# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['QueueArgs', 'Queue']

@pulumi.input_type
class QueueArgs:
    def __init__(__self__, *,
                 app_engine_http_target: Optional[pulumi.Input['AppEngineHttpTargetArgs']] = None,
                 http_target: Optional[pulumi.Input['HttpTargetArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pull_target: Optional[pulumi.Input['PullTargetArgs']] = None,
                 rate_limits: Optional[pulumi.Input['RateLimitsArgs']] = None,
                 retry_config: Optional[pulumi.Input['RetryConfigArgs']] = None,
                 task_ttl: Optional[pulumi.Input[str]] = None,
                 tombstone_ttl: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Queue resource.
        :param pulumi.Input['AppEngineHttpTargetArgs'] app_engine_http_target: App Engine HTTP target. An App Engine queue is a queue that has an AppEngineHttpTarget.
        :param pulumi.Input['HttpTargetArgs'] http_target: An http_target is used to override the target values for HTTP tasks.
        :param pulumi.Input[str] name: Caller-specified and required in CreateQueue, after which it becomes output only. The queue name. The queue name must have the following format: `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID` * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]), hyphens (-), colons (:), or periods (.). For more information, see [Identifying projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects) * `LOCATION_ID` is the canonical ID for the queue's location. The list of available locations can be obtained by calling ListLocations. For more information, see https://cloud.google.com/about/locations/. * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or hyphens (-). The maximum length is 100 characters.
        :param pulumi.Input['PullTargetArgs'] pull_target: Pull target. A pull queue is a queue that has a PullTarget.
        :param pulumi.Input['RateLimitsArgs'] rate_limits: Rate limits for task dispatches. rate_limits and retry_config are related because they both control task attempts however they control how tasks are attempted in different ways: * rate_limits controls the total rate of dispatches from a queue (i.e. all traffic dispatched from the queue, regardless of whether the dispatch is from a first attempt or a retry). * retry_config controls what happens to particular a task after its first attempt fails. That is, retry_config controls task retries (the second attempt, third attempt, etc).
        :param pulumi.Input['RetryConfigArgs'] retry_config: Settings that determine the retry behavior. * For tasks created using Cloud Tasks: the queue-level retry settings apply to all tasks in the queue that were created using Cloud Tasks. Retry settings cannot be set on individual tasks. * For tasks created using the App Engine SDK: the queue-level retry settings apply to all tasks in the queue which do not have retry settings explicitly set on the task and were created by the App Engine SDK. See [App Engine documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
        :param pulumi.Input[str] task_ttl: The maximum amount of time that a task will be retained in this queue. Queues created by Cloud Tasks have a default `task_ttl` of 31 days. After a task has lived for `task_ttl`, the task will be deleted regardless of whether it was dispatched or not. The `task_ttl` for queues created via queue.yaml/xml is equal to the maximum duration because there is a [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for these queues. To view the maximum valid duration, see the documentation for Duration.
        :param pulumi.Input[str] tombstone_ttl: The task tombstone time to live (TTL). After a task is deleted or completed, the task's tombstone is retained for the length of time specified by `tombstone_ttl`. The tombstone is used by task de-duplication; another task with the same name can't be created until the tombstone has expired. For more information about task de-duplication, see the documentation for CreateTaskRequest. Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
        """
        if app_engine_http_target is not None:
            pulumi.set(__self__, "app_engine_http_target", app_engine_http_target)
        if http_target is not None:
            pulumi.set(__self__, "http_target", http_target)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pull_target is not None:
            pulumi.set(__self__, "pull_target", pull_target)
        if rate_limits is not None:
            pulumi.set(__self__, "rate_limits", rate_limits)
        if retry_config is not None:
            pulumi.set(__self__, "retry_config", retry_config)
        if task_ttl is not None:
            pulumi.set(__self__, "task_ttl", task_ttl)
        if tombstone_ttl is not None:
            pulumi.set(__self__, "tombstone_ttl", tombstone_ttl)

    @property
    @pulumi.getter(name="appEngineHttpTarget")
    def app_engine_http_target(self) -> Optional[pulumi.Input['AppEngineHttpTargetArgs']]:
        """
        App Engine HTTP target. An App Engine queue is a queue that has an AppEngineHttpTarget.
        """
        return pulumi.get(self, "app_engine_http_target")

    @app_engine_http_target.setter
    def app_engine_http_target(self, value: Optional[pulumi.Input['AppEngineHttpTargetArgs']]):
        pulumi.set(self, "app_engine_http_target", value)

    @property
    @pulumi.getter(name="httpTarget")
    def http_target(self) -> Optional[pulumi.Input['HttpTargetArgs']]:
        """
        An http_target is used to override the target values for HTTP tasks.
        """
        return pulumi.get(self, "http_target")

    @http_target.setter
    def http_target(self, value: Optional[pulumi.Input['HttpTargetArgs']]):
        pulumi.set(self, "http_target", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Caller-specified and required in CreateQueue, after which it becomes output only. The queue name. The queue name must have the following format: `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID` * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]), hyphens (-), colons (:), or periods (.). For more information, see [Identifying projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects) * `LOCATION_ID` is the canonical ID for the queue's location. The list of available locations can be obtained by calling ListLocations. For more information, see https://cloud.google.com/about/locations/. * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or hyphens (-). The maximum length is 100 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pullTarget")
    def pull_target(self) -> Optional[pulumi.Input['PullTargetArgs']]:
        """
        Pull target. A pull queue is a queue that has a PullTarget.
        """
        return pulumi.get(self, "pull_target")

    @pull_target.setter
    def pull_target(self, value: Optional[pulumi.Input['PullTargetArgs']]):
        pulumi.set(self, "pull_target", value)

    @property
    @pulumi.getter(name="rateLimits")
    def rate_limits(self) -> Optional[pulumi.Input['RateLimitsArgs']]:
        """
        Rate limits for task dispatches. rate_limits and retry_config are related because they both control task attempts however they control how tasks are attempted in different ways: * rate_limits controls the total rate of dispatches from a queue (i.e. all traffic dispatched from the queue, regardless of whether the dispatch is from a first attempt or a retry). * retry_config controls what happens to particular a task after its first attempt fails. That is, retry_config controls task retries (the second attempt, third attempt, etc).
        """
        return pulumi.get(self, "rate_limits")

    @rate_limits.setter
    def rate_limits(self, value: Optional[pulumi.Input['RateLimitsArgs']]):
        pulumi.set(self, "rate_limits", value)

    @property
    @pulumi.getter(name="retryConfig")
    def retry_config(self) -> Optional[pulumi.Input['RetryConfigArgs']]:
        """
        Settings that determine the retry behavior. * For tasks created using Cloud Tasks: the queue-level retry settings apply to all tasks in the queue that were created using Cloud Tasks. Retry settings cannot be set on individual tasks. * For tasks created using the App Engine SDK: the queue-level retry settings apply to all tasks in the queue which do not have retry settings explicitly set on the task and were created by the App Engine SDK. See [App Engine documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
        """
        return pulumi.get(self, "retry_config")

    @retry_config.setter
    def retry_config(self, value: Optional[pulumi.Input['RetryConfigArgs']]):
        pulumi.set(self, "retry_config", value)

    @property
    @pulumi.getter(name="taskTtl")
    def task_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        The maximum amount of time that a task will be retained in this queue. Queues created by Cloud Tasks have a default `task_ttl` of 31 days. After a task has lived for `task_ttl`, the task will be deleted regardless of whether it was dispatched or not. The `task_ttl` for queues created via queue.yaml/xml is equal to the maximum duration because there is a [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for these queues. To view the maximum valid duration, see the documentation for Duration.
        """
        return pulumi.get(self, "task_ttl")

    @task_ttl.setter
    def task_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "task_ttl", value)

    @property
    @pulumi.getter(name="tombstoneTtl")
    def tombstone_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        The task tombstone time to live (TTL). After a task is deleted or completed, the task's tombstone is retained for the length of time specified by `tombstone_ttl`. The tombstone is used by task de-duplication; another task with the same name can't be created until the tombstone has expired. For more information about task de-duplication, see the documentation for CreateTaskRequest. Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
        """
        return pulumi.get(self, "tombstone_ttl")

    @tombstone_ttl.setter
    def tombstone_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tombstone_ttl", value)


class Queue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_engine_http_target: Optional[pulumi.Input[pulumi.InputType['AppEngineHttpTargetArgs']]] = None,
                 http_target: Optional[pulumi.Input[pulumi.InputType['HttpTargetArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pull_target: Optional[pulumi.Input[pulumi.InputType['PullTargetArgs']]] = None,
                 rate_limits: Optional[pulumi.Input[pulumi.InputType['RateLimitsArgs']]] = None,
                 retry_config: Optional[pulumi.Input[pulumi.InputType['RetryConfigArgs']]] = None,
                 task_ttl: Optional[pulumi.Input[str]] = None,
                 tombstone_ttl: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a queue. Queues created with this method allow tasks to live for a maximum of 31 days. After a task is 31 days old, the task will be deleted regardless of whether it was dispatched or not. WARNING: Using this method may have unintended side effects if you are using an App Engine `queue.yaml` or `queue.xml` file to manage your queues. Read [Overview of Queue Management and queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using this method.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AppEngineHttpTargetArgs']] app_engine_http_target: App Engine HTTP target. An App Engine queue is a queue that has an AppEngineHttpTarget.
        :param pulumi.Input[pulumi.InputType['HttpTargetArgs']] http_target: An http_target is used to override the target values for HTTP tasks.
        :param pulumi.Input[str] name: Caller-specified and required in CreateQueue, after which it becomes output only. The queue name. The queue name must have the following format: `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID` * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]), hyphens (-), colons (:), or periods (.). For more information, see [Identifying projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects) * `LOCATION_ID` is the canonical ID for the queue's location. The list of available locations can be obtained by calling ListLocations. For more information, see https://cloud.google.com/about/locations/. * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or hyphens (-). The maximum length is 100 characters.
        :param pulumi.Input[pulumi.InputType['PullTargetArgs']] pull_target: Pull target. A pull queue is a queue that has a PullTarget.
        :param pulumi.Input[pulumi.InputType['RateLimitsArgs']] rate_limits: Rate limits for task dispatches. rate_limits and retry_config are related because they both control task attempts however they control how tasks are attempted in different ways: * rate_limits controls the total rate of dispatches from a queue (i.e. all traffic dispatched from the queue, regardless of whether the dispatch is from a first attempt or a retry). * retry_config controls what happens to particular a task after its first attempt fails. That is, retry_config controls task retries (the second attempt, third attempt, etc).
        :param pulumi.Input[pulumi.InputType['RetryConfigArgs']] retry_config: Settings that determine the retry behavior. * For tasks created using Cloud Tasks: the queue-level retry settings apply to all tasks in the queue that were created using Cloud Tasks. Retry settings cannot be set on individual tasks. * For tasks created using the App Engine SDK: the queue-level retry settings apply to all tasks in the queue which do not have retry settings explicitly set on the task and were created by the App Engine SDK. See [App Engine documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
        :param pulumi.Input[str] task_ttl: The maximum amount of time that a task will be retained in this queue. Queues created by Cloud Tasks have a default `task_ttl` of 31 days. After a task has lived for `task_ttl`, the task will be deleted regardless of whether it was dispatched or not. The `task_ttl` for queues created via queue.yaml/xml is equal to the maximum duration because there is a [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for these queues. To view the maximum valid duration, see the documentation for Duration.
        :param pulumi.Input[str] tombstone_ttl: The task tombstone time to live (TTL). After a task is deleted or completed, the task's tombstone is retained for the length of time specified by `tombstone_ttl`. The tombstone is used by task de-duplication; another task with the same name can't be created until the tombstone has expired. For more information about task de-duplication, see the documentation for CreateTaskRequest. Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[QueueArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a queue. Queues created with this method allow tasks to live for a maximum of 31 days. After a task is 31 days old, the task will be deleted regardless of whether it was dispatched or not. WARNING: Using this method may have unintended side effects if you are using an App Engine `queue.yaml` or `queue.xml` file to manage your queues. Read [Overview of Queue Management and queue.yaml](https://cloud.google.com/tasks/docs/queue-yaml) before using this method.

        :param str resource_name: The name of the resource.
        :param QueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_engine_http_target: Optional[pulumi.Input[pulumi.InputType['AppEngineHttpTargetArgs']]] = None,
                 http_target: Optional[pulumi.Input[pulumi.InputType['HttpTargetArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pull_target: Optional[pulumi.Input[pulumi.InputType['PullTargetArgs']]] = None,
                 rate_limits: Optional[pulumi.Input[pulumi.InputType['RateLimitsArgs']]] = None,
                 retry_config: Optional[pulumi.Input[pulumi.InputType['RetryConfigArgs']]] = None,
                 task_ttl: Optional[pulumi.Input[str]] = None,
                 tombstone_ttl: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueueArgs.__new__(QueueArgs)

            __props__.__dict__["app_engine_http_target"] = app_engine_http_target
            __props__.__dict__["http_target"] = http_target
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["pull_target"] = pull_target
            __props__.__dict__["rate_limits"] = rate_limits
            __props__.__dict__["retry_config"] = retry_config
            __props__.__dict__["task_ttl"] = task_ttl
            __props__.__dict__["tombstone_ttl"] = tombstone_ttl
            __props__.__dict__["purge_time"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["stats"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Queue, __self__).__init__(
            'google-native:cloudtasks/v2beta2:Queue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Queue':
        """
        Get an existing Queue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = QueueArgs.__new__(QueueArgs)

        __props__.__dict__["app_engine_http_target"] = None
        __props__.__dict__["http_target"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["pull_target"] = None
        __props__.__dict__["purge_time"] = None
        __props__.__dict__["rate_limits"] = None
        __props__.__dict__["retry_config"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["stats"] = None
        __props__.__dict__["task_ttl"] = None
        __props__.__dict__["tombstone_ttl"] = None
        return Queue(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appEngineHttpTarget")
    def app_engine_http_target(self) -> pulumi.Output['outputs.AppEngineHttpTargetResponse']:
        """
        App Engine HTTP target. An App Engine queue is a queue that has an AppEngineHttpTarget.
        """
        return pulumi.get(self, "app_engine_http_target")

    @property
    @pulumi.getter(name="httpTarget")
    def http_target(self) -> pulumi.Output['outputs.HttpTargetResponse']:
        """
        An http_target is used to override the target values for HTTP tasks.
        """
        return pulumi.get(self, "http_target")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Caller-specified and required in CreateQueue, after which it becomes output only. The queue name. The queue name must have the following format: `projects/PROJECT_ID/locations/LOCATION_ID/queues/QUEUE_ID` * `PROJECT_ID` can contain letters ([A-Za-z]), numbers ([0-9]), hyphens (-), colons (:), or periods (.). For more information, see [Identifying projects](https://cloud.google.com/resource-manager/docs/creating-managing-projects#identifying_projects) * `LOCATION_ID` is the canonical ID for the queue's location. The list of available locations can be obtained by calling ListLocations. For more information, see https://cloud.google.com/about/locations/. * `QUEUE_ID` can contain letters ([A-Za-z]), numbers ([0-9]), or hyphens (-). The maximum length is 100 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="pullTarget")
    def pull_target(self) -> pulumi.Output['outputs.PullTargetResponse']:
        """
        Pull target. A pull queue is a queue that has a PullTarget.
        """
        return pulumi.get(self, "pull_target")

    @property
    @pulumi.getter(name="purgeTime")
    def purge_time(self) -> pulumi.Output[str]:
        """
        The last time this queue was purged. All tasks that were created before this time were purged. A queue can be purged using PurgeQueue, the [App Engine Task Queue SDK, or the Cloud Console](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/deleting-tasks-and-queues#purging_all_tasks_from_a_queue). Purge time will be truncated to the nearest microsecond. Purge time will be unset if the queue has never been purged.
        """
        return pulumi.get(self, "purge_time")

    @property
    @pulumi.getter(name="rateLimits")
    def rate_limits(self) -> pulumi.Output['outputs.RateLimitsResponse']:
        """
        Rate limits for task dispatches. rate_limits and retry_config are related because they both control task attempts however they control how tasks are attempted in different ways: * rate_limits controls the total rate of dispatches from a queue (i.e. all traffic dispatched from the queue, regardless of whether the dispatch is from a first attempt or a retry). * retry_config controls what happens to particular a task after its first attempt fails. That is, retry_config controls task retries (the second attempt, third attempt, etc).
        """
        return pulumi.get(self, "rate_limits")

    @property
    @pulumi.getter(name="retryConfig")
    def retry_config(self) -> pulumi.Output['outputs.RetryConfigResponse']:
        """
        Settings that determine the retry behavior. * For tasks created using Cloud Tasks: the queue-level retry settings apply to all tasks in the queue that were created using Cloud Tasks. Retry settings cannot be set on individual tasks. * For tasks created using the App Engine SDK: the queue-level retry settings apply to all tasks in the queue which do not have retry settings explicitly set on the task and were created by the App Engine SDK. See [App Engine documentation](https://cloud.google.com/appengine/docs/standard/python/taskqueue/push/retrying-tasks).
        """
        return pulumi.get(self, "retry_config")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the queue. `state` can only be changed by called PauseQueue, ResumeQueue, or uploading [queue.yaml/xml](https://cloud.google.com/appengine/docs/python/config/queueref). UpdateQueue cannot be used to change `state`.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def stats(self) -> pulumi.Output['outputs.QueueStatsResponse']:
        """
        The realtime, informational statistics for a queue. In order to receive the statistics the caller should include this field in the FieldMask.
        """
        return pulumi.get(self, "stats")

    @property
    @pulumi.getter(name="taskTtl")
    def task_ttl(self) -> pulumi.Output[str]:
        """
        The maximum amount of time that a task will be retained in this queue. Queues created by Cloud Tasks have a default `task_ttl` of 31 days. After a task has lived for `task_ttl`, the task will be deleted regardless of whether it was dispatched or not. The `task_ttl` for queues created via queue.yaml/xml is equal to the maximum duration because there is a [storage quota](https://cloud.google.com/appengine/quotas#Task_Queue) for these queues. To view the maximum valid duration, see the documentation for Duration.
        """
        return pulumi.get(self, "task_ttl")

    @property
    @pulumi.getter(name="tombstoneTtl")
    def tombstone_ttl(self) -> pulumi.Output[str]:
        """
        The task tombstone time to live (TTL). After a task is deleted or completed, the task's tombstone is retained for the length of time specified by `tombstone_ttl`. The tombstone is used by task de-duplication; another task with the same name can't be created until the tombstone has expired. For more information about task de-duplication, see the documentation for CreateTaskRequest. Queues created by Cloud Tasks have a default `tombstone_ttl` of 1 hour.
        """
        return pulumi.get(self, "tombstone_ttl")

