# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AndroidAttributesResponse',
    'CertificateAttributesResponse',
    'CertificateTemplateResponse',
    'DynamicGroupMetadataResponse',
    'DynamicGroupQueryResponse',
    'DynamicGroupStatusResponse',
    'EndpointVerificationSpecificAttributesResponse',
    'EntityKeyResponse',
    'ExpiryDetailResponse',
    'MembershipRoleResponse',
    'MembershipRoleRestrictionEvaluationResponse',
    'PosixGroupResponse',
    'RestrictionEvaluationsResponse',
]

@pulumi.output_type
class AndroidAttributesResponse(dict):
    """
    Resource representing the Android specific attributes of a Device.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledUnknownSources":
            suggest = "enabled_unknown_sources"
        elif key == "ownerProfileAccount":
            suggest = "owner_profile_account"
        elif key == "ownershipPrivilege":
            suggest = "ownership_privilege"
        elif key == "supportsWorkProfile":
            suggest = "supports_work_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AndroidAttributesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AndroidAttributesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AndroidAttributesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_unknown_sources: bool,
                 owner_profile_account: bool,
                 ownership_privilege: str,
                 supports_work_profile: bool):
        """
        Resource representing the Android specific attributes of a Device.
        :param bool enabled_unknown_sources: Whether applications from unknown sources can be installed on device.
        :param bool owner_profile_account: Whether this account is on an owner/primary profile. For phones, only true for owner profiles. Android 4+ devices can have secondary or restricted user profiles.
        :param str ownership_privilege: Ownership privileges on device.
        :param bool supports_work_profile: Whether device supports Android work profiles. If false, this service will not block access to corp data even if an administrator turns on the "Enforce Work Profile" policy.
        """
        pulumi.set(__self__, "enabled_unknown_sources", enabled_unknown_sources)
        pulumi.set(__self__, "owner_profile_account", owner_profile_account)
        pulumi.set(__self__, "ownership_privilege", ownership_privilege)
        pulumi.set(__self__, "supports_work_profile", supports_work_profile)

    @property
    @pulumi.getter(name="enabledUnknownSources")
    def enabled_unknown_sources(self) -> bool:
        """
        Whether applications from unknown sources can be installed on device.
        """
        return pulumi.get(self, "enabled_unknown_sources")

    @property
    @pulumi.getter(name="ownerProfileAccount")
    def owner_profile_account(self) -> bool:
        """
        Whether this account is on an owner/primary profile. For phones, only true for owner profiles. Android 4+ devices can have secondary or restricted user profiles.
        """
        return pulumi.get(self, "owner_profile_account")

    @property
    @pulumi.getter(name="ownershipPrivilege")
    def ownership_privilege(self) -> str:
        """
        Ownership privileges on device.
        """
        return pulumi.get(self, "ownership_privilege")

    @property
    @pulumi.getter(name="supportsWorkProfile")
    def supports_work_profile(self) -> bool:
        """
        Whether device supports Android work profiles. If false, this service will not block access to corp data even if an administrator turns on the "Enforce Work Profile" policy.
        """
        return pulumi.get(self, "supports_work_profile")


@pulumi.output_type
class CertificateAttributesResponse(dict):
    """
    Stores information about a certificate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateTemplate":
            suggest = "certificate_template"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "validationState":
            suggest = "validation_state"
        elif key == "validityExpirationTime":
            suggest = "validity_expiration_time"
        elif key == "validityStartTime":
            suggest = "validity_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateAttributesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateAttributesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateAttributesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_template: 'outputs.CertificateTemplateResponse',
                 fingerprint: str,
                 issuer: str,
                 serial_number: str,
                 subject: str,
                 thumbprint: str,
                 validation_state: str,
                 validity_expiration_time: str,
                 validity_start_time: str):
        """
        Stores information about a certificate.
        :param 'CertificateTemplateResponse' certificate_template: The X.509 extension for CertificateTemplate.
        :param str fingerprint: The encoded certificate fingerprint.
        :param str issuer: The name of the issuer of this certificate.
        :param str serial_number: Serial number of the certificate, Example: "123456789".
        :param str subject: The subject name of this certificate.
        :param str thumbprint: The certificate thumbprint.
        :param str validation_state: Validation state of this certificate.
        :param str validity_expiration_time: Certificate not valid at or after this timestamp.
        :param str validity_start_time: Certificate not valid before this timestamp.
        """
        pulumi.set(__self__, "certificate_template", certificate_template)
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "serial_number", serial_number)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "thumbprint", thumbprint)
        pulumi.set(__self__, "validation_state", validation_state)
        pulumi.set(__self__, "validity_expiration_time", validity_expiration_time)
        pulumi.set(__self__, "validity_start_time", validity_start_time)

    @property
    @pulumi.getter(name="certificateTemplate")
    def certificate_template(self) -> 'outputs.CertificateTemplateResponse':
        """
        The X.509 extension for CertificateTemplate.
        """
        return pulumi.get(self, "certificate_template")

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        """
        The encoded certificate fingerprint.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        The name of the issuer of this certificate.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> str:
        """
        Serial number of the certificate, Example: "123456789".
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        The subject name of this certificate.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def thumbprint(self) -> str:
        """
        The certificate thumbprint.
        """
        return pulumi.get(self, "thumbprint")

    @property
    @pulumi.getter(name="validationState")
    def validation_state(self) -> str:
        """
        Validation state of this certificate.
        """
        return pulumi.get(self, "validation_state")

    @property
    @pulumi.getter(name="validityExpirationTime")
    def validity_expiration_time(self) -> str:
        """
        Certificate not valid at or after this timestamp.
        """
        return pulumi.get(self, "validity_expiration_time")

    @property
    @pulumi.getter(name="validityStartTime")
    def validity_start_time(self) -> str:
        """
        Certificate not valid before this timestamp.
        """
        return pulumi.get(self, "validity_start_time")


@pulumi.output_type
class CertificateTemplateResponse(dict):
    """
    CertificateTemplate (v3 Extension in X.509).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "majorVersion":
            suggest = "major_version"
        elif key == "minorVersion":
            suggest = "minor_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CertificateTemplateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CertificateTemplateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CertificateTemplateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 major_version: int,
                 minor_version: int):
        """
        CertificateTemplate (v3 Extension in X.509).
        :param int major_version: The Major version of the template. Example: 100.
        :param int minor_version: The minor version of the template. Example: 12.
        """
        pulumi.set(__self__, "major_version", major_version)
        pulumi.set(__self__, "minor_version", minor_version)

    @property
    @pulumi.getter(name="majorVersion")
    def major_version(self) -> int:
        """
        The Major version of the template. Example: 100.
        """
        return pulumi.get(self, "major_version")

    @property
    @pulumi.getter(name="minorVersion")
    def minor_version(self) -> int:
        """
        The minor version of the template. Example: 12.
        """
        return pulumi.get(self, "minor_version")


@pulumi.output_type
class DynamicGroupMetadataResponse(dict):
    """
    Dynamic group metadata like queries and status.
    """
    def __init__(__self__, *,
                 queries: Sequence['outputs.DynamicGroupQueryResponse'],
                 status: 'outputs.DynamicGroupStatusResponse'):
        """
        Dynamic group metadata like queries and status.
        :param Sequence['DynamicGroupQueryResponse'] queries: Memberships will be the union of all queries. Only one entry with USER resource is currently supported. Customers can create up to 100 dynamic groups.
        :param 'DynamicGroupStatusResponse' status: Status of the dynamic group.
        """
        pulumi.set(__self__, "queries", queries)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def queries(self) -> Sequence['outputs.DynamicGroupQueryResponse']:
        """
        Memberships will be the union of all queries. Only one entry with USER resource is currently supported. Customers can create up to 100 dynamic groups.
        """
        return pulumi.get(self, "queries")

    @property
    @pulumi.getter
    def status(self) -> 'outputs.DynamicGroupStatusResponse':
        """
        Status of the dynamic group.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class DynamicGroupQueryResponse(dict):
    """
    Defines a query on a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceType":
            suggest = "resource_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DynamicGroupQueryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DynamicGroupQueryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DynamicGroupQueryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query: str,
                 resource_type: str):
        """
        Defines a query on a resource.
        :param str query: Query that determines the memberships of the dynamic group. Examples: All users with at least one `organizations.department` of engineering. `user.organizations.exists(org, org.department=='engineering')` All users with at least one location that has `area` of `foo` and `building_id` of `bar`. `user.locations.exists(loc, loc.area=='foo' && loc.building_id=='bar')` All users with any variation of the name John Doe (case-insensitive queries add `equalsIgnoreCase()` to the value being queried). `user.name.value.equalsIgnoreCase('jOhn DoE')`
        """
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "resource_type", resource_type)

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        Query that determines the memberships of the dynamic group. Examples: All users with at least one `organizations.department` of engineering. `user.organizations.exists(org, org.department=='engineering')` All users with at least one location that has `area` of `foo` and `building_id` of `bar`. `user.locations.exists(loc, loc.area=='foo' && loc.building_id=='bar')` All users with any variation of the name John Doe (case-insensitive queries add `equalsIgnoreCase()` to the value being queried). `user.name.value.equalsIgnoreCase('jOhn DoE')`
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        return pulumi.get(self, "resource_type")


@pulumi.output_type
class DynamicGroupStatusResponse(dict):
    """
    The current status of a dynamic group along with timestamp.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "statusTime":
            suggest = "status_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DynamicGroupStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DynamicGroupStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DynamicGroupStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 status: str,
                 status_time: str):
        """
        The current status of a dynamic group along with timestamp.
        :param str status: Status of the dynamic group.
        :param str status_time: The latest time at which the dynamic group is guaranteed to be in the given status. If status is `UP_TO_DATE`, the latest time at which the dynamic group was confirmed to be up-to-date. If status is `UPDATING_MEMBERSHIPS`, the time at which dynamic group was created.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "status_time", status_time)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the dynamic group.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusTime")
    def status_time(self) -> str:
        """
        The latest time at which the dynamic group is guaranteed to be in the given status. If status is `UP_TO_DATE`, the latest time at which the dynamic group was confirmed to be up-to-date. If status is `UPDATING_MEMBERSHIPS`, the time at which dynamic group was created.
        """
        return pulumi.get(self, "status_time")


@pulumi.output_type
class EndpointVerificationSpecificAttributesResponse(dict):
    """
    Resource representing the Endpoint Verification-specific attributes of a Device. https://cloud.google.com/endpoint-verification/docs/overview
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateAttributes":
            suggest = "certificate_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointVerificationSpecificAttributesResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointVerificationSpecificAttributesResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointVerificationSpecificAttributesResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_attributes: Sequence['outputs.CertificateAttributesResponse']):
        """
        Resource representing the Endpoint Verification-specific attributes of a Device. https://cloud.google.com/endpoint-verification/docs/overview
        :param Sequence['CertificateAttributesResponse'] certificate_attributes: Details of certificates.
        """
        pulumi.set(__self__, "certificate_attributes", certificate_attributes)

    @property
    @pulumi.getter(name="certificateAttributes")
    def certificate_attributes(self) -> Sequence['outputs.CertificateAttributesResponse']:
        """
        Details of certificates.
        """
        return pulumi.get(self, "certificate_attributes")


@pulumi.output_type
class EntityKeyResponse(dict):
    """
    A unique identifier for an entity in the Cloud Identity Groups API. An entity can represent either a group with an optional `namespace` or a user without a `namespace`. The combination of `id` and `namespace` must be unique; however, the same `id` can be used with different `namespace`s.
    """
    def __init__(__self__, *,
                 namespace: str):
        """
        A unique identifier for an entity in the Cloud Identity Groups API. An entity can represent either a group with an optional `namespace` or a user without a `namespace`. The combination of `id` and `namespace` must be unique; however, the same `id` can be used with different `namespace`s.
        :param str namespace: The namespace in which the entity exists. If not specified, the `EntityKey` represents a Google-managed entity such as a Google user or a Google Group. If specified, the `EntityKey` represents an external-identity-mapped group. The namespace must correspond to an identity source created in Admin Console and must be in the form of `identitysources/{identity_source_id}`.
        """
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace in which the entity exists. If not specified, the `EntityKey` represents a Google-managed entity such as a Google user or a Google Group. If specified, the `EntityKey` represents an external-identity-mapped group. The namespace must correspond to an identity source created in Admin Console and must be in the form of `identitysources/{identity_source_id}`.
        """
        return pulumi.get(self, "namespace")


@pulumi.output_type
class ExpiryDetailResponse(dict):
    """
    The `MembershipRole` expiry details.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expireTime":
            suggest = "expire_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExpiryDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExpiryDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExpiryDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expire_time: str):
        """
        The `MembershipRole` expiry details.
        :param str expire_time: The time at which the `MembershipRole` will expire.
        """
        pulumi.set(__self__, "expire_time", expire_time)

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        The time at which the `MembershipRole` will expire.
        """
        return pulumi.get(self, "expire_time")


@pulumi.output_type
class MembershipRoleResponse(dict):
    """
    A membership role within the Cloud Identity Groups API. A `MembershipRole` defines the privileges granted to a `Membership`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiryDetail":
            suggest = "expiry_detail"
        elif key == "restrictionEvaluations":
            suggest = "restriction_evaluations"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MembershipRoleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MembershipRoleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MembershipRoleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiry_detail: 'outputs.ExpiryDetailResponse',
                 name: str,
                 restriction_evaluations: 'outputs.RestrictionEvaluationsResponse'):
        """
        A membership role within the Cloud Identity Groups API. A `MembershipRole` defines the privileges granted to a `Membership`.
        :param 'ExpiryDetailResponse' expiry_detail: The expiry details of the `MembershipRole`. Expiry details are only supported for `MEMBER` `MembershipRoles`. May be set if `name` is `MEMBER`. Must not be set if `name` is any other value.
        :param str name: The name of the `MembershipRole`. Must be one of `OWNER`, `MANAGER`, `MEMBER`.
        :param 'RestrictionEvaluationsResponse' restriction_evaluations: Evaluations of restrictions applied to parent group on this membership.
        """
        pulumi.set(__self__, "expiry_detail", expiry_detail)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "restriction_evaluations", restriction_evaluations)

    @property
    @pulumi.getter(name="expiryDetail")
    def expiry_detail(self) -> 'outputs.ExpiryDetailResponse':
        """
        The expiry details of the `MembershipRole`. Expiry details are only supported for `MEMBER` `MembershipRoles`. May be set if `name` is `MEMBER`. Must not be set if `name` is any other value.
        """
        return pulumi.get(self, "expiry_detail")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the `MembershipRole`. Must be one of `OWNER`, `MANAGER`, `MEMBER`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="restrictionEvaluations")
    def restriction_evaluations(self) -> 'outputs.RestrictionEvaluationsResponse':
        """
        Evaluations of restrictions applied to parent group on this membership.
        """
        return pulumi.get(self, "restriction_evaluations")


@pulumi.output_type
class MembershipRoleRestrictionEvaluationResponse(dict):
    """
    The evaluated state of this restriction.
    """
    def __init__(__self__, *,
                 state: str):
        """
        The evaluated state of this restriction.
        :param str state: The current state of the restriction
        """
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the restriction
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class PosixGroupResponse(dict):
    """
    POSIX Group definition to represent a group in a POSIX compliant system.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemId":
            suggest = "system_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PosixGroupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PosixGroupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PosixGroupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gid: str,
                 name: str,
                 system_id: str):
        """
        POSIX Group definition to represent a group in a POSIX compliant system.
        :param str gid: GID of the POSIX group.
        :param str name: Name of the POSIX group.
        :param str system_id: System identifier for which group name and gid apply to. If not specified it will default to empty value.
        """
        pulumi.set(__self__, "gid", gid)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "system_id", system_id)

    @property
    @pulumi.getter
    def gid(self) -> str:
        """
        GID of the POSIX group.
        """
        return pulumi.get(self, "gid")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the POSIX group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="systemId")
    def system_id(self) -> str:
        """
        System identifier for which group name and gid apply to. If not specified it will default to empty value.
        """
        return pulumi.get(self, "system_id")


@pulumi.output_type
class RestrictionEvaluationsResponse(dict):
    """
    Evaluations of restrictions applied to parent group on this membership.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memberRestrictionEvaluation":
            suggest = "member_restriction_evaluation"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestrictionEvaluationsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestrictionEvaluationsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestrictionEvaluationsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 member_restriction_evaluation: 'outputs.MembershipRoleRestrictionEvaluationResponse'):
        """
        Evaluations of restrictions applied to parent group on this membership.
        :param 'MembershipRoleRestrictionEvaluationResponse' member_restriction_evaluation: Evaluation of the member restriction applied to this membership. Empty if the user lacks permission to view the restriction evaluation.
        """
        pulumi.set(__self__, "member_restriction_evaluation", member_restriction_evaluation)

    @property
    @pulumi.getter(name="memberRestrictionEvaluation")
    def member_restriction_evaluation(self) -> 'outputs.MembershipRoleRestrictionEvaluationResponse':
        """
        Evaluation of the member restriction applied to this membership. Empty if the user lacks permission to view the restriction evaluation.
        """
        return pulumi.get(self, "member_restriction_evaluation")


