# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AllocatedConnectionResponse',
    'ApplicationEndpointResponse',
    'ConfigResponse',
    'DestinationRouteResponse',
    'EgressResponse',
    'GatewayResponse',
    'GoogleCloudBeyondcorpAppconnectionsV1alphaAppConnectionApplicationEndpointResponse',
    'GoogleCloudBeyondcorpAppconnectionsV1alphaAppConnectionGatewayResponse',
    'GoogleCloudBeyondcorpAppconnectorsV1alphaAppConnectorPrincipalInfoResponse',
    'GoogleCloudBeyondcorpAppconnectorsV1alphaAppConnectorPrincipalInfoServiceAccountResponse',
    'GoogleCloudBeyondcorpAppconnectorsV1alphaResourceInfoResponse',
    'GoogleIamV1AuditConfigResponse',
    'GoogleIamV1AuditLogConfigResponse',
    'GoogleIamV1BindingResponse',
    'GoogleTypeExprResponse',
    'IngressResponse',
    'PeeredVpcResponse',
    'PrincipalInfoResponse',
    'ResourceInfoResponse',
    'ServiceAccountResponse',
]

@pulumi.output_type
class AllocatedConnectionResponse(dict):
    """
    Allocated connection of the AppGateway.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingressPort":
            suggest = "ingress_port"
        elif key == "pscUri":
            suggest = "psc_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AllocatedConnectionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AllocatedConnectionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AllocatedConnectionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ingress_port: int,
                 psc_uri: str):
        """
        Allocated connection of the AppGateway.
        :param int ingress_port: The ingress port of an allocated connection
        :param str psc_uri: The PSC uri of an allocated connection
        """
        pulumi.set(__self__, "ingress_port", ingress_port)
        pulumi.set(__self__, "psc_uri", psc_uri)

    @property
    @pulumi.getter(name="ingressPort")
    def ingress_port(self) -> int:
        """
        The ingress port of an allocated connection
        """
        return pulumi.get(self, "ingress_port")

    @property
    @pulumi.getter(name="pscUri")
    def psc_uri(self) -> str:
        """
        The PSC uri of an allocated connection
        """
        return pulumi.get(self, "psc_uri")


@pulumi.output_type
class ApplicationEndpointResponse(dict):
    """
    ApplicationEndpoint represents a remote application endpoint.
    """
    def __init__(__self__, *,
                 host: str,
                 port: int):
        """
        ApplicationEndpoint represents a remote application endpoint.
        :param str host: Hostname or IP address of the remote application endpoint.
        :param int port: Port of the remote application endpoint.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Hostname or IP address of the remote application endpoint.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port of the remote application endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class ConfigResponse(dict):
    """
    The basic ingress config for ClientGateways.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationRoutes":
            suggest = "destination_routes"
        elif key == "transportProtocol":
            suggest = "transport_protocol"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination_routes: Sequence['outputs.DestinationRouteResponse'],
                 transport_protocol: str):
        """
        The basic ingress config for ClientGateways.
        :param Sequence['DestinationRouteResponse'] destination_routes: The settings used to configure basic ClientGateways.
        :param str transport_protocol: Immutable. The transport protocol used between the client and the server.
        """
        pulumi.set(__self__, "destination_routes", destination_routes)
        pulumi.set(__self__, "transport_protocol", transport_protocol)

    @property
    @pulumi.getter(name="destinationRoutes")
    def destination_routes(self) -> Sequence['outputs.DestinationRouteResponse']:
        """
        The settings used to configure basic ClientGateways.
        """
        return pulumi.get(self, "destination_routes")

    @property
    @pulumi.getter(name="transportProtocol")
    def transport_protocol(self) -> str:
        """
        Immutable. The transport protocol used between the client and the server.
        """
        return pulumi.get(self, "transport_protocol")


@pulumi.output_type
class DestinationRouteResponse(dict):
    """
    The setting used to configure ClientGateways. It is adding routes to the client's routing table after the connection is established.
    """
    def __init__(__self__, *,
                 address: str,
                 netmask: str):
        """
        The setting used to configure ClientGateways. It is adding routes to the client's routing table after the connection is established.
        :param str address: The network address of the subnet for which the packet is routed to the ClientGateway.
        :param str netmask: The network mask of the subnet for which the packet is routed to the ClientGateway.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "netmask", netmask)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        The network address of the subnet for which the packet is routed to the ClientGateway.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def netmask(self) -> str:
        """
        The network mask of the subnet for which the packet is routed to the ClientGateway.
        """
        return pulumi.get(self, "netmask")


@pulumi.output_type
class EgressResponse(dict):
    """
    The details of the egress info. One of the following options should be set.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "peeredVpc":
            suggest = "peered_vpc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EgressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EgressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EgressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 peered_vpc: 'outputs.PeeredVpcResponse'):
        """
        The details of the egress info. One of the following options should be set.
        :param 'PeeredVpcResponse' peered_vpc: A VPC from the consumer project.
        """
        pulumi.set(__self__, "peered_vpc", peered_vpc)

    @property
    @pulumi.getter(name="peeredVpc")
    def peered_vpc(self) -> 'outputs.PeeredVpcResponse':
        """
        A VPC from the consumer project.
        """
        return pulumi.get(self, "peered_vpc")


@pulumi.output_type
class GatewayResponse(dict):
    """
    Gateway represents a user facing component that serves as an entrance to enable connectivity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userPort":
            suggest = "user_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 uri: str,
                 user_port: int):
        """
        Gateway represents a user facing component that serves as an entrance to enable connectivity.
        :param str type: The type of hosting used by the gateway.
        :param str uri: Server-defined URI for this resource.
        :param int user_port: User port reserved on the gateways for this connection, if not specified or zero, the default port is 19443.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uri", uri)
        pulumi.set(__self__, "user_port", user_port)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of hosting used by the gateway.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Server-defined URI for this resource.
        """
        return pulumi.get(self, "uri")

    @property
    @pulumi.getter(name="userPort")
    def user_port(self) -> int:
        """
        User port reserved on the gateways for this connection, if not specified or zero, the default port is 19443.
        """
        return pulumi.get(self, "user_port")


@pulumi.output_type
class GoogleCloudBeyondcorpAppconnectionsV1alphaAppConnectionApplicationEndpointResponse(dict):
    """
    ApplicationEndpoint represents a remote application endpoint.
    """
    def __init__(__self__, *,
                 host: str,
                 port: int):
        """
        ApplicationEndpoint represents a remote application endpoint.
        :param str host: Hostname or IP address of the remote application endpoint.
        :param int port: Port of the remote application endpoint.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Hostname or IP address of the remote application endpoint.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        Port of the remote application endpoint.
        """
        return pulumi.get(self, "port")


@pulumi.output_type
class GoogleCloudBeyondcorpAppconnectionsV1alphaAppConnectionGatewayResponse(dict):
    """
    Gateway represents a user facing component that serves as an entrance to enable connectivity.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appGateway":
            suggest = "app_gateway"
        elif key == "ingressPort":
            suggest = "ingress_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudBeyondcorpAppconnectionsV1alphaAppConnectionGatewayResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudBeyondcorpAppconnectionsV1alphaAppConnectionGatewayResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudBeyondcorpAppconnectionsV1alphaAppConnectionGatewayResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_gateway: str,
                 ingress_port: int,
                 l7psc: str,
                 type: str,
                 uri: str):
        """
        Gateway represents a user facing component that serves as an entrance to enable connectivity.
        :param str app_gateway: AppGateway name in following format: `projects/{project_id}/locations/{location_id}/appgateways/{gateway_id}`
        :param int ingress_port: Ingress port reserved on the gateways for this AppConnection, if not specified or zero, the default port is 19443.
        :param str l7psc: L7 private service connection for this resource.
        :param str type: The type of hosting used by the gateway.
        :param str uri: Server-defined URI for this resource.
        """
        pulumi.set(__self__, "app_gateway", app_gateway)
        pulumi.set(__self__, "ingress_port", ingress_port)
        pulumi.set(__self__, "l7psc", l7psc)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter(name="appGateway")
    def app_gateway(self) -> str:
        """
        AppGateway name in following format: `projects/{project_id}/locations/{location_id}/appgateways/{gateway_id}`
        """
        return pulumi.get(self, "app_gateway")

    @property
    @pulumi.getter(name="ingressPort")
    def ingress_port(self) -> int:
        """
        Ingress port reserved on the gateways for this AppConnection, if not specified or zero, the default port is 19443.
        """
        return pulumi.get(self, "ingress_port")

    @property
    @pulumi.getter
    def l7psc(self) -> str:
        """
        L7 private service connection for this resource.
        """
        return pulumi.get(self, "l7psc")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of hosting used by the gateway.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        Server-defined URI for this resource.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class GoogleCloudBeyondcorpAppconnectorsV1alphaAppConnectorPrincipalInfoResponse(dict):
    """
    PrincipalInfo represents an Identity oneof.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudBeyondcorpAppconnectorsV1alphaAppConnectorPrincipalInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudBeyondcorpAppconnectorsV1alphaAppConnectorPrincipalInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudBeyondcorpAppconnectorsV1alphaAppConnectorPrincipalInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_account: 'outputs.GoogleCloudBeyondcorpAppconnectorsV1alphaAppConnectorPrincipalInfoServiceAccountResponse'):
        """
        PrincipalInfo represents an Identity oneof.
        :param 'GoogleCloudBeyondcorpAppconnectorsV1alphaAppConnectorPrincipalInfoServiceAccountResponse' service_account: A GCP service account.
        """
        pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> 'outputs.GoogleCloudBeyondcorpAppconnectorsV1alphaAppConnectorPrincipalInfoServiceAccountResponse':
        """
        A GCP service account.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class GoogleCloudBeyondcorpAppconnectorsV1alphaAppConnectorPrincipalInfoServiceAccountResponse(dict):
    """
    ServiceAccount represents a GCP service account.
    """
    def __init__(__self__, *,
                 email: str):
        """
        ServiceAccount represents a GCP service account.
        :param str email: Email address of the service account.
        """
        pulumi.set(__self__, "email", email)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        Email address of the service account.
        """
        return pulumi.get(self, "email")


@pulumi.output_type
class GoogleCloudBeyondcorpAppconnectorsV1alphaResourceInfoResponse(dict):
    """
    ResourceInfo represents the information/status of an app connector resource. Such as: - remote_agent - container - runtime - appgateway - appconnector - appconnection - tunnel - logagent
    """
    def __init__(__self__, *,
                 resource: Mapping[str, str],
                 status: str,
                 sub: Sequence['outputs.GoogleCloudBeyondcorpAppconnectorsV1alphaResourceInfoResponse'],
                 time: str):
        """
        ResourceInfo represents the information/status of an app connector resource. Such as: - remote_agent - container - runtime - appgateway - appconnector - appconnection - tunnel - logagent
        :param Mapping[str, str] resource: Specific details for the resource. This is for internal use only.
        :param str status: Overall health status. Overall status is derived based on the status of each sub level resources.
        :param Sequence['GoogleCloudBeyondcorpAppconnectorsV1alphaResourceInfoResponse'] sub: List of Info for the sub level resources.
        :param str time: The timestamp to collect the info. It is suggested to be set by the topmost level resource only.
        """
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "sub", sub)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def resource(self) -> Mapping[str, str]:
        """
        Specific details for the resource. This is for internal use only.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Overall health status. Overall status is derived based on the status of each sub level resources.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def sub(self) -> Sequence['outputs.GoogleCloudBeyondcorpAppconnectorsV1alphaResourceInfoResponse']:
        """
        List of Info for the sub level resources.
        """
        return pulumi.get(self, "sub")

    @property
    @pulumi.getter
    def time(self) -> str:
        """
        The timestamp to collect the info. It is suggested to be set by the topmost level resource only.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class GoogleIamV1AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.GoogleIamV1AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['GoogleIamV1AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.GoogleIamV1AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GoogleIamV1AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class GoogleIamV1BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.GoogleTypeExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'GoogleTypeExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.GoogleTypeExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GoogleTypeExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class IngressResponse(dict):
    """
    Settings of how to connect to the ClientGateway. One of the following options should be set.
    """
    def __init__(__self__, *,
                 config: 'outputs.ConfigResponse'):
        """
        Settings of how to connect to the ClientGateway. One of the following options should be set.
        :param 'ConfigResponse' config: The basic ingress config for ClientGateways.
        """
        pulumi.set(__self__, "config", config)

    @property
    @pulumi.getter
    def config(self) -> 'outputs.ConfigResponse':
        """
        The basic ingress config for ClientGateways.
        """
        return pulumi.get(self, "config")


@pulumi.output_type
class PeeredVpcResponse(dict):
    """
    The peered VPC owned by the consumer project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkVpc":
            suggest = "network_vpc"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PeeredVpcResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PeeredVpcResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PeeredVpcResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_vpc: str):
        """
        The peered VPC owned by the consumer project.
        :param str network_vpc: The name of the peered VPC owned by the consumer project.
        """
        pulumi.set(__self__, "network_vpc", network_vpc)

    @property
    @pulumi.getter(name="networkVpc")
    def network_vpc(self) -> str:
        """
        The name of the peered VPC owned by the consumer project.
        """
        return pulumi.get(self, "network_vpc")


@pulumi.output_type
class PrincipalInfoResponse(dict):
    """
    PrincipalInfo represents an Identity oneof.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serviceAccount":
            suggest = "service_account"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrincipalInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrincipalInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrincipalInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 service_account: 'outputs.ServiceAccountResponse'):
        """
        PrincipalInfo represents an Identity oneof.
        :param 'ServiceAccountResponse' service_account: A GCP service account.
        """
        pulumi.set(__self__, "service_account", service_account)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> 'outputs.ServiceAccountResponse':
        """
        A GCP service account.
        """
        return pulumi.get(self, "service_account")


@pulumi.output_type
class ResourceInfoResponse(dict):
    """
    ResourceInfo represents the information/status of the associated resource.
    """
    def __init__(__self__, *,
                 resource: Mapping[str, str],
                 status: str,
                 sub: Sequence['outputs.ResourceInfoResponse'],
                 time: str):
        """
        ResourceInfo represents the information/status of the associated resource.
        :param Mapping[str, str] resource: Specific details for the resource.
        :param str status: Overall health status. Overall status is derived based on the status of each sub level resources.
        :param Sequence['ResourceInfoResponse'] sub: List of Info for the sub level resources.
        :param str time: The timestamp to collect the info. It is suggested to be set by the topmost level resource only.
        """
        pulumi.set(__self__, "resource", resource)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "sub", sub)
        pulumi.set(__self__, "time", time)

    @property
    @pulumi.getter
    def resource(self) -> Mapping[str, str]:
        """
        Specific details for the resource.
        """
        return pulumi.get(self, "resource")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Overall health status. Overall status is derived based on the status of each sub level resources.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def sub(self) -> Sequence['outputs.ResourceInfoResponse']:
        """
        List of Info for the sub level resources.
        """
        return pulumi.get(self, "sub")

    @property
    @pulumi.getter
    def time(self) -> str:
        """
        The timestamp to collect the info. It is suggested to be set by the topmost level resource only.
        """
        return pulumi.get(self, "time")


@pulumi.output_type
class ServiceAccountResponse(dict):
    """
    ServiceAccount represents a GCP service account.
    """
    def __init__(__self__, *,
                 email: str):
        """
        ServiceAccount represents a GCP service account.
        :param str email: Email address of the service account.
        """
        pulumi.set(__self__, "email", email)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        Email address of the service account.
        """
        return pulumi.get(self, "email")


