# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetAppConnectorResult',
    'AwaitableGetAppConnectorResult',
    'get_app_connector',
    'get_app_connector_output',
]

@pulumi.output_type
class GetAppConnectorResult:
    def __init__(__self__, create_time=None, display_name=None, labels=None, name=None, principal_info=None, resource_info=None, state=None, uid=None, update_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if principal_info and not isinstance(principal_info, dict):
            raise TypeError("Expected argument 'principal_info' to be a dict")
        pulumi.set(__self__, "principal_info", principal_info)
        if resource_info and not isinstance(resource_info, dict):
            raise TypeError("Expected argument 'resource_info' to be a dict")
        pulumi.set(__self__, "resource_info", resource_info)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Timestamp when the resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Optional. An arbitrary user-provided name for the AppConnector. Cannot exceed 64 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. Resource labels to represent user provided metadata.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique resource name of the AppConnector. The name is ignored when creating a AppConnector.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="principalInfo")
    def principal_info(self) -> 'outputs.GoogleCloudBeyondcorpAppconnectorsV1alphaAppConnectorPrincipalInfoResponse':
        """
        Principal information about the Identity of the AppConnector.
        """
        return pulumi.get(self, "principal_info")

    @property
    @pulumi.getter(name="resourceInfo")
    def resource_info(self) -> 'outputs.GoogleCloudBeyondcorpAppconnectorsV1alphaResourceInfoResponse':
        """
        Optional. Resource info of the connector.
        """
        return pulumi.get(self, "resource_info")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the AppConnector.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        A unique identifier for the instance generated by the system.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Timestamp when the resource was last modified.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetAppConnectorResult(GetAppConnectorResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAppConnectorResult(
            create_time=self.create_time,
            display_name=self.display_name,
            labels=self.labels,
            name=self.name,
            principal_info=self.principal_info,
            resource_info=self.resource_info,
            state=self.state,
            uid=self.uid,
            update_time=self.update_time)


def get_app_connector(app_connector_id: Optional[str] = None,
                      location: Optional[str] = None,
                      project: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAppConnectorResult:
    """
    Gets details of a single AppConnector.
    """
    __args__ = dict()
    __args__['appConnectorId'] = app_connector_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:beyondcorp/v1alpha:getAppConnector', __args__, opts=opts, typ=GetAppConnectorResult).value

    return AwaitableGetAppConnectorResult(
        create_time=__ret__.create_time,
        display_name=__ret__.display_name,
        labels=__ret__.labels,
        name=__ret__.name,
        principal_info=__ret__.principal_info,
        resource_info=__ret__.resource_info,
        state=__ret__.state,
        uid=__ret__.uid,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_app_connector)
def get_app_connector_output(app_connector_id: Optional[pulumi.Input[str]] = None,
                             location: Optional[pulumi.Input[str]] = None,
                             project: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAppConnectorResult]:
    """
    Gets details of a single AppConnector.
    """
    ...
