# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'GoogleCloudApigeeV1AddonsConfigArgs',
    'GoogleCloudApigeeV1AdvancedApiOpsConfigArgs',
    'GoogleCloudApigeeV1ApiSecurityConfigArgs',
    'GoogleCloudApigeeV1AttributeArgs',
    'GoogleCloudApigeeV1CanaryEvaluationMetricLabelsArgs',
    'GoogleCloudApigeeV1ConnectorsPlatformConfigArgs',
    'GoogleCloudApigeeV1CustomReportMetricArgs',
    'GoogleCloudApigeeV1DatastoreConfigArgs',
    'GoogleCloudApigeeV1DateRangeArgs',
    'GoogleCloudApigeeV1GraphQLOperationConfigArgs',
    'GoogleCloudApigeeV1GraphQLOperationGroupArgs',
    'GoogleCloudApigeeV1GraphQLOperationArgs',
    'GoogleCloudApigeeV1IntegrationConfigArgs',
    'GoogleCloudApigeeV1MonetizationConfigArgs',
    'GoogleCloudApigeeV1OperationConfigArgs',
    'GoogleCloudApigeeV1OperationGroupArgs',
    'GoogleCloudApigeeV1OperationArgs',
    'GoogleCloudApigeeV1PropertiesArgs',
    'GoogleCloudApigeeV1PropertyArgs',
    'GoogleCloudApigeeV1QueryMetricArgs',
    'GoogleCloudApigeeV1QuotaArgs',
    'GoogleCloudApigeeV1RateRangeArgs',
    'GoogleCloudApigeeV1ReportPropertyArgs',
    'GoogleCloudApigeeV1RevenueShareRangeArgs',
    'GoogleCloudApigeeV1SecurityReportQueryMetricArgs',
    'GoogleCloudApigeeV1TlsInfoCommonNameArgs',
    'GoogleCloudApigeeV1TlsInfoArgs',
    'GoogleCloudApigeeV1TraceSamplingConfigArgs',
    'GoogleIamV1AuditConfigArgs',
    'GoogleIamV1AuditLogConfigArgs',
    'GoogleIamV1BindingArgs',
    'GoogleTypeExprArgs',
    'GoogleTypeMoneyArgs',
]

@pulumi.input_type
class GoogleCloudApigeeV1AddonsConfigArgs:
    def __init__(__self__, *,
                 advanced_api_ops_config: Optional[pulumi.Input['GoogleCloudApigeeV1AdvancedApiOpsConfigArgs']] = None,
                 api_security_config: Optional[pulumi.Input['GoogleCloudApigeeV1ApiSecurityConfigArgs']] = None,
                 connectors_platform_config: Optional[pulumi.Input['GoogleCloudApigeeV1ConnectorsPlatformConfigArgs']] = None,
                 integration_config: Optional[pulumi.Input['GoogleCloudApigeeV1IntegrationConfigArgs']] = None,
                 monetization_config: Optional[pulumi.Input['GoogleCloudApigeeV1MonetizationConfigArgs']] = None):
        """
        Add-on configurations for the Apigee organization.
        :param pulumi.Input['GoogleCloudApigeeV1AdvancedApiOpsConfigArgs'] advanced_api_ops_config: Configuration for the Advanced API Ops add-on.
        :param pulumi.Input['GoogleCloudApigeeV1ApiSecurityConfigArgs'] api_security_config: Configuration for the API Security add-on.
        :param pulumi.Input['GoogleCloudApigeeV1ConnectorsPlatformConfigArgs'] connectors_platform_config: Configuration for the Connectors Platform add-on.
        :param pulumi.Input['GoogleCloudApigeeV1IntegrationConfigArgs'] integration_config: Configuration for the Integration add-on.
        :param pulumi.Input['GoogleCloudApigeeV1MonetizationConfigArgs'] monetization_config: Configuration for the Monetization add-on.
        """
        if advanced_api_ops_config is not None:
            pulumi.set(__self__, "advanced_api_ops_config", advanced_api_ops_config)
        if api_security_config is not None:
            pulumi.set(__self__, "api_security_config", api_security_config)
        if connectors_platform_config is not None:
            pulumi.set(__self__, "connectors_platform_config", connectors_platform_config)
        if integration_config is not None:
            pulumi.set(__self__, "integration_config", integration_config)
        if monetization_config is not None:
            pulumi.set(__self__, "monetization_config", monetization_config)

    @property
    @pulumi.getter(name="advancedApiOpsConfig")
    def advanced_api_ops_config(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1AdvancedApiOpsConfigArgs']]:
        """
        Configuration for the Advanced API Ops add-on.
        """
        return pulumi.get(self, "advanced_api_ops_config")

    @advanced_api_ops_config.setter
    def advanced_api_ops_config(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1AdvancedApiOpsConfigArgs']]):
        pulumi.set(self, "advanced_api_ops_config", value)

    @property
    @pulumi.getter(name="apiSecurityConfig")
    def api_security_config(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1ApiSecurityConfigArgs']]:
        """
        Configuration for the API Security add-on.
        """
        return pulumi.get(self, "api_security_config")

    @api_security_config.setter
    def api_security_config(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1ApiSecurityConfigArgs']]):
        pulumi.set(self, "api_security_config", value)

    @property
    @pulumi.getter(name="connectorsPlatformConfig")
    def connectors_platform_config(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1ConnectorsPlatformConfigArgs']]:
        """
        Configuration for the Connectors Platform add-on.
        """
        return pulumi.get(self, "connectors_platform_config")

    @connectors_platform_config.setter
    def connectors_platform_config(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1ConnectorsPlatformConfigArgs']]):
        pulumi.set(self, "connectors_platform_config", value)

    @property
    @pulumi.getter(name="integrationConfig")
    def integration_config(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1IntegrationConfigArgs']]:
        """
        Configuration for the Integration add-on.
        """
        return pulumi.get(self, "integration_config")

    @integration_config.setter
    def integration_config(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1IntegrationConfigArgs']]):
        pulumi.set(self, "integration_config", value)

    @property
    @pulumi.getter(name="monetizationConfig")
    def monetization_config(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1MonetizationConfigArgs']]:
        """
        Configuration for the Monetization add-on.
        """
        return pulumi.get(self, "monetization_config")

    @monetization_config.setter
    def monetization_config(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1MonetizationConfigArgs']]):
        pulumi.set(self, "monetization_config", value)


@pulumi.input_type
class GoogleCloudApigeeV1AdvancedApiOpsConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for the Advanced API Ops add-on.
        :param pulumi.Input[bool] enabled: Flag that specifies whether the Advanced API Ops add-on is enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that specifies whether the Advanced API Ops add-on is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class GoogleCloudApigeeV1ApiSecurityConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configurations of the API Security add-on.
        :param pulumi.Input[bool] enabled: Flag that specifies whether the API security add-on is enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that specifies whether the API security add-on is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class GoogleCloudApigeeV1AttributeArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Key-value pair to store extra metadata.
        :param pulumi.Input[str] name: API key of the attribute.
        :param pulumi.Input[str] value: Value of the attribute.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        API key of the attribute.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the attribute.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudApigeeV1CanaryEvaluationMetricLabelsArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 location: pulumi.Input[str],
                 env: Optional[pulumi.Input[str]] = None):
        """
        Labels that can be used to filter Apigee metrics.
        :param pulumi.Input[str] instance_id: The instance ID associated with the metrics. In Apigee Hybrid, the value is configured during installation.
        :param pulumi.Input[str] location: The location associated with the metrics.
        :param pulumi.Input[str] env: The environment ID associated with the metrics.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "location", location)
        if env is not None:
            pulumi.set(__self__, "env", env)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The instance ID associated with the metrics. In Apigee Hybrid, the value is configured during installation.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[str]:
        """
        The location associated with the metrics.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[str]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[str]]:
        """
        The environment ID associated with the metrics.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "env", value)


@pulumi.input_type
class GoogleCloudApigeeV1ConnectorsPlatformConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for the Connectors Platform add-on.
        :param pulumi.Input[bool] enabled: Flag that specifies whether the Connectors Platform add-on is enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that specifies whether the Connectors Platform add-on is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class GoogleCloudApigeeV1CustomReportMetricArgs:
    def __init__(__self__, *,
                 function: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        This encapsulates a metric property of the form sum(message_count) where name is message_count and function is sum
        :param pulumi.Input[str] function: aggregate function
        :param pulumi.Input[str] name: name of the metric
        """
        if function is not None:
            pulumi.set(__self__, "function", function)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[str]]:
        """
        aggregate function
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        name of the metric
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class GoogleCloudApigeeV1DatastoreConfigArgs:
    def __init__(__self__, *,
                 project: pulumi.Input[str],
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 dataset_name: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 table_prefix: Optional[pulumi.Input[str]] = None):
        """
        Configuration detail for datastore
        :param pulumi.Input[str] project: GCP project in which the datastore exists
        :param pulumi.Input[str] bucket_name: Name of the Cloud Storage bucket. Required for `gcs` target_type.
        :param pulumi.Input[str] dataset_name: BigQuery dataset name Required for `bigquery` target_type.
        :param pulumi.Input[str] path: Path of Cloud Storage bucket Required for `gcs` target_type.
        :param pulumi.Input[str] table_prefix: Prefix of BigQuery table Required for `bigquery` target_type.
        """
        pulumi.set(__self__, "project", project)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if dataset_name is not None:
            pulumi.set(__self__, "dataset_name", dataset_name)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if table_prefix is not None:
            pulumi.set(__self__, "table_prefix", table_prefix)

    @property
    @pulumi.getter
    def project(self) -> pulumi.Input[str]:
        """
        GCP project in which the datastore exists
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: pulumi.Input[str]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the Cloud Storage bucket. Required for `gcs` target_type.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="datasetName")
    def dataset_name(self) -> Optional[pulumi.Input[str]]:
        """
        BigQuery dataset name Required for `bigquery` target_type.
        """
        return pulumi.get(self, "dataset_name")

    @dataset_name.setter
    def dataset_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataset_name", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path of Cloud Storage bucket Required for `gcs` target_type.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="tablePrefix")
    def table_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Prefix of BigQuery table Required for `bigquery` target_type.
        """
        return pulumi.get(self, "table_prefix")

    @table_prefix.setter
    def table_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "table_prefix", value)


@pulumi.input_type
class GoogleCloudApigeeV1DateRangeArgs:
    def __init__(__self__, *,
                 end: pulumi.Input[str],
                 start: pulumi.Input[str]):
        """
        Date range of the data to export.
        :param pulumi.Input[str] end: End date (exclusive) of the data to export in the format `yyyy-mm-dd`. The date range ends at 00:00:00 UTC on the end date- which will not be in the output.
        :param pulumi.Input[str] start: Start date of the data to export in the format `yyyy-mm-dd`. The date range begins at 00:00:00 UTC on the start date.
        """
        pulumi.set(__self__, "end", end)
        pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> pulumi.Input[str]:
        """
        End date (exclusive) of the data to export in the format `yyyy-mm-dd`. The date range ends at 00:00:00 UTC on the end date- which will not be in the output.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: pulumi.Input[str]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def start(self) -> pulumi.Input[str]:
        """
        Start date of the data to export in the format `yyyy-mm-dd`. The date range begins at 00:00:00 UTC on the start date.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: pulumi.Input[str]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class GoogleCloudApigeeV1GraphQLOperationConfigArgs:
    def __init__(__self__, *,
                 api_source: pulumi.Input[str],
                 operations: pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationArgs']]],
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]] = None,
                 quota: Optional[pulumi.Input['GoogleCloudApigeeV1QuotaArgs']] = None):
        """
        Binds the resources in a proxy or remote service with the GraphQL operation and its associated quota enforcement.
        :param pulumi.Input[str] api_source: Name of the API proxy endpoint or remote service with which the GraphQL operation and quota are associated.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationArgs']]] operations: List of GraphQL name/operation type pairs for the proxy or remote service to which quota will be applied. If only operation types are specified, the quota will be applied to all GraphQL requests irrespective of the GraphQL name. **Note**: Currently, you can specify only a single GraphQLOperation. Specifying more than one will cause the operation to fail.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]] attributes: Custom attributes associated with the operation.
        :param pulumi.Input['GoogleCloudApigeeV1QuotaArgs'] quota: Quota parameters to be enforced for the resources, methods, and API source combination. If none are specified, quota enforcement will not be done.
        """
        pulumi.set(__self__, "api_source", api_source)
        pulumi.set(__self__, "operations", operations)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)

    @property
    @pulumi.getter(name="apiSource")
    def api_source(self) -> pulumi.Input[str]:
        """
        Name of the API proxy endpoint or remote service with which the GraphQL operation and quota are associated.
        """
        return pulumi.get(self, "api_source")

    @api_source.setter
    def api_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_source", value)

    @property
    @pulumi.getter
    def operations(self) -> pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationArgs']]]:
        """
        List of GraphQL name/operation type pairs for the proxy or remote service to which quota will be applied. If only operation types are specified, the quota will be applied to all GraphQL requests irrespective of the GraphQL name. **Note**: Currently, you can specify only a single GraphQLOperation. Specifying more than one will cause the operation to fail.
        """
        return pulumi.get(self, "operations")

    @operations.setter
    def operations(self, value: pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationArgs']]]):
        pulumi.set(self, "operations", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]:
        """
        Custom attributes associated with the operation.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1QuotaArgs']]:
        """
        Quota parameters to be enforced for the resources, methods, and API source combination. If none are specified, quota enforcement will not be done.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1QuotaArgs']]):
        pulumi.set(self, "quota", value)


@pulumi.input_type
class GoogleCloudApigeeV1GraphQLOperationGroupArgs:
    def __init__(__self__, *,
                 operation_configs: pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationConfigArgs']]],
                 operation_config_type: Optional[pulumi.Input[str]] = None):
        """
        List of graphQL operation configuration details associated with Apigee API proxies or remote services. Remote services are non-Apigee proxies, such as Istio-Envoy.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationConfigArgs']]] operation_configs: List of operation configurations for either Apigee API proxies or other remote services that are associated with this API product.
        :param pulumi.Input[str] operation_config_type: Flag that specifies whether the configuration is for Apigee API proxy or a remote service. Valid values include `proxy` or `remoteservice`. Defaults to `proxy`. Set to `proxy` when Apigee API proxies are associated with the API product. Set to `remoteservice` when non-Apigee proxies like Istio-Envoy are associated with the API product.
        """
        pulumi.set(__self__, "operation_configs", operation_configs)
        if operation_config_type is not None:
            pulumi.set(__self__, "operation_config_type", operation_config_type)

    @property
    @pulumi.getter(name="operationConfigs")
    def operation_configs(self) -> pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationConfigArgs']]]:
        """
        List of operation configurations for either Apigee API proxies or other remote services that are associated with this API product.
        """
        return pulumi.get(self, "operation_configs")

    @operation_configs.setter
    def operation_configs(self, value: pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1GraphQLOperationConfigArgs']]]):
        pulumi.set(self, "operation_configs", value)

    @property
    @pulumi.getter(name="operationConfigType")
    def operation_config_type(self) -> Optional[pulumi.Input[str]]:
        """
        Flag that specifies whether the configuration is for Apigee API proxy or a remote service. Valid values include `proxy` or `remoteservice`. Defaults to `proxy`. Set to `proxy` when Apigee API proxies are associated with the API product. Set to `remoteservice` when non-Apigee proxies like Istio-Envoy are associated with the API product.
        """
        return pulumi.get(self, "operation_config_type")

    @operation_config_type.setter
    def operation_config_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation_config_type", value)


@pulumi.input_type
class GoogleCloudApigeeV1GraphQLOperationArgs:
    def __init__(__self__, *,
                 operation_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 operation: Optional[pulumi.Input[str]] = None):
        """
        Represents the pairing of GraphQL operation types and the GraphQL operation name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] operation_types: GraphQL operation types. Valid values include `query` or `mutation`. **Note**: Apigee does not currently support `subscription` types.
        :param pulumi.Input[str] operation: GraphQL operation name. The name and operation type will be used to apply quotas. If no name is specified, the quota will be applied to all GraphQL operations irrespective of their operation names in the payload.
        """
        pulumi.set(__self__, "operation_types", operation_types)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)

    @property
    @pulumi.getter(name="operationTypes")
    def operation_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        GraphQL operation types. Valid values include `query` or `mutation`. **Note**: Apigee does not currently support `subscription` types.
        """
        return pulumi.get(self, "operation_types")

    @operation_types.setter
    def operation_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "operation_types", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        """
        GraphQL operation name. The name and operation type will be used to apply quotas. If no name is specified, the quota will be applied to all GraphQL operations irrespective of their operation names in the payload.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)


@pulumi.input_type
class GoogleCloudApigeeV1IntegrationConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for the Integration add-on.
        :param pulumi.Input[bool] enabled: Flag that specifies whether the Integration add-on is enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that specifies whether the Integration add-on is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class GoogleCloudApigeeV1MonetizationConfigArgs:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for the Monetization add-on.
        :param pulumi.Input[bool] enabled: Flag that specifies whether the Monetization add-on is enabled.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag that specifies whether the Monetization add-on is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)


@pulumi.input_type
class GoogleCloudApigeeV1OperationConfigArgs:
    def __init__(__self__, *,
                 api_source: pulumi.Input[str],
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationArgs']]]] = None,
                 quota: Optional[pulumi.Input['GoogleCloudApigeeV1QuotaArgs']] = None):
        """
        Binds the resources in an API proxy or remote service with the allowed REST methods and associated quota enforcement.
        :param pulumi.Input[str] api_source: Name of the API proxy or remote service with which the resources, methods, and quota are associated.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]] attributes: Custom attributes associated with the operation.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationArgs']]] operations: List of resource/method pairs for the API proxy or remote service to which quota will applied. **Note**: Currently, you can specify only a single resource/method pair. The call will fail if more than one resource/method pair is provided.
        :param pulumi.Input['GoogleCloudApigeeV1QuotaArgs'] quota: Quota parameters to be enforced for the resources, methods, and API source combination. If none are specified, quota enforcement will not be done.
        """
        pulumi.set(__self__, "api_source", api_source)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if quota is not None:
            pulumi.set(__self__, "quota", quota)

    @property
    @pulumi.getter(name="apiSource")
    def api_source(self) -> pulumi.Input[str]:
        """
        Name of the API proxy or remote service with which the resources, methods, and quota are associated.
        """
        return pulumi.get(self, "api_source")

    @api_source.setter
    def api_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "api_source", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]:
        """
        Custom attributes associated with the operation.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationArgs']]]]:
        """
        List of resource/method pairs for the API proxy or remote service to which quota will applied. **Note**: Currently, you can specify only a single resource/method pair. The call will fail if more than one resource/method pair is provided.
        """
        return pulumi.get(self, "operations")

    @operations.setter
    def operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationArgs']]]]):
        pulumi.set(self, "operations", value)

    @property
    @pulumi.getter
    def quota(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1QuotaArgs']]:
        """
        Quota parameters to be enforced for the resources, methods, and API source combination. If none are specified, quota enforcement will not be done.
        """
        return pulumi.get(self, "quota")

    @quota.setter
    def quota(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1QuotaArgs']]):
        pulumi.set(self, "quota", value)


@pulumi.input_type
class GoogleCloudApigeeV1OperationGroupArgs:
    def __init__(__self__, *,
                 operation_configs: pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationConfigArgs']]],
                 operation_config_type: Optional[pulumi.Input[str]] = None):
        """
        List of operation configuration details associated with Apigee API proxies or remote services. Remote services are non-Apigee proxies, such as Istio-Envoy.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationConfigArgs']]] operation_configs: List of operation configurations for either Apigee API proxies or other remote services that are associated with this API product.
        :param pulumi.Input[str] operation_config_type: Flag that specifes whether the configuration is for Apigee API proxy or a remote service. Valid values include `proxy` or `remoteservice`. Defaults to `proxy`. Set to `proxy` when Apigee API proxies are associated with the API product. Set to `remoteservice` when non-Apigee proxies like Istio-Envoy are associated with the API product.
        """
        pulumi.set(__self__, "operation_configs", operation_configs)
        if operation_config_type is not None:
            pulumi.set(__self__, "operation_config_type", operation_config_type)

    @property
    @pulumi.getter(name="operationConfigs")
    def operation_configs(self) -> pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationConfigArgs']]]:
        """
        List of operation configurations for either Apigee API proxies or other remote services that are associated with this API product.
        """
        return pulumi.get(self, "operation_configs")

    @operation_configs.setter
    def operation_configs(self, value: pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1OperationConfigArgs']]]):
        pulumi.set(self, "operation_configs", value)

    @property
    @pulumi.getter(name="operationConfigType")
    def operation_config_type(self) -> Optional[pulumi.Input[str]]:
        """
        Flag that specifes whether the configuration is for Apigee API proxy or a remote service. Valid values include `proxy` or `remoteservice`. Defaults to `proxy`. Set to `proxy` when Apigee API proxies are associated with the API product. Set to `remoteservice` when non-Apigee proxies like Istio-Envoy are associated with the API product.
        """
        return pulumi.get(self, "operation_config_type")

    @operation_config_type.setter
    def operation_config_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation_config_type", value)


@pulumi.input_type
class GoogleCloudApigeeV1OperationArgs:
    def __init__(__self__, *,
                 resource: pulumi.Input[str],
                 methods: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Represents the pairing of REST resource path and the actions (verbs) allowed on the resource path.
        :param pulumi.Input[str] resource: REST resource path associated with the API proxy or remote service.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] methods: methods refers to the REST verbs as in https://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html. When none specified, all verb types are allowed.
        """
        pulumi.set(__self__, "resource", resource)
        if methods is not None:
            pulumi.set(__self__, "methods", methods)

    @property
    @pulumi.getter
    def resource(self) -> pulumi.Input[str]:
        """
        REST resource path associated with the API proxy or remote service.
        """
        return pulumi.get(self, "resource")

    @resource.setter
    def resource(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource", value)

    @property
    @pulumi.getter
    def methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        methods refers to the REST verbs as in https://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html. When none specified, all verb types are allowed.
        """
        return pulumi.get(self, "methods")

    @methods.setter
    def methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "methods", value)


@pulumi.input_type
class GoogleCloudApigeeV1PropertiesArgs:
    def __init__(__self__, *,
                 property: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1PropertyArgs']]]] = None):
        """
        Message for compatibility with legacy Edge specification for Java Properties object in JSON.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1PropertyArgs']]] property: List of all properties in the object
        """
        if property is not None:
            pulumi.set(__self__, "property", property)

    @property
    @pulumi.getter
    def property(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1PropertyArgs']]]]:
        """
        List of all properties in the object
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1PropertyArgs']]]]):
        pulumi.set(self, "property", value)


@pulumi.input_type
class GoogleCloudApigeeV1PropertyArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        A single property entry in the Properties message.
        :param pulumi.Input[str] name: The property key
        :param pulumi.Input[str] value: The property value
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The property key
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The property value
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudApigeeV1QueryMetricArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 alias: Optional[pulumi.Input[str]] = None,
                 function: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        More info about Metric: https://docs.apigee.com/api-platform/analytics/analytics-reference#metrics
        :param pulumi.Input[str] name: Metric name.
        :param pulumi.Input[str] alias: Alias for the metric. Alias will be used to replace metric name in query results.
        :param pulumi.Input[str] function: Aggregation function: avg, min, max, or sum.
        :param pulumi.Input[str] operator: One of `+`, `-`, `/`, `%`, `*`.
        :param pulumi.Input[str] value: Operand value should be provided when operator is set.
        """
        pulumi.set(__self__, "name", name)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if function is not None:
            pulumi.set(__self__, "function", function)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Metric name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        Alias for the metric. Alias will be used to replace metric name in query results.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def function(self) -> Optional[pulumi.Input[str]]:
        """
        Aggregation function: avg, min, max, or sum.
        """
        return pulumi.get(self, "function")

    @function.setter
    def function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "function", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[str]]:
        """
        One of `+`, `-`, `/`, `%`, `*`.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Operand value should be provided when operator is set.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudApigeeV1QuotaArgs:
    def __init__(__self__, *,
                 interval: pulumi.Input[str],
                 limit: pulumi.Input[str],
                 time_unit: Optional[pulumi.Input[str]] = None):
        """
        Quota contains the essential parameters needed that can be applied on the resources, methods, API source combination associated with this API product. While Quota is optional, setting it prevents requests from exceeding the provisioned parameters.
        :param pulumi.Input[str] interval: Time interval over which the number of request messages is calculated.
        :param pulumi.Input[str] limit: Upper limit allowed for the time interval and time unit specified. Requests exceeding this limit will be rejected.
        :param pulumi.Input[str] time_unit: Time unit defined for the `interval`. Valid values include `minute`, `hour`, `day`, or `month`. If `limit` and `interval` are valid, the default value is `hour`; otherwise, the default is null.
        """
        pulumi.set(__self__, "interval", interval)
        pulumi.set(__self__, "limit", limit)
        if time_unit is not None:
            pulumi.set(__self__, "time_unit", time_unit)

    @property
    @pulumi.getter
    def interval(self) -> pulumi.Input[str]:
        """
        Time interval over which the number of request messages is calculated.
        """
        return pulumi.get(self, "interval")

    @interval.setter
    def interval(self, value: pulumi.Input[str]):
        pulumi.set(self, "interval", value)

    @property
    @pulumi.getter
    def limit(self) -> pulumi.Input[str]:
        """
        Upper limit allowed for the time interval and time unit specified. Requests exceeding this limit will be rejected.
        """
        return pulumi.get(self, "limit")

    @limit.setter
    def limit(self, value: pulumi.Input[str]):
        pulumi.set(self, "limit", value)

    @property
    @pulumi.getter(name="timeUnit")
    def time_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Time unit defined for the `interval`. Valid values include `minute`, `hour`, `day`, or `month`. If `limit` and `interval` are valid, the default value is `hour`; otherwise, the default is null.
        """
        return pulumi.get(self, "time_unit")

    @time_unit.setter
    def time_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_unit", value)


@pulumi.input_type
class GoogleCloudApigeeV1RateRangeArgs:
    def __init__(__self__, *,
                 end: Optional[pulumi.Input[str]] = None,
                 fee: Optional[pulumi.Input['GoogleTypeMoneyArgs']] = None,
                 start: Optional[pulumi.Input[str]] = None):
        """
        API call volume range and the fees charged when the total number of API calls is within the range.
        :param pulumi.Input[str] end: Ending value of the range. Set to 0 or `null` for the last range of values.
        :param pulumi.Input['GoogleTypeMoneyArgs'] fee: Fee to charge when total number of API calls falls within this range.
        :param pulumi.Input[str] start: Starting value of the range. Set to 0 or `null` for the initial range of values.
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if fee is not None:
            pulumi.set(__self__, "fee", fee)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        Ending value of the range. Set to 0 or `null` for the last range of values.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter
    def fee(self) -> Optional[pulumi.Input['GoogleTypeMoneyArgs']]:
        """
        Fee to charge when total number of API calls falls within this range.
        """
        return pulumi.get(self, "fee")

    @fee.setter
    def fee(self, value: Optional[pulumi.Input['GoogleTypeMoneyArgs']]):
        pulumi.set(self, "fee", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        Starting value of the range. Set to 0 or `null` for the initial range of values.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class GoogleCloudApigeeV1ReportPropertyArgs:
    def __init__(__self__, *,
                 property: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]] = None):
        """
        :param pulumi.Input[str] property: name of the property
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]] value: property values
        """
        if property is not None:
            pulumi.set(__self__, "property", property)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]:
        """
        property values
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudApigeeV1AttributeArgs']]]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter
    def property(self) -> Optional[pulumi.Input[str]]:
        """
        name of the property
        """
        return pulumi.get(self, "property")

    @property.setter
    def property(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "property", value)


@pulumi.input_type
class GoogleCloudApigeeV1RevenueShareRangeArgs:
    def __init__(__self__, *,
                 end: Optional[pulumi.Input[str]] = None,
                 share_percentage: Optional[pulumi.Input[float]] = None,
                 start: Optional[pulumi.Input[str]] = None):
        """
        API call volume range and the percentage of revenue to share with the developer when the total number of API calls is within the range.
        :param pulumi.Input[str] end: Ending value of the range. Set to 0 or `null` for the last range of values.
        :param pulumi.Input[float] share_percentage: Percentage of the revenue to be shared with the developer. For example, to share 21 percent of the total revenue with the developer, set this value to 21. Specify a decimal number with a maximum of two digits following the decimal point.
        :param pulumi.Input[str] start: Starting value of the range. Set to 0 or `null` for the initial range of values.
        """
        if end is not None:
            pulumi.set(__self__, "end", end)
        if share_percentage is not None:
            pulumi.set(__self__, "share_percentage", share_percentage)
        if start is not None:
            pulumi.set(__self__, "start", start)

    @property
    @pulumi.getter
    def end(self) -> Optional[pulumi.Input[str]]:
        """
        Ending value of the range. Set to 0 or `null` for the last range of values.
        """
        return pulumi.get(self, "end")

    @end.setter
    def end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end", value)

    @property
    @pulumi.getter(name="sharePercentage")
    def share_percentage(self) -> Optional[pulumi.Input[float]]:
        """
        Percentage of the revenue to be shared with the developer. For example, to share 21 percent of the total revenue with the developer, set this value to 21. Specify a decimal number with a maximum of two digits following the decimal point.
        """
        return pulumi.get(self, "share_percentage")

    @share_percentage.setter
    def share_percentage(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "share_percentage", value)

    @property
    @pulumi.getter
    def start(self) -> Optional[pulumi.Input[str]]:
        """
        Starting value of the range. Set to 0 or `null` for the initial range of values.
        """
        return pulumi.get(self, "start")

    @start.setter
    def start(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start", value)


@pulumi.input_type
class GoogleCloudApigeeV1SecurityReportQueryMetricArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 aggregation_function: Optional[pulumi.Input[str]] = None,
                 alias: Optional[pulumi.Input[str]] = None,
                 operator: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Metric of the Query
        :param pulumi.Input[str] name: Metric name.
        :param pulumi.Input[str] aggregation_function: Aggregation function: avg, min, max, or sum.
        :param pulumi.Input[str] alias: Alias for the metric. Alias will be used to replace metric name in query results.
        :param pulumi.Input[str] operator: One of `+`, `-`, `/`, `%`, `*`.
        :param pulumi.Input[str] value: Operand value should be provided when operator is set.
        """
        pulumi.set(__self__, "name", name)
        if aggregation_function is not None:
            pulumi.set(__self__, "aggregation_function", aggregation_function)
        if alias is not None:
            pulumi.set(__self__, "alias", alias)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Metric name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="aggregationFunction")
    def aggregation_function(self) -> Optional[pulumi.Input[str]]:
        """
        Aggregation function: avg, min, max, or sum.
        """
        return pulumi.get(self, "aggregation_function")

    @aggregation_function.setter
    def aggregation_function(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "aggregation_function", value)

    @property
    @pulumi.getter
    def alias(self) -> Optional[pulumi.Input[str]]:
        """
        Alias for the metric. Alias will be used to replace metric name in query results.
        """
        return pulumi.get(self, "alias")

    @alias.setter
    def alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias", value)

    @property
    @pulumi.getter
    def operator(self) -> Optional[pulumi.Input[str]]:
        """
        One of `+`, `-`, `/`, `%`, `*`.
        """
        return pulumi.get(self, "operator")

    @operator.setter
    def operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Operand value should be provided when operator is set.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class GoogleCloudApigeeV1TlsInfoCommonNameArgs:
    def __init__(__self__, *,
                 value: Optional[pulumi.Input[str]] = None,
                 wildcard_match: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] value: The TLS Common Name string of the certificate.
        :param pulumi.Input[bool] wildcard_match: Indicates whether the cert should be matched against as a wildcard cert.
        """
        if value is not None:
            pulumi.set(__self__, "value", value)
        if wildcard_match is not None:
            pulumi.set(__self__, "wildcard_match", wildcard_match)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        The TLS Common Name string of the certificate.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)

    @property
    @pulumi.getter(name="wildcardMatch")
    def wildcard_match(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the cert should be matched against as a wildcard cert.
        """
        return pulumi.get(self, "wildcard_match")

    @wildcard_match.setter
    def wildcard_match(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "wildcard_match", value)


@pulumi.input_type
class GoogleCloudApigeeV1TlsInfoArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[bool],
                 ciphers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 client_auth_enabled: Optional[pulumi.Input[bool]] = None,
                 common_name: Optional[pulumi.Input['GoogleCloudApigeeV1TlsInfoCommonNameArgs']] = None,
                 ignore_validation_errors: Optional[pulumi.Input[bool]] = None,
                 key_alias: Optional[pulumi.Input[str]] = None,
                 key_store: Optional[pulumi.Input[str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 trust_store: Optional[pulumi.Input[str]] = None):
        """
        TLS configuration information for virtual hosts and TargetServers.
        :param pulumi.Input[bool] enabled: Enables TLS. If false, neither one-way nor two-way TLS will be enabled.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ciphers: The SSL/TLS cipher suites to be used. For programmable proxies, it must be one of the cipher suite names listed in: http://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html#ciphersuites. For configurable proxies, it must follow the configuration specified in: https://commondatastorage.googleapis.com/chromium-boringssl-docs/ssl.h.html#Cipher-suite-configuration. This setting has no effect for configurable proxies when negotiating TLS 1.3.
        :param pulumi.Input[bool] client_auth_enabled: Optional. Enables two-way TLS.
        :param pulumi.Input['GoogleCloudApigeeV1TlsInfoCommonNameArgs'] common_name: The TLS Common Name of the certificate.
        :param pulumi.Input[bool] ignore_validation_errors: If true, Edge ignores TLS certificate errors. Valid when configuring TLS for target servers and target endpoints, and when configuring virtual hosts that use 2-way TLS. When used with a target endpoint/target server, if the backend system uses SNI and returns a cert with a subject Distinguished Name (DN) that does not match the hostname, there is no way to ignore the error and the connection fails.
        :param pulumi.Input[str] key_alias: Required if `client_auth_enabled` is true. The resource ID for the alias containing the private key and cert.
        :param pulumi.Input[str] key_store: Required if `client_auth_enabled` is true. The resource ID of the keystore.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] protocols: The TLS versioins to be used.
        :param pulumi.Input[str] trust_store: The resource ID of the truststore.
        """
        pulumi.set(__self__, "enabled", enabled)
        if ciphers is not None:
            pulumi.set(__self__, "ciphers", ciphers)
        if client_auth_enabled is not None:
            pulumi.set(__self__, "client_auth_enabled", client_auth_enabled)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if ignore_validation_errors is not None:
            pulumi.set(__self__, "ignore_validation_errors", ignore_validation_errors)
        if key_alias is not None:
            pulumi.set(__self__, "key_alias", key_alias)
        if key_store is not None:
            pulumi.set(__self__, "key_store", key_store)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if trust_store is not None:
            pulumi.set(__self__, "trust_store", trust_store)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[bool]:
        """
        Enables TLS. If false, neither one-way nor two-way TLS will be enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[bool]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def ciphers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The SSL/TLS cipher suites to be used. For programmable proxies, it must be one of the cipher suite names listed in: http://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html#ciphersuites. For configurable proxies, it must follow the configuration specified in: https://commondatastorage.googleapis.com/chromium-boringssl-docs/ssl.h.html#Cipher-suite-configuration. This setting has no effect for configurable proxies when negotiating TLS 1.3.
        """
        return pulumi.get(self, "ciphers")

    @ciphers.setter
    def ciphers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ciphers", value)

    @property
    @pulumi.getter(name="clientAuthEnabled")
    def client_auth_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Enables two-way TLS.
        """
        return pulumi.get(self, "client_auth_enabled")

    @client_auth_enabled.setter
    def client_auth_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "client_auth_enabled", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1TlsInfoCommonNameArgs']]:
        """
        The TLS Common Name of the certificate.
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1TlsInfoCommonNameArgs']]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter(name="ignoreValidationErrors")
    def ignore_validation_errors(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, Edge ignores TLS certificate errors. Valid when configuring TLS for target servers and target endpoints, and when configuring virtual hosts that use 2-way TLS. When used with a target endpoint/target server, if the backend system uses SNI and returns a cert with a subject Distinguished Name (DN) that does not match the hostname, there is no way to ignore the error and the connection fails.
        """
        return pulumi.get(self, "ignore_validation_errors")

    @ignore_validation_errors.setter
    def ignore_validation_errors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ignore_validation_errors", value)

    @property
    @pulumi.getter(name="keyAlias")
    def key_alias(self) -> Optional[pulumi.Input[str]]:
        """
        Required if `client_auth_enabled` is true. The resource ID for the alias containing the private key and cert.
        """
        return pulumi.get(self, "key_alias")

    @key_alias.setter
    def key_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_alias", value)

    @property
    @pulumi.getter(name="keyStore")
    def key_store(self) -> Optional[pulumi.Input[str]]:
        """
        Required if `client_auth_enabled` is true. The resource ID of the keystore.
        """
        return pulumi.get(self, "key_store")

    @key_store.setter
    def key_store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_store", value)

    @property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The TLS versioins to be used.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "protocols", value)

    @property
    @pulumi.getter(name="trustStore")
    def trust_store(self) -> Optional[pulumi.Input[str]]:
        """
        The resource ID of the truststore.
        """
        return pulumi.get(self, "trust_store")

    @trust_store.setter
    def trust_store(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trust_store", value)


@pulumi.input_type
class GoogleCloudApigeeV1TraceSamplingConfigArgs:
    def __init__(__self__, *,
                 sampler: Optional[pulumi.Input['GoogleCloudApigeeV1TraceSamplingConfigSampler']] = None,
                 sampling_rate: Optional[pulumi.Input[float]] = None):
        """
        TraceSamplingConfig represents the detail settings of distributed tracing. Only the fields that are defined in the distributed trace configuration can be overridden using the distribute trace configuration override APIs.
        :param pulumi.Input['GoogleCloudApigeeV1TraceSamplingConfigSampler'] sampler: Sampler of distributed tracing. OFF is the default value.
        :param pulumi.Input[float] sampling_rate: Field sampling rate. This value is only applicable when using the PROBABILITY sampler. The supported values are > 0 and <= 0.5.
        """
        if sampler is not None:
            pulumi.set(__self__, "sampler", sampler)
        if sampling_rate is not None:
            pulumi.set(__self__, "sampling_rate", sampling_rate)

    @property
    @pulumi.getter
    def sampler(self) -> Optional[pulumi.Input['GoogleCloudApigeeV1TraceSamplingConfigSampler']]:
        """
        Sampler of distributed tracing. OFF is the default value.
        """
        return pulumi.get(self, "sampler")

    @sampler.setter
    def sampler(self, value: Optional[pulumi.Input['GoogleCloudApigeeV1TraceSamplingConfigSampler']]):
        pulumi.set(self, "sampler", value)

    @property
    @pulumi.getter(name="samplingRate")
    def sampling_rate(self) -> Optional[pulumi.Input[float]]:
        """
        Field sampling rate. This value is only applicable when using the PROBABILITY sampler. The supported values are > 0 and <= 0.5.
        """
        return pulumi.get(self, "sampling_rate")

    @sampling_rate.setter
    def sampling_rate(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "sampling_rate", value)


@pulumi.input_type
class GoogleIamV1AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleIamV1AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class GoogleIamV1AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['GoogleIamV1AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['GoogleIamV1AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['GoogleIamV1AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['GoogleIamV1AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class GoogleIamV1BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['GoogleTypeExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['GoogleTypeExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['GoogleTypeExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['GoogleTypeExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class GoogleTypeExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class GoogleTypeMoneyArgs:
    def __init__(__self__, *,
                 currency_code: Optional[pulumi.Input[str]] = None,
                 nanos: Optional[pulumi.Input[int]] = None,
                 units: Optional[pulumi.Input[str]] = None):
        """
        Represents an amount of money with its currency type.
        :param pulumi.Input[str] currency_code: The three-letter currency code defined in ISO 4217.
        :param pulumi.Input[int] nanos: Number of nano (10^-9) units of the amount. The value must be between -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos` must be positive or zero. If `units` is zero, `nanos` can be positive, zero, or negative. If `units` is negative, `nanos` must be negative or zero. For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
        :param pulumi.Input[str] units: The whole units of the amount. For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
        """
        if currency_code is not None:
            pulumi.set(__self__, "currency_code", currency_code)
        if nanos is not None:
            pulumi.set(__self__, "nanos", nanos)
        if units is not None:
            pulumi.set(__self__, "units", units)

    @property
    @pulumi.getter(name="currencyCode")
    def currency_code(self) -> Optional[pulumi.Input[str]]:
        """
        The three-letter currency code defined in ISO 4217.
        """
        return pulumi.get(self, "currency_code")

    @currency_code.setter
    def currency_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "currency_code", value)

    @property
    @pulumi.getter
    def nanos(self) -> Optional[pulumi.Input[int]]:
        """
        Number of nano (10^-9) units of the amount. The value must be between -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos` must be positive or zero. If `units` is zero, `nanos` can be positive, zero, or negative. If `units` is negative, `nanos` must be negative or zero. For example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
        """
        return pulumi.get(self, "nanos")

    @nanos.setter
    def nanos(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "nanos", value)

    @property
    @pulumi.getter
    def units(self) -> Optional[pulumi.Input[str]]:
        """
        The whole units of the amount. For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
        """
        return pulumi.get(self, "units")

    @units.setter
    def units(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "units", value)


