KOTOR_LIBRARY = {'k_inc_cheat': b'//:: k_inc_cheat\r\n/*\r\n    This will be localized area for all\r\n    Cheat Bot scripting.\r\n*/\r\n//:: Created By: Preston Watamaniuk\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n\r\n#include "k_inc_debug"\r\n\r\n//Takes a PLANET_ Constant\r\nvoid CH_SetPlanetaryGlobal(int nPlanetConstant);\r\n//Makes the specified party member available to the PC\r\nvoid CH_SetPartyMemberAvailable(int nNPC);\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Set Planet Local\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    VARIABLE = K_CURRENT_PLANET\r\n        Endar Spire     5\r\n        Taris           10\r\n        Dantooine       15\r\n        --Kashyyk       20\r\n        --Manaan        25\r\n        --Korriban      30\r\n        --Tatooine      35\r\n        Leviathan       40\r\n        Unknown World   45\r\n        Star Forge      50\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 16, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid CH_SetPlanetaryGlobal(int nPlanetConstant)\r\n{\r\n    if(nPlanetConstant == PLANET_ENDAR_SPIRE)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 5);\r\n    }\r\n    else if(nPlanetConstant == PLANET_TARIS)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 10);\r\n    }\r\n    else if(nPlanetConstant == PLANET_DANTOOINE)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 15);\r\n    }\r\n    else if(nPlanetConstant == PLANET_KASHYYYK)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 20);\r\n    }\r\n    else if(nPlanetConstant == PLANET_KORRIBAN)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 30);\r\n    }\r\n    else if(nPlanetConstant == PLANET_MANAAN)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 25);\r\n    }\r\n    else if(nPlanetConstant == PLANET_TATOOINE)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 35);\r\n    }\r\n    else if(nPlanetConstant == PLANET_LEVIATHAN)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 40);\r\n    }\r\n    else if(nPlanetConstant == PLANET_UNKNOWN_WORLD)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 45);\r\n    }\r\n    else if(nPlanetConstant == PLANET_STAR_FORGE)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 50);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Make NPC Available\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Sets an NPC as available\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 16, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid CH_SetPartyMemberAvailable(int nNPC)\r\n{\r\n    if(nNPC == NPC_BASTILA)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_BASTILA, "p_bastilla");\r\n    }\r\n    else if(nNPC == NPC_CANDEROUS)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_CANDEROUS, "p_cand");\r\n    }\r\n    else if(nNPC == NPC_CARTH)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_CARTH, "p_carth");\r\n    }\r\n    else if(nNPC == NPC_HK_47)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_HK_47, "p_hk47");\r\n    }\r\n    else if(nNPC == NPC_JOLEE)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_JOLEE, "p_jolee");\r\n    }\r\n    else if(nNPC == NPC_JUHANI)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_JUHANI, "p_juhani");\r\n    }\r\n    else if(nNPC == NPC_MISSION)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_MISSION, "p_mission");\r\n    }\r\n    else if(nNPC == NPC_T3_M4)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_T3_M4, "p_t3m4");\r\n    }\r\n    else if(nNPC == NPC_ZAALBAR)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_ZAALBAR, "p_zaalbar");\r\n    }\r\n}\r\n\r\n\r\n\r\n', 'k_inc_dan': b'#include "k_inc_generic"\r\n#include "k_inc_utility"\r\nint ROMANCE_DONE = 4;\r\nint JUHANI_RESCUED = 1;\r\nint JEDI_TRAINING_DONE = 7;\r\n\r\nint JEDI_PATH_GUARDIAN = 1;\r\nint JEDI_PATH_SENTINEL = 2;\r\nint JEDI_PATH_CONSULAR = 3;\r\n\r\n\r\nint DROID_STARTED = 1;\r\nint DROID_DESTROYED = 2;\r\nint DROID_DECEIVED = 3;\r\nint DROID_RETURNED = 4;\r\nint DROID_HELPED = 5;\r\nint DROID_FINISHED = 6;\r\nstring sBastilaTag = "bastila";\r\nstring sCarthTag = "carth";\r\nstring sCouncilTag = "dan13_WP_council";\r\n\r\nstring SABER_BLUE = "g_w_lghtsbr01";\r\nstring SABER_GREEN = "g_w_lghtsbr03";\r\nstring SABER_GOLD = "g_w_lghtsbr04";\r\nstring WANDERING_HOUND_TAG = "dan_wanderhound";\r\n//places an instance of a character based on the tag/template\r\n// **TAG MUST BE THE SAME AS TEMPLATE**\r\nvoid PlaceNPC(string sTag, string sLocation = "");\r\n\r\n//Get Carth\'s Object\r\nobject GetCarth();\r\n\r\n//Gets Bastila\'s object\r\nobject GetBastila();\r\n\r\n//gets the center of the council chamber\r\nvector GetChamberCenter();\r\n\r\n// creature move along a waypoint path. Not interuptable.\r\nvoid PlotMove(string sWayPointTag,int nFirst, int nLast, int nRun = FALSE);\r\n\r\n// creature move along a waypoint path. Not interuptable. Destroys self at the end\r\nvoid PlotLeave(string sWayPointTag,int nFirst, int nLast, int nRun = FALSE);\r\n\r\n// returns true is a trigger has not been fired yet\r\n// intended for one shot triggers\r\nint HasNeverTriggered();\r\n\r\n//returns true if, on Korriban, the player has convinced Yuthura to come to Dantooine.\r\nint YuthuraHasDefected();\r\n\r\n//Sets the progression of the Elise plot on Dantooine\r\nvoid SetElisePlot(int nValue);\r\n\r\n// returns true if the player has started the Elise plot\r\nint ElisePlotStarted();\r\n\r\n// returns true if the player has agreed to help the droid after it has returned to elise\r\nint GetDroidHelped();\r\n\r\n// returns true if c369 has been spoken to\r\nint GetEliseDroidMet();\r\n\r\n//  the Elise plot has not started yet\r\nint GetElisePlotNeverStared();\r\n\r\n// returns true if Elise has gone to the Jedi compund\r\nint GetEliseInCompound();\r\n\r\n// returns true if the Elise plot is over\r\nint GetElisePlotDone();\r\n\r\n\r\n//returns true if Elise\'s droid was returned to her\r\nint GetEliseDroidReturned();\r\n\r\n// changes the PC to a new Jedi Class and gives them the required xperience to level Up\r\nvoid TurnPlayerIntoJedi();\r\n\r\n//checks for a color crystal in the players inventory and creates a saber of that color\r\nobject CreateFirstLightsaber();\r\n\r\n//creates droids for the danm14ab cutscene\r\nvoid StartDroid(string sLetter, int nNum);\r\n\r\n//\r\nvoid WraperShowLevelUpGUI();\r\n//void main(){}\r\n\r\n// returns number of the remaining wndering hounds on the level\r\nint GetNumberOfWanderingKathHounds();\r\n\r\n// spawns the number of Kath hounds. recursive\r\nvoid SpawnWanderingKathHound(int nNumberOfHounds);\r\n\r\nvoid PlaceNPC(string sTag, string sLocation = "")\r\n{\r\n    if(!GetIsObjectValid(GetObjectByTag(sTag)))\r\n    {\r\n        CreateObject(OBJECT_TYPE_CREATURE,sTag,GetLocation(GetObjectByTag("POST_" + sTag + sLocation)));\r\n    }\r\n}\r\n\r\nobject GetCarth()\r\n{\r\n    return GetObjectByTag(sCarthTag);\r\n}\r\n\r\nobject GetBastila()\r\n{\r\n    return GetObjectByTag(sBastilaTag);\r\n}\r\n\r\nvector GetChamberCenter()\r\n{\r\n    return GetPosition(GetObjectByTag(sCouncilTag));\r\n}\r\n\r\nvoid PlotMove(string sWayPointTag,int nFirst, int nLast, int nRun = FALSE)\r\n{\r\n\r\n    int nInc = 1;\r\n    object oWP;\r\n    int nIdx;\r\n    if(nFirst > nLast)\r\n    {\r\n        nInc = -1;\r\n    }\r\n    for(nIdx = nFirst - nInc; abs(nLast - nIdx) > 0 && abs(nLast - nIdx) <= abs((nLast - nFirst) + 1); nIdx = nIdx + nInc)\r\n    {\r\n        oWP = GetObjectByTag(sWayPointTag + IntToString(nIdx + nInc));\r\n        if(GetIsObjectValid(oWP))\r\n        {\r\n            ActionForceMoveToObject(oWP,nRun,3.0f,5.0f);\r\n        }\r\n    }\r\n    ActionDoCommand(SetCommandable(TRUE));\r\n    SetCommandable(FALSE);\r\n}\r\n\r\nvoid PlotLeave(string sWayPointTag,int nFirst, int nLast, int nRun = FALSE)\r\n{\r\n    int nInc = 1;\r\n    object oWP;\r\n    int nIdx;\r\n    object oSelf = OBJECT_SELF;\r\n    if(nFirst > nLast)\r\n    {\r\n        nInc = -1;\r\n    }\r\n    for(nIdx = nFirst - nInc; abs(nLast - nIdx) > 0 && abs(nLast - nIdx) <= abs((nLast - nFirst) + 1); nIdx = nIdx + nInc)\r\n    {\r\n        oWP = GetObjectByTag(sWayPointTag + IntToString(nIdx + nInc));\r\n        if(GetIsObjectValid(oWP))\r\n        {\r\n            ActionForceMoveToObject(oWP,nRun,3.0f,5.0f);\r\n        }\r\n    }\r\n    ActionDoCommand(DestroyObject(OBJECT_SELF));\r\n    SetCommandable(FALSE);\r\n}\r\n\r\nint HasNeverTriggered()\r\n{\r\n    int bReturn;\r\n    if(UT_GetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_01) == FALSE)\r\n    {\r\n        bReturn = TRUE;\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_01,TRUE);\r\n    }\r\n    return bReturn;\r\n}\r\n\r\nint YuthuraHasDefected()\r\n{\r\n    return GetGlobalNumber("KOR_FINAL_TEST") == 7;\r\n}\r\n\r\nvoid SetElisePlot(int nValue)\r\n{\r\n    SetGlobalNumber("DAN_ELISE_PLOT",nValue);\r\n}\r\n\r\nint ElisePlotStarted()\r\n{\r\n    return GetGlobalNumber("DAN_ELISE_PLOT") == DROID_STARTED;\r\n}\r\n\r\nint GetDroidHelped()\r\n{\r\n    return GetGlobalNumber("DAN_ELISE_PLOT") == DROID_HELPED;\r\n}\r\n\r\nint GetEliseDroidMet()\r\n{\r\n    return GetGlobalNumber("DAN_ELISE_PLOT") > DROID_STARTED &&\r\n           GetGlobalNumber("DAN_ELISE_PLOT") < DROID_FINISHED;\r\n}\r\n\r\nint GetElisePlotNeverStared()\r\n{\r\n    return GetGlobalNumber("DAN_ELISE_PLOT") == 0;\r\n}\r\n\r\nint GetEliseInCompound()\r\n{\r\n    return GetGlobalBoolean("DAN_ELISE_COMPOUND");\r\n}\r\n\r\nint GetElisePlotDone()\r\n{\r\n    return GetGlobalNumber("DAN_ELISE_PLOT") >= DROID_FINISHED;\r\n}\r\n\r\nint GetEliseDroidReturned()\r\n{\r\n    return GetGlobalNumber("DAN_ELISE_PLOT") == DROID_RETURNED ||\r\n           GetGlobalNumber("DAN_ELISE_PLOT") == DROID_HELPED;\r\n}\r\n\r\nvoid TurnPlayerIntoJedi()\r\n{\r\n    object oPC = GetFirstPC();\r\n/*    int nXP = GetXP(oPC);\r\n   // AurPostString("Current XP: " + IntToString(nXP),5,5,5.0);\r\n\r\n    int nLevel = GetHitDice(oPC);\r\n   // AurPostString("Current Level: " + IntToString(nLevel),5,6,5.0);\r\n\r\n    int nXPNeeded = 1000 * FloatToInt((IntToFloat(nLevel) / 2.0) * (IntToFloat(nLevel) + 1.0));\r\n   // AurPostString("XP Needed" + IntToString(nXPNeeded),5,7,5.0);\r\n\r\n    int nSaved = nXP - nXPNeeded;\r\n   // AurPostString("Extra: " + IntToString(nSaved),5,8,5.0);\r\n    if(nSaved > 0)\r\n    {\r\n        SetGlobalBoolean("DAN_EXTRA",TRUE);\r\n        int nLow = nSaved & 0xff;\r\n        AurPostString(IntToString(nLow),5,9,5.0);\r\n        int nHigh = (nSaved >> 8) & 0xff;\r\n        AurPostString(IntToString(nHigh),5,10,5.0);\r\n       // if (nLow > 0)\r\n       // {\r\n           SetGlobalNumber("DAN_EXTRA_XP",nLow - 128);\r\n       // }\r\n      //  if (nHigh > 0)\r\n        //{\r\n            SetGlobalNumber("DAN_EXTRA_XP2",nHigh - 128);\r\n       //}\r\n    } */\r\n\r\n    int nJediPath = GetGlobalNumber("DAN_PATH_STATE");\r\n    if(nJediPath > 0)\r\n    {\r\n        if(nJediPath == JEDI_PATH_GUARDIAN)\r\n        {\r\n            AddMultiClass(CLASS_TYPE_JEDIGUARDIAN,oPC);\r\n        }\r\n        else if (nJediPath == JEDI_PATH_SENTINEL)\r\n        {\r\n            AddMultiClass(CLASS_TYPE_JEDISENTINEL,oPC);\r\n        }\r\n        else if (nJediPath == JEDI_PATH_CONSULAR)\r\n        {\r\n            AddMultiClass(CLASS_TYPE_JEDICONSULAR,oPC);\r\n        }\r\n      //  int nLevel = GetHitDice(oPC);\r\n      //  int nXPNeeded = 1000 * (nLevel / 2) * (nLevel + 1);\r\n      //  SetXP(oPC,nXPNeeded);\r\n    }\r\n    //ShowLevelUpGUI();\r\n    CancelPostDialogCharacterSwitch();\r\n    NoClicksFor(0.6);\r\n    DelayCommand(0.5,WraperShowLevelUpGUI());\r\n}\r\n\r\nobject CreateFirstLightsaber()\r\n{\r\n    object oPC = GetFirstPC();\r\n    object oSaber;\r\n    object oCrystal = GetItemPossessedBy(GetFirstPC(),"dan13_plotcrys");\r\n    SetPlotFlag(oCrystal,FALSE);\r\n    DestroyObject(oCrystal);\r\n   /* if(GetIsObjectValid(oSaber))\r\n    {\r\n        AssignCommand(oPC,ActionEquipItem(oSaber,INVENTORY_SLOT_RIGHTWEAPON));\r\n    }*/\r\n    int nJediPath = GetGlobalNumber("DAN_PATH_STATE");\r\n    if(nJediPath > 0)\r\n    {\r\n        if(nJediPath == JEDI_PATH_GUARDIAN)\r\n        {\r\n            oSaber = CreateItemOnObject(SABER_BLUE,oPC);\r\n        }\r\n        else if (nJediPath == JEDI_PATH_SENTINEL)\r\n        {\r\n            oSaber = CreateItemOnObject(SABER_GOLD,oPC);\r\n        }\r\n        else if (nJediPath == JEDI_PATH_CONSULAR)\r\n        {\r\n            oSaber = CreateItemOnObject(SABER_GREEN,oPC);\r\n        }\r\n    }\r\n    if(GetIsObjectValid(oSaber))\r\n    {\r\n      // ExecuteScript("k_pdan_player03",oPC);\r\n        DelayCommand(0.1,AssignCommand(oPC,ActionEquipItem(oSaber,INVENTORY_SLOT_RIGHTWEAPON)));\r\n    }\r\n    return oSaber;\r\n}\r\n\r\nvoid StartDroid(string sLetter, int nNum)\r\n{\r\n    string sBase = "danm14aa_WP_droid";\r\n    string sStartTag = sBase + sLetter + "_01";\r\n    string sEndTag = sBase + sLetter + "_0" + IntToString(nNum);\r\n    location lStart = GetLocation(GetObjectByTag(sStartTag));\r\n    location lEnd = GetLocation(GetObjectByTag(sEndTag));\r\n\r\n    object oDroid = CreateObject(OBJECT_TYPE_CREATURE, "pdan_mwdroid",lStart);\r\n    AssignCommand(oDroid,ActionWait(0.5));\r\n    AssignCommand(oDroid,ActionMoveToLocation(lEnd));\r\n\r\n\r\n/*    if(GetIsObjectValid(GetObjectByTag(sTag + sLetter + "_01")))\r\n    {\r\n        PrintString("Aidan--FoundDroidWP");\r\n    }\r\n    else\r\n    {\r\n        PrintString("Aidan--Can\'t Find DroidWP");\r\n    }*/\r\n   // object oDroid = CreateObject(OBJECT_TYPE_CREATURE, "pdan_mwdroid",GetLocation(GetObjectByTag(sTag + sLetter + "_01")));\r\n  //  AssignCommand(oDroid,ActionMoveToObject(GetObjectByTag(sTag + sLetter + "_0" + IntToString(nNum))));\r\n}\r\n\r\nvoid WraperShowLevelUpGUI()\r\n{\r\n    int bAdd = GetGlobalBoolean("DAN_EXTRA");\r\n    int nHigh =(GetGlobalNumber("DAN_EXTRA_XP2") + 128) << 8;\r\n   // AurPostString(IntToString(nHigh),5,12,5.0);\r\n    int nLow = GetGlobalNumber("DAN_EXTRA_XP") + 128;\r\n   // AurPostString(IntToString(nLow),5,13,5.0);\r\n    int nExtra = nHigh  | nLow;\r\n   // AurPostString("Extra Saved: " + IntToString(nExtra),5,14,5.0);\r\n    if(bAdd)\r\n    {\r\n       // AurPostString("Setting: " + IntToString(nExtra),5,15,5.0);\r\n        GiveXPToCreature(GetFirstPC(),nExtra);\r\n    }\r\n    SetGlobalNumber("DAN_EXTRA_XP",0);\r\n    SetGlobalNumber("DAN_EXTRA_XP2",0);\r\n    ShowLevelUpGUI();\r\n}\r\n\r\nint GetNumberOfWanderingKathHounds()\r\n{\r\n    int nNumber;\r\n   // int nNumber2;\r\n    int nCount = GetStringLength(WANDERING_HOUND_TAG);\r\n    object oHound = GetFirstObjectInArea();\r\n    while(GetIsObjectValid(oHound))\r\n    {\r\n     //   AurPostString("Tag: " + GetTag(oHound),5,3,5.0);\r\n        if(GetStringLeft(GetTag(oHound),nCount) == WANDERING_HOUND_TAG)\r\n        {\r\n            nNumber++;\r\n        }\r\n       // nNumber2++;\r\n        oHound = GetNextObjectInArea();\r\n       // AurPostString("Tag: " + GetTag(oHound),5,4,5.0);\r\n    }\r\n    //AurPostString("Number of Objects: " + IntToString(nNumber2),5,5,5.0);\r\n   // AurPostString("Number of Objects: " + IntToString(nNumber),5,6,5.0);\r\n    return nNumber;\r\n}\r\n\r\nvoid SpawnWanderingKathHound(int nNumberOfHounds)\r\n{\r\n    string sHound = WANDERING_HOUND_TAG + IntToString(nNumberOfHounds);\r\n    location lSpawn = GetLocation(GetObjectByTag( "WP_" + sHound + "_01" ));\r\n    CreateObject(OBJECT_TYPE_CREATURE,sHound,lSpawn);\r\n    nNumberOfHounds--;\r\n    if(nNumberOfHounds > 0)\r\n    {\r\n        SpawnWanderingKathHound(nNumberOfHounds);\r\n    }\r\n\r\n}\r\n', 'k_inc_debug': b'//::///////////////////////////////////////////////\r\n//:: KOTOR Debug Include\r\n//:: k_inc_debug\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This contains the functions for inserting\r\n    debug information into the scripts.\r\n    This include will use Db as its two letter\r\n    function prefix.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: June 12, 2002\r\n//:://////////////////////////////////////////////\r\n\r\n//Inserts a print string into the log file for debugging purposes.\r\nvoid Db_MyPrintString(string sString);\r\n//Makes the object running the script say a speak string.\r\nvoid Db_MySpeakString(string sString);\r\n//Makes the nearest PC say a speakstring.\r\nvoid Db_AssignPCDebugString(string sString);\r\n//Basically, a wrapper for AurPostString\r\nvoid Db_PostString(string sString = "",int x = 5,int y = 5,float fShow = 1.0);\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Debug Print String\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Inserts a print string into the log file for\r\n    debugging purposes.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: June 12, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid Db_MyPrintString(string sString)\r\n{\r\n    if(!ShipBuild())\r\n    {\r\n        PrintString(sString);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Debug Speak String\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Makes the object running the script say a\r\n    speak string.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: June 12, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid Db_MySpeakString(string sString)\r\n{\r\n    SpeakString(sString);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Assign PC Debug String\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Assigns the nearest PC a speakstring for debug\r\n    purposes.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: June 12, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid Db_AssignPCDebugString(string sString)\r\n{\r\n    object oPC = GetNearestCreature(CREATURE_TYPE_PLAYER_CHAR, PLAYER_CHAR_IS_PC);\r\n    if(GetIsObjectValid(oPC))\r\n    {\r\n        AssignCommand(oPC, SpeakString(sString));\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Db_PostString\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//Basically, a wrapper for AurPostString\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: July 15, 2002\r\n//:://////////////////////////////////////////////\r\nvoid Db_PostString(string sString = "",int x = 5,int y = 5,float fShow = 1.0)\r\n{\r\n    if(!ShipBuild())\r\n    {\r\n        AurPostString(sString,x,y,fShow);\r\n    }\r\n}\r\n\r\n', 'k_inc_drop': b'//::///////////////////////////////////////////////\r\n//:: KOTOR Treasure drop Include\r\n//:: k_inc_drop\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n// Contains the functions for handling creatures dropping random treasure\r\n//Only human creatures not of the beast subrace willdrop treasure dependant\r\n//on their hit dice\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Aidan Scanlan On: 02/06/03\r\n//:://////////////////////////////////////////////\r\n\r\nint DR_HIGH_LEVEL = 15;\r\nint DR_MEDIUM_LEVEL = 10;\r\nint DR_LOW_LEVEL = 5;\r\nint DR_SUBRACE_BEAST = 2;\r\n//Checks for treasure drop conditions. Returns True if treasure will drop\r\nint DR_SpawnCreatureTreasure(object oTarget = OBJECT_SELF);\r\n//Dependant on the level of a creature drops treasure from a list\r\nvoid DR_CreateRandomTreasure(object oTarget = OBJECT_SELF);\r\n// creates a low level treasure: med pack/repair, frag grenade, credits\r\nvoid DR_CreateLowTreasure();\r\n// creates midlevel treasure: adv-med/repair, any gredade, stims, credits\r\nvoid DR_CreateMidTreasure();\r\n// creates high treasure: adv stims, grenades, ultra med/repair, credits\r\nvoid DR_CreateHighTreasure();\r\n// Creates 1-4 credits\r\nvoid DR_CreateFillerCredits();\r\n/////////////////////////////////////////////////////////////////////////\r\n\r\n\r\n//Checks for treasure drop conditions. Returns True if treasure will drop\r\nint DR_SpawnCreatureTreasure(object oTarget = OBJECT_SELF)\r\n{\r\n    int nRace = GetRacialType(oTarget);\r\n    int nFaction = GetStandardFaction(oTarget);\r\n    int nSubRace = GetSubRace(oTarget);\r\n    if(Random(4) == 0 &&\r\n       nRace != RACIAL_TYPE_DROID &&\r\n       nSubRace != DR_SUBRACE_BEAST)\r\n    {\r\n        //AurPostString("will drop",5,5,5.0);\r\n        DR_CreateRandomTreasure(oTarget);\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//Dependant on the level of a creature drops treasure from a list\r\nvoid DR_CreateRandomTreasure(object oTarget = OBJECT_SELF)\r\n{\r\n    int nLevel = GetHitDice(oTarget);\r\n    if (nLevel > DR_HIGH_LEVEL)\r\n    {\r\n        DR_CreateHighTreasure();\r\n        if(Random(2) == 0)\r\n        {\r\n            DR_CreateHighTreasure();\r\n        }\r\n        if(Random(2) == 0)\r\n        {\r\n            DR_CreateMidTreasure();\r\n        }\r\n    }\r\n    else if (nLevel <= DR_HIGH_LEVEL && nLevel > DR_MEDIUM_LEVEL)\r\n    {\r\n        DR_CreateMidTreasure();\r\n        if(Random(3) == 0)\r\n        {\r\n            DR_CreateHighTreasure();\r\n        }\r\n        if(Random(2) == 0)\r\n        {\r\n            DR_CreateMidTreasure();\r\n        }\r\n    }\r\n    else if (nLevel <= DR_MEDIUM_LEVEL && nLevel > DR_LOW_LEVEL)\r\n    {\r\n        DR_CreateMidTreasure();\r\n        if(Random(2) == 0)\r\n        {\r\n            DR_CreateLowTreasure();\r\n        }\r\n    }\r\n    else\r\n    {\r\n        DR_CreateLowTreasure();\r\n        if(Random(3) == 0)\r\n        {\r\n            DR_CreateLowTreasure();\r\n        }\r\n        if(Random(4) == 0)\r\n        {\r\n            DR_CreateMidTreasure();\r\n        }\r\n    }\r\n}\r\n\r\n// creates a low level treasure: med pack/repair, frag grenade, credits\r\nvoid DR_CreateLowTreasure()\r\n{\r\n   //AurPostString("dropping low",5,6,5.0);\r\n    string sTemplate;\r\n    int nStack = 1;\r\n    int nRandom = Random(6);\r\n    switch(nRandom)\r\n    {\r\n        case 0: sTemplate = "g_i_drdrepeqp001";  //repair kit\r\n        break;\r\n\r\n        case 1:\r\n            sTemplate = "g_i_credits001";// 5 stack\r\n            nStack = 5;\r\n            DR_CreateFillerCredits();\r\n        break;\r\n\r\n        case 2:\r\n            sTemplate = "g_i_credits002";  //10 stack\r\n            nStack = 10;\r\n            DR_CreateFillerCredits();\r\n        break;\r\n\r\n        case 3:\r\n            sTemplate = "g_i_credits003";  // 25 stack\r\n            nStack = 25;\r\n            DR_CreateFillerCredits();\r\n        break;\r\n\r\n        case 4: sTemplate = "g_i_medeqpmnt01";// med kit\r\n        break;\r\n\r\n        case 5: sTemplate = "g_w_fraggren01"; // frag grenade\r\n        break;\r\n    }\r\n\r\n    CreateItemOnObject(sTemplate,OBJECT_SELF,nStack);\r\n}\r\n\r\n// creates midlevel treasure: adv-med/repair, any gredade, stims, credits\r\nvoid DR_CreateMidTreasure()\r\n{\r\n    string sTemplate;\r\n    int nStack = 1;\r\n    int nRandom = Random(15);\r\n    switch (nRandom)\r\n    {\r\n        case 0: sTemplate = "g_i_drdrepeqp002";  //advanced repair kit\r\n        break;\r\n\r\n        case 1:\r\n            sTemplate = "g_i_credits004";  // 50 stack\r\n            nStack = 50;\r\n            DR_CreateFillerCredits();\r\n        break;\r\n\r\n        case 2: sTemplate = "g_i_medeqpmnt02"; //advanced med pack\r\n        break;\r\n\r\n        case 3: sTemplate = "g_i_cmbtshot001"; //battle stimulant\r\n        break;\r\n\r\n        case 4: sTemplate = "g_i_adrnaline003";  //adrenal stamina\r\n        break;\r\n\r\n        case 5: sTemplate = "g_i_adrnaline002"; // adrenal alacrity\r\n        break;\r\n\r\n        case 6: sTemplate = "g_i_adrnaline001"; // adrenal strength\r\n        break;\r\n\r\n        case 7:\r\n            sTemplate = "g_w_stungren01";  // stun grenade\r\n            nStack = 2;\r\n        break;\r\n\r\n        case 8:\r\n            sTemplate = "g_w_fraggren01";  // fragmentation grenade\r\n            nStack = 2;\r\n        break;\r\n\r\n        case 9: sTemplate = "g_w_poisngren01"; // poison gredade\r\n        break;\r\n\r\n        case 10: sTemplate = "g_w_sonicgren01"; // sonic grenade\r\n        break;\r\n\r\n        case 11: sTemplate = "g_w_adhsvgren001"; // adhesive grenade\r\n        break;\r\n\r\n        case 12: sTemplate = "g_w_cryobgren001";// cryo grenade\r\n        break;\r\n\r\n        case 13: sTemplate = "g_w_iongren01";// ion grenade\r\n        break;\r\n    }\r\n    CreateItemOnObject(sTemplate,OBJECT_SELF,nStack);\r\n}\r\n\r\n// creates high treasure: adv stims, grenades, ultra med/repair, credits\r\nvoid DR_CreateHighTreasure()\r\n{\r\n    string sTemplate;\r\n    int nStack = 1;\r\n    int nRandom = Random(16);\r\n    switch (nRandom)\r\n    {\r\n        case 0: sTemplate = "g_i_drdrepeqp003";  //super repair kit\r\n        break;\r\n\r\n        case 1: sTemplate = "g_w_thermldet01"; //Thermal detinator\r\n        break;\r\n\r\n        case 2: sTemplate = "g_i_medeqpmnt03"; //life pack\r\n        break;\r\n\r\n        case 3: sTemplate = "g_i_cmbtshot003";//speed stim\r\n        break;\r\n\r\n        case 4: sTemplate = "g_i_cmbtshot002"; //hyper battle stim\r\n        break;\r\n\r\n        case 5: sTemplate = "g_i_adrnaline006"; //huper adrenal stamina\r\n        break;\r\n\r\n        case 6: sTemplate = "g_i_adrnaline005"; //hyper adrenal alacrity\r\n        break;\r\n\r\n        case 7: sTemplate = "g_i_adrnaline004";// hyper adrenal strength\r\n        break;\r\n\r\n        case 8:\r\n        sTemplate = "g_w_poisngren01"; // poison gredade\r\n        nStack = 2;\r\n        break;\r\n\r\n        case 9:\r\n        sTemplate = "g_w_sonicgren01"; // sonic grenade\r\n        nStack = 2;\r\n        break;\r\n\r\n        case 10:\r\n        sTemplate = "g_w_adhsvgren001"; // adhesive grenade\r\n        nStack = 2;\r\n        break;\r\n\r\n        case 11:\r\n        sTemplate = "g_w_cryobgren001";// cryo grenade\r\n        nStack = 2;\r\n        break;\r\n\r\n        case 12:\r\n        sTemplate = "g_w_firegren001";// plasma grenade\r\n        nStack = 2;\r\n        break;\r\n\r\n        case 13:\r\n        sTemplate = "g_w_iongren01";// ion grenade\r\n        nStack = 2;\r\n        break;\r\n\r\n        case 14:\r\n        sTemplate = "g_i_credits015";\r\n        nStack = Random(50) + 50;\r\n        break;\r\n\r\n        case 15: sTemplate = "g_w_firegren001";// plasma grenade\r\n        break;\r\n\r\n    }\r\n    CreateItemOnObject(sTemplate,OBJECT_SELF,nStack);\r\n}\r\n\r\n// Creates 1-4 credits\r\nvoid DR_CreateFillerCredits()\r\n{\r\n    CreateItemOnObject("g_i_credits015",OBJECT_SELF,Random(4) + 1);\r\n}\r\n', 'k_inc_ebonhawk': b'//:: k_inc_ebonhawk\r\n/*\r\n     Ebon Hawk include file\r\n*/\r\n//:: Created By: Preston Watamaniuk\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n\r\n//This checks the Star Map plot to see if it is at state 30.\r\nint EBO_CheckStarMapPlot();\r\n//Bastila intiates conversation with the PC\r\nvoid EBO_BastilaStartConversation2();\r\n//Should Bastila intiates conversation with the PC\r\nint EBO_ShouldBastilaStartConversation();\r\n//Bastila intiates conversation with the PC\r\nvoid EBO_BastilaStartConversation2();\r\n//Advances the state of the bounty hunters plot after galaxy map selections are made\r\nvoid EBO_PlayBountyHunterCutScene();\r\n//Play the current cutscene for taking off from the planet.\r\nvoid EBO_PlayTakeOff(int nCurrentPlanet);\r\n//Play the corrent cutscene for landing on the planet.\r\nvoid EBO_PlayLanding(int nDestination);\r\n//Creates items on the PC based on the NPC they are talking to.\r\nvoid EBO_CreateEquipmentOnPC();\r\n//Checks if the PC needs equipment based on the NPC they are talking to.\r\nint EBO_GetIsEquipmentNeeded();\r\n//Determines the number items held with specific tags\r\nint EBO_CheckInventoryNumbers(string sTag1, string sTag2 = "", string sTag3 = "", string sTag4 = "");\r\n//Returns the scripting constant for the current planet.\r\nint EBO_GetCurrentPlanet();\r\n//Returns the scripting constant for the future planet.\r\nint EBO_GetFuturePlanet();\r\n//Returns the correct K_CURRENT_PLANET value when a Planetary.2DA index is passed in.\r\nint EBO_GetPlanetFrom2DA(int nPlanetIndex);\r\n//Starts the correct sequence based on the planet being traveled to.\r\nvoid EBO_PlayRenderSequence();\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Check Star Map\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    If the variable K_STAR_MAP is at 30 and\r\n    the variable K_CAPTURED_LEV = 5 then\r\n    run the leviathan module.\r\n    K_CAPTURED_LEV States\r\n    0 = Pre Leviathan\r\n    5 = Captured\r\n    10 = Escaped\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 3, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint EBO_CheckStarMapPlot()\r\n{\r\n    int nStarMap = GetGlobalNumber("K_STAR_MAP");\r\n    int nLev = GetGlobalBoolean("K_CAPTURED_LEV");\r\n    if(nStarMap >= 40 && nLev == 5)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 40);\r\n        //This will be removed when the new galaxy map is rolled out.\r\n        StartNewModule("ebo_m40aa");\r\n\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Bastila Start Vision Conversation\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This function gets bastila to start the\r\n    appropriate cutscene dialogue with the PC\r\n    You can use k_vis_[PLANET] == FALSE to see\r\n    if they have been their before and seen the\r\n    planet vision. This applies to Dantooine,\r\n    Manaan, Korriban, Tatooine and Kashyyyk.\r\n\r\n    Also set the script so that if Ebon_Vision !=99\r\n    then it fires the dialog file ebo_bast_vision\r\n    and has Bastila init dialog on the Ebon Hawk.\r\n    (If Ebon_Vision==99 the dialog will not fire,\r\n    but it should still play the vision.\r\n    15 to 35\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 3, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid EBO_BastilaStartConversation()\r\n{\r\n    int nPlanet = GetGlobalNumber("K_CURRENT_PLANET");\r\n    int nVision = GetGlobalNumber("Ebon_Vision");\r\n    int nFLAG = FALSE;\r\n    if( (nPlanet == 15 || nPlanet == 20 || nPlanet == 25 || nPlanet == 30 || nPlanet == 35) && nVision != 99)\r\n    {\r\n        object oBast = GetNearestObjectByTag("Bastila");\r\n        if(GetIsObjectValid(oBast))\r\n        {\r\n            if(nPlanet == 15 && !GetGlobalBoolean("k_vis_dantooine"))\r\n            {\r\n                nFLAG = TRUE;\r\n                SetGlobalBoolean("k_vis_dantooine",1);\r\n            }\r\n            else if(nPlanet == 20 && !GetGlobalBoolean("k_vis_kashyyyk"))\r\n            {\r\n                nFLAG = TRUE;\r\n                SetGlobalBoolean("k_vis_kashyyyk",1);\r\n            }\r\n            else if(nPlanet == 25 && !GetGlobalBoolean("k_vis_manaan"))\r\n            {\r\n                nFLAG = TRUE;\r\n                SetGlobalBoolean("k_vis_manaan",1);\r\n            }\r\n            else if(nPlanet == 30 && !GetGlobalBoolean("k_vis_korriban"))\r\n            {\r\n                nFLAG = TRUE;\r\n                SetGlobalBoolean("k_vis_korriban",1);\r\n            }\r\n            else if(nPlanet == 35 && !GetGlobalBoolean("k_vis_tatooine"))\r\n            {\r\n                nFLAG = TRUE;\r\n                SetGlobalBoolean("k_vis_tatooine",1);\r\n            }\r\n            if(nFLAG == TRUE)\r\n            {\r\n                //HoldWorldFadeInForDialog();\r\n                object oPC = GetFirstPC();\r\n                AurPostString("I am going to talk", 5, 6, 4.0);\r\n                AurPostString("Bastila is Valid = " + IntToString(GetIsObjectValid(oBast)), 5,7,4.0);\r\n                AurPostString("PC is Valid = " + IntToString(GetIsObjectValid(oPC)), 5,8,4.0);\r\n                AssignCommand(oBast, ActionStartConversation(oPC, "ebo_bast_vision", FALSE, CONVERSATION_TYPE_CINEMATIC, TRUE));\r\n            }\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//::Calo Nord / Bandon Variable Advancement\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This plot involves the PC being tracked across the galaxy.\r\n    Plot is tracked with the K_KALO_BANDON variable\r\n    1 - Leaving Dantooine --> Cutscene with Calo Nord = 0, set to 10.\r\n    2 - On 3rd Star Map Planet --> Next villain encounter will spawn Nord = 10, set to 20\r\n    3 - Leaving 3rd Starmap Planet --> Darth Bandon cutscene = 20, set to 30.\r\n    4 - On 4th Star Map planet --> Darth Bandon Attacks = 30, set to 99\r\n    Trigger have been placed on all the creamy middle planets to simulate\r\n    the ambush\r\n    10 - 1st Map Activated - Set K_KALO_BANDON to 10\r\n    30 - 3rd Map Activated - Set K_KALO_BANDON to 30\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 9, 2002\r\n//:://////////////////////////////////////////////\r\nvoid EBO_PlayBountyHunterCutScene()\r\n{\r\n    int nStar = GetGlobalNumber("K_STAR_MAP");\r\n    if(nStar == 10)\r\n    {\r\n        //NOTE - PLAY FIRST CUTSCENE WITH CALO NORD HERE\r\n        SetGlobalNumber("K_KALO_BANDON", 10);\r\n    }\r\n    else if(nStar == 30)\r\n    {\r\n        //NOTE - PLAY SECOND CUTSCENE WITH DARTH BANDON HERE\r\n        SetGlobalNumber("K_KALO_BANDON", 30);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//::Play Appropriate Travel Cutscenes\r\n//::Calo Nord / Bandon Variable Advancement\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    K_STAR_MAP variable\r\n    0 - No maps activated\r\n    10 - 1st Map Activated\r\n    20 - 2nd Map Activated\r\n    30 - 3rd Map Activated\r\n    40 - 4th Map Activated\r\n    50 - 5th Map Activated\r\n\r\nWorld Variables\r\n    Global Number Variable: Planet Settings\r\n    VARIABLE = K_CURRENT_PLANET\r\n        Endar Spire     5\r\n        Taris           10\r\n        Dantooine       15\r\n        --Kashyyk       20\r\n        --Manaan        25\r\n        --Korriban      30\r\n        --Tatooine      35\r\n        Leviathan       40\r\n        Unknown World   45\r\n        Star Forge      50\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 9, 2002\r\n//:://////////////////////////////////////////////\r\nstring EBO_PlayTakeOff(int nCurrentPlanet)\r\n{\r\n    int nPlanet = nCurrentPlanet;//GetGlobalNumber("K_CURRENT_PLANET");\r\n    if(nPlanet == 15)\r\n    {\r\n        PlayMovie("05_2c");\r\n    }\r\n    else if(nPlanet == 20)\r\n    {\r\n        PlayMovie("05_4c");\r\n    }\r\n    else if(nPlanet == 25)\r\n    {\r\n        PlayMovie("05_5c");\r\n    }\r\n    else if(nPlanet == 30)\r\n    {\r\n        PlayMovie("05_7c");\r\n    }\r\n    else if(nPlanet == 35)\r\n    {\r\n        PlayMovie("05_3c");\r\n    }\r\n    else if(nPlanet == 40)\r\n    {\r\n        //PlayMovie("");\r\n    }\r\n    else if(nPlanet == 45)\r\n    {\r\n        PlayMovie("05_8c");\r\n    }\r\n    return "NULL";\r\n}\r\n\r\nstring EBO_PlayLanding(int nDestination)\r\n{\r\n    int nPlanet = GetGlobalNumber("K_CURRENT_PLANET");\r\n    if(nPlanet == 15)\r\n    {\r\n        PlayMovie("05_2a");\r\n    }\r\n    else if(nPlanet == 20)\r\n    {\r\n        PlayMovie("05_4a");\r\n    }\r\n    else if(nPlanet == 25)\r\n    {\r\n        PlayMovie("05_5a");\r\n    }\r\n    else if(nPlanet == 30)\r\n    {\r\n        PlayMovie("05_7a");\r\n    }\r\n    else if(nPlanet == 35)\r\n    {\r\n        PlayMovie("05_3a");\r\n    }\r\n    else if(nPlanet == 40)\r\n    {\r\n        //PlayMovie("");\r\n    }\r\n    else if(nPlanet == 45)\r\n    {\r\n        PlayMovie("05_8a");\r\n    }\r\n    return "NULL";\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Does the PC need equipment\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks the PCs inventory and determines based\r\n    on OBJECT_SELF whether the PC needs equipment\r\n    Returns true if the PC has enough of the selected\r\n    item.\r\n\r\n    The number of items given out is now tracked as\r\n    of Feb 25, 2003.  The NPCs will not give out\r\n    more items than the current setting of the\r\n    star map variable + 5.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 19, 2002\r\n//:://////////////////////////////////////////////\r\nint EBO_GetIsEquipmentNeeded()\r\n{\r\n    int nNumber, nGlobal;\r\n    string sTag = GetTag(OBJECT_SELF);\r\n    int nStarMap = (GetGlobalNumber("K_STAR_MAP")*2) + 10;\r\n    if(sTag == "zaalbar")\r\n    {\r\n        nNumber = EBO_CheckInventoryNumbers("G_w_StunGren01","g_w_iongren01","g_w_adhsvgren001");\r\n        nGlobal = GetGlobalNumber("K_ZAALBAR_ITEMS");\r\n        if((nNumber <= 10 && nGlobal < nStarMap) || nGlobal == 0)\r\n        {\r\n            return FALSE;\r\n        }\r\n        return TRUE;\r\n    }\r\n    else if(sTag == "jolee")\r\n    {\r\n        nNumber = EBO_CheckInventoryNumbers("g_I_medeqpmnt01","G_I_MEDEQPMNT02","g_I_medeqpmnt03");\r\n        nGlobal = GetGlobalNumber("K_JOLEE_ITEMS");\r\n        if((nNumber <= 10 && nGlobal < nStarMap) || nGlobal == 0)\r\n        {\r\n            return FALSE;\r\n        }\r\n        return TRUE;\r\n    }\r\n    else if(sTag == "mission")\r\n    {\r\n        nNumber = EBO_CheckInventoryNumbers("g_i_secspike01","G_I_SECSPIKE02");\r\n        nGlobal = GetGlobalNumber("K_MISSION_ITEMS");\r\n        if((nNumber <= 10 && nGlobal <= nStarMap) || nGlobal == 0)\r\n        {\r\n            return FALSE;\r\n        }\r\n        return TRUE;\r\n    }\r\n    else if(sTag == "cand")\r\n    {\r\n        nNumber = EBO_CheckInventoryNumbers("g_i_adrnaline001","G_I_ADRNALINE002","g_i_adrnaline003", "g_i_cmbtshot001");\r\n        nGlobal = GetGlobalNumber("K_CAND_ITEMS");\r\n\r\n        PrintString("Number = " + IntToString(nNumber));\r\n        PrintString("Global = " + IntToString(nGlobal));\r\n        PrintString("StarMap = " + IntToString(nStarMap));\r\n\r\n        if((nNumber <= 10 && nGlobal <= nStarMap) || nGlobal == 0)\r\n        {\r\n            return FALSE;\r\n        }\r\n        return TRUE;\r\n    }\r\n    else if(sTag == "t3m4")\r\n    {\r\n        nNumber = EBO_CheckInventoryNumbers("K_COMPUTER_SPIKE");\r\n        nGlobal = GetGlobalNumber("K_T3M4_ITEMS");\r\n\r\n        if((nNumber <= 10 && nGlobal <= nStarMap) || nGlobal == 0)\r\n        {\r\n            return FALSE;\r\n        }\r\n        return TRUE;\r\n    }\r\n    return TRUE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: NPC Item Creation\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Determines who the person being talked to is\r\n    and what items the character should receive.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 19, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid EBO_CreateEquipmentOnPC()\r\n{\r\n    int nCount;\r\n    string sTag = GetTag(OBJECT_SELF);\r\n    object oProxy;\r\n    if(sTag == "zaalbar")\r\n    {\r\n        int nRand = d3();\r\n        if(nRand == 1)\r\n        {\r\n            oProxy = CreateItemOnObject("g_w_stungren01", GetFirstPC());\r\n        }\r\n        else if(nRand == 2)\r\n        {\r\n            oProxy = CreateItemOnObject("g_w_iongren01", GetFirstPC());\r\n        }\r\n        else if(nRand == 3)\r\n        {\r\n            oProxy = CreateItemOnObject("g_w_adhsvgren001", GetFirstPC());\r\n        }\r\n        nCount = GetGlobalNumber("K_ZAALBAR_ITEMS");\r\n        nCount++;\r\n        SetGlobalNumber("K_ZAALBAR_ITEMS", nCount);\r\n    }\r\n    else if(sTag == "jolee")\r\n    {\r\n        int nLevel = GetHitDice(GetFirstPC());\r\n        if(nLevel <= 4)\r\n        {\r\n            oProxy = CreateItemOnObject("G_I_MEDEQPMNT01", GetFirstPC());\r\n        }\r\n        else if(nLevel > 4 && nLevel <= 10)\r\n        {\r\n            oProxy = CreateItemOnObject("G_I_MEDEQPMNT02", GetFirstPC());\r\n        }\r\n        else if(nLevel > 10)\r\n        {\r\n            oProxy = CreateItemOnObject("G_I_MEDEQPMNT03", GetFirstPC());\r\n        }\r\n        nCount = GetGlobalNumber("K_JOLEE_ITEMS");\r\n        nCount++;\r\n        SetGlobalNumber("K_JOLEE_ITEMS", nCount);\r\n    }\r\n    else if(sTag == "mission")\r\n    {\r\n        int nLevel = GetHitDice(GetFirstPC());\r\n        if(nLevel <= 7)\r\n        {\r\n            oProxy = CreateItemOnObject("g_i_secspike01", GetFirstPC());\r\n        }\r\n        else if(nLevel > 7)\r\n        {\r\n            oProxy = CreateItemOnObject("g_i_secspike02", GetFirstPC());\r\n        }\r\n        nCount = GetGlobalNumber("K_MISSION_ITEMS");\r\n        nCount++;\r\n        SetGlobalNumber("K_MISSION_ITEMS", nCount);\r\n    }\r\n    else if(sTag == "cand")\r\n    {\r\n        int nRand = d4();\r\n\r\n        if(nRand == 1)\r\n        {\r\n            oProxy = CreateItemOnObject("G_I_ADRNALINE001", GetFirstPC());\r\n        }\r\n        else if(nRand == 2)\r\n        {\r\n            oProxy = CreateItemOnObject("G_I_ADRNALINE002", GetFirstPC());\r\n        }\r\n        else if(nRand == 3)\r\n        {\r\n            oProxy = CreateItemOnObject("G_I_ADRNALINE003", GetFirstPC());\r\n        }\r\n        else if(nRand == 4)\r\n        {\r\n            oProxy = CreateItemOnObject("G_I_CMBTSHOT001", GetFirstPC());\r\n        }\r\n        nCount = GetGlobalNumber("K_CAND_ITEMS");\r\n        nCount++;\r\n        SetGlobalNumber("K_CAND_ITEMS", nCount);\r\n    }\r\n    else if(sTag == "t3m4")\r\n    {\r\n        oProxy = CreateItemOnObject("G_I_PROGSPIKE01", GetFirstPC());\r\n        nCount = GetGlobalNumber("K_T3M4_ITEMS");\r\n        nCount++;\r\n        SetGlobalNumber("K_T3M4_ITEMS", nCount);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Count Inventory Items\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Counts and totals up to four different items\r\n    within the PCs inventory.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 19, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint EBO_CheckInventoryNumbers(string sTag1, string sTag2 = "", string sTag3 = "", string sTag4 = "")\r\n{\r\n    int nNumber;\r\n    object oGrenade;\r\n    if(sTag1 != "")\r\n    {\r\n        oGrenade = GetItemPossessedBy(GetFirstPC(), sTag1);\r\n        if(GetIsObjectValid(oGrenade))\r\n        {\r\n            nNumber += GetNumStackedItems(oGrenade);\r\n        }\r\n    }\r\n    if(sTag2 != "")\r\n    {\r\n        oGrenade = GetItemPossessedBy(GetFirstPC(), sTag2);\r\n        if(GetIsObjectValid(oGrenade))\r\n        {\r\n            nNumber += GetNumStackedItems(oGrenade);\r\n        }\r\n    }\r\n    if(sTag3 != "")\r\n    {\r\n        oGrenade = GetItemPossessedBy(GetFirstPC(), sTag3);\r\n        if(GetIsObjectValid(oGrenade))\r\n        {\r\n            nNumber += GetNumStackedItems(oGrenade);\r\n        }\r\n    }\r\n    if(sTag4 != "")\r\n    {\r\n        oGrenade = GetItemPossessedBy(GetFirstPC(), sTag4);\r\n        if(GetIsObjectValid(oGrenade))\r\n        {\r\n            nNumber += GetNumStackedItems(oGrenade);\r\n        }\r\n    }\r\n    return nNumber;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Planet Constant\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Uses K_CURRENT_PLANET to return the current\r\n    planets scripting constant\r\n    0    Endar Spire     5\r\n    1    Taris           10\r\n    2    Dantooine       15\r\n    3    --Kashyyk       20\r\n    4    --Manaan        25\r\n    5    --Korriban      30\r\n    6    --Tatooine      35\r\n    7    Leviathan       40\r\n    8    Unknown World   45\r\n    9    Star Forge      50\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Dec 1, 2002\r\n//:://////////////////////////////////////////////\r\nint EBO_GetCurrentPlanet()\r\n{\r\n    int nPlanet = GetGlobalNumber("K_CURRENT_PLANET");\r\n    if(nPlanet == 5)\r\n    {\r\n        return PLANET_ENDAR_SPIRE;\r\n    }\r\n    else if(nPlanet == 10)\r\n    {\r\n        return PLANET_TARIS;\r\n    }\r\n    else if(nPlanet == 15)\r\n    {\r\n        return PLANET_DANTOOINE;\r\n    }\r\n    else if(nPlanet == 20)\r\n    {\r\n        return PLANET_KASHYYYK;\r\n    }\r\n    else if(nPlanet == 25)\r\n    {\r\n        return PLANET_MANAAN;\r\n    }\r\n    else if(nPlanet == 30)\r\n    {\r\n        return PLANET_KORRIBAN;\r\n    }\r\n    else if(nPlanet == 35)\r\n    {\r\n        return PLANET_TATOOINE;\r\n    }\r\n    else if(nPlanet == 40)\r\n    {\r\n        return PLANET_LEVIATHAN;\r\n    }\r\n    else if(nPlanet == 45)\r\n    {\r\n        return PLANET_UNKNOWN_WORLD;\r\n    }\r\n    else if(nPlanet == 50)\r\n    {\r\n        return PLANET_STAR_FORGE;\r\n    }\r\n    return -1;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Planet Constant\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Uses K_FUTURE_PLANET to return the current\r\n    planets scripting constant\r\n    0    Endar Spire     5\r\n    1    Taris           10\r\n    2    Dantooine       15\r\n    3    --Kashyyk       20\r\n    4    --Manaan        25\r\n    5    --Korriban      30\r\n    6    --Tatooine      35\r\n    7    Leviathan       40\r\n    8    Unknown World   45\r\n    9    Star Forge      50\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Dec 1, 2002\r\n//:://////////////////////////////////////////////\r\nint EBO_GetFuturePlanet()\r\n{\r\n    int nPlanet = GetGlobalNumber("K_FUTURE_PLANET");\r\n    if(nPlanet == 5)\r\n    {\r\n        return PLANET_ENDAR_SPIRE;\r\n    }\r\n    else if(nPlanet == 10)\r\n    {\r\n        return PLANET_TARIS;\r\n    }\r\n    else if(nPlanet == 15)\r\n    {\r\n        return PLANET_DANTOOINE;\r\n    }\r\n    else if(nPlanet == 20)\r\n    {\r\n        return PLANET_KASHYYYK;\r\n    }\r\n    else if(nPlanet == 25)\r\n    {\r\n        return PLANET_MANAAN;\r\n    }\r\n    else if(nPlanet == 30)\r\n    {\r\n        return PLANET_KORRIBAN;\r\n    }\r\n    else if(nPlanet == 35)\r\n    {\r\n        return PLANET_TATOOINE;\r\n    }\r\n    else if(nPlanet == 40)\r\n    {\r\n        return PLANET_LEVIATHAN;\r\n    }\r\n    else if(nPlanet == 45)\r\n    {\r\n        return PLANET_UNKNOWN_WORLD;\r\n    }\r\n    else if(nPlanet == 50)\r\n    {\r\n        return PLANET_STAR_FORGE;\r\n    }\r\n    else if(nPlanet == 55)\r\n    {\r\n        return PLANET_LIVE_01;\r\n    }\r\n    else if(nPlanet == 60)\r\n    {\r\n        return PLANET_LIVE_02;\r\n    }\r\n    else if(nPlanet == 65)\r\n    {\r\n        return PLANET_LIVE_03;\r\n    }\r\n    else if(nPlanet == 70)\r\n    {\r\n        return PLANET_LIVE_04;\r\n    }\r\n    else if(nPlanet == 75)\r\n    {\r\n        return PLANET_LIVE_05;\r\n    }\r\n    return -1;\r\n}\r\n\r\n\r\nint EBO_GetPlanetFrom2DA(int nPlanetIndex)\r\n{\r\n/*Scripting Constants              2DA Values\r\nint PLANET_ENDAR_SPIRE      = 0;   0          Endar_Spire\r\nint PLANET_TARIS            = 1;   1          Taris\r\nint PLANET_EBON_HAWK        = 2;   2          Ebon_Hawk\r\nint PLANET_DANTOOINE        = 3;   3          Dantooine\r\nint PLANET_TATOOINE         = 4;   4          Tatooine\r\nint PLANET_KASHYYYK         = 5;   5          Kashyyyk\r\nint PLANET_MANAAN           = 6;   6          Manaan\r\nint PLANET_KORRIBAN         = 7;   7          Korriban\r\nint PLANET_LEVIATHAN        = 8;   8          Leviathan\r\nint PLANET_UNKNOWN_WORLD    = 9;   9          Unknown_World\r\nint PLANET_STAR_FORGE       = 10;  10         Star_Forge\r\n\r\nPlot Values\r\n0    Endar Spire     5\r\n1    Taris           10\r\n3    Dantooine       15\r\n5    --Kashyyk       20\r\n6    --Manaan        25\r\n7    --Korriban      30\r\n4    --Tatooine      35\r\n8    Leviathan       40\r\n9    Unknown World   45\r\n10   Star Forge      50\r\n\r\n*/\r\n    if(nPlanetIndex == PLANET_ENDAR_SPIRE)\r\n    {\r\n        return 5;\r\n    }\r\n    else if(nPlanetIndex == PLANET_TARIS)\r\n    {\r\n        return 10;\r\n    }\r\n    else if(nPlanetIndex == PLANET_EBON_HAWK)\r\n    {\r\n        return -1;\r\n    }\r\n    else if(nPlanetIndex == PLANET_DANTOOINE)\r\n    {\r\n        return 15;\r\n    }\r\n    else if(nPlanetIndex == PLANET_TATOOINE)\r\n    {\r\n        return 35;\r\n    }\r\n    else if(nPlanetIndex == PLANET_KASHYYYK)\r\n    {\r\n        return 20;\r\n    }\r\n    else if(nPlanetIndex == PLANET_MANAAN)\r\n    {\r\n        return 25;\r\n    }\r\n    else if(nPlanetIndex == PLANET_KORRIBAN)\r\n    {\r\n        return 30;\r\n    }\r\n    else if(nPlanetIndex == PLANET_LEVIATHAN)\r\n    {\r\n        return 40;\r\n    }\r\n    else if(nPlanetIndex == PLANET_UNKNOWN_WORLD)\r\n    {\r\n        return 45;\r\n    }\r\n    else if(nPlanetIndex == PLANET_STAR_FORGE)\r\n    {\r\n        return 50;\r\n    }\r\n    else if(nPlanetIndex == PLANET_LIVE_01)\r\n    {\r\n        return 55;\r\n    }\r\n    else if(nPlanetIndex == PLANET_LIVE_02)\r\n    {\r\n        return 60;\r\n    }\r\n    else if(nPlanetIndex == PLANET_LIVE_03)\r\n    {\r\n        return 65;\r\n    }\r\n    else if(nPlanetIndex == PLANET_LIVE_04)\r\n    {\r\n        return 70;\r\n    }\r\n    else if(nPlanetIndex == PLANET_LIVE_05)\r\n    {\r\n        return 75;\r\n    }\r\n    return -1;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Start Render/Stunt Sequence\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Starts the correct sequence based on the\r\n    planet being traveled to.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Dec 9, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid EBO_PlayRenderSequence()\r\n{\r\n    int nSelected = GetSelectedPlanet();\r\n    nSelected = EBO_GetPlanetFrom2DA(nSelected);\r\n    SetGlobalNumber("K_FUTURE_PLANET", nSelected);\r\n    int nCurrent = GetGlobalNumber("K_CURRENT_PLANET");\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Should Bastila Start Vision Conversation\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This function returns true if bastila should\r\n    start a cutscene dialogue with the PC\r\n    You can use k_vis_[PLANET] == FALSE to see\r\n    if they have been their before and seen the\r\n    planet vision. This applies to Dantooine,\r\n    Manaan, Korriban, Tatooine and Kashyyyk.\r\n\r\n    Also set the script so that if Ebon_Vision !=99\r\n    then it fires the dialog file ebo_bast_vision\r\n    and has Bastila init dialog on the Ebon Hawk.\r\n    (If Ebon_Vision==99 the dialog will not fire,\r\n    but it should still play the vision.\r\n    15 to 35\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 3, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint EBO_ShouldBastilaStartConversation()\r\n{\r\n    int nPlanet = GetGlobalNumber("K_CURRENT_PLANET");\r\n    int nVision = GetGlobalNumber("Ebon_Vision");\r\n    int nFLAG = FALSE;\r\n    if( (nPlanet == 15 || nPlanet == 20 || nPlanet == 25 || nPlanet == 30 || nPlanet == 35) && nVision != 99)\r\n    {\r\n        //object oBast = GetNearestObjectByTag("Bastila");\r\n        //if(GetIsObjectValid(oBast))\r\n        //{\r\n            if(nPlanet == 15 && !GetGlobalBoolean("k_vis_dantooine"))\r\n            {\r\n                nFLAG = TRUE;\r\n                SetGlobalBoolean("k_vis_dantooine",1);\r\n            }\r\n            else if(nPlanet == 20 && !GetGlobalBoolean("k_vis_kashyyyk"))\r\n            {\r\n                nFLAG = TRUE;\r\n                SetGlobalBoolean("k_vis_kashyyyk",1);\r\n            }\r\n            else if(nPlanet == 25 && !GetGlobalBoolean("k_vis_manaan"))\r\n            {\r\n                nFLAG = TRUE;\r\n                SetGlobalBoolean("k_vis_manaan",1);\r\n            }\r\n            else if(nPlanet == 30 && !GetGlobalBoolean("k_vis_korriban"))\r\n            {\r\n                nFLAG = TRUE;\r\n                SetGlobalBoolean("k_vis_korriban",1);\r\n            }\r\n            else if(nPlanet == 35 && !GetGlobalBoolean("k_vis_tatooine"))\r\n            {\r\n                nFLAG = TRUE;\r\n                SetGlobalBoolean("k_vis_tatooine",1);\r\n            }\r\n            if(nFLAG == TRUE)\r\n            {\r\n                //AurPostString("k_vis_kashyyyk = " + IntToString(GetGlobalBoolean("k_vis_kashyyyk")), 5, 6, 3.0);\r\n                //AurPostString("k_vis_manaan = " + IntToString(GetGlobalBoolean("k_vis_manaan")), 5, 7, 3.0);\r\n                //AurPostString("k_vis_korriban = " + IntToString(GetGlobalBoolean("k_vis_korriban")), 5, 8, 3.0);\r\n                //AurPostString("k_vis_tatooine = " + IntToString(GetGlobalBoolean("k_vis_tatooine")), 5, 9, 3.0);\r\n\r\n                return TRUE;\r\n                //HoldWorldFadeInForDialog();\r\n                //object oPC = GetFirstPC();\r\n                //AssignCommand(oBast, ActionStartConversation(oPC, "ebo_bast_vision", FALSE, CONVERSATION_TYPE_CINEMATIC, TRUE));\r\n            }\r\n        //}\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Bastila Start Conversation\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: June 17,\r\n//:://////////////////////////////////////////////\r\n\r\nvoid EBO_BastilaStartConversation2()\r\n{\r\n    object oPC = GetFirstPC();\r\n    object oBast = GetNearestObjectByTag("Bastila_Starter");\r\n    if(GetIsObjectValid(oBast))\r\n    {\r\n        //AurPostString("Ebon_Vision = " + IntToString(GetGlobalNumber("Ebon_Vision")), 5, 6, 4.0);\r\n        //AurPostString("Firing Bastila\'s Conversation", 5, 7, 4.0);\r\n        AssignCommand(oBast, ActionStartConversation(oPC, "ebo_bast_vision", FALSE, CONVERSATION_TYPE_CINEMATIC, TRUE, "Bastila"));\r\n    }\r\n}\r\n', 'k_inc_end': b'#include "k_inc_utility"\r\n#include "k_inc_generic"\r\n\r\nstring sTraskTag = "end_trask";\r\nstring sTraskWP = "endwp_tarsk01";\r\nstring sCarthTag = "Carth";\r\n\r\nstring SOLDIER_WEAPON = "g_w_blstrrfl001";\r\nstring SOLDIER_ITEM01 = "g_i_adrnaline003";\r\nstring SOLDIER_ITEM02 = "";\r\n\r\nstring SCOUT_WEAPON = "g_w_blstrpstl001";\r\nstring SCOUT_ITEM01 = "g_i_adrnaline002";\r\nstring SCOUT_ITEM02 = "g_i_implant101";\r\n\r\nstring SCOUNDREL_WEAPON = "g_w_blstrpstl001";\r\nstring SCOUNDREL_ITEM01 = "g_i_secspike01";\r\nstring SCOUNDREL_ITEM02 = "g_i_progspike01";\r\n\r\nint ROOM3_DEAD = 3;\r\nint ROOM5_DEAD = 4;\r\nint ROOM7_DEAD = 2;\r\n\r\nint TRASK_DEFAULT = -1;\r\nint TRASK_MUST_GET_GEAR = 0;\r\nint TRASK_GEAR_DONE = 1;\r\nint TRASK_TARGET_DONE = 2;\r\nint TRASK_MUST_EQUIP = 3;\r\nint TRASK_EQUIP_DONE = 4;\r\nint TRASK_MUST_MAP = 5;\r\nint TRASK_MAP_DONE = 6;\r\nint TRASK_MUST_SWITCH = 7;\r\nint TRASK_SWITCH_DONE = 8;\r\nint TRASK_SWITCH_REMIND = 9;\r\nint TRASK_CARTH_BRIDGE = 10;\r\nint TRASK_BRIDGE_DONE = 11;\r\nint TRASK_MUST_DOOR = 12;\r\nint TRASK_DOOR_DONE = 13;\r\nint TRASK_ROOM3_DONE = 14;\r\nint TRASK_MUST_MEDPACK = 15;\r\nint TRASK_COMBAT_WARNING = 16;\r\nint TRASK_COMBAT_WARNING2 = 17;\r\nint TRASK_COMPUTER_DONE = 18;\r\nint TRASK_MUST_DROID = 19;\r\nint TRASK_DROID_DONE = 20;\r\nint TRASK_MUST_MAP_02 = 21;\r\nint TRASK_NOTHING_02 = 22;\r\n//int TRASK_COMBAT_WARNING = 27;\r\nint TRASK_LEVEL_INIT = 28;\r\nint TRASK_MUST_LEVEL = 29;\r\nint TRASK_PARTY_LEVEL = 30;\r\nint TRASK_LEVEL_DONE = 31;\r\nstring LOCKER_TAG = "end_locker01";\r\nstring STEALTH_UNIT = "g_i_belt010";\r\n//returns Trask\'s object id\r\nobject GetTrask();\r\n\r\n// checks if the conditions for passing the healing stage have been met\r\nint HealingDone();\r\n\r\n// returns Carth\'s object id\r\nobject GetCarth();\r\n\r\n// checks if this has never been done before. uses sw 10\r\nint HasNeverTriggered();\r\n\r\n// Has Trask initiate with the pc at any distance\r\nvoid TalkTrask();\r\n\r\n// returns the effect from the corridor explosion\r\neffect CorridorExplosion();\r\n\r\n//spawns equipment into the first locker dependent on the players class\r\nvoid SpawnStartingEquipment();\r\n\r\n// returns if the door has been sliced (uses plot 2)\r\nint GetIsSecureDoorSliced(object oDoor = OBJECT_SELF);\r\n\r\n// sets the slice state of the door (uses plot 2)\r\nvoid SetSecureDoorSliced(int bState, object oDoor = OBJECT_SELF);\r\n\r\n// returns if the door has been repaired (uses plot 3)\r\nint GetIsDamagedDoorRepaired(object oDoor = OBJECT_SELF);\r\n\r\n// sets the repaired state of the door (uses plot 3)\r\nvoid SetDamagedDoorRepaired(int bState, object oDoor = OBJECT_SELF);\r\n\r\n// returns the value of the trask dialouge state global\r\nint GetTraskState();\r\n\r\n//sets the trask dialouge global\r\nvoid SetTraskState(int nValue);\r\n\r\n// returns true if there is somethin equipped in the weapon or body slots\r\nint GetHasEquippedSomething();\r\n\r\n// Checks if Trask is already waiting to initiate\r\nint GetTraskWillInitiate();\r\n\r\n// Sets the flag for Trask waiting to initiate\r\nvoid SetTraskWillInitiate(int nValue);\r\n\r\n//returns Carth dialgue state\r\nint GetCarthState();\r\n\r\n//sets Carth dialogue state\r\nvoid SetCarthState(int nValue);\r\n\r\n// plays an explosion\r\nvoid PlayExplosion(string sWP = "end_explode01", int bWithShake = TRUE, int bWithRumble = TRUE);\r\n\r\n//returns a cutscene invisible placeable based on the given number\r\nobject GetCutsceneObject(int nObjectNumber);\r\n//////////////////////////////////////////////////////////////////////////\r\n\r\n\r\nobject GetTrask()\r\n{\r\n    return GetObjectByTag(sTraskTag);\r\n}\r\n\r\nint HealingDone()\r\n{\r\n    int bDone;\r\n    object oPC = GetFirstPC();\r\n    int bHasMedPack = GetIsObjectValid(GetItemPossessedBy(oPC,"g_i_medeqpmnt01"));\r\n    int bFullHitPoints = GetCurrentHitPoints(oPC) == GetMaxHitPoints(oPC);\r\n    if(bFullHitPoints || bHasMedPack == FALSE)\r\n    {\r\n\r\n        bDone = TRUE;\r\n    }\r\n    return bDone;\r\n}\r\n\r\nobject GetCarth()\r\n{\r\n    return GetObjectByTag("Carth");\r\n}\r\n\r\nint HasNeverTriggered()\r\n{\r\n    int bReturn;\r\n    if(UT_GetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_10) == FALSE)\r\n    {\r\n        bReturn = TRUE;\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_10,TRUE);\r\n    }\r\n    return bReturn;\r\n}\r\n\r\nvoid TalkTrask()\r\n{\r\n    object oTrask = GetTrask();\r\n    if(GetPartyMemberByIndex(0) == oTrask)\r\n    {\r\n        SetPartyLeader(NPC_PLAYER);\r\n    }\r\n   // AurPostString("Trask trying to talk" + IntToString(GetTraskState()),5,5,5.0);\r\n    NoClicksFor(0.5);\r\n    DelayCommand(0.1,SignalEvent(oTrask,EventUserDefined(50)));\r\n}\r\n\r\neffect CorridorExplosion()\r\n{\r\n    effect eZap = EffectBeam(VFX_BEAM_LIGHTNING_DARK_L,GetObjectByTag("end_zap01"),BODY_NODE_CHEST);\r\n    return EffectLinkEffects(EffectDamage(5),eZap);\r\n}\r\n\r\nobject GetSpeaker()\r\n{\r\n    return GetPartyMemberByIndex(1);\r\n}\r\n\r\nobject GetListener()\r\n{\r\n    return GetPartyMemberByIndex(0);\r\n}\r\n\r\nvoid SpawnStartingEquipment()\r\n{\r\n    object oLocker = GetObjectByTag(LOCKER_TAG);\r\n    int nClass = GetClassByPosition(1,GetFirstPC());\r\n    if(nClass == CLASS_TYPE_SCOUNDREL)\r\n    {\r\n        CreateItemOnObject(SCOUNDREL_WEAPON,oLocker);\r\n        CreateItemOnObject(SCOUNDREL_ITEM01,oLocker);\r\n        CreateItemOnObject(SCOUNDREL_ITEM02,oLocker);\r\n    }\r\n    else if(nClass == CLASS_TYPE_SCOUT)\r\n    {\r\n        CreateItemOnObject(SCOUT_WEAPON,oLocker);\r\n        CreateItemOnObject(SCOUT_ITEM01,oLocker);\r\n        CreateItemOnObject(SCOUT_ITEM02,oLocker);\r\n    }\r\n    else if(nClass == CLASS_TYPE_SOLDIER)\r\n    {\r\n        CreateItemOnObject(SOLDIER_WEAPON,oLocker);\r\n        CreateItemOnObject(SOLDIER_ITEM01,oLocker);\r\n        CreateItemOnObject(SOLDIER_ITEM02,oLocker);\r\n    }\r\n\r\n    if(GetHasSkill(SKILL_STEALTH,GetFirstPC()))\r\n    {\r\n        CreateItemOnObject(STEALTH_UNIT,oLocker);\r\n    }\r\n}\r\n\r\nint GetIsSecureDoorSliced(object oDoor = OBJECT_SELF)\r\n{\r\n    return UT_GetPlotBooleanFlag(oDoor,SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetSecureDoorSliced(int bState, object oDoor = OBJECT_SELF)\r\n{\r\n    UT_SetPlotBooleanFlag(oDoor,SW_PLOT_BOOLEAN_02,bState);\r\n}\r\n\r\nint GetIsDamagedDoorRepaired(object oDoor = OBJECT_SELF)\r\n{\r\n    return UT_GetPlotBooleanFlag(oDoor,SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetDamagedDoorRepaired(int bState, object oDoor = OBJECT_SELF)\r\n{\r\n    UT_SetPlotBooleanFlag(oDoor,SW_PLOT_BOOLEAN_03,bState);\r\n}\r\n\r\nint GetTraskState()\r\n{\r\n    return GetGlobalNumber("END_TRASK_DLG");\r\n}\r\n\r\nvoid SetTraskState(int nValue)\r\n{\r\n  //  AurPostString("New State" + IntToString(nValue),5,7,2.0);\r\n    SetGlobalNumber("END_TRASK_DLG",nValue);\r\n   // AurPostString("Set: " + IntToString(nValue),5,10,3.0);\r\n}\r\n\r\nint GetHasEquippedSomething()\r\n{\r\n    int bItemEquipped = FALSE;\r\n    object oPC = GetFirstPC();\r\n    if(GetIsObjectValid(GetItemInSlot(INVENTORY_SLOT_RIGHTWEAPON,oPC)) ||\r\n       GetIsObjectValid(GetItemInSlot(INVENTORY_SLOT_LEFTWEAPON,oPC)) ||\r\n       GetIsObjectValid(GetItemInSlot(INVENTORY_SLOT_BODY,oPC)) )\r\n    {\r\n            bItemEquipped = TRUE;\r\n    }\r\n    return bItemEquipped;\r\n}\r\n\r\nint GetTraskWillInitiate()\r\n{\r\n    return UT_GetPlotBooleanFlag(GetTrask(),SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetTraskWillInitiate(int nValue)\r\n{\r\n    UT_SetPlotBooleanFlag(GetTrask(),SW_PLOT_BOOLEAN_03,nValue);\r\n}\r\n\r\nint GetCarthState()\r\n{\r\n    return GetGlobalNumber("END_CARTH_DLG");\r\n}\r\n\r\nvoid SetCarthState(int nValue)\r\n{\r\n    SetGlobalNumber("END_CARTH_DLG",nValue);\r\n}\r\n\r\nvoid PlayExplosion(string sWP = "end_explode01", int bWithShake = TRUE, int bWithRumble = TRUE)\r\n{\r\n    location lExplode = GetLocation(GetNearestObjectByTag(sWP));\r\n    effect eExplode = EffectVisualEffect(VFX_FNF_GRENADE_FRAGMENTATION);\r\n    effect eShake = EffectVisualEffect(VFX_IMP_SCREEN_SHAKE);\r\n    ApplyEffectAtLocation(DURATION_TYPE_INSTANT,eExplode,lExplode);\r\n    if(bWithShake)\r\n    {\r\n        ApplyEffectToObject(DURATION_TYPE_INSTANT,eShake,GetFirstPC());\r\n    }\r\n    if(bWithRumble)\r\n    {\r\n        PlayRumblePattern(14);\r\n    }\r\n}\r\n\r\nobject GetCutsceneObject(int nObjectNumber)\r\n{\r\n    return GetObjectByTag("end01_sceneobj0" + IntToString(nObjectNumber));\r\n}\r\n', 'k_inc_endgame': b'//::///////////////////////////////////////////////\r\n//:: Name k_inc_endgame\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n     This include houses all of the stunt/render\r\n     calls for the end game. This will be for\r\n     modules sta_m45ac and sta_m45ad.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Brad Prince\r\n//:: Created On: Mar 6, 2003\r\n//:://////////////////////////////////////////////\r\n\r\n///////////////////////\r\n// LIGHT SIDE scenes //\r\n///////////////////////\r\n\r\n// SCENE 1 BO2 - Player kills Bastila on sta_m45ac\r\nvoid ST_PlayBastilaLight();\r\n// SCENE 2 C01 - Player returns after watching SCENE 1.\r\nvoid ST_PlayReturnToStarForgeLight();\r\n// SCENE 3 A - Star Forge under attack.\r\nvoid ST_PlayStarForgeUnderAttack();\r\n// SCENE 4 B - End game credits - Light.\r\nvoid ST_PlayEndCreditsLight();\r\n\r\n//////////////////////////////////////////////////\r\n\r\n//////////////////////\r\n// DARK SIDE scenes //\r\n//////////////////////\r\n\r\n// SCENE 1 B01 - Bastila leaves party to meditate before generator puzzle.\r\nvoid ST_PlayBastilaDark();\r\n// SCENE 2 C - Player returns after watching SCENE 1.\r\nvoid ST_PlayReturnToStarForgeDark();\r\n// SCENE 3 A - The Republic dies.\r\nvoid ST_PlayRepublicDies();\r\n// SCENE 4 B - The Sith Ceremony.\r\nvoid ST_PlaySithCeremony();\r\n// SCENE 5 C - End game credits - Dark.\r\nvoid ST_PlayEndCreditsDark();\r\n\r\n//////////////////////////////////////////////////\r\n//                  FUNCTIONS                   //\r\n//////////////////////////////////////////////////\r\n\r\n///////////////////////\r\n// LIGHT SIDE scenes //\r\n///////////////////////\r\n\r\n// SCENE 1 BO2 - Player kills Bastila on sta_m45ac\r\nvoid ST_PlayBastilaLight()\r\n{\r\n    StartNewModule("STUNT_50a","", "50b");\r\n}\r\n\r\n// SCENE 2 C01 - Player returns after watching SCENE 1.\r\nvoid ST_PlayReturnToStarForgeLight()\r\n{\r\n    StartNewModule("sta_m45ac","K_LAST_LOCATION", "50");\r\n}\r\n\r\n// SCENE 3 A - Star Forge under attack.\r\nvoid ST_PlayStarForgeUnderAttack()\r\n{\r\n    StartNewModule("STUNT_56a","", "56");\r\n}\r\n\r\n// SCENE 4 B - End game credits - Light.\r\nvoid ST_PlayEndCreditsLight()\r\n{\r\n    StartNewModule("STUNT_57","", "56b");\r\n}\r\n\r\n//////////////////////////////////////////////////\r\n\r\n//////////////////////\r\n// DARK SIDE scenes //\r\n//////////////////////\r\n\r\n// SCENE 1 B01 - Bastila leaves party to meditate before generator puzzle.\r\nvoid ST_PlayBastilaDark()\r\n{\r\n    StartNewModule("STUNT_51a","", "54");\r\n}\r\n\r\n// SCENE 2 C - Player returns after watching SCENE 1.\r\nvoid ST_PlayReturnToStarForgeDark()\r\n{\r\n    StartNewModule("sta_m45ac","sta_bast_pc_move0", "51b");\r\n}\r\n\r\n// SCENE 3 A - The Republic dies.\r\nvoid ST_PlayRepublicDies()\r\n{\r\n    StartNewModule("STUNT_54a","", "51");\r\n}\r\n\r\n// SCENE 4 B - The Sith Ceremony.\r\nvoid ST_PlaySithCeremony()\r\n{\r\n    StartNewModule("STUNT_55a","", "54b");\r\n}\r\n\r\n// SCENE 5 C - End game credits - Dark.\r\nvoid ST_PlayEndCreditsDark()\r\n{\r\n    StartNewModule("STUNT_57","", "56b");\r\n}\r\n', 'k_inc_force': b'//:: k_inc_force\r\n/*\r\n    v1.0\r\n    Force Powers Include for KOTOR\r\n*/\r\n//:: Created By: Preston Watamaniuk\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n\r\nfloat fLightningDuration = 1.0;\r\n\r\n//These variables are set in the script run area.\r\nint SWFP_PRIVATE_SAVE_TYPE;\r\nint SWFP_PRIVATE_SAVE_VERSUS_TYPE;\r\nint SWFP_DAMAGE;\r\nint SWFP_DAMAGE_TYPE;\r\nint SWFP_DAMAGE_VFX;\r\nint SWFP_HARMFUL;\r\nint SWFP_SHAPE;\r\n\r\n//Runs the script section for the particular force power.\r\nvoid  Sp_RunForcePowers();\r\n//Immunity and Resist Spell check for the force power.\r\n//The eDamage checks whether the target is immune to the damage effect\r\nint Sp_BlockingChecks(object oTarget, effect eEffect, effect eEffect2, effect eDamage);\r\n//Makes the necessary saving throws\r\nint Sp_MySavingThrows(object oTarget);\r\n//Remove an effect of a specific type\r\nvoid Sp_RemoveSpecificEffect(int nEffectTypeID, object oTarget);\r\n//Remove an effect from a specific force power.\r\nvoid Sp_RemoveSpellEffects(int nSpell_ID, object oCaster, object oTarget);\r\n// Delays the application of a spell effect by an amount determined by distance.\r\nfloat Sp_GetSpellEffectDelay(location SpellTargetLocation, object oTarget);\r\n//Randomly delays the effect application for a default of 0.0 to 0.75 seconds\r\nfloat Sp_GetRandomDelay(float fMinimumTime = 0.0, float MaximumTime = 0.75);\r\n//Gets a saving throw appropriate to the jedi using the force power.\r\nint Sp_GetJediDCSave();\r\n///Apply effects in a sphere shape.\r\nvoid Sp_SphereSaveHalf(object oAnchor, float fSize, int nCounter, effect eLink1, float fDuration1, effect eLink2, float fDuration);\r\n//Apply effects to a single target.\r\nvoid Sp_SingleTarget(object oAnchor, effect eLink1, float fDuration1, effect eLink2, float fDuration2);\r\n//Apply effect to an area and negate on a save.\r\nvoid Sp_SphereBlocking(object oAnchor, float fSize, int nCounter, effect eLink1, float fDuration1, effect eLink2, float fDuration);\r\n// /Apply effect to an object and negate on a save.\r\nvoid Sp_SingleTargetBlocking(object oAnchor, effect eLink1, float fDuration1, effect eLink2, float fDuration2);\r\n//Apply effects for a for power.\r\nvoid Sp_ApplyForcePowerEffects(float fTime, effect eEffect, object oTarget);\r\n//Apply effects to targets.\r\nvoid Sp_ApplyEffects(int nBlocking, object oAnchor, float fSize, int nCounter, effect eLink1, float fDuration1, effect eLink2, float fDuration2, int nRacial = RACIAL_TYPE_ALL);\r\n//Removes all effects from the spells , Knights Mind, Mind Mastery and Battle Meditation\r\nvoid Sp_RemoveBuffSpell();\r\n//Prints a string for the spell stript\r\nvoid SP_MyPrintString(string sString);\r\n//Posts a string for the spell script\r\nvoid SP_MyPostString(string sString, int n1 = 5, int n2 = 10, float fTime = 4.0);\r\n//Interates through given a time period and a damage amount and hurts someone.  Checks if the person is in conversation.\r\nvoid SP_InterativeDamage(effect eDamage, int nSecondsRemaining, object oTarget);\r\n//Checks to see if the target is a Turret\r\nint SP_CheckAppearanceTurret(object oTarget, int nFeedback = FALSE);\r\n//Checks to see if the target is a Mark 1, 2, 4 or Spyder Droid\r\nint SP_CheckAppearanceGeoDroid(object oTarget);\r\n//Checks if the character already has Energy Resistance and Improved Energy Resistance\r\nint SP_CheckEnergyResistance(object oTarget);\r\n//This checks all of the delayed effect applications to make sure the target is still hostile and has not surrendered\r\nvoid SP_MyApplyEffectToObject(int nDurationType, effect eEffect, object oTarget, float fDuration=0.0);\r\n//Checks droids appearance type and if they have shields up\r\nint SP_CheckAppearanceGeoDroidShields(object oTarget, int nFeedback = FALSE);\r\n//Check push compatibility, if true is passed in for the Whirlwind an addition check for shields is made\r\nint SP_CheckForcePushViability(object oTarget, int Whirlwind);\r\n//Removes the spell\'s effects regardless of caster\r\nvoid Sp_RemoveSpellEffectsGeneral(int nSpell_ID, object oTarget);\r\n\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Apply Delayed Effect\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This checks all of the delayed effect applications\r\n    to make sure the target is still hostile and has\r\n    not surrendered\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: May 20, 2003\r\n//:://////////////////////////////////////////////\r\nvoid SP_MyApplyEffectToObject(int nDurationType, effect eEffect, object oTarget, float fDuration=0.0)\r\n{\r\n    if(GetIsEnemy(oTarget))\r\n    {\r\n        ApplyEffectToObject(nDurationType, eEffect, oTarget, fDuration);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Interative Damage\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Interates through given a time period and a\r\n    damage amount and hurts someone.  Checks if\r\n    the person is in conversation.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 5, 2003\r\n//:://////////////////////////////////////////////\r\nvoid SP_InterativeDamage(effect eDamage, int nSecondsRemaining, object oTarget)\r\n{\r\n    if(GetIsObjectValid(oTarget))\r\n    {\r\n        if(!GetIsConversationActive() && !GetIsDead(oTarget) && GetIsEnemy(oTarget))\r\n        {\r\n             if (nSecondsRemaining % 2 == 0)\r\n             {\r\n                  ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n             }\r\n             --nSecondsRemaining;\r\n             if (nSecondsRemaining > 0)\r\n             {\r\n                DelayCommand(1.0f, SP_InterativeDamage(eDamage, nSecondsRemaining, oTarget));\r\n             }\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Blocking Checks\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Does the Spell Resistance and Immunity\r\n    Checks\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Aug 15, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint Sp_BlockingChecks(object oTarget, effect eEffect1, effect eEffect2, effect eDamage)\r\n{\r\n    int nReturn = FALSE;\r\n    //MODIFIED by Preston Watamaniuk on April 11th\r\n    //Put the immunity check in place for Force Powers.\r\n    if(GetIsLinkImmune(oTarget, eEffect1) || GetIsLinkImmune(oTarget, eEffect2) || GetIsLinkImmune(oTarget, eDamage))\r\n    {\r\n        DisplayFeedBackText(oTarget, 1);\r\n        nReturn = TRUE;\r\n    }\r\n    if(ResistForce(OBJECT_SELF, oTarget))\r\n    {\r\n        DisplayFeedBackText(oTarget, 0);\r\n        nReturn = TRUE;\r\n    }\r\n\r\n    if(nReturn == TRUE)\r\n    {\r\n        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceResisted(OBJECT_SELF), oTarget);\r\n    }\r\n\r\n    return nReturn;\r\n}\r\n\r\nint Sp_MySavingThrows(object oTarget)\r\n{\r\n    int nSave;\r\n    if(SWFP_PRIVATE_SAVE_TYPE == SAVING_THROW_FORT)\r\n    {\r\n        nSave = FortitudeSave(oTarget, Sp_GetJediDCSave(), SWFP_PRIVATE_SAVE_VERSUS_TYPE);\r\n        SP_MyPrintString("Fort Save = " + IntToString(nSave) + " For DC of " + IntToString(Sp_GetJediDCSave()));\r\n    }\r\n    else if(SWFP_PRIVATE_SAVE_TYPE == SAVING_THROW_REFLEX)\r\n    {\r\n        nSave = ReflexSave(oTarget, Sp_GetJediDCSave(), SWFP_PRIVATE_SAVE_VERSUS_TYPE);\r\n        SP_MyPrintString("Reflex Save = " + IntToString(nSave)+" For DC of " + IntToString(Sp_GetJediDCSave()));\r\n    }\r\n    else if(SWFP_PRIVATE_SAVE_TYPE == SAVING_THROW_WILL)\r\n    {\r\n        nSave = WillSave(oTarget, Sp_GetJediDCSave(), SWFP_PRIVATE_SAVE_VERSUS_TYPE);\r\n        SP_MyPrintString("Will Save = " + IntToString(nSave)+" For DC of " + IntToString(Sp_GetJediDCSave()));\r\n    }\r\n    if(nSave > 0)\r\n    {\r\n        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceResisted(OBJECT_SELF), oTarget);\r\n        DisplayFeedBackText(oTarget, 2);\r\n    }\r\n    return nSave;\r\n}\r\n\r\nvoid Sp_RemoveSpellEffects(int nSpell_ID, object oCaster, object oTarget)\r\n{\r\n    //Declare major variables\r\n    int bValid = FALSE;\r\n    effect eAOE;\r\n    if(GetHasSpellEffect(nSpell_ID, oTarget))\r\n    {\r\n        //Search through the valid effects on the target.\r\n        eAOE = GetFirstEffect(oTarget);\r\n        while (GetIsEffectValid(eAOE) && bValid == FALSE)\r\n        {\r\n            //\r\n            if (GetEffectCreator(eAOE) == oCaster)\r\n            {\r\n                //If the effect was created by the spell then remove it\r\n                if(GetEffectSpellId(eAOE) == nSpell_ID)\r\n                {\r\n                    RemoveEffect(oTarget, eAOE);\r\n                    bValid = TRUE;\r\n                }\r\n            }\r\n            //Get next effect on the target\r\n            eAOE = GetNextEffect(oTarget);\r\n        }\r\n    }\r\n}\r\n\r\nvoid Sp_RemoveSpellEffectsGeneral(int nSpell_ID, object oTarget)\r\n{\r\n    //Declare major variables\r\n    int bValid = FALSE;\r\n    effect eAOE;\r\n    if(GetHasSpellEffect(nSpell_ID, oTarget))\r\n    {\r\n        //Search through the valid effects on the target.\r\n        eAOE = GetFirstEffect(oTarget);\r\n        while (GetIsEffectValid(eAOE) && bValid == FALSE)\r\n        {\r\n            //If the effect was created by the spell then remove it\r\n            if(GetEffectSpellId(eAOE) == nSpell_ID)\r\n            {\r\n                RemoveEffect(oTarget, eAOE);\r\n                bValid = TRUE;\r\n            }\r\n            //Get next effect on the target\r\n            eAOE = GetNextEffect(oTarget);\r\n        }\r\n    }\r\n}\r\n\r\nvoid Sp_RemoveSpecificEffect(int nEffectTypeID, object oTarget)\r\n{\r\n    //Declare major variables\r\n    //Get the object that is exiting the AOE\r\n    int bValid = FALSE;\r\n    effect eAOE;\r\n    //Search through the valid effects on the target.\r\n    eAOE = GetFirstEffect(oTarget);\r\n    while (GetIsEffectValid(eAOE))\r\n    {\r\n        if (GetEffectType(eAOE) == nEffectTypeID)\r\n        {\r\n            //If the effect was created by the spell then remove it\r\n            bValid = TRUE;\r\n            RemoveEffect(oTarget, eAOE);\r\n        }\r\n        //Get next effect on the target\r\n        eAOE = GetNextEffect(oTarget);\r\n    }\r\n}\r\n\r\nfloat Sp_GetSpellEffectDelay(location SpellTargetLocation, object oTarget)\r\n{\r\n    float fDelay;\r\n    return fDelay = GetDistanceBetweenLocations(SpellTargetLocation, GetLocation(oTarget))/20;\r\n}\r\n\r\nfloat Sp_GetRandomDelay(float fMinimumTime = 0.4, float MaximumTime = 1.1)\r\n{\r\n    float fRandom = MaximumTime - fMinimumTime;\r\n    int nRandom;\r\n    if(fRandom < 0.0)\r\n    {\r\n        return 0.0;\r\n    }\r\n    else\r\n    {\r\n        nRandom = FloatToInt(fRandom  * 10.0);\r\n        nRandom = Random(nRandom) + 1;\r\n        fRandom = IntToFloat(nRandom);\r\n        fRandom /= 10.0;\r\n        return fRandom + fMinimumTime;\r\n    }\r\n}\r\n\r\nint Sp_GetJediDCSave()\r\n{\r\n    int nDC = GetSpellSaveDC();\r\n    return nDC;\r\n}\r\n\r\nvoid Sp_ApplyForcePowerEffects(float fTime, effect eEffect, object oTarget)\r\n{\r\n    float fDelay;\r\n    int nRoll = d6();\r\n    fDelay = IntToFloat(nRoll)/10.0;\r\n    if(fTime == 1000.0)\r\n    {\r\n        ApplyEffectToObject(DURATION_TYPE_PERMANENT, eEffect, oTarget);\r\n    }\r\n    else if(fTime == 0.0)\r\n    {\r\n        DelayCommand(fDelay, ApplyEffectToObject(DURATION_TYPE_INSTANT, eEffect, oTarget));\r\n    }\r\n    else\r\n    {\r\n        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eEffect, oTarget, fTime);\r\n    }\r\n}\r\n\r\nint SP_CheckEnergyResistance(object oTarget)\r\n{\r\n    if(GetHasSpellEffect(FORCE_POWER_RESIST_COLD_HEAT_ENERGY, oTarget) || GetHasSpellEffect(FORCE_POWER_RESIST_POISON_DISEASE_SONIC, oTarget))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n//::///////////////////////////////////////////////\r\n//:: Runs the specified force power.\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Runs the script for the particular force power.\r\n\r\n    SWFP_HARMFUL = ;\r\n    SWFP_PRIVATE_SAVE_TYPE;\r\n    SWFP_PRIVATE_SAVE_VERSUS_TYPE;\r\n    SWFP_DAMAGE;\r\n    SWFP_DAMAGE_TYPE;\r\n    SWFP_DAMAGE_VFX;\r\n\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: July 30, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid  Sp_RunForcePowers()\r\n{\r\n    object oTarget = GetSpellTargetObject();\r\n    effect eLink1, eLink2;\r\n    effect eInvalid;\r\n    SWFP_SHAPE = SHAPE_SPHERE;\r\n\r\n    //P.W. (June 8) This makes the Taris Calo Nord immune to Force Push, breaks the cutscene if not.\r\n    if(GetTag(oTarget) == "Calo082" && GetSpellId() == FORCE_POWER_FORCE_PUSH)\r\n    {\r\n        DisplayFeedBackText(oTarget, 1);\r\n        return;\r\n    }\r\n\r\n    switch (GetSpellId())\r\n    {\r\n        /*\r\n        AFFLICTION\r\n        */\r\n        case FORCE_POWER_AFFLICTION:\r\n        {\r\n            /*\r\n            SWFP_HARMFUL = TRUE;\r\n            eLink1 = EffectPoison(POISON_ABILITY_SCORE_AVERAGE);\r\n            effect eLink3 = EffectLinkEffects(eLink1, EffectMovementSpeedDecrease(50));\r\n\r\n            eLink3 = SetEffectIcon(eLink3, 1);\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            ApplyEffectToObject(DURATION_TYPE_PERMANENT, eLink1, oTarget);\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink3, oTarget, 21.0);\r\n            */\r\n            SWFP_HARMFUL = TRUE;\r\n\r\n            eLink1 = EffectPoison(POISON_ABILITY_SCORE_AVERAGE);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectMovementSpeedDecrease(50));\r\n            eLink1 = SetEffectIcon(eLink1, 23);\r\n            if(!GetIsPoisoned(oTarget))\r\n            {\r\n                Sp_ApplyEffects(FALSE, oTarget, 0.0, 1, eLink1, 1000.0, eInvalid, 0.0);\r\n            }\r\n\r\n        }\r\n        break;\r\n\r\n        /*\r\n        CHOKE\r\n        */\r\n        case FORCE_POWER_CHOKE:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n            SWFP_DAMAGE = (GetHitDice(OBJECT_SELF)*2)/3;\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;\r\n            SWFP_DAMAGE_VFX = VFX_IMP_CHOKE;\r\n\r\n            eLink1 = EffectAbilityDecrease(ABILITY_CONSTITUTION, 4);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityDecrease(ABILITY_STRENGTH, 4));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityDecrease(ABILITY_DEXTERITY, 4));\r\n            eLink1 = SetEffectIcon(eLink1, 3);\r\n\r\n            effect eChoke = EffectChoke();\r\n            effect eDamage = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n\r\n            int nResist = Sp_BlockingChecks(oTarget, eChoke, eDamage, eInvalid);\r\n            int nSaves;\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            if(nResist == 0)\r\n            {\r\n                nSaves = Sp_MySavingThrows(oTarget);\r\n                if(nSaves == 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_CHOKE), oTarget);\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eChoke, oTarget, 6.0);\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 24.0);\r\n                    int nIdx = 1;\r\n                    float fDelay;\r\n                    SP_InterativeDamage(eDamage, 7, oTarget);\r\n                }\r\n            }\r\n            if(nResist > 0 || nSaves > 0)\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        CURE\r\n        */\r\n        //MODIFIED by Preston Watamaniuk March 28\r\n        // Remove cure poison and reduced the amount by 5\r\n        case FORCE_POWER_CURE:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n\r\n            int nHeal = GetAbilityModifier(ABILITY_WISDOM) + GetAbilityModifier(ABILITY_CHARISMA) + 5 + GetHitDice(OBJECT_SELF);\r\n\r\n            effect eVis =  EffectVisualEffect(VFX_IMP_CURE);\r\n            int nCnt = 0;\r\n\r\n            object oParty;\r\n            if(IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                oParty = GetPartyMemberByIndex(nCnt);\r\n            }\r\n            else\r\n            {\r\n                oParty = OBJECT_SELF;\r\n            }\r\n\r\n            while(nCnt < 3)\r\n            {\r\n                if(GetIsObjectValid(oParty) &&\r\n                   GetRacialType(oParty) != RACIAL_TYPE_DROID &&\r\n                   GetDistanceBetween(OBJECT_SELF, oParty) < 15.0)\r\n                {\r\n                    SignalEvent(oParty, EventSpellCastAt(OBJECT_SELF, GetSpellId(), FALSE));\r\n                    //Sp_RemoveSpecificEffect(EFFECT_TYPE_POISON, oParty);\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eVis, oParty);\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectHeal(nHeal), oParty);\r\n                }\r\n                nCnt++;\r\n                if(IsObjectPartyMember(OBJECT_SELF))\r\n                {\r\n                   oParty = GetPartyMemberByIndex(nCnt);\r\n                }\r\n                else\r\n                {\r\n                   oParty = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, OBJECT_SELF, nCnt);\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        DEATH FIELD\r\n        */\r\n        case FORCE_POWER_DEATH_FIELD:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_DARK_SIDE;\r\n            int nDamTest = GetHitDice(OBJECT_SELF);\r\n            if(nDamTest > 10)\r\n            {\r\n                nDamTest = 10;\r\n            }\r\n            SWFP_DAMAGE = d4(nDamTest);\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_DARK_SIDE;\r\n            SWFP_DAMAGE_VFX = VFX_PRO_DEATH_FIELD;\r\n\r\n            int nHealCount;\r\n            int nDamage = SWFP_DAMAGE/2;\r\n            effect eDamage;\r\n            effect eBeam = EffectBeam(VFX_BEAM_DEATH_FIELD_TENTACLE, OBJECT_SELF, BODY_NODE_HEAD);\r\n            effect eVFX = EffectVisualEffect(VFX_PRO_DEATH_FIELD);\r\n\r\n            object oTarget = GetFirstObjectInShape(SHAPE_SPHERE, 12.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            while(GetIsObjectValid(oTarget))\r\n            {\r\n                int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eDamage);\r\n                if((GetRacialType(oTarget) == RACIAL_TYPE_HUMAN &&\r\n                   GetRacialType(oTarget) != RACIAL_TYPE_DROID) || GetObjectType(oTarget) == OBJECT_TYPE_PLACEABLE)\r\n                {\r\n                    if(GetIsEnemy(oTarget))\r\n                    {\r\n                        SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                        if(nResist == 0)\r\n                        {\r\n                            int nSaves = Sp_MySavingThrows(oTarget);\r\n                            if(nSaves == FALSE)\r\n                            {\r\n                                eDamage =  EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                                nHealCount += SWFP_DAMAGE;\r\n                            }\r\n                            else\r\n                            {\r\n                                eDamage =  EffectDamage(nDamage, SWFP_DAMAGE_TYPE);\r\n                                nHealCount += nDamage;\r\n                            }\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eVFX, oTarget);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBeam, oTarget, fLightningDuration);\r\n                        }\r\n                        else\r\n                        {\r\n                            //effect eBeam2 = EffectBeam(VFX_BEAM_DEATH_FIELD_TENTACLE, OBJECT_SELF, BODY_NODE_HEAD, TRUE);\r\n                            //ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBeam, oTarget, fLightningDuration);\r\n                        }\r\n                    }\r\n                }\r\n                oTarget = GetNextObjectInShape(SHAPE_SPHERE, 12.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            }\r\n            if(GetCurrentHitPoints(OBJECT_SELF) < GetMaxHitPoints(OBJECT_SELF) && nHealCount > 0)\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectHeal(nHealCount), OBJECT_SELF);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        DRAIN LIFE\r\n        */\r\n        case FORCE_POWER_DRAIN_LIFE:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n            int nDam = GetHitDice(OBJECT_SELF);\r\n            int nDamTest = GetHitDice(OBJECT_SELF);\r\n            if(nDamTest > 10)\r\n            {\r\n                nDamTest = 10;\r\n            }\r\n            SWFP_DAMAGE = d4(nDamTest);\r\n            SWFP_DAMAGE_TYPE= DAMAGE_TYPE_DARK_SIDE;\r\n            SWFP_DAMAGE_VFX = VFX_PRO_DRAIN;\r\n            //Set up the drain effect link for the target\r\n            effect eBeam = EffectBeam(VFX_BEAM_DRAIN_LIFE, OBJECT_SELF, BODY_NODE_HAND);\r\n            effect eVFX = EffectVisualEffect(SWFP_DAMAGE_VFX);\r\n            //Set up the link to Heal the user by the same amount.\r\n            effect eHeal;\r\n            effect eDamage = EffectDamage(SWFP_DAMAGE, DAMAGE_TYPE_DARK_SIDE);\r\n\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBeam, oTarget, fLightningDuration);\r\n            DelayCommand(0.3, ApplyEffectToObject(DURATION_TYPE_INSTANT, eVFX, oTarget));\r\n\r\n            int nResist = Sp_BlockingChecks(oTarget, eDamage, eInvalid, eInvalid);\r\n\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            if(GetRacialType(oTarget) != RACIAL_TYPE_DROID)\r\n            {\r\n                if(nResist == 0)\r\n                {\r\n                    int nSaves = Sp_MySavingThrows(oTarget);\r\n                    if(nSaves > 0)\r\n                    {\r\n                        SWFP_DAMAGE /= 2;\r\n                    }\r\n                    eDamage = EffectDamage(SWFP_DAMAGE,  DAMAGE_TYPE_DARK_SIDE);\r\n                    if(GetCurrentHitPoints(OBJECT_SELF) < GetMaxHitPoints(OBJECT_SELF) && SWFP_DAMAGE > 0)\r\n                    {\r\n                        eHeal = EffectHeal(SWFP_DAMAGE);\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eHeal, OBJECT_SELF);\r\n                    }\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        DESTROY DROID\r\n        */\r\n        case FORCE_POWER_DROID_DESTROY:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_REFLEX;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_ELECTRICAL;\r\n\r\n            eLink1 = EffectBeam(VFX_BEAM_DROID_DESTROY, oTarget, BODY_NODE_CHEST);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_PRO_LIGHTNING_L));\r\n\r\n            eLink2 = EffectDroidStun();\r\n            eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(1008));\r\n            eLink2 = SetEffectIcon(eLink2, 5);\r\n\r\n            effect eLink3 = EffectBeam(VFX_BEAM_DROID_DESTROY, OBJECT_SELF, BODY_NODE_HAND);\r\n            eLink3 = EffectLinkEffects(eLink3, EffectVisualEffect(VFX_PRO_LIGHTNING_L));\r\n\r\n            int nDamage = d6(GetHitDice(OBJECT_SELF));\r\n            int nApply = nDamage/2;\r\n            effect eDamage = EffectDamage(nDamage, DAMAGE_TYPE_ELECTRICAL);;\r\n            effect eSaveDamage = EffectDamage(nApply, DAMAGE_TYPE_ELECTRICAL);\r\n\r\n\r\n            //Apply Effects to the first droid targeted.\r\n            int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n            int nSaves;\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink3, oTarget, fLightningDuration);\r\n            if(nResist == 0)\r\n            {\r\n                nSaves = Sp_MySavingThrows(oTarget);\r\n                if(nSaves == 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage , oTarget);\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, 12.0);\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eSaveDamage , oTarget);\r\n                }\r\n            }\r\n            else\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n\r\n            //Start going through all hostile droids around the primary target\r\n            object oSecond = GetFirstObjectInShape(SHAPE_SPHERE, 6.0, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            while(GetIsObjectValid(oSecond))\r\n            {\r\n                if(oSecond != oTarget && GetIsEnemy(oSecond) && GetRacialType(oSecond) == RACIAL_TYPE_DROID)\r\n                {\r\n                    nResist = Sp_BlockingChecks(oSecond, eLink1, eLink2, eInvalid);\r\n\r\n                    SignalEvent(oSecond, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    if(nResist == 0)\r\n                    {\r\n                        nSaves = Sp_MySavingThrows(oSecond);\r\n                        //Apply the beam effect and hit regardless because damage is still done.\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oSecond, fLightningDuration);\r\n                        if(nSaves == 0)\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage , oSecond);\r\n                            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oSecond, 12.0);\r\n                        }\r\n                        else\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eSaveDamage , oSecond);\r\n                        }\r\n                    }\r\n                }\r\n                oSecond = GetNextObjectInShape(SHAPE_SPHERE, 6.0, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        DISABLE DROID\r\n        */\r\n        case FORCE_POWER_DROID_DISABLE:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_REFLEX;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_ELECTRICAL;\r\n\r\n            eLink1 = EffectBeam(VFX_BEAM_DROID_DESTROY, oTarget, BODY_NODE_CHEST);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_PRO_LIGHTNING_L));\r\n\r\n            eLink2 = EffectDroidStun();\r\n            eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(1008));\r\n            eLink2 = SetEffectIcon(eLink2, 4);\r\n\r\n            effect eLink3 = EffectBeam(VFX_BEAM_DROID_DISABLE, OBJECT_SELF, BODY_NODE_HAND);\r\n            eLink3 = EffectLinkEffects(eLink3, EffectVisualEffect(VFX_PRO_LIGHTNING_L));\r\n\r\n            int nDamage = GetHitDice(OBJECT_SELF);\r\n            int nApply = nDamage/2;\r\n            effect eDamage = EffectDamage(nDamage, DAMAGE_TYPE_ELECTRICAL);;\r\n            effect eSaveDamage = EffectDamage(nApply, DAMAGE_TYPE_ELECTRICAL);\r\n\r\n\r\n            //Apply Effects to the first droid targeted.\r\n            int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n            int nSaves;\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink3, oTarget, fLightningDuration);\r\n            if(nResist == 0)\r\n            {\r\n                nSaves = Sp_MySavingThrows(oTarget);\r\n                if(nSaves == 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage , oTarget);\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, 12.0);\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eSaveDamage , oTarget);\r\n                }\r\n            }\r\n            else\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n\r\n            //Start going through all hostile droids around the primary target\r\n            object oSecond = GetFirstObjectInShape(SHAPE_SPHERE, 5.0, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            while(GetIsObjectValid(oSecond))\r\n            {\r\n                if(oSecond != oTarget && GetIsEnemy(oSecond) && GetRacialType(oSecond) == RACIAL_TYPE_DROID)\r\n                {\r\n                    nResist = Sp_BlockingChecks(oSecond, eLink1, eLink2, eInvalid);\r\n\r\n                    SignalEvent(oSecond, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    if(nResist == 0)\r\n                    {\r\n                        nSaves = Sp_MySavingThrows(oSecond);\r\n                        //Apply the beam effect and hit regardless because damage is still done.\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oSecond, fLightningDuration);\r\n                        if(nSaves == 0)\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage , oSecond);\r\n                            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oSecond, 12.0);\r\n                        }\r\n                        else\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eSaveDamage , oSecond);\r\n                        }\r\n                    }\r\n                }\r\n                oSecond = GetNextObjectInShape(SHAPE_SPHERE, 5.0, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        STUN DROID\r\n        */\r\n        case FORCE_POWER_DROID_STUN:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_ELECTRICAL;\r\n            SWFP_DAMAGE = GetHitDice(OBJECT_SELF);\r\n            SWFP_DAMAGE_TYPE= DAMAGE_TYPE_ELECTRICAL;\r\n\r\n            eLink1 = EffectBeam(2065, OBJECT_SELF, BODY_NODE_HAND); //P.W.(May 19, 2003) New Droid Stun Beam Effect added\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_PRO_LIGHTNING_S));\r\n            eLink2 = EffectDroidStun();\r\n            eLink2 = SetEffectIcon(eLink2, 30);\r\n            eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(1007));  //P.W.(May 19, 2003) Linked the smoke to Link 2\r\n            effect eDamage;\r\n\r\n            int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, fLightningDuration);\r\n\r\n            if(nResist == 0)\r\n            {\r\n                int nSaves = Sp_MySavingThrows(oTarget);\r\n                if(nSaves == 0)\r\n                {\r\n                    eDamage = EffectDamage(SWFP_DAMAGE, DAMAGE_TYPE_ELECTRICAL);\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, 12.0);\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                }\r\n                else\r\n                {\r\n                    eDamage = EffectDamage(SWFP_DAMAGE/2, DAMAGE_TYPE_ELECTRICAL);\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                }\r\n            }\r\n            else\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FEAR\r\n        */\r\n        case FORCE_POWER_FEAR:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_FEAR;\r\n\r\n            eLink1 = EffectHorrified();\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(1041));\r\n            eLink1 = SetEffectIcon(eLink1, 6);\r\n\r\n            Sp_ApplyEffects(TRUE, oTarget, 0.0, 1, eLink1, 6.0, eInvalid, 0.0);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE ARMOR\r\n        */\r\n        case FORCE_POWER_FORCE_ARMOR:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n            eLink1 = EffectACIncrease(6, AC_DODGE_BONUS);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_ALL, 6));\r\n            eLink1 = SetEffectIcon(eLink1, 7);\r\n            eLink2 = EffectVisualEffect(VFX_PRO_FORCE_ARMOR);\r\n            eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(VFX_PRO_FORCE_SHIELD));\r\n\r\n\r\n            //MODIFIED by Preston Watamaniuk on March 12\r\n            //Make sure these Force Powers do not stack\r\n            /*\r\n            if(!GetHasSpellEffect(FORCE_POWER_FORCE_AURA) &&\r\n               !GetHasSpellEffect(FORCE_POWER_FORCE_ARMOR) &&\r\n               !GetHasSpellEffect(FORCE_POWER_FORCE_SHIELD))\r\n            {\r\n                Sp_ApplyEffects(FALSE, oTarget, 0.0, 1, eLink1, 20.0, eLink2, 3.0);\r\n            }\r\n            */\r\n\r\n            //Modified by Preston Watamaniuk on Sept 2\r\n            //Make sure the old power is replaced by a new version if the same or more powerful\r\n            if(GetHasSpellEffect(FORCE_POWER_FORCE_AURA))\r\n            {\r\n                Sp_RemoveSpellEffectsGeneral(FORCE_POWER_FORCE_AURA, oTarget);\r\n            }\r\n            else if(GetHasSpellEffect(FORCE_POWER_FORCE_SHIELD))\r\n            {\r\n                Sp_RemoveSpellEffectsGeneral(FORCE_POWER_FORCE_SHIELD, oTarget);\r\n            }\r\n            else if(GetHasSpellEffect(FORCE_POWER_FORCE_ARMOR))\r\n            {\r\n                Sp_RemoveSpellEffectsGeneral(FORCE_POWER_FORCE_ARMOR, oTarget);\r\n            }\r\n            Sp_ApplyEffects(FALSE, oTarget, 0.0, 1, eLink1, 20.0, eLink2, 3.0);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE AURA\r\n        */\r\n        case FORCE_POWER_FORCE_AURA:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n            eLink1 = EffectACIncrease(2, AC_DODGE_BONUS);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_ALL, 2));\r\n            eLink1 = SetEffectIcon(eLink1, 8);\r\n            eLink2 = EffectVisualEffect(VFX_PRO_FORCE_AURA);\r\n\r\n            //Modified by Preston Watamaniuk on Sept 2\r\n            //Make sure the old power is replaced by a new version if the same or more powerful\r\n            if(GetHasSpellEffect(FORCE_POWER_FORCE_AURA))\r\n            {\r\n                Sp_RemoveSpellEffectsGeneral(FORCE_POWER_FORCE_AURA, oTarget);\r\n            }\r\n\r\n            //MODIFIED by Preston Watamaniuk on March 12\r\n            //Make sure these Force Powers do not stack\r\n            if(!GetHasSpellEffect(FORCE_POWER_FORCE_ARMOR) &&\r\n               !GetHasSpellEffect(FORCE_POWER_FORCE_SHIELD))\r\n            {\r\n                Sp_ApplyEffects(FALSE, oTarget, 0.0, 1, eLink1, 20.0, eLink2, 3.0);\r\n            }\r\n\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE BREACH\r\n        */\r\n        case FORCE_POWER_FORCE_BREACH:\r\n        {\r\n            effect eBuff = GetFirstEffect(oTarget);\r\n            int bValid = FALSE;\r\n            while(GetIsEffectValid(eBuff))\r\n            {\r\n                if(GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_AURA ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_SHIELD ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_ARMOR ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_MIND ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_KNIGHT_MIND ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_MIND_MASTERY ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_SPEED_BURST ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_KNIGHT_SPEED ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_SPEED_MASTERY ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_RESIST_COLD_HEAT_ENERGY ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_RESIST_POISON_DISEASE_SONIC ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_RESIST_FORCE ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_IMMUNITY)\r\n                 {\r\n                    RemoveEffect(oTarget, eBuff);\r\n                 }\r\n                 eBuff = GetNextEffect(oTarget);\r\n            }\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId()));\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_FORCE_BREACH), oTarget);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE IMMUNITY\r\n        */\r\n        case FORCE_POWER_FORCE_IMMUNITY:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n            int nSR = 15 + GetHitDice(OBJECT_SELF);\r\n            eLink1 = EffectForceResistanceIncrease(nSR);\r\n            eLink1 = SetEffectIcon(eLink1, 9);\r\n            eLink2 = EffectVisualEffect(VFX_PRO_RESIST_FORCE);\r\n            if(GetHasSpellEffect(FORCE_POWER_RESIST_FORCE))\r\n            {\r\n                Sp_RemoveSpellEffectsGeneral(FORCE_POWER_RESIST_FORCE, oTarget);\r\n            }\r\n            else if(GetHasSpellEffect(FORCE_POWER_FORCE_IMMUNITY))\r\n            {\r\n                Sp_RemoveSpellEffectsGeneral(FORCE_POWER_FORCE_IMMUNITY, oTarget);\r\n            }\r\n            Sp_ApplyEffects(TRUE, oTarget, 0.0, 1, eLink1, 60.0, eLink2, 1.0);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE PUSH\r\n        */\r\n        case FORCE_POWER_FORCE_PUSH:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_REFLEX;\r\n            SWFP_DAMAGE = GetHitDice(OBJECT_SELF);\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;\r\n\r\n            eLink1 = EffectForcePushed();\r\n            eLink2 = EffectStunned();\r\n            eLink2 = SetEffectIcon(eLink2, 11);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_IMP_FORCE_PUSH));\r\n            effect eDamage = EffectDamage(GetHitDice(OBJECT_SELF), SWFP_DAMAGE_TYPE);\r\n\r\n            int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eDamage);\r\n            if(SP_CheckForcePushViability(oTarget, FALSE))\r\n            {\r\n                if(nResist == FALSE)\r\n                {\r\n                    int nSaves = Sp_MySavingThrows(oTarget);\r\n                    if(nSaves == FALSE)\r\n                    {\r\n                        eDamage = EffectDamage(GetHitDice(OBJECT_SELF), SWFP_DAMAGE_TYPE);\r\n                        DelayCommand(0.4, SP_MyApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget));\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 0.1);\r\n                        DelayCommand(2.55, SP_MyApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, 2.0));\r\n                    }\r\n                    else\r\n                    {\r\n                        eDamage = EffectDamage(GetHitDice(OBJECT_SELF)/2, SWFP_DAMAGE_TYPE);\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 0.1);\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_FORCE_PUSH), oTarget);\r\n\r\n                    }\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE VALOR\r\n        */\r\n        case FORCE_POWER_FORCE_MIND:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n            SWFP_SHAPE = SHAPE_SPHERE;\r\n            eLink1 = EffectSavingThrowIncrease(SAVING_THROW_FORT,2);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_REFLEX, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_WILL, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_CHARISMA, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_CONSTITUTION, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_DEXTERITY, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_INTELLIGENCE, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_STRENGTH, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_WISDOM, 2));\r\n            eLink2 = EffectVisualEffect(VFX_IMP_MIND_FORCE);\r\n            eLink1 = SetEffectIcon(eLink1, 10);\r\n            Sp_RemoveBuffSpell();\r\n            Sp_ApplyEffects(FALSE, OBJECT_SELF, 30.0, 1000, eLink1, 20.0, eLink2, 0.0);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE SHIELD\r\n        */\r\n        case FORCE_POWER_FORCE_SHIELD:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n            eLink1 = EffectACIncrease(4, AC_DODGE_BONUS);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_ALL, 4));\r\n            eLink1 = SetEffectIcon(eLink1, 12);\r\n            eLink2 = EffectVisualEffect(VFX_PRO_FORCE_SHIELD);\r\n\r\n            //Modified by Preston Watamaniuk on Sept 2\r\n            //Make sure the old power is replaced by a new version if the same or more powerful\r\n            if(GetHasSpellEffect(FORCE_POWER_FORCE_AURA))\r\n            {\r\n                Sp_RemoveSpellEffectsGeneral(FORCE_POWER_FORCE_AURA, oTarget);\r\n            }\r\n            else if(GetHasSpellEffect(FORCE_POWER_FORCE_SHIELD))\r\n            {\r\n                Sp_RemoveSpellEffectsGeneral(FORCE_POWER_FORCE_SHIELD, oTarget);\r\n            }\r\n            //MODIFIED by Preston Watamaniuk on March 12\r\n            //Make sure these Force Powers do not stack\r\n            if(!GetHasSpellEffect(FORCE_POWER_FORCE_ARMOR))\r\n            {\r\n                Sp_ApplyEffects(FALSE, oTarget, 0.0, 1, eLink1, 20.0, eLink2, 3.0);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE STORM\r\n        */\r\n        case FORCE_POWER_FORCE_STORM:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            int nDamage = GetHitDice(OBJECT_SELF);\r\n            if(nDamage > 10)\r\n            {\r\n                nDamage = 10;\r\n            }\r\n            SWFP_DAMAGE = d6(nDamage);\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_ELECTRICAL;\r\n            effect eBeam = EffectBeam(2061, OBJECT_SELF, BODY_NODE_HEAD);\r\n            effect eVis = EffectVisualEffect(VFX_PRO_LIGHTNING_L);\r\n            effect eForce;\r\n            effect eDam;\r\n            object oUse = GetFirstObjectInShape(SHAPE_SPHERE, 12.0, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            while(GetIsObjectValid(oUse))\r\n            {\r\n                //Make Immunity Checks\r\n                if(GetIsEnemy(oUse))\r\n                {\r\n                    SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                    if(!ResistForce(OBJECT_SELF, oUse))\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eVis, oUse);\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBeam, oUse, fLightningDuration);\r\n                        if(!WillSave(oUse, Sp_GetJediDCSave()))\r\n                        {\r\n                            eDam = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                            eForce = EffectDamageForcePoints(SWFP_DAMAGE);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eForce, oUse);\r\n                        }\r\n                        else\r\n                        {\r\n                            eDam = EffectDamage(SWFP_DAMAGE/2, SWFP_DAMAGE_TYPE);\r\n                            eForce = EffectDamageForcePoints(SWFP_DAMAGE/2);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eForce, oUse);\r\n                        }\r\n                    }\r\n                    else\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                    }\r\n                }\r\n                oUse = GetNextObjectInShape(SHAPE_SPHERE, 12.0, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE WAVE\r\n        */\r\n        case FORCE_POWER_FORCE_WAVE:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_REFLEX;\r\n            SWFP_DAMAGE = GetHitDice(OBJECT_SELF) + GetHitDice(OBJECT_SELF)/2;\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;\r\n            effect eVis = EffectVisualEffect(VFX_IMP_FORCE_PUSH);\r\n            eLink1 = EffectForcePushed();\r\n            eLink2 = EffectStunned();\r\n            eLink2 = SetEffectIcon(eLink2, 13);\r\n            effect eDam;\r\n            effect eForce;\r\n            object oUse = GetFirstObjectInShape(SHAPE_SPHERE, 15.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            ApplyEffectAtLocation(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_FNF_FORCE_WAVE), GetLocation(OBJECT_SELF));\r\n            while(GetIsObjectValid(oUse))\r\n            {\r\n                //Make Immunity Checks\r\n                if(GetIsEnemy(oUse))\r\n                {\r\n                    SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                    if(!ResistForce(OBJECT_SELF, oUse))\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eVis, oUse);\r\n                        if(!ReflexSave(oUse, Sp_GetJediDCSave()))\r\n                        {\r\n                            eDam = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                            DelayCommand(0.4, SP_MyApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse));\r\n\r\n                            if(SP_CheckForcePushViability(oUse, FALSE))\r\n                            {\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oUse, 0.2);\r\n                            }\r\n                            DelayCommand(2.55, SP_MyApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oUse, 6.0));\r\n                        }\r\n                        else\r\n                        {\r\n                            if(SP_CheckForcePushViability(oUse, FALSE))\r\n                            {\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oUse, 0.2);\r\n                            }\r\n                            eDam = EffectDamage(SWFP_DAMAGE/2, SWFP_DAMAGE_TYPE);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceResisted(OBJECT_SELF), oTarget);\r\n                        }\r\n                    }\r\n                }\r\n                oUse = GetNextObjectInShape(SHAPE_SPHERE, 15.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE WHIRLWIND\r\n        */\r\n        case FORCE_POWER_FORCE_WHIRLWIND:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_REFLEX;\r\n            SWFP_DAMAGE = GetHitDice(OBJECT_SELF)/3;\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;\r\n            effect eDamage = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n\r\n            //SP_MyPostString(IntToString(SP_CheckAppearanceGeoDroidShields(oTarget)),5,5,3.0);\r\n\r\n            if(SP_CheckForcePushViability(oTarget, TRUE))\r\n            {\r\n                eLink1 = EffectWhirlWind();\r\n                eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_IMP_FORCE_WHIRLWIND));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_FORCE_WHIRLWIND));\r\n                eLink1 = SetEffectIcon(eLink1, 14);\r\n\r\n                int nResist = Sp_BlockingChecks(oTarget, eLink1, eDamage, eInvalid);\r\n                int nSaves;\r\n                SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                if(nResist == 0)\r\n                {\r\n                    nSaves = Sp_MySavingThrows(oTarget);\r\n                    if(nSaves == 0)\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 9.0);\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eDamage, oTarget);\r\n                        int nIdx = 1;\r\n                        float fDelay;\r\n                        SP_InterativeDamage(eDamage, 13, oTarget);\r\n                    }\r\n                }\r\n                if(nResist > 0 || nSaves > 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                }\r\n            }\r\n            //Force Push all enemies away from the target is they meet the conditions.\r\n            SP_MyPrintString("");\r\n            eLink2 = EffectForcePushTargeted(GetLocation(oTarget));\r\n            object oSecond = GetFirstObjectInShape(SHAPE_SPHERE, 5.0, GetLocation(oTarget));\r\n            while(GetIsObjectValid(oSecond))\r\n            {\r\n                if(SP_CheckForcePushViability(oSecond, FALSE) == TRUE && GetIsEnemy(oSecond, OBJECT_SELF) && oSecond != oTarget)\r\n                {\r\n                    //P.W. (June 8) - Put this check in so Calo Nord does not move during the fight on Taris\r\n                    if(GetTag(oTarget) != "Calo082")\r\n                    {\r\n                        SignalEvent(oSecond, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                        int nResist2 = Sp_BlockingChecks(oSecond, eLink2,eInvalid,eInvalid);\r\n                        if(nResist2 == 0)\r\n                        {\r\n                            int nSaves2 = Sp_MySavingThrows(oSecond);\r\n                            if(nSaves2 == 0)\r\n                            {\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oSecond, 0.2);\r\n                            }\r\n                        }\r\n                    }\r\n                }\r\n                oSecond = GetNextObjectInShape(SHAPE_SPHERE, 5.0, GetLocation(oTarget));\r\n                SP_MyPrintString("");\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        HEAL\r\n        */\r\n        //MODIFIED by Preston Watamaniuk March 28\r\n        //Cut the heal in half\r\n        case FORCE_POWER_HEAL:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n\r\n            int nHeal = GetAbilityModifier(ABILITY_WISDOM) + GetAbilityModifier(ABILITY_CHARISMA) + 10 + GetHitDice(OBJECT_SELF);\r\n\r\n            effect eVis =  EffectVisualEffect(VFX_IMP_HEAL);\r\n            int nCnt = 0;\r\n\r\n            object oParty;\r\n            if(IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                oParty = GetPartyMemberByIndex(nCnt);\r\n            }\r\n            else\r\n            {\r\n                oParty = OBJECT_SELF;\r\n            }\r\n\r\n            while(nCnt < 3)\r\n            {\r\n                if(GetIsObjectValid(oParty) &&\r\n                   GetRacialType(oParty) != RACIAL_TYPE_DROID &&\r\n                   GetDistanceBetween(OBJECT_SELF, oParty) < 15.0)\r\n                {\r\n                    SignalEvent(oParty, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                    Sp_RemoveSpecificEffect(EFFECT_TYPE_POISON, oParty);\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eVis, oParty);\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectHeal(nHeal), oParty);\r\n                }\r\n                nCnt++;\r\n                if(IsObjectPartyMember(OBJECT_SELF))\r\n                {\r\n                   oParty = GetPartyMemberByIndex(nCnt);\r\n                }\r\n                else\r\n                {\r\n                   oParty = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, OBJECT_SELF, nCnt, CREATURE_TYPE_RACIAL_TYPE, RACIAL_TYPE_HUMAN);\r\n                }\r\n            }\r\n        }\r\n        break;\r\n        /*\r\n        HORROR\r\n        */\r\n        case FORCE_POWER_HORROR:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_FEAR;\r\n\r\n            eLink1 = EffectHorrified();\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(1042));\r\n            eLink1 = SetEffectIcon(eLink1, 16);\r\n            Sp_ApplyEffects(TRUE, oTarget, 5.0, 1000, eLink1, 12.0, eInvalid, 0.0, RACIAL_TYPE_HUMAN);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        INSANITY\r\n        */\r\n        case FORCE_POWER_INSANITY:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_FEAR;\r\n\r\n            eLink1 = EffectHorrified();\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(1043));\r\n            eLink1 = SetEffectIcon(eLink1, 17);\r\n            Sp_ApplyEffects(TRUE, oTarget, 10.0, 1000, eLink1, 12.0, eInvalid, 0.0, RACIAL_TYPE_HUMAN);\r\n\r\n            //ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(1043), oTarget);\r\n\r\n        }\r\n        break;\r\n\r\n        /*\r\n        KILL\r\n        */\r\n        case FORCE_POWER_KILL:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n            effect eDeath = EffectDeath();\r\n            effect eDamage;\r\n            effect eChoke = EffectChoke();\r\n            eChoke = SetEffectIcon(eChoke, 18);\r\n            effect eVFX = EffectVisualEffect(VFX_IMP_CHOKE);\r\n\r\n            int nResist = Sp_BlockingChecks(oTarget, eDeath, eDamage, eChoke);\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            if(nResist == 0)\r\n            {\r\n                int nSaves = Sp_MySavingThrows(oTarget);\r\n                int nDamage = GetHitDice(OBJECT_SELF);\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, eVFX, oTarget);\r\n                eDamage = EffectDamage(nDamage, DAMAGE_TYPE_BLUDGEONING);\r\n                if(nSaves == 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eChoke, oTarget, 6.0);\r\n                    nDamage = (GetMaxHitPoints(oTarget))/2;\r\n                    nDamage = nDamage/3;\r\n                    //This will do damage over time to make the effect look more dramatic\r\n                    eDamage = EffectDamage(nDamage, DAMAGE_TYPE_BLUDGEONING);\r\n                    SP_InterativeDamage(eDamage, 7, oTarget);\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                }\r\n\r\n            }\r\n            else\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        KNIGHT VALOR\r\n        */\r\n        case FORCE_POWER_KNIGHT_MIND:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n            SWFP_SHAPE = SHAPE_SPHERE;\r\n            eLink1 = EffectSavingThrowIncrease(SAVING_THROW_ALL,3);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_ALL, 3));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_CHARISMA, 3));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_CONSTITUTION, 3));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_DEXTERITY, 3));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_INTELLIGENCE, 3));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_STRENGTH, 3));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_WISDOM, 3));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectImmunity(IMMUNITY_TYPE_POISON));\r\n            eLink1 = SetEffectIcon(eLink1, 19);\r\n            eLink2 = EffectVisualEffect(1033);\r\n\r\n            Sp_RemoveBuffSpell();\r\n            //Sp_SphereSaveHalf(OBJECT_SELF, 30.0, 1000, eLink1, 20.0);\r\n            Sp_ApplyEffects(TRUE, OBJECT_SELF, 30.0, 1000, eLink1, 20.0, eLink2, 0.0);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        LIGHTSABER THROW\r\n        */\r\n        case FORCE_POWER_LIGHT_SABER_THROW:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n\r\n            eLink1 = EffectLightsaberThrow(oTarget);\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, OBJECT_SELF, 3.0);\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n        }\r\n        break;\r\n        /*\r\n        ADVANCED LIGHTSABER THROW\r\n        */\r\n        case FORCE_POWER_LIGHT_SABER_THROW_ADVANCED:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            object oTarget2, oTarget3;\r\n            oTarget2 = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, oTarget, 1);\r\n            if(GetIsObjectValid(oTarget2) && GetDistanceBetween(oTarget, oTarget2) <= 5.0)\r\n            {\r\n                oTarget3 = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, oTarget, 2);\r\n                if(GetIsObjectValid(oTarget3) && GetDistanceBetween(oTarget, oTarget3) <= 5.0)\r\n                {\r\n                    SP_MyPrintString("Target 1 = " + ObjectToString(oTarget) +\r\n                                " Target 2 = " + ObjectToString(oTarget2) +\r\n                                " Target 3 = " + ObjectToString(oTarget3));\r\n                    eLink1 = EffectLightsaberThrow(oTarget, oTarget2, oTarget3);\r\n                    SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                    SignalEvent(oTarget2, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                    SignalEvent(oTarget3, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                }\r\n                else\r\n                {\r\n                    SP_MyPrintString("Target 1 = " + ObjectToString(oTarget) +\r\n                                " Target 2 = " + ObjectToString(oTarget2));\r\n                    eLink1 = EffectLightsaberThrow(oTarget, oTarget2);\r\n                    SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                    SignalEvent(oTarget2, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                }\r\n            }\r\n            else\r\n            {\r\n                SP_MyPrintString("Target 1 = " + ObjectToString(oTarget));\r\n                eLink1 = EffectLightsaberThrow(oTarget);\r\n                oTarget2 = OBJECT_INVALID;\r\n            }\r\n            SP_MyPrintString("Apply Throwsaber Effect");\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, OBJECT_SELF, 3.0);\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n        }\r\n        break;\r\n\r\n        /*\r\n        LIGHTNING\r\n        */\r\n        case FORCE_POWER_LIGHTNING:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_ELECTRICAL;\r\n            int nDamage = GetHitDice(OBJECT_SELF);\r\n            if(nDamage > 10)\r\n            {\r\n                nDamage = 10;\r\n            }\r\n            SWFP_DAMAGE = d6(nDamage);\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_ELECTRICAL;\r\n            SWFP_DAMAGE_VFX = VFX_PRO_LIGHTNING_L; //1036 - With sound\r\n            SWFP_SHAPE = SHAPE_SPELLCYLINDER;\r\n\r\n            effect eLightning = EffectBeam(VFX_BEAM_LIGHTNING_DARK_L, OBJECT_SELF, BODY_NODE_HAND);\r\n\r\n            effect eDam = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n            object oUse = GetFirstObjectInShape(SWFP_SHAPE, 17.0, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            effect eBump = EffectVisualEffect(SWFP_DAMAGE_VFX);\r\n            int nCnt = 1;\r\n            // This will need to be changed to a double while get nearest in shape script.\r\n            //ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(1036), OBJECT_SELF);\r\n            while(GetIsObjectValid(oUse))\r\n            {\r\n                if(GetIsEnemy(oUse))\r\n                {\r\n                    SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                    //Make Immunity Checks\r\n                    if(!ResistForce(OBJECT_SELF, oUse))\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eBump, oUse);\r\n                        if(!WillSave(oUse, Sp_GetJediDCSave(), SWFP_PRIVATE_SAVE_VERSUS_TYPE))\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n                            //ApplyEffectToObject(DURATION_TYPE_INSTANT, eForce, oUse);\r\n                        }\r\n                        else\r\n                        {\r\n                            SWFP_DAMAGE /= 2;\r\n                            eDam = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n\r\n                        }\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLightning, oUse, fLightningDuration);\r\n                    }\r\n                    else\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceResisted(OBJECT_SELF), oTarget);\r\n                    }\r\n                }\r\n                nCnt++;\r\n                oUse = GetNextObjectInShape(SWFP_SHAPE, 17.0, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        MASTER VALOR\r\n        */\r\n        case FORCE_POWER_MIND_MASTERY:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n            SWFP_SHAPE = SHAPE_SPHERE;\r\n            eLink1 = EffectSavingThrowIncrease(SAVING_THROW_ALL,5);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_ALL, 5));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_CHARISMA, 5));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_CONSTITUTION, 5));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_DEXTERITY, 5));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_INTELLIGENCE, 5));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_STRENGTH, 5));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_WISDOM, 5));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectImmunity(IMMUNITY_TYPE_POISON));\r\n            eLink1 = SetEffectIcon(eLink1, 21);\r\n            eLink2 = EffectVisualEffect(VFX_IMP_MIND_MASTERY);\r\n\r\n            Sp_RemoveBuffSpell();\r\n            Sp_ApplyEffects(TRUE, OBJECT_SELF, 30.0, 1000, eLink1, 20.0, eLink2, 0.0);\r\n\r\n        }\r\n        break;\r\n\r\n        /*\r\n        PLAGUE\r\n        */\r\n        case FORCE_POWER_PLAGUE:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n\r\n            eLink1 = EffectPoison(POISON_ABILITY_SCORE_VIRULENT);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectMovementSpeedDecrease(50));\r\n            eLink1 = SetEffectIcon(eLink1, 23);\r\n            if(!GetIsPoisoned(oTarget))\r\n            {\r\n                Sp_ApplyEffects(FALSE, oTarget, 0.0, 1, eLink1, 1000.0, eInvalid, 0.0);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        IMPROVED ENERGY RESISTANCE\r\n        */\r\n        case FORCE_POWER_RESIST_COLD_HEAT_ENERGY:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n\r\n            eLink1 = EffectDamageResistance(DAMAGE_TYPE_COLD, 15);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_FIRE, 15));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_SONIC, 15));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_BLASTER, 15));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_ELECTRICAL, 15));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectImmunity(IMMUNITY_TYPE_POISON));\r\n            eLink1 = SetEffectIcon(eLink1, 24);\r\n            eLink2 = EffectVisualEffect(VFX_PRO_RESIST_POISON);\r\n            if(!SP_CheckEnergyResistance(OBJECT_SELF) && !IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, OBJECT_SELF, 120.0);\r\n                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, OBJECT_SELF, 1.0);\r\n            }\r\n            else if(IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                int nCnt = 0;\r\n                object oParty;\r\n                for(nCnt; nCnt < 3; nCnt++)\r\n                {\r\n                    oParty = GetPartyMemberByIndex(nCnt);\r\n                    if(GetIsObjectValid(oParty))\r\n                    {\r\n                        if(!SP_CheckEnergyResistance(oParty))\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oParty, 120.0);\r\n                            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oParty, 1.0);\r\n                        }\r\n                    }\r\n                }\r\n            }\r\n\r\n            //Sp_ApplyEffects(FALSE, oTarget, 10.0, 3, eLink1, 120.0, eLink2, 1.0);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        RESIST FORCE 1\r\n        */\r\n        case FORCE_POWER_RESIST_FORCE:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n            int nSR = 10 + GetHitDice(OBJECT_SELF);\r\n            eLink1 = EffectForceResistanceIncrease(nSR);\r\n            eLink1 = SetEffectIcon(eLink1, 25);\r\n            eLink2 = EffectVisualEffect(VFX_PRO_RESIST_FORCE);\r\n            if(GetHasSpellEffect(FORCE_POWER_RESIST_FORCE))\r\n            {\r\n                Sp_RemoveSpellEffectsGeneral(FORCE_POWER_RESIST_FORCE, oTarget);\r\n            }\r\n            if(!GetHasSpellEffect(FORCE_POWER_FORCE_IMMUNITY))\r\n            {\r\n                Sp_ApplyEffects(TRUE, oTarget, 0.0, 1, eLink1, 60.0, eLink2, 1.0);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        RESIST ENERGY\r\n        */\r\n\r\n        case FORCE_POWER_RESIST_POISON_DISEASE_SONIC:\r\n        {\r\n            if(!SP_CheckEnergyResistance(OBJECT_SELF))\r\n            {\r\n                SWFP_HARMFUL = FALSE;\r\n                eLink1 = EffectDamageResistance(DAMAGE_TYPE_COLD, 15);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_FIRE, 15));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_SONIC, 15));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_ELECTRICAL, 15));\r\n                eLink1 = SetEffectIcon(eLink1, 26);\r\n                eLink2 = EffectVisualEffect(VFX_PRO_RESIST_ELEMENTS);\r\n                Sp_ApplyEffects(FALSE, oTarget, 0.0, 1, eLink1, 120.0, eLink2, 1.0);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        SHOCK\r\n        */\r\n        case FORCE_POWER_SHOCK:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_ELECTRICAL;\r\n            int nDamage = GetHitDice(OBJECT_SELF);\r\n            if(nDamage > 10)\r\n            {\r\n                nDamage = 10;\r\n            }\r\n            SWFP_DAMAGE = d6(nDamage);\r\n            SP_MyPostString(IntToString(SWFP_DAMAGE),5,5,4.0);\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_ELECTRICAL;\r\n            SWFP_DAMAGE_VFX = VFX_PRO_LIGHTNING_S;\r\n            effect eDamage = EffectDamage(SWFP_DAMAGE, DAMAGE_TYPE_ELECTRICAL);\r\n            effect eDamage2 = EffectDamage(SWFP_DAMAGE/2, DAMAGE_TYPE_ELECTRICAL);\r\n\r\n            int nSaves = Sp_MySavingThrows(oTarget);\r\n            int nResist = Sp_BlockingChecks(oTarget, eDamage, eInvalid, eInvalid);\r\n            eLink1 = EffectBeam(2066, OBJECT_SELF, BODY_NODE_HAND); //P.W.(May 19, 2003) Changed to Shock beam effect.\r\n\r\n            if(nResist == 0)\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, fLightningDuration);\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_PRO_LIGHTNING_S), oTarget);\r\n                if(nSaves == 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage2, oTarget);\r\n                }\r\n            }\r\n            //Sp_ApplyEffects(FALSE, oTarget, 0.0, 1, eLink1, fLightningDuration, eInvalid, 0.0);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        STASIS\r\n        */\r\n        case FORCE_POWER_HOLD:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n            eLink1 = EffectParalyze();\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_HOLD));\r\n            eLink1 = SetEffectIcon(eLink1, 15);\r\n\r\n            eLink2 = EffectMovementSpeedDecrease(50);\r\n            eLink2 = EffectLinkEffects(eLink2, EffectACDecrease(4));\r\n            eLink2 = SetEffectIcon(eLink2, 15);\r\n\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            //Make Immunity Checks\r\n            int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n            if(nResist == 0)\r\n            {\r\n                int nSaves = Sp_MySavingThrows(oTarget);\r\n                if(nSaves == 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 12.0);\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, 12.0);\r\n                }\r\n            }\r\n            else\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        STASIS FIELD\r\n        */\r\n        case FORCE_POWER_SLEEP:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n\r\n            eLink1 = EffectParalyze();\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_HOLD));\r\n            eLink1 = SetEffectIcon(eLink1, 27);\r\n\r\n            eLink2 = EffectMovementSpeedDecrease(50);\r\n            eLink2 = EffectLinkEffects(eLink2, EffectACDecrease(4));\r\n            eLink2 = SetEffectIcon(eLink2, 27);\r\n\r\n            oTarget = GetFirstObjectInShape(SHAPE_SPHERE, 10.0, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            while(GetIsObjectValid(oTarget))\r\n            {\r\n                if(GetIsEnemy(oTarget) && GetRacialType(oTarget) != RACIAL_TYPE_DROID)\r\n                {\r\n                    SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                    //Make Immunity Checks\r\n                    int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n                    if(nResist == 0)\r\n                    {\r\n                        int nSaves = Sp_MySavingThrows(oTarget);\r\n                        if(nSaves == 0)\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 12.0);\r\n                        }\r\n                        else\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, 12.0);\r\n                        }\r\n                    }\r\n                }\r\n                oTarget = GetNextObjectInShape(SHAPE_SPHERE, 10.0, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        SLOW\r\n        */\r\n        case FORCE_POWER_SLOW:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n\r\n            eLink1 = EffectMovementSpeedDecrease(50);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectACDecrease(2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAttackDecrease(2));\r\n            //eLink1 = EffectLinkEffects(eLink1, EffectDamageDecrease(2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowDecrease(SAVING_THROW_REFLEX,2));\r\n            eLink2 = EffectVisualEffect(VFX_PRO_AFFLICT);\r\n            eLink1 = SetEffectIcon(eLink1, 28);\r\n\r\n            Sp_ApplyEffects(TRUE, oTarget, 0.0, 1, eLink1, 30.0, eLink2, 1.0);\r\n        }\r\n        break;\r\n        /*\r\n        BURST OF SPEED\r\n        */\r\n        case FORCE_POWER_SPEED_BURST:\r\n        {\r\n            if(!GetHasSpellEffect(FORCE_POWER_KNIGHT_SPEED) &&\r\n               !GetHasSpellEffect(FORCE_POWER_SPEED_MASTERY))\r\n            {\r\n                SWFP_HARMFUL = FALSE;\r\n                eLink1 = EffectMovementSpeedIncrease(99);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectACIncrease(2));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_KNIGHTS_SPEED));\r\n                eLink1 = SetEffectIcon(eLink1, 2);\r\n                if(OBJECT_SELF == GetPartyMemberByIndex(0))\r\n                {\r\n                    eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_SPEED));\r\n                }\r\n                if(GetHasSpellEffect(FORCE_POWER_SPEED_BURST, oTarget))\r\n                {\r\n                    Sp_RemoveSpellEffectsGeneral(FORCE_POWER_SPEED_BURST, oTarget);\r\n                }\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, 36.0, eInvalid, 0.0);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        KNIGHT SPEED\r\n        */\r\n        case FORCE_POWER_KNIGHT_SPEED:\r\n        {\r\n            if(!GetHasSpellEffect(FORCE_POWER_SPEED_MASTERY))\r\n            {\r\n                SWFP_HARMFUL = FALSE;\r\n                eLink1 = EffectMovementSpeedIncrease(99);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectACIncrease(4));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectModifyAttacks(1));\r\n                eLink1 = SetEffectIcon(eLink1, 20);\r\n\r\n                if(OBJECT_SELF == GetPartyMemberByIndex(0))\r\n                {\r\n                    eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_SPEED));\r\n                    //eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_IMP_SPEED_KNIGHT));\r\n                }\r\n\r\n                if(GetHasSpellEffect(FORCE_POWER_SPEED_BURST, oTarget))\r\n                {\r\n                    Sp_RemoveSpellEffectsGeneral(FORCE_POWER_SPEED_BURST, oTarget);\r\n                }\r\n                if(GetHasSpellEffect(FORCE_POWER_KNIGHT_SPEED, oTarget))\r\n                {\r\n                    Sp_RemoveSpellEffectsGeneral(FORCE_POWER_KNIGHT_SPEED, oTarget);\r\n                }\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, 36.0, eInvalid, 0.0);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        MASTER SPEED\r\n        */\r\n        case FORCE_POWER_SPEED_MASTERY:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n            eLink1 = EffectMovementSpeedIncrease(99);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectACIncrease(4));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectModifyAttacks(2));\r\n            eLink1 = SetEffectIcon(eLink1, 22);\r\n\r\n            if(OBJECT_SELF == GetPartyMemberByIndex(0))\r\n            {\r\n                eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_SPEED));\r\n                //eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_IMP_SPEED_MASTERY));\r\n            }\r\n            if(GetHasSpellEffect(FORCE_POWER_SPEED_BURST, oTarget))\r\n            {\r\n                Sp_RemoveSpellEffectsGeneral(FORCE_POWER_SPEED_BURST, oTarget);\r\n            }\r\n            if(GetHasSpellEffect(FORCE_POWER_KNIGHT_SPEED, oTarget))\r\n            {\r\n                Sp_RemoveSpellEffectsGeneral(FORCE_POWER_KNIGHT_SPEED, oTarget);\r\n            }\r\n            if(GetHasSpellEffect(FORCE_POWER_SPEED_MASTERY, oTarget))\r\n            {\r\n                Sp_RemoveSpellEffectsGeneral(FORCE_POWER_SPEED_MASTERY, oTarget);\r\n            }\r\n            Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, 36.0, eInvalid, 0.0);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        STUN\r\n        */\r\n        case FORCE_POWER_STUN:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_MIND_AFFECTING;\r\n\r\n            eLink1 = EffectStunned();\r\n            //eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_HOLD));\r\n            eLink1 = SetEffectIcon(eLink1, 29);\r\n\r\n            eLink2 = EffectMovementSpeedDecrease(50);\r\n            eLink2 = EffectLinkEffects(eLink2, EffectACDecrease(4));\r\n            eLink1 = SetEffectIcon(eLink1, 29);\r\n\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            //Make Immunity Checks\r\n            int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n            int nSaves;\r\n            if(nResist == 0)\r\n            {\r\n                nSaves = Sp_MySavingThrows(oTarget);\r\n                if(nSaves == 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 9.0);\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, 9.0);\r\n                }\r\n            }\r\n            if(nResist > 0 || nSaves > 0)\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        SUPRESS FORCE\r\n        */\r\n        case FORCE_POWER_SUPRESS_FORCE:\r\n        {\r\n            effect eBuff = GetFirstEffect(oTarget);\r\n            int bValid = FALSE;\r\n            while(GetIsEffectValid(eBuff))\r\n            {\r\n                if(GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_AURA ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_SHIELD ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_MIND ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_KNIGHT_MIND ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_SPEED_BURST ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_KNIGHT_SPEED ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_RESIST_FORCE ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_RESIST_POISON_DISEASE_SONIC)\r\n                 {\r\n                    RemoveEffect(oTarget, eBuff);\r\n                 }\r\n                 eBuff = GetNextEffect(oTarget);\r\n            }\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId()));\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_FORCE_BREACH), oTarget);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        WOUND\r\n        */\r\n        case FORCE_POWER_WOUND:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n            SWFP_DAMAGE = (GetHitDice(OBJECT_SELF)*2)/3;\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;\r\n\r\n            effect eChoke = EffectChoke();\r\n            eChoke = SetEffectIcon(eChoke, 31);\r\n            effect eDamage = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n\r\n            int nResist = Sp_BlockingChecks(oTarget, eChoke, eDamage, eInvalid);\r\n            int nSaves;\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            if(nResist == 0)\r\n            {\r\n                nSaves = Sp_MySavingThrows(oTarget);\r\n                if(nSaves == 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_CHOKE), oTarget);\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eChoke, oTarget, 6.0);\r\n                    int nIdx = 1;\r\n                    float fDelay;\r\n                    SP_InterativeDamage(eDamage, 7, oTarget);\r\n                }\r\n            }\r\n            if(nResist > 0 || nSaves > 0)\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n        }\r\n        break;\r\n\r\n        case SPECIAL_ABILITY_BODY_FUEL:\r\n        {\r\n            effect eBody = EffectBodyFuel();\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBody, OBJECT_SELF, 30.0);\r\n        }\r\n        break;\r\n        case SPECIAL_ABILITY_ENHANCED_SENSES:\r\n        {\r\n            effect eAC = EffectACDecrease(6);\r\n            effect eAware = EffectSkillIncrease(SKILL_AWARENESS, 10);\r\n            effect eSee = EffectTrueSeeing();\r\n            eLink1 = EffectLinkEffects(eAC, eAware);\r\n            eLink1 = EffectLinkEffects(eLink1, eAware);\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, OBJECT_SELF, RoundsToSeconds(10));\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_MIND_FORCE), OBJECT_SELF);\r\n        }\r\n        break;\r\n\r\n        case SPECIAL_ABILITY_PSYCHIC_STANCE:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_MIND_AFFECTING;\r\n\r\n            eLink1 = EffectPsychicStatic();\r\n            Sp_ApplyEffects(TRUE, oTarget, 10.0, 1000, eLink1, 20.0, eInvalid, 0.0);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        Rage\r\n        This ability allows Zaalbar to fly into a rage.\r\n        When Zaalbar flies into a rage he gains +4 to his Strength and Constitution.  He also gains a +2 bonus on\r\n        Fortitude and Will saves.  While raging Zaalbar cannot use any skills.  He also has a -4 penalty to his Defense rating.\r\n        Interface: Mystical.  It takes one round to initiate the rage.\r\n        Prerequisites: Nothing.  This is a unique NPC power.\r\n        */\r\n        case SPECIAL_ABILITY_RAGE:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_FORT, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_WILL, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_CONSTITUTION, 4));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_STRENGTH, 4));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectACDecrease(4));\r\n\r\n            Sp_ApplyEffects(TRUE, OBJECT_SELF, 0.0, 1, eLink1, 30.0, eInvalid, 0.0);\r\n        }\r\n        break;\r\n\r\n        case 83: //Monster Slam Attack\r\n        {\r\n            SP_MyPrintString("I am attempting to use monster slam");\r\n\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_REFLEX;\r\n            SWFP_DAMAGE = GetHitDice(OBJECT_SELF);\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;\r\n\r\n            eLink1 = EffectForcePushed();\r\n            eLink2 = EffectStunned();\r\n            effect eDamage = EffectDamage(GetHitDice(OBJECT_SELF), SWFP_DAMAGE_TYPE);\r\n\r\n            if(!ReflexSave(oTarget, 15))\r\n            {\r\n                eDamage = EffectDamage(GetHitDice(OBJECT_SELF), SWFP_DAMAGE_TYPE);\r\n                DelayCommand(0.5, SP_MyApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget));\r\n                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 0.25);\r\n                DelayCommand(2.55, SP_MyApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, 3.0));\r\n            }\r\n            else\r\n            {\r\n                eDamage = EffectDamage(GetHitDice(OBJECT_SELF)/2, SWFP_DAMAGE_TYPE);\r\n                DelayCommand(0.5, SP_MyApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 0.25));\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_FORCE_PUSH), oTarget);\r\n\r\n            }\r\n        }\r\n        break;\r\n\r\n        case 130: //Fire Breath Weapon\r\n        {\r\n            oTarget = GetSpellTargetObject();\r\n            int nDC = 15;\r\n            int nDamage = 40;\r\n            effect eBeam = EffectBeam(2053, OBJECT_SELF, BODY_NODE_HEAD);\r\n            effect eVFX = EffectVisualEffect(1039);\r\n            effect eBump = EffectVisualEffect(2062);\r\n            effect eHorror = EffectHorrified();\r\n            eHorror = SetEffectIcon(eHorror, 57);\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, eVFX, oTarget);\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBeam, oTarget, 1.0);\r\n            if(GetHitDice(oTarget) < 7 || FortitudeSave(oTarget, 15) == FALSE)\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eHorror, oTarget, 3.0);\r\n            }\r\n            DelayCommand(0.33, SP_MyApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBump, oTarget, 1.5));\r\n            if(ReflexSave(oTarget, nDC, SAVING_THROW_TYPE_FIRE))\r\n            {\r\n                nDamage /= 2;\r\n            }\r\n            effect eDam = EffectDamage(nDamage, DAMAGE_TYPE_FIRE);\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oTarget);\r\n        }\r\n        break;\r\n\r\n        case 131:\r\n        {\r\n            int nVFX = 3002;\r\n            int nDC = 15;\r\n            effect eDex = EffectAbilityDecrease(ABILITY_DEXTERITY, 3);\r\n            eDex = SetEffectIcon(eDex, 41);\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(nVFX), OBJECT_SELF);\r\n            oTarget = GetFirstObjectInShape(SHAPE_SPHERE, 10.0, GetSpellTargetLocation());\r\n            while(GetIsObjectValid(oTarget))\r\n            {\r\n                if(GetIsEnemy(oTarget))\r\n                {\r\n                    if(!FortitudeSave(oTarget, nDC, SAVING_THROW_TYPE_SONIC))\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eDex, oTarget, 30.0);\r\n                    }\r\n                }\r\n                oTarget = GetNextObjectInShape(SHAPE_SPHERE, 4.0, GetSpellTargetLocation());\r\n            }\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: While Loop Effect Delivery\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Uses these values to deliver the effects in the\r\n    loop.\r\n\r\n    SWFP_PRIVATE_SAVE_TYPE;\r\n    SWFP_PRIVATE_SAVE_VERSUS_TYPE;\r\n    SWFP_DAMAGE;\r\n    SWFP_DAMAGE_TYPE;\r\n    SWFP_DAMAGE_VFX;\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Aug 2, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid Sp_ApplyEffects(int nBlocking, object oAnchor, float fSize, int nCounter, effect eLink1, float fDuration1, effect eLink2, float fDuration2, int nRacial = RACIAL_TYPE_ALL)\r\n{\r\n    int nCnt = 0;\r\n    object oTarget;\r\n    //By setting the counter to 1 you specify a single target.\r\n    //By setting the counter to 1000, you specify all targets in a shape.\r\n    //By setting the counter to another number you specify that many targets maximum.\r\n    if(nCounter > 1)\r\n    {\r\n        oTarget = GetFirstObjectInShape(SWFP_SHAPE, fSize, GetLocation(oAnchor));\r\n    }\r\n    else if(nCounter == 1)\r\n    {\r\n        oTarget = oAnchor;\r\n    }\r\n    while(GetIsObjectValid(oTarget) && nCnt < nCounter)\r\n    {\r\n        if(nRacial == GetRacialType(oTarget) || nRacial == RACIAL_TYPE_ALL)\r\n        {\r\n            int nIdx = 0; // Index for the for loop link application.\r\n            effect eUse;  // Current effect to use\r\n            float fUse;   // Current duration to use\r\n            int nDamage;  // The damage as set from SWFP_DAMAGE\r\n            int bFizzle;  // Tracks whether the Fizzle has played on the caster yet or not.\r\n            effect eDamage; // The damage effect which will be linked after the saves are done and checked with blocking.\r\n            if((GetIsEnemy(oTarget) && SWFP_HARMFUL == TRUE) || (GetIsFriend(oTarget) && SWFP_HARMFUL == FALSE))\r\n            {\r\n                SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                //eDamage = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                int nResist = FALSE;\r\n                int nSaves = -1;\r\n                if(SWFP_HARMFUL == TRUE)\r\n                {\r\n                    nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eDamage);\r\n                }\r\n                //By adding another index the number of links added to this function can increase.\r\n                for(nIdx; nIdx <= 1; nIdx++)\r\n                {\r\n                    if(nIdx == 0)\r\n                    {\r\n                        eUse = eLink1;\r\n                        fUse = fDuration1;\r\n                    }\r\n                    else\r\n                    {\r\n                        eUse = eLink2;\r\n                        fUse = fDuration2;\r\n                    }\r\n                    if(nResist == FALSE)\r\n                    {\r\n                        //MODIFIED by Preston Watamaniuk March 23\r\n                         //Moved the save call down to here from up above with the resist inorder to help\r\n                         //feedback system not make useless save calls.\r\n                        //MODIFIED by Preston Watamaniuk March 24\r\n                         //Made the default value of nSave -1 so that I only do it once.\r\n                        //MODIFIED by Preston Watamaniuk April 5\r\n                         //Made sure to set nSaves to FALSE so that it would fall through the function.\r\n                        if(SWFP_HARMFUL == TRUE && nSaves == -1)\r\n                        {\r\n                            nSaves = Sp_MySavingThrows(oTarget);\r\n                        }\r\n                        else\r\n                        {\r\n                            nSaves = FALSE;\r\n                        }\r\n                        if(nSaves == FALSE)\r\n                        {\r\n                            if(nIdx == 1 && SWFP_DAMAGE > 0)\r\n                            //Damage effects are always linked to the eDamage effect which is kept seperate from\r\n                            //all other eLink types coming in.\r\n                            {\r\n                                eDamage = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                                eDamage = EffectLinkEffects(eDamage, EffectVisualEffect(SWFP_DAMAGE_VFX));\r\n                                ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                            }\r\n                            if(GetIsEffectValid(eUse))\r\n                            {\r\n                                Sp_ApplyForcePowerEffects(fUse, eUse, oTarget);\r\n                            }\r\n                        }\r\n                        //If the blocking flag is true then do not apply any effects on a save.\r\n                        else if(nSaves > 0 && nBlocking == FALSE)\r\n                        {\r\n                            if(nIdx == 1 && SWFP_DAMAGE > 0)\r\n                            {\r\n                                SWFP_DAMAGE /= 2;\r\n                                eDamage = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                                eDamage = EffectLinkEffects(eDamage, EffectVisualEffect(SWFP_DAMAGE_VFX));\r\n                                ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                            }\r\n                            if(GetIsEffectValid(eUse))\r\n                            {\r\n                                Sp_ApplyForcePowerEffects(fUse, eUse, oTarget);\r\n                            }\r\n                        }\r\n                    }\r\n                    if(nResist > 0 || (nSaves > 0 && nBlocking > 0))\r\n                    {\r\n                        if(bFizzle == FALSE)\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                            bFizzle = TRUE;\r\n                        }\r\n                    }\r\n                }\r\n                nCnt++;\r\n            }\r\n        }\r\n        oTarget = GetNextObjectInShape(SWFP_SHAPE, fSize, GetLocation(oAnchor), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Remove Buff Bonuses\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Goes through and removes all of the bonuses\r\n    from people in a 30m radius from Force Mind,\r\n    Knight Mind, Mind Mastery and Battle Meditation\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Aug 7, 2002\r\n//:://////////////////////////////////////////////\r\nvoid Sp_RemoveBuffSpell()\r\n{\r\n    object oTarget = GetFirstObjectInShape(SHAPE_SPHERE, 30.0, GetLocation(OBJECT_SELF));\r\n    while(GetIsObjectValid(oTarget))\r\n    {\r\n        if(GetFactionEqual(oTarget))\r\n        {\r\n            //Declare major variables\r\n            int bValid = FALSE;\r\n            effect eAOE;\r\n            if(GetHasSpellEffect(FORCE_POWER_FORCE_MIND, oTarget) ||\r\n               GetHasSpellEffect(FORCE_POWER_MIND_MASTERY, oTarget) ||\r\n               GetHasSpellEffect(FORCE_POWER_KNIGHT_MIND, oTarget) ||\r\n               GetHasSpellEffect(SPECIAL_ABILITY_BATTLE_MEDITATION, oTarget))\r\n            {\r\n                //Search through the valid effects on the target.\r\n                eAOE = GetFirstEffect(oTarget);\r\n                while (GetIsEffectValid(eAOE) && bValid == FALSE)\r\n                {\r\n                    //If the effect was created by the spell then remove it\r\n                    if(GetEffectSpellId(eAOE) == FORCE_POWER_FORCE_MIND ||\r\n                       GetEffectSpellId(eAOE) == FORCE_POWER_MIND_MASTERY ||\r\n                       GetEffectSpellId(eAOE) == FORCE_POWER_KNIGHT_MIND ||\r\n                       GetEffectSpellId(eAOE) == SPECIAL_ABILITY_BATTLE_MEDITATION)\r\n                    {\r\n                        RemoveEffect(oTarget, eAOE);\r\n                    }\r\n                    //Get next effect on the target\r\n                    eAOE = GetNextEffect(oTarget);\r\n                }\r\n            }\r\n        }\r\n        oTarget = GetNextObjectInShape(SHAPE_SPHERE, 30.0, GetLocation(OBJECT_SELF));\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Check for Appearance Type Turret\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks to see if the target is a Turret\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 10, 2003\r\n//:://////////////////////////////////////////////\r\nint SP_CheckAppearanceTurret(object oTarget, int nFeedback = FALSE)\r\n{\r\n    int nCheck = FALSE;\r\n\r\n    SP_MyPostString("Appearance = " + IntToString(GetAppearanceType(oTarget)));\r\n\r\n    if(GetAppearanceType(oTarget) == 182 || GetAppearanceType(oTarget) == 183)\r\n    {\r\n        if(nFeedback == TRUE)\r\n        {\r\n            DisplayFeedBackText(oTarget, 1);\r\n        }\r\n        nCheck = TRUE;\r\n    }\r\n    return nCheck;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Check Droid Appearance Type\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks to see if the target is a Mark 1, 2, 4\r\n    or Spyder Droid\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 10, 2003\r\n//:://////////////////////////////////////////////\r\nint SP_CheckAppearanceGeoDroid(object oTarget)\r\n{\r\n    int nCheck = FALSE;\r\n    if(GetAppearanceType(oTarget) == 59 ||\r\n       GetAppearanceType(oTarget) == 60 ||\r\n       GetAppearanceType(oTarget) == 61 ||\r\n       GetAppearanceType(oTarget) == 65)\r\n    {\r\n        nCheck = TRUE;\r\n    }\r\n    return nCheck;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Check Droid Appearance Type and and Shields\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks to see if the target is a Mark 1, 2, 4\r\n    or Spyder Droid and has a shield activated\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 10, 2003\r\n//:://////////////////////////////////////////////\r\nint SP_CheckAppearanceGeoDroidShields(object oTarget, int nFeedback = FALSE)\r\n{\r\n    int nCheck = FALSE;\r\n    if(GetAppearanceType(oTarget) == 59 ||\r\n       GetAppearanceType(oTarget) == 60 ||\r\n       GetAppearanceType(oTarget) == 61 ||\r\n       GetAppearanceType(oTarget) == 65)\r\n    {\r\n        if(GetHasSpellEffect(110, oTarget) ||\r\n           GetHasSpellEffect(111, oTarget) ||\r\n           GetHasSpellEffect(112, oTarget) ||\r\n           GetHasSpellEffect(113, oTarget) ||\r\n           GetHasSpellEffect(114, oTarget) ||\r\n           GetHasSpellEffect(115, oTarget))\r\n         {\r\n            if(nFeedback == TRUE)\r\n            {\r\n                DisplayFeedBackText(oTarget, 1);\r\n            }\r\n\r\n            nCheck = TRUE;\r\n         }\r\n    }\r\n    return nCheck;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Force Push Viability\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns TRUE if the target can be force pushed\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: June 12, 2003\r\n//:://////////////////////////////////////////////\r\nint SP_CheckForcePushViability(object oTarget, int Whirlwind)\r\n{\r\n    int bValid = FALSE;\r\n\r\n    SP_MyPrintString("Push Check Start");\r\n    if(GetCreatureSize(oTarget) != CREATURE_SIZE_LARGE &&\r\n       GetCreatureSize(oTarget) != CREATURE_SIZE_HUGE)\r\n    {\r\n        SP_MyPrintString("Size is OK");\r\n        if(SP_CheckAppearanceTurret(oTarget) == FALSE)\r\n        {\r\n            SP_MyPrintString("I am not a turret");\r\n            if((Whirlwind == TRUE && SP_CheckAppearanceGeoDroidShields(oTarget) == FALSE) ||\r\n                Whirlwind == FALSE)\r\n            {\r\n                SP_MyPrintString("I am whirlwind without droid shiled or not whirlwind");\r\n                if(GetCreatureMovmentType(oTarget) != MOVEMENT_SPEED_IMMOBILE)\r\n                {\r\n                    SP_MyPrintString("Returning Push True");\r\n                    bValid = TRUE;\r\n                }\r\n            }\r\n        }\r\n    }\r\n\r\n    if(bValid == FALSE)\r\n    {\r\n        DisplayFeedBackText(oTarget, 1);\r\n    }\r\n    return bValid;\r\n}\r\n\r\n\r\nvoid SP_MyPrintString(string sString)\r\n{\r\n    if(!ShipBuild())\r\n    {\r\n        sString = "SPELL GENERIC DEBUG STRING: " + sString;\r\n        PrintString(sString);\r\n    }\r\n}\r\n\r\nvoid SP_MyPostString(string sString, int n1 = 5, int n2 = 10, float fTime = 4.0)\r\n{\r\n    sString = "DEBUG: " + sString;\r\n    AurPostString(sString,10,10,3.0);\r\n}\r\n\r\n\r\n', 'k_inc_generic': b'//:: k_inc_generic\r\n/*\r\n    v1.5\r\n    Generic Include for KOTOR\r\n    Post Clean Up as of March 3, 2003\r\n*/\r\n//:: Created By: Preston Watamaniuk\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n\r\n#include "k_inc_gensupport"\r\n#include "k_inc_walkways"\r\n#include "k_inc_drop"\r\n\r\nstruct tLastRound\r\n{\r\n    int nLastAction;\r\n    int nLastActionID;\r\n    int nLastTalentCode;\r\n    object oLastTarget;\r\n    int nTalentSuccessCode;\r\n    int nIsLastTargetDebil;\r\n    int nLastCombo;\r\n    int nLastComboIndex;\r\n    int nCurrentCombo;\r\n    int nBossSwitchCurrent;\r\n};\r\n\r\nstruct tLastRound tPR;\r\n\r\n//LOCAL BOOLEANS RANGE FROM 0 to 96\r\nint AMBIENT_PRESENCE_DAY_ONLY = 1;        //POSSIBLE CUT\r\nint AMBIENT_PRESENCE_NIGHT_ONLY = 2;      //POSSIBLE CUT\r\nint AMBIENT_PRESENCE_ALWAYS_PRESENT = 3;\r\n\r\nint SW_FLAG_EVENT_ON_PERCEPTION =   20;\r\nint SW_FLAG_EVENT_ON_ATTACKED   =   21;\r\nint SW_FLAG_EVENT_ON_DAMAGED    =   22;\r\nint SW_FLAG_EVENT_ON_FORCE_AFFECTED = 23;\r\nint SW_FLAG_EVENT_ON_DISTURBED = 24;\r\nint SW_FLAG_EVENT_ON_COMBAT_ROUND_END = 25;\r\nint SW_FLAG_EVENT_ON_DIALOGUE    = 26;\r\nint SW_FLAG_EVENT_ON_DEATH       = 27;\r\nint SW_FLAG_EVENT_ON_HEARTBEAT   = 28;\r\n//int SW_FLAG_AMBIENT_ANIMATIONS = 29;          located in k_inc_walkways\r\n//int SW_FLAG_AMBIENT_ANIMATIONS_MOBILE = 30;   located in k_inc_walkways\r\nint SW_FLAG_FAST_BUFF            = 31;   //POSSIBLE CUT\r\nint SW_FLAG_ASC_IS_BUSY          = 32;   //POSSIBLE CUT\r\nint SW_FLAG_ASC_AGGRESSIVE_MODE  = 33;   //POSSIBLE CUT\r\nint SW_FLAG_AMBIENT_DAY_ONLY     = 40;   //POSSIBLE CUT\r\nint SW_FLAG_AMBIENT_NIGHT_ONLY   = 43;   //POSSIBLE CUT\r\nint SW_FLAG_EVENT_ON_SPELL_CAST_AT = 44;\r\nint SW_FLAG_EVENT_ON_BLOCKED     = 45;\r\nint SW_FLAG_ON_DIALOGUE_COMPUTER = 48;\r\nint SW_FLAG_FORMATION_POSITION_0 = 49;   //POSSIBLE CUT\r\nint SW_FLAG_FORMATION_POSITION_1 = 50;   //POSSIBLE CUT\r\nint SW_FLAG_FORMATION_POSITION_2 = 51;   //POSSIBLE CUT\r\nint SW_FLAG_FORMATION_POSITION_3 = 52;   //POSSIBLE CUT\r\nint SW_FLAG_FORMATION_POSITION_4 = 53;   //POSSIBLE CUT\r\nint SW_FLAG_FORMATION_POSITION_5 = 54;   //POSSIBLE CUT\r\nint SW_FLAG_FORMATION_POSITION_6 = 55;   //POSSIBLE CUT\r\nint SW_FLAG_FORMATION_POSITION_7 = 56;   //POSSIBLE CUT\r\nint SW_FLAG_FORMATION_POSITION_8 = 57;   //POSSIBLE CUT\r\nint SW_FLAG_FORMATION_POSITION_9 = 58;   //POSSIBLE CUT\r\n//int SW_FLAG_TARGET_FRIEND      = 59;        Located in k_inc_gensupport\r\nint SW_FLAG_COMMONER_BEHAVIOR    = 60;\r\nint SW_FLAG_SPECTATOR_STATE      = 61;\r\nint SW_FLAG_AI_OFF               = 62;\r\nint SW_CANDEROUS_COMBAT_REGEN    = 63;\r\nint SW_FLAG_BOSS_AI              = 64;\r\nint SW_FLAG_SHIELD_USED          = 65;\r\nint SW_FLAG_EVENT_ON_DIALOGUE_END = 66;\r\nint SW_FLAG_RESISTANCES_APPLIED  = 67;\r\nint SW_FLAG_EVENT_DIALOGUE_END   = 68;   //User defined event\r\n//This flag is set when the creature percieves a hostile for the first time.\r\n//Used to eliminate the delay a creature puts on his perception event when first seeing a hostile.\r\nint SW_FLAG_STATE_AGITATED       = 69;\r\nint SW_FLAG_MALAK_AI_ON          = 70;\r\nint SW_FLAG_DYNAMIC_COMBAT_ZONE  = 71;\r\nint SW_FLAG_EVENT_ON_DIALOGUE_INTERRUPT  = 72;\r\n\r\n//TALENT ROUTINES\r\nint GEN_TALENT_SUPRESS_FORCE = 1;\r\nint GEN_TALENT_REMOVE_POISON = 2;\r\nint GEN_TALENT_HEALING       = 3;\r\nint GEN_TALENT_BUFF          = 4;\r\n\r\n//Sets the NPC listening patterns for the purposes of shouts\r\nvoid GN_SetListeningPatterns();\r\n//Determines what combat actions the character is going to take.\r\nvoid GN_DetermineCombatRound(object oIntruder = OBJECT_INVALID);\r\n// Function used by the On Dialogue script to determine what to do when a NPC gets shout\r\nvoid GN_RespondToShout(object oShouter, int nShoutIndex, object oIntruder = OBJECT_INVALID);\r\n//Sets the day night patterns for the creature.  Uses the AMBIENCE_ constants.\r\nvoid GN_SetDayNightPresence(int nPresenceSetting);\r\n//Sets the attack target depending on whether oTarget or oIntruder is Valid\r\nobject GN_DetermineAttackTarget(object oIntruder = OBJECT_INVALID);\r\n//Makes the character flee the center of an explosion\r\nvoid GN_DodgeGrenade(object oIntruder);\r\n//Resets the formation booleans on a character.\r\nvoid GN_ResetFormationBooleans();\r\n//Checks which position on a character is free.\r\nvoid GN_MoveToFormation(object oAnchor, int nFormationType);\r\n//Runs the default AI routine\r\nint GN_RunDefaultAIRoutine(object oIntruder = OBJECT_INVALID);\r\n//Runs the Aid AI routine\r\nint GN_RunAidAIRoutine(object oIntruder = OBJECT_INVALID);\r\n//Runs the Grenade Thrower AI\r\nint GN_RunGrenadeAIRoutine(object oIntruder = OBJECT_INVALID);\r\n//Runs the Jedi Support AI routine\r\nint GN_RunJediSupportAIRoutine(object oIntruder = OBJECT_INVALID);\r\n//Runs the Boss AI Routine\r\nint GN_RunBossAIRoutine(object oIntruder = OBJECT_INVALID);\r\n//Run Boss Grenade AI Routine\r\nint GN_RunBossGrenadeAI();\r\n//Run Boss AOE Force Power Routine\r\nint GN_RunBossAOEPowerRoutine();\r\n//Runs special AI just for Darth Malak on the Star Forge\r\nint GN_RunMalakAIRoutine();\r\n//Run Boss Targeted Routine\r\nint GN_RunBossTargetedRoutine();\r\n//Sets up struct tLastRound to allow for a single point of determination.\r\nvoid GN_SetLastRoundData();\r\n//Makes the person or droid activate a shield\r\nint GN_ActivateForceField();\r\n//Makes the person activate Resist Elements and Resist Force.\r\nint GN_ActivateResistances();\r\n//Resets a Droid to his deactivated animation\r\nvoid GN_ResetDroidDeactivationState(object oDroid = OBJECT_SELF);\r\n//Checks the target and the droid utility use to make sure they are compatible\r\ntalent GN_CheckDroidUtilityUsage(object oTarget, talent tUse);\r\n//Checks the target and the force power to make sure that a lightsaber is not thrown from close range.\r\ntalent GN_CheckThrowLightSaberUsage(object oTarget, talent tUse);\r\n//Checks the target and the force power to make sure that a non-droid force power is used against a droid\r\ntalent GN_CheckNonDroidForcePower(object oTarget, talent tUse);\r\n//Performs a series of checks in case the combat portion of DetermineCombatRound falls through.\r\nint GN_DoPostDCRChecks();\r\n//A void version of do post DCR checks for use with action do command.\r\nvoid GN_ActionDoPostDCRChecks();\r\n\r\n//Determine Combat Round Targeting Funtions\r\n//This function returns an object if OBJECT_SELF is poisoned, or if any party member is poisoned.\r\nobject GN_CheckIfPoisoned();\r\n//This function returns an object if OBJECT_SELF is below 50% health, or if any party member is injured.\r\nobject GN_CheckIfInjured();\r\n//This checks the last hostile target and determines the best attack action based on the last round.\r\nint GN_GetAttackTalentCode(object oTarget);\r\n//Pass in a talent type and a target to have object_self use the talent\r\nint GN_TalentMasterRoutine(int nTalentConstant, object oTarget);\r\n//Determines where in the current combo the character is and what to do next based on AI style, and combat info.\r\ntalent GN_GetComboMove(int nBoss = FALSE);\r\n//Plays an Ambient Animation depending on the spawn in condition selected.\r\nvoid GN_PlayAmbientAnimation();\r\n// This causes peasants to flee when people\r\nint GN_CommonAI();\r\n//Should Commoners run away.  This returns a yes or no based on a set of conditions\r\nint GN_CheckShouldFlee();\r\n\r\n\r\nvoid GN_DetermineCombatRound(object oIntruder = OBJECT_INVALID)\r\n{\r\n    GN_MyPrintString("");\r\n    GN_MyPrintString("GENERIC DEBUG *************** START DETERMINE COMBAT ROUND " + GN_ReturnDebugName(OBJECT_SELF));\r\n\r\n    GN_SetLastRoundData();\r\n    int nPartyAI = GetPartyAIStyle(); //Determines how the party should react to intruders\r\n    int nNPC_AI = GetNPCAIStyle(OBJECT_SELF); //Determines how the individual should react in combat\r\n    GN_MyPrintString("GENERIC DEBUG *************** AI STYLE = " + GN_ReturnAIStyle());\r\n    if(!GN_GetSpawnInCondition(SW_FLAG_COMMONER_BEHAVIOR)\r\n    && !GN_GetSpawnInCondition(SW_FLAG_SPECTATOR_STATE)\r\n    && !GN_GetSpawnInCondition(SW_FLAG_AI_OFF)\r\n    //MODIFIED by Preston Watamaniuk on March 27\r\n    //Put this back in to cancel Determine Combat when user actions are present.\r\n    && !GetUserActionsPending())\r\n    {\r\n        if(GetPartyMemberByIndex(0) != OBJECT_SELF && !GetPlayerRestrictMode())\r\n        {\r\n            if((IsObjectPartyMember(OBJECT_SELF) && !GetPlayerRestrictMode()) || !IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                if(nNPC_AI == NPC_AISTYLE_MELEE_ATTACK)\r\n                {\r\n                    if(GetIsObjectValid(oIntruder))\r\n                    {\r\n                        ClearAllActions();\r\n                        ActionAttack(oIntruder);\r\n                        return;\r\n                    }\r\n                    else\r\n                    {\r\n                        object oDefault = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY);\r\n                        if(GetIsObjectValid(oDefault))\r\n                        {\r\n                            ClearAllActions();\r\n                            ActionAttack(oDefault);\r\n                            return;\r\n                        }\r\n                    }\r\n                    return;\r\n                }\r\n                //Always try and run a force field at the beginning of combat.\r\n                if(GN_ActivateForceField() == TRUE)\r\n                {\r\n                    GN_MyPrintString("GENERIC DEBUG *************** Terminating AI from Shields");\r\n                    return;\r\n                }\r\n                //Always try to use Force Resistance at the beginning of combat.\r\n                if(GN_ActivateResistances() == TRUE){return;}\r\n\r\n                //P.W. (June 9) - Malak AI put into the generics\r\n                if(GN_GetSpawnInCondition(SW_FLAG_MALAK_AI_ON) == TRUE)\r\n                {\r\n                    if(GN_RunMalakAIRoutine() == TRUE){return;}\r\n                }\r\n\r\n                //If the boss flag is set then the creature will run the boss AI first.\r\n                if(GN_GetSpawnInCondition(SW_FLAG_BOSS_AI) == TRUE)\r\n                {\r\n                    if(GN_RunBossAIRoutine(oIntruder) == TRUE){return;}\r\n                }\r\n\r\n                if(nNPC_AI == NPC_AISTYLE_DEFAULT_ATTACK)\r\n                {\r\n                     //ACTIVE\r\n                     if(GN_RunDefaultAIRoutine(oIntruder) == TRUE)\r\n                     {\r\n                        return;\r\n                     }\r\n                }\r\n                else if(nNPC_AI == NPC_AISTYLE_GRENADE_THROWER)\r\n                {\r\n                     //ACTIVE\r\n                     if(GN_RunGrenadeAIRoutine(oIntruder) == TRUE){return;}\r\n                }\r\n                else if(nNPC_AI == NPC_AISTYLE_JEDI_SUPPORT)\r\n                {\r\n                     //ACTIVE\r\n                     if(GN_RunJediSupportAIRoutine(oIntruder) == TRUE){return;}\r\n                }\r\n            }\r\n        }\r\n    }\r\n    if(GN_DoPostDCRChecks())\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** DETERMINE COMBAT ROUND END");\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** WARNING DETERMINE COMBAT ROUND FAILURE");\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Do Post Determine Combat Round Checks\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Performs a series of checks in case the combat\r\n    portion of DetermineCombatRound falls through.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 25, 2003\r\n//:://////////////////////////////////////////////\r\nint GN_DoPostDCRChecks()\r\n{\r\n    GN_MyPrintString("GENERIC DEBUG *************** Post DCR Checks for " + GN_ReturnDebugName(OBJECT_SELF));\r\n    if(GN_GetSpawnInCondition(SW_FLAG_COMMONER_BEHAVIOR) && !GN_GetSpawnInCondition(SW_FLAG_SPECTATOR_STATE))\r\n    {\r\n        //MODIFIED by Preston Watamaniuk on May 29, 2003\r\n        //Changed the commoner subroutine to make sure it walks ways at the end of battles.\r\n        if(GN_CommonAI())\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(GN_GetSpawnInCondition(SW_FLAG_SPECTATOR_STATE))\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Clear 1000");\r\n        ClearAllActions();\r\n        return TRUE;\r\n    }\r\n    //If all combat actions fail, then return to Walkways\r\n    //P.W.(May 22, 2003) - Added check to make sure a waypoint path is set out for the creature. If then do not clear all actions.\r\n    if(!IsObjectPartyMember(OBJECT_SELF) && GN_CheckWalkWays(OBJECT_SELF) == TRUE)\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Clear 1100");\r\n        ClearAllActions();\r\n        //MODIFIED by Preston Watamaniuk on May15, 2003\r\n        //Put this delay command in so that bark bubble do not disapear so quickly off conversations.\r\n        DelayCommand(1.0, GN_WalkWayPoints());\r\n        return TRUE;\r\n    }\r\n    else if(GetPartyMemberByIndex(0) != OBJECT_SELF &&\r\n            !GetIsObjectValid(GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY, OBJECT_SELF,1, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN)) &&\r\n            IsObjectPartyMember(OBJECT_SELF))\r\n    {\r\n        if(!GetSoloMode())\r\n        {\r\n            GN_PostString("NO TARGET: FOLLOW LEADER");\r\n            CancelCombat(OBJECT_SELF);\r\n            GN_MyPrintString("GENERIC DEBUG *************** Clear 1200");\r\n            ClearAllActions();\r\n            ActionFollowLeader();\r\n        }\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: GN_ActionDoPostDCRChecks\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    A form of the DCR checks that can be run as\r\n    an actions.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: May 29, 2003\r\n//:://////////////////////////////////////////////\r\nvoid GN_ActionDoPostDCRChecks()\r\n{\r\n    int nx = GN_DoPostDCRChecks();\r\n}\r\n\r\n//:://////////////////////////////////////////////\r\n//:: Run Default AI\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Runs the default AI for an NPC. Returns FALSE\r\n    if they cannot do anything.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 9, 2002\r\n//:://////////////////////////////////////////////\r\nint GN_RunDefaultAIRoutine(object oIntruder)\r\n{\r\n    object oTarget, oClose;\r\n    int nTalentCode;\r\n    talent tUse;\r\n\r\n    oTarget = GN_CheckIfPoisoned();\r\n    if(GetIsObjectValid(oTarget))\r\n    {\r\n        if(GN_TalentMasterRoutine(GEN_TALENT_REMOVE_POISON, oTarget)) {return TRUE;}\r\n    }\r\n    oTarget = GN_CheckIfInjured();\r\n    if(GetIsObjectValid(oTarget))\r\n    {\r\n        if(GN_TalentMasterRoutine(GEN_TALENT_HEALING, oTarget)) {return TRUE;}\r\n    }\r\n\r\n    tUse = GN_GetComboMove();\r\n\r\n    int nFriend = GetLocalBoolean(OBJECT_SELF, SW_FLAG_TARGET_FRIEND);\r\n    if(nFriend == TRUE)\r\n    {\r\n        if(GetNPCAIStyle(OBJECT_SELF) == NPC_AISTYLE_JEDI_SUPPORT)\r\n        {\r\n            oTarget = GetPartyMemberByIndex(0);\r\n        }\r\n        else\r\n        {\r\n            oTarget = OBJECT_SELF;\r\n        }\r\n    }\r\n    else\r\n    {\r\n        oTarget = tPR.oLastTarget;\r\n        oClose = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY, OBJECT_SELF,1, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN);\r\n\r\n        GN_MyPrintString("GENERIC DEBUG *************** Default AI Debug Start *************************");\r\n        GN_MyPrintString("GENERIC DEBUG *************** Intruder    = " + GN_ReturnDebugName(oIntruder));\r\n        GN_MyPrintString("GENERIC DEBUG *************** Last Target = " + GN_ReturnDebugName(oTarget));\r\n        GN_MyPrintString("GENERIC DEBUG *************** Closest     = " + GN_ReturnDebugName(oClose));\r\n\r\n        //GN_MyPrintString("GENERIC DEBUG *************** " + GN_ReturnDebugName(OBJECT_SELF) + "I see an enemy = " + IntToString(GetIsObjectValid(oClose)));\r\n\r\n        //MODIFIED by Preston Watamaniuk on June 3, 2003\r\n        //I put this check in to make sure the party members only attack what you want until that things dies or leaves.\r\n        if(IsObjectPartyMember(OBJECT_SELF) && GetIsObjectValid(oTarget) && !GetIsDead(oTarget) && GetObjectSeen(oTarget))\r\n        {\r\n            oTarget = oTarget; //Just put this here to show that the target is being used.\r\n        }\r\n        //MODIFIED by Preston Watamaniuk on May 15, 2003\r\n        //Made it so the intruder object is always used if they can be seen and are valid.\r\n        else if(GetIsObjectValid(oIntruder) && GetObjectSeen(oIntruder))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Intruder becomes Target");\r\n            oTarget = oIntruder;\r\n        }\r\n        else if(GetIsObjectValid(oClose) && GetObjectSeen(oClose))\r\n        {\r\n            if((!GetIsObjectValid(oTarget) ||\r\n               !GetIsEnemy(oTarget) ||\r\n               GetIsDead(oTarget) ||\r\n               GetCurrentHitPoints(oTarget) < GetCurrentHitPoints(oClose)))\r\n               {\r\n                  GN_MyPrintString("GENERIC DEBUG *************** Closest becomes Target");\r\n                  oTarget = oClose;\r\n               }\r\n        }\r\n    }\r\n\r\n    //MODIFIED by Preston Watamaniuk on April 22, 2003\r\n    //Put this check in to allow Droids to use their special abilities in a more logical manner. Passes in the talent and the target\r\n    //and double checks that the usage is logical.\r\n    if(GetRacialType(OBJECT_SELF) == RACIAL_TYPE_DROID)\r\n    {\r\n        tUse = GN_CheckDroidUtilityUsage(oTarget, tUse);\r\n    }\r\n    tUse = GN_CheckThrowLightSaberUsage(oTarget, tUse);\r\n    tUse = GN_CheckNonDroidForcePower(oTarget, tUse);\r\n\r\n    GN_MyPrintString("GENERIC DEBUG *************** Default AI Debug End ***************************");\r\n\r\n    GN_MyPrintString("GENERIC DEBUG *************** Target = " + GN_ReturnDebugName(oTarget) + " is Enemy: " + IntToString(GetIsEnemy(oTarget)));\r\n    if(GetIsObjectValid(oTarget))\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Clear 1300");\r\n        ClearAllActions();\r\n        if(GN_EquipAppropriateWeapon())\r\n        {\r\n           GN_MyPrintString("GENERIC DEBUG *************** Switching Weapons");\r\n        }\r\n\r\n        if(GetIsTalentValid(tUse) && GetIsEnemy(oTarget))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Using Talent on Target");\r\n            ActionUseTalentOnObject(tUse, oTarget);\r\n            return TRUE;\r\n        }\r\n        else if(GetIsEnemy(oTarget))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Action Attack by Default");\r\n            ActionAttack(oTarget);\r\n            return TRUE;\r\n        }\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** Default AI has failed to do an action");\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Jedi Aid AI\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    AI that concentrates on keeping the party healed,\r\n    poison free.  If the party is doing ok then the Jedi\r\n    will attempt to use Force Powers. If they are unable\r\n    to use force powers they will run default AI.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Jan 20, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_RunAidAIRoutine(object oIntruder = OBJECT_INVALID)\r\n{\r\n    object oPoisoned = GN_CheckIfPoisoned();\r\n    if(GetIsObjectValid(oPoisoned))\r\n    {\r\n        if(GN_TalentMasterRoutine(GEN_TALENT_REMOVE_POISON, oPoisoned)) {return TRUE;}\r\n    }\r\n    object oInjured = GN_CheckIfInjured();\r\n    if(GetIsObjectValid(oInjured))\r\n    {\r\n        if(GN_TalentMasterRoutine(GEN_TALENT_HEALING, oInjured)) {return TRUE;}\r\n    }\r\n\r\n    return GN_RunDefaultAIRoutine(oIntruder);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Grenade AI\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Trys to use a grenades on targets not surrounded\r\n    by enemies\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Jan 17, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_RunGrenadeAIRoutine(object oIntruder = OBJECT_INVALID)\r\n{\r\n    if(IsObjectPartyMember(OBJECT_SELF) || d100() > 50)\r\n    {\r\n        int nDroid = FALSE;\r\n        talent tUse;\r\n        object oTarget = GN_FindGrenadeTarget();\r\n\r\n        if(GetRacialType(oTarget) == RACIAL_TYPE_DROID)\r\n        {\r\n            nDroid = TRUE;\r\n        }\r\n\r\n        tUse = GN_GetGrenadeTalent(nDroid);\r\n\r\n        if(GetIsObjectValid(oTarget) && GetIsTalentValid(tUse) && GetCreatureHasTalent(tUse))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Clear 1400");\r\n            ClearAllActions();\r\n            ActionUseTalentOnObject(tUse, oTarget);\r\n            return TRUE;\r\n        }\r\n        GN_MyPrintString("GENERIC DEBUG *************** Grenade AI Failure");\r\n        return GN_RunDefaultAIRoutine(oIntruder);\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** Grenade AI Fall Through");\r\n    return GN_RunDefaultAIRoutine(oIntruder);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Jedi Support\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This will make the Jedi use Force Powers before\r\n    everything else.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Jan 17, 2003\r\n//:://////////////////////////////////////////////\r\nint GN_RunJediSupportAIRoutine(object oIntruder = OBJECT_INVALID)\r\n{\r\n    object oPoisoned = GN_CheckIfPoisoned();\r\n    talent tUse;\r\n    object oTarget;\r\n\r\n    //P.W (May 27, 2003) - Made a change so that Droids can use Jedi Support. Its just defaul AI with an AI check however.\r\n    if(GetRacialType(OBJECT_SELF) == RACIAL_TYPE_DROID)\r\n    {\r\n        return GN_RunDefaultAIRoutine();\r\n    }\r\n\r\n    if(GN_TalentMasterRoutine(GEN_TALENT_BUFF, OBJECT_SELF))\r\n    {\r\n        return TRUE;\r\n    }\r\n    if(GetIsObjectValid(oPoisoned))\r\n    {\r\n        if(GN_TalentMasterRoutine(GEN_TALENT_REMOVE_POISON, oPoisoned)) {return TRUE;}\r\n    }\r\n    object oInjured = GN_CheckIfInjured();\r\n    if(GetIsObjectValid(oInjured))\r\n    {\r\n        if(GN_TalentMasterRoutine(GEN_TALENT_HEALING, oInjured)) {return TRUE;}\r\n    }\r\n\r\n    oTarget = GN_FindAOETarget();\r\n    GN_MyPrintString("GENERIC DEBUG *************** Jedi Support AI: AOE Target = " + GN_ITS(GetIsObjectValid(oTarget)));\r\n    if(GetIsObjectValid(oTarget))\r\n    {\r\n        if(GetRacialType(oTarget) == RACIAL_TYPE_DROID)\r\n        {\r\n            tUse = GN_GetBossCombatMove(SW_BOSS_ATTACK_TYPE_FORCE_POWER, TRUE);\r\n        }\r\n        else\r\n        {\r\n            tUse = GN_GetBossCombatMove(SW_BOSS_ATTACK_TYPE_FORCE_POWER);\r\n        }\r\n    }\r\n    else\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Jedi Support AI: Inside the Party AI Section");\r\n\r\n        oTarget = GN_DetermineAttackTarget();\r\n\r\n        GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Initial oFind Search = " + GN_ReturnDebugName(oTarget));\r\n\r\n        if(GetIsObjectValid(oTarget))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Jedi Support AI: Valid oTarget Set As = " + GN_ReturnDebugName(oTarget));\r\n            if(GetRacialType(oTarget) == RACIAL_TYPE_DROID)\r\n            {\r\n                tUse = GN_GetBossCombatMove(SW_BOSS_ATTACK_TYPE_NPC, TRUE);\r\n            }\r\n            else\r\n            {\r\n                tUse = GN_GetBossCombatMove(SW_BOSS_ATTACK_TYPE_NPC);\r\n            }\r\n        }\r\n    }\r\n    tUse = GN_CheckThrowLightSaberUsage(oTarget, tUse);\r\n    tUse = GN_CheckNonDroidForcePower(oTarget, tUse);\r\n    if(GetIsObjectValid(oTarget) && GetIsTalentValid(tUse))\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Clear 1450");\r\n        ClearAllActions();\r\n        ActionUseTalentOnObject(tUse, oTarget);\r\n        return TRUE;\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** Jedi Support AI: Fall Through");\r\n    return GN_RunDefaultAIRoutine();\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Boss AI: Grenade\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Run Boss Grenade AI Routine\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 2, 2003\r\n//:://////////////////////////////////////////////\r\nint GN_RunBossGrenadeAI()\r\n{\r\n    GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Grenade Function Starting");\r\n    talent tUse;\r\n    object oCheck = GN_FindGrenadeTarget();\r\n    GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Grenade Target = " + GN_ITS(GetIsObjectValid(oCheck)));\r\n    int nDroid;\r\n    if(GetIsObjectValid(oCheck))\r\n    {\r\n         if(GetRacialType(oCheck) == RACIAL_TYPE_DROID)\r\n         {\r\n            nDroid == TRUE;\r\n         }\r\n         tUse = GN_GetBossCombatMove(SW_BOSS_ATTACK_TYPE_GRENADE, nDroid);\r\n         if(GetIsTalentValid(tUse))\r\n         {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Clear 1460");\r\n            ClearAllActions();\r\n            ActionUseTalentOnObject(tUse, oCheck);\r\n            GN_MyPrintString("GENERIC DEBUG *************** Boss AI: AOE Success");\r\n            return TRUE;\r\n         }\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** Boss AI: AOE Failure");\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Boss AI: AOE Power\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Run Boss AOE Force Power Routine\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 2, 2003\r\n//:://////////////////////////////////////////////\r\nint GN_RunBossAOEPowerRoutine()\r\n{\r\n    GN_MyPrintString("GENERIC DEBUG *************** Boss AI: AOE Function Starting");\r\n    talent tUse;\r\n    object oCheck = GN_FindAOETarget();\r\n    GN_MyPrintString("GENERIC DEBUG *************** Boss AI: AOE Target = " + GN_ITS(GetIsObjectValid(oCheck)));\r\n    int nDroid;\r\n    if(GetIsObjectValid(oCheck))\r\n    {\r\n         if(GetRacialType(oCheck) == RACIAL_TYPE_DROID)\r\n         {\r\n            nDroid == TRUE;\r\n         }\r\n         tUse = GN_GetBossCombatMove(SW_BOSS_ATTACK_TYPE_FORCE_POWER, nDroid);\r\n         if(GetIsTalentValid(tUse))\r\n         {\r\n            ClearAllActions();\r\n            ActionUseTalentOnObject(tUse, oCheck);\r\n            GN_MyPrintString("GENERIC DEBUG *************** Boss AI: AOE Success");\r\n            return TRUE;\r\n         }\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** Boss AI: AOE Failure");\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Boss AI: Targeting\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This will make boss monsters use targeted\r\n    super powers.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 2, 2003\r\n//:://////////////////////////////////////////////\r\nint GN_RunBossTargetedRoutine()\r\n{\r\n    GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Start Targeted Action Routine");\r\n    talent tUse;\r\n    object oTarget;\r\n    int nDroid;\r\n    int nRand = d6();\r\n    int nCnt = 1;\r\n    if(nRand < 4){nRand = 1;}\r\n    if(nRand == 4){nRand = 2;}\r\n    if(nRand == 5){nRand = 3;}\r\n    if(nRand == 6){nRand = 4;}\r\n\r\n    GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Get the #" + GN_ITS(nRand) + " target");\r\n\r\n    object oFind = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY, OBJECT_SELF, nCnt, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN);\r\n    GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Initial oFind Search = " + GN_ReturnDebugName(oFind));\r\n    while(GetIsObjectValid(oFind) && nCnt <= nRand)\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Valid oFind = " + GN_ReturnDebugName(oFind) + " nCnt = " + GN_ITS(nCnt));\r\n        if(GetIsObjectValid(oFind))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Valid oTarget Set As = " + GN_ReturnDebugName(oFind));\r\n            oTarget = oFind;\r\n        }\r\n        nCnt++;\r\n        oFind = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY, OBJECT_SELF, nCnt, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN);\r\n    }\r\n\r\n    //DEBUG STATEMENTS\r\n    int nX = TRUE;\r\n    if(nX == TRUE)\r\n    {\r\n        if(GetIsTalentValid(tUse))\r\n        {\r\n            if(GetTypeFromTalent(tUse) == TALENT_TYPE_FEAT)\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Talent Feat = " + GN_ITS(GetIdFromTalent(tUse)));\r\n            }\r\n            else if(GetTypeFromTalent(tUse) == TALENT_TYPE_FORCE)\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Talent Power = " + GN_ITS(GetIdFromTalent(tUse)));\r\n            }\r\n        }\r\n    }\r\n    if(GetIsObjectValid(oTarget))\r\n    {\r\n        if(GetRacialType(oTarget) == RACIAL_TYPE_DROID)\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Get Boss Combat Move AI Droid");\r\n            nDroid = TRUE;\r\n        }\r\n        tUse = GN_GetBossCombatMove(SW_BOSS_ATTACK_TYPE_NPC, nDroid);\r\n        \r\n        tUse = GN_CheckThrowLightSaberUsage(oTarget, tUse);\r\n        tUse = GN_CheckNonDroidForcePower(oTarget, tUse);\r\n        \r\n        //MODIFIED by Preston Watamaniuk on April 2, 2003\r\n        //Added this check to make the Droid setting was used for non-specific attacks.\r\n        GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Target = " + GN_ITS(GetIsObjectValid(oTarget)));\r\n        GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Talent = " + GN_ITS(GetIsTalentValid(tUse)));\r\n        if(GetIsTalentValid(tUse) && GetIsObjectValid(oTarget))\r\n        {\r\n            ClearAllActions();\r\n            ActionUseTalentOnObject(tUse, oTarget);\r\n            GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Targeted Power Success");\r\n            return TRUE;\r\n        }\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Targeted Failure");\r\n    return FALSE;\r\n}\r\n\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Boss AI\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This will make boss monsters buff themselves\r\n    and use more force powers or utility devices\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Jan 31, 2003\r\n//:://////////////////////////////////////////////\r\nint GN_RunBossAIRoutine(object oIntruder = OBJECT_INVALID)\r\n{\r\n    GN_MyPrintString("GENERIC DEBUG *************** Boss AI Start");\r\n\r\n    object oTarget = GN_CheckIfInjured();\r\n    if(GetIsObjectValid(oTarget))\r\n    {\r\n        if(GN_TalentMasterRoutine(GEN_TALENT_HEALING, oTarget)) {return TRUE;}\r\n    }\r\n    if(GN_EquipAppropriateWeapon())\r\n    {\r\n       GN_MyPrintString("GENERIC DEBUG *************** Switching Weapons");\r\n    }\r\n\r\n    if(GN_RunBossGrenadeAI() == TRUE) {return TRUE;}\r\n    else if(GN_RunBossAOEPowerRoutine() == TRUE) {return TRUE;}\r\n    else if(GN_RunBossTargetedRoutine() ==  TRUE) {return TRUE;}\r\n\r\n    GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Fall Through");\r\n    return GN_RunDefaultAIRoutine();\r\n}\r\n\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Malak AI\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This AI is just for Darth Malak on the Star\r\n    Forge. It assumes there is only the PC and\r\n    no one else.\r\n    \r\n    Malak\'s Force Powers\r\n        Master Speed\r\n        Force Push\r\n        Throw Lightsaber (15)\r\n        Affliction\r\n        Force Resistance\r\n        Imp. Energy Resist\r\n        Lightning (15)\r\n        Force Breach\r\n        \r\n    This routine is an add-on for boss ai.  It\r\n    tests certain conditions that could be\r\n    occurring in the Malak fight and reacts to them\r\n    in a more agressive manner.\r\n\r\n    1. K_END_JEDI_LEFT - Will track the total number\r\n       of entombed Jedi left in the fight.\r\n    2. K_END_MALAK_JEDI_USED - Will track the number\r\n    of Jedi\'s Malak has personally used in the fight.\r\n\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 29, 2003\r\n//:://////////////////////////////////////////////\r\nint GN_RunMalakAIRoutine()\r\n{\r\n    GN_MyPrintString("GENERIC DEBUG *************** Malak AI Start");\r\n    int nJediLeft = GetGlobalNumber("K_END_JEDI_LEFT");\r\n    int nMalakUsed = GetGlobalNumber("K_END_MALAK_JEDI_USED");\r\n    object oPC = GetFirstPC();\r\n    int bJedi, bDist, bAttack;\r\n    float fDist = GetDistanceBetween(OBJECT_SELF, oPC);\r\n\r\n    //Check to see if Malak need to become more aggressive\r\n    //Test the number of Jedi to see if the player has used any\r\n    if(((8 - nJediLeft) < nMalakUsed))\r\n    {\r\n        bJedi = TRUE;\r\n    }\r\n    //Check to see if the player is running away\r\n    GN_MyPrintString("GENERIC DEBUG *************** Malak Distance to PC = " + FloatToString(GetDistanceBetween(OBJECT_SELF, oPC),4,4));\r\n    if(fDist > 10.0)\r\n    {\r\n        bDist = TRUE;\r\n    }\r\n    if(bDist == TRUE)\r\n    {\r\n        /*\r\n            AI REACTION 2 - Player is keeping his distance.\r\n            1. Force Breach if the player is using speed\r\n            OR\r\n            2. Use Action Attack to Force Jump\r\n        */\r\n        GN_MyPrintString("GENERIC DEBUG *************** Clear 1480");\r\n        ClearAllActions();\r\n        if(GetHasSpellEffect(FORCE_POWER_SPEED_BURST, oPC) ||\r\n           GetHasSpellEffect(FORCE_POWER_KNIGHT_SPEED, oPC) ||\r\n           GetHasSpellEffect(FORCE_POWER_SPEED_MASTERY, oPC))\r\n        {\r\n            talent tBreach = TalentSpell(FORCE_POWER_FORCE_BREACH);\r\n            if(GetIsTalentValid(tBreach))\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** Using Breach");\r\n                ActionUseTalentOnObject(tBreach, oPC);\r\n            }\r\n            bAttack = TRUE;\r\n        }\r\n        else\r\n        {\r\n            if(fDist > 10.0)\r\n            {\r\n                int nRoll = d3();\r\n                int nPower = -1;\r\n                if(nRoll == 1)\r\n                {\r\n                    nPower = FORCE_POWER_LIGHTNING;\r\n                }\r\n                else if(nRoll == 2)\r\n                {\r\n                    nPower = FORCE_POWER_LIGHT_SABER_THROW;\r\n                }\r\n                else if(nRoll > 2)\r\n                {\r\n                    bAttack = TRUE;\r\n                }\r\n                if(nPower != -1)\r\n                {\r\n                    talent tPower = TalentSpell(nPower);\r\n                    if(GetIsTalentValid(tPower))\r\n                    {\r\n                        GN_MyPrintString("GENERIC DEBUG *************** Malak Using Force Power");\r\n                        ActionUseTalentOnObject(tPower, oPC);\r\n                        return TRUE;\r\n                    }\r\n                }\r\n            }\r\n            bAttack = TRUE;\r\n        }\r\n    }\r\n    if(bAttack == TRUE)\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Malak Attacking");\r\n        ActionAttack(oPC);\r\n        return TRUE;\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** Malak AI Drop Out");\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Shield Activation\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Organic Shields are 99 to 107\r\n    Droid shields are 110 to 115\r\n\r\n    Scans through all of the shield talents to\r\n    see if the target has a shield to use. If the\r\n    shield is used then the person will never use\r\n    another one. Party members will never use this\r\n    function.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Jan 31, 2003\r\n//:://////////////////////////////////////////////\r\nint GN_ActivateForceField()\r\n{\r\n    GN_MyPrintString("GENERIC DEBUG *************** Starting Forcefield Search");\r\n    GN_MyPrintString("GENERIC DEBUG *************** Shield Boolean (" + GN_ITS(SW_FLAG_SHIELD_USED) + ") = " + GN_ITS(GN_GetSpawnInCondition(SW_FLAG_SHIELD_USED)));\r\n    if(GN_GetSpawnInCondition(SW_FLAG_SHIELD_USED) == FALSE && !IsObjectPartyMember(OBJECT_SELF))\r\n    {\r\n        int nCnt, nStop;\r\n        int bValid = FALSE;\r\n        talent tShield;\r\n        if(GetRacialType(OBJECT_SELF) == RACIAL_TYPE_DROID)\r\n        {\r\n            nCnt = 110;\r\n            nStop = 115;\r\n        }\r\n        else\r\n        {\r\n            nCnt = 99;\r\n            nStop = 107;\r\n        }\r\n\r\n        while(bValid == FALSE && nCnt <= nStop)\r\n        {\r\n            tShield = TalentSpell(nCnt);\r\n            if(GetCreatureHasTalent(tShield))\r\n            {\r\n                bValid = TRUE;\r\n            }\r\n            else\r\n            {\r\n                nCnt++;\r\n            }\r\n        }\r\n\r\n        if(GetCreatureHasTalent(tShield))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Clear 1700");\r\n            ClearAllActions();\r\n            ActionUseTalentOnObject(tShield, OBJECT_SELF);\r\n            GN_SetSpawnInCondition(SW_FLAG_SHIELD_USED);\r\n            return TRUE;\r\n        }\r\n        else\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Forcefield Search Fallthrough");\r\n            GN_SetSpawnInCondition(SW_FLAG_SHIELD_USED);\r\n            return FALSE;\r\n        }\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** Forcefield Search Fallthrough");\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Resistance Activation\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    20 Resist Force\r\n    41 Force Immunity\r\n    Checks to see if the character has resist force\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Jan 31, 2003\r\n//:://////////////////////////////////////////////\r\n//Makes the person activate Resist Elements and Resist Force.\r\nint GN_ActivateResistances()\r\n{\r\n    int bValid = FALSE;\r\n    if(GN_GetSpawnInCondition(SW_FLAG_RESISTANCES_APPLIED) == FALSE && !IsObjectPartyMember(OBJECT_SELF))\r\n    {\r\n        if(GetHitDice(GetFirstPC()) >= 15 || GN_GetSpawnInCondition(SW_FLAG_BOSS_AI))\r\n        {\r\n            talent tResist = TalentSpell(FORCE_POWER_RESIST_FORCE);\r\n            talent tImmune = TalentSpell(FORCE_POWER_FORCE_IMMUNITY);\r\n            talent tUse;\r\n            if(GetCreatureHasTalent(tImmune))\r\n            {\r\n                tUse = tImmune;\r\n                bValid = TRUE;\r\n            }\r\n            else if(GetCreatureHasTalent(tResist))\r\n            {\r\n                tUse = tResist;\r\n                bValid = TRUE;\r\n            }\r\n\r\n            if(bValid == TRUE)\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** Clear 1710");\r\n                ClearAllActions();\r\n                ActionUseTalentOnObject(tUse, OBJECT_SELF);\r\n            }\r\n            GN_SetSpawnInCondition(SW_FLAG_RESISTANCES_APPLIED);\r\n        }\r\n    }\r\n\r\n    return bValid;\r\n}\r\n\r\n\r\n\r\n//:://///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n//:://///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n//:: Respond to Shout                                           ========  =       =   =======   =       =  =========   ========\r\n//:: Copyright (c) 2001 Bioware Corp.                          =          =       =  =       =  =       =      =      =\r\n//:://////////////////////////////////////////////             =          =       =  =       =  =       =      =      =\r\n/*//                                                           =          =       =  =       =  =       =      =      =\r\n    Catches the shouts and determines the best                 =========  =========  =       =  =       =      =      =========\r\n    course of action for them                                          =  =       =  =       =  =       =      =              =\r\n                                                                       =  =       =  =       =  =       =      =              =\r\n    SetListenPattern(OBJECT_SELF, "GEN_I_WAS_ATTACKED", 1);            =  =       =  =       =  =       =      =              =\r\n    SetListenPattern(OBJECT_SELF, "GEN_I_SEE_AN_ENEMY", 15);   ========   =       =   =======     ======       =      ========\r\n*///\r\n//:://///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: July 16, 2002\r\n//:://///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n//:://///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\nvoid GN_RespondToShout(object oShouter, int nShoutIndex, object oIntruder = OBJECT_INVALID)\r\n{\r\n    GN_MyPrintShoutString("");\r\n    GN_MyPrintShoutString("GENERIC SHOUT DEBUG *************** Respond to Shout Started for " + GN_ReturnDebugName(OBJECT_SELF));\r\n    GN_MyPrintShoutString("GENERIC SHOUT DEBUG *************** Intruder Object = " + GN_ReturnDebugName(oIntruder));\r\n\r\n    int nFLAG; //This determines whether the object walksway points instead of attacking.\r\n    int nPartyAI = GetPartyAIStyle(); //Determines how the party should react to intruders\r\n    int nNPC_AI = GetNPCAIStyle(OBJECT_SELF); //Determines how the individual should react in combat\r\n\r\n    //MODIFIED by Preston Watamaniuk May 9\r\n    //Put this check into disable shouts being heard by people from different combat zones.\r\n    if(GetLocalNumber(oShouter, SW_NUMBER_COMBAT_ZONE) == GetLocalNumber(OBJECT_SELF, SW_NUMBER_LAST_COMBO) ||\r\n       GetLocalNumber(oShouter, SW_NUMBER_COMBAT_ZONE) == 0 ||\r\n       GetLocalNumber(OBJECT_SELF, SW_NUMBER_COMBAT_ZONE) == 0 ||\r\n       IsObjectPartyMember(OBJECT_SELF))\r\n    {\r\n        if(!GN_GetSpawnInCondition(SW_FLAG_COMMONER_BEHAVIOR)\r\n           && !GN_GetSpawnInCondition(SW_FLAG_SPECTATOR_STATE)\r\n           && !GN_GetSpawnInCondition(SW_FLAG_AI_OFF)\r\n           && !GetUserActionsPending())\r\n        {\r\n            GN_MyPrintShoutString("GENERIC SHOUT DEBUG *************** Check 1 Pass");\r\n            if(nShoutIndex == 1 && GetIsFriend(oShouter) && oShouter != OBJECT_SELF)\r\n            {\r\n                if((IsObjectPartyMember(OBJECT_SELF) && IsObjectPartyMember(oShouter) && GetSoloMode() == FALSE) ||\r\n                    !IsObjectPartyMember(OBJECT_SELF))\r\n                {\r\n                    GN_MyPrintShoutString("GENERIC SHOUT DEBUG *************** Check 2 Pass");\r\n                    if(!GetIsObjectValid(GetAttemptedAttackTarget()) && !GetIsObjectValid(GetAttemptedSpellTarget()) && !GetIsObjectValid(GetAttackTarget()))\r\n                    {\r\n                        GN_MyPrintShoutString("GENERIC SHOUT DEBUG *************** Check 3 Pass");\r\n                        if(GetPartyMemberByIndex(0) != OBJECT_SELF && nPartyAI != PARTY_AISTYLE_PASSIVE && !GetPlayerRestrictMode())\r\n                        {\r\n                            GN_MyPrintShoutString("GENERIC SHOUT DEBUG *************** Check 3 Pass");\r\n                            if((IsObjectPartyMember(OBJECT_SELF) && !GetPlayerRestrictMode()) || !IsObjectPartyMember(OBJECT_SELF))\r\n                            {\r\n                                GN_MyPrintShoutString("GENERIC SHOUT DEBUG *************** Check 5 Pass");\r\n\r\n                                GN_MyPrintShoutString("GENERIC SHOUT DEBUG *************** Intruder = " + GN_ReturnDebugName(oIntruder));\r\n                                if(GetObjectSeen(oIntruder))\r\n                                {\r\n                                    GN_MyPrintShoutString("GENERIC SHOUT DEBUG *************** Shout: Determine Combat Round");\r\n                                    GN_MyPrintString("GENERIC SHOUT DEBUG *************** Shout Clear 1800");\r\n\r\n                                    ClearAllActions();\r\n                                    GN_DetermineCombatRound(oIntruder);\r\n                                }\r\n                                else if(GetIsObjectValid(oIntruder))\r\n                                {\r\n                                    GN_MyPrintShoutString("GENERIC SHOUT DEBUG *************** Shout: Move To Intruder");\r\n                                    GN_MyPrintString("GENERIC SHOUT DEBUG ***************= Shout Clear 1900");\r\n                                    ClearAllActions();\r\n                                    float fDistance = 5.0;\r\n                                    /*\r\n                                    if(!GetObjectSeen(oIntruder))\r\n                                    {\r\n                                        fDistance = 3.0;\r\n                                    }\r\n                                    */\r\n                                    //P.W. (June 8) - Put this check in to try and reduce the instances of NPCs running right up\r\n                                    //to their enemies with blasters.\r\n                                    if(GetDistanceBetween(OBJECT_SELF, oIntruder) < 20.0 && !GetObjectSeen(oIntruder))\r\n                                    {\r\n                                        ActionMoveToObject(oIntruder, TRUE, 2.0);\r\n                                    }\r\n                                    else\r\n                                    {\r\n                                        if(GN_GetWeaponType(OBJECT_SELF) == 1)\r\n                                        {\r\n                                            ActionMoveToObject(oIntruder, TRUE, 4.0);\r\n                                        }\r\n                                        else\r\n                                        {\r\n                                            ActionMoveToObject(oIntruder, TRUE, 15.0);\r\n                                        }\r\n                                    }\r\n                                }\r\n                                //MODIFIED by Preston Watamaniuk on May 16th\r\n                                //Added this check to make Party Members attack after the PC engages in combat.\r\n                                else if(IsObjectPartyMember(OBJECT_SELF))\r\n                                {\r\n                                    oIntruder = GetAttackTarget(oShouter);\r\n                                    GN_MyPrintShoutString("GENERIC SHOUT DEBUG *************** Attack Intruder = " + GN_ReturnDebugName(oIntruder));\r\n                                    if(GetIsObjectValid(oIntruder))\r\n                                    {\r\n                                        GN_DetermineCombatRound(oIntruder);\r\n                                    }\r\n                                    else\r\n                                    {\r\n                                        oIntruder = GetSpellTarget(oShouter);\r\n                                        GN_MyPrintShoutString("GENERIC SHOUT DEBUG *************** Spell Intruder = " + GN_ReturnDebugName(oIntruder));\r\n                                        if(GetIsObjectValid(oIntruder))\r\n                                        {\r\n                                            GN_DetermineCombatRound(oIntruder);\r\n                                        }\r\n                                    }\r\n                                }\r\n                            }\r\n                            //I AM IN COMBAT\r\n                            else if(nShoutIndex == 15 && GetIsFriend(oShouter) && oShouter != OBJECT_SELF)\r\n                            {\r\n                                if(GetCurrentAction(OBJECT_SELF) == ACTION_INVALID)\r\n                                {\r\n                                    if(GetObjectSeen(oIntruder))\r\n                                    {\r\n                                        GN_MyPrintString("GENERIC SHOUT DEBUG *************** Clear 2000");\r\n                                        ClearAllActions();\r\n                                        GN_MyPrintShoutString("GENERIC SHOUT DEBUG *************** Attack Intruder = " + GN_ReturnDebugName(oIntruder));\r\n                                        GN_DetermineCombatRound(oIntruder);\r\n                                        //GN_SetSpawnInCondition(SW_FLAG_SHOUTED_AT);\r\n                                    }\r\n                                    else if(GetIsObjectValid(oIntruder))\r\n                                    {\r\n                                        GN_MyPrintString("GENERIC SHOUT DEBUG *************** Clear 2100");\r\n                                        ClearAllActions();\r\n                                        ActionMoveToObject(oIntruder, TRUE, 5.0);\r\n                                        //GN_SetSpawnInCondition(SW_FLAG_SHOUTED_AT);\r\n                                    }\r\n                                }\r\n                            }\r\n                        }\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        else if(GN_GetSpawnInCondition(SW_FLAG_SPECTATOR_STATE))\r\n        {\r\n            GN_MyPrintString("GENERIC SHOUT DEBUG *************** Clear 2200");\r\n            ClearAllActions();\r\n            return;\r\n        }\r\n    }\r\n    /*\r\n    if(!GN_GetSpawnInCondition(SW_FLAG_COMMONER_BEHAVIOR)\r\n       && !GN_GetSpawnInCondition(SW_FLAG_SPECTATOR_STATE)\r\n       && !GN_GetSpawnInCondition(SW_FLAG_AI_OFF))\r\n    {\r\n        if(GetPartyMemberByIndex(0) != OBJECT_SELF && nPartyAI != PARTY_AISTYLE_PASSIVE && !GetPlayerRestrictMode())\r\n        {\r\n            //P.W.(June 5) It looks stupid, but do not take this out.\r\n            if(GetCurrentAction(OBJECT_SELF) == ACTION_QUEUEEMPTY && !GetUserActionsPending() && !IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                if((IsObjectPartyMember(OBJECT_SELF) && IsObjectPartyMember(oShouter) && GetSoloMode() == FALSE) ||\r\n                    !IsObjectPartyMember(OBJECT_SELF))\r\n                {\r\n                    GN_MyPrintString("GENERIC SHOUT DEBUG *************** Hail Mary activated by " + GN_ReturnDebugName(OBJECT_SELF));\r\n                    GN_MyPrintString("GENERIC SHOUT DEBUG *************** Hail Mary Shout Clear 2110");\r\n                    GN_DetermineCombatRound();\r\n                }\r\n            }\r\n        }\r\n    }\r\n    */\r\n    GN_MyPrintShoutString("");\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: SetListeningPatterns\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Sets the correct listen checks on the NPC by\r\n    determining what talents they possess or what\r\n    class they use.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 24, 2001\r\n//:://////////////////////////////////////////////\r\n\r\nvoid GN_SetListeningPatterns()\r\n{\r\n    SetListening(OBJECT_SELF, TRUE);\r\n    SetListenPattern(OBJECT_SELF, "GEN_I_WAS_ATTACKED", 1);\r\n    SetListenPattern(OBJECT_SELF, "GEN_I_AM_DEAD", 3);\r\n    SetListenPattern(OBJECT_SELF, "GEN_CALL_TO_ARMS", 6);\r\n    if(GetHasSpell(FORCE_POWER_SUPRESS_FORCE) || GetHasSpell(FORCE_POWER_FORCE_BREACH))\r\n    {\r\n        SetListenPattern(OBJECT_SELF, "GEN_SUPRESS_FORCE", 9);\r\n    }\r\n    SetListenPattern(OBJECT_SELF, "GEN_GRENADE_TOSSED", 12);\r\n    SetListenPattern(OBJECT_SELF, "GEN_I_SEE_AN_ENEMY", 14);\r\n    SetListenPattern(OBJECT_SELF, "GEN_COMBAT_ACTIVE", 15);\r\n\r\n    GN_SetUpWayPoints();\r\n    string sTag = GetTag(OBJECT_SELF);\r\n    if(sTag != "Carth" &&\r\n       sTag != "Bastila" &&\r\n       sTag != "Cand" &&\r\n       sTag != "HK47" &&\r\n       sTag != "Jolee" &&\r\n       sTag != "Juhani" &&\r\n       sTag != "Mission" &&\r\n       sTag != "T3M4" &&\r\n       sTag != "Zaalbar" &&\r\n       !GetIsPC(OBJECT_SELF))\r\n    {\r\n        DR_SpawnCreatureTreasure(OBJECT_SELF);\r\n    }\r\n    \r\n    //MODIFIED by Preston Watamaniuk on May 8, 2003\r\n    //Added functionality for dynamic or encounter creatures\r\n    //to latch onto a Zone Controller.\r\n    //GN_MyPrintString("ZONE DEBUG *****************" + IntToString(GetIsEncounterCreature()) + " " + GN_ReturnDebugName(OBJECT_SELF));\r\n    if(GN_GetSpawnInCondition(SW_FLAG_DYNAMIC_COMBAT_ZONE) || GetIsEncounterCreature())\r\n    {\r\n        string sController;\r\n        int nCount = 1;\r\n        object oController, oTest;\r\n        float fNear;\r\n        float fClosest = 100.0;\r\n\r\n        for(nCount; nCount < 40; nCount++)\r\n        {\r\n            if(nCount < 10)\r\n            {\r\n                sController = "ZoneController" + "0" + IntToString(nCount);\r\n            }\r\n            else\r\n            {\r\n                sController = "ZoneController" + IntToString(nCount);\r\n            }\r\n            oTest = GetObjectByTag(sController);\r\n            if(GetIsObjectValid(oTest))\r\n            {\r\n                fNear = GetDistanceBetween(OBJECT_SELF, oTest);\r\n                //GN_MyPrintString("ZONING DEBUG ***************** Controller Distance = " + GN_ReturnDebugName(oController) + " " + FloatToString(fNear, 4, 2));\r\n                if(fNear < fClosest)\r\n                {\r\n                    fClosest = fNear;\r\n                    oController = oTest;\r\n                }\r\n            }\r\n        }\r\n        if(GetIsObjectValid(oController) && fClosest < 30.0)\r\n        {\r\n            //GN_MyPrintString("ZONING DEBUG ***************** Setup Controller = " + GN_ReturnDebugName(oController));\r\n            int nZone = StringToInt(GetStringRight(GetTag(oController), 2));\r\n            SetLocalNumber(OBJECT_SELF, SW_NUMBER_COMBAT_ZONE, nZone);\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Check for Poison\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks if someone in the party is poisoned.\r\n    If the person is a non-party NPC then they\r\n    check if they are poisoned.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 9, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nobject GN_CheckIfPoisoned()\r\n{\r\n    GN_MyPrintString("GENERIC DEBUG *************** Starting Poison Check");\r\n    effect ePoison;\r\n    if(IsObjectPartyMember(OBJECT_SELF))\r\n    {\r\n        int nCnt = 0;\r\n        for(nCnt; nCnt > 2; nCnt++)\r\n        {\r\n            ePoison = GetFirstEffect(GetPartyMemberByIndex(nCnt));\r\n            while(GetIsEffectValid(ePoison))\r\n            {\r\n                if(GetEffectType(ePoison) == EFFECT_TYPE_POISON)\r\n                {\r\n                    return GetPartyMemberByIndex(nCnt);\r\n                }\r\n                ePoison = GetNextEffect(GetPartyMemberByIndex(nCnt));\r\n            }\r\n        }\r\n    }\r\n    else\r\n    {\r\n        ePoison = GetFirstEffect(OBJECT_SELF);\r\n        while(GetIsEffectValid(ePoison))\r\n        {\r\n            if(GetEffectType(ePoison) == EFFECT_TYPE_POISON)\r\n            {\r\n                return OBJECT_SELF;\r\n            }\r\n            ePoison = GetNextEffect(OBJECT_SELF);\r\n        }\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG ***************  Returning Invalid Poison Object");\r\n    return OBJECT_INVALID;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Check for Injuries\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns member index +1 or false depending on\r\n    whether the object belongs in the PCs party.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 9, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nobject GN_CheckIfInjured()\r\n{\r\n    GN_MyPrintString("GENERIC DEBUG ***************  Starting Injury Check Function");\r\n    if(IsObjectPartyMember(OBJECT_SELF) || GetRacialType(OBJECT_SELF) == RACIAL_TYPE_DROID)\r\n    {\r\n\r\n        object oP0=GetPartyMemberByIndex(0);\r\n        object oP1=GetPartyMemberByIndex(1);\r\n        object oP2=GetPartyMemberByIndex(2);\r\n\r\n        float fDown00 = 10.0;\r\n        float fDown01 = 10.0;\r\n        float fDown02 = 10.0;\r\n\r\n        if(GetIsObjectValid(oP0) && GetRacialType(oP0) != RACIAL_TYPE_DROID)\r\n        {\r\n            fDown00 = IntToFloat(GetCurrentHitPoints(oP0)) / IntToFloat(GetMaxHitPoints(oP0));\r\n        }\r\n        if(GetIsObjectValid(oP1)&& GetRacialType(oP0) != RACIAL_TYPE_DROID)\r\n        {\r\n            fDown01 = IntToFloat(GetCurrentHitPoints(oP1)) / IntToFloat(GetMaxHitPoints(oP1));\r\n        }\r\n        if(GetIsObjectValid(oP2) && GetRacialType(oP0) != RACIAL_TYPE_DROID)\r\n        {\r\n            fDown02 = IntToFloat(GetCurrentHitPoints(oP2)) / IntToFloat(GetMaxHitPoints(oP2));\r\n        }\r\n\r\n        if(GetIsObjectValid(oP0) && !GetIsDead(oP0) && (fDown00 < 0.5 && fDown00 > 0.0))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG ***************  Return oP0");\r\n            return oP0;\r\n        }\r\n        else if(GetIsObjectValid(oP1) && !GetIsDead(oP1) && (fDown00 < 0.5 && fDown00 > 0.0))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG ***************  Return oP1");\r\n            return oP1;\r\n        }\r\n        else if(GetIsObjectValid(oP2) && !GetIsDead(oP2) && (fDown00 < 0.5 && fDown00 > 0.0))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG ***************  Return oP2");\r\n            return oP2;\r\n        }\r\n    }\r\n    else\r\n    {\r\n        float fNPC = IntToFloat(GetCurrentHitPoints(OBJECT_SELF)) / IntToFloat(GetMaxHitPoints(OBJECT_SELF));\r\n        if(fNPC < 0.5)\r\n        {\r\n            return OBJECT_SELF;\r\n        }\r\n    }\r\n    return OBJECT_INVALID;\r\n}\r\n\r\n//:://///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n//:: Generic Talent Routines\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//::////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n//::////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: June 12, 2002\r\n//::////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n\r\nint GN_TalentMasterRoutine(int nTalentConstant, object oTarget)\r\n{\r\n    if(GetIsObjectValid(oTarget))\r\n    {\r\n        talent tSpe11_01, tSpe11_02, tSpe11_03, tSpe11_04, tSpe11_05, tSpe11_06, tSpe11_07, tUse;\r\n        int nTalent;\r\n        int bValid = FALSE;\r\n        int bHostile = FALSE;\r\n        if(nTalentConstant == GEN_TALENT_SUPRESS_FORCE)\r\n        {\r\n            nTalent = 0xf021; //Any Area, No Harmful, Dispel, Ranged\r\n        }\r\n        else if(nTalentConstant == GEN_TALENT_REMOVE_POISON)\r\n        {\r\n            bValid = FALSE;\r\n            tSpe11_01 = TalentSpell(FORCE_POWER_HEAL);\r\n            tSpe11_02 = TalentSpell(FORCE_POWER_CURE);\r\n            tSpe11_03 = TalentSpell(67); //Remove Poison Item\r\n            if(GetCreatureHasTalent(tSpe11_01) || GetCreatureHasTalent(tSpe11_02))\r\n            {\r\n                bValid = TRUE;\r\n                if(GetCreatureHasTalent(tSpe11_01))\r\n                {\r\n                    tUse = tSpe11_01;\r\n                }\r\n                else\r\n                {\r\n                    tUse = tSpe11_02;\r\n                }\r\n            }\r\n            else if(GetCreatureHasTalent(tSpe11_03) && oTarget == OBJECT_SELF)\r\n            {\r\n                bValid = TRUE;\r\n                tUse = tSpe11_03;\r\n            }\r\n            //nTalent = 0xff4f;\r\n        }\r\n        else if(nTalentConstant == GEN_TALENT_HEALING)\r\n        {\r\n            bValid = FALSE;\r\n            GN_MyPrintString("GENERIC DEBUG *************** Starting Heal Talent Checks " + GN_ReturnDebugName(OBJECT_SELF));\r\n            tSpe11_01 = TalentSpell(FORCE_POWER_HEAL);\r\n            tSpe11_02 = TalentSpell(FORCE_POWER_CURE);\r\n\r\n            if(GetRacialType(OBJECT_SELF) != RACIAL_TYPE_DROID)\r\n            {\r\n                tSpe11_05 = GetCreatureTalentBest(0x1408, 20);\r\n            }\r\n            else\r\n            {\r\n                tSpe11_05 = TalentSpell(128);\r\n                if(!GetCreatureHasTalent(tSpe11_05))\r\n                {\r\n                    tSpe11_05 = TalentSpell(127);\r\n                    if(!GetCreatureHasTalent(tSpe11_05))\r\n                    {\r\n                        tSpe11_05 = TalentSpell(84);\r\n                    }\r\n                }\r\n            }\r\n\r\n            tSpe11_06 = TalentSpell(FORCE_POWER_DRAIN_LIFE);\r\n            tSpe11_07 = TalentSpell(FORCE_POWER_DEATH_FIELD);\r\n            tUse;\r\n            bValid = FALSE;\r\n\r\n            if(GetCreatureHasTalent(tSpe11_01) || GetCreatureHasTalent(tSpe11_02))\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** I have Heal or Cure");\r\n                bValid = TRUE;\r\n                if(GetCreatureHasTalent(tSpe11_01))\r\n                {\r\n                    tUse = tSpe11_01;\r\n                }\r\n                else\r\n                {\r\n                    tUse = tSpe11_02;\r\n                }\r\n            }\r\n            else if(GetIsTalentValid(tSpe11_05) ||\r\n                    GetCreatureHasTalent(tSpe11_06) ||\r\n                    GetCreatureHasTalent(tSpe11_07))\r\n            {\r\n                if(oTarget == OBJECT_SELF)\r\n                {\r\n                    if(GetCreatureHasTalent(tSpe11_07) && !IsObjectPartyMember(OBJECT_SELF))\r\n                    {\r\n                        GN_MyPrintString("GENERIC DEBUG *************** I have Death Field");\r\n                        bValid = TRUE;\r\n                        bHostile = TRUE;\r\n                        tUse = tSpe11_07;\r\n                    }\r\n                    else if(GetCreatureHasTalent(tSpe11_06) && !IsObjectPartyMember(OBJECT_SELF))\r\n                    {\r\n                        GN_MyPrintString("GENERIC DEBUG *************** I have Drain Life");\r\n                        bValid = TRUE;\r\n                        bHostile = TRUE;\r\n                        tUse = tSpe11_06;\r\n                    }\r\n                    else\r\n                    {\r\n                        GN_MyPrintString("GENERIC DEBUG *************** I have a Med Pack");\r\n                        bValid = TRUE;\r\n                        tUse = tSpe11_05;\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        else if(nTalentConstant == GEN_TALENT_BUFF)\r\n        {\r\n            bValid = FALSE;\r\n            tSpe11_01 = TalentSpell(36); //Master Valor\r\n            tSpe11_02 = TalentSpell(33); //Knight Valor\r\n            tSpe11_03 = TalentSpell(22); //Valor\r\n            int bBuff = FALSE;\r\n            if(GetCreatureHasTalent(tSpe11_01))\r\n            {\r\n                bBuff = TRUE;\r\n                tUse = tSpe11_01;\r\n            }\r\n            else if(GetCreatureHasTalent(tSpe11_02))\r\n            {\r\n                bBuff = TRUE;\r\n                tUse = tSpe11_02;\r\n            }\r\n            else if(GetCreatureHasTalent(tSpe11_03))\r\n            {\r\n                bBuff = TRUE;\r\n                tUse = tSpe11_03;\r\n            }\r\n            GN_MyPrintString("GENERIC DEBUG *************** Spell Effect 22" + GN_ITS(GetHasSpellEffect(22)));\r\n            GN_MyPrintString("GENERIC DEBUG *************** Spell Effect 33" + GN_ITS(GetHasSpellEffect(33)));\r\n            GN_MyPrintString("GENERIC DEBUG *************** Spell Effect 36" + GN_ITS(GetHasSpellEffect(36)));\r\n            if(!GetHasSpellEffect(22) &&\r\n               !GetHasSpellEffect(33) &&\r\n               !GetHasSpellEffect(36) &&\r\n               bBuff == TRUE)\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** I do have VALOR");\r\n                bValid = TRUE;\r\n            }\r\n            else\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** I do not have VALOR");\r\n                bValid = FALSE;\r\n            }\r\n        }\r\n\r\n        if(bValid == TRUE && bHostile == FALSE)\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Clear 2300");\r\n            int nSpell = GetIdFromTalent(tUse);\r\n            GN_MyPrintString("GENERIC DEBUG *************** Spells.2DA ID = " + GN_ITS(nSpell));\r\n            ClearAllActions();\r\n            ActionUseTalentOnObject(tUse, OBJECT_SELF);\r\n            return TRUE;\r\n        }\r\n        else if(bValid == TRUE && bHostile == TRUE)\r\n        {\r\n            oTarget = GN_GetActivePartyMember(TRUE);\r\n            if(GetIsObjectValid(oTarget))\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** Hostile Heal Targeted On: " + GN_ReturnDebugName(oTarget));\r\n                GN_MyPrintString("GENERIC DEBUG *************** Clear 2400");\r\n                ClearAllActions();\r\n                ActionUseTalentOnObject(tUse, oTarget);\r\n                return TRUE;\r\n            }\r\n        }\r\n        talent tUse2 = GetCreatureTalentBest(nTalent, 20);\r\n        if(GetIsTalentValid(tUse) && !GetHasSpellEffect(GetIdFromTalent(tUse)))\r\n        {\r\n            if(GetIsObjectValid(oTarget))\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** Clear 2500");\r\n                ClearAllActions();\r\n                GN_MyPrintString("GENERIC DEBUG *************** Target = " + GetName(oTarget) + " Talent Code = " + IntToString(nTalent));\r\n                ActionUseTalentOnObject(tUse, OBJECT_SELF);\r\n                return TRUE;\r\n            }\r\n        }\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** " + GN_ReturnDebugName(OBJECT_SELF) + " VP = " + GN_ITS(GetCurrentHitPoints())+ "/" + GN_ITS(GetMaxHitPoints()) );\r\n    GN_MyPrintString("GENERIC DEBUG *************** Healing Not Used");\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Last Round Setup\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Sets the following struct up so that Last Rounds\r\n    information is easier to access.\r\n\r\n    int nLastAction;\r\n    int nLastActionID;\r\n    int nLastTalentCode;\r\n    object oLastTarget;\r\n    int nTalentSuccessCode;\r\n    int nIsLastTargetDebil;\r\n    int nLastCombo;\r\n    int nLastComboIndex;\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 26, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid GN_SetLastRoundData()\r\n{\r\n     talent tTalent;\r\n\r\n     tPR.oLastTarget = GetLastHostileTarget();\r\n     tPR.nIsLastTargetDebil = GetIsDebilitated(tPR.oLastTarget);\r\n     tPR.nLastAction = GetLastAttackAction();\r\n     if(tPR.nLastAction == ACTION_CASTSPELL)\r\n     {\r\n        tPR.nLastActionID = GetLastForcePowerUsed();\r\n        tPR.nTalentSuccessCode = GetWasForcePowerSuccessful();\r\n        tTalent = TalentSpell(tPR.nLastActionID);\r\n        tPR.nLastTalentCode = GetCategoryFromTalent(tTalent);\r\n     }\r\n     else if(tPR.nLastAction == ACTION_ATTACKOBJECT)\r\n     {\r\n        tPR.nLastActionID = GetLastCombatFeatUsed();\r\n        tPR.nTalentSuccessCode = GetLastAttackResult();\r\n        tTalent = TalentFeat(tPR.nLastActionID);\r\n        tPR.nLastTalentCode = GetCategoryFromTalent(tTalent);\r\n     }\r\n     //tPR.nLastCombo = GetLocalNumber(OBJECT_SELF, SW_NUMBER_LAST_COMBO);\r\n     tPR.nLastComboIndex = GetLocalNumber(OBJECT_SELF, SW_NUMBER_COMBO_INDEX);\r\n     tPR.nCurrentCombo = GetLocalNumber(OBJECT_SELF, SW_NUMBER_COMBO_ROUTINE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Combo Sub Routine\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This function determines what move to do\r\n    based on the last part of the combo performed.\r\n    int nLastAction;\r\n    int nLastActionID;\r\n    int nLastTalentCode;\r\n    object oLastTarget;\r\n    int nTalentSuccessCode;\r\n    int nIsLastTargetDebil;\r\n    int nLastCombo;\r\n    int nLastComboIndex;\r\n    int nCurrentCombo;\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 27, 2002\r\n//:://////////////////////////////////////////////\r\ntalent GN_GetComboMove(int nBoss = FALSE)\r\n{\r\n    int nRand;\r\n    int nCombo;\r\n    talent tUse;\r\n    int nNPC_AI = GetNPCAIStyle(OBJECT_SELF); //Determines how the individual should react in combat\r\n    GN_MyPrintString("GENERIC DEBUG *************** Starting GetComboMove");\r\n\r\n    //Is the last combo done?\r\n    if(tPR.nLastComboIndex == 4 || tPR.nLastComboIndex == 0)\r\n    {\r\n        //If so then set the local numbers controlling the combo to 0;\r\n        SetLocalNumber(OBJECT_SELF, SW_NUMBER_COMBO_INDEX, 0);\r\n        SetLocalNumber(OBJECT_SELF, SW_NUMBER_COMBO_ROUTINE, 0);\r\n        nRand = d6();\r\n        if(nRand > 0)//This nRand check is place here in case we need to limit combo use later\r\n        {\r\n            //If a Jedi use the jedi routines.\r\n            if(GetLevelByClass(CLASS_TYPE_JEDICONSULAR) > 0 ||\r\n               GetLevelByClass(CLASS_TYPE_JEDIGUARDIAN) > 0 ||\r\n               GetLevelByClass(CLASS_TYPE_JEDISENTINEL) > 0)\r\n            {\r\n                nCombo = GN_GetStandardJediCombo(nBoss);\r\n\r\n                GN_MyPrintString("GENERIC DEBUG *************** Starting Jedi Combo " + GN_FetchComboString(nCombo));\r\n\r\n                SetLocalNumber(OBJECT_SELF, SW_NUMBER_COMBO_INDEX, 1);\r\n                SetLocalNumber(OBJECT_SELF, SW_NUMBER_COMBO_ROUTINE, nCombo);\r\n\r\n                return GN_GetNextTalentInCombo(nCombo);\r\n            }\r\n            //If a Droid use these routines\r\n            else if(GetLevelByClass(CLASS_TYPE_COMBATDROID) > 0 ||\r\n                    GetLevelByClass(CLASS_TYPE_EXPERTDROID) > 0)\r\n            {\r\n                nCombo = GN_GetStandardDroidCombo(nBoss);\r\n                GN_MyPrintString("GENERIC DEBUG *************** Starting Droid Combo " + GN_FetchComboString(nCombo));\r\n                SetLocalNumber(OBJECT_SELF, SW_NUMBER_COMBO_INDEX, 1);\r\n                SetLocalNumber(OBJECT_SELF, SW_NUMBER_COMBO_ROUTINE, nCombo);\r\n\r\n                return GN_GetNextTalentInCombo(nCombo);\r\n            }\r\n            //All others.\r\n            else\r\n            {\r\n                nCombo = GN_GetStandardNPCCombo(nBoss);\r\n                GN_MyPrintString("GENERIC DEBUG *************** Starting NPC Combo " + GN_FetchComboString(nCombo));\r\n                SetLocalNumber(OBJECT_SELF, SW_NUMBER_COMBO_INDEX, 1);\r\n                SetLocalNumber(OBJECT_SELF, SW_NUMBER_COMBO_ROUTINE, nCombo);\r\n\r\n                return GN_GetNextTalentInCombo(nCombo);\r\n            }\r\n        }\r\n        else//returning an invalid Talent here will mean action attack.\r\n        {\r\n            return tUse;\r\n        }\r\n    }\r\n    else//if(tPR.nTalentSuccessCode > 0)\r\n    {\r\n        //If the PC is already in a combo then continue that combo\r\n        GN_MyPrintString("GENERIC DEBUG *************** Continuing Combo " + GN_FetchComboString(tPR.nCurrentCombo));\r\n        return GN_GetNextTalentInCombo(tPR.nCurrentCombo);\r\n    }\r\n    return tUse;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Check Droid Utility Usage\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks the target and the droid utility use\r\n    to make sure they are compatible\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 22, 2003\r\n//:://////////////////////////////////////////////\r\ntalent GN_CheckDroidUtilityUsage(object oTarget, talent tUse)\r\n{\r\n    int bSwitch;\r\n    GN_MyPrintString("GENERIC DEBUG *************** Starting Droid Talent Double Check");\r\n    if(GetTypeFromTalent(tUse) == TALENT_TYPE_FORCE)\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Droid Talent is a Spell");\r\n        if(GetIdFromTalent(tUse) == 116 || GetIdFromTalent(tUse) == 117) //STUN RAY\r\n        {\r\n            if(GetRacialType(oTarget) == RACIAL_TYPE_HUMAN)\r\n            {\r\n                return tUse;\r\n            }\r\n            else\r\n            {\r\n                bSwitch = TRUE;\r\n            }\r\n        }\r\n        if(GetIdFromTalent(tUse) == 118 || GetIdFromTalent(tUse) == 119) //SHIELD DISRUPTOR\r\n        {\r\n            if(GetHasSpellEffect(99, oTarget) || GetHasSpellEffect(100, oTarget) || GetHasSpellEffect(101, oTarget) ||\r\n               GetHasSpellEffect(102, oTarget) || GetHasSpellEffect(103, oTarget) || GetHasSpellEffect(104, oTarget) ||\r\n               GetHasSpellEffect(105, oTarget) || GetHasSpellEffect(106, oTarget) || GetHasSpellEffect(107, oTarget) ||\r\n               GetHasSpellEffect(110, oTarget) || GetHasSpellEffect(111, oTarget) || GetHasSpellEffect(112, oTarget) ||\r\n               GetHasSpellEffect(113, oTarget) || GetHasSpellEffect(114, oTarget) || GetHasSpellEffect(115, oTarget))\r\n            {\r\n                return tUse;\r\n            }\r\n            else\r\n            {\r\n                bSwitch = TRUE;\r\n            }\r\n        }\r\n    }\r\n    if(bSwitch == TRUE)\r\n    {\r\n        talent tFeat = GetCreatureTalentBest(0x1181, 20);\r\n        if(GetIsTalentValid(tUse) && GetCreatureHasTalent(tUse))\r\n        {\r\n            return tFeat;\r\n        }\r\n        else\r\n        {\r\n            talent Invalid;\r\n            return Invalid;\r\n        }\r\n    }\r\n    return tUse;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Throw Lightsaber Check\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks the target and the force power to make\r\n    sure that a lightsaber is not thrown from close\r\n    range.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 24, 2003\r\n//:://////////////////////////////////////////////\r\ntalent GN_CheckThrowLightSaberUsage(object oTarget, talent tUse)\r\n{\r\n    int bSwitch = FALSE;\r\n    if(GetTypeFromTalent(tUse) == TALENT_TYPE_FORCE)\r\n    {\r\n        if(GetIdFromTalent(tUse) == FORCE_POWER_LIGHT_SABER_THROW || GetIdFromTalent(tUse) == FORCE_POWER_LIGHT_SABER_THROW_ADVANCED)\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Lightsaber Throw Check = " + FloatToString(GetDistanceBetween(OBJECT_SELF, oTarget),4,2));\r\n            if(GetDistanceBetween(OBJECT_SELF, oTarget) < 10.0)\r\n            {\r\n                bSwitch = TRUE;\r\n            }\r\n        }\r\n    }\r\n    if(bSwitch == TRUE)\r\n    {\r\n        talent tFeat = GetCreatureTalentBest(0x1104, 20);\r\n        if(GetIsTalentValid(tUse) && GetCreatureHasTalent(tUse))\r\n        {\r\n            return tFeat;\r\n        }\r\n        else\r\n        {\r\n            talent Invalid;\r\n            return Invalid;\r\n        }\r\n    }\r\n    return tUse;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Check Droid Force Power Usage\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks the force power and makes sure it can\r\n    be used on a droid.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On:May 12, 2003\r\n//:://////////////////////////////////////////////\r\ntalent GN_CheckNonDroidForcePower(object oTarget, talent tUse)\r\n{\r\n    int bSwitch = FALSE;\r\n    if(GetTypeFromTalent(tUse) == TALENT_TYPE_FORCE)\r\n    {\r\n        if(GetIdFromTalent(tUse) == FORCE_POWER_HOLD ||\r\n           GetIdFromTalent(tUse) == FORCE_POWER_HORROR ||\r\n           GetIdFromTalent(tUse) == FORCE_POWER_INSANITY ||\r\n           GetIdFromTalent(tUse) == FORCE_POWER_KILL ||\r\n           GetIdFromTalent(tUse) == FORCE_POWER_PLAGUE ||\r\n           GetIdFromTalent(tUse) == FORCE_POWER_SLEEP ||\r\n           GetIdFromTalent(tUse) == FORCE_POWER_SLOW ||\r\n           GetIdFromTalent(tUse) == FORCE_POWER_STUN ||\r\n           GetIdFromTalent(tUse) == FORCE_POWER_WOUND ||\r\n           GetIdFromTalent(tUse) == FORCE_POWER_AFFLICTION ||\r\n           GetIdFromTalent(tUse) == FORCE_POWER_CHOKE ||\r\n           GetIdFromTalent(tUse) == FORCE_POWER_DEATH_FIELD ||\r\n           GetIdFromTalent(tUse) == FORCE_POWER_DRAIN_LIFE ||\r\n           GetIdFromTalent(tUse) == FORCE_POWER_FEAR)\r\n        {\r\n            if(GetRacialType(oTarget) == RACIAL_TYPE_DROID)\r\n            {\r\n                bSwitch = TRUE;\r\n            }\r\n        }\r\n    }\r\n    if(bSwitch == TRUE)\r\n    {\r\n        talent tFeat = GetCreatureTalentBest(0x1104, 20);\r\n        if(GetIsTalentValid(tUse) && GetCreatureHasTalent(tUse))\r\n        {\r\n            return tFeat;\r\n        }\r\n        else\r\n        {\r\n            talent Invalid;\r\n            return Invalid;\r\n        }\r\n    }\r\n    return tUse;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Play Ambient Animations\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Play the correct animations based on the\r\n    spawn in condition selected.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Dec 4, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid GN_PlayAmbientAnimation()\r\n{\r\n    if(!GetIsInConversation(OBJECT_SELF))\r\n    {\r\n        location lLocal;\r\n        vector vFrnd;\r\n        int nRoll = d2();\r\n        object oFriend = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, OBJECT_SELF, nRoll, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN);\r\n        if(!GetIsObjectValid(oFriend))\r\n        {\r\n            oFriend = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_NEUTRAL, OBJECT_SELF, nRoll, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN);\r\n        }\r\n        object oEnemy = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY);\r\n        int nHDMe = GetHitDice(OBJECT_SELF);\r\n        int nHDOther = GetHitDice(oFriend);\r\n\r\n        if(!GN_CheckShouldFlee() || !GN_GetSpawnInCondition(SW_FLAG_COMMONER_BEHAVIOR))\r\n        {\r\n            if(GN_GetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS))\r\n            {\r\n                vFrnd = GetPosition(oFriend);\r\n                nRoll = d6();\r\n                if(GetIsObjectValid(oFriend) && GetDistanceBetween(oFriend, OBJECT_SELF) < 5.0 && !IsObjectPartyMember(oFriend))\r\n                {\r\n                    SetFacingPoint(vFrnd);\r\n                    GN_MyPrintString("GENERIC DEBUG *************** Clear 2600");\r\n                    ClearAllActions();\r\n                    if(nRoll == 1 || nRoll == 2)\r\n                    {\r\n                        ActionPlayAnimation(ANIMATION_LOOPING_TALK_NORMAL, 1.0, 3.0);\r\n                    }\r\n                    else if(nRoll == 3)\r\n                    {\r\n                        ActionPlayAnimation(ANIMATION_LOOPING_TALK_LAUGHING, 1.0, 3.0);\r\n                    }\r\n                    else if(nRoll == 4)\r\n                    {\r\n                        ActionPlayAnimation(ANIMATION_LOOPING_TALK_FORCEFUL, 1.0, 3.0);\r\n                    }\r\n                    else if(nRoll == 5)\r\n                    {\r\n                        ActionPlayAnimation(ANIMATION_FIREFORGET_HEAD_TURN_LEFT);\r\n                    }\r\n                    else if(nRoll == 6)\r\n                    {\r\n                        ActionPlayAnimation(ANIMATION_FIREFORGET_HEAD_TURN_RIGHT);\r\n                    }\r\n                }\r\n                else\r\n                {\r\n                    nRoll = d8();\r\n                    if(nRoll == 1)\r\n                    {\r\n                        ActionPlayAnimation(ANIMATION_FIREFORGET_PAUSE_BORED, 1.0);\r\n                    }\r\n                    else if(nRoll == 2)\r\n                    {\r\n                        ActionPlayAnimation(ANIMATION_FIREFORGET_PAUSE_SCRATCH_HEAD, 1.0);\r\n                    }\r\n                    else if(nRoll == 3)\r\n                    {\r\n                        ActionPlayAnimation(ANIMATION_LOOPING_PAUSE2, 1.0, 3.0);\r\n                    }\r\n                    else if(nRoll == 4 || nRoll == 5)\r\n                    {\r\n                        if(GetGender(OBJECT_SELF) == GENDER_MALE)\r\n                        {\r\n                            GN_SetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS, FALSE);\r\n                            ActionPlayAnimation(ANIMATION_LOOPING_PAUSE3, 1.0, 20.4);\r\n                            ActionDoCommand(GN_SetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS, TRUE));\r\n                        }\r\n                        else if(GetGender(OBJECT_SELF) == GENDER_FEMALE)\r\n                        {\r\n                            GN_SetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS, FALSE);\r\n                            ActionPlayAnimation(ANIMATION_LOOPING_PAUSE3, 1.0, 13.3);\r\n                            ActionDoCommand(GN_SetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS, TRUE));\r\n                        }\r\n                    }\r\n                    else if(nRoll == 6)\r\n                    {\r\n                        ActionPlayAnimation(ANIMATION_FIREFORGET_HEAD_TURN_LEFT);\r\n                    }\r\n                    else if(nRoll == 7)\r\n                    {\r\n                        ActionPlayAnimation(ANIMATION_FIREFORGET_HEAD_TURN_RIGHT);\r\n                    }\r\n                    else if(nRoll == 8)\r\n                    {\r\n                        GN_SetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS, FALSE);\r\n                        ActionPlayAnimation(ANIMATION_LOOPING_PAUSE2, 1.0, 5.0);\r\n                        ActionDoCommand(GN_SetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS, TRUE));\r\n                    }\r\n                }\r\n            }\r\n            else if(GN_GetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS_MOBILE))\r\n            {\r\n                nRoll = d8();\r\n                GN_MyPrintString("GENERIC DEBUG *************** Clear 2700");\r\n                ClearAllActions();\r\n                if(nRoll == 1)\r\n                {\r\n                    ActionPlayAnimation(ANIMATION_LOOPING_PAUSE2, 1.0, 2.0);\r\n                }\r\n                else if(nRoll == 2)\r\n                {\r\n                    ActionPlayAnimation(ANIMATION_FIREFORGET_TAUNT, 1.0);\r\n                }\r\n                else if(nRoll == 3)\r\n                {\r\n                    //ActionPlayAnimation(ANIMATION_FIREFORGET_HEAD_TURN_LEFT, 0.75);\r\n                    //ActionPlayAnimation(ANIMATION_FIREFORGET_HEAD_TURN_RIGHT, 0.75);\r\n                }\r\n                else if(nRoll == 4)\r\n                {\r\n                    ActionPlayAnimation(ANIMATION_FIREFORGET_VICTORY1, 1.0);\r\n                }\r\n                else if(nRoll >= 5)\r\n                {\r\n                    ActionRandomWalk();\r\n                }\r\n            }\r\n        }\r\n        else if(GN_CheckShouldFlee() && GN_GetSpawnInCondition(SW_FLAG_COMMONER_BEHAVIOR))\r\n        {\r\n            GN_CommonAI();\r\n        }\r\n    }\r\n}\r\n//::///////////////////////////////////////////////\r\n//:: Commoner AI\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    If ever engaged in combat they will flee.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: July 18, 2002\r\n//:://////////////////////////////////////////////\r\nint GN_CommonAI()\r\n{\r\n    GN_MyPrintString("GENERIC DEBUG *************** Start Commoner AI");\r\n    object oEnemy = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY);\r\n    object oFlee;\r\n    int bValid = TRUE;\r\n    int nIdx = 1;\r\n\r\n    object oNeutral = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_NEUTRAL);\r\n    while(GetIsObjectValid(oNeutral) && bValid == TRUE)\r\n    {\r\n        if(GetStandardFaction(oNeutral) == STANDARD_FACTION_HOSTILE_1 ||\r\n            GetStandardFaction(oNeutral) == STANDARD_FACTION_HOSTILE_2 ||\r\n            GetStandardFaction(oNeutral) == STANDARD_FACTION_INSANE)\r\n        {\r\n            if(GetDistanceBetween(OBJECT_SELF, oNeutral) <= 20.0)\r\n            {\r\n                oFlee = oNeutral;\r\n                bValid = FALSE;\r\n            }\r\n        }\r\n        else\r\n        {\r\n            nIdx++;\r\n            oNeutral = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_NEUTRAL, OBJECT_SELF, nIdx);\r\n        }\r\n    }\r\n\r\n    if(GetIsObjectValid(oEnemy))\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Clear 2710");\r\n        ClearAllActions();\r\n        ActionMoveAwayFromObject(oEnemy, TRUE, 20.0);\r\n        DelayCommand(0.2, ActionDoCommand(GN_ActionDoPostDCRChecks()));\r\n        return TRUE;\r\n    }\r\n    else if(GetIsObjectValid(oFlee))\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Object Flee = " + GN_ReturnDebugName(oFlee));\r\n        GN_MyPrintString("GENERIC DEBUG *************** Clear 2720");\r\n        ClearAllActions();\r\n        ActionMoveAwayFromObject(oFlee, TRUE, 20.0);\r\n        DelayCommand(0.2, ActionDoCommand(GN_ActionDoPostDCRChecks()));\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n//::///////////////////////////////////////////////\r\n//:: Should Commoner Flee\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks a number of conditions for a commoner\r\n    to flee.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Dec 20, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_CheckShouldFlee()\r\n{\r\n    int nIdx = 1;\r\n    object oNeutral = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_NEUTRAL, OBJECT_SELF, 1, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN);\r\n    object oHostile = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY, OBJECT_SELF, 1, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN);\r\n    while(GetIsObjectValid(oNeutral) || GetIsObjectValid(oHostile))\r\n    {\r\n        if(GetIsObjectValid(oHostile))\r\n        {\r\n            return TRUE;\r\n        }\r\n        if(GetIsObjectValid(oNeutral))\r\n        {\r\n            if(GetStandardFaction(oNeutral) == STANDARD_FACTION_HOSTILE_1 ||\r\n                GetStandardFaction(oNeutral) == STANDARD_FACTION_HOSTILE_2 ||\r\n                GetStandardFaction(oNeutral) == STANDARD_FACTION_INSANE)\r\n            {\r\n                return TRUE;\r\n            }\r\n        }\r\n        nIdx++;\r\n        oNeutral = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_NEUTRAL, OBJECT_SELF, nIdx, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN);\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Reset Deactivated Droid\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Resets a Droid to his deactivated animation\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Feb 25, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nvoid GN_ResetDroidDeactivationState(object oDroid = OBJECT_SELF)\r\n{\r\n    /*\r\n    GN_SetSpawnInCondition(SW_FLAG_EVENT_ON_HEARTBEAT, FALSE);\r\n    ClearAllActions();\r\n    ActionPlayAnimation(ANIMATION_LOOPING_DEACTIVATE, 1.0, 900.0);\r\n    ActionDoCommand(GN_SetSpawnInCondition(SW_FLAG_EVENT_ON_HEARTBEAT, TRUE));\r\n    */\r\n    ClearAllActions();\r\n    ActionPlayAnimation(ANIMATION_LOOPING_DEACTIVATE, 1.0, -1.0);\r\n    GN_SetSpawnInCondition(SW_FLAG_EVENT_ON_HEARTBEAT, FALSE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Determine Attack Target\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks the nearest seen target and oIntruder\r\n    for a valid attack target.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 7, 2002\r\n//:://////////////////////////////////////////////\r\nobject GN_DetermineAttackTarget(object oIntruder = OBJECT_INVALID)\r\n{\r\n    GN_MyPrintString("GENERIC DEBUG *************** Starting: Determine Attack Target");\r\n\r\n    int nPartyAI = GetPartyAIStyle();\r\n    int nNPC_AI = GetNPCAIStyle(OBJECT_SELF);\r\n    object oTarget;\r\n    object oLastTarget = GetLastHostileTarget();\r\n\r\n    GN_MyPrintString("GENERIC DEBUG *************** Intruder = " + IntToString(GetIsObjectValid(oIntruder)) + " Last Target = " + IntToString(GetIsObjectValid(oLastTarget)));\r\n\r\n    if(GetIsObjectValid(oIntruder) && !GetIsDead(oIntruder) && !GetIsDebilitated(oIntruder))\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Intruder Target Returned = " + ObjectToString(oIntruder));\r\n        return oIntruder;\r\n    }\r\n    else if(GetIsObjectValid(oLastTarget) && !GetIsDead(oLastTarget) && !GetIsDebilitated(oLastTarget))\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Last Target Returned = " + ObjectToString(oIntruder));\r\n        return oLastTarget;\r\n    }\r\n    else\r\n    {\r\n        if(nPartyAI == PARTY_AISTYLE_AGGRESSIVE)\r\n        {\r\n            int nCnt = 1;\r\n            GN_MyPrintString("GENERIC DEBUG *************** Getting nearest target - 249");\r\n            object oATarget = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY, OBJECT_SELF, nCnt, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN);\r\n            oTarget = oATarget;\r\n            while(!GetIsDebilitated(oTarget) && GetIsObjectValid(oTarget))\r\n            {\r\n                nCnt++;\r\n                oTarget = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY, OBJECT_SELF, nCnt, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN);\r\n            }\r\n            if(!GetIsObjectValid(oTarget) && GetIsObjectValid(oATarget))\r\n            {\r\n                oTarget = oATarget;\r\n            }\r\n        }\r\n        else if(nPartyAI == PARTY_AISTYLE_DEFENSIVE)\r\n        {\r\n            int nCnt = 0;\r\n            object oHostile;\r\n            while(!GetIsObjectValid(oHostile) && nCnt < 3)\r\n            {\r\n                oHostile = GetLastHostileActor(GetPartyMemberByIndex(nCnt));\r\n                nCnt++;\r\n            }\r\n            if(GetIsObjectValid(oHostile))\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** Getting nearest target - 262");\r\n                oTarget = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY, OBJECT_SELF, 1, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN);\r\n            }\r\n            else\r\n            {\r\n                oHostile = GetLastHostileTarget(GetPartyMemberByIndex(0));\r\n                if(GetIsObjectValid(oHostile))\r\n                {\r\n                    GN_MyPrintString("GENERIC DEBUG *************** Getting nearest target - 269");\r\n                    oTarget = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY, OBJECT_SELF, 1, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN);\r\n                }\r\n            }\r\n        }\r\n        else if(nPartyAI != PARTY_AISTYLE_PASSIVE)\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Getting nearest target - 275");\r\n            oTarget = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY, OBJECT_SELF, 1, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN);\r\n        }\r\n        else\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Getting nearest target - 279");\r\n            oTarget = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY, OBJECT_SELF, 1, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN);\r\n        }\r\n    }\r\n    if(GetIsObjectValid(oTarget))\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Attack Target From Determine Attack Target = " + GN_ReturnDebugName(oTarget));\r\n        return oTarget;\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** No Attack Targets Found");\r\n    return OBJECT_INVALID;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Return Talent Code\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This function determines the state of the selected\r\n    attack target and what should be done to them.\r\n    If the target is last rounds target then they\r\n    will try not to use failed attack types.\r\n\r\n    NOTE: The functionality for area attacks and\r\n    specialized talent use will be coded here.\r\n    For the time being, I will just try to get\r\n    the appropriate cascade of talents being used.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 14, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_GetAttackTalentCode(object oTarget)\r\n{\r\n    GN_MyPrintString("GENERIC DEBUG *************** Starting: Getting Talent Attack Code");\r\n\r\n    int nPreviousTalentCode;\r\n    //GN_MyPrintString("GENERIC DEBUG *************** Cooked Return Code  0x0100");\r\n\r\n    GN_MyPrintString("GENERIC DEBUG *************** Debilitated = " + IntToString(GetIsDebilitated(oTarget)));\r\n\r\n    if(!GetIsDead(oTarget) && GetIsObjectValid(oTarget) && !GetIsDebilitated(oTarget) && GetLastHostileTarget() == oTarget)\r\n    {\r\n        //GN_MyPrintString("GENERIC DEBUG *************** Talent Code: Before GetPreviousTalent");\r\n        nPreviousTalentCode = GN_GetPreviousTalentCode();\r\n        //GN_MyPrintString("GENERIC DEBUG *************** Talent Code: Before If Compare");\r\n        if(GN_CompareTalents(nPreviousTalentCode, 0xf2ff))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Talent Code: 0xff1f");\r\n            if(GN_GetHasViableTalent(0xff1f))\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** Return Code 0xff1f");\r\n                return 0xff1f;\r\n            }\r\n            if(GN_GetHasViableTalent(0x0100))\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** Return Code  0xf1ff");\r\n                return 0xf1ff;\r\n            }\r\n        }\r\n        else if(GN_CompareTalents(nPreviousTalentCode, 0xff1f))\r\n        {\r\n            if(GN_GetHasViableTalent(0xf1f0))\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** Return Code  0xf1ff");\r\n                return 0xf1ff;\r\n            }\r\n        }\r\n    }\r\n    else if(!GetIsDead(oTarget) && GetIsObjectValid(oTarget) && !GetIsDebilitated(oTarget) && GetLastHostileTarget() != oTarget)\r\n    {\r\n        if(GN_GetHasViableTalent(0xf3ff))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Return Code  0xf3ff");\r\n            return 0xf3ff;\r\n        }\r\n        if(GN_GetHasViableTalent(0xf2ff))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Return Code  0xf2ff");\r\n            return 0xf2ff;\r\n        }\r\n        if(GN_GetHasViableTalent(0xff1f))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Return Code  0xff1f");\r\n            return 0xff1f;\r\n        }\r\n        if(GN_GetHasViableTalent(0xf1ff))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Return Code  0xf1ff");\r\n            return 0xf1ff;\r\n        }\r\n    }\r\n    else if(!GetIsDead(oTarget) && GetIsObjectValid(oTarget) && GetIsDebilitated(oTarget))\r\n    {\r\n        if(GN_GetHasViableTalent(0xf1ff))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Return Code  0xf1ff");\r\n            return 0xf1ff;\r\n        }\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** Return Code  0xffff");\r\n    return 0xffff;\r\n}\r\n\r\n//this function was cut from the generics but is needed\r\n//here to keep scripts from breaking.\r\nvoid GN_SetDayNightPresence(int nPresenceSetting)\r\n{\r\n\r\n}\r\n', 'k_inc_gensupport': b'//:: k_inc_gensupport\r\n/*\r\n    v1.0\r\n    Support Include for k_inc_generic\r\n\r\n    NOTE - To get these functions\r\n    use k_inc_generic\r\n*/\r\n//:: Created By: Preston Watamaniuk\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n\r\n//BOSS ATTACK TYPES\r\nint SW_BOSS_ATTACK_TYPE_GRENADE = 1;\r\nint SW_BOSS_ATTACK_TYPE_FORCE_POWER = 2;\r\nint SW_BOSS_ATTACK_TYPE_NPC = 3;\r\nint SW_BOSS_ATTACK_TYPE_PC = 4;\r\nint SW_BOSS_ATTACK_ANY = 5;\r\nint SW_BOSS_ATTACK_DROID = 6;\r\n\r\n//LOCAL NUMBERS\r\nint SW_NUMBER_COMBO_ROUTINE = 3;\r\nint SW_NUMBER_COMBO_INDEX = 4;\r\nint SW_NUMBER_LAST_COMBO = 5;\r\nint SW_NUMBER_ROUND_COUNTER = 6;\r\nint SW_NUMBER_COMBAT_ZONE = 7;\r\n\r\n//COMBO CONSTANTS\r\nint SW_COMBO_RANGED_FEROCIOUS = 1;\r\nint SW_COMBO_RANGED_AGGRESSIVE = 2;\r\nint SW_COMBO_RANGED_DISCIPLINED = 3;\r\nint SW_COMBO_RANGED_CAUTIOUS = 4;\r\nint SW_COMBO_MELEE_FEROCIOUS = 5;\r\nint SW_COMBO_MELEE_AGGRESSIVE = 6;\r\nint SW_COMBO_MELEE_DISCIPLINED = 7;\r\nint SW_COMBO_MELEE_CAUTIOUS = 8;\r\nint SW_COMBO_BUFF_PARTY = 9;\r\nint SW_COMBO_BUFF_DEBILITATE = 10;\r\nint SW_COMBO_BUFF_DAMAGE = 11;\r\nint SW_COMBO_BUFF_DEBILITATE_DESTROY = 12;\r\nint SW_COMBO_SUPRESS_DEBILITATE_DESTROY = 13;\r\nint SW_COMBO_SITH_ATTACK = 14;\r\nint SW_COMBO_BUFF_ATTACK = 15;\r\nint SW_COMBO_SITH_CONFOUND = 16;\r\nint SW_COMBO_JEDI_SMITE = 17;\r\nint SW_COMBO_SITH_TAUNT = 18;\r\nint SW_COMBO_SITH_BLADE = 19;\r\nint SW_COMBO_SITH_CRUSH = 20;\r\nint SW_COMBO_JEDI_CRUSH = 21;\r\nint SW_COMBO_SITH_BRUTALIZE = 22;\r\nint SW_COMBO_SITH_DRAIN = 23;\r\nint SW_COMBO_SITH_ESCAPE = 24;\r\nint SW_COMBO_JEDI_BLITZ = 25;\r\nint SW_COMBO_SITH_SPIKE = 26;\r\nint SW_COMBO_SITH_SCYTHE = 27;\r\nint SW_COMBO_DROID_UTILITIES = 28;\r\nint SW_COMBO_DROID_UTILITIES_2 = 29;\r\nint SW_COMBO_INVALID = 30;\r\n\r\nint SW_FLAG_TARGET_FRIEND = 59;\r\n\r\n//****SUPPORT FUNCTIONS FOR THE GENERICS**************************************************************************\r\n//Returns the number targets attacking the passed in object\r\nint GN_GetAttackers(object oTarget);\r\n//Returns the index of the party member passed in or false if the object is not a party member.\r\nint GN_CheckNPCIsInParty(object oNPC);\r\n//Checks whether the attempted spell or attack targets are true\r\nint GN_CheckAttemptedSpellAttackTarget();\r\n//Determines if the object has a valid attempted spell or attack target or a valid attack target.\r\nint GN_GetIsFighting(object oFighting);\r\n//Compares to talent codes to see if specific bits are true.\r\nint GN_CompareTalents(int nTalent1, int nTalent2);\r\n// Returns the talent code for the previous round.\r\nint GN_GetPreviousTalentCode();\r\n//Takes a spell constant and passes back the code\r\nint GN_GetSpellTalentCode(int nSpell);\r\n//Takes a feat constant and passes back the code\r\nint GN_GetFeatTalentCode(int nFeat);\r\n//Searchs for viable talents that can be used by the user and passes back yes or no according to whether one is found.\r\nint GN_GetHasViableTalent(int nTalentCode);\r\n//Returns the exclusion code for the talent based on the racial type of the creature passed in.\r\nint GN_GetExclusionCode(object oTarget);\r\n//This takes a combo constant and returns a talent.\r\ntalent GN_GetNextTalentInCombo(int nCombo);\r\n//Determines if a combo is valid for the object in question\r\nint GN_GetIsComboValid(int nComboType);\r\n//Does the Jedi have a damaging Force Power\r\nint GN_GetHasDamagingForcePower();\r\n//Gets a random combo for a default AI Jedi\r\nint GN_GetStandardJediCombo(int nBoss = FALSE);\r\n//Gets a random combo for a default AI Droid\r\nint GN_GetStandardDroidCombo(int nBoss = FALSE);\r\n//Gets a random combo for a default AI NPC\r\nint GN_GetStandardNPCCombo(int nBoss = FALSE);\r\n// Returns 2 for Ranged and 1 for Melee weapons, checking the basetype\r\nint GN_GetWeaponType(object oTarget = OBJECT_SELF);\r\n//Gets the NPC to eqyuip a melee = 1 or ranged = 2 weapon.\r\nint GN_EquipAppropriateWeapon();\r\n//Returns a talent for the boss to perform in combat.\r\ntalent GN_GetBossCombatMove(int nBossAttackType, int nDroid = FALSE);\r\n//Get Boss AOE Force Powers\r\ntalent GN_GetAOEForcePower(int nDroid = FALSE);\r\n//Get Boss Single Target Force Powers\r\ntalent GN_GetTargetedForcePower(int nDroid = FALSE);\r\n//Returns the number of party members who are active\r\nint GN_GetActivePartyMemberCount();\r\n//Returns the active party member who is not Member(0)\r\nobject GN_GetActivePartyMember(int nDrainTarget = FALSE);\r\n//This function returns an active party member. They must not be dead.  The debilitated parameter will\r\n//ignore those party members already debilitated.\r\nobject GN_ReturnActivePartyMember(int nDebil = FALSE);\r\n\r\n//****VERIFICATION FOR COMMANDS FOR COMBOS**************************************************************************\r\n\r\n//Check Push Series\r\nint GN_CheckSeriesForcePush();\r\n//Check Armor Series\r\nint GN_CheckSeriesArmor();\r\n//Check Fear Series\r\nint GN_CheckSeriesFear();\r\n//Check Hold Series\r\nint GN_CheckSeriesHold();\r\n//Check Poison Series\r\nint GN_CheckSeriesAfflict();\r\n//Check Saber Throw Series\r\nint GN_CheckSeriesSaberThrow();\r\n//Check Lightning Series\r\nint GN_CheckSeriesLightning();\r\n//Check Jump Series\r\nint GN_CheckSeriesJump();\r\n//Check Choke Series\r\nint GN_CheckSeriesChoke();\r\n//Check Drain Life Series\r\nint GN_CheckSeriesDrainLife();\r\n//Check Speed Series\r\nint GN_CheckSeriesSpeed();\r\n//Checks if the droid has utility items\r\nint GN_CheckSeriesDroidUtilities();\r\n//Checks Mind Series\r\nint GN_CheckSeriesMind();\r\n//Checks Resist Series\r\nint GN_CheckSeriesResist();\r\n//Checks Force Immunity Series();\r\nint GN_CheckSeriesForceImmunity();\r\n//Checks the Breach Series\r\nint GN_CheckSeriesBreach();\r\n\r\n//****GET COMMANDS FOR COMBOS**************************************************************************\r\n\r\n//Fetch Series Force Push Power\r\nint GN_GetSeriesForcePush();\r\n//Fetch Series Force Armor Power\r\nint GN_GetSeriesForceArmor();\r\n//Fetch Series Fear Power\r\nint GN_GetSeriesFear();\r\n//Fetch Series Hold Power\r\nint GN_GetSeriesHold();\r\n//Fetch Series Afflict Power\r\nint GN_GetSeriesAfflict();\r\n//Fetch Series Saber Throw Power\r\nint GN_GetSeriesSaberThrow();\r\n//Fetch Series Lightning Power\r\nint GN_GetSeriesLightning();\r\n//Fetch Series Jump Power\r\nint GN_GetSeriesJump();\r\n//Fetch Series Choke Power\r\nint GN_GetSeriesChoke();\r\n//Fetch Series Drain Life Power\r\nint GN_GetSeriesDrainLife();\r\n//Fetch Series Speed Power\r\nint GN_GetSeriesSpeed();\r\n//Fetch Melee Feat\r\nint GN_GetSeriesMeleeFeat();\r\n//Fetch Ranged Feat\r\nint GN_GetSeriesRangedFeat();\r\n//Fetch Mind Series\r\nint GN_GetSeriesMind();\r\n//Fetch Resist Series\r\nint GN_GetSeriesResist();\r\n//Fetch Force Immunity Series();\r\nint GN_GetSeriesForceImmunity();\r\n//Fetch the Breach Series\r\nint GN_GetSeriesBreach();\r\n\r\n//****DEBUG COMMANDS FOR THE GENERICS**************************************************************************\r\n\r\n//Basically, a wrapper for AurPostString\r\nvoid GN_PostString(string sString = "",int x = 10,int y = 10,float fShow = 4.0);\r\n//Makes the object running the script say a speak string.\r\nvoid GN_MySpeakString(string sString);\r\n//Makes the nearest PC say a speakstring.\r\nvoid GN_AssignPCDebugString(string sString);\r\n//Inserts a print string into the log file for debugging purposes.\r\nvoid GN_MyPrintString(string sString);\r\n//Prints to the log file the shout received by a target.\r\nvoid GN_PrintShoutType(object oShouter, int nShout);\r\n//Returns the object ID and name appended to each other.\r\nstring GN_ReturnDebugName(object oTarget);\r\n//Returns a string of the combo being used.\r\nstring GN_FetchComboString(int nCombo);\r\n//Checks the friendly fire on the target out to 3.5m by default.\r\nint GN_CheckFriendlyFireOnTarget(object oTarget, float fDistance = 4.0);\r\n//Checks the enemies around a target object.\r\nint GN_CheckEnemyGroupingOnTarget(object oTarget, float fDistance = 4.0);\r\n//Searches the area and marks a group as a viable target for a grenade\r\nobject GN_FindGrenadeTarget();\r\n//Searches the area and marks a group as a viable target for a AOE force power\r\nobject GN_FindAOETarget();\r\n//Returns a grenade appropriate to the target\r\ntalent GN_GetGrenadeTalent(int nDroid = FALSE);\r\n//Returns the AI style in a string\r\nstring GN_ReturnAIStyle(object oTarget = OBJECT_SELF);\r\n//Prints a string from a int\r\nstring GN_ITS(int sFutureString);\r\n//These debug commands are used for debugging shouts only\r\nvoid GN_PostShoutString(string sString = "",int x = 10,int y = 10,float fShow = 4.0);\r\n//These debug commands are used for debugging shouts o\r\nvoid GN_MyPrintShoutString(string sString);\r\n\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Attackers\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns the number objects attacking the object;\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 9, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_GetAttackers(object oTarget)\r\n{\r\n    int nCnt = 0;\r\n    object oAttacker = GetFirstAttacker(oTarget);\r\n    while(GetIsObjectValid(oAttacker))\r\n    {\r\n        nCnt++;\r\n        oAttacker = GetNextAttacker(oTarget);\r\n    }\r\n    return nCnt;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Am I a party member\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns member index +1 or false depending on\r\n    whether the object belongs in the PCs party.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 9, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_CheckNPCIsInParty(object oNPC)\r\n{\r\n    if(GetPartyMemberByIndex(0) == oNPC)\r\n    {\r\n        return 1;\r\n    }\r\n    else if(GetPartyMemberByIndex(1) == oNPC)\r\n    {\r\n        return 2;\r\n    }\r\n    else if(GetPartyMemberByIndex(2) == oNPC)\r\n    {\r\n        return 3;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: GetAttempted Spell or Attack Target State\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns true if the spell or attack target is\r\n    true\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 8, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_CheckAttemptedSpellAttackTarget()\r\n{\r\n    object oAttack = GetAttemptedAttackTarget();\r\n    object oSpell = GetAttemptedSpellTarget();\r\n    if(GetIsObjectValid(oAttack) || GetIsObjectValid(oSpell))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: GetIsFighting\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks if the passed object has an Attempted\r\n    Attack or Spell Target\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: July 16, 2002\r\n//:://////////////////////////////////////////////\r\nint GN_GetIsFighting(object oFighting)\r\n{\r\n    object oAttack = GetAttemptedAttackTarget();\r\n    object oSpellTarget = GetAttemptedSpellTarget();\r\n    object oAttacking = GetAttackTarget();\r\n    object oMove = GetAttemptedMovementTarget();\r\n\r\n    if(GetTag(OBJECT_SELF) == "DEBUG")\r\n    {\r\n        GN_ReturnDebugName(OBJECT_SELF);\r\n        GN_PostString("Attempted Attack Target = " + IntToString(GetIsObjectValid(oAttack)), 10,20, 4.0);\r\n        GN_PostString("Attempted Spell Target = " + IntToString(GetIsObjectValid(oSpellTarget)), 10,22, 4.0);\r\n        GN_PostString("Attack Target = " + IntToString(GetIsObjectValid(oAttacking)), 10,24, 4.0);\r\n        GN_PostString("Move Target = " + IntToString(GetIsObjectValid(oMove)), 10,26, 4.0);\r\n    }\r\n\r\n    if(GetIsObjectValid(oAttack) || GetIsObjectValid(oSpellTarget) || GetIsObjectValid(oAttacking) ||\r\n     (GetIsObjectValid(oMove) && GetIsEnemy(oMove)))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Compare Talents\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks the bits of Talent 1 against the bits\r\n    of Talent 2 to see if 1 is true.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 12, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_CompareTalents(int nTalent1, int nTalent2)\r\n{\r\n    if(nTalent1 & nTalent2)\r\n    {\r\n        //GN_MyPrintString("GENERIC DEBUG *************** Comparison of " + IntToString(nTalent1) + " / " + IntToString(nTalent2));\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Last Talent Code\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Determines the last talent that was used\r\n    by OBJECT_SELF\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 14, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_GetPreviousTalentCode()\r\n{\r\n    int nAction = GetLastAttackAction();\r\n    int nFeatSpell;\r\n    if(nAction == ACTION_CASTSPELL)\r\n    {\r\n        nFeatSpell = GetLastForcePowerUsed();\r\n        nFeatSpell = GN_GetSpellTalentCode(nFeatSpell);\r\n    }\r\n    else if(nAction == ACTION_ATTACKOBJECT)\r\n    {\r\n        nFeatSpell = GetLastCombatFeatUsed();\r\n        nFeatSpell = GN_GetFeatTalentCode(nFeatSpell);\r\n    }\r\n    return nFeatSpell;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Spell Talent Code\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns the talent code for a particular spell\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 14, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_GetSpellTalentCode(int nSpell)\r\n{\r\n    talent tSpell = TalentSpell(nSpell);\r\n    return GetCategoryFromTalent(tSpell);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Feat Talent Code\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns the talent code for a particular feat\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 14, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_GetFeatTalentCode(int nFeat)\r\n{\r\n    talent tFeat = TalentSpell(nFeat);\r\n    return GetCategoryFromTalent(tFeat);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Has Viable Talent\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Takes a talent code and searches for a viable\r\n    talent from the bunch\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 14, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_GetHasViableTalent(int nTalentCode)\r\n{\r\n    talent tTest = GetCreatureTalentBest(nTalentCode, 20);\r\n    if(GetIsTalentValid(tTest))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Exclusion Code\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns an exclusion code based on the Racial\r\n    Type of the target\r\n    0x00 = None\r\n    0x01 = Organic\r\n    0x02 = Droid\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 14, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_GetExclusionCode(object oTarget)\r\n{\r\n    int nRacial = GetRacialType(oTarget);\r\n    if(nRacial == RACIAL_TYPE_DROID)\r\n    {\r\n        //GN_MyPrintString("GENERIC DEBUG *************** Exclusion Used: 0x01");\r\n        return 0x01;\r\n    }\r\n    else if(nRacial == RACIAL_TYPE_HUMAN)\r\n    {\r\n        //GN_MyPrintString("GENERIC DEBUG *************** Exclusion Used: 0x02");\r\n        return 0x02;\r\n    }\r\n    //GN_MyPrintString("GENERIC DEBUG *************** Exclusion Used: 0x03");\r\n    return 0x03;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Jedi Combo\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns a proper Jedi Combo for Standard AI\r\n\r\nint SW_COMBO_RANGED_FEROCIOUS = 1;\r\nint SW_COMBO_RANGED_AGGRESSIVE = 2;\r\nint SW_COMBO_RANGED_DISCIPLINED = 3;\r\nint SW_COMBO_RANGED_CAUTIOUS = 4;\r\nint SW_COMBO_MELEE_FEROCIOUS = 5;\r\nint SW_COMBO_MELEE_AGGRESSIVE = 6;\r\nint SW_COMBO_MELEE_DISCIPLINED = 7;\r\nint SW_COMBO_MELEE_CAUTIOUS = 8;\r\nint SW_COMBO_BUFF_PARTY = 9;\r\nint SW_COMBO_BUFF_DEBILITATE = 10;\r\nint SW_COMBO_BUFF_DAMAGE = 11;\r\nint SW_COMBO_BUFF_DEBILITATE_DESTROY = 12;\r\nint SW_COMBO_SUPRESS_DEBILITATE_DESTROY = 13;\r\nint SW_COMBO_SITH_ATTACK = 14;\r\nint SW_COMBO_BUFF_ATTACK = 15;\r\nint SW_COMBO_SITH_CONFOUND = 16;\r\nint SW_COMBO_JEDI_SMITE = 17;\r\nint SW_COMBO_SITH_TAUNT = 18;\r\nint SW_COMBO_SITH_BLADE = 19;\r\nint SW_COMBO_SITH_CRUSH = 20;\r\nint SW_COMBO_JEDI_CRUSH = 21;\r\nint SW_COMBO_SITH_BRUTALIZE = 22;\r\nint SW_COMBO_SITH_DRAIN = 23;\r\nint SW_COMBO_SITH_ESCAPE = 24;\r\nint SW_COMBO_JEDI_BLITZ = 25;\r\nint SW_COMBO_SITH_SPIKE = 26;\r\nint SW_COMBO_SITH_SCYTHE = 27;\r\nint SW_COMBO_DROID_UTILITIES = 28;\r\nint SW_COMBO_DROID_UTILITIES_2 = 29;\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 28, 2002\r\n//:://////////////////////////////////////////////\r\nint GN_GetStandardJediCombo(int nBoss = FALSE)\r\n{\r\n    int nBool;\r\n    int nRand;\r\n    while(nBool == FALSE)\r\n    {\r\n        if(nBoss == FALSE)\r\n        {\r\n            nRand = Random(23)+1;\r\n\r\n            if(nRand == 1 || nRand == 2) {return SW_COMBO_MELEE_FEROCIOUS;}\r\n            else if(nRand == 3 || nRand == 4) {return SW_COMBO_MELEE_AGGRESSIVE;}\r\n            else if(nRand == 5 || nRand == 6) {return SW_COMBO_MELEE_DISCIPLINED;}\r\n            else if(nRand == 7 || nRand == 8 || nRand == 9) {return SW_COMBO_MELEE_CAUTIOUS;}\r\n            else if(nRand >= 10 || nRand <= 24)\r\n            {\r\n                nRand = nRand+3;\r\n            }\r\n        }\r\n        else\r\n        {\r\n            nRand = Random(15);\r\n            nRand = nRand + 13;\r\n        }\r\n\r\n        nBool = GN_GetIsComboValid(nRand);\r\n        //GN_MyPrintString("GENERIC DEBUG *************** Jedi Combo " + GN_FetchComboString(nRand) + " is " + IntToString(nBool));\r\n    }\r\n    return nRand;\r\n}\r\n//::///////////////////////////////////////////////\r\n//:: Get Droid Combo\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns a proper Droid Combo for Standard AI\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 28, 2002\r\n//:://////////////////////////////////////////////\r\nint GN_GetStandardDroidCombo(int nBoss = FALSE)\r\n{\r\n    //GN_MyPrintString("GENERIC DEBUG *************** Droid Combo Selection Started");\r\n    int nBool = FALSE;\r\n    int nRand = d6();\r\n    while(nBool == FALSE)\r\n    {\r\n        if(nRand == 1){nRand = SW_COMBO_RANGED_AGGRESSIVE;}\r\n        else if(nRand == 2){nRand = SW_COMBO_RANGED_CAUTIOUS;}\r\n        else if(nRand == 3){nRand = SW_COMBO_RANGED_DISCIPLINED;}\r\n        else if(nRand == 4){nRand = SW_COMBO_RANGED_FEROCIOUS;}\r\n        else if(nRand == 5 || nRand == 6)\r\n        {\r\n            if((IsObjectPartyMember(OBJECT_SELF) && GetNPCAIStyle(OBJECT_SELF) == NPC_AISTYLE_JEDI_SUPPORT) ||\r\n                !IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                if(nRand == 5)\r\n                {\r\n                    nRand = SW_COMBO_DROID_UTILITIES;\r\n                }\r\n                else if(nRand == 6)\r\n                {\r\n                    nRand = SW_COMBO_DROID_UTILITIES_2;\r\n                }\r\n            }\r\n            else\r\n            {\r\n                nRand = SW_COMBO_INVALID;\r\n            }\r\n        }\r\n\r\n        nBool = GN_GetIsComboValid(nRand);\r\n        //GN_MyPrintString("GENERIC DEBUG *************** Droid Combo Picked " + GN_FetchComboString(nRand) + " is " + IntToString(nBool));\r\n        if(nBool == FALSE)\r\n        {\r\n            nRand = d6();\r\n        }\r\n    }\r\n    //GN_MyPrintString("GENERIC DEBUG *************** Returning Combo Returned = " + GN_FetchComboString(nRand));\r\n    return nRand;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get NPC Combo\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns a proper NPC Combo for Standard AI\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 28, 2002\r\n//:://////////////////////////////////////////////\r\nint GN_GetStandardNPCCombo(int nBoss = FALSE)\r\n{\r\n    int nBool;\r\n    int nRand = d4();\r\n    if(GN_GetWeaponType() != 0)\r\n    {\r\n        while(nBool == FALSE)\r\n        {\r\n            if(GN_GetWeaponType() == 1)\r\n            {\r\n                if(nRand == 1){nRand = SW_COMBO_MELEE_AGGRESSIVE;}\r\n                else if(nRand == 2){nRand = SW_COMBO_MELEE_CAUTIOUS;}\r\n                else if(nRand == 3){nRand = SW_COMBO_MELEE_DISCIPLINED;}\r\n                else if(nRand == 4){nRand = SW_COMBO_MELEE_FEROCIOUS;}\r\n            }\r\n            else if(GN_GetWeaponType() == 2)\r\n            {\r\n                if(nRand == 1){nRand = SW_COMBO_RANGED_AGGRESSIVE;}\r\n                else if(nRand == 2){nRand = SW_COMBO_RANGED_CAUTIOUS;}\r\n                else if(nRand == 3){nRand = SW_COMBO_RANGED_DISCIPLINED;}\r\n                else if(nRand == 4){nRand = SW_COMBO_RANGED_FEROCIOUS;}\r\n            }\r\n            nBool = GN_GetIsComboValid(nRand);\r\n            if(nBool == FALSE)\r\n            {\r\n                nRand = d6();\r\n            }\r\n        }\r\n    }\r\n    else\r\n    {\r\n        nRand = 2;\r\n    }\r\n    //GN_MyPrintString("GENERIC DEBUG *************** NPC Combo " + GN_FetchComboString(nRand) + " is " + IntToString(nBool));\r\n    return nRand;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Next Talent In Combo\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Looks at the combo id and returns an ability\r\n    usable by the NPC which matches the next\r\n    feat in the combo.\r\n*/\r\n\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 27, 2002\r\n//:://////////////////////////////////////////////\r\ntalent GN_GetNextTalentInCombo(int nCombo)\r\n{\r\n    SetLocalBoolean(OBJECT_SELF, SW_FLAG_TARGET_FRIEND, FALSE);\r\n    int nLocal = GetLocalNumber(OBJECT_SELF, SW_NUMBER_COMBO_INDEX);\r\n    //GN_MyPrintString("GENERIC DEBUG *************** Combo Index " + IntToString(nLocal));\r\n    talent tUse, tInvalid;\r\n    int nID = -1;\r\n    int nFeat = FALSE;\r\n    int nBuff = FALSE;\r\n    //Sith Attack(PUSH, CHOKE, JUMP)\r\n    if(nCombo == SW_COMBO_SITH_ATTACK)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesChoke();\r\n        }\r\n        else if (nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesForcePush();\r\n        }\r\n        else\r\n        {\r\n            nID = GN_GetSeriesJump();\r\n        }\r\n    }\r\n    //Buff Attack(ARMOR, SPEED, FEAT)\r\n    else if(nCombo == SW_COMBO_BUFF_ATTACK)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesForceArmor();\r\n            nBuff = TRUE;\r\n        }\r\n        else if (nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesSpeed();\r\n            nBuff = TRUE;\r\n        }\r\n        else\r\n        {\r\n            nID = GN_GetSeriesMeleeFeat();\r\n            nFeat = TRUE;\r\n        }\r\n    }\r\n    //Sith Confound (FEAR, FEAT, FEAT)\r\n    else if(nCombo == SW_COMBO_SITH_CONFOUND)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesLightning();\r\n        }\r\n        else if (nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesMeleeFeat();\r\n            nFeat = TRUE;\r\n        }\r\n        else\r\n        {\r\n            nID = GN_GetSeriesMeleeFeat();\r\n            nFeat = TRUE;\r\n        }\r\n    }\r\n    //Jedi Smite (HOLD, FEAT, FEAT)\r\n    else if(nCombo == SW_COMBO_JEDI_SMITE)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesHold();\r\n        }\r\n        else if (nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesMeleeFeat();\r\n            nFeat = TRUE;\r\n        }\r\n        else\r\n        {\r\n            nID = GN_GetSeriesMeleeFeat();\r\n            nFeat = TRUE;\r\n        }\r\n    }\r\n    //Sith Taunt (CHOKE, POISON, FEAT)\r\n    else if(nCombo == SW_COMBO_SITH_TAUNT)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesChoke();\r\n        }\r\n        else if (nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesAfflict();\r\n        }\r\n        else\r\n        {\r\n            nID = GN_GetSeriesMeleeFeat();\r\n            nFeat = TRUE;\r\n        }\r\n    }\r\n    //Sith Blade (SLOW, PUSH, THROW)\r\n    else if(nCombo == SW_COMBO_SITH_BLADE)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesAfflict();\r\n        }\r\n        else if (nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesForcePush();\r\n        }\r\n        else\r\n        {\r\n            nID = GN_GetSeriesSaberThrow();\r\n        }\r\n    }\r\n    //Sith Crush (PUSH, SHOCK, JUMP)\r\n    else if(nCombo == SW_COMBO_SITH_CRUSH)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesLightning();\r\n        }\r\n        else if (nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesForcePush();\r\n        }\r\n        else\r\n        {\r\n            nID = GN_GetSeriesJump();\r\n        }\r\n    }\r\n    //Jedi Crush (HOLD, THROW, JUMP)\r\n    else if(nCombo == SW_COMBO_JEDI_CRUSH)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesHold();\r\n        }\r\n        else if (nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesForcePush();\r\n        }\r\n        else\r\n        {\r\n            nID = GN_GetSeriesJump();\r\n        }\r\n    }\r\n    //Sith Brutalize (CHOKE, DRAIN, PUSH)\r\n    else if(nCombo == SW_COMBO_SITH_BRUTALIZE)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesChoke();\r\n        }\r\n        else if (nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesDrainLife();\r\n        }\r\n        else\r\n        {\r\n            nID = GN_GetSeriesForcePush();\r\n        }\r\n    }\r\n    //Sith Drain (FEAT, DRAIN, FEAT)\r\n    else if(nCombo == SW_COMBO_SITH_DRAIN)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesMeleeFeat();\r\n            nFeat = TRUE;\r\n        }\r\n        else if (nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesDrainLife();\r\n        }\r\n        else\r\n        {\r\n            nID = GN_GetSeriesMeleeFeat();\r\n            nFeat = TRUE;\r\n        }\r\n    }\r\n    //Sith Escape (DRAIN, PUSH, THROW)\r\n    else if(nCombo == SW_COMBO_SITH_ESCAPE)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesDrainLife();\r\n        }\r\n        else if (nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesForcePush();\r\n        }\r\n        else\r\n        {\r\n            nID = GN_GetSeriesSaberThrow();\r\n        }\r\n    }\r\n    //Jedi Blitz (FEAT, FEAT, PUSH)\r\n    else if(nCombo == SW_COMBO_JEDI_BLITZ)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesMeleeFeat();\r\n            nFeat = TRUE;\r\n        }\r\n        else if (nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesMeleeFeat();\r\n            nFeat = TRUE;\r\n        }\r\n        else\r\n        {\r\n            nID = GN_GetSeriesForcePush();\r\n        }\r\n    }\r\n    //Sith Spike (PUSH, SLOW, FEAT)\r\n    else if(nCombo == SW_COMBO_SITH_SPIKE)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesAfflict();\r\n        }\r\n        else if (nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesMeleeFeat();\r\n            nFeat = TRUE;\r\n        }\r\n        else\r\n        {\r\n            nID = GN_GetSeriesForcePush();\r\n        }\r\n    }\r\n    //Sith Scythe (DRAIN, FEAR, FEAT)\r\n    else if(nCombo == SW_COMBO_SITH_SCYTHE)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesDrainLife();\r\n        }\r\n        else if (nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesBreach();\r\n        }\r\n        else\r\n        {\r\n            nID = GN_GetSeriesMeleeFeat();\r\n            nFeat = TRUE;\r\n        }\r\n    }\r\n    //Melee Ferocious (USE 3 FEATS)\r\n    else if(nCombo == SW_COMBO_MELEE_FEROCIOUS)\r\n    {\r\n        nID = GN_GetSeriesMeleeFeat();\r\n        nFeat = TRUE;\r\n    }\r\n    //Melee Aggressive (USE 2 FEATS)\r\n    else if(nCombo == SW_COMBO_MELEE_AGGRESSIVE)\r\n    {\r\n        if(nLocal == 1 || nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesMeleeFeat();\r\n            nFeat = TRUE;\r\n        }\r\n        else\r\n        {\r\n            //GN_MyPrintString("GENERIC DEBUG *************** Melee/Ranged Breather");\r\n        }\r\n    }\r\n    //Melee Discipline (USE 1 FEAT)\r\n    else if(nCombo == SW_COMBO_MELEE_DISCIPLINED)\r\n    {\r\n        if(nLocal == 1 || nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesMeleeFeat();\r\n            nFeat = TRUE;\r\n        }\r\n        else\r\n        {\r\n            //GN_MyPrintString("GENERIC DEBUG *************** Melee/Ranged Breather");\r\n        }\r\n    }\r\n    else if(nCombo == SW_COMBO_MELEE_CAUTIOUS || nCombo == SW_COMBO_RANGED_CAUTIOUS)\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Melee/Ranged Breather");\r\n    }\r\n    //Melee Cautious (USE NO FEATS) //This does not require a check. It will return an invalid talent\r\n    //Ranged Cautious (USE NO FEATS) //This does not require a check. It will return an invalid talent\r\n    //Ranged Ferocious (USE 3 FEATS)\r\n    else if(nCombo == SW_COMBO_RANGED_FEROCIOUS)\r\n    {\r\n        nID = GN_GetSeriesRangedFeat();\r\n        nFeat = TRUE;\r\n    }\r\n    //Ranged Aggressive (USE 2 FEATS)\r\n    else if(nCombo == SW_COMBO_RANGED_AGGRESSIVE)\r\n    {\r\n        if(nLocal == 1 || nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesRangedFeat();\r\n            nFeat = TRUE;\r\n        }\r\n        else\r\n        {\r\n            //GN_MyPrintString("GENERIC DEBUG *************** Melee/Ranged Breather");\r\n        }\r\n    }\r\n    //Ranged Discipline (USE 1 FEAT)\r\n    else if(nCombo == SW_COMBO_RANGED_DISCIPLINED)\r\n    {\r\n        if(nLocal == 1 || nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesRangedFeat();\r\n            nFeat = TRUE;\r\n        }\r\n        else\r\n        {\r\n            //GN_MyPrintString("GENERIC DEBUG *************** Melee/Ranged Breather");\r\n        }\r\n    }\r\n    //Buff Party\r\n    else if(nCombo == SW_COMBO_BUFF_PARTY)\r\n    {\r\n        tUse = GetCreatureTalentRandom(0xf8ff);\r\n    }\r\n    //Buff & Debilitate (BUFF & 2 DEBILITATE ENEMY)\r\n    else if(nCombo == SW_COMBO_BUFF_DEBILITATE)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            tUse = GetCreatureTalentRandom(0xf8ff);\r\n        }\r\n        else\r\n        {\r\n            tUse = GetCreatureTalentRandom(0xf2ff);\r\n        }\r\n    }\r\n    //Buff & Damage (BUFF  & 2 DAMAGE ENEMY)\r\n    else if(nCombo == SW_COMBO_BUFF_DAMAGE)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            tUse = GetCreatureTalentRandom(0xf8ff);\r\n        }\r\n        else\r\n        {\r\n            tUse = GetCreatureTalentRandom(0xf1ff);\r\n        }\r\n    }\r\n    //Buff, Debilitate & Destroy (1 BUFF, 1 DEBILITATE, 1 DESTROY)\r\n    else if(nCombo == SW_COMBO_BUFF_DEBILITATE_DESTROY)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            tUse = GetCreatureTalentRandom(0xf8ff);\r\n        }\r\n        if(nLocal == 2)\r\n        {\r\n            tUse = GetCreatureTalentRandom(0xf2ff);\r\n        }\r\n        if(nLocal == 3)\r\n        {\r\n            tUse = GetCreatureTalentRandom(0x1101);\r\n        }\r\n    }\r\n    //Supress, Debilitate & Destroy (1 Supress, 1 DEBILITATE, 1 DESTROY)\r\n    else if(nCombo == SW_COMBO_SUPRESS_DEBILITATE_DESTROY)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            tUse = GetCreatureTalentRandom(0xf1ff);\r\n        }\r\n        if(nLocal == 2)\r\n        {\r\n            tUse = GetCreatureTalentRandom(0xf2ff);\r\n        }\r\n        if(nLocal == 3)\r\n        {\r\n            tUse = GetCreatureTalentRandom(0x1101);\r\n        }\r\n    }\r\n    else if(nCombo == SW_COMBO_DROID_UTILITIES)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            nID = GN_GetSeriesRangedFeat();\r\n            nFeat = TRUE;\r\n        }\r\n        if(nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesRangedFeat();\r\n            nFeat = TRUE;\r\n        }\r\n        if(nLocal == 3)\r\n        {\r\n            tUse = GetCreatureTalentRandom(0x8000);\r\n        }\r\n    }\r\n    else if(nCombo == SW_COMBO_DROID_UTILITIES_2)\r\n    {\r\n        if(nLocal == 1)\r\n        {\r\n            tUse = GetCreatureTalentRandom(0x8000);\r\n        }\r\n        if(nLocal == 2)\r\n        {\r\n            nID = GN_GetSeriesRangedFeat();\r\n            nFeat = TRUE;\r\n        }\r\n        if(nLocal == 3)\r\n        {\r\n            tUse = GetCreatureTalentRandom(0x8000);\r\n        }\r\n    }\r\n\r\n    //Increments the Local number so that the progression through the Combo continues even if the talent fails\r\n    nLocal++;\r\n    SetLocalNumber(OBJECT_SELF, SW_NUMBER_COMBO_INDEX, nLocal);\r\n    if(!GetIsTalentValid(tUse) || !GetCreatureHasTalent(tUse))\r\n    {\r\n        //GN_MyPrintString("GENERIC DEBUG *************** ID = " + IntToString(nID));\r\n        if(nID != -1 && nFeat == FALSE)\r\n        {\r\n            //GN_MyPrintString("GENERIC DEBUG *************** Spell ID = " + IntToString(nID));\r\n            tUse = TalentSpell(nID);\r\n        }\r\n        else if(nID != -1 && nFeat == TRUE)\r\n        {\r\n            //GN_MyPrintString("GENERIC DEBUG *************** Feat ID = " + IntToString(nID));\r\n            tUse = TalentFeat(nID);\r\n        }\r\n    }\r\n    else\r\n    {\r\n        nID = GetIdFromTalent(tUse);\r\n        //GN_MyPrintString("GENERIC DEBUG *************** Preselected ID = " + IntToString(nID));\r\n    }\r\n    //Use GetCreatureHasTalent here to make the talent is currently usable - ie enough force points.\r\n    //Currently it terminates the script, so do not use it.\r\n    if(GetIsTalentValid(tUse) && GetCreatureHasTalent(tUse))\r\n    {\r\n        //GN_MyPrintString("GENERIC DEBUG *************** Returning Valid Talent");\r\n        return tUse;\r\n    }\r\n    //GN_MyPrintString("GENERIC DEBUG *************** Returning Invalid Talent");\r\n    return tInvalid;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Force Power Get Functions\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns an ability based.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 27, 2002\r\n//:://////////////////////////////////////////////\r\nint GN_GetSeriesForcePush()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_FORCE_WAVE))\r\n    {\r\n        return FORCE_POWER_FORCE_WAVE;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_FORCE_WHIRLWIND))\r\n    {\r\n        return FORCE_POWER_FORCE_WHIRLWIND;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_FORCE_PUSH))\r\n    {\r\n        return FORCE_POWER_FORCE_PUSH;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesForceArmor()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_FORCE_ARMOR))\r\n    {\r\n        return FORCE_POWER_FORCE_ARMOR;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_FORCE_SHIELD))\r\n    {\r\n        return FORCE_POWER_FORCE_SHIELD;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_FORCE_AURA))\r\n    {\r\n        return FORCE_POWER_FORCE_AURA;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesFear()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_INSANITY))\r\n    {\r\n        return FORCE_POWER_INSANITY;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_HORROR))\r\n    {\r\n        return FORCE_POWER_HORROR;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_FEAR))\r\n    {\r\n        return FORCE_POWER_FEAR;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesHold()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_SLEEP))\r\n    {\r\n        return FORCE_POWER_SLEEP;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_HOLD))\r\n    {\r\n        return FORCE_POWER_HOLD;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_STUN))\r\n    {\r\n        return FORCE_POWER_STUN;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesAfflict()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_PLAGUE))\r\n    {\r\n        return FORCE_POWER_PLAGUE;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_AFFLICTION))\r\n    {\r\n        return FORCE_POWER_AFFLICTION;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_SLOW))\r\n    {\r\n        return FORCE_POWER_SLOW;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesSaberThrow()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_LIGHT_SABER_THROW_ADVANCED))\r\n    {\r\n        return FORCE_POWER_LIGHT_SABER_THROW_ADVANCED;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_LIGHT_SABER_THROW))\r\n    {\r\n        return FORCE_POWER_LIGHT_SABER_THROW;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesLightning()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_FORCE_STORM))\r\n    {\r\n        return FORCE_POWER_FORCE_STORM;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_LIGHTNING))\r\n    {\r\n        return FORCE_POWER_LIGHTNING;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_SHOCK))\r\n    {\r\n        return FORCE_POWER_SHOCK;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesJump()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_FORCE_JUMP_ADVANCED))\r\n    {\r\n        return FORCE_POWER_FORCE_JUMP_ADVANCED;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_FORCE_JUMP))\r\n    {\r\n        return FORCE_POWER_FORCE_JUMP;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesChoke()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_KILL))\r\n    {\r\n        return FORCE_POWER_KILL;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_CHOKE))\r\n    {\r\n        return FORCE_POWER_CHOKE;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_WOUND))\r\n    {\r\n        return FORCE_POWER_WOUND;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesDrainLife()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_DEATH_FIELD))\r\n    {\r\n        return FORCE_POWER_DEATH_FIELD;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_DRAIN_LIFE))\r\n    {\r\n        return FORCE_POWER_DRAIN_LIFE;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesSpeed()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_SPEED_MASTERY))\r\n    {\r\n        return FORCE_POWER_SPEED_MASTERY;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_KNIGHT_SPEED))\r\n    {\r\n        return FORCE_POWER_KNIGHT_SPEED;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_SPEED_BURST))\r\n    {\r\n        return FORCE_POWER_SPEED_BURST;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesMeleeFeat()\r\n{\r\n    talent tUse = GetCreatureTalentBest(0x1104, 20);\r\n    if(GetIsTalentValid(tUse) && GetCreatureHasTalent(tUse))\r\n    {\r\n        int nID = GetIdFromTalent(tUse);\r\n        return nID;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesRangedFeat()\r\n{\r\n    talent tUse = GetCreatureTalentBest(0x1181, 20);\r\n    if(GetIsTalentValid(tUse) && GetCreatureHasTalent(tUse))\r\n    {\r\n        int nID = GetIdFromTalent(tUse);\r\n        return nID;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesMind()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_MIND_MASTERY))\r\n    {\r\n        return FORCE_POWER_MIND_MASTERY;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_KNIGHT_MIND))\r\n    {\r\n        return FORCE_POWER_KNIGHT_MIND;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_FORCE_MIND))\r\n    {\r\n        return FORCE_POWER_FORCE_MIND;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesResist()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_RESIST_COLD_HEAT_ENERGY))\r\n    {\r\n        return FORCE_POWER_RESIST_COLD_HEAT_ENERGY;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_RESIST_POISON_DISEASE_SONIC))\r\n    {\r\n        return FORCE_POWER_RESIST_POISON_DISEASE_SONIC;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesForceImmunity()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_FORCE_IMMUNITY))\r\n    {\r\n        return FORCE_POWER_FORCE_IMMUNITY;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_RESIST_FORCE))\r\n    {\r\n        return FORCE_POWER_RESIST_FORCE;\r\n    }\r\n    return -1;\r\n}\r\nint GN_GetSeriesBreach()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_FORCE_BREACH))\r\n    {\r\n        return FORCE_POWER_FORCE_BREACH;\r\n    }\r\n    else if(GetHasSpell(FORCE_POWER_SUPRESS_FORCE))\r\n    {\r\n        return FORCE_POWER_SUPRESS_FORCE;\r\n    }\r\n    return -1;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Force Power Series Checks\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks if a Jedi has 1 in a force power series\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 27, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_CheckSeriesForcePush()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_FORCE_PUSH) || GetHasSpell(FORCE_POWER_FORCE_WHIRLWIND) || GetHasSpell(FORCE_POWER_FORCE_WAVE))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\nint GN_CheckSeriesArmor()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_FORCE_ARMOR) || GetHasSpell(FORCE_POWER_FORCE_SHIELD) || GetHasSpell(FORCE_POWER_FORCE_AURA))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\nint GN_CheckSeriesFear()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_FEAR) || GetHasSpell(FORCE_POWER_HORROR) || GetHasSpell(FORCE_POWER_INSANITY))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\nint GN_CheckSeriesHold()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_STUN) || GetHasSpell(FORCE_POWER_HOLD) || GetHasSpell(FORCE_POWER_SLEEP))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\nint GN_CheckSeriesAfflict()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_SLOW) || GetHasSpell(FORCE_POWER_AFFLICTION) || GetHasSpell(FORCE_POWER_PLAGUE))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\nint GN_CheckSeriesSaberThrow()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_LIGHT_SABER_THROW) || GetHasSpell(FORCE_POWER_LIGHT_SABER_THROW_ADVANCED))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\nint GN_CheckSeriesLightning()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_SHOCK) || GetHasSpell(FORCE_POWER_LIGHTNING) || GetHasSpell(FORCE_POWER_FORCE_STORM))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\nint GN_CheckSeriesJump()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_FORCE_JUMP) || GetHasSpell(FORCE_POWER_FORCE_JUMP_ADVANCED))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\nint GN_CheckSeriesChoke()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_CHOKE) || GetHasSpell(FORCE_POWER_WOUND) || GetHasSpell(FORCE_POWER_KILL))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\nint GN_CheckSeriesDrainLife()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_DRAIN_LIFE) || GetHasSpell(FORCE_POWER_DEATH_FIELD))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\nint GN_CheckSeriesSpeed()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_SPEED_BURST) || GetHasSpell(FORCE_POWER_SPEED_MASTERY) || GetHasSpell(FORCE_POWER_KNIGHT_SPEED))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\nint GN_CheckSeriesMind()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_MIND_MASTERY) || GetHasSpell(FORCE_POWER_KNIGHT_MIND) || GetHasSpell(FORCE_POWER_FORCE_MIND))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\nint GN_CheckSeriesResist()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_RESIST_COLD_HEAT_ENERGY) || GetHasSpell(FORCE_POWER_RESIST_POISON_DISEASE_SONIC))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\nint GN_CheckSeriesForceImmunity()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_RESIST_FORCE) || GetHasSpell(FORCE_POWER_FORCE_IMMUNITY))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\nint GN_CheckSeriesBreach()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_SUPRESS_FORCE) || GetHasSpell(FORCE_POWER_FORCE_BREACH))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\nint GN_CheckSeriesDroidUtilities()\r\n{\r\n    talent tUse = GetCreatureTalentRandom(0x8000);\r\n    /*\r\n    if(GetHasSpell(116) || GetHasSpell(117) || GetHasSpell(118) ||\r\n       GetHasSpell(119) || GetHasSpell(120) || GetHasSpell(121) ||\r\n       GetHasSpell(121) || GetHasSpell(122) || GetHasSpell(123) ||\r\n       GetHasSpell(124) || GetHasSpell(125))\r\n    */\r\n    if(GetIsTalentValid(tUse))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Is Combo Valid\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Gets a combo constant and determines if the\r\n    NPC can perform the stated combo\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 27, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_GetIsComboValid(int nComboType)\r\n{\r\n    //P.W (May 27, 2003) - Made allowances for an invalid effect to be passed in.\r\n    if(nComboType == SW_COMBO_INVALID)\r\n    {\r\n        return FALSE;\r\n    }\r\n\r\n    talent tTest, tTest2;\r\n    if(nComboType == SW_COMBO_MELEE_FEROCIOUS ||\r\n            nComboType == SW_COMBO_MELEE_AGGRESSIVE ||\r\n            nComboType == SW_COMBO_MELEE_DISCIPLINED)\r\n    {\r\n        tTest = GetCreatureTalentRandom(0x1104); //Only Melee feats use this code\r\n        if(GetIsTalentValid(tTest) && GetCreatureHasTalent(tTest))\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_RANGED_CAUTIOUS)\r\n    {\r\n        return TRUE;\r\n    }\r\n    else if(nComboType == SW_COMBO_RANGED_FEROCIOUS ||\r\n       nComboType == SW_COMBO_RANGED_AGGRESSIVE ||\r\n       nComboType == SW_COMBO_RANGED_DISCIPLINED)\r\n    {\r\n        //These are the only ranged feats in the game and therefore it is better to use a feat constant not a talent code\r\n        //given that 0x1101 is also used by some force powers.\r\n        if(GetHasFeat(FEAT_SNIPER_SHOT) || GetHasFeat(FEAT_IMPROVED_SNIPER_SHOT) || GetHasFeat(FEAT_MASTER_SNIPER_SHOT) ||\r\n           GetHasFeat(FEAT_POWER_BLAST) || GetHasFeat(FEAT_IMPROVED_POWER_BLAST) || GetHasFeat(82) || //Master Power Blast\r\n           GetHasFeat(FEAT_RAPID_SHOT) || GetHasFeat(FEAT_MULTI_SHOT) || GetHasFeat(92))//92 = IMRPOVED_RAPID_SHOT\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_MELEE_CAUTIOUS)\r\n    {\r\n        return TRUE;\r\n    }\r\n    else if(nComboType == SW_COMBO_BUFF_PARTY)\r\n    {\r\n        tTest = GetCreatureTalentRandom(0xf8ff);\r\n        if(GetIsTalentValid(tTest) && GetCreatureHasTalent(tTest))\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_BUFF_DEBILITATE)\r\n    {\r\n        tTest = GetCreatureTalentRandom(0xf8ff);\r\n        tTest2 = GetCreatureTalentRandom(0xf2ff);\r\n        if(GetIsTalentValid(tTest) && GetIsTalentValid(tTest2)\r\n           && GetCreatureHasTalent(tTest)\r\n           && GetCreatureHasTalent(tTest2))\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_BUFF_DAMAGE)\r\n    {\r\n        tTest = GetCreatureTalentRandom(0xf8ff);\r\n        if(GetIsTalentValid(tTest) && GN_GetHasDamagingForcePower())\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_BUFF_DEBILITATE_DESTROY)\r\n    {\r\n        tTest = GetCreatureTalentRandom(0xf8ff);\r\n        tTest2 = GetCreatureTalentRandom(0xf2ff);\r\n        if(GetIsTalentValid(tTest) && GetIsTalentValid(tTest2) && GN_GetHasDamagingForcePower())\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_SUPRESS_DEBILITATE_DESTROY)\r\n    {\r\n        tTest = GetCreatureTalentRandom(0xff2f);\r\n        tTest2 = GetCreatureTalentRandom(0xf2ff);\r\n        if(GetIsTalentValid(tTest) && GetIsTalentValid(tTest2) && GN_GetHasDamagingForcePower())\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_SITH_ATTACK)\r\n    {\r\n        if(GN_CheckSeriesForcePush() && GN_CheckSeriesChoke() && GN_CheckSeriesJump())\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_BUFF_ATTACK)\r\n    {\r\n        tTest = GetCreatureTalentRandom(0x1104);\r\n        if(GN_CheckSeriesArmor() && GN_CheckSeriesSpeed() && GetIsTalentValid(tTest))\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_SITH_CONFOUND)\r\n    {\r\n        tTest = GetCreatureTalentRandom(0x1104);\r\n        if(GN_CheckSeriesLightning() && GetIsTalentValid(tTest))\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_JEDI_SMITE)\r\n    {\r\n        tTest = GetCreatureTalentRandom(0x1104);\r\n        if(GN_CheckSeriesHold() && GetIsTalentValid(tTest))\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_SITH_TAUNT)\r\n    {\r\n        tTest = GetCreatureTalentRandom(0x1104);\r\n        if(GN_CheckSeriesChoke() && GN_CheckSeriesAfflict() && GetIsTalentValid(tTest))\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_SITH_BLADE)\r\n    {\r\n        if(GN_CheckSeriesAfflict() && GN_CheckSeriesForcePush() && GN_CheckSeriesSaberThrow())\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_SITH_CRUSH)\r\n    {\r\n        if(GN_CheckSeriesLightning() && GN_CheckSeriesForcePush() && GN_CheckSeriesJump())\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_JEDI_CRUSH)\r\n    {\r\n        if(GN_CheckSeriesHold() && GN_CheckSeriesForcePush() && GN_CheckSeriesJump())\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_JEDI_CRUSH)\r\n    {\r\n        if(GN_CheckSeriesChoke() && GN_CheckSeriesDrainLife() && GN_CheckSeriesForcePush())\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_SITH_DRAIN)\r\n    {\r\n        tTest = GetCreatureTalentRandom(0x1104);\r\n        if(GN_CheckSeriesDrainLife() && GetIsTalentValid(tTest))\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_SITH_ESCAPE)\r\n    {\r\n        if(GN_CheckSeriesDrainLife() && GN_CheckSeriesForcePush() && GN_CheckSeriesSaberThrow())\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_JEDI_BLITZ)\r\n    {\r\n        tTest = GetCreatureTalentRandom(0x1104);\r\n        if(GN_CheckSeriesForcePush() && GetIsTalentValid(tTest))\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_SITH_SPIKE)\r\n    {\r\n        tTest = GetCreatureTalentRandom(0x1104);\r\n        if(GN_CheckSeriesForcePush() && GN_CheckSeriesAfflict() && GetIsTalentValid(tTest))\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_SITH_SCYTHE)\r\n    {\r\n        tTest = GetCreatureTalentRandom(0x1104);\r\n        if(GN_CheckSeriesDrainLife() && GN_CheckSeriesBreach() && GetIsTalentValid(tTest))\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    else if(nComboType == SW_COMBO_DROID_UTILITIES || nComboType == SW_COMBO_DROID_UTILITIES_2)\r\n    {\r\n        object oItem1 = GetItemInSlot(INVENTORY_SLOT_LEFTARM);\r\n        object oItem2 = GetItemInSlot(INVENTORY_SLOT_RIGHTARM);\r\n\r\n        GN_MyPrintString("GENERIC DEBUG *************** Droid Items = " + GN_ReturnDebugName(oItem1) + " / " + GN_ReturnDebugName(oItem2));\r\n\r\n        if(GN_CheckSeriesDroidUtilities())\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Droid Utility Check is TRUE");\r\n            return TRUE;\r\n        }\r\n        GN_MyPrintString("GENERIC DEBUG *************** Droid Utility Check is FALSE");\r\n    }\r\n    return FALSE;\r\n}\r\n\r\nint GN_GetHasDamagingForcePower()\r\n{\r\n    if(GetHasSpell(FORCE_POWER_CHOKE) ||\r\n       GetHasSpell(FORCE_POWER_DEATH_FIELD) ||\r\n       GetHasSpell(FORCE_POWER_DRAIN_LIFE) ||\r\n       GetHasSpell(FORCE_POWER_DROID_DESTROY) ||\r\n       GetHasSpell(FORCE_POWER_DROID_DISABLE) ||\r\n       GetHasSpell(FORCE_POWER_FORCE_PUSH) ||\r\n       GetHasSpell(FORCE_POWER_FORCE_STORM) ||\r\n       GetHasSpell(FORCE_POWER_FORCE_WAVE) ||\r\n       GetHasSpell(FORCE_POWER_FORCE_WHIRLWIND) ||\r\n       GetHasSpell(FORCE_POWER_KILL) ||\r\n       GetHasSpell(FORCE_POWER_LIGHT_SABER_THROW) ||\r\n       GetHasSpell(FORCE_POWER_LIGHT_SABER_THROW_ADVANCED) ||\r\n       GetHasSpell(FORCE_POWER_LIGHTNING) ||\r\n       GetHasSpell(FORCE_POWER_SHOCK) ||\r\n       GetHasSpell(FORCE_POWER_WOUND))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Weapon Type\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Return 1 if the object is a Melee Weapon and\r\n    2 if the weapon is a Ranged Weapon\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Dec 2, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_GetWeaponType(object oTarget = OBJECT_SELF)\r\n{\r\n    object oItem = GetItemInSlot(INVENTORY_SLOT_RIGHTWEAPON,oTarget);\r\n    //GN_MyPrintString("GENERIC DEBUG *************** Valid Weapon = " + GN_ITS(GetIsObjectValid(oItem)));\r\n    if(GetIsObjectValid(oItem))\r\n    {\r\n        if( GetBaseItemType(oItem) == BASE_ITEM_BLASTER_CARBINE ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_BLASTER_PISTOL ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_BLASTER_RIFLE ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_BOWCASTER ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_DISRUPTER_PISTOL ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_DISRUPTER_RIFLE ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_HEAVY_BLASTER ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_HEAVY_REPEATING_BLASTER ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_HOLD_OUT_BLASTER ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_ION_BLASTER ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_ION_RIFLE ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_REPEATING_BLASTER ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_SONIC_PISTOL ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_SONIC_RIFLE ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_SONIC_PISTOL )\r\n        {\r\n            //GN_MyPrintString("GENERIC DEBUG *************** Ranged Weapon Equipped");\r\n            return 2;\r\n        }\r\n        else if( GetBaseItemType(oItem) == BASE_ITEM_DOUBLE_BLADED_LIGHTSABER ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_DOUBLE_BLADED_SWORD ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_GAMMOREAN_BATTLEAXE ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_GHAFFI_STICK ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_LIGHTSABER ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_LONG_SWORD ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_QUARTER_STAFF ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_SHORT_LIGHTSABER ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_SHORT_SWORD ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_STUN_BATON ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_VIBRO_BLADE ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_VIBRO_DOUBLE_BLADE ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_VIBRO_SWORD ||\r\n           GetBaseItemType(oItem) == BASE_ITEM_WOOKIE_WARBLADE )\r\n        {\r\n            //GN_MyPrintString("GENERIC DEBUG *************** Melee Weapon Equipped");\r\n            return 1;\r\n        }\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** Return No Weapon Type");\r\n    return 0;\r\n}\r\n\r\n//\r\n//::///////////////////////////////////////////////\r\n//:: Equip Appropriate Weapon\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Gets the NPC to eqyuip a melee = 1 or\r\n    ranged = 2 weapon.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Jan 13, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_EquipAppropriateWeapon()\r\n{\r\n    object oItem;\r\n    if(GetIsObjectValid(GetAttackTarget()) &&\r\n       GetDistanceBetween(GetAttackTarget(), OBJECT_SELF) <= 3.0 &&\r\n       GN_GetWeaponType() != 1 &&\r\n       GetRacialType(OBJECT_SELF) == RACIAL_TYPE_HUMAN &&\r\n       !IsObjectPartyMember(OBJECT_SELF))\r\n    {\r\n        oItem = GetFirstItemInInventory();\r\n        while(GetIsObjectValid(oItem))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Checking Melee Weapon");\r\n            if( GetBaseItemType(oItem) == BASE_ITEM_DOUBLE_BLADED_LIGHTSABER ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_DOUBLE_BLADED_SWORD ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_GAMMOREAN_BATTLEAXE ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_GHAFFI_STICK ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_LIGHTSABER ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_LONG_SWORD ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_QUARTER_STAFF ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_SHORT_LIGHTSABER ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_SHORT_SWORD ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_STUN_BATON ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_VIBRO_BLADE ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_VIBRO_DOUBLE_BLADE ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_VIBRO_SWORD ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_WOOKIE_WARBLADE )\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** Equipping Melee Weapon");\r\n                //ActionEquipItem(oItem, INVENTORY_SLOT_RIGHTWEAPON, TRUE);\r\n                ActionEquipMostDamagingMelee();\r\n                return TRUE;\r\n            }\r\n            else\r\n            {\r\n              oItem = GetNextItemInInventory();\r\n            }\r\n        }\r\n    }\r\n    else if(GN_GetWeaponType() != 2 &&\r\n            GetLevelByClass(CLASS_TYPE_JEDICONSULAR) == 0 &&\r\n            GetLevelByClass(CLASS_TYPE_JEDIGUARDIAN) == 0 &&\r\n            GetLevelByClass(CLASS_TYPE_JEDISENTINEL) == 0 &&\r\n            //GetIsObjectValid(GetAttackTarget()) &&\r\n            GetDistanceBetween(GetAttemptedAttackTarget(), OBJECT_SELF) > 3.0 &&\r\n            !IsObjectPartyMember(OBJECT_SELF))\r\n    {\r\n        oItem = GetFirstItemInInventory();\r\n        while(GetIsObjectValid(oItem))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Checking Ranged Weapon");\r\n            if( GetBaseItemType(oItem) == BASE_ITEM_BLASTER_CARBINE ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_BLASTER_PISTOL ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_BLASTER_RIFLE ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_BOWCASTER ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_DISRUPTER_PISTOL ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_DISRUPTER_RIFLE ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_HEAVY_BLASTER ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_HEAVY_REPEATING_BLASTER ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_HOLD_OUT_BLASTER ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_ION_BLASTER ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_ION_RIFLE ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_REPEATING_BLASTER ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_SONIC_PISTOL ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_SONIC_RIFLE ||\r\n               GetBaseItemType(oItem) == BASE_ITEM_SONIC_PISTOL )\r\n              {\r\n                GN_MyPrintString("GENERIC DEBUG *************** Equipping Ranged Weapon");\r\n                //ActionEquipItem(oItem, INVENTORY_SLOT_RIGHTWEAPON, TRUE);\r\n                ActionEquipMostDamagingRanged();\r\n                return TRUE;\r\n              }\r\n              else\r\n              {\r\n                oItem = GetNextItemInInventory();\r\n              }\r\n         }\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** Should not currently change weapons");\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Check Friendly Fire on Target\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Takes a target object and a radius and\r\n    returns how many friendly targets\r\n    are in that zone.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Jan 17, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_CheckFriendlyFireOnTarget(object oTarget, float fDistance = 4.0)\r\n{\r\n    int nCnt, nHD, nMyHD;\r\n    nMyHD = GetHitDice(OBJECT_SELF);\r\n    object oCheck = GetFirstObjectInShape(SHAPE_SPHERE, fDistance, GetLocation(oTarget));\r\n    while(GetIsObjectValid(oCheck))\r\n    {\r\n        //P.W.(May 20, 2003) - Put a dead check here for whether the person being checked is dead.\r\n        if(GetIsFriend(oCheck) && !GetIsDead(oCheck))\r\n        {\r\n            nCnt++;\r\n        }\r\n        oCheck = GetNextObjectInShape(SHAPE_SPHERE, fDistance, GetLocation(oTarget));\r\n    }\r\n    return nCnt;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Check For Enemies Around Target\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Takes a target object and a radius and\r\n    returns how many targets of the enemy faction\r\n    are in that zone.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 16, 2001\r\n//:://////////////////////////////////////////////\r\nint GN_CheckEnemyGroupingOnTarget(object oTarget, float fDistance = 4.0)\r\n{\r\n    int nCnt;\r\n    object oCheck = GetFirstObjectInShape(SHAPE_SPHERE, fDistance, GetLocation(oTarget));\r\n    while(GetIsObjectValid(oCheck))\r\n    {\r\n        //P.W.(May 20, 2003) - Put a dead check here for whether the person being checked is dead.\r\n        if(GetIsEnemy(oCheck) && !GetIsDead(oCheck))\r\n        {\r\n            nCnt++;\r\n        }\r\n        oCheck = GetNextObjectInShape(SHAPE_SPHERE, fDistance, GetLocation(oTarget));\r\n    }\r\n    return nCnt;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Find Grenade Target\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Searches the area and marks a group as a viable\r\n    target for a grenade\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Jan 17m 2003\r\n//:://////////////////////////////////////////////\r\n\r\nobject GN_FindGrenadeTarget()\r\n{\r\n    int nMinimum = 0;\r\n    if(IsObjectPartyMember(OBJECT_SELF))\r\n    {\r\n        nMinimum = 1;\r\n    }\r\n    int nFriend = 0;\r\n    int nEnemy = 0;\r\n    int nEnemyCnt = 0;\r\n    object oFinal;\r\n    object oCheck = GetFirstObjectInShape(SHAPE_SPHERE, 40.0, GetLocation(OBJECT_SELF));\r\n    while(GetIsObjectValid(oCheck))\r\n    {\r\n        if(GetObjectSeen(oCheck) && !GetIsDead(oCheck))\r\n        {\r\n            nFriend = GN_CheckFriendlyFireOnTarget(oCheck);\r\n            nEnemy = GN_CheckEnemyGroupingOnTarget(oCheck);\r\n            //GN_MyPrintString("GENERIC DEBUG *************** Friends " + GN_ITS(nFriend) + "Enemies" + GN_ITS(nEnemy));\r\n            if(nEnemy > nMinimum && nFriend == 0 && nEnemyCnt < nEnemy)\r\n            {\r\n                oFinal = oCheck;\r\n                nEnemyCnt = nEnemy;\r\n            }\r\n        }\r\n        oCheck = GetNextObjectInShape(SHAPE_SPHERE, 40.0, GetLocation(OBJECT_SELF));\r\n    }\r\n    return oFinal;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Find Grenade Target\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Searches the area and marks a group as a\r\n    viable target for a AOE force power\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Jan 17m 2003\r\n//:://////////////////////////////////////////////\r\n\r\nobject GN_FindAOETarget()\r\n{\r\n    int nEnemy = 0;\r\n    int nEnemyCnt = 0;\r\n    object oFinal;\r\n    object oCheck = GetFirstObjectInShape(SHAPE_SPHERE, 30.0, GetLocation(OBJECT_SELF));\r\n    while(GetIsObjectValid(oCheck))\r\n    {\r\n        nEnemy = GN_CheckEnemyGroupingOnTarget(oCheck,4.0);\r\n        if(nEnemy > 2 && nEnemyCnt < nEnemy)\r\n        {\r\n            oFinal = oCheck;\r\n            nEnemyCnt = nEnemy;\r\n        }\r\n        oCheck = GetNextObjectInShape(SHAPE_SPHERE, 30.0, GetLocation(OBJECT_SELF));\r\n    }\r\n    return oFinal;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Grenade Talent\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns a talent based on the target.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Jan 17, 2003\r\n//:://////////////////////////////////////////////\r\n\r\ntalent GN_GetGrenadeTalent(int nDroid = FALSE)\r\n{\r\n    talent tUse;\r\n    int n87, n88, n89, n90, n91, n92, n93, n94, n95;\r\n    int nRand = 0;\r\n\r\n    int bValid = FALSE;\r\n    int nCnt = 87;\r\n    for(nCnt; nCnt < 96; nCnt++)\r\n    {\r\n        tUse = TalentSpell(nCnt);\r\n        if(GetCreatureHasTalent(tUse))\r\n        {\r\n            switch(nCnt)\r\n            {\r\n                case 87:\r\n                {\r\n                    n87 = TRUE;\r\n                    nRand++;\r\n                }\r\n                break;\r\n                case 88:\r\n                {\r\n                    if(nDroid == FALSE)\r\n                    {\r\n                        n88 = TRUE;\r\n                        nRand++;\r\n                    }\r\n                }\r\n                break;\r\n                case 89:\r\n                {\r\n                    n89 = TRUE;\r\n                    nRand++;\r\n                }\r\n                break;\r\n                case 90:\r\n                {\r\n                    if(nDroid == FALSE)\r\n                    {\r\n                        n90 = TRUE;\r\n                        nRand++;\r\n                    }\r\n                }\r\n                break;\r\n                case 91:\r\n                {\r\n                    if(nDroid == FALSE)\r\n                    {\r\n                        n91 = TRUE;\r\n                        nRand++;\r\n                    }\r\n                }\r\n                break;\r\n                case 92:\r\n                {\r\n                    if(nDroid == FALSE)\r\n                    {\r\n                        n92 = TRUE;\r\n                        nRand++;\r\n                    }\r\n                }\r\n                break;\r\n                case 93:\r\n                {\r\n                    if(nDroid == FALSE)\r\n                    {\r\n                        n93 = TRUE;\r\n                        nRand++;\r\n                    }\r\n                }\r\n                break;\r\n                case 94:\r\n                {\r\n                    n94 = TRUE;\r\n                    nRand++;\r\n                }\r\n                break;\r\n                case 95:\r\n                {\r\n                    if(nDroid == TRUE)\r\n                    {\r\n                        n95 = TRUE;\r\n                        nRand++;\r\n                    }\r\n                }\r\n                break;\r\n            }\r\n        }\r\n    }\r\n    int nRoll;\r\n    if(nRand > 0)\r\n    {\r\n        nRoll = Random(nRand) + 1;\r\n    }\r\n    else\r\n    {\r\n        nRoll = 0;\r\n    }\r\n    //GN_MyPrintString("GENERIC DEBUG *************** Roll = " + GN_ITS(nRoll));\r\n    if(nRand > 0)\r\n    {\r\n        //FRAG GRENADE\r\n        if(nRoll == 1 && n87 == TRUE)\r\n        {\r\n            return tUse = TalentSpell(87);\r\n        }\r\n        if(nRoll > 1 && n87 == TRUE)\r\n        {\r\n            nRoll--;\r\n        }\r\n        //STUN GRENADE\r\n        if(nRoll == 1 && n88 == TRUE)\r\n        {\r\n            return tUse = TalentSpell(88);\r\n        }\r\n        if(nRoll > 1 && n88 == TRUE)\r\n        {\r\n            nRoll--;\r\n        }\r\n        //THERMAL DETONATOR\r\n        if(nRoll == 1 && n89 == TRUE)\r\n        {\r\n            return tUse = TalentSpell(89);\r\n        }\r\n        if(nRoll > 1 && n89 == TRUE)\r\n        {\r\n            nRoll--;\r\n        }\r\n        //POISON\r\n        if(nRoll == 1 && n90 == TRUE)\r\n        {\r\n            return tUse = TalentSpell(90);\r\n        }\r\n        if(nRoll > 1 && n90 == TRUE)\r\n        {\r\n            nRoll--;\r\n        }\r\n        //SONIC\r\n        if(nRoll == 1 && n91 == TRUE)\r\n        {\r\n            return tUse = TalentSpell(91);\r\n        }\r\n        if(nRoll > 1 && n91 == TRUE)\r\n        {\r\n            nRoll--;\r\n        }\r\n        //ADHESIVE\r\n        if(nRoll == 1 && n92 == TRUE)\r\n        {\r\n            return tUse = TalentSpell(92);\r\n        }\r\n        if(nRoll > 1 && n92 == TRUE)\r\n        {\r\n            nRoll--;\r\n        }\r\n        //CRYOBAN\r\n        if(nRoll == 1 && n93 == TRUE)\r\n        {\r\n            return tUse = TalentSpell(93);\r\n        }\r\n        if(nRoll > 1 && n93 == TRUE)\r\n        {\r\n            nRoll--;\r\n        }\r\n        //PLASMA\r\n        if(nRoll == 1 && n94 == TRUE)\r\n        {\r\n            return tUse = TalentSpell(94);\r\n        }\r\n        if(nRoll > 1 && n94 == TRUE)\r\n        {\r\n            nRoll--;\r\n        }\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** Grenade Selection Failure");\r\n    talent tNull;\r\n    return tNull;\r\n    return tNull;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Boss Combat Move\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns a talent for the boss to perform\r\n    in combat.  This function will try and pick a\r\n    talent which will inflict maximum damage\r\n    on the party via area of effect spells, grenades\r\n    and debilitating effects.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Feb 2, 2003\r\n//:://////////////////////////////////////////////\r\ntalent GN_GetBossCombatMove(int nBossAttackType, int nDroid = FALSE)\r\n{\r\n    talent tInvalid;\r\n    talent tUse;\r\n    int bValid = FALSE;\r\n    if(nBossAttackType == SW_BOSS_ATTACK_TYPE_GRENADE || nBossAttackType == SW_BOSS_ATTACK_ANY)\r\n    {\r\n        tUse = GN_GetGrenadeTalent(nDroid);\r\n        if(GetIsTalentValid(tUse))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Grenade Talent Chosen");\r\n            return tUse;\r\n        }\r\n    }\r\n    if(nBossAttackType == SW_BOSS_ATTACK_TYPE_FORCE_POWER || nBossAttackType == SW_BOSS_ATTACK_ANY)\r\n    {\r\n        tUse = GN_GetAOEForcePower(nDroid);\r\n        if(GetIsTalentValid(tUse))\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Boss AI: AOE Force Power Talent Chosen");\r\n            return tUse;\r\n        }\r\n    }\r\n    if(nBossAttackType == SW_BOSS_ATTACK_TYPE_NPC || nBossAttackType == SW_BOSS_ATTACK_ANY)\r\n    {\r\n        if(d100() > 50)\r\n        {\r\n            tUse = GN_GetTargetedForcePower(nDroid);\r\n            if(GetIsTalentValid(tUse))\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Targeted Force Power Talent Chosen");\r\n                return tUse;\r\n            }\r\n            tUse = GN_GetAOEForcePower(nDroid);\r\n            if(GetIsTalentValid(tUse))\r\n            {\r\n                GN_MyPrintString("GENERIC DEBUG *************** Boss AI: AOE Force Power Talent Chosen");\r\n                return tUse;\r\n            }\r\n        }\r\n        if(GN_GetWeaponType() == 1)\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Melee Feat Talent Chosen");\r\n            tUse = GetCreatureTalentRandom(0x1104); //Only melee feats use this code\r\n        }\r\n        else\r\n        {\r\n            GN_MyPrintString("GENERIC DEBUG *************** Boss AI: Range Feat Talent Chosen");\r\n            tUse = GetCreatureTalentRandom(0x1111); //Only ranged feats use this code\r\n        }\r\n        if(GetIsTalentValid(tUse))\r\n        {\r\n            return tUse;\r\n        }\r\n    }\r\n    else if(nBossAttackType == SW_BOSS_ATTACK_TYPE_PC || nBossAttackType == SW_BOSS_ATTACK_ANY)\r\n    {\r\n        if(d100() > 70)\r\n        {\r\n            tUse = GN_GetTargetedForcePower(nDroid);\r\n            if(GetIsTalentValid(tUse))\r\n            {\r\n                return tUse;\r\n            }\r\n            tUse = GN_GetAOEForcePower(nDroid);\r\n            if(GetIsTalentValid(tUse))\r\n            {\r\n                return tUse;\r\n            }\r\n        }\r\n        tUse = GetCreatureTalentRandom(0x1104); //Only melee feats use this code\r\n        if(GetIsTalentValid(tUse))\r\n        {\r\n            return tUse;\r\n        }\r\n        GN_MyPrintString("GENERIC DEBUG *************** Boss AI: No Feats Available");\r\n    }\r\n    //Comment this out so that the boss AI handles the failure not this function.\r\n    /*\r\n    if(!GetIsTalentValid(tUse) && nBossAttackType != SW_BOSS_ATTACK_ANY)\r\n    {\r\n        tUse = GN_GetBossCombatMove(SW_BOSS_ATTACK_ANY);\r\n    }\r\n    */\r\n    return tUse;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get AOE Force Power\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks and returns a random force power that\r\n    can effect more than 1 target.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Feb 2, 2003\r\n//:://////////////////////////////////////////////\r\ntalent GN_GetAOEForcePower(int nDroid = FALSE)\r\n{\r\n    talent tUse;\r\n    int nHorror, nInsanity, nStorm, nWave, nSaber, nLightning, nSleep, nStunDroid, nKillDroid, nHowl, nCnt;\r\n\r\n    //MODIFIED by Preston Watamaniuk on April 27, 2003\r\n    //Removed Death Field so that it would be used exlusively for Healing.\r\n\r\n    //MODIFIED by Preston Watamaniuk on May 14, 2003\r\n    //Put a check into make sure that the same AOE power is not used over and over.\r\n    int nLastForcePower = GetLastForcePowerUsed(OBJECT_SELF);\r\n    GN_MyPrintString("GENERIC DEBUG *************** Last Force Power Used = " + GN_ITS(nLastForcePower));\r\n\r\n    //THIS SECTION DETERMINES WHICH POWERS ARE APPLICABLE\r\n    if(GetHasSpell(FORCE_POWER_HORROR) && nDroid == FALSE && nLastForcePower != FORCE_POWER_HORROR)\r\n    {\r\n        nHorror = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_INSANITY) && nDroid == FALSE && nLastForcePower != FORCE_POWER_INSANITY)\r\n    {\r\n        nInsanity = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_FORCE_STORM) && nLastForcePower != FORCE_POWER_FORCE_STORM)\r\n    {\r\n        nStorm = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_FORCE_WAVE) && nLastForcePower != FORCE_POWER_FORCE_WAVE)\r\n    {\r\n        nWave = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_LIGHT_SABER_THROW_ADVANCED) && nLastForcePower != FORCE_POWER_LIGHT_SABER_THROW_ADVANCED)\r\n    {\r\n        nSaber = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_LIGHTNING) && nLastForcePower != FORCE_POWER_LIGHTNING)\r\n    {\r\n        nLightning = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_SLEEP) && nDroid == FALSE && nLastForcePower != FORCE_POWER_SLEEP)//Now Mass Stasis\r\n    {\r\n        nSleep = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_DROID_STUN) && nDroid == TRUE && nLastForcePower != FORCE_POWER_DROID_STUN)\r\n    {\r\n        nStunDroid = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_DROID_DESTROY) && nDroid == TRUE && nLastForcePower != FORCE_POWER_DROID_DESTROY)\r\n    {\r\n        nKillDroid = 1;\r\n        nCnt++;\r\n    }\r\n    talent tHowl  = TalentSpell(131);\r\n    if(GetCreatureHasTalent(tHowl)) //Sonic Howl\r\n    {\r\n        nHowl = 1;\r\n        nCnt++;\r\n    }\r\n\r\n    \r\n    //THIS SECTION DETERMINES WHICH POWER TO USE\r\n    int nRoll;\r\n    if(nCnt > 0)\r\n    {\r\n        nRoll = Random(nCnt) + 1;\r\n    }\r\n    else\r\n    {\r\n        nRoll = 0;\r\n    }\r\n    \r\n    //Horror\r\n    if(nHorror == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_HORROR);\r\n        nRoll--;\r\n    }\r\n    if(nHorror == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Insanity\r\n    if(nInsanity == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_INSANITY);\r\n        nRoll--;\r\n    }\r\n    if(nHorror == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Force Storm\r\n    if(nStorm == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_FORCE_STORM);\r\n        nRoll--;\r\n    }\r\n    if(nStorm == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Force Wave\r\n    if(nWave == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_FORCE_WAVE);\r\n        nRoll--;\r\n    }\r\n    if(nWave == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Advanced Saber Throw\r\n    if(nSaber == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_LIGHT_SABER_THROW_ADVANCED);\r\n        nRoll--;\r\n    }\r\n    if(nSaber == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Lightning\r\n    if(nLightning == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_LIGHTNING);\r\n        nRoll--;\r\n    }\r\n    if(nLightning == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Mass Stasis\r\n    if(nSleep == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_SLEEP);\r\n        nRoll--;\r\n    }\r\n    if(nSleep == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Stun Droid\r\n    if(nStunDroid == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_DROID_STUN);\r\n        nRoll--;\r\n    }\r\n    if(nStunDroid == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Destroy Droid\r\n    if(nKillDroid == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_DROID_DESTROY);\r\n        nRoll--;\r\n    }\r\n    if(nKillDroid == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Sonic Howl\r\n    if(nKillDroid == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(131);\r\n        nRoll--;\r\n    }\r\n    if(nHowl == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** Force Power Returned = " + GN_ITS(GetIdFromTalent(tUse)));\r\n    return tUse;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Targeted Force Power\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks and returns a random force power that\r\n    can effect 1 target.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Feb 2, 2003\r\n//:://////////////////////////////////////////////\r\ntalent GN_GetTargetedForcePower(int nDroid = FALSE)\r\n{\r\n    talent tUse;\r\n    int nChoke, nAfflict, nPlague, nPush, nWind, nLightning, nKill, nHorror, nWound, nStasis, nDroid, nKnock, nHowl, nCnt;\r\n\r\n    if(GetRacialType(OBJECT_SELF) == RACIAL_TYPE_DROID)\r\n    {\r\n        tUse = GetCreatureTalentRandom(0x8000);\r\n        if(GetIsTalentValid(tUse))\r\n        {\r\n            return tUse;\r\n        }\r\n    }\r\n    //MODIFIED by Preston Watamaniuk on April 27, 2003\r\n    //Removed Drain Life so that it would be used exlusively for Healing.\r\n    \r\n    if(GetHasSpell(FORCE_POWER_CHOKE) && nDroid == FALSE)\r\n    {\r\n        nChoke = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_AFFLICTION) && nDroid == FALSE)\r\n    {\r\n        nAfflict = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_PLAGUE) && nDroid == FALSE)\r\n    {\r\n        nPlague = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_FORCE_PUSH))\r\n    {\r\n        nPush = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_FORCE_WHIRLWIND))\r\n    {\r\n        nWind = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_LIGHTNING))\r\n    {\r\n        nLightning = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_KILL) && nDroid == FALSE)\r\n    {\r\n        nKill = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_HORROR) && nDroid == FALSE)\r\n    {\r\n        nHorror = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_WOUND) && nDroid == FALSE)\r\n    {\r\n        nWound = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_HOLD))\r\n    {\r\n        nStasis = 1;\r\n        nCnt++;\r\n    }\r\n    if(GetHasSpell(FORCE_POWER_DROID_DISABLE) && nDroid == TRUE)\r\n    {\r\n        nDroid = 1;\r\n        nCnt++;\r\n    }\r\n    talent tSlam  = TalentSpell(83);\r\n    if(GetCreatureHasTalent(tSlam)) //Monster Slam\r\n    {\r\n        nKnock = 1;\r\n        nCnt++;\r\n    }\r\n\r\n    //THIS SECTION DETERMINES WHICH POWER TO USE\r\n    int nRoll;\r\n    if(nCnt > 0)\r\n    {\r\n        nRoll = Random(nCnt) + 1;\r\n    }\r\n    else\r\n    {\r\n        nRoll = 0;\r\n    }\r\n    //Choke\r\n    if(nChoke == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_CHOKE);\r\n        nRoll--;\r\n    }\r\n    if(nChoke == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Affliction\r\n    if(nAfflict == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_AFFLICTION);\r\n        nRoll--;\r\n    }\r\n    if(nAfflict == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Plague\r\n    if(nPlague == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_AFFLICTION);\r\n        nRoll--;\r\n    }\r\n    if(nPlague == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Force Push\r\n    if(nPush == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_FORCE_PUSH);\r\n        nRoll--;\r\n    }\r\n    if(nPush == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Force Whirlwind\r\n    if(nWind == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_FORCE_WHIRLWIND);\r\n        nRoll--;\r\n    }\r\n    if(nWind == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Lightning\r\n    if(nLightning == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_LIGHTNING);\r\n        nRoll--;\r\n    }\r\n    if(nLightning == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Kill\r\n    if(nKill == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_KILL);\r\n        nRoll--;\r\n    }\r\n    if(nKill == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Horror\r\n    if(nHorror == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_HORROR);\r\n        nRoll--;\r\n    }\r\n    if(nHorror == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Wound\r\n    if(nWound== 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_WOUND);\r\n        nRoll--;\r\n    }\r\n    if(nWound == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Stasis\r\n    if(nStasis== 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_HOLD);\r\n        nRoll--;\r\n    }\r\n    if(nStasis == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Disable Droid\r\n    if(nDroid== 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(FORCE_POWER_DROID_DISABLE);\r\n        nRoll--;\r\n    }\r\n    if(nDroid == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    //Monster Slam\r\n    if(nKnock == 1 && nRoll == 1)\r\n    {\r\n        tUse = TalentSpell(83);\r\n        nRoll--;\r\n    }\r\n    if(nKnock == 1 && nRoll > 1)\r\n    {\r\n        nRoll--;\r\n    }\r\n    return tUse;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Active Party Member Count\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns the number of party members who\r\n    are active\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Feb 2, 2003\r\n//:://////////////////////////////////////////////\r\nint GN_GetActivePartyMemberCount()\r\n{\r\n    object oNPC1 = GetPartyMemberByIndex(0);\r\n    object oNPC2 = GetPartyMemberByIndex(1);\r\n    object oNPC3 = GetPartyMemberByIndex(2);\r\n\r\n    int nCnt = 0;\r\n\r\n    if(GetIsObjectValid(oNPC1) && GetCurrentHitPoints(oNPC1) > 0 && GetObjectSeen(oNPC1))\r\n    {\r\n        nCnt++;\r\n    }\r\n    if(GetIsObjectValid(oNPC2) && GetCurrentHitPoints(oNPC2) > 0 && GetObjectSeen(oNPC2))\r\n    {\r\n        nCnt++;\r\n    }\r\n    if(GetIsObjectValid(oNPC3) && GetCurrentHitPoints(oNPC3) > 0 && GetObjectSeen(oNPC3))\r\n    {\r\n        nCnt++;\r\n    }\r\n    return nCnt;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Active Party Member\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns a party member who is active a not\r\n    currently controlled by the PC.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Feb 2, 2003\r\n//:://////////////////////////////////////////////\r\n/*\r\n    MODIFIED by Preston Watamaniuk on March 8, 2003\r\n\r\n    Added some functionality so that the Drain Life\r\n    will be targeted on the 0 Index as well as the\r\n    other party members. Also if Drain = TRUE then\r\n    no droids will be returned.\r\n    \r\n    This function will return the nearest non-droid\r\n    enemy if the party is freindly.\r\n*/\r\n//:://////////////////////////////////////////////\r\nobject GN_GetActivePartyMember(int nDrainTarget = FALSE)\r\n{\r\n    object oNPC1 = GetPartyMemberByIndex(0);\r\n    object oNPC2 = GetPartyMemberByIndex(1);\r\n    object oNPC3 = GetPartyMemberByIndex(2);\r\n    object oTarget;\r\n\r\n    int nCnt = 0;\r\n    int nRoll;\r\n    int nNPC1 = FALSE;\r\n    int nNPC2 = FALSE;\r\n    int nNPC3 = FALSE;\r\n\r\n    if(GetIsObjectValid(oNPC2) && GetCurrentHitPoints(oNPC2) > 0 && GetObjectSeen(oNPC2))\r\n    {\r\n        if(GetRacialType(oNPC2) != RACIAL_TYPE_DROID || nDrainTarget == FALSE)\r\n        {\r\n            nCnt++;\r\n            nNPC2 = TRUE;\r\n        }\r\n    }\r\n    if(GetIsObjectValid(oNPC3) && GetCurrentHitPoints(oNPC3) > 0 && GetObjectSeen(oNPC3))\r\n    {\r\n        if(GetRacialType(oNPC3) != RACIAL_TYPE_DROID || nDrainTarget == FALSE)\r\n        {\r\n            nCnt++;\r\n            nNPC3 = TRUE;\r\n        }\r\n    }\r\n\r\n    if(nDrainTarget == TRUE)\r\n    {\r\n        if(GetIsObjectValid(oNPC1) && GetCurrentHitPoints(oNPC1) > 0 && GetObjectSeen(oNPC1))\r\n        {\r\n            if(GetRacialType(oNPC1) != RACIAL_TYPE_DROID)\r\n            {\r\n                nCnt++;\r\n                nNPC1 = TRUE;\r\n            }\r\n        }\r\n    }\r\n\r\n    if(nCnt == 0)\r\n    {\r\n        oTarget = OBJECT_INVALID;\r\n    }\r\n    else if(nCnt == 1)\r\n    {\r\n        if(nNPC2 == TRUE){oTarget = oNPC2;}\r\n        else if(nNPC3 == TRUE){oTarget = oNPC3;}\r\n        else if(nNPC1 == TRUE){oTarget = oNPC1;}\r\n    }\r\n    else if(nCnt == 2)\r\n    {\r\n        nRoll = d100();\r\n        if(nNPC1 == TRUE && nNPC2 == TRUE)\r\n        {\r\n            if(nRoll > 50){oTarget = oNPC1;}\r\n            else{oTarget = oNPC2;}\r\n        }\r\n        else if(nNPC1 == TRUE && nNPC3 == TRUE)\r\n        {\r\n            if(nRoll > 50){oTarget = oNPC1;}\r\n            else{oTarget = oNPC3;}\r\n        }\r\n        else if(nNPC2 == TRUE && nNPC3 == TRUE)\r\n        {\r\n            if(nRoll > 50){oTarget = oNPC2;}\r\n            else{oTarget = oNPC3;}\r\n        }\r\n    }\r\n    else if(nCnt == 3)\r\n    {\r\n        nRoll = d100();\r\n        if(nRoll <= 33){oTarget = oNPC1;}\r\n        else if(nRoll > 33 && nRoll <= 66) {oTarget = oNPC2;}\r\n        else if(nRoll > 66 && nRoll <= 100) {oTarget = oNPC3;}\r\n    }\r\n    \r\n    //MODIFIED by Preston Watamaniuk on May 18, 2003\r\n    //Changed the racial type to Human from Droid.\r\n    if(!GetIsEnemy(oTarget, OBJECT_SELF) && nDrainTarget == TRUE)\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** Searching for Alternate Target");\r\n        oTarget = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY, OBJECT_SELF, 1, CREATURE_TYPE_RACIAL_TYPE, RACIAL_TYPE_HUMAN);\r\n        GN_MyPrintString("GENERIC DEBUG *************** Alternate Target = " + GN_ReturnDebugName(oTarget));\r\n    }\r\n    GN_MyPrintString("GENERIC DEBUG *************** Heal Drain Target = " + GN_ITS(nDrainTarget));\r\n    GN_MyPrintString("GENERIC DEBUG *************** Get Active Party Member: " + GN_ReturnDebugName(oTarget));\r\n    return oTarget;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Return Active Party Member\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This function returns an active party member.\r\n    They must not be dead.  The debilitated\r\n    parameter will ignore those party members\r\n    already debilitated.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: June 12, 2003\r\n//:://////////////////////////////////////////////\r\nobject GN_ReturnActivePartyMember(int nDebil = FALSE)\r\n{\r\n    object oNPC1 = GetPartyMemberByIndex(0);\r\n    object oNPC2 = GetPartyMemberByIndex(1);\r\n    object oNPC3 = GetPartyMemberByIndex(2);\r\n    object oTarget;\r\n\r\n    int nCnt = 0;\r\n    int nRoll;\r\n    int nNPC1 = FALSE;\r\n    int nNPC2 = FALSE;\r\n    int nNPC3 = FALSE;\r\n\r\n    if(GetIsObjectValid(oNPC2) && GetCurrentHitPoints(oNPC2) > 0 && GetObjectSeen(oNPC2))\r\n    {\r\n        if(nDebil == FALSE || !GetIsDebilitated(oNPC2))\r\n        {\r\n            nCnt++;\r\n            nNPC2 = TRUE;\r\n        }\r\n    }\r\n    if(GetIsObjectValid(oNPC3) && GetCurrentHitPoints(oNPC3) > 0 && GetObjectSeen(oNPC3))\r\n    {\r\n        if(nDebil == FALSE || !GetIsDebilitated(oNPC2))\r\n        {\r\n            nCnt++;\r\n            nNPC3 = TRUE;\r\n        }\r\n    }\r\n\r\n    if(GetIsObjectValid(oNPC1) && GetCurrentHitPoints(oNPC1) > 0 && GetObjectSeen(oNPC1))\r\n    {\r\n        if(nDebil == FALSE || !GetIsDebilitated(oNPC2))\r\n        {\r\n            nCnt++;\r\n            nNPC1 = TRUE;\r\n        }\r\n    }\r\n    if(nCnt == 0)\r\n    {\r\n        oTarget = OBJECT_INVALID;\r\n    }\r\n    else if(nCnt == 1)\r\n    {\r\n        if(nNPC2 == TRUE){oTarget = oNPC2;}\r\n        else if(nNPC3 == TRUE){oTarget = oNPC3;}\r\n        else if(nNPC1 == TRUE){oTarget = oNPC1;}\r\n    }\r\n    else if(nCnt == 2)\r\n    {\r\n        nRoll = d100();\r\n        if(nNPC1 == TRUE && nNPC2 == TRUE)\r\n        {\r\n            if(nRoll > 50){oTarget = oNPC1;}\r\n            else{oTarget = oNPC2;}\r\n        }\r\n        else if(nNPC1 == TRUE && nNPC3 == TRUE)\r\n        {\r\n            if(nRoll > 50){oTarget = oNPC1;}\r\n            else{oTarget = oNPC3;}\r\n        }\r\n        else if(nNPC2 == TRUE && nNPC3 == TRUE)\r\n        {\r\n            if(nRoll > 50){oTarget = oNPC2;}\r\n            else{oTarget = oNPC3;}\r\n        }\r\n    }\r\n    else if(nCnt == 3)\r\n    {\r\n        nRoll = d100();\r\n        if(nRoll <= 33){oTarget = oNPC1;}\r\n        else if(nRoll > 33 && nRoll <= 66) {oTarget = oNPC2;}\r\n        else if(nRoll > 66 && nRoll <= 100) {oTarget = oNPC3;}\r\n    }\r\n    \r\n    return oTarget;\r\n}\r\n\r\n//:://///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n//:: Generic Include Debug Commands\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//::////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n//::////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: June 12, 2002\r\n//::////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n\r\nvoid GN_MySpeakString(string sString)\r\n{\r\n    //SpeakString(sString);\r\n}\r\n\r\nvoid GN_AssignPCDebugString(string sString)\r\n{\r\n    object oPC = GetNearestCreature(CREATURE_TYPE_PLAYER_CHAR, PLAYER_CHAR_IS_PC);\r\n    if(GetIsObjectValid(oPC))\r\n    {\r\n        AssignCommand(oPC, SpeakString(sString));\r\n    }\r\n}\r\nvoid GN_PostString(string sString = "",int x = 10,int y = 10,float fShow = 4.0)\r\n{\r\n    //AurPostString(sString,x,y,fShow);\r\n}\r\n\r\nvoid GN_MyPrintString(string sString)\r\n{\r\n    if(!ShipBuild())\r\n    {\r\n        PrintString(sString);\r\n    }\r\n}\r\n\r\nvoid GN_PostShoutString(string sString = "",int x = 10,int y = 10,float fShow = 4.0)\r\n{\r\n    //AurPostString(sString,x,y,fShow);\r\n}\r\n\r\nvoid GN_MyPrintShoutString(string sString)\r\n{\r\n    if(!ShipBuild())\r\n    {\r\n        //PrintString(sString);\r\n    }\r\n}\r\n\r\n\r\nvoid GN_PrintShoutType(object oShouter, int nShout)\r\n{\r\n    /*\r\n    //I WAS ATTACKED\r\n    if(nShout == 1)\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** " + GetName(oShouter) + "/" + ObjectToString(oShouter) + " ATTACKED");\r\n    }\r\n    //I WAS KILLED\r\n    else if(nShout == 3)\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** " + GetName(oShouter) + "/" + ObjectToString(oShouter) + " KILLED");\r\n    }\r\n    //CALL TO ARMS\r\n    else if(nShout == 6)\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** " + GetName(oShouter) + "/" + ObjectToString(oShouter) + " CALL TO ARMS");\r\n    }\r\n    //SUPRESS FORCE\r\n    else if(nShout == 9)\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** " + GetName(oShouter) + "/" + ObjectToString(oShouter) + " WANTS FORCE SUPPRESSED");\r\n    }\r\n    //FLEE FROM GRENADES\r\n    else if(nShout == 12)\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** " + GetName(oShouter) + "/" + ObjectToString(oShouter) + " GRENADE THROWN");\r\n    }\r\n    //I SEE AN ENEMY\r\n    else if(nShout == 15)\r\n    {\r\n        GN_MyPrintString("GENERIC DEBUG *************** " + GetName(oShouter) + "/" + ObjectToString(oShouter) + " SEES AN ENEMY");\r\n    }\r\n    */\r\n}\r\n\r\nstring GN_ReturnDebugName(object oTarget)\r\n{\r\n    string sName = GetName(oTarget) + "_" + ObjectToString(oTarget);\r\n    return sName;\r\n}\r\n\r\nstring GN_FetchComboString(int nCombo)\r\n{\r\n    if(nCombo == SW_COMBO_RANGED_FEROCIOUS){return "SW_COMBO_RANGED_FEROCIOUS";}\r\n    else if(nCombo == SW_COMBO_RANGED_AGGRESSIVE){return "SW_COMBO_RANGED_AGGRESSIVE";}\r\n    else if(nCombo == SW_COMBO_RANGED_DISCIPLINED){return "SW_COMBO_RANGED_DISCIPLINED";}\r\n    else if(nCombo == SW_COMBO_RANGED_CAUTIOUS){return "SW_COMBO_RANGED_CAUTIOUS";}\r\n    else if(nCombo == SW_COMBO_MELEE_FEROCIOUS){return "SW_COMBO_MELEE_FEROCIOUS";}\r\n    else if(nCombo == SW_COMBO_MELEE_AGGRESSIVE){return "SW_COMBO_MELEE_AGGRESSIVE";}\r\n    else if(nCombo == SW_COMBO_MELEE_DISCIPLINED){return "SW_COMBO_MELEE_DISCIPLINED";}\r\n    else if(nCombo == SW_COMBO_MELEE_CAUTIOUS){return "SW_COMBO_MELEE_CAUTIOUS";}\r\n    else if(nCombo == SW_COMBO_BUFF_PARTY){return "SW_COMBO_BUFF_PARTY";}\r\n    else if(nCombo == SW_COMBO_BUFF_DEBILITATE){return "SW_COMBO_BUFF_DEBILITATE";}\r\n    else if(nCombo == SW_COMBO_BUFF_DAMAGE){return "SW_COMBO_BUFF_DAMAGE";}\r\n    else if(nCombo == SW_COMBO_BUFF_DEBILITATE_DESTROY){return "SW_COMBO_BUFF_DEBILITATE_DESTROY";}\r\n    else if(nCombo == SW_COMBO_SUPRESS_DEBILITATE_DESTROY){return "SW_COMBO_SUPRESS_DEBILITATE_DESTROY";}\r\n    else if(nCombo == SW_COMBO_SITH_ATTACK){return "SW_COMBO_SITH_ATTACK";}\r\n    else if(nCombo == SW_COMBO_BUFF_ATTACK){return "SW_COMBO_BUFF_ATTACK";}\r\n    else if(nCombo == SW_COMBO_SITH_CONFOUND){return "SW_COMBO_SITH_CONFOUND";}\r\n    else if(nCombo == SW_COMBO_JEDI_SMITE){return "SW_COMBO_JEDI_SMITE";}\r\n    else if(nCombo == SW_COMBO_SITH_TAUNT){return "SW_COMBO_SITH_TAUNT";}\r\n    else if(nCombo == SW_COMBO_SITH_BLADE){return "SW_COMBO_SITH_BLADE";}\r\n    else if(nCombo == SW_COMBO_SITH_CRUSH){return "SW_COMBO_SITH_CRUSH";}\r\n    else if(nCombo == SW_COMBO_JEDI_CRUSH){return "SW_COMBO_JEDI_CRUSH";}\r\n    else if(nCombo == SW_COMBO_SITH_BRUTALIZE){return "SW_COMBO_SITH_BRUTALIZE";}\r\n    else if(nCombo == SW_COMBO_SITH_DRAIN){return "SW_COMBO_SITH_DRAIN";}\r\n    else if(nCombo == SW_COMBO_SITH_ESCAPE){return "SW_COMBO_SITH_ESCAPE";}\r\n    else if(nCombo == SW_COMBO_JEDI_BLITZ){return "SW_COMBO_JEDI_BLITZ";}\r\n    else if(nCombo == SW_COMBO_SITH_SPIKE){return "SW_COMBO_SITH_SPIKE";}\r\n    else if(nCombo == SW_COMBO_SITH_SCYTHE){return "SW_COMBO_SITH_SCYTHE";}\r\n    else if(nCombo == SW_COMBO_DROID_UTILITIES){return "SW_COMBO_DROID_UTILITIES";}\r\n    return "NO COMBO SELECTED";\r\n}\r\n\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Return AI Style\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns the AI style in a string\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Jan 28, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nstring GN_ReturnAIStyle(object oTarget = OBJECT_SELF)\r\n{\r\n    if(GetNPCAIStyle(oTarget) == NPC_AISTYLE_AID)\r\n    {\r\n        return "NPC_AISTYLE_AID";\r\n    }\r\n    else if(GetNPCAIStyle(oTarget) == NPC_AISTYLE_GRENADE_THROWER)\r\n    {\r\n        return "NPC_AISTYLE_GRENADE_THROWER";\r\n    }\r\n    else if(GetNPCAIStyle(oTarget) == NPC_AISTYLE_JEDI_SUPPORT)\r\n    {\r\n        return "NPC_AISTYLE_JEDI_SUPPORT";\r\n    }\r\n    else if(GetNPCAIStyle(oTarget) == NPC_AISTYLE_DEFAULT_ATTACK)\r\n    {\r\n        return "NPC_AISTYLE_DEFAULT_ATTACK";\r\n    }\r\n    int nAI = GetNPCAIStyle(oTarget);\r\n    string sAI = IntToString(nAI);\r\n    sAI = "No Valid AI Set, state = " + sAI;\r\n    return sAI;\r\n}\r\n\r\nstring GN_ITS(int sFutureString)\r\n{\r\n    return IntToString(sFutureString);\r\n}\r\n\r\n', 'k_inc_kas': b'//::///////////////////////////////////////////////\r\n//:: Include\r\n//:: k_inc_kas\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This is the include file for Kashyyyk.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: John Winski\r\n//:: Created On: July 29, 2002\r\n//:://////////////////////////////////////////////\r\n#include "k_inc_utility"\r\n#include "k_inc_generic"\r\n\r\nint GetGorwookenSpawnGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_SpawnGorwook");\r\n}\r\n\r\nvoid SetGorwookenSpawnGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_SpawnGorwook", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetEliBeenKilledGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_elikilled");\r\n}\r\n\r\nvoid SetEliBeenKilledGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_elikilled", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJaarakConfessedGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_JaarakConfessed");\r\n}\r\n\r\nvoid SetJaarakConfessedGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_JaarakConfessed", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetKashyyykPazaakStateGlobal()\r\n{\r\n    return GetGlobalNumber("tat_kashpazstate");\r\n}\r\n\r\nvoid SetKashyyykPazaakStateGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("tat_kashpazstate", bValue);\r\n\r\n    return;\r\n}\r\n\r\nint GetGuardToldGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_GuardTold");\r\n}\r\n\r\nvoid SetGuardToldGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_GuardTold", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPoacherPlotStateGlobal()\r\n{\r\nreturn GetGlobalNumber("kas_poacherstate");\r\n}\r\n\r\nvoid SetPoacherPlotStateGlobal(int bValue)\r\n{\r\nSetGlobalNumber("kas_poacherstate", bValue);\r\nreturn;\r\n}\r\n\r\n\r\nint GetPlayerToldOfPoachersGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_ToldPoachers");\r\n}\r\n\r\nvoid SetPlayerToldOfPoachersGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_ToldPoachers", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetChuundarTalkGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_TalkChuundar");\r\n}\r\n\r\nvoid SetChuundarTalkGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_TalkChuundar", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetHelpedFreyyrGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_HelpedFreyyr");\r\n}\r\n\r\nvoid SetHelpedFreyyrGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_HelpedFreyyr", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFreyyrDeadGlobal()\r\n{\r\n\treturn GetGlobalBoolean("kas_FreyyrDead");\r\n}\r\n\r\nvoid SetFreyyrDeadGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_FreyyrDead", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetChuundarDeadGlobal()\r\n{\r\n\treturn GetGlobalBoolean("kas_ChuundarDead");\r\n}\r\n\r\nvoid SetChuundarDeadGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_ChuundarDead", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetComputerTalkGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_ComputerTalk");\r\n}\r\n\r\nvoid SetComputerTalkGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_ComputerTalk", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetStarMapRecievedGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_StarMap");\r\n}\r\n\r\nvoid SetStarMapRecievedGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_StarMap", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJaarakBoltsGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_JaarakBolts");\r\n}\r\n\r\nvoid SetJaarakBoltsGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_JaarakBolts", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJaarakDeadGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_JaarakDead");\r\n}\r\n\r\nvoid SetJaarakDeadGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_JaarakDead", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJaarakFreeGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_JaarakFree");\r\n}\r\n\r\nvoid SetJaarakFreeGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_JaarakFree", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetRorworrMissingGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_RorworrMiss");\r\n}\r\n\r\nvoid SetRorworrMissingGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_RorworrMiss", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetDroidTalkGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_DroidTalk");\r\n}\r\n\r\nvoid SetDroidTalkGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_DroidTalk", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetChuundarRewardGlobal()\r\n{\r\n    return GetGlobalBoolean("kas_ChuundReward");\r\n}\r\n\r\nvoid SetChuundarRewardGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_ChuundReward", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetMandalorianPlotGlobal()\r\n{\r\n    return GetGlobalNumber("kas_MandalorPlot");\r\n}\r\n\r\nvoid SetMandalorianPlotGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("kas_MandalorPlot", bValue);\r\n\r\n    return;\r\n}\r\n\r\nint GetAskedJanosForRewardLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for xxJanos.02 in area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetAskedJanosForRewardLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for xxJanos.02 in area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJanosPaidLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Janos in area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetJanosPaidLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Janos in area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJanosOfficeLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Janos in area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetJanosOfficeLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Janos in area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPlayerAskedAboutSlavesLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Janos in area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetPlayerAskedAboutSlavesLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Janos in area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPlayerAskedAboutSuppliesLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for Janos in area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetPlayerAskedAboutSuppliesLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for Janos in area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJoleeHomeLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetJoleeHomeLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJoleeInfoLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetJoleeInfoLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPoachersRunoffLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetPoachersRunoffLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPoachersKilledLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for the area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetPoachersKilledLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for the area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetForceFieldLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_05);\r\n}\r\n\r\nvoid SetForceFieldLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_05, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetOpenForceFieldLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_06);\r\n}\r\n\r\nvoid SetOpenForceFieldLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_06, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetForceFieldInfoLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_07 for area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_07);\r\n}\r\n\r\nvoid SetForceFieldInfoLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_07 for area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_07, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetEnteredShadowlandsLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_08 for area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_08);\r\n}\r\n\r\nvoid SetEnteredShadowlandsLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_08 for area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_08, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJoleeTalkLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_09 for area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_09);\r\n}\r\n\r\nvoid SetJoleeTalkLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_09 for area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_09, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetUllerBerriesLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the uller.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetUllerBerriesLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the uller.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFreyyrSpawnGlobal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for area kas_m23ad.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetFreyyrSpawnGlobal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for area kas_m23ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFreyyrBeatLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Freyyr in area kas_m25aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetFreyyrBeatLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Freyyr in area kas_m25aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetComputerShutdownLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the computer in area kas_m25aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetComputerShutdownLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the computer in area kas_m25aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetRecognizedRevanLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the computer in area kas_m25aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetRecognizedRevanLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the computer in area kas_m25aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetComputerAttackLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the computer in area kas_m25aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetComputerAttackLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the computer in area kas_m25aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetHealChanceLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Grrrwahrr in area kas_m25aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetHealChanceLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Grrrwahrr in area kas_m25aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetEvilHurtLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Grrrwahrr in area kas_m25aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetEvilHurtLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Grrrwahrr in area kas_m25aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFreyyrMadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Freyyr in area kas_m23ad.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetFreyyrMadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Freyyr in area kas_m23ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetZaalbarMadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for area kas_m23ad.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetZaalbarMadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for area kas_m23ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetAskAboutComputerLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for area kas_m23ad.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetAskAboutComputerLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for area kas_m23ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFreyyrUpsetLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for area kas_m23ad.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetFreyyrUpsetLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for area kas_m23ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFinalBattleLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for area kas_m23ad.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_05);\r\n}\r\n\r\nvoid SetFinalBattleLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for area kas_m23ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_05, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFadeOffLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for area kas_m23ad.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_06);\r\n}\r\n\r\nvoid SetFadeOffLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for area kas_m23ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_06, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJaarakTrialLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for area kas_m23ac.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetJaarakTrialLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for area kas_m23ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJaarakAngeredOnceLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Woorwill in area kas_m23ab.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetJaarakAngeredOnceLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the computer in area kas_m23ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetRorworrDescribedOnceLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Woorwill in area kas_m23ab.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetRorworrDescribedOnceLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the computer in area kas_m23ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetRorworrGoneSinceLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Woorwill in area kas_m23ab.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetRorworrGoneSinceLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the computer in area kas_m23ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJaarakAccusedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for area kas_m23ab.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetJaarakAccusedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for area kas_m23ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPoachersDeadGlobal()\r\n{\r\n\treturn GetGlobalNumber("kas_PoachersDead");\r\n}\r\n\r\nvoid SetPoachersDeadGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("kas_PoachersDead", bValue);\r\n\r\n    return;\r\n}\r\n\r\nint GetEmittersOffGlobal()\r\n{\r\n\treturn GetGlobalNumber("kas_EmittersOff");\r\n}\r\n\r\nvoid SetEmittersOffGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("kas_EmittersOff", bValue);\r\n\r\n    return;\r\n}\r\n\r\nint GetPoacherJobLocal()\r\n{\r\n\t// This was changed from a local to a global because I needed to turn\r\n\t// all tach in kas_m24aa and kas_m25aa hostile.\r\n\r\n    return GetGlobalBoolean("kas_PoacherJob");\r\n}\r\n\r\nvoid SetPoacherJobLocal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("kas_PoacherJob", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPoacherThreatenLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the officer in area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetPoacherThreatenLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the officer in area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPoacherRunLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the officer in area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetPoacherRunLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the officer in area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPoacherAlarmLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for each guard in area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetPoacherAlarmLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for each guard in area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetDesertLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for each guard in area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetDesertLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for each guard in area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetDroidNorthLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the busted droid in area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetDroidNorthLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the busted droid in area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGuardThreatenedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the guard at the exit to area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetGuardThreatenedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the guard at the exit to area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetScientistThreatenedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the sceintist in area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetScientistThreatenedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the sceintist in area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\n\r\nint GetDroidSouthLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the busted droid in area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetDroidSouthLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the busted droid in area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetWorrroznorRewardLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Worrroznor in area kas_m23ac.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetWorrroznorRewardLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Worrroznor in area kas_m23ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetKashyyykPazaakPlayedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Pazzak on alien player in the area kas_m22aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetKashyyykPazaakPlayedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Pazzak on alien player in the area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetKashyyykLostLastGameLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Pazzak on alien player in the area kas_m22aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetKashyyykLostLastGameLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Pazzak on alien player in the area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetToldOfKashyyykPazaakLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Pazzak on alien player in the area kas_m22aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetToldOfKashyyykPazaakLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Pazzak on alien player in the area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetAskDehnoLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Captain Dehno in area kas_m22ab.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetAskDehnoLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Captain Dehno in area kas_m22ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetDehnoPaidLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Captain Dehno in area kas_m22ab.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetDehnoPaidLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Captain Dehno in area kas_m22ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetChorrawlMadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Chorrawl in area kas_m22ab.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetChorrawlMadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Chorrawl in area kas_m22ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetDroidShutdownLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the supply droid in area kas_m22ab.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetDroidShutdownLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the supply droid in area kas_m22ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetEliSaidKoltoLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the Eli in area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetEliSaidKoltoLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the Eli in area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetEliSaidKorribanLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the Eli in area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetEliSaidKorribanLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the Eli in area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetEliSaidSwoopLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for the Eli in area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetEliSaidSwoopLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for the Eli in area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetEliDeadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the Matton Dasol in area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetEliDeadLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the Matton Dasol in area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetMattonShopLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the Matton Dasol in area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetMattonShopLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the Matton Dasol in area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetWookieeGuardZaalbarLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the wookiee guard in area kas_m22ab.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetWookieeGuardZaalbarLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the wookiee guard in area kas_m22ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\n\r\nint GetMattonGaveReward()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the Matton Dasol in area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetMattonGaveReward(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the Matton Dasol in area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetMattonLeaveShopLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for the Matton Dasol in area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetMattonLeaveShopLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for the Matton Dasol in area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetEmitterShutdown()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the emitters in area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetEmitterShutdown(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the emitters in area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetEmitterDamagedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the emitters in area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetEmitterDamagedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the emitters in area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetForceFieldOpenLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_10 for the forcefield in area kas_m24aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_10);\r\n}\r\n\r\nvoid SetForceFieldOpenLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_10 for the forcefield in area kas_m24aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_10, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetWookieHealedLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area kas_m25aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetWookieHealedLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area kas_m25aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetAngryTachLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the area kas_m25aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetAngryTachLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the area kas_m25aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFreyyrJobLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the area kas_m25aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetFreyyrJobLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the area kas_m25aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetZaalbarTalk1Local(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetZaalbarTalk1Local(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPartyTalk1Local(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetPartyTalk1Local(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetWookieRebelsLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetWookieRebelsLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\n\r\nint GetWookieCapturedLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for the area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetWookieCapturedLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for the area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetKomadSpawnLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for the area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_05);\r\n}\r\n\r\nvoid SetKomadSpawnLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for the area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_05, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetRebelFight1Local(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for the area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_06);\r\n}\r\n\r\nvoid SetRebelFight1Local(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for the area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_06, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetRebelFight2Local(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_07 for the area kas_m22aa.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_07);\r\n}\r\n\r\nvoid SetRebelFight2Local(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_07 for the area kas_m22aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_07, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetZaalbarTalk2Local(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area kas_m22ab.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetZaalbarTalk2Local(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area kas_m22ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPartyTalk2Local(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the area kas_m22ab.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetPartyTalk2Local(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the area kas_m22ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetWookieRebels2Local(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the area kas_m22ab.\r\n\r\n\treturn UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetWookieRebels2Local(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the area kas_m22ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetChorrawlFightLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for the area kas_m22ab.\r\n\r\n\treturn UT_GetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetChorrawlFightLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for the area kas_m22ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n\t\tUT_SetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}', 'k_inc_lev': b'//::///////////////////////////////////////////////\r\n//:: k_inc_lev\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n  include file for leviathan\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 26, 2002\r\n//:://////////////////////////////////////////////\r\n#include "k_inc_debug"\r\n#include "k_inc_utility"\r\n//mark an object for cleanup by the LEV_CleanupDeadObjects function\r\nvoid LEV_MarkForCleanup(object obj);\r\n\r\n//destroy all objects whose PLOT_10 flag has been set\r\nvoid LEV_CleanupDeadObjects(object oArea);\r\n\r\n//mark object for cleanup and move to nearest exit\r\nvoid LEV_LeaveArea(object obj = OBJECT_SELF, int bRun = FALSE);\r\n\r\n//fill container with treasure from table\r\nvoid LEV_AddTreasureToContainer(object oContainer,int iTable,int iAmount);\r\n\r\n//strip inventory from oTarget and put it in oDest\r\nvoid LEV_StripCharacter(object oTarget,object oDest);\r\n\r\n//::///////////////////////////////////////////////\r\n//:: LEV_MarkForCleanup\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//mark an object for cleanup by the TAR_CleanupDeadObjects function\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 26, 2002\r\n//:://////////////////////////////////////////////\r\nvoid LEV_MarkForCleanup(object obj)\r\n{\r\n  UT_SetPlotBooleanFlag(obj,SW_PLOT_BOOLEAN_10,TRUE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: LEV_CleanupDeadObjects\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//destroy all objects whose PLOT_10 flag has been set\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 15, 2002\r\n//:://////////////////////////////////////////////\r\nvoid LEV_CleanupDeadObjects(object oArea)\r\n{\r\n  object obj;\r\n\r\n  obj = GetFirstObjectInArea(oArea);\r\n  //Db_PostString("START CLEANUP...",5,7,5.0);\r\n  while(GetIsObjectValid(obj))\r\n  {\r\n    //Db_PostString("FOUND OBJ",5,6,5.0);\r\n    if(UT_GetPlotBooleanFlag(obj,SW_PLOT_BOOLEAN_10))\r\n    {\r\n      //Db_PostString("CLEANING UP OBJECT",5,5,5.0);\r\n      DestroyObject(obj);\r\n    }\r\n    obj = GetNextObjectInArea(oArea);\r\n  }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: LEV_LeaveArea\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//mark object for cleanup and move to nearest exit\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 26, 2002\r\n//:://////////////////////////////////////////////\r\nvoid LEV_LeaveArea(object obj = OBJECT_SELF, int bRun = FALSE)\r\n{\r\n  object oExit = GetNearestObjectByTag("plev_wpnpcext");\r\n\r\n  LEV_MarkForCleanup(obj);\r\n  if(GetIsObjectValid(oExit))\r\n  {\r\n    UT_PlotMoveObject(oExit,bRun);\r\n  }\r\n}\r\n\r\n//fill container with treasure from table\r\nvoid LEV_AddTreasureToContainer(object oContainer,int iTable,int iAmount)\r\n{\r\n  int i;\r\n\r\n  if(!GetIsObjectValid(oContainer))\r\n  {\r\n    return;\r\n  }\r\n\r\n  for(i = 0;i < iAmount;i++)\r\n  {\r\n    switch(iTable)\r\n    {\r\n    case 0:\r\n      switch(Random(3))\r\n      {\r\n      case 0:\r\n        CreateItemOnObject("G_I_CREDITS001",oContainer,Random(30) + 10);\r\n        break;\r\n      case 1:\r\n        CreateItemOnObject("G_I_DRDREPEQP002",oContainer);\r\n        break;\r\n      case 2:\r\n        CreateItemOnObject("G_I_MEDEQPMNT04",oContainer);\r\n        break;\r\n      default:\r\n        CreateItemOnObject("G_I_MEDEQPMNT02",oContainer);\r\n      }\r\n      break;\r\n    }\r\n  }\r\n}\r\n\r\nvoid LEV_StripCharacter(object oTarget,object oDest)\r\n{\r\n  object oItem;\r\n\r\n  if(!GetIsObjectValid(oTarget) || !GetIsObjectValid(oDest))\r\n  {\r\n    return;\r\n  }\r\n  \r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_BELT,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_BODY,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_HANDS,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_HEAD,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_IMPLANT,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_LEFTARM,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_LEFTWEAPON,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_RIGHTARM,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_RIGHTWEAPON,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  \r\n  oItem = GetFirstItemInInventory(oTarget);\r\n  while(GetIsObjectValid(oItem))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n    oItem = GetFirstItemInInventory(oTarget);\r\n  }\r\n}\r\n', 'k_inc_man': b'//:: Name\r\n/*\r\n     Desc\r\n*/\r\n//:: Created By:\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n\r\n#include "k_inc_generic"\r\n#include "k_inc_utility"\r\n\r\nint SHIP_TAKEOFF_CUTSCENE = 1;\r\nint SHIP_LANDING_CUTSCENE = 2;\r\nint NONE = 0;\r\nint QUEEDLE = 1;\r\nint CASSANDRA = 2;\r\nint JAX = 3;\r\nint QUEEDLE_CHAMP = 4;\r\n\r\nint QUEEDLE_TIME = 3012;\r\nint CASSANDRA_TIME = 2702;\r\nint JAX_TIME = 2548;\r\nint CHAMP_TIME = 2348;\r\n\r\nint PLOT_HARVEST_STOPPED = 3;\r\nint PLOT_KOLTO_DESTROYED = 4;\r\n\r\n//effect EFFECT_STEAM = EffectDamage(15);\r\nint STEAM_DAMAGE_AMOUNT = 25;\r\nstring RACE_DEFAULT = GetStringByStrRef(32289);\r\nstring STEAM_PLACEABLE = "man27_visstm0";\r\nstring ROLAND_TAG = "man26_repdip";\r\nvoid PlaceShip(string sTag,location lLoc);\r\n\r\nvoid RemoveShip(string sTag);\r\n\r\nvoid PlaceNPC(string sTag);\r\n\r\n// switches current player models to envirosuit models.\r\nvoid DonSuits();\r\n\r\n// switches the envirosuit model back to the regular player models\r\nvoid RemoveSuits();\r\n\r\n// deactivates all turrets on the map with the corresponding tag\r\n// if no tag is given it will default to the tag of the calling object\r\nvoid DeactivateTurrets(string sTag = "");\r\n\r\n//used to make a given condition only fire once\r\n//***note uses SW_PLOT_BOOLEAN_10***\r\nint HasNeverTriggered();\r\n\r\n// Sets a global to track who the player is racing\r\nvoid SetOpponent(int nOpponent);\r\n\r\n//Returns thte current race opponent\r\nint GetOpponent();\r\n\r\n//Sets a cutom token in racetime format\r\nvoid SetTokenRaceTime(int nToken, int nRacerTime);\r\n\r\n//returns the main plot global for Manaan\r\nint GetManaanMainPlotVariable();\r\n\r\n// returns true if poison has been released if the Hrakert rift\r\nint KoltoDestroyed();\r\n\r\n// Removes instances and deactives Selkath encounters\r\nvoid ClearSelkathFromThisLevel();\r\n\r\n// Opens the water door based on the tag og the button\r\nvoid OpenAssociatedDoor();\r\n\r\n// Closes the water door based on the tag og the button\r\nvoid CloseAssociatedDoor();\r\n\r\n// returns the state of a water room TRUE == full\r\nint GetRoomFull(string sRoom);\r\n\r\n// sets the water room to nValue\r\nvoid SetRoomFull(string sRoom, int nValue);\r\n\r\n// CLoses all water doors\r\nvoid CloseAllWaterDoors();\r\n\r\n//checks if there is water on either side of the door, if not the door opens\r\nvoid OpenWaterDoor(string sRoom1,string sRoom2 = "");\r\n\r\n//switches water filled rooms accross the corridor\r\nvoid SwitchWaterRooms();\r\n\r\n//returns True if the steam vent is active\r\nint GetIsVentActive(object oVent = OBJECT_SELF);\r\n\r\n//sets the state of the Vent and playes the appropriate animation\r\nvoid SetVentActive(int bState,object oVent = OBJECT_SELF);\r\n\r\n// Gives the correct readout for the various water displays\r\nvoid ActivateWaterDisplays(string sRoom,int nValue);\r\n\r\n//plays the required looping animation for the injecter display\r\nvoid PlayInjecterAnimation(int nLevel);\r\n\r\n//plays the required looping animation for the container display\r\nvoid PlayContainerAnimation(int nLevel);\r\n\r\n//initates the sitting animations for the sitting placeables\r\nvoid InitiateSitters();\r\n\r\n// returns true if the staramp was found on Manaan\r\nint GetManaanStarMapFound();\r\n\r\n//Turns off AI on party members (if any) for curscene purposes\r\nvoid TurnOffPartyAI();\r\n\r\n//Turns on AI on party members (if any)\r\nvoid TurnOnPartyAI();\r\n\r\n//roland is in post plot state uses SW_PLOT_BOOLEAN05\r\nint GetRolandIsPostPlot();\r\n\r\n//toggles the post plot state of Roland\r\nvoid SetRolandIsPostPlot(int nValue);\r\n\r\n//returns the plot global for the missing Selkath youth plot\r\n//used primarily by Shealas(manm26ab) and Sasha (man27aa)\r\nint GetMissingSelkathPlotVariable();\r\n\r\n//Sets the plot global for the missing Selkath youth plot\r\n//used primarily by Shealas(manm26ab) and Sasha (man27aa)\r\nvoid SetMissingSelkathPlotVariable(int nValue);\r\n\r\n// returns true if Sasha has been killed\r\nint GetIsSashaDead();\r\n\r\n// Sets the variable tracking wheather Sasha is alive\r\nvoid SetIsSashaDead();\r\n////////////////////////////////////////////////////////////////////////////////\r\nvoid RemoveShip(string sTag)\r\n{\r\n    object oShip = GetObjectByTag(sTag);\r\n    if(GetIsObjectValid(oShip))\r\n    {\r\n        DestroyObject(oShip);\r\n    }\r\n}\r\n\r\nvoid PlaceShip(string sTag,location lLoc)\r\n{\r\n    object oShip = GetObjectByTag(sTag);\r\n    if(GetIsObjectValid(oShip) == FALSE)\r\n    {\r\n        CreateObject(OBJECT_TYPE_PLACEABLE,sTag,lLoc);\r\n    }\r\n}\r\n\r\nvoid PlaceNPC(string sTag)\r\n{\r\n    if(!GetIsObjectValid(GetObjectByTag(sTag)))\r\n    {\r\n        CreateObject(OBJECT_TYPE_CREATURE,sTag,GetLocation(GetObjectByTag("POST_" + sTag)));\r\n    }\r\n}\r\nvoid DonSuits()\r\n{\r\n    object oPC;\r\n    int nMax = GetPartyMemberCount();\r\n    int nIdx;\r\n    effect eChange = EffectDisguise(DISGUISE_TYPE_ENVIRONMENTSUIT);\r\n    for(nIdx = 0;nIdx < nMax; nIdx++)\r\n    {\r\n        ApplyEffectToObject(DURATION_TYPE_PERMANENT,eChange,GetPartyMemberByIndex(nIdx));\r\n    }\r\n}\r\n\r\nvoid RemoveSuits()\r\n{\r\n    int nDisguize = EFFECT_TYPE_DISGUISE;//replace with effect constant\r\n    object oPC;\r\n    effect eEffect;\r\n    int nMax = GetPartyMemberCount();\r\n    int nIdx;\r\n    for(nIdx = 0;nIdx < nMax; nIdx++)\r\n    {\r\n        oPC = GetPartyMemberByIndex(nIdx);\r\n        eEffect = GetFirstEffect(oPC);\r\n        while(GetIsEffectValid(eEffect))\r\n        {\r\n            if(GetEffectType(eEffect) == nDisguize)\r\n            {\r\n                RemoveEffect(oPC,eEffect);\r\n            }\r\n            eEffect = GetNextEffect(oPC);\r\n        }\r\n    /*  if(GetTag(oPC) == "Bastila")\r\n        {\r\n            ApplyEffectToObject(DURATION_TYPE_PERMANENT,EffectDisguise(4),oPC);\r\n        }\r\n        if(GetTag(oPC) == "Carth")\r\n        {\r\n            ApplyEffectToObject(DURATION_TYPE_PERMANENT,EffectDisguise(6),oPC);\r\n        }*/\r\n    }\r\n}\r\n\r\nvoid DeactivateTurrets(string sTag = "")\r\n{\r\n    if(sTag == "")\r\n    {\r\n        sTag = GetTag(OBJECT_SELF);\r\n    }\r\n    int nNth = 0;\r\n    object oTurret = GetObjectByTag(sTag,nNth);\r\n    while(GetIsObjectValid(oTurret))\r\n    {\r\n        if(oTurret != OBJECT_SELF &&\r\n           GetObjectType(oTurret) == OBJECT_TYPE_CREATURE)\r\n        {\r\n            ChangeToStandardFaction(oTurret,STANDARD_FACTION_NEUTRAL);\r\n        }\r\n        nNth++;\r\n        oTurret = GetObjectByTag(sTag,nNth);\r\n    }\r\n}\r\n\r\n//This global indicates that Hukta threatened player\r\nint GetHuktaThreatenedPlayerGlobal()\r\n{\r\n    return GetGlobalBoolean("man_HuktaThreatened");\r\n}\r\n\r\nvoid SetHuktaThreatenedPlayerGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("man_HuktaThreatened", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\n//This global indicates that the player lost his last race\r\nint GetPlayerLostLastRaceGlobal()\r\n{\r\n    return GetGlobalBoolean("man_PlayerLostLast");\r\n}\r\n\r\nvoid SetPlayerLostLastRaceGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("man_PlayerLostLast", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\n//This global measures the state of the swoop races on Manaan\r\nint GetManaanRaceStateGlobal()\r\n{\r\n    return GetGlobalNumber("man_ManaanRaceState");\r\n}\r\n\r\nvoid SetManaanRaceStateGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("man_ManaanRaceState", bValue);\r\n\r\n    return;\r\n}\r\n\r\n//This global measures the state of Queedle during the swoop races on Manaan\r\nint GetQueedleStateGlobal()\r\n{\r\n    return GetGlobalNumber("tat_QueedleState");\r\n}\r\n\r\nvoid SetQueedleStateGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("tat_QueedleState", bValue);\r\n\r\n    return;\r\n}\r\n\r\n//This global indicates that player gave money to Queedle\r\nint GetQueedleUpgradeGlobal()\r\n{\r\n    return GetGlobalBoolean("man_QueedleUpgrade");\r\n}\r\n\r\nvoid SetQueedleUpgradeGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("man_QueedleUpgrade", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\n//This global indicates that player has angered Hukta by winning against him\r\nint GetHuktaMadGlobal()\r\n{\r\n    return GetGlobalBoolean("man_HuktaMad");\r\n}\r\n\r\nvoid SetHuktaMadGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("man_HuktaMad", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\nint GetPlayerNotPaidLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Race Coordinator in the area man_26ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetPlayerNotPaidLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Race Coordinator in the area man_26ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetObjectByTag("man26_swpreg"), SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n}\r\n\r\nint GetPlayerPersuadedOnceLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Race Coordinator in the area man_26ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetPlayerPersuadedOnceLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Race Coordinator in the area man_26ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n}\r\n\r\nint GetCasandraMadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Casandra in the area man_26ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetCasandraMadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Casandra in the area man_26ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n}\r\n\r\nint GetToldCasandraNameLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Casandra in the area man_26ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetToldCasandraNameLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Casandra in the area man_26ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n}\r\n\r\n\r\nint GetToldHuktaNameLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Hukta in the area man_26ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetToldHuktaNameLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Hukta in the area man_26ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n}\r\n\r\nint GetQueedleMadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Queedle in the area man_26ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetQueedleMadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Queedle in the area man_26ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n}\r\n\r\nint GetToldQueedleNameLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Queedle in the area man_26ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetToldQueedleNameLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Queedle in the area man_26ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n}\r\n\r\nint GetQueedleLeavingLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Queedle in the area man_26ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetQueedleLeavingLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Queedle in the area man_26ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n}\r\n\r\nint GetQueedleToldAboutMoneyLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for Queedle in the area man_26ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetQueedleToldAboutMoneyLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for Queedle in the area man_26ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n}\r\n\r\nint GetQueedleGaveMoneyBackLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for Queedle in the area man_26ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_05);\r\n}\r\n\r\nvoid SetQueedleGaveMoneyBackLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for Queedle in the area man_26ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_05, bValue);\r\n    }\r\n}\r\n\r\nint GetSwoopStoreInitialLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Yortal in the area man_26ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetSwoopStoreInitialLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Yortal in the area man_26ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n}\r\n\r\nint GetSwoopSithMadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for swoop sith in the area man_26ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetSwoopSithMadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for swoop sith in the area man_26ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n}\r\n\r\nint GetSecondSwoopSithMadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for second swoop sith in the area man_26ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetSecondSwoopSithMadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for second swoop sith in the area man_26ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n}\r\n\r\nint HasNeverTriggered()\r\n{\r\n    int bReturn;\r\n    if(UT_GetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_10) == FALSE)\r\n    {\r\n        bReturn = TRUE;\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_10,TRUE);\r\n    }\r\n    return bReturn;\r\n}\r\n\r\n\r\nvoid SetOpponent(int nOpponent)\r\n{\r\n    SetGlobalNumber("MAN_SWOOP_OPP",nOpponent);\r\n}\r\n\r\nint GetOpponent()\r\n{\r\n    return GetGlobalNumber("MAN_SWOOP_OPP");\r\n}\r\n\r\nvoid SetTokenRaceTime(int nToken, int nRacerTime)\r\n{\r\n    // calculate the time components\r\n    int nMinutes = nRacerTime/6000;\r\n    int nSeconds = (nRacerTime - (nMinutes * 6000)) / 100;\r\n    int nFractions =  nRacerTime - ((nMinutes * 6000) + (nSeconds * 100));\r\n\r\n    //building the time string\r\n    string sTime = IntToString(nMinutes) + ":";\r\n    if (nSeconds < 10)\r\n    {\r\n        sTime = sTime + "0";\r\n    }\r\n    sTime = sTime + IntToString(nSeconds) + ":";\r\n    if(nFractions < 10)\r\n    {\r\n        sTime = sTime + "0";\r\n    }\r\n    sTime = sTime + IntToString(nFractions);\r\n    SetCustomToken(nToken,sTime);\r\n\r\n}\r\n\r\n\r\nvoid DestroyFish(object oArea)\r\n{\r\n    object oFish = GetFirstObjectInArea(oArea,OBJECT_TYPE_PLACEABLE);\r\n    while (GetIsObjectValid(oFish))\r\n    {\r\n        string sTag = GetTag(oFish);\r\n        string sPlaceable = GetStringLeft(sTag,10);\r\n        if (sPlaceable == "FirixaFish")\r\n        {\r\n            DestroyObject(oFish);\r\n        }\r\n        oFish = GetNextObjectInArea(oArea,OBJECT_TYPE_PLACEABLE);\r\n    }\r\n  /*  object oCreature = GetFirstObjectInArea(oArea);\r\n    while (GetIsObjectValid(oCreature))\r\n    {\r\n        if(GetRacialType(oCreature) == RACIAL_TYPE_HUMAN)\r\n        {\r\n            DestroyObject(oCreature);\r\n        }\r\n        oCreature =GetNextObjectInArea(oArea);\r\n    }\r\n    object oEnc = GetFirstObjectInArea(oArea,OBJECT_TYPE_ENCOUNTER);\r\n    while (GetIsObjectValid(oEnc))\r\n    {\r\n        SetEncounterActive(FALSE,oEnc);\r\n        oEnc = GetNextObjectInArea(oArea,OBJECT_TYPE_ENCOUNTER);\r\n    } */\r\n}\r\n\r\nint GetManaanMainPlotVariable()\r\n{\r\n    return GetGlobalNumber("MAN_PLANET_PLOT");\r\n}\r\n\r\nint KoltoDestroyed()\r\n{\r\n    return GetGlobalNumber("MAN_PLANET_PLOT") == PLOT_KOLTO_DESTROYED;\r\n}\r\n\r\nvoid ClearSelkathFromThisLevel()\r\n{\r\n    string sTag = "man28_inssel";\r\n    int nLength = GetStringLength(sTag);\r\n    object oSelkath = GetFirstObjectInArea(OBJECT_SELF,OBJECT_TYPE_ALL);\r\n    while(GetIsObjectValid(oSelkath))\r\n    {\r\n        if(GetObjectType(oSelkath) == OBJECT_TYPE_CREATURE)\r\n        {\r\n            if(GetStringLeft(GetTag(oSelkath),nLength) == sTag)\r\n            {\r\n                DelayCommand(0.1,DestroyObject(oSelkath,0.0,TRUE));\r\n            }\r\n\r\n        }\r\n        if(GetObjectType(oSelkath) == OBJECT_TYPE_ENCOUNTER)\r\n        {\r\n            if(GetEncounterActive(oSelkath))\r\n            {\r\n                SetEncounterActive(FALSE,oSelkath);\r\n            }\r\n        }\r\n        oSelkath = GetNextObjectInArea(OBJECT_SELF,OBJECT_TYPE_ALL);\r\n    }\r\n}\r\n\r\nvoid OpenAssociatedDoor()\r\n{\r\n    string sNum = GetStringRight(GetTag(OBJECT_SELF),1);\r\n    object oDoor = GetObjectByTag("man27_h2o0" + sNum);\r\n    AssignCommand(oDoor,ActionOpenDoor(oDoor));\r\n}\r\n\r\nvoid CloseAssociatedDoor()\r\n{\r\n    string sNum = GetStringRight(GetTag(OBJECT_SELF),1);\r\n    object oDoor = GetObjectByTag("man27_h2o0" + sNum);\r\n    AssignCommand(oDoor,ActionCloseDoor(oDoor));\r\n}\r\n\r\nint GetRoomFull(string sRoom)\r\n{\r\n\r\n    int bFilled = FALSE;\r\n    if(sRoom != "")\r\n    {\r\n        bFilled = GetGlobalBoolean("MAN_WATER_" + sRoom);\r\n    }\r\n    return bFilled;\r\n}\r\n\r\nvoid SetRoomFull(string sRoom, int nValue)\r\n{\r\n    if (GetRoomFull(sRoom) != nValue)\r\n    {\r\n        SetGlobalBoolean("MAN_WATER_" + sRoom,nValue);\r\n        ActivateWaterDisplays(sRoom,nValue);\r\n    }\r\n}\r\n\r\nvoid CloseAllWaterDoors()\r\n{\r\n    object oDoor = GetFirstObjectInArea(GetArea(OBJECT_SELF),OBJECT_TYPE_DOOR);\r\n    while(GetIsObjectValid(oDoor))\r\n    {\r\n        if(GetStringLeft(GetTag(oDoor),9) == "man27_h2o")\r\n        {\r\n            AssignCommand(oDoor,ActionCloseDoor(oDoor));\r\n        }\r\n        oDoor = GetNextObjectInArea(GetArea(OBJECT_SELF),OBJECT_TYPE_DOOR);\r\n    }\r\n}\r\n\r\nvoid OpenWaterDoor(string sRoom1,string sRoom2 = "")\r\n{\r\n    if(!GetRoomFull(sRoom1) && !GetRoomFull(sRoom2))\r\n    {\r\n        ActionOpenDoor(OBJECT_SELF);\r\n    }\r\n    else\r\n    {\r\n        BarkString(GetPartyMemberByIndex(0),32128);\r\n    }\r\n}\r\n\r\nvoid SwitchWaterRooms()\r\n{\r\n        if (GetRoomFull("A"))\r\n    {\r\n        SetRoomFull("A",FALSE);\r\n        SetRoomFull("B",TRUE);\r\n    }\r\n    else if(GetRoomFull("B"))\r\n    {\r\n        SetRoomFull("A",TRUE);\r\n        SetRoomFull("B",FALSE);\r\n    }\r\n    if (GetRoomFull("C"))\r\n    {\r\n        SetRoomFull("C",FALSE);\r\n        SetRoomFull("D",TRUE);\r\n    }\r\n    else if(GetRoomFull("D"))\r\n    {\r\n        SetRoomFull("C",TRUE);\r\n        SetRoomFull("D",FALSE);\r\n    }\r\n    if (GetRoomFull("E"))\r\n    {\r\n        SetRoomFull("E",FALSE);\r\n        SetRoomFull("F",TRUE);\r\n    }\r\n    else if(GetRoomFull("F"))\r\n    {\r\n        SetRoomFull("E",TRUE);\r\n        SetRoomFull("F",FALSE);\r\n    }\r\n}\r\n\r\nint GetIsVentActive(object oVent = OBJECT_SELF)\r\n{\r\n    return UT_GetPlotBooleanFlag(oVent,SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetVentActive(int bState,object oVent = OBJECT_SELF)\r\n{\r\n    int nNth = 0;\r\n    object oSteam = GetObjectByTag(STEAM_PLACEABLE + GetStringRight(GetTag(oVent),1),nNth );\r\n    while(GetIsObjectValid(oSteam))\r\n    {\r\n        if(bState)\r\n        {\r\n            //AurPostString(GetTag(oVent) + " on",5,5 + StringToInt(GetStringRight(GetTag(oVent),1)),5.0f);\r\n            AssignCommand(oSteam,PlayAnimation(ANIMATION_PLACEABLE_ACTIVATE));\r\n        }\r\n        else\r\n        {\r\n            AssignCommand(oSteam,PlayAnimation(ANIMATION_PLACEABLE_DEACTIVATE));\r\n        }\r\n        nNth++;\r\n        oSteam = GetObjectByTag(STEAM_PLACEABLE + GetStringRight(GetTag(oVent),1),nNth );\r\n    }\r\n    UT_SetPlotBooleanFlag(oVent,SW_PLOT_BOOLEAN_04,bState);\r\n\r\n}\r\n\r\nvoid ActivateWaterDisplays(string sRoom,int nValue)\r\n{\r\n    int nNth = 0;\r\n    object oDisplay = GetObjectByTag("man27_waterlvl" + sRoom,nNth);\r\n    while (GetIsObjectValid(oDisplay))\r\n    {\r\n        if(nValue)\r\n        {\r\n            AssignCommand(oDisplay,ActionPlayAnimation(ANIMATION_PLACEABLE_ACTIVATE));\r\n        }\r\n        else\r\n        {\r\n            AssignCommand(oDisplay,ActionPlayAnimation(ANIMATION_PLACEABLE_DEACTIVATE));\r\n        }\r\n        nNth++;\r\n        oDisplay = GetObjectByTag("man27_waterlvl" + sRoom,nNth);\r\n    }\r\n}\r\n\r\nvoid PlayInjecterAnimation(int nLevel)\r\n{\r\n    int nAnim;\r\n    object oInjector = GetObjectByTag("man28_inject");\r\n    if(nLevel == 0)\r\n    {\r\n        nAnim = ANIMATION_PLACEABLE_ANIMLOOP04;\r\n    }\r\n    else if(nLevel == 1)\r\n    {\r\n        nAnim = ANIMATION_PLACEABLE_ANIMLOOP03;\r\n    }\r\n    else if(nLevel == 2)\r\n    {\r\n        nAnim = ANIMATION_PLACEABLE_ANIMLOOP02;\r\n    }\r\n    else if(nLevel >= 3)\r\n    {\r\n        nAnim = ANIMATION_PLACEABLE_ANIMLOOP01;\r\n    }\r\n    AssignCommand(oInjector, ActionPlayAnimation(nAnim));\r\n}\r\n\r\nvoid PlayContainerAnimation(int nLevel)\r\n{\r\n    int nAnim;\r\n    object oInjector = GetObjectByTag("man28_contain");\r\n    if(nLevel == 0)\r\n    {\r\n       //AurPostString("level 0",5,5,5.0);\r\n        nAnim = ANIMATION_PLACEABLE_ANIMLOOP06;\r\n    }\r\n    else if(nLevel == 1)\r\n    {\r\n        nAnim = ANIMATION_PLACEABLE_ANIMLOOP05;\r\n    }\r\n    else if(nLevel == 2)\r\n    {\r\n        nAnim = ANIMATION_PLACEABLE_ANIMLOOP04;\r\n    }\r\n    else if(nLevel == 3)\r\n    {\r\n        nAnim = ANIMATION_PLACEABLE_ANIMLOOP03;\r\n    }\r\n    else if(nLevel == 4)\r\n    {\r\n        nAnim = ANIMATION_PLACEABLE_ANIMLOOP02;\r\n    }\r\n    else if(nLevel >= 3)\r\n    {\r\n        nAnim = ANIMATION_PLACEABLE_ANIMLOOP01;\r\n    }\r\n    AssignCommand(oInjector, ActionPlayAnimation(nAnim));\r\n}\r\n\r\nvoid InitiateSitters()\r\n{\r\n    int nNth = 0;\r\n    object oPlaceable = GetObjectByTag("man_drinking",nNth);\r\n    while (GetIsObjectValid(oPlaceable))\r\n    {\r\n        AssignCommand(oPlaceable,ActionPlayAnimation(ANIMATION_PLACEABLE_ANIMLOOP02));\r\n        nNth++;\r\n        oPlaceable = GetObjectByTag("man_drinking",nNth);\r\n    }\r\n    nNth = 0;\r\n    oPlaceable = GetObjectByTag("man_cards",nNth);\r\n    while (GetIsObjectValid(oPlaceable))\r\n    {\r\n        AssignCommand(oPlaceable,ActionPlayAnimation(ANIMATION_PLACEABLE_ANIMLOOP03));\r\n        nNth++;\r\n        oPlaceable = GetObjectByTag("man_cards",nNth);\r\n    }\r\n    nNth = 0;\r\n    oPlaceable = GetObjectByTag("man_sitting",nNth);\r\n    while (GetIsObjectValid(oPlaceable))\r\n    {\r\n        AssignCommand(oPlaceable,ActionPlayAnimation(ANIMATION_PLACEABLE_ANIMLOOP01));\r\n        nNth++;\r\n        oPlaceable = GetObjectByTag("man_sitting",nNth);\r\n    }\r\n}\r\n\r\nint GetManaanStarMapFound()\r\n{\r\n    return GetGlobalBoolean("MAN_STARMAP_FOUND");\r\n}\r\n\r\nvoid TurnOffPartyAI()\r\n{\r\n    int nIdx;\r\n    object oNPC;\r\n    for(nIdx = 0; nIdx <= 2; nIdx++)\r\n    {\r\n       oNPC = GetPartyMemberByIndex(nIdx);\r\n       if(GetIsObjectValid(oNPC) &&\r\n          GetFirstPC() != oNPC)\r\n       {\r\n            ExecuteScript("k_pman_aioff",oNPC);\r\n\r\n       }\r\n    }\r\n}\r\n\r\nvoid TurnOnPartyAI()\r\n{\r\n    int nIdx;\r\n    object oNPC;\r\n    for(nIdx = 0; nIdx <= 2; nIdx++)\r\n    {\r\n       oNPC = GetPartyMemberByIndex(nIdx);\r\n       if(GetIsObjectValid(oNPC) &&\r\n          GetFirstPC() != oNPC)\r\n       {\r\n            ExecuteScript("k_pman_aion",oNPC);\r\n\r\n       }\r\n    }\r\n}\r\n\r\nint GetRolandIsPostPlot()\r\n{\r\n    object oRoland = GetObjectByTag(ROLAND_TAG);\r\n    int nReturn;\r\n    if(GetIsObjectValid(oRoland))\r\n    {\r\n        nReturn = UT_GetPlotBooleanFlag(oRoland,SW_PLOT_BOOLEAN_05);\r\n    }\r\n    else\r\n    {\r\n        nReturn = FALSE;\r\n    }\r\n    return nReturn;\r\n}\r\n\r\nvoid SetRolandIsPostPlot(int nValue)\r\n{\r\n    object oRoland = GetObjectByTag(ROLAND_TAG);\r\n    if(GetIsObjectValid(oRoland))\r\n    {\r\n        UT_SetPlotBooleanFlag(oRoland,SW_PLOT_BOOLEAN_05,nValue);\r\n    }\r\n}\r\n\r\nint GetMissingSelkathPlotVariable()\r\n{\r\n    return GetGlobalNumber("MAN_MISSING_PLOT");\r\n}\r\n\r\nvoid SetMissingSelkathPlotVariable(int nValue)\r\n{\r\n    SetGlobalNumber("MAN_MISSING_PLOT",nValue);\r\n}\r\n\r\nint GetIsSashaDead()\r\n{\r\n    return GetGlobalBoolean("MAN_KILLS_DONE");\r\n}\r\n\r\nvoid SetIsSashaDead()\r\n{\r\n    SetGlobalBoolean("MAN_KILLS_DONE",TRUE);\r\n}\r\n', 'k_inc_stunt': b'//:: Stunt/Render Include\r\n/*\r\n     This Include File runs\r\n     the stunt and cutscenes\r\n     for the game.\r\n*/\r\n//:: Created By: Preston Watamaniuk\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n\r\n//INDIVIDUAL STUNT MODULE CALLS ******************************************************************************************************\r\n\r\n//LEV_A: Pulled out of hyperspace by the Leviathan, load STUNT_16\r\nvoid ST_PlayLevCaptureStunt();\r\n//LEV_A: Capture by the Leviathan, load ebo_m40aa\r\nvoid ST_PlayLevCaptureStunt02();\r\n//Load Turret Module Opening 07_3\r\nvoid ST_PlayStuntTurret_07_3();\r\n//Plays the Bastila torture scene\r\nvoid ST_PlayBastilaTorture();\r\n//Load Turret Module Opening 07_4\r\nvoid ST_PlayStuntTurret_07_4();\r\n//Load Leviathan Bombardment Stunt_06 covered by Render 5\r\nvoid ST_PlayTarisEscape();\r\n//Load Stunt_07 covered by Render 6a and 05_1C\r\nvoid ST_PlayTarisEscape02();\r\n//Load the Fighter Mini-Game m12ab covered by Render 07_3\r\nvoid ST_PlayTarisEscape03();\r\n//Load Dantooine module covered by hyperspace and dant landing\r\nvoid ST_PlayDantooineLanding();\r\n//Leaving Dantooine for the first time, going to STUNT_12 covered by Dant takeoff and hyperspace\r\nvoid ST_PlayDantooineTakeOff();\r\n//Plays the correct vision based on the value of K_FUTURE_PLANET from a stunt module\r\nvoid ST_PlayVisionStunt();\r\n//Plays the correct vision based on the value of K_FUTURE_PLANET with a take-off\r\nvoid ST_PlayVisionStunt02();\r\n//Plays the starforge approach\r\nvoid ST_PlayStarForgeApproach();\r\n//Plays the Damage Ebon Hawk Stunt scene\r\nvoid ST_PlayStunt35();\r\n//Shows the crash landing on the Unknown World\r\nvoid ST_PlayUnknownWorldLanding();\r\n//Shows the take-off from the Unknown World\r\nvoid ST_PlayUnknownWorldTakeOff();\r\n//Landing on the Star Forge\r\nvoid ST_PlayStarForgeLanding();\r\n//Goes to the Leviathan Mini-Game covered by the Escape Render\r\nvoid ST_PlayLeviathanEscape01();\r\n\r\n//UBER FUNCTIONS *********************************************************************************************************************\r\n\r\n//This determines what to play after a Fighter Mini Game is run\r\nvoid ST_PlayPostTurret();\r\n//Play the appropriate take off render\r\nstring ST_GetTakeOffRender();\r\n//Play the appropriate landing render\r\nstring ST_GetLandingRender();\r\n//Plays the appropriate landing sequence for the chosen planet unless Lev or Star Forge\r\nvoid ST_PlayGenericLanding();\r\n//This determines what planet the PC is taking off of and plays the STUNT_14 in the appropriate manner\r\nvoid ST_PlayStunt14();\r\n//Checks if the planet designated as K_FUTURE_PLANET has had a vision played for it\r\nint ST_VisionPlayed();\r\n//With no cutscene between planets the game can go to a vision or straight to another planet.\r\nvoid ST_PlayPlanetToPlanet();\r\n//Play the transition from a vision to a particular planet.  This is only called at the end of a Vision STUNT_00\r\nvoid ST_PlayVisionLanding();\r\n//Fetches the correct Starmap Vision Render\r\nstring ST_GetStarmapVisionRender();\r\n//This gets the current planet that the character is on and determines what skybox to set for the Ebon Hawk.\r\nvoid ST_SetEbonHawkSkyBox();\r\n// Fetches the correct Starmap Vision Render for the planet the player is currently on\r\nstring ST_GetCurrentStarmapVisionRender();\r\n// Allows the Ebon Hawk to continue to the selected planet after the Leviathan unless that planet is Dantooine.\r\nvoid ST_PlayPostEbo_m40ad();\r\n\r\nvoid ST_MyPrintString(string sString);\r\nvoid ST_MyPostString(string sString);\r\n\r\n//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n////////////////// SINGLE STUNT/RENDER CALLS /////////////////////////////////////////////////////////////////////////////////\r\n//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n\r\n//Load Leviathan Bombardment Stunt_06 covered by Render 5\r\nvoid ST_PlayTarisEscape()\r\n{\r\n    StartNewModule("STUNT_06", "", "05");\r\n}\r\n//Load Stunt_07 covered by Render 6a and 05_1C\r\nvoid ST_PlayTarisEscape02()\r\n{\r\n    StartNewModule("STUNT_07", "", "06a", "05_1C");\r\n}\r\n//Load the Fighter Mini-Game m12ab covered by Render 07_3\r\nvoid ST_PlayTarisEscape03()\r\n{\r\n    SetGlobalNumber("K_TURRET_SKYBOX", 5);\r\n    StartNewModule("m12ab", "", "11a");\r\n}\r\n//Load Dantooine danm13 module covered by hyperspace and dant landing\r\nvoid ST_PlayDantooineLanding()\r\n{\r\n    SetGlobalNumber("K_CURRENT_PLANET", 15);\r\n    StartNewModule("danm13","","05_2A");\r\n}\r\n\r\n//LEV_A: Pulled out of hyperspace by the Leviathan, load STUNT_16\r\nvoid ST_PlayLevCaptureStunt()\r\n{\r\n    string sRender = ST_GetTakeOffRender();\r\n    SetGlobalNumber("K_CURRENT_PLANET", 40);\r\n    StartNewModule("STUNT_16", "",  sRender, "08");\r\n}\r\n//LEV_A: Capture by the Leviathan, load ebo_m40aa\r\nvoid ST_PlayLevCaptureStunt02()\r\n{\r\n    StartNewModule("ebo_m40aa","", "17");\r\n}\r\n//Plays the Bastila torture scene\r\nvoid ST_PlayBastilaTorture()\r\n{\r\n    StartNewModule("STUNT_18", "", ST_GetTakeOffRender(), "08");\r\n}\r\n//Load Turret Module Opening 07_3\r\nvoid ST_PlayStuntTurret_07_3()\r\n{\r\n    StartNewModule("m12ab","",  "11a");\r\n}\r\n//Load Turret Module Opening 07_4\r\nvoid ST_PlayStuntTurret_07_4()\r\n{\r\n    StartNewModule("m12ab","",  "11a");\r\n}\r\n//Leaving Dantooine for the first time\r\nvoid ST_PlayDantooineTakeOff()\r\n{\r\n    StartNewModule("STUNT_12","", "05_2C", "08");\r\n}\r\n//Plays the correct vision based on the value of K_FUTURE_PLANET\r\nvoid ST_PlayVisionStunt()\r\n{\r\n    StartNewModule("STUNT_00","", "07_1");\r\n}\r\n//Plays the correct vision based on the value of K_FUTURE_PLANET with a take-off\r\nvoid ST_PlayVisionStunt02()\r\n{\r\n    StartNewModule("STUNT_00","", ST_GetTakeOffRender(), "08");\r\n}\r\n//Plays the starforge approach\r\nvoid ST_PlayStarForgeApproach()\r\n{\r\n    StartNewModule("STUNT_34", "", "33");\r\n}\r\n//Plays the Damage Ebon Hawk Stunt scene\r\nvoid ST_PlayStunt35()\r\n{\r\n    StartNewModule("STUNT_35", "", "07_2");\r\n}\r\n//Shows the crash landing on the Unknown World\r\nvoid ST_PlayUnknownWorldLanding()\r\n{\r\n    SetGlobalNumber("K_CURRENT_PLANET", 45);\r\n    StartNewModule("ebo_m41aa","", "05_8A");\r\n}\r\n//Shows the take-off from the Unknown World\r\nvoid ST_PlayUnknownWorldTakeOff()\r\n{\r\n    /*\r\n        STUNT_44    05_8C   5_9 = DARK SIDE   1\r\n        STUNT_42    05_8C   5_9 = LIGHT SIDE  2\r\n    */\r\n    int nChoice = GetGlobalNumber("G_FINALCHOICE");\r\n    if(nChoice == 1)\r\n    {\r\n        StartNewModule("STUNT_44", "", "05_8C", "5_9");\r\n    }\r\n    else if(nChoice == 2)\r\n    {\r\n        StartNewModule("STUNT_42", "", "05_8C", "5_9");\r\n    }\r\n    if(nChoice == 1 || nChoice == 2)\r\n    {\r\n        SetGlobalNumber("K_KOTOR_MASTER", 60);\r\n    }\r\n}\r\n//Landing on the Star Forge\r\nvoid ST_PlayStarForgeLanding()\r\n{\r\n    StartNewModule("ebo_m12aa", "", "43");\r\n    SetGlobalNumber("K_CURRENT_PLANET", 50);\r\n}\r\n\r\n//Goes to the Leviathan Mini-Game covered by the Escape Render\r\nvoid ST_PlayLeviathanEscape01()\r\n{\r\n    SetGlobalNumber("K_TURRET_SKYBOX", 10);\r\n    StartNewModule("m12ab", "", "17a", "11a");\r\n}\r\n\r\n//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n////////////////// GENERIC RENDER HANDLER ////////////////////////////////////////////////////////////////////////////////////\r\n//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Play Post Turret Sequence\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n   This determines what to play after a Fighter\r\n   Mini Game is run\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Dec 14, 2002\r\n//:://////////////////////////////////////////////\r\nvoid ST_PlayPostTurret()\r\n{\r\n    ST_MyPrintString(" Start: ST_PlayPostTurret()");\r\n    SetGlobalNumber("K_TURRET_SKYBOX", -1);\r\n    int nStarMap = GetGlobalNumber("K_STAR_MAP");\r\n    int nKOTOR = GetGlobalNumber("K_KOTOR_MASTER");\r\n    int nSimu = GetGlobalBoolean("K_HK47_SIMULATION");\r\n    int nRandom = GetGlobalBoolean("K_RANDOM_MINI_GAME");\r\n    ST_MyPostString("Firing Play Post Turret " + IntToString(nSimu));\r\n\r\n    if(nSimu == TRUE)\r\n    {\r\n        SetGlobalBoolean("K_HK47_SIMULATION", FALSE);\r\n        StartNewModule("ebo_m12aa", "K_MINI_GAME");\r\n    }\r\n    else if(nRandom == TRUE)\r\n    {\r\n        SetGlobalBoolean("K_RANDOM_MINI_GAME", FALSE);\r\n        StartNewModule("ebo_m12aa", "", "11b", ST_GetLandingRender());\r\n        SetGlobalNumber("K_CURRENT_PLANET", GetGlobalNumber("K_FUTURE_PLANET"));\r\n    }\r\n    else if(nStarMap == 0 && nKOTOR == 10) //Blasting Off Taris for Dantooine\r\n    {\r\n        //MODIFIED by Preston Watamaniuk, March 6, 2003\r\n        //Add this variable so I could get the space skybox to show up on the Taris To Dantooine Run\r\n        SetGlobalBoolean("K_SPACE_SKYBOX_ON", TRUE);\r\n        StartNewModule("ebo_m12aa", "K_TARIS_DESTROYED","11b");\r\n    }\r\n    else if(nStarMap == 40 && nKOTOR == 20) //Blasting Off the Leviathan\r\n    {\r\n        StartNewModule("ebo_m40ad", "","11b");\r\n    }\r\n    else if(nStarMap == 50 && nKOTOR == 40) //Landing on the Unknown World\r\n    {\r\n        ST_PlayStunt35();\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Play STUNT_14 Cutscene\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This determines what planet the PC is taking\r\n    off of and plays the STUNT_14 in the\r\n    appropriate manner\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Dec 14, 2002\r\n//:://////////////////////////////////////////////\r\nvoid ST_PlayStunt14()\r\n{\r\n    ST_MyPrintString(" Start: ST_PlayStunt14()");\r\n\r\n    StartNewModule("STUNT_14","",  ST_GetTakeOffRender());\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Play Landing Sequence\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Plays the appropriate landing sequence for the\r\n    chosen planet unless Lev or Star Forge\r\n    Sets K_CURRENT_PLANET as well.   Note that\r\n    this is played after a stunt module between\r\n    planets.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Dec 14, 2002\r\n//:://////////////////////////////////////////////\r\nvoid ST_PlayGenericLanding()\r\n{\r\n    ST_MyPrintString(" Start: ST_PlayGenericLanding()");\r\n\r\n    if(ST_VisionPlayed() == TRUE)\r\n    {\r\n        StartNewModule("ebo_m12aa","",  ST_GetLandingRender());\r\n        SetGlobalNumber("K_CURRENT_PLANET", GetGlobalNumber("K_FUTURE_PLANET"));\r\n    }\r\n    else\r\n    {\r\n        ST_PlayVisionStunt();\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Play Planet to Planet\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    With no cutscene between planets the game can\r\n    go to a vision or straight to another planet.\r\n    If interrupted by a vision then this will be\r\n    finished by a call in ST_PlayVisionLanding\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Dec 14, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid ST_PlayPlanetToPlanet()\r\n{\r\n    ST_MyPrintString(" Start: ST_PlayPlanetToPlanet()");\r\n    int nRoll = d100();\r\n    if(ST_VisionPlayed() == TRUE)\r\n    {\r\n        //MODIFIED by Preston Watamaniuk, March 6, 2003\r\n        //I have put a 50% chance of being ambushed by Sith Fighters when doing a straight planet to planet transition.\r\n        if(nRoll > 50)\r\n        {\r\n            ST_MyPrintString(" Start: Random Mini-Game Attack");\r\n            //Set this so that the function ST_PlayPostTurret will know what to do.\r\n            SetGlobalBoolean("K_RANDOM_MINI_GAME", TRUE);\r\n            StartNewModule("m12ab", "", ST_GetTakeOffRender(), "11a");\r\n        }\r\n        else\r\n        {\r\n            StartNewModule("ebo_m12aa","",  ST_GetTakeOffRender(), "08", ST_GetLandingRender());\r\n            SetGlobalNumber("K_CURRENT_PLANET", GetGlobalNumber("K_FUTURE_PLANET"));\r\n        }\r\n    }\r\n    else\r\n    {\r\n        ST_PlayVisionStunt02();\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Play Vision Stunt and Landing\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    If the landing is broken by a STUNT_00 then\r\n    the landing will be finished with this function.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Dec 14, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid ST_PlayVisionLanding()\r\n{\r\n    ST_MyPrintString(" Start: ST_PlayVisionLanding()");\r\n    int nFUTURE = GetGlobalNumber("K_FUTURE_PLANET");\r\n    if(nFUTURE == 20 ||\r\n       nFUTURE == 25 ||\r\n       nFUTURE == 30 ||\r\n       nFUTURE == 35)\r\n    {\r\n        StartNewModule("ebo_m12aa","", ST_GetStarmapVisionRender(), ST_GetLandingRender());\r\n        SetGlobalNumber("K_CURRENT_PLANET", GetGlobalNumber("K_FUTURE_PLANET"));\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Play Post ebo_m40ad\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Allows the Ebon Hawk to continue to the\r\n    selected planet after the Leviathan unless\r\n    that planet is Dantooine.\r\n    0    Endar Spire     5\r\n    1    Taris           10\r\n    2    Dantooine       15\r\n    3    --Kashyyk       20\r\n    4    --Manaan        25\r\n    5    --Korriban      30\r\n    6    --Tatooine      35\r\n    7    Leviathan       40\r\n    8    Unknown World   45\r\n    9    Star Forge      50\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: March 21, 2003\r\n//:://////////////////////////////////////////////\r\nvoid ST_PlayPostEbo_m40ad()\r\n{\r\n    ST_MyPrintString(" Start: ST_PlayGenericLanding()");\r\n    int nFPlanet = GetGlobalNumber("K_FUTURE_PLANET");\r\n\r\n    if(nFPlanet == 15)\r\n    {\r\n        if(GetGlobalBoolean("K_STAR_MAP_KASHYYYK") == FALSE)\r\n        {\r\n            nFPlanet = 20;\r\n        }\r\n        else if(GetGlobalBoolean("K_STAR_MAP_MANAAN") == FALSE)\r\n        {\r\n            nFPlanet = 25;\r\n        }\r\n        else if(GetGlobalBoolean("K_STAR_MAP_KORRIBAN") == FALSE)\r\n        {\r\n            nFPlanet = 30;\r\n        }\r\n        else if(GetGlobalBoolean("K_STAR_MAP_TATOOINE") == FALSE)\r\n        {\r\n            nFPlanet = 35;\r\n        }\r\n    }\r\n    SetGlobalNumber("K_FUTURE_PLANET", nFPlanet);\r\n    if(ST_VisionPlayed() == TRUE)\r\n    {\r\n        StartNewModule("ebo_m12aa","",  ST_GetLandingRender());\r\n        SetGlobalNumber("K_CURRENT_PLANET", nFPlanet);\r\n    }\r\n    else\r\n    {\r\n        ST_PlayVisionStunt();\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Take-Off Render\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns the appropriate take off render based\r\n    on the K_CURRENT_PLANET variable\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Dec 14, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nstring ST_GetTakeOffRender()\r\n{\r\n    int nCURRENT = GetGlobalNumber("K_CURRENT_PLANET");\r\n    if(nCURRENT == 15)\r\n    {\r\n        return "05_2c";\r\n    }\r\n    else if(nCURRENT == 20)\r\n    {\r\n        return "05_4c";\r\n    }\r\n    else if(nCURRENT == 25)\r\n    {\r\n        return "05_5c";\r\n    }\r\n    else if(nCURRENT == 30)\r\n    {\r\n        return "05_7C";\r\n    }\r\n    else if(nCURRENT == 35)\r\n    {\r\n        return "05_3c";\r\n    }\r\n    else if(nCURRENT == 40)\r\n    {\r\n        return  "NULL";\r\n    }\r\n    else if(nCURRENT == 45)\r\n    {\r\n        return "05_8c";\r\n    }\r\n    else if(nCURRENT == 55)\r\n    {\r\n        return "LIVE_1c";\r\n    }\r\n    else if(nCURRENT == 60)\r\n    {\r\n        return "LIVE_2c";\r\n    }\r\n    else if(nCURRENT == 65)\r\n    {\r\n        return "LIVE_3c";\r\n    }\r\n    else if(nCURRENT == 70)\r\n    {\r\n        return "LIVE_4c";\r\n    }\r\n    else if(nCURRENT == 75)\r\n    {\r\n        return "LIVE_5c";\r\n    }\r\n    else if(nCURRENT == 80)\r\n    {\r\n        return "LIVE_6c";\r\n    }\r\n    return "NULL";\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Landing Render\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns the appropriate landing render based\r\n    on the K_FUTURE_PLANET variable\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Dec 14, 2002\r\n//:://////////////////////////////////////////////\r\nstring ST_GetLandingRender()\r\n{\r\n    int nFUTURE = GetGlobalNumber("K_FUTURE_PLANET");\r\n    if(nFUTURE == 15)\r\n    {\r\n        return "05_2a";\r\n    }\r\n    else if(nFUTURE == 20)\r\n    {\r\n        return "05_4a";\r\n    }\r\n    else if(nFUTURE == 25)\r\n    {\r\n        return "05_5a";\r\n    }\r\n    else if(nFUTURE == 30)\r\n    {\r\n        return "05_7a";\r\n    }\r\n    else if(nFUTURE == 35)\r\n    {\r\n        return "05_3a";\r\n    }\r\n    else if(nFUTURE == 40)\r\n    {\r\n        return  "NULL";\r\n    }\r\n    else if(nFUTURE == 55)\r\n    {\r\n        return "LIVE_1a";\r\n    }\r\n    else if(nFUTURE == 60)\r\n    {\r\n        return "LIVE_2a";\r\n    }\r\n    else if(nFUTURE == 65)\r\n    {\r\n        return "LIVE_3a";\r\n    }\r\n    else if(nFUTURE == 70)\r\n    {\r\n        return "LIVE_4a";\r\n    }\r\n    else if(nFUTURE == 75)\r\n    {\r\n        return "LIVE_5a";\r\n    }\r\n    else if(nFUTURE == 80)\r\n    {\r\n        return "LIVE_6a";\r\n    }\r\n    return  "NULL";\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Has Vision Played\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks if the planet designated as\r\n    K_FUTURE_PLANET has had a vision played for it\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watmanaiuk\r\n//:: Created On: Dec 14, 2002\r\n//:://////////////////////////////////////////////\r\nint ST_VisionPlayed()\r\n{\r\n    int nVision = GetGlobalNumber("Ebon_Vision");\r\n    int nFUTURE = GetGlobalNumber("K_FUTURE_PLANET");\r\n\r\n    ST_MyPrintString(" Start: ST_VisionPlayed()");\r\n    ST_MyPrintString(" nFuture = " + IntToString(nFUTURE));\r\n    ST_MyPrintString("k_vis_kashyyyk2  = " + IntToString(GetGlobalBoolean("k_vis_kashyyyk2")));\r\n    ST_MyPrintString("k_vis_manaan2  = " + IntToString(GetGlobalBoolean("k_vis_manaan2")));\r\n    ST_MyPrintString("k_vis_korriban2  = " + IntToString(GetGlobalBoolean("k_vis_korriban2")));\r\n    ST_MyPrintString("k_vis_tatooine2  = " + IntToString(GetGlobalBoolean("k_vis_tatooine2")));\r\n\r\n    if(nFUTURE == 20 && GetGlobalBoolean("k_vis_kashyyyk2") == FALSE)\r\n    {\r\n        SetGlobalBoolean("k_vis_kashyyyk2", TRUE);\r\n        return FALSE;\r\n    }\r\n    else if(nFUTURE == 25 && GetGlobalBoolean("k_vis_manaan2") == FALSE)\r\n    {\r\n        SetGlobalBoolean("k_vis_manaan2", TRUE);\r\n        return FALSE;\r\n    }\r\n    else if(nFUTURE == 30 && GetGlobalBoolean("k_vis_korriban2") == FALSE)\r\n    {\r\n        SetGlobalBoolean("k_vis_korriban2", TRUE);\r\n        return FALSE;\r\n    }\r\n    else if(nFUTURE == 35 && GetGlobalBoolean("k_vis_tatooine2") == FALSE)\r\n    {\r\n        SetGlobalBoolean("k_vis_tatooine2", TRUE);\r\n        return FALSE;\r\n    }\r\n\r\n    ST_MyPrintString("Returning True");\r\n    return TRUE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Fetch Starmap Render\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Fetches the correct Starmap Vision Render\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Dec 14, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nstring ST_GetStarmapVisionRender()\r\n{\r\n    int nFUTURE = GetGlobalNumber("K_FUTURE_PLANET");\r\n\r\n    if(nFUTURE == 20)\r\n    {\r\n        return "0C";\r\n    }\r\n    else if(nFUTURE == 25)\r\n    {\r\n        return "0B";\r\n    }\r\n    else if(nFUTURE == 30)\r\n    {\r\n        return "0D";\r\n    }\r\n    else if(nFUTURE == 35)\r\n    {\r\n        return "0A";\r\n    }\r\n    return "NULL";\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Set Ebon Hawk Skybox\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This gets the current planet that the character\r\n    is on and determines what skybox to set for\r\n    the Ebon Hawk.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: March 6, 2003\r\n//:://////////////////////////////////////////////\r\nvoid ST_SetEbonHawkSkyBox()\r\n{\r\n    int nFUTURE = GetGlobalNumber("K_CURRENT_PLANET");\r\n\r\n    if(GetGlobalBoolean("K_SPACE_SKYBOX_ON") == TRUE)\r\n    {\r\n        ST_MyPrintString("Firing Anim 09 for Space");\r\n        ST_MyPrintString("New Print Line Confirmation");\r\n        PlayRoomAnimation("m12aa_01q", ANIMATION_ROOM_SCRIPTLOOP09);\r\n        SetGlobalBoolean("K_SPACE_SKYBOX_ON", FALSE);\r\n    }\r\n    else if(nFUTURE == 15)\r\n    {\r\n        ST_MyPrintString("Firing Anim 02 for Dantooine");\r\n        PlayRoomAnimation("m12aa_01q", ANIMATION_ROOM_SCRIPTLOOP02);\r\n    }\r\n    else if(nFUTURE == 20)\r\n    {\r\n        ST_MyPrintString("Firing Anim 01 for Kashyyyk");\r\n        PlayRoomAnimation("m12aa_01q", ANIMATION_ROOM_SCRIPTLOOP01);\r\n    }\r\n    else if(nFUTURE == 25)\r\n    {\r\n        ST_MyPrintString("Firing Anim 06 for Manaan");\r\n        PlayRoomAnimation("m12aa_01q", ANIMATION_ROOM_SCRIPTLOOP06);\r\n    }\r\n    else if(nFUTURE == 30)\r\n    {\r\n        ST_MyPrintString("Firing Anim 05 for Korriban");\r\n        PlayRoomAnimation("m12aa_01q", ANIMATION_ROOM_SCRIPTLOOP05);\r\n    }\r\n    else if(nFUTURE == 35)\r\n    {\r\n        ST_MyPrintString("Firing Anim 04 for Tatooine");\r\n        PlayRoomAnimation("m12aa_01q", ANIMATION_ROOM_SCRIPTLOOP04);\r\n    }\r\n    else if(nFUTURE == 40)\r\n    {\r\n        ST_MyPrintString("Firing Anim 08 for Leviathan");\r\n        PlayRoomAnimation("m12aa_01q", ANIMATION_ROOM_SCRIPTLOOP08);\r\n    }\r\n    else if(nFUTURE == 45)\r\n    {\r\n        ST_MyPrintString("Firing Anim 07 for Unknown World");\r\n        PlayRoomAnimation("m12aa_01q", ANIMATION_ROOM_SCRIPTLOOP07);\r\n    }\r\n    else if(nFUTURE == 50)\r\n    {\r\n        ST_MyPrintString("Firing Anim 03 for Star Forge");\r\n        PlayRoomAnimation("m12aa_01q", ANIMATION_ROOM_SCRIPTLOOP03);\r\n    }\r\n    //MODIFIED by Preston Watamaniuk on May 10, 2003\r\n    //Skybox added for live planets.\r\n    else if(nFUTURE > 50)\r\n    {\r\n        ST_MyPrintString("Firing Anim 10 for all live content planets");\r\n        PlayRoomAnimation("m12aa_01q", ANIMATION_ROOM_SCRIPTLOOP10);\r\n    }\r\n    else\r\n    {\r\n        PlayRoomAnimation("m12aa_01q", ANIMATION_ROOM_SCRIPTLOOP09);\r\n    }\r\n}\r\n\r\nvoid ST_MyPrintString(string sString)\r\n{\r\n    PrintString("RENDER/STUNT Debug ****************** " + sString);\r\n}\r\n\r\nvoid ST_MyPostString(string sString)\r\n{\r\n    AurPostString("RENDER/STUNT Debug ****************** " + sString, 10, 10, 4.0);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Fetch Starmap Render\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Fetches the correct Starmap Vision Render\r\n    for the planet the player is currently on\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: March 13, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nstring ST_GetCurrentStarmapVisionRender()\r\n{\r\n    int nFUTURE = GetGlobalNumber("K_CURRENT_PLANET");\r\n\r\n    if(nFUTURE == 20)\r\n    {\r\n        return "0C";\r\n    }\r\n    else if(nFUTURE == 25)\r\n    {\r\n        return "0B";\r\n    }\r\n    else if(nFUTURE == 30)\r\n    {\r\n        return "0D";\r\n    }\r\n    else if(nFUTURE == 35)\r\n    {\r\n        return "0A";\r\n    }\r\n    return "NULL";\r\n}\r\n\r\n', 'k_inc_switch': b'//:: k_inc_switch\r\n/*\r\n     A simple include defining all of the\r\n     events in the game as constants.\r\n*/\r\n//:: Created By: Preston Watamaniuk\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n\r\n//DEFAULT AI EVENTS\r\nint KOTOR_DEFAULT_EVENT_ON_HEARTBEAT           = 1001;\r\nint KOTOR_DEFAULT_EVENT_ON_PERCEPTION          = 1002;\r\nint KOTOR_DEFAULT_EVENT_ON_COMBAT_ROUND_END    = 1003;\r\nint KOTOR_DEFAULT_EVENT_ON_DIALOGUE            = 1004;\r\nint KOTOR_DEFAULT_EVENT_ON_ATTACKED            = 1005;\r\nint KOTOR_DEFAULT_EVENT_ON_DAMAGE              = 1006;\r\nint KOTOR_DEFAULT_EVENT_ON_DEATH               = 1007;\r\nint KOTOR_DEFAULT_EVENT_ON_DISTURBED           = 1008;\r\nint KOTOR_DEFAULT_EVENT_ON_BLOCKED             = 1009;\r\nint KOTOR_DEFAULT_EVENT_ON_FORCE_AFFECTED      = 1010;\r\nint KOTOR_DEFAULT_EVENT_ON_GLOBAL_DIALOGUE_END = 1011;\r\nint KOTOR_DEFAULT_EVENT_ON_PATH_BLOCKED        = 1012;\r\n\r\n//HENCHMEN AI EVENTS\r\nint KOTOR_HENCH_EVENT_ON_HEARTBEAT           = 2001;\r\nint KOTOR_HENCH_EVENT_ON_PERCEPTION          = 2002;\r\nint KOTOR_HENCH_EVENT_ON_COMBAT_ROUND_END    = 2003;\r\nint KOTOR_HENCH_EVENT_ON_DIALOGUE            = 2004;\r\nint KOTOR_HENCH_EVENT_ON_ATTACKED            = 2005;\r\nint KOTOR_HENCH_EVENT_ON_DAMAGE              = 2006;\r\nint KOTOR_HENCH_EVENT_ON_DEATH               = 2007;\r\nint KOTOR_HENCH_EVENT_ON_DISTURBED           = 2008;\r\nint KOTOR_HENCH_EVENT_ON_BLOCKED             = 2009;\r\nint KOTOR_HENCH_EVENT_ON_FORCE_AFFECTED      = 2010;\r\nint KOTOR_HENCH_EVENT_ON_GLOBAL_DIALOGUE_END = 2011;\r\nint KOTOR_HENCH_EVENT_ON_PATH_BLOCKED        = 2012;\r\nint KOTOR_HENCH_EVENT_ON_ENTER_5m            = 2013;\r\nint KOTOR_HENCH_EVENT_ON_EXIT_5m             = 2014;\r\n\r\n//MISC AI EVENTS\r\nint KOTOR_MISC_DETERMINE_COMBAT_ROUND                = 3001;\r\nint KOTOR_MISC_DETERMINE_COMBAT_ROUND_ON_PC          = 3002;\r\nint KOTOR_MISC_DETERMINE_COMBAT_ROUND_ON_INDEX_ZERO  = 3003;\r\n\r\n', 'k_inc_tar': b'//::///////////////////////////////////////////////\r\n//:: k_inc_tar\r\n//:: k_inc_tar\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n  include file for taris\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: July 16, 2002\r\n//:://////////////////////////////////////////////\r\n#include "k_inc_debug"\r\n#include "k_inc_utility"\r\n\r\n//performs a standard creature transformation where the original creature\r\n//is destroyed and a new creature is put in its place.  returns a reference\r\n//to the new creature.\r\nobject TAR_TransformCreature(object oTarget = OBJECT_INVALID,string sTemplate = "");\r\n\r\n//test routine for walking waypoints\r\nvoid TAR_WalkWaypoints();\r\n\r\n//mark an object for cleanup by the TAR_CleanupDeadObjects function\r\nvoid TAR_MarkForCleanup(object obj = OBJECT_SELF);\r\n\r\n//destroy all objects whose PLOT_10 flag has been set\r\nvoid TAR_CleanupDeadObjects(object oArea);\r\n\r\n//make object do an uninterruptible path move\r\nvoid TAR_PlotMovePath(string sWayPointTag,int nFirst, int nLast, int nRun = FALSE);\r\n\r\n//make object do an uninterruptible move to an object\r\nvoid TAR_PlotMoveObject(object oTarget,int nRun = FALSE);\r\n\r\n//make object do an uninterruptible move to a location\r\nvoid TAR_PlotMoveLocation(location lTarget,int nRun = FALSE);\r\n\r\n//check for rukil\'s apprentice journal\r\nint TAR_PCHasApprenticeJournal();\r\n\r\n//return number of promised land journals player has\r\nint TAR_GetNumberPromisedLandJournals();\r\n\r\n//toggle the state of sith armor\r\nvoid TAR_ToggleSithArmor();\r\n\r\n//fill container with treasure from table\r\nvoid TAR_AddTreasureToContainer(object oContainer,int iTable,int iAmount);\r\n\r\n//returns TRUE if object is wearing sith armor\r\nint TAR_GetWearingSithArmor(object oTarget = OBJECT_INVALID);\r\n\r\n//strip sith armor from party, equipping another appropriate item (if available)\r\n//returns the sith armor object if it was being worn\r\nobject TAR_StripSithArmor();\r\n\r\n//teleport party member\r\nvoid TAR_TeleportPartyMember(object oPartyMember, location lDest);\r\n\r\n//makes the sith armor equippable\r\nvoid TAR_EnableSithArmor();\r\n\r\n//strip all items from an object\r\nvoid TAR_StripCharacter(object oTarget,object oDest);\r\n\r\n//::///////////////////////////////////////////////\r\n//:: TAR_TransformCreature\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//performs a standard creature transformation where the original creature\r\n//is destroyed and a new creature is put in its place.  returns a reference\r\n//to the new creature.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: July 16, 2002\r\n//:://////////////////////////////////////////////\r\nobject TAR_TransformCreature(object oTarget = OBJECT_INVALID,string sTemplate = "")\r\n{\r\n  if(GetIsObjectValid(oTarget) && sTemplate != "")\r\n  {\r\n    location lPlace = GetLocation(oTarget);\r\n\r\n    DestroyObject(oTarget,0.0,TRUE);\r\n    return(CreateObject(OBJECT_TYPE_CREATURE,sTemplate,lPlace));\r\n  }\r\n  else\r\n  {\r\n    return(OBJECT_INVALID);\r\n  }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: TAR_WalkWaypoints\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//test routine for walking waypoints\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: July 29, 2002\r\n//:://////////////////////////////////////////////\r\nvoid TAR_WalkWaypoints()\r\n{\r\n  object oNextWP = OBJECT_INVALID;\r\n  string sWPPath = "";\r\n\r\n  if(UT_GetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_01))\r\n  {\r\n    sWPPath = "ptar_testwp1";\r\n  }\r\n  else if(UT_GetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_02))\r\n  {\r\n    sWPPath = "ptar_testwp2";\r\n  }\r\n  else if(UT_GetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_03))\r\n  {\r\n    sWPPath = "ptar_testwp3";\r\n  }\r\n  else if(UT_GetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_04))\r\n  {\r\n    sWPPath = "ptar_testwp4";\r\n  }\r\n  else if(UT_GetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_05))\r\n  {\r\n    sWPPath = "ptar_testwp5";\r\n  }\r\n  else\r\n  {\r\n    sWPPath = "ptar_testwp6";\r\n  }\r\n  \r\n  if(UT_GetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_06))\r\n  {\r\n    sWPPath = sWPPath + "_1";\r\n    UT_SetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_06,FALSE);\r\n  }\r\n  else\r\n  {\r\n    sWPPath = sWPPath + "_0";\r\n    UT_SetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_06,TRUE);\r\n  }\r\n  \r\n  oNextWP = GetObjectByTag(sWPPath);\r\n  \r\n  Db_PostString("MOVING TO " + GetTag(oNextWP),5,5,2.0);\r\n  //ClearAllActions();\r\n  ActionForceMoveToObject(oNextWP);\r\n  ActionDoCommand(TAR_WalkWaypoints());\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: TAR_MarkForCleanup\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//mark an object for cleanup by the TAR_CleanupDeadObjects function\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 16, 2002\r\n//:://////////////////////////////////////////////\r\nvoid TAR_MarkForCleanup(object obj = OBJECT_SELF)\r\n{\r\n  UT_SetPlotBooleanFlag(obj,SW_PLOT_BOOLEAN_10,TRUE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: TAR_CleanupDeadObjects\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//destroy all objects whose PLOT_10 flag has been set\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 15, 2002\r\n//:://////////////////////////////////////////////\r\nvoid TAR_CleanupDeadObjects(object oArea)\r\n{\r\n  object obj;\r\n\r\n  obj = GetFirstObjectInArea(oArea);\r\n  //Db_PostString("START CLEANUP...",5,7,5.0);\r\n  while(GetIsObjectValid(obj))\r\n  {\r\n    //Db_PostString("FOUND OBJ",5,6,5.0);\r\n    if(UT_GetPlotBooleanFlag(obj,SW_PLOT_BOOLEAN_10))\r\n    {\r\n      //Db_PostString("CLEANING UP OBJECT",5,5,5.0);\r\n      DestroyObject(obj,0.0,TRUE);\r\n    }\r\n    obj = GetNextObjectInArea(oArea);\r\n  }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: TAR_PlotMovePath\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//make object do an uninterruptible path move\r\n//based on code done by Aidan (actually, pretty much a copy)\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 16, 2002\r\n//:://////////////////////////////////////////////\r\nvoid TAR_PlotMovePath(string sWayPointTag,int nFirst, int nLast, int nRun = FALSE)\r\n{\r\n\r\n    int nInc = 1;\r\n    object oWP;\r\n    int nIdx;\r\n    if(nFirst > nLast)\r\n    {\r\n        nInc = -1;\r\n    }\r\n    for(nIdx = nFirst - nInc; abs(nLast - nIdx) > 0 && abs(nLast - nIdx) <= abs((nLast - nFirst) + 1); nIdx = nIdx + nInc)\r\n    {\r\n        oWP = GetObjectByTag(sWayPointTag + IntToString(nIdx + nInc));\r\n        if(GetIsObjectValid(oWP))\r\n        {\r\n            ActionForceMoveToObject(oWP,nRun);\r\n        }\r\n    }\r\n    ActionDoCommand(SetCommandable(TRUE));\r\n    SetCommandable(FALSE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: TAR_PlotMoveObject\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//make object do an uninterruptible move to an object\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 16, 2002\r\n//:://////////////////////////////////////////////\r\nvoid TAR_PlotMoveObject(object oTarget,int nRun = FALSE)\r\n{\r\n  ActionForceMoveToObject(oTarget,nRun);\r\n  ActionDoCommand(SetCommandable(TRUE));\r\n  SetCommandable(FALSE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: TAR_PlotMoveObject\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//make object do an uninterruptible move to a location\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 16, 2002\r\n//:://////////////////////////////////////////////\r\nvoid TAR_PlotMoveLocation(location lTarget,int nRun = FALSE)\r\n{\r\n  ActionForceMoveToLocation(lTarget,nRun);\r\n  ActionDoCommand(SetCommandable(TRUE));\r\n  SetCommandable(FALSE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: TAR_PCHasApprenticeJournal\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//check for rukil\'s apprentice journal\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 21, 2002\r\n//:://////////////////////////////////////////////\r\nint TAR_PCHasApprenticeJournal()\r\n{\r\n  return(GetIsObjectValid(GetItemPossessedBy(GetFirstPC(),"ptar_appjournal")));\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: TAR_GetNumberPromisedLandJournals\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//return number of promised land journals player has\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 21, 2002\r\n//:://////////////////////////////////////////////\r\nint TAR_GetNumberPromisedLandJournals()\r\n{\r\n  object oInv;\r\n  int iJournals = 0;\r\n  \r\n  oInv = GetFirstItemInInventory(GetFirstPC());\r\n  while(GetIsObjectValid(oInv))\r\n  {\r\n    if(GetTag(oInv) == "ptar_rukjournal")\r\n    {\r\n      Db_PostString("JOURNALS - " + IntToString(GetNumStackedItems(oInv)),5,5,5.0);\r\n      iJournals += GetNumStackedItems(oInv);\r\n    }\r\n    oInv = GetNextItemInInventory(GetFirstPC());\r\n  }\r\n  \r\n  return(iJournals);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: TAR_ToggleSithArmor\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//toggle the state of sith armor\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: Oct. 8, 2002\r\n//:://////////////////////////////////////////////\r\nvoid TAR_ToggleSithArmor()\r\n{\r\n  int i;\r\n  object obj;\r\n  \r\n  obj = GetItemActivated();\r\n  if(GetTag(obj) != "ptar_sitharmor")\r\n  {\r\n    return;\r\n  }\r\n  \r\n  i = 1;\r\n  obj = GetNearestCreature(CREATURE_TYPE_RACIAL_TYPE,RACIAL_TYPE_ALL,GetFirstPC(),i);\r\n  while(GetIsObjectValid(obj))\r\n  {\r\n    if(GetDistanceBetween(obj,GetFirstPC()) < 10.0 && !IsObjectPartyMember(obj))\r\n    {\r\n      ActionStartConversation(GetFirstPC(),"ptar_armor_dlg");\r\n      return;\r\n    }\r\n    i++;\r\n    obj = GetNearestCreature(CREATURE_TYPE_RACIAL_TYPE,RACIAL_TYPE_ALL,GetFirstPC(),i);\r\n  }\r\n  \r\n  ActionStartConversation(GetFirstPC(),"ptar_armon_dlg");\r\n  SetGlobalBoolean("TAR_SITHARMOR",!GetGlobalBoolean("TAR_SITHARMOR"));\r\n}\r\n\r\n//fill container with treasure from table\r\nvoid TAR_AddTreasureToContainer(object oContainer,int iTable,int iAmount)\r\n{\r\n  int i;\r\n  \r\n  if(!GetIsObjectValid(oContainer))\r\n  {\r\n    return;\r\n  }\r\n  \r\n  for(i = 0;i < iAmount;i++)\r\n  {\r\n    switch(iTable)\r\n    {\r\n    case 0:\r\n      switch(Random(3))\r\n      {\r\n      case 0:\r\n        CreateItemOnObject("G_I_CREDITS001",oContainer,Random(20) + 1);\r\n        break;\r\n      case 1:\r\n        CreateItemOnObject("G_I_DRDREPEQP001",oContainer);\r\n        break;\r\n      case 2:\r\n        CreateItemOnObject("G_I_MEDEQPMNT04",oContainer);\r\n        break;\r\n      default:\r\n        CreateItemOnObject("G_I_MEDEQPMNT01",oContainer);\r\n      }\r\n      break;\r\n    case 1:\r\n      switch(Random(11))\r\n      {\r\n      case 0:\r\n        CreateItemOnObject("G_W_BLSTRPSTL001",oContainer);\r\n        break;\r\n      case 1:\r\n        CreateItemOnObject("G_I_SECSPIKE01",oContainer);\r\n        break;\r\n      case 2:\r\n        CreateItemOnObject("G_I_PROGSPIKE01",oContainer);\r\n        break;\r\n      case 3:\r\n        CreateItemOnObject("G_A_CLASS5001",oContainer);\r\n        break;\r\n      case 4:\r\n        CreateItemOnObject("G_W_FRAGGREN01",oContainer);\r\n        break;\r\n      case 5:\r\n        CreateItemOnObject("G_W_STUNGREN01",oContainer);\r\n        break;\r\n      case 6:\r\n        CreateItemOnObject("G_W_IONGREN01",oContainer);\r\n        break;\r\n      case 7:\r\n        CreateItemOnObject("G_W_SONICGREN01",oContainer);\r\n        break;\r\n      case 8:\r\n        CreateItemOnObject("G_W_VBROSHORT01",oContainer);\r\n        break;\r\n      case 9:\r\n        CreateItemOnObject("G_W_STUNBATON01",oContainer);\r\n        break;\r\n      default:\r\n        CreateItemOnObject("G_I_CREDITS001",oContainer,Random(40) + 20);\r\n        break;\r\n      }\r\n      break;\r\n    case 2:\r\n      switch(Random(5))\r\n      {\r\n      case 0:\r\n        CreateItemOnObject("G_W_BLSTRPSTL001",oContainer);\r\n        break;\r\n      case 1:\r\n        CreateItemOnObject("G_W_QTRSTAFF01",oContainer);\r\n        break;\r\n      case 2:\r\n        CreateItemOnObject("G_I_MEDEQPMNT01",oContainer);\r\n        break;\r\n      case 3:\r\n        CreateItemOnObject("G_A_CLASS4001",oContainer);\r\n        break;\r\n      default:\r\n        CreateItemOnObject("G_I_CREDITS001",oContainer,Random(20) + 1);\r\n        break;\r\n      }\r\n      break;\r\n    }\r\n  }\r\n}\r\n\r\n\r\nint TAR_GetWearingSithArmor(object oTarget = OBJECT_INVALID)\r\n{\r\n  int i;\r\n  object obj;\r\n  object oArmorItem = GetItemInSlot(INVENTORY_SLOT_BODY,oTarget);\r\n\r\n  if(!GetIsObjectValid(oTarget))\r\n  {\r\n    for(i = 0;i < GetPartyMemberCount();i++)\r\n    {\r\n      obj = GetPartyMemberByIndex(i);\r\n      oArmorItem = GetItemInSlot(INVENTORY_SLOT_BODY,obj);\r\n      if(GetTag(oArmorItem) == "ptar_sitharmor")\r\n      {\r\n        return(TRUE);\r\n      }\r\n    }\r\n    return(FALSE);\r\n  }\r\n  return(GetTag(oArmorItem) == "ptar_sitharmor");\r\n}\r\n\r\n//strip sith armor from target, equipping another appropriate item (if available)\r\nobject TAR_StripSithArmor()\r\n{\r\n  object oArmor = OBJECT_INVALID;\r\n  object obj;\r\n  object oTarget;\r\n  int i;\r\n\r\n  Db_PostString("STRIPPING ARMOR = " + GetTag(oTarget),5,7,5.0);\r\n\r\n  for(i = 0;i < GetPartyMemberCount();i++)\r\n  {\r\n    oTarget = GetPartyMemberByIndex(i);\r\n    \r\n    if(TAR_GetWearingSithArmor(oTarget))\r\n    {\r\n      Db_PostString("ARMOR STRIPPED",5,8,5.0);\r\n      oArmor = GetItemInSlot(INVENTORY_SLOT_BODY,oTarget);\r\n      SetCommandable(TRUE,oTarget);\r\n      AssignCommand(oTarget,ActionUnequipItem(oArmor));\r\n      obj = GetFirstItemInInventory(oTarget);\r\n      while(GetIsObjectValid(obj))\r\n      {\r\n        if(GetBaseItemType(obj) == BASE_ITEM_BASIC_CLOTHING)\r\n        {\r\n          Db_PostString("PUT ON NEW ITEM",5,9,5.0);\r\n          AssignCommand(oTarget,ActionEquipItem(obj,INVENTORY_SLOT_BODY,TRUE));\r\n          break;\r\n        }\r\n        obj = GetNextItemInInventory(oTarget);\r\n      }\r\n    }\r\n    else if(GetIsObjectValid(obj = GetItemPossessedBy(oTarget,"ptar_sitharmor")))\r\n    {\r\n      oArmor = obj;\r\n      Db_PostString("ARMOR FOUND",5,9,5.0);\r\n    }\r\n  }\r\n  return(oArmor);\r\n}\r\n\r\n//teleport party member\r\nvoid TAR_TeleportPartyMember(object oPartyMember, location lDest)\r\n{\r\n  if(!GetIsObjectValid(oPartyMember))\r\n  {\r\n    return;\r\n  }\r\n  \r\n  SetCommandable(TRUE,oPartyMember);\r\n  AssignCommand(oPartyMember,ClearAllActions());\r\n  AssignCommand(oPartyMember,ActionJumpToLocation(lDest));\r\n}\r\n\r\n//makes the sith armor equippable\r\nvoid TAR_EnableSithArmor()\r\n{\r\n  int i;\r\n  object obj;\r\n  object oArmor;\r\n  \r\n  for(i = 0;i < GetPartyMemberCount();i++)\r\n  {\r\n    obj = GetPartyMemberByIndex(i);\r\n    if(GetIsObjectValid(oArmor = GetItemPossessedBy(obj,"ptar_sitharmor")))\r\n    {\r\n      SetItemNonEquippable(oArmor,FALSE);\r\n    }\r\n  }\r\n}\r\n\r\nvoid TAR_StripCharacter(object oTarget,object oDest)\r\n{\r\n  object oItem;\r\n\r\n  if(!GetIsObjectValid(oTarget) || !GetIsObjectValid(oDest))\r\n  {\r\n    return;\r\n  }\r\n\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_BELT,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_BODY,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_HANDS,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_HEAD,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_IMPLANT,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_LEFTARM,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_LEFTWEAPON,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_RIGHTARM,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n  if(GetIsObjectValid(oItem = GetItemInSlot(INVENTORY_SLOT_RIGHTWEAPON,oTarget)))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n  }\r\n\r\n  oItem = GetFirstItemInInventory(oTarget);\r\n  while(GetIsObjectValid(oItem))\r\n  {\r\n    GiveItem(oItem,oDest);\r\n    oItem = GetFirstItemInInventory(oTarget);\r\n  }\r\n}\r\n\r\n\r\n', 'k_inc_tat': b'//::///////////////////////////////////////////////\r\n//:: Include\r\n//:: k_inc_tat\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This is the include file for Tatooine.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: John Winski\r\n//:: Created On: September 3, 2002\r\n//:://////////////////////////////////////////////\r\n#include "k_inc_utility"\r\n#include "k_inc_generic"\r\n// racer constants\r\nint NONE = 0;\r\nint GARM = 1;\r\nint YUKA = 2;\r\nint ZORIIS = 3;\r\n\r\n// race time constants\r\nint GARM_TIME = 2600;\r\nint YUKA_TIME = 2470;\r\nint ZORIIS_TIME = 2350;\r\nstring RACE_DEFAULT = GetStringByStrRef(32289);\r\n\r\nint GetGammoreansDeadGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_GammoreansDead");\r\n}\r\n\r\nvoid SetGammoreansDeadGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_GammoreansDead", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\nint GetMetKomadLodgeGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_MetKomadLodge");\r\n}\r\n\r\nvoid SetMetKomadLodgeGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_MetKomadLodge", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\nint GetSharinaAccusedGurkeGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_SharinaAccused");\r\n}\r\n\r\nvoid SetSharinaAccusedGurkeGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_SharinaAccused", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\nint GetKraytDeadGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_KraytDead");\r\n}\r\n\r\nvoid SetKraytDeadGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_KraytDead", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\nint GetKraytFightGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_KraytFight");\r\n}\r\n\r\nvoid SetKraytFightGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_KraytFight", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\nint GetTalkedToConserveGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_talkconserve");\r\n}\r\n\r\nvoid SetTalkedToConserveGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_talkconserve", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\nint GetUsedChokeOnCzerkaGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_chokedczerka");\r\n}\r\n\r\nvoid SetUsedChokeOnCzerkaGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_chokedczerka", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\nint GetTatooineRacerGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_SwoopRacer");\r\n}\r\n\r\nvoid SetTatooineRacerGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_SwoopRacer", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetLostLastRaceGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_LostLastRace");\r\n}\r\n\r\nvoid SetLostLastRaceGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_LostLastRace", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTanisDeadGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_TanisDead");\r\n}\r\n\r\nvoid SetTanisDeadGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_TanisDead", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPlayerDestroyedOneGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_OneDroidDead");\r\n}\r\n\r\nvoid SetPlayerDestroyedOneGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_OneDroidDead", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTanisGiveUpGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_TanisGiveUp");\r\n}\r\n\r\nvoid SetTanisGiveUpGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_TanisGiveUp", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetAskAboutHuntGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_AskAboutHunt");\r\n}\r\n\r\nvoid SetAskAboutHuntGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_AskAboutHunt", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGammoreanWarningGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_TrustGammNot");\r\n}\r\n\r\nvoid SetGammoreanWarningGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_TrustGammNot", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGammoreanGoneGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_GammGone");\r\n}\r\n\r\nvoid SetGammoreanGoneGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_GammGone", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGammoreanBribeGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_GammBribe");\r\n}\r\n\r\nvoid SetGammoreanBribeGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_GammBribe", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetRaceCompleteGlobal()\r\n{\r\n    return GetGlobalNumber("tat_RaceComplete");\r\n}\r\n\r\nvoid SetRaceCompleteGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("tat_RaceComplete", bValue);\r\n\r\n    return;\r\n}\r\n\r\nint GetSandHistoryStateGlobal()\r\n{\r\n    return GetGlobalNumber("tat_SandHistory");\r\n}\r\n\r\nvoid SetSandHistoryStateGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("tat_SandHistory", bValue);\r\n\r\n    return;\r\n}\r\n\r\nint GetToldHowToBeWarriorGlobal()\r\n{\r\n    return GetGlobalNumber("tat_SandWarrior");\r\n}\r\n\r\nvoid SetToldHowToBeWarriorGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("tat_SandWarrior", bValue);\r\n\r\n    return;\r\n}\r\n\r\nint GetRaceWonNotPaidGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_NotPaid");\r\n}\r\n\r\nvoid SetRaceWonNotPaidGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_NotPaid", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetSharinaPaidFullGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_SharinaPaidFull");\r\n}\r\n\r\nvoid SetSharinaPaidFullGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_SharinaPaidFull", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTalkTanisGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_TalkTanis");\r\n}\r\n\r\nvoid SetTalkTanisGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_TalkTanis", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetMadTanisGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_MadTanis");\r\n}\r\n\r\nvoid SetMadTanisGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_MadTanis", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTanisSavedGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_TanisSaved");\r\n}\r\n\r\nvoid SetTanisSavedGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_TanisSaved", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTuskenJobGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_TuskenJob");\r\n}\r\n\r\nvoid SetTuskenJobGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_TuskenJob", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJawaCaptiveGlobal()\r\n{\r\n    return GetGlobalNumber("tat_JawaCaptive");\r\n}\r\n\r\nvoid SetJawaCaptiveGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("tat_JawaCaptive", bValue);\r\n\r\n    return;\r\n}\r\n\r\nint GetIzizCaptiveGlobal()\r\n{\r\n    return GetGlobalNumber("tat_IzizCaptive");\r\n}\r\n\r\nvoid SetIzizCaptiveGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("tat_IzizCaptive", bValue);\r\n\r\n    return;\r\n}\r\n\r\nint GetIzizGotMadGlobal()\r\n{\r\n    return GetGlobalNumber("tat_IzizGotMad");\r\n}\r\n\r\nvoid SetIzizGotMadGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("tat_IzizGotMad", bValue);\r\n\r\n    return;\r\n}\r\n\r\nint GetGriffCaptiveGlobal()\r\n{\r\n    return GetGlobalNumber("tat_GriffCaptive");\r\n}\r\n\r\nvoid SetGriffCaptiveGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("tat_GriffCaptive", bValue);\r\n\r\n    return;\r\n}\r\n\r\nint GetMissionCaptiveGlobal()\r\n{\r\n    return GetGlobalNumber("tat_MissCaptive");\r\n}\r\n\r\nvoid SetMissionCaptiveGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("tat_MissCaptive", bValue);\r\n\r\n    return;\r\n}\r\n\r\nint GetFazzaPazzakStateGlobal()\r\n{\r\n    return GetGlobalNumber("tat_fazzpazzstate");\r\n}\r\n\r\nvoid SetFazzaPazzakStateGlobal(int bValue)\r\n{\r\n    SetGlobalNumber("tat_fazzpazzstate", bValue);\r\n\r\n    return;\r\n}\r\n\r\nint GetGriffGreetaGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_GriffGreeta");\r\n}\r\n\r\nvoid SetGriffGreetaGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_GriffGreeta", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\nint GetGriffPortGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_GriffPort");\r\n}\r\n\r\nvoid SetGriffPortGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_GriffPort", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\nint GetDockingPaidLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the Czerka official in area kas_m17ab.\r\n\r\n    return UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetDockingPaidLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the Czerka official in area kas_m17ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPlayerWarnedAboutQuestionsLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Sand People Storyteller in area tat_20aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetPlayerWarnedAboutQuestionsLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Sand People Storyteller in area tat_20aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetHK47CriticisedOnceLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Sand People Storyteller in area tat_20aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetHK47CriticisedOnceLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Sand People Storyteller in area tat_20aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetDorakNamedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Dorak Quinn in area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetDorakNamedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the Dorak Quinn in area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGurkePissedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetGurkePissedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGurkeNamedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Gurke in area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetGurkeNamedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Gurke in area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJunixTatooineInfoLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Junix Nard in area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetJunixTatooineInfoLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Junix nard in area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJunixSaidSwoopLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Junix nard in area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetJunixSaidSwoopLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Junix nard in area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJunixSaidKorribanLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Junix nard in area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetJunixSaidKorribanLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Junix nard in area tat_m17afd.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJunixSaidKoltoLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for Junix nard in area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetJunixSaidKoltoLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for Junix nard in area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetJunixSaidWookieeLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for Junix nard in area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_05);\r\n}\r\n\r\nvoid SetJunixSaidWookieeLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for Junix nard in area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_05, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetCelisNicoInfoLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area tat_m17ae.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetCelisNicoInfoLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area tat_m17ae.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetBulliedNicoLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the area tat_m17ae.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetBulliedNicoLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the area tat_m17ae.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetCelisDealLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the area tat_m17ae.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetCelisDealLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the area tat_m17ae.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetNicoHappyLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Nico in the area tat_m17ae.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetNicoHappyLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Nico in the area kas_m17ae.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetNicoTalkTimesSubstituteLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Nico in the area tat_m17ae.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetNicoTalkTimesSubstituteLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Nico in the area tat_m17ae.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetMottaPaidThePlayerLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Motta in the area tat_m17ae.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetMottaPaidThePlayerLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Motta in the area tat_m17ae.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGarmNamedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Garm Totryl in the area tat_m17ae.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetGarmNamedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Garm Totryl in the area tat_m17ae.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetYukarNamedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Yuka Rill in the area tat_m17ae.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetYukarNamedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Yuka Rill in the area tat_m17ae.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetYukarMadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Yuka Rill in the area tat_m17ae.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetYukarMadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Yuka Rill in the area tat_m17ae.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetZoriisNamedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Zoriis Bafka in the area tat_m17ae.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetZoriisNamedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Zoriis Bafka in the area tat_m17ae.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetHK47InfoLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Yuka Laka in the area tat_m17ac.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetHK47InfoLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Yuka Laka in the area tat_m17ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetHK47SoldLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Yuka Laka in the area tat_m17ac.\r\n\r\n    return UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetHK47SoldLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Yuka Laka in the area tat_m17ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetYukalPersuadeLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Yuka Laka in the area tat_m17ac.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetYukalPersuadeLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Yuka Laka in the area tat_m17ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetYukaHKFourThousandLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for Yuka Laka in the area tat_m17ac.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetYukaHKFourThousandLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for Yuka Laka in the area tat_m17ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetYukaHKThreeThousandLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for Yuka Laka in the area tat_m17ac.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_05);\r\n}\r\n\r\nvoid SetYukaHKThreeThousandLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for Yuka Laka in the area tat_m17ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_05, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetYukaHKTwentyFiveHundredLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for Yuka Laka in the area tat_m17ac.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_06);\r\n}\r\n\r\nvoid SetYukaHKTwentyFiveHundredLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for Yuka Laka in the area tat_m17ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_06, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetYukaThreatenedOverPriceLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_07 for Yuka Laka in the area tat_m17ac.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_07);\r\n}\r\n\r\nvoid SetYukaThreatenedOverPriceLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_07 for Yuka Laka in the area tat_m17ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_07, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetYukaSaidSwoopChampionLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_08 for Yuka Laka in the area tat_m17ac.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_08);\r\n}\r\n\r\nvoid SetYukaSaidSwoopChampionLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_08 for Yuka Laka in the area tat_m17ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_08, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetYukaSaidKoltoGoneLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_09 for Yuka Laka in the area tat_m17ac.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_09);\r\n}\r\n\r\nvoid SetYukaSaidKoltoGoneLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_09 for Yuka Laka in the area tat_m17ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_09, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetYukaSaidWookieesRevoltedGlobal()\r\n// set when yuka talks about wookies\r\n{\r\n    return GetGlobalBoolean("tat_YukaWookiees");\r\n}\r\n\r\nvoid SetYukaSaidWookieesRevoltedGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_YukaWookiees", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\nint GetYukaSaidPowerStruggleGlobal()\r\n// set when yuka talks about power struggle\r\n{\r\n    return GetGlobalBoolean("tat_YukaStruggle");\r\n}\r\n\r\nvoid SetYukaSaidPowerStruggleGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_YukaStruggle", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\nint GetPlayerRacedAtAllGlobal()\r\n// set when yuka talks about power struggle\r\n{\r\n    return GetGlobalBoolean("tat_playerhasraced");\r\n}\r\n\r\nvoid SetPlayerRacedAtAllGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_playerhasraced", bValue);\r\n    }\r\n    return;\r\n}\r\n\r\nint GetGandroffMadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Gandroff in the area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetGandroffMadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Gandroff in the area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGandroffNameLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Gandroff in the area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetGandroffNameLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Gandroff in the area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGandrofForceNoTalkLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Gandroff in the area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetGandrofForceNoTalkLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Gandroff in the area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPazzakLastGameLostLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Pazzak on Furko Nellis in the area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetPazzakLastGameLostLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Pazzak on Furko Nellis in the area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPazzakGame1WonLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Pazzak on Furko Nellis in the area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetPazzakGame1WonLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Pazzak on Furko Nellis in the area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPazzakGame2WonLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Pazzak on Furko Nellis in the area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetPazzakGame2WonLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Pazzak on Furko Nellis in the area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPazzakGame3WonLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for Pazzak on Furko Nellis in the area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetPazzakGame3WonLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for Pazzak on Furko Nellis in the area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPazzakJustPlayedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for Pazzak on Furko Nellis in the area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_05);\r\n}\r\n\r\nvoid SetPazzakJustPlayedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for Pazzak on Furko Nellis in the area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_05, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFazzaPazzakPlayedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Pazzak on alien player in the area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetFazzaPazzakPlayedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Pazzak on alien player in the area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFazzaLostLastGameLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Pazzak on alien player in the area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetFazzaLostLastGameLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Pazzak on alien player in the area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetToldOfFazzaPazzakLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Pazzak on alien player in the area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetToldOfFazzaPazzakLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Pazzak on alien player in the area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetKomadNameLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for komad in the area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetKomadNameLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Komad in the area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetKomadMadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for komad in the area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetKomadMadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Komad in the area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTanisNameLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Tanis in the area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetTanisNameLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Tanis in the area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetQuestionTanisAboutWifeLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Tanis in the area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetQuestionTanisAboutWifeLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Tanis in the area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTanisIgnoredLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Tanis in the area tat_m18aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetTanisIgnoredLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Tanis in the area tat_m18aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGammoreanAmbushLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the ambush droid in the area tat_m18aa.\r\n\r\n    return UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetGammoreanAmbushLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the ambush droid in the area tat_m18aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetAskedTanisForPaymentLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Tanis in the area tat_m18aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetAskedTanisForPaymentLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Tanis in the area tat_m18aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetAskedTanisForCreditsLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Tanis in the area tat_m18aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetAskedTanisForCreditsLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Tanis in the area tat_m18aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetAskedTanisToGiveUpLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for Tanis in the area tat_m18aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetAskedTanisToGiveUpLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for Tanis in the area tat_m18aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTanisShoutLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for Tanis in the area tat_m18aa.\r\n\r\n    return UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_05);\r\n}\r\n\r\nvoid SetTanisShoutLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for Tanis in the area tat_m18aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_05, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetDroidExplodeLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for Tanis in the area tat_m18aa.\r\n\r\n    return UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_06);\r\n}\r\n\r\nvoid SetDroidExplodeLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for Tanis in the area tat_m18aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_06, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTanisCallLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_07 for Tanis in the area tat_m18aa.\r\n\r\n    return UT_GetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_07);\r\n}\r\n\r\nvoid SetTanisCallLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_07 for Tanis in the area tat_m18aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(oTarget, SW_PLOT_BOOLEAN_07, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetOfficeMadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Czerka officer in the area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetOfficeMadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Czerka officer in the area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetOfficeNamedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Czerka officer in the area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetOfficeNamedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Czerka officer in the area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetVaporatorPriceDroppedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for greeta holda in the area tat_m17ag.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetVaporatorPriceDroppedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for greeta holda in the area tat_m17ag.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetVaporatorGivenLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for greeta holda in the area tat_m17ag.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetVaporatorGivenLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for greeta holda in the area tat_m17ag.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGreetaSaidSwoopLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for greeta holda in the area tat_m17ag.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetGreetaSaidSwoopLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for greeta holda in the area tat_m17ag.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGreetaSaidKorribanLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for greeta holda in the area tat_m17ag.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_05);\r\n}\r\n\r\nvoid SetGreetaSaidKorribanLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for greeta holda in the area tat_m17ag.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_05, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGreetaSaidKoltoLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for greeta holda in the area tat_m17ag.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_06);\r\n}\r\n\r\nvoid SetGreetaSaidKoltoLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for greeta holda in the area tat_m17ag.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_06, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetToldOfBountyLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Czerka protocol officer in the area tat_m17ag.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetToldOfBountyLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Czerka protocol officer in the area tat_m17ag.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetChieftainStickGivenLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Czerka protocol officer in the area tat_m17ag.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetChieftainStickGivenLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Czerka protocol officer in the area tat_m17ag.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetAskedIzizStarMapLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for iziz in the area tat_m17aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetAskedIzizStarMapLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for iziz in the area tat_m17aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetIzizMadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for iziz in the area tat_m17aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetIzizMadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for iziz in the area tat_m17aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetIzizRewardedLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for iziz in the area tat_m17aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetIzizRewardedLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for iziz in the area tat_m17aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetIzizPaidMoreLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for iziz in the area tat_m17aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetIzizPaidMoreLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for iziz in the area tat_m17aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetMechMadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for mechanic in the area tat_m17aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetMechMadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for mechanic in the area tat_m17aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetForcedMechanicLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for mechanic in the area tat_m17aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetForcedMechanicLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for mechanic in the area tat_m17aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetForcedNoTalkLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for mechanic in the area tat_m17aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetForcedNoTalkLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for mechanic in the area tat_m17aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGateGuardMadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the gate guard in the area tat_m17aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetGateGuardMadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the gate guard in the area tat_m17aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPlayerSaidNoHuntLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Komad in the area tat_m18ac.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetPlayerSaidNoHuntLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Komad in the area tat_m18ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPlayerSaidYesHuntLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Komad in the area tat_m18ac.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetPlayerSaidYesHuntLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Komad in the area tat_m18ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTwoSaidSwoopLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for twohead in the area tat_m17ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetTwoSaidSwoopLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for twohead in the area tat_m17ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTwoSaidKorribanLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for twohead in the area tat_m17ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetTwoSaidKorribanLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for twohead in the area tat_m17ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTwoSaidKoltoLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for twohead in the area tat_m17ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetTwoSaidKoltoLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for twohead in the area tat_m17ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTwoSaidWookieeLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for two head in the area tat_m17ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetTwoSaidWookieeLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for two head in the area tat_m17ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTwoAskedAboutSelfLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for two head in the area tat_m17ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_05);\r\n}\r\n\r\nvoid SetTwoAskedAboutSelfLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for two head in the area tat_m17ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_05, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTwoAskedAboutTatooineLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for two head in the area tat_m17ab.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_06);\r\n}\r\n\r\nvoid SetTwoAskedAboutTatooineLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for two head in the area tat_m17ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_06, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFazzaSaidSwoopLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Fazza in the area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetFazzaSaidSwoopLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for Fazza in the area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFazzaSaidKorribanLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Fazza in the area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetFazzaSaidKorribanLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Fazza in the area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFazzaSaidKoltoLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for Fazza in the area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetFazzaSaidKoltoLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for Fazza in the area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFazzaSaidWookieeLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for Fazza in the area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_05);\r\n}\r\n\r\nvoid SetFazzaSaidWookieeLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for Fazza in the area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_05, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTalkedToKomadLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Komad in the area tat_m18ac.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetTalkedToKomadLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for Komad in the area tat_m18ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetDragonSpawnLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area tat_m18ac.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetDragonSpawnLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area tat_m18ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetDragonPearlLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the area tat_m18ac.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetDragonPearlLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the area tat_m18ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTuskenAmbush2Local()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the area tat_m18ac.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_03);\r\n}\r\n\r\nvoid SetTuskenAmbush2Local(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_03 for the area tat_m18ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_03, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetHelenaSpawnLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area tat_m17af.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetHelenaSpawnLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area tat_m17af.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\n\r\nint GetTuskenAmbushLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area kas_m18aa.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetTuskenAmbushLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area kas_m18aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetBanthaFollowLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for the area tat_m18ac.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_04);\r\n}\r\n\r\nvoid SetBanthaFollowLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_04 for the area tat_m18ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_04, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetBanthaLuredLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for the area tat_m18ac.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_05);\r\n}\r\n\r\nvoid SetBanthaLuredLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for the area tat_m18ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_05, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetKomadReadyLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for the area tat_m18ac.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_06);\r\n}\r\n\r\nvoid SetKomadReadyLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for the area tat_m18ac.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_06, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetFailedFixLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for the area kas_m18aa.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_05);\r\n}\r\n\r\nvoid SetFailedFixLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_05 for the area kas_m18aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_05, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetDroid1RiddleLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for the area kas_m18aa.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_06);\r\n}\r\n\r\nvoid SetDroid1RiddleLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_06 for the area kas_m18aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_06, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetDroid2RiddleLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_07 for the area kas_m18aa.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_07);\r\n}\r\n\r\nvoid SetDroid2RiddleLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_07 for the area kas_m18aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_07, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetDroid3RiddleLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_08 for the area kas_m18aa.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_08);\r\n}\r\n\r\nvoid SetDroid3RiddleLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_08 for the area kas_m18aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_08, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetDroid4RiddleLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_09 for the area kas_m18aa.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_09);\r\n}\r\n\r\nvoid SetDroid4RiddleLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_09 for the area kas_m18aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_09, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetSharinaWaitLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area kas_m17aa.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetSharinaWaitLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area kas_m17aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGriffSpawnLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area tat_m20aa and tat_m17ag.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetGriffSpawnLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area tat_m20aa and tat_m17ag.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetGriffSawMissionLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Griff in the area kas_m20aa.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetGriffSawMissionLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for Griff in the area kas_m20aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\n// sets the current opponent variable\r\nvoid SetOpponent(int nOpponent)\r\n{\r\n    SetGlobalNumber("TAT_SWOOP_OPP",nOpponent);\r\n}\r\n\r\n// retuens the current opponent variable\r\nint GetOpponent()\r\n{\r\n    return GetGlobalNumber("TAT_SWOOP_OPP");\r\n}\r\n\r\n// sets the dialouge tokens based on an integer and creates it in the format\r\n// mm:ss:ff\r\nvoid SetTokenRaceTime(int nToken, int nRacerTime)\r\n{\r\n    // calculate the time components\r\n    int nMinutes = nRacerTime/6000;\r\n    int nSeconds = (nRacerTime - (nMinutes * 6000)) / 100;\r\n    int nFractions =  nRacerTime - ((nMinutes * 6000) + (nSeconds * 100));\r\n\r\n    //building the time string\r\n    string sTime = IntToString(nMinutes) + ":";\r\n    if (nSeconds < 10)\r\n    {\r\n        sTime = sTime + "0";\r\n    }\r\n    sTime = sTime + IntToString(nSeconds) + ":";\r\n    if(nFractions < 10)\r\n    {\r\n        sTime = sTime + "0";\r\n    }\r\n    sTime = sTime + IntToString(nFractions);\r\n    SetCustomToken(nToken,sTime);\r\n\r\n}\r\n\r\n// Checks if SW_PLOT_BOOLEAN_10 has been set. if not returns true and sets the boolean\r\nint HasNeverTriggered()\r\n{\r\n    int bReturn;\r\n    if(UT_GetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_10) == FALSE)\r\n    {\r\n        bReturn = TRUE;\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_10,TRUE);\r\n    }\r\n    return bReturn;\r\n}\r\n\r\n// Checks if SW_PLOT_BOOLEAN_09 has been set. if not returns true and sets the boolean\r\nint FirstRace()\r\n{\r\n    int bReturn;\r\n    if(UT_GetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_09) == FALSE)\r\n    {\r\n        bReturn = TRUE;\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF,SW_PLOT_BOOLEAN_09,TRUE);\r\n    }\r\n    return bReturn;\r\n}\r\n\r\nint GetKomadHuntEndGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_KomadHuntEnd");\r\n}\r\n\r\nvoid SetKomadHuntEndGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_KomadHuntEnd", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPlayerAttemptedOfficialRaceGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_oneofficialrace");\r\n}\r\n\r\nvoid SetPlayerAttemptedOfficialRaceGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_oneofficialrace", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetPlayerGotFreeRaceGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_freeracegiven");\r\n}\r\n\r\nvoid SetPlayerGotFreeRaceGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_freeracegiven", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetKraytMapGlobal()\r\n{\r\n    return GetGlobalBoolean("tat_KraytMap");\r\n}\r\n\r\nvoid SetKraytMapGlobal(int bValue)\r\n{\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        SetGlobalBoolean("tat_KraytMap", bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetKomadHuntingLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area tat_m17ad.\r\n\r\n    return UT_GetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetKomadHuntingLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area tat_m17ad.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(OBJECT_SELF, SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nint GetTuskenDoneLocal()\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area tat_m18ab.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01);\r\n}\r\n\r\nvoid SetTuskenDoneLocal(int bValue)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_01 for the area tat_m18ab.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(OBJECT_SELF), SW_PLOT_BOOLEAN_01, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n\r\nvoid EquipBasicClothing(object oTarget)\r\n{\r\n    int bFound = FALSE;\r\n\r\n    object oParty1 = GetPartyMemberByIndex(0);\r\n    object oParty2 = GetPartyMemberByIndex(1);\r\n    object oParty3 = GetPartyMemberByIndex(2);\r\n    object oItem = GetFirstItemInInventory(oTarget);\r\n\r\n    //Issue 1  Make sure the same clothing is not equipped.\r\n    //Issue 2  Make sure that they already have clothing.\r\n    //Issue 3  If they do not have clothing then spawn and equip.\r\n    //Issue 4  If they are wearing basic clothing ignore them.\r\n\r\n    /*\r\n    while(GetIsObjectValid(oItem) == TRUE && bFound == FALSE)\r\n    {\r\n        if (//GetBaseItemType(oItem) == BASE_ITEM_JEDI_ROBE &&\r\n           (//GetLevelByClass(CLASS_TYPE_JEDICONSULAR, oTarget) > 0 ||\r\n            //GetLevelByClass(CLASS_TYPE_JEDIGUARDIAN, oTarget) > 0 ||\r\n            //GetLevelByClass(CLASS_TYPE_JEDISENTINEL, oTarget) > 0) &&\r\n            GetItemInSlot(INVENTORY_SLOT_BODY, oParty1) != oItem &&\r\n            GetItemInSlot(INVENTORY_SLOT_BODY, oParty2) != oItem &&\r\n            GetItemInSlot(INVENTORY_SLOT_BODY, oParty3) != oItem)\r\n        {\r\n            AssignCommand(oTarget, ActionEquipItem(oItem, INVENTORY_SLOT_BODY,TRUE));\r\n            bFound = TRUE;\r\n        }\r\n        oItem = GetNextItemInInventory(oTarget);\r\n    }\r\n    */\r\n\r\n    oItem = GetFirstItemInInventory(oTarget);\r\n\r\n    while(GetIsObjectValid(oItem) == TRUE && bFound == FALSE)\r\n    {\r\n        if (GetBaseItemType(oItem) == BASE_ITEM_BASIC_CLOTHING &&\r\n            GetItemInSlot(INVENTORY_SLOT_BODY, oParty1) != oItem &&\r\n            GetItemInSlot(INVENTORY_SLOT_BODY, oParty2) != oItem &&\r\n            GetItemInSlot(INVENTORY_SLOT_BODY, oParty3) != oItem)\r\n        {\r\n            AssignCommand(oTarget, ActionEquipItem(oItem, INVENTORY_SLOT_BODY, TRUE));\r\n            bFound = TRUE;\r\n        }\r\n        oItem = GetNextItemInInventory(oTarget);\r\n    }\r\n\r\n    if (bFound == FALSE)\r\n    {\r\n        oItem = CreateItemOnObject("G_A_CLOTHES01", oTarget);\r\n        AssignCommand(oTarget, ActionEquipItem(oItem, INVENTORY_SLOT_BODY,TRUE));\r\n    }\r\n}\r\n\r\n\r\nvoid RemoveSandpeopleDisguise()\r\n{\r\n    object oPC = GetFirstPC();\r\n    object oParty1 = GetPartyMemberByIndex(0);\r\n    object oParty2 = GetPartyMemberByIndex(1);\r\n    object oParty3 = GetPartyMemberByIndex(2);\r\n\r\n    object oArmor = GetItemInSlot(INVENTORY_SLOT_BODY, oParty1);\r\n\r\n    if (GetTag(oArmor) == "tat17_sandperdis")\r\n    {\r\n        AssignCommand(oParty1, ClearAllActions());\r\n        AssignCommand(oParty1, ActionUnequipItem(oArmor));\r\n        AssignCommand(oParty1, ActionDoCommand(SetItemNonEquippable(oArmor, TRUE)));\r\n        EquipBasicClothing(oParty1);\r\n    }\r\n    oArmor = GetItemInSlot(INVENTORY_SLOT_BODY, oParty2);\r\n    if (GetTag(oArmor) == "tat17_sandperdis")\r\n    {\r\n        AssignCommand(oParty2, ClearAllActions());\r\n        AssignCommand(oParty2, ActionUnequipItem(oArmor));\r\n        AssignCommand(oParty2, ActionDoCommand(SetItemNonEquippable(oArmor, TRUE)));\r\n        EquipBasicClothing(oParty2);\r\n    }\r\n    oArmor = GetItemInSlot(INVENTORY_SLOT_BODY, oParty3);\r\n    if (GetTag(oArmor) == "tat17_sandperdis")\r\n    {\r\n        AssignCommand(oParty3, ClearAllActions());\r\n        AssignCommand(oParty3, ActionUnequipItem(oArmor));\r\n        AssignCommand(oParty3, ActionDoCommand(SetItemNonEquippable(oArmor, TRUE)));\r\n        EquipBasicClothing(oParty3);\r\n    }\r\n\r\n    ActionWait(1.0);\r\n\r\n    object oItem = GetFirstItemInInventory(oPC);\r\n\r\n    while (GetIsObjectValid(oItem) == TRUE)\r\n    {\r\n        if (GetTag(oItem) == "tat17_sandperdis")\r\n        {\r\n            SetItemNonEquippable(oItem, TRUE);\r\n        }\r\n\r\n        oItem = GetNextItemInInventory(oPC);\r\n    }\r\n}\r\n\r\nvoid DestroySandpeopleDisguise()\r\n{\r\n    object oPC = GetFirstPC();\r\n    object oParty1 = GetPartyMemberByIndex(0);\r\n    object oParty2 = GetPartyMemberByIndex(1);\r\n    object oParty3 = GetPartyMemberByIndex(2);\r\n\r\n    object oArmor = GetItemInSlot(INVENTORY_SLOT_BODY, oParty1);\r\n\r\n    if (GetTag(oArmor) == "tat17_sandperdis")\r\n    {\r\n        AssignCommand(oParty1, ClearAllActions());\r\n        AssignCommand(oParty1, ActionUnequipItem(oArmor));\r\n        DestroyObject(oArmor);\r\n        //EquipBasicClothing(oParty1);\r\n    }\r\n    oArmor = GetItemInSlot(INVENTORY_SLOT_BODY, oParty2);\r\n    if (GetTag(oArmor) == "tat17_sandperdis")\r\n    {\r\n        AssignCommand(oParty2, ClearAllActions());\r\n        AssignCommand(oParty2, ActionUnequipItem(oArmor));\r\n        DestroyObject(oArmor);\r\n        //EquipBasicClothing(oParty2);\r\n    }\r\n    oArmor = GetItemInSlot(INVENTORY_SLOT_BODY, oParty3);\r\n    if (GetTag(oArmor) == "tat17_sandperdis")\r\n    {\r\n        AssignCommand(oParty3, ClearAllActions());\r\n        AssignCommand(oParty3, ActionUnequipItem(oArmor));\r\n        DestroyObject(oArmor);\r\n        //EquipBasicClothing(oParty3);\r\n    }\r\n\r\n    ActionWait(1.0);\r\n\r\n    object oItem = GetFirstItemInInventory(oPC);\r\n\r\n    while (GetIsObjectValid(oItem) == TRUE)\r\n    {\r\n        if (GetTag(oItem) == "tat17_sandperdis")\r\n        {\r\n            DestroyObject(oItem);\r\n        }\r\n\r\n        oItem = GetNextItemInInventory(oPC);\r\n    }\r\n}\r\n\r\nvoid SandpeopleDisguiseUsable()\r\n{\r\n    object oPC = GetFirstPC();\r\n\r\n    object oItem = GetFirstItemInInventory(oPC);\r\n\r\n    while (GetIsObjectValid(oItem) == TRUE)\r\n    {\r\n        if (GetTag(oItem) == "tat17_sandperdis")\r\n        {\r\n            SetItemNonEquippable(oItem, FALSE);\r\n        }\r\n\r\n        oItem = GetNextItemInInventory(oPC);\r\n    }\r\n}\r\n\r\nint GetTuskenContainerLocal(object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the the area tat_m20aa.\r\n\r\n    return UT_GetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_02);\r\n}\r\n\r\nvoid SetTuskenContainerLocal(int bValue, object oTarget = OBJECT_SELF)\r\n{\r\n    // This uses SW_PLOT_BOOLEAN_02 for the the area tat_m20aa.\r\n\r\n    if (bValue == TRUE || bValue == FALSE)\r\n    {\r\n        UT_SetPlotBooleanFlag(GetArea(oTarget), SW_PLOT_BOOLEAN_02, bValue);\r\n    }\r\n\r\n    return;\r\n}\r\n', 'k_inc_treasure': b'//:: k_inc_treasure\r\n/*\r\n     contains code for filling containers using treasure tables\r\n*/\r\n//:: Created By:  Jason Booth\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n//\r\n//  March 15, 2003  J.B.\r\n//      removed parts and spikes from tables\r\n//\r\n\r\n//constants for container types\r\nint SWTR_DEBUG = TRUE;  //set to false to disable console/file logging\r\nint SWTR_TABLE_CIVILIAN_CONTAINER = 1;\r\nint SWTR_TABLE_MILITARY_CONTAINER_LOW = 2;\r\nint SWTR_TABLE_MILITARY_CONTAINER_MID = 3;\r\nint SWTR_TABLE_MILITARY_CONTAINER_HIGH = 4;\r\nint SWTR_TABLE_CORPSE_CONTAINER_LOW = 5;\r\nint SWTR_TABLE_CORPSE_CONTAINER_MID = 6;\r\nint SWTR_TABLE_CORPSE_CONTAINER_HIGH = 7;\r\nint SWTR_TABLE_SHADOWLANDS_CONTAINER_LOW = 8;\r\nint SWTR_TABLE_SHADOWLANDS_CONTAINER_MID = 9;\r\nint SWTR_TABLE_SHADOWLANDS_CONTAINER_HIGH = 10;\r\nint SWTR_TABLE_DROID_CONTAINER_LOW = 11;\r\nint SWTR_TABLE_DROID_CONTAINER_MID = 12;\r\nint SWTR_TABLE_DROID_CONTAINER_HIGH = 13;\r\nint SWTR_TABLE_RAKATAN_CONTAINER = 14;\r\nint SWTR_TABLE_SANDPERSON_CONTAINER = 15;\r\n\r\n//Fill an object with treasure from the specified table\r\n//This is the only function that should be used outside this include file\r\nvoid SWTR_PopulateTreasure(object oContainer,int iTable,int iItems = 1,int bUnique = TRUE);\r\n\r\n//for internal debugging use only, output string to the log file and console if desired\r\nvoid SWTR_Debug_PostString(string sStr,int bConsole = TRUE,int x = 5,int y = 5,float fTime = 5.0)\r\n{\r\n  if(SWTR_DEBUG)\r\n  {\r\n    if(bConsole)\r\n    {\r\n      AurPostString("SWTR_DEBUG - " + sStr,x,y,fTime);\r\n    }\r\n    PrintString("SWTR_DEBUG - " + sStr);\r\n  }\r\n}\r\n\r\n//return whether i>=iLow and i<=iHigh\r\nint SWTR_InRange(int i,int iLow,int iHigh)\r\n{\r\n  if(i >= iLow && i <= iHigh)\r\n  {\r\n    return(TRUE);\r\n  }\r\n  else\r\n  {\r\n    return(FALSE);\r\n  }\r\n}\r\n\r\n//returns whether sTemplate is not in sFilter\r\nint SWTR_IsUnique(string sTemplate,string sFilter)\r\n{\r\n  if(sFilter == "")\r\n  {\r\n    return(TRUE);\r\n  }\r\n  \r\n  if(FindSubString(sFilter,sTemplate) >= 0)\r\n  {\r\n    return(FALSE);\r\n  }\r\n  else\r\n  {\r\n    return(TRUE);\r\n  }\r\n}\r\n\r\n//turn a given quantity into appropriate format for a treasure blob (string)\r\nstring SWTR_GetQuantity(int iCount)\r\n{\r\n  string str = IntToString(iCount);\r\n  string pad = "0";\r\n  int length = 4;\r\n  \r\n  while(GetStringLength(str) < length)\r\n  {\r\n    str = pad + str;\r\n  }\r\n  return("[" + str + "]");\r\n}\r\n\r\n//get a single treasure blob (string) from specified table\r\n//use sFilter to maintain uniqueness\r\nstring SWTR_GetTreasure(int iTable,string sFilter = "")\r\n{\r\n  int iRoll;\r\n  string sTemplate;\r\n  int bFound = FALSE;\r\n  string sObjDesc = "";\r\n  string sQuantity;\r\n  \r\n  //first, generate a random number (0-99) and then, using the specified table\r\n  //lookup the treasure\r\n  do {\r\n    iRoll = Random(100);\r\n    switch(iTable)\r\n    {\r\n    case 1:  //civilian container\r\n      sTemplate = "G_I_CREDITS001";\r\n      if(SWTR_InRange(iRoll,0,84) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(20)+1);\r\n        bFound = TRUE;\r\n      }\r\n      /*\r\n      sTemplate = "G_A_CLOTHES01";\r\n      if(SWTR_InRange(iRoll,25,34) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_A_CLOTHES02";\r\n      if(SWTR_InRange(iRoll,35,44) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_A_CLOTHES03";\r\n      if(SWTR_InRange(iRoll,45,54) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_A_CLOTHES04";\r\n      if(SWTR_InRange(iRoll,55,64) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_A_CLOTHES05";\r\n      if(SWTR_InRange(iRoll,65,74) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_A_CLOTHES06";\r\n      if(SWTR_InRange(iRoll,75,84) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_i_progspike01";\r\n      if(SWTR_InRange(iRoll,85,89) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,90,94) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "g_i_medeqpmnt01";\r\n      if(SWTR_InRange(iRoll,85,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    case 2:  //low level military container\r\n      sTemplate = "G_I_CREDITS001";\r\n      if(SWTR_InRange(iRoll,0,9) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(20)+1);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_w_fraggren01";\r\n      if(SWTR_InRange(iRoll,10,29) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_w_StunGren01";\r\n      if(SWTR_InRange(iRoll,30,39) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_w_SonicGren01";\r\n      if(SWTR_InRange(iRoll,40,59) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_w_iongren01";\r\n      if(SWTR_InRange(iRoll,60,69) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      /*\r\n      sTemplate = "g_i_progspike01";\r\n      if(SWTR_InRange(iRoll,50,59) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,60,69) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "g_i_medeqpmnt01";\r\n      if(SWTR_InRange(iRoll,70,84) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_MEDEQPMNT04";\r\n      if(SWTR_InRange(iRoll,85,89) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_DRDREPEQP001";\r\n      if(SWTR_InRange(iRoll,90,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    case 3:  //mid level military container\r\n      sTemplate = "G_I_CREDITS001";\r\n      if(SWTR_InRange(iRoll,0,3) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(30)+10);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_w_fraggren01";\r\n      if(SWTR_InRange(iRoll,4,17) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_w_StunGren01";\r\n      if(SWTR_InRange(iRoll,18,21) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_w_SonicGren01";\r\n      if(SWTR_InRange(iRoll,22,27) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_w_iongren01";\r\n      if(SWTR_InRange(iRoll,28,33) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      /*\r\n      sTemplate = "g_i_progspike01";\r\n      if(SWTR_InRange(iRoll,20,23) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,24,33) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "G_I_MEDEQPMNT02";\r\n      if(SWTR_InRange(iRoll,34,48) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_MEDEQPMNT04";\r\n      if(SWTR_InRange(iRoll,49,53) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_DRDREPEQP002";\r\n      if(SWTR_InRange(iRoll,54,63) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE001";\r\n      if(SWTR_InRange(iRoll,64,75) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE002";\r\n      if(SWTR_InRange(iRoll,76,87) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE003";\r\n      if(SWTR_InRange(iRoll,88,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    case 4:  //high level military container\r\n      sTemplate = "G_I_CREDITS001";\r\n      if(SWTR_InRange(iRoll,0,3) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(60)+ 40);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_w_fraggren01";\r\n      if(SWTR_InRange(iRoll,4,17) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(4)+ 3);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_w_StunGren01";\r\n      if(SWTR_InRange(iRoll,18,21) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(4)+ 3);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_w_SonicGren01";\r\n      if(SWTR_InRange(iRoll,22,27) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(4)+ 3);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_w_iongren01";\r\n      if(SWTR_InRange(iRoll,28,33) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(4)+ 3);\r\n        bFound = TRUE;\r\n      }\r\n      /*\r\n      sTemplate = "g_i_progspike01";\r\n      if(SWTR_InRange(iRoll,20,23) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(4)+ 3);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,24,33) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(4)+ 3);\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "G_I_MEDEQPMNT03";\r\n      if(SWTR_InRange(iRoll,34,48) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_MEDEQPMNT04";\r\n      if(SWTR_InRange(iRoll,49,53) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(4)+ 3);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_DRDREPEQP003";\r\n      if(SWTR_InRange(iRoll,54,63) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE004";\r\n      if(SWTR_InRange(iRoll,64,75) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE005";\r\n      if(SWTR_InRange(iRoll,76,87) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE006";\r\n      if(SWTR_InRange(iRoll,88,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    case 5:  //low level corpse container\r\n      sTemplate = "G_I_CREDITS001";\r\n      if(SWTR_InRange(iRoll,0,79) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(20)+ 1);\r\n        bFound = TRUE;\r\n      }\r\n      /*\r\n      sTemplate = "g_i_progspike01";\r\n      if(SWTR_InRange(iRoll,70,79) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,80,89) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "g_i_medeqpmnt01";\r\n      if(SWTR_InRange(iRoll,80,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    case 6:  //mid level corpse container\r\n      sTemplate = "G_I_CREDITS001";\r\n      if(SWTR_InRange(iRoll,0,49) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(30)+ 10);\r\n        bFound = TRUE;\r\n      }\r\n      /*\r\n      sTemplate = "g_i_progspike01";\r\n      if(SWTR_InRange(iRoll,40,49) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,50,59) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "G_I_MEDEQPMNT02";\r\n      if(SWTR_InRange(iRoll,50,69) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE001";\r\n      if(SWTR_InRange(iRoll,70,79) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE002";\r\n      if(SWTR_InRange(iRoll,80,89) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE003";\r\n      if(SWTR_InRange(iRoll,90,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    case 7:  //high level corpse container\r\n      sTemplate = "G_I_CREDITS001";\r\n      if(SWTR_InRange(iRoll,0,49) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(60)+ 40);\r\n        bFound = TRUE;\r\n      }\r\n      /*\r\n      sTemplate = "g_i_progspike01";\r\n      if(SWTR_InRange(iRoll,40,49) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(4)+ 3);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,50,59) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(4)+ 3);\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "G_I_MEDEQPMNT03";\r\n      if(SWTR_InRange(iRoll,50,69) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE004";\r\n      if(SWTR_InRange(iRoll,70,79) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE005";\r\n      if(SWTR_InRange(iRoll,80,89) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE006";\r\n      if(SWTR_InRange(iRoll,90,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    case 8:  //low level shadowlands container\r\n      sTemplate = "G_I_CREDITS001";\r\n      if(SWTR_InRange(iRoll,0,69) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(20)+ 1);\r\n        bFound = TRUE;\r\n      }\r\n      /*\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,60,79) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "g_i_medeqpmnt01";\r\n      if(SWTR_InRange(iRoll,70,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    case 9:  //mid level shadowlands container\r\n      sTemplate = "G_I_CREDITS001";\r\n      if(SWTR_InRange(iRoll,0,59) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(30)+ 10);\r\n        bFound = TRUE;\r\n      }\r\n      /*\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,50,59) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "g_i_medeqpmnt02";\r\n      if(SWTR_InRange(iRoll,60,69) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE001";\r\n      if(SWTR_InRange(iRoll,70,79) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE002";\r\n      if(SWTR_InRange(iRoll,80,89) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE003";\r\n      if(SWTR_InRange(iRoll,90,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    case 10:  //high level shadowlands container\r\n      sTemplate = "G_I_CREDITS001";\r\n      if(SWTR_InRange(iRoll,0,59) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(60)+ 40);\r\n        bFound = TRUE;\r\n      }\r\n      /*\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,50,59) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(4)+ 3);\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "g_i_medeqpmnt03";\r\n      if(SWTR_InRange(iRoll,60,69) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE004";\r\n      if(SWTR_InRange(iRoll,70,79) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE005";\r\n      if(SWTR_InRange(iRoll,80,89) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE006";\r\n      if(SWTR_InRange(iRoll,90,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    case 11:  //low level droid container\r\n      /*\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,0,79) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "G_I_DRDLTPLAT001";\r\n      if(SWTR_InRange(iRoll,0,79) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_DRDMTNSEN001";\r\n      if(SWTR_InRange(iRoll,80,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    case 12:  //mid level droid container\r\n      /*\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,0,79) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "G_I_DRDLTPLAT002";\r\n      if(SWTR_InRange(iRoll,0,79) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_DRDMTNSEN002";\r\n      if(SWTR_InRange(iRoll,80,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    case 13:  //high level droid container\r\n    /*\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,0,79) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(4)+ 3);\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "G_I_DRDLTPLAT003";\r\n      if(SWTR_InRange(iRoll,0,79) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_DRDMTNSEN003";\r\n      if(SWTR_InRange(iRoll,80,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    case 14:  //rakatan container\r\n    /*\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,0,15) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(4)+ 3);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_i_progspike01";\r\n      if(SWTR_InRange(iRoll,16,31) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(4)+ 3);\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "G_I_DRDREPEQP003";\r\n      if(SWTR_InRange(iRoll,0,24) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE004";\r\n      if(SWTR_InRange(iRoll,25,49) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE005";\r\n      if(SWTR_InRange(iRoll,50,74) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE006";\r\n      if(SWTR_InRange(iRoll,75,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    case 15:  //sandperson container\r\n    /*\r\n      sTemplate = "g_i_parts01";\r\n      if(SWTR_InRange(iRoll,0,11) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      */\r\n      sTemplate = "g_w_fraggren01";\r\n      if(SWTR_InRange(iRoll,0,23) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_w_StunGren01";\r\n      if(SWTR_InRange(iRoll,24,35) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_w_SonicGren01";\r\n      if(SWTR_InRange(iRoll,36,47) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "g_w_iongren01";\r\n      if(SWTR_InRange(iRoll,48,59) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate + SWTR_GetQuantity(Random(3)+ 2);\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE001";\r\n      if(SWTR_InRange(iRoll,60,71) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE002";\r\n      if(SWTR_InRange(iRoll,72,83) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      sTemplate = "G_I_ADRNALINE003";\r\n      if(SWTR_InRange(iRoll,84,99) && SWTR_IsUnique(sTemplate,sFilter))\r\n      {\r\n        sObjDesc = sTemplate;\r\n        bFound = TRUE;\r\n      }\r\n      break;\r\n    }\r\n  } while(!bFound);\r\n  return(sObjDesc);\r\n}\r\n\r\n//Fill an object with treasure from the specified table\r\n//This is the only function that should be used outside this include file\r\nvoid SWTR_PopulateTreasure(object oContainer,int iTable,int iItems = 1,int bUnique = TRUE)\r\n{\r\n  string sFilter = "";  //maintains list of item templates already retrieved\r\n  string sItem,sTemplate;\r\n  int iQuantity;\r\n  int i;\r\n\r\n  if(!GetIsObjectValid(oContainer))\r\n  {\r\n    SWTR_Debug_PostString("invalid container");\r\n    return;\r\n  }\r\n\r\n  while(iItems > 0)\r\n  {\r\n    sItem = SWTR_GetTreasure(iTable,sFilter);\r\n    if(sItem == "")\r\n    {\r\n      SWTR_Debug_PostString("bad table");\r\n    }\r\n    //parse the item description\r\n    //treasure blobs (strings) consist of the item template followed by the quantity\r\n    if((i = FindSubString(sItem,"[")) >= 0)\r\n    {\r\n      iQuantity = StringToInt(GetSubString(sItem,i+1,4));\r\n      sTemplate = GetSubString(sItem,0,i);\r\n    }\r\n    else\r\n    {\r\n      iQuantity = 1;\r\n      sTemplate = sItem;\r\n    }\r\n    //create item\r\n    if(!GetIsObjectValid(CreateItemOnObject(sTemplate,oContainer,iQuantity)))\r\n    {\r\n      SWTR_Debug_PostString("item create failed (" + sTemplate + ")");\r\n    }\r\n    else\r\n    {\r\n      SWTR_Debug_PostString("container:" + GetTag(oContainer) + " item:" + sTemplate,FALSE);\r\n    }\r\n    //update our filter if we are maintaining uniqueness\r\n    if(bUnique)\r\n    {\r\n      sFilter = sFilter + sTemplate;\r\n    }\r\n    iItems--;\r\n  }\r\n}\r\n', 'k_inc_unk': b'//::///////////////////////////////////////////////\r\n//:: k_inc_unk\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n  include file for unknown world\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: Sept. 9, 2002\r\n//:://////////////////////////////////////////////\r\n#include "k_inc_debug"\r\n#include "k_inc_utility"\r\n#include "k_inc_generic"\r\n//mark an object for cleanup by the UNK_CleanupDeadObjects function\r\nvoid UNK_MarkForCleanup(object obj);\r\n\r\n//destroy all objects whose PLOT_10 flag has been set\r\nvoid UNK_CleanupDeadObjects(object oArea);\r\n\r\n//mark object for cleanup and move to nearest exit\r\nvoid UNK_LeaveArea(object obj = OBJECT_SELF, int bRun = FALSE);\r\n\r\n//test if red rakata are hostile\r\nint UNK_GetRedRakataHostile();\r\n\r\n//test if black rakata are hostile\r\nint UNK_GetBlackRakataHostile();\r\n\r\n//make red rakatans hostile\r\nvoid UNK_SetRedRakataHostile();\r\n\r\n//make black rakatans hostile\r\nvoid UNK_SetBlackRakataHostile();\r\n\r\n//make black rakatans neutral\r\nvoid UNK_SetBlackRakataNeutral();\r\n\r\n//fill container with treasure from table\r\nvoid UNK_AddTreasureToContainer(object oContainer,int iTable,int iAmount);\r\n\r\n// unavoidable damage to all within radius\r\nvoid UNK_RakDefence(string sObjectTag, float fDistance, int bIndiscriminant = TRUE);\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UNK_MarkForCleanup\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//mark an object for cleanup by the TAR_CleanupDeadObjects function\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 26, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UNK_MarkForCleanup(object obj)\r\n{\r\n  UT_SetPlotBooleanFlag(obj,SW_PLOT_BOOLEAN_10,TRUE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UNK_CleanupDeadObjects\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//destroy all objects whose PLOT_10 flag has been set\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 15, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UNK_CleanupDeadObjects(object oArea)\r\n{\r\n  object obj;\r\n\r\n  obj = GetFirstObjectInArea(oArea);\r\n  //Db_PostString("START CLEANUP...",5,7,5.0);\r\n  while(GetIsObjectValid(obj))\r\n  {\r\n    //Db_PostString("FOUND OBJ",5,6,5.0);\r\n    if ((UT_GetPlotBooleanFlag(obj,SW_PLOT_BOOLEAN_10)) && (IsObjectPartyMember(obj) == FALSE))\r\n    {\r\n      //Db_PostString("CLEANING UP OBJECT",5,5,5.0);\r\n      DestroyObject(obj,0.0,TRUE);\r\n    }\r\n    obj = GetNextObjectInArea(oArea);\r\n  }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UNK_LeaveArea\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//mark object for cleanup and move to nearest exit\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 26, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UNK_LeaveArea(object obj = OBJECT_SELF, int bRun = FALSE)\r\n{\r\n  object oExit = GetNearestObjectByTag("punk_wpnpcext");\r\n\r\n  UNK_MarkForCleanup(obj);\r\n  if ((GetIsObjectValid(oExit)) && (IsObjectPartyMember(oExit) == FALSE))\r\n  {\r\n    UT_PlotMoveObject(oExit,bRun);\r\n  }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UNK_GetRedRakataHostile\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//test if red rakata are hostile\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: Sept. 10, 2002\r\n//:://////////////////////////////////////////////\r\nint UNK_GetRedRakataHostile()\r\n{\r\n  return (GetGlobalNumber("unk_redvill") == 99);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UNK_GetBlackRakataHostile\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//test if black rakata are hostile\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: Sept. 10, 2002\r\n//:://////////////////////////////////////////////\r\nint UNK_GetBlackRakataHostile()\r\n{\r\n  return ((GetGlobalBoolean("UNK_USEDDARKSIDE") == FALSE) && (GetGlobalBoolean("UNK_BLACKHOSTILE") == FALSE));\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UNK_SetRedRakatanHostile\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//make red rakatans hostile\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: Sept. 13, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UNK_SetRedRakataHostile()\r\n{\r\n  object obj;\r\n\r\n  SetGlobalNumber("Unk_redvill",99);\r\n  SetGlobalBoolean("Unk_RedHostile",TRUE);\r\n  obj = GetFirstObjectInArea();\r\n  while (GetIsObjectValid(obj))\r\n  {\r\n    if ((GetTag(obj) != "unk42_breed01") && (GetTag(obj) != "unk42_breed02") && (GetTag(obj) != "unk42_breed03") && (GetTag(obj) != "unk41_gizka") && (IsObjectPartyMember(obj) == FALSE))\r\n    {\r\n      ChangeToStandardFaction(obj,STANDARD_FACTION_HOSTILE_1);\r\n      AssignCommand(obj,ClearAllActions());\r\n      AssignCommand(obj, GN_DetermineCombatRound());\r\n    }\r\n    obj = GetNextObjectInArea();\r\n  }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UNK_SetBlackRakatanHostile\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//make black rakatans hostile\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: Sept. 13, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UNK_SetBlackRakataHostile()\r\n{\r\n  object obj;\r\n\r\n  Db_PostString("SCANNING...",5,5,5.0);\r\n  SetGlobalBoolean("UNK_BLACKHOSTILE",TRUE);\r\n  obj = GetFirstObjectInArea();\r\n  Db_PostString("FOUND OBJ...",5,5,5.0);\r\n  while(GetIsObjectValid(obj))\r\n  {\r\n    if ((GetTag(obj) != "unk41_gizka") && (IsObjectPartyMember(obj) == FALSE) && (GetTag(obj) != "unk43_redpris"))\r\n    {\r\n      Db_PostString("IN LOOP...",5,5,5.0);\r\n      Db_PostString("RAKATA HOSTILE",5,5,5.0);\r\n      ChangeToStandardFaction(obj,STANDARD_FACTION_HOSTILE_1);\r\n      AssignCommand(obj,ClearAllActions());\r\n      AssignCommand(obj, GN_DetermineCombatRound());\r\n    }\r\n\r\n    obj = GetNextObjectInArea();\r\n  }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UNK_SetBlackRakataNeutral\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//make black rakatans neutral\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: Sept. 13, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UNK_SetBlackRakataNeutral()\r\n{\r\n  object obj;\r\n\r\n  obj = GetFirstObjectInArea();\r\n  while(GetIsObjectValid(obj))\r\n  {\r\n    if (IsObjectPartyMember(obj) == FALSE)\r\n    {\r\n        ChangeToStandardFaction(obj,STANDARD_FACTION_NEUTRAL);\r\n        AssignCommand(obj,ClearAllActions());\r\n    }\r\n\r\n    obj = GetNextObjectInArea();\r\n  }\r\n}\r\n\r\n//fill container with treasure from table\r\nvoid UNK_AddTreasureToContainer(object oContainer,int iTable,int iAmount)\r\n{\r\n  int i;\r\n\r\n  if(!GetIsObjectValid(oContainer))\r\n  {\r\n    return;\r\n  }\r\n\r\n  for(i = 0;i < iAmount;i++)\r\n  {\r\n    switch(iTable)\r\n    {\r\n    case 0:\r\n      switch(Random(3))\r\n      {\r\n      case 0:\r\n        CreateItemOnObject("G_I_CREDITS001",oContainer,Random(50) + 20);\r\n        break;\r\n      case 1:\r\n        CreateItemOnObject("G_I_MEDEQPMNT04",oContainer);\r\n        break;\r\n      default:\r\n        CreateItemOnObject("G_I_MEDEQPMNT02",oContainer);\r\n      }\r\n      break;\r\n    case 1:\r\n      switch(Random(5))\r\n      {\r\n      case 0:\r\n        CreateItemOnObject("G_I_CREDITS001",oContainer,Random(50) + 20);\r\n        break;\r\n      case 1:\r\n        CreateItemOnObject("G_I_MEDEQPMNT04",oContainer);\r\n        break;\r\n      case 2:\r\n        CreateItemOnObject("G_I_DRDREPEQP002",oContainer);\r\n        break;\r\n      case 3:\r\n        CreateItemOnObject("G_I_PARTS01",oContainer);\r\n        break;\r\n      default:\r\n        CreateItemOnObject("G_I_MEDEQPMNT02",oContainer);\r\n      }\r\n      break;\r\n    }\r\n  }\r\n}\r\n\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Rakatan Defence Grid\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Overloads a power conduit and does 10d6 damage\r\n    to all within the specified radius\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Peter Thomas\r\n//:: Created On:\r\n//:://////////////////////////////////////////////\r\n\r\nvoid UNK_RakDefence(string sObjectTag, float fDistance, int bIndiscriminant = TRUE)\r\n{\r\n    object oWay = GetObjectByTag(sObjectTag);\r\n    if(GetIsObjectValid(oWay))\r\n    {\r\n        effect eFNF = EffectVisualEffect(VFX_FNF_GRENADE_ION);\r\n        effect eVFXHit = EffectVisualEffect(1021);\r\n        effect eVFXBeam = EffectBeam(VFX_BEAM_LIGHTNING_DARK_L, oWay, BODY_NODE_CHEST);\r\n        effect eDam;\r\n\r\n        object oTarget = GetNearestObject(OBJECT_TYPE_CREATURE, oWay, 1);\r\n        int nCount = 1;\r\n        int nDam = 1000;\r\n        float fDelay = 0.3;\r\n\r\n        AssignCommand(oWay, ActionPlayAnimation(ANIMATION_PLACEABLE_OPEN));\r\n\r\n        DelayCommand(0.3, ApplyEffectAtLocation(DURATION_TYPE_INSTANT, eFNF, GetLocation(oWay)));\r\n        while(GetIsObjectValid(oTarget) && GetDistanceBetween(oTarget, oWay) <= fDistance)\r\n        {\r\n            if(bIndiscriminant == TRUE || GetIsEnemy(oTarget, GetFirstPC()))\r\n            {\r\n                eDam = EffectDamage(nDam, DAMAGE_TYPE_UNIVERSAL);\r\n                DelayCommand(fDelay, ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oTarget));\r\n                //fDelay = fDelay + 0.17;\r\n\r\n                eDam = EffectDeath();\r\n                DelayCommand(fDelay + 0.1, ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oTarget));\r\n                DelayCommand(fDelay, ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eVFXBeam, oTarget, 1.0));\r\n                DelayCommand(fDelay, ApplyEffectToObject(DURATION_TYPE_INSTANT, eVFXHit, oTarget, 1.0));\r\n                fDelay = fDelay + 0.17;\r\n}\r\n            nCount++;\r\n            oTarget = GetNearestObject(OBJECT_TYPE_CREATURE, oWay, nCount);\r\n        }\r\n        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_PRO_DROID_KILL), oWay);\r\n\r\n    }\r\n}\r\n\r\n', 'k_inc_utility': b'//:: k_inc_utility\r\n/*\r\n    common functions used throughout various scripts\r\n\r\n    Modified by Peter T. 17/03/03\r\n    - Added UT_MakeNeutral2(), UT_MakeHostile1(), UT_MakeFriendly1() and UT_MakeFriendly2()\r\n*/\r\n//:: Created By: Jason Booth\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n\r\n// Plot Flag Constants.\r\nint SW_PLOT_BOOLEAN_01 = 0;\r\nint SW_PLOT_BOOLEAN_02 = 1;\r\nint SW_PLOT_BOOLEAN_03 = 2;\r\nint SW_PLOT_BOOLEAN_04 = 3;\r\nint SW_PLOT_BOOLEAN_05 = 4;\r\nint SW_PLOT_BOOLEAN_06 = 5;\r\nint SW_PLOT_BOOLEAN_07 = 6;\r\nint SW_PLOT_BOOLEAN_08 = 7;\r\nint SW_PLOT_BOOLEAN_09 = 8;\r\nint SW_PLOT_BOOLEAN_10 = 9;\r\nint SW_PLOT_HAS_TALKED_TO = 10;\r\nint SW_PLOT_COMPUTER_OPEN_DOORS = 11;\r\nint SW_PLOT_COMPUTER_USE_GAS = 12;\r\nint SW_PLOT_COMPUTER_DEACTIVATE_TURRETS = 13;\r\nint SW_PLOT_COMPUTER_DEACTIVATE_DROIDS = 14;\r\nint SW_PLOT_COMPUTER_MODIFY_DROID = 15;\r\nint SW_PLOT_REPAIR_WEAPONS = 16;\r\nint SW_PLOT_REPAIR_TARGETING_COMPUTER = 17;\r\nint SW_PLOT_REPAIR_SHIELDS = 18;\r\nint SW_PLOT_REPAIR_ACTIVATE_PATROL_ROUTE = 19;\r\n\r\n// UserDefined events\r\nint HOSTILE_RETREAT = 1100;\r\n\r\n//Alignment Adjustment Constants\r\nint SW_CONSTANT_DARK_HIT_HIGH = -6;\r\nint SW_CONSTANT_DARK_HIT_MEDIUM = -5;\r\nint SW_CONSTANT_DARK_HIT_LOW = -4;\r\nint SW_CONSTANT_LIGHT_HIT_LOW = -2;\r\nint SW_CONSTANT_LIGHT_HIT_MEDIUM = -1;\r\nint SW_CONSTANT_LIGHT_HIT_HIGH = 0;\r\n\r\n// Returns a pass value based on the object\'s level and DC rating of 0, 1, or 2 (easy, medium, difficult)\r\n// December 20 2001: Changed so that the difficulty is determined by the\r\n// NPC\'s Hit Dice\r\nint AutoDC(int DC, int nSkill, object oTarget);\r\n//  checks for high charisma\r\nint IsCharismaHigh();\r\n//  checks for low charisma\r\nint IsCharismaLow();\r\n//  checks for normal charisma\r\nint IsCharismaNormal();\r\n//  checks for high intelligence\r\nint IsIntelligenceHigh();\r\n//  checks for low intelligence\r\nint IsIntelligenceLow();\r\n//  checks for normal intelligence\r\nint IsIntelligenceNormal();\r\n//  checks to see if pc is very dark side\r\nint IsDarkHigh();\r\n//  checks to see if pc is just a little dark side\r\nint IsDarkLow();\r\n//  checks to see if pc is dark side\r\nint IsDark();\r\n//  checks to see if pc is very light side\r\nint IsLightHigh();\r\n//  checks to see if pc is slightly light side\r\nint IsLightLow();\r\n//  checks to see if pc is light side\r\nint IsLight();\r\n//  checks to see if pc is neutral\r\nint IsNeutral();\r\n//  pads a string with the given pad character to the specified length\r\nstring PadString(string str = "",string pad = " ",int length = 0);\r\n//  causes the given object to initiate conversation with the player\r\nvoid TalkToPC(object oSpeaker);\r\n//Gets the boolean state of a plot bit field\r\nint UT_GetPlotBooleanFlag(object oTarget, int nIndex);\r\n//Sets the boolean state of plot bit field using the SW_PLOT_BOOLEAN CONSTANTS\r\nvoid UT_SetPlotBooleanFlag(object oTarget, int nIndex, int nState);\r\n//Determines state of the HAS TALKED TO FLAG on the passed in object.\r\nint UT_GetTalkedToBooleanFlag(object oTarget);\r\n//Sets the Talked To Flag on the specified object.\r\nvoid UT_SetTalkedToBooleanFlag(object oTarget, int nState = TRUE);\r\n//Get the nearest PC to the specified object\r\nobject UT_GetNearestPCToObject(object oTarget = OBJECT_SELF);\r\n//Determine if object is a PC\r\nint UT_IsObjectPC(object oTarget = OBJECT_INVALID);\r\n//does a heavy darkside adjustment on the player\r\nvoid UT_DarkHigh(object oTarget);\r\n//does a medium darkside adjustment on the player\r\nvoid UT_DarkMed(object oTarget);\r\n//does a small darkside adjustment on the player\r\nvoid UT_DarkSml(object oTarget);\r\n//does a heavy lightside adjustment on the player\r\nvoid UT_LightHigh(object oTarget);\r\n//does a medium lightside adjustment on the player\r\nvoid UT_LightMed(object oTarget);\r\n//does a small lightside adjustment on the player\r\nvoid UT_LightSml(object oTarget);\r\n//Resets all of an objects Bit Fields to TRUE or FALSE\r\nvoid UT_ResetPlotBooleanFlags(object oToChange, int nState);\r\n//make object do an uninterruptible path move\r\nvoid UT_PlotMovePath(string sWayPointTag,int nFirst, int nLast, int nRun = FALSE);\r\n//make object do an uninterruptible move to an object\r\nvoid UT_PlotMoveObject(object oTarget,int nRun = FALSE);\r\n//make object do an uninterruptible move to a location\r\nvoid UT_PlotMoveLocation(location lTarget,int nRun = FALSE);\r\n//perform a skill check\r\nint UT_SkillCheck(int iDC, int iSkill, object oTarget);\r\n//test whether force power is dark side\r\nint UT_IsDarkSidePower(int iSpellID);\r\n//Creates an object at a location without having to pass back an object.  Can be\r\n//used in DelayCommand functions.\r\nvoid UT_CreateObject(int nObjectType, string sTemplate, location lLocal);\r\n//Command used in the swoop droid triggers to activate the spawning in of messengers.\r\nvoid UT_SpawnMessenger();\r\n//Makes the NPC flee to an SW_EXIT waypoint and destroy itself\r\nvoid UT_ExitArea(int nRun = FALSE);\r\n//Determines the number of spikes or parts to take away from the PC.\r\nint UT_DeterminesItemCost(int nDC, int nSkill);\r\n//Remove a number of computer spikes.\r\nvoid UT_RemoveComputerSpikes(int nNumber);\r\n//Remove a number of parts\r\nvoid UT_RemoveRepairParts(int nNumber);\r\n//Return items amounts for either the Spikes or the Parts\r\nint UT_ReturnSpikePartAmount(int nSkill);\r\n//Searches the area and changes all turrets with the specified tag to the neutral faction\r\nvoid UT_MakeNeutral(string sObjectTag);\r\n//Searches the area and changes all droids with the specified tag to the insane faction\r\nvoid UT_MakeInsane(string sObjectTag);\r\n//Searches through the ara and stuns all droids with the given tag permanently\r\nvoid UT_StunDroids(string sObjectTag);\r\n//Starts a fight\r\nvoid UT_StartCombat(object oObject);\r\n//Releases gas into the room and kills all biologicals in the specified radius\r\n//The radius should be between 2 - 5m\r\nvoid UT_GasRoom(string sWayTag, float fDistance, int bIndiscriminant = TRUE);\r\n//Overloads a power conduit and does 10d6 damage to all within the specified radius\r\n//bIndiscriminant: TRUE-affects all creatures; FALSE-affects only enemies\r\nvoid UT_OverloadConduit(string sObjectTag, float fDistance, int bIndiscriminant = TRUE);\r\n//Returns a creature to the nearest "wp_" waypoint.\r\n//During this time the creature will be uncommanable\r\nvoid UT_ReturnToBase(string sTag = "wp_homebase");\r\n//NPC initiates a conversation with the player.\r\nvoid UT_NPC_InitConversation(string sNPCTag,string sDlg = "",object oEntered = OBJECT_INVALID);\r\n//Sets the Journal entry for the starmap automatically.\r\nvoid UT_SetStarmapJournal();\r\n//Creates number of creatures with a specific template at a specified waypoint tag.\r\n//Total is the number times the loop will run.\r\n//fTimeDelay is the number seconds between iterations.\r\n//nSpawnIncrement is the number of templates spawned in per iteration.\r\nvoid UT_RunCombatEncounter(string sTemplate, string sTag, int nTotal = 3, float fTimeDelay = 1.5, int nSpawnIncrement = 1);\r\n//Sets the talik to flag on all objects with the specified tag using the PC as a focal point.\r\nvoid UT_SetTalkToFlagByTag(string sTag);\r\n//Locks any other doors with the same tag.  Makes them plot.\r\nvoid UT_LockDoorDuplicates(string sTag);\r\n//Check to see if the Party member specified is in the party and within the distance given.\r\nint UT_CheckCanPartyMemberInterject(int nNPC_Constant, float fDistance);\r\n//Reinitializes the Party Planet Initialization Variables\r\nvoid UT_ReinitializePartyPlanetVariables();\r\n//Teleport a party member\r\nvoid UT_TeleportPartyMember(object oPartyMember, location lDest);\r\n//Returns true if oTarget is the object of interest of an attacker\r\nint UT_GetUnderAttack(object oTarget);\r\n//Teleport the whole party and face them the direction that the objects they\r\n//are being jumped to are facing.\r\nvoid UT_TeleportWholeParty(object oWP0, object oWP1, object oWP2);\r\n//Pause and restart a conversation.\r\nvoid UT_ActionPauseConversation(float fDelay);\r\n//Spawn NPC without return\r\nvoid UT_SpawnAvailableNPC(int nNPC, location lWay);\r\n//Goes through the current party and heals them.\r\nvoid UT_HealParty();\r\n//Heals the object passed in.\r\nvoid UT_HealNPC(object oNPC);\r\n//Heals all of the Party NPCs in Area\r\nvoid UT_HealAllPartyNPCs();\r\n//This function removes party members. It stores the npc constants of the removed party members.\r\nvoid UT_StoreParty();\r\n//This function restore party members. It will only restore party members removed via the UT_StoreParty funcion\r\nvoid UT_RestoreParty();\r\n//Returns the NPC code for the given object if it is a NPC, otherwise it returns -1\r\nint UT_GetNPCCode(object oNPC);\r\n//restores all party mambers to 1 hp if tempoarily dead\r\nvoid UT_RestorePartyToOneHealth();\r\n//Alter the stack size of a given item\r\nvoid UT_AlterItemStack(object oItem,int iNum = 1,int bDecrement = TRUE);\r\n//Goes through the party and removes them. This is best used on Module Load when the object are not actually created yet.\r\nvoid UT_ClearAllPartyMembers();\r\n//Does a DC check just using an ability score\r\nint UT_AbilityCheck(int iDC, int iAbility, object oTarget);\r\n//Validate a jump back to the last location by comparing module names.\r\nint UT_ValidateJump(string sLastModule);\r\n//Make alignment change based on a constant passed in to the function\r\nvoid UT_AdjustCharacterAlignment(object oTarget, int nScale);\r\n\r\n// Added by Peter T. 17/03/03\r\n// Searches the area and changes all instances with the specified tag to the Neutral faction\r\nvoid UT_MakeNeutral2(string sObjectTag);\r\n// Added by Peter T. 17/03/03\r\n// Searches the area and changes all instances with the specified tag to the Hostile_1 faction\r\nvoid UT_MakeHostile1(string sObjectTag);\r\n// Added by Peter T. 17/03/03\r\n// Searches the area and changes all instances with the specified tag to the Friendly_1 faction\r\nvoid UT_MakeFriendly1(string sObjectTag);\r\n// Added by Peter T. 17/03/03\r\n// Searches the area and changes all instances with the specified tag to the Friendly_2 faction\r\nvoid UT_MakeFriendly2(string sObjectTag);\r\n//performs a standard torture cage effect\r\nvoid UT_ActivateTortureCage(object oCage, object oTarget,float fDuration);\r\n//Makes the animal face the PC, do its victory and play a sound passed in.\r\n//Should be used in conjunction with the k_def_interact spawn in\r\nvoid UT_DoAmbientReaction(string sSound);\r\n\r\n\r\n//STAR MAP FUNCTION SET\r\n//Advances K_STAR_MAP, sets the journal and sets the talk to flag.\r\nvoid UT_StarMap1VariableSet();\r\n//Plays the animations necessary for the current state of the starmap variable\r\nvoid UT_StarMap2PlayAnimation();\r\n//Returns the appropriate animation loop for the Star Map\r\nint UT_StarMap3GetLoopAnim(int nStarMapVar);\r\n//Runs the entire Starmap sequence as a black box with no extra scripting required.\r\nvoid UT_StarMap4RunStarMap();\r\n\r\n\r\n\r\n///////////////////////////////////////////////////////////////////////////////\r\n/*\r\n    AutoDC\r\n\r\nRelation to Max Persuade   Low Persaude chance   Mid Persuade chance   High Persuade chance\r\n\r\nHigher than Max                  100                   100                     100\r\n75% to 100%                      100                   100                     75\r\n50% to 75%                       75                    50                      25\r\n25% to 50%                       50                    25                      0\r\n0% to 25%                        25                    0                       0\r\n*/\r\n///////////////////////////////////////////////////////////////////////////////\r\n//  Returns a pass value based on the object\'s level and the suggested DC\r\n// December 20 2001: Changed so that the difficulty is determined by the\r\n// NPC\'s Hit Dice\r\n///////////////////////////////////////////////////////////////////////////////\r\n//  Created By: Preston Watamaniuk\r\n///////////////////////////////////////////////////////////////////////////////\r\nint AutoDC(int DC, int nSkill, object oTarget)\r\n{\r\n    int nSkillLvl = GetSkillRank(nSkill, oTarget);\r\n    int nMax;\r\n    int nRoll = d100();\r\n\r\n    nMax = GetHitDice(oTarget) + 5;\r\n    float fMax = IntToFloat(nMax);\r\n    float fSkillLvl = IntToFloat(nSkillLvl);\r\n    float fPercent = fSkillLvl/fMax;\r\n\r\n    AurPostString("Skill Percentage Chance = " + FloatToString(fPercent,4,2),5,5,3.0);\r\n    AurPostString("Percentage Die Roll     = " + IntToString(nRoll),5,7,3.0);\r\n\r\n    if(fPercent <= 0.25)\r\n    {\r\n        if(DC == 0 && nRoll <= 40){return TRUE;}\r\n    }\r\n    else if(fPercent > 0.25 && fPercent <= 0.5)\r\n    {\r\n        if(DC == 0 && nRoll <= 50){return TRUE;}\r\n        if(DC == 1 && nRoll <= 25){return TRUE;}\r\n    }\r\n    else if(fPercent > 0.5 && fPercent <= 0.75)\r\n    {\r\n        if(DC == 0 && nRoll <= 75){return TRUE;}\r\n        if(DC == 1 && nRoll <= 50){return TRUE;}\r\n        if(DC == 2 && nRoll <= 25){return TRUE;}\r\n    }\r\n    else if(fPercent > 0.75 && fPercent <= 1.0)\r\n    {\r\n        if(DC == 0 && nRoll <= 100){return TRUE;}\r\n        if(DC == 1 && nRoll <= 100){return TRUE;}\r\n        if(DC == 2 && nRoll <= 75){return TRUE;}\r\n    }\r\n    else if(fPercent > 1.0)\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n\r\n\r\n    //LEGACY CODE CHANGED ON FEB 18, 2003\r\n    /*\r\n    Easy = Lvl/4 ...rounded up\r\n    Moderate = 3/Lvl + Lvl ...rounded up\r\n    Difficult = Lvl * 1.5 + 6 ...rounded up\r\n\r\n    int nLevel = GetHitDice(OBJECT_SELF);\r\n    if(nLevel <= 0 || nLevel > 20)\r\n    {\r\n        nLevel = GetHitDice(GetPCSpeaker());\r\n    }\r\n    int nTest = 0;\r\n    switch (DC)\r\n    {\r\n    case 0: nTest = nLevel / 4 + 1; break;\r\n        // * minor tweak to lower the values a little\r\n    case 1: nTest = (3 / nLevel + nLevel) - abs( (nLevel/2) -2); break;\r\n    case 2: nTest = FloatToInt(nLevel * 1.5 + 6) - abs( ( FloatToInt(nLevel/1.5) -2));   break;\r\n    }\r\n    //SpeakString(IntToString(nTest));\r\n\r\n    // * Roll d20 + skill rank vs. DC + 10\r\n    if (GetSkillRank(nSkill, oTarget) + d20() >= nTest + 10)\r\n    {\r\n       return TRUE;\r\n    }\r\n       return FALSE;\r\n    */\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: IsCharismaHigh\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  checks for high charisma\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  June 19, 2002\r\n//:://////////////////////////////////////////////\r\nint IsCharismaHigh()\r\n{\r\n  if (GetAbilityScore(GetPCSpeaker(),ABILITY_CHARISMA) >= 15)\r\n  {\r\n    return TRUE;\r\n  }\r\n  else\r\n  {\r\n    return FALSE;\r\n  }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: IsCharismaLow\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  checks for low charisma\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  June 19, 2002\r\n//:://////////////////////////////////////////////\r\nint IsCharismaLow()\r\n{\r\n  return !IsCharismaNormal();\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: IsCharismaNormal\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  checks for normal charisma\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  June 19, 2002\r\n//:://////////////////////////////////////////////\r\nint IsCharismaNormal()\r\n{\r\n  if (GetAbilityScore(GetPCSpeaker(),ABILITY_CHARISMA) >= 10)\r\n  {\r\n    return TRUE;\r\n  }\r\n  else\r\n  {\r\n    return FALSE;\r\n  }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: IsIntelligenceHigh\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  checks for high intelligence\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  June 19, 2002\r\n//:://////////////////////////////////////////////\r\nint IsIntelligenceHigh()\r\n{\r\n  if (GetAbilityScore(GetPCSpeaker(),ABILITY_INTELLIGENCE) >= 15)\r\n  {\r\n    return TRUE;\r\n  }\r\n  else\r\n  {\r\n    return FALSE;\r\n  }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: IsIntelligenceLow\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  checks for low intelligence\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  June 19, 2002\r\n//:://////////////////////////////////////////////\r\nint IsIntelligenceLow()\r\n{\r\n  return !IsIntelligenceNormal();\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: IsIntelligenceNormal\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  checks for normal intelligence\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  June 19, 2002\r\n//:://////////////////////////////////////////////\r\nint IsIntelligenceNormal()\r\n{\r\n  if (GetAbilityScore(GetPCSpeaker(),ABILITY_INTELLIGENCE) >= 10)\r\n  {\r\n    return TRUE;\r\n  }\r\n  else\r\n  {\r\n    return FALSE;\r\n  }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: IsDarkHigh\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  checks to see if pc is very dark side\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  June 19, 2002\r\n//:://////////////////////////////////////////////\r\nint IsDarkHigh()\r\n{\r\n    int align = GetGoodEvilValue(GetPCSpeaker());\r\n\r\n    if(align >= 0 && align < 20)\r\n    {\r\n        return TRUE;\r\n    }\r\n    else\r\n    {\r\n        return FALSE;\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: IsDarkLow\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  checks to see if pc is just a little dark side\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  June 19, 2002\r\n//:://////////////////////////////////////////////\r\nint IsDarkLow()\r\n{\r\n    int align = GetGoodEvilValue(GetPCSpeaker());\r\n\r\n    if(align >= 20 && align < 40)\r\n    {\r\n        return TRUE;\r\n    }\r\n    else\r\n    {\r\n        return FALSE;\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: IsDark\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  checks to see if pc is dark side\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  June 19, 2002\r\n//:://////////////////////////////////////////////\r\nint IsDark()\r\n{\r\n    if(IsDarkLow() || IsDarkHigh())\r\n    {\r\n        return TRUE;\r\n    }\r\n    else\r\n    {\r\n        return FALSE;\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: IsLightHigh\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  checks to see if pc is very light side\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  June 19, 2002\r\n//:://////////////////////////////////////////////\r\nint IsLightHigh()\r\n{\r\n    int align = GetGoodEvilValue(GetPCSpeaker());\r\n\r\n    if(align >= 81)\r\n    {\r\n        return TRUE;\r\n    }\r\n    else\r\n    {\r\n        return FALSE;\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: IsLightLow\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  checks to see if pc is slightly light side\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  June 19, 2002\r\n//:://////////////////////////////////////////////\r\nint IsLightLow()\r\n{\r\n    int align = GetGoodEvilValue(GetPCSpeaker());\r\n\r\n    if(align >= 61 && align < 81)\r\n    {\r\n        return TRUE;\r\n    }\r\n    else\r\n    {\r\n        return FALSE;\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: IsLight\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  checks to see if pc is light side\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  June 19, 2002\r\n//:://////////////////////////////////////////////\r\nint IsLight()\r\n{\r\n    if(IsLightLow() || IsLightHigh())\r\n    {\r\n        return TRUE;\r\n    }\r\n    else\r\n    {\r\n        return FALSE;\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: IsNeutral\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  checks to see if pc is neutral\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  June 19, 2002\r\n//:://////////////////////////////////////////////\r\nint IsNeutral()\r\n{\r\n    if(!IsDark() && !IsLight())\r\n    {\r\n        return TRUE;\r\n    }\r\n    else\r\n    {\r\n        return FALSE;\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: PadString\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  pads a string with the given pad character to the specified length\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  June 20, 2002\r\n//:://////////////////////////////////////////////\r\nstring PadString(string str = "",string pad = " ",int length = 0)\r\n{\r\n  while(GetStringLength(str) < length)\r\n  {\r\n    str = pad + str;\r\n  }\r\n  return(str);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: TalkToPC\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//  causes the given object to initiate conversation with the player\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By:  Jason Booth\r\n//:: Created On:  July 12, 2002\r\n//:://////////////////////////////////////////////\r\nvoid TalkToPC(object oSpeaker)\r\n{\r\n  AssignCommand(oSpeaker,ClearAllActions());\r\n  AssignCommand(oSpeaker,\r\n  ActionStartConversation(GetNearestCreature(CREATURE_TYPE_PLAYER_CHAR, PLAYER_CHAR_IS_PC)));\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Boolean Plot Flag\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Gets the boolean state of a plot bit field\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: July 15, 2002\r\n//:://////////////////////////////////////////////\r\nint UT_GetPlotBooleanFlag(object oTarget, int nIndex)\r\n{\r\n    int nPlotBoolean;\r\n    if(nIndex >= 0 && nIndex <= 19 && GetIsObjectValid(oTarget))\r\n    {\r\n        nPlotBoolean = GetLocalBoolean(oTarget, nIndex);\r\n        if(nPlotBoolean > 0)\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Set Boolean Plot Flag\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Sets the boolean state of a plot bit field\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: July 15, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid UT_SetPlotBooleanFlag(object oTarget, int nIndex, int nState)\r\n{\r\n    int nLevel = GetHitDice(GetFirstPC());\r\n    if(nState == TRUE)\r\n    {\r\n        if(nIndex == SW_PLOT_COMPUTER_OPEN_DOORS ||\r\n           nIndex == SW_PLOT_REPAIR_WEAPONS ||\r\n           nIndex == SW_PLOT_REPAIR_TARGETING_COMPUTER ||\r\n           nIndex == SW_PLOT_REPAIR_SHIELDS)\r\n        {\r\n            GiveXPToCreature(GetFirstPC(), nLevel * 15);\r\n        }\r\n        else if(nIndex == SW_PLOT_COMPUTER_USE_GAS || nIndex == SW_PLOT_REPAIR_ACTIVATE_PATROL_ROUTE || nIndex == SW_PLOT_COMPUTER_MODIFY_DROID)\r\n        {\r\n            GiveXPToCreature(GetFirstPC(), nLevel * 20);\r\n        }\r\n        else if(nIndex == SW_PLOT_COMPUTER_DEACTIVATE_TURRETS ||\r\n                nIndex == SW_PLOT_COMPUTER_DEACTIVATE_DROIDS)\r\n        {\r\n            GiveXPToCreature(GetFirstPC(), nLevel * 10);\r\n        }\r\n    }\r\n    if(nIndex >= 0 && nIndex <= 19 && GetIsObjectValid(oTarget))\r\n    {\r\n        if(nState == TRUE || nState == FALSE)\r\n        {\r\n            SetLocalBoolean(oTarget, nIndex, nState);\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Talked To Flag\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns the state of the Talk to Flag\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: July 15, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint UT_GetTalkedToBooleanFlag(object oTarget)\r\n{\r\n    int nPlotFlag;\r\n    if(GetIsObjectValid(oTarget))\r\n    {\r\n        nPlotFlag = GetLocalBoolean(oTarget, SW_PLOT_HAS_TALKED_TO);\r\n        if(nPlotFlag > 0)\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Set Talked To Flag\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Sets the talked to flag to the given state.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: July 15, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid UT_SetTalkedToBooleanFlag(object oTarget, int nState = TRUE)\r\n{\r\n    if(GetIsObjectValid(oTarget))\r\n    {\r\n        if(nState == TRUE || nState == FALSE)\r\n        {\r\n            SetLocalBoolean(oTarget, SW_PLOT_HAS_TALKED_TO, nState);\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UT_GetNearestPCToObject\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//Get the nearest PC to the specified object\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: July 15, 2002\r\n//:://////////////////////////////////////////////\r\nobject UT_GetNearestPCToObject(object oTarget = OBJECT_SELF)\r\n{\r\n  return(GetNearestCreature(CREATURE_TYPE_PLAYER_CHAR, PLAYER_CHAR_IS_PC,oTarget));\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UT_IsObjectPC\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//Determine if object is a PC\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: July 15, 2002\r\n//:://////////////////////////////////////////////\r\nint UT_IsObjectPC(object oTarget = OBJECT_INVALID)\r\n{\r\n  object oPC = GetFirstPC();\r\n\r\n  while(oPC != OBJECT_INVALID)\r\n  {\r\n    if(oTarget == oPC)\r\n    {\r\n      return(TRUE);\r\n    }\r\n    oPC = GetNextPC();\r\n  }\r\n\r\n  return(FALSE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Adjust Character Alignment\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Make alignment change based on a constant\r\n    passed in to the function\r\n    nDarkSide = 1 then do a darkside hit.\r\n    nScale is the size of the hit. -3 to +3\r\n\r\n    //Alignment Adjustment Constants\r\n\r\n    int SW_CONSTANT_DARK_HIT_HIGH = -6;\r\n    int SW_CONSTANT_DARK_HIT_MEDIUM = -5;\r\n    int SW_CONSTANT_DARK_HIT_LOW = -4;\r\n    int SW_CONSTANT_LIGHT_HIT_LOW = -2;\r\n    int SW_CONSTANT_LIGHT_HIT_MEDIUM = -1;\r\n    int SW_CONSTANT_LIGHT_HIT_HIGH = 0;\r\n\r\n                    1       2       3         4      5\r\n                    VLight  Light   Neutral   Dark   VDark\r\n      High Light    2       4       6         8      10\r\n      Mid Light     1       2       4         6      8\r\n      Low Light     1       1       2         4      6\r\n      Low Dark      -6      -4      -2        -1     -1\r\n      Mid Dark      -8      -6      -4        -2     -1\r\n      High Dark     -10     -8      -6        -4     -2\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 23, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_AdjustCharacterAlignment(object oTarget, int nScale)\r\n{\r\n    //Find out if the target is good or evil\r\n    int nScore = GetGoodEvilValue(oTarget);\r\n    int nAlignType;\r\n    //Set the type of alignment hit to do.\r\n    if(nScale == SW_CONSTANT_DARK_HIT_HIGH ||\r\n       nScale == SW_CONSTANT_DARK_HIT_MEDIUM ||\r\n       nScale == SW_CONSTANT_DARK_HIT_LOW)\r\n    {\r\n        nAlignType = ALIGNMENT_DARK_SIDE;\r\n    }\r\n    else\r\n    {\r\n        nAlignType = ALIGNMENT_LIGHT_SIDE;\r\n    }\r\n\r\n    int nHit;\r\n    int nAlignCategory;\r\n\r\n    //Set the alignment category which will determine the base from which to calculate the hit.\r\n    if(nScore >= 85)//VERY GOOD\r\n    {\r\n        nAlignCategory = 1;\r\n    }\r\n    else if(nScore < 85 && nScore > 60)//GOOD\r\n    {\r\n        nAlignCategory = 2;\r\n    }\r\n    else if(nScore <= 60 && nScore >= 40)//NEUTRAL\r\n    {\r\n        nAlignCategory = 3;\r\n    }\r\n    else if(nScore < 40 && nScore >= 15)//EVIL\r\n    {\r\n        nAlignCategory = 4;\r\n    }\r\n    else //VERY EVIL\r\n    {\r\n        nAlignCategory = 5;\r\n    }\r\n\r\n    //Calculate the hit.\r\n    nHit = (nAlignCategory + nScale) * 2;\r\n    if(nHit < 0)\r\n    {\r\n        nHit = nHit * -1;\r\n    }\r\n    if(nHit == 0)\r\n    {\r\n        nHit = 1;\r\n    }\r\n    //Zero results that do not mathematically fit within the formula.\r\n    if(nAlignCategory == 1 && nScale == SW_CONSTANT_LIGHT_HIT_LOW)\r\n    {\r\n        nHit = 1;\r\n    }\r\n    else if(nAlignCategory == 5 && nScale == SW_CONSTANT_DARK_HIT_LOW)\r\n    {\r\n        nHit = 1;\r\n    }\r\n    AurPostString("Hit = " + IntToString(nHit), 5, 5, 4.0);\r\n    \r\n    AdjustAlignment(oTarget, nAlignType, nHit);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UT_DarkHigh\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//does a heavy darkside adjustment on the target\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: July 16, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_DarkHigh(object oTarget)\r\n{\r\n    UT_AdjustCharacterAlignment(oTarget, SW_CONSTANT_DARK_HIT_HIGH);\r\n    //AdjustAlignment(oTarget,ALIGNMENT_DARK_SIDE,10);\r\n}\r\n//::///////////////////////////////////////////////\r\n//:: UT_DarkMed\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//does a medium darkside adjustment on the target\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: July 16, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_DarkMed(object oTarget)\r\n{\r\n  UT_AdjustCharacterAlignment(oTarget, SW_CONSTANT_DARK_HIT_MEDIUM);\r\n  //AdjustAlignment(oTarget,ALIGNMENT_DARK_SIDE,5);\r\n}\r\n//::///////////////////////////////////////////////\r\n//:: UT_DarkSml\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//does a small darkside adjustment on the target\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: July 16, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_DarkSml(object oTarget)\r\n{\r\n  UT_AdjustCharacterAlignment(oTarget, SW_CONSTANT_DARK_HIT_LOW);\r\n  //AdjustAlignment(oTarget,ALIGNMENT_DARK_SIDE,1);\r\n}\r\n//::///////////////////////////////////////////////\r\n//:: UT_LightHigh\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//does a heavy lightside adjustment on the target\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: July 16, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_LightHigh(object oTarget)\r\n{\r\n  UT_AdjustCharacterAlignment(oTarget, SW_CONSTANT_LIGHT_HIT_HIGH);\r\n  //AdjustAlignment(oTarget,ALIGNMENT_LIGHT_SIDE,10);\r\n}\r\n//::///////////////////////////////////////////////\r\n//:: UT_LightMed\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//does a medium lightside adjustment on the target\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: July 16, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_LightMed(object oTarget)\r\n{\r\n  UT_AdjustCharacterAlignment(oTarget, SW_CONSTANT_LIGHT_HIT_MEDIUM);\r\n  //AdjustAlignment(oTarget,ALIGNMENT_LIGHT_SIDE,5);\r\n}\r\n//::///////////////////////////////////////////////\r\n//:: UT_LightSml\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//does a small lightside adjustment on the target\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: July 16, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_LightSml(object oTarget)\r\n{\r\n  UT_AdjustCharacterAlignment(oTarget, SW_CONSTANT_LIGHT_HIT_LOW);\r\n  //AdjustAlignment(oTarget,ALIGNMENT_LIGHT_SIDE,1);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Reset Plot Booleans\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Goes through all of the plot bit fields and sets\r\n    them to nState.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Aug 15, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid UT_ResetPlotBooleanFlags(object oToChange, int nState)\r\n{\r\n    int nCnt;\r\n    for(nCnt; nCnt <= 9; nCnt++)\r\n    {\r\n        if(nState == TRUE || nState == FALSE)\r\n        {\r\n            SetLocalBoolean(oToChange, nCnt, nState);\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Check Manaan Medical State\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns true if the manaan facilities have\r\n    been destroyed.  Global = 4 returns true.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Aug 19, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint UT_GetIsKoltoDestroyed()\r\n{\r\n    return GetGlobalNumber("MAN_PLANET_PLOT") == 4;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UT_PlotMovePath\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//make object do an uninterruptible path move\r\n//based on code done by Aidan (actually, pretty much a copy)\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 16, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_PlotMovePath(string sWayPointTag,int nFirst, int nLast, int nRun = FALSE)\r\n{\r\n\r\n    int nInc = 1;\r\n    object oWP;\r\n    int nIdx;\r\n    if(nFirst > nLast)\r\n    {\r\n        nInc = -1;\r\n    }\r\n    for(nIdx = nFirst - nInc; abs(nLast - nIdx) > 0 && abs(nLast - nIdx) <= abs((nLast - nFirst) + 1); nIdx = nIdx + nInc)\r\n    {\r\n        oWP = GetObjectByTag(sWayPointTag + IntToString(nIdx + nInc));\r\n        if(GetIsObjectValid(oWP))\r\n        {\r\n            ActionForceMoveToObject(oWP,nRun);\r\n        }\r\n    }\r\n    ActionDoCommand(SetCommandable(TRUE));\r\n    SetCommandable(FALSE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UT_PlotMoveObject\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//make object do an uninterruptible move to an object\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 16, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_PlotMoveObject(object oTarget,int nRun = FALSE)\r\n{\r\n  ActionForceMoveToObject(oTarget,nRun);\r\n  ActionDoCommand(SetCommandable(TRUE));\r\n  SetCommandable(FALSE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UT_PlotMoveLocation\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//make object do an uninterruptible move to a location\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 16, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_PlotMoveLocation(location lTarget,int nRun = FALSE)\r\n{\r\n  ActionForceMoveToLocation(lTarget,nRun);\r\n  ActionDoCommand(SetCommandable(TRUE));\r\n  SetCommandable(FALSE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UT_SkillCheck\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//perform a skill check using a given DC\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: August 29, 2002\r\n//:://////////////////////////////////////////////\r\nint UT_SkillCheck(int iDC, int iSkill, object oTarget)\r\n{\r\n  if (GetSkillRank(iSkill, oTarget) + d20() >= iDC)\r\n  {\r\n    return TRUE;\r\n  }\r\n  return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UT_IsDarkSidePower\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//test whether force power is dark side\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: Sept. 11, 2002\r\n//:://////////////////////////////////////////////\r\nint UT_IsDarkSidePower(int iSpellID)\r\n{\r\n  if(iSpellID == FORCE_POWER_AFFECT_MIND) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_AFFLICTION) return(TRUE);\r\n  if(iSpellID == FORCE_POWER_CHOKE) return(TRUE);\r\n  if(iSpellID == FORCE_POWER_CURE) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_DEATH_FIELD) return(TRUE);\r\n  if(iSpellID == FORCE_POWER_DOMINATE) return(TRUE);\r\n  if(iSpellID == FORCE_POWER_DRAIN_LIFE) return(TRUE);\r\n  if(iSpellID == FORCE_POWER_DROID_DESTROY) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_DROID_DISABLE) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_DROID_STUN) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_FEAR) return(TRUE);\r\n  if(iSpellID == FORCE_POWER_FORCE_ARMOR) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_FORCE_AURA) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_FORCE_BREACH) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_FORCE_IMMUNITY) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_FORCE_JUMP) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_FORCE_JUMP_ADVANCED) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_FORCE_MIND) return(TRUE);\r\n  if(iSpellID == FORCE_POWER_FORCE_PUSH) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_FORCE_SHIELD) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_FORCE_STORM) return(TRUE);\r\n  if(iSpellID == FORCE_POWER_FORCE_WAVE) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_FORCE_WHIRLWIND) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_HOLD) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_HORROR) return(TRUE);\r\n  if(iSpellID == FORCE_POWER_INSANITY) return(TRUE);\r\n  if(iSpellID == FORCE_POWER_KILL) return(TRUE);\r\n  if(iSpellID == FORCE_POWER_KNIGHT_SPEED) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_LIGHT_SABER_THROW) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_LIGHT_SABER_THROW_ADVANCED) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_LIGHTNING) return(TRUE);\r\n  if(iSpellID == FORCE_POWER_MASTER_CONTROL) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_MASTER_SENSE) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_MIND_MASTERY) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_PLAGUE) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_REGENERATION) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_REGNERATION_ADVANCED) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_RESIST_COLD_HEAT_ENERGY) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_RESIST_FORCE) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_RESIST_POISON_DISEASE_SONIC) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_SHOCK) return(TRUE);\r\n  if(iSpellID == FORCE_POWER_SLEEP) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_SLOW) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_SPEED_BURST) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_SPEED_MASTERY) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_STUN) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_SUPRESS_FORCE) return(FALSE);\r\n  if(iSpellID == FORCE_POWER_WOUND) return(TRUE);\r\n\r\n  return(FALSE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UT_CreateObject\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Create an object without needing a variable\r\n    to pass it into.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Sept. 21, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_CreateObject(int nObjectType, string sTemplate, location lLocal)\r\n{\r\n    object oCreate = CreateObject(nObjectType, sTemplate, lLocal);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UT_JumpPartyToObject\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Move the entire party to the object specified.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: John Winski\r\n//:: Created On: Sept. 24, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_JumpPartyToObject(object oTarget)\r\n{\r\n    UT_RestorePartyToOneHealth();\r\n    object oMember1 = GetPartyMemberByIndex(0);\r\n    object oMember2 = GetPartyMemberByIndex(1);\r\n    object oMember3 = GetPartyMemberByIndex(2);\r\n\r\n    if (GetIsObjectValid(oMember1) == TRUE)\r\n    {\r\n        AssignCommand(oMember1, ClearAllActions());\r\n        AssignCommand(oMember1, JumpToObject(oTarget));\r\n    }\r\n    if (GetIsObjectValid(oMember2) == TRUE)\r\n    {\r\n        AssignCommand(oMember2, ClearAllActions());\r\n        AssignCommand(oMember2, JumpToObject(oTarget));\r\n    }\r\n    if (GetIsObjectValid(oMember2) == TRUE)\r\n    {\r\n        AssignCommand(oMember3, ClearAllActions());\r\n        AssignCommand(oMember3, JumpToObject(oTarget));\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UT_JumpPartyToLocation\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Move the entire party to the location specified.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: John Winski\r\n//:: Created On: Sept. 24, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_JumpPartyToLocation(location lTarget)\r\n{\r\n    object oMember1 = GetPartyMemberByIndex(0);\r\n    object oMember2 = GetPartyMemberByIndex(1);\r\n    object oMember3 = GetPartyMemberByIndex(2);\r\n    UT_RestorePartyToOneHealth();\r\n    if (GetIsObjectValid(oMember1) == TRUE)\r\n    {\r\n        AssignCommand(oMember1, ClearAllActions());\r\n        AssignCommand(oMember1, JumpToLocation(lTarget));\r\n    }\r\n    if (GetIsObjectValid(oMember2) == TRUE)\r\n    {\r\n        AssignCommand(oMember2, ClearAllActions());\r\n        AssignCommand(oMember2, JumpToLocation(lTarget));\r\n    }\r\n    if (GetIsObjectValid(oMember2) == TRUE)\r\n    {\r\n        AssignCommand(oMember3, ClearAllActions());\r\n        AssignCommand(oMember3, JumpToLocation(lTarget));\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Spawn Messenger\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Determines which messenger to spawn in for a specific planet.\r\n    Uses the waypoint K_MESSENGER_SPAWN to determine where to place an incoming messenger\r\n\r\n    Carth: KOR_DANEL == 1. Messenger = Jordo.\r\n    Bastila: K_SWG_HELENA == 1. Messenger = Malare.\r\n    Mission: Mis_MissionTalk == 5  Messenger = Lena\r\n    Canderous: G_CAND_STATE == 8, G_CAND_PLOT == 0, K_CURRENT_PLANET != 35.  Messenger = Jagi\r\n    Juhani: G_JUHANIH_STATE == 7, G_JUHANI_PLOT == 0. Messenger = Xor\r\n    \r\n    Endar Spire     5\r\n    Taris           10\r\n    Dantooine       15\r\n    --Kashyyk       20\r\n    --Manaan        25\r\n    --Korriban      30\r\n    --Tatooine      35\r\n    Leviathan       40\r\n    Unknown World   45\r\n    Star Forge      50\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Sept 26, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid UT_SpawnMessenger()\r\n{\r\n    object oPC = GetFirstPC();\r\n    object oWay = GetWaypointByTag("K_MESSENGER_SPAWN");\r\n    object oNPC;\r\n    int nGlobal_1, nGlobal_2;\r\n    location lLocal;\r\n    int bConditional = FALSE;\r\n    int nXor = GetGlobalNumber("K_XOR_AMBUSH");\r\n\r\n    //Do not fire any messenger plots on Kashyyyk if Chuundar is dead\r\n    if(GetGlobalNumber("K_CURRENT_PLANET") == 20)\r\n    {\r\n        bConditional = GetGlobalBoolean("kas_ChuundarDead");\r\n    }\r\n    if(bConditional == FALSE)\r\n    {\r\n        if(nXor == 0 || nXor > 2)\r\n        {\r\n            if(GetIsObjectValid(oWay))\r\n            {\r\n                lLocal = GetLocation(oWay);\r\n                //MODIFIED by Preston Watamaniuk on April 11\r\n                //Added the exchange crony Ziagrom to tell the PC about the special store.\r\n                if(GetGlobalNumber("K_KOTOR_MASTER") >= 20 &&\r\n                   GetGlobalNumber("K_Exchange_Store") == 0 &&\r\n                   GetGlobalBoolean("K_MESS_ZIAGROM") == FALSE)\r\n                {\r\n                    SetGlobalBoolean("K_MESS_ZIAGROM", TRUE);\r\n                    oNPC = CreateObject(OBJECT_TYPE_CREATURE, "g_Ziagrom", lLocal);\r\n                    NoClicksFor(2.2);\r\n                    DelayCommand(2.0,  AssignCommand(oNPC, ActionStartConversation(oPC,"",FALSE, CONVERSATION_TYPE_CINEMATIC, TRUE)));\r\n                    return;\r\n                }\r\n                if(IsNPCPartyMember(NPC_BASTILA) &&\r\n                   GetGlobalBoolean("K_MESS_BASTILA") == FALSE &&\r\n                   GetGlobalNumber("K_CURRENT_PLANET") != 25 &&\r\n                   GetGlobalNumber("K_SWG_HELENA") == 1)\r\n                {\r\n                        SetGlobalBoolean("K_MESSENGER_AVAILABLE", FALSE);\r\n                        SetGlobalBoolean("K_MESS_BASTILA", TRUE);\r\n                        oNPC = CreateObject(OBJECT_TYPE_CREATURE, "g_malare", lLocal);\r\n                        NoClicksFor(2.2);\r\n                        DelayCommand(2.0,  AssignCommand(oNPC, ActionStartConversation(oPC,"",FALSE, CONVERSATION_TYPE_CINEMATIC, TRUE)));\r\n                        //DelayCommand(2.0, UT_NPC_InitConversation(GetTag(oNPC)));\r\n                        return;\r\n                }\r\n                if(IsNPCPartyMember(NPC_CARTH) &&\r\n                   //MODIFIED by Preston Watamaniuk on May 13, 2003\r\n                   //Added a check to make sure the Sith Acadamy is not closed before spawning in Jordo.\r\n                   GetGlobalBoolean("KOR_END_HOSTILE") == FALSE &&\r\n                   GetGlobalBoolean("K_MESS_CARTH") == FALSE &&\r\n                   GetGlobalNumber("K_CURRENT_PLANET") != 30 &&\r\n                   GetGlobalNumber("KOR_DANEL") == 1)\r\n                {\r\n                        SetGlobalBoolean("K_MESSENGER_AVAILABLE", FALSE);\r\n                        SetGlobalBoolean("K_MESS_CARTH", TRUE);\r\n                        oNPC = CreateObject(OBJECT_TYPE_CREATURE, "g_jordo", lLocal);\r\n                        NoClicksFor(2.2);\r\n                        DelayCommand(2.0,  AssignCommand(oNPC, ActionStartConversation(oPC,"",FALSE, CONVERSATION_TYPE_CINEMATIC, TRUE)));\r\n                        //DelayCommand(2.0, UT_NPC_InitConversation(GetTag(oNPC)));\r\n                        return;\r\n                }\r\n                if(IsNPCPartyMember(NPC_JOLEE) &&\r\n                   GetGlobalBoolean("K_MESS_JOLEE") == FALSE &&\r\n                   GetGlobalNumber("K_CURRENT_PLANET") != 25 &&\r\n                   GetGlobalNumber("K_CURRENT_PLANET") != 20 &&\r\n                   GetGlobalNumber("MAN_MURDER_PLOT") == 0)\r\n                {\r\n                        SetGlobalBoolean("K_MESSENGER_AVAILABLE", FALSE);\r\n                        SetGlobalBoolean("K_MESS_JOLEE", TRUE);\r\n                        oNPC = CreateObject(OBJECT_TYPE_CREATURE, "g_davink", lLocal);\r\n                        NoClicksFor(2.2);\r\n                        DelayCommand(2.0,  AssignCommand(oNPC, ActionStartConversation(oPC,"",FALSE, CONVERSATION_TYPE_CINEMATIC, TRUE)));\r\n                        //DelayCommand(2.0, UT_NPC_InitConversation(GetTag(oNPC)));\r\n                        return;\r\n                }\r\n                if(IsNPCPartyMember(NPC_JUHANI) &&\r\n                   GetGlobalBoolean("K_MESS_JUHANI") == FALSE &&\r\n                   (GetGlobalNumber("G_JUHANIH_STATE") > 5 && GetGlobalNumber("G_JUHANIP_STATE") < 10) &&\r\n                   GetGlobalNumber("G_JUHANI_PLOT") == 0 &&\r\n                   GetGlobalNumber("K_CURRENT_PLANET") != 15)\r\n                {\r\n                        //juhanih_state > 5, and juhanip_state < 10\r\n                        SetGlobalBoolean("K_MESSENGER_AVAILABLE", FALSE);\r\n                        SetGlobalBoolean("K_MESS_JUHANI", TRUE);\r\n                        oNPC = CreateObject(OBJECT_TYPE_CREATURE, "g_xor", lLocal);\r\n                        NoClicksFor(2.2);\r\n                        DelayCommand(2.0,  AssignCommand(oNPC, ActionStartConversation(oPC,"",FALSE, CONVERSATION_TYPE_CINEMATIC, TRUE)));\r\n                        //DelayCommand(2.0, UT_NPC_InitConversation(GetTag(oNPC)));\r\n                        return;\r\n                }\r\n                if(IsNPCPartyMember(NPC_CANDEROUS) &&\r\n                   GetGlobalBoolean("K_MESS_CANDEROUS") == FALSE &&\r\n                   GetGlobalNumber("K_CURRENT_PLANET") != 35 &&\r\n                   GetGlobalNumber("G_CAND_STATE") >= 6 &&\r\n                   GetGlobalBoolean("G_CAND_THING") == TRUE &&\r\n                   GetGlobalNumber("G_CAND_PLOT") == 0)\r\n                {\r\n                        SetGlobalBoolean("K_MESSENGER_AVAILABLE", FALSE);\r\n                        SetGlobalBoolean("K_MESS_CANDEROUS", TRUE);\r\n                        oNPC = CreateObject(OBJECT_TYPE_CREATURE, "g_jagi", lLocal);\r\n                        NoClicksFor(2.2);\r\n                        DelayCommand(2.0,  AssignCommand(oNPC, ActionStartConversation(oPC,"",FALSE, CONVERSATION_TYPE_CINEMATIC, TRUE)));\r\n                        //DelayCommand(2.0, UT_NPC_InitConversation(GetTag(oNPC)));\r\n                        return;\r\n                }\r\n                if(IsNPCPartyMember(NPC_MISSION) &&\r\n                   GetGlobalBoolean("K_MESS_MISSION") == FALSE &&\r\n                   GetGlobalNumber("K_CURRENT_PLANET") != 35 &&\r\n                   GetGlobalNumber("K_CURRENT_PLANET") != 25 &&\r\n                   GetGlobalNumber("Mis_MissionTalk") == 5)\r\n                {\r\n                        SetGlobalBoolean("K_MESSENGER_AVAILABLE", FALSE);\r\n                        SetGlobalBoolean("K_MESS_MISSION", TRUE);\r\n                        oNPC = CreateObject(OBJECT_TYPE_CREATURE, "g_lena", lLocal);\r\n                        NoClicksFor(2.2);\r\n                        DelayCommand(2.0,  AssignCommand(oNPC, ActionStartConversation(oPC,"",FALSE, CONVERSATION_TYPE_CINEMATIC, TRUE)));\r\n                        //DelayCommand(2.0, UT_NPC_InitConversation(GetTag(oNPC)));\r\n                        return;\r\n                }\r\n            }\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Exit Area\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    The NPC moves to an SW_EXIT waypoint and destroys\r\n    itself.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Sept 27, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_ExitArea(int nRun = FALSE)\r\n{\r\n    object oExit = GetWaypointByTag("SW_EXIT");\r\n    object oExit2 = GetWaypointByTag("K_EXIT");\r\n\r\n    if(GetIsObjectValid(oExit) && GetIsObjectValid(oExit2))\r\n    {\r\n        if(GetDistanceBetween(OBJECT_SELF, oExit) > GetDistanceBetween(OBJECT_SELF, oExit2))\r\n        {\r\n            oExit = oExit2;\r\n        }\r\n    }\r\n    else if(GetIsObjectValid(oExit2) && !GetIsObjectValid(oExit))\r\n    {\r\n        oExit = oExit2;\r\n    }\r\n\r\n    ActionForceMoveToObject(oExit, nRun);\r\n    ActionDoCommand(SetCommandable(TRUE));\r\n    ActionDoCommand(DestroyObject(OBJECT_SELF));\r\n    SetCommandable(FALSE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UT_GetNumItems\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Counts the number of items with the given tag\r\n    in the party inventory.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: John Winski\r\n//:: Created On: October 15, 2002\r\n//:://////////////////////////////////////////////\r\nint UT_GetNumItems(object oTarget, string sItemTag)\r\n{\r\n    int nCount = 0;\r\n    object oItem = GetFirstItemInInventory(oTarget);\r\n\r\n    while (GetIsObjectValid(oItem) == TRUE)\r\n    {\r\n        if (GetTag(oItem) == sItemTag)\r\n        {\r\n            nCount = nCount + 1;\r\n        }\r\n\r\n        oItem = GetNextItemInInventory(oTarget);\r\n    }\r\n\r\n    return nCount;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Determines Item Cost\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns a value for how many parts or spikes\r\n    a given dialogue option will cost.  The costs\r\n    are as follows:\r\n    Computer Use\r\n    1.  Open all doors in area (cost: 3 spikes). The player can open all doors on the level.\r\n    2.  Open all containers in area (cost: 3 spikes). The player can open all containers on the level.\r\n    3.  Fill security room with gas (cost: 5 spikes).\r\n    4.  Turn off all gun turrets (cost: 8 spikes).\r\n    5.  Modify droid programming; target everything (cost: 10 spikes).\r\n    6.  Deactivate all droids in area (cost: 8 spikes).\r\n\r\n    Repair Use\r\n    1.  Activate droid. Hostile to Sith faction. (cost: 3 repair unit)\r\n    2.  Activate droid. Hostile to Sith faction. Enter patrol route. (cost: 5 repair unit)\r\n    3.  Activate droid. Hostile to Sith faction. Hunter Killer mode. (cost: 7 repair unit)\r\n    4.  Activate droid. Hostile to Sith faction. Follow mode. (cost: 5 repair unit)\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: PReston Watamaniuk\r\n//:: Created On: Nov 19, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint UT_DeterminesItemCost(int nDC, int nSkill)\r\n{\r\n        //AurPostString("DC " + IntToString(nDC), 5, 5, 3.0);\r\n    float fModSkill =  IntToFloat(GetSkillRank(nSkill, GetPartyMemberByIndex(0)));\r\n        //AurPostString("Skill Total " + IntToString(GetSkillRank(nSkill, GetPartyMemberByIndex(0))), 5, 6, 3.0);\r\n    int nUse;\r\n    fModSkill = fModSkill/4.0;\r\n    nUse = nDC - FloatToInt(fModSkill);\r\n        //AurPostString("nUse Raw " + IntToString(nUse), 5, 7, 3.0);\r\n    if(nUse < 1)\r\n    {\r\n        //MODIFIED by Preston Watamaniuk, March 19\r\n        //Put in a check so that those PC with a very high skill\r\n        //could have a cost of 0 for doing computer work\r\n        if(nUse <= -3)\r\n        {\r\n            nUse = 0;\r\n        }\r\n        else\r\n        {\r\n            nUse = 1;\r\n        }\r\n    }\r\n        //AurPostString("nUse Final " + IntToString(nUse), 5, 8, 3.0);\r\n    return nUse;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Remove X number of Computer Spikes\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Remove a number of computer spikes\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 19, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_RemoveComputerSpikes(int nNumber)\r\n{\r\n    object oItem = GetItemPossessedBy(GetFirstPC(), "K_COMPUTER_SPIKE");\r\n    if(GetIsObjectValid(oItem))\r\n    {\r\n        int nStackSize = GetItemStackSize(oItem);\r\n        if(nNumber < nStackSize)\r\n        {\r\n            nNumber = nStackSize - nNumber;\r\n            SetItemStackSize(oItem, nNumber);\r\n        }\r\n        else if(nNumber > nStackSize || nNumber == nStackSize)\r\n        {\r\n            DestroyObject(oItem);\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Remove X number of Repair Parts\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Remove a number of repair parts\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 19, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_RemoveRepairParts(int nNumber)\r\n{\r\n    object oItem = GetItemPossessedBy(GetFirstPC(), "K_REPAIR_PART");\r\n    if(GetIsObjectValid(oItem))\r\n    {\r\n        int nStackSize = GetItemStackSize(oItem);\r\n        if(nNumber < nStackSize)\r\n        {\r\n            nNumber = nStackSize - nNumber;\r\n            SetItemStackSize(oItem, nNumber);\r\n        }\r\n        else if(nNumber > nStackSize || nNumber == nStackSize)\r\n        {\r\n            DestroyObject(oItem);\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Return item amount\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Depending on the skill chosen, returns the\r\n    number items relating to that skill\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 19, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint UT_ReturnSpikePartAmount(int nSkill)\r\n{\r\n    string sItem;\r\n    int nCount = 0;\r\n    if(nSkill == SKILL_COMPUTER_USE)\r\n    {\r\n        sItem = "K_COMPUTER_SPIKE";\r\n    }\r\n    else if(nSkill == SKILL_REPAIR)\r\n    {\r\n        sItem = "K_REPAIR_PART";\r\n    }\r\n    object oItem = GetItemPossessedBy(GetFirstPC(), sItem);\r\n    if(GetIsObjectValid(oItem))\r\n    {\r\n        nCount = GetNumStackedItems(oItem);\r\n    }\r\n    return nCount;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Make Neutral\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Searches the area and changes all object with\r\n    the specified tag to the neutral faction\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 20, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_MakeNeutral(string sObjectTag)\r\n{\r\n    effect eStun = EffectDroidStun();\r\n    int nCount = 1;\r\n    object oDroid = GetNearestObjectByTag(sObjectTag);\r\n    while(GetIsObjectValid(oDroid))\r\n    {\r\n        ApplyEffectToObject(DURATION_TYPE_PERMANENT, eStun, oDroid);\r\n        nCount++;\r\n        oDroid = GetNearestObjectByTag(sObjectTag, OBJECT_SELF, nCount);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Make Insane\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Searches the area and changes all objects with\r\n    the specified tag to the insane faction\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 20, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_MakeInsane(string sObjectTag)\r\n{\r\n    int nCount = 1;\r\n    object oDroid = GetNearestObjectByTag(sObjectTag);\r\n    while(GetIsObjectValid(oDroid))\r\n    {\r\n        ChangeToStandardFaction(oDroid, STANDARD_FACTION_INSANE);\r\n        UT_StartCombat(oDroid);\r\n\r\n        nCount++;\r\n        oDroid = GetNearestObjectByTag(sObjectTag, OBJECT_SELF, nCount);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Stun Droids\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Searches the area and changes all objects with\r\n    the specified tag to the insane faction\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 20, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_StunDroids(string sObjectTag)\r\n{\r\n    effect eStun = EffectDroidStun();\r\n    int nCount = 1;\r\n    object oDroid = GetNearestObjectByTag(sObjectTag);\r\n    while(GetIsObjectValid(oDroid))\r\n    {\r\n        ApplyEffectToObject(DURATION_TYPE_PERMANENT, eStun, oDroid);\r\n        nCount++;\r\n        oDroid = GetNearestObjectByTag(sObjectTag, OBJECT_SELF, nCount);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Start a Fight\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Gets the nearest enemy that is seen and start combat\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 21, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_StartCombat(object oObject)\r\n{\r\n    AssignCommand(oObject, ActionAttack(GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_ENEMY, oObject, 1, CREATURE_TYPE_PERCEPTION, PERCEPTION_SEEN)));\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Gas a Rooom\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Releases gas into the room and kills all biologicals in the\r\n    specified radius.  The radius should be between 2 - 5m\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 21, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_GasRoom(string sWayTag, float fDistance, int bIndiscriminant = TRUE)\r\n{\r\n    object oWay = GetWaypointByTag(sWayTag);\r\n    object oPC = GetFirstPC();\r\n    if(GetIsObjectValid(oWay))\r\n    {\r\n        effect eVFX = EffectVisualEffect(3006);\r\n        ApplyEffectAtLocation(DURATION_TYPE_INSTANT, eVFX, GetLocation(oWay));\r\n        object oTarget = GetNearestCreature(CREATURE_TYPE_RACIAL_TYPE, RACIAL_TYPE_HUMAN, oWay, 1);\r\n        int nCount = 1;\r\n        while(GetIsObjectValid(oTarget) && GetDistanceBetween(oTarget, oWay) <= fDistance)\r\n        {\r\n            float fDelay = 3.0 + (IntToFloat(d10())/10.0);\r\n            float fDelay2 = fDelay + 1.0 + (IntToFloat(d20())/10.0);\r\n\r\n            if((GetIsFriend(oTarget, oPC) || GetIsNeutral(oTarget, oPC)) && bIndiscriminant == FALSE)\r\n            {\r\n                DelayCommand(fDelay, ApplyEffectToObject(DURATION_TYPE_TEMPORARY, EffectChoke(), oTarget, 3.0));\r\n                DelayCommand(fDelay2, ApplyEffectToObject(DURATION_TYPE_PERMANENT, EffectPoison(POISON_ABILITY_SCORE_VIRULENT),oTarget));\r\n            }\r\n            else if(GetIsEnemy(oTarget, oPC) || bIndiscriminant == TRUE)\r\n            {\r\n                DelayCommand(fDelay, ApplyEffectToObject(DURATION_TYPE_TEMPORARY, EffectChoke(), oTarget, 10.0));\r\n                DelayCommand(fDelay2, ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectDeath(), oTarget));\r\n            }\r\n            nCount++;\r\n            oTarget = GetNearestCreature(CREATURE_TYPE_RACIAL_TYPE, RACIAL_TYPE_HUMAN, oWay, nCount);\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Overload Conduit\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Overloads a power conduit and does 10d6 damage\r\n    to all within the specified radius\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Nov 21, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid UT_OverloadConduit(string sObjectTag, float fDistance, int bIndiscriminant = TRUE)\r\n{\r\n    object oWay = GetObjectByTag(sObjectTag);\r\n    if(GetIsObjectValid(oWay))\r\n    {\r\n        effect eFNF = EffectVisualEffect(VFX_FNF_GRENADE_ION);\r\n        effect eVFXHit = EffectVisualEffect(1021);\r\n        effect eVFXBeam = EffectBeam(VFX_BEAM_LIGHTNING_DARK_L, oWay, BODY_NODE_CHEST);\r\n        effect eDam;\r\n\r\n        object oTarget = GetNearestObject(OBJECT_TYPE_CREATURE, oWay, 1);\r\n        int nCount = 1;\r\n        int nDam = 1000;\r\n        float fDelay = 0.3;\r\n\r\n        AssignCommand(oWay, ActionPlayAnimation(ANIMATION_PLACEABLE_OPEN));\r\n\r\n        DelayCommand(0.3, ApplyEffectAtLocation(DURATION_TYPE_INSTANT, eFNF, GetLocation(oWay)));\r\n        while(GetIsObjectValid(oTarget) && GetDistanceBetween(oTarget, oWay) <= fDistance)\r\n        {\r\n            if(bIndiscriminant == TRUE || GetIsEnemy(oTarget, GetFirstPC()))\r\n            {\r\n                eDam = EffectDamage(nDam, DAMAGE_TYPE_ELECTRICAL);\r\n                DelayCommand(fDelay, ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oTarget));\r\n                DelayCommand(fDelay, ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eVFXBeam, oTarget, 1.0));\r\n                DelayCommand(fDelay, ApplyEffectToObject(DURATION_TYPE_INSTANT, eVFXHit, oTarget, 1.0));\r\n                fDelay = fDelay + 0.17;\r\n            }\r\n            nCount++;\r\n            oTarget = GetNearestObject(OBJECT_TYPE_CREATURE, oWay, nCount);\r\n        }\r\n        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_PRO_DROID_KILL), oWay);\r\n\r\n    }\r\n}\r\n\r\n///////////////////////////////////////////////////////////////////////////////\r\n/*\r\n    UT_ReturnToBase\r\n    This function is used in the user defined event of a creature crossing a\r\n    trigger used to pen in hostile creatures. When a creature crosses the\r\n    trigger, it\'s actions are cleared, it is sent to the homebase waypoint and\r\n    it is set non commanble. Once reaching its destination, it becomes\r\n    commandable again. By defaut the standard tag for the waypoint is given, but\r\n    a different one may be specified\r\n\r\n    Created by Aidan Scanlan\r\n    On Dec 2, 2002\r\n*/\r\n///////////////////////////////////////////////////////////////////////////////\r\nvoid UT_ReturnToBase(string sTag = "wp_homebase")\r\n{\r\n    object oSelf = OBJECT_SELF;\r\n    if(GetCommandable(oSelf))\r\n    {\r\n        ClearAllActions();\r\n        CancelCombat(oSelf);\r\n        ActionMoveToObject(GetNearestObjectByTag("wp_homebase"),TRUE,3.0f);\r\n        ActionDoCommand( SetCommandable(TRUE,oSelf));\r\n        SetCommandable(FALSE);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UT_NPC_InitConversation\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    The specified NPC will start a conversation\r\n    with the player.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: John Winski\r\n//:: Created On: December 2, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_NPC_InitConversation(string sNPCTag,string sDlg = "",object oEntered = OBJECT_INVALID)\r\n{\r\n    object oNPC = GetObjectByTag(sNPCTag);\r\n    object oPC = GetFirstPC();\r\n    UT_RestorePartyToOneHealth();\r\n    // The NPC must exist.\r\n    if (GetIsObjectValid(oNPC) == TRUE)\r\n    {\r\n        if (oPC == GetPartyMemberByIndex(0))\r\n        {\r\n            AssignCommand(oPC, ClearAllActions());\r\n            AssignCommand(oNPC, ClearAllActions());\r\n            CancelCombat(oPC);\r\n            AssignCommand(oNPC, ActionStartConversation(oPC, sDlg, FALSE, CONVERSATION_TYPE_CINEMATIC, TRUE));\r\n        }\r\n        else\r\n        {\r\n            // Fade to black, switch player control to the main character,\r\n            // move the player to the NPC and start conversation.\r\n\r\n            SetGlobalFadeOut();\r\n            SetPartyLeader(NPC_PLAYER);\r\n\r\n            object oParty1 = GetPartyMemberByIndex(1);\r\n            object oParty2 = GetPartyMemberByIndex(2);\r\n            \r\n            //P.W. (June 7) - Put this in to terminate any player input during the fade.\r\n            NoClicksFor(0.7);\r\n            AssignCommand(oPC, ClearAllActions());\r\n            AssignCommand(oNPC, ClearAllActions());\r\n            CancelCombat(oPC);\r\n            if (GetIsObjectValid(oEntered) == TRUE)\r\n            {\r\n                AssignCommand(oPC, DelayCommand(0.2, JumpToObject(oEntered)));\r\n                AssignCommand(oPC, DelayCommand(0.4, SetFacingPoint(GetPosition(oNPC))));\r\n            }\r\n            else\r\n            {\r\n                AssignCommand(oPC, DelayCommand(0.2, JumpToObject(oNPC)));\r\n            }\r\n            AssignCommand(oParty1, DelayCommand(0.5, JumpToObject(oPC)));\r\n            AssignCommand(oParty2, DelayCommand(0.5, JumpToObject(oPC)));\r\n            AssignCommand(oNPC, ActionDoCommand(SetGlobalFadeIn(0.5, 2.0)));\r\n            AssignCommand(oNPC, ActionStartConversation(oPC, sDlg, FALSE, CONVERSATION_TYPE_CINEMATIC, TRUE));\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Set Starmap Journal\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Sets the Journal entry for the starmap\r\n    automatically.\r\n\r\n    Korriban - entry 10\r\n    Tatooine - entry 20\r\n    Kashyyyk - entry 30\r\n    Manaan   - entry 40\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamanmiuk\r\n//:: Created On: Dec 17, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid UT_SetStarmapJournal()\r\n{\r\n    string sModule = GetModuleFileName();\r\n    if(sModule == "manm28ad") //Manaan\r\n    {\r\n        SetGlobalBoolean("K_STAR_MAP_MANAAN", TRUE);\r\n        AddJournalQuestEntry("k_starforge", 40, TRUE);\r\n    }\r\n    else if(sModule == "korr_m39aa") //Korriban\r\n    {\r\n        SetGlobalBoolean("K_STAR_MAP_KORRIBAN", TRUE);\r\n        AddJournalQuestEntry("k_starforge", 10, TRUE);\r\n    }\r\n    else if(sModule == "Kas_m25aa") //Kashyyyk\r\n    {\r\n        SetGlobalBoolean("K_STAR_MAP_KASHYYYK", TRUE);\r\n        AddJournalQuestEntry("k_starforge", 30, TRUE);\r\n    }\r\n    else if(sModule == "Tat_m18ac") //Tatooine\r\n    {\r\n        SetGlobalBoolean("K_STAR_MAP_TATOOINE", TRUE);\r\n        AddJournalQuestEntry("k_starforge", 20, TRUE);\r\n    }\r\n    if(GetGlobalNumber("K_STAR_MAP") == 50)\r\n    {\r\n        AddJournalQuestEntry("k_starforge", 50, TRUE);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Spawn Creatures\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Creates number of creatures with a specific template at a specified waypoint tag.\r\n    Total is the number times the loop will run.\r\n    fTimeDelay is the number seconds between iterations.\r\n    nSpawnIncrement is the number of templates spawned in per iteration.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamanmiuk\r\n//:: Created On: Dec 17, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_RunCombatEncounter(string sTemplate, string sTag, int nTotal = 3, float fTimeDelay = 1.5, int nSpawnIncrement = 1)\r\n{\r\n    if(fTimeDelay < 1.5)\r\n    {\r\n       fTimeDelay = 1.5;\r\n    }\r\n    object oWay = GetWaypointByTag(sTag);\r\n    object oCreate;\r\n    if(GetIsObjectValid(oWay))\r\n    {\r\n        int nCount = nSpawnIncrement;\r\n        for(nCount; nCount != 0; nCount--)\r\n        {\r\n            oCreate = CreateObject(OBJECT_TYPE_CREATURE, sTemplate, GetLocation(oWay));\r\n        }\r\n        nTotal--;\r\n        if(nTotal > 0)\r\n        {\r\n            DelayCommand(fTimeDelay, UT_RunCombatEncounter(sTemplate, sTag, nTotal, fTimeDelay, nSpawnIncrement));\r\n        }\r\n        fTimeDelay += fTimeDelay;\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Set Talk To Flag by Tag\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Loops through all object with a certain tag\r\n    and sets their Talk To Flag to TRUE.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamanmiuk\r\n//:: Created On: Dec 17, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_SetTalkToFlagByTag(string sTag)\r\n{\r\n    int nCnt = 1;\r\n    object oTrigger = GetNearestObjectByTag(sTag, GetFirstPC(), nCnt);\r\n    while(GetIsObjectValid(oTrigger))\r\n    {\r\n        SetLocalBoolean(oTrigger, SW_PLOT_HAS_TALKED_TO, TRUE);\r\n        nCnt++;\r\n        oTrigger = GetNearestObjectByTag(sTag, GetFirstPC(), nCnt);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Lock / Plot Twin Doors\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Loops through all doors with a certain tag\r\n    and closes, locks and plots them.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamanmiuk\r\n//:: Created On: Dec 17, 2002\r\n//:://////////////////////////////////////////////\r\nvoid UT_LockDoorDuplicates(string sTag)\r\n{\r\n    int nCount;\r\n    object oDoor = GetNearestObjectByTag(sTag);\r\n    while(GetIsObjectValid(oDoor) && GetObjectType(oDoor) == OBJECT_TYPE_DOOR)\r\n    {\r\n        if(oDoor != OBJECT_SELF)\r\n        {\r\n            AssignCommand(oDoor, ActionCloseDoor(oDoor));\r\n            AssignCommand(oDoor, ActionLockObject(oDoor));\r\n            AssignCommand(oDoor, SetPlotFlag(oDoor, TRUE));\r\n        }\r\n        nCount++;\r\n        oDoor = GetNearestObjectByTag(sTag, OBJECT_SELF, nCount);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Can Party Member Interject\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Check to see if the Party member specified is\r\n    in the party and within the distance given.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Jan 10, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nint UT_CheckCanPartyMemberInterject(int nNPC_Constant, float fDistance)\r\n{\r\n    object oParty;\r\n\r\n    if(IsNPCPartyMember(nNPC_Constant))\r\n    {\r\n        //MODIFIED by Preston Watamaniuk on April 24, 2003\r\n        //Put this in so that NPCs who you turn down on a planet will not reinitiate on that planet again.\r\n        int nPlanet = GetGlobalNumber("K_CURRENT_PLANET");\r\n        string sConstant = "NPC_INIT_PLANET_";\r\n        sConstant = "NPC_INIT_PLANET_" + IntToString(nNPC_Constant);\r\n        int nConstant = GetGlobalNumber(sConstant);\r\n\r\n        if(nNPC_Constant == NPC_BASTILA)\r\n        {\r\n            oParty = GetObjectByTag("Bastila");\r\n        }\r\n        else if(nNPC_Constant == NPC_CANDEROUS)\r\n        {\r\n            oParty = GetObjectByTag("Cand");\r\n        }\r\n        else if(nNPC_Constant == NPC_CARTH)\r\n        {\r\n            oParty = GetObjectByTag("Carth");\r\n        }\r\n        else if(nNPC_Constant == NPC_HK_47)\r\n        {\r\n            oParty = GetObjectByTag("HK47");\r\n        }\r\n        else if(nNPC_Constant == NPC_JOLEE)\r\n        {\r\n            oParty = GetObjectByTag("Jolee");\r\n        }\r\n        else if(nNPC_Constant == NPC_JUHANI)\r\n        {\r\n            oParty = GetObjectByTag("Juhani");\r\n        }\r\n        else if(nNPC_Constant == NPC_MISSION)\r\n        {\r\n            oParty = GetObjectByTag("Mission");\r\n        }\r\n        else if(nNPC_Constant == NPC_T3_M4)\r\n        {\r\n            oParty = GetObjectByTag("T3M4");\r\n        }\r\n        else if(nNPC_Constant == NPC_ZAALBAR)\r\n        {\r\n            oParty = GetObjectByTag("Zaalbar");\r\n        }\r\n        if(GetIsObjectValid(oParty) &&\r\n           GetDistanceBetween(oParty, GetFirstPC()) <= fDistance &&\r\n           nPlanet != nConstant)\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Reinitialize NPC Planet Constants\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This resets the variables for each party member\r\n    that controls whether they will init on a\r\n    particular planet.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 24, 2003\r\n//:://////////////////////////////////////////////\r\nvoid UT_ReinitializePartyPlanetVariables()\r\n{\r\n    string sConstant = "NPC_INIT_PLANET_";\r\n    int nCnt = 0;\r\n\r\n    for(nCnt; nCnt <= 8; nCnt++)\r\n    {\r\n        sConstant = "NPC_INIT_PLANET_" + IntToString(nCnt);\r\n        SetGlobalNumber(sConstant, 0);\r\n    }\r\n}\r\n\r\n//teleport party member\r\nvoid UT_TeleportPartyMember(object oPartyMember, location lDest)\r\n{\r\n\r\n  if(!GetIsObjectValid(oPartyMember))\r\n  {\r\n    return;\r\n  }\r\n  if(GetCurrentHitPoints(oPartyMember) < 1)\r\n  {\r\n    ApplyEffectToObject(DURATION_TYPE_INSTANT,EffectResurrection(),oPartyMember);\r\n    ApplyEffectToObject(DURATION_TYPE_INSTANT,EffectHeal(1),oPartyMember);\r\n  }\r\n  SetCommandable(TRUE,oPartyMember);\r\n  AssignCommand(oPartyMember,ClearAllActions());\r\n  AssignCommand(oPartyMember,ActionJumpToLocation(lDest));\r\n}\r\n\r\n//Returns true if oTarget is the object of interest of an attacker\r\nint UT_GetUnderAttack(object oTarget)\r\n{\r\n  if(!GetIsObjectValid(oTarget))\r\n  {\r\n    return(FALSE);\r\n  }\r\n\r\n  object oAttacker = GetLastHostileActor(oTarget);\r\n  return(GetIsObjectValid(oAttacker) || !GetIsDead(oAttacker) || GetObjectSeen(oAttacker, oTarget));\r\n}\r\n\r\n//:://////////////////////////////////////////////\r\n/*\r\n     This include handles jumping the party to the\r\n     specified locations, good for controlling\r\n     positions at the start of a cutscene.\r\n\r\n     They will also be faced in the direction of\r\n     the waypoints or objects they are being\r\n     jumped to.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Brad Prince\r\n//:: Created On: Jan 23, 2003\r\n//:://////////////////////////////////////////////\r\nvoid UT_TeleportWholeParty(object oWP0, object oWP1, object oWP2)\r\n{\r\n   // The member the PC is in control of.\r\n   object oMember0 = GetPartyMemberByIndex(0);\r\n   // The second party member.\r\n   object oMember1 = GetPartyMemberByIndex(1);\r\n   // The third member.\r\n   object oMember2 = GetPartyMemberByIndex(2);\r\n   UT_RestorePartyToOneHealth();\r\n   if(GetIsObjectValid(oMember0)) {\r\n      UT_TeleportPartyMember(oMember0, GetLocation(oWP0));\r\n      AssignCommand(oMember0, SetFacing(GetFacing(oWP0)));\r\n   }\r\n   if(GetIsObjectValid(oMember1)) {\r\n      UT_TeleportPartyMember(oMember1, GetLocation(oWP1));\r\n      DelayCommand(0.3, AssignCommand(oMember1, SetFacing(GetFacing(oWP1))));\r\n   }\r\n   if(GetIsObjectValid(oMember2)) {\r\n      UT_TeleportPartyMember(oMember2, GetLocation(oWP2));\r\n      DelayCommand(0.3, AssignCommand(oMember2, SetFacing(GetFacing(oWP2))));\r\n   }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Action Pause Converation\r\n//:: Copyright (c) 2003 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n     This will stop and start a conversation in 1\r\n     step. Just pass the length of the pause.\r\n\r\n     Be sure your commands will get carried out\r\n     in the specified time and that the "pauser"\r\n     is not killed.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Brad Prince\r\n//:: Created On: Jan 23, 2003\r\n//:://////////////////////////////////////////////\r\nvoid UT_ActionPauseConversation(float fDelay)\r\n{\r\n   ActionPauseConversation();\r\n   DelayCommand(fDelay, ActionResumeConversation());\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Spawn Available NPC\r\n//:: Copyright (c) 2003 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Allows the uses to delay command on the creation\r\n    of an NPC.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Feb 5, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nvoid UT_SpawnAvailableNPC(int nNPC, location lWay)\r\n{\r\n    object oNPC = SpawnAvailableNPC(nNPC, lWay);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Set Starmap Variables\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Advances K_STAR_MAP, sets the journal and\r\n    sets the talk to flag.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Feb 19, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nvoid UT_StarMap1VariableSet()\r\n{\r\n    int nStar = GetGlobalNumber("K_STAR_MAP");\r\n    int nBast = GetGlobalNumber("K_SWG_BASTILA");\r\n    int nBool = GetLocalBoolean(OBJECT_SELF, SW_PLOT_HAS_TALKED_TO);\r\n\r\n    if(nBool == FALSE)\r\n    {\r\n        //REMOVE THIS BEFORE SHIP\r\n        AurPostString("v3.0 - K_STAR_MAP Before = " + IntToString(nStar), 5, 5, 5.0);\r\n\r\n        nStar = nStar + 10;\r\n        SetGlobalNumber("K_STAR_MAP",nStar);\r\n\r\n        //REMOVE THIS BEFORE SHIP\r\n        AurPostString("K_STAR_MAP After = " + IntToString(nStar), 5, 7, 5.0);\r\n\r\n        if(nStar == 30)\r\n        {\r\n            if(nBast < 3)\r\n            {\r\n                SetGlobalNumber("K_SWG_BASTILA", 99);\r\n            }\r\n        }\r\n        else if(nStar == 40)\r\n        {\r\n            //The player should now be captured by the Leviathan\r\n            SetGlobalNumber("K_CAPTURED_LEV", 5);\r\n            if(nBast < 5)\r\n            {\r\n                SetGlobalNumber("K_SWG_BASTILA", 99);\r\n            }\r\n        }\r\n        else if(nStar == 50)\r\n        {\r\n            //The player should now have access to the unknown world.\r\n            SetGlobalNumber("K_KOTOR_MASTER", 30);\r\n        }\r\n        SetLocalBoolean(OBJECT_SELF, SW_PLOT_HAS_TALKED_TO, TRUE);\r\n        UT_SetStarmapJournal();\r\n        AurPostString("Manaan Starmap = " + IntToString(GetGlobalBoolean("K_STAR_MAP_MANAAN")), 5, 9, 4.0);\r\n        AurPostString("Kashyyyk Starmap = " + IntToString(GetGlobalBoolean("K_STAR_MAP_KASHYYYK")), 5, 11, 4.0);\r\n        AurPostString("Korriban Starmap = " + IntToString(GetGlobalBoolean("K_STAR_MAP_KORRIBAN")), 5, 13, 4.0);\r\n        AurPostString("Tatooine Starmap = " + IntToString(GetGlobalBoolean("K_STAR_MAP_TATOOINE")), 5, 15, 4.0);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Play Starmap Animations\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Plays the animations necessary for the current\r\n    state of the starmap variable\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Feb 19, 2003\r\n//:://////////////////////////////////////////////\r\nvoid UT_StarMap2PlayAnimation()\r\n{\r\n    int nStar = GetGlobalNumber("K_STAR_MAP");\r\n    int nBool = GetLocalBoolean(OBJECT_SELF, SW_PLOT_HAS_TALKED_TO);\r\n    float fDelay = 30.0;\r\n    if(nBool == FALSE)\r\n    {\r\n        ActionPlayAnimation(ANIMATION_PLACEABLE_ACTIVATE);\r\n        ActionPlayAnimation(UT_StarMap3GetLoopAnim(nStar));\r\n        if(nStar == 40)//This variable is the pre-activation value.  It is going from 40 to 50\r\n        {\r\n            fDelay = 60.0;\r\n        }\r\n        DelayCommand(fDelay, ActionPlayAnimation(ANIMATION_PLACEABLE_DEACTIVATE));\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Returns the Appropriate Starmap Anim Loop\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns the appropriate animation loop for the\r\n    Star Map based on the value used before the\r\n    new variable is set.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Feb 19, 2003\r\n//:://////////////////////////////////////////////\r\nint UT_StarMap3GetLoopAnim(int nStarMapVar)\r\n{\r\n    if(nStarMapVar == 0)\r\n    {\r\n        return ANIMATION_PLACEABLE_ANIMLOOP01;\r\n    }\r\n    else if(nStarMapVar == 10)\r\n    {\r\n        return ANIMATION_PLACEABLE_ANIMLOOP02;\r\n    }\r\n    else if(nStarMapVar == 20)\r\n    {\r\n        return ANIMATION_PLACEABLE_ANIMLOOP03;\r\n    }\r\n    else if(nStarMapVar == 30)\r\n    {\r\n        return ANIMATION_PLACEABLE_ANIMLOOP04;\r\n    }\r\n    else if(nStarMapVar == 40)\r\n    {\r\n        return ANIMATION_PLACEABLE_ANIMLOOP06;\r\n    }\r\n\r\n    return -1;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Generic Starmap Handler\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Runs the entire Starmap sequence as a black\r\n    box with no extra scripting required.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Feb 19, 2003\r\n//:://////////////////////////////////////////////\r\nvoid UT_StarMap4RunStarMap()\r\n{\r\n    UT_StarMap2PlayAnimation();\r\n    UT_StarMap1VariableSet();\r\n}\r\n\r\n//////////////////////////////////////////////////////////////////////\r\n/*    This function removes party members. It stores the npc constants\r\n    of the removed party members.\r\n\r\n    Aidan-Feb 20,03\r\n*/\r\n//////////////////////////////////////////////////////////////////////\r\nvoid UT_StoreParty()\r\n{\r\n    if(GetPartyMemberByIndex(0) != GetFirstPC())\r\n    {\r\n        SetPartyLeader(NPC_PLAYER);\r\n    }\r\n    object oNPC1 = GetPartyMemberByIndex(1);\r\n    object oNPC2 = GetPartyMemberByIndex(2);\r\n\r\n\r\n    int nIdx, bFound1, bFound2, bRemove;\r\n    for (nIdx = NPC_BASTILA; nIdx <= NPC_ZAALBAR && !bFound2; nIdx++)\r\n    {\r\n        bRemove = IsNPCPartyMember(nIdx);\r\n        if(bRemove)\r\n        {\r\n            if(bFound1 == FALSE)\r\n            {\r\n                RemovePartyMember(nIdx);\r\n                SetGlobalNumber("K_PARTY_STORE1",nIdx);\r\n                bFound1 = TRUE;\r\n                SetGlobalBoolean("K_PARTY_STORED",TRUE);\r\n            }\r\n            else\r\n            {\r\n                RemovePartyMember(nIdx);\r\n                SetGlobalNumber("K_PARTY_STORE2",nIdx);\r\n                bFound2 = TRUE;\r\n                SetGlobalBoolean("K_PARTY_STORED",TRUE);\r\n            }\r\n        }\r\n\r\n\r\n        bRemove = FALSE;\r\n    }\r\n    if(GetIsObjectValid(oNPC1))\r\n    {\r\n        DestroyObject(oNPC1);\r\n    }\r\n    if(GetIsObjectValid(oNPC2))\r\n    {\r\n        DestroyObject(oNPC2);\r\n    }\r\n\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Restore NPC\r\n//:: Copyright (c) 2003 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This function restore party members. It will only\r\n    restore party members removed via the\r\n    UT_StoreParty function\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Aidan Scanlan\r\n//:: Created On: Feb 20, 2003\r\n//:://////////////////////////////////////////////\r\nvoid UT_RestoreParty()\r\n{\r\n    int nNPC1 = GetGlobalNumber("K_PARTY_STORE1");\r\n    int nNPC2 = GetGlobalNumber("K_PARTY_STORE2");\r\n    object oNPC;\r\n    if(GetGlobalBoolean("K_PARTY_STORED"))\r\n    {\r\n        if(nNPC1 >= NPC_BASTILA && nNPC1 <= NPC_ZAALBAR)\r\n        {\r\n            if(GetIsObjectValid(GetPartyMemberByIndex(1)) == FALSE)\r\n            {\r\n                oNPC = SpawnAvailableNPC(nNPC1,GetLocation(GetFirstPC()));\r\n                if(GetIsObjectValid(oNPC))\r\n                {\r\n                    AddPartyMember(nNPC1,oNPC);\r\n                }\r\n            }\r\n        }\r\n        if(nNPC2 >= NPC_BASTILA && nNPC2 <= NPC_ZAALBAR)\r\n        {\r\n            if(GetIsObjectValid(GetPartyMemberByIndex(2)) == FALSE)\r\n            {\r\n                oNPC = SpawnAvailableNPC(nNPC2,GetLocation(GetFirstPC()));\r\n                if(GetIsObjectValid(oNPC))\r\n                {\r\n                    AddPartyMember(nNPC2,oNPC);\r\n                }\r\n            }\r\n\r\n        }\r\n    }\r\n    SetGlobalNumber("K_PARTY_STORE2",-2);\r\n    SetGlobalNumber("K_PARTY_STORE1",-2);\r\n    SetGlobalBoolean("K_PARTY_STORED",FALSE);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Return NPC Integer\r\n//:: Copyright (c) 2003 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Returns the NPC code for the given object if\r\n    it is a NPC, otherwise it returns -1\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: Feb 26, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nint UT_GetNPCCode(object oNPC)\r\n{\r\n  string sTag = GetTag(oNPC);\r\n\r\n  if(!GetIsObjectValid(oNPC))\r\n  {\r\n    return(-1);\r\n  }\r\n\r\n  if(sTag == "bastila")\r\n  {\r\n    return(NPC_BASTILA);\r\n  }\r\n\r\n  if(sTag == "cand")\r\n  {\r\n    return(NPC_CANDEROUS);\r\n  }\r\n\r\n  if(sTag == "carth")\r\n  {\r\n    return(NPC_CARTH);\r\n  }\r\n\r\n  if(sTag == "hk47")\r\n  {\r\n    return(NPC_HK_47);\r\n  }\r\n\r\n  if(sTag == "jolee")\r\n  {\r\n    return(NPC_JOLEE);\r\n  }\r\n\r\n  if(sTag == "juhani")\r\n  {\r\n    return(NPC_JUHANI);\r\n  }\r\n\r\n  if(sTag == "mission")\r\n  {\r\n    return(NPC_MISSION);\r\n  }\r\n\r\n  if(sTag == "t3m4")\r\n  {\r\n    return(NPC_T3_M4);\r\n  }\r\n\r\n  if(sTag == "zaalbar")\r\n  {\r\n    return(NPC_ZAALBAR);\r\n  }\r\n\r\n  return(-1);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Restore Party Member to 1 Vitality\r\n//:: Copyright (c) 2003 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Restores all party mambers to 1 hp if\r\n    tempoarily dead\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Aidan Scanlan\r\n//:: Created On: March 1, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nvoid UT_RestorePartyToOneHealth()\r\n{\r\n    int nIdx = 0;\r\n    object oParty = GetPartyMemberByIndex(nIdx);\r\n    while (GetIsObjectValid(oParty))\r\n    {\r\n        if(GetCurrentHitPoints(oParty) < 1)\r\n        {\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT,EffectResurrection(),oParty);\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT,EffectHeal(1),oParty);\r\n        }\r\n        nIdx++;\r\n        oParty = GetPartyMemberByIndex(nIdx);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Heal Party\r\n//:: Copyright (c) 2003 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Cycles throught the entire party and heals\r\n    them.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Feb 28, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nvoid UT_HealParty()\r\n{\r\n    object oParty;\r\n    int nCnt = 0;\r\n    for(nCnt; nCnt < 3; nCnt++)\r\n    {\r\n        oParty = GetPartyMemberByIndex(nCnt);\r\n        if(GetIsObjectValid(oParty))\r\n        {\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectHeal(500), oParty);\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectHealForcePoints(500), oParty);\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Heal Party Member\r\n//:: Copyright (c) 2003 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Heals a single target to full.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Feb 28, 2003\r\n//:://////////////////////////////////////////////\r\nvoid UT_HealNPC(object oNPC)\r\n{\r\n    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectHeal(500), oNPC);\r\n    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectHealForcePoints(500), oNPC);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Alter Stack\r\n//:: Copyright (c) 2003 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Alters the stack of a given object by the\r\n    specified amount. If the stack is only 1 then\r\n    the object is destroyed.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: March 3, 2003\r\n//:://////////////////////////////////////////////\r\nvoid UT_AlterItemStack(object oItem,int iNum = 1,int bDecrement = TRUE)\r\n{\r\n    int iStackSize;\r\n\r\n    if(!GetIsObjectValid(oItem) || iNum == 0)\r\n    {\r\n        return;\r\n    }\r\n\r\n    if(bDecrement)\r\n    {\r\n        iNum = -iNum;\r\n    }\r\n\r\n    iStackSize = GetItemStackSize(oItem);\r\n    if(iNum > 0)\r\n    {\r\n        SetItemStackSize(oItem,iStackSize+iNum);\r\n    }\r\n    else\r\n    {\r\n        if(iStackSize+iNum <= 0)\r\n        {\r\n          //MODIFIED by Preston Watamaniuk on May 13, 2003\r\n          //Added the command below to set the stack to 1 before destroying it.\r\n          SetItemStackSize(oItem,1);\r\n          DestroyObject(oItem,0.0,TRUE);\r\n        }\r\n        else\r\n        {\r\n          SetItemStackSize(oItem,iStackSize+iNum);\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Heal All Party NPCs\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Searches through the area and heals all of the\r\n    party members who are there. Used on the Ebon\r\n    Hawk and the Taris Apartment.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: March 5, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nvoid UT_HealAllPartyNPCs()\r\n{\r\n    object oNPC1 = GetObjectByTag("bastila");\r\n    object oNPC2 =  GetObjectByTag("carth");\r\n    object oNPC3 = GetObjectByTag("cand");\r\n    object oNPC4 = GetObjectByTag("hk47");\r\n    object oNPC5 = GetObjectByTag("jolee");\r\n    object oNPC6 = GetObjectByTag("juhani");\r\n    object oNPC7 = GetObjectByTag("mission");\r\n    object oNPC8 = GetObjectByTag("t3m4");\r\n    object oNPC9 = GetObjectByTag("zaalbar");\r\n    object oCurrent;\r\n\r\n    int nCnt = 1;\r\n    while(nCnt <= 9)\r\n    {\r\n        if(nCnt == 1){oCurrent = oNPC1;}\r\n        if(nCnt == 2){oCurrent = oNPC2;}\r\n        if(nCnt == 3){oCurrent = oNPC3;}\r\n        if(nCnt == 4){oCurrent = oNPC4;}\r\n        if(nCnt == 5){oCurrent = oNPC5;}\r\n        if(nCnt == 6){oCurrent = oNPC6;}\r\n        if(nCnt == 7){oCurrent = oNPC7;}\r\n        if(nCnt == 8){oCurrent = oNPC8;}\r\n        if(nCnt == 9){oCurrent = oNPC9;}\r\n\r\n        if(GetIsObjectValid(oCurrent))\r\n        {\r\n            UT_HealNPC(oCurrent);\r\n        }\r\n        nCnt++;\r\n    }\r\n    UT_HealNPC(GetFirstPC());\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Clear Party Members\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Goes through the party and removes them.\r\n    This is best used on Module Load when the\r\n    object are not actually created yet.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: March 6, 2003\r\n//:://////////////////////////////////////////////\r\nvoid UT_ClearAllPartyMembers()\r\n{\r\n    int nCnt;\r\n    for(nCnt; nCnt <= 8; nCnt++)\r\n    {\r\n        if(IsNPCPartyMember(nCnt))\r\n        {\r\n            RemovePartyMember(nCnt);\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: DC check using an ability score only\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Does a DC check just using an ability score\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: March 13, 2003\r\n//:://////////////////////////////////////////////\r\nint UT_AbilityCheck(int iDC, int iAbility, object oTarget)\r\n{\r\n    if(!GetIsObjectValid(oTarget))\r\n    {\r\n        return(FALSE);\r\n    }\r\n\r\n    if(GetAbilityScore(oTarget,iAbility) + (Random(20)+1) >= iDC)\r\n    {\r\n        return(TRUE);\r\n    }\r\n    else\r\n    {\r\n        return(FALSE);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Make Neutral2\r\n//:: Copyright (c) 2003 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Searches the area and changes all objects with\r\n    the specified tag to the neutral faction\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Peter T.\r\n//:: Created On: March 17, 2003\r\n//:://////////////////////////////////////////////\r\nvoid UT_MakeNeutral2(string sObjectTag)\r\n{\r\n    int nCount = 1;\r\n\r\n    // get first object\r\n    object oObject = GetNearestObjectByTag(sObjectTag);\r\n\r\n    while(GetIsObjectValid(oObject))\r\n    {\r\n        // set to Neutral\r\n        ChangeToStandardFaction(oObject, STANDARD_FACTION_NEUTRAL);\r\n\r\n        // get next object\r\n        nCount++;\r\n        oObject = GetNearestObjectByTag(sObjectTag, OBJECT_SELF, nCount);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Make Hostile1\r\n//:: Copyright (c) 2003 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Searches the area and changes all objects with\r\n    the specified tag to the Hostile_1 faction\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Peter T.\r\n//:: Created On: March 17, 2003\r\n//:://////////////////////////////////////////////\r\nvoid UT_MakeHostile1(string sObjectTag)\r\n{\r\n    int nCount = 1;\r\n\r\n    // get first object\r\n    object oObject = GetNearestObjectByTag(sObjectTag);\r\n\r\n    while(GetIsObjectValid(oObject))\r\n    {\r\n        // set to Hostile_1\r\n        ChangeToStandardFaction(oObject, STANDARD_FACTION_HOSTILE_1);\r\n\r\n        // get next object\r\n        nCount++;\r\n        oObject = GetNearestObjectByTag(sObjectTag, OBJECT_SELF, nCount);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Make Friendly1\r\n//:: Copyright (c) 2003 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Searches the area and changes all objects with\r\n    the specified tag to the Friendly_1 faction\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Peter T.\r\n//:: Created On: March 17, 2003\r\n//:://////////////////////////////////////////////\r\nvoid UT_MakeFriendly1(string sObjectTag)\r\n{\r\n    int nCount = 1;\r\n\r\n    // get first object\r\n    object oObject = GetNearestObjectByTag(sObjectTag);\r\n\r\n    while(GetIsObjectValid(oObject))\r\n    {\r\n        // set to Friendly_1\r\n        ChangeToStandardFaction(oObject, STANDARD_FACTION_FRIENDLY_1);\r\n\r\n        // get next object\r\n        nCount++;\r\n        oObject = GetNearestObjectByTag(sObjectTag, OBJECT_SELF, nCount);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Make Friendly2\r\n//:: Copyright (c) 2003 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Searches the area and changes all objects with\r\n    the specified tag to the Friendly_2 faction\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Peter T.\r\n//:: Created On: March 17, 2003\r\n//:://////////////////////////////////////////////\r\nvoid UT_MakeFriendly2(string sObjectTag)\r\n{\r\n    int nCount = 1;\r\n\r\n    // get first object\r\n    object oObject = GetNearestObjectByTag(sObjectTag);\r\n\r\n    while(GetIsObjectValid(oObject))\r\n    {\r\n        // set to Friendly_2\r\n        ChangeToStandardFaction(oObject, STANDARD_FACTION_FRIENDLY_2);\r\n\r\n        // get next object\r\n        nCount++;\r\n        oObject = GetNearestObjectByTag(sObjectTag, OBJECT_SELF, nCount);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: UT_ActivateTortureCage\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    performs a standard torture cage effect\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: April 1, 2003\r\n//:://////////////////////////////////////////////\r\nvoid DoTortureAnims(float fDuration)\r\n{\r\n    ActionPlayAnimation(ANIMATION_LOOPING_SPASM,1.0,fDuration/3.0);\r\n    ActionPlayAnimation(ANIMATION_LOOPING_HORROR,1.0,fDuration/3.0);\r\n    ActionPlayAnimation(ANIMATION_LOOPING_SPASM,1.0,fDuration/3.0);\r\n}\r\nvoid UT_ActivateTortureCage(object oCage, object oTarget,float fDuration)\r\n{\r\n    //AssignCommand(oCage,\r\n    //ActionPlayAnimation(ANIMATION_PLACEABLE_ACTIVATE));\r\n    //ApplyEffectToObject(DURATION_TYPE_TEMPORARY,EffectHorrified(),oTarget,fDuration);\r\n    AssignCommand(oTarget,DoTortureAnims(fDuration));\r\n    ApplyEffectToObject(DURATION_TYPE_TEMPORARY,EffectBeam(VFX_BEAM_LIGHTNING_DARK_S, oCage, BODY_NODE_HEAD),oTarget,fDuration);\r\n    //DelayCommand(fDuration,AssignCommand(oCage,ActionPlayAnimation(ANIMATION_PLACEABLE_DEACTIVATE)));\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Validate Jump\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    If the first three letters of the last module\r\n    do not match the first three letters of the\r\n    space port then function will return false.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 15, 2003\r\n//:://////////////////////////////////////////////\r\nint UT_ValidateJump(string sLastModule)\r\n{\r\n    int nJump = FALSE;\r\n\r\n    string sCurrentModule = GetModuleFileName();\r\n    PrintString("JUMP VALIDATION: CURRENT = " + sCurrentModule + " LAST = " + sLastModule);\r\n    PrintString("JUMP VALIDATION: SUBSTRING: " + GetSubString(sCurrentModule, 0,3) + " = " + GetSubString(sLastModule, 0,3));\r\n    if(GetSubString(sCurrentModule, 0,3) == GetSubString(sLastModule, 0,3))\r\n    {\r\n        nJump = TRUE;\r\n    }\r\n    else if(sCurrentModule != "ebo_m12aa")\r\n    {\r\n        SetGlobalString("K_LAST_MODULE", "NO_MODULE");\r\n    }\r\n    return nJump;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Play On Click Reaction\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Makes the animal face the PC, do its victory\r\n    and play a sound passed in. Should be used\r\n    in conjunction with the k_def_interact spawn in\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: May 31, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nvoid UT_DoAmbientReaction(string sSound)\r\n{\r\n    //ActionDoCommand(SetLocalBoolean(OBJECT_SELF, 72, FALSE));\r\n    PlaySound(sSound);\r\n    SetFacingPoint(GetPosition(GetPCSpeaker()));\r\n    ActionPlayAnimation(ANIMATION_FIREFORGET_VICTORY1);\r\n    //DelayCommand(2.0, ActionDoCommand(SetLocalBoolean(OBJECT_SELF, 72, TRUE)));\r\n}\r\n', 'k_inc_walkways': b'//:: k_inc_walkways\r\n/*\r\n    v1.0\r\n    Walk Way Points Include\r\n    used by k_inc_generic\r\n    \r\n    NOTE - To get these functions\r\n    use k_inc_generic\r\n*/\r\n//:: Created By: Preston Watamaniuk\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n\r\nint WALKWAYS_CURRENT_POSITION = 0;\r\nint WALKWAYS_END_POINT = 1;\r\nint WALKWAYS_SERIES_NUMBER = 2;\r\n\r\nint\tSW_FLAG_AMBIENT_ANIMATIONS\t=\t29;\r\nint\tSW_FLAG_AMBIENT_ANIMATIONS_MOBILE =\t30;\r\nint\tSW_FLAG_WAYPOINT_WALK_ONCE\t=\t34;\r\nint\tSW_FLAG_WAYPOINT_WALK_CIRCULAR\t=\t35;\r\nint\tSW_FLAG_WAYPOINT_WALK_PATH\t=\t36;\r\nint\tSW_FLAG_WAYPOINT_WALK_STOP\t=\t37; //One to three\r\nint\tSW_FLAG_WAYPOINT_WALK_RANDOM\t=\t38;\r\nint SW_FLAG_WAYPOINT_WALK_RUN    =   39;\r\nint SW_FLAG_WAYPOINT_DIRECTION = 41;\r\nint SW_FLAG_WAYPOINT_DEACTIVATE = 42;\r\nint SW_FLAG_WAYPOINT_WALK_STOP_LONG = 46;\r\nint SW_FLAG_WAYPOINT_WALK_STOP_RANDOM = 47;\r\n\r\n//Makes OBJECT_SELF walk way points based on the spawn in conditions set out.\r\nvoid GN_WalkWayPoints();\r\n//Sets the series number from 01 to 99 on a creature so that the series number and not the creature\'s tag is used for walkway points\r\nvoid GN_SetWalkWayPointsSeries(int nSeriesNumber);\r\n//Sets Generic Spawn In Conditions\r\nvoid GN_SetSpawnInCondition(int nFlag, int nState = TRUE);\r\n//Gets the boolean state of a generic spawn in condition.\r\nint GN_GetSpawnInCondition(int nFlag);\r\n//Moves an object to the last waypoint in a series\r\nvoid GN_MoveToLastWayPoint(object oToMove);\r\n//Moves an object to a random point in the series\r\nvoid GN_MoveToRandomWayPoint(object oToMove);\r\n//Moves an object to a sepcific point in the series\r\nvoid GN_MoveToSpecificWayPoint(object oToMove, int nArrayNumber);\r\n//Determines the correct direction to proceed in a walkway points array.\r\nint GN_GetWayPointDirection(int nEndArray, int nCurrentPosition);\r\n//Should only be called from within SetListendingPatterns\r\nvoid GN_SetUpWayPoints();\r\n//Play an animation between way points.\r\nvoid GN_PlayWalkWaysAnimation();\r\n//Inserts a print string into the log file for debugging purposes for the walkways include.\r\nvoid WK_MyPrintString(string sString);\r\n//Are valid walkway points available\r\nint GN_CheckWalkWays(object oTarget);\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Walk Way Points\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Makes OBJECT_SELF walk way points based on a\r\n    number of spawn in conditions.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: July 15, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid GN_WalkWayPoints()\r\n{\r\n    if(!GN_GetSpawnInCondition(SW_FLAG_WAYPOINT_DEACTIVATE))\r\n    {\r\n        string sPost = "POST_";\r\n        string sWays = "WP_";\r\n        string sWayNumber;\r\n\r\n        int nCurrentTarget = GetLocalNumber(OBJECT_SELF, WALKWAYS_CURRENT_POSITION);\r\n        int nEndArray = GetLocalNumber(OBJECT_SELF, WALKWAYS_END_POINT);\r\n        int nSeriesInt = GetLocalNumber(OBJECT_SELF, WALKWAYS_SERIES_NUMBER);\r\n        //Used where you want the creature to use a numbered series instead of their own tag.\r\n\r\n        if(nCurrentTarget < 10 &&  nCurrentTarget > 0)\r\n        {\r\n            sWayNumber = "0" + IntToString(nCurrentTarget);\r\n        }\r\n        else if(nCurrentTarget == 0)\r\n        {\r\n            //August 2, 2002 - Jason Booth - changed to randomize start wp\r\n            if(GN_GetSpawnInCondition(SW_FLAG_WAYPOINT_WALK_RANDOM))\r\n            {\r\n                nCurrentTarget = Random(nEndArray) + 1;\r\n                if(nCurrentTarget < 10)\r\n                {\r\n                  sWayNumber = "0" + IntToString(nCurrentTarget);\r\n                }\r\n                else\r\n                {\r\n                  sWayNumber = IntToString(nCurrentTarget);\r\n                }\r\n            }\r\n            else\r\n            {\r\n              sWayNumber = "01";\r\n            }\r\n        }\r\n        else if(nCurrentTarget < 10)\r\n        {\r\n            sWayNumber = "0" + IntToString(nCurrentTarget);\r\n        }\r\n        else\r\n        {\r\n            sWayNumber = IntToString(nCurrentTarget);\r\n        }\r\n\r\n        string sMoveWay;\r\n        string sTestWay;\r\n        //Test to see if the series waypoints are being used and if so then build sTestWay with the number not tag.\r\n        if(nSeriesInt > 0)\r\n        {\r\n            string sSeriesWay;\r\n            if(nSeriesInt < 10)\r\n            {\r\n                sSeriesWay = "0" + IntToString(nSeriesInt);\r\n            }\r\n            else\r\n            {\r\n                sSeriesWay = IntToString(nSeriesInt);\r\n            }\r\n            sTestWay = sWays + sSeriesWay + "_02";\r\n        }\r\n        //Use object tag if there is no series number\r\n        else\r\n        {\r\n            sTestWay = sWays + GetTag(OBJECT_SELF) + "_02";\r\n        }\r\n\r\n        object oTestWay = GetWaypointByTag(sTestWay);\r\n\r\n        if(nEndArray == 0 && GetIsObjectValid(oTestWay))\r\n        {\r\n            //GN_PostString("SET LISTENING PATTERNS HAS NOT RUN PLEASE USE IN SPAWN IN SCRIPT");\r\n        }\r\n\r\n        if(GetIsObjectValid(oTestWay))\r\n        {\r\n            int nLength = GetStringLength(sTestWay);\r\n            sMoveWay = GetStringLeft(sTestWay, nLength - 2) + sWayNumber;\r\n            //sWays + GetTag(OBJECT_SELF) + "_" + sWayNumber;\r\n        }\r\n        else\r\n        {\r\n            sWays = "UNKNOWN";\r\n            sMoveWay = sPost + GetTag(OBJECT_SELF);\r\n        }\r\n\r\n        object oWay = GetWaypointByTag(sMoveWay);\r\n        int nRun = GN_GetSpawnInCondition(SW_FLAG_WAYPOINT_WALK_RUN);\r\n\r\n        //Check if the target waypoint is close enough to warrent moving on to the next waypoint.\r\n        if(GetDistanceToObject2D(oWay) <= 2.5)\r\n        {\r\n            int nDirection;\r\n            if(GN_GetSpawnInCondition(SW_FLAG_WAYPOINT_WALK_RANDOM))\r\n            {\r\n                nCurrentTarget = Random(nEndArray) + 1;\r\n            }\r\n            else if(nCurrentTarget < nEndArray && !GN_GetSpawnInCondition(SW_FLAG_WAYPOINT_WALK_RANDOM))\r\n            {\r\n                nDirection = GN_GetWayPointDirection(nEndArray, nCurrentTarget);\r\n                nCurrentTarget = nCurrentTarget + nDirection;\r\n            }\r\n            else if(nCurrentTarget == nEndArray)\r\n            {\r\n                nDirection = GN_GetWayPointDirection(nEndArray, nCurrentTarget);\r\n                if(GN_GetSpawnInCondition(SW_FLAG_WAYPOINT_WALK_ONCE))\r\n                {\r\n                    GN_SetSpawnInCondition(SW_FLAG_WAYPOINT_DEACTIVATE);\r\n                }\r\n                else if(GN_GetSpawnInCondition(SW_FLAG_WAYPOINT_WALK_CIRCULAR))\r\n                {\r\n                    nCurrentTarget = 1;\r\n                    GN_SetSpawnInCondition(SW_FLAG_WAYPOINT_DIRECTION, FALSE);\r\n                }\r\n                else\r\n                {\r\n                    nCurrentTarget = nCurrentTarget + nDirection;\r\n                }\r\n            }\r\n        }\r\n\r\n        if(GetIsObjectValid(GetWaypointByTag(sMoveWay)))\r\n        {\r\n            //MODIFIED by Preston Watamaniuk on March 13\r\n            //Took out the clear all actions. It was mucking up the chain of commands.\r\n            //ActionDoCommand(ClearAllActions());\r\n            \r\n            int nRand;\r\n            if(GN_GetSpawnInCondition(SW_FLAG_WAYPOINT_WALK_STOP))\r\n            {\r\n                nRand = d3();\r\n            }\r\n            else if(GN_GetSpawnInCondition(SW_FLAG_WAYPOINT_WALK_STOP_LONG))\r\n            {\r\n                nRand = d6()+6;\r\n            }\r\n            else if(GN_GetSpawnInCondition(SW_FLAG_WAYPOINT_WALK_STOP_RANDOM))\r\n            {\r\n                nRand = d12();\r\n            }\r\n            else if(nRand > 0)\r\n            {\r\n                ActionWait(IntToFloat(nRand)); //ACTION\r\n            }\r\n            oWay = GetWaypointByTag(sMoveWay);\r\n            //Calculate the timeout based on the distance that needs to be traveled.\r\n            float fTimeOut = GetDistanceBetween2D(GetWaypointByTag(sMoveWay), OBJECT_SELF)/1.25;\r\n            if(fTimeOut < 30.0)\r\n            {\r\n                fTimeOut = 30.0;\r\n            }\r\n            //WK_MyPrintString("WALKWAYS DEBUG *************** Adding Action: Force Move");\r\n            ActionForceMoveToObject(oWay, GN_GetSpawnInCondition(SW_FLAG_WAYPOINT_WALK_RUN), 2.5, fTimeOut); //ACTION\r\n\r\n            //MODIFIED by Preston Watamaniuk on March 13\r\n            //Added this piece of code to add ambient animations to Walkways.\r\n            if(GN_GetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS))\r\n            {\r\n                //WK_MyPrintString("WALKWAYS DEBUG *************** Adding Action: Animation");\r\n                ActionDoCommand(GN_PlayWalkWaysAnimation()); //ACTION\r\n            }\r\n            SetLocalNumber(OBJECT_SELF, WALKWAYS_CURRENT_POSITION, nCurrentTarget);\r\n            if(sWays != "UNKNOWN")\r\n            {\r\n                //WK_MyPrintString("WALKWAYS DEBUG *************** Adding Action: Walkways Interate");\r\n                ActionDoCommand(GN_WalkWayPoints());   //ACTION\r\n            }\r\n        }\r\n    }\r\n}\r\n\r\nvoid GN_SetWalkWayPointsSeries(int nSeriesNumber)\r\n{\r\n    SetLocalNumber(OBJECT_SELF, WALKWAYS_SERIES_NUMBER, nSeriesNumber);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Set Spawn In Condition\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Sets the Generic Spawn In Conditions\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: July 15, 2002\r\n//:://////////////////////////////////////////////\r\nvoid GN_SetSpawnInCondition(int nFlag, int nState = TRUE)\r\n{\r\n    //WK_MyPrintString("GENERIC DEBUG *************** Setting Local Number (" + IntToString(nFlag) + ") = " + IntToString(nState));\r\n    SetLocalBoolean(OBJECT_SELF, nFlag, nState);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Spawn In Condition\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Gets the Generic Spawn In Conditions\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: July 15, 2002\r\n//:://////////////////////////////////////////////\r\nint GN_GetSpawnInCondition(int nFlag)\r\n{\r\n    int nLocal = GetLocalBoolean(OBJECT_SELF, nFlag);\r\n    if(nLocal > 0)\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Preston Watamaniuk\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Moves the passed in object to the last waypoint\r\n    in that NPCs series of waypoints.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Aug 12, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid GN_MoveToLastWayPoint(object oToMove)\r\n{\r\n    int nLastWay = GetLocalNumber(oToMove, WALKWAYS_END_POINT);\r\n    int nSeries = GetLocalNumber(oToMove, WALKWAYS_SERIES_NUMBER);\r\n    string sString;\r\n    if(nSeries > 0)\r\n    {\r\n        string sSeriesWay;\r\n        if(nSeries < 10)\r\n        {\r\n            sSeriesWay = "0" + IntToString(nSeries);\r\n        }\r\n        else\r\n        {\r\n            sSeriesWay = IntToString(nSeries);\r\n        }\r\n        sString = "WP_" + sSeriesWay;\r\n    }\r\n    else\r\n    {\r\n        sString = "WP_" + GetTag(oToMove);\r\n    }\r\n    if(nLastWay < 10)\r\n    {\r\n        sString = sString + "_0" + IntToString(nLastWay);\r\n    }\r\n    else\r\n    {\r\n        sString = sString + "_" + IntToString(nLastWay);\r\n    }\r\n\r\n    object oWay = GetWaypointByTag(sString);\r\n    if(GetIsObjectValid(oWay))\r\n    {\r\n        AssignCommand(oToMove, ClearAllActions());\r\n        AssignCommand(oToMove, ActionMoveToObject(oWay, FALSE));\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Preston Watamaniuk\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Moves the passed in object to a random waypoint\r\n    in that NPCs series of waypoints.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Aug 12, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid GN_MoveToRandomWayPoint(object oToMove)\r\n{\r\n    int nLastWay = GetLocalNumber(oToMove, WALKWAYS_END_POINT);\r\n    int nRandom = Random(nLastWay)+1;\r\n    int nSeries = GetLocalNumber(oToMove, WALKWAYS_SERIES_NUMBER);\r\n    string sString;\r\n    if(nSeries > 0)\r\n    {\r\n        string sSeriesWay;\r\n        if(nSeries < 10)\r\n        {\r\n            sSeriesWay = "0" + IntToString(nSeries);\r\n        }\r\n        else\r\n        {\r\n            sSeriesWay = IntToString(nSeries);\r\n        }\r\n        sString = "WP_" + sSeriesWay;\r\n    }\r\n    else\r\n    {\r\n        sString = "WP_" + GetTag(oToMove);\r\n    }\r\n    if(nLastWay < 10)\r\n    {\r\n        sString = sString + "_0" + IntToString(nRandom);\r\n    }\r\n    else\r\n    {\r\n        sString = sString + "_" + IntToString(nRandom);\r\n    }\r\n\r\n    object oWay = GetWaypointByTag(sString);\r\n    if(GetIsObjectValid(oWay))\r\n    {\r\n        AssignCommand(oToMove, ClearAllActions());\r\n        AssignCommand(oToMove, ActionMoveToObject(oWay, FALSE));\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Preston Watamaniuk\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Moves the passed in object to a specified waypoint\r\n    in that NPCs series of waypoints.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Aug 12, 2002\r\n//:://////////////////////////////////////////////\r\nvoid GN_MoveToSpecificWayPoint(object oToMove, int nArrayNumber)\r\n{\r\n    int nLastWay = GetLocalNumber(oToMove, WALKWAYS_END_POINT);\r\n    int nSeries = GetLocalNumber(oToMove, WALKWAYS_SERIES_NUMBER);\r\n    string sString;\r\n    if(nArrayNumber <= nLastWay)\r\n    {\r\n        if(nSeries > 0)\r\n        {\r\n            string sSeriesWay;\r\n            if(nSeries < 10)\r\n            {\r\n                sSeriesWay = "0" + IntToString(nSeries);\r\n            }\r\n            else\r\n            {\r\n                sSeriesWay = IntToString(nSeries);\r\n            }\r\n            sString = "WP_" + sSeriesWay;\r\n        }\r\n        else\r\n        {\r\n            sString = "WP_" + GetTag(oToMove);\r\n        }\r\n        if(nArrayNumber < 10)\r\n        {\r\n            sString = sString + "_0" + IntToString(nArrayNumber);\r\n        }\r\n        else\r\n        {\r\n            sString = sString + "_" + IntToString(nArrayNumber);\r\n        }\r\n\r\n        object oWay = GetWaypointByTag(sString);\r\n        if(GetIsObjectValid(oWay))\r\n        {\r\n            AssignCommand(oToMove, ClearAllActions());\r\n            AssignCommand(oToMove, ActionMoveToObject(oWay, FALSE));\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Get Waypooint Direction\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Determines the direction that a NPC should be\r\n    walking along their waypoints.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Jul 20, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint GN_GetWayPointDirection(int nEndArray, int nCurrentPosition)\r\n{\r\n    int nDirection;\r\n    int nFlag = GN_GetSpawnInCondition(SW_FLAG_WAYPOINT_DIRECTION);\r\n    if(nEndArray == nCurrentPosition && nFlag == FALSE)\r\n    {\r\n        nDirection = -1;\r\n        GN_SetSpawnInCondition(SW_FLAG_WAYPOINT_DIRECTION, TRUE);\r\n    }\r\n    else if(nCurrentPosition == 1 && nFlag == TRUE)\r\n    {\r\n        nDirection = 1;\r\n        GN_SetSpawnInCondition(SW_FLAG_WAYPOINT_DIRECTION, FALSE);\r\n    }\r\n    else if(nFlag == FALSE)\r\n    {\r\n        nDirection = 1;\r\n    }\r\n    else if(nFlag == TRUE)\r\n    {\r\n        nDirection = -1;\r\n    }\r\n\r\n    return nDirection;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Set Up Way Points\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Used to initialize the NPCs waypoints\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 9, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid GN_SetUpWayPoints()\r\n{\r\n    string sString;\r\n    int nSeries = GetLocalNumber(OBJECT_SELF, WALKWAYS_SERIES_NUMBER);\r\n    if(nSeries > 0)\r\n    {\r\n        string sSeriesWay;\r\n        if(nSeries < 10)\r\n        {\r\n            sSeriesWay = "0" + IntToString(nSeries);\r\n        }\r\n        else\r\n        {\r\n            sSeriesWay = IntToString(nSeries);\r\n        }\r\n        sString = "WP_" + sSeriesWay;\r\n    }\r\n    else\r\n    {\r\n        sString = "WP_" + GetTag(OBJECT_SELF);\r\n    }\r\n\r\n    int nCnt = 1;\r\n    string sTest = sString + "_01";\r\n    object oWay = GetWaypointByTag(sTest);\r\n\r\n    while(GetIsObjectValid(oWay))\r\n    {\r\n        nCnt++;\r\n        if(nCnt < 10)\r\n        {\r\n            sTest = sString + "_0" + IntToString(nCnt);\r\n        }\r\n        else\r\n        {\r\n            sTest = sString + "_" + IntToString(nCnt);\r\n        }\r\n        oWay = GetWaypointByTag(sTest);\r\n    }\r\n    nCnt = nCnt - 1;\r\n    if(nCnt > 0)\r\n    {\r\n        SetLocalNumber(OBJECT_SELF, WALKWAYS_END_POINT, nCnt);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Play Walk Ways Animations\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Plays an animation between way points\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: March 13, 2003\r\n//:://////////////////////////////////////////////\r\n\r\nvoid GN_PlayWalkWaysAnimation()\r\n{\r\n    int nRoll = d8();\r\n    if(nRoll == 1)\r\n    {\r\n        //WK_MyPrintString("WALKWAYS DEBUG *************** Play Anim: Bored");\r\n        ActionPlayAnimation(ANIMATION_FIREFORGET_PAUSE_BORED, 1.0);\r\n    }\r\n    else if(nRoll == 2)\r\n    {\r\n        //WK_MyPrintString("WALKWAYS DEBUG *************** Play Anim: Scratch");\r\n        ActionPlayAnimation(ANIMATION_FIREFORGET_PAUSE_SCRATCH_HEAD, 1.0);\r\n    }\r\n    else if(nRoll == 3)\r\n    {\r\n        //WK_MyPrintString("WALKWAYS DEBUG *************** Play Anim: Pause 2");\r\n        ActionPlayAnimation(ANIMATION_LOOPING_PAUSE2, 1.0, 3.0);\r\n    }\r\n    else if((nRoll == 4 || nRoll == 5) && GetRacialType(OBJECT_SELF) != RACIAL_TYPE_DROID)\r\n    {\r\n        if(GetGender(OBJECT_SELF) == GENDER_MALE)\r\n        {\r\n            //WK_MyPrintString("WALKWAYS DEBUG *************** Play Anim: Male Pause 3");\r\n            GN_SetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS, FALSE);\r\n            ActionPlayAnimation(ANIMATION_LOOPING_PAUSE3, 1.0, 20.4);\r\n            ActionDoCommand(GN_SetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS, TRUE));\r\n        }\r\n        else if(GetGender(OBJECT_SELF) == GENDER_FEMALE)\r\n        {\r\n            //WK_MyPrintString("WALKWAYS DEBUG *************** Play Anim: Female Pause 3");\r\n            GN_SetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS, FALSE);\r\n            ActionPlayAnimation(ANIMATION_LOOPING_PAUSE3, 1.0, 13.3);\r\n            ActionDoCommand(GN_SetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS, TRUE));\r\n        }\r\n    }\r\n    else if(nRoll == 6 || nRoll == 4 || nRoll == 5)\r\n    {\r\n        //WK_MyPrintString("WALKWAYS DEBUG *************** Play Anim: Head Turn Left");\r\n        ActionPlayAnimation(ANIMATION_FIREFORGET_HEAD_TURN_LEFT);\r\n    }\r\n    else if(nRoll == 7)\r\n    {\r\n        //WK_MyPrintString("WALKWAYS DEBUG *************** Play Anim: Head Turn Right");\r\n        ActionPlayAnimation(ANIMATION_FIREFORGET_HEAD_TURN_RIGHT);\r\n    }\r\n    else if(nRoll == 8)\r\n    {\r\n        //WK_MyPrintString("WALKWAYS DEBUG *************** Play Anim: Pause 2");\r\n        GN_SetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS, FALSE);\r\n        ActionPlayAnimation(ANIMATION_LOOPING_PAUSE2, 1.0, 5.0);\r\n        ActionDoCommand(GN_SetSpawnInCondition(SW_FLAG_AMBIENT_ANIMATIONS, TRUE));\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Are Walk Ways Available\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Are valid walkway points available for walking\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: May 22, 2003\r\n//:://////////////////////////////////////////////\r\nint GN_CheckWalkWays(object oTarget)\r\n{\r\n    string sTag = "WP_" + GetTag(oTarget) + "_01";\r\n    string sPost = "POST_" + GetTag(oTarget);\r\n    int nSeriesInt = GetLocalNumber(oTarget, WALKWAYS_SERIES_NUMBER);\r\n    string sSeriesWay;\r\n    if(nSeriesInt < 10)\r\n    {\r\n        sSeriesWay = "0" + IntToString(nSeriesInt);\r\n    }\r\n    else\r\n    {\r\n        sSeriesWay = IntToString(nSeriesInt);\r\n    }\r\n    string sTestWay = "WP_" + sSeriesWay + "_01";\r\n\r\n    object oWay = GetWaypointByTag(sTag);\r\n    object oWay2 = GetWaypointByTag(sTestWay);\r\n    object oPost = GetWaypointByTag(sPost);\r\n\r\n    WK_MyPrintString("Walk Initiate for " + GetTag(oTarget));\r\n    WK_MyPrintString("TAG WAY FOUND = " + IntToString(GetIsObjectValid(oWay)));\r\n    WK_MyPrintString("WAY POINT NAME = " + GetTag(oWay));\r\n    WK_MyPrintString("SERIES INT = " + IntToString(nSeriesInt));\r\n    WK_MyPrintString("SERIES WAY FOUND = " + IntToString(GetIsObjectValid(oWay2)));\r\n    WK_MyPrintString("SERIES Series Tag = " + sTestWay);\r\n    WK_MyPrintString("");\r\n\r\n    if(GetIsObjectValid(oWay) || GetIsObjectValid(oWay2) || GetIsObjectValid(oPost))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\nvoid WK_MyPrintString(string sString)\r\n{\r\n    if(!ShipBuild())\r\n    {\r\n        PrintString(sString);\r\n    }\r\n}\r\n', 'k_inc_zone': b'//:: k_inc_zones\r\n/*\r\n     Zone including for controlling\r\n     the chaining of creatures\r\n*/\r\n//:: Created By: Preston Watamaniuk\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n\r\n#include "k_inc_generic"\r\n\r\n//Function run by the trigger to catalog the control nodes followers\r\nvoid ZN_CatalogFollowers();\r\n//Checks zone conditional on creature to if they belong to the zone\r\nint ZN_CheckIsFollower(object oController, object oTarget);\r\n//Checks the distance and creatures around the PC to see if it should return home.\r\nint ZN_CheckReturnConditions();\r\n//Gets the followers to move back to the controller object\r\nvoid ZN_MoveToController(object oController, object oFollower);\r\n//Checks to see if a specific individual needs to return to the controller.\r\nint ZN_CheckFollowerReturnConditions(object oTarget);\r\n\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Catalog Zone Followers\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n     Catalogs all creatures within\r\n     the trigger area and marks\r\n     them with an integer which\r\n     is part of the creature\'s\r\n     tag.\r\n     Use local number SW_NUMBER_LAST_COMBO\r\n     as a test. A new local number will\r\n     be defined if the system works.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 7, 2003\r\n//:://////////////////////////////////////////////\r\nvoid ZN_CatalogFollowers()\r\n{\r\n    GN_PostString("FIRING", 10,10, 10.0);\r\n    if(GetLocalBoolean(OBJECT_SELF, 10) == FALSE) //Has talked to boolean\r\n    {\r\n        string sZoneTag = GetTag(OBJECT_SELF);\r\n        int nZoneNumber = StringToInt(GetStringRight(sZoneTag, 2));\r\n        //Set up creature followers\r\n        object oZoneFollower = GetFirstInPersistentObject();\r\n        while(GetIsObjectValid(oZoneFollower))\r\n        {\r\n            SetLocalNumber(oZoneFollower, SW_NUMBER_COMBAT_ZONE, nZoneNumber);\r\n            //GN_MyPrintString("ZONING DEBUG ***************** Setup Follower = " + GN_ReturnDebugName(oZoneFollower));\r\n            //GN_MyPrintString("ZONING DEBUG ***************** Setup Follower Zone # = " + GN_ITS(GetLocalNumber(oZoneFollower, SW_NUMBER_COMBAT_ZONE)));\r\n\r\n            oZoneFollower = GetNextInPersistentObject();\r\n        }\r\n        SetLocalBoolean(OBJECT_SELF, 10, TRUE);//Has talked to boolean\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Check Object for Zoning\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks the object to see if they part of the\r\n    zone. This function is run off of the control\r\n    node.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 7, 2003\r\n//:://////////////////////////////////////////////\r\nint ZN_CheckIsFollower(object oController, object oTarget)\r\n{\r\n    int nNumber = GetLocalNumber(oTarget, SW_NUMBER_COMBAT_ZONE);\r\n    string sZoneTag = GetTag(OBJECT_SELF);\r\n    int nZoneNumber = StringToInt(GetStringRight(sZoneTag, 2));\r\n    if(nZoneNumber == nNumber)\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Check Return Conditions\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks to see if the conditions exist to\r\n    possibly check for followers to return to\r\n    the controller.\r\n*/\r\n//:://////////////////////////////////////////////\r\n\r\n//:://////////////////////////////////////////////\r\nint ZN_CheckReturnConditions()\r\n{\r\n    object oPC = GetPartyMemberByIndex(0);\r\n    /*\r\n        1.  Is the PC more than 21m away from the control node\r\n        2.  Is the follower more than 20m away from the control node\r\n        3.  Are there 9 or more individuals around the any single party member out to a distance of 30m\r\n    */\r\n    object oNinth = GetNearestCreature(CREATURE_TYPE_PLAYER_CHAR, PLAYER_CHAR_NOT_PC, oPC, 9);\r\n    //GN_MyPrintString("ZONING DEBUG ***************** 9th Creature = " + GN_ReturnDebugName(oNinth));\r\n    //GN_MyPrintString("ZONING DEBUG ***************** 9th Creature Distance = " + FloatToString(GetDistanceBetween(oPC, oNinth), 4,2));\r\n\r\n    if(GetIsObjectValid(oNinth) && GetDistanceBetween(oPC, oNinth) < 30.0)\r\n    {\r\n        if(GetDistanceBetween(OBJECT_SELF, oPC) > 21.0)\r\n        {\r\n            return TRUE;\r\n        }\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Check Follower Return Conditions.\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Checks if the follower object needs to return\r\n    to home base.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 8, 2003\r\n//:://////////////////////////////////////////////\r\nint ZN_CheckFollowerReturnConditions(object oTarget)\r\n{\r\n    float fDistance = GetDistanceBetween(oTarget, OBJECT_SELF);\r\n    //GN_MyPrintString("ZONING DEBUG ***************** " + GN_ReturnDebugName(oTarget) + " control distance " + FloatToString(fDistance, 4, 2));\r\n\r\n    if(fDistance >= 10.0 && GetIsEnemy(oTarget, GetFirstPC()))\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Move to Controller\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Gets the follower object to move back to the\r\n    controller object.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 7, 2003\r\n//:://////////////////////////////////////////////\r\nvoid ZN_MoveToController(object oController, object oFollower)\r\n{\r\n    //GN_MyPrintString("ZONING DEBUG ***************** Controller = " + GN_ReturnDebugName(oController));\r\n    //GN_MyPrintString("ZONING DEBUG ***************** Follower = " + GN_ReturnDebugName(oFollower));\r\n    //GN_MyPrintString("ZONING DEBUG ***************** Follower Zone # = " + GN_ITS(GetLocalNumber(oFollower, SW_NUMBER_LAST_COMBO)));\r\n    if(GetCurrentAction(oFollower) != ACTION_INVALID)\r\n    {\r\n        SetCommandable(TRUE);\r\n    }\r\n\r\n    CancelCombat(oFollower);\r\n    AssignCommand(oFollower, ClearAllActions());\r\n    AssignCommand(oFollower, ActionForceMoveToObject(oController, TRUE, 5.0, 5.0));\r\n    AssignCommand(oFollower, ActionDoCommand(SetCommandable(TRUE, oFollower)));\r\n    AssignCommand(oFollower, SetCommandable(FALSE, oFollower));\r\n}\r\n\r\n\r\n\r\n\r\n\r\n'}

TSL_LIBRARY = {'a_global_inc': b'\r\n//:: a_global_inc\r\n/*\r\n    parameter 1 = string identifier for a global number\r\n    parameter 2 = amount to increment GetGlobalNumber(param1)\r\n*/\r\n//:: Created By: Anthony Davis\r\n\r\n#include "k_inc_debug"\r\nvoid main()\r\n{\r\n    string tString = GetScriptStringParameter();\r\n    int tInt = GetScriptParameter( 1 );\r\n\r\n    SetGlobalNumber(tString, GetGlobalNumber(tString) + tInt);\r\n}\r\n', 'a_influence_inc': b"// a_influence_inc\r\n/* Parameter Count: 2\r\n\r\nIncreases an NPC's influence.\r\n\r\nParam1 - The NPC value of the player whose influence is increased.\r\nParam2 - magnitude of influence change:\r\n    1 - low\r\n    2 - medium\r\n    3 - high\r\n    all others - medium\r\n\r\n\r\nNPC numbers, as specified in NPC.2da\r\n\r\n0       Atton\r\n1       BaoDur\r\n2       Mand\r\n3       g0t0\r\n4       Handmaiden\r\n5       hk47\r\n6       Kreia\r\n7       Mira\r\n8       T3m4\r\n9       VisasMarr\r\n10      Hanharr\r\n11      Disciple\r\n\r\n*/\r\n//\r\n// KDS 06/16/04\r\nvoid main()\r\n{\r\n\r\nint nInfluenceLow = 8;\r\nint nInfluenceMedium = 8;\r\nint nInfluenceHigh = 8;\r\n\r\nint nNPC = GetScriptParameter(1);\r\nint nImpact = GetScriptParameter(2);\r\nint nInfluenceChange;\r\n\r\nswitch (nImpact)\r\n\r\n{\r\n    case 1:\r\n        nInfluenceChange = nInfluenceLow;\r\n        break;\r\n    case 2:\r\n        nInfluenceChange = nInfluenceMedium;\r\n        break;\r\n    case 3:\r\n        nInfluenceChange = nInfluenceHigh;\r\n        break;\r\n    default:\r\n        nInfluenceChange = nInfluenceMedium;\r\n        break;\r\n}\r\n\r\nModifyInfluence (nNPC, nInfluenceChange);\r\n\r\n}\r\n", 'a_localn_inc': b'// a_localn_inc\r\n// Parameter Count: 2\r\n// Param1 - The local number # to increment (range 12-31)\r\n// Param2 - the amount to increment Param1 by (default = 1)\r\n// Param3 - Optional string parameter to refer to another object\'s local #\r\n//\r\n// KDS 06/15/04\r\n// Modified TDE 7/31/04\r\n\r\n#include "k_inc_debug"\r\n#include "k_inc_utility"\r\nvoid main()\r\n{\r\n\r\n    int nLocalNumber = GetScriptParameter( 1 );\r\n    int nValue = GetScriptParameter ( 2 );\r\n    // Added optional string parameter to refer to another object\'s local #\r\n    string sTag = GetScriptStringParameter();\r\n\r\n    object oObject;\r\n\r\n    // If sTag is empty, use the object that called the script\r\n    if ( sTag == "" ) oObject = OBJECT_SELF;\r\n\r\n    else oObject = GetObjectByTag(sTag);\r\n\r\n    if (nValue == 0) nValue = 1;\r\n\r\n    SetLocalNumber(oObject, nLocalNumber,\r\n        GetLocalNumber(oObject, nLocalNumber) + nValue);\r\n\r\n}\r\n', 'k_inc_cheat': b'//:: k_inc_cheat\r\n/*\r\n    This will be localized area for all\r\n    Cheat Bot scripting.\r\n*/\r\n//:: Created By: Preston Watamaniuk\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n\r\n#include "k_inc_debug"\r\n\r\n//Takes a PLANET_ Constant\r\nvoid CH_SetPlanetaryGlobal(int nPlanetConstant);\r\n//Makes the specified party member available to the PC\r\nvoid CH_SetPartyMemberAvailable(int nNPC);\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Set Planet Local\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    VARIABLE = K_CURRENT_PLANET\r\n        Endar Spire     5\r\n        Taris           10\r\n        Dantooine       15\r\n        --Kashyyk       20\r\n        --Manaan        25\r\n        --Korriban      30\r\n        --Tatooine      35\r\n        Leviathan       40\r\n        Unknown World   45\r\n        Star Forge      50\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 16, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid CH_SetPlanetaryGlobal(int nPlanetConstant)\r\n{\r\n/*\r\n    if(nPlanetConstant == PLANET_ENDAR_SPIRE)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 5);\r\n    }\r\n    else if(nPlanetConstant == PLANET_TARIS)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 10);\r\n    }\r\n    else if(nPlanetConstant == PLANET_DANTOOINE)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 15);\r\n    }\r\n    else if(nPlanetConstant == PLANET_KASHYYYK)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 20);\r\n    }\r\n    else if(nPlanetConstant == PLANET_KORRIBAN)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 30);\r\n    }\r\n    else if(nPlanetConstant == PLANET_MANAAN)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 25);\r\n    }\r\n    else if(nPlanetConstant == PLANET_TATOOINE)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 35);\r\n    }\r\n    else if(nPlanetConstant == PLANET_LEVIATHAN)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 40);\r\n    }\r\n    else if(nPlanetConstant == PLANET_UNKNOWN_WORLD)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 45);\r\n    }\r\n    else if(nPlanetConstant == PLANET_STAR_FORGE)\r\n    {\r\n        SetGlobalNumber("K_CURRENT_PLANET", 50);\r\n    }\r\n*/\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Make NPC Available\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Sets an NPC as available\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Oct 16, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid CH_SetPartyMemberAvailable(int nNPC)\r\n{\r\n/*\r\n    if(nNPC == NPC_BASTILA)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_BASTILA, "p_bastilla");\r\n    }\r\n    else if(nNPC == NPC_CANDEROUS)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_CANDEROUS, "p_cand");\r\n    }\r\n    else if(nNPC == NPC_CARTH)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_CARTH, "p_carth");\r\n    }\r\n    else if(nNPC == NPC_HK_47)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_HK_47, "p_hk47");\r\n    }\r\n    else if(nNPC == NPC_JOLEE)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_JOLEE, "p_jolee");\r\n    }\r\n    else if(nNPC == NPC_JUHANI)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_JUHANI, "p_juhani");\r\n    }\r\n    else if(nNPC == NPC_MISSION)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_MISSION, "p_mission");\r\n    }\r\n    else if(nNPC == NPC_T3_M4)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_T3_M4, "p_t3m4");\r\n    }\r\n    else if(nNPC == NPC_ZAALBAR)\r\n    {\r\n        AddAvailableNPCByTemplate(NPC_ZAALBAR, "p_zaalbar");\r\n    }\r\n*/\r\n}\r\n\r\n\r\n\r\n', 'k_inc_debug': b'//::///////////////////////////////////////////////\r\n//:: KOTOR Debug Include\r\n//:: k_inc_debug\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This contains the functions for inserting\r\n    debug information into the scripts.\r\n    This include will use Db as its two letter\r\n    function prefix.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: June 12, 2002\r\n//:://////////////////////////////////////////////\r\n\r\n//Inserts a print string into the log file for debugging purposes.\r\nvoid Db_MyPrintString(string sString);\r\n//Makes the object running the script say a speak string.\r\nvoid Db_MySpeakString(string sString);\r\n//Makes the nearest PC say a speakstring.\r\nvoid Db_AssignPCDebugString(string sString);\r\n//Basically, a wrapper for AurPostString\r\nvoid Db_PostString(string sString = "",int x = 5,int y = 5,float fShow = 1.0);\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Debug Print String\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Inserts a print string into the log file for\r\n    debugging purposes.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: June 12, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid Db_MyPrintString(string sString)\r\n{\r\n    if(!ShipBuild())\r\n    {\r\n        PrintString(sString);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Debug Speak String\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Makes the object running the script say a\r\n    speak string.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: June 12, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid Db_MySpeakString(string sString)\r\n{\r\n    SpeakString(sString);\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Assign PC Debug String\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Assigns the nearest PC a speakstring for debug\r\n    purposes.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: June 12, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid Db_AssignPCDebugString(string sString)\r\n{\r\n    object oPC = GetNearestCreature(CREATURE_TYPE_PLAYER_CHAR, PLAYER_CHAR_IS_PC);\r\n    if(GetIsObjectValid(oPC))\r\n    {\r\n        AssignCommand(oPC, SpeakString(sString));\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Db_PostString\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n//Basically, a wrapper for AurPostString\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Jason Booth\r\n//:: Created On: July 15, 2002\r\n//:://////////////////////////////////////////////\r\nvoid Db_PostString(string sString = "",int x = 5,int y = 5,float fShow = 1.0)\r\n{\r\n    if(!ShipBuild())\r\n    {\r\n        AurPostString(sString,x,y,fShow);\r\n    }\r\n}\r\n\r\n', 'k_inc_disguise': b'//:: k_inc_disguise\r\n/*\r\n    This script contains all functions necessary to add and\r\n    remove disguises on all party members.\r\n*/\r\n\r\nvoid DonEnvironmentSuit() {\r\n\r\n    object oPC;\r\n    int nMax = GetPartyMemberCount();\r\n    int nIdx;\r\n    effect eChange = EffectDisguise(DISGUISE_TYPE_ENVIRONMENTSUIT);\r\n    for(nIdx = 0;nIdx < nMax; nIdx++)\r\n    {\r\n        ApplyEffectToObject(DURATION_TYPE_PERMANENT,eChange,GetPartyMemberByIndex(nIdx));\r\n    }\r\n}\r\n\r\nvoid DonSpaceSuit() {\r\n    int nMax = GetPartyMemberCount();\r\n    int nIdx;\r\n    effect eChange = EffectDisguise(DISGUISE_TYPE_ENVIRONMENTSUIT_02);\r\n    for(nIdx = 0;nIdx < nMax; nIdx++)\r\n    {\r\n        object oPartyMember = GetPartyMemberByIndex(nIdx);\r\n        ApplyEffectToObject(DURATION_TYPE_PERMANENT,eChange,oPartyMember);\r\n    }\r\n}\r\n\r\nvoid RemoveDisguises() {\r\n\r\n    int nDisguise = EFFECT_TYPE_DISGUISE;\r\n    object oPC;\r\n    effect eEffect;\r\n    int nMax = GetPartyMemberCount();\r\n    int nIdx;\r\n    for(nIdx = 0;nIdx < nMax; nIdx++)\r\n    {\r\n        oPC = GetPartyMemberByIndex(nIdx);\r\n        eEffect = GetFirstEffect(oPC);\r\n        while(GetIsEffectValid(eEffect))\r\n        {\r\n            if(GetEffectType(eEffect) == nDisguise)\r\n            {\r\n                RemoveEffect(oPC,eEffect);\r\n            }\r\n            eEffect = GetNextEffect(oPC);\r\n        }\r\n    }\r\n}\r\n', 'k_inc_drop': b'//::///////////////////////////////////////////////\r\n//:: KOTOR Treasure drop Include\r\n//:: k_inc_drop\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n// Contains the functions for handling creatures dropping random treasure\r\n//Only human creatures not of the beast subrace willdrop treasure dependant\r\n//on their hit dice\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Aidan Scanlan On: 02/06/03\r\n//:://////////////////////////////////////////////\r\n\r\nint DR_HIGH_LEVEL = 15;\r\nint DR_MEDIUM_LEVEL = 10;\r\nint DR_LOW_LEVEL = 5;\r\nint DR_SUBRACE_BEAST = 2;\r\n//Checks for treasure drop conditions. Returns True if treasure will drop\r\nint DR_SpawnCreatureTreasure(object oTarget = OBJECT_SELF);\r\n//Dependant on the level of a creature drops treasure from a list\r\nvoid DR_CreateRandomTreasure(object oTarget = OBJECT_SELF);\r\n// creates a low level treasure: med pack/repair, frag grenade, credits\r\nvoid DR_CreateLowTreasure();\r\n// creates midlevel treasure: adv-med/repair, any gredade, stims, credits\r\nvoid DR_CreateMidTreasure();\r\n// creates high treasure: adv stims, grenades, ultra med/repair, credits\r\nvoid DR_CreateHighTreasure();\r\n// Creates 1-4 credits\r\nvoid DR_CreateFillerCredits();\r\n/////////////////////////////////////////////////////////////////////////\r\n\r\n\r\n//Checks for treasure drop conditions. Returns True if treasure will drop\r\nint DR_SpawnCreatureTreasure(object oTarget = OBJECT_SELF)\r\n{\r\n    int nRace = GetRacialType(oTarget);\r\n    int nFaction = GetStandardFaction(oTarget);\r\n    int nSubRace = GetSubRace(oTarget);\r\n    if(Random(4) == 0 &&\r\n       nRace != RACIAL_TYPE_DROID &&\r\n       nSubRace != DR_SUBRACE_BEAST)\r\n    {\r\n        //AurPostString("will drop",5,5,5.0);\r\n        DR_CreateRandomTreasure(oTarget);\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n//Dependant on the level of a creature drops treasure from a list\r\nvoid DR_CreateRandomTreasure(object oTarget = OBJECT_SELF)\r\n{\r\n    int nLevel = GetHitDice(oTarget);\r\n    if (nLevel > DR_HIGH_LEVEL)\r\n    {\r\n        DR_CreateHighTreasure();\r\n        if(Random(2) == 0)\r\n        {\r\n            DR_CreateHighTreasure();\r\n        }\r\n        if(Random(2) == 0)\r\n        {\r\n            DR_CreateMidTreasure();\r\n        }\r\n    }\r\n    else if (nLevel <= DR_HIGH_LEVEL && nLevel > DR_MEDIUM_LEVEL)\r\n    {\r\n        DR_CreateMidTreasure();\r\n        if(Random(3) == 0)\r\n        {\r\n            DR_CreateHighTreasure();\r\n        }\r\n        if(Random(2) == 0)\r\n        {\r\n            DR_CreateMidTreasure();\r\n        }\r\n    }\r\n    else if (nLevel <= DR_MEDIUM_LEVEL && nLevel > DR_LOW_LEVEL)\r\n    {\r\n        DR_CreateMidTreasure();\r\n        if(Random(2) == 0)\r\n        {\r\n            DR_CreateLowTreasure();\r\n        }\r\n    }\r\n    else\r\n    {\r\n        DR_CreateLowTreasure();\r\n        if(Random(3) == 0)\r\n        {\r\n            DR_CreateLowTreasure();\r\n        }\r\n        if(Random(4) == 0)\r\n        {\r\n            DR_CreateMidTreasure();\r\n        }\r\n    }\r\n}\r\n\r\n// creates a low level treasure: med pack/repair, frag grenade, credits\r\nvoid DR_CreateLowTreasure()\r\n{\r\n   //AurPostString("dropping low",5,6,5.0);\r\n    string sTemplate;\r\n    int nStack = 1;\r\n    int nRandom = Random(6);\r\n    switch(nRandom)\r\n    {\r\n        case 0: sTemplate = "g_i_drdrepeqp001";  //repair kit\r\n        break;\r\n\r\n        case 1:\r\n            sTemplate = "g_i_credits001";// 5 stack\r\n            nStack = 5;\r\n            DR_CreateFillerCredits();\r\n        break;\r\n\r\n        case 2:\r\n            sTemplate = "g_i_credits002";  //10 stack\r\n            nStack = 10;\r\n            DR_CreateFillerCredits();\r\n        break;\r\n\r\n        case 3:\r\n            sTemplate = "g_i_credits003";  // 25 stack\r\n            nStack = 25;\r\n            DR_CreateFillerCredits();\r\n        break;\r\n\r\n        case 4: sTemplate = "g_i_medeqpmnt01";// med kit\r\n        break;\r\n\r\n        case 5: sTemplate = "g_w_fraggren01"; // frag grenade\r\n        break;\r\n    }\r\n\r\n    CreateItemOnObject(sTemplate,OBJECT_SELF,nStack);\r\n}\r\n\r\n// creates midlevel treasure: adv-med/repair, any gredade, stims, credits\r\nvoid DR_CreateMidTreasure()\r\n{\r\n    string sTemplate;\r\n    int nStack = 1;\r\n    int nRandom = Random(15);\r\n    switch (nRandom)\r\n    {\r\n        case 0: sTemplate = "g_i_drdrepeqp002";  //advanced repair kit\r\n        break;\r\n\r\n        case 1:\r\n            sTemplate = "g_i_credits004";  // 50 stack\r\n            nStack = 50;\r\n            DR_CreateFillerCredits();\r\n        break;\r\n\r\n        case 2: sTemplate = "g_i_medeqpmnt02"; //advanced med pack\r\n        break;\r\n\r\n        case 3: sTemplate = "g_i_cmbtshot001"; //battle stimulant\r\n        break;\r\n\r\n        case 4: sTemplate = "g_i_adrnaline003";  //adrenal stamina\r\n        break;\r\n\r\n        case 5: sTemplate = "g_i_adrnaline002"; // adrenal alacrity\r\n        break;\r\n\r\n        case 6: sTemplate = "g_i_adrnaline001"; // adrenal strength\r\n        break;\r\n\r\n        case 7:\r\n            sTemplate = "g_w_stungren01";  // stun grenade\r\n            nStack = 2;\r\n        break;\r\n\r\n        case 8:\r\n            sTemplate = "g_w_fraggren01";  // fragmentation grenade\r\n            nStack = 2;\r\n        break;\r\n\r\n        case 9: sTemplate = "g_w_poisngren01"; // poison gredade\r\n        break;\r\n\r\n        case 10: sTemplate = "g_w_sonicgren01"; // sonic grenade\r\n        break;\r\n\r\n        case 11: sTemplate = "g_w_adhsvgren001"; // adhesive grenade\r\n        break;\r\n\r\n        case 12: sTemplate = "g_w_cryobgren001";// cryo grenade\r\n        break;\r\n\r\n        case 13: sTemplate = "g_w_iongren01";// ion grenade\r\n        break;\r\n    }\r\n    CreateItemOnObject(sTemplate,OBJECT_SELF,nStack);\r\n}\r\n\r\n// creates high treasure: adv stims, grenades, ultra med/repair, credits\r\nvoid DR_CreateHighTreasure()\r\n{\r\n    string sTemplate;\r\n    int nStack = 1;\r\n    int nRandom = Random(16);\r\n    switch (nRandom)\r\n    {\r\n        case 0: sTemplate = "g_i_drdrepeqp003";  //super repair kit\r\n        break;\r\n\r\n        case 1: sTemplate = "g_w_thermldet01"; //Thermal detinator\r\n        break;\r\n\r\n        case 2: sTemplate = "g_i_medeqpmnt03"; //life pack\r\n        break;\r\n\r\n        case 3: sTemplate = "g_i_cmbtshot003";//speed stim\r\n        break;\r\n\r\n        case 4: sTemplate = "g_i_cmbtshot002"; //hyper battle stim\r\n        break;\r\n\r\n        case 5: sTemplate = "g_i_adrnaline006"; //huper adrenal stamina\r\n        break;\r\n\r\n        case 6: sTemplate = "g_i_adrnaline005"; //hyper adrenal alacrity\r\n        break;\r\n\r\n        case 7: sTemplate = "g_i_adrnaline004";// hyper adrenal strength\r\n        break;\r\n\r\n        case 8:\r\n        sTemplate = "g_w_poisngren01"; // poison gredade\r\n        nStack = 2;\r\n        break;\r\n\r\n        case 9:\r\n        sTemplate = "g_w_sonicgren01"; // sonic grenade\r\n        nStack = 2;\r\n        break;\r\n\r\n        case 10:\r\n        sTemplate = "g_w_adhsvgren001"; // adhesive grenade\r\n        nStack = 2;\r\n        break;\r\n\r\n        case 11:\r\n        sTemplate = "g_w_cryobgren001";// cryo grenade\r\n        nStack = 2;\r\n        break;\r\n\r\n        case 12:\r\n        sTemplate = "g_w_firegren001";// plasma grenade\r\n        nStack = 2;\r\n        break;\r\n\r\n        case 13:\r\n        sTemplate = "g_w_iongren01";// ion grenade\r\n        nStack = 2;\r\n        break;\r\n\r\n        case 14:\r\n        sTemplate = "g_i_credits015";\r\n        nStack = Random(50) + 50;\r\n        break;\r\n\r\n        case 15: sTemplate = "g_w_firegren001";// plasma grenade\r\n        break;\r\n\r\n    }\r\n    CreateItemOnObject(sTemplate,OBJECT_SELF,nStack);\r\n}\r\n\r\n// Creates 1-4 credits\r\nvoid DR_CreateFillerCredits()\r\n{\r\n    CreateItemOnObject("g_i_credits015",OBJECT_SELF,Random(4) + 1);\r\n}\r\n', 'k_inc_fab': b'// k_inc_fab\r\n/*\r\n    Ferret\'s Wacky Include Script - YAY\r\n    A running compilation of short cuts\r\n    to make life easier\r\n*/\r\n// FAB 3/11\r\n\r\n// This spawns in a creature with resref sCreature\r\n// in waypoint location "sp_<sCreature><nInstance>"\r\nobject FAB_Spawn( string sCreature, int nInstance = 0 );\r\n\r\n// This makes oAct face in the direction of oFace\r\n// if oFace is left blank it defaults to the PC\r\nvoid FAB_Face( object oAct, object oFace = OBJECT_INVALID );\r\n\r\n// This function teleports the PC to oWP then any\r\n// other CNPCs are teleported behind the PC.\r\n// WARNING: Make sure that behind the waypoint there\r\n// are valid points for the CNPCs to teleport to.\r\nvoid FAB_PCPort( object oWP );\r\n\r\n// This function returns a location directly behind the object\r\n// you pass it. The float can be changed to determine how far\r\n// behind the PC.\r\nlocation FAB_Behind( object oTarg, float fMult = 2.5 );\r\n\r\n// This spawns in a creature with resref sCreature\r\n// in waypoint location "sp_<sCreature><nInstance>"\r\nobject FAB_Spawn( string sCreature, int nInstance = 0 )\r\n{\r\n\r\n    string sWP;\r\n\r\n    if ( nInstance == 0 ) sWP = "sp_" + sCreature ;\r\n    else sWP = "sp_" + sCreature + IntToString( nInstance );\r\n\r\n    return CreateObject( OBJECT_TYPE_CREATURE, sCreature, GetLocation( GetObjectByTag( sWP ) ));\r\n\r\n}\r\n\r\n// This makes oAct face in the direction of oFace\r\n// if oFace is left blank it defaults to the PC\r\nvoid FAB_Face( object oAct, object oFace = OBJECT_INVALID )\r\n{\r\n\r\n    if ( oFace == OBJECT_INVALID ) oFace = GetFirstPC();\r\n\r\n    AssignCommand( oAct, SetFacingPoint( GetPositionFromLocation(GetLocation(oFace)) ));\r\n\r\n}\r\n\r\n// This function teleports the PC to oWP then any\r\n// other CNPCs are teleported behind the PC.\r\n// WARNING: Make sure that behind the waypoint there\r\n// are valid points for the CNPCs to teleport to.\r\nvoid FAB_PCPort( object oWP )\r\n{\r\n\r\n    AurPostString("Testing!",5,4,2.0);\r\n    //object oWP = GetObjectByTag( "tp_test" );\r\n    //object oTarg = GetFirstPC();\r\n    object oTarg = GetPartyMemberByIndex(0);\r\n\r\n    DelayCommand( 0.1, AssignCommand( oTarg, ClearAllActions() ));\r\n    DelayCommand( 0.2, AssignCommand( oTarg, ActionJumpToObject(oWP) ) );\r\n\r\n    float fX = 0.0;\r\n    float fY = 0.0;\r\n\r\n    float fFacing = GetFacing( oWP ) + 0.0;\r\n    float fFacing2 = GetFacing( oWP ) + 90.0;\r\n    float fTempFace;\r\n    vector vTest;\r\n\r\n    if ( fFacing >  180.0 ) fTempFace = fFacing - 360.0;\r\n    else fTempFace = fFacing;\r\n\r\n    fTempFace = fTempFace / 90;\r\n\r\n    if ( fTempFace < -1.0 ) fTempFace = -( fTempFace + 2.0 );\r\n    if ( fTempFace > 1.0 ) fTempFace = -( fTempFace - 2.0 );\r\n\r\n    fY = fTempFace * -2.5;\r\n\r\n    // Come up with X adjust based on Facing2\r\n    if ( fFacing2 > 360.0 ) fFacing2 = fFacing2 - 360.0;\r\n    if ( fFacing2 >  180.0 ) fTempFace = fFacing2 - 360.0;\r\n    else fTempFace = fFacing2;\r\n\r\n    fTempFace = fTempFace / 90;\r\n\r\n    if ( fTempFace < -1.0 ) fTempFace = -( fTempFace + 2.0 );\r\n    if ( fTempFace > 1.0 ) fTempFace = -( fTempFace - 2.0 );\r\n\r\n    fX = fTempFace * -2.5;\r\n\r\n    //AurPostString("fFacing: " + FloatToString(fFacing),5,4,2.0);\r\n    //AurPostString("fX: " + FloatToString(fX) + ", fY: " + FloatToString(fY),5,5,2.0);\r\n\r\n    //oTarg = GetObjectByTag( "bith",0 );\r\n    oTarg = GetPartyMemberByIndex(1);\r\n\r\n    if( GetIsObjectValid(oTarg) && GetCurrentHitPoints(oTarg) > 1 )\r\n    {\r\n        SetCommandable(TRUE,oTarg);\r\n        vTest = GetPositionFromLocation(GetLocation(oWP)) + Vector(fX,fY);\r\n        DelayCommand( 0.1, AssignCommand( oTarg, ClearAllActions() ));\r\n        DelayCommand( 0.2, AssignCommand( oTarg, ActionJumpToLocation( Location(vTest,fFacing) ) ));\r\n        //SetCommandable(FALSE,oTarg);\r\n    }\r\n\r\n    //oTarg = GetObjectByTag( "bith",1 );\r\n    oTarg = GetPartyMemberByIndex(2);\r\n    if( GetIsObjectValid(oTarg) && GetCurrentHitPoints(oTarg) > 1 )\r\n    {\r\n        SetCommandable(TRUE,oTarg);\r\n        vTest = GetPositionFromLocation(GetLocation(oWP)) + Vector(fX * 1.9,fY * 1.9);\r\n        DelayCommand( 0.1, AssignCommand( oTarg, ClearAllActions() ));\r\n        DelayCommand( 0.2, AssignCommand( oTarg, ActionJumpToLocation( Location(vTest,fFacing) ) ));\r\n        //SetCommandable(FALSE,oTarg);\r\n    }\r\n\r\n}\r\n\r\n// This function returns a location directly behind the object\r\n// you pass it. The float can be changed to determine how far\r\n// behind the PC.\r\nlocation FAB_Behind( object oTarg, float fMult = 2.5 )\r\n{\r\n\r\n    float fX = 0.0;\r\n    float fY = 0.0;\r\n\r\n    float fFacing = GetFacing( oTarg ) + 0.0;\r\n    float fFacing2 = GetFacing( oTarg ) + 90.0;\r\n    float fTempFace;\r\n    vector vTest;\r\n\r\n    if ( fFacing >  180.0 ) fTempFace = fFacing - 360.0;\r\n    else fTempFace = fFacing;\r\n\r\n    fTempFace = fTempFace / 90;\r\n\r\n    if ( fTempFace < -1.0 ) fTempFace = -( fTempFace + 2.0 );\r\n    if ( fTempFace > 1.0 ) fTempFace = -( fTempFace - 2.0 );\r\n\r\n    fY = fTempFace * - fMult;\r\n\r\n    // Come up with X adjust based on Facing2\r\n    if ( fFacing2 > 360.0 ) fFacing2 = fFacing2 - 360.0;\r\n    if ( fFacing2 >  180.0 ) fTempFace = fFacing2 - 360.0;\r\n    else fTempFace = fFacing2;\r\n\r\n    fTempFace = fTempFace / 90;\r\n\r\n    if ( fTempFace < -1.0 ) fTempFace = -( fTempFace + 2.0 );\r\n    if ( fTempFace > 1.0 ) fTempFace = -( fTempFace - 2.0 );\r\n\r\n    fX = fTempFace * - fMult;\r\n\r\n    vTest = GetPositionFromLocation(GetLocation(oTarg)) + Vector(fX,fY);\r\n\r\n    return Location( vTest,fFacing );\r\n\r\n}\r\n\r\n\r\n', 'k_inc_fakecombat': b'//:: k_inc_fakecombat\r\n/*\r\n     routines for doing fake combat\r\n*/\r\n//:: Created By: Jason Booth\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n\r\n#include "k_inc_generic"\r\nvoid FAI_EnableFakeMode(object oTarget,int iFaction);\r\nvoid FAI_DisableFakeMode(object oTarget,int iFaction);\r\nvoid FAI_PerformFakeAttack(object oAttacker,object oTarget,int bLethal = FALSE);\r\nvoid FAI_PerformFakeTalent(object oAttacker,object oTarget,talent t,int bLethal = FALSE);\r\n\r\nvoid FAI_EnableFakeMode(object oTarget,int iFaction)\r\n{\r\n  if(!GetIsObjectValid(oTarget))\r\n  {\r\n    return;\r\n  }\r\n\r\n  SetCommandable(TRUE,oTarget);\r\n  AssignCommand(oTarget,ClearAllActions());\r\n  SetLocalBoolean(oTarget,SW_FLAG_AI_OFF,TRUE);\r\n  AurPostString("TURNING AI OFF - " + GetTag(oTarget),5,5,5.0);\r\n  ChangeToStandardFaction(oTarget,iFaction);\r\n  SetMinOneHP(oTarget,TRUE);\r\n}\r\n\r\nvoid FAI_DisableFakeMode(object oTarget,int iFaction)\r\n{\r\n  if(!GetIsObjectValid(oTarget))\r\n  {\r\n    return;\r\n  }\r\n\r\n  SetCommandable(TRUE,oTarget);\r\n  SetLocalBoolean(oTarget,SW_FLAG_AI_OFF,FALSE);\r\n  ChangeToStandardFaction(oTarget,iFaction);\r\n  SetMinOneHP(oTarget,FALSE);\r\n}\r\n\r\nvoid DoFakeAttack(object oTarget,int bLethal)\r\n{\r\n  if(bLethal)\r\n  {\r\n    SetMinOneHP(oTarget,FALSE);\r\n    ApplyEffectToObject(DURATION_TYPE_INSTANT,EffectDamage(GetCurrentHitPoints(oTarget)-1),\r\n      oTarget);\r\n    //CutsceneAttack(oTarget,ACTION_ATTACKOBJECT,ATTACK_RESULT_HIT_SUCCESSFUL,1000);\r\n  }\r\n  //else\r\n  //{\r\n    ApplyEffectToObject(DURATION_TYPE_TEMPORARY,EffectAssuredHit(),OBJECT_SELF,3.0);\r\n    ActionAttack(oTarget);\r\n //}\r\n}\r\n\r\nvoid FAI_PerformFakeAttack(object oAttacker,object oTarget,int bLethal = FALSE)\r\n{\r\n  if(!GetIsObjectValid(oAttacker) || !GetIsObjectValid(oTarget))\r\n  {\r\n    return;\r\n  }\r\n\r\n  AssignCommand(oAttacker,ActionDoCommand(DoFakeAttack(oTarget,bLethal)));\r\n}\r\n\r\nvoid DoFakeTalent(object oTarget,talent t,int bLethal)\r\n{\r\n  if(bLethal)\r\n  {\r\n    SetMinOneHP(oTarget,FALSE);\r\n    ApplyEffectToObject(DURATION_TYPE_INSTANT,EffectDamage(GetCurrentHitPoints(oTarget)-1),\r\n      oTarget);\r\n  }\r\n\r\n  ApplyEffectToObject(DURATION_TYPE_TEMPORARY,EffectAssuredHit(),OBJECT_SELF,3.0);\r\n  ActionUseTalentOnObject(t,oTarget);\r\n}\r\n\r\nvoid FAI_PerformFakeTalent(object oAttacker,object oTarget,talent t,int bLethal = FALSE)\r\n{\r\n  if(!GetIsObjectValid(oAttacker) || !GetIsObjectValid(oTarget))\r\n  {\r\n    return;\r\n  }\r\n\r\n  AssignCommand(oAttacker,ActionDoCommand(DoFakeTalent(oTarget,t,bLethal)));\r\n}\r\n', 'k_inc_force': b'//:: k_inc_force\r\n/*\r\n    v1.0\r\n    Force Powers Include for KOTOR\r\n*/\r\n//:: Created By: Preston Watamaniuk\r\n//:: Copyright (c) 2002 Bioware Corp.\r\n\r\nfloat fLightningDuration = 1.0;\r\n\r\n//These variables are set in the script run area.\r\nint SWFP_PRIVATE_SAVE_TYPE;\r\nint SWFP_PRIVATE_SAVE_VERSUS_TYPE;\r\nint SWFP_DAMAGE;\r\nint SWFP_DAMAGE_TYPE;\r\nint SWFP_DAMAGE_VFX;\r\nint SWFP_HARMFUL;\r\nint SWFP_SHAPE;\r\n\r\n//Runs the script section for the particular force power.\r\nvoid  Sp_RunForcePowers();\r\n//Immunity and Resist Spell check for the force power.\r\n//The eDamage checks whether the target is immune to the damage effect\r\nint Sp_BlockingChecks(object oTarget, effect eEffect, effect eEffect2, effect eDamage);\r\n//Makes the necessary saving throws\r\nint Sp_MySavingThrows(object oTarget, int iSpellDC = 0);\r\n//Remove an effect of a specific type\r\nvoid Sp_RemoveSpecificEffect(int nEffectTypeID, object oTarget);\r\n//Remove an effect from a specific force power.\r\nvoid Sp_RemoveSpellEffects(int nSpell_ID, object oCaster, object oTarget);\r\n// Delays the application of a spell effect by an amount determined by distance.\r\nfloat Sp_GetSpellEffectDelay(location SpellTargetLocation, object oTarget);\r\n//Randomly delays the effect application for a default of 0.0 to 0.75 seconds\r\nfloat Sp_GetRandomDelay(float fMinimumTime = 0.0, float MaximumTime = 0.75);\r\n//Gets a saving throw appropriate to the jedi using the force power.\r\nint Sp_GetJediDCSave();\r\n///Apply effects in a sphere shape.\r\nvoid Sp_SphereSaveHalf(object oAnchor, float fSize, int nCounter, effect eLink1, float fDuration1, effect eLink2, float fDuration);\r\n//Apply effects to a single target.\r\nvoid Sp_SingleTarget(object oAnchor, effect eLink1, float fDuration1, effect eLink2, float fDuration2);\r\n//Apply effect to an area and negate on a save.\r\nvoid Sp_SphereBlocking(object oAnchor, float fSize, int nCounter, effect eLink1, float fDuration1, effect eLink2, float fDuration);\r\n// /Apply effect to an object and negate on a save.\r\nvoid Sp_SingleTargetBlocking(object oAnchor, effect eLink1, float fDuration1, effect eLink2, float fDuration2);\r\n//Apply effects for a for power.\r\nvoid Sp_ApplyForcePowerEffects(float fTime, effect eEffect, object oTarget);\r\n//Apply effects to targets.\r\nvoid Sp_ApplyEffects(int nBlocking, object oAnchor, float fSize, int nCounter, effect eLink1, float fDuration1, effect eLink2, float fDuration2, int nRacial = RACIAL_TYPE_ALL);\r\n//Removes all effects from the spells , Knights Mind, Mind Mastery and Battle Meditation\r\nvoid Sp_RemoveBuffSpell();\r\n//Prints a string for the spell stript\r\nvoid SP_MyPrintString(string sString);\r\n//Posts a string for the spell script\r\nvoid SP_MyPostString(string sString, int n1 = 5, int n2 = 10, float fTime = 4.0);\r\n//Interates through given a time period and a damage amount and hurts someone.  Checks if the person is in conversation.\r\nvoid SP_InterativeDamage(effect eDamage, int nSecondsRemaining, object oTarget);\r\n//Checks to see if the target is a Turret\r\nint SP_CheckAppearanceTurret(object oTarget, int nFeedback = FALSE);\r\n//Checks to see if the target is a Mark 1, 2, 4 or Spyder Droid\r\nint SP_CheckAppearanceGeoDroid(object oTarget);\r\n//Checks if the character already has Energy Resistance and Improved Energy Resistance\r\nint SP_CheckEnergyResistance(object oTarget);\r\n//This checks all of the delayed effect applications to make sure the target is still hostile and has not surrendered\r\nvoid SP_MyApplyEffectToObject(int nDurationType, effect eEffect, object oTarget, float fDuration=0.0);\r\n//Checks droids appearance type and if they have shields up\r\nint SP_CheckAppearanceGeoDroidShields(object oTarget, int nFeedback = FALSE);\r\n//Check push compatibility, if true is passed in for the Whirlwind an addition check for shields is made\r\nint SP_CheckForcePushViability(object oTarget, int Whirlwind);\r\n\r\n// DJS-OEI 12/9/2003\r\nvoid Sp_RemoveRelatedPowers( object oTarget, int nPowerID );\r\nint Sp_BetterRelatedPowerExists( object oTarget, int nPowerID );\r\nvoid Sp_RemoveRelatedPowersInRadius( int nPowerID, float nRadius );\r\nint Sp_IsJedi( object oTarget );\r\n\r\n// DJS-OEI 3/25/2004\r\n// Due to the addition of Lightsaber/Consular Forms and their\r\n// frequent modification of damage, I\'ve implemented this function\r\n// to calculate the damage for a Force Power based on the parameters\r\n// passed in, as well as adding in modifiers based on the target\r\n// or caster\'s active Form.\r\nint Sp_CalcDamage( object oTarget, int nNumDice, int nSizeDice, int nFlatAmount=0 );\r\n\r\n// DJS-OEI 3/28/2004\r\n// Similar to Sp_CalcDamage(), this function calculates the duration\r\n// of a Force Power, taking into account the base duration as well\r\n// as modifiers due to Consular Forms.\r\nfloat Sp_CalcDuration( float fBaseDuration );\r\n\r\n// DJS-OEI 3/29/2004\r\n// Similar to Sp_CalcDamage(), this function calculates the range\r\n// of a Force Power, taking into account the base range as well\r\n// as modifiers due to Consular Forms.\r\nfloat Sp_CalcRange( float fBaseRange );\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Apply Delayed Effect\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    This checks all of the delayed effect applications\r\n    to make sure the target is still hostile and has\r\n    not surrendered\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: May 20, 2003\r\n//:://////////////////////////////////////////////\r\nvoid SP_MyApplyEffectToObject(int nDurationType, effect eEffect, object oTarget, float fDuration=0.0)\r\n{\r\n    if(GetIsEnemy(oTarget))\r\n    {\r\n        ApplyEffectToObject(nDurationType, eEffect, oTarget, fDuration);\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Interative Damage\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Interates through given a time period and a\r\n    damage amount and hurts someone.  Checks if\r\n    the person is in conversation.\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: April 5, 2003\r\n//:://////////////////////////////////////////////\r\nvoid SP_InterativeDamage(effect eDamage, int nSecondsRemaining, object oTarget)\r\n{\r\n    if(GetIsObjectValid(oTarget))\r\n    {\r\n        if(!GetIsConversationActive() && !GetIsDead(oTarget) && GetIsEnemy(oTarget))\r\n        {\r\n             if (nSecondsRemaining % 2 == 0)\r\n             {\r\n                  ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n             }\r\n             --nSecondsRemaining;\r\n             if (nSecondsRemaining > 0)\r\n             {\r\n                DelayCommand(1.0f, SP_InterativeDamage(eDamage, nSecondsRemaining, oTarget));\r\n             }\r\n        }\r\n    }\r\n}\r\n\r\n//::///////////////////////////////////////////////\r\n//:: Blocking Checks\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Does the Spell Resistance and Immunity\r\n    Checks\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: Aug 15, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nint Sp_BlockingChecks(object oTarget, effect eEffect1, effect eEffect2, effect eDamage)\r\n{\r\n    int nReturn = FALSE;\r\n    //MODIFIED by Preston Watamaniuk on April 11th\r\n    //Put the immunity check in place for Force Powers.\r\n    if(GetIsLinkImmune(oTarget, eEffect1) || GetIsLinkImmune(oTarget, eEffect2) || GetIsLinkImmune(oTarget, eDamage))\r\n    {\r\n        DisplayFeedBackText(oTarget, 1);\r\n        nReturn = TRUE;\r\n    }\r\n\r\n    // DJS-OEI 7/20/2004\r\n    // Form/Stance re-design.\r\n    /*\r\n    // DJS-OEI 3/29/2004\r\n    // Users of the Power of the Dark Side III Consular Form\r\n    // are immune to any spell with the Form Mask for that Form.\r\n    if( GetSpellFormMask( GetSpellId() ) & FORM_MASK_POWER_OF_THE_DARK_SIDE ) {\r\n        if( IsFormActive( oTarget, FORM_CONSULAR_POWER_OF_THE_DARK_SIDE_III ) ) {\r\n            DisplayFeedBackText(oTarget, 1);\r\n            nReturn = TRUE;\r\n        }\r\n    }\r\n    */\r\n\r\n    if(ResistForce(OBJECT_SELF, oTarget))\r\n    {\r\n        DisplayFeedBackText(oTarget, 0);\r\n        nReturn = TRUE;\r\n    }\r\n\r\n    if(nReturn == TRUE)\r\n    {\r\n        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceResisted(OBJECT_SELF), oTarget);\r\n    }\r\n\r\n    return nReturn;\r\n}\r\n\r\n// DJS-OEI 3/16/2004\r\nint Sp_IsJedi( object oTarget ) {\r\n\r\n    if( ( GetLevelByClass( CLASS_TYPE_JEDICONSULAR, oTarget ) > 0 ) ||\r\n        ( GetLevelByClass( CLASS_TYPE_JEDIGUARDIAN, oTarget ) > 0 ) ||\r\n        ( GetLevelByClass( CLASS_TYPE_JEDIMASTER, oTarget ) > 0 ) ||\r\n        ( GetLevelByClass( CLASS_TYPE_JEDISENTINEL, oTarget ) > 0 ) ||\r\n        ( GetLevelByClass( CLASS_TYPE_JEDIWATCHMAN, oTarget ) > 0 ) ||\r\n        ( GetLevelByClass( CLASS_TYPE_JEDIWEAPONMASTER, oTarget ) > 0 ) ||\r\n        ( GetLevelByClass( CLASS_TYPE_SITHASSASSIN, oTarget ) > 0 ) ||\r\n        ( GetLevelByClass( CLASS_TYPE_SITHLORD, oTarget ) > 0 ) ||\r\n        ( GetLevelByClass( CLASS_TYPE_SITHMARAUDER, oTarget ) > 0 ) ) {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n\r\n// DJS-OEI 3/25/2004\r\n// Due to the addition of Lightsaber/Consular Forms and their\r\n// frequent modification of damage, I\'ve implemented this function\r\n// to calculate the damage for a Force Power based on the parameters\r\n// passed in, as well as adding in modifiers based on the target\r\n// or caster\'s active Form.\r\nint Sp_CalcDamage( object oTarget, int nNumDice, int nSizeDice, int nFlatAmount ) {\r\n\r\n    int nDamage = 0;\r\n    int nMod = 0;\r\n    int nCounter = 0;\r\n\r\n    if( nFlatAmount != 0 ) {\r\n        nDamage = nFlatAmount;\r\n    }\r\n    else {\r\n        // DJS-OEI 7/20/2004\r\n        // Form/Stance re-design.\r\n        /*\r\n        // The caller is using using die rolls to determine.\r\n        // damage. The Force Potency Form tree plays havoc\r\n        // with this process since it can change rolls of 1 or 2\r\n        // to higher values.\r\n        if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_FORCE_POTENCY_I ) ) {\r\n\r\n            // Change all ones rolled to twos.\r\n            int nRoll;\r\n            for( nCounter=0; nCounter<nNumDice; nCounter++ ) {\r\n\r\n                nRoll = Random( nSizeDice ) + 1;\r\n                if( nRoll < 2 ) {\r\n                    nRoll = 2;\r\n                }\r\n                nDamage += nRoll;\r\n            }\r\n        }\r\n        else if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_FORCE_POTENCY_II ) ||\r\n                 IsFormActive( OBJECT_SELF, FORM_CONSULAR_FORCE_POTENCY_III ) ) {\r\n\r\n            // Change all ones and twos rolled to threes.\r\n            int nRoll;\r\n            for( nCounter=0; nCounter<nNumDice; nCounter++ ) {\r\n\r\n                nRoll = Random( nSizeDice ) + 1;\r\n                if( nRoll < 3 ) {\r\n                    nRoll = 3;\r\n                }\r\n                nDamage += nRoll;\r\n            }\r\n        }\r\n        */\r\n        switch( nSizeDice ) {\r\n            case 2:\r\n                nDamage = d2( nNumDice );\r\n                break;\r\n            case 3:\r\n                nDamage = d3( nNumDice );\r\n                break;\r\n            case 4:\r\n                nDamage = d4( nNumDice );\r\n                break;\r\n            case 6:\r\n                nDamage = d6( nNumDice );\r\n                break;\r\n            case 8:\r\n                nDamage = d8( nNumDice );\r\n                break;\r\n            case 10:\r\n                nDamage = d10( nNumDice );\r\n                break;\r\n            case 12:\r\n                nDamage = d12( nNumDice );\r\n                break;\r\n            case 20:\r\n                nDamage = d20( nNumDice );\r\n                break;\r\n            case 100:\r\n                nDamage = d100( nNumDice );\r\n                break;\r\n            default:\r\n                SP_MyPrintString("SP_CalcDamage() - Invalid Die Size:" + IntToString(nSizeDice));\r\n                return 0;\r\n                break;\r\n        }\r\n    }\r\n\r\n    // DJS-OEI 7/20/2004\r\n    // Form/Stance re-design.\r\n    /////////////////////////////////////////////////\r\n    // Modifiers due to caster\'s Form\r\n    /////////////////////////////////////////////////\r\n    // The Force Focus Form increases damage\r\n    // for offensive Force Powers.\r\n    if( IsFormActive( OBJECT_SELF, FORM_FORCE_I_FOCUS ) ) {\r\n        // +3 to damage.\r\n        nDamage += 3;\r\n    }\r\n    else if( IsFormActive( OBJECT_SELF, FORM_FORCE_II_POTENCY ) ) {\r\n        // DJS-OEI 8/24/2004\r\n        // Changed to +30%.\r\n        /*\r\n        // +1 damage for each class level. We\'ll just get the\r\n        // levels attained for the base class and sub-class.\r\n        int nTotalLevel = GetLevelByPosition( 1, OBJECT_SELF ) + GetLevelByPosition( 2, OBJECT_SELF );\r\n        nDamage += nTotalLevel;\r\n        */\r\n        int nExtraDamage = ( nDamage * 30 ) / 100;\r\n        nDamage += nExtraDamage;\r\n    }\r\n\r\n    /*\r\n    // The Force Focus Lightsaber Form I-III increases damage\r\n    // for offensive Force Powers.\r\n    if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_FORCE_FOCUS_I ) ) {\r\n        // +1 to damage.\r\n        nDamage += 1;\r\n    }\r\n    else if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_FORCE_FOCUS_II ) ) {\r\n        // +3 to damage.\r\n        nDamage += 3;\r\n    }\r\n    else if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_FORCE_FOCUS_III ) ) {\r\n        // If the damage is a flat amount, just add 5. Otherwise, the\r\n        // damage was calculated with die rolls. Increase the damage\r\n        // by 1 for each die rolled.\r\n        if( nFlatAmount == 0 ) {\r\n            nDamage += nNumDice;\r\n        }\r\n        else {\r\n            nDamage += 5;\r\n        }\r\n    }\r\n\r\n    // The Force Potency Form I-III increases damage for offensive\r\n    // Force Powers.\r\n    if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_FORCE_POTENCY_I ) ) {\r\n        // If the damage is a flat amount, just add 5. Otherwise, the\r\n        // damage was calculated with die rolls. Increase the damage\r\n        // by 1 for each die rolled.\r\n        if( nFlatAmount == 0 ) {\r\n            nDamage += nNumDice;\r\n        }\r\n        else {\r\n            nDamage += 5;\r\n        }\r\n    }\r\n    else if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_FORCE_POTENCY_II ) ) {\r\n        // If the damage is a flat amount, just add 7. Otherwise, the\r\n        // damage was calculated with die rolls. Increase the damage\r\n        // by 1 for each die rolled.\r\n        if( nFlatAmount == 0 ) {\r\n            nDamage += nNumDice;\r\n        }\r\n        else {\r\n            nDamage += 7;\r\n        }\r\n    }\r\n    else if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_FORCE_POTENCY_III ) ) {\r\n        // If the damage is a flat amount, just add 10. Otherwise, the\r\n        // damage was calculated with die rolls. Increase the damage\r\n        // by 2 for each die rolled.\r\n        if( nFlatAmount == 0 ) {\r\n            nDamage += nNumDice*2;\r\n        }\r\n        else {\r\n            nDamage += 10;\r\n        }\r\n    }\r\n\r\n    // The Power of the Dark Side Form I-III increases damage for offensive\r\n    // Force Powers.\r\n    if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_POWER_OF_THE_DARK_SIDE_I ) ||\r\n        IsFormActive( OBJECT_SELF, FORM_CONSULAR_POWER_OF_THE_DARK_SIDE_II ) ) {\r\n        // If the damage is a flat amount, add nothing. Otherwise, the\r\n        // damage was calculated with die rolls. Increase the damage\r\n        // by 1 for each die rolled.\r\n        if( nFlatAmount == 0 ) {\r\n            nDamage += nNumDice;\r\n        }\r\n    }\r\n    else if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_POWER_OF_THE_DARK_SIDE_III ) ) {\r\n        // If the damage is a flat amount, add nothing. Otherwise, the\r\n        // damage was calculated with die rolls. Increase the damage\r\n        // by 2 for each die rolled.\r\n        if( nFlatAmount == 0 ) {\r\n            nDamage += nNumDice*2;\r\n        }\r\n    }\r\n\r\n    /////////////////////////////////////////////////\r\n    // Modifiers due to target\'s Form\r\n    /////////////////////////////////////////////////\r\n\r\n    // The Ancient III Lightsaber Form and Force Armor III Form\r\n    // both reduce damage by 1/2 of the target\'s level.\r\n    if( IsFormActive( oTarget, FORM_LIGHTSABER_ANCIENT_III ) ||\r\n        IsFormActive( oTarget, FORM_CONSULAR_FORCE_SHELL_III ) ) {\r\n        nMod = GetHitDice( oTarget )/2;\r\n        if( nDamage > nMod ) {\r\n            nDamage -= nMod;\r\n        }\r\n        else {\r\n            nDamage = 0;\r\n        }\r\n    }\r\n\r\n    // The Force Armor II Form reduces damage by 4.\r\n    if( IsFormActive( oTarget, FORM_CONSULAR_FORCE_SHELL_II ) ) {\r\n        if( nDamage > 4 ) {\r\n            nDamage -= 4;\r\n        }\r\n        else {\r\n            nDamage = 0;\r\n        }\r\n    }\r\n    */\r\n\r\n    return nDamage;\r\n}\r\n\r\n// DJS-OEI 3/28/2004\r\n// Similar to Sp_CalcDamage(), this function calculates the duration\r\n// of a Force Power, taking into account the base duration as well\r\n// as modifiers due to Consular Forms.\r\nfloat Sp_CalcDuration( float fBaseDuration ) {\r\n\r\n    float fFinalDuration = fBaseDuration;\r\n\r\n    // DJS-OEI 7/20/2004\r\n    // Form/Stance re-design.\r\n    if( IsFormActive( OBJECT_SELF, FORM_FORCE_IV_MASTERY ) ) {\r\n        // Duration is increased by 50%.\r\n        fFinalDuration = fFinalDuration * 1.50f;\r\n    }\r\n\r\n    /*\r\n    // If the Form Mask of the spell we\'re casting has the\r\n    // Enduring Force mask, its duration can be modified\r\n    // when Enduring Force is the caster\'s active Form.\r\n    if( GetSpellFormMask( GetSpellId() ) & FORM_MASK_ENDURING_FORCE ) {\r\n        if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_ENDURING_FORCE_I ) ) {\r\n            // Duration is increased by 25%.\r\n            fFinalDuration = fFinalDuration * 1.25f;\r\n        }\r\n        else if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_ENDURING_FORCE_II ) ) {\r\n            // Duration is increased by 50%.\r\n            fFinalDuration = fFinalDuration * 1.50f;\r\n        }\r\n        else if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_ENDURING_FORCE_III ) ) {\r\n            // Duration is increased by 100%.\r\n            fFinalDuration = fFinalDuration * 2.0f;\r\n        }\r\n    }\r\n    */\r\n    return fFinalDuration;\r\n}\r\n\r\n// DJS-OEI 3/29/2004\r\n// Similar to Sp_CalcDamage(), this function calculates the range\r\n// of a Force Power, taking into account the base range as well\r\n// as modifiers due to Consular Forms.\r\nfloat Sp_CalcRange( float fBaseRange ) {\r\n\r\n    float fFinalRange = fBaseRange;\r\n\r\n    // DJS-OEI 7/20/2004\r\n    // Form/Stance re-design.\r\n    /*\r\n    // If the Form Mask of the spell we\'re casting has the\r\n    // Force Amplification mask, its range can be modified\r\n    // when Force Amplification is the caster\'s active Form.\r\n    if( GetSpellFormMask( GetSpellId() ) & FORM_MASK_FORCE_AMPLIFICATION ) {\r\n        if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_FORCE_AMPLIFICATION_I ) ) {\r\n            // Duration is increased by 25%.\r\n            fFinalRange = fFinalRange * 1.25f;\r\n        }\r\n        else if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_FORCE_AMPLIFICATION_II ) ) {\r\n            // Duration is increased by 50%.\r\n            fFinalRange = fFinalRange * 1.50f;\r\n        }\r\n        else if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_FORCE_AMPLIFICATION_III ) ) {\r\n            // Duration is increased by 100%.\r\n            fFinalRange = fFinalRange * 2.0f;\r\n        }\r\n    }\r\n    */\r\n    return fFinalRange;\r\n}\r\n\r\nint Sp_MySavingThrows(object oTarget, int iSpellDC = 0)\r\n{\r\n    int nSave;\r\n    int nMod;\r\n\r\n    // FAK - OEI , for allowing spell based DC\r\n    if (iSpellDC > 0)\r\n    {\r\n        nMod = iSpellDC;\r\n    }\r\n    else\r\n    {\r\n        nMod = Sp_GetJediDCSave();\r\n    }\r\n\r\n    // DJS-OEI 7/20/2004\r\n    // Form/Stance re-design.\r\n    /////////////////////////////////////////////////\r\n    // Modifiers due to caster\'s Form\r\n    /////////////////////////////////////////////////\r\n    if( IsFormActive( OBJECT_SELF, FORM_FORCE_IV_MASTERY ) ) {\r\n        // +2 bonus to DC.\r\n        nMod += 2;\r\n    }\r\n\r\n    /////////////////////////////////////////////////\r\n    // Modifiers due to target\'s Form\r\n    /////////////////////////////////////////////////\r\n    // If the target has a bonus to saves, we just decrease\r\n    // the DC by that amount. If it\'s a penalty, we increase it.\r\n    if( IsFormActive( oTarget, FORM_SABER_II_MAKASHI ) ||\r\n        IsFormActive( oTarget, FORM_FORCE_I_FOCUS ) ) {\r\n        // +2 bonus to save.\r\n        nMod -= 2;\r\n    }\r\n    else if( IsFormActive( oTarget, FORM_SABER_VI_NIMAN ) ) {\r\n        // +1 bonus to save.\r\n        nMod -= 1;\r\n    }\r\n    else if( IsFormActive( oTarget, FORM_SABER_VII_JUYO ) ||\r\n             IsFormActive( oTarget, FORM_FORCE_IV_MASTERY ) ) {\r\n        // -4 penalty to save.\r\n        nMod += 4;\r\n    }\r\n\r\n    /*\r\n    /////////////////////////////////////////////////\r\n    // Modifiers due to caster\'s Form\r\n    /////////////////////////////////////////////////\r\n\r\n    // DJS-OEI 3/25/2004\r\n    // The Power of the Dark Side Form provides bonuses to the\r\n    // DC of the save.\r\n    if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_POWER_OF_THE_DARK_SIDE_I ) ) {\r\n        // +1 bonus to DC.\r\n        nMod += 1;\r\n    }\r\n    else if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_POWER_OF_THE_DARK_SIDE_II ) ||\r\n             IsFormActive( OBJECT_SELF, FORM_CONSULAR_POWER_OF_THE_DARK_SIDE_III ) ) {\r\n        // +2 bonus to DC.\r\n        nMod += 2;\r\n    }\r\n\r\n    /////////////////////////////////////////////////\r\n    // Modifiers due to target\'s Form\r\n    /////////////////////////////////////////////////\r\n\r\n    // DJS-OEI 3/16/2004\r\n    // The Total Defense Stance gives Jedis a +4 to their\r\n    // saving throws versus force powers. We just decrease\r\n    // the DC by that amount.\r\n    if( IsInTotalDefense( oTarget ) && Sp_IsJedi( oTarget ) ) {\r\n        nMod -= 4;\r\n    }\r\n\r\n    // DJS-OEI 3/25/2004\r\n    // The Ancient Lightsaber Form provides bonuses to saves,\r\n    // which we handle as decreases to the DC.\r\n    if( IsFormActive( oTarget, FORM_LIGHTSABER_ANCIENT_I ) ||\r\n        IsFormActive( oTarget, FORM_LIGHTSABER_ANCIENT_II ) ) {\r\n        // +1 bonus to save.\r\n        nMod -= 1;\r\n    }\r\n    else if( IsFormActive( oTarget, FORM_LIGHTSABER_ANCIENT_III ) ) {\r\n        // +2 bonus to save.\r\n        nMod -= 2;\r\n    }\r\n\r\n    // DJS-OEI 3/25/2004\r\n    // The Force Armor I-III Form provides bonuses to saves,\r\n    // which we handle as decreases to the DC.\r\n    if( IsFormActive( oTarget, FORM_CONSULAR_FORCE_SHELL_I ) ) {\r\n        // +2 bonus to save.\r\n        nMod -= 2;\r\n    }\r\n    else if( IsFormActive( oTarget, FORM_CONSULAR_FORCE_SHELL_II ) ) {\r\n        // +4 bonus to save.\r\n        nMod -= 4;\r\n    }\r\n    else if( IsFormActive( oTarget, FORM_CONSULAR_FORCE_SHELL_III ) ) {\r\n        // +6 bonus to save.\r\n        nMod -= 6;\r\n    }\r\n    */\r\n\r\n    if( nMod < 0 ) {\r\n        nMod = 0;\r\n    }\r\n\r\n    if(SWFP_PRIVATE_SAVE_TYPE == SAVING_THROW_FORT)\r\n    {\r\n        nSave = FortitudeSave(oTarget,nMod, SWFP_PRIVATE_SAVE_VERSUS_TYPE);\r\n        SP_MyPrintString("Fort Save = " + IntToString(nSave) + " For DC of " + IntToString(nMod));\r\n    }\r\n    else if(SWFP_PRIVATE_SAVE_TYPE == SAVING_THROW_REFLEX)\r\n    {\r\n        nSave = ReflexSave(oTarget, nMod, SWFP_PRIVATE_SAVE_VERSUS_TYPE);\r\n        SP_MyPrintString("Reflex Save = " + IntToString(nSave)+" For DC of " + IntToString(nMod));\r\n    }\r\n    else if(SWFP_PRIVATE_SAVE_TYPE == SAVING_THROW_WILL)\r\n    {\r\n        nSave = WillSave(oTarget, nMod, SWFP_PRIVATE_SAVE_VERSUS_TYPE);\r\n        SP_MyPrintString("Will Save = " + IntToString(nSave)+" For DC of " + IntToString(nMod));\r\n    }\r\n    if(nSave > 0)\r\n    {\r\n        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceResisted(OBJECT_SELF), oTarget);\r\n        DisplayFeedBackText(oTarget, 2);\r\n    }\r\n    return nSave;\r\n}\r\n\r\nvoid Sp_RemoveSpellEffects(int nSpell_ID, object oCaster, object oTarget)\r\n{\r\n    //Declare major variables\r\n    int bValid = FALSE;\r\n    effect eAOE;\r\n    if(GetHasSpellEffect(nSpell_ID, oTarget))\r\n    {\r\n        //Search through the valid effects on the target.\r\n        eAOE = GetFirstEffect(oTarget);\r\n        while (GetIsEffectValid(eAOE) && bValid == FALSE)\r\n        {\r\n            if (GetEffectCreator(eAOE) == oCaster)\r\n            {\r\n                //If the effect was created by the spell then remove it\r\n                if(GetEffectSpellId(eAOE) == nSpell_ID)\r\n                {\r\n                    RemoveEffect(oTarget, eAOE);\r\n                    bValid = TRUE;\r\n                }\r\n            }\r\n            //Get next effect on the target\r\n            eAOE = GetNextEffect(oTarget);\r\n        }\r\n    }\r\n}\r\n\r\nvoid Sp_RemoveSpecificEffect(int nEffectTypeID, object oTarget)\r\n{\r\n    //Declare major variables\r\n    //Get the object that is exiting the AOE\r\n    int bValid = FALSE;\r\n    effect eAOE;\r\n    //Search through the valid effects on the target.\r\n    eAOE = GetFirstEffect(oTarget);\r\n    while (GetIsEffectValid(eAOE))\r\n    {\r\n        if (GetEffectType(eAOE) == nEffectTypeID)\r\n        {\r\n            //If the effect was created by the spell then remove it\r\n            bValid = TRUE;\r\n            RemoveEffect(oTarget, eAOE);\r\n        }\r\n        //Get next effect on the target\r\n        eAOE = GetNextEffect(oTarget);\r\n    }\r\n}\r\n\r\nfloat Sp_GetSpellEffectDelay(location SpellTargetLocation, object oTarget)\r\n{\r\n    float fDelay;\r\n    return fDelay = GetDistanceBetweenLocations(SpellTargetLocation, GetLocation(oTarget))/20;\r\n}\r\n\r\nfloat Sp_GetRandomDelay(float fMinimumTime = 0.4, float MaximumTime = 1.1)\r\n{\r\n    float fRandom = MaximumTime - fMinimumTime;\r\n    int nRandom;\r\n    if(fRandom < 0.0)\r\n    {\r\n        return 0.0;\r\n    }\r\n    else\r\n    {\r\n        nRandom = FloatToInt(fRandom  * 10.0);\r\n        nRandom = Random(nRandom) + 1;\r\n        fRandom = IntToFloat(nRandom);\r\n        fRandom /= 10.0;\r\n        return fRandom + fMinimumTime;\r\n    }\r\n}\r\n\r\nint Sp_GetJediDCSave()\r\n{\r\n    int nDC = GetSpellSaveDC();\r\n    return nDC;\r\n}\r\n\r\nvoid Sp_ApplyForcePowerEffects(float fTime, effect eEffect, object oTarget)\r\n{\r\n    float fDelay;\r\n    int nRoll = d6();\r\n    fDelay = IntToFloat(nRoll)/10.0;\r\n    if(fTime == 1000.0)\r\n    {\r\n        ApplyEffectToObject(DURATION_TYPE_PERMANENT, eEffect, oTarget);\r\n    }\r\n    else if(fTime == 0.0)\r\n    {\r\n        DelayCommand(fDelay, ApplyEffectToObject(DURATION_TYPE_INSTANT, eEffect, oTarget));\r\n    }\r\n    else\r\n    {\r\n        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eEffect, oTarget, fTime);\r\n    }\r\n}\r\n\r\nint SP_CheckEnergyResistance(object oTarget)\r\n{\r\n    // DJS-OEI 12/9/2003\r\n    // Added Master Energy Resistance to the check.\r\n    if( GetHasSpellEffect(FORCE_POWER_RESIST_COLD_HEAT_ENERGY, oTarget) ||\r\n        GetHasSpellEffect(FORCE_POWER_RESIST_POISON_DISEASE_SONIC, oTarget) ||\r\n        GetHasSpellEffect(FORCE_POWER_MASTER_ENERGY_RESISTANCE, oTarget) )\r\n    {\r\n        return TRUE;\r\n    }\r\n    return FALSE;\r\n}\r\n//::///////////////////////////////////////////////\r\n//:: Runs the specified force power.\r\n//:: Copyright (c) 2001 Bioware Corp.\r\n//:://////////////////////////////////////////////\r\n/*\r\n    Runs the script for the particular force power.\r\n\r\n    SWFP_HARMFUL = ;\r\n    SWFP_PRIVATE_SAVE_TYPE;\r\n    SWFP_PRIVATE_SAVE_VERSUS_TYPE;\r\n    SWFP_DAMAGE;\r\n    SWFP_DAMAGE_TYPE;\r\n    SWFP_DAMAGE_VFX;\r\n\r\n*/\r\n//:://////////////////////////////////////////////\r\n//:: Created By: Preston Watamaniuk\r\n//:: Created On: July 30, 2002\r\n//:://////////////////////////////////////////////\r\n\r\nvoid  Sp_RunForcePowers()\r\n{\r\n    object oTarget = GetSpellTargetObject();\r\n    effect eLink1, eLink2;\r\n    effect eInvalid;\r\n    SWFP_SHAPE = SHAPE_SPHERE;\r\n\r\n    //P.W. (June 8) This makes the Taris Calo Nord immune to Force Push, breaks the cutscene if not.\r\n    if(GetTag(oTarget) == "Calo082" && GetSpellId() == FORCE_POWER_FORCE_PUSH)\r\n    {\r\n        DisplayFeedBackText(oTarget, 1);\r\n        return;\r\n    }\r\n\r\n    // DJS-OEI 10/18/2004\r\n    // I\'m going to jump on the hack bandwagon and make sure General Vaklu can\'t\r\n    // be affected by Confusion.\r\n    if(GetTag(oTarget) == "vaklu" && GetSpellId() == FORCE_POWER_CONFUSION)\r\n    {\r\n        DisplayFeedBackText(oTarget, 1);\r\n        return;\r\n    }\r\n    // DJS-OEI 10/22/2004\r\n    // Also made Bralor immune.\r\n    else if(GetTag(oTarget) == "npc_bralor" && GetSpellId() == FORCE_POWER_CONFUSION)\r\n    {\r\n        DisplayFeedBackText(oTarget, 1);\r\n        return;\r\n    }\r\n\r\n    switch (GetSpellId())\r\n    {\r\n        /*\r\n        AFFLICTION\r\n        */\r\n        case FORCE_POWER_AFFLICTION:\r\n        {\r\n            // If the target is already poisoned in any way, don\'t\r\n            // apply this effect.\r\n            if(!GetIsPoisoned(oTarget))\r\n            {\r\n                // DJS-OEI 12/9/2003\r\n                // For KotOR2, we have decided to modify the application behavior\r\n                // of Force Power trees. Lower level versions of Force Powers will\r\n                // no longer overwrite higher level versions, although this means\r\n                // the caster still loses their Force Points to no effect. Also,\r\n                // casting a Force Power will remove any Force Powers of equal or\r\n                // lesser level prior to applying themselves.\r\n\r\n                // Remove any lower level or equal versions of this power.\r\n                Sp_RemoveRelatedPowers( oTarget, FORCE_POWER_AFFLICTION );\r\n\r\n                // Do not apply the effects of this power if a more powerful\r\n                // version is already attached to the target.\r\n                if( !Sp_BetterRelatedPowerExists( oTarget, FORCE_POWER_AFFLICTION ) ) {\r\n\r\n                    SWFP_HARMFUL = TRUE;\r\n\r\n                    eLink1 = EffectPoison(POISON_ABILITY_SCORE_AVERAGE);\r\n                    eLink1 = EffectLinkEffects(eLink1, EffectMovementSpeedDecrease(50));\r\n                    //eLink1 = SetEffectIcon(eLink1, 23);\r\n                    eLink1 = SetEffectIcon(eLink1, 1);//RWT-OEI 07/08/04 - Affliction is a specific effect\r\n\r\n                    //Sp_ApplyEffects(FALSE, oTarget, 0.0, 1, eLink1, 1000.0, eInvalid, 0.0);\r\n                    //RWT-OEI 09/27/04 - Apparently this is supposed to last 21 seconds.\r\n                    Sp_ApplyEffects(FALSE, oTarget, 0.0, 1, eLink1, 21.0, eInvalid, 0.0);\r\n                }\r\n            }\r\n            // DJS-OEI 10/22/2004\r\n            else {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceResisted(OBJECT_SELF), oTarget);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        CHOKE\r\n        */\r\n        case FORCE_POWER_CHOKE:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n\r\n            // DJS-OEI 3/25/2004\r\n            SWFP_DAMAGE = Sp_CalcDamage( oTarget, 0, 0, (GetHitDice(OBJECT_SELF)*2)/3 );\r\n            //SWFP_DAMAGE = (GetHitDice(OBJECT_SELF)*2)/3;\r\n\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;\r\n            SWFP_DAMAGE_VFX = VFX_IMP_CHOKE;\r\n\r\n            eLink1 = EffectAbilityDecrease(ABILITY_CONSTITUTION, 4);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityDecrease(ABILITY_STRENGTH, 4));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityDecrease(ABILITY_DEXTERITY, 4));\r\n            eLink1 = SetEffectIcon(eLink1, 3);\r\n\r\n            effect eChoke = EffectChoke();\r\n            effect eDamage = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n\r\n            int nResist = Sp_BlockingChecks(oTarget, eChoke, eDamage, eInvalid);\r\n            int nSaves;\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            if(nResist == 0)\r\n            {\r\n                nSaves = Sp_MySavingThrows(oTarget);\r\n                if(nSaves == 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_CHOKE), oTarget);\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eChoke, oTarget, 6.0);\r\n\r\n                    float fDuration = Sp_CalcDuration( 24.0 );\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, fDuration);\r\n                    int nIdx = 1;\r\n                    float fDelay;\r\n                    SP_InterativeDamage(eDamage, 7, oTarget);\r\n                }\r\n            }\r\n            if(nResist > 0 || nSaves > 0)\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        HEAL\r\n        */\r\n        //MODIFIED by Preston Watamaniuk March 28\r\n        // Remove cure poison and reduced the amount by 5\r\n        case FORCE_POWER_CURE:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n\r\n            // DJS-OEI 3/29/2004\r\n            // The Regeneration Consular Forms increase the relevance of\r\n            // the Wisdom and Charisma modifiers.\r\n            int nMultiplier = 1;\r\n            // DJS-OEI 7/20/2004\r\n            // Form/Stance re-design.\r\n            /*\r\n            if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_REGENERATION_I ) ) {\r\n                nMultiplier = 2;\r\n            }\r\n            else if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_REGENERATION_II ) ||\r\n                     IsFormActive( OBJECT_SELF, FORM_CONSULAR_REGENERATION_III ) ) {\r\n                nMultiplier = 3;\r\n            }\r\n            */\r\n\r\n            int nHeal = ( ( GetAbilityModifier(ABILITY_WISDOM) + GetAbilityModifier(ABILITY_CHARISMA) ) * nMultiplier ) + 5 + GetHitDice(OBJECT_SELF);\r\n\r\n            effect eVis =  EffectVisualEffect(VFX_IMP_CURE);\r\n            int nCnt = 0;\r\n\r\n            object oParty;\r\n            if(IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                oParty = GetPartyMemberByIndex(nCnt);\r\n            }\r\n            else\r\n            {\r\n                oParty = OBJECT_SELF;\r\n            }\r\n\r\n            while(nCnt < 3)\r\n            {\r\n                if(GetIsObjectValid(oParty) &&\r\n                   GetRacialType(oParty) != RACIAL_TYPE_DROID &&\r\n                   GetDistanceBetween(OBJECT_SELF, oParty) < 15.0)\r\n                {\r\n                    SignalEvent(oParty, EventSpellCastAt(OBJECT_SELF, GetSpellId(), FALSE));\r\n                    //Sp_RemoveSpecificEffect(EFFECT_TYPE_POISON, oParty);\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eVis, oParty);\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectHeal(nHeal), oParty);\r\n                }\r\n                nCnt++;\r\n                if(IsObjectPartyMember(OBJECT_SELF))\r\n                {\r\n                   oParty = GetPartyMemberByIndex(nCnt);\r\n                }\r\n                else\r\n                {\r\n                   oParty = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, OBJECT_SELF, nCnt);\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        DEATH FIELD\r\n        */\r\n        case FORCE_POWER_DEATH_FIELD:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_DARK_SIDE;\r\n            int nDamTest = GetHitDice(OBJECT_SELF);\r\n            if(nDamTest > 10)\r\n            {\r\n                nDamTest = 10;\r\n            }\r\n\r\n            // DJS-OEI 3/25/2004\r\n            SWFP_DAMAGE = Sp_CalcDamage( oTarget, nDamTest, 4 );\r\n            //SWFP_DAMAGE = d4(nDamTest);\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_DARK_SIDE;\r\n            SWFP_DAMAGE_VFX = VFX_PRO_DEATH_FIELD;\r\n\r\n            int nHealCount;\r\n            int nDamage = SWFP_DAMAGE/2;\r\n            effect eDamage;\r\n            effect eBeam = EffectBeam(VFX_BEAM_DEATH_FIELD_TENTACLE, OBJECT_SELF, BODY_NODE_HEAD);\r\n            effect eVFX = EffectVisualEffect(VFX_PRO_DEATH_FIELD);\r\n\r\n            //object oTarget = GetFirstObjectInShape(SHAPE_SPHERE, 12.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            object oTarget = GetFirstObjectInShape(SHAPE_SPHERE, 12.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            while(GetIsObjectValid(oTarget))\r\n            {\r\n                int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eDamage);\r\n                if((GetRacialType(oTarget) == RACIAL_TYPE_HUMAN &&\r\n                   GetRacialType(oTarget) != RACIAL_TYPE_DROID) || GetObjectType(oTarget) == OBJECT_TYPE_PLACEABLE)\r\n                {\r\n                    if(GetIsEnemy(oTarget))\r\n                    {\r\n                        SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                        if(nResist == 0)\r\n                        {\r\n                            int nSaves = Sp_MySavingThrows(oTarget);\r\n                            if(nSaves == FALSE)\r\n                            {\r\n                                eDamage =  EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                                nHealCount += SWFP_DAMAGE;\r\n                            }\r\n                            else\r\n                            {\r\n                                eDamage =  EffectDamage(nDamage, SWFP_DAMAGE_TYPE);\r\n                                nHealCount += nDamage;\r\n                            }\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eVFX, oTarget);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBeam, oTarget, fLightningDuration);\r\n                        }\r\n                        else\r\n                        {\r\n                            //effect eBeam2 = EffectBeam(VFX_BEAM_DEATH_FIELD_TENTACLE, OBJECT_SELF, BODY_NODE_HEAD, TRUE);\r\n                            //ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBeam, oTarget, fLightningDuration);\r\n                        }\r\n                    }\r\n                }\r\n                //oTarget = GetNextObjectInShape(SHAPE_SPHERE, 12.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n                oTarget = GetNextObjectInShape(SHAPE_SPHERE, 12.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            }\r\n            if(GetCurrentHitPoints(OBJECT_SELF) < GetMaxHitPoints(OBJECT_SELF) && nHealCount > 0)\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectHeal(nHealCount), OBJECT_SELF);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        DRAIN LIFE\r\n        */\r\n        case FORCE_POWER_DRAIN_LIFE:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n            int nDam = GetHitDice(OBJECT_SELF);\r\n            int nDamTest = GetHitDice(OBJECT_SELF);\r\n            if(nDamTest > 10)\r\n            {\r\n                nDamTest = 10;\r\n            }\r\n\r\n            // DJS-OEI 3/25/2004\r\n            SWFP_DAMAGE = Sp_CalcDamage( oTarget, nDamTest, 4 );\r\n            //SWFP_DAMAGE = d4(nDamTest);\r\n            SWFP_DAMAGE_TYPE= DAMAGE_TYPE_DARK_SIDE;\r\n            SWFP_DAMAGE_VFX = VFX_PRO_DRAIN;\r\n            //Set up the drain effect link for the target\r\n            effect eBeam = EffectBeam(VFX_BEAM_DRAIN_LIFE, OBJECT_SELF, BODY_NODE_HAND);\r\n            effect eVFX = EffectVisualEffect(SWFP_DAMAGE_VFX);\r\n            //Set up the link to Heal the user by the same amount.\r\n            effect eHeal;\r\n            effect eDamage = EffectDamage(SWFP_DAMAGE, DAMAGE_TYPE_DARK_SIDE);\r\n\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBeam, oTarget, fLightningDuration);\r\n            DelayCommand(0.3, ApplyEffectToObject(DURATION_TYPE_INSTANT, eVFX, oTarget));\r\n\r\n            int nResist = Sp_BlockingChecks(oTarget, eDamage, eInvalid, eInvalid);\r\n\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            if(GetRacialType(oTarget) != RACIAL_TYPE_DROID)\r\n            {\r\n                if(nResist == 0)\r\n                {\r\n                    int nSaves = Sp_MySavingThrows(oTarget);\r\n                    if(nSaves > 0)\r\n                    {\r\n                        SWFP_DAMAGE /= 2;\r\n                    }\r\n                    eDamage = EffectDamage(SWFP_DAMAGE,  DAMAGE_TYPE_DARK_SIDE);\r\n                    if(GetCurrentHitPoints(OBJECT_SELF) < GetMaxHitPoints(OBJECT_SELF) && SWFP_DAMAGE > 0)\r\n                    {\r\n                        eHeal = EffectHeal(SWFP_DAMAGE);\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eHeal, OBJECT_SELF);\r\n                    }\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        DESTROY DROID\r\n        */\r\n        case FORCE_POWER_DROID_DESTROY:\r\n        {\r\n            int bIsMine = FALSE;\r\n            //RWT-OEI 08/31/04 - Need to special case the mine stuff\r\n            //everywhere below.\r\n            //We don\'t have to confirm that the targetted trap is the\r\n            //right level of trap to get blown up because it wouldn\'t\r\n            //have been targettable otherwise. But all the traps in the loop\r\n            //for the AoE portion will have to be tested.\r\n            if ( GetObjectType(oTarget) == OBJECT_TYPE_TRIGGER )\r\n            {\r\n                //Check for MINOR and AVERAGE and STRONG trap types now\r\n                int nMineType = GetTrapBaseType(oTarget);\r\n                if ( !GetIsTrapped(oTarget) )\r\n                {\r\n                    nMineType = -1;\r\n                }\r\n                if ( nMineType == TRAP_BASE_TYPE_FLASH_STUN_MINOR            ||\r\n                     nMineType == TRAP_BASE_TYPE_FLASH_STUN_AVERAGE          ||\r\n                     nMineType == TRAP_BASE_TYPE_FLASH_STUN_STRONG           ||\r\n                     nMineType == TRAP_BASE_TYPE_FRAGMENTATION_MINE_MINOR     ||\r\n                     nMineType == TRAP_BASE_TYPE_FRAGMENTATION_MINE_AVERAGE  ||\r\n                     nMineType == TRAP_BASE_TYPE_FRAGMENTATION_MINE_STRONG   ||\r\n                     nMineType == TRAP_BASE_TYPE_LASER_SLICING_MINOR         ||\r\n                     nMineType == TRAP_BASE_TYPE_LASER_SLICING_AVERAGE       ||\r\n                     nMineType == TRAP_BASE_TYPE_LASER_SLICING_STRONG        ||\r\n                     nMineType == TRAP_BASE_TYPE_POISON_GAS_MINOR            ||\r\n                     nMineType == TRAP_BASE_TYPE_POISON_GAS_AVERAGE          ||\r\n                     nMineType == TRAP_BASE_TYPE_POISON_GAS_STRONG           ||\r\n                     nMineType == TRAP_BASE_TYPE_SONIC_CHARGE_MINOR          ||\r\n                     nMineType == TRAP_BASE_TYPE_SONIC_CHARGE_AVERAGE        ||\r\n                     nMineType == TRAP_BASE_TYPE_SONIC_CHARGE_STRONG\r\n                     )\r\n                 {\r\n                     bIsMine = TRUE;\r\n                 }\r\n                 else\r\n                 {\r\n                    break;//Somehow a non-mine trigger got targetted. Just bail\r\n                 }\r\n            }\r\n\r\n            SWFP_HARMFUL = TRUE;\r\n            //SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_REFLEX;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;//RWT-OEI 09/27/04\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_ELECTRICAL;\r\n\r\n            float fRange = Sp_CalcRange( 6.0 );\r\n\r\n            eLink1 = EffectBeam(VFX_BEAM_DROID_DESTROY, oTarget, BODY_NODE_CHEST);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_PRO_LIGHTNING_L));\r\n\r\n            eLink2 = EffectDroidStun();\r\n            eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(1008));\r\n            eLink2 = SetEffectIcon(eLink2, 5);\r\n\r\n            effect eLink3 = EffectBeam(VFX_BEAM_DROID_DESTROY, OBJECT_SELF, BODY_NODE_HAND);\r\n            eLink3 = EffectLinkEffects(eLink3, EffectVisualEffect(VFX_PRO_LIGHTNING_L));\r\n\r\n            // DJS-OEI 3/25/2004\r\n            int nDamage = Sp_CalcDamage( oTarget, GetHitDice(OBJECT_SELF), 6 );\r\n            //int nDamage = d6(GetHitDice(OBJECT_SELF));\r\n            int nApply;\r\n\r\n            // DJS-OEI 11/20/2003\r\n            // If the target has the Evasion feat, the damage on a successful\r\n            // Reflex save is 0. Otherwise, it\'s half the original damage.\r\n            if( GetHasFeat( FEAT_EVASION, oTarget ) ) {\r\n                nApply = 0;\r\n            }\r\n            else {\r\n                nApply = nDamage/2;\r\n            }\r\n\r\n            effect eDamage = EffectDamage(nDamage, DAMAGE_TYPE_ELECTRICAL);;\r\n            effect eSaveDamage = EffectDamage(nApply, DAMAGE_TYPE_ELECTRICAL);\r\n\r\n\r\n            //Apply Effects to the first droid targeted.\r\n            int nResist = 0;\r\n            if ( !bIsMine )\r\n            {\r\n                nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n            }\r\n            int nSaves = 0;\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink3, oTarget, fLightningDuration);\r\n            if(nResist == 0)\r\n            {\r\n                if (!bIsMine)\r\n                {\r\n                    nSaves = Sp_MySavingThrows(oTarget);\r\n                }\r\n                if(nSaves == 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage , oTarget);\r\n                    float fDuration = Sp_CalcDuration( 12.0 );\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, fDuration);\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eSaveDamage , oTarget);\r\n                }\r\n            }\r\n            else\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n\r\n            //RWT-OEI 08/31/04 - Cache location here since this object goes baibai\r\n            location lTarget = GetLocation(oTarget);\r\n            if ( bIsMine )\r\n            {\r\n                AssignCommand(oTarget,ExecuteScript( "k_trp_generic",oTarget));\r\n                DetonateMine(oTarget);\r\n            }\r\n\r\n            //Start going through all hostile droids around the primary target\r\n            //object oSecond = GetFirstObjectInShape(SHAPE_SPHERE, fRange, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            object oSecond = GetFirstObjectInShape(SHAPE_SPHERE, fRange, lTarget, FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_TRIGGER);\r\n            while(GetIsObjectValid(oSecond))\r\n            {\r\n                int bIsMine2 = FALSE;\r\n                if (GetObjectType(oSecond) == OBJECT_TYPE_TRIGGER)\r\n                {\r\n                    //Check for MINOR, AVERAGE, and STRONG mine types here\r\n                    int nMineType2 = GetTrapBaseType(oSecond);\r\n                    if ( !GetIsTrapped(oSecond) )\r\n                    {\r\n                        nMineType2 = -1;\r\n                    }\r\n                    if (nMineType2 == TRAP_BASE_TYPE_FLASH_STUN_MINOR            ||\r\n                        nMineType2 == TRAP_BASE_TYPE_FLASH_STUN_AVERAGE          ||\r\n                        nMineType2 == TRAP_BASE_TYPE_FLASH_STUN_STRONG           ||\r\n                        nMineType2 == TRAP_BASE_TYPE_FRAGMENTATION_MINE_MINOR     ||\r\n                        nMineType2 == TRAP_BASE_TYPE_FRAGMENTATION_MINE_AVERAGE  ||\r\n                        nMineType2 == TRAP_BASE_TYPE_FRAGMENTATION_MINE_STRONG   ||\r\n                        nMineType2 == TRAP_BASE_TYPE_LASER_SLICING_MINOR         ||\r\n                        nMineType2 == TRAP_BASE_TYPE_LASER_SLICING_AVERAGE       ||\r\n                        nMineType2 == TRAP_BASE_TYPE_LASER_SLICING_STRONG        ||\r\n                        nMineType2 == TRAP_BASE_TYPE_POISON_GAS_MINOR            ||\r\n                        nMineType2 == TRAP_BASE_TYPE_POISON_GAS_AVERAGE          ||\r\n                        nMineType2 == TRAP_BASE_TYPE_POISON_GAS_STRONG           ||\r\n                        nMineType2 == TRAP_BASE_TYPE_SONIC_CHARGE_MINOR          ||\r\n                        nMineType2 == TRAP_BASE_TYPE_SONIC_CHARGE_AVERAGE        ||\r\n                        nMineType2 == TRAP_BASE_TYPE_SONIC_CHARGE_STRONG\r\n                        )\r\n                    {\r\n                        bIsMine2 = TRUE;\r\n                    }\r\n                    else\r\n                    {\r\n                        continue;//This is a non-mine trigger. Just skip it.\r\n                    }\r\n                }\r\n                if(oSecond != oTarget && GetIsEnemy(oSecond) && (GetRacialType(oSecond) == RACIAL_TYPE_DROID || bIsMine2))\r\n                {\r\n                    if ( !bIsMine2 )\r\n                    {\r\n                        nResist = Sp_BlockingChecks(oSecond, eLink1, eLink2, eInvalid);\r\n                    }\r\n                    else\r\n                    {\r\n                        nResist = 0;\r\n                    }\r\n\r\n                    SignalEvent(oSecond, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    if(nResist == 0)\r\n                    {\r\n                        if ( !bIsMine2 )\r\n                        {\r\n                            nSaves = Sp_MySavingThrows(oSecond);\r\n                        }\r\n                        else\r\n                        {\r\n                            nSaves = 0;\r\n                        }\r\n                        //Apply the beam effect and hit regardless because damage is still done.\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oSecond, fLightningDuration);\r\n                        if(nSaves == 0)\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage , oSecond);\r\n                            float fDuration = Sp_CalcDuration( 12.0 );\r\n                            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oSecond, fDuration);\r\n                        }\r\n                        else\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eSaveDamage , oSecond);\r\n                        }\r\n                        if ( bIsMine2 )\r\n                        {\r\n                            AssignCommand(oSecond,ExecuteScript( "k_trp_generic",oSecond));\r\n                            DetonateMine(oSecond);\r\n                        }\r\n                    }\r\n                }\r\n                //oSecond = GetNextObjectInShape(SHAPE_SPHERE, fRange, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n                oSecond = GetNextObjectInShape(SHAPE_SPHERE, fRange, lTarget, FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_TRIGGER);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        DISABLE DROID\r\n        */\r\n        case FORCE_POWER_DROID_DISABLE:\r\n        {\r\n            int bIsMine = FALSE;\r\n            //RWT-OEI 08/31/04 - Need to special case the mine stuff\r\n            //everywhere below.\r\n            //We don\'t have to confirm that the targetted trap is the\r\n            //right level of trap to get blown up because it wouldn\'t\r\n            //have been targettable otherwise. But all the traps in the loop\r\n            //for the AoE portion will have to be tested.\r\n            if ( GetObjectType(oTarget) == OBJECT_TYPE_TRIGGER )\r\n            {\r\n                //Check for MINOR and AVERAGE trap types now\r\n                int nMineType = GetTrapBaseType(oTarget);\r\n                if ( !GetIsTrapped(oTarget) )\r\n                {\r\n                    nMineType = -1;\r\n                }\r\n                if ( nMineType == TRAP_BASE_TYPE_FLASH_STUN_MINOR            ||\r\n                     nMineType == TRAP_BASE_TYPE_FLASH_STUN_AVERAGE          ||\r\n                     nMineType == TRAP_BASE_TYPE_FRAGMENTATION_MINE_MINOR     ||\r\n                     nMineType == TRAP_BASE_TYPE_FRAGMENTATION_MINE_AVERAGE  ||\r\n                     nMineType == TRAP_BASE_TYPE_LASER_SLICING_MINOR         ||\r\n                     nMineType == TRAP_BASE_TYPE_LASER_SLICING_AVERAGE       ||\r\n                     nMineType == TRAP_BASE_TYPE_POISON_GAS_MINOR            ||\r\n                     nMineType == TRAP_BASE_TYPE_POISON_GAS_AVERAGE          ||\r\n                     nMineType == TRAP_BASE_TYPE_SONIC_CHARGE_MINOR          ||\r\n                     nMineType == TRAP_BASE_TYPE_SONIC_CHARGE_AVERAGE )\r\n                 {\r\n                     bIsMine = TRUE;\r\n                 }\r\n                 else\r\n                 {\r\n                    break;//Somehow a non-mine trigger got targetted. Bail\r\n                 }\r\n            }\r\n            SWFP_HARMFUL = TRUE;\r\n            //SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_REFLEX;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;//RWT-OEI 09/27/04\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_ELECTRICAL;\r\n\r\n            float fRange = Sp_CalcRange( 5.0 );\r\n\r\n            eLink1 = EffectBeam(VFX_BEAM_DROID_DESTROY, oTarget, BODY_NODE_CHEST);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_PRO_LIGHTNING_L));\r\n\r\n            eLink2 = EffectDroidStun();\r\n            eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(1008));\r\n            eLink2 = SetEffectIcon(eLink2, 4);\r\n\r\n            effect eLink3 = EffectBeam(VFX_BEAM_DROID_DISABLE, OBJECT_SELF, BODY_NODE_HAND);\r\n            eLink3 = EffectLinkEffects(eLink3, EffectVisualEffect(VFX_PRO_LIGHTNING_L));\r\n\r\n            // DJS-OEI 3/25/2004\r\n            int nDamage = Sp_CalcDamage( oTarget, 0, 0, GetHitDice(OBJECT_SELF) );\r\n            //int nDamage = GetHitDice(OBJECT_SELF);\r\n            int nApply;\r\n\r\n            // DJS-OEI 11/20/2003\r\n            // If the target has the Evasion feat, the damage on a successful\r\n            // Reflex save is 0. Otherwise, it\'s half the original damage.\r\n            if( GetHasFeat( FEAT_EVASION, oTarget ) ) {\r\n                nApply = 0;\r\n            }\r\n            else {\r\n                nApply = nDamage/2;\r\n            }\r\n\r\n            effect eDamage = EffectDamage(nDamage, DAMAGE_TYPE_ELECTRICAL);;\r\n            effect eSaveDamage = EffectDamage(nApply, DAMAGE_TYPE_ELECTRICAL);\r\n\r\n\r\n            //Apply Effects to the first droid targeted.\r\n            int nResist = 0;\r\n            if ( !bIsMine )\r\n            {\r\n                nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n            }\r\n            int nSaves = 0;\r\n\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink3, oTarget, fLightningDuration);\r\n            if(nResist == 0)\r\n            {\r\n                if ( !bIsMine )\r\n                {\r\n                    nSaves = Sp_MySavingThrows(oTarget);\r\n                }\r\n                if(nSaves == 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage , oTarget);\r\n                    float fDuration = Sp_CalcDuration( 12.0 );\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, fDuration);\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eSaveDamage , oTarget);\r\n                }\r\n            }\r\n            else\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n\r\n            location lTarget = GetLocation(oTarget);\r\n            if ( bIsMine )\r\n            {\r\n                AssignCommand(oTarget,ExecuteScript( "k_trp_generic",oTarget));\r\n                DetonateMine(oTarget);\r\n            }\r\n\r\n            //Start going through all hostile droids around the primary target\r\n            //object oSecond = GetFirstObjectInShape(SHAPE_SPHERE, fRange, lTarget, FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            object oSecond = GetFirstObjectInShape(SHAPE_SPHERE, fRange, lTarget, FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_TRIGGER);\r\n            while(GetIsObjectValid(oSecond))\r\n            {\r\n                int bIsMine2 = FALSE;\r\n                if (GetObjectType(oSecond) == OBJECT_TYPE_TRIGGER)\r\n                {\r\n                    int nMineType2 = GetTrapBaseType(oSecond);\r\n                    if ( !GetIsTrapped(oSecond))\r\n                    {\r\n                        nMineType2 = -1;\r\n                    }\r\n                    if (nMineType2 == TRAP_BASE_TYPE_FLASH_STUN_MINOR            ||\r\n                        nMineType2 == TRAP_BASE_TYPE_FLASH_STUN_AVERAGE          ||\r\n                        nMineType2 == TRAP_BASE_TYPE_FRAGMENTATION_MINE_MINOR     ||\r\n                        nMineType2 == TRAP_BASE_TYPE_FRAGMENTATION_MINE_AVERAGE  ||\r\n                        nMineType2 == TRAP_BASE_TYPE_LASER_SLICING_MINOR         ||\r\n                        nMineType2 == TRAP_BASE_TYPE_LASER_SLICING_AVERAGE       ||\r\n                        nMineType2 == TRAP_BASE_TYPE_POISON_GAS_MINOR            ||\r\n                        nMineType2 == TRAP_BASE_TYPE_POISON_GAS_AVERAGE          ||\r\n                        nMineType2 == TRAP_BASE_TYPE_SONIC_CHARGE_MINOR          ||\r\n                        nMineType2 == TRAP_BASE_TYPE_SONIC_CHARGE_AVERAGE )\r\n                    {\r\n                        bIsMine2 = TRUE;\r\n                    }\r\n                    else\r\n                    {\r\n                        continue;//This is a non-mine trigger. Just skip it.\r\n                    }\r\n                }\r\n                if(oSecond != oTarget && GetIsEnemy(oSecond) && (GetRacialType(oSecond) == RACIAL_TYPE_DROID || bIsMine2 ))\r\n                {\r\n                    int bIsMine2 = (GetObjectType(oSecond) == OBJECT_TYPE_TRIGGER);\r\n                    if (!bIsMine2)\r\n                    {\r\n                        nResist = Sp_BlockingChecks(oSecond, eLink1, eLink2, eInvalid);\r\n                    }\r\n\r\n                    SignalEvent(oSecond, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    if(nResist == 0)\r\n                    {\r\n                        if ( !bIsMine2 )\r\n                        {\r\n                            AurPostString( "Mines found in radius.", 20, 21, 5.0f );\r\n                            nSaves = Sp_MySavingThrows(oSecond);\r\n                        }\r\n                        //Apply the beam effect and hit regardless because damage is still done.\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oSecond, fLightningDuration);\r\n                        if(nSaves == 0)\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage , oSecond);\r\n                            float fDuration = Sp_CalcDuration( 12.0 );\r\n                            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oSecond, fDuration);\r\n                        }\r\n                        else\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eSaveDamage , oSecond);\r\n                        }\r\n                        if ( bIsMine2 )\r\n                        {\r\n                            AssignCommand(oSecond,ExecuteScript( "k_trp_generic",oSecond));\r\n                            DetonateMine(oSecond);\r\n                        }\r\n                    }\r\n                }\r\n                //oSecond = GetNextObjectInShape(SHAPE_SPHERE, fRange, lTarget, FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n                oSecond = GetNextObjectInShape(SHAPE_SPHERE, fRange, lTarget, FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_TRIGGER);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        STUN DROID\r\n        */\r\n        case FORCE_POWER_DROID_STUN:\r\n        {\r\n            //RWT-OEI 08/31/04\r\n            //if the oTarget is a trigger, it\'s a mine, so handle way differently\r\n            int bIsMine = 0;\r\n            if ( GetObjectType(oTarget) == OBJECT_TYPE_TRIGGER )\r\n            {\r\n                int nMineType = GetTrapBaseType(oTarget);\r\n                if ( !GetIsTrapped(oTarget) )\r\n                {\r\n                    nMineType = -1;\r\n                }\r\n                if ( nMineType == TRAP_BASE_TYPE_FLASH_STUN_MINOR             ||\r\n                     nMineType == TRAP_BASE_TYPE_FRAGMENTATION_MINE_MINOR     ||\r\n                     nMineType == TRAP_BASE_TYPE_LASER_SLICING_MINOR          ||\r\n                     nMineType == TRAP_BASE_TYPE_POISON_GAS_MINOR            ||\r\n                     nMineType == TRAP_BASE_TYPE_SONIC_CHARGE_MINOR )\r\n                {\r\n                    bIsMine = TRUE;\r\n                }\r\n                else\r\n                {\r\n                    break;//Somehow a none-mine trigger got targetted. Just skip\r\n                }\r\n            }\r\n            //if ( GetObjectType(oTarget) == OBJECT_TYPE_TRIGGER )\r\n            if ( bIsMine )\r\n            {\r\n                AurPostString( "Stun Droid on a mine.", 20,20,5.0f);\r\n                eLink1 = EffectBeam(2065, OBJECT_SELF, BODY_NODE_HAND);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_PRO_LIGHTNING_S));\r\n                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, fLightningDuration);\r\n                AssignCommand(oTarget, ExecuteScript("k_trp_generic", oTarget));\r\n                DetonateMine(oTarget);\r\n            }\r\n            else\r\n            {//Otherwise target is a droid, so handle the existing way.\r\n                SWFP_HARMFUL = TRUE;\r\n                SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n                SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_ELECTRICAL;\r\n\r\n                // DJS-OEI 3/25/2004\r\n                SWFP_DAMAGE = Sp_CalcDamage( oTarget, 0, 0, GetHitDice(OBJECT_SELF) );\r\n                //SWFP_DAMAGE = GetHitDice(OBJECT_SELF);\r\n\r\n                SWFP_DAMAGE_TYPE= DAMAGE_TYPE_ELECTRICAL;\r\n\r\n                eLink1 = EffectBeam(2065, OBJECT_SELF, BODY_NODE_HAND); //P.W.(May 19, 2003) New Droid Stun Beam Effect added\r\n                eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_PRO_LIGHTNING_S));\r\n                eLink2 = EffectDroidStun();\r\n                eLink2 = SetEffectIcon(eLink2, 30);\r\n                eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(1007));  //P.W.(May 19, 2003) Linked the smoke to Link 2\r\n                effect eDamage;\r\n\r\n                int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n                SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, fLightningDuration);\r\n\r\n                if(nResist == 0)\r\n                {\r\n                    int nSaves = Sp_MySavingThrows(oTarget);\r\n                    if(nSaves == 0)\r\n                    {\r\n                        eDamage = EffectDamage(SWFP_DAMAGE, DAMAGE_TYPE_ELECTRICAL);\r\n                        float fDuration = Sp_CalcDuration( 12.0 );\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, fDuration);\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                    }\r\n                    else\r\n                    {\r\n                        eDamage = EffectDamage(SWFP_DAMAGE/2, DAMAGE_TYPE_ELECTRICAL);\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                    }\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FEAR\r\n        */\r\n        case FORCE_POWER_FEAR:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_FEAR;\r\n\r\n            eLink1 = EffectHorrified();\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(1041));\r\n            eLink1 = SetEffectIcon(eLink1, 6);\r\n\r\n            float fDuration = Sp_CalcDuration( 6.0 );\r\n            Sp_ApplyEffects(TRUE, oTarget, 0.0, 1, eLink1, fDuration, eInvalid, 0.0);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE ARMOR\r\n        */\r\n        case FORCE_POWER_FORCE_ARMOR:\r\n        {\r\n            // DJS-OEI 12/9/2003\r\n            // For KotOR2, we have decided to modify the application behavior\r\n            // of Force Power trees. Lower level versions of Force Powers will\r\n            // no longer overwrite higher level versions, although this means\r\n            // the caster still loses their Force Points to no effect. Also,\r\n            // casting a Force Power will remove any Force Powers of equal or\r\n            // lesser level prior to applying themselves.\r\n\r\n            float fDuration = Sp_CalcDuration( 20.0 );\r\n\r\n            // Remove any lower level or equal versions of this power.\r\n            Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_FORCE_ARMOR );\r\n\r\n            // Do not apply the effects of this power if a more powerful\r\n            // version is already attached to the target.\r\n            if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_FORCE_ARMOR ) ) {\r\n\r\n                SWFP_HARMFUL = FALSE;\r\n                eLink1 = EffectACIncrease(6, AC_DODGE_BONUS);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_ALL, 6));\r\n                eLink1 = SetEffectIcon(eLink1, 7);\r\n                eLink2 = EffectVisualEffect(VFX_PRO_FORCE_ARMOR);\r\n                eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(VFX_PRO_FORCE_SHIELD));\r\n\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, fDuration, eLink2, 3.0);\r\n            }\r\n            //RWT-OEI 12//29/03 - Added support for the ForceChain FEAT\r\n            //  Will add this bonus to anyone else w/Force Chain for free.\r\n            if ( GetHasFeat(FEAT_FORCE_CHAIN, OBJECT_SELF) ) {\r\n                int index = 0;\r\n                for ( ; index < 3; ++index ) {\r\n                    object oCharacter = GetPartyMemberByIndex(index);\r\n                    if ( oCharacter != OBJECT_SELF\r\n                         && GetHasFeat(FEAT_FORCE_CHAIN, oCharacter)\r\n                         && !Sp_BetterRelatedPowerExists( oCharacter, FORCE_POWER_FORCE_ARMOR)) {\r\n                         Sp_RemoveRelatedPowers( oCharacter, FORCE_POWER_FORCE_ARMOR);\r\n                         eLink1 = EffectACIncrease(6, AC_DODGE_BONUS);\r\n                         eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_ALL, 6));\r\n                         eLink1 = SetEffectIcon(eLink1, 7);\r\n                         eLink2 = EffectVisualEffect(VFX_PRO_FORCE_ARMOR);\r\n                         eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(VFX_PRO_FORCE_SHIELD));\r\n\r\n                         Sp_ApplyEffects(FALSE, oCharacter, 0.0, 1, eLink1, fDuration, eLink2, 3.0);\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE AURA\r\n        */\r\n        case FORCE_POWER_FORCE_AURA:\r\n        {\r\n            // DJS-OEI 12/9/2003\r\n            // For KotOR2, we have decided to modify the application behavior\r\n            // of Force Power trees. Lower level versions of Force Powers will\r\n            // no longer overwrite higher level versions, although this means\r\n            // the caster still loses their Force Points to no effect. Also,\r\n            // casting a Force Power will remove any Force Powers of equal or\r\n            // lesser level prior to applying themselves.\r\n\r\n            float fDuration = Sp_CalcDuration( 20.0 );\r\n\r\n            // Remove any lower level or equal versions of this power.\r\n            Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_FORCE_AURA );\r\n\r\n            // Do not apply the effects of this power if a more powerful\r\n            // version is already attached to the target.\r\n            if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_FORCE_AURA ) ) {\r\n\r\n                SWFP_HARMFUL = FALSE;\r\n                eLink1 = EffectACIncrease(2, AC_DODGE_BONUS);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_ALL, 2));\r\n                eLink1 = SetEffectIcon(eLink1, 8);\r\n                eLink2 = EffectVisualEffect(VFX_PRO_FORCE_AURA);\r\n\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, fDuration, eLink2, 3.0);\r\n            }\r\n\r\n            //RWT-OEI 12//29/03 - Added support for the ForceChain FEAT\r\n            //  Will add this bonus to anyone else w/Force Chain for free.\r\n            if ( GetHasFeat(FEAT_FORCE_CHAIN, OBJECT_SELF) ) {\r\n                int index = 0;\r\n                for ( ; index < 3; ++index ) {\r\n                    object oCharacter = GetPartyMemberByIndex(index);\r\n                    if ( oCharacter != OBJECT_SELF\r\n                         && GetHasFeat(FEAT_FORCE_CHAIN, oCharacter)\r\n                         && !Sp_BetterRelatedPowerExists( oCharacter, FORCE_POWER_FORCE_AURA)) {\r\n                         Sp_RemoveRelatedPowers( oCharacter, FORCE_POWER_FORCE_AURA);\r\n                         eLink1 = EffectACIncrease(2, AC_DODGE_BONUS);\r\n                         eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_ALL, 2));\r\n                         eLink1 = SetEffectIcon(eLink1, 8);\r\n                         eLink2 = EffectVisualEffect(VFX_PRO_FORCE_AURA);\r\n\r\n                         Sp_ApplyEffects(FALSE, oCharacter, 0.0, 1, eLink1, fDuration, eLink2, 3.0);\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE BREACH\r\n        */\r\n        case FORCE_POWER_FORCE_BREACH:\r\n        {\r\n            effect eBuff = GetFirstEffect(oTarget);\r\n            int bValid = FALSE;\r\n            while(GetIsEffectValid(eBuff))\r\n            {\r\n                if(GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_AURA ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_SHIELD ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_ARMOR ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_MIND ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_KNIGHT_MIND ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_MIND_MASTERY ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_SPEED_BURST  ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_KNIGHT_SPEED ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_SPEED_MASTERY ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_RESIST_COLD_HEAT_ENERGY ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_RESIST_POISON_DISEASE_SONIC ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_RESIST_FORCE ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_IMMUNITY ||\r\n                   // DJS-OEI 12/9/2003\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_MASTER_ENERGY_RESISTANCE ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_BARRIER ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_IMPROVED_FORCE_BARRIER ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_MASTER_FORCE_BARRIER ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_ENLIGHTENMENT )\r\n                 {\r\n                    RemoveEffect(oTarget, eBuff);\r\n                 }\r\n                 eBuff = GetNextEffect(oTarget);\r\n            }\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId()));\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_FORCE_BREACH), oTarget);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE IMMUNITY\r\n        */\r\n        case FORCE_POWER_FORCE_IMMUNITY:\r\n        {\r\n            // DJS-OEI 12/9/2003\r\n            // For KotOR2, we have decided to modify the application behavior\r\n            // of Force Power trees. Lower level versions of Force Powers will\r\n            // no longer overwrite higher level versions, although this means\r\n            // the caster still loses their Force Points to no effect. Also,\r\n            // casting a Force Power will remove any Force Powers of equal or\r\n            // lesser level prior to applying themselves.\r\n\r\n            // Remove any lower level or equal versions of this power.\r\n            Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_FORCE_IMMUNITY );\r\n\r\n            float fDuration = Sp_CalcDuration( 60.0 );\r\n\r\n            // Do not apply the effects of this power if a more powerful\r\n            // version is already attached to the target.\r\n            if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_FORCE_IMMUNITY ) ) {\r\n\r\n                SWFP_HARMFUL = FALSE;\r\n                int nSR = 15 + GetHitDice(OBJECT_SELF);\r\n                eLink1 = EffectForceResistanceIncrease(nSR);\r\n                eLink1 = SetEffectIcon(eLink1, 9);\r\n                eLink2 = EffectVisualEffect(VFX_PRO_RESIST_FORCE);\r\n\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, fDuration, eLink2, 1.0);\r\n            }\r\n\r\n            //RWT-OEI 12//29/03 - Added support for the ForceChain FEAT\r\n            //  Will add this bonus to anyone else w/Force Chain for free.\r\n            if ( GetHasFeat(FEAT_FORCE_CHAIN, OBJECT_SELF) ) {\r\n                int index = 0;\r\n                for ( ; index < 3; ++index ) {\r\n                    object oCharacter = GetPartyMemberByIndex(index);\r\n                    if ( oCharacter != OBJECT_SELF\r\n                         && GetHasFeat(FEAT_FORCE_CHAIN, oCharacter)\r\n                         && !Sp_BetterRelatedPowerExists( oCharacter, FORCE_POWER_FORCE_IMMUNITY)) {\r\n                         Sp_RemoveRelatedPowers( oCharacter, FORCE_POWER_FORCE_IMMUNITY);\r\n                         int nSR = 15 + GetHitDice(oCharacter);\r\n                         eLink1 = EffectForceResistanceIncrease(nSR);\r\n                         eLink1 = SetEffectIcon(eLink1, 9);\r\n                         eLink2 = EffectVisualEffect(VFX_PRO_RESIST_FORCE);\r\n                         Sp_ApplyEffects(FALSE, oCharacter, 0.0, 1, eLink1, fDuration, eLink2, 1.0);\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE PUSH\r\n        */\r\n        case FORCE_POWER_FORCE_PUSH:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_REFLEX;\r\n\r\n            // DJS-OEI 3/25/2004\r\n            SWFP_DAMAGE = Sp_CalcDamage( oTarget, 0, 0, GetHitDice(OBJECT_SELF) );\r\n            //SWFP_DAMAGE = GetHitDice(OBJECT_SELF);\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;\r\n\r\n            //eLink1 = EffectForcePushed();\r\n            //eLink2 = EffectStunned();\r\n            //eLink2 = SetEffectIcon(eLink2, 11);\r\n            //eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_IMP_FORCE_PUSH));\r\n            effect eDamage = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            // DJS-OEI 10/24/2004\r\n            // Droids can now be pushed back, but not stunned.\r\n            if( GetRacialType(oTarget) == RACIAL_TYPE_DROID ) {\r\n                eLink1 = EffectForcePushed();\r\n                eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_IMP_FORCE_PUSH));\r\n            }\r\n            else {\r\n                eLink1 = EffectForcePushed();\r\n                eLink2 = EffectStunned();\r\n                eLink2 = SetEffectIcon(eLink2, 11);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_IMP_FORCE_PUSH));\r\n            }\r\n            int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eDamage);\r\n            if(SP_CheckForcePushViability(oTarget, FALSE))\r\n            {\r\n                if(nResist == FALSE)\r\n                {\r\n                    int nSaves = Sp_MySavingThrows(oTarget);\r\n                    if(nSaves == FALSE)\r\n                    {\r\n                        eDamage = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                        DelayCommand(0.4, SP_MyApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget));\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 0.1);\r\n                        float fDuration = Sp_CalcDuration( 2.0 );\r\n                        DelayCommand(2.55, SP_MyApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, fDuration));\r\n                    }\r\n                    else\r\n                    {\r\n                        int nApply;\r\n\r\n                        // DJS-OEI 11/20/2003\r\n                        // If the target has the Evasion feat, the damage on a successful\r\n                        // Reflex save is 0. Otherwise, it\'s half the original damage.\r\n                        if( GetHasFeat( FEAT_EVASION, oTarget ) ) {\r\n                            nApply = 0;\r\n                        }\r\n                        else {\r\n                            nApply = SWFP_DAMAGE/2;\r\n                        }\r\n\r\n                        eDamage = EffectDamage(nApply, SWFP_DAMAGE_TYPE);\r\n                        // DJS-OEI 10/26/2004\r\n                        // Asked to remove push effect on successful save.\r\n//                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 0.1);\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n//                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_FORCE_PUSH), oTarget);\r\n\r\n                    }\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE VALOR\r\n        */\r\n        case FORCE_POWER_FORCE_MIND:\r\n        {\r\n            // DJS-OEI 12/10/2003\r\n            // Although the Force Valor series of effects still need to handle\r\n            // stacking like all of the other power trees, it can\'t be handled\r\n            // in the same fashion since it affects a radius. We can\'t just call\r\n            // Sp_ApplyEffects() as usual since we would have to change the script\r\n            // to query for better related effects in the tree prior to application.\r\n            // As a result, we are just going to find all of the targets ourselves.\r\n            SWFP_HARMFUL = FALSE;\r\n            eLink1 = EffectSavingThrowIncrease(SAVING_THROW_FORT,2);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_REFLEX, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_WILL, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_CHARISMA, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_CONSTITUTION, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_DEXTERITY, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_INTELLIGENCE, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_STRENGTH, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_WISDOM, 2));\r\n            eLink2 = EffectVisualEffect(VFX_IMP_MIND_FORCE);\r\n            eLink1 = SetEffectIcon(eLink1, 10);\r\n\r\n            float fDuration = Sp_CalcDuration( 20.0 );\r\n\r\n            // Get each creature within 30.0 units.\r\n            object oCreature = GetFirstObjectInShape(SHAPE_SPHERE, 30.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            while(GetIsObjectValid(oCreature))\r\n            {\r\n                // This power targets party members only.\r\n                if( GetIsObjectValid(oCreature) && IsObjectPartyMember(oCreature) )\r\n                {\r\n                    // Remove any lower level or equal versions of this power.\r\n                    Sp_RemoveRelatedPowers( oCreature, FORCE_POWER_FORCE_MIND );\r\n\r\n                    // Do not apply the effects of this power if a more powerful\r\n                    // version is already attached to the target.\r\n                    if( !Sp_BetterRelatedPowerExists( oCreature, FORCE_POWER_FORCE_MIND ) ) {\r\n                        SignalEvent(oCreature, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                        Sp_ApplyForcePowerEffects(fDuration, eLink1, oCreature);\r\n                        Sp_ApplyForcePowerEffects(0.0, eLink2, oCreature);\r\n                    }\r\n                }\r\n                oCreature = GetNextObjectInShape(SHAPE_SPHERE, 30.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE SHIELD\r\n        */\r\n        case FORCE_POWER_FORCE_SHIELD:\r\n        {\r\n            // DJS-OEI 12/9/2003\r\n            // For KotOR2, we have decided to modify the application behavior\r\n            // of Force Power trees. Lower level versions of Force Powers will\r\n            // no longer overwrite higher level versions, although this means\r\n            // the caster still loses their Force Points to no effect. Also,\r\n            // casting a Force Power will remove any Force Powers of equal or\r\n            // lesser level prior to applying themselves.\r\n\r\n            float fDuration = Sp_CalcDuration( 20.0 );\r\n\r\n            // Remove any lower level or equal versions of this power.\r\n            Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_FORCE_SHIELD );\r\n\r\n            // Do not apply the effects of this power if a more powerful\r\n            // version is already attached to the target.\r\n            if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_FORCE_SHIELD ) ) {\r\n\r\n                SWFP_HARMFUL = FALSE;\r\n                eLink1 = EffectACIncrease(4, AC_DODGE_BONUS);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_ALL, 4));\r\n                eLink1 = SetEffectIcon(eLink1, 12);\r\n                eLink2 = EffectVisualEffect(VFX_PRO_FORCE_SHIELD);\r\n\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, fDuration, eLink2, 3.0);\r\n            }\r\n            //RWT-OEI 12//29/03 - Added support for the ForceChain FEAT\r\n            //  Will add this bonus to anyone else w/Force Chain for free.\r\n            if ( GetHasFeat(FEAT_FORCE_CHAIN, OBJECT_SELF) ) {\r\n                int index = 0;\r\n                for ( ; index < 3; ++index ) {\r\n                    object oCharacter = GetPartyMemberByIndex(index);\r\n                    if ( oCharacter != OBJECT_SELF\r\n                         && GetHasFeat(FEAT_FORCE_CHAIN, oCharacter)\r\n                         && !Sp_BetterRelatedPowerExists( oCharacter, FORCE_POWER_FORCE_SHIELD)) {\r\n                         Sp_RemoveRelatedPowers( oCharacter, FORCE_POWER_FORCE_SHIELD);\r\n                         eLink1 = EffectACIncrease(4, AC_DODGE_BONUS);\r\n                         eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_ALL, 4));\r\n                         eLink1 = SetEffectIcon(eLink1, 12);\r\n                         eLink2 = EffectVisualEffect(VFX_PRO_FORCE_SHIELD);\r\n\r\n                         Sp_ApplyEffects(FALSE, oCharacter, 0.0, 1, eLink1, fDuration, eLink2, 3.0);\r\n\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE STORM\r\n        */\r\n        case FORCE_POWER_FORCE_STORM:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n\r\n            float fRange = Sp_CalcRange( 12.0 );\r\n\r\n            // DJS-OEI 3/25/2004\r\n            int nDice = GetHitDice(OBJECT_SELF);\r\n            // DJS-OEI 10/7/2004\r\n            // Removed cap.\r\n            /*\r\n            if(nDice > 10)\r\n            {\r\n                nDice = 10;\r\n            }\r\n            */\r\n            // DJS-OEI 3/25/2004\r\n            SWFP_DAMAGE = Sp_CalcDamage( oTarget, nDice, 6 );\r\n            //SWFP_DAMAGE = d6(nDamage);\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_ELECTRICAL;\r\n            effect eBeam = EffectBeam(2061, OBJECT_SELF, BODY_NODE_HEAD);\r\n            effect eVis = EffectVisualEffect(VFX_PRO_LIGHTNING_L);\r\n            effect eForce;\r\n            effect eDam;\r\n            //object oUse = GetFirstObjectInShape(SHAPE_SPHERE, fRange, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            object oUse = GetFirstObjectInShape(SHAPE_SPHERE, fRange, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE );\r\n            while(GetIsObjectValid(oUse))\r\n            {\r\n                //Make Immunity Checks\r\n                if(GetIsEnemy(oUse))\r\n                {\r\n                    SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    // DJS-OEI 3/25/2004\r\n                    // Modified this power to use the sp_ functions so it could\r\n                    // get the benefits of the Form modifiers.\r\n                    int nResist = Sp_BlockingChecks(oUse, eVis, eBeam, eInvalid);\r\n                    int nSaves;\r\n                    if(nResist == 0)\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eVis, oUse);\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBeam, oUse, fLightningDuration);\r\n\r\n                        nSaves = Sp_MySavingThrows(oUse);\r\n                        if(nSaves == 0)\r\n                        {\r\n                            eDam = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                            eForce = EffectDamageForcePoints(SWFP_DAMAGE);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eForce, oUse);\r\n                        }\r\n                        else\r\n                        {\r\n                            eDam = EffectDamage(SWFP_DAMAGE/2, SWFP_DAMAGE_TYPE);\r\n                            eForce = EffectDamageForcePoints(SWFP_DAMAGE/2);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eForce, oUse);\r\n                        }\r\n                    }\r\n                    else {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                    }\r\n\r\n                    /*\r\n                    if(!ResistForce(OBJECT_SELF, oUse))\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eVis, oUse);\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBeam, oUse, fLightningDuration);\r\n\r\n                        // DJS-OEI 3/16/2004\r\n                        // The Total Defense Stance gives Jedis a +4 to their\r\n                        // saving throws versus force powers. We just decrease\r\n                        // the DC by that amount.\r\n                        int nMod = Sp_GetJediDCSave();\r\n                        if( IsInTotalDefense( oTarget ) && Sp_IsJedi( oTarget ) ) {\r\n                            if( nMod > 4 ) {\r\n                                nMod -= 4;\r\n                            }\r\n                            else {\r\n                                nMod = 0;\r\n                            }\r\n                        }\r\n\r\n                        if(!WillSave(oUse, nMod))\r\n                        {\r\n                            eDam = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                            eForce = EffectDamageForcePoints(SWFP_DAMAGE);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eForce, oUse);\r\n                        }\r\n                        else\r\n                        {\r\n                            eDam = EffectDamage(SWFP_DAMAGE/2, SWFP_DAMAGE_TYPE);\r\n                            eForce = EffectDamageForcePoints(SWFP_DAMAGE/2);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eForce, oUse);\r\n                        }\r\n                    }\r\n                    else\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                    }\r\n                    */\r\n                }\r\n                //oUse = GetNextObjectInShape(SHAPE_SPHERE, fRange, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n                oUse = GetNextObjectInShape(SHAPE_SPHERE, fRange, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE );\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE WAVE\r\n        */\r\n        case FORCE_POWER_FORCE_WAVE:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_REFLEX;\r\n\r\n            float fRange = Sp_CalcRange( 15.0 );\r\n\r\n            // DJS-OEI 3/25/2004\r\n            SWFP_DAMAGE = Sp_CalcDamage( oTarget, 0, 0, GetHitDice(OBJECT_SELF) + GetHitDice(OBJECT_SELF)/2 );\r\n            //SWFP_DAMAGE = GetHitDice(OBJECT_SELF) + GetHitDice(OBJECT_SELF)/2;\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;\r\n            effect eVis = EffectVisualEffect(VFX_IMP_FORCE_PUSH);\r\n            eLink1 = EffectForcePushed();\r\n            eLink2 = EffectStunned();\r\n            eLink2 = SetEffectIcon(eLink2, 13);\r\n            effect eDam;\r\n            effect eForce;\r\n            //object oUse = GetFirstObjectInShape(SHAPE_SPHERE, fRange, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            object oUse = GetFirstObjectInShape(SHAPE_SPHERE, fRange, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            ApplyEffectAtLocation(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_FNF_FORCE_WAVE), GetLocation(OBJECT_SELF));\r\n            while(GetIsObjectValid(oUse))\r\n            {\r\n                //Make Immunity Checks\r\n                if(GetIsEnemy(oUse))\r\n                {\r\n                    SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    // DJS-OEI 3/25/2004\r\n                    // Modified this power to use the sp_ functions so it could\r\n                    // get the benefits of the Form modifiers.\r\n                    int nResist = Sp_BlockingChecks(oUse, eVis, eInvalid, eInvalid);\r\n                    int nSaves;\r\n                    if(nResist == 0)\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eVis, oUse);\r\n\r\n                        nSaves = Sp_MySavingThrows(oUse);\r\n                        if(nSaves == 0)\r\n                        {\r\n                            eDam = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                            DelayCommand(0.4, SP_MyApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse));\r\n\r\n                            if(SP_CheckForcePushViability(oUse, FALSE))\r\n                            {\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oUse, 0.2);\r\n                            }\r\n                            DelayCommand(2.55, SP_MyApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oUse, 6.0));\r\n                        }\r\n                        else\r\n                        {\r\n                            // DJS-OEI 10/26/2004\r\n                            // Asked to remove Push if save succeeded.\r\n//                            if(SP_CheckForcePushViability(oUse, FALSE))\r\n//                            {\r\n//                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oUse, 0.2);\r\n//                            }\r\n\r\n                            int nApply;\r\n                            // DJS-OEI 11/20/2003\r\n                            // If the target has the Evasion feat, the damage on a successful\r\n                            // Reflex save is 0. Otherwise, it\'s half the original damage.\r\n                            if( GetHasFeat( FEAT_EVASION, oTarget ) ) {\r\n                                nApply = 0;\r\n                            }\r\n                            else {\r\n                                nApply = SWFP_DAMAGE/2;\r\n                            }\r\n\r\n                            eDam = EffectDamage(nApply, SWFP_DAMAGE_TYPE);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceResisted(OBJECT_SELF), oTarget);\r\n                        }\r\n                    }\r\n\r\n                    /*\r\n                    if(!ResistForce(OBJECT_SELF, oUse))\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eVis, oUse);\r\n\r\n                        // DJS-OEI 3/16/2004\r\n                        // The Total Defense Stance gives Jedis a +4 to their\r\n                        // saving throws versus force powers. We just decrease\r\n                        // the DC by that amount.\r\n                        int nMod = Sp_GetJediDCSave();\r\n                        if( IsInTotalDefense( oTarget ) && Sp_IsJedi( oTarget ) ) {\r\n                            if( nMod > 4 ) {\r\n                                nMod -= 4;\r\n                            }\r\n                            else {\r\n                                nMod = 0;\r\n                            }\r\n                        }\r\n\r\n                        if(!ReflexSave(oUse, nMod))\r\n                        {\r\n                            eDam = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                            DelayCommand(0.4, SP_MyApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse));\r\n\r\n                            if(SP_CheckForcePushViability(oUse, FALSE))\r\n                            {\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oUse, 0.2);\r\n                            }\r\n                            DelayCommand(2.55, SP_MyApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oUse, 6.0));\r\n                        }\r\n                        else\r\n                        {\r\n                            if(SP_CheckForcePushViability(oUse, FALSE))\r\n                            {\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oUse, 0.2);\r\n                            }\r\n\r\n                            int nApply;\r\n                            // DJS-OEI 11/20/2003\r\n                            // If the target has the Evasion feat, the damage on a successful\r\n                            // Reflex save is 0. Otherwise, it\'s half the original damage.\r\n                            if( GetHasFeat( FEAT_EVASION, oTarget ) ) {\r\n                                nApply = 0;\r\n                            }\r\n                            else {\r\n                                nApply = SWFP_DAMAGE/2;\r\n                            }\r\n\r\n                            eDam = EffectDamage(nApply, SWFP_DAMAGE_TYPE);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceResisted(OBJECT_SELF), oTarget);\r\n                        }\r\n                    }\r\n                    */\r\n                }\r\n                //oUse = GetNextObjectInShape(SHAPE_SPHERE, fRange, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n                oUse = GetNextObjectInShape(SHAPE_SPHERE, fRange, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        FORCE WHIRLWIND\r\n        */\r\n        case FORCE_POWER_FORCE_WHIRLWIND:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_REFLEX;\r\n\r\n            float fRange = Sp_CalcRange( 5.0 );\r\n\r\n            // DJS-OEI 3/25/2004\r\n            SWFP_DAMAGE = Sp_CalcDamage( oTarget, 0, 0, GetHitDice(OBJECT_SELF)/3 );\r\n            //SWFP_DAMAGE = GetHitDice(OBJECT_SELF)/3;\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;\r\n            effect eDamage = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n\r\n            //SP_MyPostString(IntToString(SP_CheckAppearanceGeoDroidShields(oTarget)),5,5,3.0);\r\n\r\n            if(SP_CheckForcePushViability(oTarget, TRUE))\r\n            {\r\n                eLink1 = EffectWhirlWind();\r\n                eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_IMP_FORCE_WHIRLWIND));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_FORCE_WHIRLWIND));\r\n                eLink1 = SetEffectIcon(eLink1, 14);\r\n\r\n                int nResist = Sp_BlockingChecks(oTarget, eLink1, eDamage, eInvalid);\r\n                int nSaves;\r\n                SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                if(nResist == 0)\r\n                {\r\n                    nSaves =Sp_MySavingThrows(oTarget);\r\n                    if(nSaves == 0)\r\n                    {\r\n                        //ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 9.0);\r\n                        //RWT-OEI 09/27/04 - QA says they fall too soon. Upping this to 12 to\r\n                        //see if that fixes it. FMP#6266\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 12.0);\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eDamage, oTarget);\r\n                        int nIdx = 1;\r\n                        float fDelay;\r\n                        SP_InterativeDamage(eDamage, 13, oTarget);\r\n                    }\r\n                }\r\n                if(nResist > 0 || nSaves > 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                }\r\n            }\r\n            //Force Push all enemies away from the target is they meet the conditions.\r\n            SP_MyPrintString("");\r\n            eLink2 = EffectForcePushTargeted(GetLocation(oTarget));\r\n            object oSecond = GetFirstObjectInShape(SHAPE_SPHERE, fRange, GetLocation(oTarget));\r\n            while(GetIsObjectValid(oSecond))\r\n            {\r\n                if(SP_CheckForcePushViability(oSecond, FALSE) == TRUE && GetIsEnemy(oSecond, OBJECT_SELF) && oSecond != oTarget)\r\n                {\r\n                    //P.W. (June 8) - Put this check in so Calo Nord does not move during the fight on Taris\r\n                    if(GetTag(oTarget) != "Calo082")\r\n                    {\r\n                        SignalEvent(oSecond, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                        int nResist2 = Sp_BlockingChecks(oSecond, eLink2,eInvalid,eInvalid);\r\n                        if(nResist2 == 0)\r\n                        {\r\n                            int nSaves2 = Sp_MySavingThrows(oSecond);\r\n                            if(nSaves2 == 0)\r\n                            {\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oSecond, 0.2);\r\n                            }\r\n                        }\r\n                    }\r\n                }\r\n                oSecond = GetNextObjectInShape(SHAPE_SPHERE, fRange, GetLocation(oTarget));\r\n                SP_MyPrintString("");\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        IMPROVED HEAL\r\n        */\r\n        //MODIFIED by Preston Watamaniuk March 28\r\n        //Cut the heal in half\r\n        case FORCE_POWER_HEAL:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n\r\n            // DJS-OEI 3/29/2004\r\n            // The Regeneration Consular Forms increase the relevance of\r\n            // the Wisdom and Charisma modifiers.\r\n            int nMultiplier = 1;\r\n            // DJS-OEI 7/20/2004\r\n            // Form/Stance re-design.\r\n            /*\r\n            if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_REGENERATION_I ) ) {\r\n                nMultiplier = 2;\r\n            }\r\n            else if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_REGENERATION_II ) ||\r\n                     IsFormActive( OBJECT_SELF, FORM_CONSULAR_REGENERATION_III ) ) {\r\n                nMultiplier = 3;\r\n            }\r\n            */\r\n\r\n            // DJS-OEI 10/20/2004\r\n            // Balance change\r\n            //int nHeal = ( ( GetAbilityModifier(ABILITY_WISDOM) + GetAbilityModifier(ABILITY_CHARISMA) ) * nMultiplier ) + 10 + GetHitDice(OBJECT_SELF);\r\n            int nHeal = ( ( GetAbilityModifier(ABILITY_WISDOM) + GetAbilityModifier(ABILITY_CHARISMA) ) * nMultiplier ) + 15 + GetHitDice(OBJECT_SELF);\r\n\r\n            effect eVis =  EffectVisualEffect(VFX_IMP_HEAL);\r\n            int nCnt = 0;\r\n\r\n            object oParty;\r\n            if(IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                oParty = GetPartyMemberByIndex(nCnt);\r\n            }\r\n            else\r\n            {\r\n                oParty = OBJECT_SELF;\r\n            }\r\n\r\n            while(nCnt < 3)\r\n            {\r\n                if(GetIsObjectValid(oParty) &&\r\n                   GetRacialType(oParty) != RACIAL_TYPE_DROID &&\r\n                   GetDistanceBetween(OBJECT_SELF, oParty) < 15.0)\r\n                {\r\n                    SignalEvent(oParty, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                    Sp_RemoveSpecificEffect(EFFECT_TYPE_POISON, oParty);\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eVis, oParty);\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectHeal(nHeal), oParty);\r\n                }\r\n                nCnt++;\r\n                if(IsObjectPartyMember(OBJECT_SELF))\r\n                {\r\n                   oParty = GetPartyMemberByIndex(nCnt);\r\n                }\r\n                else\r\n                {\r\n                   oParty = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, OBJECT_SELF, nCnt, CREATURE_TYPE_RACIAL_TYPE, RACIAL_TYPE_HUMAN);\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        MASTER HEAL\r\n        */\r\n        // Same as Improved Heal with addition 5 VP and Stun removal.\r\n        case FORCE_POWER_MASTER_HEAL:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n\r\n            // DJS-OEI 3/29/2004\r\n            // The Regeneration Consular Forms increase the relevance of\r\n            // the Wisdom and Charisma modifiers.\r\n            int nMultiplier = 1;\r\n            // DJS-OEI 7/20/2004\r\n            // Form/Stance re-design.\r\n            /*\r\n            if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_REGENERATION_I ) ) {\r\n                nMultiplier = 2;\r\n            }\r\n            else if( IsFormActive( OBJECT_SELF, FORM_CONSULAR_REGENERATION_II ) ||\r\n                     IsFormActive( OBJECT_SELF, FORM_CONSULAR_REGENERATION_III ) ) {\r\n                nMultiplier = 3;\r\n            }\r\n            */\r\n\r\n            // Balance Change\r\n            //int nHeal = ( ( GetAbilityModifier(ABILITY_WISDOM) + GetAbilityModifier(ABILITY_CHARISMA) ) * nMultiplier ) + 15 + GetHitDice(OBJECT_SELF);\r\n            int nHeal = ( ( GetAbilityModifier(ABILITY_WISDOM) + GetAbilityModifier(ABILITY_CHARISMA) ) * nMultiplier ) + 15 + 2*GetHitDice(OBJECT_SELF);\r\n\r\n            effect eVis =  EffectVisualEffect(VFX_IMP_HEAL);\r\n            int nCnt = 0;\r\n\r\n            object oParty;\r\n            if(IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                oParty = GetPartyMemberByIndex(nCnt);\r\n            }\r\n            else\r\n            {\r\n                oParty = OBJECT_SELF;\r\n            }\r\n\r\n            while(nCnt < 3)\r\n            {\r\n                if(GetIsObjectValid(oParty) &&\r\n                   GetRacialType(oParty) != RACIAL_TYPE_DROID &&\r\n                   GetDistanceBetween(OBJECT_SELF, oParty) < 15.0)\r\n                {\r\n                    SignalEvent(oParty, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                    Sp_RemoveSpecificEffect(EFFECT_TYPE_STUNNED, oParty);\r\n                    Sp_RemoveSpecificEffect(EFFECT_TYPE_POISON, oParty);\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eVis, oParty);\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectHeal(nHeal), oParty);\r\n                }\r\n                nCnt++;\r\n                if(IsObjectPartyMember(OBJECT_SELF))\r\n                {\r\n                   oParty = GetPartyMemberByIndex(nCnt);\r\n                }\r\n                else\r\n                {\r\n                   oParty = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, OBJECT_SELF, nCnt, CREATURE_TYPE_RACIAL_TYPE, RACIAL_TYPE_HUMAN);\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        HORROR\r\n        */\r\n        case FORCE_POWER_HORROR:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_FEAR;\r\n\r\n            float fRange = Sp_CalcRange( 5.0 );\r\n\r\n            eLink1 = EffectHorrified();\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(1042));\r\n            eLink1 = SetEffectIcon(eLink1, 16);\r\n\r\n            float fDuration = Sp_CalcDuration( 12.0 );\r\n            Sp_ApplyEffects(TRUE, oTarget, fRange, 1000, eLink1, fDuration, eInvalid, 0.0, RACIAL_TYPE_HUMAN);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        INSANITY\r\n        */\r\n        case FORCE_POWER_INSANITY:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_FEAR;\r\n\r\n            float fRange = Sp_CalcRange( 10.0 );\r\n\r\n            eLink1 = EffectHorrified();\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(1043));\r\n            eLink1 = SetEffectIcon(eLink1, 17);\r\n\r\n            // DJS-OEI 10/7/2004\r\n            // Changed to base of 18 seconds.\r\n            //float fDuration = Sp_CalcDuration( 12.0 );\r\n            float fDuration = Sp_CalcDuration( 18.0 );\r\n            Sp_ApplyEffects(TRUE, oTarget, fRange, 1000, eLink1, fDuration, eInvalid, 0.0, RACIAL_TYPE_HUMAN);\r\n\r\n            //ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(1043), oTarget);\r\n\r\n        }\r\n        break;\r\n\r\n        /*\r\n        KILL\r\n        */\r\n        case FORCE_POWER_KILL:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n            effect eDeath = EffectDeath();\r\n            effect eDamage;\r\n            effect eChoke = EffectChoke();\r\n            eChoke = SetEffectIcon(eChoke, 18);\r\n            effect eVFX = EffectVisualEffect(VFX_IMP_CHOKE);\r\n\r\n            int nResist = Sp_BlockingChecks(oTarget, eDeath, eDamage, eChoke);\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            if(nResist == 0)\r\n            {\r\n                int nSaves = Sp_MySavingThrows(oTarget);\r\n\r\n                // DJS-OEI 3/25/2004\r\n                int nDamage = Sp_CalcDamage( oTarget, 0, 0, GetHitDice(OBJECT_SELF) );\r\n                //int nDamage = GetHitDice(OBJECT_SELF);\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, eVFX, oTarget);\r\n                eDamage = EffectDamage(nDamage, DAMAGE_TYPE_BLUDGEONING);\r\n                if(nSaves == 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eChoke, oTarget, 6.0);\r\n                    nDamage = (GetMaxHitPoints(oTarget))/2;\r\n                    nDamage = nDamage/3;\r\n\r\n                    // DJS-OEI 3/25/2004\r\n                    nDamage = Sp_CalcDamage( oTarget, 0, 0, nDamage );\r\n\r\n                    //This will do damage over time to make the effect look more dramatic\r\n                    eDamage = EffectDamage(nDamage, DAMAGE_TYPE_BLUDGEONING);\r\n                    SP_InterativeDamage(eDamage, 7, oTarget);\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                }\r\n\r\n            }\r\n            else\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        KNIGHT VALOR\r\n        */\r\n        case FORCE_POWER_KNIGHT_MIND:\r\n        {\r\n            // DJS-OEI 12/10/2003\r\n            // Although the Force Valor series of effects still need to handle\r\n            // stacking like all of the other power trees, it can\'t be handled\r\n            // in the same fashion since it affects a radius. We can\'t just call\r\n            // Sp_ApplyEffects() as usual since we would have to change the script\r\n            // to query for better related effects in the tree prior to application.\r\n            // As a result, we are just going to find all of the targets ourselves.\r\n            SWFP_HARMFUL = FALSE;\r\n            eLink1 = EffectSavingThrowIncrease(SAVING_THROW_ALL,3);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_CHARISMA, 3));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_CONSTITUTION, 3));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_DEXTERITY, 3));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_INTELLIGENCE, 3));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_STRENGTH, 3));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_WISDOM, 3));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectImmunity(IMMUNITY_TYPE_POISON));\r\n            eLink1 = SetEffectIcon(eLink1, 19);\r\n            eLink2 = EffectVisualEffect(1033);\r\n\r\n            float fDuration = Sp_CalcDuration( 20.0 );\r\n\r\n            // Get each creature within 30.0 units.\r\n            object oCreature = GetFirstObjectInShape(SHAPE_SPHERE, 30.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            while(GetIsObjectValid(oCreature))\r\n            {\r\n                // This power targets party members only.\r\n                if( GetIsObjectValid(oCreature) && IsObjectPartyMember(oCreature) )\r\n                {\r\n                    // Remove any lower level or equal versions of this power.\r\n                    Sp_RemoveRelatedPowers( oCreature, FORCE_POWER_KNIGHT_MIND );\r\n\r\n                    // Do not apply the effects of this power if a more powerful\r\n                    // version is already attached to the target.\r\n                    if( !Sp_BetterRelatedPowerExists( oCreature, FORCE_POWER_KNIGHT_MIND ) ) {\r\n                        SignalEvent(oCreature, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                        Sp_ApplyForcePowerEffects(fDuration, eLink1, oCreature);\r\n                        Sp_ApplyForcePowerEffects(0.0, eLink2, oCreature);\r\n                    }\r\n                }\r\n                oCreature = GetNextObjectInShape(SHAPE_SPHERE, 30.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        KNIGHT SPEED\r\n        */\r\n        case FORCE_POWER_KNIGHT_SPEED:\r\n        {\r\n            // DJS-OEI 12/9/2003\r\n            // For KotOR2, we have decided to modify the application behavior\r\n            // of Force Power trees. Lower level versions of Force Powers will\r\n            // no longer overwrite higher level versions, although this means\r\n            // the caster still loses their Force Points to no effect. Also,\r\n            // casting a Force Power will remove any Force Powers of equal or\r\n            // lesser level prior to applying themselves.\r\n\r\n            float fDuration = Sp_CalcDuration( 36.0 );\r\n\r\n            // Remove any lower level or equal versions of this power.\r\n            Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_KNIGHT_SPEED );\r\n            // Do not apply the effects of this power if a more powerful\r\n            // version is already attached to the target.\r\n            if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_KNIGHT_SPEED ) ) {\r\n\r\n                SWFP_HARMFUL = FALSE;\r\n                eLink1 = EffectMovementSpeedIncrease(99);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectACIncrease(4));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectModifyAttacks(1));\r\n                eLink1 = SetEffectIcon(eLink1, 20);\r\n\r\n                if(OBJECT_SELF == GetPartyMemberByIndex(0))\r\n                {\r\n                    eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_SPEED));\r\n                    //eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_IMP_SPEED_KNIGHT));\r\n                }\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, fDuration, eInvalid, 0.0);\r\n            }\r\n\r\n            //RWT-OEI 12//29/03 - Added support for the ForceChain FEAT\r\n            //  Will add this bonus to anyone else w/Force Chain for free.\r\n            if ( GetHasFeat(FEAT_FORCE_CHAIN, OBJECT_SELF) ) {\r\n                int index = 0;\r\n                for ( ; index < 3; ++index ) {\r\n                    object oCharacter = GetPartyMemberByIndex(index);\r\n                    if ( oCharacter != OBJECT_SELF\r\n                         && GetHasFeat(FEAT_FORCE_CHAIN, oCharacter)\r\n                         && !Sp_BetterRelatedPowerExists( oCharacter, FORCE_POWER_KNIGHT_SPEED)) {\r\n                            Sp_RemoveRelatedPowers( oCharacter, FORCE_POWER_KNIGHT_SPEED );\r\n                            eLink2 = EffectMovementSpeedIncrease(99);\r\n                            eLink2 = EffectLinkEffects(eLink2, EffectACIncrease(4));\r\n                            eLink2 = EffectLinkEffects(eLink2, EffectModifyAttacks(1));\r\n                            eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(VFX_DUR_SPEED));\r\n                            eLink2 = SetEffectIcon(eLink2, 20);\r\n                            Sp_ApplyEffects(FALSE, oCharacter, 0.0, 1, eLink2, fDuration, eInvalid, 0.0);\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        LIGHTSABER THROW\r\n        */\r\n        case FORCE_POWER_LIGHT_SABER_THROW:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n\r\n            eLink1 = EffectLightsaberThrow(oTarget);\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, OBJECT_SELF, 3.0);\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n        }\r\n        break;\r\n        /*\r\n        ADVANCED LIGHTSABER THROW\r\n        */\r\n        case FORCE_POWER_LIGHT_SABER_THROW_ADVANCED:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            object oTarget2, oTarget3;\r\n            oTarget2 = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, oTarget, 1);\r\n            if(GetIsObjectValid(oTarget2) && GetDistanceBetween(oTarget, oTarget2) <= 5.0)\r\n            {\r\n                oTarget3 = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, oTarget, 2);\r\n                if(GetIsObjectValid(oTarget3) && GetDistanceBetween(oTarget, oTarget3) <= 5.0)\r\n                {\r\n                    SP_MyPrintString("Target 1 = " + ObjectToString(oTarget) +\r\n                                " Target 2 = " + ObjectToString(oTarget2) +\r\n                                " Target 3 = " + ObjectToString(oTarget3));\r\n                    eLink1 = EffectLightsaberThrow(oTarget, oTarget2, oTarget3);\r\n                    SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                    SignalEvent(oTarget2, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                    SignalEvent(oTarget3, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                }\r\n                else\r\n                {\r\n                    SP_MyPrintString("Target 1 = " + ObjectToString(oTarget) +\r\n                                " Target 2 = " + ObjectToString(oTarget2));\r\n                    eLink1 = EffectLightsaberThrow(oTarget, oTarget2);\r\n                    SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                    SignalEvent(oTarget2, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                }\r\n            }\r\n            else\r\n            {\r\n                SP_MyPrintString("Target 1 = " + ObjectToString(oTarget));\r\n                eLink1 = EffectLightsaberThrow(oTarget);\r\n                oTarget2 = OBJECT_INVALID;\r\n            }\r\n            SP_MyPrintString("Apply Throwsaber Effect");\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, OBJECT_SELF, 3.0);\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n        }\r\n        break;\r\n\r\n        /*\r\n        LIGHTNING\r\n        */\r\n        case FORCE_POWER_LIGHTNING:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_ELECTRICAL;\r\n            int nDice = GetHitDice(OBJECT_SELF);\r\n            // DJS-OEI 10/7/2004\r\n            // Removed cap.\r\n            /*\r\n            if(nDice > 10)\r\n            {\r\n                nDice = 10;\r\n            }\r\n            */\r\n\r\n            float fRange = Sp_CalcRange( 17.0 );\r\n\r\n            // DJS-OEI 3/25/2004\r\n            SWFP_DAMAGE = Sp_CalcDamage( oTarget, nDice, 6 );\r\n            //SWFP_DAMAGE = d6(nDamage);\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_ELECTRICAL;\r\n            SWFP_DAMAGE_VFX = VFX_PRO_LIGHTNING_L; //1036 - With sound\r\n            SWFP_SHAPE = SHAPE_SPELLCYLINDER;\r\n\r\n            effect eLightning = EffectBeam(VFX_BEAM_LIGHTNING_DARK_L, OBJECT_SELF, BODY_NODE_HAND);\r\n\r\n            effect eDam = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n            //object oUse = GetFirstObjectInShape(SWFP_SHAPE, fRange, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            object oUse = GetFirstObjectInShape(SWFP_SHAPE, fRange, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE );\r\n            effect eBump = EffectVisualEffect(SWFP_DAMAGE_VFX);\r\n            int nCnt = 1;\r\n            // This will need to be changed to a double while get nearest in shape script.\r\n            //ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(1036), OBJECT_SELF);\r\n            while(GetIsObjectValid(oUse))\r\n            {\r\n                if(GetIsEnemy(oUse))\r\n                {\r\n                    SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    // DJS-OEI 3/25/2004\r\n                    // Modified this power to use the sp_ functions so it could\r\n                    // get the benefits of the Form modifiers.\r\n                    int nResist = Sp_BlockingChecks(oUse, eBump, eInvalid, eInvalid);\r\n                    int nSaves;\r\n                    if(nResist == 0)\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eBump, oUse);\r\n\r\n                        nSaves = Sp_MySavingThrows(oUse);\r\n                        if(nSaves == 0)\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n                            //ApplyEffectToObject(DURATION_TYPE_INSTANT, eForce, oUse);\r\n                        }\r\n                        else\r\n                        {\r\n                            SWFP_DAMAGE /= 2;\r\n                            eDam = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n                        }\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLightning, oUse, fLightningDuration);\r\n                    }\r\n                    else\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceResisted(OBJECT_SELF), oTarget);\r\n                    }\r\n\r\n                    /*\r\n                    //Make Immunity Checks\r\n                    if(!ResistForce(OBJECT_SELF, oUse))\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eBump, oUse);\r\n\r\n                        // DJS-OEI 3/16/2004\r\n                        // The Total Defense Stance gives Jedis a +4 to their\r\n                        // saving throws versus force powers. We just decrease\r\n                        // the DC by that amount.\r\n                        int nMod = Sp_GetJediDCSave();\r\n                        if( IsInTotalDefense( oTarget ) && Sp_IsJedi( oTarget ) ) {\r\n                            if( nMod > 4 ) {\r\n                                nMod -= 4;\r\n                            }\r\n                            else {\r\n                                nMod = 0;\r\n                            }\r\n                        }\r\n\r\n                        if(!WillSave(oUse, nMod, SWFP_PRIVATE_SAVE_VERSUS_TYPE))\r\n                        {\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n                            //ApplyEffectToObject(DURATION_TYPE_INSTANT, eForce, oUse);\r\n                        }\r\n                        else\r\n                        {\r\n                            SWFP_DAMAGE /= 2;\r\n                            eDam = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oUse);\r\n\r\n                        }\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLightning, oUse, fLightningDuration);\r\n                    }\r\n                    else\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceResisted(OBJECT_SELF), oTarget);\r\n                    }\r\n                    */\r\n                }\r\n                nCnt++;\r\n                //oUse = GetNextObjectInShape(SWFP_SHAPE, fRange, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n                oUse = GetNextObjectInShape(SWFP_SHAPE, fRange, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE );\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        MASTER VALOR\r\n        */\r\n        case FORCE_POWER_MIND_MASTERY:\r\n        {\r\n            // DJS-OEI 12/10/2003\r\n            // Although the Force Valor series of effects still need to handle\r\n            // stacking like all of the other power trees, it can\'t be handled\r\n            // in the same fashion since it affects a radius. We can\'t just call\r\n            // Sp_ApplyEffects() as usual since we would have to change the script\r\n            // to query for better related effects in the tree prior to application.\r\n            // As a result, we are just going to find all of the targets ourselves.\r\n            SWFP_HARMFUL = FALSE;\r\n            eLink1 = EffectSavingThrowIncrease(SAVING_THROW_ALL,5);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_CHARISMA, 5));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_CONSTITUTION, 5));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_DEXTERITY, 5));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_INTELLIGENCE, 5));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_STRENGTH, 5));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_WISDOM, 5));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectImmunity(IMMUNITY_TYPE_POISON));\r\n            eLink1 = SetEffectIcon(eLink1, 21);\r\n            eLink2 = EffectVisualEffect(VFX_IMP_MIND_MASTERY);\r\n\r\n            float fDuration = Sp_CalcDuration( 20.0 );\r\n\r\n            // Get each creature within 30.0 units.\r\n            object oCreature = GetFirstObjectInShape(SHAPE_SPHERE, 30.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            while(GetIsObjectValid(oCreature))\r\n            {\r\n                // This power targets party members only.\r\n                if( GetIsObjectValid(oCreature) && IsObjectPartyMember(oCreature) )\r\n                {\r\n                    // Remove any lower level or equal versions of this power.\r\n                    Sp_RemoveRelatedPowers( oCreature, FORCE_POWER_MIND_MASTERY );\r\n\r\n                    // Do not apply the effects of this power if a more powerful\r\n                    // version is already attached to the target.\r\n                    if( !Sp_BetterRelatedPowerExists( oCreature, FORCE_POWER_MIND_MASTERY ) ) {\r\n                        SignalEvent(oCreature, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                        Sp_ApplyForcePowerEffects(fDuration, eLink1, oCreature);\r\n                        Sp_ApplyForcePowerEffects(0.0, eLink2, oCreature);\r\n                    }\r\n                }\r\n                oCreature = GetNextObjectInShape(SHAPE_SPHERE, 30.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        PLAGUE\r\n        */\r\n        case FORCE_POWER_PLAGUE:\r\n        {\r\n            // If the target is already poisoned in any way, don\'t\r\n            // apply this effect.\r\n            if(!GetIsPoisoned(oTarget))\r\n            {\r\n                // DJS-OEI 12/9/2003\r\n                // For KotOR2, we have decided to modify the application behavior\r\n                // of Force Power trees. Lower level versions of Force Powers will\r\n                // no longer overwrite higher level versions, although this means\r\n                // the caster still loses their Force Points to no effect. Also,\r\n                // casting a Force Power will remove any Force Powers of equal or\r\n                // lesser level prior to applying themselves.\r\n\r\n                // Remove any lower level or equal versions of this power.\r\n                Sp_RemoveRelatedPowers( oTarget, FORCE_POWER_PLAGUE );\r\n\r\n                // Do not apply the effects of this power if a more powerful\r\n                // version is already attached to the target.\r\n                if( !Sp_BetterRelatedPowerExists( oTarget, FORCE_POWER_PLAGUE ) ) {\r\n\r\n                    SWFP_HARMFUL = TRUE;\r\n\r\n                    eLink1 = EffectPoison(POISON_ABILITY_SCORE_VIRULENT);\r\n                    eLink1 = EffectLinkEffects(eLink1, EffectMovementSpeedDecrease(50));\r\n                    eLink1 = SetEffectIcon(eLink1, 23);\r\n                    if(!GetIsPoisoned(oTarget))\r\n                    {\r\n                        //Sp_ApplyEffects(FALSE, oTarget, 0.0, 1, eLink1, 1000.0, eInvalid, 0.0);\r\n                        //RWT-OEI 09/27/04 - This is apparently supposed to be 12 seconds instead\r\n                        //of permanent.\r\n                        Sp_ApplyEffects(FALSE, oTarget, 0.0, 1, eLink1, 12.0, eInvalid, 0.0);\r\n                    }\r\n                }\r\n            }\r\n            // DJS-OEI 10/22/2004\r\n            else {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceResisted(OBJECT_SELF), oTarget);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        IMPROVED ENERGY RESISTANCE\r\n        */\r\n        case FORCE_POWER_RESIST_COLD_HEAT_ENERGY:\r\n        {\r\n            // DJS-OEI 12/10/2003\r\n            // Although the Energy Resistance series of effects still need to handle\r\n            // stacking like all of the other power trees, it can\'t be handled\r\n            // in the same fashion since it affects multiple targets in the party. We can\'t just call\r\n            // Sp_ApplyEffects() as usual since we would have to change the script\r\n            // to query for better related effects in the tree prior to application.\r\n            // As a result, we are just going to find all of the targets ourselves.\r\n            SWFP_HARMFUL = FALSE;\r\n            eLink1 = EffectDamageResistance(DAMAGE_TYPE_COLD, 12);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_FIRE, 12));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_SONIC, 12));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_BLASTER, 12));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_ELECTRICAL, 12));\r\n            eLink1 = SetEffectIcon(eLink1, 24);\r\n            eLink2 = EffectVisualEffect(VFX_PRO_RESIST_ELEMENTS);\r\n\r\n            // Keep in mind that enemies can also cast this, although\r\n            // only the caster will receive benfit. If a PC casts it,\r\n            // the entire party is affected regardless of distance.\r\n            if(!IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                // Remove any lower level or equal versions of this power.\r\n                Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_RESIST_COLD_HEAT_ENERGY );\r\n\r\n                // Do not apply the effects of this power if a more powerful\r\n                // version is already attached to the target.\r\n                if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_RESIST_COLD_HEAT_ENERGY ) ) {\r\n                    float fDuration = Sp_CalcDuration( 120.0 );\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, OBJECT_SELF, fDuration);\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, OBJECT_SELF, 1.0);\r\n                }\r\n            }\r\n            else if(IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                int nCnt = 0;\r\n                object oParty;\r\n                for(nCnt; nCnt < 3; nCnt++)\r\n                {\r\n                    oParty = GetPartyMemberByIndex(nCnt);\r\n                    if(GetIsObjectValid(oParty))\r\n                    {\r\n                        // Remove any lower level or equal versions of this power.\r\n                        Sp_RemoveRelatedPowers( oParty, FORCE_POWER_RESIST_COLD_HEAT_ENERGY );\r\n\r\n                        // Do not apply the effects of this power if a more powerful\r\n                        // version is already attached to the target.\r\n                        if( !Sp_BetterRelatedPowerExists( oParty, FORCE_POWER_RESIST_COLD_HEAT_ENERGY ) ) {\r\n\r\n                            // Make sure to send the event signal to anyone other\r\n                            // than the caster that gets the benefit of this power.\r\n                            if( oParty != OBJECT_SELF ) {\r\n                                SignalEvent(oParty, EventSpellCastAt(oParty, GetSpellId(), SWFP_HARMFUL));\r\n                            }\r\n                            float fDuration = Sp_CalcDuration( 120.0 );\r\n                            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oParty, fDuration);\r\n                            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oParty, 1.0);\r\n                        }\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        // DJS-OEI 12/9/2003\r\n        /*\r\n        MASTER ENERGY RESISTANCE\r\n        */\r\n        case FORCE_POWER_MASTER_ENERGY_RESISTANCE:\r\n        {\r\n            // DJS-OEI 12/10/2003\r\n            // Although the Energy Resistance series of effects still need to handle\r\n            // stacking like all of the other power trees, it can\'t be handled\r\n            // in the same fashion since it affects multiple targets in the party. We can\'t just call\r\n            // Sp_ApplyEffects() as usual since we would have to change the script\r\n            // to query for better related effects in the tree prior to application.\r\n            // As a result, we are just going to find all of the targets ourselves.\r\n            SWFP_HARMFUL = FALSE;\r\n            eLink1 = EffectDamageResistance(DAMAGE_TYPE_COLD, 20);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_FIRE, 20));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_SONIC, 20));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_BLASTER, 20));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_ELECTRICAL, 20));\r\n            eLink1 = SetEffectIcon(eLink1, 104);\r\n            eLink2 = EffectVisualEffect(VFX_PRO_RESIST_ELEMENTS);\r\n\r\n            // Keep in mind that enemies can also cast this, although\r\n            // only the caster will receive benfit. If a PC casts it,\r\n            // the entire party is affected regardless of distance.\r\n            if(!IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                // Remove any lower level or equal versions of this power.\r\n                Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_MASTER_ENERGY_RESISTANCE );\r\n\r\n                // Do not apply the effects of this power if a more powerful\r\n                // version is already attached to the target.\r\n                if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_MASTER_ENERGY_RESISTANCE ) ) {\r\n                    float fDuration = Sp_CalcDuration( 120.0 );\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, OBJECT_SELF, fDuration);\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, OBJECT_SELF, 1.0);\r\n                }\r\n            }\r\n            else if(IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                int nCnt = 0;\r\n                object oParty;\r\n                for(nCnt; nCnt < 3; nCnt++)\r\n                {\r\n                    oParty = GetPartyMemberByIndex(nCnt);\r\n                    if(GetIsObjectValid(oParty))\r\n                    {\r\n                        // Remove any lower level or equal versions of this power.\r\n                        Sp_RemoveRelatedPowers( oParty, FORCE_POWER_MASTER_ENERGY_RESISTANCE );\r\n\r\n                        // Do not apply the effects of this power if a more powerful\r\n                        // version is already attached to the target.\r\n                        if( !Sp_BetterRelatedPowerExists( oParty, FORCE_POWER_MASTER_ENERGY_RESISTANCE ) ) {\r\n\r\n                            // Make sure to send the event signal to anyone other\r\n                            // than the caster that gets the benefit of this power.\r\n                            if( oParty != OBJECT_SELF ) {\r\n                                SignalEvent(oParty, EventSpellCastAt(oParty, GetSpellId(), SWFP_HARMFUL));\r\n                            }\r\n                            float fDuration = Sp_CalcDuration( 120.0 );\r\n                            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oParty, fDuration);\r\n                            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oParty, 1.0);\r\n                        }\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n        /*\r\n        RESIST FORCE 1\r\n        */\r\n        case FORCE_POWER_RESIST_FORCE:\r\n        {\r\n            // DJS-OEI 12/9/2003\r\n            // For KotOR2, we have decided to modify the application behavior\r\n            // of Force Power trees. Lower level versions of Force Powers will\r\n            // no longer overwrite higher level versions, although this means\r\n            // the caster still loses their Force Points to no effect. Also,\r\n            // casting a Force Power will remove any Force Powers of equal or\r\n            // lesser level prior to applying themselves.\r\n\r\n            // Remove any lower level or equal versions of this power.\r\n            Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_RESIST_FORCE );\r\n\r\n            // Do not apply the effects of this power if a more powerful\r\n            // version is already attached to the target.\r\n            if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_RESIST_FORCE ) ) {\r\n\r\n                SWFP_HARMFUL = FALSE;\r\n                int nSR = 10 + GetHitDice(OBJECT_SELF);\r\n                eLink1 = EffectForceResistanceIncrease(nSR);\r\n                eLink1 = SetEffectIcon(eLink1, 25);\r\n                eLink2 = EffectVisualEffect(VFX_PRO_RESIST_FORCE);\r\n\r\n                float fDuration = Sp_CalcDuration( 60.0 );\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, fDuration, eLink2, 1.0);\r\n            }\r\n\r\n            //RWT-OEI 12//29/03 - Added support for the ForceChain FEAT\r\n            //  Will add this bonus to anyone else w/Force Chain for free.\r\n            if ( GetHasFeat(FEAT_FORCE_CHAIN, OBJECT_SELF) ) {\r\n                int index = 0;\r\n                for ( ; index < 3; ++index ) {\r\n                    object oCharacter = GetPartyMemberByIndex(index);\r\n                    if ( oCharacter != OBJECT_SELF\r\n                         && GetHasFeat(FEAT_FORCE_CHAIN, oCharacter)\r\n                         && !Sp_BetterRelatedPowerExists( oCharacter, FORCE_POWER_RESIST_FORCE)) {\r\n                         Sp_RemoveRelatedPowers( oCharacter, FORCE_POWER_RESIST_FORCE );\r\n                         int nSR = 10 + GetHitDice(oCharacter);\r\n                         eLink1 = EffectForceResistanceIncrease(nSR);\r\n                         eLink1 = SetEffectIcon(eLink1, 25);\r\n                         eLink2 = EffectVisualEffect(VFX_PRO_RESIST_FORCE);\r\n                         float fDuration = Sp_CalcDuration( 60.0 );\r\n                         Sp_ApplyEffects(FALSE, oCharacter, 0.0, 1, eLink1, fDuration, eLink2, 1.0);\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        RESIST ENERGY\r\n        */\r\n\r\n        case FORCE_POWER_RESIST_POISON_DISEASE_SONIC:\r\n        {\r\n            // DJS-OEI 12/9/2003\r\n            // For KotOR2, we have decided to modify the application behavior\r\n            // of Force Power trees. Lower level versions of Force Powers will\r\n            // no longer overwrite higher level versions, although this means\r\n            // the caster still loses their Force Points to no effect. Also,\r\n            // casting a Force Power will remove any Force Powers of equal or\r\n            // lesser level prior to applying themselves.\r\n\r\n            // Remove any lower level or equal versions of this power.\r\n            Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_RESIST_POISON_DISEASE_SONIC );\r\n\r\n            // Do not apply the effects of this power if a more powerful\r\n            // version is already attached to the target.\r\n            if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_RESIST_POISON_DISEASE_SONIC ) ) {\r\n\r\n                SWFP_HARMFUL = FALSE;\r\n                eLink1 = EffectDamageResistance(DAMAGE_TYPE_COLD, 6);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_FIRE, 6));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_SONIC, 6));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_ELECTRICAL, 6));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_BLASTER, 6));\r\n                eLink1 = SetEffectIcon(eLink1, 26);\r\n                eLink2 = EffectVisualEffect(VFX_PRO_RESIST_ELEMENTS);\r\n                float fDuration = Sp_CalcDuration( 120.0 );\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, fDuration, eLink2, 1.0);\r\n            }\r\n\r\n            //RWT-OEI 12//29/03 - Added support for the ForceChain FEAT\r\n            //  Will add this bonus to anyone else w/Force Chain for free.\r\n            if ( GetHasFeat(FEAT_FORCE_CHAIN, OBJECT_SELF) ) {\r\n                int index = 0;\r\n                for ( ; index < 3; ++index ) {\r\n                    object oCharacter = GetPartyMemberByIndex(index);\r\n                    if ( oCharacter != OBJECT_SELF\r\n                         && GetHasFeat(FEAT_FORCE_CHAIN, oCharacter)\r\n                         && !Sp_BetterRelatedPowerExists( oCharacter, FORCE_POWER_RESIST_POISON_DISEASE_SONIC)) {\r\n                         Sp_RemoveRelatedPowers( oCharacter, FORCE_POWER_RESIST_POISON_DISEASE_SONIC );\r\n                         eLink1 = EffectDamageResistance(DAMAGE_TYPE_COLD, 6);\r\n                         eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_FIRE, 6));\r\n                         eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_SONIC, 6));\r\n                         eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_ELECTRICAL, 6));\r\n                         eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_BLASTER, 6));\r\n                         eLink1 = SetEffectIcon(eLink1, 26);\r\n                         eLink2 = EffectVisualEffect( VFX_PRO_RESIST_ELEMENTS);\r\n                         float fDuration = Sp_CalcDuration( 120.0 );\r\n                         Sp_ApplyEffects(FALSE, oCharacter, 0.0, 1, eLink1, fDuration, eLink2, 1.0);\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        SHOCK\r\n        */\r\n        case FORCE_POWER_SHOCK:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_ELECTRICAL;\r\n            int nDice = GetHitDice(OBJECT_SELF);\r\n            // DJS-OEI 10/7/2004\r\n            // Removed cap.\r\n            /*\r\n            if(nDice > 10)\r\n            {\r\n                nDice = 10;\r\n            }\r\n            */\r\n\r\n            // DJS-OEI 3/25/2004\r\n            SWFP_DAMAGE = Sp_CalcDamage( oTarget, nDice, 6 );\r\n            //SWFP_DAMAGE = d6(nDamage);\r\n            SP_MyPostString(IntToString(SWFP_DAMAGE),5,5,4.0);\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_ELECTRICAL;\r\n            SWFP_DAMAGE_VFX = VFX_PRO_LIGHTNING_S;\r\n            effect eDamage = EffectDamage(SWFP_DAMAGE, DAMAGE_TYPE_ELECTRICAL);\r\n            effect eDamage2 = EffectDamage(SWFP_DAMAGE/2, DAMAGE_TYPE_ELECTRICAL);\r\n\r\n            int nSaves = Sp_MySavingThrows(oTarget);\r\n            int nResist = Sp_BlockingChecks(oTarget, eDamage, eInvalid, eInvalid);\r\n            eLink1 = EffectBeam(2066, OBJECT_SELF, BODY_NODE_HAND); //P.W.(May 19, 2003) Changed to Shock beam effect.\r\n\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            if(nResist == 0)\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, fLightningDuration);\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_PRO_LIGHTNING_S), oTarget);\r\n                if(nSaves == 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage2, oTarget);\r\n                }\r\n            }\r\n            //Sp_ApplyEffects(FALSE, oTarget, 0.0, 1, eLink1, fLightningDuration, eInvalid, 0.0);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        STASIS\r\n        */\r\n        case FORCE_POWER_HOLD:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n            eLink1 = EffectParalyze();\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_HOLD));\r\n            eLink1 = SetEffectIcon(eLink1, 15);\r\n\r\n            eLink2 = EffectMovementSpeedDecrease(50);\r\n            eLink2 = EffectLinkEffects(eLink2, EffectACDecrease(4));\r\n            eLink2 = SetEffectIcon(eLink2, 15);\r\n\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            //Make Immunity Checks\r\n            int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n            if(nResist == 0)\r\n            {\r\n                // Remove any lower level or equal versions of this power.\r\n                // DJS-OEI 9/30/2004\r\n                // Since this spell has differing effects based on whether the\r\n                // saving throw succeeds or fails, we can\'t remove the related\r\n                // powers or a failed save on the second cast will override a\r\n                // succeeded save on the first cast.\r\n                //Sp_RemoveRelatedPowers( oTarget, FORCE_POWER_HOLD );\r\n\r\n                // Do not apply the effects of this power if a more powerful\r\n                // version is already attached to the target.\r\n                if( !Sp_BetterRelatedPowerExists( oTarget, FORCE_POWER_HOLD ) ) {\r\n                    float fDuration = Sp_CalcDuration( 12.0 );\r\n                    int nSaves = Sp_MySavingThrows(oTarget);\r\n                    if(nSaves == 0)\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget,fDuration);\r\n                    }\r\n                    else\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, fDuration);\r\n                    }\r\n                }\r\n            }\r\n            else\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        STASIS FIELD\r\n        */\r\n        case FORCE_POWER_SLEEP:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n\r\n            float fRange = Sp_CalcRange( 10.0 );\r\n\r\n            eLink1 = EffectParalyze();\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_HOLD));\r\n            eLink1 = SetEffectIcon(eLink1, 27);\r\n\r\n            eLink2 = EffectMovementSpeedDecrease(50);\r\n            eLink2 = EffectLinkEffects(eLink2, EffectACDecrease(4));\r\n            eLink2 = SetEffectIcon(eLink2, 27);\r\n\r\n            //oTarget = GetFirstObjectInShape(SHAPE_SPHERE, fRange, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n            oTarget = GetFirstObjectInShape(SHAPE_SPHERE, fRange, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE );\r\n            while(GetIsObjectValid(oTarget))\r\n            {\r\n                if(GetIsEnemy(oTarget) && GetRacialType(oTarget) != RACIAL_TYPE_DROID)\r\n                {\r\n                    SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                    //Make Immunity Checks\r\n                    int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n                    if(nResist == 0)\r\n                    {\r\n                        // Remove any lower level or equal versions of this power.\r\n                        // DJS-OEI 9/30/2004\r\n                        // Since this spell has differing effects based on whether the\r\n                        // saving throw succeeds or fails, we can\'t remove the related\r\n                        // powers or a failed save on the second cast will override a\r\n                        // succeeded save on the first cast.\r\n                        //Sp_RemoveRelatedPowers( oTarget, FORCE_POWER_SLEEP );\r\n\r\n                        // Do not apply the effects of this power if a more powerful\r\n                        // version is already attached to the target.\r\n                        if( !Sp_BetterRelatedPowerExists( oTarget, FORCE_POWER_SLEEP ) ) {\r\n\r\n                            float fDuration = Sp_CalcDuration( 12.0 );\r\n                            int nSaves = Sp_MySavingThrows(oTarget);\r\n                            if(nSaves == 0)\r\n                            {\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, fDuration);\r\n                            }\r\n                            else\r\n                            {\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, fDuration);\r\n                            }\r\n                        }\r\n                    }\r\n                }\r\n                //oTarget = GetNextObjectInShape(SHAPE_SPHERE, fRange, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE | OBJECT_TYPE_PLACEABLE);\r\n                oTarget = GetNextObjectInShape(SHAPE_SPHERE, fRange, GetLocation(oTarget), FALSE, OBJECT_TYPE_CREATURE );\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        SLOW\r\n        */\r\n        case FORCE_POWER_SLOW:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n\r\n            eLink1 = EffectMovementSpeedDecrease(50);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectACDecrease(2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAttackDecrease(2));\r\n            //eLink1 = EffectLinkEffects(eLink1, EffectDamageDecrease(2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowDecrease(SAVING_THROW_REFLEX,2));\r\n            eLink2 = EffectVisualEffect(VFX_PRO_AFFLICT);\r\n            eLink1 = SetEffectIcon(eLink1, 28);\r\n\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            //Make Immunity Checks\r\n            int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n            if(nResist == 0)\r\n            {\r\n                int nSaves = Sp_MySavingThrows(oTarget);\r\n                if(nSaves == 0)\r\n                {\r\n                    // Remove any lower level or equal versions of this power.\r\n                    Sp_RemoveRelatedPowers( oTarget, FORCE_POWER_SLOW );\r\n\r\n                    // Do not apply the effects of this power if a more powerful\r\n                    // version is already attached to the target.\r\n                    if( !Sp_BetterRelatedPowerExists( oTarget, FORCE_POWER_SLOW ) ) {\r\n                        float fDuration = Sp_CalcDuration( 30.0 );\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, fDuration);\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, 1.0);\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n        /*\r\n        BURST OF SPEED\r\n        */\r\n        case FORCE_POWER_SPEED_BURST:\r\n        {\r\n            // DJS-OEI 12/9/2003\r\n            // For KotOR2, we have decided to modify the application behavior\r\n            // of Force Power trees. Lower level versions of Force Powers will\r\n            // no longer overwrite higher level versions, although this means\r\n            // the caster still loses their Force Points to no effect. Also,\r\n            // casting a Force Power will remove any Force Powers of equal or\r\n            // lesser level prior to applying themselves.\r\n\r\n            float fDuration = Sp_CalcDuration( 36.0 );\r\n\r\n            // Remove any lower level or equal versions of this power.\r\n            Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_SPEED_BURST );\r\n\r\n            // Do not apply the effects of this power if a more powerful\r\n            // version is already attached to the target.\r\n            if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_SPEED_BURST ) ) {\r\n\r\n                SWFP_HARMFUL = FALSE;\r\n                eLink1 = EffectMovementSpeedIncrease(99);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectACIncrease(2));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_KNIGHTS_SPEED));\r\n                eLink1 = SetEffectIcon(eLink1, 2);\r\n                if(OBJECT_SELF == GetPartyMemberByIndex(0))\r\n                {\r\n                    eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_SPEED));\r\n                }\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, fDuration, eInvalid, 0.0);\r\n            }\r\n\r\n            //RWT-OEI 12//29/03 - Added support for the ForceChain FEAT\r\n            //  Will add this bonus to anyone else w/Force Chain for free.\r\n            if ( GetHasFeat(FEAT_FORCE_CHAIN, OBJECT_SELF) ) {\r\n                int index = 0;\r\n                for ( ; index < 3; ++index ) {\r\n                    object oCharacter = GetPartyMemberByIndex(index);\r\n                    if ( oCharacter != OBJECT_SELF\r\n                         && GetHasFeat(FEAT_FORCE_CHAIN, oCharacter)\r\n                         && !Sp_BetterRelatedPowerExists( oCharacter, FORCE_POWER_SPEED_BURST)) {\r\n                            Sp_RemoveRelatedPowers( oCharacter, FORCE_POWER_SPEED_BURST );\r\n                            eLink2 = EffectMovementSpeedIncrease(99);\r\n                            eLink2 = EffectLinkEffects(eLink2, EffectACIncrease(2));\r\n                            eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(VFX_DUR_SPEED));\r\n                            eLink2 = SetEffectIcon(eLink2, 2);\r\n                            Sp_ApplyEffects(FALSE, oCharacter, 0.0, 1, eLink2, fDuration, eInvalid, 0.0);\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        MASTER SPEED\r\n        */\r\n        case FORCE_POWER_SPEED_MASTERY:\r\n        {\r\n            // DJS-OEI 12/9/2003\r\n            // For KotOR2, we have decided to modify the application behavior\r\n            // of Force Power trees. Lower level versions of Force Powers will\r\n            // no longer overwrite higher level versions, although this means\r\n            // the caster still loses their Force Points to no effect. Also,\r\n            // casting a Force Power will remove any Force Powers of equal or\r\n            // lesser level prior to applying themselves.\r\n\r\n            float fDuration = Sp_CalcDuration( 36.0 );\r\n\r\n            // Remove any lower level or equal versions of this power.\r\n            Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_SPEED_MASTERY );\r\n\r\n            // Do not apply the effects of this power if a more powerful\r\n            // version is already attached to the target.\r\n            if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_SPEED_MASTERY ) ) {\r\n\r\n                SWFP_HARMFUL = FALSE;\r\n                eLink1 = EffectMovementSpeedIncrease(99);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectACIncrease(4));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectModifyAttacks(2));\r\n                eLink1 = SetEffectIcon(eLink1, 22);\r\n\r\n                if(OBJECT_SELF == GetPartyMemberByIndex(0))\r\n                {\r\n                    eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_SPEED));\r\n                    //eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_IMP_SPEED_MASTERY));\r\n                }\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, fDuration, eInvalid, 0.0);\r\n            }\r\n\r\n            //RWT-OEI 12//29/03 - Added support for the ForceChain FEAT\r\n            //  Will add this bonus to anyone else w/Force Chain for free.\r\n            if ( GetHasFeat(FEAT_FORCE_CHAIN, OBJECT_SELF) ) {\r\n                int index = 0;\r\n                for ( ; index < 3; ++index ) {\r\n                    object oCharacter = GetPartyMemberByIndex(index);\r\n                    if ( oCharacter != OBJECT_SELF\r\n                         && GetHasFeat(FEAT_FORCE_CHAIN, oCharacter)\r\n                         && !Sp_BetterRelatedPowerExists( oCharacter, FORCE_POWER_SPEED_MASTERY)) {\r\n\r\n                            Sp_RemoveRelatedPowers( oCharacter, FORCE_POWER_SPEED_MASTERY );\r\n                            eLink2 = EffectMovementSpeedIncrease(99);\r\n                            eLink2 = EffectLinkEffects(eLink2, EffectACIncrease(4));\r\n                            eLink2 = EffectLinkEffects(eLink2, EffectModifyAttacks(2));\r\n                            eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(VFX_DUR_SPEED));\r\n                            eLink2 = SetEffectIcon(eLink2, 22);\r\n                            Sp_ApplyEffects(FALSE, oCharacter, 0.0, 1, eLink2, fDuration, eInvalid, 0.0);\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        STUN\r\n        */\r\n        case FORCE_POWER_STUN:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_MIND_AFFECTING;\r\n\r\n            eLink1 = EffectStunned();\r\n            //eLink1 = EffectLinkEffects(eLink1, EffectVisualEffect(VFX_DUR_HOLD));\r\n            eLink1 = SetEffectIcon(eLink1, 29);\r\n\r\n            eLink2 = EffectMovementSpeedDecrease(50);\r\n            eLink2 = EffectLinkEffects(eLink2, EffectACDecrease(4));\r\n            eLink1 = SetEffectIcon(eLink1, 29);\r\n\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            //Make Immunity Checks\r\n            int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n            int nSaves;\r\n            if(nResist == 0)\r\n            {\r\n                // Remove any lower level or equal versions of this power.\r\n                Sp_RemoveRelatedPowers( oTarget, FORCE_POWER_STUN );\r\n\r\n                // Do not apply the effects of this power if a more powerful\r\n                // version is already attached to the target.\r\n                if( !Sp_BetterRelatedPowerExists( oTarget, FORCE_POWER_STUN ) ) {\r\n\r\n                    float fDuration = Sp_CalcDuration( 9.0 );\r\n                    nSaves = Sp_MySavingThrows(oTarget);\r\n                    if(nSaves == 0)\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, fDuration);\r\n                    }\r\n                    else\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, fDuration);\r\n                    }\r\n                }\r\n            }\r\n            if(nResist > 0 || nSaves > 0)\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n        }\r\n        break;\r\n\r\n        /*\r\n        SUPRESS FORCE\r\n        */\r\n        case FORCE_POWER_SUPRESS_FORCE:\r\n        {\r\n            effect eBuff = GetFirstEffect(oTarget);\r\n            int bValid = FALSE;\r\n            while(GetIsEffectValid(eBuff))\r\n            {\r\n                if(GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_AURA ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_SHIELD ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_MIND ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_KNIGHT_MIND ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_SPEED_BURST ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_KNIGHT_SPEED ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_RESIST_FORCE ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_RESIST_POISON_DISEASE_SONIC ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_FORCE_BARRIER ||\r\n                   GetEffectSpellId(eBuff) == FORCE_POWER_IMPROVED_FORCE_BARRIER )\r\n                 {\r\n                    RemoveEffect(oTarget, eBuff);\r\n                 }\r\n                 eBuff = GetNextEffect(oTarget);\r\n            }\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId()));\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_FORCE_BREACH), oTarget);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        WOUND\r\n        */\r\n        case FORCE_POWER_WOUND:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_FORT;\r\n\r\n            // DJS-OEI 3/25/2004\r\n            SWFP_DAMAGE = Sp_CalcDamage( oTarget, 0, 0, (GetHitDice(OBJECT_SELF)*2)/3 );\r\n            //SWFP_DAMAGE = (GetHitDice(OBJECT_SELF)*2)/3;\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;\r\n\r\n            effect eChoke = EffectChoke();\r\n            eChoke = SetEffectIcon(eChoke, 31);\r\n            effect eDamage = EffectDamage(SWFP_DAMAGE, SWFP_DAMAGE_TYPE);\r\n\r\n            int nResist = Sp_BlockingChecks(oTarget, eChoke, eDamage, eInvalid);\r\n            int nSaves;\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            if(nResist == 0)\r\n            {\r\n                nSaves = Sp_MySavingThrows(oTarget);\r\n                if(nSaves == 0)\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_CHOKE), oTarget);\r\n                    ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eChoke, oTarget, 6.0);\r\n                    int nIdx = 1;\r\n                    float fDelay;\r\n                    SP_InterativeDamage(eDamage, 7, oTarget);\r\n                }\r\n            }\r\n            if(nResist > 0 || nSaves > 0)\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n            }\r\n        }\r\n        break;\r\n\r\n        //\r\n        // Force Sight\r\n        //\r\n        case FORCE_POWER_FORCE_SIGHT:\r\n        {\r\n            float fDuration = Sp_CalcDuration( 20.0 );\r\n\r\n            // Remove any lower level or equal versions of this power.\r\n            Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_FORCE_SIGHT );\r\n\r\n            // Do not apply the effects of this power if a more powerful\r\n            // version is already attached to the target.\r\n            if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_FORCE_SIGHT ) ) {\r\n\r\n                SWFP_HARMFUL = FALSE;\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, EffectForceSight(), fDuration, eInvalid, 0.0);\r\n            }\r\n        }\r\n        break;\r\n\r\n        case SPECIAL_ABILITY_BODY_FUEL:\r\n        {\r\n            effect eBody = EffectBodyFuel();\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBody, OBJECT_SELF, 30.0);\r\n        }\r\n        break;\r\n        case SPECIAL_ABILITY_ENHANCED_SENSES:\r\n        {\r\n            effect eAC = EffectACDecrease(6);\r\n            effect eAware = EffectSkillIncrease(SKILL_AWARENESS, 10);\r\n            effect eSee = EffectTrueSeeing();\r\n            eLink1 = EffectLinkEffects(eAC, eAware);\r\n            eLink1 = EffectLinkEffects(eLink1, eAware);\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, OBJECT_SELF, RoundsToSeconds(10));\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_MIND_FORCE), OBJECT_SELF);\r\n        }\r\n        break;\r\n\r\n        case SPECIAL_ABILITY_PSYCHIC_STANCE:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_MIND_AFFECTING;\r\n\r\n            eLink1 = EffectPsychicStatic();\r\n            Sp_ApplyEffects(TRUE, oTarget, 10.0, 1000, eLink1, 20.0, eInvalid, 0.0);\r\n        }\r\n        break;\r\n\r\n        /*\r\n        Rage\r\n        This ability allows Zaalbar to fly into a rage.\r\n        When Zaalbar flies into a rage he gains +4 to his Strength and Constitution.  He also gains a +2 bonus on\r\n        Fortitude and Will saves.  While raging Zaalbar cannot use any skills.  He also has a -4 penalty to his Defense rating.\r\n        Interface: Mystical.  It takes one round to initiate the rage.\r\n        Prerequisites: Nothing.  This is a unique NPC power.\r\n        */\r\n        case SPECIAL_ABILITY_RAGE:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_FORT, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_WILL, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_CONSTITUTION, 4));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAbilityIncrease(ABILITY_STRENGTH, 4));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectACDecrease(4));\r\n\r\n            Sp_ApplyEffects(TRUE, OBJECT_SELF, 0.0, 1, eLink1, 30.0, eInvalid, 0.0);\r\n        }\r\n        break;\r\n\r\n        case 83: //Monster Slam Attack\r\n        {\r\n            SP_MyPrintString("I am attempting to use monster slam");\r\n\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_REFLEX;\r\n            SWFP_DAMAGE = GetHitDice(OBJECT_SELF);\r\n            SWFP_DAMAGE_TYPE = DAMAGE_TYPE_BLUDGEONING;\r\n\r\n            eLink1 = EffectForcePushed();\r\n            eLink2 = EffectStunned();\r\n            effect eDamage = EffectDamage(GetHitDice(OBJECT_SELF), SWFP_DAMAGE_TYPE);\r\n\r\n            if(!ReflexSave(oTarget, 15))\r\n            {\r\n                eDamage = EffectDamage(GetHitDice(OBJECT_SELF), SWFP_DAMAGE_TYPE);\r\n                DelayCommand(0.5, SP_MyApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget));\r\n                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 0.25);\r\n                DelayCommand(2.55, SP_MyApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, 3.0));\r\n            }\r\n            else\r\n            {\r\n                int nApply;\r\n                // DJS-OEI 11/20/2003\r\n                // If the target has the Evasion feat, the damage on a successful\r\n                // Reflex save is 0. Otherwise, it\'s half the original damage.\r\n                if( GetHasFeat( FEAT_EVASION, oTarget ) ) {\r\n                    nApply = 0;\r\n                }\r\n                else {\r\n                    nApply = GetHitDice(OBJECT_SELF)/2;\r\n                }\r\n                eDamage = EffectDamage(nApply, SWFP_DAMAGE_TYPE);\r\n                DelayCommand(0.5, SP_MyApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oTarget, 0.25));\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, eDamage, oTarget);\r\n                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(VFX_IMP_FORCE_PUSH), oTarget);\r\n\r\n            }\r\n        }\r\n        break;\r\n\r\n        case 130: //Fire Breath Weapon\r\n        {\r\n            oTarget = GetSpellTargetObject();\r\n            int nDC = 15;\r\n            int nDamage = 40;\r\n            effect eBeam = EffectBeam(2053, OBJECT_SELF, BODY_NODE_HEAD);\r\n            effect eVFX = EffectVisualEffect(1039);\r\n            effect eBump = EffectVisualEffect(2062);\r\n            effect eHorror = EffectHorrified();\r\n            eHorror = SetEffectIcon(eHorror, 57);\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, eVFX, oTarget);\r\n            ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBeam, oTarget, 1.0);\r\n            if(GetHitDice(oTarget) < 7 || FortitudeSave(oTarget, 15) == FALSE)\r\n            {\r\n                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eHorror, oTarget, 3.0);\r\n            }\r\n            DelayCommand(0.33, SP_MyApplyEffectToObject(DURATION_TYPE_TEMPORARY, eBump, oTarget, 1.5));\r\n            if(ReflexSave(oTarget, nDC, SAVING_THROW_TYPE_FIRE))\r\n            {\r\n                // DJS-OEI 11/20/2003\r\n                // If the target has the Evasion feat, the damage on a successful\r\n                // Reflex save is 0. Otherwise, it\'s half the original damage.\r\n                if( GetHasFeat( FEAT_EVASION, oTarget ) ) {\r\n                    nDamage = 0;\r\n                }\r\n                else {\r\n                    nDamage /= 2;\r\n                }\r\n            }\r\n            effect eDam = EffectDamage(nDamage, DAMAGE_TYPE_FIRE);\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, eDam, oTarget);\r\n        }\r\n        break;\r\n\r\n        case 131:   // Sonic Howl\r\n        {\r\n            // DJS-OEI 9/27/2004\r\n            // This is basically just Master Force Scream.\r\n            /*\r\n            int nVFX = 3002;\r\n            int nDC = 15;\r\n            effect eDex = EffectAbilityDecrease(ABILITY_DEXTERITY, 3);\r\n            eDex = SetEffectIcon(eDex, 106);\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(nVFX), OBJECT_SELF);\r\n            oTarget = GetFirstObjectInShape(SHAPE_SPHERE, 10.0, GetSpellTargetLocation());\r\n            while(GetIsObjectValid(oTarget))\r\n            {\r\n                if(GetIsEnemy(oTarget))\r\n                {\r\n                    if(!FortitudeSave(oTarget, nDC, SAVING_THROW_TYPE_SONIC))\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eDex, oTarget, 30.0);\r\n                    }\r\n                }\r\n                oTarget = GetNextObjectInShape(SHAPE_SPHERE, 4.0, GetSpellTargetLocation());\r\n            }\r\n            */\r\n            // Force Scream and Improved Force Scream both affect\r\n            // targets in a cone extending from the caster\'s location.\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_SONIC;\r\n\r\n            // Each version of the spell causes differing amounts of damage.\r\n            int nDamageRolls;\r\n            int nAttributeDamage;\r\n            int nIconID;\r\n            int nShape;\r\n            float fShapeSize;\r\n            int nVFXID;\r\n\r\n                nDamageRolls = 7;\r\n                nAttributeDamage = 6;\r\n                nIconID = 113;\r\n                nShape = SHAPE_SPHERE;\r\n                // DJS-OEI 1/14/2004\r\n                // Increase the range slightly. Since the range for this spell\r\n                // is 10m, the pathing system fudging will in some cases not\r\n                // cuase any valid targets to be within 10m to get damaged.\r\n                //fShapeSize = Sp_CalcRange( 10.0 );\r\n                fShapeSize = Sp_CalcRange( 12.0 );\r\n                nVFXID = 9007;\r\n\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect( nVFXID ), OBJECT_SELF);\r\n\r\n            object oTarget = GetFirstObjectInShape(nShape, fShapeSize, GetLocation(OBJECT_SELF), TRUE, OBJECT_TYPE_CREATURE );\r\n            while(GetIsObjectValid(oTarget))\r\n            {\r\n                int nTotalDamage = Sp_CalcDamage( oTarget, nDamageRolls, 6 );\r\n\r\n                // Create the damage effects.\r\n                eLink1 = EffectDamage( nTotalDamage, DAMAGE_TYPE_SONIC );\r\n                eLink2 = EffectAbilityDecrease(ABILITY_STRENGTH, nAttributeDamage);\r\n                eLink2 = EffectLinkEffects(eLink2, EffectAbilityDecrease(ABILITY_DEXTERITY, nAttributeDamage));\r\n                eLink2 = EffectLinkEffects(eLink2, EffectAbilityDecrease(ABILITY_INTELLIGENCE, nAttributeDamage));\r\n                eLink2 = EffectLinkEffects(eLink2, EffectAbilityDecrease(ABILITY_WISDOM, nAttributeDamage));\r\n                eLink2 = EffectLinkEffects(eLink2, EffectAbilityDecrease(ABILITY_CHARISMA, nAttributeDamage));\r\n                eLink2 = EffectLinkEffects(eLink2, EffectAbilityDecrease(ABILITY_CONSTITUTION, nAttributeDamage));\r\n                eLink2 = SetEffectIcon(eLink2, nIconID);\r\n\r\n                // Check resistances.\r\n                int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n                SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                if( ( GetRacialType(oTarget) != RACIAL_TYPE_DROID ) &&\r\n                    GetIsEnemy(oTarget) )\r\n                {\r\n                    if(nResist == 0)\r\n                    {\r\n                        int nSaves = Sp_MySavingThrows(oTarget, 20);\r\n                        if(nSaves <= 0)\r\n                        {\r\n                            // Apply physical damage effect to the target.\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eLink1, oTarget);\r\n\r\n                            // Remove any lower level or equal versions of this power.\r\n                            Sp_RemoveRelatedPowers( oTarget, GetSpellId() );\r\n\r\n                            // Do not apply the effects of this power if a more powerful\r\n                            // version is already attached to the target.\r\n                            if( !Sp_BetterRelatedPowerExists( oTarget, GetSpellId() ) ) {\r\n\r\n                                // Apply the attribute damage effect.\r\n                                float fDuration = Sp_CalcDuration( 30.0 );\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, fDuration);\r\n                            }\r\n                        }\r\n                        else {\r\n                            int nApply;\r\n                            // DJS-OEI 11/20/2003\r\n                            // If the target has the Evasion feat, the damage on a successful\r\n                            // save is 0. Otherwise, it\'s half the original damage.\r\n                            if( GetHasFeat( FEAT_EVASION, oTarget ) ) {\r\n                                nApply = 0;\r\n                            }\r\n                            else {\r\n                                nApply = nTotalDamage/2;\r\n                            }\r\n\r\n                            if( nApply > 0 ) {\r\n                                // The target saved, so the attribute damage is ignored.\r\n                                // Rebuild the damage effect with the new damage.\r\n                                eLink1 = EffectDamage( nApply, DAMAGE_TYPE_SONIC );\r\n                                ApplyEffectToObject(DURATION_TYPE_INSTANT, eLink1, oTarget);\r\n                            }\r\n                        }\r\n                    }\r\n                    else\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                    }\r\n                }\r\n                oTarget = GetNextObjectInShape(nShape, fShapeSize, GetLocation(OBJECT_SELF), TRUE, OBJECT_TYPE_CREATURE );\r\n            }\r\n        }\r\n        break;\r\n\r\n        // DJS-OEI 12/11/2003\r\n        case FORCE_POWER_FORCE_BARRIER:\r\n        {\r\n            // Remove any lower level or equal versions of this power.\r\n            Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_FORCE_BARRIER );\r\n\r\n            // Do not apply the effects of this power if a more powerful\r\n            // version is already attached to the target.\r\n            if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_FORCE_BARRIER ) ) {\r\n\r\n                SWFP_HARMFUL = FALSE;\r\n                eLink1 = EffectDamageResistance(DAMAGE_TYPE_BLUDGEONING, 4);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_PIERCING, 4));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_SLASHING, 4));\r\n                eLink1 = SetEffectIcon(eLink1, 64);\r\n                eLink2 = EffectVisualEffect(VFX_PRO_FORCE_ARMOR);\r\n                eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(VFX_PRO_FORCE_SHIELD));\r\n\r\n                float fDuration = Sp_CalcDuration( 30.0 );\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, fDuration, eLink2, 3.0);\r\n            }\r\n\r\n            //RWT-OEI 12//29/03 - Added support for the ForceChain FEAT\r\n            //  Will add this bonus to anyone else w/Force Chain for free.\r\n            if ( GetHasFeat(FEAT_FORCE_CHAIN, OBJECT_SELF) ) {\r\n                int index = 0;\r\n                for ( ; index < 3; ++index ) {\r\n                    object oCharacter = GetPartyMemberByIndex(index);\r\n                    if ( oCharacter != OBJECT_SELF\r\n                         && GetHasFeat(FEAT_FORCE_CHAIN, oCharacter)\r\n                         && !Sp_BetterRelatedPowerExists( oCharacter, FORCE_POWER_FORCE_BARRIER)) {\r\n                         Sp_RemoveRelatedPowers( oCharacter, FORCE_POWER_FORCE_BARRIER );\r\n                         eLink1 = EffectDamageResistance(DAMAGE_TYPE_BLUDGEONING, 4);\r\n                         eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_PIERCING, 4));\r\n                         eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_SLASHING, 4));\r\n                         eLink1 = SetEffectIcon(eLink1, 64);\r\n                         eLink2 = EffectVisualEffect(VFX_PRO_FORCE_ARMOR);\r\n                         eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(VFX_PRO_FORCE_SHIELD));\r\n\r\n                         float fDuration = Sp_CalcDuration( 30.0 );\r\n                         Sp_ApplyEffects(FALSE, oCharacter, 0.0, 1, eLink1, fDuration, eLink2, 3.0);\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        // DJS-OEI 12/11/2003\r\n        case FORCE_POWER_IMPROVED_FORCE_BARRIER:\r\n        {\r\n            // Remove any lower level or equal versions of this power.\r\n            Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_IMPROVED_FORCE_BARRIER );\r\n\r\n            // Do not apply the effects of this power if a more powerful\r\n            // version is already attached to the target.\r\n            if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_IMPROVED_FORCE_BARRIER ) ) {\r\n\r\n                SWFP_HARMFUL = FALSE;\r\n                eLink1 = EffectDamageResistance(DAMAGE_TYPE_BLUDGEONING, 8);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_PIERCING, 8));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_SLASHING, 8));\r\n                eLink1 = SetEffectIcon(eLink1, 65);\r\n                eLink2 = EffectVisualEffect(VFX_PRO_FORCE_ARMOR);\r\n                eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(VFX_PRO_FORCE_SHIELD));\r\n\r\n                float fDuration = Sp_CalcDuration( 45.0 );\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, fDuration, eLink2, 3.0);\r\n            }\r\n            //RWT-OEI 12//29/03 - Added support for the ForceChain FEAT\r\n            //  Will add this bonus to anyone else w/Force Chain for free.\r\n            if ( GetHasFeat(FEAT_FORCE_CHAIN, OBJECT_SELF) ) {\r\n                int index = 0;\r\n                for ( ; index < 3; ++index ) {\r\n                    object oCharacter = GetPartyMemberByIndex(index);\r\n                    if ( oCharacter != OBJECT_SELF\r\n                         && GetHasFeat(FEAT_FORCE_CHAIN, oCharacter)\r\n                         && !Sp_BetterRelatedPowerExists( oCharacter, FORCE_POWER_IMPROVED_FORCE_BARRIER)) {\r\n                         Sp_RemoveRelatedPowers( oCharacter, FORCE_POWER_IMPROVED_FORCE_BARRIER );\r\n                         eLink1 = EffectDamageResistance(DAMAGE_TYPE_BLUDGEONING, 8);\r\n                         eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_PIERCING, 8));\r\n                         eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_SLASHING, 8));\r\n                         eLink1 = SetEffectIcon(eLink1, 65);\r\n                         eLink2 = EffectVisualEffect(VFX_PRO_FORCE_ARMOR);\r\n                         eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(VFX_PRO_FORCE_SHIELD));\r\n\r\n                         float fDuration = Sp_CalcDuration( 45.0 );\r\n                         Sp_ApplyEffects(FALSE, oCharacter, 0.0, 1, eLink1, fDuration, eLink2, 3.0);\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        // DJS-OEI 12/11/2003\r\n        case FORCE_POWER_MASTER_FORCE_BARRIER:\r\n        {\r\n            // Remove any lower level or equal versions of this power.\r\n            Sp_RemoveRelatedPowers( OBJECT_SELF, FORCE_POWER_MASTER_FORCE_BARRIER );\r\n\r\n            // Do not apply the effects of this power if a more powerful\r\n            // version is already attached to the target.\r\n            if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, FORCE_POWER_MASTER_FORCE_BARRIER ) ) {\r\n\r\n                SWFP_HARMFUL = FALSE;\r\n                eLink1 = EffectDamageResistance(DAMAGE_TYPE_BLUDGEONING, 15);\r\n                eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_PIERCING, 15));\r\n                eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_SLASHING, 15));\r\n                eLink1 = SetEffectIcon(eLink1, 66);\r\n                eLink2 = EffectVisualEffect(VFX_PRO_FORCE_ARMOR);\r\n                eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(VFX_PRO_FORCE_SHIELD));\r\n\r\n                float fDuration = Sp_CalcDuration( 60.0 );\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, fDuration, eLink2, 3.0);\r\n            }\r\n            //RWT-OEI 12//29/03 - Added support for the ForceChain FEAT\r\n            //  Will add this bonus to anyone else w/Force Chain for free.\r\n            if ( GetHasFeat(FEAT_FORCE_CHAIN, OBJECT_SELF) ) {\r\n                int index = 0;\r\n                for ( ; index < 3; ++index ) {\r\n                    object oCharacter = GetPartyMemberByIndex(index);\r\n                    if ( oCharacter != OBJECT_SELF\r\n                         && GetHasFeat(FEAT_FORCE_CHAIN, oCharacter)\r\n                         && !Sp_BetterRelatedPowerExists( oCharacter, FORCE_POWER_MASTER_FORCE_BARRIER)) {\r\n                         Sp_RemoveRelatedPowers( oCharacter, FORCE_POWER_MASTER_FORCE_BARRIER );\r\n                         eLink1 = EffectDamageResistance(DAMAGE_TYPE_BLUDGEONING, 15);\r\n                         eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_PIERCING, 15));\r\n                         eLink1 = EffectLinkEffects(eLink1, EffectDamageResistance(DAMAGE_TYPE_SLASHING, 15));\r\n                         eLink1 = SetEffectIcon(eLink1, 66);\r\n                         eLink2 = EffectVisualEffect(VFX_PRO_FORCE_ARMOR);\r\n                         eLink2 = EffectLinkEffects(eLink2, EffectVisualEffect(VFX_PRO_FORCE_SHIELD));\r\n\r\n                         float fDuration = Sp_CalcDuration( 60.0 );\r\n                         Sp_ApplyEffects(FALSE, oCharacter, 0.0, 1, eLink1, fDuration, eLink2, 3.0);\r\n                    }\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        // DJS-OEI 12/12/2003\r\n        // Only PCs, NPCs, and Friendly Allies should cast these\r\n        // versions of Battle Meditation. That way, only allies will\r\n        // get bonuses with this spell ID and only targets will get\r\n        // penalties with this spell ID.\r\n        case FORCE_POWER_BATTLE_MEDITATION_PC:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n\r\n            // Bonuses\r\n            eLink1 = EffectDamageIncrease(2, DAMAGE_TYPE_UNIVERSAL);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAttackIncrease(2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_WILL, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVPRegenModifier( 50 ) );\r\n            eLink1 = SetEffectIcon(eLink1, 67);\r\n\r\n            int nCnt = 0;\r\n            float fDuration = Sp_CalcDuration( 20.0 );\r\n\r\n            object oParty;\r\n            if(IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                // The caster is a party member. Apply the benefits\r\n                // to the each member of the party.\r\n                oParty = GetPartyMemberByIndex(nCnt);\r\n            }\r\n            else\r\n            {\r\n                // The caster is not a party member. Apply the benefits\r\n                // to the closest three allies.\r\n                oParty = OBJECT_SELF;\r\n            }\r\n\r\n            while(nCnt < 3)\r\n            {\r\n                if( GetIsObjectValid(oParty) &&\r\n                    GetRacialType(oParty) != RACIAL_TYPE_DROID )\r\n                {\r\n                    SignalEvent(oParty, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    // Remove any lower level or equal versions of this power.\r\n                    Sp_RemoveRelatedPowers( oParty, FORCE_POWER_BATTLE_MEDITATION_PC );\r\n\r\n                    // Do not apply the effects of this power if a more powerful\r\n                    // version is already attached to the target.\r\n                    if( !Sp_BetterRelatedPowerExists( oParty, FORCE_POWER_BATTLE_MEDITATION_PC ) ) {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(9000), oParty);\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oParty, fDuration);\r\n                    }\r\n                }\r\n                nCnt++;\r\n                if(IsObjectPartyMember(OBJECT_SELF))\r\n                {\r\n                   oParty = GetPartyMemberByIndex(nCnt);\r\n                }\r\n                else\r\n                {\r\n                   oParty = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, OBJECT_SELF, nCnt);\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        case FORCE_POWER_IMPROVED_BATTLE_MEDITATION_PC:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n\r\n            // Bonuses\r\n            eLink1 = EffectDamageIncrease(2);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAttackIncrease(2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_WILL, 2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVPRegenModifier( 50 ) );\r\n            eLink1 = SetEffectIcon(eLink1, 68);\r\n\r\n            int nCnt = 0;\r\n            float fDuration = Sp_CalcDuration( 20.0 );\r\n\r\n            object oParty;\r\n            if(IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                // The caster is a party member. Apply the benefits\r\n                // to the each member of the party.\r\n                oParty = GetPartyMemberByIndex(nCnt);\r\n            }\r\n            else\r\n            {\r\n                // The caster is not a party member. Apply the benefits\r\n                // to the closest three allies.\r\n                oParty = OBJECT_SELF;\r\n            }\r\n\r\n            //tIterae over all targets of the beneficial effects and\r\n            // apply them.\r\n            while(nCnt < 3)\r\n            {\r\n                if( GetIsObjectValid(oParty) &&\r\n                    GetRacialType(oParty) != RACIAL_TYPE_DROID )\r\n                {\r\n                    SignalEvent(oParty, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    // Remove any lower level or equal versions of this power.\r\n                    Sp_RemoveRelatedPowers( oParty, FORCE_POWER_IMPROVED_BATTLE_MEDITATION_PC );\r\n\r\n                    // Do not apply the effects of this power if a more powerful\r\n                    // version is already attached to the target.\r\n                    if( !Sp_BetterRelatedPowerExists( oParty, FORCE_POWER_IMPROVED_BATTLE_MEDITATION_PC ) ) {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(9001), oParty);\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oParty, fDuration);\r\n                    }\r\n                }\r\n                nCnt++;\r\n                if(IsObjectPartyMember(OBJECT_SELF))\r\n                {\r\n                   oParty = GetPartyMemberByIndex(nCnt);\r\n                }\r\n                else\r\n                {\r\n                   oParty = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, OBJECT_SELF, nCnt);\r\n                }\r\n            }\r\n\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_SHAPE = SHAPE_SPHERE;\r\n\r\n            // Penalties\r\n            eLink1 = EffectDamageDecrease(2);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAttackDecrease(2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowDecrease(SAVING_THROW_WILL, 2));\r\n            eLink1 = SetEffectIcon(eLink1, 68);\r\n\r\n            // Iterate over all targets of the detrimental effects and\r\n            // apply them.\r\n            // Get each creature within 10.0 units.\r\n            object oCreature = GetFirstObjectInShape(SWFP_SHAPE, 10.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            while(GetIsObjectValid(oCreature))\r\n            {\r\n                // This power targets hostile creatures only.\r\n                if( GetIsObjectValid(oCreature) &&\r\n                    GetIsEnemy(oCreature) &&\r\n                    GetRacialType(oCreature) != RACIAL_TYPE_DROID )\r\n                {\r\n                    SignalEvent(oCreature, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    //Make Immunity Checks\r\n                    int nResist = Sp_BlockingChecks(oCreature, eLink1, eInvalid, eInvalid);\r\n                    if(nResist == 0)\r\n                    {\r\n                        int nSaves = Sp_MySavingThrows(oCreature);\r\n                        if(nSaves == 0)\r\n                        {\r\n                            // Remove any lower level or equal versions of this power.\r\n                            Sp_RemoveRelatedPowers( oCreature, FORCE_POWER_IMPROVED_BATTLE_MEDITATION_PC );\r\n\r\n                            // Do not apply the effects of this power if a more powerful\r\n                            // version is already attached to the target.\r\n                            if( !Sp_BetterRelatedPowerExists( oCreature, FORCE_POWER_IMPROVED_BATTLE_MEDITATION_PC ) ) {\r\n                                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(9003), oCreature);\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oCreature, fDuration);\r\n                            }\r\n                        }\r\n                    }\r\n                }\r\n                oCreature = GetNextObjectInShape(SWFP_SHAPE, 10.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            }\r\n        }\r\n        break;\r\n\r\n        case FORCE_POWER_MASTER_BATTLE_MEDITATION_PC:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n\r\n            // Bonuses\r\n            eLink1 = EffectDamageIncrease(4);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAttackIncrease(4));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_WILL, 4));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectVPRegenModifier( 50 ) );\r\n            eLink1 = SetEffectIcon(eLink1, 69);\r\n\r\n            int nCnt = 0;\r\n            float fDuration = Sp_CalcDuration( 20.0 );\r\n\r\n            object oParty;\r\n            if(IsObjectPartyMember(OBJECT_SELF))\r\n            {\r\n                // The caster is a party member. Apply the benefits\r\n                // to the each member of the party.\r\n                oParty = GetPartyMemberByIndex(nCnt);\r\n            }\r\n            else\r\n            {\r\n                // The caster is not a party member. Apply the benefits\r\n                // to the closest three allies.\r\n                oParty = OBJECT_SELF;\r\n            }\r\n\r\n            // Iterate over all targets of the beneficial effects and\r\n            // apply them.\r\n            while(nCnt < 3)\r\n            {\r\n                if( GetIsObjectValid(oParty) &&\r\n                    GetRacialType(oParty) != RACIAL_TYPE_DROID )\r\n                {\r\n                    SignalEvent(oParty, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    // Remove any lower level or equal versions of this power.\r\n                    Sp_RemoveRelatedPowers( oParty, FORCE_POWER_MASTER_BATTLE_MEDITATION_PC );\r\n\r\n                    // Do not apply the effects of this power if a more powerful\r\n                    // version is already attached to the target.\r\n                    if( !Sp_BetterRelatedPowerExists( oParty, FORCE_POWER_MASTER_BATTLE_MEDITATION_PC ) ) {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(9002), oParty);\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oParty, fDuration);\r\n                    }\r\n                }\r\n                nCnt++;\r\n                if(IsObjectPartyMember(OBJECT_SELF))\r\n                {\r\n                   oParty = GetPartyMemberByIndex(nCnt);\r\n                }\r\n                else\r\n                {\r\n                   oParty = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, OBJECT_SELF, nCnt);\r\n                }\r\n            }\r\n\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_SHAPE = SHAPE_SPHERE;\r\n\r\n            // Penalties\r\n            eLink1 = EffectDamageDecrease(4);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAttackDecrease(4));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowDecrease(SAVING_THROW_WILL, 4));\r\n            eLink1 = SetEffectIcon(eLink1, 69);\r\n\r\n            // Iterate over all targets of the detrimental effects and\r\n            // apply them.\r\n            // Get each creature within 15.0 units.\r\n            object oCreature = GetFirstObjectInShape(SWFP_SHAPE, 15.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            while(GetIsObjectValid(oCreature))\r\n            {\r\n                // This power targets hostile creatures only.\r\n                if( GetIsObjectValid(oCreature) &&\r\n                    GetIsEnemy(oCreature) &&\r\n                    GetRacialType(oCreature) != RACIAL_TYPE_DROID )\r\n                {\r\n                    SignalEvent(oCreature, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    //Make Immunity Checks\r\n                    int nResist = Sp_BlockingChecks(oCreature, eLink1, eInvalid, eInvalid);\r\n                    if(nResist == 0)\r\n                    {\r\n                        int nSaves = Sp_MySavingThrows(oCreature);\r\n                        if(nSaves == 0)\r\n                        {\r\n                            // Remove any lower level or equal versions of this power.\r\n                            Sp_RemoveRelatedPowers( oCreature, FORCE_POWER_MASTER_BATTLE_MEDITATION_PC );\r\n\r\n                            // Do not apply the effects of this power if a more powerful\r\n                            // version is already attached to the target.\r\n                            if( !Sp_BetterRelatedPowerExists( oCreature, FORCE_POWER_MASTER_BATTLE_MEDITATION_PC ) ) {\r\n                                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(9004), oCreature);\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oCreature, fDuration);\r\n                            }\r\n                        }\r\n                    }\r\n                }\r\n                oCreature = GetNextObjectInShape(SWFP_SHAPE, 15.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            }\r\n        }\r\n        break;\r\n\r\n        // DJS-OEI 12/12/2003\r\n        // Only enemies of the PC party should cast these\r\n        // versions of Battle Meditation. That way, only enemies will\r\n        // get bonuses with this spell ID and only "allied" targets will get\r\n        // penalties with this spell ID.\r\n        case FORCE_POWER_BAT_MED_ENEMY:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n\r\n            // Bonuses\r\n            eLink1 = EffectDamageIncrease(2, DAMAGE_TYPE_UNIVERSAL);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAttackIncrease(2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_WILL, 2));\r\n            eLink1 = SetEffectIcon(eLink1, 107);\r\n\r\n            int nCnt = 0;\r\n            float fDuration = Sp_CalcDuration( 20.0 );\r\n\r\n            //Apply the benefits to the closest three allies.\r\n            object oParty = OBJECT_SELF;\r\n            while(nCnt < 3)\r\n            {\r\n                if( GetIsObjectValid(oParty) &&\r\n                    GetRacialType(oParty) != RACIAL_TYPE_DROID )\r\n                {\r\n                    SignalEvent(oParty, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    // Remove any lower level or equal versions of this power.\r\n                    Sp_RemoveRelatedPowers( oParty, FORCE_POWER_BAT_MED_ENEMY );\r\n\r\n                    // Do not apply the effects of this power if a more powerful\r\n                    // version is already attached to the target.\r\n                    if( !Sp_BetterRelatedPowerExists( oParty, FORCE_POWER_BAT_MED_ENEMY ) ) {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(9000), oParty);\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oParty, fDuration);\r\n                    }\r\n                }\r\n                nCnt++;\r\n                oParty = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, OBJECT_SELF, nCnt);\r\n            }\r\n        }\r\n        break;\r\n\r\n        case FORCE_POWER_IMP_BAT_MED_ENEMY:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n\r\n            // Bonuses\r\n            eLink1 = EffectDamageIncrease(2);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAttackIncrease(2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_WILL, 2));\r\n            eLink1 = SetEffectIcon(eLink1, 108);\r\n\r\n            int nCnt = 0;\r\n            float fDuration = Sp_CalcDuration( 20.0 );\r\n\r\n            object oParty = OBJECT_SELF;\r\n            // Iterate over all targets of the beneficial effects and\r\n            // apply them.\r\n            while(nCnt < 3)\r\n            {\r\n                if( GetIsObjectValid(oParty) &&\r\n                    GetRacialType(oParty) != RACIAL_TYPE_DROID )\r\n                {\r\n                    SignalEvent(oParty, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    // Remove any lower level or equal versions of this power.\r\n                    Sp_RemoveRelatedPowers( oParty, FORCE_POWER_IMP_BAT_MED_ENEMY );\r\n\r\n                    // Do not apply the effects of this power if a more powerful\r\n                    // version is already attached to the target.\r\n                    if( !Sp_BetterRelatedPowerExists( oParty, FORCE_POWER_IMP_BAT_MED_ENEMY ) ) {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(9001), oParty);\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oParty, fDuration);\r\n                    }\r\n                }\r\n                nCnt++;\r\n                oParty = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, OBJECT_SELF, nCnt);\r\n            }\r\n\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_SHAPE = SHAPE_SPHERE;\r\n\r\n            // Penalties\r\n            eLink1 = EffectDamageDecrease(2);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAttackDecrease(2));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowDecrease(SAVING_THROW_WILL, 2));\r\n            eLink1 = SetEffectIcon(eLink1, 108);\r\n\r\n            // Iterate over all targets of the detrimental effects and\r\n            // apply them.\r\n            // Get each creature within 10.0 units.\r\n            object oCreature = GetFirstObjectInShape(SWFP_SHAPE, 10.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            while(GetIsObjectValid(oCreature))\r\n            {\r\n                // This power targets hostile creatures only.\r\n                if( GetIsObjectValid(oCreature) &&\r\n                    GetIsEnemy(oCreature) &&\r\n                    GetRacialType(oCreature) != RACIAL_TYPE_DROID )\r\n                {\r\n                    SignalEvent(oCreature, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    //Make Immunity Checks\r\n                    int nResist = Sp_BlockingChecks(oCreature, eLink1, eInvalid, eInvalid);\r\n                    if(nResist == 0)\r\n                    {\r\n                        int nSaves = Sp_MySavingThrows(oCreature);\r\n                        if(nSaves == 0)\r\n                        {\r\n                            // Remove any lower level or equal versions of this power.\r\n                            Sp_RemoveRelatedPowers( oCreature, FORCE_POWER_IMP_BAT_MED_ENEMY );\r\n\r\n                            // Do not apply the effects of this power if a more powerful\r\n                            // version is already attached to the target.\r\n                            if( !Sp_BetterRelatedPowerExists( oCreature, FORCE_POWER_IMP_BAT_MED_ENEMY ) ) {\r\n                                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(9001), oCreature);\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oCreature, fDuration);\r\n                            }\r\n                        }\r\n                    }\r\n                }\r\n                oCreature = GetNextObjectInShape(SWFP_SHAPE, 10.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            }\r\n        }\r\n        break;\r\n\r\n        case FORCE_POWER_MAS_BAT_MED_ENEMY:\r\n        {\r\n            SWFP_HARMFUL = FALSE;\r\n\r\n            // Bonuses\r\n            eLink1 = EffectDamageIncrease(4);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAttackIncrease(4));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowIncrease(SAVING_THROW_WILL, 4));\r\n            eLink1 = SetEffectIcon(eLink1, 109);\r\n\r\n            int nCnt = 0;\r\n            float fDuration = Sp_CalcDuration( 20.0 );\r\n\r\n            object oParty = OBJECT_SELF;\r\n            // Iterate over all targets of the beneficial effects and\r\n            // apply them.\r\n            while(nCnt < 3)\r\n            {\r\n                if( GetIsObjectValid(oParty) &&\r\n                    GetRacialType(oParty) != RACIAL_TYPE_DROID )\r\n                {\r\n                    SignalEvent(oParty, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    // Remove any lower level or equal versions of this power.\r\n                    Sp_RemoveRelatedPowers( oParty, FORCE_POWER_MAS_BAT_MED_ENEMY );\r\n\r\n                    // Do not apply the effects of this power if a more powerful\r\n                    // version is already attached to the target.\r\n                    if( !Sp_BetterRelatedPowerExists( oParty, FORCE_POWER_MAS_BAT_MED_ENEMY ) ) {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(9002), oParty);\r\n                        ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oParty, fDuration);\r\n                    }\r\n                }\r\n                nCnt++;\r\n                oParty = GetNearestCreature(CREATURE_TYPE_REPUTATION, REPUTATION_TYPE_FRIEND, OBJECT_SELF, nCnt);\r\n            }\r\n\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_SHAPE = SHAPE_SPHERE;\r\n\r\n            // Penalties\r\n            eLink1 = EffectDamageDecrease(4);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectAttackDecrease(4));\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowDecrease(SAVING_THROW_WILL, 4));\r\n            eLink1 = SetEffectIcon(eLink1, 109);\r\n\r\n            // Iterate over all targets of the detrimental effects and\r\n            // apply them.\r\n            // Get each creature within 15.0 units.\r\n            object oCreature = GetFirstObjectInShape(SWFP_SHAPE, 15.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            while(GetIsObjectValid(oCreature))\r\n            {\r\n                // This power targets hostile creatures only.\r\n                if( GetIsObjectValid(oCreature) &&\r\n                    GetIsEnemy(oCreature) &&\r\n                    GetRacialType(oCreature) != RACIAL_TYPE_DROID )\r\n                {\r\n                    SignalEvent(oCreature, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    //Make Immunity Checks\r\n                    int nResist = Sp_BlockingChecks(oCreature, eLink1, eInvalid, eInvalid);\r\n                    if(nResist == 0)\r\n                    {\r\n                        int nSaves = Sp_MySavingThrows(oCreature);\r\n                        if(nSaves == 0)\r\n                        {\r\n                            // Remove any lower level or equal versions of this power.\r\n                            Sp_RemoveRelatedPowers( oCreature, FORCE_POWER_MAS_BAT_MED_ENEMY );\r\n\r\n                            // Do not apply the effects of this power if a more powerful\r\n                            // version is already attached to the target.\r\n                            if( !Sp_BetterRelatedPowerExists( oCreature, FORCE_POWER_MAS_BAT_MED_ENEMY ) ) {\r\n                                ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect(9002), oCreature);\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oCreature, fDuration);\r\n                            }\r\n                        }\r\n                    }\r\n                }\r\n                oCreature = GetNextObjectInShape(SWFP_SHAPE, 15.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            }\r\n        }\r\n        break;\r\n\r\n        // DJS-OEI 12/15/2003\r\n        case FORCE_POWER_CRUSH_OPPOSITION_I:\r\n        case FORCE_POWER_CRUSH_OPPOSITION_II:\r\n        case FORCE_POWER_CRUSH_OPPOSITION_III:\r\n        case FORCE_POWER_CRUSH_OPPOSITION_IV:\r\n        case FORCE_POWER_CRUSH_OPPOSITION_V:\r\n        case FORCE_POWER_CRUSH_OPPOSITION_VI:\r\n        {\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_SHAPE = SHAPE_SPHERE;\r\n\r\n            float fRange = Sp_CalcRange( 15.0 );\r\n\r\n            // Calculate the severity of the penalty based on the power used.\r\n            // It goes from 1 to 6.\r\n            int nPenalty = GetSpellId() - FORCE_POWER_CRUSH_OPPOSITION_I + 1;\r\n\r\n            // Penalties\r\n            eLink1 = EffectAttackDecrease(nPenalty);\r\n            eLink1 = EffectLinkEffects(eLink1, EffectSavingThrowDecrease(SAVING_THROW_WILL, nPenalty));\r\n            eLink1 = SetEffectIcon(eLink1, 70 + nPenalty - 1);\r\n\r\n            // Iterate over all targets of the detrimental effects and\r\n            // apply them.\r\n            // Get each creature within 15.0 units.\r\n            object oCreature = GetFirstObjectInShape(SWFP_SHAPE, fRange, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            while(GetIsObjectValid(oCreature))\r\n            {\r\n                // This power targets hostile creatures only.\r\n                if( GetIsObjectValid(oCreature) &&\r\n                    GetIsEnemy(oCreature) &&\r\n                    GetRacialType(oCreature) != RACIAL_TYPE_DROID )\r\n                {\r\n                    SignalEvent(oCreature, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n\r\n                    //Make Immunity Checks\r\n                    int nResist = Sp_BlockingChecks(oCreature, eLink1, eInvalid, eInvalid);\r\n                    if(nResist == 0)\r\n                    {\r\n                        int nSaves = Sp_MySavingThrows(oCreature);\r\n                        if(nSaves == 0)\r\n                        {\r\n                            // Remove any lower level or equal versions of this power.\r\n                            Sp_RemoveRelatedPowers( oCreature, GetSpellId() );\r\n\r\n                            // Do not apply the effects of this power if a more powerful\r\n                            // version is already attached to the target.\r\n                            if( !Sp_BetterRelatedPowerExists( oCreature, GetSpellId() ) ) {\r\n                                float fDuration = Sp_CalcDuration( 45.0 );\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink1, oCreature, fDuration);\r\n                            }\r\n                        }\r\n                    }\r\n                }\r\n                oCreature = GetNextObjectInShape(SWFP_SHAPE, fRange, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            }\r\n        }\r\n        break;\r\n\r\n        // DJS-OEI 12/15/2003\r\n        // Applies the Force Body effect to the target. This effect has\r\n        // the value 0, 1, or 2 embedded in it depending on the level of\r\n        // this power cast. This will determine the percentages of FP/VP\r\n        // used to cast subsquent spells.\r\n        case FORCE_POWER_FORCE_BODY:\r\n        case FORCE_POWER_IMPROVED_FORCE_BODY:\r\n        case FORCE_POWER_MASTER_FORCE_BODY:\r\n        {\r\n            int nFX = 0;\r\n            if( GetSpellId() == FORCE_POWER_FORCE_BODY ) {\r\n                nFX = 9011;\r\n            }\r\n            else if( GetSpellId() == FORCE_POWER_IMPROVED_FORCE_BODY ) {\r\n                nFX = 9012;\r\n            }\r\n            else if( GetSpellId() == FORCE_POWER_MASTER_FORCE_BODY ) {\r\n                nFX = 9013;\r\n            }\r\n\r\n            // Remove any lower level or equal versions of this power.\r\n            Sp_RemoveRelatedPowers( OBJECT_SELF, GetSpellId() );\r\n\r\n            // Do not apply the effects of this power if a more powerful\r\n            // version is already attached to the target.\r\n            if( !Sp_BetterRelatedPowerExists( OBJECT_SELF, GetSpellId() ) ) {\r\n\r\n                SWFP_HARMFUL = FALSE;\r\n                int nValue = GetSpellId() - FORCE_POWER_FORCE_BODY;\r\n                eLink1 = EffectForceBody( nValue );\r\n                eLink1 = SetEffectIcon(eLink1, 76 + nValue );\r\n                float fDuration = Sp_CalcDuration( 30.0 );\r\n                Sp_ApplyEffects(FALSE, OBJECT_SELF, 0.0, 1, eLink1, fDuration, eInvalid, 0.0);\r\n                ApplyEffectToObject( DURATION_TYPE_INSTANT, EffectVisualEffect( nFX ), OBJECT_SELF );\r\n            }\r\n        }\r\n        break;\r\n\r\n        // DJS-OEI 12/30/2003\r\n        case FORCE_POWER_DRAIN_FORCE:\r\n        {\r\n            // Drain Force affects a single target and drains a maximum\r\n            // of 10 FP plus the casting cost.\r\n\r\n            // As per Ferret, the caster will always receive at least the casting\r\n            // cost of the power in FP even if none of the targets have\r\n            // that much FP to leech. Since the caster has lost the FP by the time\r\n            // we get here, just apply a Force Heal effect immediately.\r\n            int nCost = GetSpellForcePointCost();\r\n            //eLink1 = EffectHealForcePoints( nCost );\r\n            //ApplyEffectToObject(DURATION_TYPE_INSTANT, eLink1, OBJECT_SELF);\r\n\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n\r\n            // The number of FP to steal is assumed to be 10 to start with.\r\n            int nFPAmount = 20;\r\n\r\n            // Determine the number of Force Points the target has. If it is\r\n            // less than the steal amount, decrease the steal amount.\r\n            /*\r\n            int nTargetFP = GetCurrentForcePoints( oTarget );\r\n            if( nTargetFP < nFPAmount ) {\r\n                nFPAmount = nTargetFP;\r\n            }\r\n            */\r\n            if ( GetMaxForcePoints( oTarget ) < 1 )\r\n            {\r\n                nFPAmount = nCost;\r\n            }\r\n            else\r\n            {\r\n                nFPAmount = 20;\r\n            }\r\n\r\n            // Always give the player back the casting cost.\r\n            //nFPAmount += nCost;\r\n\r\n            // Create a temporary Force Point Damage effect in order to\r\n            // see if the target is immune for some reason.\r\n            eLink1 = EffectDamageForcePoints( nFPAmount );\r\n            int nResist = Sp_BlockingChecks(oTarget, eLink1, eInvalid, eInvalid);\r\n\r\n            SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n            if( GetRacialType(oTarget) != RACIAL_TYPE_DROID )\r\n            {\r\n                if(nResist == 0)\r\n                {\r\n                    int nSaves = Sp_MySavingThrows(oTarget);\r\n                    if(nSaves > 0)\r\n                    {\r\n                        nFPAmount /= 2;\r\n                    }\r\n                    if ( nFPAmount < nCost )\r\n                    {\r\n                        nFPAmount = nCost;\r\n                    }\r\n\r\n                    // Apply a Force Point Damage effect to the target.\r\n                    eLink1 = EffectDamageForcePoints( nFPAmount );\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eLink1, oTarget);\r\n\r\n                    // Apply a Force Point Heal effect to the caster.\r\n                    eLink2 = EffectHealForcePoints( nFPAmount );\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, eLink2, OBJECT_SELF);\r\n                }\r\n                else\r\n                {\r\n                    ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                }\r\n            }\r\n        }\r\n        break;\r\n\r\n        // DJS-OEI 12/30/2003\r\n        case FORCE_POWER_IMPROVED_DRAIN_FORCE:\r\n        case FORCE_POWER_MASTER_DRAIN_FORCE:\r\n        {\r\n            // Improved Drain Force and Master Drain Force both\r\n            // affect multiple targets.\r\n\r\n            // As per Ferret, the caster will always receive at least the casting\r\n            // cost of the power in FP even if none of the targets have\r\n            // that much FP to leech. Since the caster has lost the FP by the time\r\n            // we get here, just apply a Force Heal effect immediately.\r\n            int nCost = GetSpellForcePointCost();\r\n            //eLink1 = EffectHealForcePoints( nCost );\r\n            //ApplyEffectToObject(DURATION_TYPE_INSTANT, eLink1, OBJECT_SELF);\r\n\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n\r\n            int nFullRegainAmount = nCost;\r\n            object oTarget = GetFirstObjectInShape(SHAPE_SPHERE, 10.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            while(GetIsObjectValid(oTarget))\r\n            {\r\n                int nFPAmount;\r\n                if( GetSpellId() == FORCE_POWER_IMPROVED_DRAIN_FORCE ) {\r\n                    nFPAmount = 20;\r\n                }\r\n                else if( GetSpellId() == FORCE_POWER_MASTER_DRAIN_FORCE ) {\r\n                    nFPAmount = 30;\r\n                }\r\n\r\n                // Determine the number of Force Points the target has. If it is\r\n                // less than the steal amount, decrease the steal amount.\r\n                int nTargetFP = GetCurrentForcePoints( oTarget );\r\n                if( nTargetFP < nFPAmount ) {\r\n                    nFPAmount = nTargetFP;\r\n                }\r\n\r\n                // Create a temporary Force Point Damage effect in order to\r\n                // see if the target is immune for some reason.\r\n                eLink1 = EffectDamageForcePoints( nFPAmount );\r\n                int nResist = Sp_BlockingChecks(oTarget, eLink1, eInvalid, eInvalid);\r\n\r\n                SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                if( ( GetRacialType(oTarget) != RACIAL_TYPE_DROID ) &&\r\n                    GetIsEnemy(oTarget) )\r\n                {\r\n                    if(nResist == 0)\r\n                    {\r\n                        int nSaves = Sp_MySavingThrows(oTarget);\r\n                        if(nSaves > 0)\r\n                        {\r\n                            nFPAmount /= 2;\r\n                        }\r\n\r\n                        // Apply a Force Point Damage effect to the target.\r\n                        eLink1 = EffectDamageForcePoints( nFPAmount );\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, eLink1, oTarget);\r\n\r\n                        nFullRegainAmount += nFPAmount;\r\n                    }\r\n                    else\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                    }\r\n                }\r\n                oTarget = GetNextObjectInShape(SHAPE_SPHERE, 10.0, GetLocation(OBJECT_SELF), FALSE, OBJECT_TYPE_CREATURE );\r\n            }\r\n\r\n            // Finally, give the player the FP they\'ve drained plus the\r\n            // casting cost (assigned above).\r\n            eLink2 = EffectHealForcePoints( nFullRegainAmount );\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, eLink2, OBJECT_SELF);\r\n        }\r\n        break;\r\n\r\n        // DJS-OEI 12/30/2003\r\n        case FORCE_POWER_FORCE_SCREAM:\r\n        case FORCE_POWER_IMPROVED_FORCE_SCREAM:\r\n        case FORCE_POWER_MASTER_FORCE_SCREAM:\r\n        {\r\n            // Force Scream and Improved Force Scream both affect\r\n            // targets in a cone extending from the caster\'s location.\r\n            SWFP_HARMFUL = TRUE;\r\n            SWFP_PRIVATE_SAVE_TYPE = SAVING_THROW_WILL;\r\n            SWFP_PRIVATE_SAVE_VERSUS_TYPE = SAVING_THROW_TYPE_SONIC;\r\n\r\n            // Each version of the spell causes differing amounts of damage.\r\n            int nDamageRolls;\r\n            int nAttributeDamage;\r\n            int nIconID;\r\n            int nShape;\r\n            float fShapeSize;\r\n            int nVFXID;\r\n            location lTargetLoc;\r\n            if( GetSpellId() == FORCE_POWER_FORCE_SCREAM ) {\r\n                nDamageRolls = 3;\r\n                nAttributeDamage = 2;\r\n                nIconID = 79;\r\n                nShape = SHAPE_SPELLCONE;\r\n                fShapeSize = Sp_CalcRange( 20.0 );\r\n                nVFXID = 9005;\r\n                lTargetLoc = GetLocation( GetSpellTarget() );\r\n            }\r\n            else if( GetSpellId() == FORCE_POWER_IMPROVED_FORCE_SCREAM ) {\r\n                nDamageRolls = 5;\r\n                nAttributeDamage = 4;\r\n                nIconID = 80;\r\n                nShape = SHAPE_SPELLCONE;\r\n                fShapeSize = Sp_CalcRange( 20.0 );\r\n                nVFXID = 9006;\r\n                lTargetLoc = GetLocation( GetSpellTarget() );\r\n            }\r\n            else if( GetSpellId() == FORCE_POWER_MASTER_FORCE_SCREAM ) {\r\n                nDamageRolls = 7;\r\n                nAttributeDamage = 6;\r\n                nIconID = 81;\r\n                nShape = SHAPE_SPHERE;\r\n                // DJS-OEI 1/14/2004\r\n                // Increase the range slightly. Since the range for this spell\r\n                // is 10m, the pathing system fudging will in some cases not\r\n                // cuase any valid targets to be within 10m to get damaged.\r\n                //fShapeSize = Sp_CalcRange( 10.0 );\r\n                fShapeSize = Sp_CalcRange( 12.0 );\r\n                nVFXID = 9007;\r\n                lTargetLoc = GetLocation( OBJECT_SELF );\r\n            }\r\n\r\n            ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectVisualEffect( nVFXID ), OBJECT_SELF);\r\n\r\n//            object oTarget = GetFirstObjectInShape(nShape, fShapeSize, GetLocation(OBJECT_SELF), TRUE, OBJECT_TYPE_CREATURE );\r\n            object oTarget = GetFirstObjectInShape(nShape, fShapeSize, lTargetLoc, TRUE, OBJECT_TYPE_CREATURE );\r\n            while(GetIsObjectValid(oTarget))\r\n            {\r\n                int nTotalDamage = Sp_CalcDamage( oTarget, nDamageRolls, 6 );\r\n\r\n                // Create the damage effects.\r\n                eLink1 = EffectDamage( nTotalDamage, DAMAGE_TYPE_SONIC );\r\n                eLink2 = EffectAbilityDecrease(ABILITY_STRENGTH, nAttributeDamage);\r\n                eLink2 = EffectLinkEffects(eLink2, EffectAbilityDecrease(ABILITY_DEXTERITY, nAttributeDamage));\r\n                eLink2 = EffectLinkEffects(eLink2, EffectAbilityDecrease(ABILITY_INTELLIGENCE, nAttributeDamage));\r\n                eLink2 = EffectLinkEffects(eLink2, EffectAbilityDecrease(ABILITY_WISDOM, nAttributeDamage));\r\n                eLink2 = EffectLinkEffects(eLink2, EffectAbilityDecrease(ABILITY_CHARISMA, nAttributeDamage));\r\n                eLink2 = EffectLinkEffects(eLink2, EffectAbilityDecrease(ABILITY_CONSTITUTION, nAttributeDamage));\r\n                eLink2 = SetEffectIcon(eLink2, nIconID);\r\n\r\n                // Check resistances.\r\n                int nResist = Sp_BlockingChecks(oTarget, eLink1, eLink2, eInvalid);\r\n                SignalEvent(oTarget, EventSpellCastAt(OBJECT_SELF, GetSpellId(), SWFP_HARMFUL));\r\n                if( ( GetRacialType(oTarget) != RACIAL_TYPE_DROID ) &&\r\n                    GetIsEnemy(oTarget) )\r\n                {\r\n                    if(nResist == 0)\r\n                    {\r\n                        int nSaves = Sp_MySavingThrows(oTarget);\r\n                        if(nSaves <= 0)\r\n                        {\r\n                            // Apply physical damage effect to the target.\r\n                            ApplyEffectToObject(DURATION_TYPE_INSTANT, eLink1, oTarget);\r\n\r\n                            // Remove any lower level or equal versions of this power.\r\n                            Sp_RemoveRelatedPowers( oTarget, GetSpellId() );\r\n\r\n                            // Do not apply the effects of this power if a more powerful\r\n                            // version is already attached to the target.\r\n                            if( !Sp_BetterRelatedPowerExists( oTarget, GetSpellId() ) ) {\r\n\r\n                                // Apply the attribute damage effect.\r\n                                float fDuration = Sp_CalcDuration( 30.0 );\r\n                                ApplyEffectToObject(DURATION_TYPE_TEMPORARY, eLink2, oTarget, fDuration);\r\n                            }\r\n                        }\r\n                        else {\r\n                            int nApply;\r\n                            // DJS-OEI 11/20/2003\r\n                            // If the target has the Evasion feat, the damage on a successful\r\n                            // save is 0. Otherwise, it\'s half the original damage.\r\n                            if( GetHasFeat( FEAT_EVASION, oTarget ) ) {\r\n                                nApply = 0;\r\n                            }\r\n                            else {\r\n                                nApply = nTotalDamage/2;\r\n                            }\r\n\r\n                            if( nApply > 0 ) {\r\n                                // The target saved, so the attribute damage is ignored.\r\n                                // Rebuild the damage effect with the new damage.\r\n                                eLink1 = EffectDamage( nApply, DAMAGE_TYPE_SONIC );\r\n                                ApplyEffectToObject(DURATION_TYPE_INSTANT, eLink1, oTarget);\r\n                            }\r\n                        }\r\n                    }\r\n                    else\r\n                    {\r\n                        ApplyEffectToObject(DURATION_TYPE_INSTANT, EffectForceFizzle(), OBJECT_SELF);\r\n                    }\r\n                }\r\n//                oTarget = G