# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AccountResponse',
    'AndroidDeviceListResponse',
    'AndroidDeviceResponse',
    'AndroidInstrumentationTestResponse',
    'AndroidMatrixResponse',
    'AndroidRoboTestResponse',
    'AndroidTestLoopResponse',
    'ApkResponse',
    'AppBundleResponse',
    'ClientInfoDetailResponse',
    'ClientInfoResponse',
    'DeviceFileResponse',
    'EnvironmentMatrixResponse',
    'EnvironmentResponse',
    'EnvironmentVariableResponse',
    'FileReferenceResponse',
    'GoogleAutoResponse',
    'GoogleCloudStorageResponse',
    'IosDeviceFileResponse',
    'IosDeviceListResponse',
    'IosDeviceResponse',
    'IosTestLoopResponse',
    'IosTestSetupResponse',
    'IosXcTestResponse',
    'LauncherActivityIntentResponse',
    'ManualShardingResponse',
    'ObbFileResponse',
    'RegularFileResponse',
    'ResultStorageResponse',
    'RoboDirectiveResponse',
    'RoboStartingIntentResponse',
    'ShardResponse',
    'ShardingOptionResponse',
    'StartActivityIntentResponse',
    'SystraceSetupResponse',
    'TestDetailsResponse',
    'TestExecutionResponse',
    'TestSetupResponse',
    'TestSpecificationResponse',
    'TestTargetsForShardResponse',
    'ToolResultsExecutionResponse',
    'ToolResultsHistoryResponse',
    'ToolResultsStepResponse',
    'UniformShardingResponse',
]

@pulumi.output_type
class AccountResponse(dict):
    """
    Identifies an account and how to log into it.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "googleAuto":
            suggest = "google_auto"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 google_auto: 'outputs.GoogleAutoResponse'):
        """
        Identifies an account and how to log into it.
        :param 'GoogleAutoResponse' google_auto: An automatic google login account.
        """
        pulumi.set(__self__, "google_auto", google_auto)

    @property
    @pulumi.getter(name="googleAuto")
    def google_auto(self) -> 'outputs.GoogleAutoResponse':
        """
        An automatic google login account.
        """
        return pulumi.get(self, "google_auto")


@pulumi.output_type
class AndroidDeviceListResponse(dict):
    """
    A list of Android device configurations in which the test is to be executed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "androidDevices":
            suggest = "android_devices"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AndroidDeviceListResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AndroidDeviceListResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AndroidDeviceListResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 android_devices: Sequence['outputs.AndroidDeviceResponse']):
        """
        A list of Android device configurations in which the test is to be executed.
        :param Sequence['AndroidDeviceResponse'] android_devices: A list of Android devices.
        """
        pulumi.set(__self__, "android_devices", android_devices)

    @property
    @pulumi.getter(name="androidDevices")
    def android_devices(self) -> Sequence['outputs.AndroidDeviceResponse']:
        """
        A list of Android devices.
        """
        return pulumi.get(self, "android_devices")


@pulumi.output_type
class AndroidDeviceResponse(dict):
    """
    A single Android device.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "androidModelId":
            suggest = "android_model_id"
        elif key == "androidVersionId":
            suggest = "android_version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AndroidDeviceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AndroidDeviceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AndroidDeviceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 android_model_id: str,
                 android_version_id: str,
                 locale: str,
                 orientation: str):
        """
        A single Android device.
        :param str android_model_id: The id of the Android device to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        :param str android_version_id: The id of the Android OS version to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        :param str locale: The locale the test device used for testing. Use the TestEnvironmentDiscoveryService to get supported options.
        :param str orientation: How the device is oriented during the test. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        pulumi.set(__self__, "android_model_id", android_model_id)
        pulumi.set(__self__, "android_version_id", android_version_id)
        pulumi.set(__self__, "locale", locale)
        pulumi.set(__self__, "orientation", orientation)

    @property
    @pulumi.getter(name="androidModelId")
    def android_model_id(self) -> str:
        """
        The id of the Android device to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "android_model_id")

    @property
    @pulumi.getter(name="androidVersionId")
    def android_version_id(self) -> str:
        """
        The id of the Android OS version to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "android_version_id")

    @property
    @pulumi.getter
    def locale(self) -> str:
        """
        The locale the test device used for testing. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "locale")

    @property
    @pulumi.getter
    def orientation(self) -> str:
        """
        How the device is oriented during the test. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "orientation")


@pulumi.output_type
class AndroidInstrumentationTestResponse(dict):
    """
    A test of an Android application that can control an Android component independently of its normal lifecycle. Android instrumentation tests run an application APK and test APK inside the same process on a virtual or physical AndroidDevice. They also specify a test runner class, such as com.google.GoogleTestRunner, which can vary on the specific instrumentation framework chosen. See for more information on types of Android tests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appApk":
            suggest = "app_apk"
        elif key == "appBundle":
            suggest = "app_bundle"
        elif key == "appPackageId":
            suggest = "app_package_id"
        elif key == "orchestratorOption":
            suggest = "orchestrator_option"
        elif key == "shardingOption":
            suggest = "sharding_option"
        elif key == "testApk":
            suggest = "test_apk"
        elif key == "testPackageId":
            suggest = "test_package_id"
        elif key == "testRunnerClass":
            suggest = "test_runner_class"
        elif key == "testTargets":
            suggest = "test_targets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AndroidInstrumentationTestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AndroidInstrumentationTestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AndroidInstrumentationTestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_apk: 'outputs.FileReferenceResponse',
                 app_bundle: 'outputs.AppBundleResponse',
                 app_package_id: str,
                 orchestrator_option: str,
                 sharding_option: 'outputs.ShardingOptionResponse',
                 test_apk: 'outputs.FileReferenceResponse',
                 test_package_id: str,
                 test_runner_class: str,
                 test_targets: Sequence[str]):
        """
        A test of an Android application that can control an Android component independently of its normal lifecycle. Android instrumentation tests run an application APK and test APK inside the same process on a virtual or physical AndroidDevice. They also specify a test runner class, such as com.google.GoogleTestRunner, which can vary on the specific instrumentation framework chosen. See for more information on types of Android tests.
        :param 'FileReferenceResponse' app_apk: The APK for the application under test.
        :param 'AppBundleResponse' app_bundle: A multi-apk app bundle for the application under test.
        :param str app_package_id: The java package for the application under test. The default value is determined by examining the application's manifest.
        :param str orchestrator_option: The option of whether running each test within its own invocation of instrumentation with Android Test Orchestrator or not. ** Orchestrator is only compatible with AndroidJUnitRunner version 1.1 or higher! ** Orchestrator offers the following benefits: - No shared state - Crashes are isolated - Logs are scoped per test See for more information about Android Test Orchestrator. If not set, the test will be run without the orchestrator.
        :param 'ShardingOptionResponse' sharding_option: The option to run tests in multiple shards in parallel.
        :param 'FileReferenceResponse' test_apk: The APK containing the test code to be executed.
        :param str test_package_id: The java package for the test to be executed. The default value is determined by examining the application's manifest.
        :param str test_runner_class: The InstrumentationTestRunner class. The default value is determined by examining the application's manifest.
        :param Sequence[str] test_targets: Each target must be fully qualified with the package name or class name, in one of these formats: - "package package_name" - "class package_name.class_name" - "class package_name.class_name#method_name" If empty, all targets in the module will be run.
        """
        pulumi.set(__self__, "app_apk", app_apk)
        pulumi.set(__self__, "app_bundle", app_bundle)
        pulumi.set(__self__, "app_package_id", app_package_id)
        pulumi.set(__self__, "orchestrator_option", orchestrator_option)
        pulumi.set(__self__, "sharding_option", sharding_option)
        pulumi.set(__self__, "test_apk", test_apk)
        pulumi.set(__self__, "test_package_id", test_package_id)
        pulumi.set(__self__, "test_runner_class", test_runner_class)
        pulumi.set(__self__, "test_targets", test_targets)

    @property
    @pulumi.getter(name="appApk")
    def app_apk(self) -> 'outputs.FileReferenceResponse':
        """
        The APK for the application under test.
        """
        return pulumi.get(self, "app_apk")

    @property
    @pulumi.getter(name="appBundle")
    def app_bundle(self) -> 'outputs.AppBundleResponse':
        """
        A multi-apk app bundle for the application under test.
        """
        return pulumi.get(self, "app_bundle")

    @property
    @pulumi.getter(name="appPackageId")
    def app_package_id(self) -> str:
        """
        The java package for the application under test. The default value is determined by examining the application's manifest.
        """
        return pulumi.get(self, "app_package_id")

    @property
    @pulumi.getter(name="orchestratorOption")
    def orchestrator_option(self) -> str:
        """
        The option of whether running each test within its own invocation of instrumentation with Android Test Orchestrator or not. ** Orchestrator is only compatible with AndroidJUnitRunner version 1.1 or higher! ** Orchestrator offers the following benefits: - No shared state - Crashes are isolated - Logs are scoped per test See for more information about Android Test Orchestrator. If not set, the test will be run without the orchestrator.
        """
        return pulumi.get(self, "orchestrator_option")

    @property
    @pulumi.getter(name="shardingOption")
    def sharding_option(self) -> 'outputs.ShardingOptionResponse':
        """
        The option to run tests in multiple shards in parallel.
        """
        return pulumi.get(self, "sharding_option")

    @property
    @pulumi.getter(name="testApk")
    def test_apk(self) -> 'outputs.FileReferenceResponse':
        """
        The APK containing the test code to be executed.
        """
        return pulumi.get(self, "test_apk")

    @property
    @pulumi.getter(name="testPackageId")
    def test_package_id(self) -> str:
        """
        The java package for the test to be executed. The default value is determined by examining the application's manifest.
        """
        return pulumi.get(self, "test_package_id")

    @property
    @pulumi.getter(name="testRunnerClass")
    def test_runner_class(self) -> str:
        """
        The InstrumentationTestRunner class. The default value is determined by examining the application's manifest.
        """
        return pulumi.get(self, "test_runner_class")

    @property
    @pulumi.getter(name="testTargets")
    def test_targets(self) -> Sequence[str]:
        """
        Each target must be fully qualified with the package name or class name, in one of these formats: - "package package_name" - "class package_name.class_name" - "class package_name.class_name#method_name" If empty, all targets in the module will be run.
        """
        return pulumi.get(self, "test_targets")


@pulumi.output_type
class AndroidMatrixResponse(dict):
    """
    A set of Android device configuration permutations is defined by the the cross-product of the given axes. Internally, the given AndroidMatrix will be expanded into a set of AndroidDevices. Only supported permutations will be instantiated. Invalid permutations (e.g., incompatible models/versions) are ignored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "androidModelIds":
            suggest = "android_model_ids"
        elif key == "androidVersionIds":
            suggest = "android_version_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AndroidMatrixResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AndroidMatrixResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AndroidMatrixResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 android_model_ids: Sequence[str],
                 android_version_ids: Sequence[str],
                 locales: Sequence[str],
                 orientations: Sequence[str]):
        """
        A set of Android device configuration permutations is defined by the the cross-product of the given axes. Internally, the given AndroidMatrix will be expanded into a set of AndroidDevices. Only supported permutations will be instantiated. Invalid permutations (e.g., incompatible models/versions) are ignored.
        :param Sequence[str] android_model_ids: The ids of the set of Android device to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        :param Sequence[str] android_version_ids: The ids of the set of Android OS version to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        :param Sequence[str] locales: The set of locales the test device will enable for testing. Use the TestEnvironmentDiscoveryService to get supported options.
        :param Sequence[str] orientations: The set of orientations to test with. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        pulumi.set(__self__, "android_model_ids", android_model_ids)
        pulumi.set(__self__, "android_version_ids", android_version_ids)
        pulumi.set(__self__, "locales", locales)
        pulumi.set(__self__, "orientations", orientations)

    @property
    @pulumi.getter(name="androidModelIds")
    def android_model_ids(self) -> Sequence[str]:
        """
        The ids of the set of Android device to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "android_model_ids")

    @property
    @pulumi.getter(name="androidVersionIds")
    def android_version_ids(self) -> Sequence[str]:
        """
        The ids of the set of Android OS version to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "android_version_ids")

    @property
    @pulumi.getter
    def locales(self) -> Sequence[str]:
        """
        The set of locales the test device will enable for testing. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "locales")

    @property
    @pulumi.getter
    def orientations(self) -> Sequence[str]:
        """
        The set of orientations to test with. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "orientations")


@pulumi.output_type
class AndroidRoboTestResponse(dict):
    """
    A test of an android application that explores the application on a virtual or physical Android Device, finding culprits and crashes as it goes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appApk":
            suggest = "app_apk"
        elif key == "appBundle":
            suggest = "app_bundle"
        elif key == "appInitialActivity":
            suggest = "app_initial_activity"
        elif key == "appPackageId":
            suggest = "app_package_id"
        elif key == "maxDepth":
            suggest = "max_depth"
        elif key == "maxSteps":
            suggest = "max_steps"
        elif key == "roboDirectives":
            suggest = "robo_directives"
        elif key == "roboMode":
            suggest = "robo_mode"
        elif key == "roboScript":
            suggest = "robo_script"
        elif key == "startingIntents":
            suggest = "starting_intents"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AndroidRoboTestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AndroidRoboTestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AndroidRoboTestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_apk: 'outputs.FileReferenceResponse',
                 app_bundle: 'outputs.AppBundleResponse',
                 app_initial_activity: str,
                 app_package_id: str,
                 max_depth: int,
                 max_steps: int,
                 robo_directives: Sequence['outputs.RoboDirectiveResponse'],
                 robo_mode: str,
                 robo_script: 'outputs.FileReferenceResponse',
                 starting_intents: Sequence['outputs.RoboStartingIntentResponse']):
        """
        A test of an android application that explores the application on a virtual or physical Android Device, finding culprits and crashes as it goes.
        :param 'FileReferenceResponse' app_apk: The APK for the application under test.
        :param 'AppBundleResponse' app_bundle: A multi-apk app bundle for the application under test.
        :param str app_initial_activity: The initial activity that should be used to start the app.
        :param str app_package_id: The java package for the application under test. The default value is determined by examining the application's manifest.
        :param int max_depth: The max depth of the traversal stack Robo can explore. Needs to be at least 2 to make Robo explore the app beyond the first activity. Default is 50.
        :param int max_steps: The max number of steps Robo can execute. Default is no limit.
        :param Sequence['RoboDirectiveResponse'] robo_directives: A set of directives Robo should apply during the crawl. This allows users to customize the crawl. For example, the username and password for a test account can be provided.
        :param str robo_mode: The mode in which Robo should run. Most clients should allow the server to populate this field automatically.
        :param 'FileReferenceResponse' robo_script: A JSON file with a sequence of actions Robo should perform as a prologue for the crawl.
        :param Sequence['RoboStartingIntentResponse'] starting_intents: The intents used to launch the app for the crawl. If none are provided, then the main launcher activity is launched. If some are provided, then only those provided are launched (the main launcher activity must be provided explicitly).
        """
        pulumi.set(__self__, "app_apk", app_apk)
        pulumi.set(__self__, "app_bundle", app_bundle)
        pulumi.set(__self__, "app_initial_activity", app_initial_activity)
        pulumi.set(__self__, "app_package_id", app_package_id)
        pulumi.set(__self__, "max_depth", max_depth)
        pulumi.set(__self__, "max_steps", max_steps)
        pulumi.set(__self__, "robo_directives", robo_directives)
        pulumi.set(__self__, "robo_mode", robo_mode)
        pulumi.set(__self__, "robo_script", robo_script)
        pulumi.set(__self__, "starting_intents", starting_intents)

    @property
    @pulumi.getter(name="appApk")
    def app_apk(self) -> 'outputs.FileReferenceResponse':
        """
        The APK for the application under test.
        """
        return pulumi.get(self, "app_apk")

    @property
    @pulumi.getter(name="appBundle")
    def app_bundle(self) -> 'outputs.AppBundleResponse':
        """
        A multi-apk app bundle for the application under test.
        """
        return pulumi.get(self, "app_bundle")

    @property
    @pulumi.getter(name="appInitialActivity")
    def app_initial_activity(self) -> str:
        """
        The initial activity that should be used to start the app.
        """
        return pulumi.get(self, "app_initial_activity")

    @property
    @pulumi.getter(name="appPackageId")
    def app_package_id(self) -> str:
        """
        The java package for the application under test. The default value is determined by examining the application's manifest.
        """
        return pulumi.get(self, "app_package_id")

    @property
    @pulumi.getter(name="maxDepth")
    def max_depth(self) -> int:
        """
        The max depth of the traversal stack Robo can explore. Needs to be at least 2 to make Robo explore the app beyond the first activity. Default is 50.
        """
        return pulumi.get(self, "max_depth")

    @property
    @pulumi.getter(name="maxSteps")
    def max_steps(self) -> int:
        """
        The max number of steps Robo can execute. Default is no limit.
        """
        return pulumi.get(self, "max_steps")

    @property
    @pulumi.getter(name="roboDirectives")
    def robo_directives(self) -> Sequence['outputs.RoboDirectiveResponse']:
        """
        A set of directives Robo should apply during the crawl. This allows users to customize the crawl. For example, the username and password for a test account can be provided.
        """
        return pulumi.get(self, "robo_directives")

    @property
    @pulumi.getter(name="roboMode")
    def robo_mode(self) -> str:
        """
        The mode in which Robo should run. Most clients should allow the server to populate this field automatically.
        """
        return pulumi.get(self, "robo_mode")

    @property
    @pulumi.getter(name="roboScript")
    def robo_script(self) -> 'outputs.FileReferenceResponse':
        """
        A JSON file with a sequence of actions Robo should perform as a prologue for the crawl.
        """
        return pulumi.get(self, "robo_script")

    @property
    @pulumi.getter(name="startingIntents")
    def starting_intents(self) -> Sequence['outputs.RoboStartingIntentResponse']:
        """
        The intents used to launch the app for the crawl. If none are provided, then the main launcher activity is launched. If some are provided, then only those provided are launched (the main launcher activity must be provided explicitly).
        """
        return pulumi.get(self, "starting_intents")


@pulumi.output_type
class AndroidTestLoopResponse(dict):
    """
    A test of an Android Application with a Test Loop. The intent \ will be implicitly added, since Games is the only user of this api, for the time being.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appApk":
            suggest = "app_apk"
        elif key == "appBundle":
            suggest = "app_bundle"
        elif key == "appPackageId":
            suggest = "app_package_id"
        elif key == "scenarioLabels":
            suggest = "scenario_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AndroidTestLoopResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AndroidTestLoopResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AndroidTestLoopResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_apk: 'outputs.FileReferenceResponse',
                 app_bundle: 'outputs.AppBundleResponse',
                 app_package_id: str,
                 scenario_labels: Sequence[str],
                 scenarios: Sequence[int]):
        """
        A test of an Android Application with a Test Loop. The intent \ will be implicitly added, since Games is the only user of this api, for the time being.
        :param 'FileReferenceResponse' app_apk: The APK for the application under test.
        :param 'AppBundleResponse' app_bundle: A multi-apk app bundle for the application under test.
        :param str app_package_id: The java package for the application under test. The default is determined by examining the application's manifest.
        :param Sequence[str] scenario_labels: The list of scenario labels that should be run during the test. The scenario labels should map to labels defined in the application's manifest. For example, player_experience and com.google.test.loops.player_experience add all of the loops labeled in the manifest with the com.google.test.loops.player_experience name to the execution. Scenarios can also be specified in the scenarios field.
        :param Sequence[int] scenarios: The list of scenarios that should be run during the test. The default is all test loops, derived from the application's manifest.
        """
        pulumi.set(__self__, "app_apk", app_apk)
        pulumi.set(__self__, "app_bundle", app_bundle)
        pulumi.set(__self__, "app_package_id", app_package_id)
        pulumi.set(__self__, "scenario_labels", scenario_labels)
        pulumi.set(__self__, "scenarios", scenarios)

    @property
    @pulumi.getter(name="appApk")
    def app_apk(self) -> 'outputs.FileReferenceResponse':
        """
        The APK for the application under test.
        """
        return pulumi.get(self, "app_apk")

    @property
    @pulumi.getter(name="appBundle")
    def app_bundle(self) -> 'outputs.AppBundleResponse':
        """
        A multi-apk app bundle for the application under test.
        """
        return pulumi.get(self, "app_bundle")

    @property
    @pulumi.getter(name="appPackageId")
    def app_package_id(self) -> str:
        """
        The java package for the application under test. The default is determined by examining the application's manifest.
        """
        return pulumi.get(self, "app_package_id")

    @property
    @pulumi.getter(name="scenarioLabels")
    def scenario_labels(self) -> Sequence[str]:
        """
        The list of scenario labels that should be run during the test. The scenario labels should map to labels defined in the application's manifest. For example, player_experience and com.google.test.loops.player_experience add all of the loops labeled in the manifest with the com.google.test.loops.player_experience name to the execution. Scenarios can also be specified in the scenarios field.
        """
        return pulumi.get(self, "scenario_labels")

    @property
    @pulumi.getter
    def scenarios(self) -> Sequence[int]:
        """
        The list of scenarios that should be run during the test. The default is all test loops, derived from the application's manifest.
        """
        return pulumi.get(self, "scenarios")


@pulumi.output_type
class ApkResponse(dict):
    """
    An Android package file to install.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "packageName":
            suggest = "package_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location: 'outputs.FileReferenceResponse',
                 package_name: str):
        """
        An Android package file to install.
        :param 'FileReferenceResponse' location: The path to an APK to be installed on the device before the test begins.
        :param str package_name: The java package for the APK to be installed. Value is determined by examining the application's manifest.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "package_name", package_name)

    @property
    @pulumi.getter
    def location(self) -> 'outputs.FileReferenceResponse':
        """
        The path to an APK to be installed on the device before the test begins.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="packageName")
    def package_name(self) -> str:
        """
        The java package for the APK to be installed. Value is determined by examining the application's manifest.
        """
        return pulumi.get(self, "package_name")


@pulumi.output_type
class AppBundleResponse(dict):
    """
    An Android App Bundle file format, containing a BundleConfig.pb file, a base module directory, zero or more dynamic feature module directories. See https://developer.android.com/guide/app-bundle/build for guidance on building App Bundles.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bundleLocation":
            suggest = "bundle_location"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppBundleResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppBundleResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppBundleResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bundle_location: 'outputs.FileReferenceResponse'):
        """
        An Android App Bundle file format, containing a BundleConfig.pb file, a base module directory, zero or more dynamic feature module directories. See https://developer.android.com/guide/app-bundle/build for guidance on building App Bundles.
        :param 'FileReferenceResponse' bundle_location: .aab file representing the app bundle under test.
        """
        pulumi.set(__self__, "bundle_location", bundle_location)

    @property
    @pulumi.getter(name="bundleLocation")
    def bundle_location(self) -> 'outputs.FileReferenceResponse':
        """
        .aab file representing the app bundle under test.
        """
        return pulumi.get(self, "bundle_location")


@pulumi.output_type
class ClientInfoDetailResponse(dict):
    """
    Key-value pair of detailed information about the client which invoked the test. Examples: {'Version', '1.0'}, {'Release Track', 'BETA'}.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        Key-value pair of detailed information about the client which invoked the test. Examples: {'Version', '1.0'}, {'Release Track', 'BETA'}.
        :param str key: The key of detailed client information.
        :param str value: The value of detailed client information.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of detailed client information.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of detailed client information.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ClientInfoResponse(dict):
    """
    Information about the client which invoked the test.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientInfoDetails":
            suggest = "client_info_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClientInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClientInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClientInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_info_details: Sequence['outputs.ClientInfoDetailResponse'],
                 name: str):
        """
        Information about the client which invoked the test.
        :param Sequence['ClientInfoDetailResponse'] client_info_details: The list of detailed information about client.
        :param str name: Client name, such as gcloud.
        """
        pulumi.set(__self__, "client_info_details", client_info_details)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="clientInfoDetails")
    def client_info_details(self) -> Sequence['outputs.ClientInfoDetailResponse']:
        """
        The list of detailed information about client.
        """
        return pulumi.get(self, "client_info_details")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Client name, such as gcloud.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DeviceFileResponse(dict):
    """
    A single device file description.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "obbFile":
            suggest = "obb_file"
        elif key == "regularFile":
            suggest = "regular_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 obb_file: 'outputs.ObbFileResponse',
                 regular_file: 'outputs.RegularFileResponse'):
        """
        A single device file description.
        :param 'ObbFileResponse' obb_file: A reference to an opaque binary blob file.
        :param 'RegularFileResponse' regular_file: A reference to a regular file.
        """
        pulumi.set(__self__, "obb_file", obb_file)
        pulumi.set(__self__, "regular_file", regular_file)

    @property
    @pulumi.getter(name="obbFile")
    def obb_file(self) -> 'outputs.ObbFileResponse':
        """
        A reference to an opaque binary blob file.
        """
        return pulumi.get(self, "obb_file")

    @property
    @pulumi.getter(name="regularFile")
    def regular_file(self) -> 'outputs.RegularFileResponse':
        """
        A reference to a regular file.
        """
        return pulumi.get(self, "regular_file")


@pulumi.output_type
class EnvironmentMatrixResponse(dict):
    """
    The matrix of environments in which the test is to be executed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "androidDeviceList":
            suggest = "android_device_list"
        elif key == "androidMatrix":
            suggest = "android_matrix"
        elif key == "iosDeviceList":
            suggest = "ios_device_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentMatrixResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentMatrixResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentMatrixResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 android_device_list: 'outputs.AndroidDeviceListResponse',
                 android_matrix: 'outputs.AndroidMatrixResponse',
                 ios_device_list: 'outputs.IosDeviceListResponse'):
        """
        The matrix of environments in which the test is to be executed.
        :param 'AndroidDeviceListResponse' android_device_list: A list of Android devices; the test will be run only on the specified devices.
        :param 'AndroidMatrixResponse' android_matrix: A matrix of Android devices.
        :param 'IosDeviceListResponse' ios_device_list: A list of iOS devices.
        """
        pulumi.set(__self__, "android_device_list", android_device_list)
        pulumi.set(__self__, "android_matrix", android_matrix)
        pulumi.set(__self__, "ios_device_list", ios_device_list)

    @property
    @pulumi.getter(name="androidDeviceList")
    def android_device_list(self) -> 'outputs.AndroidDeviceListResponse':
        """
        A list of Android devices; the test will be run only on the specified devices.
        """
        return pulumi.get(self, "android_device_list")

    @property
    @pulumi.getter(name="androidMatrix")
    def android_matrix(self) -> 'outputs.AndroidMatrixResponse':
        """
        A matrix of Android devices.
        """
        return pulumi.get(self, "android_matrix")

    @property
    @pulumi.getter(name="iosDeviceList")
    def ios_device_list(self) -> 'outputs.IosDeviceListResponse':
        """
        A list of iOS devices.
        """
        return pulumi.get(self, "ios_device_list")


@pulumi.output_type
class EnvironmentResponse(dict):
    """
    The environment in which the test is run.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "androidDevice":
            suggest = "android_device"
        elif key == "iosDevice":
            suggest = "ios_device"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 android_device: 'outputs.AndroidDeviceResponse',
                 ios_device: 'outputs.IosDeviceResponse'):
        """
        The environment in which the test is run.
        :param 'AndroidDeviceResponse' android_device: An Android device which must be used with an Android test.
        :param 'IosDeviceResponse' ios_device: An iOS device which must be used with an iOS test.
        """
        pulumi.set(__self__, "android_device", android_device)
        pulumi.set(__self__, "ios_device", ios_device)

    @property
    @pulumi.getter(name="androidDevice")
    def android_device(self) -> 'outputs.AndroidDeviceResponse':
        """
        An Android device which must be used with an Android test.
        """
        return pulumi.get(self, "android_device")

    @property
    @pulumi.getter(name="iosDevice")
    def ios_device(self) -> 'outputs.IosDeviceResponse':
        """
        An iOS device which must be used with an iOS test.
        """
        return pulumi.get(self, "ios_device")


@pulumi.output_type
class EnvironmentVariableResponse(dict):
    """
    A key-value pair passed as an environment variable to the test.
    """
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        A key-value pair passed as an environment variable to the test.
        :param str key: Key for the environment variable.
        :param str value: Value for the environment variable.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Key for the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value for the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class FileReferenceResponse(dict):
    """
    A reference to a file, used for user inputs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcsPath":
            suggest = "gcs_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FileReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FileReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FileReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcs_path: str):
        """
        A reference to a file, used for user inputs.
        :param str gcs_path: A path to a file in Google Cloud Storage. Example: gs://build-app-1414623860166/app%40debug-unaligned.apk These paths are expected to be url encoded (percent encoding)
        """
        pulumi.set(__self__, "gcs_path", gcs_path)

    @property
    @pulumi.getter(name="gcsPath")
    def gcs_path(self) -> str:
        """
        A path to a file in Google Cloud Storage. Example: gs://build-app-1414623860166/app%40debug-unaligned.apk These paths are expected to be url encoded (percent encoding)
        """
        return pulumi.get(self, "gcs_path")


@pulumi.output_type
class GoogleAutoResponse(dict):
    """
    Enables automatic Google account login. If set, the service automatically generates a Google test account and adds it to the device, before executing the test. Note that test accounts might be reused. Many applications show their full set of functionalities when an account is present on the device. Logging into the device with these generated accounts allows testing more functionalities.
    """
    def __init__(__self__):
        """
        Enables automatic Google account login. If set, the service automatically generates a Google test account and adds it to the device, before executing the test. Note that test accounts might be reused. Many applications show their full set of functionalities when an account is present on the device. Logging into the device with these generated accounts allows testing more functionalities.
        """
        pass


@pulumi.output_type
class GoogleCloudStorageResponse(dict):
    """
    A storage location within Google cloud storage (GCS).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcsPath":
            suggest = "gcs_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudStorageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudStorageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudStorageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcs_path: str):
        """
        A storage location within Google cloud storage (GCS).
        :param str gcs_path: The path to a directory in GCS that will eventually contain the results for this test. The requesting user must have write access on the bucket in the supplied path.
        """
        pulumi.set(__self__, "gcs_path", gcs_path)

    @property
    @pulumi.getter(name="gcsPath")
    def gcs_path(self) -> str:
        """
        The path to a directory in GCS that will eventually contain the results for this test. The requesting user must have write access on the bucket in the supplied path.
        """
        return pulumi.get(self, "gcs_path")


@pulumi.output_type
class IosDeviceFileResponse(dict):
    """
    A file or directory to install on the device before the test starts.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bundleId":
            suggest = "bundle_id"
        elif key == "devicePath":
            suggest = "device_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IosDeviceFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IosDeviceFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IosDeviceFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bundle_id: str,
                 content: 'outputs.FileReferenceResponse',
                 device_path: str):
        """
        A file or directory to install on the device before the test starts.
        :param str bundle_id: The bundle id of the app where this file lives. iOS apps sandbox their own filesystem, so app files must specify which app installed on the device.
        :param 'FileReferenceResponse' content: The source file
        :param str device_path: Location of the file on the device, inside the app's sandboxed filesystem
        """
        pulumi.set(__self__, "bundle_id", bundle_id)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "device_path", device_path)

    @property
    @pulumi.getter(name="bundleId")
    def bundle_id(self) -> str:
        """
        The bundle id of the app where this file lives. iOS apps sandbox their own filesystem, so app files must specify which app installed on the device.
        """
        return pulumi.get(self, "bundle_id")

    @property
    @pulumi.getter
    def content(self) -> 'outputs.FileReferenceResponse':
        """
        The source file
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="devicePath")
    def device_path(self) -> str:
        """
        Location of the file on the device, inside the app's sandboxed filesystem
        """
        return pulumi.get(self, "device_path")


@pulumi.output_type
class IosDeviceListResponse(dict):
    """
    A list of iOS device configurations in which the test is to be executed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iosDevices":
            suggest = "ios_devices"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IosDeviceListResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IosDeviceListResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IosDeviceListResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ios_devices: Sequence['outputs.IosDeviceResponse']):
        """
        A list of iOS device configurations in which the test is to be executed.
        :param Sequence['IosDeviceResponse'] ios_devices: A list of iOS devices.
        """
        pulumi.set(__self__, "ios_devices", ios_devices)

    @property
    @pulumi.getter(name="iosDevices")
    def ios_devices(self) -> Sequence['outputs.IosDeviceResponse']:
        """
        A list of iOS devices.
        """
        return pulumi.get(self, "ios_devices")


@pulumi.output_type
class IosDeviceResponse(dict):
    """
    A single iOS device.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "iosModelId":
            suggest = "ios_model_id"
        elif key == "iosVersionId":
            suggest = "ios_version_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IosDeviceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IosDeviceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IosDeviceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ios_model_id: str,
                 ios_version_id: str,
                 locale: str,
                 orientation: str):
        """
        A single iOS device.
        :param str ios_model_id: The id of the iOS device to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        :param str ios_version_id: The id of the iOS major software version to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        :param str locale: The locale the test device used for testing. Use the TestEnvironmentDiscoveryService to get supported options.
        :param str orientation: How the device is oriented during the test. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        pulumi.set(__self__, "ios_model_id", ios_model_id)
        pulumi.set(__self__, "ios_version_id", ios_version_id)
        pulumi.set(__self__, "locale", locale)
        pulumi.set(__self__, "orientation", orientation)

    @property
    @pulumi.getter(name="iosModelId")
    def ios_model_id(self) -> str:
        """
        The id of the iOS device to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "ios_model_id")

    @property
    @pulumi.getter(name="iosVersionId")
    def ios_version_id(self) -> str:
        """
        The id of the iOS major software version to be used. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "ios_version_id")

    @property
    @pulumi.getter
    def locale(self) -> str:
        """
        The locale the test device used for testing. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "locale")

    @property
    @pulumi.getter
    def orientation(self) -> str:
        """
        How the device is oriented during the test. Use the TestEnvironmentDiscoveryService to get supported options.
        """
        return pulumi.get(self, "orientation")


@pulumi.output_type
class IosTestLoopResponse(dict):
    """
    A test of an iOS application that implements one or more game loop scenarios. This test type accepts an archived application (.ipa file) and a list of integer scenarios that will be executed on the app sequentially.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appBundleId":
            suggest = "app_bundle_id"
        elif key == "appIpa":
            suggest = "app_ipa"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IosTestLoopResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IosTestLoopResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IosTestLoopResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_bundle_id: str,
                 app_ipa: 'outputs.FileReferenceResponse',
                 scenarios: Sequence[int]):
        """
        A test of an iOS application that implements one or more game loop scenarios. This test type accepts an archived application (.ipa file) and a list of integer scenarios that will be executed on the app sequentially.
        :param str app_bundle_id: The bundle id for the application under test.
        :param 'FileReferenceResponse' app_ipa: The .ipa of the application to test.
        :param Sequence[int] scenarios: The list of scenarios that should be run during the test. Defaults to the single scenario 0 if unspecified.
        """
        pulumi.set(__self__, "app_bundle_id", app_bundle_id)
        pulumi.set(__self__, "app_ipa", app_ipa)
        pulumi.set(__self__, "scenarios", scenarios)

    @property
    @pulumi.getter(name="appBundleId")
    def app_bundle_id(self) -> str:
        """
        The bundle id for the application under test.
        """
        return pulumi.get(self, "app_bundle_id")

    @property
    @pulumi.getter(name="appIpa")
    def app_ipa(self) -> 'outputs.FileReferenceResponse':
        """
        The .ipa of the application to test.
        """
        return pulumi.get(self, "app_ipa")

    @property
    @pulumi.getter
    def scenarios(self) -> Sequence[int]:
        """
        The list of scenarios that should be run during the test. Defaults to the single scenario 0 if unspecified.
        """
        return pulumi.get(self, "scenarios")


@pulumi.output_type
class IosTestSetupResponse(dict):
    """
    A description of how to set up an iOS device prior to running the test.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalIpas":
            suggest = "additional_ipas"
        elif key == "networkProfile":
            suggest = "network_profile"
        elif key == "pullDirectories":
            suggest = "pull_directories"
        elif key == "pushFiles":
            suggest = "push_files"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IosTestSetupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IosTestSetupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IosTestSetupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_ipas: Sequence['outputs.FileReferenceResponse'],
                 network_profile: str,
                 pull_directories: Sequence['outputs.IosDeviceFileResponse'],
                 push_files: Sequence['outputs.IosDeviceFileResponse']):
        """
        A description of how to set up an iOS device prior to running the test.
        :param Sequence['FileReferenceResponse'] additional_ipas: iOS apps to install in addition to those being directly tested.
        :param str network_profile: The network traffic profile used for running the test. Available network profiles can be queried by using the NETWORK_CONFIGURATION environment type when calling TestEnvironmentDiscoveryService.GetTestEnvironmentCatalog.
        :param Sequence['IosDeviceFileResponse'] pull_directories: List of directories on the device to upload to Cloud Storage at the end of the test. Directories should either be in a shared directory (such as /private/var/mobile/Media) or within an accessible directory inside the app's filesystem (such as /Documents) by specifying the bundle ID.
        :param Sequence['IosDeviceFileResponse'] push_files: List of files to push to the device before starting the test.
        """
        pulumi.set(__self__, "additional_ipas", additional_ipas)
        pulumi.set(__self__, "network_profile", network_profile)
        pulumi.set(__self__, "pull_directories", pull_directories)
        pulumi.set(__self__, "push_files", push_files)

    @property
    @pulumi.getter(name="additionalIpas")
    def additional_ipas(self) -> Sequence['outputs.FileReferenceResponse']:
        """
        iOS apps to install in addition to those being directly tested.
        """
        return pulumi.get(self, "additional_ipas")

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> str:
        """
        The network traffic profile used for running the test. Available network profiles can be queried by using the NETWORK_CONFIGURATION environment type when calling TestEnvironmentDiscoveryService.GetTestEnvironmentCatalog.
        """
        return pulumi.get(self, "network_profile")

    @property
    @pulumi.getter(name="pullDirectories")
    def pull_directories(self) -> Sequence['outputs.IosDeviceFileResponse']:
        """
        List of directories on the device to upload to Cloud Storage at the end of the test. Directories should either be in a shared directory (such as /private/var/mobile/Media) or within an accessible directory inside the app's filesystem (such as /Documents) by specifying the bundle ID.
        """
        return pulumi.get(self, "pull_directories")

    @property
    @pulumi.getter(name="pushFiles")
    def push_files(self) -> Sequence['outputs.IosDeviceFileResponse']:
        """
        List of files to push to the device before starting the test.
        """
        return pulumi.get(self, "push_files")


@pulumi.output_type
class IosXcTestResponse(dict):
    """
    A test of an iOS application that uses the XCTest framework. Xcode supports the option to "build for testing", which generates an .xctestrun file that contains a test specification (arguments, test methods, etc). This test type accepts a zip file containing the .xctestrun file and the corresponding contents of the Build/Products directory that contains all the binaries needed to run the tests.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appBundleId":
            suggest = "app_bundle_id"
        elif key == "testSpecialEntitlements":
            suggest = "test_special_entitlements"
        elif key == "testsZip":
            suggest = "tests_zip"
        elif key == "xcodeVersion":
            suggest = "xcode_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IosXcTestResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IosXcTestResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IosXcTestResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_bundle_id: str,
                 test_special_entitlements: bool,
                 tests_zip: 'outputs.FileReferenceResponse',
                 xcode_version: str,
                 xctestrun: 'outputs.FileReferenceResponse'):
        """
        A test of an iOS application that uses the XCTest framework. Xcode supports the option to "build for testing", which generates an .xctestrun file that contains a test specification (arguments, test methods, etc). This test type accepts a zip file containing the .xctestrun file and the corresponding contents of the Build/Products directory that contains all the binaries needed to run the tests.
        :param str app_bundle_id: The bundle id for the application under test.
        :param bool test_special_entitlements: The option to test special app entitlements. Setting this would re-sign the app having special entitlements with an explicit application-identifier. Currently supports testing aps-environment entitlement.
        :param 'FileReferenceResponse' tests_zip: The .zip containing the .xctestrun file and the contents of the DerivedData/Build/Products directory. The .xctestrun file in this zip is ignored if the xctestrun field is specified.
        :param str xcode_version: The Xcode version that should be used for the test. Use the TestEnvironmentDiscoveryService to get supported options. Defaults to the latest Xcode version Firebase Test Lab supports.
        :param 'FileReferenceResponse' xctestrun: An .xctestrun file that will override the .xctestrun file in the tests zip. Because the .xctestrun file contains environment variables along with test methods to run and/or ignore, this can be useful for sharding tests. Default is taken from the tests zip.
        """
        pulumi.set(__self__, "app_bundle_id", app_bundle_id)
        pulumi.set(__self__, "test_special_entitlements", test_special_entitlements)
        pulumi.set(__self__, "tests_zip", tests_zip)
        pulumi.set(__self__, "xcode_version", xcode_version)
        pulumi.set(__self__, "xctestrun", xctestrun)

    @property
    @pulumi.getter(name="appBundleId")
    def app_bundle_id(self) -> str:
        """
        The bundle id for the application under test.
        """
        return pulumi.get(self, "app_bundle_id")

    @property
    @pulumi.getter(name="testSpecialEntitlements")
    def test_special_entitlements(self) -> bool:
        """
        The option to test special app entitlements. Setting this would re-sign the app having special entitlements with an explicit application-identifier. Currently supports testing aps-environment entitlement.
        """
        return pulumi.get(self, "test_special_entitlements")

    @property
    @pulumi.getter(name="testsZip")
    def tests_zip(self) -> 'outputs.FileReferenceResponse':
        """
        The .zip containing the .xctestrun file and the contents of the DerivedData/Build/Products directory. The .xctestrun file in this zip is ignored if the xctestrun field is specified.
        """
        return pulumi.get(self, "tests_zip")

    @property
    @pulumi.getter(name="xcodeVersion")
    def xcode_version(self) -> str:
        """
        The Xcode version that should be used for the test. Use the TestEnvironmentDiscoveryService to get supported options. Defaults to the latest Xcode version Firebase Test Lab supports.
        """
        return pulumi.get(self, "xcode_version")

    @property
    @pulumi.getter
    def xctestrun(self) -> 'outputs.FileReferenceResponse':
        """
        An .xctestrun file that will override the .xctestrun file in the tests zip. Because the .xctestrun file contains environment variables along with test methods to run and/or ignore, this can be useful for sharding tests. Default is taken from the tests zip.
        """
        return pulumi.get(self, "xctestrun")


@pulumi.output_type
class LauncherActivityIntentResponse(dict):
    """
    Specifies an intent that starts the main launcher activity.
    """
    def __init__(__self__):
        """
        Specifies an intent that starts the main launcher activity.
        """
        pass


@pulumi.output_type
class ManualShardingResponse(dict):
    """
    Shards test cases into the specified groups of packages, classes, and/or methods. With manual sharding enabled, specifying test targets via environment_variables or in InstrumentationTest is invalid.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "testTargetsForShard":
            suggest = "test_targets_for_shard"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManualShardingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManualShardingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManualShardingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 test_targets_for_shard: Sequence['outputs.TestTargetsForShardResponse']):
        """
        Shards test cases into the specified groups of packages, classes, and/or methods. With manual sharding enabled, specifying test targets via environment_variables or in InstrumentationTest is invalid.
        :param Sequence['TestTargetsForShardResponse'] test_targets_for_shard: Group of packages, classes, and/or test methods to be run for each shard. When any physical devices are selected, the number of test_targets_for_shard must be >= 1 and <= 50. When no physical devices are selected, the number must be >= 1 and <= 500.
        """
        pulumi.set(__self__, "test_targets_for_shard", test_targets_for_shard)

    @property
    @pulumi.getter(name="testTargetsForShard")
    def test_targets_for_shard(self) -> Sequence['outputs.TestTargetsForShardResponse']:
        """
        Group of packages, classes, and/or test methods to be run for each shard. When any physical devices are selected, the number of test_targets_for_shard must be >= 1 and <= 50. When no physical devices are selected, the number must be >= 1 and <= 500.
        """
        return pulumi.get(self, "test_targets_for_shard")


@pulumi.output_type
class ObbFileResponse(dict):
    """
    An opaque binary blob file to install on the device before the test starts.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "obbFileName":
            suggest = "obb_file_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObbFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObbFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObbFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 obb: 'outputs.FileReferenceResponse',
                 obb_file_name: str):
        """
        An opaque binary blob file to install on the device before the test starts.
        :param 'FileReferenceResponse' obb: Opaque Binary Blob (OBB) file(s) to install on the device.
        :param str obb_file_name: OBB file name which must conform to the format as specified by Android e.g. [main|patch].0300110.com.example.android.obb which will be installed into \/Android/obb/\/ on the device.
        """
        pulumi.set(__self__, "obb", obb)
        pulumi.set(__self__, "obb_file_name", obb_file_name)

    @property
    @pulumi.getter
    def obb(self) -> 'outputs.FileReferenceResponse':
        """
        Opaque Binary Blob (OBB) file(s) to install on the device.
        """
        return pulumi.get(self, "obb")

    @property
    @pulumi.getter(name="obbFileName")
    def obb_file_name(self) -> str:
        """
        OBB file name which must conform to the format as specified by Android e.g. [main|patch].0300110.com.example.android.obb which will be installed into \/Android/obb/\/ on the device.
        """
        return pulumi.get(self, "obb_file_name")


@pulumi.output_type
class RegularFileResponse(dict):
    """
    A file or directory to install on the device before the test starts.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "devicePath":
            suggest = "device_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegularFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegularFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegularFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 content: 'outputs.FileReferenceResponse',
                 device_path: str):
        """
        A file or directory to install on the device before the test starts.
        :param 'FileReferenceResponse' content: The source file.
        :param str device_path: Where to put the content on the device. Must be an absolute, allowlisted path. If the file exists, it will be replaced. The following device-side directories and any of their subdirectories are allowlisted: ${EXTERNAL_STORAGE}, /sdcard, or /storage ${ANDROID_DATA}/local/tmp, or /data/local/tmp Specifying a path outside of these directory trees is invalid. The paths /sdcard and /data will be made available and treated as implicit path substitutions. E.g. if /sdcard on a particular device does not map to external storage, the system will replace it with the external storage path prefix for that device and copy the file there. It is strongly advised to use the Environment API in app and test code to access files on the device in a portable way.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "device_path", device_path)

    @property
    @pulumi.getter
    def content(self) -> 'outputs.FileReferenceResponse':
        """
        The source file.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter(name="devicePath")
    def device_path(self) -> str:
        """
        Where to put the content on the device. Must be an absolute, allowlisted path. If the file exists, it will be replaced. The following device-side directories and any of their subdirectories are allowlisted: ${EXTERNAL_STORAGE}, /sdcard, or /storage ${ANDROID_DATA}/local/tmp, or /data/local/tmp Specifying a path outside of these directory trees is invalid. The paths /sdcard and /data will be made available and treated as implicit path substitutions. E.g. if /sdcard on a particular device does not map to external storage, the system will replace it with the external storage path prefix for that device and copy the file there. It is strongly advised to use the Environment API in app and test code to access files on the device in a portable way.
        """
        return pulumi.get(self, "device_path")


@pulumi.output_type
class ResultStorageResponse(dict):
    """
    Locations where the results of running the test are stored.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "googleCloudStorage":
            suggest = "google_cloud_storage"
        elif key == "resultsUrl":
            suggest = "results_url"
        elif key == "toolResultsExecution":
            suggest = "tool_results_execution"
        elif key == "toolResultsHistory":
            suggest = "tool_results_history"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ResultStorageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ResultStorageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ResultStorageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 google_cloud_storage: 'outputs.GoogleCloudStorageResponse',
                 results_url: str,
                 tool_results_execution: 'outputs.ToolResultsExecutionResponse',
                 tool_results_history: 'outputs.ToolResultsHistoryResponse'):
        """
        Locations where the results of running the test are stored.
        :param 'GoogleCloudStorageResponse' google_cloud_storage: Required.
        :param str results_url: URL to the results in the Firebase Web Console.
        :param 'ToolResultsExecutionResponse' tool_results_execution: The tool results execution that results are written to.
        :param 'ToolResultsHistoryResponse' tool_results_history: The tool results history that contains the tool results execution that results are written to. If not provided, the service will choose an appropriate value.
        """
        pulumi.set(__self__, "google_cloud_storage", google_cloud_storage)
        pulumi.set(__self__, "results_url", results_url)
        pulumi.set(__self__, "tool_results_execution", tool_results_execution)
        pulumi.set(__self__, "tool_results_history", tool_results_history)

    @property
    @pulumi.getter(name="googleCloudStorage")
    def google_cloud_storage(self) -> 'outputs.GoogleCloudStorageResponse':
        """
        Required.
        """
        return pulumi.get(self, "google_cloud_storage")

    @property
    @pulumi.getter(name="resultsUrl")
    def results_url(self) -> str:
        """
        URL to the results in the Firebase Web Console.
        """
        return pulumi.get(self, "results_url")

    @property
    @pulumi.getter(name="toolResultsExecution")
    def tool_results_execution(self) -> 'outputs.ToolResultsExecutionResponse':
        """
        The tool results execution that results are written to.
        """
        return pulumi.get(self, "tool_results_execution")

    @property
    @pulumi.getter(name="toolResultsHistory")
    def tool_results_history(self) -> 'outputs.ToolResultsHistoryResponse':
        """
        The tool results history that contains the tool results execution that results are written to. If not provided, the service will choose an appropriate value.
        """
        return pulumi.get(self, "tool_results_history")


@pulumi.output_type
class RoboDirectiveResponse(dict):
    """
    Directs Robo to interact with a specific UI element if it is encountered during the crawl. Currently, Robo can perform text entry or element click.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionType":
            suggest = "action_type"
        elif key == "inputText":
            suggest = "input_text"
        elif key == "resourceName":
            suggest = "resource_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoboDirectiveResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoboDirectiveResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoboDirectiveResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_type: str,
                 input_text: str,
                 resource_name: str):
        """
        Directs Robo to interact with a specific UI element if it is encountered during the crawl. Currently, Robo can perform text entry or element click.
        :param str action_type: The type of action that Robo should perform on the specified element.
        :param str input_text: The text that Robo is directed to set. If left empty, the directive will be treated as a CLICK on the element matching the resource_name.
        :param str resource_name: The android resource name of the target UI element. For example, in Java: R.string.foo in xml: @string/foo Only the "foo" part is needed. Reference doc: https://developer.android.com/guide/topics/resources/accessing-resources.html
        """
        pulumi.set(__self__, "action_type", action_type)
        pulumi.set(__self__, "input_text", input_text)
        pulumi.set(__self__, "resource_name", resource_name)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The type of action that Robo should perform on the specified element.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="inputText")
    def input_text(self) -> str:
        """
        The text that Robo is directed to set. If left empty, the directive will be treated as a CLICK on the element matching the resource_name.
        """
        return pulumi.get(self, "input_text")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> str:
        """
        The android resource name of the target UI element. For example, in Java: R.string.foo in xml: @string/foo Only the "foo" part is needed. Reference doc: https://developer.android.com/guide/topics/resources/accessing-resources.html
        """
        return pulumi.get(self, "resource_name")


@pulumi.output_type
class RoboStartingIntentResponse(dict):
    """
    Message for specifying the start activities to crawl.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "launcherActivity":
            suggest = "launcher_activity"
        elif key == "startActivity":
            suggest = "start_activity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RoboStartingIntentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RoboStartingIntentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RoboStartingIntentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 launcher_activity: 'outputs.LauncherActivityIntentResponse',
                 start_activity: 'outputs.StartActivityIntentResponse',
                 timeout: str):
        """
        Message for specifying the start activities to crawl.
        :param 'LauncherActivityIntentResponse' launcher_activity: An intent that starts the main launcher activity.
        :param 'StartActivityIntentResponse' start_activity: An intent that starts an activity with specific details.
        :param str timeout: Timeout in seconds for each intent.
        """
        pulumi.set(__self__, "launcher_activity", launcher_activity)
        pulumi.set(__self__, "start_activity", start_activity)
        pulumi.set(__self__, "timeout", timeout)

    @property
    @pulumi.getter(name="launcherActivity")
    def launcher_activity(self) -> 'outputs.LauncherActivityIntentResponse':
        """
        An intent that starts the main launcher activity.
        """
        return pulumi.get(self, "launcher_activity")

    @property
    @pulumi.getter(name="startActivity")
    def start_activity(self) -> 'outputs.StartActivityIntentResponse':
        """
        An intent that starts an activity with specific details.
        """
        return pulumi.get(self, "start_activity")

    @property
    @pulumi.getter
    def timeout(self) -> str:
        """
        Timeout in seconds for each intent.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ShardResponse(dict):
    """
    Output only. Details about the shard.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numShards":
            suggest = "num_shards"
        elif key == "shardIndex":
            suggest = "shard_index"
        elif key == "testTargetsForShard":
            suggest = "test_targets_for_shard"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 num_shards: int,
                 shard_index: int,
                 test_targets_for_shard: 'outputs.TestTargetsForShardResponse'):
        """
        Output only. Details about the shard.
        :param int num_shards: The total number of shards.
        :param int shard_index: The index of the shard among all the shards.
        :param 'TestTargetsForShardResponse' test_targets_for_shard: Test targets for each shard.
        """
        pulumi.set(__self__, "num_shards", num_shards)
        pulumi.set(__self__, "shard_index", shard_index)
        pulumi.set(__self__, "test_targets_for_shard", test_targets_for_shard)

    @property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> int:
        """
        The total number of shards.
        """
        return pulumi.get(self, "num_shards")

    @property
    @pulumi.getter(name="shardIndex")
    def shard_index(self) -> int:
        """
        The index of the shard among all the shards.
        """
        return pulumi.get(self, "shard_index")

    @property
    @pulumi.getter(name="testTargetsForShard")
    def test_targets_for_shard(self) -> 'outputs.TestTargetsForShardResponse':
        """
        Test targets for each shard.
        """
        return pulumi.get(self, "test_targets_for_shard")


@pulumi.output_type
class ShardingOptionResponse(dict):
    """
    Options for enabling sharding.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manualSharding":
            suggest = "manual_sharding"
        elif key == "uniformSharding":
            suggest = "uniform_sharding"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShardingOptionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShardingOptionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShardingOptionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 manual_sharding: 'outputs.ManualShardingResponse',
                 uniform_sharding: 'outputs.UniformShardingResponse'):
        """
        Options for enabling sharding.
        :param 'ManualShardingResponse' manual_sharding: Shards test cases into the specified groups of packages, classes, and/or methods.
        :param 'UniformShardingResponse' uniform_sharding: Uniformly shards test cases given a total number of shards.
        """
        pulumi.set(__self__, "manual_sharding", manual_sharding)
        pulumi.set(__self__, "uniform_sharding", uniform_sharding)

    @property
    @pulumi.getter(name="manualSharding")
    def manual_sharding(self) -> 'outputs.ManualShardingResponse':
        """
        Shards test cases into the specified groups of packages, classes, and/or methods.
        """
        return pulumi.get(self, "manual_sharding")

    @property
    @pulumi.getter(name="uniformSharding")
    def uniform_sharding(self) -> 'outputs.UniformShardingResponse':
        """
        Uniformly shards test cases given a total number of shards.
        """
        return pulumi.get(self, "uniform_sharding")


@pulumi.output_type
class StartActivityIntentResponse(dict):
    """
    A starting intent specified by an action, uri, and categories.
    """
    def __init__(__self__, *,
                 action: str,
                 categories: Sequence[str],
                 uri: str):
        """
        A starting intent specified by an action, uri, and categories.
        :param str action: Action name. Required for START_ACTIVITY.
        :param Sequence[str] categories: Intent categories to set on the intent.
        :param str uri: URI for the action.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "categories", categories)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Action name. Required for START_ACTIVITY.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def categories(self) -> Sequence[str]:
        """
        Intent categories to set on the intent.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter
    def uri(self) -> str:
        """
        URI for the action.
        """
        return pulumi.get(self, "uri")


@pulumi.output_type
class SystraceSetupResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "durationSeconds":
            suggest = "duration_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SystraceSetupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SystraceSetupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SystraceSetupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 duration_seconds: int):
        """
        :param int duration_seconds: Systrace duration in seconds. Should be between 1 and 30 seconds. 0 disables systrace.
        """
        pulumi.set(__self__, "duration_seconds", duration_seconds)

    @property
    @pulumi.getter(name="durationSeconds")
    def duration_seconds(self) -> int:
        """
        Systrace duration in seconds. Should be between 1 and 30 seconds. 0 disables systrace.
        """
        return pulumi.get(self, "duration_seconds")


@pulumi.output_type
class TestDetailsResponse(dict):
    """
    Additional details about the progress of the running test.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "errorMessage":
            suggest = "error_message"
        elif key == "progressMessages":
            suggest = "progress_messages"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TestDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TestDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TestDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 error_message: str,
                 progress_messages: Sequence[str]):
        """
        Additional details about the progress of the running test.
        :param str error_message: If the TestState is ERROR, then this string will contain human-readable details about the error.
        :param Sequence[str] progress_messages: Human-readable, detailed descriptions of the test's progress. For example: "Provisioning a device", "Starting Test". During the course of execution new data may be appended to the end of progress_messages.
        """
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "progress_messages", progress_messages)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        If the TestState is ERROR, then this string will contain human-readable details about the error.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="progressMessages")
    def progress_messages(self) -> Sequence[str]:
        """
        Human-readable, detailed descriptions of the test's progress. For example: "Provisioning a device", "Starting Test". During the course of execution new data may be appended to the end of progress_messages.
        """
        return pulumi.get(self, "progress_messages")


@pulumi.output_type
class TestExecutionResponse(dict):
    """
    A single test executed in a single environment.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "matrixId":
            suggest = "matrix_id"
        elif key == "testDetails":
            suggest = "test_details"
        elif key == "testSpecification":
            suggest = "test_specification"
        elif key == "toolResultsStep":
            suggest = "tool_results_step"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TestExecutionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TestExecutionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TestExecutionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 environment: 'outputs.EnvironmentResponse',
                 matrix_id: str,
                 project: str,
                 shard: 'outputs.ShardResponse',
                 state: str,
                 test_details: 'outputs.TestDetailsResponse',
                 test_specification: 'outputs.TestSpecificationResponse',
                 timestamp: str,
                 tool_results_step: 'outputs.ToolResultsStepResponse'):
        """
        A single test executed in a single environment.
        :param 'EnvironmentResponse' environment: How the host machine(s) are configured.
        :param str matrix_id: Id of the containing TestMatrix.
        :param str project: The cloud project that owns the test execution.
        :param 'ShardResponse' shard: Details about the shard.
        :param str state: Indicates the current progress of the test execution (e.g., FINISHED).
        :param 'TestDetailsResponse' test_details: Additional details about the running test.
        :param 'TestSpecificationResponse' test_specification: How to run the test.
        :param str timestamp: The time this test execution was initially created.
        :param 'ToolResultsStepResponse' tool_results_step: Where the results for this execution are written.
        """
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "matrix_id", matrix_id)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "shard", shard)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "test_details", test_details)
        pulumi.set(__self__, "test_specification", test_specification)
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "tool_results_step", tool_results_step)

    @property
    @pulumi.getter
    def environment(self) -> 'outputs.EnvironmentResponse':
        """
        How the host machine(s) are configured.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter(name="matrixId")
    def matrix_id(self) -> str:
        """
        Id of the containing TestMatrix.
        """
        return pulumi.get(self, "matrix_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The cloud project that owns the test execution.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter
    def shard(self) -> 'outputs.ShardResponse':
        """
        Details about the shard.
        """
        return pulumi.get(self, "shard")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Indicates the current progress of the test execution (e.g., FINISHED).
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="testDetails")
    def test_details(self) -> 'outputs.TestDetailsResponse':
        """
        Additional details about the running test.
        """
        return pulumi.get(self, "test_details")

    @property
    @pulumi.getter(name="testSpecification")
    def test_specification(self) -> 'outputs.TestSpecificationResponse':
        """
        How to run the test.
        """
        return pulumi.get(self, "test_specification")

    @property
    @pulumi.getter
    def timestamp(self) -> str:
        """
        The time this test execution was initially created.
        """
        return pulumi.get(self, "timestamp")

    @property
    @pulumi.getter(name="toolResultsStep")
    def tool_results_step(self) -> 'outputs.ToolResultsStepResponse':
        """
        Where the results for this execution are written.
        """
        return pulumi.get(self, "tool_results_step")


@pulumi.output_type
class TestSetupResponse(dict):
    """
    A description of how to set up the Android device prior to running the test.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalApks":
            suggest = "additional_apks"
        elif key == "directoriesToPull":
            suggest = "directories_to_pull"
        elif key == "dontAutograntPermissions":
            suggest = "dont_autogrant_permissions"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "filesToPush":
            suggest = "files_to_push"
        elif key == "networkProfile":
            suggest = "network_profile"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TestSetupResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TestSetupResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TestSetupResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account: 'outputs.AccountResponse',
                 additional_apks: Sequence['outputs.ApkResponse'],
                 directories_to_pull: Sequence[str],
                 dont_autogrant_permissions: bool,
                 environment_variables: Sequence['outputs.EnvironmentVariableResponse'],
                 files_to_push: Sequence['outputs.DeviceFileResponse'],
                 network_profile: str,
                 systrace: 'outputs.SystraceSetupResponse'):
        """
        A description of how to set up the Android device prior to running the test.
        :param 'AccountResponse' account: The device will be logged in on this account for the duration of the test.
        :param Sequence['ApkResponse'] additional_apks: APKs to install in addition to those being directly tested. Currently capped at 100.
        :param Sequence[str] directories_to_pull: List of directories on the device to upload to GCS at the end of the test; they must be absolute paths under /sdcard, /storage or /data/local/tmp. Path names are restricted to characters a-z A-Z 0-9 _ - . + and / Note: The paths /sdcard and /data will be made available and treated as implicit path substitutions. E.g. if /sdcard on a particular device does not map to external storage, the system will replace it with the external storage path prefix for that device.
        :param bool dont_autogrant_permissions: Whether to prevent all runtime permissions to be granted at app install
        :param Sequence['EnvironmentVariableResponse'] environment_variables: Environment variables to set for the test (only applicable for instrumentation tests).
        :param Sequence['DeviceFileResponse'] files_to_push: List of files to push to the device before starting the test.
        :param str network_profile: The network traffic profile used for running the test. Available network profiles can be queried by using the NETWORK_CONFIGURATION environment type when calling TestEnvironmentDiscoveryService.GetTestEnvironmentCatalog.
        :param 'SystraceSetupResponse' systrace: Deprecated: Systrace uses Python 2 which has been sunset 2020-01-01. Support of Systrace may stop at any time, at which point no Systrace file will be provided in the results. Systrace configuration for the run. If set a systrace will be taken, starting on test start and lasting for the configured duration. The systrace file thus obtained is put in the results bucket together with the other artifacts from the run.
        """
        pulumi.set(__self__, "account", account)
        pulumi.set(__self__, "additional_apks", additional_apks)
        pulumi.set(__self__, "directories_to_pull", directories_to_pull)
        pulumi.set(__self__, "dont_autogrant_permissions", dont_autogrant_permissions)
        pulumi.set(__self__, "environment_variables", environment_variables)
        pulumi.set(__self__, "files_to_push", files_to_push)
        pulumi.set(__self__, "network_profile", network_profile)
        pulumi.set(__self__, "systrace", systrace)

    @property
    @pulumi.getter
    def account(self) -> 'outputs.AccountResponse':
        """
        The device will be logged in on this account for the duration of the test.
        """
        return pulumi.get(self, "account")

    @property
    @pulumi.getter(name="additionalApks")
    def additional_apks(self) -> Sequence['outputs.ApkResponse']:
        """
        APKs to install in addition to those being directly tested. Currently capped at 100.
        """
        return pulumi.get(self, "additional_apks")

    @property
    @pulumi.getter(name="directoriesToPull")
    def directories_to_pull(self) -> Sequence[str]:
        """
        List of directories on the device to upload to GCS at the end of the test; they must be absolute paths under /sdcard, /storage or /data/local/tmp. Path names are restricted to characters a-z A-Z 0-9 _ - . + and / Note: The paths /sdcard and /data will be made available and treated as implicit path substitutions. E.g. if /sdcard on a particular device does not map to external storage, the system will replace it with the external storage path prefix for that device.
        """
        return pulumi.get(self, "directories_to_pull")

    @property
    @pulumi.getter(name="dontAutograntPermissions")
    def dont_autogrant_permissions(self) -> bool:
        """
        Whether to prevent all runtime permissions to be granted at app install
        """
        return pulumi.get(self, "dont_autogrant_permissions")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Sequence['outputs.EnvironmentVariableResponse']:
        """
        Environment variables to set for the test (only applicable for instrumentation tests).
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="filesToPush")
    def files_to_push(self) -> Sequence['outputs.DeviceFileResponse']:
        """
        List of files to push to the device before starting the test.
        """
        return pulumi.get(self, "files_to_push")

    @property
    @pulumi.getter(name="networkProfile")
    def network_profile(self) -> str:
        """
        The network traffic profile used for running the test. Available network profiles can be queried by using the NETWORK_CONFIGURATION environment type when calling TestEnvironmentDiscoveryService.GetTestEnvironmentCatalog.
        """
        return pulumi.get(self, "network_profile")

    @property
    @pulumi.getter
    def systrace(self) -> 'outputs.SystraceSetupResponse':
        """
        Deprecated: Systrace uses Python 2 which has been sunset 2020-01-01. Support of Systrace may stop at any time, at which point no Systrace file will be provided in the results. Systrace configuration for the run. If set a systrace will be taken, starting on test start and lasting for the configured duration. The systrace file thus obtained is put in the results bucket together with the other artifacts from the run.
        """
        return pulumi.get(self, "systrace")


@pulumi.output_type
class TestSpecificationResponse(dict):
    """
    A description of how to run the test.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "androidInstrumentationTest":
            suggest = "android_instrumentation_test"
        elif key == "androidRoboTest":
            suggest = "android_robo_test"
        elif key == "androidTestLoop":
            suggest = "android_test_loop"
        elif key == "disablePerformanceMetrics":
            suggest = "disable_performance_metrics"
        elif key == "disableVideoRecording":
            suggest = "disable_video_recording"
        elif key == "iosTestLoop":
            suggest = "ios_test_loop"
        elif key == "iosTestSetup":
            suggest = "ios_test_setup"
        elif key == "iosXcTest":
            suggest = "ios_xc_test"
        elif key == "testSetup":
            suggest = "test_setup"
        elif key == "testTimeout":
            suggest = "test_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TestSpecificationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TestSpecificationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TestSpecificationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 android_instrumentation_test: 'outputs.AndroidInstrumentationTestResponse',
                 android_robo_test: 'outputs.AndroidRoboTestResponse',
                 android_test_loop: 'outputs.AndroidTestLoopResponse',
                 disable_performance_metrics: bool,
                 disable_video_recording: bool,
                 ios_test_loop: 'outputs.IosTestLoopResponse',
                 ios_test_setup: 'outputs.IosTestSetupResponse',
                 ios_xc_test: 'outputs.IosXcTestResponse',
                 test_setup: 'outputs.TestSetupResponse',
                 test_timeout: str):
        """
        A description of how to run the test.
        :param 'AndroidInstrumentationTestResponse' android_instrumentation_test: An Android instrumentation test.
        :param 'AndroidRoboTestResponse' android_robo_test: An Android robo test.
        :param 'AndroidTestLoopResponse' android_test_loop: An Android Application with a Test Loop.
        :param bool disable_performance_metrics: Disables performance metrics recording. May reduce test latency.
        :param bool disable_video_recording: Disables video recording. May reduce test latency.
        :param 'IosTestLoopResponse' ios_test_loop: An iOS application with a test loop.
        :param 'IosTestSetupResponse' ios_test_setup: Test setup requirements for iOS.
        :param 'IosXcTestResponse' ios_xc_test: An iOS XCTest, via an .xctestrun file.
        :param 'TestSetupResponse' test_setup: Test setup requirements for Android e.g. files to install, bootstrap scripts.
        :param str test_timeout: Max time a test execution is allowed to run before it is automatically cancelled. The default value is 5 min.
        """
        pulumi.set(__self__, "android_instrumentation_test", android_instrumentation_test)
        pulumi.set(__self__, "android_robo_test", android_robo_test)
        pulumi.set(__self__, "android_test_loop", android_test_loop)
        pulumi.set(__self__, "disable_performance_metrics", disable_performance_metrics)
        pulumi.set(__self__, "disable_video_recording", disable_video_recording)
        pulumi.set(__self__, "ios_test_loop", ios_test_loop)
        pulumi.set(__self__, "ios_test_setup", ios_test_setup)
        pulumi.set(__self__, "ios_xc_test", ios_xc_test)
        pulumi.set(__self__, "test_setup", test_setup)
        pulumi.set(__self__, "test_timeout", test_timeout)

    @property
    @pulumi.getter(name="androidInstrumentationTest")
    def android_instrumentation_test(self) -> 'outputs.AndroidInstrumentationTestResponse':
        """
        An Android instrumentation test.
        """
        return pulumi.get(self, "android_instrumentation_test")

    @property
    @pulumi.getter(name="androidRoboTest")
    def android_robo_test(self) -> 'outputs.AndroidRoboTestResponse':
        """
        An Android robo test.
        """
        return pulumi.get(self, "android_robo_test")

    @property
    @pulumi.getter(name="androidTestLoop")
    def android_test_loop(self) -> 'outputs.AndroidTestLoopResponse':
        """
        An Android Application with a Test Loop.
        """
        return pulumi.get(self, "android_test_loop")

    @property
    @pulumi.getter(name="disablePerformanceMetrics")
    def disable_performance_metrics(self) -> bool:
        """
        Disables performance metrics recording. May reduce test latency.
        """
        return pulumi.get(self, "disable_performance_metrics")

    @property
    @pulumi.getter(name="disableVideoRecording")
    def disable_video_recording(self) -> bool:
        """
        Disables video recording. May reduce test latency.
        """
        return pulumi.get(self, "disable_video_recording")

    @property
    @pulumi.getter(name="iosTestLoop")
    def ios_test_loop(self) -> 'outputs.IosTestLoopResponse':
        """
        An iOS application with a test loop.
        """
        return pulumi.get(self, "ios_test_loop")

    @property
    @pulumi.getter(name="iosTestSetup")
    def ios_test_setup(self) -> 'outputs.IosTestSetupResponse':
        """
        Test setup requirements for iOS.
        """
        return pulumi.get(self, "ios_test_setup")

    @property
    @pulumi.getter(name="iosXcTest")
    def ios_xc_test(self) -> 'outputs.IosXcTestResponse':
        """
        An iOS XCTest, via an .xctestrun file.
        """
        return pulumi.get(self, "ios_xc_test")

    @property
    @pulumi.getter(name="testSetup")
    def test_setup(self) -> 'outputs.TestSetupResponse':
        """
        Test setup requirements for Android e.g. files to install, bootstrap scripts.
        """
        return pulumi.get(self, "test_setup")

    @property
    @pulumi.getter(name="testTimeout")
    def test_timeout(self) -> str:
        """
        Max time a test execution is allowed to run before it is automatically cancelled. The default value is 5 min.
        """
        return pulumi.get(self, "test_timeout")


@pulumi.output_type
class TestTargetsForShardResponse(dict):
    """
    Test targets for a shard.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "testTargets":
            suggest = "test_targets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TestTargetsForShardResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TestTargetsForShardResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TestTargetsForShardResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 test_targets: Sequence[str]):
        """
        Test targets for a shard.
        :param Sequence[str] test_targets: Group of packages, classes, and/or test methods to be run for each shard. The targets need to be specified in AndroidJUnitRunner argument format. For example, "package com.my.packages" "class com.my.package.MyClass". The number of shard_test_targets must be greater than 0.
        """
        pulumi.set(__self__, "test_targets", test_targets)

    @property
    @pulumi.getter(name="testTargets")
    def test_targets(self) -> Sequence[str]:
        """
        Group of packages, classes, and/or test methods to be run for each shard. The targets need to be specified in AndroidJUnitRunner argument format. For example, "package com.my.packages" "class com.my.package.MyClass". The number of shard_test_targets must be greater than 0.
        """
        return pulumi.get(self, "test_targets")


@pulumi.output_type
class ToolResultsExecutionResponse(dict):
    """
    Represents a tool results execution resource. This has the results of a TestMatrix.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionId":
            suggest = "execution_id"
        elif key == "historyId":
            suggest = "history_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ToolResultsExecutionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ToolResultsExecutionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ToolResultsExecutionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_id: str,
                 history_id: str,
                 project: str):
        """
        Represents a tool results execution resource. This has the results of a TestMatrix.
        :param str execution_id: A tool results execution ID.
        :param str history_id: A tool results history ID.
        :param str project: The cloud project that owns the tool results execution.
        """
        pulumi.set(__self__, "execution_id", execution_id)
        pulumi.set(__self__, "history_id", history_id)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="executionId")
    def execution_id(self) -> str:
        """
        A tool results execution ID.
        """
        return pulumi.get(self, "execution_id")

    @property
    @pulumi.getter(name="historyId")
    def history_id(self) -> str:
        """
        A tool results history ID.
        """
        return pulumi.get(self, "history_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The cloud project that owns the tool results execution.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class ToolResultsHistoryResponse(dict):
    """
    Represents a tool results history resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "historyId":
            suggest = "history_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ToolResultsHistoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ToolResultsHistoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ToolResultsHistoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 history_id: str,
                 project: str):
        """
        Represents a tool results history resource.
        :param str history_id: A tool results history ID.
        :param str project: The cloud project that owns the tool results history.
        """
        pulumi.set(__self__, "history_id", history_id)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="historyId")
    def history_id(self) -> str:
        """
        A tool results history ID.
        """
        return pulumi.get(self, "history_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The cloud project that owns the tool results history.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class ToolResultsStepResponse(dict):
    """
    Represents a tool results step resource. This has the results of a TestExecution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionId":
            suggest = "execution_id"
        elif key == "historyId":
            suggest = "history_id"
        elif key == "stepId":
            suggest = "step_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ToolResultsStepResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ToolResultsStepResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ToolResultsStepResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_id: str,
                 history_id: str,
                 project: str,
                 step_id: str):
        """
        Represents a tool results step resource. This has the results of a TestExecution.
        :param str execution_id: A tool results execution ID.
        :param str history_id: A tool results history ID.
        :param str project: The cloud project that owns the tool results step.
        :param str step_id: A tool results step ID.
        """
        pulumi.set(__self__, "execution_id", execution_id)
        pulumi.set(__self__, "history_id", history_id)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "step_id", step_id)

    @property
    @pulumi.getter(name="executionId")
    def execution_id(self) -> str:
        """
        A tool results execution ID.
        """
        return pulumi.get(self, "execution_id")

    @property
    @pulumi.getter(name="historyId")
    def history_id(self) -> str:
        """
        A tool results history ID.
        """
        return pulumi.get(self, "history_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The cloud project that owns the tool results step.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> str:
        """
        A tool results step ID.
        """
        return pulumi.get(self, "step_id")


@pulumi.output_type
class UniformShardingResponse(dict):
    """
    Uniformly shards test cases given a total number of shards. For Instrumentation test, it will be translated to "-e numShard" "-e shardIndex" AndroidJUnitRunner arguments. Based on the sharding mechanism AndroidJUnitRunner uses, there is no guarantee that test cases will be distributed uniformly across all shards. With uniform sharding enabled, specifying these sharding arguments via environment_variables is invalid.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "numShards":
            suggest = "num_shards"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UniformShardingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UniformShardingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UniformShardingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 num_shards: int):
        """
        Uniformly shards test cases given a total number of shards. For Instrumentation test, it will be translated to "-e numShard" "-e shardIndex" AndroidJUnitRunner arguments. Based on the sharding mechanism AndroidJUnitRunner uses, there is no guarantee that test cases will be distributed uniformly across all shards. With uniform sharding enabled, specifying these sharding arguments via environment_variables is invalid.
        :param int num_shards: Total number of shards. When any physical devices are selected, the number must be >= 1 and <= 50. When no physical devices are selected, the number must be >= 1 and <= 500.
        """
        pulumi.set(__self__, "num_shards", num_shards)

    @property
    @pulumi.getter(name="numShards")
    def num_shards(self) -> int:
        """
        Total number of shards. When any physical devices are selected, the number must be >= 1 and <= 50. When no physical devices are selected, the number must be >= 1 and <= 500.
        """
        return pulumi.get(self, "num_shards")


