# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetPhraseSetResult',
    'AwaitableGetPhraseSetResult',
    'get_phrase_set',
    'get_phrase_set_output',
]

@pulumi.output_type
class GetPhraseSetResult:
    def __init__(__self__, boost=None, name=None, phrases=None):
        if boost and not isinstance(boost, float):
            raise TypeError("Expected argument 'boost' to be a float")
        pulumi.set(__self__, "boost", boost)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if phrases and not isinstance(phrases, list):
            raise TypeError("Expected argument 'phrases' to be a list")
        pulumi.set(__self__, "phrases", phrases)

    @property
    @pulumi.getter
    def boost(self) -> float:
        """
        Hint Boost. Positive value will increase the probability that a specific phrase will be recognized over other similar sounding phrases. The higher the boost, the higher the chance of false positive recognition as well. Negative boost values would correspond to anti-biasing. Anti-biasing is not enabled, so negative boost will simply be ignored. Though `boost` can accept a wide range of positive values, most use cases are best served with values between 0 (exclusive) and 20. We recommend using a binary search approach to finding the optimal value for your use case. Speech recognition will skip PhraseSets with a boost value of 0.
        """
        return pulumi.get(self, "boost")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The resource name of the phrase set.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def phrases(self) -> Sequence['outputs.PhraseResponse']:
        """
        A list of word and phrases.
        """
        return pulumi.get(self, "phrases")


class AwaitableGetPhraseSetResult(GetPhraseSetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetPhraseSetResult(
            boost=self.boost,
            name=self.name,
            phrases=self.phrases)


def get_phrase_set(location: Optional[str] = None,
                   phrase_set_id: Optional[str] = None,
                   project: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetPhraseSetResult:
    """
    Get a phrase set.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['phraseSetId'] = phrase_set_id
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:speech/v1:getPhraseSet', __args__, opts=opts, typ=GetPhraseSetResult).value

    return AwaitableGetPhraseSetResult(
        boost=__ret__.boost,
        name=__ret__.name,
        phrases=__ret__.phrases)


@_utilities.lift_output_func(get_phrase_set)
def get_phrase_set_output(location: Optional[pulumi.Input[str]] = None,
                          phrase_set_id: Optional[pulumi.Input[str]] = None,
                          project: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetPhraseSetResult]:
    """
    Get a phrase set.
    """
    ...
