# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SpokeArgs', 'Spoke']

@pulumi.input_type
class SpokeArgs:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hub: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_interconnect_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 linked_router_appliance_instances: Optional[pulumi.Input[Sequence[pulumi.Input['RouterApplianceInstanceArgs']]]] = None,
                 linked_vpn_tunnels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 spoke_id: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Spoke resource.
        :param pulumi.Input[str] create_time: The time when the Spoke was created.
        :param pulumi.Input[str] description: Short description of the spoke resource
        :param pulumi.Input[str] hub: The resource URL of the hub resource that the spoke is attached to
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] linked_interconnect_attachments: The URIs of linked interconnect attachment resources
        :param pulumi.Input[Sequence[pulumi.Input['RouterApplianceInstanceArgs']]] linked_router_appliance_instances: The URIs of linked Router appliance resources
        :param pulumi.Input[Sequence[pulumi.Input[str]]] linked_vpn_tunnels: The URIs of linked VPN tunnel resources
        :param pulumi.Input[str] name: Immutable. The name of a Spoke resource.
        :param pulumi.Input[str] request_id: Optional. An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        :param pulumi.Input[str] spoke_id: Optional. Unique id for the Spoke to create.
        :param pulumi.Input[str] update_time: The time when the Spoke was updated.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if hub is not None:
            pulumi.set(__self__, "hub", hub)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if linked_interconnect_attachments is not None:
            pulumi.set(__self__, "linked_interconnect_attachments", linked_interconnect_attachments)
        if linked_router_appliance_instances is not None:
            pulumi.set(__self__, "linked_router_appliance_instances", linked_router_appliance_instances)
        if linked_vpn_tunnels is not None:
            pulumi.set(__self__, "linked_vpn_tunnels", linked_vpn_tunnels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if spoke_id is not None:
            pulumi.set(__self__, "spoke_id", spoke_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the Spoke was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Short description of the spoke resource
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def hub(self) -> Optional[pulumi.Input[str]]:
        """
        The resource URL of the hub resource that the spoke is attached to
        """
        return pulumi.get(self, "hub")

    @hub.setter
    def hub(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hub", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        User-defined labels.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="linkedInterconnectAttachments")
    def linked_interconnect_attachments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The URIs of linked interconnect attachment resources
        """
        return pulumi.get(self, "linked_interconnect_attachments")

    @linked_interconnect_attachments.setter
    def linked_interconnect_attachments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "linked_interconnect_attachments", value)

    @property
    @pulumi.getter(name="linkedRouterApplianceInstances")
    def linked_router_appliance_instances(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RouterApplianceInstanceArgs']]]]:
        """
        The URIs of linked Router appliance resources
        """
        return pulumi.get(self, "linked_router_appliance_instances")

    @linked_router_appliance_instances.setter
    def linked_router_appliance_instances(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RouterApplianceInstanceArgs']]]]):
        pulumi.set(self, "linked_router_appliance_instances", value)

    @property
    @pulumi.getter(name="linkedVpnTunnels")
    def linked_vpn_tunnels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The URIs of linked VPN tunnel resources
        """
        return pulumi.get(self, "linked_vpn_tunnels")

    @linked_vpn_tunnels.setter
    def linked_vpn_tunnels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "linked_vpn_tunnels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. The name of a Spoke resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        """
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter(name="spokeId")
    def spoke_id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Unique id for the Spoke to create.
        """
        return pulumi.get(self, "spoke_id")

    @spoke_id.setter
    def spoke_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "spoke_id", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the Spoke was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Spoke(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hub: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_interconnect_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 linked_router_appliance_instances: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterApplianceInstanceArgs']]]]] = None,
                 linked_vpn_tunnels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 spoke_id: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates a new Spoke in a given project and location.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: The time when the Spoke was created.
        :param pulumi.Input[str] description: Short description of the spoke resource
        :param pulumi.Input[str] hub: The resource URL of the hub resource that the spoke is attached to
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: User-defined labels.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] linked_interconnect_attachments: The URIs of linked interconnect attachment resources
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterApplianceInstanceArgs']]]] linked_router_appliance_instances: The URIs of linked Router appliance resources
        :param pulumi.Input[Sequence[pulumi.Input[str]]] linked_vpn_tunnels: The URIs of linked VPN tunnel resources
        :param pulumi.Input[str] name: Immutable. The name of a Spoke resource.
        :param pulumi.Input[str] request_id: Optional. An optional request ID to identify requests. Specify a unique request ID so that if you must retry your request, the server will know to ignore the request if it has already been completed. The server will guarantee that for at least 60 minutes since the first request. For example, consider a situation where you make an initial request and t he request times out. If you make the request again with the same request ID, the server can check if original operation with the same request ID was received, and if so, will ignore the second request. This prevents clients from accidentally creating duplicate commitments. The request ID must be a valid UUID with the exception that zero UUID is not supported (00000000-0000-0000-0000-000000000000).
        :param pulumi.Input[str] spoke_id: Optional. Unique id for the Spoke to create.
        :param pulumi.Input[str] update_time: The time when the Spoke was updated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[SpokeArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new Spoke in a given project and location.

        :param str resource_name: The name of the resource.
        :param SpokeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpokeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 hub: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 linked_interconnect_attachments: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 linked_router_appliance_instances: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RouterApplianceInstanceArgs']]]]] = None,
                 linked_vpn_tunnels: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 spoke_id: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpokeArgs.__new__(SpokeArgs)

            __props__.__dict__["create_time"] = create_time
            __props__.__dict__["description"] = description
            __props__.__dict__["hub"] = hub
            __props__.__dict__["labels"] = labels
            __props__.__dict__["linked_interconnect_attachments"] = linked_interconnect_attachments
            __props__.__dict__["linked_router_appliance_instances"] = linked_router_appliance_instances
            __props__.__dict__["linked_vpn_tunnels"] = linked_vpn_tunnels
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["request_id"] = request_id
            __props__.__dict__["spoke_id"] = spoke_id
            __props__.__dict__["update_time"] = update_time
            __props__.__dict__["state"] = None
            __props__.__dict__["unique_id"] = None
        super(Spoke, __self__).__init__(
            'google-native:networkconnectivity/v1alpha1:Spoke',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Spoke':
        """
        Get an existing Spoke resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = SpokeArgs.__new__(SpokeArgs)

        __props__.__dict__["create_time"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["hub"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["linked_interconnect_attachments"] = None
        __props__.__dict__["linked_router_appliance_instances"] = None
        __props__.__dict__["linked_vpn_tunnels"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["unique_id"] = None
        __props__.__dict__["update_time"] = None
        return Spoke(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time when the Spoke was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Short description of the spoke resource
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def hub(self) -> pulumi.Output[str]:
        """
        The resource URL of the hub resource that the spoke is attached to
        """
        return pulumi.get(self, "hub")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        User-defined labels.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="linkedInterconnectAttachments")
    def linked_interconnect_attachments(self) -> pulumi.Output[Sequence[str]]:
        """
        The URIs of linked interconnect attachment resources
        """
        return pulumi.get(self, "linked_interconnect_attachments")

    @property
    @pulumi.getter(name="linkedRouterApplianceInstances")
    def linked_router_appliance_instances(self) -> pulumi.Output[Sequence['outputs.RouterApplianceInstanceResponse']]:
        """
        The URIs of linked Router appliance resources
        """
        return pulumi.get(self, "linked_router_appliance_instances")

    @property
    @pulumi.getter(name="linkedVpnTunnels")
    def linked_vpn_tunnels(self) -> pulumi.Output[Sequence[str]]:
        """
        The URIs of linked VPN tunnel resources
        """
        return pulumi.get(self, "linked_vpn_tunnels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Immutable. The name of a Spoke resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of this Hub.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="uniqueId")
    def unique_id(self) -> pulumi.Output[str]:
        """
        Google-generated UUID for this resource. This is unique across all Spoke resources. If a Spoke resource is deleted and another with the same name is created, it gets a different unique_id.
        """
        return pulumi.get(self, "unique_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The time when the Spoke was updated.
        """
        return pulumi.get(self, "update_time")

