# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetJobResult',
    'AwaitableGetJobResult',
    'get_job',
    'get_job_output',
]

@pulumi.output_type
class GetJobResult:
    def __init__(__self__, create_time=None, end_time=None, error_message=None, etag=None, job_id=None, job_position=None, labels=None, prediction_input=None, prediction_output=None, start_time=None, state=None, training_input=None, training_output=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if error_message and not isinstance(error_message, str):
            raise TypeError("Expected argument 'error_message' to be a str")
        pulumi.set(__self__, "error_message", error_message)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if job_id and not isinstance(job_id, str):
            raise TypeError("Expected argument 'job_id' to be a str")
        pulumi.set(__self__, "job_id", job_id)
        if job_position and not isinstance(job_position, str):
            raise TypeError("Expected argument 'job_position' to be a str")
        pulumi.set(__self__, "job_position", job_position)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if prediction_input and not isinstance(prediction_input, dict):
            raise TypeError("Expected argument 'prediction_input' to be a dict")
        pulumi.set(__self__, "prediction_input", prediction_input)
        if prediction_output and not isinstance(prediction_output, dict):
            raise TypeError("Expected argument 'prediction_output' to be a dict")
        pulumi.set(__self__, "prediction_output", prediction_output)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if training_input and not isinstance(training_input, dict):
            raise TypeError("Expected argument 'training_input' to be a dict")
        pulumi.set(__self__, "training_input", training_input)
        if training_output and not isinstance(training_output, dict):
            raise TypeError("Expected argument 'training_output' to be a dict")
        pulumi.set(__self__, "training_output", training_output)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        When the job was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        When the job processing was completed.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        """
        The details of a failure or a cancellation.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a job from overwriting each other. It is strongly suggested that systems make use of the `etag` in the read-modify-write cycle to perform job updates in order to avoid race conditions: An `etag` is returned in the response to `GetJob`, and systems are expected to put that etag in the request to `UpdateJob` to ensure that their change will be applied to the same version of the job.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> str:
        """
        The user-specified id of the job.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter(name="jobPosition")
    def job_position(self) -> str:
        """
        It's only effect when the job is in QUEUED state. If it's positive, it indicates the job's position in the job scheduler. It's 0 when the job is already scheduled.
        """
        return pulumi.get(self, "job_position")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. One or more labels that you can add, to organize your jobs. Each label is a key-value pair, where both the key and the value are arbitrary strings that you supply. For more information, see the documentation on using labels.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="predictionInput")
    def prediction_input(self) -> 'outputs.GoogleCloudMlV1__PredictionInputResponse':
        """
        Input parameters to create a prediction job.
        """
        return pulumi.get(self, "prediction_input")

    @property
    @pulumi.getter(name="predictionOutput")
    def prediction_output(self) -> 'outputs.GoogleCloudMlV1__PredictionOutputResponse':
        """
        The current prediction job result.
        """
        return pulumi.get(self, "prediction_output")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        When the job processing was started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The detailed state of a job.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="trainingInput")
    def training_input(self) -> 'outputs.GoogleCloudMlV1__TrainingInputResponse':
        """
        Input parameters to create a training job.
        """
        return pulumi.get(self, "training_input")

    @property
    @pulumi.getter(name="trainingOutput")
    def training_output(self) -> 'outputs.GoogleCloudMlV1__TrainingOutputResponse':
        """
        The current training job result.
        """
        return pulumi.get(self, "training_output")


class AwaitableGetJobResult(GetJobResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJobResult(
            create_time=self.create_time,
            end_time=self.end_time,
            error_message=self.error_message,
            etag=self.etag,
            job_id=self.job_id,
            job_position=self.job_position,
            labels=self.labels,
            prediction_input=self.prediction_input,
            prediction_output=self.prediction_output,
            start_time=self.start_time,
            state=self.state,
            training_input=self.training_input,
            training_output=self.training_output)


def get_job(job_id: Optional[str] = None,
            project: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJobResult:
    """
    Describes a job.
    """
    __args__ = dict()
    __args__['jobId'] = job_id
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:ml/v1:getJob', __args__, opts=opts, typ=GetJobResult).value

    return AwaitableGetJobResult(
        create_time=__ret__.create_time,
        end_time=__ret__.end_time,
        error_message=__ret__.error_message,
        etag=__ret__.etag,
        job_id=__ret__.job_id,
        job_position=__ret__.job_position,
        labels=__ret__.labels,
        prediction_input=__ret__.prediction_input,
        prediction_output=__ret__.prediction_output,
        start_time=__ret__.start_time,
        state=__ret__.state,
        training_input=__ret__.training_input,
        training_output=__ret__.training_output)


@_utilities.lift_output_func(get_job)
def get_job_output(job_id: Optional[pulumi.Input[str]] = None,
                   project: Optional[pulumi.Input[Optional[str]]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetJobResult]:
    """
    Describes a job.
    """
    ...
