# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetEnvironmentResult',
    'AwaitableGetEnvironmentResult',
    'get_environment',
    'get_environment_output',
]

@pulumi.output_type
class GetEnvironmentResult:
    def __init__(__self__, description=None, display_name=None, name=None, test_cases_config=None, update_time=None, version_configs=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if test_cases_config and not isinstance(test_cases_config, dict):
            raise TypeError("Expected argument 'test_cases_config' to be a dict")
        pulumi.set(__self__, "test_cases_config", test_cases_config)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)
        if version_configs and not isinstance(version_configs, list):
            raise TypeError("Expected argument 'version_configs' to be a list")
        pulumi.set(__self__, "version_configs", version_configs)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The human-readable description of the environment. The maximum length is 500 characters. If exceeded, the request is rejected.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The human-readable name of the environment (unique in an agent). Limit of 64 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the environment. Format: `projects//locations//agents//environments/`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="testCasesConfig")
    def test_cases_config(self) -> 'outputs.GoogleCloudDialogflowCxV3beta1EnvironmentTestCasesConfigResponse':
        """
        The test cases config for continuous tests of this environment.
        """
        return pulumi.get(self, "test_cases_config")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Update time of this environment.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="versionConfigs")
    def version_configs(self) -> Sequence['outputs.GoogleCloudDialogflowCxV3beta1EnvironmentVersionConfigResponse']:
        """
        A list of configurations for flow versions. You should include version configs for all flows that are reachable from `Start Flow` in the agent. Otherwise, an error will be returned.
        """
        return pulumi.get(self, "version_configs")


class AwaitableGetEnvironmentResult(GetEnvironmentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentResult(
            description=self.description,
            display_name=self.display_name,
            name=self.name,
            test_cases_config=self.test_cases_config,
            update_time=self.update_time,
            version_configs=self.version_configs)


def get_environment(agent_id: Optional[str] = None,
                    environment_id: Optional[str] = None,
                    location: Optional[str] = None,
                    project: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentResult:
    """
    Retrieves the specified Environment.
    """
    __args__ = dict()
    __args__['agentId'] = agent_id
    __args__['environmentId'] = environment_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:dialogflow/v3beta1:getEnvironment', __args__, opts=opts, typ=GetEnvironmentResult).value

    return AwaitableGetEnvironmentResult(
        description=__ret__.description,
        display_name=__ret__.display_name,
        name=__ret__.name,
        test_cases_config=__ret__.test_cases_config,
        update_time=__ret__.update_time,
        version_configs=__ret__.version_configs)


@_utilities.lift_output_func(get_environment)
def get_environment_output(agent_id: Optional[pulumi.Input[str]] = None,
                           environment_id: Optional[pulumi.Input[str]] = None,
                           location: Optional[pulumi.Input[str]] = None,
                           project: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEnvironmentResult]:
    """
    Retrieves the specified Environment.
    """
    ...
