# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetConversationProfileResult',
    'AwaitableGetConversationProfileResult',
    'get_conversation_profile',
    'get_conversation_profile_output',
]

@pulumi.output_type
class GetConversationProfileResult:
    def __init__(__self__, automated_agent_config=None, create_time=None, display_name=None, human_agent_assistant_config=None, human_agent_handoff_config=None, language_code=None, logging_config=None, name=None, new_message_event_notification_config=None, notification_config=None, security_settings=None, stt_config=None, time_zone=None, update_time=None):
        if automated_agent_config and not isinstance(automated_agent_config, dict):
            raise TypeError("Expected argument 'automated_agent_config' to be a dict")
        pulumi.set(__self__, "automated_agent_config", automated_agent_config)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if human_agent_assistant_config and not isinstance(human_agent_assistant_config, dict):
            raise TypeError("Expected argument 'human_agent_assistant_config' to be a dict")
        pulumi.set(__self__, "human_agent_assistant_config", human_agent_assistant_config)
        if human_agent_handoff_config and not isinstance(human_agent_handoff_config, dict):
            raise TypeError("Expected argument 'human_agent_handoff_config' to be a dict")
        pulumi.set(__self__, "human_agent_handoff_config", human_agent_handoff_config)
        if language_code and not isinstance(language_code, str):
            raise TypeError("Expected argument 'language_code' to be a str")
        pulumi.set(__self__, "language_code", language_code)
        if logging_config and not isinstance(logging_config, dict):
            raise TypeError("Expected argument 'logging_config' to be a dict")
        pulumi.set(__self__, "logging_config", logging_config)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if new_message_event_notification_config and not isinstance(new_message_event_notification_config, dict):
            raise TypeError("Expected argument 'new_message_event_notification_config' to be a dict")
        pulumi.set(__self__, "new_message_event_notification_config", new_message_event_notification_config)
        if notification_config and not isinstance(notification_config, dict):
            raise TypeError("Expected argument 'notification_config' to be a dict")
        pulumi.set(__self__, "notification_config", notification_config)
        if security_settings and not isinstance(security_settings, str):
            raise TypeError("Expected argument 'security_settings' to be a str")
        pulumi.set(__self__, "security_settings", security_settings)
        if stt_config and not isinstance(stt_config, dict):
            raise TypeError("Expected argument 'stt_config' to be a dict")
        pulumi.set(__self__, "stt_config", stt_config)
        if time_zone and not isinstance(time_zone, str):
            raise TypeError("Expected argument 'time_zone' to be a str")
        pulumi.set(__self__, "time_zone", time_zone)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="automatedAgentConfig")
    def automated_agent_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1AutomatedAgentConfigResponse':
        """
        Configuration for an automated agent to use with this profile.
        """
        return pulumi.get(self, "automated_agent_config")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Create time of the conversation profile.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Human readable name for this profile. Max length 1024 bytes.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="humanAgentAssistantConfig")
    def human_agent_assistant_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1HumanAgentAssistantConfigResponse':
        """
        Configuration for agent assistance to use with this profile.
        """
        return pulumi.get(self, "human_agent_assistant_config")

    @property
    @pulumi.getter(name="humanAgentHandoffConfig")
    def human_agent_handoff_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1HumanAgentHandoffConfigResponse':
        """
        Configuration for connecting to a live agent. Currently, this feature is not general available, please contact Google to get access.
        """
        return pulumi.get(self, "human_agent_handoff_config")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        Language code for the conversation profile. If not specified, the language is en-US. Language at ConversationProfile should be set for all non en-us languages. This should be a [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag. Example: "en-US".
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1LoggingConfigResponse':
        """
        Configuration for logging conversation lifecycle events.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The unique identifier of this conversation profile. Format: `projects//locations//conversationProfiles/`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newMessageEventNotificationConfig")
    def new_message_event_notification_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1NotificationConfigResponse':
        """
        Configuration for publishing new message events. Event will be sent in format of ConversationEvent
        """
        return pulumi.get(self, "new_message_event_notification_config")

    @property
    @pulumi.getter(name="notificationConfig")
    def notification_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1NotificationConfigResponse':
        """
        Configuration for publishing conversation lifecycle events.
        """
        return pulumi.get(self, "notification_config")

    @property
    @pulumi.getter(name="securitySettings")
    def security_settings(self) -> str:
        """
        Name of the CX SecuritySettings reference for the agent. Format: `projects//locations//securitySettings/`.
        """
        return pulumi.get(self, "security_settings")

    @property
    @pulumi.getter(name="sttConfig")
    def stt_config(self) -> 'outputs.GoogleCloudDialogflowV2beta1SpeechToTextConfigResponse':
        """
        Settings for speech transcription.
        """
        return pulumi.get(self, "stt_config")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        The time zone of this conversational profile from the [time zone database](https://www.iana.org/time-zones), e.g., America/New_York, Europe/Paris. Defaults to America/New_York.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Update time of the conversation profile.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetConversationProfileResult(GetConversationProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConversationProfileResult(
            automated_agent_config=self.automated_agent_config,
            create_time=self.create_time,
            display_name=self.display_name,
            human_agent_assistant_config=self.human_agent_assistant_config,
            human_agent_handoff_config=self.human_agent_handoff_config,
            language_code=self.language_code,
            logging_config=self.logging_config,
            name=self.name,
            new_message_event_notification_config=self.new_message_event_notification_config,
            notification_config=self.notification_config,
            security_settings=self.security_settings,
            stt_config=self.stt_config,
            time_zone=self.time_zone,
            update_time=self.update_time)


def get_conversation_profile(conversation_profile_id: Optional[str] = None,
                             location: Optional[str] = None,
                             project: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConversationProfileResult:
    """
    Retrieves the specified conversation profile.
    """
    __args__ = dict()
    __args__['conversationProfileId'] = conversation_profile_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:dialogflow/v2beta1:getConversationProfile', __args__, opts=opts, typ=GetConversationProfileResult).value

    return AwaitableGetConversationProfileResult(
        automated_agent_config=__ret__.automated_agent_config,
        create_time=__ret__.create_time,
        display_name=__ret__.display_name,
        human_agent_assistant_config=__ret__.human_agent_assistant_config,
        human_agent_handoff_config=__ret__.human_agent_handoff_config,
        language_code=__ret__.language_code,
        logging_config=__ret__.logging_config,
        name=__ret__.name,
        new_message_event_notification_config=__ret__.new_message_event_notification_config,
        notification_config=__ret__.notification_config,
        security_settings=__ret__.security_settings,
        stt_config=__ret__.stt_config,
        time_zone=__ret__.time_zone,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_conversation_profile)
def get_conversation_profile_output(conversation_profile_id: Optional[pulumi.Input[str]] = None,
                                    location: Optional[pulumi.Input[str]] = None,
                                    project: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConversationProfileResult]:
    """
    Retrieves the specified conversation profile.
    """
    ...
