# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AliasContextResponse',
    'ArtifactResponse',
    'AttestationNoteResponse',
    'AttestationOccurrenceResponse',
    'BindingResponse',
    'BuildNoteResponse',
    'BuildOccurrenceResponse',
    'BuildProvenanceResponse',
    'BuilderConfigResponse',
    'CVSSResponse',
    'CVSSv3Response',
    'CategoryResponse',
    'CisBenchmarkResponse',
    'CloudRepoSourceContextResponse',
    'CommandResponse',
    'CompletenessResponse',
    'ComplianceNoteResponse',
    'ComplianceOccurrenceResponse',
    'ComplianceVersionResponse',
    'DSSEAttestationNoteResponse',
    'DSSEAttestationOccurrenceResponse',
    'DSSEHintResponse',
    'DeploymentNoteResponse',
    'DeploymentOccurrenceResponse',
    'DetailResponse',
    'DiscoveryNoteResponse',
    'DiscoveryOccurrenceResponse',
    'DistributionResponse',
    'EnvelopeResponse',
    'EnvelopeSignatureResponse',
    'ExprResponse',
    'FingerprintResponse',
    'GerritSourceContextResponse',
    'GitSourceContextResponse',
    'HintResponse',
    'IdentityResponse',
    'ImageNoteResponse',
    'ImageOccurrenceResponse',
    'InTotoProvenanceResponse',
    'InTotoStatementResponse',
    'JwtResponse',
    'KnowledgeBaseResponse',
    'LayerResponse',
    'LocationResponse',
    'MaterialResponse',
    'MetadataResponse',
    'NonCompliantFileResponse',
    'PackageIssueResponse',
    'PackageNoteResponse',
    'PackageOccurrenceResponse',
    'ProjectRepoIdResponse',
    'RecipeResponse',
    'RelatedUrlResponse',
    'RepoIdResponse',
    'SignatureResponse',
    'SlsaBuilderResponse',
    'SlsaCompletenessResponse',
    'SlsaMetadataResponse',
    'SlsaProvenanceResponse',
    'SlsaRecipeResponse',
    'SourceContextResponse',
    'SourceResponse',
    'StatusResponse',
    'SubjectResponse',
    'UpgradeDistributionResponse',
    'UpgradeNoteResponse',
    'UpgradeOccurrenceResponse',
    'VersionResponse',
    'VulnerabilityNoteResponse',
    'VulnerabilityOccurrenceResponse',
    'WindowsDetailResponse',
    'WindowsUpdateResponse',
]

@pulumi.output_type
class AliasContextResponse(dict):
    """
    An alias to a repo revision.
    """
    def __init__(__self__, *,
                 kind: str,
                 name: str):
        """
        An alias to a repo revision.
        :param str kind: The alias kind.
        :param str name: The alias name.
        """
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The alias kind.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The alias name.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ArtifactResponse(dict):
    """
    Artifact describes a build product.
    """
    def __init__(__self__, *,
                 checksum: str,
                 names: Sequence[str]):
        """
        Artifact describes a build product.
        :param str checksum: Hash or checksum value of a binary, or Docker Registry 2.0 digest of a container.
        :param Sequence[str] names: Related artifact names. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. Note that a single Artifact ID can have multiple names, for example if two tags are applied to one image.
        """
        pulumi.set(__self__, "checksum", checksum)
        pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def checksum(self) -> str:
        """
        Hash or checksum value of a binary, or Docker Registry 2.0 digest of a container.
        """
        return pulumi.get(self, "checksum")

    @property
    @pulumi.getter
    def names(self) -> Sequence[str]:
        """
        Related artifact names. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. Note that a single Artifact ID can have multiple names, for example if two tags are applied to one image.
        """
        return pulumi.get(self, "names")


@pulumi.output_type
class AttestationNoteResponse(dict):
    """
    Note kind that represents a logical attestation "role" or "authority". For example, an organization might have one `Authority` for "QA" and one for "build". This note is intended to act strictly as a grouping mechanism for the attached occurrences (Attestations). This grouping mechanism also provides a security boundary, since IAM ACLs gate the ability for a principle to attach an occurrence to a given note. It also provides a single point of lookup to find all attached attestation occurrences, even if they don't all live in the same project.
    """
    def __init__(__self__, *,
                 hint: 'outputs.HintResponse'):
        """
        Note kind that represents a logical attestation "role" or "authority". For example, an organization might have one `Authority` for "QA" and one for "build". This note is intended to act strictly as a grouping mechanism for the attached occurrences (Attestations). This grouping mechanism also provides a security boundary, since IAM ACLs gate the ability for a principle to attach an occurrence to a given note. It also provides a single point of lookup to find all attached attestation occurrences, even if they don't all live in the same project.
        :param 'HintResponse' hint: Hint hints at the purpose of the attestation authority.
        """
        pulumi.set(__self__, "hint", hint)

    @property
    @pulumi.getter
    def hint(self) -> 'outputs.HintResponse':
        """
        Hint hints at the purpose of the attestation authority.
        """
        return pulumi.get(self, "hint")


@pulumi.output_type
class AttestationOccurrenceResponse(dict):
    """
    Occurrence that represents a single "attestation". The authenticity of an attestation can be verified using the attached signature. If the verifier trusts the public key of the signer, then verifying the signature is sufficient to establish trust. In this circumstance, the authority to which this attestation is attached is primarily useful for lookup (how to find this attestation if you already know the authority and artifact to be verified) and intent (for which authority this attestation was intended to sign.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serializedPayload":
            suggest = "serialized_payload"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttestationOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttestationOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttestationOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jwts: Sequence['outputs.JwtResponse'],
                 serialized_payload: str,
                 signatures: Sequence['outputs.SignatureResponse']):
        """
        Occurrence that represents a single "attestation". The authenticity of an attestation can be verified using the attached signature. If the verifier trusts the public key of the signer, then verifying the signature is sufficient to establish trust. In this circumstance, the authority to which this attestation is attached is primarily useful for lookup (how to find this attestation if you already know the authority and artifact to be verified) and intent (for which authority this attestation was intended to sign.
        :param Sequence['JwtResponse'] jwts: One or more JWTs encoding a self-contained attestation. Each JWT encodes the payload that it verifies within the JWT itself. Verifier implementation SHOULD ignore the `serialized_payload` field when verifying these JWTs. If only JWTs are present on this AttestationOccurrence, then the `serialized_payload` SHOULD be left empty. Each JWT SHOULD encode a claim specific to the `resource_uri` of this Occurrence, but this is not validated by Grafeas metadata API implementations. The JWT itself is opaque to Grafeas.
        :param str serialized_payload: The serialized payload that is verified by one or more `signatures`.
        :param Sequence['SignatureResponse'] signatures: One or more signatures over `serialized_payload`. Verifier implementations should consider this attestation message verified if at least one `signature` verifies `serialized_payload`. See `Signature` in common.proto for more details on signature structure and verification.
        """
        pulumi.set(__self__, "jwts", jwts)
        pulumi.set(__self__, "serialized_payload", serialized_payload)
        pulumi.set(__self__, "signatures", signatures)

    @property
    @pulumi.getter
    def jwts(self) -> Sequence['outputs.JwtResponse']:
        """
        One or more JWTs encoding a self-contained attestation. Each JWT encodes the payload that it verifies within the JWT itself. Verifier implementation SHOULD ignore the `serialized_payload` field when verifying these JWTs. If only JWTs are present on this AttestationOccurrence, then the `serialized_payload` SHOULD be left empty. Each JWT SHOULD encode a claim specific to the `resource_uri` of this Occurrence, but this is not validated by Grafeas metadata API implementations. The JWT itself is opaque to Grafeas.
        """
        return pulumi.get(self, "jwts")

    @property
    @pulumi.getter(name="serializedPayload")
    def serialized_payload(self) -> str:
        """
        The serialized payload that is verified by one or more `signatures`.
        """
        return pulumi.get(self, "serialized_payload")

    @property
    @pulumi.getter
    def signatures(self) -> Sequence['outputs.SignatureResponse']:
        """
        One or more signatures over `serialized_payload`. Verifier implementations should consider this attestation message verified if at least one `signature` verifies `serialized_payload`. See `Signature` in common.proto for more details on signature structure and verification.
        """
        return pulumi.get(self, "signatures")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class BuildNoteResponse(dict):
    """
    Note holding the version of the provider's builder and the signature of the provenance message in the build details occurrence.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "builderVersion":
            suggest = "builder_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildNoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildNoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildNoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 builder_version: str):
        """
        Note holding the version of the provider's builder and the signature of the provenance message in the build details occurrence.
        :param str builder_version: Immutable. Version of the builder which produced this build.
        """
        pulumi.set(__self__, "builder_version", builder_version)

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> str:
        """
        Immutable. Version of the builder which produced this build.
        """
        return pulumi.get(self, "builder_version")


@pulumi.output_type
class BuildOccurrenceResponse(dict):
    """
    Details of a build occurrence.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "intotoProvenance":
            suggest = "intoto_provenance"
        elif key == "intotoStatement":
            suggest = "intoto_statement"
        elif key == "provenanceBytes":
            suggest = "provenance_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 intoto_provenance: 'outputs.InTotoProvenanceResponse',
                 intoto_statement: 'outputs.InTotoStatementResponse',
                 provenance: 'outputs.BuildProvenanceResponse',
                 provenance_bytes: str):
        """
        Details of a build occurrence.
        :param 'InTotoProvenanceResponse' intoto_provenance: Deprecated. See InTotoStatement for the replacement. In-toto Provenance representation as defined in spec.
        :param 'InTotoStatementResponse' intoto_statement: In-toto Statement representation as defined in spec. The intoto_statement can contain any type of provenance. The serialized payload of the statement can be stored and signed in the Occurrence's envelope.
        :param 'BuildProvenanceResponse' provenance: The actual provenance for the build.
        :param str provenance_bytes: Serialized JSON representation of the provenance, used in generating the build signature in the corresponding build note. After verifying the signature, `provenance_bytes` can be unmarshalled and compared to the provenance to confirm that it is unchanged. A base64-encoded string representation of the provenance bytes is used for the signature in order to interoperate with openssl which expects this format for signature verification. The serialized form is captured both to avoid ambiguity in how the provenance is marshalled to json as well to prevent incompatibilities with future changes.
        """
        pulumi.set(__self__, "intoto_provenance", intoto_provenance)
        pulumi.set(__self__, "intoto_statement", intoto_statement)
        pulumi.set(__self__, "provenance", provenance)
        pulumi.set(__self__, "provenance_bytes", provenance_bytes)

    @property
    @pulumi.getter(name="intotoProvenance")
    def intoto_provenance(self) -> 'outputs.InTotoProvenanceResponse':
        """
        Deprecated. See InTotoStatement for the replacement. In-toto Provenance representation as defined in spec.
        """
        return pulumi.get(self, "intoto_provenance")

    @property
    @pulumi.getter(name="intotoStatement")
    def intoto_statement(self) -> 'outputs.InTotoStatementResponse':
        """
        In-toto Statement representation as defined in spec. The intoto_statement can contain any type of provenance. The serialized payload of the statement can be stored and signed in the Occurrence's envelope.
        """
        return pulumi.get(self, "intoto_statement")

    @property
    @pulumi.getter
    def provenance(self) -> 'outputs.BuildProvenanceResponse':
        """
        The actual provenance for the build.
        """
        return pulumi.get(self, "provenance")

    @property
    @pulumi.getter(name="provenanceBytes")
    def provenance_bytes(self) -> str:
        """
        Serialized JSON representation of the provenance, used in generating the build signature in the corresponding build note. After verifying the signature, `provenance_bytes` can be unmarshalled and compared to the provenance to confirm that it is unchanged. A base64-encoded string representation of the provenance bytes is used for the signature in order to interoperate with openssl which expects this format for signature verification. The serialized form is captured both to avoid ambiguity in how the provenance is marshalled to json as well to prevent incompatibilities with future changes.
        """
        return pulumi.get(self, "provenance_bytes")


@pulumi.output_type
class BuildProvenanceResponse(dict):
    """
    Provenance of a build. Contains all information needed to verify the full details about the build from source to completion.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildOptions":
            suggest = "build_options"
        elif key == "builderVersion":
            suggest = "builder_version"
        elif key == "builtArtifacts":
            suggest = "built_artifacts"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "endTime":
            suggest = "end_time"
        elif key == "logsUri":
            suggest = "logs_uri"
        elif key == "sourceProvenance":
            suggest = "source_provenance"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "triggerId":
            suggest = "trigger_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BuildProvenanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BuildProvenanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BuildProvenanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_options: Mapping[str, str],
                 builder_version: str,
                 built_artifacts: Sequence['outputs.ArtifactResponse'],
                 commands: Sequence['outputs.CommandResponse'],
                 create_time: str,
                 creator: str,
                 end_time: str,
                 logs_uri: str,
                 project: str,
                 source_provenance: 'outputs.SourceResponse',
                 start_time: str,
                 trigger_id: str):
        """
        Provenance of a build. Contains all information needed to verify the full details about the build from source to completion.
        :param Mapping[str, str] build_options: Special options applied to this build. This is a catch-all field where build providers can enter any desired additional details.
        :param str builder_version: Version string of the builder at the time this build was executed.
        :param Sequence['ArtifactResponse'] built_artifacts: Output of the build.
        :param Sequence['CommandResponse'] commands: Commands requested by the build.
        :param str create_time: Time at which the build was created.
        :param str creator: E-mail address of the user who initiated this build. Note that this was the user's e-mail address at the time the build was initiated; this address may not represent the same end-user for all time.
        :param str end_time: Time at which execution of the build was finished.
        :param str logs_uri: URI where any logs for this provenance were written.
        :param str project: ID of the project.
        :param 'SourceResponse' source_provenance: Details of the Source input to the build.
        :param str start_time: Time at which execution of the build was started.
        :param str trigger_id: Trigger identifier if the build was triggered automatically; empty if not.
        """
        pulumi.set(__self__, "build_options", build_options)
        pulumi.set(__self__, "builder_version", builder_version)
        pulumi.set(__self__, "built_artifacts", built_artifacts)
        pulumi.set(__self__, "commands", commands)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "creator", creator)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "logs_uri", logs_uri)
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "source_provenance", source_provenance)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "trigger_id", trigger_id)

    @property
    @pulumi.getter(name="buildOptions")
    def build_options(self) -> Mapping[str, str]:
        """
        Special options applied to this build. This is a catch-all field where build providers can enter any desired additional details.
        """
        return pulumi.get(self, "build_options")

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> str:
        """
        Version string of the builder at the time this build was executed.
        """
        return pulumi.get(self, "builder_version")

    @property
    @pulumi.getter(name="builtArtifacts")
    def built_artifacts(self) -> Sequence['outputs.ArtifactResponse']:
        """
        Output of the build.
        """
        return pulumi.get(self, "built_artifacts")

    @property
    @pulumi.getter
    def commands(self) -> Sequence['outputs.CommandResponse']:
        """
        Commands requested by the build.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Time at which the build was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> str:
        """
        E-mail address of the user who initiated this build. Note that this was the user's e-mail address at the time the build was initiated; this address may not represent the same end-user for all time.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        Time at which execution of the build was finished.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="logsUri")
    def logs_uri(self) -> str:
        """
        URI where any logs for this provenance were written.
        """
        return pulumi.get(self, "logs_uri")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        ID of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="sourceProvenance")
    def source_provenance(self) -> 'outputs.SourceResponse':
        """
        Details of the Source input to the build.
        """
        return pulumi.get(self, "source_provenance")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Time at which execution of the build was started.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> str:
        """
        Trigger identifier if the build was triggered automatically; empty if not.
        """
        return pulumi.get(self, "trigger_id")


@pulumi.output_type
class BuilderConfigResponse(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class CVSSResponse(dict):
    """
    Common Vulnerability Scoring System. For details, see https://www.first.org/cvss/specification-document This is a message we will try to use for storing multiple versions of CVSS. The intention is that as new versions of CVSS scores get added, we will be able to modify this message rather than adding new protos for each new version of the score.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attackComplexity":
            suggest = "attack_complexity"
        elif key == "attackVector":
            suggest = "attack_vector"
        elif key == "availabilityImpact":
            suggest = "availability_impact"
        elif key == "baseScore":
            suggest = "base_score"
        elif key == "confidentialityImpact":
            suggest = "confidentiality_impact"
        elif key == "exploitabilityScore":
            suggest = "exploitability_score"
        elif key == "impactScore":
            suggest = "impact_score"
        elif key == "integrityImpact":
            suggest = "integrity_impact"
        elif key == "privilegesRequired":
            suggest = "privileges_required"
        elif key == "userInteraction":
            suggest = "user_interaction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CVSSResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CVSSResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CVSSResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attack_complexity: str,
                 attack_vector: str,
                 authentication: str,
                 availability_impact: str,
                 base_score: float,
                 confidentiality_impact: str,
                 exploitability_score: float,
                 impact_score: float,
                 integrity_impact: str,
                 privileges_required: str,
                 scope: str,
                 user_interaction: str):
        """
        Common Vulnerability Scoring System. For details, see https://www.first.org/cvss/specification-document This is a message we will try to use for storing multiple versions of CVSS. The intention is that as new versions of CVSS scores get added, we will be able to modify this message rather than adding new protos for each new version of the score.
        :param str attack_vector: Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments.
        :param float base_score: The base score is a function of the base metric scores.
        """
        pulumi.set(__self__, "attack_complexity", attack_complexity)
        pulumi.set(__self__, "attack_vector", attack_vector)
        pulumi.set(__self__, "authentication", authentication)
        pulumi.set(__self__, "availability_impact", availability_impact)
        pulumi.set(__self__, "base_score", base_score)
        pulumi.set(__self__, "confidentiality_impact", confidentiality_impact)
        pulumi.set(__self__, "exploitability_score", exploitability_score)
        pulumi.set(__self__, "impact_score", impact_score)
        pulumi.set(__self__, "integrity_impact", integrity_impact)
        pulumi.set(__self__, "privileges_required", privileges_required)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "user_interaction", user_interaction)

    @property
    @pulumi.getter(name="attackComplexity")
    def attack_complexity(self) -> str:
        return pulumi.get(self, "attack_complexity")

    @property
    @pulumi.getter(name="attackVector")
    def attack_vector(self) -> str:
        """
        Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments.
        """
        return pulumi.get(self, "attack_vector")

    @property
    @pulumi.getter
    def authentication(self) -> str:
        return pulumi.get(self, "authentication")

    @property
    @pulumi.getter(name="availabilityImpact")
    def availability_impact(self) -> str:
        return pulumi.get(self, "availability_impact")

    @property
    @pulumi.getter(name="baseScore")
    def base_score(self) -> float:
        """
        The base score is a function of the base metric scores.
        """
        return pulumi.get(self, "base_score")

    @property
    @pulumi.getter(name="confidentialityImpact")
    def confidentiality_impact(self) -> str:
        return pulumi.get(self, "confidentiality_impact")

    @property
    @pulumi.getter(name="exploitabilityScore")
    def exploitability_score(self) -> float:
        return pulumi.get(self, "exploitability_score")

    @property
    @pulumi.getter(name="impactScore")
    def impact_score(self) -> float:
        return pulumi.get(self, "impact_score")

    @property
    @pulumi.getter(name="integrityImpact")
    def integrity_impact(self) -> str:
        return pulumi.get(self, "integrity_impact")

    @property
    @pulumi.getter(name="privilegesRequired")
    def privileges_required(self) -> str:
        return pulumi.get(self, "privileges_required")

    @property
    @pulumi.getter
    def scope(self) -> str:
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="userInteraction")
    def user_interaction(self) -> str:
        return pulumi.get(self, "user_interaction")


@pulumi.output_type
class CVSSv3Response(dict):
    """
    Common Vulnerability Scoring System version 3. For details, see https://www.first.org/cvss/specification-document
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attackComplexity":
            suggest = "attack_complexity"
        elif key == "attackVector":
            suggest = "attack_vector"
        elif key == "availabilityImpact":
            suggest = "availability_impact"
        elif key == "baseScore":
            suggest = "base_score"
        elif key == "confidentialityImpact":
            suggest = "confidentiality_impact"
        elif key == "exploitabilityScore":
            suggest = "exploitability_score"
        elif key == "impactScore":
            suggest = "impact_score"
        elif key == "integrityImpact":
            suggest = "integrity_impact"
        elif key == "privilegesRequired":
            suggest = "privileges_required"
        elif key == "userInteraction":
            suggest = "user_interaction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CVSSv3Response. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CVSSv3Response.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CVSSv3Response.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attack_complexity: str,
                 attack_vector: str,
                 availability_impact: str,
                 base_score: float,
                 confidentiality_impact: str,
                 exploitability_score: float,
                 impact_score: float,
                 integrity_impact: str,
                 privileges_required: str,
                 scope: str,
                 user_interaction: str):
        """
        Common Vulnerability Scoring System version 3. For details, see https://www.first.org/cvss/specification-document
        :param str attack_vector: Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments.
        :param float base_score: The base score is a function of the base metric scores.
        """
        pulumi.set(__self__, "attack_complexity", attack_complexity)
        pulumi.set(__self__, "attack_vector", attack_vector)
        pulumi.set(__self__, "availability_impact", availability_impact)
        pulumi.set(__self__, "base_score", base_score)
        pulumi.set(__self__, "confidentiality_impact", confidentiality_impact)
        pulumi.set(__self__, "exploitability_score", exploitability_score)
        pulumi.set(__self__, "impact_score", impact_score)
        pulumi.set(__self__, "integrity_impact", integrity_impact)
        pulumi.set(__self__, "privileges_required", privileges_required)
        pulumi.set(__self__, "scope", scope)
        pulumi.set(__self__, "user_interaction", user_interaction)

    @property
    @pulumi.getter(name="attackComplexity")
    def attack_complexity(self) -> str:
        return pulumi.get(self, "attack_complexity")

    @property
    @pulumi.getter(name="attackVector")
    def attack_vector(self) -> str:
        """
        Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments.
        """
        return pulumi.get(self, "attack_vector")

    @property
    @pulumi.getter(name="availabilityImpact")
    def availability_impact(self) -> str:
        return pulumi.get(self, "availability_impact")

    @property
    @pulumi.getter(name="baseScore")
    def base_score(self) -> float:
        """
        The base score is a function of the base metric scores.
        """
        return pulumi.get(self, "base_score")

    @property
    @pulumi.getter(name="confidentialityImpact")
    def confidentiality_impact(self) -> str:
        return pulumi.get(self, "confidentiality_impact")

    @property
    @pulumi.getter(name="exploitabilityScore")
    def exploitability_score(self) -> float:
        return pulumi.get(self, "exploitability_score")

    @property
    @pulumi.getter(name="impactScore")
    def impact_score(self) -> float:
        return pulumi.get(self, "impact_score")

    @property
    @pulumi.getter(name="integrityImpact")
    def integrity_impact(self) -> str:
        return pulumi.get(self, "integrity_impact")

    @property
    @pulumi.getter(name="privilegesRequired")
    def privileges_required(self) -> str:
        return pulumi.get(self, "privileges_required")

    @property
    @pulumi.getter
    def scope(self) -> str:
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="userInteraction")
    def user_interaction(self) -> str:
        return pulumi.get(self, "user_interaction")


@pulumi.output_type
class CategoryResponse(dict):
    """
    The category to which the update belongs.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "categoryId":
            suggest = "category_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CategoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CategoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CategoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 category_id: str,
                 name: str):
        """
        The category to which the update belongs.
        :param str category_id: The identifier of the category.
        :param str name: The localized name of the category.
        """
        pulumi.set(__self__, "category_id", category_id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> str:
        """
        The identifier of the category.
        """
        return pulumi.get(self, "category_id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The localized name of the category.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CisBenchmarkResponse(dict):
    """
    A compliance check that is a CIS benchmark.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "profileLevel":
            suggest = "profile_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CisBenchmarkResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CisBenchmarkResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CisBenchmarkResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 profile_level: int,
                 severity: str):
        """
        A compliance check that is a CIS benchmark.
        """
        pulumi.set(__self__, "profile_level", profile_level)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter(name="profileLevel")
    def profile_level(self) -> int:
        return pulumi.get(self, "profile_level")

    @property
    @pulumi.getter
    def severity(self) -> str:
        return pulumi.get(self, "severity")


@pulumi.output_type
class CloudRepoSourceContextResponse(dict):
    """
    A CloudRepoSourceContext denotes a particular revision in a Google Cloud Source Repo.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aliasContext":
            suggest = "alias_context"
        elif key == "repoId":
            suggest = "repo_id"
        elif key == "revisionId":
            suggest = "revision_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudRepoSourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudRepoSourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudRepoSourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alias_context: 'outputs.AliasContextResponse',
                 repo_id: 'outputs.RepoIdResponse',
                 revision_id: str):
        """
        A CloudRepoSourceContext denotes a particular revision in a Google Cloud Source Repo.
        :param 'AliasContextResponse' alias_context: An alias, which may be a branch or tag.
        :param 'RepoIdResponse' repo_id: The ID of the repo.
        :param str revision_id: A revision ID.
        """
        pulumi.set(__self__, "alias_context", alias_context)
        pulumi.set(__self__, "repo_id", repo_id)
        pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter(name="aliasContext")
    def alias_context(self) -> 'outputs.AliasContextResponse':
        """
        An alias, which may be a branch or tag.
        """
        return pulumi.get(self, "alias_context")

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> 'outputs.RepoIdResponse':
        """
        The ID of the repo.
        """
        return pulumi.get(self, "repo_id")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        A revision ID.
        """
        return pulumi.get(self, "revision_id")


@pulumi.output_type
class CommandResponse(dict):
    """
    Command describes a step performed as part of the build pipeline.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "waitFor":
            suggest = "wait_for"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CommandResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CommandResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CommandResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 args: Sequence[str],
                 dir: str,
                 env: Sequence[str],
                 name: str,
                 wait_for: Sequence[str]):
        """
        Command describes a step performed as part of the build pipeline.
        :param Sequence[str] args: Command-line arguments used when executing this command.
        :param str dir: Working directory (relative to project source root) used when running this command.
        :param Sequence[str] env: Environment variables set before running this command.
        :param str name: Name of the command, as presented on the command line, or if the command is packaged as a Docker container, as presented to `docker pull`.
        :param Sequence[str] wait_for: The ID(s) of the command(s) that this command depends on.
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "dir", dir)
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "wait_for", wait_for)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Command-line arguments used when executing this command.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def dir(self) -> str:
        """
        Working directory (relative to project source root) used when running this command.
        """
        return pulumi.get(self, "dir")

    @property
    @pulumi.getter
    def env(self) -> Sequence[str]:
        """
        Environment variables set before running this command.
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the command, as presented on the command line, or if the command is packaged as a Docker container, as presented to `docker pull`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="waitFor")
    def wait_for(self) -> Sequence[str]:
        """
        The ID(s) of the command(s) that this command depends on.
        """
        return pulumi.get(self, "wait_for")


@pulumi.output_type
class CompletenessResponse(dict):
    """
    Indicates that the builder claims certain fields in this message to be complete.
    """
    def __init__(__self__, *,
                 arguments: bool,
                 environment: bool,
                 materials: bool):
        """
        Indicates that the builder claims certain fields in this message to be complete.
        :param bool arguments: If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        :param bool environment: If true, the builder claims that recipe.environment is claimed to be complete.
        :param bool materials: If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "materials", materials)

    @property
    @pulumi.getter
    def arguments(self) -> bool:
        """
        If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def environment(self) -> bool:
        """
        If true, the builder claims that recipe.environment is claimed to be complete.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def materials(self) -> bool:
        """
        If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        return pulumi.get(self, "materials")


@pulumi.output_type
class ComplianceNoteResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cisBenchmark":
            suggest = "cis_benchmark"
        elif key == "scanInstructions":
            suggest = "scan_instructions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComplianceNoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComplianceNoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComplianceNoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cis_benchmark: 'outputs.CisBenchmarkResponse',
                 description: str,
                 rationale: str,
                 remediation: str,
                 scan_instructions: str,
                 title: str,
                 version: Sequence['outputs.ComplianceVersionResponse']):
        """
        :param str description: A description about this compliance check.
        :param str rationale: A rationale for the existence of this compliance check.
        :param str remediation: A description of remediation steps if the compliance check fails.
        :param str scan_instructions: Serialized scan instructions with a predefined format.
        :param str title: The title that identifies this compliance check.
        :param Sequence['ComplianceVersionResponse'] version: The OS and config versions the benchmark applies to.
        """
        pulumi.set(__self__, "cis_benchmark", cis_benchmark)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "rationale", rationale)
        pulumi.set(__self__, "remediation", remediation)
        pulumi.set(__self__, "scan_instructions", scan_instructions)
        pulumi.set(__self__, "title", title)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cisBenchmark")
    def cis_benchmark(self) -> 'outputs.CisBenchmarkResponse':
        return pulumi.get(self, "cis_benchmark")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description about this compliance check.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def rationale(self) -> str:
        """
        A rationale for the existence of this compliance check.
        """
        return pulumi.get(self, "rationale")

    @property
    @pulumi.getter
    def remediation(self) -> str:
        """
        A description of remediation steps if the compliance check fails.
        """
        return pulumi.get(self, "remediation")

    @property
    @pulumi.getter(name="scanInstructions")
    def scan_instructions(self) -> str:
        """
        Serialized scan instructions with a predefined format.
        """
        return pulumi.get(self, "scan_instructions")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        The title that identifies this compliance check.
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def version(self) -> Sequence['outputs.ComplianceVersionResponse']:
        """
        The OS and config versions the benchmark applies to.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ComplianceOccurrenceResponse(dict):
    """
    An indication that the compliance checks in the associated ComplianceNote were not satisfied for particular resources or a specified reason.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nonComplianceReason":
            suggest = "non_compliance_reason"
        elif key == "nonCompliantFiles":
            suggest = "non_compliant_files"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComplianceOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComplianceOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComplianceOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 non_compliance_reason: str,
                 non_compliant_files: Sequence['outputs.NonCompliantFileResponse']):
        """
        An indication that the compliance checks in the associated ComplianceNote were not satisfied for particular resources or a specified reason.
        """
        pulumi.set(__self__, "non_compliance_reason", non_compliance_reason)
        pulumi.set(__self__, "non_compliant_files", non_compliant_files)

    @property
    @pulumi.getter(name="nonComplianceReason")
    def non_compliance_reason(self) -> str:
        return pulumi.get(self, "non_compliance_reason")

    @property
    @pulumi.getter(name="nonCompliantFiles")
    def non_compliant_files(self) -> Sequence['outputs.NonCompliantFileResponse']:
        return pulumi.get(self, "non_compliant_files")


@pulumi.output_type
class ComplianceVersionResponse(dict):
    """
    Describes the CIS benchmark version that is applicable to a given OS and os version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "benchmarkDocument":
            suggest = "benchmark_document"
        elif key == "cpeUri":
            suggest = "cpe_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ComplianceVersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ComplianceVersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ComplianceVersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 benchmark_document: str,
                 cpe_uri: str,
                 version: str):
        """
        Describes the CIS benchmark version that is applicable to a given OS and os version.
        :param str benchmark_document: The name of the document that defines this benchmark, e.g. "CIS Container-Optimized OS".
        :param str cpe_uri: The CPE URI (https://cpe.mitre.org/specification/) this benchmark is applicable to.
        :param str version: The version of the benchmark. This is set to the version of the OS-specific CIS document the benchmark is defined in.
        """
        pulumi.set(__self__, "benchmark_document", benchmark_document)
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="benchmarkDocument")
    def benchmark_document(self) -> str:
        """
        The name of the document that defines this benchmark, e.g. "CIS Container-Optimized OS".
        """
        return pulumi.get(self, "benchmark_document")

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The CPE URI (https://cpe.mitre.org/specification/) this benchmark is applicable to.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the benchmark. This is set to the version of the OS-specific CIS document the benchmark is defined in.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DSSEAttestationNoteResponse(dict):
    def __init__(__self__, *,
                 hint: 'outputs.DSSEHintResponse'):
        """
        :param 'DSSEHintResponse' hint: DSSEHint hints at the purpose of the attestation authority.
        """
        pulumi.set(__self__, "hint", hint)

    @property
    @pulumi.getter
    def hint(self) -> 'outputs.DSSEHintResponse':
        """
        DSSEHint hints at the purpose of the attestation authority.
        """
        return pulumi.get(self, "hint")


@pulumi.output_type
class DSSEAttestationOccurrenceResponse(dict):
    """
    Deprecated. Prefer to use a regular Occurrence, and populate the Envelope at the top level of the Occurrence.
    """
    def __init__(__self__, *,
                 envelope: 'outputs.EnvelopeResponse',
                 statement: 'outputs.InTotoStatementResponse'):
        """
        Deprecated. Prefer to use a regular Occurrence, and populate the Envelope at the top level of the Occurrence.
        :param 'EnvelopeResponse' envelope: If doing something security critical, make sure to verify the signatures in this metadata.
        """
        pulumi.set(__self__, "envelope", envelope)
        pulumi.set(__self__, "statement", statement)

    @property
    @pulumi.getter
    def envelope(self) -> 'outputs.EnvelopeResponse':
        """
        If doing something security critical, make sure to verify the signatures in this metadata.
        """
        return pulumi.get(self, "envelope")

    @property
    @pulumi.getter
    def statement(self) -> 'outputs.InTotoStatementResponse':
        return pulumi.get(self, "statement")


@pulumi.output_type
class DSSEHintResponse(dict):
    """
    This submessage provides human-readable hints about the purpose of the authority. Because the name of a note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should not be used to look up authorities in security sensitive contexts, such as when looking up attestations to verify.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "humanReadableName":
            suggest = "human_readable_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DSSEHintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DSSEHintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DSSEHintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 human_readable_name: str):
        """
        This submessage provides human-readable hints about the purpose of the authority. Because the name of a note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should not be used to look up authorities in security sensitive contexts, such as when looking up attestations to verify.
        :param str human_readable_name: The human readable name of this attestation authority, for example "cloudbuild-prod".
        """
        pulumi.set(__self__, "human_readable_name", human_readable_name)

    @property
    @pulumi.getter(name="humanReadableName")
    def human_readable_name(self) -> str:
        """
        The human readable name of this attestation authority, for example "cloudbuild-prod".
        """
        return pulumi.get(self, "human_readable_name")


@pulumi.output_type
class DeploymentNoteResponse(dict):
    """
    An artifact that can be deployed in some runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceUri":
            suggest = "resource_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentNoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentNoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentNoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_uri: Sequence[str]):
        """
        An artifact that can be deployed in some runtime.
        :param Sequence[str] resource_uri: Resource URI for the artifact being deployed.
        """
        pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Sequence[str]:
        """
        Resource URI for the artifact being deployed.
        """
        return pulumi.get(self, "resource_uri")


@pulumi.output_type
class DeploymentOccurrenceResponse(dict):
    """
    The period during which some deployable was active in a runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployTime":
            suggest = "deploy_time"
        elif key == "resourceUri":
            suggest = "resource_uri"
        elif key == "undeployTime":
            suggest = "undeploy_time"
        elif key == "userEmail":
            suggest = "user_email"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address: str,
                 config: str,
                 deploy_time: str,
                 platform: str,
                 resource_uri: Sequence[str],
                 undeploy_time: str,
                 user_email: str):
        """
        The period during which some deployable was active in a runtime.
        :param str address: Address of the runtime element hosting this deployment.
        :param str config: Configuration used to create this deployment.
        :param str deploy_time: Beginning of the lifetime of this deployment.
        :param str platform: Platform hosting this deployment.
        :param Sequence[str] resource_uri: Resource URI for the artifact being deployed taken from the deployable field with the same name.
        :param str undeploy_time: End of the lifetime of this deployment.
        :param str user_email: Identity of the user that triggered this deployment.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "deploy_time", deploy_time)
        pulumi.set(__self__, "platform", platform)
        pulumi.set(__self__, "resource_uri", resource_uri)
        pulumi.set(__self__, "undeploy_time", undeploy_time)
        pulumi.set(__self__, "user_email", user_email)

    @property
    @pulumi.getter
    def address(self) -> str:
        """
        Address of the runtime element hosting this deployment.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def config(self) -> str:
        """
        Configuration used to create this deployment.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="deployTime")
    def deploy_time(self) -> str:
        """
        Beginning of the lifetime of this deployment.
        """
        return pulumi.get(self, "deploy_time")

    @property
    @pulumi.getter
    def platform(self) -> str:
        """
        Platform hosting this deployment.
        """
        return pulumi.get(self, "platform")

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> Sequence[str]:
        """
        Resource URI for the artifact being deployed taken from the deployable field with the same name.
        """
        return pulumi.get(self, "resource_uri")

    @property
    @pulumi.getter(name="undeployTime")
    def undeploy_time(self) -> str:
        """
        End of the lifetime of this deployment.
        """
        return pulumi.get(self, "undeploy_time")

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> str:
        """
        Identity of the user that triggered this deployment.
        """
        return pulumi.get(self, "user_email")


@pulumi.output_type
class DetailResponse(dict):
    """
    A detail for a distro and package affected by this vulnerability and its associated fix (if one is available).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "affectedCpeUri":
            suggest = "affected_cpe_uri"
        elif key == "affectedPackage":
            suggest = "affected_package"
        elif key == "affectedVersionEnd":
            suggest = "affected_version_end"
        elif key == "affectedVersionStart":
            suggest = "affected_version_start"
        elif key == "fixedCpeUri":
            suggest = "fixed_cpe_uri"
        elif key == "fixedPackage":
            suggest = "fixed_package"
        elif key == "fixedVersion":
            suggest = "fixed_version"
        elif key == "isObsolete":
            suggest = "is_obsolete"
        elif key == "packageType":
            suggest = "package_type"
        elif key == "severityName":
            suggest = "severity_name"
        elif key == "sourceUpdateTime":
            suggest = "source_update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 affected_cpe_uri: str,
                 affected_package: str,
                 affected_version_end: 'outputs.VersionResponse',
                 affected_version_start: 'outputs.VersionResponse',
                 description: str,
                 fixed_cpe_uri: str,
                 fixed_package: str,
                 fixed_version: 'outputs.VersionResponse',
                 is_obsolete: bool,
                 package_type: str,
                 severity_name: str,
                 source: str,
                 source_update_time: str,
                 vendor: str):
        """
        A detail for a distro and package affected by this vulnerability and its associated fix (if one is available).
        :param str affected_cpe_uri: The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability affects.
        :param str affected_package: The package this vulnerability affects.
        :param 'VersionResponse' affected_version_end: The version number at the end of an interval in which this vulnerability exists. A vulnerability can affect a package between version numbers that are disjoint sets of intervals (example: [1.0.0-1.1.0], [2.4.6-2.4.8] and [4.5.6-4.6.8]) each of which will be represented in its own Detail. If a specific affected version is provided by a vulnerability database, affected_version_start and affected_version_end will be the same in that Detail.
        :param 'VersionResponse' affected_version_start: The version number at the start of an interval in which this vulnerability exists. A vulnerability can affect a package between version numbers that are disjoint sets of intervals (example: [1.0.0-1.1.0], [2.4.6-2.4.8] and [4.5.6-4.6.8]) each of which will be represented in its own Detail. If a specific affected version is provided by a vulnerability database, affected_version_start and affected_version_end will be the same in that Detail.
        :param str description: A vendor-specific description of this vulnerability.
        :param str fixed_cpe_uri: The distro recommended [CPE URI](https://cpe.mitre.org/specification/) to update to that contains a fix for this vulnerability. It is possible for this to be different from the affected_cpe_uri.
        :param str fixed_package: The distro recommended package to update to that contains a fix for this vulnerability. It is possible for this to be different from the affected_package.
        :param 'VersionResponse' fixed_version: The distro recommended version to update to that contains a fix for this vulnerability. Setting this to VersionKind.MAXIMUM means no such version is yet available.
        :param bool is_obsolete: Whether this detail is obsolete. Occurrences are expected not to point to obsolete details.
        :param str package_type: The type of package; whether native or non native (e.g., ruby gems, node.js packages, etc.).
        :param str severity_name: The distro assigned severity of this vulnerability.
        :param str source: The source from which the information in this Detail was obtained.
        :param str source_update_time: The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        :param str vendor: The name of the vendor of the product.
        """
        pulumi.set(__self__, "affected_cpe_uri", affected_cpe_uri)
        pulumi.set(__self__, "affected_package", affected_package)
        pulumi.set(__self__, "affected_version_end", affected_version_end)
        pulumi.set(__self__, "affected_version_start", affected_version_start)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "fixed_cpe_uri", fixed_cpe_uri)
        pulumi.set(__self__, "fixed_package", fixed_package)
        pulumi.set(__self__, "fixed_version", fixed_version)
        pulumi.set(__self__, "is_obsolete", is_obsolete)
        pulumi.set(__self__, "package_type", package_type)
        pulumi.set(__self__, "severity_name", severity_name)
        pulumi.set(__self__, "source", source)
        pulumi.set(__self__, "source_update_time", source_update_time)
        pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter(name="affectedCpeUri")
    def affected_cpe_uri(self) -> str:
        """
        The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability affects.
        """
        return pulumi.get(self, "affected_cpe_uri")

    @property
    @pulumi.getter(name="affectedPackage")
    def affected_package(self) -> str:
        """
        The package this vulnerability affects.
        """
        return pulumi.get(self, "affected_package")

    @property
    @pulumi.getter(name="affectedVersionEnd")
    def affected_version_end(self) -> 'outputs.VersionResponse':
        """
        The version number at the end of an interval in which this vulnerability exists. A vulnerability can affect a package between version numbers that are disjoint sets of intervals (example: [1.0.0-1.1.0], [2.4.6-2.4.8] and [4.5.6-4.6.8]) each of which will be represented in its own Detail. If a specific affected version is provided by a vulnerability database, affected_version_start and affected_version_end will be the same in that Detail.
        """
        return pulumi.get(self, "affected_version_end")

    @property
    @pulumi.getter(name="affectedVersionStart")
    def affected_version_start(self) -> 'outputs.VersionResponse':
        """
        The version number at the start of an interval in which this vulnerability exists. A vulnerability can affect a package between version numbers that are disjoint sets of intervals (example: [1.0.0-1.1.0], [2.4.6-2.4.8] and [4.5.6-4.6.8]) each of which will be represented in its own Detail. If a specific affected version is provided by a vulnerability database, affected_version_start and affected_version_end will be the same in that Detail.
        """
        return pulumi.get(self, "affected_version_start")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A vendor-specific description of this vulnerability.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fixedCpeUri")
    def fixed_cpe_uri(self) -> str:
        """
        The distro recommended [CPE URI](https://cpe.mitre.org/specification/) to update to that contains a fix for this vulnerability. It is possible for this to be different from the affected_cpe_uri.
        """
        return pulumi.get(self, "fixed_cpe_uri")

    @property
    @pulumi.getter(name="fixedPackage")
    def fixed_package(self) -> str:
        """
        The distro recommended package to update to that contains a fix for this vulnerability. It is possible for this to be different from the affected_package.
        """
        return pulumi.get(self, "fixed_package")

    @property
    @pulumi.getter(name="fixedVersion")
    def fixed_version(self) -> 'outputs.VersionResponse':
        """
        The distro recommended version to update to that contains a fix for this vulnerability. Setting this to VersionKind.MAXIMUM means no such version is yet available.
        """
        return pulumi.get(self, "fixed_version")

    @property
    @pulumi.getter(name="isObsolete")
    def is_obsolete(self) -> bool:
        """
        Whether this detail is obsolete. Occurrences are expected not to point to obsolete details.
        """
        return pulumi.get(self, "is_obsolete")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The type of package; whether native or non native (e.g., ruby gems, node.js packages, etc.).
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="severityName")
    def severity_name(self) -> str:
        """
        The distro assigned severity of this vulnerability.
        """
        return pulumi.get(self, "severity_name")

    @property
    @pulumi.getter
    def source(self) -> str:
        """
        The source from which the information in this Detail was obtained.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter(name="sourceUpdateTime")
    def source_update_time(self) -> str:
        """
        The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        """
        return pulumi.get(self, "source_update_time")

    @property
    @pulumi.getter
    def vendor(self) -> str:
        """
        The name of the vendor of the product.
        """
        return pulumi.get(self, "vendor")


@pulumi.output_type
class DiscoveryNoteResponse(dict):
    """
    A note that indicates a type of analysis a provider would perform. This note exists in a provider's project. A `Discovery` occurrence is created in a consumer's project at the start of analysis.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analysisKind":
            suggest = "analysis_kind"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryNoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryNoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryNoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analysis_kind: str):
        """
        A note that indicates a type of analysis a provider would perform. This note exists in a provider's project. A `Discovery` occurrence is created in a consumer's project at the start of analysis.
        :param str analysis_kind: Immutable. The kind of analysis that is handled by this discovery.
        """
        pulumi.set(__self__, "analysis_kind", analysis_kind)

    @property
    @pulumi.getter(name="analysisKind")
    def analysis_kind(self) -> str:
        """
        Immutable. The kind of analysis that is handled by this discovery.
        """
        return pulumi.get(self, "analysis_kind")


@pulumi.output_type
class DiscoveryOccurrenceResponse(dict):
    """
    Provides information about the analysis status of a discovered resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "analysisStatus":
            suggest = "analysis_status"
        elif key == "analysisStatusError":
            suggest = "analysis_status_error"
        elif key == "archiveTime":
            suggest = "archive_time"
        elif key == "continuousAnalysis":
            suggest = "continuous_analysis"
        elif key == "lastScanTime":
            suggest = "last_scan_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiscoveryOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiscoveryOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiscoveryOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 analysis_status: str,
                 analysis_status_error: 'outputs.StatusResponse',
                 archive_time: str,
                 continuous_analysis: str,
                 cpe: str,
                 last_scan_time: str):
        """
        Provides information about the analysis status of a discovered resource.
        :param str analysis_status: The status of discovery for the resource.
        :param 'StatusResponse' analysis_status_error: When an error is encountered this will contain a LocalizedMessage under details to show to the user. The LocalizedMessage is output only and populated by the API.
        :param str archive_time: The time occurrences related to this discovery occurrence were archived.
        :param str continuous_analysis: Whether the resource is continuously analyzed.
        :param str cpe: The CPE of the resource being scanned.
        :param str last_scan_time: The last time this resource was scanned.
        """
        pulumi.set(__self__, "analysis_status", analysis_status)
        pulumi.set(__self__, "analysis_status_error", analysis_status_error)
        pulumi.set(__self__, "archive_time", archive_time)
        pulumi.set(__self__, "continuous_analysis", continuous_analysis)
        pulumi.set(__self__, "cpe", cpe)
        pulumi.set(__self__, "last_scan_time", last_scan_time)

    @property
    @pulumi.getter(name="analysisStatus")
    def analysis_status(self) -> str:
        """
        The status of discovery for the resource.
        """
        return pulumi.get(self, "analysis_status")

    @property
    @pulumi.getter(name="analysisStatusError")
    def analysis_status_error(self) -> 'outputs.StatusResponse':
        """
        When an error is encountered this will contain a LocalizedMessage under details to show to the user. The LocalizedMessage is output only and populated by the API.
        """
        return pulumi.get(self, "analysis_status_error")

    @property
    @pulumi.getter(name="archiveTime")
    def archive_time(self) -> str:
        """
        The time occurrences related to this discovery occurrence were archived.
        """
        return pulumi.get(self, "archive_time")

    @property
    @pulumi.getter(name="continuousAnalysis")
    def continuous_analysis(self) -> str:
        """
        Whether the resource is continuously analyzed.
        """
        return pulumi.get(self, "continuous_analysis")

    @property
    @pulumi.getter
    def cpe(self) -> str:
        """
        The CPE of the resource being scanned.
        """
        return pulumi.get(self, "cpe")

    @property
    @pulumi.getter(name="lastScanTime")
    def last_scan_time(self) -> str:
        """
        The last time this resource was scanned.
        """
        return pulumi.get(self, "last_scan_time")


@pulumi.output_type
class DistributionResponse(dict):
    """
    This represents a particular channel of distribution for a given package. E.g., Debian's jessie-backports dpkg mirror.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"
        elif key == "latestVersion":
            suggest = "latest_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DistributionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DistributionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DistributionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 architecture: str,
                 cpe_uri: str,
                 description: str,
                 latest_version: 'outputs.VersionResponse',
                 maintainer: str,
                 url: str):
        """
        This represents a particular channel of distribution for a given package. E.g., Debian's jessie-backports dpkg mirror.
        :param str architecture: The CPU architecture for which packages in this distribution channel were built.
        :param str cpe_uri: The cpe_uri in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        :param str description: The distribution channel-specific description of this package.
        :param 'VersionResponse' latest_version: The latest available version of this package in this distribution channel.
        :param str maintainer: A freeform string denoting the maintainer of this package.
        :param str url: The distribution channel-specific homepage for this package.
        """
        pulumi.set(__self__, "architecture", architecture)
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "latest_version", latest_version)
        pulumi.set(__self__, "maintainer", maintainer)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def architecture(self) -> str:
        """
        The CPU architecture for which packages in this distribution channel were built.
        """
        return pulumi.get(self, "architecture")

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The cpe_uri in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The distribution channel-specific description of this package.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> 'outputs.VersionResponse':
        """
        The latest available version of this package in this distribution channel.
        """
        return pulumi.get(self, "latest_version")

    @property
    @pulumi.getter
    def maintainer(self) -> str:
        """
        A freeform string denoting the maintainer of this package.
        """
        return pulumi.get(self, "maintainer")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        The distribution channel-specific homepage for this package.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class EnvelopeResponse(dict):
    """
    MUST match https://github.com/secure-systems-lab/dsse/blob/master/envelope.proto. An authenticated message of arbitrary type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "payloadType":
            suggest = "payload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvelopeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvelopeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvelopeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 payload: str,
                 payload_type: str,
                 signatures: Sequence['outputs.EnvelopeSignatureResponse']):
        """
        MUST match https://github.com/secure-systems-lab/dsse/blob/master/envelope.proto. An authenticated message of arbitrary type.
        """
        pulumi.set(__self__, "payload", payload)
        pulumi.set(__self__, "payload_type", payload_type)
        pulumi.set(__self__, "signatures", signatures)

    @property
    @pulumi.getter
    def payload(self) -> str:
        return pulumi.get(self, "payload")

    @property
    @pulumi.getter(name="payloadType")
    def payload_type(self) -> str:
        return pulumi.get(self, "payload_type")

    @property
    @pulumi.getter
    def signatures(self) -> Sequence['outputs.EnvelopeSignatureResponse']:
        return pulumi.get(self, "signatures")


@pulumi.output_type
class EnvelopeSignatureResponse(dict):
    def __init__(__self__, *,
                 keyid: str,
                 sig: str):
        pulumi.set(__self__, "keyid", keyid)
        pulumi.set(__self__, "sig", sig)

    @property
    @pulumi.getter
    def keyid(self) -> str:
        return pulumi.get(self, "keyid")

    @property
    @pulumi.getter
    def sig(self) -> str:
        return pulumi.get(self, "sig")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class FingerprintResponse(dict):
    """
    A set of properties that uniquely identify a given Docker image.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "v1Name":
            suggest = "v1_name"
        elif key == "v2Blob":
            suggest = "v2_blob"
        elif key == "v2Name":
            suggest = "v2_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FingerprintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FingerprintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FingerprintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 v1_name: str,
                 v2_blob: Sequence[str],
                 v2_name: str):
        """
        A set of properties that uniquely identify a given Docker image.
        :param str v1_name: The layer ID of the final layer in the Docker image's v1 representation.
        :param Sequence[str] v2_blob: The ordered list of v2 blobs that represent a given image.
        :param str v2_name: The name of the image's v2 blobs computed via: [bottom] := v2_blobbottom := sha256(v2_blob[N] + " " + v2_name[N+1]) Only the name of the final blob is kept.
        """
        pulumi.set(__self__, "v1_name", v1_name)
        pulumi.set(__self__, "v2_blob", v2_blob)
        pulumi.set(__self__, "v2_name", v2_name)

    @property
    @pulumi.getter(name="v1Name")
    def v1_name(self) -> str:
        """
        The layer ID of the final layer in the Docker image's v1 representation.
        """
        return pulumi.get(self, "v1_name")

    @property
    @pulumi.getter(name="v2Blob")
    def v2_blob(self) -> Sequence[str]:
        """
        The ordered list of v2 blobs that represent a given image.
        """
        return pulumi.get(self, "v2_blob")

    @property
    @pulumi.getter(name="v2Name")
    def v2_name(self) -> str:
        """
        The name of the image's v2 blobs computed via: [bottom] := v2_blobbottom := sha256(v2_blob[N] + " " + v2_name[N+1]) Only the name of the final blob is kept.
        """
        return pulumi.get(self, "v2_name")


@pulumi.output_type
class GerritSourceContextResponse(dict):
    """
    A SourceContext referring to a Gerrit project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "aliasContext":
            suggest = "alias_context"
        elif key == "gerritProject":
            suggest = "gerrit_project"
        elif key == "hostUri":
            suggest = "host_uri"
        elif key == "revisionId":
            suggest = "revision_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GerritSourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GerritSourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GerritSourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alias_context: 'outputs.AliasContextResponse',
                 gerrit_project: str,
                 host_uri: str,
                 revision_id: str):
        """
        A SourceContext referring to a Gerrit project.
        :param 'AliasContextResponse' alias_context: An alias, which may be a branch or tag.
        :param str gerrit_project: The full project name within the host. Projects may be nested, so "project/subproject" is a valid project name. The "repo name" is the hostURI/project.
        :param str host_uri: The URI of a running Gerrit instance.
        :param str revision_id: A revision (commit) ID.
        """
        pulumi.set(__self__, "alias_context", alias_context)
        pulumi.set(__self__, "gerrit_project", gerrit_project)
        pulumi.set(__self__, "host_uri", host_uri)
        pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter(name="aliasContext")
    def alias_context(self) -> 'outputs.AliasContextResponse':
        """
        An alias, which may be a branch or tag.
        """
        return pulumi.get(self, "alias_context")

    @property
    @pulumi.getter(name="gerritProject")
    def gerrit_project(self) -> str:
        """
        The full project name within the host. Projects may be nested, so "project/subproject" is a valid project name. The "repo name" is the hostURI/project.
        """
        return pulumi.get(self, "gerrit_project")

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> str:
        """
        The URI of a running Gerrit instance.
        """
        return pulumi.get(self, "host_uri")

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        A revision (commit) ID.
        """
        return pulumi.get(self, "revision_id")


@pulumi.output_type
class GitSourceContextResponse(dict):
    """
    A GitSourceContext denotes a particular revision in a third party Git repository (e.g., GitHub).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "revisionId":
            suggest = "revision_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GitSourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GitSourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GitSourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revision_id: str,
                 url: str):
        """
        A GitSourceContext denotes a particular revision in a third party Git repository (e.g., GitHub).
        :param str revision_id: Git commit hash.
        :param str url: Git repository URL.
        """
        pulumi.set(__self__, "revision_id", revision_id)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> str:
        """
        Git commit hash.
        """
        return pulumi.get(self, "revision_id")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Git repository URL.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class HintResponse(dict):
    """
    This submessage provides human-readable hints about the purpose of the authority. Because the name of a note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should not be used to look up authorities in security sensitive contexts, such as when looking up attestations to verify.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "humanReadableName":
            suggest = "human_readable_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HintResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HintResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HintResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 human_readable_name: str):
        """
        This submessage provides human-readable hints about the purpose of the authority. Because the name of a note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should not be used to look up authorities in security sensitive contexts, such as when looking up attestations to verify.
        :param str human_readable_name: The human readable name of this attestation authority, for example "qa".
        """
        pulumi.set(__self__, "human_readable_name", human_readable_name)

    @property
    @pulumi.getter(name="humanReadableName")
    def human_readable_name(self) -> str:
        """
        The human readable name of this attestation authority, for example "qa".
        """
        return pulumi.get(self, "human_readable_name")


@pulumi.output_type
class IdentityResponse(dict):
    """
    The unique identifier of the update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateId":
            suggest = "update_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 revision: int,
                 update_id: str):
        """
        The unique identifier of the update.
        :param int revision: The revision number of the update.
        :param str update_id: The revision independent identifier of the update.
        """
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "update_id", update_id)

    @property
    @pulumi.getter
    def revision(self) -> int:
        """
        The revision number of the update.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="updateId")
    def update_id(self) -> str:
        """
        The revision independent identifier of the update.
        """
        return pulumi.get(self, "update_id")


@pulumi.output_type
class ImageNoteResponse(dict):
    """
    Basis describes the base image portion (Note) of the DockerImage relationship. Linked occurrences are derived from this or an equivalent image via: FROM Or an equivalent reference, e.g., a tag of the resource_url.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceUrl":
            suggest = "resource_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageNoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageNoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageNoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fingerprint: 'outputs.FingerprintResponse',
                 resource_url: str):
        """
        Basis describes the base image portion (Note) of the DockerImage relationship. Linked occurrences are derived from this or an equivalent image via: FROM Or an equivalent reference, e.g., a tag of the resource_url.
        :param 'FingerprintResponse' fingerprint: Immutable. The fingerprint of the base image.
        :param str resource_url: Immutable. The resource_url for the resource representing the basis of associated occurrence images.
        """
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "resource_url", resource_url)

    @property
    @pulumi.getter
    def fingerprint(self) -> 'outputs.FingerprintResponse':
        """
        Immutable. The fingerprint of the base image.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="resourceUrl")
    def resource_url(self) -> str:
        """
        Immutable. The resource_url for the resource representing the basis of associated occurrence images.
        """
        return pulumi.get(self, "resource_url")


@pulumi.output_type
class ImageOccurrenceResponse(dict):
    """
    Details of the derived image portion of the DockerImage relationship. This image would be produced from a Dockerfile with FROM .
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseResourceUrl":
            suggest = "base_resource_url"
        elif key == "layerInfo":
            suggest = "layer_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_resource_url: str,
                 distance: int,
                 fingerprint: 'outputs.FingerprintResponse',
                 layer_info: Sequence['outputs.LayerResponse']):
        """
        Details of the derived image portion of the DockerImage relationship. This image would be produced from a Dockerfile with FROM .
        :param str base_resource_url: This contains the base image URL for the derived image occurrence.
        :param int distance: The number of layers by which this image differs from the associated image basis.
        :param 'FingerprintResponse' fingerprint: The fingerprint of the derived image.
        :param Sequence['LayerResponse'] layer_info: This contains layer-specific metadata, if populated it has length "distance" and is ordered with [distance] being the layer immediately following the base image and [1] being the final layer.
        """
        pulumi.set(__self__, "base_resource_url", base_resource_url)
        pulumi.set(__self__, "distance", distance)
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "layer_info", layer_info)

    @property
    @pulumi.getter(name="baseResourceUrl")
    def base_resource_url(self) -> str:
        """
        This contains the base image URL for the derived image occurrence.
        """
        return pulumi.get(self, "base_resource_url")

    @property
    @pulumi.getter
    def distance(self) -> int:
        """
        The number of layers by which this image differs from the associated image basis.
        """
        return pulumi.get(self, "distance")

    @property
    @pulumi.getter
    def fingerprint(self) -> 'outputs.FingerprintResponse':
        """
        The fingerprint of the derived image.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter(name="layerInfo")
    def layer_info(self) -> Sequence['outputs.LayerResponse']:
        """
        This contains layer-specific metadata, if populated it has length "distance" and is ordered with [distance] being the layer immediately following the base image and [1] being the final layer.
        """
        return pulumi.get(self, "layer_info")


@pulumi.output_type
class InTotoProvenanceResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "builderConfig":
            suggest = "builder_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InTotoProvenanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InTotoProvenanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InTotoProvenanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 builder_config: 'outputs.BuilderConfigResponse',
                 materials: Sequence[str],
                 metadata: 'outputs.MetadataResponse',
                 recipe: 'outputs.RecipeResponse'):
        """
        :param 'BuilderConfigResponse' builder_config: required
        :param Sequence[str] materials: The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        :param 'RecipeResponse' recipe: Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible). required
        """
        pulumi.set(__self__, "builder_config", builder_config)
        pulumi.set(__self__, "materials", materials)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "recipe", recipe)

    @property
    @pulumi.getter(name="builderConfig")
    def builder_config(self) -> 'outputs.BuilderConfigResponse':
        """
        required
        """
        return pulumi.get(self, "builder_config")

    @property
    @pulumi.getter
    def materials(self) -> Sequence[str]:
        """
        The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        """
        return pulumi.get(self, "materials")

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.MetadataResponse':
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def recipe(self) -> 'outputs.RecipeResponse':
        """
        Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible). required
        """
        return pulumi.get(self, "recipe")


@pulumi.output_type
class InTotoStatementResponse(dict):
    """
    Spec defined at https://github.com/in-toto/attestation/tree/main/spec#statement The serialized InTotoStatement will be stored as Envelope.payload. Envelope.payloadType is always "application/vnd.in-toto+json".
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "predicateType":
            suggest = "predicate_type"
        elif key == "slsaProvenance":
            suggest = "slsa_provenance"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InTotoStatementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InTotoStatementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InTotoStatementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 predicate_type: str,
                 provenance: 'outputs.InTotoProvenanceResponse',
                 slsa_provenance: 'outputs.SlsaProvenanceResponse',
                 subject: Sequence['outputs.SubjectResponse'],
                 type: str):
        """
        Spec defined at https://github.com/in-toto/attestation/tree/main/spec#statement The serialized InTotoStatement will be stored as Envelope.payload. Envelope.payloadType is always "application/vnd.in-toto+json".
        :param str predicate_type: `https://slsa.dev/provenance/v0.1` for SlsaProvenance.
        :param str type: Always `https://in-toto.io/Statement/v0.1`.
        """
        pulumi.set(__self__, "predicate_type", predicate_type)
        pulumi.set(__self__, "provenance", provenance)
        pulumi.set(__self__, "slsa_provenance", slsa_provenance)
        pulumi.set(__self__, "subject", subject)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="predicateType")
    def predicate_type(self) -> str:
        """
        `https://slsa.dev/provenance/v0.1` for SlsaProvenance.
        """
        return pulumi.get(self, "predicate_type")

    @property
    @pulumi.getter
    def provenance(self) -> 'outputs.InTotoProvenanceResponse':
        return pulumi.get(self, "provenance")

    @property
    @pulumi.getter(name="slsaProvenance")
    def slsa_provenance(self) -> 'outputs.SlsaProvenanceResponse':
        return pulumi.get(self, "slsa_provenance")

    @property
    @pulumi.getter
    def subject(self) -> Sequence['outputs.SubjectResponse']:
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Always `https://in-toto.io/Statement/v0.1`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JwtResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "compactJwt":
            suggest = "compact_jwt"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JwtResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JwtResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JwtResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 compact_jwt: str):
        """
        :param str compact_jwt: The compact encoding of a JWS, which is always three base64 encoded strings joined by periods. For details, see: https://tools.ietf.org/html/rfc7515.html#section-3.1
        """
        pulumi.set(__self__, "compact_jwt", compact_jwt)

    @property
    @pulumi.getter(name="compactJwt")
    def compact_jwt(self) -> str:
        """
        The compact encoding of a JWS, which is always three base64 encoded strings joined by periods. For details, see: https://tools.ietf.org/html/rfc7515.html#section-3.1
        """
        return pulumi.get(self, "compact_jwt")


@pulumi.output_type
class KnowledgeBaseResponse(dict):
    def __init__(__self__, *,
                 name: str,
                 url: str):
        """
        :param str name: The KB name (generally of the form KB[0-9]+ (e.g., KB123456)).
        :param str url: A link to the KB in the [Windows update catalog] (https://www.catalog.update.microsoft.com/).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The KB name (generally of the form KB[0-9]+ (e.g., KB123456)).
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        A link to the KB in the [Windows update catalog] (https://www.catalog.update.microsoft.com/).
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class LayerResponse(dict):
    """
    Layer holds metadata specific to a layer of a Docker image.
    """
    def __init__(__self__, *,
                 arguments: str,
                 directive: str):
        """
        Layer holds metadata specific to a layer of a Docker image.
        :param str arguments: The recovered arguments to the Dockerfile directive.
        :param str directive: The recovered Dockerfile directive used to construct this layer. See https://docs.docker.com/engine/reference/builder/ for more information.
        """
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "directive", directive)

    @property
    @pulumi.getter
    def arguments(self) -> str:
        """
        The recovered arguments to the Dockerfile directive.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def directive(self) -> str:
        """
        The recovered Dockerfile directive used to construct this layer. See https://docs.docker.com/engine/reference/builder/ for more information.
        """
        return pulumi.get(self, "directive")


@pulumi.output_type
class LocationResponse(dict):
    """
    An occurrence of a particular package installation found within a system's filesystem. E.g., glibc was found in `/var/lib/dpkg/status`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LocationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LocationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LocationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpe_uri: str,
                 path: str,
                 version: 'outputs.VersionResponse'):
        """
        An occurrence of a particular package installation found within a system's filesystem. E.g., glibc was found in `/var/lib/dpkg/status`.
        :param str cpe_uri: The CPE URI in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        :param str path: The path from which we gathered that this package/version is installed.
        :param 'VersionResponse' version: The version installed at this location.
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The CPE URI in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The path from which we gathered that this package/version is installed.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def version(self) -> 'outputs.VersionResponse':
        """
        The version installed at this location.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class MaterialResponse(dict):
    def __init__(__self__, *,
                 digest: Mapping[str, str],
                 uri: str):
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def digest(self) -> Mapping[str, str]:
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def uri(self) -> str:
        return pulumi.get(self, "uri")


@pulumi.output_type
class MetadataResponse(dict):
    """
    Other properties of the build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildFinishedOn":
            suggest = "build_finished_on"
        elif key == "buildInvocationId":
            suggest = "build_invocation_id"
        elif key == "buildStartedOn":
            suggest = "build_started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_finished_on: str,
                 build_invocation_id: str,
                 build_started_on: str,
                 completeness: 'outputs.CompletenessResponse',
                 reproducible: bool):
        """
        Other properties of the build.
        :param str build_finished_on: The timestamp of when the build completed.
        :param str build_invocation_id: Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        :param str build_started_on: The timestamp of when the build started.
        :param 'CompletenessResponse' completeness: Indicates that the builder claims certain fields in this message to be complete.
        :param bool reproducible: If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        pulumi.set(__self__, "build_finished_on", build_finished_on)
        pulumi.set(__self__, "build_invocation_id", build_invocation_id)
        pulumi.set(__self__, "build_started_on", build_started_on)
        pulumi.set(__self__, "completeness", completeness)
        pulumi.set(__self__, "reproducible", reproducible)

    @property
    @pulumi.getter(name="buildFinishedOn")
    def build_finished_on(self) -> str:
        """
        The timestamp of when the build completed.
        """
        return pulumi.get(self, "build_finished_on")

    @property
    @pulumi.getter(name="buildInvocationId")
    def build_invocation_id(self) -> str:
        """
        Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        """
        return pulumi.get(self, "build_invocation_id")

    @property
    @pulumi.getter(name="buildStartedOn")
    def build_started_on(self) -> str:
        """
        The timestamp of when the build started.
        """
        return pulumi.get(self, "build_started_on")

    @property
    @pulumi.getter
    def completeness(self) -> 'outputs.CompletenessResponse':
        """
        Indicates that the builder claims certain fields in this message to be complete.
        """
        return pulumi.get(self, "completeness")

    @property
    @pulumi.getter
    def reproducible(self) -> bool:
        """
        If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        return pulumi.get(self, "reproducible")


@pulumi.output_type
class NonCompliantFileResponse(dict):
    """
    Details about files that caused a compliance check to fail. display_command is a single command that can be used to display a list of non compliant files. When there is no such command, we can also iterate a list of non compliant file using 'path'.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayCommand":
            suggest = "display_command"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NonCompliantFileResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NonCompliantFileResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NonCompliantFileResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_command: str,
                 path: str,
                 reason: str):
        """
        Details about files that caused a compliance check to fail. display_command is a single command that can be used to display a list of non compliant files. When there is no such command, we can also iterate a list of non compliant file using 'path'.
        :param str display_command: Command to display the non-compliant files.
        :param str path: Empty if `display_command` is set.
        :param str reason: Explains why a file is non compliant for a CIS check.
        """
        pulumi.set(__self__, "display_command", display_command)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter(name="displayCommand")
    def display_command(self) -> str:
        """
        Command to display the non-compliant files.
        """
        return pulumi.get(self, "display_command")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Empty if `display_command` is set.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        Explains why a file is non compliant for a CIS check.
        """
        return pulumi.get(self, "reason")


@pulumi.output_type
class PackageIssueResponse(dict):
    """
    A detail for a distro and package this vulnerability occurrence was found in and its associated fix (if one is available).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "affectedCpeUri":
            suggest = "affected_cpe_uri"
        elif key == "affectedPackage":
            suggest = "affected_package"
        elif key == "affectedVersion":
            suggest = "affected_version"
        elif key == "effectiveSeverity":
            suggest = "effective_severity"
        elif key == "fixAvailable":
            suggest = "fix_available"
        elif key == "fixedCpeUri":
            suggest = "fixed_cpe_uri"
        elif key == "fixedPackage":
            suggest = "fixed_package"
        elif key == "fixedVersion":
            suggest = "fixed_version"
        elif key == "packageType":
            suggest = "package_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PackageIssueResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PackageIssueResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PackageIssueResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 affected_cpe_uri: str,
                 affected_package: str,
                 affected_version: 'outputs.VersionResponse',
                 effective_severity: str,
                 fix_available: bool,
                 fixed_cpe_uri: str,
                 fixed_package: str,
                 fixed_version: 'outputs.VersionResponse',
                 package_type: str):
        """
        A detail for a distro and package this vulnerability occurrence was found in and its associated fix (if one is available).
        :param str affected_cpe_uri: The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability was found in.
        :param str affected_package: The package this vulnerability was found in.
        :param 'VersionResponse' affected_version: The version of the package that is installed on the resource affected by this vulnerability.
        :param str effective_severity: The distro or language system assigned severity for this vulnerability when that is available and note provider assigned severity when it is not available.
        :param bool fix_available: Whether a fix is available for this package.
        :param str fixed_cpe_uri: The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability was fixed in. It is possible for this to be different from the affected_cpe_uri.
        :param str fixed_package: The package this vulnerability was fixed in. It is possible for this to be different from the affected_package.
        :param 'VersionResponse' fixed_version: The version of the package this vulnerability was fixed in. Setting this to VersionKind.MAXIMUM means no fix is yet available.
        :param str package_type: The type of package (e.g. OS, MAVEN, GO).
        """
        pulumi.set(__self__, "affected_cpe_uri", affected_cpe_uri)
        pulumi.set(__self__, "affected_package", affected_package)
        pulumi.set(__self__, "affected_version", affected_version)
        pulumi.set(__self__, "effective_severity", effective_severity)
        pulumi.set(__self__, "fix_available", fix_available)
        pulumi.set(__self__, "fixed_cpe_uri", fixed_cpe_uri)
        pulumi.set(__self__, "fixed_package", fixed_package)
        pulumi.set(__self__, "fixed_version", fixed_version)
        pulumi.set(__self__, "package_type", package_type)

    @property
    @pulumi.getter(name="affectedCpeUri")
    def affected_cpe_uri(self) -> str:
        """
        The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability was found in.
        """
        return pulumi.get(self, "affected_cpe_uri")

    @property
    @pulumi.getter(name="affectedPackage")
    def affected_package(self) -> str:
        """
        The package this vulnerability was found in.
        """
        return pulumi.get(self, "affected_package")

    @property
    @pulumi.getter(name="affectedVersion")
    def affected_version(self) -> 'outputs.VersionResponse':
        """
        The version of the package that is installed on the resource affected by this vulnerability.
        """
        return pulumi.get(self, "affected_version")

    @property
    @pulumi.getter(name="effectiveSeverity")
    def effective_severity(self) -> str:
        """
        The distro or language system assigned severity for this vulnerability when that is available and note provider assigned severity when it is not available.
        """
        return pulumi.get(self, "effective_severity")

    @property
    @pulumi.getter(name="fixAvailable")
    def fix_available(self) -> bool:
        """
        Whether a fix is available for this package.
        """
        return pulumi.get(self, "fix_available")

    @property
    @pulumi.getter(name="fixedCpeUri")
    def fixed_cpe_uri(self) -> str:
        """
        The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability was fixed in. It is possible for this to be different from the affected_cpe_uri.
        """
        return pulumi.get(self, "fixed_cpe_uri")

    @property
    @pulumi.getter(name="fixedPackage")
    def fixed_package(self) -> str:
        """
        The package this vulnerability was fixed in. It is possible for this to be different from the affected_package.
        """
        return pulumi.get(self, "fixed_package")

    @property
    @pulumi.getter(name="fixedVersion")
    def fixed_version(self) -> 'outputs.VersionResponse':
        """
        The version of the package this vulnerability was fixed in. Setting this to VersionKind.MAXIMUM means no fix is yet available.
        """
        return pulumi.get(self, "fixed_version")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The type of package (e.g. OS, MAVEN, GO).
        """
        return pulumi.get(self, "package_type")


@pulumi.output_type
class PackageNoteResponse(dict):
    """
    This represents a particular package that is distributed over various channels. E.g., glibc (aka libc6) is distributed by many, at various versions.
    """
    def __init__(__self__, *,
                 distribution: Sequence['outputs.DistributionResponse'],
                 name: str):
        """
        This represents a particular package that is distributed over various channels. E.g., glibc (aka libc6) is distributed by many, at various versions.
        :param Sequence['DistributionResponse'] distribution: The various channels by which a package is distributed.
        :param str name: Immutable. The name of the package.
        """
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def distribution(self) -> Sequence['outputs.DistributionResponse']:
        """
        The various channels by which a package is distributed.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Immutable. The name of the package.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class PackageOccurrenceResponse(dict):
    """
    Details on how a particular software package was installed on a system.
    """
    def __init__(__self__, *,
                 location: Sequence['outputs.LocationResponse'],
                 name: str):
        """
        Details on how a particular software package was installed on a system.
        :param Sequence['LocationResponse'] location: All of the places within the filesystem versions of this package have been found.
        :param str name: The name of the installed package.
        """
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def location(self) -> Sequence['outputs.LocationResponse']:
        """
        All of the places within the filesystem versions of this package have been found.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the installed package.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ProjectRepoIdResponse(dict):
    """
    Selects a repo using a Google Cloud Platform project ID (e.g., winged-cargo-31) and a repo name within that project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoName":
            suggest = "repo_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ProjectRepoIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ProjectRepoIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ProjectRepoIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project: str,
                 repo_name: str):
        """
        Selects a repo using a Google Cloud Platform project ID (e.g., winged-cargo-31) and a repo name within that project.
        :param str project: The ID of the project.
        :param str repo_name: The name of the repo. Leave empty for the default repo.
        """
        pulumi.set(__self__, "project", project)
        pulumi.set(__self__, "repo_name", repo_name)

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> str:
        """
        The name of the repo. Leave empty for the default repo.
        """
        return pulumi.get(self, "repo_name")


@pulumi.output_type
class RecipeResponse(dict):
    """
    Steps taken to build the artifact. For a TaskRun, typically each container corresponds to one step in the recipe.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "definedInMaterial":
            suggest = "defined_in_material"
        elif key == "entryPoint":
            suggest = "entry_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RecipeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RecipeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RecipeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arguments: Sequence[Mapping[str, str]],
                 defined_in_material: str,
                 entry_point: str,
                 environment: Sequence[Mapping[str, str]],
                 type: str):
        """
        Steps taken to build the artifact. For a TaskRun, typically each container corresponds to one step in the recipe.
        :param Sequence[Mapping[str, str]] arguments: Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint. Since the arguments field can greatly vary in structure, depending on the builder and recipe type, this is of form "Any".
        :param str defined_in_material: Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        :param str entry_point: String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        :param Sequence[Mapping[str, str]] environment: Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy. Since the environment field can greatly vary in structure, depending on the builder and recipe type, this is of form "Any".
        :param str type: URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "defined_in_material", defined_in_material)
        pulumi.set(__self__, "entry_point", entry_point)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arguments(self) -> Sequence[Mapping[str, str]]:
        """
        Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint. Since the arguments field can greatly vary in structure, depending on the builder and recipe type, this is of form "Any".
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="definedInMaterial")
    def defined_in_material(self) -> str:
        """
        Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        """
        return pulumi.get(self, "defined_in_material")

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> str:
        """
        String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter
    def environment(self) -> Sequence[Mapping[str, str]]:
        """
        Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy. Since the environment field can greatly vary in structure, depending on the builder and recipe type, this is of form "Any".
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RelatedUrlResponse(dict):
    """
    Metadata for any related URL information.
    """
    def __init__(__self__, *,
                 label: str,
                 url: str):
        """
        Metadata for any related URL information.
        :param str label: Label to describe usage of the URL.
        :param str url: Specific URL associated with the resource.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        Label to describe usage of the URL.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Specific URL associated with the resource.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class RepoIdResponse(dict):
    """
    A unique identifier for a Cloud Repo.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "projectRepoId":
            suggest = "project_repo_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RepoIdResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RepoIdResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RepoIdResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 project_repo_id: 'outputs.ProjectRepoIdResponse',
                 uid: str):
        """
        A unique identifier for a Cloud Repo.
        :param 'ProjectRepoIdResponse' project_repo_id: A combination of a project ID and a repo name.
        :param str uid: A server-assigned, globally unique identifier.
        """
        pulumi.set(__self__, "project_repo_id", project_repo_id)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="projectRepoId")
    def project_repo_id(self) -> 'outputs.ProjectRepoIdResponse':
        """
        A combination of a project ID and a repo name.
        """
        return pulumi.get(self, "project_repo_id")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        A server-assigned, globally unique identifier.
        """
        return pulumi.get(self, "uid")


@pulumi.output_type
class SignatureResponse(dict):
    """
    Verifiers (e.g. Kritis implementations) MUST verify signatures with respect to the trust anchors defined in policy (e.g. a Kritis policy). Typically this means that the verifier has been configured with a map from `public_key_id` to public key material (and any required parameters, e.g. signing algorithm). In particular, verification implementations MUST NOT treat the signature `public_key_id` as anything more than a key lookup hint. The `public_key_id` DOES NOT validate or authenticate a public key; it only provides a mechanism for quickly selecting a public key ALREADY CONFIGURED on the verifier through a trusted channel. Verification implementations MUST reject signatures in any of the following circumstances: * The `public_key_id` is not recognized by the verifier. * The public key that `public_key_id` refers to does not verify the signature with respect to the payload. The `signature` contents SHOULD NOT be "attached" (where the payload is included with the serialized `signature` bytes). Verifiers MUST ignore any "attached" payload and only verify signatures with respect to explicitly provided payload (e.g. a `payload` field on the proto message that holds this Signature, or the canonical serialization of the proto message that holds this signature).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeyId":
            suggest = "public_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SignatureResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SignatureResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SignatureResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_key_id: str,
                 signature: str):
        """
        Verifiers (e.g. Kritis implementations) MUST verify signatures with respect to the trust anchors defined in policy (e.g. a Kritis policy). Typically this means that the verifier has been configured with a map from `public_key_id` to public key material (and any required parameters, e.g. signing algorithm). In particular, verification implementations MUST NOT treat the signature `public_key_id` as anything more than a key lookup hint. The `public_key_id` DOES NOT validate or authenticate a public key; it only provides a mechanism for quickly selecting a public key ALREADY CONFIGURED on the verifier through a trusted channel. Verification implementations MUST reject signatures in any of the following circumstances: * The `public_key_id` is not recognized by the verifier. * The public key that `public_key_id` refers to does not verify the signature with respect to the payload. The `signature` contents SHOULD NOT be "attached" (where the payload is included with the serialized `signature` bytes). Verifiers MUST ignore any "attached" payload and only verify signatures with respect to explicitly provided payload (e.g. a `payload` field on the proto message that holds this Signature, or the canonical serialization of the proto message that holds this signature).
        :param str public_key_id: The identifier for the public key that verifies this signature. * The `public_key_id` is required. * The `public_key_id` SHOULD be an RFC3986 conformant URI. * When possible, the `public_key_id` SHOULD be an immutable reference, such as a cryptographic digest. Examples of valid `public_key_id`s: OpenPGP V4 public key fingerprint: * "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA" See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more details on this scheme. RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER serialization): * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU" * "nih:///sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a1271589a5"
        :param str signature: The content of the signature, an opaque bytestring. The payload that this signature verifies MUST be unambiguously provided with the Signature during verification. A wrapper message might provide the payload explicitly. Alternatively, a message might have a canonical serialization that can always be unambiguously computed to derive the payload.
        """
        pulumi.set(__self__, "public_key_id", public_key_id)
        pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="publicKeyId")
    def public_key_id(self) -> str:
        """
        The identifier for the public key that verifies this signature. * The `public_key_id` is required. * The `public_key_id` SHOULD be an RFC3986 conformant URI. * When possible, the `public_key_id` SHOULD be an immutable reference, such as a cryptographic digest. Examples of valid `public_key_id`s: OpenPGP V4 public key fingerprint: * "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA" See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more details on this scheme. RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER serialization): * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU" * "nih:///sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a1271589a5"
        """
        return pulumi.get(self, "public_key_id")

    @property
    @pulumi.getter
    def signature(self) -> str:
        """
        The content of the signature, an opaque bytestring. The payload that this signature verifies MUST be unambiguously provided with the Signature during verification. A wrapper message might provide the payload explicitly. Alternatively, a message might have a canonical serialization that can always be unambiguously computed to derive the payload.
        """
        return pulumi.get(self, "signature")


@pulumi.output_type
class SlsaBuilderResponse(dict):
    def __init__(__self__):
        pass


@pulumi.output_type
class SlsaCompletenessResponse(dict):
    """
    Indicates that the builder claims certain fields in this message to be complete.
    """
    def __init__(__self__, *,
                 arguments: bool,
                 environment: bool,
                 materials: bool):
        """
        Indicates that the builder claims certain fields in this message to be complete.
        :param bool arguments: If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        :param bool environment: If true, the builder claims that recipe.environment is claimed to be complete.
        :param bool materials: If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "materials", materials)

    @property
    @pulumi.getter
    def arguments(self) -> bool:
        """
        If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter
    def environment(self) -> bool:
        """
        If true, the builder claims that recipe.environment is claimed to be complete.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def materials(self) -> bool:
        """
        If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        return pulumi.get(self, "materials")


@pulumi.output_type
class SlsaMetadataResponse(dict):
    """
    Other properties of the build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildFinishedOn":
            suggest = "build_finished_on"
        elif key == "buildInvocationId":
            suggest = "build_invocation_id"
        elif key == "buildStartedOn":
            suggest = "build_started_on"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SlsaMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SlsaMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SlsaMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 build_finished_on: str,
                 build_invocation_id: str,
                 build_started_on: str,
                 completeness: 'outputs.SlsaCompletenessResponse',
                 reproducible: bool):
        """
        Other properties of the build.
        :param str build_finished_on: The timestamp of when the build completed.
        :param str build_invocation_id: Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        :param str build_started_on: The timestamp of when the build started.
        :param 'SlsaCompletenessResponse' completeness: Indicates that the builder claims certain fields in this message to be complete.
        :param bool reproducible: If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        pulumi.set(__self__, "build_finished_on", build_finished_on)
        pulumi.set(__self__, "build_invocation_id", build_invocation_id)
        pulumi.set(__self__, "build_started_on", build_started_on)
        pulumi.set(__self__, "completeness", completeness)
        pulumi.set(__self__, "reproducible", reproducible)

    @property
    @pulumi.getter(name="buildFinishedOn")
    def build_finished_on(self) -> str:
        """
        The timestamp of when the build completed.
        """
        return pulumi.get(self, "build_finished_on")

    @property
    @pulumi.getter(name="buildInvocationId")
    def build_invocation_id(self) -> str:
        """
        Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        """
        return pulumi.get(self, "build_invocation_id")

    @property
    @pulumi.getter(name="buildStartedOn")
    def build_started_on(self) -> str:
        """
        The timestamp of when the build started.
        """
        return pulumi.get(self, "build_started_on")

    @property
    @pulumi.getter
    def completeness(self) -> 'outputs.SlsaCompletenessResponse':
        """
        Indicates that the builder claims certain fields in this message to be complete.
        """
        return pulumi.get(self, "completeness")

    @property
    @pulumi.getter
    def reproducible(self) -> bool:
        """
        If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        return pulumi.get(self, "reproducible")


@pulumi.output_type
class SlsaProvenanceResponse(dict):
    def __init__(__self__, *,
                 builder: 'outputs.SlsaBuilderResponse',
                 materials: Sequence['outputs.MaterialResponse'],
                 metadata: 'outputs.SlsaMetadataResponse',
                 recipe: 'outputs.SlsaRecipeResponse'):
        """
        :param 'SlsaBuilderResponse' builder: required
        :param Sequence['MaterialResponse'] materials: The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        :param 'SlsaRecipeResponse' recipe: Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible). required
        """
        pulumi.set(__self__, "builder", builder)
        pulumi.set(__self__, "materials", materials)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "recipe", recipe)

    @property
    @pulumi.getter
    def builder(self) -> 'outputs.SlsaBuilderResponse':
        """
        required
        """
        return pulumi.get(self, "builder")

    @property
    @pulumi.getter
    def materials(self) -> Sequence['outputs.MaterialResponse']:
        """
        The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        """
        return pulumi.get(self, "materials")

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.SlsaMetadataResponse':
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def recipe(self) -> 'outputs.SlsaRecipeResponse':
        """
        Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible). required
        """
        return pulumi.get(self, "recipe")


@pulumi.output_type
class SlsaRecipeResponse(dict):
    """
    Steps taken to build the artifact. For a TaskRun, typically each container corresponds to one step in the recipe.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "definedInMaterial":
            suggest = "defined_in_material"
        elif key == "entryPoint":
            suggest = "entry_point"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SlsaRecipeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SlsaRecipeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SlsaRecipeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 arguments: Mapping[str, str],
                 defined_in_material: str,
                 entry_point: str,
                 environment: Mapping[str, str],
                 type: str):
        """
        Steps taken to build the artifact. For a TaskRun, typically each container corresponds to one step in the recipe.
        :param Mapping[str, str] arguments: Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint. Depending on the recipe Type, the structure may be different.
        :param str defined_in_material: Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        :param str entry_point: String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        :param Mapping[str, str] environment: Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy. Depending on the recipe Type, the structure may be different.
        :param str type: URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        pulumi.set(__self__, "arguments", arguments)
        pulumi.set(__self__, "defined_in_material", defined_in_material)
        pulumi.set(__self__, "entry_point", entry_point)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arguments(self) -> Mapping[str, str]:
        """
        Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint. Depending on the recipe Type, the structure may be different.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="definedInMaterial")
    def defined_in_material(self) -> str:
        """
        Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        """
        return pulumi.get(self, "defined_in_material")

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> str:
        """
        String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        """
        return pulumi.get(self, "entry_point")

    @property
    @pulumi.getter
    def environment(self) -> Mapping[str, str]:
        """
        Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy. Depending on the recipe Type, the structure may be different.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SourceContextResponse(dict):
    """
    A SourceContext is a reference to a tree of files. A SourceContext together with a path point to a unique revision of a single file or directory.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudRepo":
            suggest = "cloud_repo"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceContextResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceContextResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceContextResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_repo: 'outputs.CloudRepoSourceContextResponse',
                 gerrit: 'outputs.GerritSourceContextResponse',
                 git: 'outputs.GitSourceContextResponse',
                 labels: Mapping[str, str]):
        """
        A SourceContext is a reference to a tree of files. A SourceContext together with a path point to a unique revision of a single file or directory.
        :param 'CloudRepoSourceContextResponse' cloud_repo: A SourceContext referring to a revision in a Google Cloud Source Repo.
        :param 'GerritSourceContextResponse' gerrit: A SourceContext referring to a Gerrit project.
        :param 'GitSourceContextResponse' git: A SourceContext referring to any third party Git repo (e.g., GitHub).
        :param Mapping[str, str] labels: Labels with user defined metadata.
        """
        pulumi.set(__self__, "cloud_repo", cloud_repo)
        pulumi.set(__self__, "gerrit", gerrit)
        pulumi.set(__self__, "git", git)
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter(name="cloudRepo")
    def cloud_repo(self) -> 'outputs.CloudRepoSourceContextResponse':
        """
        A SourceContext referring to a revision in a Google Cloud Source Repo.
        """
        return pulumi.get(self, "cloud_repo")

    @property
    @pulumi.getter
    def gerrit(self) -> 'outputs.GerritSourceContextResponse':
        """
        A SourceContext referring to a Gerrit project.
        """
        return pulumi.get(self, "gerrit")

    @property
    @pulumi.getter
    def git(self) -> 'outputs.GitSourceContextResponse':
        """
        A SourceContext referring to any third party Git repo (e.g., GitHub).
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Labels with user defined metadata.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class SourceResponse(dict):
    """
    Source describes the location of the source used for the build.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalContexts":
            suggest = "additional_contexts"
        elif key == "artifactStorageSourceUri":
            suggest = "artifact_storage_source_uri"
        elif key == "fileHashes":
            suggest = "file_hashes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_contexts: Sequence['outputs.SourceContextResponse'],
                 artifact_storage_source_uri: str,
                 context: 'outputs.SourceContextResponse',
                 file_hashes: Mapping[str, str]):
        """
        Source describes the location of the source used for the build.
        :param Sequence['SourceContextResponse'] additional_contexts: If provided, some of the source code used for the build may be found in these locations, in the case where the source repository had multiple remotes or submodules. This list will not include the context specified in the context field.
        :param str artifact_storage_source_uri: If provided, the input binary artifacts for the build came from this location.
        :param 'SourceContextResponse' context: If provided, the source code used for the build came from this location.
        :param Mapping[str, str] file_hashes: Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (.tar.gz), the FileHash will be for the single path to that file.
        """
        pulumi.set(__self__, "additional_contexts", additional_contexts)
        pulumi.set(__self__, "artifact_storage_source_uri", artifact_storage_source_uri)
        pulumi.set(__self__, "context", context)
        pulumi.set(__self__, "file_hashes", file_hashes)

    @property
    @pulumi.getter(name="additionalContexts")
    def additional_contexts(self) -> Sequence['outputs.SourceContextResponse']:
        """
        If provided, some of the source code used for the build may be found in these locations, in the case where the source repository had multiple remotes or submodules. This list will not include the context specified in the context field.
        """
        return pulumi.get(self, "additional_contexts")

    @property
    @pulumi.getter(name="artifactStorageSourceUri")
    def artifact_storage_source_uri(self) -> str:
        """
        If provided, the input binary artifacts for the build came from this location.
        """
        return pulumi.get(self, "artifact_storage_source_uri")

    @property
    @pulumi.getter
    def context(self) -> 'outputs.SourceContextResponse':
        """
        If provided, the source code used for the build came from this location.
        """
        return pulumi.get(self, "context")

    @property
    @pulumi.getter(name="fileHashes")
    def file_hashes(self) -> Mapping[str, str]:
        """
        Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (.tar.gz), the FileHash will be for the single path to that file.
        """
        return pulumi.get(self, "file_hashes")


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class SubjectResponse(dict):
    def __init__(__self__, *,
                 digest: Mapping[str, str],
                 name: str):
        """
        :param Mapping[str, str] digest: `"": ""` Algorithms can be e.g. sha256, sha512 See https://github.com/in-toto/attestation/blob/main/spec/field_types.md#DigestSet
        """
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def digest(self) -> Mapping[str, str]:
        """
        `"": ""` Algorithms can be e.g. sha256, sha512 See https://github.com/in-toto/attestation/blob/main/spec/field_types.md#DigestSet
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")


@pulumi.output_type
class UpgradeDistributionResponse(dict):
    """
    The Upgrade Distribution represents metadata about the Upgrade for each operating system (CPE). Some distributions have additional metadata around updates, classifying them into various categories and severities.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradeDistributionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradeDistributionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradeDistributionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 classification: str,
                 cpe_uri: str,
                 cve: Sequence[str],
                 severity: str):
        """
        The Upgrade Distribution represents metadata about the Upgrade for each operating system (CPE). Some distributions have additional metadata around updates, classifying them into various categories and severities.
        :param str classification: The operating system classification of this Upgrade, as specified by the upstream operating system upgrade feed. For Windows the classification is one of the category_ids listed at https://docs.microsoft.com/en-us/previous-versions/windows/desktop/ff357803(v=vs.85)
        :param str cpe_uri: Required - The specific operating system this metadata applies to. See https://cpe.mitre.org/specification/.
        :param Sequence[str] cve: The cve tied to this Upgrade.
        :param str severity: The severity as specified by the upstream operating system.
        """
        pulumi.set(__self__, "classification", classification)
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "cve", cve)
        pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def classification(self) -> str:
        """
        The operating system classification of this Upgrade, as specified by the upstream operating system upgrade feed. For Windows the classification is one of the category_ids listed at https://docs.microsoft.com/en-us/previous-versions/windows/desktop/ff357803(v=vs.85)
        """
        return pulumi.get(self, "classification")

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        Required - The specific operating system this metadata applies to. See https://cpe.mitre.org/specification/.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def cve(self) -> Sequence[str]:
        """
        The cve tied to this Upgrade.
        """
        return pulumi.get(self, "cve")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The severity as specified by the upstream operating system.
        """
        return pulumi.get(self, "severity")


@pulumi.output_type
class UpgradeNoteResponse(dict):
    """
    An Upgrade Note represents a potential upgrade of a package to a given version. For each package version combination (i.e. bash 4.0, bash 4.1, bash 4.1.2), there will be an Upgrade Note. For Windows, windows_update field represents the information related to the update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "windowsUpdate":
            suggest = "windows_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradeNoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradeNoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradeNoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distributions: Sequence['outputs.UpgradeDistributionResponse'],
                 package: str,
                 version: 'outputs.VersionResponse',
                 windows_update: 'outputs.WindowsUpdateResponse'):
        """
        An Upgrade Note represents a potential upgrade of a package to a given version. For each package version combination (i.e. bash 4.0, bash 4.1, bash 4.1.2), there will be an Upgrade Note. For Windows, windows_update field represents the information related to the update.
        :param Sequence['UpgradeDistributionResponse'] distributions: Metadata about the upgrade for each specific operating system.
        :param str package: Required for non-Windows OS. The package this Upgrade is for.
        :param 'VersionResponse' version: Required for non-Windows OS. The version of the package in machine + human readable form.
        :param 'WindowsUpdateResponse' windows_update: Required for Windows OS. Represents the metadata about the Windows update.
        """
        pulumi.set(__self__, "distributions", distributions)
        pulumi.set(__self__, "package", package)
        pulumi.set(__self__, "version", version)
        pulumi.set(__self__, "windows_update", windows_update)

    @property
    @pulumi.getter
    def distributions(self) -> Sequence['outputs.UpgradeDistributionResponse']:
        """
        Metadata about the upgrade for each specific operating system.
        """
        return pulumi.get(self, "distributions")

    @property
    @pulumi.getter
    def package(self) -> str:
        """
        Required for non-Windows OS. The package this Upgrade is for.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter
    def version(self) -> 'outputs.VersionResponse':
        """
        Required for non-Windows OS. The version of the package in machine + human readable form.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="windowsUpdate")
    def windows_update(self) -> 'outputs.WindowsUpdateResponse':
        """
        Required for Windows OS. Represents the metadata about the Windows update.
        """
        return pulumi.get(self, "windows_update")


@pulumi.output_type
class UpgradeOccurrenceResponse(dict):
    """
    An Upgrade Occurrence represents that a specific resource_url could install a specific upgrade. This presence is supplied via local sources (i.e. it is present in the mirror and the running system has noticed its availability). For Windows, both distribution and windows_update contain information for the Windows update.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parsedVersion":
            suggest = "parsed_version"
        elif key == "windowsUpdate":
            suggest = "windows_update"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UpgradeOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UpgradeOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UpgradeOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 distribution: 'outputs.UpgradeDistributionResponse',
                 package: str,
                 parsed_version: 'outputs.VersionResponse',
                 windows_update: 'outputs.WindowsUpdateResponse'):
        """
        An Upgrade Occurrence represents that a specific resource_url could install a specific upgrade. This presence is supplied via local sources (i.e. it is present in the mirror and the running system has noticed its availability). For Windows, both distribution and windows_update contain information for the Windows update.
        :param 'UpgradeDistributionResponse' distribution: Metadata about the upgrade for available for the specific operating system for the resource_url. This allows efficient filtering, as well as making it easier to use the occurrence.
        :param str package: Required for non-Windows OS. The package this Upgrade is for.
        :param 'VersionResponse' parsed_version: Required for non-Windows OS. The version of the package in a machine + human readable form.
        :param 'WindowsUpdateResponse' windows_update: Required for Windows OS. Represents the metadata about the Windows update.
        """
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "package", package)
        pulumi.set(__self__, "parsed_version", parsed_version)
        pulumi.set(__self__, "windows_update", windows_update)

    @property
    @pulumi.getter
    def distribution(self) -> 'outputs.UpgradeDistributionResponse':
        """
        Metadata about the upgrade for available for the specific operating system for the resource_url. This allows efficient filtering, as well as making it easier to use the occurrence.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter
    def package(self) -> str:
        """
        Required for non-Windows OS. The package this Upgrade is for.
        """
        return pulumi.get(self, "package")

    @property
    @pulumi.getter(name="parsedVersion")
    def parsed_version(self) -> 'outputs.VersionResponse':
        """
        Required for non-Windows OS. The version of the package in a machine + human readable form.
        """
        return pulumi.get(self, "parsed_version")

    @property
    @pulumi.getter(name="windowsUpdate")
    def windows_update(self) -> 'outputs.WindowsUpdateResponse':
        """
        Required for Windows OS. Represents the metadata about the Windows update.
        """
        return pulumi.get(self, "windows_update")


@pulumi.output_type
class VersionResponse(dict):
    """
    Version contains structured information about the version of a package.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fullName":
            suggest = "full_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VersionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VersionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VersionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 epoch: int,
                 full_name: str,
                 inclusive: bool,
                 kind: str,
                 name: str,
                 revision: str):
        """
        Version contains structured information about the version of a package.
        :param int epoch: Used to correct mistakes in the version numbering scheme.
        :param str full_name: Human readable version string. This string is of the form :- and is only set when kind is NORMAL.
        :param bool inclusive: Whether this version is specifying part of an inclusive range. Grafeas does not have the capability to specify version ranges; instead we have fields that specify start version and end versions. At times this is insufficient - we also need to specify whether the version is included in the range or is excluded from the range. This boolean is expected to be set to true when the version is included in a range.
        :param str kind: Distinguishes between sentinel MIN/MAX versions and normal versions.
        :param str name: Required only when version kind is NORMAL. The main part of the version name.
        :param str revision: The iteration of the package build from the above version.
        """
        pulumi.set(__self__, "epoch", epoch)
        pulumi.set(__self__, "full_name", full_name)
        pulumi.set(__self__, "inclusive", inclusive)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def epoch(self) -> int:
        """
        Used to correct mistakes in the version numbering scheme.
        """
        return pulumi.get(self, "epoch")

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> str:
        """
        Human readable version string. This string is of the form :- and is only set when kind is NORMAL.
        """
        return pulumi.get(self, "full_name")

    @property
    @pulumi.getter
    def inclusive(self) -> bool:
        """
        Whether this version is specifying part of an inclusive range. Grafeas does not have the capability to specify version ranges; instead we have fields that specify start version and end versions. At times this is insufficient - we also need to specify whether the version is included in the range or is excluded from the range. This boolean is expected to be set to true when the version is included in a range.
        """
        return pulumi.get(self, "inclusive")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Distinguishes between sentinel MIN/MAX versions and normal versions.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required only when version kind is NORMAL. The main part of the version name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def revision(self) -> str:
        """
        The iteration of the package build from the above version.
        """
        return pulumi.get(self, "revision")


@pulumi.output_type
class VulnerabilityNoteResponse(dict):
    """
    A security vulnerability that can be found in resources.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cvssScore":
            suggest = "cvss_score"
        elif key == "cvssV3":
            suggest = "cvss_v3"
        elif key == "sourceUpdateTime":
            suggest = "source_update_time"
        elif key == "windowsDetails":
            suggest = "windows_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityNoteResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityNoteResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityNoteResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cvss_score: float,
                 cvss_v3: 'outputs.CVSSv3Response',
                 details: Sequence['outputs.DetailResponse'],
                 severity: str,
                 source_update_time: str,
                 windows_details: Sequence['outputs.WindowsDetailResponse']):
        """
        A security vulnerability that can be found in resources.
        :param float cvss_score: The CVSS score of this vulnerability. CVSS score is on a scale of 0 - 10 where 0 indicates low severity and 10 indicates high severity.
        :param 'CVSSv3Response' cvss_v3: The full description of the CVSSv3 for this vulnerability.
        :param Sequence['DetailResponse'] details: Details of all known distros and packages affected by this vulnerability.
        :param str severity: The note provider assigned severity of this vulnerability.
        :param str source_update_time: The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        :param Sequence['WindowsDetailResponse'] windows_details: Windows details get their own format because the information format and model don't match a normal detail. Specifically Windows updates are done as patches, thus Windows vulnerabilities really are a missing package, rather than a package being at an incorrect version.
        """
        pulumi.set(__self__, "cvss_score", cvss_score)
        pulumi.set(__self__, "cvss_v3", cvss_v3)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "source_update_time", source_update_time)
        pulumi.set(__self__, "windows_details", windows_details)

    @property
    @pulumi.getter(name="cvssScore")
    def cvss_score(self) -> float:
        """
        The CVSS score of this vulnerability. CVSS score is on a scale of 0 - 10 where 0 indicates low severity and 10 indicates high severity.
        """
        return pulumi.get(self, "cvss_score")

    @property
    @pulumi.getter(name="cvssV3")
    def cvss_v3(self) -> 'outputs.CVSSv3Response':
        """
        The full description of the CVSSv3 for this vulnerability.
        """
        return pulumi.get(self, "cvss_v3")

    @property
    @pulumi.getter
    def details(self) -> Sequence['outputs.DetailResponse']:
        """
        Details of all known distros and packages affected by this vulnerability.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The note provider assigned severity of this vulnerability.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="sourceUpdateTime")
    def source_update_time(self) -> str:
        """
        The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        """
        return pulumi.get(self, "source_update_time")

    @property
    @pulumi.getter(name="windowsDetails")
    def windows_details(self) -> Sequence['outputs.WindowsDetailResponse']:
        """
        Windows details get their own format because the information format and model don't match a normal detail. Specifically Windows updates are done as patches, thus Windows vulnerabilities really are a missing package, rather than a package being at an incorrect version.
        """
        return pulumi.get(self, "windows_details")


@pulumi.output_type
class VulnerabilityOccurrenceResponse(dict):
    """
    An occurrence of a severity vulnerability on a resource.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cvssScore":
            suggest = "cvss_score"
        elif key == "effectiveSeverity":
            suggest = "effective_severity"
        elif key == "fixAvailable":
            suggest = "fix_available"
        elif key == "longDescription":
            suggest = "long_description"
        elif key == "packageIssue":
            suggest = "package_issue"
        elif key == "relatedUrls":
            suggest = "related_urls"
        elif key == "shortDescription":
            suggest = "short_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VulnerabilityOccurrenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VulnerabilityOccurrenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VulnerabilityOccurrenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cvss_score: float,
                 cvssv3: 'outputs.CVSSResponse',
                 effective_severity: str,
                 fix_available: bool,
                 long_description: str,
                 package_issue: Sequence['outputs.PackageIssueResponse'],
                 related_urls: Sequence['outputs.RelatedUrlResponse'],
                 severity: str,
                 short_description: str,
                 type: str):
        """
        An occurrence of a severity vulnerability on a resource.
        :param float cvss_score: The CVSS score of this vulnerability. CVSS score is on a scale of 0 - 10 where 0 indicates low severity and 10 indicates high severity.
        :param 'CVSSResponse' cvssv3: The cvss v3 score for the vulnerability.
        :param str effective_severity: The distro assigned severity for this vulnerability when it is available, otherwise this is the note provider assigned severity. When there are multiple PackageIssues for this vulnerability, they can have different effective severities because some might be provided by the distro while others are provided by the language ecosystem for a language pack. For this reason, it is advised to use the effective severity on the PackageIssue level. In the case where multiple PackageIssues have differing effective severities, this field should be the highest severity for any of the PackageIssues.
        :param bool fix_available: Whether at least one of the affected packages has a fix available.
        :param str long_description: A detailed description of this vulnerability.
        :param Sequence['PackageIssueResponse'] package_issue: The set of affected locations and their fixes (if available) within the associated resource.
        :param Sequence['RelatedUrlResponse'] related_urls: URLs related to this vulnerability.
        :param str severity: The note provider assigned severity of this vulnerability.
        :param str short_description: A one sentence description of this vulnerability.
        :param str type: The type of package; whether native or non native (e.g., ruby gems, node.js packages, etc.).
        """
        pulumi.set(__self__, "cvss_score", cvss_score)
        pulumi.set(__self__, "cvssv3", cvssv3)
        pulumi.set(__self__, "effective_severity", effective_severity)
        pulumi.set(__self__, "fix_available", fix_available)
        pulumi.set(__self__, "long_description", long_description)
        pulumi.set(__self__, "package_issue", package_issue)
        pulumi.set(__self__, "related_urls", related_urls)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "short_description", short_description)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cvssScore")
    def cvss_score(self) -> float:
        """
        The CVSS score of this vulnerability. CVSS score is on a scale of 0 - 10 where 0 indicates low severity and 10 indicates high severity.
        """
        return pulumi.get(self, "cvss_score")

    @property
    @pulumi.getter
    def cvssv3(self) -> 'outputs.CVSSResponse':
        """
        The cvss v3 score for the vulnerability.
        """
        return pulumi.get(self, "cvssv3")

    @property
    @pulumi.getter(name="effectiveSeverity")
    def effective_severity(self) -> str:
        """
        The distro assigned severity for this vulnerability when it is available, otherwise this is the note provider assigned severity. When there are multiple PackageIssues for this vulnerability, they can have different effective severities because some might be provided by the distro while others are provided by the language ecosystem for a language pack. For this reason, it is advised to use the effective severity on the PackageIssue level. In the case where multiple PackageIssues have differing effective severities, this field should be the highest severity for any of the PackageIssues.
        """
        return pulumi.get(self, "effective_severity")

    @property
    @pulumi.getter(name="fixAvailable")
    def fix_available(self) -> bool:
        """
        Whether at least one of the affected packages has a fix available.
        """
        return pulumi.get(self, "fix_available")

    @property
    @pulumi.getter(name="longDescription")
    def long_description(self) -> str:
        """
        A detailed description of this vulnerability.
        """
        return pulumi.get(self, "long_description")

    @property
    @pulumi.getter(name="packageIssue")
    def package_issue(self) -> Sequence['outputs.PackageIssueResponse']:
        """
        The set of affected locations and their fixes (if available) within the associated resource.
        """
        return pulumi.get(self, "package_issue")

    @property
    @pulumi.getter(name="relatedUrls")
    def related_urls(self) -> Sequence['outputs.RelatedUrlResponse']:
        """
        URLs related to this vulnerability.
        """
        return pulumi.get(self, "related_urls")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        The note provider assigned severity of this vulnerability.
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter(name="shortDescription")
    def short_description(self) -> str:
        """
        A one sentence description of this vulnerability.
        """
        return pulumi.get(self, "short_description")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of package; whether native or non native (e.g., ruby gems, node.js packages, etc.).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WindowsDetailResponse(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpeUri":
            suggest = "cpe_uri"
        elif key == "fixingKbs":
            suggest = "fixing_kbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsDetailResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsDetailResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsDetailResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpe_uri: str,
                 description: str,
                 fixing_kbs: Sequence['outputs.KnowledgeBaseResponse'],
                 name: str):
        """
        :param str cpe_uri: The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability affects.
        :param str description: The description of this vulnerability.
        :param Sequence['KnowledgeBaseResponse'] fixing_kbs: The names of the KBs which have hotfixes to mitigate this vulnerability. Note that there may be multiple hotfixes (and thus multiple KBs) that mitigate a given vulnerability. Currently any listed KBs presence is considered a fix.
        :param str name: The name of this vulnerability.
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "fixing_kbs", fixing_kbs)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> str:
        """
        The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability affects.
        """
        return pulumi.get(self, "cpe_uri")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of this vulnerability.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="fixingKbs")
    def fixing_kbs(self) -> Sequence['outputs.KnowledgeBaseResponse']:
        """
        The names of the KBs which have hotfixes to mitigate this vulnerability. Note that there may be multiple hotfixes (and thus multiple KBs) that mitigate a given vulnerability. Currently any listed KBs presence is considered a fix.
        """
        return pulumi.get(self, "fixing_kbs")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of this vulnerability.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class WindowsUpdateResponse(dict):
    """
    Windows Update represents the metadata about the update for the Windows operating system. The fields in this message come from the Windows Update API documented at https://docs.microsoft.com/en-us/windows/win32/api/wuapi/nn-wuapi-iupdate.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kbArticleIds":
            suggest = "kb_article_ids"
        elif key == "lastPublishedTimestamp":
            suggest = "last_published_timestamp"
        elif key == "supportUrl":
            suggest = "support_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsUpdateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsUpdateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsUpdateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 categories: Sequence['outputs.CategoryResponse'],
                 description: str,
                 identity: 'outputs.IdentityResponse',
                 kb_article_ids: Sequence[str],
                 last_published_timestamp: str,
                 support_url: str,
                 title: str):
        """
        Windows Update represents the metadata about the update for the Windows operating system. The fields in this message come from the Windows Update API documented at https://docs.microsoft.com/en-us/windows/win32/api/wuapi/nn-wuapi-iupdate.
        :param Sequence['CategoryResponse'] categories: The list of categories to which the update belongs.
        :param str description: The localized description of the update.
        :param 'IdentityResponse' identity: Required - The unique identifier for the update.
        :param Sequence[str] kb_article_ids: The Microsoft Knowledge Base article IDs that are associated with the update.
        :param str last_published_timestamp: The last published timestamp of the update.
        :param str support_url: The hyperlink to the support information for the update.
        :param str title: The localized title of the update.
        """
        pulumi.set(__self__, "categories", categories)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "kb_article_ids", kb_article_ids)
        pulumi.set(__self__, "last_published_timestamp", last_published_timestamp)
        pulumi.set(__self__, "support_url", support_url)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def categories(self) -> Sequence['outputs.CategoryResponse']:
        """
        The list of categories to which the update belongs.
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The localized description of the update.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def identity(self) -> 'outputs.IdentityResponse':
        """
        Required - The unique identifier for the update.
        """
        return pulumi.get(self, "identity")

    @property
    @pulumi.getter(name="kbArticleIds")
    def kb_article_ids(self) -> Sequence[str]:
        """
        The Microsoft Knowledge Base article IDs that are associated with the update.
        """
        return pulumi.get(self, "kb_article_ids")

    @property
    @pulumi.getter(name="lastPublishedTimestamp")
    def last_published_timestamp(self) -> str:
        """
        The last published timestamp of the update.
        """
        return pulumi.get(self, "last_published_timestamp")

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> str:
        """
        The hyperlink to the support information for the update.
        """
        return pulumi.get(self, "support_url")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        The localized title of the update.
        """
        return pulumi.get(self, "title")


