# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetSearchApplicationResult',
    'AwaitableGetSearchApplicationResult',
    'get_search_application',
    'get_search_application_output',
]

@pulumi.output_type
class GetSearchApplicationResult:
    def __init__(__self__, data_source_restrictions=None, default_facet_options=None, default_sort_options=None, display_name=None, enable_audit_log=None, name=None, operation_ids=None, query_interpretation_config=None, return_result_thumbnail_urls=None, scoring_config=None, source_config=None):
        if data_source_restrictions and not isinstance(data_source_restrictions, list):
            raise TypeError("Expected argument 'data_source_restrictions' to be a list")
        pulumi.set(__self__, "data_source_restrictions", data_source_restrictions)
        if default_facet_options and not isinstance(default_facet_options, list):
            raise TypeError("Expected argument 'default_facet_options' to be a list")
        pulumi.set(__self__, "default_facet_options", default_facet_options)
        if default_sort_options and not isinstance(default_sort_options, dict):
            raise TypeError("Expected argument 'default_sort_options' to be a dict")
        pulumi.set(__self__, "default_sort_options", default_sort_options)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if enable_audit_log and not isinstance(enable_audit_log, bool):
            raise TypeError("Expected argument 'enable_audit_log' to be a bool")
        pulumi.set(__self__, "enable_audit_log", enable_audit_log)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if operation_ids and not isinstance(operation_ids, list):
            raise TypeError("Expected argument 'operation_ids' to be a list")
        pulumi.set(__self__, "operation_ids", operation_ids)
        if query_interpretation_config and not isinstance(query_interpretation_config, dict):
            raise TypeError("Expected argument 'query_interpretation_config' to be a dict")
        pulumi.set(__self__, "query_interpretation_config", query_interpretation_config)
        if return_result_thumbnail_urls and not isinstance(return_result_thumbnail_urls, bool):
            raise TypeError("Expected argument 'return_result_thumbnail_urls' to be a bool")
        pulumi.set(__self__, "return_result_thumbnail_urls", return_result_thumbnail_urls)
        if scoring_config and not isinstance(scoring_config, dict):
            raise TypeError("Expected argument 'scoring_config' to be a dict")
        pulumi.set(__self__, "scoring_config", scoring_config)
        if source_config and not isinstance(source_config, list):
            raise TypeError("Expected argument 'source_config' to be a list")
        pulumi.set(__self__, "source_config", source_config)

    @property
    @pulumi.getter(name="dataSourceRestrictions")
    def data_source_restrictions(self) -> Sequence['outputs.DataSourceRestrictionResponse']:
        """
        Retrictions applied to the configurations. The maximum number of elements is 10.
        """
        return pulumi.get(self, "data_source_restrictions")

    @property
    @pulumi.getter(name="defaultFacetOptions")
    def default_facet_options(self) -> Sequence['outputs.FacetOptionsResponse']:
        """
        The default fields for returning facet results. The sources specified here also have been included in data_source_restrictions above.
        """
        return pulumi.get(self, "default_facet_options")

    @property
    @pulumi.getter(name="defaultSortOptions")
    def default_sort_options(self) -> 'outputs.SortOptionsResponse':
        """
        The default options for sorting the search results
        """
        return pulumi.get(self, "default_sort_options")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name of the Search Application. The maximum length is 300 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enableAuditLog")
    def enable_audit_log(self) -> bool:
        """
        Indicates whether audit logging is on/off for requests made for the search application in query APIs.
        """
        return pulumi.get(self, "enable_audit_log")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the Search Application. Format: searchapplications/{application_id}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operationIds")
    def operation_ids(self) -> Sequence[str]:
        """
        IDs of the Long Running Operations (LROs) currently running for this schema. Output only field.
        """
        return pulumi.get(self, "operation_ids")

    @property
    @pulumi.getter(name="queryInterpretationConfig")
    def query_interpretation_config(self) -> 'outputs.QueryInterpretationConfigResponse':
        """
        The default options for query interpretation
        """
        return pulumi.get(self, "query_interpretation_config")

    @property
    @pulumi.getter(name="returnResultThumbnailUrls")
    def return_result_thumbnail_urls(self) -> bool:
        """
        With each result we should return the URI for its thumbnail (when applicable)
        """
        return pulumi.get(self, "return_result_thumbnail_urls")

    @property
    @pulumi.getter(name="scoringConfig")
    def scoring_config(self) -> 'outputs.ScoringConfigResponse':
        """
        Configuration for ranking results.
        """
        return pulumi.get(self, "scoring_config")

    @property
    @pulumi.getter(name="sourceConfig")
    def source_config(self) -> Sequence['outputs.SourceConfigResponse']:
        """
        Configuration for a sources specified in data_source_restrictions.
        """
        return pulumi.get(self, "source_config")


class AwaitableGetSearchApplicationResult(GetSearchApplicationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSearchApplicationResult(
            data_source_restrictions=self.data_source_restrictions,
            default_facet_options=self.default_facet_options,
            default_sort_options=self.default_sort_options,
            display_name=self.display_name,
            enable_audit_log=self.enable_audit_log,
            name=self.name,
            operation_ids=self.operation_ids,
            query_interpretation_config=self.query_interpretation_config,
            return_result_thumbnail_urls=self.return_result_thumbnail_urls,
            scoring_config=self.scoring_config,
            source_config=self.source_config)


def get_search_application(debug_options_enable_debugging: Optional[str] = None,
                           searchapplication_id: Optional[str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSearchApplicationResult:
    """
    Gets the specified search application. **Note:** This API requires an admin account to execute.
    """
    __args__ = dict()
    __args__['debugOptionsEnableDebugging'] = debug_options_enable_debugging
    __args__['searchapplicationId'] = searchapplication_id
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:cloudsearch/v1:getSearchApplication', __args__, opts=opts, typ=GetSearchApplicationResult).value

    return AwaitableGetSearchApplicationResult(
        data_source_restrictions=__ret__.data_source_restrictions,
        default_facet_options=__ret__.default_facet_options,
        default_sort_options=__ret__.default_sort_options,
        display_name=__ret__.display_name,
        enable_audit_log=__ret__.enable_audit_log,
        name=__ret__.name,
        operation_ids=__ret__.operation_ids,
        query_interpretation_config=__ret__.query_interpretation_config,
        return_result_thumbnail_urls=__ret__.return_result_thumbnail_urls,
        scoring_config=__ret__.scoring_config,
        source_config=__ret__.source_config)


@_utilities.lift_output_func(get_search_application)
def get_search_application_output(debug_options_enable_debugging: Optional[pulumi.Input[Optional[str]]] = None,
                                  searchapplication_id: Optional[pulumi.Input[str]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSearchApplicationResult]:
    """
    Gets the specified search application. **Note:** This API requires an admin account to execute.
    """
    ...
