# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetCertificateMapEntryResult',
    'AwaitableGetCertificateMapEntryResult',
    'get_certificate_map_entry',
    'get_certificate_map_entry_output',
]

@pulumi.output_type
class GetCertificateMapEntryResult:
    def __init__(__self__, certificates=None, create_time=None, description=None, hostname=None, labels=None, matcher=None, name=None, state=None, update_time=None):
        if certificates and not isinstance(certificates, list):
            raise TypeError("Expected argument 'certificates' to be a list")
        pulumi.set(__self__, "certificates", certificates)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if hostname and not isinstance(hostname, str):
            raise TypeError("Expected argument 'hostname' to be a str")
        pulumi.set(__self__, "hostname", hostname)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if matcher and not isinstance(matcher, str):
            raise TypeError("Expected argument 'matcher' to be a str")
        pulumi.set(__self__, "matcher", matcher)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def certificates(self) -> Sequence[str]:
        """
        A set of Certificates defines for the given `hostname`. There can be defined up to fifteen certificates in each Certificate Map Entry. Each certificate must match pattern `projects/*/locations/*/certificates/*`.
        """
        return pulumi.get(self, "certificates")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation timestamp of a Certificate Map Entry.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        One or more paragraphs of text description of a certificate map entry.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        A Hostname (FQDN, e.g. `example.com`) or a wildcard hostname expression (`*.example.com`) for a set of hostnames with common suffix. Used as Server Name Indication (SNI) for selecting a proper certificate.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Set of labels associated with a Certificate Map Entry.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def matcher(self) -> str:
        """
        A predefined matcher for particular cases, other than SNI selection.
        """
        return pulumi.get(self, "matcher")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A user-defined name of the Certificate Map Entry. Certificate Map Entry names must be unique globally and match pattern `projects/*/locations/*/certificateMaps/*/certificateMapEntries/*`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A serving state of this Certificate Map Entry.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The update timestamp of a Certificate Map Entry.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetCertificateMapEntryResult(GetCertificateMapEntryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCertificateMapEntryResult(
            certificates=self.certificates,
            create_time=self.create_time,
            description=self.description,
            hostname=self.hostname,
            labels=self.labels,
            matcher=self.matcher,
            name=self.name,
            state=self.state,
            update_time=self.update_time)


def get_certificate_map_entry(certificate_map_entry_id: Optional[str] = None,
                              certificate_map_id: Optional[str] = None,
                              location: Optional[str] = None,
                              project: Optional[str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCertificateMapEntryResult:
    """
    Gets details of a single CertificateMapEntry.
    """
    __args__ = dict()
    __args__['certificateMapEntryId'] = certificate_map_entry_id
    __args__['certificateMapId'] = certificate_map_id
    __args__['location'] = location
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:certificatemanager/v1:getCertificateMapEntry', __args__, opts=opts, typ=GetCertificateMapEntryResult).value

    return AwaitableGetCertificateMapEntryResult(
        certificates=__ret__.certificates,
        create_time=__ret__.create_time,
        description=__ret__.description,
        hostname=__ret__.hostname,
        labels=__ret__.labels,
        matcher=__ret__.matcher,
        name=__ret__.name,
        state=__ret__.state,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_certificate_map_entry)
def get_certificate_map_entry_output(certificate_map_entry_id: Optional[pulumi.Input[str]] = None,
                                     certificate_map_id: Optional[pulumi.Input[str]] = None,
                                     location: Optional[pulumi.Input[str]] = None,
                                     project: Optional[pulumi.Input[Optional[str]]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCertificateMapEntryResult]:
    """
    Gets details of a single CertificateMapEntry.
    """
    ...
