# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'AutoscalingLimitsResponse',
    'AutoscalingTargetsResponse',
    'BackupInfoResponse',
    'BindingResponse',
    'ClusterAutoscalingConfigResponse',
    'ClusterConfigResponse',
    'EncryptionConfigResponse',
    'EncryptionInfoResponse',
    'ExprResponse',
    'MultiClusterRoutingUseAnyResponse',
    'RestoreInfoResponse',
    'SingleClusterRoutingResponse',
    'StatusResponse',
]

@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class AutoscalingLimitsResponse(dict):
    """
    Limits for the number of nodes a Cluster can autoscale up/down to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxServeNodes":
            suggest = "max_serve_nodes"
        elif key == "minServeNodes":
            suggest = "min_serve_nodes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscalingLimitsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscalingLimitsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscalingLimitsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_serve_nodes: int,
                 min_serve_nodes: int):
        """
        Limits for the number of nodes a Cluster can autoscale up/down to.
        :param int max_serve_nodes: Maximum number of nodes to scale up to.
        :param int min_serve_nodes: Minimum number of nodes to scale down to.
        """
        pulumi.set(__self__, "max_serve_nodes", max_serve_nodes)
        pulumi.set(__self__, "min_serve_nodes", min_serve_nodes)

    @property
    @pulumi.getter(name="maxServeNodes")
    def max_serve_nodes(self) -> int:
        """
        Maximum number of nodes to scale up to.
        """
        return pulumi.get(self, "max_serve_nodes")

    @property
    @pulumi.getter(name="minServeNodes")
    def min_serve_nodes(self) -> int:
        """
        Minimum number of nodes to scale down to.
        """
        return pulumi.get(self, "min_serve_nodes")


@pulumi.output_type
class AutoscalingTargetsResponse(dict):
    """
    The Autoscaling targets for a Cluster. These determine the recommended nodes.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuUtilizationPercent":
            suggest = "cpu_utilization_percent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscalingTargetsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscalingTargetsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscalingTargetsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_utilization_percent: int):
        """
        The Autoscaling targets for a Cluster. These determine the recommended nodes.
        :param int cpu_utilization_percent: The cpu utilization that the Autoscaler should be trying to achieve. This number is on a scale from 0 (no utilization) to 100 (total utilization), and is limited between 10 and 80, otherwise it will return INVALID_ARGUMENT error.
        """
        pulumi.set(__self__, "cpu_utilization_percent", cpu_utilization_percent)

    @property
    @pulumi.getter(name="cpuUtilizationPercent")
    def cpu_utilization_percent(self) -> int:
        """
        The cpu utilization that the Autoscaler should be trying to achieve. This number is on a scale from 0 (no utilization) to 100 (total utilization), and is limited between 10 and 80, otherwise it will return INVALID_ARGUMENT error.
        """
        return pulumi.get(self, "cpu_utilization_percent")


@pulumi.output_type
class BackupInfoResponse(dict):
    """
    Information about a backup.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "sourceTable":
            suggest = "source_table"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BackupInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BackupInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BackupInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup: str,
                 end_time: str,
                 source_table: str,
                 start_time: str):
        """
        Information about a backup.
        :param str backup: Name of the backup.
        :param str end_time: This time that the backup was finished. Row data in the backup will be no newer than this timestamp.
        :param str source_table: Name of the table the backup was created from.
        :param str start_time: The time that the backup was started. Row data in the backup will be no older than this timestamp.
        """
        pulumi.set(__self__, "backup", backup)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "source_table", source_table)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter
    def backup(self) -> str:
        """
        Name of the backup.
        """
        return pulumi.get(self, "backup")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        This time that the backup was finished. Row data in the backup will be no newer than this timestamp.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="sourceTable")
    def source_table(self) -> str:
        """
        Name of the table the backup was created from.
        """
        return pulumi.get(self, "source_table")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The time that the backup was started. Row data in the backup will be no older than this timestamp.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ClusterAutoscalingConfigResponse(dict):
    """
    Autoscaling config for a cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalingLimits":
            suggest = "autoscaling_limits"
        elif key == "autoscalingTargets":
            suggest = "autoscaling_targets"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterAutoscalingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterAutoscalingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterAutoscalingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling_limits: 'outputs.AutoscalingLimitsResponse',
                 autoscaling_targets: 'outputs.AutoscalingTargetsResponse'):
        """
        Autoscaling config for a cluster.
        :param 'AutoscalingLimitsResponse' autoscaling_limits: Autoscaling limits for this cluster.
        :param 'AutoscalingTargetsResponse' autoscaling_targets: Autoscaling targets for this cluster.
        """
        pulumi.set(__self__, "autoscaling_limits", autoscaling_limits)
        pulumi.set(__self__, "autoscaling_targets", autoscaling_targets)

    @property
    @pulumi.getter(name="autoscalingLimits")
    def autoscaling_limits(self) -> 'outputs.AutoscalingLimitsResponse':
        """
        Autoscaling limits for this cluster.
        """
        return pulumi.get(self, "autoscaling_limits")

    @property
    @pulumi.getter(name="autoscalingTargets")
    def autoscaling_targets(self) -> 'outputs.AutoscalingTargetsResponse':
        """
        Autoscaling targets for this cluster.
        """
        return pulumi.get(self, "autoscaling_targets")


@pulumi.output_type
class ClusterConfigResponse(dict):
    """
    Configuration for a cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterAutoscalingConfig":
            suggest = "cluster_autoscaling_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_autoscaling_config: 'outputs.ClusterAutoscalingConfigResponse'):
        """
        Configuration for a cluster.
        :param 'ClusterAutoscalingConfigResponse' cluster_autoscaling_config: Autoscaling configuration for this cluster.
        """
        pulumi.set(__self__, "cluster_autoscaling_config", cluster_autoscaling_config)

    @property
    @pulumi.getter(name="clusterAutoscalingConfig")
    def cluster_autoscaling_config(self) -> 'outputs.ClusterAutoscalingConfigResponse':
        """
        Autoscaling configuration for this cluster.
        """
        return pulumi.get(self, "cluster_autoscaling_config")


@pulumi.output_type
class EncryptionConfigResponse(dict):
    """
    Cloud Key Management Service (Cloud KMS) settings for a CMEK-protected cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyName":
            suggest = "kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_name: str):
        """
        Cloud Key Management Service (Cloud KMS) settings for a CMEK-protected cluster.
        :param str kms_key_name: Describes the Cloud KMS encryption key that will be used to protect the destination Bigtable cluster. The requirements for this key are: 1) The Cloud Bigtable service account associated with the project that contains this cluster must be granted the `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key. 2) Only regional keys can be used and the region of the CMEK key must match the region of the cluster. 3) All clusters within an instance must use the same CMEK key. Values are of the form `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}`
        """
        pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> str:
        """
        Describes the Cloud KMS encryption key that will be used to protect the destination Bigtable cluster. The requirements for this key are: 1) The Cloud Bigtable service account associated with the project that contains this cluster must be granted the `cloudkms.cryptoKeyEncrypterDecrypter` role on the CMEK key. 2) Only regional keys can be used and the region of the CMEK key must match the region of the cluster. 3) All clusters within an instance must use the same CMEK key. Values are of the form `projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}`
        """
        return pulumi.get(self, "kms_key_name")


@pulumi.output_type
class EncryptionInfoResponse(dict):
    """
    Encryption information for a given resource. If this resource is protected with customer managed encryption, the in-use Cloud Key Management Service (Cloud KMS) key version is specified along with its status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "encryptionStatus":
            suggest = "encryption_status"
        elif key == "encryptionType":
            suggest = "encryption_type"
        elif key == "kmsKeyVersion":
            suggest = "kms_key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 encryption_status: 'outputs.StatusResponse',
                 encryption_type: str,
                 kms_key_version: str):
        """
        Encryption information for a given resource. If this resource is protected with customer managed encryption, the in-use Cloud Key Management Service (Cloud KMS) key version is specified along with its status.
        :param 'StatusResponse' encryption_status: The status of encrypt/decrypt calls on underlying data for this resource. Regardless of status, the existing data is always encrypted at rest.
        :param str encryption_type: The type of encryption used to protect this resource.
        :param str kms_key_version: The version of the Cloud KMS key specified in the parent cluster that is in use for the data underlying this table.
        """
        pulumi.set(__self__, "encryption_status", encryption_status)
        pulumi.set(__self__, "encryption_type", encryption_type)
        pulumi.set(__self__, "kms_key_version", kms_key_version)

    @property
    @pulumi.getter(name="encryptionStatus")
    def encryption_status(self) -> 'outputs.StatusResponse':
        """
        The status of encrypt/decrypt calls on underlying data for this resource. Regardless of status, the existing data is always encrypted at rest.
        """
        return pulumi.get(self, "encryption_status")

    @property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> str:
        """
        The type of encryption used to protect this resource.
        """
        return pulumi.get(self, "encryption_type")

    @property
    @pulumi.getter(name="kmsKeyVersion")
    def kms_key_version(self) -> str:
        """
        The version of the Cloud KMS key specified in the parent cluster that is in use for the data underlying this table.
        """
        return pulumi.get(self, "kms_key_version")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class MultiClusterRoutingUseAnyResponse(dict):
    """
    Read/write requests are routed to the nearest cluster in the instance, and will fail over to the nearest cluster that is available in the event of transient errors or delays. Clusters in a region are considered equidistant. Choosing this option sacrifices read-your-writes consistency to improve availability.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterIds":
            suggest = "cluster_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MultiClusterRoutingUseAnyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MultiClusterRoutingUseAnyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MultiClusterRoutingUseAnyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_ids: Sequence[str]):
        """
        Read/write requests are routed to the nearest cluster in the instance, and will fail over to the nearest cluster that is available in the event of transient errors or delays. Clusters in a region are considered equidistant. Choosing this option sacrifices read-your-writes consistency to improve availability.
        :param Sequence[str] cluster_ids: The set of clusters to route to. The order is ignored; clusters will be tried in order of distance. If left empty, all clusters are eligible.
        """
        pulumi.set(__self__, "cluster_ids", cluster_ids)

    @property
    @pulumi.getter(name="clusterIds")
    def cluster_ids(self) -> Sequence[str]:
        """
        The set of clusters to route to. The order is ignored; clusters will be tried in order of distance. If left empty, all clusters are eligible.
        """
        return pulumi.get(self, "cluster_ids")


@pulumi.output_type
class RestoreInfoResponse(dict):
    """
    Information about a table restore.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupInfo":
            suggest = "backup_info"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RestoreInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RestoreInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RestoreInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_info: 'outputs.BackupInfoResponse',
                 source_type: str):
        """
        Information about a table restore.
        :param 'BackupInfoResponse' backup_info: Information about the backup used to restore the table. The backup may no longer exist.
        :param str source_type: The type of the restore source.
        """
        pulumi.set(__self__, "backup_info", backup_info)
        pulumi.set(__self__, "source_type", source_type)

    @property
    @pulumi.getter(name="backupInfo")
    def backup_info(self) -> 'outputs.BackupInfoResponse':
        """
        Information about the backup used to restore the table. The backup may no longer exist.
        """
        return pulumi.get(self, "backup_info")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The type of the restore source.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class SingleClusterRoutingResponse(dict):
    """
    Unconditionally routes all read/write requests to a specific cluster. This option preserves read-your-writes consistency but does not improve availability.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowTransactionalWrites":
            suggest = "allow_transactional_writes"
        elif key == "clusterId":
            suggest = "cluster_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SingleClusterRoutingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SingleClusterRoutingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SingleClusterRoutingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_transactional_writes: bool,
                 cluster_id: str):
        """
        Unconditionally routes all read/write requests to a specific cluster. This option preserves read-your-writes consistency but does not improve availability.
        :param bool allow_transactional_writes: Whether or not `CheckAndMutateRow` and `ReadModifyWriteRow` requests are allowed by this app profile. It is unsafe to send these requests to the same table/row/column in multiple clusters.
        :param str cluster_id: The cluster to which read/write requests should be routed.
        """
        pulumi.set(__self__, "allow_transactional_writes", allow_transactional_writes)
        pulumi.set(__self__, "cluster_id", cluster_id)

    @property
    @pulumi.getter(name="allowTransactionalWrites")
    def allow_transactional_writes(self) -> bool:
        """
        Whether or not `CheckAndMutateRow` and `ReadModifyWriteRow` requests are allowed by this app profile. It is unsafe to send these requests to the same table/row/column in multiple clusters.
        """
        return pulumi.get(self, "allow_transactional_writes")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The cluster to which read/write requests should be routed.
        """
        return pulumi.get(self, "cluster_id")


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


