# boaviztapi-sdk
# 🎯 Retrieving the impacts of digital elements
This is a quick demo, to see full documentation [click here](https://doc.api.boavizta.org) 
## ➡️Server router 
### Server routers support the following impacts: 
| Impact | 🔨 Manufacture | 🔌 Usage |
|--------|----------------|----------|
|   GWP  |        X       |     X    |
|   ADP  |        X       |     X    |
|   PE   |        X       |     X    |
## ➡️Cloud router 
### Cloud routers support the following impacts: 
| Impact | 🔨 Manufacture | 🔌 Usage |
|--------|----------------|----------|
|   GWP  |        X       |     X    |
|   ADP  |        X       |     X    |
|   PE   |        X       |     X    |
## ➡️Component router 
### Component routers support the following impacts: 
| Impact | 🔨 Manufacture | 🔌 Usage |
|--------|----------------|----------|
|   GWP  |        X       |          |
|   ADP  |        X       |          |
|   PE   |        X       |          |


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.1
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python >=3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import boaviztapi-sdk
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import boaviztapi-sdk
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import boaviztapi-sdk
from pprint import pprint
from boaviztapi-sdk.api import cloud_api
from boaviztapi-sdk.model.http_validation_error import HTTPValidationError
from boaviztapi-sdk.model.usage_cloud import UsageCloud
# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = boaviztapi-sdk.Configuration(
    host = "http://localhost"
)



# Enter a context with an instance of the API client
with boaviztapi-sdk.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = cloud_api.CloudApi(api_client)
    instance_type = "a1.4xlarge" # str |  (optional)
    verbose = True # bool |  (optional) (default to True)
    usage_cloud = UsageCloud(
        hash="hash_example",
        type="USAGE",
        years_use_time=3.14,
        days_use_time=3.14,
        hours_use_time=3.14,
        hours_electrical_consumption=3.14,
        usage_location="usage_location_example",
        gwp_factor=3.14,
        pe_factor=3.14,
        adp_factor=3.14,
        max_power=3.14,
        workload={
            "key": {
                "key": 3.14,
            },
        },
        instance_per_server=3.14,
    ) # UsageCloud |  (optional)

    try:
        # Instance Cloud Impact
        api_response = api_instance.instance_cloud_impact_v1_cloud_aws_post(instance_type=instance_type, verbose=verbose, usage_cloud=usage_cloud)
        pprint(api_response)
    except boaviztapi-sdk.ApiException as e:
        print("Exception when calling CloudApi->instance_cloud_impact_v1_cloud_aws_post: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CloudApi* | [**instance_cloud_impact_v1_cloud_aws_post**](docs/CloudApi.md#instance_cloud_impact_v1_cloud_aws_post) | **POST** /v1/cloud/aws | Instance Cloud Impact
*CloudApi* | [**server_get_all_archetype_name_v1_cloud_aws_all_instances_get**](docs/CloudApi.md#server_get_all_archetype_name_v1_cloud_aws_all_instances_get) | **GET** /v1/cloud/aws/all_instances | Server Get All Archetype Name
*ComponentApi* | [**case_impact_bottom_up_v1_component_case_post**](docs/ComponentApi.md#case_impact_bottom_up_v1_component_case_post) | **POST** /v1/component/case | Case Impact Bottom Up
*ComponentApi* | [**cpu_impact_bottom_up_v1_component_cpu_post**](docs/ComponentApi.md#cpu_impact_bottom_up_v1_component_cpu_post) | **POST** /v1/component/cpu | Cpu Impact Bottom Up
*ComponentApi* | [**disk_impact_bottom_up_v1_component_hdd_post**](docs/ComponentApi.md#disk_impact_bottom_up_v1_component_hdd_post) | **POST** /v1/component/hdd | Disk Impact Bottom Up
*ComponentApi* | [**disk_impact_bottom_up_v1_component_ssd_post**](docs/ComponentApi.md#disk_impact_bottom_up_v1_component_ssd_post) | **POST** /v1/component/ssd | Disk Impact Bottom Up
*ComponentApi* | [**motherboard_impact_bottom_up_v1_component_motherboard_post**](docs/ComponentApi.md#motherboard_impact_bottom_up_v1_component_motherboard_post) | **POST** /v1/component/motherboard | Motherboard Impact Bottom Up
*ComponentApi* | [**power_supply_impact_bottom_up_v1_component_power_supply_post**](docs/ComponentApi.md#power_supply_impact_bottom_up_v1_component_power_supply_post) | **POST** /v1/component/power_supply | Power Supply Impact Bottom Up
*ComponentApi* | [**ram_impact_bottom_up_v1_component_ram_post**](docs/ComponentApi.md#ram_impact_bottom_up_v1_component_ram_post) | **POST** /v1/component/ram | Ram Impact Bottom Up
*ServerApi* | [**server_get_all_archetype_name_v1_server_all_default_models_get**](docs/ServerApi.md#server_get_all_archetype_name_v1_server_all_default_models_get) | **GET** /v1/server/all_default_models | Server Get All Archetype Name
*ServerApi* | [**server_impact_by_config_v1_server_post**](docs/ServerApi.md#server_impact_by_config_v1_server_post) | **POST** /v1/server/ | Server Impact By Config
*ServerApi* | [**server_impact_by_model_v1_server_model_get**](docs/ServerApi.md#server_impact_by_model_v1_server_model_get) | **GET** /v1/server/model | Server Impact By Model


## Documentation For Models

 - [Case](docs/Case.md)
 - [ConfigurationServer](docs/ConfigurationServer.md)
 - [Cpu](docs/Cpu.md)
 - [Disk](docs/Disk.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [LocationInner](docs/LocationInner.md)
 - [ModelServer](docs/ModelServer.md)
 - [MotherBoard](docs/MotherBoard.md)
 - [PowerSupply](docs/PowerSupply.md)
 - [Ram](docs/Ram.md)
 - [ServerDTO](docs/ServerDTO.md)
 - [UsageCloud](docs/UsageCloud.md)
 - [UsageServer](docs/UsageServer.md)
 - [ValidationError](docs/ValidationError.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in boaviztapi-sdk.apis and boaviztapi-sdk.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from boaviztapi-sdk.api.default_api import DefaultApi`
- `from boaviztapi-sdk.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import boaviztapi-sdk
from boaviztapi-sdk.apis import *
from boaviztapi-sdk.models import *
```

