"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PgStacDatabase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const bootstrapper_1 = require("../bootstrapper");
/**
 * An RDS instance with pgSTAC installed. This is a wrapper around the
 * `rds.DatabaseInstance` higher-level construct making use
 * of the BootstrapPgStac construct.
 */
class PgStacDatabase extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const parameterGroup = new aws_cdk_lib_1.aws_rds.ParameterGroup(this, "parameterGroup", {
            engine: props.engine,
            parameters: {
                max_locks_per_transaction: "1024",
                work_mem: "64000",
                temp_buffers: "32000",
            },
        });
        this.db = new aws_cdk_lib_1.aws_rds.DatabaseInstance(this, "db", {
            instanceIdentifier: aws_cdk_lib_1.Stack.of(this).stackName,
            parameterGroup,
            ...props,
        });
        const bootstrap = new bootstrapper_1.BootstrapPgStac(this, "bootstrap-pgstac-instance", {
            vpc: props.vpc,
            database: this.db,
            dbSecret: this.db.secret,
            pgstacDbName: props.pgstacDbName,
            pgstacVersion: props.pgstacVersion,
            pgstacUsername: props.pgstacUsername,
            secretsPrefix: props.secretsPrefix,
        });
        this.pgstacSecret = bootstrap.secret;
    }
}
exports.PgStacDatabase = PgStacDatabase;
_a = JSII_RTTI_SYMBOL_1;
PgStacDatabase[_a] = { fqn: "cdk-pgstac.PgStacDatabase", version: "2.1.0" };
//# sourceMappingURL=data:application/json;base64,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