import * as lambda from '@aws-cdk/aws-lambda';
import { Construct } from '@aws-cdk/core';
/**
 * @stability stable
 */
export interface AfterCreateProps {
    /**
     * Resources to trigger on.
     *
     * Resources can come from any stack in the app.
     *
     * @default [] Run the trigger at any time during stack deployment.
     * @stability stable
     */
    readonly resources?: Construct[];
    /**
     * The handler to execute once after all the resources are created.
     *
     * @stability stable
     */
    readonly handler: lambda.IFunction;
}
/**
 * @stability stable
 */
export declare class AfterCreate extends Construct {
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: AfterCreateProps);
}
