(self["webpackChunkmitosheet3"] = self["webpackChunkmitosheet3"] || []).push([["lib_plugin_js"],{

/***/ "./lib/api.js":
/*!********************!*\
  !*** ./lib/api.js ***!
  \********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MitoAPI": () => (/* binding */ MitoAPI)
/* harmony export */ });
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.
/*
  Contains a wrapper around a strongly typed object that simulates a web-api.
*/
// Max delay is the longest we'll wait for the API to return a value
const MAX_DELAY = 5000;
// How often we poll to see if we have a response yet
const RETRY_DELAY = 250;
const MAX_RETRIES = MAX_DELAY / RETRY_DELAY;
const getRandomId = () => {
    return '_' + Math.random().toString(36).substr(2, 9);
};
/*
  The MitoAPI class contains functions for interacting with the Mito backend. All
  interactions with the backend should go through this call, so that if we ever move
  to a more standard API, the migration is protected by this interface!
*/
class MitoAPI {
    constructor(send) {
        this.send = send;
        this.unconsumedResponses = [];
    }
    /*
        The receive response function is a workaround to the fact that we _do not_ have
        a real API in practice. If/when we do have a real API, we'll get rid of this function,
        and allow the API to just make a call to a server, and wait on a response
    */
    receiveResponse(response) {
        this.unconsumedResponses.push(response);
    }
    /*
        Helper function that tries to get the response for a given ID, and returns
        the data inside the 'data' key in this response if it exists.

        Returns undefined if it does not get a response within the set timeframe
        for retries.
    */
    getResponseData(id, maxRetries = MAX_RETRIES) {
        return new Promise((resolve) => {
            let tries = 0;
            const interval = setInterval(() => {
                // Only try at most MAX_RETRIES times
                tries++;
                if (tries > maxRetries) {
                    console.log('Giving up on waiting');
                    clearInterval(interval);
                    // If we fail, we return an empty response
                    return resolve(undefined);
                }
                // See if there is an API response to this one specificially
                const index = this.unconsumedResponses.findIndex((response) => {
                    return response['id'] === id;
                });
                if (index !== -1) {
                    // Clear the interval
                    clearInterval(interval);
                    const response = this.unconsumedResponses[index];
                    this.unconsumedResponses.splice(index, 1);
                    return resolve(response['data']); // return to end execution
                }
                else {
                    console.log("Still waiting");
                }
            }, RETRY_DELAY);
        });
    }
    /*
        Returns all the CSV files in the current folder as the kernel.
    */
    async getDataFiles() {
        const id = getRandomId();
        this.send({
            'event': 'api_call',
            'type': 'datafiles',
            'id': id
        });
        const dataFiles = await this.getResponseData(id);
        if (dataFiles == undefined) {
            return [];
        }
        return dataFiles;
    }
    /*
        Returns a string encoding of the CSV file to download
    */
    async getDataframeAsCSV(sheetIndex) {
        const id = getRandomId();
        this.send({
            'event': 'api_call',
            'type': 'get_dataframe_as_csv',
            'id': id,
            'sheet_index': sheetIndex
        });
        // Note: We increase MAX_RETRIES to 250 although 100 worked locally for a dataset with 10M
        // rows and 4 columns, because the server is slower. 
        const sheetData = await this.getResponseData(id, 250);
        if (sheetData == undefined) {
            return '';
        }
        return sheetData;
    }
    /*
        Returns a string encoding of a PNG that can be displayed that
        is a summary graph of the specific column header at a specific
        sheet index
    */
    async getColumnSummaryGraph(sheetIndex, columnHeader) {
        const id = getRandomId();
        this.send({
            'event': 'api_call',
            'type': 'get_column_summary_graph',
            'id': id,
            'sheet_index': sheetIndex,
            'column_header': columnHeader
        });
        const summaryGraph = await this.getResponseData(id);
        if (summaryGraph == undefined) {
            return '';
        }
        return summaryGraph;
    }
    /*
        Returns a string of the dtype of a column
    */
    async getColumnDtype(sheetIndex, columnHeader) {
        const id = getRandomId();
        this.send({
            'event': 'api_call',
            'type': 'get_column_dtype',
            'id': id,
            'sheet_index': sheetIndex,
            'column_header': columnHeader
        });
        const dtype = await this.getResponseData(id);
        if (dtype == undefined) {
            return '';
        }
        return dtype;
    }
    /*
        Returns a list of the key, values that is returned by .describing
        this column
    */
    async getColumnDescribe(sheetIndex, columnHeader) {
        const id = getRandomId();
        this.send({
            'event': 'api_call',
            'type': 'get_column_describe',
            'id': id,
            'sheet_index': sheetIndex,
            'column_header': columnHeader
        });
        const describeString = await this.getResponseData(id, 100);
        if (describeString == undefined) {
            return {};
        }
        try {
            return JSON.parse(describeString);
        }
        catch (_a) {
            // We return nothing if we fail, as this is not a critical operation
            return {};
        }
    }
    /*
        Import summaries are a mapping from step_idx -> import information for each of the
        import steps in the analysis with the given analysisName.
    */
    async getImportSummary(analysisName) {
        const id = getRandomId();
        this.send({
            'event': 'api_call',
            'type': 'import_summary',
            'id': id,
            'analysis_name': analysisName
        });
        const importSumary = await this.getResponseData(id);
        if (importSumary == undefined) {
            return {};
        }
        return importSumary;
    }
    /*
        Adds a column with the passed parameters
    */
    async sendColumnAddMessage(sheetIndex, columnHeader, stepID) {
        if (stepID === undefined || stepID == '') {
            stepID = getRandomId();
        }
        this.send({
            'event': 'edit_event',
            'type': 'add_column_edit',
            'step_id': stepID,
            'sheet_index': sheetIndex,
            'column_header': columnHeader
        });
        return stepID;
    }
    /*
        Adds a delete column message with the passed parameters
    */
    async sendDeleteColumn(sheetIndex, columnHeader) {
        const stepID = getRandomId();
        this.send({
            'event': 'edit_event',
            'type': 'delete_column_edit',
            'step_id': stepID,
            'sheet_index': sheetIndex,
            'column_header': columnHeader
        });
    }
    /*
        Does a merge with the passed parameters, returning the ID of the edit
        event that was generated (in case you want to overwrite it).
    */
    async sendMergeMessage(sheetOneIndex, sheetOneMergeKey, sheetOneSelectedColumns, sheetTwoIndex, sheetTwoMergeKey, sheetTwoSelectedColumns, 
    /*
        If you want to overwrite, you have to pass the ID of the the step that
        you want to overwrite. Not passing this argument, or passing an empty string,
        will result in no overwrite occuring (and a new stepID) being returned.
    */
    stepID) {
        // If this is overwriting a merge event, then we do not need to
        // create a new id, as we already have it!
        if (stepID === undefined || stepID == '') {
            stepID = getRandomId();
        }
        this.send({
            event: 'edit_event',
            type: 'merge_edit',
            step_id: stepID,
            sheet_index_one: sheetOneIndex,
            merge_key_one: sheetOneMergeKey,
            selected_columns_one: sheetOneSelectedColumns,
            sheet_index_two: sheetTwoIndex,
            merge_key_two: sheetTwoMergeKey,
            selected_columns_two: sheetTwoSelectedColumns,
        });
        return stepID;
    }
    /*
        Does a pivot with the passed parameters, returning the ID of the edit
        event that was generated (in case you want to overwrite it).
    */
    async sendPivotMessage(sheetIndex, pivotRows, pivotCols, values, stepID) {
        // If this is overwriting a pivot event, then we do not need to
        // create a new id, as we already have it!
        if (stepID === undefined || stepID === '') {
            stepID = getRandomId();
        }
        this.send({
            event: 'edit_event',
            type: 'pivot_edit',
            step_id: stepID,
            sheet_index: sheetIndex,
            pivot_rows: pivotRows,
            pivot_columns: pivotCols,
            values: values,
        });
        return stepID;
    }
    /*
        Reorders the columnHeader on sheetIndex to the newIndex, and shifts the remaining
        columns to the right.
    */
    async sendReorderColumnMessage(sheetIndex, columnHeader, newIndex) {
        const stepID = getRandomId();
        this.send({
            'event': 'edit_event',
            'type': 'reorder_column_edit',
            'step_id': stepID,
            'sheet_index': sheetIndex,
            'column_header': columnHeader,
            'new_column_index': newIndex
        });
    }
    /*
        Renames the dataframe at sheetIndex.
    */
    async sendDataframeRenameEdit(sheetIndex, newDataframeName, stepID) {
        // If this is overwriting a pivot event, then we do not need to
        // create a new id, as we already have it!
        if (stepID === undefined || stepID === '') {
            stepID = getRandomId();
        }
        this.send({
            'event': 'edit_event',
            'type': 'dataframe_rename_edit',
            'step_id': stepID,
            'sheet_index': sheetIndex,
            'new_dataframe_name': newDataframeName
        });
        return stepID;
    }
    /*
        Does a filter with the passed parameters, returning the ID of the edit
        event that was generated (in case you want to overwrite it).
    */
    async sendFilterMessage(sheetIndex, columnHeader, filters, operator, stepID) {
        // create a new id, if we need it!
        if (stepID === undefined || stepID === '') {
            stepID = getRandomId();
        }
        this.send({
            event: 'edit_event',
            type: 'filter_column_edit',
            step_id: stepID,
            sheet_index: sheetIndex,
            column_header: columnHeader,
            operator: operator,
            filters: filters,
        });
        return stepID;
    }
    /*
        Does a sort with the passed parameters, returning the ID of the edit
        event that was generated (in case you want to overwrite it).
    */
    async sendSortMessage(sheetIndex, columnHeader, sortDirection, stepID) {
        if (stepID === undefined || stepID === '') {
            stepID = getRandomId();
        }
        this.send({
            event: 'edit_event',
            type: 'sort_edit',
            step_id: stepID,
            sheet_index: sheetIndex,
            column_header: columnHeader,
            sort_direction: sortDirection,
        });
        return stepID;
    }
    /*
        Renames a column with the passed parameters
    */
    async sendRenameColumn(sheetIndex, oldColumnHeader, newColumnHeader, stepID) {
        if (stepID === undefined || stepID === '') {
            stepID = getRandomId();
        }
        this.send({
            event: 'edit_event',
            type: 'rename_column_edit',
            step_id: stepID,
            sheet_index: sheetIndex,
            old_column_header: oldColumnHeader,
            new_column_header: newColumnHeader,
        });
        return stepID;
    }
    /*
        Duplicates the dataframe at sheetIndex.
    */
    async sendDataframeDuplicateMessage(sheetIndex) {
        const stepID = getRandomId();
        this.send({
            'event': 'edit_event',
            'type': 'dataframe_duplicate_edit',
            'step_id': stepID,
            'sheet_index': sheetIndex,
        });
    }
    /*
        Deletes the dataframe at the passed sheetIndex
    */
    async sendDataframeDeleteMessage(sheetIndex) {
        const stepID = getRandomId();
        this.send({
            'event': 'edit_event',
            'type': 'dataframe_delete_edit',
            'step_id': stepID,
            'sheet_index': sheetIndex,
        });
    }
    /*
        Sends an undo message, which removes the last step that was created.
    */
    async sendUndoMessage() {
        this.send({
            'event': 'update_event',
            'type': 'undo'
        });
    }
    /*
        Sends a message which saves the current analysis with the passed
        analysisName.
    */
    async sendSaveAnalysisMessage(analysisName) {
        this.send({
            'event': 'update_event',
            'type': 'save_analysis_update',
            'analysis_name': analysisName
        });
    }
    /*
        Sends a message to tell Mito to replay an existing analysis onto
        the current analysis.
    */
    async sendUseExistingAnalysisUpdateMessage(analysisName, newFileNames, clearExistingAnalysis) {
        this.send({
            'event': 'update_event',
            'type': 'replay_analysis_update',
            'analysis_name': analysisName,
            'import_summaries': newFileNames === undefined ? {} : newFileNames,
            'clear_existing_analysis': clearExistingAnalysis === undefined ? false : clearExistingAnalysis
        });
    }
    /*
        Sends a message to tell Mito to delete a saved analysis.
    */
    async sendDeleteSavedAnalysisMessage(analysisName) {
        this.send({
            'event': 'update_event',
            'type': 'delete_analysis_update',
            'analysis_name': analysisName,
        });
    }
    /*
        Sends a message to tell Mito to rename a saved analysis.
    */
    async sendRenameSavedAnalysisMessage(old_analysis_name, new_analysis_name) {
        this.send({
            'event': 'update_event',
            'type': 'rename_analysis_update',
            'old_analysis_name': old_analysis_name,
            'new_analysis_name': new_analysis_name,
        });
    }
    /*
     Sends a message to get the description of a saved analysis
    */
    async getSavedAnalysisDescription(analysisName) {
        const id = getRandomId();
        this.send({
            'event': 'api_call',
            'type': 'get_saved_analysis_description',
            'id': id,
            'analysis_name': analysisName
        });
        const savedAnalysisDescription = await this.getResponseData(id);
        if (savedAnalysisDescription === undefined || savedAnalysisDescription === '') {
            return [];
        }
        return JSON.parse(savedAnalysisDescription);
    }
    /*
        Sets the formula for the given columns.
    */
    async sendSetColumnFormulaEditMessage(sheetIndex, columnHeader, newFormula) {
        const stepID = getRandomId();
        this.send({
            'event': 'edit_event',
            'type': 'set_column_formula_edit',
            'step_id': stepID,
            'sheet_index': sheetIndex,
            'column_header': columnHeader,
            'new_formula': newFormula
        });
    }
    /*
        Imports the given file names.
    */
    async sendSimpleImportMessage(fileNames) {
        const stepID = getRandomId();
        this.send({
            'event': 'edit_event',
            'type': 'simple_import_edit',
            'step_id': stepID,
            'file_names': fileNames,
        });
    }
    /*
        Does an import by running the pythonCode, and pulling out
        the new df names.
    */
    async sendRawPythonImportMessage(pythonCode, newDfNames) {
        const stepID = getRandomId();
        this.send({
            'event': 'edit_event',
            'type': 'raw_python_import_edit',
            'step_id': stepID,
            'python_code': pythonCode,
            'new_df_names': newDfNames,
        });
    }
    /*
        Sends the user_email to the backend so the user can sign in
    */
    async sendSignUp(userEmail) {
        this.send({
            'event': 'update_event',
            'type': 'signup_update',
            'user_email': userEmail
        });
    }
    /*
        Checks outs a specific step by index
    */
    async checkoutStepByIndex(stepIndex) {
        this.send({
            'event': 'update_event',
            'type': 'checkout_step_by_idx_update',
            'step_idx': stepIndex
        });
    }
    /*
        Sends a log event from the frontend to the backend, where it is logged
        by the backend. We log in the backend to keep a linear stream of actions
        that is making.
    */
    async sendLogMessage(logEventType, params) {
        let message = {};
        // Copy the params, so we don't accidently modify anything
        if (params !== undefined) {
            message = Object.assign({}, params);
        }
        // Get the browser information
        message['user_agent'] = window.navigator.userAgent;
        // Get browser dimensions
        message['browser_dimensions'] = {
            'inner_height': window.innerHeight,
            'inner_width': window.innerWidth,
            'outer_height': window.outerHeight,
            'outer_width': window.outerWidth
        };
        // Save the type of event, as well as what is being logged
        message['event'] = 'log_event';
        message['type'] = logEventType;
        this.send(message);
    }
}


/***/ }),

/***/ "./lib/components/ColumnHeader.js":
/*!****************************************!*\
  !*** ./lib/components/ColumnHeader.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_column_header_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../css/column-header.css */ "./css/column-header.css");
/* harmony import */ var _css_column_header_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_column_header_css__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _utils_gridStyling__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/gridStyling */ "./lib/utils/gridStyling.js");
/* harmony import */ var _icons_FilterIcons__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./icons/FilterIcons */ "./lib/components/icons/FilterIcons.js");
/* harmony import */ var _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./taskpanes/taskpanes */ "./lib/components/taskpanes/taskpanes.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.






/*
  A custom component that AG-Grid displays for the column
  header, that we extend to open the column header popup when clicked.
*/
const ColumnHeader = (props) => {
    /*
      we split each word of the header (separated by _) into its own span element, adding the _ to
      the latter half of the split. ie: first_name -> [first, _name]
      This lets us wrap the column headers without breaking words in half, which we would
      do if we just used a fix length cutoff for each row as the cutoff.

      Note: this behaves better when the header's words are <10 characters, but worse when
      the header's words are > 10 characters. The 10 number is decided by the default column width
    */
    const wordsSpans = (0,_utils_gridStyling__WEBPACK_IMPORTED_MODULE_3__.getHeaderWords)(props.displayName).map(word => {
        // give the span a random key. we don't use the word because there may be duplicates
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("span", { key: Math.random() }, word));
    });
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'column-header-cell', onClick: () => {
            props.setSelectedColumn(props.displayName);
        } },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'column-header-header-container' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { onClick: () => {
                    props.setCurrOpenTaskpane({
                        type: _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_5__.TaskpaneType.CONTROL_PANEL,
                        columnHeader: props.displayName,
                        openEditingColumnHeader: true
                    });
                }, className: "column-header-column-header mr-1" }, wordsSpans)),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'column-header-filter-container' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'column-header-filter-button', onClick: () => {
                    props.setCurrOpenTaskpane({
                        type: _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_5__.TaskpaneType.CONTROL_PANEL,
                        columnHeader: props.displayName,
                        openEditingColumnHeader: false
                    });
                } },
                props.filters.length === 0 &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_FilterIcons__WEBPACK_IMPORTED_MODULE_4__.FilterEmptyIcon, null),
                props.filters.length !== 0 &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_FilterIcons__WEBPACK_IMPORTED_MODULE_4__.FilterNonEmptyIcon, null)))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ColumnHeader);


/***/ }),

/***/ "./lib/components/DefaultModal.js":
/*!****************************************!*\
  !*** ./lib/components/DefaultModal.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_default_modal_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../css/default-modal.css */ "./css/default-modal.css");
/* harmony import */ var _css_default_modal_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_default_modal_css__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _Mito__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Mito */ "./lib/components/Mito.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// import css



/*
    DefaultModal is a higher-order component that
    takes a modal and a header, and displays it as a component.

    The modal has props
    - a header string to be shown at the top of the modal
    - a modalType to indicate the font color of the header string
    - a viewComponent, a react fragment which is the center segment of the modal.
        ie: an input field or text
    - a buttons component, react divs which have onclick functions to apply functions.
        the modal is designed to take either 1 or 2 buttons where the left button is always
        the close button.
*/
const DefaultModal = (props) => {
    const headerColor = props.modalType === _Mito__WEBPACK_IMPORTED_MODULE_3__.ModalEnum.Error ? '#ED4747' : '#343434';
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-container' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-header-text-div', style: { color: headerColor } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, props.header)),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-message" }, props.viewComponent),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-buttons" }, props.buttons))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DefaultModal);


/***/ }),

/***/ "./lib/components/ErrorModal.js":
/*!**************************************!*\
  !*** ./lib/components/ErrorModal.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _DefaultModal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./DefaultModal */ "./lib/components/DefaultModal.js");
/* harmony import */ var _Mito__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Mito */ "./lib/components/Mito.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// import css



/*
    A modal that displays error messages and gives
    users actions to recover.
*/
const ErrorModal = (props) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DefaultModal__WEBPACK_IMPORTED_MODULE_2__.default, { header: "Oops! " + props.errorJSON.header, modalType: _Mito__WEBPACK_IMPORTED_MODULE_3__.ModalEnum.Error, viewComponent: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, props.errorJSON.to_fix)), buttons: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-close-button modal-dual-button-left', onClick: () => { props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_3__.ModalEnum.None }); } }, " Close "),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-action-button modal-dual-button-right', onClick: () => {
                    window.open("mailto:aarondr77@gmail.com", '_blank');
                    props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_3__.ModalEnum.None });
                } },
                " ",
                "Contact Us")) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ErrorModal);


/***/ }),

/***/ "./lib/components/FormulaBar.js":
/*!**************************************!*\
  !*** ./lib/components/FormulaBar.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_formula_bar_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../css/formula-bar.css */ "./css/formula-bar.css");
/* harmony import */ var _css_formula_bar_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_formula_bar_css__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _css_widths_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../css/widths.css */ "./css/widths.css");
/* harmony import */ var _css_widths_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_widths_css__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// Import css


const FormulaBar = (props) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "vertical-align-content formula-bar-container" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "formula-bar" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: "fx-text" }, "Fx"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "vertical-line" }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: "formula-bar-input w-100p", onDoubleClick: props.handleFormulaBarDoubleClick }, props.formulaBarValue))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FormulaBar);


/***/ }),

/***/ "./lib/components/LoadingIndicator.js":
/*!********************************************!*\
  !*** ./lib/components/LoadingIndicator.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_loading_indicator_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../css/loading-indicator.css */ "./css/loading-indicator.css");
/* harmony import */ var _css_loading_indicator_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_loading_indicator_css__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// import css

/*
    A tiny, upper left modal that tells the user that the operation is
    loading.

    By default, does not displaying anything for the first .5 seconds it
    is rendered, so that only long running ops actually display a loading
    bar.
*/
const LoadingIndicator = () => {
    // We use a count to track the number of ...s to display.
    // 0 -> '', 1 -> '.', 2 -> '..', 3 -> '...'. Wraps % 4.
    const [indicatorState, setIndicatorState] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(-1);
    // Schedule a change to update the loading indicator, every .5 seconds
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const interval = setInterval(() => {
            setIndicatorState(indicatorState => indicatorState + 1);
        }, 500);
        return () => clearInterval(interval);
    }, []);
    // We start the indicator at -1, so that we don't display anything
    // for the first half second. This makes us only display the indicator
    // for actually long running operations.
    if (indicatorState < 0) {
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null);
    }
    const someNumberOfDots = '.'.repeat(indicatorState % 4);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'loading-indicator-container' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'loading-indicator-text' },
            "Loading",
            someNumberOfDots)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LoadingIndicator);


/***/ }),

/***/ "./lib/components/Mito.js":
/*!********************************!*\
  !*** ./lib/components/Mito.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ModalEnum": () => (/* binding */ ModalEnum),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_intercom__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-intercom */ "webpack/sharing/consume/default/react-intercom/react-intercom");
/* harmony import */ var react_intercom__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_intercom__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _utils_gridData__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/gridData */ "./lib/utils/gridData.js");
/* harmony import */ var _utils_gridStyling__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/gridStyling */ "./lib/utils/gridStyling.js");
/* harmony import */ var _MitoSheet__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./MitoSheet */ "./lib/components/MitoSheet.js");
/* harmony import */ var _tabs_SheetTabs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./tabs/SheetTabs */ "./lib/components/tabs/SheetTabs.js");
/* harmony import */ var _FormulaBar__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./FormulaBar */ "./lib/components/FormulaBar.js");
/* harmony import */ var _MitoToolbar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./MitoToolbar */ "./lib/components/MitoToolbar.js");
/* harmony import */ var _LoadingIndicator__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./LoadingIndicator */ "./lib/components/LoadingIndicator.js");
/* harmony import */ var _ErrorModal__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ErrorModal */ "./lib/components/ErrorModal.js");
/* harmony import */ var _modals_DownloadModal__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./modals/DownloadModal */ "./lib/components/modals/DownloadModal.js");
/* harmony import */ var _modals_DeleteColumnModal__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./modals/DeleteColumnModal */ "./lib/components/modals/DeleteColumnModal.js");
/* harmony import */ var _modals_SaveAnalysisModal__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./modals/SaveAnalysisModal */ "./lib/components/modals/SaveAnalysisModal.js");
/* harmony import */ var _modals_SaveAnalysisOverwriteModal__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./modals/SaveAnalysisOverwriteModal */ "./lib/components/modals/SaveAnalysisOverwriteModal.js");
/* harmony import */ var _modals_ImportModal__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./modals/ImportModal */ "./lib/components/modals/ImportModal.js");
/* harmony import */ var _css_mito_css__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../css/mito.css */ "./css/mito.css");
/* harmony import */ var _css_mito_css__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(_css_mito_css__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var _modals_ReplayImportModal__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./modals/ReplayImportModal */ "./lib/components/modals/ReplayImportModal.js");
/* harmony import */ var _taskpanes_PivotTable_PivotTaskpane__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./taskpanes/PivotTable/PivotTaskpane */ "./lib/components/taskpanes/PivotTable/PivotTaskpane.js");
/* harmony import */ var _tours_IntroductionTour__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./tours/IntroductionTour */ "./lib/components/tours/IntroductionTour.js");
/* harmony import */ var _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./taskpanes/taskpanes */ "./lib/components/taskpanes/taskpanes.js");
/* harmony import */ var _taskpanes_Merge_MergeTaskpane__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./taskpanes/Merge/MergeTaskpane */ "./lib/components/taskpanes/Merge/MergeTaskpane.js");
/* harmony import */ var _taskpanes_Documentation_DocumentationTaskpane__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./taskpanes/Documentation/DocumentationTaskpane */ "./lib/components/taskpanes/Documentation/DocumentationTaskpane.js");
/* harmony import */ var _taskpanes_ControlPanel_ControlPanelTaskpane__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./taskpanes/ControlPanel/ControlPanelTaskpane */ "./lib/components/taskpanes/ControlPanel/ControlPanelTaskpane.js");
/* harmony import */ var _modals_SignupModal__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./modals/SignupModal */ "./lib/components/modals/SignupModal.js");
/* harmony import */ var _modals_BookDemoModal__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./modals/BookDemoModal */ "./lib/components/modals/BookDemoModal.js");
/* harmony import */ var _modals_UpgradeModal__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./modals/UpgradeModal */ "./lib/components/modals/UpgradeModal.js");
/* harmony import */ var _taskpanes_Steps_StepsTaskpane__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./taskpanes/Steps/StepsTaskpane */ "./lib/components/taskpanes/Steps/StepsTaskpane.js");
/* harmony import */ var _elements_TopLeftPopup__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./elements/TopLeftPopup */ "./lib/components/elements/TopLeftPopup.js");
/* harmony import */ var _taskpanes_ReplayAnalysis_ReplayAnalysisTaskpane__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./taskpanes/ReplayAnalysis/ReplayAnalysisTaskpane */ "./lib/components/taskpanes/ReplayAnalysis/ReplayAnalysisTaskpane.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// Import intercom


// Import helpers

// Import sheet and code components





// Import modals






// Import css   














var ModalEnum;
(function (ModalEnum) {
    ModalEnum["None"] = "None";
    ModalEnum["Error"] = "Error";
    ModalEnum["RepeatAnalysis"] = "RepeatAnalysis";
    ModalEnum["Download"] = "Download";
    ModalEnum["DeleteColumn"] = "DeleteColumn";
    ModalEnum["SaveAnalysis"] = "SaveAnalysis";
    ModalEnum["SaveAnalysisOverwrite"] = "SaveAnalysisOverwrite";
    ModalEnum["Import"] = "Import";
    ModalEnum["ReplayImport"] = "ReplayImport";
    ModalEnum["SignUp"] = "SignUp";
    ModalEnum["BookDemo"] = "BookDemo";
    ModalEnum["Upgrade"] = "Upgrade";
})(ModalEnum || (ModalEnum = {}));
class Mito extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        let formulaBarValue = '';
        let selectedColumn = '';
        // Set the default values for the formula bar and selected column (if possible, aka the sheet has some data in it)
        if (this.props.sheetJSONArray.length > 0) {
            formulaBarValue = this.props.sheetJSONArray[0].data[0] === undefined
                ? '' : this.props.sheetJSONArray[0].data[0][0];
            selectedColumn = (0,_utils_gridData__WEBPACK_IMPORTED_MODULE_2__.getNewSelectedColumn)(this.props.sheetJSONArray[0].columns);
        }
        // Build the default column widths
        const defaultColumnWidthsArray = (0,_utils_gridStyling__WEBPACK_IMPORTED_MODULE_3__.getColumnWidthsArray)(this.props.sheetJSONArray).columnWidthsArray;
        /*
            If the user has not input their email, then we default the modal info to the
            email collection modal. Otherwise, if the user should update, we default to
            the upgrade modal.

            If neither of these conditons are true, then we don't default to any modal at
            all.
        */
        const defaultModalInfo = this.props.userEmail == '' ? { type: ModalEnum.SignUp } : (this.props.shouldUpgradeMitosheet ? { type: ModalEnum.Upgrade } : { type: ModalEnum.None });
        this.state = {
            tutorialMode: props.tutorialMode,
            runTour: false,
            tourStepIndex: 0,
            dfNames: this.props.dfNames,
            sheetShapeArray: this.props.sheetShapeArray,
            columnSpreadsheetCodeJSONArray: this.props.columnSpreadsheetCodeJSONArray,
            sheetJSONArray: this.props.sheetJSONArray,
            columnFiltersArray: this.props.columnFiltersArray,
            columnTypeJSONArray: this.props.columnTypeJSONArray,
            selectedSheetIndex: 0,
            formulaBarValue: formulaBarValue,
            selectedColumn: selectedColumn,
            selectedRowIndex: 0,
            /*
                we tell if we're in cell editing mode through the editingModeOn state variable

                the editingCellColumn and editingCellRowIndex are used to update the formula of the correct
                cell editor. They get set to the new values when we turn cell editing mode back on, but are unchanged
                when we turn cell editing mode off so that we can handle formulas that error by letting the user
                edit the formula that they submitted.
            */
            editingModeState: {
                editingModeOn: false,
                editingSheetIndex: 0,
                editingCellColumn: "",
                editingCellRowIndex: -1,
                lastFormula: formulaBarValue,
                formulaCursorIndex: 2,
            },
            movingColumnParams: undefined,
            documentationOpen: false,
            errorJSON: {
                event: '',
                type: '',
                header: '',
                to_fix: ''
            },
            modalInfo: defaultModalInfo,
            savedAnalysisNames: this.props.savedAnalysisNames,
            loading: false,
            columnWidthsArray: defaultColumnWidthsArray,
            isLocalDeployment: props.isLocalDeployment,
            currOpenTaskpane: { type: _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.NONE },
            currOpenSheetTabActions: undefined,
            mitoContainerRef: undefined,
            stepDataList: this.props.stepDataList,
            currStepIdx: this.props.currStepIdx
        };
        this.cellFocused = this.cellFocused.bind(this);
        this.handleFormulaBarDoubleClick = this.handleFormulaBarDoubleClick.bind(this);
        this.sendCellValueUpdate = this.sendCellValueUpdate.bind(this);
        this.setEditingMode = this.setEditingMode.bind(this);
        this.setEditingFormula = this.setEditingFormula.bind(this);
        this.setModal = this.setModal.bind(this);
        this.getCurrentModalComponent = this.getCurrentModalComponent.bind(this);
        this.setSelectedSheetIndex = this.setSelectedSheetIndex.bind(this);
        this.turnOnCellEditor = this.turnOnCellEditor.bind(this);
        this.setCursorIndex = this.setCursorIndex.bind(this);
        this.columnMoved = this.columnMoved.bind(this);
        this.columnDragStopped = this.columnDragStopped.bind(this);
        this.setColumnWidth = this.setColumnWidth.bind(this);
        this.setCurrOpenTaskpane = this.setCurrOpenTaskpane.bind(this);
        this.getCurrOpenTaskpane = this.getCurrOpenTaskpane.bind(this);
        this.closeOpenEditingPopups = this.closeOpenEditingPopups.bind(this);
        this.setTourInfo = this.setTourInfo.bind(this);
        this.setCurrOpenSheetTabActions = this.setCurrOpenSheetTabActions.bind(this);
        this.setSelectedColumn = this.setSelectedColumn.bind(this);
    }
    /*
        if we're in tutorial mode, start the tour .5 seconds after page loading
        so that the tour selector has items to select. This also looks nice :)
    */
    componentDidMount() {
        setTimeout(() => {
            if (this.state.tutorialMode == true) {
                this.setState({ runTour: true });
            }
        }, 500);
    }
    /*
        Registers the step index with the Mito state so that when the
        tour is recreated because the key updates, we don't start back at the beginning
    */
    setTourInfo(runTour, newStepIndex) {
        this.setState({
            tourStepIndex: newStepIndex,
            runTour: runTour,
            tutorialMode: runTour
        }, () => {
            // Log the step advancement creation
            void this.props.mitoAPI.sendLogMessage('Introduction Tour', {
                tour_id: 'Introduction Tour',
                stepIndex: newStepIndex,
                runTour: runTour
            });
        });
    }
    /*
        The componentDidUpdate hook is responsible for maintaining consistency in the state
        variables of this prop in the case of updates to the sheet data. NOTE: this consistency
        should enforce that any column you index into should be defined for all sheets + all columns
        (e.g. this.state.columnFilters should be defined everywhere). If this is not the case, then it MUST
        be enforced in the type system!

        For example, if a sheet is deleted, then selectedSheetIndex in that state should not
        be set equal to the old index of that sheet.

        Furthermore, it makes sure the selected column is actually a column that exists in
        the dataset.

        See more here: https://reactjs.org/docs/react-component.html#componentdidupdate

        NOTE: careful on calling this.setState in this function, as repeated calls cause
        the sheet to crash (as this recurses infinitely).

        NOTE: this function will fail if it is called on a dataframe with mulitple columns with
        the same name. This is an invariant we currently expect to be the case.
    */
    componentDidUpdate(prevProps, prevState) {
        const newSheetJSON = this.state.sheetJSONArray;
        let newSelectedSheetIndex = this.state.selectedSheetIndex;
        // If the selectedSheetIndex no longer exists, because of an undo, don't select that one!
        // Or, if there was an a new sheet creation, then default to the last sheet
        if (newSelectedSheetIndex >= newSheetJSON.length || prevState.sheetJSONArray.length < newSheetJSON.length) {
            newSelectedSheetIndex = newSheetJSON.length - 1;
        }
        if (newSelectedSheetIndex != this.state.selectedSheetIndex) {
            this.setState({
                selectedSheetIndex: newSelectedSheetIndex
            });
        }
        // Make sure the column widths are set correctly, which they may not be if the columns in sheet
        // have changed, or a sheet has been added or subtracted
        const columnWidthsArrayResult = (0,_utils_gridStyling__WEBPACK_IMPORTED_MODULE_3__.getColumnWidthsArray)(this.state.sheetJSONArray, this.state.columnWidthsArray);
        // Check if we need to actually update the column widths (sheet number change, any column change)
        if (columnWidthsArrayResult.changed) {
            this.setState({
                columnWidthsArray: columnWidthsArrayResult.columnWidthsArray
            });
        }
        // Make sure the selected column is valid and actually from the selected sheet
        if (this.state.sheetJSONArray[newSelectedSheetIndex] !== undefined
            && !this.state.sheetJSONArray[newSelectedSheetIndex].columns.includes(this.state.selectedColumn)
            // NOTE: this last condition checks if there is no column to select
            && !(this.state.sheetJSONArray[newSelectedSheetIndex].columns.length === 0 && this.state.selectedColumn === '')) {
            const newSelectedColumnHeader = (0,_utils_gridData__WEBPACK_IMPORTED_MODULE_2__.getNewSelectedColumn)(this.state.sheetJSONArray[newSelectedSheetIndex].columns, prevState.sheetJSONArray[newSelectedSheetIndex] !== undefined ?
                {
                    oldColumnHeaders: prevState.sheetJSONArray[newSelectedSheetIndex].columns,
                    oldSelectedColumnHeader: prevState.selectedColumn
                }
                : undefined);
            this.setSelectedColumn(newSelectedColumnHeader);
        }
    }
    /*
        Called by the cell editor so that the column the user clicks on can be appended
        to the correct location in the formula
    */
    setCursorIndex(index) {
        this.setState(prevState => {
            return {
                editingModeState: Object.assign(Object.assign({}, prevState.editingModeState), { formulaCursorIndex: index })
            };
        });
    }
    /*
        This function is responsible for turning cell editing mode on and off
        by setting the state of editingCellColumn, and editingCellRowIndex.

        If you call this function with on===true, then the passed column and rowIndex
        should be the cell you want to start editing.

        If you call this function with on===false, then editing will be stopped, and the
        passed column and rowIndex will be focused on.
    */
    setEditingMode(on, column, rowIndex) {
        var _a, _b, _c, _d;
        if (on && !this.state.editingModeState.editingModeOn) {
            // we close the taskpane if its open and its a editing taskpane
            this.closeOpenEditingPopups();
            /*
                This runs (and turns on editing mode) when we're not in editing mode and:
                1. The user double clicks on a cell
                2. The user presses enter on a cell.
                3. The user types any character on a cell.
            */
            this.setState(prevState => {
                return {
                    editingModeState: Object.assign(Object.assign({}, prevState.editingModeState), { editingSheetIndex: this.state.selectedSheetIndex, editingModeOn: true, editingCellColumn: column, editingCellRowIndex: rowIndex })
                };
            });
        }
        else if (!on) {
            /*
                We turn off cell-editing mode and select the given cell.

                This handles some of the many ways cell editing can be stopped
                explicitly (e.g. ENTER), as we want only sometimes want ENTER to stop
                editing (in other cases, we want it to select a suggestion!).

                To see a list of events that stop editing, see:
                https://www.ag-grid.com/javascript-grid-cell-editing/#stop-end-editing
            */
            this.setState(prevState => {
                return {
                    editingModeState: Object.assign(Object.assign({}, prevState.editingModeState), { editingModeOn: false })
                };
            });
            // We actually stop the grid from editing in this case, and set cell focus
            // as stopping editing focuses on nothing by default.
            (_b = (_a = window.gridApiMap) === null || _a === void 0 ? void 0 : _a.get(this.props.model_id)) === null || _b === void 0 ? void 0 : _b.stopEditing();
            (_d = (_c = window.gridApiMap) === null || _c === void 0 ? void 0 : _c.get(this.props.model_id)) === null || _d === void 0 ? void 0 : _d.setFocusedCell(rowIndex, column);
        }
    }
    /*
        This function is called by the cell editor to update the formula of the editing cell
        in the mito state, so that when cellFocused starts editing mode again, it can
        pass in the starting formula.

        We save the formula in the state because:
            1) when the user clicks on another cell, it closes the cell editor.
            We need to store the formula in state so when we put the editor
            back in cell editing mode in the CellFocussedEvent,
            we're able to start the cell editor with the correct formula.
            
            Note: we don't want to send the intermediate formula to the parser

            2) we need to display the formula that is in the editor in the formula bar as well.
    */
    setEditingFormula(formula) {
        this.setState(prevState => {
            return {
                editingModeState: Object.assign(Object.assign({}, prevState.editingModeState), { lastFormula: formula }),
                formulaBarValue: formula,
            };
        });
    }
    turnOnCellEditor() {
        var _a, _b, _c, _d;
        const editingModeParams = {
            rowIndex: this.state.editingModeState.editingCellRowIndex,
            colKey: this.state.editingModeState.editingCellColumn,
        };
        // Scroll to make sure this editor is visible (but only scroll just enough)
        (_b = (_a = window.gridApiMap) === null || _a === void 0 ? void 0 : _a.get(this.props.model_id)) === null || _b === void 0 ? void 0 : _b.ensureColumnVisible(editingModeParams.colKey);
        // TODO: we might want to ensureIndexVisible as well, but users always edit at the top
        // turn the editing cell's cell editor back on!
        (_d = (_c = window.gridApiMap) === null || _c === void 0 ? void 0 : _c.get(this.props.model_id)) === null || _d === void 0 ? void 0 : _d.startEditingCell(editingModeParams);
    }
    /*
        Occurs when a cell is clicked. If we are currently editing a cell, we append the clicked
        column to the currently-edited cell. Otherwise, we select the clicked cell.
    */
    cellFocused(event) {
        var _a;
        // We always close the sheet tab actions
        this.setCurrOpenSheetTabActions(undefined);
        /*
            We avoid cell focused throwing an error when switching sheets by making sure the
            event is defined, and just returning. Not sure why this occurs!

            Additionally, turn of cell editing mode & reset the formulaBarValue. when the user switches
            sheets we reset the editing cell to clear the formula bar
        */
        const column = (_a = event.column) === null || _a === void 0 ? void 0 : _a.getColId();
        if (!column) {
            this.setEditingMode(false, "", -1);
            this.setState(prevState => {
                return {
                    editingModeState: Object.assign(Object.assign({}, prevState.editingModeState), { editingCellColumn: '', editingCellRowIndex: -1 }),
                    formulaBarValue: '',
                };
            });
            return;
        }
        // If the control panel is open, update the column header to the selected column
        if (this.state.currOpenTaskpane.type === _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.CONTROL_PANEL && column !== _utils_gridData__WEBPACK_IMPORTED_MODULE_2__.MITO_INDEX) {
            this.setState({
                currOpenTaskpane: {
                    type: _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.CONTROL_PANEL,
                    columnHeader: column,
                    openEditingColumnHeader: false
                }
            });
        }
        // If we're in cell editing mode, turn cell editor back on
        if (this.state.editingModeState.editingModeOn) {
            /*
                If the column we focussed on is the editing column or the index column, don't append to the formula
            */
            if (column === this.state.editingModeState.editingCellColumn || column === _utils_gridData__WEBPACK_IMPORTED_MODULE_2__.MITO_INDEX) {
                this.turnOnCellEditor();
                return;
            }
            /*
                If we're in editing mode & the cell focused on is not in the column we're editing
                or the index column, append the clicked column to the editing formula;
            */
            // Add the column reference to the formula where the user's cursor is in the input field
            const formulaCursorIndex = this.state.editingModeState.formulaCursorIndex;
            const newFormula = this.state.formulaBarValue.slice(0, formulaCursorIndex) + column + this.state.formulaBarValue.slice(formulaCursorIndex);
            this.setSelectedColumn(column);
            this.setState(prevState => {
                return {
                    editingModeState: Object.assign(Object.assign({}, prevState.editingModeState), { lastFormula: newFormula, formulaCursorIndex: formulaCursorIndex + column.length // update the formula cursor index to include appended characters
                     }),
                    formulaBarValue: newFormula,
                };
            }, () => {
                this.turnOnCellEditor();
            });
        }
        else {
            // If we're not in editing mode, then we update the formula bar only
            // If the column is the index column, then we reset the selected cell state
            if (column === _utils_gridData__WEBPACK_IMPORTED_MODULE_2__.MITO_INDEX) {
                this.setState({
                    selectedRowIndex: 0,
                    formulaBarValue: ''
                });
                this.setSelectedColumn('');
                return;
            }
            // Otherwise, get the cell's formula to display
            const columnIndex = this.state.sheetJSONArray[this.state.selectedSheetIndex].columns.indexOf(column);
            const rowIndex = event.rowIndex;
            const columnFormula = this.state.columnSpreadsheetCodeJSONArray[this.state.selectedSheetIndex][column];
            let formulaBarValue = this.state.formulaBarValue;
            if (columnFormula === '') {
                // If there no formula, we just display the value
                formulaBarValue = this.state.sheetJSONArray[this.state.selectedSheetIndex].data[rowIndex][columnIndex];
            }
            else {
                // Otherwise, we display the formula that is in the column
                formulaBarValue = columnFormula;
                if (this.state.selectedSheetIndex === this.state.editingModeState.editingSheetIndex && column === this.state.editingModeState.editingCellColumn) {
                    // The last formula is always equal to the _last_ edit made to a formula
                    // and so we take it so we keep an error formula
                    formulaBarValue = this.state.editingModeState.lastFormula;
                }
            }
            this.setState({
                selectedRowIndex: rowIndex,
                formulaBarValue: formulaBarValue
            });
            this.setSelectedColumn(column);
        }
    }
    handleFormulaBarDoubleClick(e) {
        var _a, _b;
        e.preventDefault();
        /*
            When the formula bar is double clicked, turns on cell editing mode and opens the
            selected cell's cell editor

            TODO: make sure it works with multiple sheets. fix: when we switch sheets,
            reset this.state.selectedColumn & this.state.selectedRowIndex
        */
        // Do nothing if the selected cell is a data column
        if (this.state.columnSpreadsheetCodeJSONArray[this.state.selectedSheetIndex][this.state.selectedColumn] === '') {
            return;
        }
        // Turn cell editing mode on
        this.setEditingMode(true, this.state.selectedColumn, this.state.selectedRowIndex);
        /*
            Turns on the correct cell editor. If the selected cell is not in view,
            the spreadsheet will be scrolled automatically until it is.
        */
        const editingModeParams = {
            rowIndex: this.state.selectedRowIndex,
            colKey: this.state.selectedColumn,
        };
        (_b = (_a = window.gridApiMap) === null || _a === void 0 ? void 0 : _a.get(this.props.model_id)) === null || _b === void 0 ? void 0 : _b.startEditingCell(editingModeParams);
    }
    async sendCellValueUpdate(columnHeader, newFormula) {
        /*
            We don't send the formula to the evaluator while in cell editing mode
            because this function gets called after the CellValueChangedEvent fires
            each time the cell editor is closed.
            
            However, the cell editor closes each time the user uses their mouse
            to reference another column - which isn't a finished update yet!
        */
        if (!this.state.editingModeState.editingModeOn) {
            await this.props.mitoAPI.sendSetColumnFormulaEditMessage(this.state.selectedSheetIndex, columnHeader, newFormula);
        }
    }
    /*
        Sets the sheet tab at the given index to have an open sheet tab
        action block.

        If undefined is passed, then the open sheet tab action is closed.
    */
    setCurrOpenSheetTabActions(sheetIndex) {
        // Log the click
        if (sheetIndex !== undefined) {
            // We just use a void, as we _don't care_ when this log gets sent,
            // and we don't want to everything async
            void this.props.mitoAPI.sendLogMessage('clicked_sheet_tab_actions', {
                sheet_index: sheetIndex
            });
        }
        this.setState({
            currOpenSheetTabActions: sheetIndex
        });
    }
    getCurrentModalComponent() {
        // Returns the JSX.element that is currently, open, and is used
        // in render to display this modal
        switch (this.state.modalInfo.type) {
            case ModalEnum.None: return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null);
            case ModalEnum.Error: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ErrorModal__WEBPACK_IMPORTED_MODULE_9__.default, { errorJSON: this.state.errorJSON, setModal: this.setModal }));
            case ModalEnum.Download: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_modals_DownloadModal__WEBPACK_IMPORTED_MODULE_10__.default, { setModal: this.setModal, mitoAPI: this.props.mitoAPI, selectedSheetIndex: this.state.selectedSheetIndex, dfName: this.state.dfNames[this.state.selectedSheetIndex] }));
            case ModalEnum.DeleteColumn: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_modals_DeleteColumnModal__WEBPACK_IMPORTED_MODULE_11__.default, { setModal: this.setModal, columnHeader: this.state.modalInfo.columnHeader, selectedSheetIndex: this.state.selectedSheetIndex, mitoAPI: this.props.mitoAPI }));
            case ModalEnum.SaveAnalysis: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_modals_SaveAnalysisModal__WEBPACK_IMPORTED_MODULE_12__.default, { setModal: this.setModal, savedAnalysisNames: this.state.savedAnalysisNames, saveAnalysisName: this.state.modalInfo.saveAnalysisName, mitoAPI: this.props.mitoAPI }));
            case ModalEnum.SaveAnalysisOverwrite: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_modals_SaveAnalysisOverwriteModal__WEBPACK_IMPORTED_MODULE_13__.default, { setModal: this.setModal, savedAnalysisNames: this.state.savedAnalysisNames, saveAnalysisName: this.state.modalInfo.saveAnalysisName, mitoAPI: this.props.mitoAPI }));
            case ModalEnum.Import: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_modals_ImportModal__WEBPACK_IMPORTED_MODULE_14__.default, { setModal: this.setModal, dfNames: this.state.dfNames, mitoAPI: this.props.mitoAPI }));
            case ModalEnum.ReplayImport: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_modals_ReplayImportModal__WEBPACK_IMPORTED_MODULE_16__.default, { setModal: this.setModal, dfNames: this.state.dfNames, api: this.props.mitoAPI, analysisName: this.state.modalInfo.analysisName, importSummaries: this.state.modalInfo.importSummary, mitoAPI: this.props.mitoAPI }));
            case ModalEnum.SignUp: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_modals_SignupModal__WEBPACK_IMPORTED_MODULE_23__.default, { setModal: this.setModal, mitoAPI: this.props.mitoAPI }));
            case ModalEnum.BookDemo: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_modals_BookDemoModal__WEBPACK_IMPORTED_MODULE_24__.default, { setModal: this.setModal, userEmail: this.state.modalInfo.userEmail }));
            case ModalEnum.Upgrade: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_modals_UpgradeModal__WEBPACK_IMPORTED_MODULE_25__.default, { setModal: this.setModal, mitoAPI: this.props.mitoAPI }));
        }
    }
    setModal(modalInfo) {
        // Sets the current modal. We _always_ turn off cell editing mode here, just
        // in case the user opens/closes a modal in cell editing mode.
        this.setEditingMode(false, "", -1);
        // unless opening an error modal or closing a modal, close open editing taskpanes
        if (modalInfo.type !== ModalEnum.Error && modalInfo.type !== ModalEnum.None) {
            this.closeOpenEditingPopups();
        }
        // And then we actually update the modalInfo
        this.setState({ modalInfo: modalInfo });
    }
    /*
        Returns the JSX.Element of the taskpane that should be currently
        displayed, stored in this.state.currOpenTaskpane.

        If this.state.currOpenTaskpane is undefined, then returns no taskpane
        at all.
    */
    getCurrOpenTaskpane() {
        switch (this.state.currOpenTaskpane.type) {
            case _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.NONE: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null));
            case _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.PIVOT: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_taskpanes_PivotTable_PivotTaskpane__WEBPACK_IMPORTED_MODULE_17__.default, { dfNames: this.state.dfNames, sheetJSONArray: this.state.sheetJSONArray, mitoAPI: this.props.mitoAPI, selectedSheetIndex: this.state.selectedSheetIndex, setCurrOpenTaskpane: this.setCurrOpenTaskpane }));
            case _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.MERGE: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_taskpanes_Merge_MergeTaskpane__WEBPACK_IMPORTED_MODULE_20__.default, { dfNames: this.state.dfNames, sheetJSONArray: this.state.sheetJSONArray, setCurrOpenTaskpane: this.setCurrOpenTaskpane, mitoAPI: this.props.mitoAPI }));
            case _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.STEPS: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_taskpanes_Steps_StepsTaskpane__WEBPACK_IMPORTED_MODULE_26__.default, { stepDataList: this.state.stepDataList, setCurrOpenTaskpane: this.setCurrOpenTaskpane, mitoAPI: this.props.mitoAPI, currStepIdx: this.state.currStepIdx }));
            case _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.DOCUMENTATION: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_taskpanes_Documentation_DocumentationTaskpane__WEBPACK_IMPORTED_MODULE_21__.default, { setCurrOpenTaskpane: this.setCurrOpenTaskpane, mitoAPI: this.props.mitoAPI }));
            case _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.CONTROL_PANEL:
                /*
                    We define default values here so when we rename the column header through the control panel,
                    we don't have to worry about a sheet-crashing race condition where the Mito state is not yet updated to reflect the
                    updated backend state.
                */
                // eslint-disable-next-line no-case-declarations
                let filters = [];
                // eslint-disable-next-line no-case-declarations
                let operator = 'And';
                // eslint-disable-next-line no-case-declarations
                let columnType = 'string';
                if (this.state.columnFiltersArray[this.state.selectedSheetIndex][this.state.currOpenTaskpane.columnHeader] !== undefined) {
                    filters = this.state.columnFiltersArray[this.state.selectedSheetIndex][this.state.currOpenTaskpane.columnHeader].filters;
                    operator = this.state.columnFiltersArray[this.state.selectedSheetIndex][this.state.currOpenTaskpane.columnHeader].operator;
                    columnType = this.state.columnTypeJSONArray[this.state.selectedSheetIndex][this.state.currOpenTaskpane.columnHeader];
                }
                return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_taskpanes_ControlPanel_ControlPanelTaskpane__WEBPACK_IMPORTED_MODULE_22__.default
                // set the columnHeader as the key so that the taskpane updates when it is switched
                // TODO: figure out why we need this, if the other variables update?
                , { 
                    // set the columnHeader as the key so that the taskpane updates when it is switched
                    // TODO: figure out why we need this, if the other variables update?
                    key: this.state.currOpenTaskpane.columnHeader + this.state.currOpenTaskpane.openEditingColumnHeader, selectedSheetIndex: this.state.selectedSheetIndex, columnHeader: this.state.currOpenTaskpane.columnHeader, openEditingColumnHeader: this.state.currOpenTaskpane.openEditingColumnHeader, columnType: columnType, operator: operator, filters: filters, setCurrOpenTaskpane: this.setCurrOpenTaskpane, mitoAPI: this.props.mitoAPI }));
            case _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.REPLAY_ANALYSIS:
                return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_taskpanes_ReplayAnalysis_ReplayAnalysisTaskpane__WEBPACK_IMPORTED_MODULE_28__.default, { savedAnalysisNames: this.state.savedAnalysisNames, mitoAPI: this.props.mitoAPI, setCurrOpenTaskpane: this.setCurrOpenTaskpane, setModal: this.setModal }));
        }
    }
    /*
        Changes what taskpane is currently displayed. Set to undefined
        to close the open taskpane.
    */
    setCurrOpenTaskpane(newTaskpaneInfo) {
        // Log this new change, including the column header if it 
        // is possible to do so
        const logParams = {
            new_taskpane: newTaskpaneInfo.type,
            sheet_index: this.state.selectedSheetIndex,
        };
        if (newTaskpaneInfo.type === _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.CONTROL_PANEL) {
            logParams['column_header'] = newTaskpaneInfo.columnHeader;
        }
        void this.props.mitoAPI.sendLogMessage('set_curr_open_taskpane', logParams);
        // If we're opening the column control panel, we make sure this column 
        // is selected in state 
        if (newTaskpaneInfo.type === _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.CONTROL_PANEL) {
            this.setSelectedColumn(newTaskpaneInfo.columnHeader);
        }
        this.setState({ currOpenTaskpane: newTaskpaneInfo });
    }
    /*
        Closes any open editing popups, which includes:
        1. Any open sheet tab actions
        2. The taskpane, if it is an EDITING_TASKPANE
    */
    closeOpenEditingPopups() {
        // We always close the sheet tab actions, no matter what
        this.setCurrOpenSheetTabActions(undefined);
        // Close the taskpane if it is an editing taskpane
        if (_taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.EDITING_TASKPANES.includes(this.state.currOpenTaskpane.type)) {
            this.setState({
                currOpenTaskpane: { type: _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.NONE }
            });
        }
    }
    setSelectedSheetIndex(newIndex) {
        // We turn off editing mode, if it is on, because we moved to a new sheet
        this.setEditingMode(false, "", -1);
        // We also make sure we don't switch to a sheet that doesn't exist
        const inBoundsNewIndex = Math.min(newIndex, this.state.sheetJSONArray.length - 1);
        // We use the backend to log that we switched sheets
        // NOTE: we don't await, because we don't care when this happens
        void this.props.mitoAPI.sendLogMessage('switch_sheet_log_event', {
            'sheet_index': newIndex
        });
        // And then we update the selected index
        this.setState({ selectedSheetIndex: inBoundsNewIndex });
    }
    /*
        The ColumnMovedEvent gets fired when a user drags a column to change its location.
        While dragging the column from one position to another, this event gets fired multiple times,
        for both the column that is moved but also sometimes for undefined columns.

        Thus, when the column is moving, and it is defined, we set the movingColumnParams
        so we can send a reorder event to the backend when it stops moving. See columnDragStopped
    */
    columnMoved(event) {
        var _a;
        const colId = (_a = event.column) === null || _a === void 0 ? void 0 : _a.getColId();
        const newIndex = event.toIndex;
        if (colId && newIndex) {
            this.setState({
                movingColumnParams: {
                    column: colId,
                    newIndex: newIndex
                }
            });
        }
    }
    // When the column stops moving, send the column reorder event to the backend 
    async columnDragStopped() {
        /*
            The DragStoppedEvent gets fired when the user changes the width of the column and when
            the user reorders the column. We only want to send a column_reorder_event when the user is
            reordering the column, so we check if the user is moving a column by checking this.state.columnMovedState.column
        */
        if (this.state.movingColumnParams != undefined) {
            // If the column did not change locations, don't send a column_reorder_event
            if (this.state.sheetJSONArray[this.state.selectedSheetIndex].columns[this.state.movingColumnParams.newIndex - 1] === this.state.movingColumnParams.column) {
                return;
            }
            void this.props.mitoAPI.sendReorderColumnMessage(this.state.selectedSheetIndex, this.state.movingColumnParams.column, this.state.movingColumnParams.newIndex - 1);
            // Reset the columnMovedState so a column resizing doesn't cause the column_reorder_event to get sent
            this.setState({
                movingColumnParams: undefined
            });
        }
    }
    setColumnWidth(sheetIndex, columnHeader, columnWidth) {
        this.setState(prevState => {
            const newColumnsWidthsArray = [...prevState.columnWidthsArray];
            newColumnsWidthsArray[sheetIndex][columnHeader] = columnWidth;
            return Object.assign(Object.assign({}, prevState), { columnWidthsArray: newColumnsWidthsArray });
        });
    }
    /*
        Sets the selectedColumn in the Mito state and tells Ag-grid
        to redraw the old selected column and new selected column to keep
        the selected column highlighting in sync with state

        Note: the selectedColumn state should not be updated without this function
    */
    setSelectedColumn(columnHeader) {
        const oldSelectedColumnHeader = this.state.selectedColumn;
        this.setState({ selectedColumn: columnHeader }, () => {
            var _a, _b;
            // force the columns to refresh.  
            const params = {
                force: true,
                suppressFlash: true,
                columns: [oldSelectedColumnHeader, columnHeader],
            };
            (_b = (_a = window.gridApiMap) === null || _a === void 0 ? void 0 : _a.get(this.props.model_id)) === null || _b === void 0 ? void 0 : _b.refreshCells(params);
        });
    }
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    render() {
        // We get the class to open or close the taskpane, as we open the taskpane by changing
        // the widths of the divs in the css
        const mitoFormulaBarAndMitosheetClass = this.state.currOpenTaskpane.type !== _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.NONE ?
            'mito-formula-bar-and-mitosheet-div mito-formula-bar-and-mitosheet-div-taskpane-open' :
            'mito-formula-bar-and-mitosheet-div';
        const mitoDefaultTaskpaneClass = this.state.currOpenTaskpane.type !== _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.NONE ?
            'mito-default-taskpane mito-default-taskpane-open' :
            'mito-default-taskpane';
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "mito-container", ref: (ref) => {
                // NOTE: it is crucial we only set the ref it is not already defined, as we
                // will otherwise enter into an infinite loop
                if (!this.state.mitoContainerRef) {
                    this.setState({ mitoContainerRef: ref });
                }
            } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MitoToolbar__WEBPACK_IMPORTED_MODULE_7__.default, { mitoContainerRef: this.state.mitoContainerRef, sheetJSON: this.state.sheetJSONArray[this.state.selectedSheetIndex], selectedSheetIndex: this.state.selectedSheetIndex, setEditingMode: this.setEditingMode, setModal: this.setModal, model_id: this.props.model_id, selectedColumn: this.state.selectedColumn, setCurrOpenTaskpane: this.setCurrOpenTaskpane, mitoAPI: this.props.mitoAPI, closeOpenEditingPopups: this.closeOpenEditingPopups, currStepIdx: this.state.currStepIdx, numSteps: this.state.stepDataList.length }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "mito-main-sheet-div" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: mitoFormulaBarAndMitosheetClass },
                    this.state.runTour &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_tours_IntroductionTour__WEBPACK_IMPORTED_MODULE_18__.default
                        // Set key so IntroductionTour gets created with new state when tour is turned on/off or import modal is open/closed
                        // see comment in IntroductionTour constructor for more info
                        , { 
                            // Set key so IntroductionTour gets created with new state when tour is turned on/off or import modal is open/closed
                            // see comment in IntroductionTour constructor for more info
                            key: this.state.runTour + this.state.modalInfo.type.toString(), isImportModalOpen: this.state.modalInfo.type == ModalEnum.Import, run: this.state.runTour, stepIndex: this.state.tourStepIndex, setTourInfo: this.setTourInfo }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_FormulaBar__WEBPACK_IMPORTED_MODULE_6__.default, { formulaBarValue: this.state.formulaBarValue, handleFormulaBarDoubleClick: this.handleFormulaBarDoubleClick }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MitoSheet__WEBPACK_IMPORTED_MODULE_4__.default, { selectedSheetIndex: this.state.selectedSheetIndex, formulaBarValue: this.state.formulaBarValue, editingColumn: this.state.editingModeState.editingCellColumn, selectedColumn: this.state.selectedColumn, columnSpreadsheetCodeJSON: this.state.columnSpreadsheetCodeJSONArray[this.state.selectedSheetIndex], sheetJSON: this.state.sheetJSONArray[this.state.selectedSheetIndex], columnFiltersJSON: this.state.columnFiltersArray[this.state.selectedSheetIndex], setEditingMode: this.setEditingMode, setEditingFormula: this.setEditingFormula, setCursorIndex: this.setCursorIndex, cursorIndex: this.state.editingModeState.formulaCursorIndex, cellFocused: this.cellFocused, columnMoved: this.columnMoved, columnDragStopped: this.columnDragStopped, model_id: this.props.model_id, sendCellValueUpdate: this.sendCellValueUpdate, columnWidths: this.state.columnWidthsArray[this.state.selectedSheetIndex], setColumnWidth: this.setColumnWidth, setCurrOpenTaskpane: this.setCurrOpenTaskpane, setSelectedColumn: this.setSelectedColumn })),
                this.state.currOpenTaskpane.type !== _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_19__.TaskpaneType.NONE &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: mitoDefaultTaskpaneClass }, this.getCurrOpenTaskpane())),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_tabs_SheetTabs__WEBPACK_IMPORTED_MODULE_5__.default, { setCurrOpenSheetTabActions: this.setCurrOpenSheetTabActions, currOpenSheetTabActions: this.state.currOpenSheetTabActions, mitoContainerRef: this.state.mitoContainerRef, dfNames: this.state.dfNames, sheetShapeArray: this.state.sheetShapeArray, selectedSheetIndex: this.state.selectedSheetIndex, setSelectedSheetIndex: this.setSelectedSheetIndex, mitoAPI: this.props.mitoAPI, closeOpenEditingPopups: this.closeOpenEditingPopups }),
            this.getCurrentModalComponent(),
            this.state.loading && react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_LoadingIndicator__WEBPACK_IMPORTED_MODULE_8__.default, null),
            !this.state.isLocalDeployment && react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react_intercom__WEBPACK_IMPORTED_MODULE_1___default()), { appID: 'mu6azgiv' }),
            this.state.currStepIdx !== this.state.stepDataList.length - 1 &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_elements_TopLeftPopup__WEBPACK_IMPORTED_MODULE_27__.default, { message: 'You are viewing a previous step, and cannot make any edits. Fast forward to start editing.' })));
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Mito);


/***/ }),

/***/ "./lib/components/MitoCellEditor.js":
/*!******************************************!*\
  !*** ./lib/components/MitoCellEditor.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TAKE_SUGGESTION_KEYS": () => (/* binding */ TAKE_SUGGESTION_KEYS),
/* harmony export */   "ARROW_UP_KEYS": () => (/* binding */ ARROW_UP_KEYS),
/* harmony export */   "ARROW_DOWN_KEYS": () => (/* binding */ ARROW_DOWN_KEYS),
/* harmony export */   "ARROW_LEFT_KEYS": () => (/* binding */ ARROW_LEFT_KEYS),
/* harmony export */   "ARROW_RIGHT_KEYS": () => (/* binding */ ARROW_RIGHT_KEYS),
/* harmony export */   "default": () => (/* binding */ MitoCellEditor)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _data_function_documentation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../data/function_documentation */ "./lib/data/function_documentation.js");
/* harmony import */ var _utils_suggestions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/suggestions */ "./lib/utils/suggestions.js");
/* harmony import */ var _editor_DocumentationBox__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./editor/DocumentationBox */ "./lib/components/editor/DocumentationBox.js");
/* harmony import */ var _editor_SuggestionBox__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./editor/SuggestionBox */ "./lib/components/editor/SuggestionBox.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.





const keyboardKeys = {
    ENTER_KEY: "Enter",
    TAB_KEY: "Tab",
    ESCAPE_KEY: "Escape",
    UP: 'ArrowUp',
    DOWN: 'ArrowDown',
    LEFT: 'ArrowLeft',
    RIGHT: 'ArrowRight',
    // These events have IE/Edge differences
    IE_UP: 'Up',
    IE_DOWN: 'Down',
    IE_LEFT: 'Left',
    IE_RIGHT: 'Right'
};
const TAKE_SUGGESTION_KEYS = [keyboardKeys.ENTER_KEY, keyboardKeys.TAB_KEY];
const CLOSE_INPUT_KEYS = [keyboardKeys.ENTER_KEY, keyboardKeys.TAB_KEY, keyboardKeys.ESCAPE_KEY];
const ARROW_UP_KEYS = [keyboardKeys.UP, keyboardKeys.IE_UP];
const ARROW_DOWN_KEYS = [keyboardKeys.DOWN, keyboardKeys.IE_DOWN];
const ARROW_LEFT_KEYS = [keyboardKeys.LEFT, keyboardKeys.IE_LEFT];
const ARROW_RIGHT_KEYS = [keyboardKeys.RIGHT, keyboardKeys.IE_RIGHT];
class MitoCellEditor extends react__WEBPACK_IMPORTED_MODULE_0__.Component {
    constructor(props) {
        super(props);
        /*
     We turn editing mode on first to ensure that any future calls to
     set editing formula set the formula of the correct column.
    */
        const column = props.colDef.field ? props.colDef.field : "";
        props.setEditingMode(true, column, props.rowIndex);
        // Set the editor's state
        if (props.charPress != null) {
            /*
      The charPress param is used to tell the cell editor which character was pressed to enter cell editing mode.
      When the cell editor is entered through a charPress, we overwrite the formula to the character pressed
      */
            props.setEditingFormula(props.charPress);
            this.state = {
                formula: props.charPress,
                input: null,
                suggestionIndex: 0
            };
        }
        else {
            // otherwise keep the original value
            this.state = {
                formula: props.formula,
                input: null,
                suggestionIndex: 0
            };
        }
        this.getValue = this.getValue.bind(this);
        this.isPopup = this.isPopup.bind(this);
        this.handleOnChange = this.handleOnChange.bind(this);
        this.afterGuiAttached = this.afterGuiAttached.bind(this);
        this.getCurrentSuggestions = this.getCurrentSuggestions.bind(this);
        this.getDocumentationBoxFunction = this.getDocumentationBoxFunction.bind(this);
        this.onKeyDown = this.onKeyDown.bind(this);
        this.onClick = this.onClick.bind(this);
        this.onMouseEnterSuggestion = this.onMouseEnterSuggestion.bind(this);
        this.selectSuggestion = this.selectSuggestion.bind(this);
        this.getAdjustedIndex = this.getAdjustedIndex.bind(this);
    }
    getValue() {
        return this.state.formula;
    }
    /*
    set the cursor location so that if the user uses mouse to reference
    column, we append the column to the correct location
  */
    // eslint-disable-next-line @typescript-eslint/no-inferrable-types
    updateCursorIndex(adjustment) {
        var _a, _b;
        if ((_a = this.state.input) === null || _a === void 0 ? void 0 : _a.selectionEnd) {
            this.props.setCursorIndex(((_b = this.state.input) === null || _b === void 0 ? void 0 : _b.selectionEnd) + adjustment);
        }
    }
    /* Make the cell editor a popup, so we can display suggestion/documentation box */
    isPopup() {
        return true;
    }
    /* update the cell value while typing */
    handleOnChange(event) {
        this.updateFormulaState(event.target.value);
        this.updateCursorIndex(0);
    }
    /*
    this function updates the state of both the mitoCelEditor formula and the formulaBar
    of in Mito.tsx. We update in both locations so that the formula can persist across
    opening and closing the cell editor
  */
    updateFormulaState(newFormula) {
        this.setState({
            formula: newFormula
        }, () => {
            this.props.setEditingFormula(this.state.formula);
        });
    }
    /*
    This function is called by ag-grid after this component
    is rendered; we simply focus on the input feild rendered
    below so the user can begin typing immediately!

    NOTE: There is a bug that requires us to also call focus
    _after_ we define the ref in the setState callback. For some reason,
    the ref is not always defined after the gui is attached - and so
    we need to focus then as well!
  */
    afterGuiAttached() {
        var _a, _b;
        (_a = this.state.input) === null || _a === void 0 ? void 0 : _a.focus();
        // when the cell editor loads, set the Cursor (cursor) to be in the last position it was in
        // if the cell editor was just closed
        (_b = this.state.input) === null || _b === void 0 ? void 0 : _b.setSelectionRange(this.props.cursorIndex, this.props.cursorIndex);
    }
    /* when the user clicks to move the Cursor, update the Cursor location*/
    onClick() {
        this.updateCursorIndex(0);
    }
    /*
    This function handles key presses on the cell editor input.

    If the suggestion box is open currently, than this function first checks
    if this key press effects the suggestion box (e.g. scrolling or selecting a suggestion).

    Otherwise, we check if this event closes the cell editor.

    NOTE: we event.preventDefault() to stop events from having unintended
    consequences if they cause effects we handle ourselves. For example, this
    prevents TAB from selecting the next form field.

    NOTE: the events handled by this functions should correspond to the events
    suppressed in editing mode in the ag-grid, to avoid unintended behavior
  */
    onKeyDown(event) {
        /*
      if the arrow keys are used to move the Cursor location, update the cursor location

      Note: Idk why, but when moving the cursor with the arrow keys, there is a one index lag
      in the direction the cursor is moving. ie: if moving to the left, the index will be 1 higher than
      it should be. We work around this by using the adjustments passed as params to the updateCursorIndex function below.
    */
        if (ARROW_LEFT_KEYS.includes(event.key)) {
            this.updateCursorIndex(-1);
        }
        else if (ARROW_RIGHT_KEYS.includes(event.key)) {
            this.updateCursorIndex(1);
        }
        const suggestions = this.getCurrentSuggestions();
        if (suggestions !== undefined) {
            if (TAKE_SUGGESTION_KEYS.includes(event.key)) {
                event.preventDefault();
                // We mod below just as one last safety check for an out of bound index, which we
                // also ensure with the getAdjustedIndex function
                const selectedSuggestion = suggestions[this.state.suggestionIndex % suggestions.length];
                const restOfSuggestion = selectedSuggestion.suggestion.substring(selectedSuggestion.match.length);
                return this.selectSuggestion(selectedSuggestion.match, restOfSuggestion, selectedSuggestion.type);
            }
            else if (ARROW_UP_KEYS.includes(event.key)) {
                event.preventDefault();
                return this.setState((prevState) => {
                    return { suggestionIndex: this.getAdjustedIndex(prevState.suggestionIndex - 1, suggestions) };
                });
            }
            else if (ARROW_DOWN_KEYS.includes(event.key)) {
                event.preventDefault();
                return this.setState((prevState) => {
                    return { suggestionIndex: this.getAdjustedIndex(prevState.suggestionIndex + 1, suggestions) };
                });
            }
        }
        // NOTE: we should always check the close events _last_, in case the keypresses
        // were trying to do other things!
        if (CLOSE_INPUT_KEYS.includes(event.key)) {
            event.preventDefault();
            this.props.setEditingMode(false, this.props.column.getColId(), this.props.rowIndex);
        }
    }
    /*
    This function returns the current suggestions, which are:
    2. Any column who is prepended by the current ending string, which may not be all alphabetic
    characters (and can be any valid column).
    1. Any functions who are prepended by the current ending string, which
    must be all alphabetic characters. Case-insensitive.
    
    Returns undefined if there are no suggestions, or if the end of the formula
    is a perfect column match - so the user can submit in this case!
  */
    getCurrentSuggestions() {
        if (typeof this.state.formula === 'string') {
            // If you have a column header that is matched exactly, we _do show no suggestions_, as 
            // we want you to be able to enter it in
            if ((0,_utils_suggestions__WEBPACK_IMPORTED_MODULE_2__.endsInColumnHeader)(this.state.formula, this.props.columns)) {
                return undefined;
            }
            const columnHeaderSuggestions = (0,_utils_suggestions__WEBPACK_IMPORTED_MODULE_2__.getColumnHeaderSuggestions)(this.state.formula, this.props.columns);
            const functionSuggestions = (0,_utils_suggestions__WEBPACK_IMPORTED_MODULE_2__.getFunctionSuggestions)(this.state.formula);
            const suggestions = [];
            // Add the column headers first, then the functions
            if (columnHeaderSuggestions !== undefined) {
                suggestions.push(...columnHeaderSuggestions);
            }
            if (functionSuggestions !== undefined) {
                suggestions.push(...functionSuggestions);
            }
            if (suggestions.length > 0) {
                return suggestions;
            }
        }
        return undefined;
    }
    /*
    Keeps the selected index for the suggestion box inbounds; the index
    should be the index of one of the suggestions!
  */
    getAdjustedIndex(index, suggestions) {
        // Fancy expression to keep it as a valid index
        return Math.min(Math.max(0, index), suggestions.length - 1);
    }
    /*
    This function returns the current function that should
    be displayed in the documentation box, based on if the
    documentation box open condition is met.

    If the documentation box open condition is not met, this
    returns undefined.
  */
    getDocumentationBoxFunction() {
        var _a;
        // Finds all instances of functions that are not followed by a closing paren
        // e.g. all functions that are still being edited.
        const docBoxRe = /[A-Za-z]+\((?![^)]*\))/g;
        if (typeof this.state.formula == 'string') {
            const functionMatches = (_a = this.state.formula) === null || _a === void 0 ? void 0 : _a.match(docBoxRe);
            if (!functionMatches) {
                return undefined;
            }
            // We take the _last_ function that has been written, as this is the funciton
            // being edited currently.
            const lastFunction = functionMatches[functionMatches.length - 1];
            // Strip off the last ( from the function name
            const lastFunctionClean = lastFunction.substring(0, lastFunction.length - 1).toUpperCase();
            return _data_function_documentation__WEBPACK_IMPORTED_MODULE_1__.functionDocumentationObjects.find((funcDocObject) => {
                return funcDocObject.function === lastFunctionClean;
            });
        }
        return undefined;
    }
    // If you mouseover a suggestion, this selects it
    onMouseEnterSuggestion(suggestionIndex) {
        this.setState({ suggestionIndex: suggestionIndex });
    }
    selectSuggestion(endingString, restOfSuggestion, type) {
        // We fill in the rest of the suggestion, and reset the suggestion box
        const stripped = this.state.formula.substring(0, this.state.formula.length - endingString.length);
        let newFormula;
        if (type === 'function') {
            // Upper case, add paren, if a function
            newFormula = stripped + endingString.toUpperCase() + restOfSuggestion.toUpperCase() + '(';
        }
        else {
            // Just add column header, if column header
            newFormula = stripped + endingString + restOfSuggestion;
        }
        this.updateFormulaState(newFormula);
        this.setState({
            suggestionIndex: 0
        }, () => {
            var _a;
            // TODO: add documentation about when this runs... (A close?)
            // We also refocus on the input feild
            (_a = this.state.input) === null || _a === void 0 ? void 0 : _a.focus();
            // And then make sure the cursor index is at the right location
            this.updateCursorIndex(0);
        });
    }
    render() {
        const suggestions = this.getCurrentSuggestions();
        const documentationBoxFunction = this.getDocumentationBoxFunction();
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { ref: (input) => {
                    if (!this.state.input) {
                        this.setState({ input: input }, () => {
                            var _a;
                            // See note in afterGuiAttached. This is a workaround that makes sure 
                            // the input is always focused on after it is displayed to the user. 
                            // Possibly related: https://stackoverflow.com/questions/44074747/componentdidmount-called-before-ref-callback
                            (_a = this.state.input) === null || _a === void 0 ? void 0 : _a.focus();
                        });
                    }
                }, className: "mito-cell-editor ag-cell-inline-editing", name: "value", autoComplete: "off", value: this.state.formula, onChange: this.handleOnChange, onKeyDown: this.onKeyDown, onClick: this.onClick, tabIndex: 1 }),
            suggestions !== undefined &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_editor_SuggestionBox__WEBPACK_IMPORTED_MODULE_4__.default, { suggestions: suggestions, index: this.state.suggestionIndex, onMouseEnterSuggestion: this.onMouseEnterSuggestion, onSelectSuggestion: this.selectSuggestion }),
            suggestions === undefined && documentationBoxFunction &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_editor_DocumentationBox__WEBPACK_IMPORTED_MODULE_3__.default, { funcDocObject: documentationBoxFunction })));
    }
}


/***/ }),

/***/ "./lib/components/MitoSheet.js":
/*!*************************************!*\
  !*** ./lib/components/MitoSheet.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ag_grid_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ag-grid-react */ "webpack/sharing/consume/default/ag-grid-react/ag-grid-react");
/* harmony import */ var ag_grid_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(ag_grid_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var ag_grid_community_dist_styles_ag_grid_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ag-grid-community/dist/styles/ag-grid.css */ "./node_modules/ag-grid-community/dist/styles/ag-grid.css");
/* harmony import */ var ag_grid_community_dist_styles_ag_grid_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(ag_grid_community_dist_styles_ag_grid_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var ag_grid_community_dist_styles_ag_theme_alpine_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ag-grid-community/dist/styles/ag-theme-alpine.css */ "./node_modules/ag-grid-community/dist/styles/ag-theme-alpine.css");
/* harmony import */ var ag_grid_community_dist_styles_ag_theme_alpine_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(ag_grid_community_dist_styles_ag_theme_alpine_css__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _css_mitosheet_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../css/mitosheet.css */ "./css/mitosheet.css");
/* harmony import */ var _css_mitosheet_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_css_mitosheet_css__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _MitoCellEditor__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./MitoCellEditor */ "./lib/components/MitoCellEditor.js");
/* harmony import */ var _utils_gridData__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/gridData */ "./lib/utils/gridData.js");
/* harmony import */ var _utils_gridStyling__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/gridStyling */ "./lib/utils/gridStyling.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.







// And functions for building components


const MitoSheet = (props) => {
    var _a;
    function onGridReady(params) {
        if (window.gridApiMap === undefined) {
            window.gridApiMap = new Map();
        }
        window.gridApiMap.set(props.model_id, params.api);
        (0,_utils_gridStyling__WEBPACK_IMPORTED_MODULE_7__.calculateAndSetHeaderHeight)(props.model_id);
    }
    /*
        Ag-grid does some sort of caching that means if we rename a column
        it will treat this as a new column that got added to the _end_.

        This function runs whenever the columns change.
        
        It makes sure that the columns are in the correct order. If they aren't,
        it then places them in the correct order.
    */
    function onGridColumnsChanged(params) {
        if (props.sheetJSON === undefined) {
            return;
        }
        const columnState = params.columnApi.getColumnState();
        const correctColumnOrder = props.sheetJSON.columns;
        for (let i = 0; i < correctColumnOrder.length; i++) {
            const columnName = correctColumnOrder[i].toString();
            // If, ignoring the index column, this column is not in the right place, then
            // we have some reordering to do!
            const correctIndex = i + 1;
            const currentDisplayIndex = columnState.findIndex((columnState) => {
                return columnState.colId === columnName;
            });
            if (correctIndex !== currentDisplayIndex) {
                params.columnApi.moveColumn(columnName, correctIndex);
            }
        }
    }
    /*
        Listener that is run when a cell value changes, which in our case
        means a formula was updated. In this case, we send a message
        to the backend of this update.
    */
    const cellValueChanged = (e) => {
        const column = e.colDef.field ? e.colDef.field : "";
        const newValue = e.newValue;
        props.sendCellValueUpdate(column, newValue);
    };
    /*
        Listener that is run anytime a column resizes. If this resize is caused
        by a user dragging the column, then we save the final width the user
        has dragged it to.
    */
    const onColumnResized = (e) => {
        // We save the resize when it occurs because the user finishes dragging a column!
        if (e.finished && e.source == 'uiColumnDragged') {
            const columns = e.columns;
            if (columns) {
                const resizedColumn = columns[0].getColId();
                const newWidth = columns[0].getActualWidth();
                props.setColumnWidth(props.selectedSheetIndex, resizedColumn, newWidth);
            }
        }
    };
    const columns = (0,_utils_gridData__WEBPACK_IMPORTED_MODULE_6__.buildGridColumns)((_a = props.sheetJSON) === null || _a === void 0 ? void 0 : _a.columns, props.columnSpreadsheetCodeJSON, props.columnFiltersJSON, props.formulaBarValue, props.editingColumn, props.selectedColumn, props.cursorIndex, props.setEditingMode, props.setEditingFormula, props.setCursorIndex, props.setCurrOpenTaskpane, props.columnWidths, props.setSelectedColumn);
    const rowData = (0,_utils_gridData__WEBPACK_IMPORTED_MODULE_6__.buildGridData)(props.sheetJSON);
    const frameworkComponents = {
        simpleEditor: _MitoCellEditor__WEBPACK_IMPORTED_MODULE_5__.default,
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { style: { height: '100%' } },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "ag-theme-alpine mitosheet-ag-grid" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ag_grid_react__WEBPACK_IMPORTED_MODULE_1__.AgGridReact, { onGridReady: onGridReady, onGridColumnsChanged: onGridColumnsChanged, onCellFocused: (e) => props.cellFocused(e), onColumnMoved: (e) => props.columnMoved(e), onDragStopped: () => props.columnDragStopped(), rowData: rowData, rowHeight: 25, rowSelection: 'multiple', headerHeight: _utils_gridStyling__WEBPACK_IMPORTED_MODULE_7__.headerHeightParams.defaultHeaderHeight, frameworkComponents: frameworkComponents, suppressKeyboardEvent: (params) => {
                    /*
                        While we're editing a cell, we suppress events that we use
                        to do things within the editor.

                        NOTE: this function should suppress the events matched in onKeyDown
                        in MitoCellEditor!
                    */
                    if (!params.editing) {
                        return false;
                    }
                    return _MitoCellEditor__WEBPACK_IMPORTED_MODULE_5__.TAKE_SUGGESTION_KEYS.includes(params.event.key) ||
                        _MitoCellEditor__WEBPACK_IMPORTED_MODULE_5__.ARROW_UP_KEYS.includes(params.event.key) ||
                        _MitoCellEditor__WEBPACK_IMPORTED_MODULE_5__.ARROW_DOWN_KEYS.includes(params.event.key);
                }, onCellValueChanged: cellValueChanged, suppressDragLeaveHidesColumns: true, suppressColumnMoveAnimation: true, onColumnResized: onColumnResized }, columns))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MitoSheet);


/***/ }),

/***/ "./lib/components/MitoToolbar.js":
/*!***************************************!*\
  !*** ./lib/components/MitoToolbar.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var fscreen__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! fscreen */ "webpack/sharing/consume/default/fscreen/fscreen");
/* harmony import */ var fscreen__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(fscreen__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _css_mito_toolbar_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../css/mito-toolbar.css */ "./css/mito-toolbar.css");
/* harmony import */ var _css_mito_toolbar_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_mito_toolbar_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _Mito__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Mito */ "./lib/components/Mito.js");
/* harmony import */ var _Tooltip__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Tooltip */ "./lib/components/Tooltip.js");
/* harmony import */ var _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./taskpanes/taskpanes */ "./lib/components/taskpanes/taskpanes.js");
/* harmony import */ var _icons_UndoIcon__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./icons/UndoIcon */ "./lib/components/icons/UndoIcon.js");
/* harmony import */ var _icons_ImportIcon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./icons/ImportIcon */ "./lib/components/icons/ImportIcon.js");
/* harmony import */ var _icons_ExportIcon__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./icons/ExportIcon */ "./lib/components/icons/ExportIcon.js");
/* harmony import */ var _icons_ReplayIcon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./icons/ReplayIcon */ "./lib/components/icons/ReplayIcon.js");
/* harmony import */ var _icons_SaveIcon__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./icons/SaveIcon */ "./lib/components/icons/SaveIcon.js");
/* harmony import */ var _icons_MergeIcon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./icons/MergeIcon */ "./lib/components/icons/MergeIcon.js");
/* harmony import */ var _icons_PivotIcon__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./icons/PivotIcon */ "./lib/components/icons/PivotIcon.js");
/* harmony import */ var _icons_DeleteColumnIcon__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./icons/DeleteColumnIcon */ "./lib/components/icons/DeleteColumnIcon.js");
/* harmony import */ var _icons_AddColumnIcon__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./icons/AddColumnIcon */ "./lib/components/icons/AddColumnIcon.js");
/* harmony import */ var _icons_DocumentationIcon__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./icons/DocumentationIcon */ "./lib/components/icons/DocumentationIcon.js");
/* harmony import */ var _icons_FullscreenIcons__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./icons/FullscreenIcons */ "./lib/components/icons/FullscreenIcons.js");
/* harmony import */ var _icons_StepsIcon__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./icons/StepsIcon */ "./lib/components/icons/StepsIcon.js");
/* harmony import */ var _icons_FastForwardIcon__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./icons/FastForwardIcon */ "./lib/components/icons/FastForwardIcon.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


// Import CSS



// Import Components 


// Icons!













const MitoToolbar = (props) => {
    /* Adds a new column onto the end of a sheet, with A, B, C... as the name */
    const addColumn = () => {
        // We turn off editing mode, if it is on
        props.setEditingMode(false, "", -1);
        // we close the editing taskpane if its open
        props.closeOpenEditingPopups();
        /*
        * Helper function that, given a number, returns Excel column that corresponds to this number (1-indexed)
        */
        function toColumnName(num) {
            let ret;
            let a = 1;
            let b = 26;
            for (ret = ''; (num -= a) >= 0; a = b, b *= 26) {
                ret = String.fromCharCode(Math.round((num % b) / a) + 65) + ret;
            }
            return ret;
        }
        let inc = 1;
        let newColumnHeader = toColumnName(props.sheetJSON.columns.length + inc);
        // If the column header is in the sheet already, we bump and keep trying
        while (props.sheetJSON.columns.includes(newColumnHeader)) {
            inc++;
            newColumnHeader = toColumnName(props.sheetJSON.columns.length + inc);
        }
        void props.mitoAPI.sendColumnAddMessage(props.selectedSheetIndex, newColumnHeader);
    };
    /* Undoes the last step that was created */
    const undo = () => {
        // We turn off editing mode, if it is on
        props.setEditingMode(false, "", -1);
        // we close the editing taskpane if its open
        props.closeOpenEditingPopups();
        void props.mitoAPI.sendUndoMessage();
    };
    /* Saves the current file as as an exported analysis */
    const downloadAnalysis = () => {
        // We turn off editing mode, if it is on
        props.setEditingMode(false, "", -1);
        // we close the editing taskpane if its open
        props.closeOpenEditingPopups();
        props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_4__.ModalEnum.Download });
    };
    const [fullscreen, setFullscreen] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    (fscreen__WEBPACK_IMPORTED_MODULE_1___default().onfullscreenchange) = () => {
        setFullscreen(!!(fscreen__WEBPACK_IMPORTED_MODULE_1___default().fullscreenElement));
        void props.mitoAPI.sendLogMessage('button_toggle_fullscreen', {
            // Note that this is true when _end_ in fullscreen mode, and 
            // false when we _end_ not in fullscreen mode, which is much
            // more natural than the alternative
            fullscreen: !!(fscreen__WEBPACK_IMPORTED_MODULE_1___default().fullscreenElement)
        });
    };
    /*
        Toggles if Mito is full screen or not
    */
    const toggleFullscreen = () => {
        // We toggle to the opposite of whatever the fullscreen actually is (as detected by the
        // fscreen library), and then we set the fullscreen state variable to that state (in the callback
        // above), so that the component rerenders propery
        const isNotFullscreen = (fscreen__WEBPACK_IMPORTED_MODULE_1___default().fullscreenElement) === undefined || (fscreen__WEBPACK_IMPORTED_MODULE_1___default().fullscreenElement) === null;
        if (isNotFullscreen && props.mitoContainerRef) {
            fscreen__WEBPACK_IMPORTED_MODULE_1___default().requestFullscreen(props.mitoContainerRef);
        }
        else {
            fscreen__WEBPACK_IMPORTED_MODULE_1___default().exitFullscreen();
        }
    };
    const openDocumentation = () => {
        // We turn off editing mode, if it is on
        props.setEditingMode(false, "", -1);
        // We log the opening of the documentation taskpane
        void props.mitoAPI.sendLogMessage('button_documentation_log_event', {
            stage: 'opened'
        });
        // we open the documentation taskpane
        props.setCurrOpenTaskpane({ type: _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_6__.TaskpaneType.DOCUMENTATION });
    };
    const openMerge = () => {
        // We turn off editing mode, if it is on
        props.setEditingMode(false, "", -1);
        // We open the merge taskpane
        props.setCurrOpenTaskpane({ type: _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_6__.TaskpaneType.MERGE });
    };
    const openPivotTable = () => {
        // We turn off editing mode, if it is on
        props.setEditingMode(false, "", -1);
        props.setCurrOpenTaskpane({ type: _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_6__.TaskpaneType.PIVOT });
    };
    const openDeleteColumn = () => {
        // We turn off editing mode, if it is on
        props.setEditingMode(false, "", -1);
        // we close the editing taskpane if its open
        props.closeOpenEditingPopups();
        // TODO: log here, and in all the rest of these functions
        props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_4__.ModalEnum.DeleteColumn, columnHeader: props.selectedColumn });
    };
    const openSave = () => {
        // We turn off editing mode, if it is on
        props.setEditingMode(false, "", -1);
        // we close the editing taskpane if its open
        props.closeOpenEditingPopups();
        props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_4__.ModalEnum.SaveAnalysis });
    };
    const openReplay = () => {
        // We turn off editing mode, if it is on
        props.setEditingMode(false, "", -1);
        // we close the editing taskpane if its open
        props.closeOpenEditingPopups();
        props.setCurrOpenTaskpane({ type: _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_6__.TaskpaneType.REPLAY_ANALYSIS });
    };
    const openImport = () => {
        // We turn off editing mode, if it is on
        props.setEditingMode(false, "", -1);
        // we close the editing taskpane if its open
        props.closeOpenEditingPopups();
        props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_4__.ModalEnum.Import });
    };
    const openSteps = () => {
        void props.mitoAPI.sendLogMessage('click_open_steps');
        props.setCurrOpenTaskpane({ type: _taskpanes_taskpanes__WEBPACK_IMPORTED_MODULE_6__.TaskpaneType.STEPS });
    };
    const fastForward = () => {
        // Fast forwards to the most recent step, allowing editing
        void props.mitoAPI.sendLogMessage('click_fast_forward');
        void props.mitoAPI.checkoutStepByIndex(props.numSteps - 1);
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'mito-toolbar-container' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'mito-toolbar-container-left' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'mito-toolbar-item vertical-align-content', onClick: undo },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_UndoIcon__WEBPACK_IMPORTED_MODULE_7__.default, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_5__.default, { tooltip: "Undo", style: { 'marginLeft': '-15px' } })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "vertical-line mt-1" }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'mito-toolbar-item vertical-align-content', id: 'tour-import-button-id', onClick: openImport },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_ImportIcon__WEBPACK_IMPORTED_MODULE_8__.default, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_5__.default, { tooltip: "Import Data" })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'mito-toolbar-item vertical-align-content', onClick: downloadAnalysis },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_ExportIcon__WEBPACK_IMPORTED_MODULE_9__.default, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_5__.default, { tooltip: "Download Sheet" })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "vertical-line mt-1" }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'mito-toolbar-item vertical-align-content', onClick: addColumn },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_AddColumnIcon__WEBPACK_IMPORTED_MODULE_15__.default, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_5__.default, { tooltip: "Add Column" })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'mito-toolbar-item vertical-align-content', onClick: openDeleteColumn },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_DeleteColumnIcon__WEBPACK_IMPORTED_MODULE_14__.default, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_5__.default, { tooltip: "Delete Column" })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "vertical-line mt-1" }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'mito-toolbar-item', onClick: openPivotTable },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_PivotIcon__WEBPACK_IMPORTED_MODULE_13__.default, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_5__.default, { tooltip: "Pivot Table" })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'mito-toolbar-item', onClick: openMerge },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_MergeIcon__WEBPACK_IMPORTED_MODULE_12__.default, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_5__.default, { tooltip: "Merge" })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "vertical-line mt-1" }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'mito-toolbar-item', onClick: openSave },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_SaveIcon__WEBPACK_IMPORTED_MODULE_11__.default, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_5__.default, { tooltip: "Save" })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'mito-toolbar-item', onClick: openReplay },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_ReplayIcon__WEBPACK_IMPORTED_MODULE_10__.default, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_5__.default, { tooltip: "Repeat Saved Analysis" }))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'mito-toolbar-container-right mr-1' },
            props.currStepIdx !== props.numSteps - 1 &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'mito-toolbar-item', onClick: fastForward },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_FastForwardIcon__WEBPACK_IMPORTED_MODULE_19__.default, null),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_5__.default, { tooltip: "Fast forward to apply all steps" })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'mito-toolbar-item', onClick: openSteps },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_StepsIcon__WEBPACK_IMPORTED_MODULE_18__.default, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_5__.default, { tooltip: "Step History" })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'mito-toolbar-item', onClick: openDocumentation },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_DocumentationIcon__WEBPACK_IMPORTED_MODULE_16__.default, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_5__.default, { tooltip: "Documentation" })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'mito-toolbar-item', onClick: toggleFullscreen },
                fullscreen &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_FullscreenIcons__WEBPACK_IMPORTED_MODULE_17__.CloseFullscreenIcon, null),
                !fullscreen &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_FullscreenIcons__WEBPACK_IMPORTED_MODULE_17__.OpenFullscreenIcon, null),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_5__.default, { tooltip: fullscreen ? "Close Full Screen" : "Full Screen", style: { 'marginLeft': '-80.5px' } })))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MitoToolbar);


/***/ }),

/***/ "./lib/components/Tooltip.js":
/*!***********************************!*\
  !*** ./lib/components/Tooltip.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Tooltip)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);

function Tooltip(props) {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "tooltip", style: props.style }, props.tooltip));
}


/***/ }),

/***/ "./lib/components/editor/DocumentationBox.js":
/*!***************************************************!*\
  !*** ./lib/components/editor/DocumentationBox.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_documentation_box_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../css/documentation-box.css */ "./css/documentation-box.css");
/* harmony import */ var _css_documentation_box_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_documentation_box_css__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


/*
  The documentation box displays instructions on how to use
  a function beneath the cell editor.
*/
const DocumentationBox = (props) => {
    var _a;
    const examples = (_a = props.funcDocObject.examples) === null || _a === void 0 ? void 0 : _a.map((example) => {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-box-example', key: example }, example));
    });
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-box-container' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-box-syntax' }, props.funcDocObject.syntax),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-box-description' }, props.funcDocObject.description),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-box-example-header' }, "Examples"),
        examples));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DocumentationBox);


/***/ }),

/***/ "./lib/components/editor/SuggestionBox.js":
/*!************************************************!*\
  !*** ./lib/components/editor/SuggestionBox.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_suggestion_box_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../css/suggestion-box.css */ "./css/suggestion-box.css");
/* harmony import */ var _css_suggestion_box_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_suggestion_box_css__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


/*
  The suggestion box suggests functions that you could be trying to
  type, beneath the cell editor.
*/
const SuggestionBox = (props) => {
    const selectedIndex = props.index % props.suggestions.length;
    const functionMatchesDivs = props.suggestions.map((suggestionObject, idx) => {
        const restOfSuggestion = suggestionObject.suggestion.substr(suggestionObject.match.length);
        if (idx === selectedIndex) {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: suggestionObject.suggestion, onMouseEnter: () => props.onMouseEnterSuggestion(idx), onClick: () => { props.onSelectSuggestion(suggestionObject.match, restOfSuggestion, suggestionObject.type); } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'suggestion-box-selected-function' }, suggestionObject.suggestion),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'suggestion-box-selected-description' }, suggestionObject.subtitle)));
        }
        else {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'suggestion-box-function', key: suggestionObject.suggestion, onMouseEnter: () => props.onMouseEnterSuggestion(idx), onClick: () => { props.onSelectSuggestion(suggestionObject.match, restOfSuggestion, suggestionObject.type); } }, suggestionObject.suggestion));
        }
    });
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'suggestion-box-container' }, functionMatchesDivs));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SuggestionBox);


/***/ }),

/***/ "./lib/components/elements/CustomDropdown.js":
/*!***************************************************!*\
  !*** ./lib/components/elements/CustomDropdown.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_custom_dropdown_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../css/custom-dropdown.css */ "./css/custom-dropdown.css");
/* harmony import */ var _css_custom_dropdown_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_custom_dropdown_css__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


// Adapted from https://stackoverflow.com/questions/54560790/detect-click-outside-react-component-using-hooks
function useComponentVisible(closeDropdown) {
    const ref = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    const handleClickOutside = (event) => {
        // We check if the current click is outside the element, and call close if so
        if (ref.current && !ref.current.contains(event.target)) {
            /*
                We delay actually closing by 100 seconds, just in case the user has clicked
                outside the dropdown, but on the button that closes the dropdown itself. This
                makes sure that we don't close and then immediately reopen the component.

                It is an ugly hack, but it appears to work for now!
            */
            setTimeout(() => {
                closeDropdown();
            }, 100);
        }
    };
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        document.addEventListener('click', handleClickOutside, true);
        return () => {
            document.removeEventListener('click', handleClickOutside, true);
        };
    });
    return { ref };
}
/*
    A custom dropdown item that performs similarly to a select, in that
    when it is displayed, if the user clicks anywhere other than selecting
    one of the options, it will close.

    SOME NOTES:
    1. Currently, the way that this is placed is very manual, and won't work
       when this component will need to be reused. We'll have to make it's
       placement a parameter to this component!
    2. The div that this CustomDropdown is a child of must have non-static positioning,
       so that this will scroll with it!
*/
function CustomDropdown(props) {
    const { ref } = useComponentVisible(props.closeDropdown);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'custom-dropdown', ref: ref }, props.children)));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CustomDropdown);


/***/ }),

/***/ "./lib/components/elements/LargeSelect.js":
/*!************************************************!*\
  !*** ./lib/components/elements/LargeSelect.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_large_select_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../css/large-select.css */ "./css/large-select.css");
/* harmony import */ var _css_large_select_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_large_select_css__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


/*
  A custom select dropdown component created for use in the default taskpane
  The Large Select element is wider than the Small Select element
*/
const LargeSelect = (props) => {
    const optionsElements = [];
    props.optionsArray.forEach((option) => {
        if (typeof option === 'string') {
            optionsElements.push((react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { value: option, key: option }, option)));
        }
        else {
            optionsElements.push(option);
        }
    });
    const className = !props.extraLarge ? 'select large-select' : 'select extra-large-select';
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("select", { className: className, value: props.startingValue, onChange: (e) => props.setValue(e.target.value) }, optionsElements)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LargeSelect);


/***/ }),

/***/ "./lib/components/elements/LargeSelects.js":
/*!*************************************************!*\
  !*** ./lib/components/elements/LargeSelects.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _LargeSelect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./LargeSelect */ "./lib/components/elements/LargeSelect.js");
/* harmony import */ var _css_large_select_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../css/large-select.css */ "./css/large-select.css");
/* harmony import */ var _css_large_select_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_large_select_css__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.



/*
  An element that allows you to create mulitple large selects, all with the same options
  and the same starting value.
*/
const LargeSelects = (props) => {
    const largeSelects = [];
    for (let i = 0; i < props.numSelects; i++) {
        largeSelects.push((react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_LargeSelect__WEBPACK_IMPORTED_MODULE_1__.default, { key: i, startingValue: props.startingValue, optionsArray: props.optionsArray, setValue: (value) => { props.setValue(i, value); }, extraLarge: props.extraLarge })));
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, largeSelects));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (LargeSelects);


/***/ }),

/***/ "./lib/components/elements/MultiToggleBox.js":
/*!***************************************************!*\
  !*** ./lib/components/elements/MultiToggleBox.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_mutli_toggle_box_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../css/mutli-toggle-box.css */ "./css/mutli-toggle-box.css");
/* harmony import */ var _css_mutli_toggle_box_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_mutli_toggle_box_css__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


/*
  A box that contains a variety of options that can be toggled on and off indivigually.
  
  If optional toggleAllOptions are passed, then a Toggle All button is also displayed
  that toggles all the buttons at once.
*/
const MultiToggleBox = (props) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'multi-toggle-box' },
        props.toggleAllOptions !== undefined &&
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: 'Toggle All' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { key: 'Toggle All', type: "checkbox", name: 'Toggle All', checked: props.toggleAllOptions.currentToggleAllState, onChange: props.toggleAllOptions.toggleAll, className: "form-check-input" }),
                "Toggle All"),
        props.itemsArray.map((item, index) => {
            const currentToggle = props.itemToggleState[index];
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: item },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { key: item, type: "checkbox", name: item, checked: currentToggle, onChange: () => { props.toggleItemAtIndex(index); }, className: "form-check-input" }),
                item));
        })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MultiToggleBox);


/***/ }),

/***/ "./lib/components/elements/SmallSelect.js":
/*!************************************************!*\
  !*** ./lib/components/elements/SmallSelect.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TitleColor": () => (/* binding */ TitleColor),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_small_select_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../css/small-select.css */ "./css/small-select.css");
/* harmony import */ var _css_small_select_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_small_select_css__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


/*
  A custom select dropdown component created for use in the default taskpane
*/
var TitleColor;
(function (TitleColor) {
    TitleColor["BLUE"] = "#0081DE";
    TitleColor["DARK"] = "#343434";
})(TitleColor || (TitleColor = {}));
const SmallSelect = (props) => {
    const optionsElements = [];
    props.optionsArray.forEach(option => {
        optionsElements.push((react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { value: option, key: option }, option)));
    });
    /*
        NOTE: because the starting value is not selectable, make sure if its an actual
        option that you want to be selected by default that you elsewhere set the startingValue
        to be selected.

        we use this because in the pivot table screen, we want to be able to have the select dropdown
        default to the title 'add' which is not an aggregation method so should not be able to be clicked.
    */
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("select", { className: 'small-select', value: props.startingValue, style: { color: props.titleColor }, onChange: (e) => props.setValue(e.target.value) },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { selected: true, hidden: true }, props.startingValue),
            optionsElements)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SmallSelect);


/***/ }),

/***/ "./lib/components/elements/TopLeftPopup.js":
/*!*************************************************!*\
  !*** ./lib/components/elements/TopLeftPopup.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_top_left_popup_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../css/top-left-popup.css */ "./css/top-left-popup.css");
/* harmony import */ var _css_top_left_popup_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_top_left_popup_css__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// import css

/*
    A small upper-left modal that displays a message to the user
    so they know what's going on
*/
const TopLeftPopup = (props) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'top-left-popup-container' }, props.message));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TopLeftPopup);


/***/ }),

/***/ "./lib/components/icons/AddColumnIcon.js":
/*!***********************************************!*\
  !*** ./lib/components/icons/AddColumnIcon.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const AddColumnIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "22", height: "30", viewBox: "0 0 8 12", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M6.45456 1V2.81818", stroke: "#343434", strokeWidth: "0.6", strokeLinecap: "round" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M7.36365 1.90909L5.54547 1.90909", stroke: "#343434", strokeWidth: "0.6", strokeLinecap: "round" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M6.45455 4.18182V6.90909V10.5455C6.45455 10.7965 6.25104 11 6 11H1.45455C1.20351 11 1 10.7965 1 10.5455V1.45455C1 1.20351 1.20351 1 1.45455 1H4.8961", stroke: "#343434", strokeWidth: "0.6" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "1", y: "4.63635", width: "5.45455", height: "3.63636", fill: "#343434", fillOpacity: "0.19" })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AddColumnIcon);


/***/ }),

/***/ "./lib/components/icons/DeleteColumnIcon.js":
/*!**************************************************!*\
  !*** ./lib/components/icons/DeleteColumnIcon.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const DeleteColumnIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "20", height: "28", viewBox: "0 0 7 11", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M5.99142 10.75H1.0641C0.956936 10.75 0.867939 10.6673 0.860102 10.5604L0.285102 2.7195C0.276409 2.60096 0.370239 2.5 0.489099 2.5H6.51414C6.63246 2.5 6.72611 2.60009 6.71823 2.71815L6.19551 10.5591C6.18834 10.6665 6.0991 10.75 5.99142 10.75Z", stroke: "#343434", strokeWidth: "0.6" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M1.60416 2.41164V1.375V0.733332H5.45416V2.41165", stroke: "#343434", strokeWidth: "0.6", strokeLinecap: "round", strokeLinejoin: "round" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M2.56668 4.58334L2.5666 8.43335", stroke: "#343434", strokeWidth: "0.6", strokeLinecap: "round", strokeLinejoin: "round" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M4.49167 4.58334L4.49158 8.43335", stroke: "#343434", strokeWidth: "0.6", strokeLinecap: "round", strokeLinejoin: "round" })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DeleteColumnIcon);


/***/ }),

/***/ "./lib/components/icons/DocumentationIcon.js":
/*!***************************************************!*\
  !*** ./lib/components/icons/DocumentationIcon.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const DocumentationIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "25", height: "25", viewBox: "0 0 14 14", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", { cx: "7", cy: "7", r: "6.75", stroke: "#404040", strokeWidth: "0.6" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M7.27173 8.43865C7.2624 8.34531 7.2624 8.30798 7.2624 8.26131C7.2624 7.89731 7.38373 7.56131 7.67307 7.36531L8.1024 7.07598C8.64373 6.71198 9.0544 6.19865 9.0544 5.45198C9.0544 4.49998 8.31707 3.57598 7.0104 3.57598C5.57307 3.57598 4.94773 4.63065 4.94773 5.48931C4.94773 5.65731 4.9664 5.80665 5.00373 5.93731L5.90907 6.04931C5.87173 5.94665 5.84373 5.75065 5.84373 5.59198C5.84373 5.00398 6.1984 4.39731 7.0104 4.39731C7.75707 4.39731 8.12107 4.91065 8.12107 5.46131C8.12107 5.82531 7.94373 6.16131 7.6264 6.37598L7.21573 6.65598C6.66507 7.02931 6.44107 7.49598 6.44107 8.11198C6.44107 8.23331 6.44107 8.32665 6.4504 8.43865H7.27173ZM6.24507 9.77331C6.24507 10.1093 6.51573 10.38 6.85173 10.38C7.18773 10.38 7.46773 10.1093 7.46773 9.77331C7.46773 9.43731 7.18773 9.15731 6.85173 9.15731C6.51573 9.15731 6.24507 9.43731 6.24507 9.77331Z", fill: "#343434" })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DocumentationIcon);


/***/ }),

/***/ "./lib/components/icons/DropdownIcon.js":
/*!**********************************************!*\
  !*** ./lib/components/icons/DropdownIcon.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const DropdownIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "20", height: "16", viewBox: "0 0 4 16", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", { cx: "2", cy: "2", r: "2", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", { cx: "2", cy: "8", r: "2", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", { cx: "2", cy: "14", r: "2", fill: "#343434" })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DropdownIcon);


/***/ }),

/***/ "./lib/components/icons/EditIcon.js":
/*!******************************************!*\
  !*** ./lib/components/icons/EditIcon.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const EditIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "25", height: "25", viewBox: "0 0 13 15", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "8.67323", y: "2.56851", width: "2.27778", height: "9.93478", transform: "rotate(36.5296 8.67323 2.56851)", stroke: "black", strokeWidth: "0.5" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "0.349697", y: "-0.0520781", width: "2.27778", height: "2.1087", transform: "matrix(0.80355 0.595237 0.595237 -0.80355 8.33261 2.44081)", stroke: "black", strokeWidth: "0.5" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M1.9732 13.5266L4.22513 12.7599L2.05046 11.149L1.9732 13.5266Z", fill: "black" })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EditIcon);


/***/ }),

/***/ "./lib/components/icons/ExportIcon.js":
/*!********************************************!*\
  !*** ./lib/components/icons/ExportIcon.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const ExportIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "25", height: "25", viewBox: "0 0 7 9", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M3.51321 7.75887L3.51321 0.999992", stroke: "#343434", strokeWidth: "0.6", strokeLinecap: "round" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M6.83495 4.94249C6.93049 4.84281 6.92714 4.68456 6.82747 4.58901C6.72779 4.49347 6.56953 4.49682 6.47399 4.5965L6.83495 4.94249ZM3.55788 8.00002L3.37987 8.17556C3.42729 8.22364 3.49213 8.25049 3.55965 8.25001C3.62717 8.24953 3.69163 8.22176 3.73836 8.17301L3.55788 8.00002ZM0.54999 4.59395C0.45304 4.49564 0.294753 4.49454 0.196445 4.59149C0.0981369 4.68844 0.0970358 4.84673 0.193985 4.94503L0.54999 4.59395ZM6.47399 4.5965L3.3774 7.82702L3.73836 8.17301L6.83495 4.94249L6.47399 4.5965ZM3.73588 7.82447L0.54999 4.59395L0.193985 4.94503L3.37987 8.17556L3.73588 7.82447Z", fill: "#343434" })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ExportIcon);


/***/ }),

/***/ "./lib/components/icons/FastForwardIcon.js":
/*!*************************************************!*\
  !*** ./lib/components/icons/FastForwardIcon.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const FastForwardIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "17", height: "18", viewBox: "0 0 17 18", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M15.5287 8.49001C15.7643 8.68971 15.7643 9.05315 15.5287 9.25285L7.73774 15.8565C7.41286 16.1319 6.91444 15.9009 6.91444 15.4751V2.26779C6.91444 1.84191 7.41286 1.611 7.73774 1.88637L15.5287 8.49001Z", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M8.61439 8.49C8.85 8.6897 8.85 9.05314 8.61439 9.25284L0.823399 15.8565C0.49852 16.1318 0.000106812 15.9009 0.000106812 15.4751V2.26778C0.000106812 1.8419 0.498521 1.61099 0.8234 1.88636L8.61439 8.49Z", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "15.0001", y: "2", width: "2", height: "14", rx: "0.5", fill: "#343434" })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FastForwardIcon);


/***/ }),

/***/ "./lib/components/icons/FilterIcons.js":
/*!*********************************************!*\
  !*** ./lib/components/icons/FilterIcons.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "FilterEmptyIcon": () => (/* binding */ FilterEmptyIcon),
/* harmony export */   "FilterNonEmptyIcon": () => (/* binding */ FilterNonEmptyIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const FilterEmptyIcon = (props) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: props.width || "13", height: props.height || "10", viewBox: "0 0 9 7", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M3.63486 6.75C3.49679 6.75 3.38486 6.63807 3.38486 6.5V4.18709C3.38486 4.00613 3.31943 3.83127 3.20064 3.69476L0.781003 0.91411C0.640219 0.75232 0.755131 0.5 0.969598 0.5L8.30011 0.5C8.51458 0.5 8.62949 0.75232 8.48871 0.91411L6.06907 3.69476C5.95028 3.83127 5.88486 4.00613 5.88486 4.18709L5.88486 6.5C5.88486 6.63807 5.77293 6.75 5.63486 6.75H3.63486Z", stroke: "#343434", strokeWidth: "0.5" })));
};
const FilterNonEmptyIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "13", height: "10", viewBox: "0 0 9 7", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M3.63481 6.75C3.49674 6.75 3.38481 6.63807 3.38481 6.5V4.18709C3.38481 4.00613 3.31939 3.83127 3.2006 3.69476L0.780957 0.91411C0.640173 0.75232 0.755085 0.5 0.969552 0.5L8.30007 0.5C8.51453 0.5 8.62945 0.75232 8.48866 0.91411L6.06903 3.69476C5.95024 3.83127 5.88481 4.00613 5.88481 4.18709L5.88481 6.5C5.88481 6.63807 5.77288 6.75 5.63481 6.75H3.63481Z", fill: "#0081DE", stroke: "#343434", strokeWidth: "0.5" })));
};


/***/ }),

/***/ "./lib/components/icons/FullscreenIcons.js":
/*!*************************************************!*\
  !*** ./lib/components/icons/FullscreenIcons.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OpenFullscreenIcon": () => (/* binding */ OpenFullscreenIcon),
/* harmony export */   "CloseFullscreenIcon": () => (/* binding */ CloseFullscreenIcon)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const OpenFullscreenIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "25", height: "25", viewBox: "0 0 14 14", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M13.3141 1.00002C13.3141 0.834334 13.1798 0.700019 13.0141 0.70002L10.3141 0.700019C10.1484 0.70002 10.0141 0.834334 10.0141 1.00002C10.0141 1.1657 10.1484 1.30002 10.3141 1.30002H12.7141V3.70002C12.7141 3.8657 12.8484 4.00002 13.0141 4.00002C13.1798 4.00002 13.3141 3.86571 13.3141 3.70002L13.3141 1.00002ZM8.07966 6.35874L13.2262 1.21215L12.802 0.787887L7.65539 5.93447L8.07966 6.35874Z", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M0.799699 13.105C0.80268 13.2707 0.939389 13.4026 1.10505 13.3996L3.80461 13.351C3.97027 13.348 4.10215 13.2113 4.09916 13.0457C4.09618 12.88 3.95947 12.7481 3.79382 12.7511L1.3942 12.7943L1.35103 10.3947C1.34805 10.229 1.21134 10.0971 1.04568 10.1001C0.880021 10.1031 0.748145 10.2398 0.751125 10.4055L0.799699 13.105ZM5.93609 7.65384L0.883736 12.8913L1.31556 13.3079L6.36792 8.0704L5.93609 7.65384Z", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M13.1141 13.2999C13.2798 13.2997 13.4139 13.1652 13.4137 12.9995L13.4105 10.2995C13.4103 10.1338 13.2759 9.99968 13.1102 9.99987C12.9445 10.0001 12.8103 10.1345 12.8105 10.3002L12.8134 12.7002L10.4134 12.7031C10.2477 12.7033 10.1135 12.8377 10.1137 13.0034C10.1139 13.1691 10.2484 13.3033 10.4141 13.3031L13.1141 13.2999ZM7.74918 8.07176L12.9019 13.2123L13.3256 12.7875L8.17294 7.64699L7.74918 8.07176Z", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M0.994269 0.799772C0.828614 0.802948 0.696899 0.939813 0.700076 1.10547L0.751844 3.80497C0.755021 3.97063 0.891886 4.10234 1.05754 4.09916C1.2232 4.09599 1.35491 3.95912 1.35173 3.79347L1.30572 1.39391L3.70528 1.34789C3.87093 1.34472 4.00265 1.20785 3.99947 1.0422C3.99629 0.876542 3.85943 0.744827 3.69377 0.748004L0.994269 0.799772ZM6.45153 5.92971L1.20805 0.883556L0.791995 1.31588L6.03547 6.36203L6.45153 5.92971Z", fill: "#343434" })));
};
const CloseFullscreenIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "25", height: "25", viewBox: "0 0 16 16", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M9.69561 5.99947C9.69531 6.16516 9.82939 6.29971 9.99508 6.3L12.6951 6.30476C12.8608 6.30505 12.9953 6.17097 12.9956 6.00529C12.9959 5.8396 12.8618 5.70505 12.6961 5.70476L10.2961 5.70053L10.3004 3.30053C10.3007 3.13485 10.1666 3.0003 10.0009 3C9.83521 2.99971 9.70066 3.13379 9.70037 3.29948L9.69561 5.99947ZM13.798 1.78749L9.78385 5.78749L10.2074 6.21251L14.2215 2.21251L13.798 1.78749Z", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M6.29488 9.97918C6.28338 9.81389 6.14007 9.68923 5.97479 9.70072L3.2813 9.88809C3.11601 9.89959 2.99134 10.0429 3.00284 10.2082C3.01434 10.3735 3.15765 10.4981 3.32293 10.4866L5.71715 10.3201L5.8837 12.7143C5.8952 12.8796 6.03851 13.0043 6.2038 12.9928C6.36908 12.9813 6.49375 12.838 6.48225 12.6727L6.29488 9.97918ZM2.50897 14.4651L6.22195 10.1969L5.76926 9.8031L2.05628 14.0713L2.50897 14.4651Z", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M9.9883 9.70009C9.82266 9.70412 9.69166 9.84167 9.69569 10.0073L9.76146 12.7065C9.76549 12.8721 9.90304 13.0031 10.0687 12.9991C10.2343 12.9951 10.3653 12.8575 10.3613 12.6919L10.3028 10.2926L12.7021 10.2341C12.8677 10.2301 12.9988 10.0926 12.9947 9.92693C12.9907 9.76129 12.8531 9.63029 12.6875 9.63433L9.9883 9.70009ZM14.3578 13.7403L10.2025 9.78276L9.7887 10.2172L13.9439 14.1748L14.3578 13.7403Z", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M5.99905 6.29998C6.16473 6.29808 6.29749 6.16223 6.29559 5.99655L6.26456 3.29673C6.26266 3.13106 6.12681 2.99829 5.96113 3.0002C5.79546 3.0021 5.6627 3.13795 5.6646 3.30363L5.69218 5.70347L3.29234 5.73105C3.12666 5.73295 2.9939 5.8688 2.9958 6.03447C2.99771 6.20015 3.13356 6.33291 3.29923 6.33101L5.99905 6.29998ZM1.79032 2.30974L5.78592 6.21456L6.20529 5.78544L2.20968 1.88063L1.79032 2.30974Z", fill: "#343434" })));
};


/***/ }),

/***/ "./lib/components/icons/ImportIcon.js":
/*!********************************************!*\
  !*** ./lib/components/icons/ImportIcon.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const ImportIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "25", height: "25", viewBox: "0 0 7 9", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M3.48679 1.24113L3.48679 8.00001", stroke: "#343434", strokeWidth: "0.6", strokeLinecap: "round" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M0.165052 4.05751C0.069509 4.15719 0.0728591 4.31544 0.172534 4.41099C0.27221 4.50653 0.430465 4.50318 0.526009 4.4035L0.165052 4.05751ZM3.44212 0.999984L3.62013 0.824442C3.57271 0.776365 3.50787 0.749511 3.44035 0.749991C3.37283 0.75047 3.30837 0.778243 3.26164 0.826988L3.44212 0.999984ZM6.45001 4.40605C6.54696 4.50436 6.70525 4.50546 6.80356 4.40851C6.90186 4.31156 6.90296 4.15327 6.80601 4.05497L6.45001 4.40605ZM0.526009 4.4035L3.6226 1.17298L3.26164 0.826988L0.165052 4.05751L0.526009 4.4035ZM3.26412 1.17553L6.45001 4.40605L6.80601 4.05497L3.62013 0.824442L3.26412 1.17553Z", fill: "#343434" })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ImportIcon);


/***/ }),

/***/ "./lib/components/icons/MergeIcon.js":
/*!*******************************************!*\
  !*** ./lib/components/icons/MergeIcon.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const MergeIcon = (props) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: props.width || "40", height: "30", viewBox: "0 0 17 11", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M11.6467 5.12789C11.6467 7.78833 9.13157 10.0058 5.94835 10.0058C2.76513 10.0058 0.25 7.78833 0.25 5.12789C0.25 2.46744 2.76513 0.25 5.94835 0.25C9.13157 0.25 11.6467 2.46744 11.6467 5.12789Z", fill: "#C8C8C8", stroke: "#343434", strokeWidth: "0.6" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M16.4784 5.12789C16.4784 7.78833 13.9632 10.0058 10.78 10.0058C7.59679 10.0058 5.08167 7.78833 5.08167 5.12789C5.08167 2.46744 7.59679 0.25 10.78 0.25C13.9632 0.25 16.4784 2.46744 16.4784 5.12789Z", stroke: "#343434", strokeWidth: "0.6" })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MergeIcon);


/***/ }),

/***/ "./lib/components/icons/MitoIcon.js":
/*!******************************************!*\
  !*** ./lib/components/icons/MitoIcon.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const MitoIcon = (props) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: props.width || "25", height: props.height || "25", viewBox: "0 0 36 32", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M4.27806 14.4605C4.41192 13.3117 5.01895 12.0216 5.97434 10.7002C7.05826 9.20103 8.57046 7.68957 10.2741 6.33985C11.9773 4.99054 13.8647 3.80854 15.6941 2.96488C17.5272 2.11946 19.2841 1.62217 20.731 1.62217H20.8262L20.8973 1.55886C22.3577 0.258248 24.1677 0.253529 25.9155 1.11776C27.6712 1.98588 29.3356 3.7235 30.4197 5.84055C31.0401 7.05223 31.4658 8.37926 31.6121 9.72767C31.4497 10.4602 31.1397 11.1739 30.6606 11.8437C29.3761 13.639 26.8438 15.1631 22.5518 15.856L22.4863 15.8666L22.4347 15.9082C21.4334 16.7156 20.5213 17.566 19.6548 18.3822C19.5897 18.4435 19.5249 18.5047 19.4603 18.5656C18.6629 19.3172 17.9036 20.033 17.1378 20.6632C15.4886 22.0206 13.8431 22.9522 11.813 22.9575C7.78218 22.385 5.10127 18.758 4.27806 14.4605ZM8.07142 22.403C6.88109 21.2513 5.86085 19.9151 5.17471 18.5227C6.56859 21.1106 8.80658 23.0423 11.761 23.4551L11.7783 23.4575H11.7956C14.0044 23.4575 15.7662 22.4397 17.4555 21.0493C18.235 20.4078 19.0063 19.6806 19.8006 18.9319C19.8661 18.8701 19.9318 18.8082 19.9976 18.7462C20.8491 17.9441 21.7325 17.1207 22.6972 16.339C27.0236 15.6292 29.6835 14.0688 31.0672 12.1346C31.3017 11.8069 31.4986 11.4697 31.6603 11.1258C31.6376 11.6681 31.5653 12.2087 31.4378 12.7414C30.8855 15.0491 29.2908 17.2422 26.141 18.8137C25.1942 19.2071 24.2969 19.8633 23.4233 20.6105C22.8835 21.0722 22.3406 21.5797 21.7977 22.0873C21.4643 22.399 21.131 22.7107 20.7983 23.0118C19.0215 24.6198 17.2161 25.9694 15.1112 25.9694C12.9939 25.9694 10.2755 24.5356 8.07142 22.403ZM31.7045 7.69414C31.4887 6.97391 31.204 6.27528 30.8647 5.61267C29.932 3.7912 28.5772 2.22312 27.0733 1.21431C27.108 1.23321 27.1426 1.25235 27.1771 1.27174C29.0479 2.32337 30.567 4.0771 31.291 6.01628C31.4961 6.56563 31.6371 7.12861 31.7045 7.69414ZM10.479 5.54883C12.213 4.17852 14.1208 2.97754 15.9474 2.1189C17.788 1.25371 19.5255 0.745911 20.9111 0.745911H20.9596L21.0046 0.727788C21.1373 0.67428 21.2705 0.625511 21.4039 0.58136C21.1408 0.730055 20.8844 0.909881 20.6364 1.12282C19.1081 1.14374 17.3123 1.66796 15.4847 2.51083C13.799 3.28822 12.0713 4.34354 10.479 5.54883Z", fill: "#00090F" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M4.27806 14.4605C4.41192 13.3117 5.01895 12.0216 5.97434 10.7002C7.05826 9.20103 8.57046 7.68957 10.2741 6.33985C11.9773 4.99054 13.8647 3.80854 15.6941 2.96488C17.5272 2.11946 19.2841 1.62217 20.731 1.62217H20.8262L20.8973 1.55886C22.3577 0.258248 24.1677 0.253529 25.9155 1.11776C27.6712 1.98588 29.3356 3.7235 30.4197 5.84055C31.0401 7.05223 31.4658 8.37926 31.6121 9.72767C31.4497 10.4602 31.1397 11.1739 30.6606 11.8437C29.3761 13.639 26.8438 15.1631 22.5518 15.856L22.4863 15.8666L22.4347 15.9082C21.4334 16.7156 20.5213 17.566 19.6548 18.3822C19.5897 18.4435 19.5249 18.5047 19.4603 18.5656C18.6629 19.3172 17.9036 20.033 17.1378 20.6632C15.4886 22.0206 13.8431 22.9522 11.813 22.9575C7.78218 22.385 5.10127 18.758 4.27806 14.4605ZM8.07142 22.403C6.88109 21.2513 5.86085 19.9151 5.17471 18.5227C6.56859 21.1106 8.80658 23.0423 11.761 23.4551L11.7783 23.4575H11.7956C14.0044 23.4575 15.7662 22.4397 17.4555 21.0493C18.235 20.4078 19.0063 19.6806 19.8006 18.9319C19.8661 18.8701 19.9318 18.8082 19.9976 18.7462C20.8491 17.9441 21.7325 17.1207 22.6972 16.339C27.0236 15.6292 29.6835 14.0688 31.0672 12.1346C31.3017 11.8069 31.4986 11.4697 31.6603 11.1258C31.6376 11.6681 31.5653 12.2087 31.4378 12.7414C30.8855 15.0491 29.2908 17.2422 26.141 18.8137C25.1942 19.2071 24.2969 19.8633 23.4233 20.6105C22.8835 21.0722 22.3406 21.5797 21.7977 22.0873C21.4643 22.399 21.131 22.7107 20.7983 23.0118C19.0215 24.6198 17.2161 25.9694 15.1112 25.9694C12.9939 25.9694 10.2755 24.5356 8.07142 22.403ZM31.7045 7.69414C31.4887 6.97391 31.204 6.27528 30.8647 5.61267C29.932 3.7912 28.5772 2.22312 27.0733 1.21431C27.108 1.23321 27.1426 1.25235 27.1771 1.27174C29.0479 2.32337 30.567 4.0771 31.291 6.01628C31.4961 6.56563 31.6371 7.12861 31.7045 7.69414ZM10.479 5.54883C12.213 4.17852 14.1208 2.97754 15.9474 2.1189C17.788 1.25371 19.5255 0.745911 20.9111 0.745911H20.9596L21.0046 0.727788C21.1373 0.67428 21.2705 0.625511 21.4039 0.58136C21.1408 0.730055 20.8844 0.909881 20.6364 1.12282C19.1081 1.14374 17.3123 1.66796 15.4847 2.51083C13.799 3.28822 12.0713 4.34354 10.479 5.54883Z", fill: "url(#paint0_linear)" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M4.27806 14.4605C4.41192 13.3117 5.01895 12.0216 5.97434 10.7002C7.05826 9.20103 8.57046 7.68957 10.2741 6.33985C11.9773 4.99054 13.8647 3.80854 15.6941 2.96488C17.5272 2.11946 19.2841 1.62217 20.731 1.62217H20.8262L20.8973 1.55886C22.3577 0.258248 24.1677 0.253529 25.9155 1.11776C27.6712 1.98588 29.3356 3.7235 30.4197 5.84055C31.0401 7.05223 31.4658 8.37926 31.6121 9.72767C31.4497 10.4602 31.1397 11.1739 30.6606 11.8437C29.3761 13.639 26.8438 15.1631 22.5518 15.856L22.4863 15.8666L22.4347 15.9082C21.4334 16.7156 20.5213 17.566 19.6548 18.3822C19.5897 18.4435 19.5249 18.5047 19.4603 18.5656C18.6629 19.3172 17.9036 20.033 17.1378 20.6632C15.4886 22.0206 13.8431 22.9522 11.813 22.9575C7.78218 22.385 5.10127 18.758 4.27806 14.4605ZM8.07142 22.403C6.88109 21.2513 5.86085 19.9151 5.17471 18.5227C6.56859 21.1106 8.80658 23.0423 11.761 23.4551L11.7783 23.4575H11.7956C14.0044 23.4575 15.7662 22.4397 17.4555 21.0493C18.235 20.4078 19.0063 19.6806 19.8006 18.9319C19.8661 18.8701 19.9318 18.8082 19.9976 18.7462C20.8491 17.9441 21.7325 17.1207 22.6972 16.339C27.0236 15.6292 29.6835 14.0688 31.0672 12.1346C31.3017 11.8069 31.4986 11.4697 31.6603 11.1258C31.6376 11.6681 31.5653 12.2087 31.4378 12.7414C30.8855 15.0491 29.2908 17.2422 26.141 18.8137C25.1942 19.2071 24.2969 19.8633 23.4233 20.6105C22.8835 21.0722 22.3406 21.5797 21.7977 22.0873C21.4643 22.399 21.131 22.7107 20.7983 23.0118C19.0215 24.6198 17.2161 25.9694 15.1112 25.9694C12.9939 25.9694 10.2755 24.5356 8.07142 22.403ZM31.7045 7.69414C31.4887 6.97391 31.204 6.27528 30.8647 5.61267C29.932 3.7912 28.5772 2.22312 27.0733 1.21431C27.108 1.23321 27.1426 1.25235 27.1771 1.27174C29.0479 2.32337 30.567 4.0771 31.291 6.01628C31.4961 6.56563 31.6371 7.12861 31.7045 7.69414ZM10.479 5.54883C12.213 4.17852 14.1208 2.97754 15.9474 2.1189C17.788 1.25371 19.5255 0.745911 20.9111 0.745911H20.9596L21.0046 0.727788C21.1373 0.67428 21.2705 0.625511 21.4039 0.58136C21.1408 0.730055 20.8844 0.909881 20.6364 1.12282C19.1081 1.14374 17.3123 1.66796 15.4847 2.51083C13.799 3.28822 12.0713 4.34354 10.479 5.54883Z", stroke: "black", strokeWidth: "0.5" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { filter: "url(#filter0_d)" },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M22.5916 16.1028C18.6195 19.3058 16.0425 23.2075 11.7956 23.2075C7.55216 22.6146 4.79526 18.7684 4 14.3321C4 8.89088 15.1567 0.495911 20.9111 0.495911C29.6603 -3.03026 39.906 13.3076 22.5916 16.1028Z", fill: "#4FBFE8" }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M22.5518 15.856L22.4863 15.8666L22.4347 15.9082C21.4334 16.7156 20.5213 17.566 19.6548 18.3822C19.5897 18.4435 19.5249 18.5046 19.4603 18.5655C18.663 19.3171 17.9036 20.0329 17.1378 20.6632C15.4886 22.0206 13.8431 22.9522 11.813 22.9575C7.73525 22.3784 5.03904 18.6732 4.25006 14.3102C4.25756 13.0333 4.91743 11.5494 6.03489 10.0223C7.15426 8.49265 8.71139 6.94887 10.4529 5.56953C12.1938 4.19062 14.1116 2.98186 15.9474 2.1189C17.788 1.25371 19.5255 0.745911 20.9111 0.745911H20.9596L21.0046 0.727787C23.1081 -0.119971 25.3091 0.221693 27.1771 1.27174C29.0479 2.32337 30.567 4.0771 31.291 6.01628C32.0133 7.95094 31.9406 10.0545 30.6606 11.8437C29.3761 13.639 26.8438 15.1631 22.5518 15.856Z", stroke: "#0A0A0A", strokeWidth: "0.5" })),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("defs", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("filter", { id: "filter0_d", x: "0", y: "0", width: "36", height: "31.2075", filterUnits: "userSpaceOnUse", colorInterpolationFilters: "sRGB" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("feFlood", { floodOpacity: "0", result: "BackgroundImageFix" }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("feColorMatrix", { in: "SourceAlpha", type: "matrix", values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 127 0" }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("feOffset", { dy: "4" }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("feGaussianBlur", { stdDeviation: "2" }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("feColorMatrix", { type: "matrix", values: "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0.25 0" }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("feBlend", { mode: "normal", in2: "BackgroundImageFix", result: "effect1_dropShadow" }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("feBlend", { mode: "normal", in: "SourceGraphic", in2: "effect1_dropShadow", result: "shape" })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("linearGradient", { id: "paint0_linear", x1: "24.6767", y1: "23.0067", x2: "-1.7759", y2: "-21.8983", gradientUnits: "userSpaceOnUse" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("stop", { stopColor: "#D17485" }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("stop", { offset: "1", stopColor: "white", stopOpacity: "0" })))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MitoIcon);


/***/ }),

/***/ "./lib/components/icons/PivotIcon.js":
/*!*******************************************!*\
  !*** ./lib/components/icons/PivotIcon.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const PivotIcon = (props) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: props.width || "30", height: "30", viewBox: "0 0 15 15", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "1.25", y: "8.25", width: "5.5", height: "5.5", rx: "0.75", stroke: "#343434", strokeWidth: "0.6" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "1.25", y: "1.25", width: "5.5", height: "5.5", rx: "0.75", stroke: "#343434", strokeWidth: "0.6" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "8.25", y: "8.25", width: "5.5", height: "5.5", rx: "0.75", stroke: "#343434", strokeWidth: "0.6" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "8.25", y: "1.25", width: "5.5", height: "5.5", rx: "0.75", stroke: "#343434", strokeWidth: "0.6" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", { cx: "3", cy: "3", r: "1", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("circle", { cx: "5", cy: "5", r: "1", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M9.49994 2.49992L9.49992 5.5M12.5 2.5L12.4999 5.50008M10.9999 2.50014L10.9999 5.50022", stroke: "#343434", strokeWidth: "0.6" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M5.63898 9.5L2.32331 9.5M5.63901 12.3181L3.97868 12.3182L2.31834 12.3183M5.63898 10.8809L2.31834 10.8809", stroke: "#343434", strokeWidth: "0.6" })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PivotIcon);


/***/ }),

/***/ "./lib/components/icons/ReplayIcon.js":
/*!********************************************!*\
  !*** ./lib/components/icons/ReplayIcon.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const ReplayIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "30", height: "30", viewBox: "0 0 14 11", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M0.799219 8.65346C0.713311 8.76181 0.733559 8.91606 0.844444 8.99798C0.955329 9.07989 1.11486 9.05846 1.20077 8.95011L0.799219 8.65346ZM2.65464 6.71478L2.788 6.50394C2.6775 6.4392 2.53338 6.46616 2.45387 6.56645L2.65464 6.71478ZM4.9951 8.37511C5.11448 8.44506 5.27096 8.40737 5.34461 8.29093C5.41825 8.17449 5.38118 8.02339 5.2618 7.95344L4.9951 8.37511ZM1.20077 8.95011L2.85542 6.8631L2.45387 6.56645L0.799219 8.65346L1.20077 8.95011ZM2.52129 6.92561L4.9951 8.37511L5.2618 7.95344L2.788 6.50394L2.52129 6.92561Z", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M11.6906 5.95284C11.6906 8.39554 9.58876 10.3757 6.99598 10.3757C4.89389 10.3757 3.09822 8.79442 2.5 7", stroke: "#343434", strokeWidth: "0.6" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M13.2008 2.80751C13.2867 2.69916 13.2664 2.54491 13.1556 2.46299C13.0447 2.38107 12.8851 2.40251 12.7992 2.51086L13.2008 2.80751ZM11.3454 4.74619L11.212 4.95702C11.3225 5.02177 11.4666 4.99481 11.5461 4.89451L11.3454 4.74619ZM9.0049 3.08586C8.88552 3.01591 8.72904 3.0536 8.65539 3.17004C8.58175 3.28648 8.61882 3.43758 8.7382 3.50753L9.0049 3.08586ZM12.7992 2.51086L11.1446 4.59786L11.5461 4.89451L13.2008 2.80751L12.7992 2.51086ZM11.4787 4.53535L9.0049 3.08586L8.7382 3.50753L11.212 4.95702L11.4787 4.53535Z", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M2.30938 5.5081C2.30938 3.0654 4.41124 1.08521 7.00402 1.08521C9.10611 1.08521 10.9018 2.70558 11.5 4.5", stroke: "#343434", strokeWidth: "0.6" })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ReplayIcon);


/***/ }),

/***/ "./lib/components/icons/SaveIcon.js":
/*!******************************************!*\
  !*** ./lib/components/icons/SaveIcon.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const SaveIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "25", height: "25", viewBox: "0 0 10 11", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M8 10.75H2C1.0335 10.75 0.25 9.9665 0.25 9V2C0.25 1.0335 1.0335 0.25 2 0.25H5.40054C5.81012 0.25 6.20673 0.393662 6.52129 0.655968L9.12075 2.82358C9.51948 3.15607 9.75 3.64844 9.75 4.16761V9C9.75 9.9665 8.9665 10.75 8 10.75Z", stroke: "#343434", strokeWidth: "0.6" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "2.12503", y: "6.05005", width: "5.875", height: "0.75", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "4.375", y: "2.88745", width: "2.8875", height: "0.75", transform: "rotate(-90 4.375 2.88745)", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "2.12503", y: "8.11255", width: "5.875", height: "0.75", fill: "#343434" })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SaveIcon);


/***/ }),

/***/ "./lib/components/icons/StepsIcon.js":
/*!*******************************************!*\
  !*** ./lib/components/icons/StepsIcon.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const StepsIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "20", height: "24", viewBox: "0 0 4 14", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "0.25", y: "0.25", width: "3.5", height: "3.5", rx: "0.25", stroke: "black", strokeWidth: "0.5" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "0.25", y: "5.25", width: "3.5", height: "3.5", rx: "0.25", stroke: "black", strokeWidth: "0.5" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "0.25", y: "10.25", width: "3.5", height: "3.5", rx: "0.25", stroke: "black", strokeWidth: "0.5" })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StepsIcon);


/***/ }),

/***/ "./lib/components/icons/UndoIcon.js":
/*!******************************************!*\
  !*** ./lib/components/icons/UndoIcon.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

const UndoIcon = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "24", height: "10", viewBox: "0 0 12 5", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M0.802595 2.66537C0.719857 2.77576 0.741164 2.93409 0.850186 3.01899C0.959208 3.10389 1.11466 3.08322 1.1974 2.97283L0.802595 2.66537ZM2.54776 0.753934L2.67568 0.538802C2.56722 0.47157 2.42691 0.498052 2.35035 0.600204L2.54776 0.753934ZM4.73383 2.4034C4.85105 2.47605 5.00334 2.43863 5.074 2.31982C5.14465 2.20101 5.1069 2.04579 4.98968 1.97313L4.73383 2.4034ZM1.1974 2.97283L2.74516 0.907664L2.35035 0.600204L0.802595 2.66537L1.1974 2.97283ZM2.41983 0.969067L4.73383 2.4034L4.98968 1.97313L2.67568 0.538802L2.41983 0.969067Z", fill: "#343434" }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M11.5 0C11.5 2.41714 9.03395 4.37659 6.60866 4.37659C4.64237 4.37659 3.05958 2.77564 2.5 1", stroke: "#343434", strokeWidth: "0.6" })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UndoIcon);


/***/ }),

/***/ "./lib/components/modals/BookDemoModal.js":
/*!************************************************!*\
  !*** ./lib/components/modals/BookDemoModal.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Mito__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Mito */ "./lib/components/Mito.js");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _css_default_modal_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../css/default-modal.css */ "./css/default-modal.css");
/* harmony import */ var _css_default_modal_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_css_default_modal_css__WEBPACK_IMPORTED_MODULE_3__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


// import css


/*
    A modal that asks the user to sign up for a demo
*/
const BookDemoModal = (props) => {
    const bookDemo = (e) => {
        // Prevent the page from reloading when the form submits
        e.preventDefault();
        // Open a new tab to the Hubspot demo booking screen w/ the email already filled in
        window.open(`https://meetings.hubspot.com/nate301/mito-early-access-check-in?utm_campaign=Mito&utm_source=in-app-demo-signup&email=${props.userEmail}`, '_blank');
        props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None });
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-container' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-header-text-div' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, 'Help us Improve Mito')),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-message" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Book an onboarding. Once we get to know you, we can help you with your analysis and build new features just for you!"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-buttons' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-close-button modal-dual-button-left', onClick: () => { props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None }); } }, " Close "),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { onSubmit: (e) => bookDemo(e) },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'modal-action-button', type: 'submit', autoFocus: true },
                            " ",
                            "Book a Demo")))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BookDemoModal);


/***/ }),

/***/ "./lib/components/modals/DeleteColumnModal.js":
/*!****************************************************!*\
  !*** ./lib/components/modals/DeleteColumnModal.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Mito__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Mito */ "./lib/components/Mito.js");
/* harmony import */ var _DefaultModal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../DefaultModal */ "./lib/components/DefaultModal.js");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _css_delete_column_modal_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../css/delete-column-modal.css */ "./css/delete-column-modal.css");
/* harmony import */ var _css_delete_column_modal_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_css_delete_column_modal_css__WEBPACK_IMPORTED_MODULE_4__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.



// import css


/*
    A modal that confirms that you want to delete a column.
*/
const DeleteColumnModal = (props) => {
    const deleteColumn = async () => {
        await props.mitoAPI.sendDeleteColumn(props.selectedSheetIndex, props.columnHeader);
        props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None });
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DefaultModal__WEBPACK_IMPORTED_MODULE_2__.default, { header: `Do you want to delete column ${props.columnHeader}?`, modalType: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.RepeatAnalysis, viewComponent: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null), buttons: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-close-button modal-dual-button-left', onClick: () => { props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None }); } }, " Close "),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-action-button modal-dual-button-right', onClick: deleteColumn },
                " ",
                "Delete Column")) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DeleteColumnModal);


/***/ }),

/***/ "./lib/components/modals/DownloadModal.js":
/*!************************************************!*\
  !*** ./lib/components/modals/DownloadModal.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Mito__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Mito */ "./lib/components/Mito.js");
/* harmony import */ var _DefaultModal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../DefaultModal */ "./lib/components/DefaultModal.js");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_3__);




/*
    A modal that allows a user to download their current sheet.

    It does this by:
    1. Getting a string representation of the sheet through the api
    2. Encoding that as a file
    3. Allowing the user to download that file

    To see more about this process, read documentation here:
    https://blog.logrocket.com/programmatic-file-downloads-in-the-browser-9a5186298d5c/
*/
const DownloadModal = (props) => {
    const [dataframeCSV, setDataframeCSV] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    // We use a count to track the number of ...s to display.
    // 0 -> '', 1 -> '.', 2 -> '..', 3 -> '...'. Wraps % 4.
    const [indicatorState, setIndicatorState] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
    const loadDataframeCSV = async () => {
        const loadedDataframeCSV = await props.mitoAPI.getDataframeAsCSV(props.selectedSheetIndex);
        setDataframeCSV(loadedDataframeCSV);
    };
    // Async load in the data from the mitoAPI
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        void loadDataframeCSV();
    }, []);
    // Schedule a change to update the loading indicator, every .5 seconds
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        const interval = setInterval(() => {
            setIndicatorState(indicatorState => indicatorState + 1);
        }, 500);
        return () => clearInterval(interval);
    }, []);
    const onDownload = () => {
        void props.mitoAPI.sendLogMessage('button_download_log_event', {
            sheet_index: props.selectedSheetIndex,
            df_name: props.dfName
        });
        props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None });
    };
    // Calculate the number of loading dots
    const someNumberOfDots = '.'.repeat(indicatorState % 4) + '.';
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DefaultModal__WEBPACK_IMPORTED_MODULE_2__.default, { header: 'Download Current Sheet', modalType: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.Download, viewComponent: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            dataframeCSV === '' &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'mt-2' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'modal-loading-text' }, "Give us a few seconds to prepare your data for download."),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-loading-dots mt-2' }, someNumberOfDots)),
            dataframeCSV !== '' &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
                    "Download ",
                    props.dfName,
                    " as a CSV.")), buttons: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-close-button modal-dual-button-left', onClick: () => { props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None }); } }, " Close "),
            dataframeCSV === '' &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-action-button modal-dual-button-right modal-button-disabled' }, "Download"),
            dataframeCSV !== '' &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", { href: URL.createObjectURL(new Blob([dataframeCSV], { type: 'text/csv' })), download: props.dfName + '.csv', className: 'modal-action-button modal-dual-button-right', onClick: onDownload }, "Download")) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DownloadModal);


/***/ }),

/***/ "./lib/components/modals/ImportModal.js":
/*!**********************************************!*\
  !*** ./lib/components/modals/ImportModal.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ImportEnum": () => (/* binding */ ImportEnum),
/* harmony export */   "getDfNameError": () => (/* binding */ getDfNameError),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Mito__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Mito */ "./lib/components/Mito.js");
/* harmony import */ var _DefaultModal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../DefaultModal */ "./lib/components/DefaultModal.js");
/* harmony import */ var _elements_LargeSelects__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../elements/LargeSelects */ "./lib/components/elements/LargeSelects.js");
/* harmony import */ var _css_all_modals_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../css/all-modals.css */ "./css/all-modals.css");
/* harmony import */ var _css_all_modals_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_css_all_modals_css__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _css_import_modal_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../css/import-modal.css */ "./css/import-modal.css");
/* harmony import */ var _css_import_modal_css__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_css_import_modal_css__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _elements_LargeSelect__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../elements/LargeSelect */ "./lib/components/elements/LargeSelect.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.




// import css



var ImportEnum;
(function (ImportEnum) {
    ImportEnum["SimpleImport"] = "Simple Import";
    ImportEnum["RawPythonImport"] = "Raw Python Import";
})(ImportEnum || (ImportEnum = {}));
const getDfNameError = (pythonCode, newDfNames, existingDfNames) => {
    for (let i = 0; i < newDfNames.length; i++) {
        // Invalid if it's not in the Python
        if (!pythonCode.includes(newDfNames[i])) {
            return `Error: ${newDfNames[i]} is not a name of a variable in your code.`;
        }
        // Or if it's already the name of a sheet
        if (existingDfNames.indexOf(newDfNames[i]) !== -1) {
            return `Error: ${newDfNames[i]} is already the name of a sheet. Please choose a different name.`;
        }
    }
    return undefined;
};
/*
  A modal that allows a user to import data into the sheet.
*/
const ImportModal = (props) => {
    const [importType, setImportType] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(ImportEnum.SimpleImport);
    // Params for a simple import
    const [fileNames, setFileNames] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    const [importedFiles, setImportedFiles] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    const [importedFilesError, setImportedFilesError] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    // Params for a raw Python import
    const [pythonCode, setPythonCode] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    const [dfNamesString, setDfNamesString] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    const [dfNameError, setDfNameError] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    async function getDataFiles() {
        const dataFiles = await props.mitoAPI.getDataFiles();
        setFileNames(dataFiles);
    }
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        // To see an explination, read here: https://medium.com/better-programming/how-to-fetch-data-from-an-api-with-react-hooks-9e7202b8afcd
        // TL;DR: we load the data after the component renders
        void getDataFiles();
    }, []); // empty array is necessary to have this run only once
    const updateImportedFile = (index, newImport) => {
        const newImports = [...importedFiles];
        newImports[index] = newImport;
        setImportedFiles(newImports);
    };
    const addNewFileImport = () => {
        const newImports = [...importedFiles];
        newImports.push(fileNames[0]);
        setImportedFiles(newImports);
    };
    /*
        Completes the import step, casing on which sort of import is occuring
    */
    const clickImport = async () => {
        if (importType === ImportEnum.SimpleImport) {
            // Don't let them continue if they didn't import
            if (importedFiles.length === 0) {
                setImportedFilesError('Please upload at least one file before continuing.');
                return;
            }
            await props.mitoAPI.sendSimpleImportMessage(importedFiles);
            props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None });
        }
        else {
            // Short curcit early if the user provides an invalid name
            const dfNames = dfNamesString.split(',').map(dfName => dfName.trim());
            const dfNameError = getDfNameError(pythonCode, dfNames, props.dfNames);
            if (dfNameError !== undefined) {
                return setDfNameError(dfNameError);
            }
            await props.mitoAPI.sendRawPythonImportMessage(pythonCode, dfNames);
            props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None });
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DefaultModal__WEBPACK_IMPORTED_MODULE_2__.default, { header: `Import Data`, modalType: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.Import, viewComponent: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-element-label' }, "Import Method"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_elements_LargeSelect__WEBPACK_IMPORTED_MODULE_6__.default, { startingValue: undefined, optionsArray: [ImportEnum.SimpleImport, ImportEnum.RawPythonImport], setValue: (value) => setImportType(value), extraLarge: true }),
            importType === ImportEnum.SimpleImport &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-element-label mt-2' }, "Files to Import"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'import-files-select' },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_elements_LargeSelects__WEBPACK_IMPORTED_MODULE_3__.default, { numSelects: importedFiles.length, startingValue: undefined, optionsArray: fileNames, setValue: updateImportedFile, extraLarge: true })),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-add', onClick: addNewFileImport }, "+ Add File"),
                    importedFilesError !== '' &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-error' }, importedFilesError)),
            importType === ImportEnum.RawPythonImport &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-element-label mt-2' }, "Python Code"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("textarea", { className: 'raw-python-textarea', rows: 5, value: pythonCode, onChange: (e) => { setPythonCode(e.target.value); }, autoFocus: true }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-element-label mt-2' }, "Dataframe Variable Names to Import (comma seperated)"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { className: "modal-input", type: "text", placeholder: 'df1, df2', value: dfNamesString, onChange: (e) => { setDfNamesString(e.target.value); } }),
                    dfNameError !== '' &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-error' }, dfNameError))), buttons: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-close-button modal-dual-button-left', onClick: () => { props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None }); } }, " Close "),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-action-button modal-dual-button-right', onClick: clickImport }, " Import ")) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ImportModal);


/***/ }),

/***/ "./lib/components/modals/ReplayImportModal.js":
/*!****************************************************!*\
  !*** ./lib/components/modals/ReplayImportModal.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Mito__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Mito */ "./lib/components/Mito.js");
/* harmony import */ var _DefaultModal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../DefaultModal */ "./lib/components/DefaultModal.js");
/* harmony import */ var _css_all_modals_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../css/all-modals.css */ "./css/all-modals.css");
/* harmony import */ var _css_all_modals_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_css_all_modals_css__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _css_import_modal_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../css/import-modal.css */ "./css/import-modal.css");
/* harmony import */ var _css_import_modal_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_css_import_modal_css__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _ImportModal__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./ImportModal */ "./lib/components/modals/ImportModal.js");
/* harmony import */ var _elements_LargeSelects__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../elements/LargeSelects */ "./lib/components/elements/LargeSelects.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.



// import css




/*
  A modal that allows a user to change what files they import when
  replaying an analysis.
*/
const ReplayImportModal = (props) => {
    // Params for a simple import
    const [fileNames, setFileNames] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)([]);
    const [importedFilesByStep, setImportedFilesByStep] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(props.importSummaries);
    const [dfNameErrors, setDfNameErrors] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    // save the original imported step summary so we can display the original dataframe names
    // because the importedFilesByStep gets updated
    const originalImportedFilesByStep = props.importSummaries;
    async function getDataFiles() {
        const dataFiles = await props.api.getDataFiles();
        setFileNames(dataFiles);
    }
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        // To see an explination, read here: https://medium.com/better-programming/how-to-fetch-data-from-an-api-with-react-hooks-9e7202b8afcd
        // TL;DR: we load the data after the component renders
        void getDataFiles();
    }, []); // empty array is key to have this run only once
    /*
        For a simple import, updates the imported file that is saved for that specific import
    */
    const updateImportedFile = (stepId, index, newImport) => {
        // Save the new file name outside the setState callback, as react does funky things w/ synthetic events
        const newFileName = newImport;
        setImportedFilesByStep(prevImportedFilesByStep => {
            const step = prevImportedFilesByStep[stepId];
            const newFilesForStep = [...step.file_names];
            newFilesForStep[index] = newFileName;
            return Object.assign(Object.assign({}, prevImportedFilesByStep), { [stepId]: {
                    'step_type': 'simple_import',
                    'file_names': newFilesForStep
                } });
        });
    };
    /*
        For a raw python import, updates the python code in that import step
    */
    const updatePythonCode = (event, stepId) => {
        // Save the new file name outside the setState callback, as react does funky things w/ synthetic events
        const newPythonCode = event.target.value;
        setImportedFilesByStep(prevImportedFilesByStep => {
            const step = prevImportedFilesByStep[stepId];
            return Object.assign(Object.assign({}, prevImportedFilesByStep), { [stepId]: {
                    'step_type': 'raw_python_import',
                    'python_code': newPythonCode,
                    'new_df_names': step.new_df_names
                } });
        });
    };
    /*
        For a raw python import, updates the dataframe name string
    */
    const updateDfNameString = (event, stepId) => {
        // Save the new file name outside the setState callback, as react does funky things w/ synthetic events
        const dfNameString = event.target.value;
        setImportedFilesByStep(prevImportedFilesByStep => {
            const step = prevImportedFilesByStep[stepId];
            return Object.assign(Object.assign({}, prevImportedFilesByStep), { [stepId]: {
                    'step_type': 'raw_python_import',
                    'python_code': step.python_code,
                    'new_df_names': dfNameString.split(',').map(dfName => dfName.trim())
                } });
        });
    };
    const getPreviousFileNamesLabels = (previousFileNames) => {
        return previousFileNames.map(fileName => (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'previous-file-name-label', key: fileName },
            " ",
            fileName,
            " ")));
    };
    const clickImport = async () => {
        // First, we check and make sure that all the Python code steps are valid, and throw an 
        // error message if they are not
        const stepIds = Object.keys(importedFilesByStep);
        let errorFound = false;
        for (let i = 0; i < stepIds.length; i++) {
            const stepId = stepIds[i];
            const step = importedFilesByStep[stepId];
            if (step.step_type === 'raw_python_import') {
                const dfNameError = (0,_ImportModal__WEBPACK_IMPORTED_MODULE_5__.getDfNameError)(step.python_code, step.new_df_names, props.dfNames);
                if (dfNameError !== undefined) {
                    errorFound = true;
                    setDfNameErrors(prevDfNameErrors => {
                        return Object.assign(Object.assign({}, prevDfNameErrors), { [stepId]: dfNameError });
                    });
                }
            }
        }
        // Short-curcit if any of the df names have errors
        if (errorFound) {
            return;
        }
        await props.mitoAPI.sendUseExistingAnalysisUpdateMessage(props.analysisName, importedFilesByStep);
        props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None });
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DefaultModal__WEBPACK_IMPORTED_MODULE_2__.default, { header: `Update Imported Data`, modalType: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.ReplayImport, viewComponent: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Change your previously-used data source to re-run this analysis on new data."),
            Object.keys(importedFilesByStep).map((stepId) => {
                const stepSummary = importedFilesByStep[stepId];
                const originalStepSummary = originalImportedFilesByStep[stepId];
                if (stepSummary.step_type == 'simple_import') {
                    const previousFileNames = stepSummary.file_names;
                    // make sure the type checks pass
                    const originalFileNames = originalStepSummary.step_type == 'simple_import' ? originalStepSummary.file_names : [''];
                    const originalFileNamesLabels = getPreviousFileNamesLabels(originalFileNames);
                    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: stepId },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-element-label mt-2' },
                            "Select the new version of each file for Step ",
                            stepId,
                            "."),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'import-files-old-and-new-container' },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'previous-file-name-labels-container' }, originalFileNamesLabels),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'import-files-select' },
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_elements_LargeSelects__WEBPACK_IMPORTED_MODULE_6__.default, { numSelects: previousFileNames.length, startingValue: undefined, optionsArray: fileNames, setValue: (index, value) => { updateImportedFile(stepId, index, value); }, extraLarge: true })))));
                }
                else {
                    const pythonCode = stepSummary.python_code;
                    const dfNameString = stepSummary.new_df_names.join(', ');
                    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: stepId },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-element-label mt-2' },
                            "Python Code for for Step ",
                            stepId),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("textarea", { className: 'raw-python-textarea', rows: 5, value: pythonCode, onChange: (e) => { updatePythonCode(e, stepId); }, autoFocus: true }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-element-label' },
                            "Dataframe Variable Names to Import (comma seperated) for Step ",
                            stepId),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { className: "modal-input", type: "text", placeholder: 'df1, df2', value: dfNameString, onChange: (e) => { updateDfNameString(e, stepId); } }),
                        dfNameErrors[stepId] !== undefined &&
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-error' }, dfNameErrors[stepId])));
                }
            })), buttons: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-close-button modal-dual-button-left', onClick: () => { props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None }); } }, " Close "),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-action-button modal-dual-button-right', onClick: clickImport }, " Replay ")) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ReplayImportModal);


/***/ }),

/***/ "./lib/components/modals/SaveAnalysisModal.js":
/*!****************************************************!*\
  !*** ./lib/components/modals/SaveAnalysisModal.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Mito__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Mito */ "./lib/components/Mito.js");
/* harmony import */ var _DefaultModal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../DefaultModal */ "./lib/components/DefaultModal.js");
/* harmony import */ var _css_save_analysis_modal_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../css/save-analysis-modal.css */ "./css/save-analysis-modal.css");
/* harmony import */ var _css_save_analysis_modal_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_css_save_analysis_modal_css__WEBPACK_IMPORTED_MODULE_3__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.



// import css

// A set of characters we don't allow in analysis names,
// just to avoid file name issues
// Taken from: https://www.mtu.edu/umc/services/digital/writing/characters-avoid/
const ILLEGAL_FILENAME_CHARACTERS = [
    '#',
    '%',
    '&',
    '{', '}',
    '/', '\\',
    '<', '>',
    '*',
    '?',
    '$',
    '!',
    '\'', '"',
    ':',
    '@'
];
function getAnalysisNameError(analysisName) {
    /*
        Helper function for validating named analyses. Avoids a set of illegal characters.

        Returns the empty string if there is no error.
    */
    if (analysisName.length == 0) {
        return 'Please enter a name for your analysis';
    }
    for (let i = 0; i < ILLEGAL_FILENAME_CHARACTERS.length; i++) {
        if (analysisName.indexOf(ILLEGAL_FILENAME_CHARACTERS[i]) > -1) {
            return `Invalid analysis name. Please remove the "${ILLEGAL_FILENAME_CHARACTERS[i]}"`;
        }
    }
    return '';
}
/*
  A modal that allows a user to save an analysis with the input
  name.
*/
const SaveAnalysis = (props) => {
    const [saveAnalysisName, setSaveAnalysisName] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(props.saveAnalysisName !== undefined ? props.saveAnalysisName : '');
    const [analysisNameError, setAnalysisNameError] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    const clickSave = async () => {
        // Don't let the user submit if they have an invalid analysis name!
        if (getAnalysisNameError(saveAnalysisName) !== '') {
            setAnalysisNameError(`Please fix before saving: ${getAnalysisNameError(saveAnalysisName)}`);
            return;
        }
        if (props.savedAnalysisNames.indexOf(saveAnalysisName) > -1) {
            // If user is overwriting an analysis, we display a popup to let them know. 
            props.setModal({
                type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.SaveAnalysisOverwrite,
                saveAnalysisName: saveAnalysisName
            });
        }
        else {
            // Otherwise, we just log and save the analysis
            await props.mitoAPI.sendSaveAnalysisMessage(saveAnalysisName);
            props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None });
        }
    };
    const onChangeAnalysisName = (newAnalysisName) => {
        setSaveAnalysisName(newAnalysisName);
        setAnalysisNameError(getAnalysisNameError(newAnalysisName));
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DefaultModal__WEBPACK_IMPORTED_MODULE_2__.default, { header: `Save your current analysis`, modalType: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.SaveAnalysis, viewComponent: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'save-analysis-label' }, "Name your analysis"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { className: "modal-input", type: "text", placeholder: 'Monthly Sales Analysis', value: saveAnalysisName, onChange: (e) => onChangeAnalysisName(e.target.value), autoFocus: true }),
                    analysisNameError !== '' &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'save-analysis-name-error' }, analysisNameError)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'mt-2 save-analysis-analysis-selection-container' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'save-analysis-label' }, "Existing analyses"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'save-analysis-analysis-selection' },
                        props.savedAnalysisNames.length == 0 &&
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Save an analysis to have it appear here."),
                        props.savedAnalysisNames.map((savedAnalysisName) => {
                            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'save-analysis-analysis-name', key: savedAnalysisName, onClick: () => { onChangeAnalysisName(savedAnalysisName); } }, savedAnalysisName));
                        }))))), buttons: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-close-button modal-dual-button-left', onClick: () => { props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None }); } }, " Close "),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-action-button modal-dual-button-right', onClick: clickSave },
                " ",
                "Save")) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SaveAnalysis);


/***/ }),

/***/ "./lib/components/modals/SaveAnalysisOverwriteModal.js":
/*!*************************************************************!*\
  !*** ./lib/components/modals/SaveAnalysisOverwriteModal.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Mito__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Mito */ "./lib/components/Mito.js");
/* harmony import */ var _DefaultModal__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../DefaultModal */ "./lib/components/DefaultModal.js");
/* harmony import */ var _css_save_analysis_modal_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../css/save-analysis-modal.css */ "./css/save-analysis-modal.css");
/* harmony import */ var _css_save_analysis_modal_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_css_save_analysis_modal_css__WEBPACK_IMPORTED_MODULE_3__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.



// import css

/*
  A modal that appears if a user tries to overwrite a saved analysis,
  prompting them they want to overwrite it.
*/
const SaveAnalysisOverwriteModal = (props) => {
    const clickBack = () => {
        props.setModal({
            type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.SaveAnalysis,
            saveAnalysisName: props.saveAnalysisName
        });
    };
    const clickOverwrite = async () => {
        await props.mitoAPI.sendSaveAnalysisMessage(props.saveAnalysisName);
        props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None });
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DefaultModal__WEBPACK_IMPORTED_MODULE_2__.default, { header: `There is already an analysis called ${props.saveAnalysisName}`, modalType: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.SaveAnalysisOverwrite, viewComponent: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Saving this analysis will overwrite your existing analysis. Are you sure you want to continue?")), buttons: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-close-button modal-dual-button-left', onClick: clickBack }, " Back "),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-action-button modal-dual-button-right', onClick: clickOverwrite }, " Overwrite")) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SaveAnalysisOverwriteModal);


/***/ }),

/***/ "./lib/components/modals/SignupModal.js":
/*!**********************************************!*\
  !*** ./lib/components/modals/SignupModal.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Mito__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Mito */ "./lib/components/Mito.js");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _css_default_modal_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../css/default-modal.css */ "./css/default-modal.css");
/* harmony import */ var _css_default_modal_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_css_default_modal_css__WEBPACK_IMPORTED_MODULE_3__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


// import css



/*
    A modal that requests the user's email to sign up
*/
const SignUpModal = (props) => {
    const [userEmail, setUserEmail] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    const signUp = async () => {
        await props.mitoAPI.sendSignUp(userEmail);
        props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.BookDemo, userEmail: userEmail });
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-container' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-header-text-div' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, 'Sign Up to Get Started with Mito')),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "modal-message" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { onSubmit: signUp },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'modal-input-label' }, "Email"),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { className: "modal-input", type: "email", placeholder: 'example@gmail.com', value: userEmail, onChange: (e) => setUserEmail(e.target.value), required: true, autoFocus: true }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'mt-2' }, "We'll only email you about Mito. We'll send you information about new features and your free trial. We'll never share you email with anyone!")),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-buttons' },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: 'modal-action-button', type: 'submit' },
                            " ",
                            "Sign Up")))))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SignUpModal);


/***/ }),

/***/ "./lib/components/modals/UpgradeModal.js":
/*!***********************************************!*\
  !*** ./lib/components/modals/UpgradeModal.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Mito__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Mito */ "./lib/components/Mito.js");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _css_default_modal_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../css/default-modal.css */ "./css/default-modal.css");
/* harmony import */ var _css_default_modal_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_css_default_modal_css__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _DefaultModal__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../DefaultModal */ "./lib/components/DefaultModal.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


// import css



/*
    A modal that appears and tells the user to upgrade to the
    new version of Mito, by going to the documentation
*/
const UpgradeModal = (props) => {
    const onUpgrade = () => {
        // We log the opening of the documentation taskpane
        void props.mitoAPI.sendLogMessage('upgrade_button_clicked');
        // Open the upgrading docs
        window.open(`https://docs.trymito.io/`, '_blank');
        props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None });
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DefaultModal__WEBPACK_IMPORTED_MODULE_4__.default, { header: `Upgrade for New Functionality`, modalType: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.Upgrade, viewComponent: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "The Mito team moves fast. Since you last updated, we\u2019ve added a bunch of shiny new things to play with, and polished the old stuff. Upgrade now to try it out!")), buttons: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-close-button modal-dual-button-left', onClick: () => { props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_1__.ModalEnum.None }); } }, " Close "),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'modal-action-button modal-dual-button-right', onClick: onUpgrade }, " Upgrade")) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UpgradeModal);


/***/ }),

/***/ "./lib/components/tabs/SheetTab.js":
/*!*****************************************!*\
  !*** ./lib/components/tabs/SheetTab.js ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SheetTab)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SheetTabActions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SheetTabActions */ "./lib/components/tabs/SheetTabActions.js");
/* harmony import */ var _css_sheet_tab_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../css/sheet-tab.css */ "./css/sheet-tab.css");
/* harmony import */ var _css_sheet_tab_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_sheet_tab_css__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


// import css

/*
    Component that displays a dataframe name at the bottom of the sheet, and
    furthermore renders the sheet actions if the sheet action dropdown is
    clicked.
*/
function SheetTab(props) {
    // We only set this as open if it the currOpenSheetTabActions
    const displayActions = props.currOpenSheetTabActions === props.sheetIndex;
    const [isRename, setIsRename] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [newDataframeName, setNewDataframeName] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(props.dfName);
    const selectedClass = props.selectedSheetIndex == props.sheetIndex ? 'selected-tab' : '';
    const elRef = (0,react__WEBPACK_IMPORTED_MODULE_0__.useRef)(null);
    /*
        Helper function that determines how much we should shift the SheetTabActions over.

        To do so, we find the bounding box of the Mito container as well as the tab itself.
        The bounding box can be understood as the left, right, top and bottom pixel indexes
        of the div element itself.

        We return the difference between the left edge of the mito container as well as the
        tab. However, we cap this at 1, so that the SheetTabActions must be displayed within
        the Mito container.
    */
    function getLeftShift() {
        var _a, _b, _c, _d;
        const containerRectLeft = (_b = (_a = elRef.current) === null || _a === void 0 ? void 0 : _a.getBoundingClientRect()) === null || _b === void 0 ? void 0 : _b.left;
        const tabRectLeft = (_d = (_c = props.mitoContainerRef) === null || _c === void 0 ? void 0 : _c.getBoundingClientRect()) === null || _d === void 0 ? void 0 : _d.left;
        if (containerRectLeft !== undefined && tabRectLeft !== undefined) {
            return Math.max(containerRectLeft - tabRectLeft, 1);
        }
        return 0;
    }
    const onRename = async () => {
        await props.mitoAPI.sendDataframeRenameEdit(props.sheetIndex, newDataframeName);
        props.setCurrOpenSheetTabActions(undefined);
        setIsRename(false);
    };
    const toggleSheetTabActions = () => {
        props.closeOpenEditingPopups();
        if (displayActions) {
            props.setCurrOpenSheetTabActions(undefined);
        }
        else {
            props.setCurrOpenSheetTabActions(props.sheetIndex);
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { ref: elRef, className: 'tab' + ' ' + selectedClass, onClick: () => {
            props.setSelectedSheetIndex(props.sheetIndex);
        }, onDoubleClick: () => { setIsRename(true); } },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'tab-text' },
            isRename &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { onSubmit: async (e) => { e.preventDefault(); await onRename(); } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: 'text', value: newDataframeName, onChange: (e) => { setNewDataframeName(e.target.value); }, onBlur: onRename, autoFocus: true })),
            !isRename &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'tab-sheet-name' }, props.dfName),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { onClick: toggleSheetTabActions, width: "15", height: "20", viewBox: "0 0 9 4", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M4.50098 4L8.39809 0.25H0.603862L4.50098 4Z", fill: "#C4C4C4" }))),
        displayActions &&
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_SheetTabActions__WEBPACK_IMPORTED_MODULE_1__.default, { setCurrOpenSheetTabActions: props.setCurrOpenSheetTabActions, setSelectedSheetIndex: props.setSelectedSheetIndex, setIsRename: setIsRename, dfName: props.dfName, selectedSheetIndex: props.selectedSheetIndex, sheetIndex: props.sheetIndex, getLeftShift: getLeftShift, mitoAPI: props.mitoAPI })));
}


/***/ }),

/***/ "./lib/components/tabs/SheetTabActions.js":
/*!************************************************!*\
  !*** ./lib/components/tabs/SheetTabActions.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ SheetTabActions)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_sheet_tab_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../css/sheet-tab.css */ "./css/sheet-tab.css");
/* harmony import */ var _css_sheet_tab_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_sheet_tab_css__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// import css

/*
    Displays a set of actions one can perform on a sheet tab, including
    deleting, duplicating, or renaming.
*/
function SheetTabActions(props) {
    const onDelete = async (e) => {
        // We stop this click from propagating, so that we don't call the callback 
        // that selects this sheet
        e.stopPropagation();
        // If we are deleting the sheet index that is currently selected & it is not sheetIndex 0, update the selected sheet index
        if (props.sheetIndex === props.selectedSheetIndex && props.selectedSheetIndex !== 0) {
            props.setSelectedSheetIndex(props.sheetIndex - 1);
        }
        await props.mitoAPI.sendDataframeDeleteMessage(props.sheetIndex);
        props.setCurrOpenSheetTabActions(undefined);
    };
    const onDuplicate = async () => {
        await props.mitoAPI.sendDataframeDuplicateMessage(props.sheetIndex);
        props.setCurrOpenSheetTabActions(undefined);
    };
    /* Rename helper, which requires changes to the sheet tab itself */
    const onRename = () => {
        props.setCurrOpenSheetTabActions(undefined);
        props.setIsRename(true);
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'sheet-tab-actions-dropdown', style: { left: props.getLeftShift() } },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'sheet-tab-action', onClick: onDelete }, "Delete"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'sheet-tab-action', onClick: onDuplicate }, "Duplicate"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'sheet-tab-action', onClick: onRename }, "Rename")));
}


/***/ }),

/***/ "./lib/components/tabs/SheetTabs.js":
/*!******************************************!*\
  !*** ./lib/components/tabs/SheetTabs.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _SheetTab__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SheetTab */ "./lib/components/tabs/SheetTab.js");
/* harmony import */ var _css_sheet_tab_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../css/sheet-tab.css */ "./css/sheet-tab.css");
/* harmony import */ var _css_sheet_tab_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_sheet_tab_css__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


// import css

/*
    Wrapper component that displays the entire bottom of the sheet, including
    the sheet tabs, as well as the shape of the currently selected dataframe.
*/
function SheetTabs(props) {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'sheet-bottom' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "sheet-tab-bar" }, props.dfNames.map((dfName, idx) => {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_SheetTab__WEBPACK_IMPORTED_MODULE_1__.default, { setCurrOpenSheetTabActions: props.setCurrOpenSheetTabActions, currOpenSheetTabActions: props.currOpenSheetTabActions, key: idx, mitoContainerRef: props.mitoContainerRef, dfName: dfName, sheetShape: props.sheetShapeArray[idx], sheetIndex: idx, selectedSheetIndex: props.selectedSheetIndex, setSelectedSheetIndex: props.setSelectedSheetIndex, mitoAPI: props.mitoAPI, closeOpenEditingPopups: props.closeOpenEditingPopups }));
        })),
        props.sheetShapeArray[props.selectedSheetIndex] !== undefined &&
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'sheet-shape' },
                "(",
                props.sheetShapeArray[props.selectedSheetIndex].rows,
                ", ",
                props.sheetShapeArray[props.selectedSheetIndex].cols,
                ")")));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SheetTabs);


/***/ }),

/***/ "./lib/components/taskpanes/ControlPanel/ColumnNameCard.js":
/*!*****************************************************************!*\
  !*** ./lib/components/taskpanes/ControlPanel/ColumnNameCard.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _css_column_header_modal_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../css/column-header-modal.css */ "./css/column-header-modal.css");
/* harmony import */ var _css_column_header_modal_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_column_header_modal_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _css_column_name_card_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../css/column-name-card.css */ "./css/column-name-card.css");
/* harmony import */ var _css_column_name_card_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_css_column_name_card_css__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _TaskpaneError__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../TaskpaneError */ "./lib/components/taskpanes/TaskpaneError.js");
/* harmony import */ var _taskpanes__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../taskpanes */ "./lib/components/taskpanes/taskpanes.js");
/* harmony import */ var _renameUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./renameUtils */ "./lib/components/taskpanes/ControlPanel/renameUtils.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// import css






/*
    A modal that allows a user to sort a column
*/
class ColumnNameCard extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.updateUnsubmittedNewColumnHeader = (e) => {
            const newColumnHeader = e.target.value;
            // Update the saved unsubmittedColumnHeader
            this.setState({
                unsubmittedNewColumnHeader: newColumnHeader
            });
            // Display an error message, if it has one
            this.setInvalidInputError((0,_renameUtils__WEBPACK_IMPORTED_MODULE_6__.getHeaderErrorMessage)(newColumnHeader));
        };
        this.changeColumnHeader = async () => {
            if (!(0,_renameUtils__WEBPACK_IMPORTED_MODULE_6__.isValidHeader)(this.state.unsubmittedNewColumnHeader)) {
                // We make sure the new column header is a valid mito column,
                // and we don't allow the user to submit if it's not! 
                // We also update the error to tell them to fix the issue.
                this.setInvalidInputError(`Please fix issues before submitting: ${(0,_renameUtils__WEBPACK_IMPORTED_MODULE_6__.getHeaderErrorMessage)(this.state.unsubmittedNewColumnHeader)}`);
                return;
            }
            // If the column header did not change, just stop renaming without updating the name to avoid error
            if (this.state.columnHeader == this.state.unsubmittedNewColumnHeader) {
                this.setState({
                    isRename: false
                });
                return;
            }
            const stepID = await this.props.mitoAPI.sendRenameColumn(this.props.selectedSheetIndex, this.state.columnHeader, this.state.unsubmittedNewColumnHeader, this.state.stepID);
            this.setState(prevState => {
                return {
                    stepID: stepID,
                    isRename: false,
                    columnHeader: prevState.unsubmittedNewColumnHeader,
                    unsubmittedNewColumnHeader: prevState.unsubmittedNewColumnHeader
                };
            });
            this.props.setCurrOpenTaskpane({ type: _taskpanes__WEBPACK_IMPORTED_MODULE_5__.TaskpaneType.CONTROL_PANEL, columnHeader: this.state.columnHeader, openEditingColumnHeader: false });
        };
        this.state = {
            columnHeader: props.columnHeader,
            unsubmittedNewColumnHeader: props.columnHeader,
            invalidInputError: '',
            isRename: props.openEditingColumnHeader,
            stepID: ''
        };
        this.setColumnHeader = this.setColumnHeader.bind(this);
        this.updateUnsubmittedNewColumnHeader = this.updateUnsubmittedNewColumnHeader.bind(this);
        this.setInvalidInputError = this.setInvalidInputError.bind(this);
        this.setIsRename = this.setIsRename.bind(this);
    }
    setColumnHeader(columnHeader) {
        this.setState({
            columnHeader: columnHeader
        });
    }
    setInvalidInputError(errorMessage) {
        this.setState({
            invalidInputError: errorMessage
        });
    }
    setIsRename(isRename) {
        this.setState(prevState => {
            return {
                isRename: isRename,
                unsubmittedNewColumnHeader: prevState.columnHeader
            };
        });
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'column-name-card-container' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-header-div' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'column-name-card-column-name-div', onClick: () => {
                        if (!this.state.isRename) {
                            this.setIsRename(!this.state.isRename);
                            this.setInvalidInputError('');
                        }
                    } },
                    this.state.isRename &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { onSubmit: (e) => { e.preventDefault(); void this.changeColumnHeader(); }, onBlur: (e) => { e.preventDefault(); void this.changeColumnHeader(); } },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: 'text', className: 'column-name-card-input-text', value: this.state.unsubmittedNewColumnHeader, onChange: (e) => { this.updateUnsubmittedNewColumnHeader(e); }, autoFocus: true })),
                    !this.state.isRename &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'column-name-card-column-header' }, this.state.columnHeader)),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-header-exit-button-div', onClick: () => this.props.setCurrOpenTaskpane({ type: _taskpanes__WEBPACK_IMPORTED_MODULE_5__.TaskpaneType.NONE }) },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "18", height: "18", viewBox: "0 0 13 13", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "0.707107", y1: "1.29289", x2: "11.3136", y2: "11.8994", stroke: "#343434", strokeWidth: "2" }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "0.7072", y1: "11.8995", x2: "11.3137", y2: "1.29297", stroke: "#343434", strokeWidth: "2" })))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_TaskpaneError__WEBPACK_IMPORTED_MODULE_4__.default, { message: this.state.invalidInputError })));
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ColumnNameCard);


/***/ }),

/***/ "./lib/components/taskpanes/ControlPanel/ColumnSummaryGraph.js":
/*!*********************************************************************!*\
  !*** ./lib/components/taskpanes/ControlPanel/ColumnSummaryGraph.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// import css

/*
    Displays the column summary graph in the column control panel
*/
function ColumnSummaryGraph(props) {
    const [base64PNGImage, setBase64PNGImage] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    const [alt, setAlt] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('Graph is loading...');
    async function loadBase64PNGImage() {
        const loadedBase64PNGImage = await props.mitoAPI.getColumnSummaryGraph(props.selectedSheetIndex, props.columnHeader);
        if (loadedBase64PNGImage === '') {
            setAlt('Sorry, it looks like there are too many items in this column to display them well.');
            await props.mitoAPI.sendLogMessage('too_many_items_to_display_graph');
        }
        else {
            setBase64PNGImage(loadedBase64PNGImage);
        }
    }
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        void loadBase64PNGImage();
    }, []);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'filter-modal-section-title' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, " Column Summary Graph "),
            base64PNGImage !== '' &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("a", { className: 'mr-30px', href: 'data:image/png;base64, ' + base64PNGImage, download: props.columnHeader + '-frequency-graph.png', onClick: () => {
                            // We log the download of the graph
                            void props.mitoAPI.sendLogMessage('click_download_column_summary_graph', {
                                'column_header': props.columnHeader
                            });
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "20", height: "16", viewBox: "0 0 20 16", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "0.384615", y: "8.077", width: "0.769231", height: "6.92308", fill: "#C4C4C4", stroke: "#343434", strokeWidth: "0.769231" }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "18.4615", y: "7.69238", width: "1.53846", height: "7.69231", fill: "#343434" }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "20", y: "13.8462", width: "1.53846", height: "20", transform: "rotate(90 20 13.8462)", fill: "#343434" }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M9.46967 12.0688C9.76256 12.3617 10.2374 12.3617 10.5303 12.0688L15.3033 7.29582C15.5962 7.00293 15.5962 6.52805 15.3033 6.23516C15.0104 5.94227 14.5355 5.94227 14.2426 6.23516L10 10.4778L5.75736 6.23516C5.46447 5.94227 4.98959 5.94227 4.6967 6.23516C4.40381 6.52805 4.40381 7.00293 4.6967 7.29582L9.46967 12.0688ZM9.25 0V11.5385H10.75V0L9.25 0Z", fill: "#343434" }))))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("img", { className: 'mb-2', src: 'data:image/png;base64, ' + base64PNGImage, alt: alt })));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ColumnSummaryGraph);


/***/ }),

/***/ "./lib/components/taskpanes/ControlPanel/ColumnSummaryStatistics.js":
/*!**************************************************************************!*\
  !*** ./lib/components/taskpanes/ControlPanel/ColumnSummaryStatistics.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// import css

/*
    Displays the column summary statistics gotten from
    a call to .describe

    See examples here: https://pandas.pydata.org/pandas-docs/stable/reference/api/pandas.Series.describe.html
*/
function ColumnSummaryStatistics(props) {
    const [describe, setDescribe] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
    const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(true);
    async function loadDescribe() {
        const loadedDescribe = await props.mitoAPI.getColumnDescribe(props.selectedSheetIndex, props.columnHeader);
        setDescribe(loadedDescribe);
        setLoading(false);
    }
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        void loadDescribe();
    }, []);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'filter-modal-section-title' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, " Column Summary Statistics ")),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { key: loading.toString() },
            !loading &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("table", { className: 'column-describe-table-container' }, Object.keys(describe).map(key => {
                    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("tr", { className: 'column-describe-table-row', key: key },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("th", null, key),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("th", null, describe[key].substring(0, 15) + (describe[key].length > 15 ? '...' : ''))));
                })),
            loading &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Column Summary statistics are loading..."))));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ColumnSummaryStatistics);


/***/ }),

/***/ "./lib/components/taskpanes/ControlPanel/ControlPanelTaskpane.js":
/*!***********************************************************************!*\
  !*** ./lib/components/taskpanes/ControlPanel/ControlPanelTaskpane.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _css_default_taskpane_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../css/default-taskpane.css */ "./css/default-taskpane.css");
/* harmony import */ var _css_default_taskpane_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_default_taskpane_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _css_control_panel_taskpane_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../css/control-panel-taskpane.css */ "./css/control-panel-taskpane.css");
/* harmony import */ var _css_control_panel_taskpane_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_css_control_panel_taskpane_css__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _css_column_graph_and_describe_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../css/column-graph-and-describe.css */ "./css/column-graph-and-describe.css");
/* harmony import */ var _css_column_graph_and_describe_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_css_column_graph_and_describe_css__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _filter_FilterCard__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./filter/FilterCard */ "./lib/components/taskpanes/ControlPanel/filter/FilterCard.js");
/* harmony import */ var _SortCard__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./SortCard */ "./lib/components/taskpanes/ControlPanel/SortCard.js");
/* harmony import */ var _ColumnSummaryGraph__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ColumnSummaryGraph */ "./lib/components/taskpanes/ControlPanel/ColumnSummaryGraph.js");
/* harmony import */ var _ColumnNameCard__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./ColumnNameCard */ "./lib/components/taskpanes/ControlPanel/ColumnNameCard.js");
/* harmony import */ var _ColumnSummaryStatistics__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./ColumnSummaryStatistics */ "./lib/components/taskpanes/ControlPanel/ColumnSummaryStatistics.js");
/* harmony import */ var _ControlPanelTaskpaneTabs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./ControlPanelTaskpaneTabs */ "./lib/components/taskpanes/ControlPanel/ControlPanelTaskpaneTabs.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// import css










/*
    A modal that allows a user to rename, sort, and filter a column.
*/
function ControlPanelTaskpane(props) {
    const [selectedTab, setSelectedTab] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(0);
    const [columnDtype, setColumnDtype] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    async function loadColumnDtype() {
        const loadedColumnDtype = await props.mitoAPI.getColumnDtype(props.selectedSheetIndex, props.columnHeader);
        setColumnDtype(loadedColumnDtype);
    }
    (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
        void loadColumnDtype();
    }, []);
    const setSelectedTabCallback = (tabNumber) => {
        setSelectedTab(tabNumber);
        if (tabNumber == 0) {
            void props.mitoAPI.sendLogMessage('clicked_sort_and_filter_tab', {
                'column_header': props.columnHeader
            });
        }
        else {
            void props.mitoAPI.sendLogMessage('clicked_summary_statistics_tab', {
                'column_header': props.columnHeader
            });
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'control-panel-taskpane-container default-taskpane-div' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ColumnNameCard__WEBPACK_IMPORTED_MODULE_8__.default, { columnHeader: props.columnHeader, openEditingColumnHeader: props.openEditingColumnHeader, selectedSheetIndex: props.selectedSheetIndex, mitoAPI: props.mitoAPI, setCurrOpenTaskpane: props.setCurrOpenTaskpane }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                "dtype: ",
                columnDtype),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-body-div mb-30px' },
                selectedTab === 0 &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_SortCard__WEBPACK_IMPORTED_MODULE_6__.default, { selectedSheetIndex: props.selectedSheetIndex, columnHeader: props.columnHeader, columnType: props.columnType, mitoAPI: props.mitoAPI }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_filter_FilterCard__WEBPACK_IMPORTED_MODULE_5__.default, { selectedSheetIndex: props.selectedSheetIndex, columnHeader: props.columnHeader, filters: props.filters, columnType: props.columnType, operator: props.operator, mitoAPI: props.mitoAPI })),
                selectedTab === 1 &&
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ColumnSummaryGraph__WEBPACK_IMPORTED_MODULE_7__.default, { selectedSheetIndex: props.selectedSheetIndex, columnHeader: props.columnHeader, mitoAPI: props.mitoAPI }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ColumnSummaryStatistics__WEBPACK_IMPORTED_MODULE_9__.default, { selectedSheetIndex: props.selectedSheetIndex, columnHeader: props.columnHeader, mitoAPI: props.mitoAPI })))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_ControlPanelTaskpaneTabs__WEBPACK_IMPORTED_MODULE_10__.default, { selectedTab: selectedTab, setSelectedTab: setSelectedTabCallback })));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ControlPanelTaskpane);


/***/ }),

/***/ "./lib/components/taskpanes/ControlPanel/ControlPanelTaskpaneTabs.js":
/*!***************************************************************************!*\
  !*** ./lib/components/taskpanes/ControlPanel/ControlPanelTaskpaneTabs.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// import css

/*
    The tabs at the bottom of the column control panel that allows users to switch
    from sort/filter to seeing summary statistics about the column
*/
function ControlPanelTaskpaneTabs(props) {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'control-panel-taskpane-tab-container' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'control-panel-taskpane-tab' + (props.selectedTab === 0 ? ' selected' : ' unselected'), onClick: () => props.setSelectedTab(0) },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Filter/Sort")),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'control-panel-taskpane-tab' + (props.selectedTab === 1 ? ' selected' : ' unselected'), onClick: () => props.setSelectedTab(1) },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Summary Stats"))));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ControlPanelTaskpaneTabs);


/***/ }),

/***/ "./lib/components/taskpanes/ControlPanel/SortCard.js":
/*!***********************************************************!*\
  !*** ./lib/components/taskpanes/ControlPanel/SortCard.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SortDirection": () => (/* binding */ SortDirection),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// import css

var SortDirection;
(function (SortDirection) {
    SortDirection["ASCENDING"] = "ascending";
    SortDirection["DESCENDING"] = "descending";
    SortDirection["NONE"] = "none";
})(SortDirection || (SortDirection = {}));
/*
    A modal that allows a user to sort a column
*/
class SortCard extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.setSortDirection = (sortDirection) => {
            // if the user toggled the button that was already selected, turn off the sort
            if (sortDirection == this.state.sortDirection) {
                this.setState({
                    sortDirection: SortDirection.NONE
                });
                return;
            }
            // otherwise the user selected a new direction, so set that as the sortDirection
            this.setState({
                sortDirection: sortDirection
            }, () => {
                // then sort the column
                void this.sendSortUpdateMessage();
            });
        };
        this.sendSortUpdateMessage = async () => {
            // sort the columns if the sortDirection is not None
            if (this.state.sortDirection != SortDirection.NONE) {
                const stepID = await this.props.mitoAPI.sendSortMessage(this.props.selectedSheetIndex, this.props.columnHeader, this.state.sortDirection, this.state.stepID);
                this.setState({ stepID: stepID });
            }
        };
        this.state = {
            sortDirection: SortDirection.NONE,
            stepID: ''
        };
        this.sendSortUpdateMessage = this.sendSortUpdateMessage.bind(this);
        this.setSortDirection = this.setSortDirection.bind(this);
    }
    render() {
        // determine css styling of sort buttons
        const ascendingButtonClass = this.state.sortDirection == SortDirection.ASCENDING ? 'sort-button sort-button-selected' : 'sort-button sort-button-unselected';
        const descendingButtonClass = this.state.sortDirection == SortDirection.DESCENDING ? 'sort-button sort-button-selected' : 'sort-button sort-button-unselected';
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'filter-modal-section-title' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, " Sort ")),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "filter-modal-centering-container" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'sort-buttons-div' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: ascendingButtonClass, onClick: () => this.setSortDirection(SortDirection.ASCENDING) }, "Ascending"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("button", { className: descendingButtonClass, onClick: () => this.setSortDirection(SortDirection.DESCENDING) }, "Descending")))));
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SortCard);


/***/ }),

/***/ "./lib/components/taskpanes/ControlPanel/filter/Filter.js":
/*!****************************************************************!*\
  !*** ./lib/components/taskpanes/ControlPanel/filter/Filter.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Filter": () => (/* binding */ Filter)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _filterConditions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./filterConditions */ "./lib/components/taskpanes/ControlPanel/filter/filterConditions.js");
/* harmony import */ var _css_filter_card_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../css/filter-card.css */ "./css/filter-card.css");
/* harmony import */ var _css_filter_card_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_filter_card_css__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


// import css

/*
    
*/
function Filter(props) {
    // We hide the input if it is not necessary
    const inputStyle = _filterConditions__WEBPACK_IMPORTED_MODULE_1__.CONDITIONS_WITH_NO_INPUT.includes(props.filter.condition) ? { 'visibility': 'hidden' } : { 'visibility': 'visible' };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'filter-object' },
        props.first &&
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'filter-where-label mr-10px' }, "Where"),
        !props.first &&
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("select", { className: 'filter-select filter-operator mr-10px', value: props.operator, onChange: (e) => { props.setOperator(e.target.value); } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { value: 'And' }, "And"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { value: 'Or' }, "Or")),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("select", { className: 'filter-select filter-condition filter-object-item', value: props.filter.condition, onChange: (e) => {
                // We perform some unplesant type casting to keep the code
                // short here
                props.setFilter({
                    type: props.filter.type,
                    condition: e.target.value,
                    value: props.filter.value
                });
            } },
            props.filter.type === 'string' && _filterConditions__WEBPACK_IMPORTED_MODULE_1__.STRING_DROPDOWN_OPTIONS,
            props.filter.type === 'number' && _filterConditions__WEBPACK_IMPORTED_MODULE_1__.NUMBER_DROPDOWN_OPTIONS,
            props.filter.type === 'datetime' && _filterConditions__WEBPACK_IMPORTED_MODULE_1__.DATETIME_DROPDOWN_OPTIONS),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { className: 'filter-select filter-value filter-object-item', style: inputStyle, type: props.filter.type === 'datetime' ? 'date' : 'text', value: props.filter.value, onChange: e => {
                props.setFilter({
                    type: props.filter.type,
                    condition: props.filter.condition,
                    value: e.target.value
                });
            } }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'filter-object-item filter-close-button', onClick: () => props.deleteFilter() },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "15", height: "15", viewBox: "0 0 13 13", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "0.707107", y1: "1.29289", x2: "11.3136", y2: "11.8994", stroke: "#343434", strokeWidth: "2" }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "0.7072", y1: "11.8995", x2: "11.3137", y2: "1.29297", stroke: "#343434", strokeWidth: "2" })))));
}


/***/ }),

/***/ "./lib/components/taskpanes/ControlPanel/filter/FilterCard.js":
/*!********************************************************************!*\
  !*** ./lib/components/taskpanes/ControlPanel/filter/FilterCard.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _filterTypes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./filterTypes */ "./lib/components/taskpanes/ControlPanel/filter/filterTypes.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils */ "./lib/components/taskpanes/ControlPanel/filter/utils.js");
/* harmony import */ var _Filter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Filter */ "./lib/components/taskpanes/ControlPanel/filter/Filter.js");
/* harmony import */ var _FilterGroup__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./FilterGroup */ "./lib/components/taskpanes/ControlPanel/filter/FilterGroup.js");
/* harmony import */ var _filterConditions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./filterConditions */ "./lib/components/taskpanes/ControlPanel/filter/filterConditions.js");
/* harmony import */ var _css_filter_card_css__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../../css/filter-card.css */ "./css/filter-card.css");
/* harmony import */ var _css_filter_card_css__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(_css_filter_card_css__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_7__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.








const ADD_FILTER_SELECT_TITLE = '+ Add Filter';
/*
    Component that contains all that one needs to filter!
*/
class FilterCard extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.state = {
            filters: props.filters,
            operator: props.operator,
            stepID: '',
            filterSelect: ADD_FILTER_SELECT_TITLE
        };
        this.sendFilterUpdateMessage = this.sendFilterUpdateMessage.bind(this);
        this.addFilter = this.addFilter.bind(this);
        this.addFilterGroup = this.addFilterGroup.bind(this);
        this.addFilterToGroup = this.addFilterToGroup.bind(this);
        this.deleteFilter = this.deleteFilter.bind(this);
        this.deleteFilterFromGroup = this.deleteFilterFromGroup.bind(this);
        this.setFilter = this.setFilter.bind(this);
        this.setFilterInGroup = this.setFilterInGroup.bind(this);
        this.setOperator = this.setOperator.bind(this);
        this.setOperatorInGroup = this.setOperatorInGroup.bind(this);
    }
    /*
        Before sending the displayed filters, we parse all the number filters from strings
        to numbers, and then filter out all of the invalid filters (as to not cause errors)
    */
    async sendFilterUpdateMessage() {
        /*
            A filter is invalid if:
            1. It should have an input, and it does not
            2. It is a number filter with a string input, or with a non-valid number input
        */
        const isValidFilter = (filter) => {
            if (_filterConditions__WEBPACK_IMPORTED_MODULE_5__.CONDITIONS_WITH_NO_INPUT.includes(filter.condition)) {
                return true;
            }
            if (filter.type === 'number') {
                return typeof filter.value !== 'string' && !isNaN(filter.value);
            }
            if (filter.type === 'string' || filter.type === 'datetime') {
                return filter.value !== '';
            }
            return true;
        };
        /*
            The frontend stores number filters as strings, and so we parse them to
            numbers before sending them to the backend
        */
        const parseFilter = (filter) => {
            if (filter.type === 'number' && typeof filter.value === 'string') {
                return {
                    type: filter.type,
                    condition: filter.condition,
                    value: parseFloat(filter.value)
                };
            }
            return filter;
        };
        // To handle decimals, we allow decimals to be submitted, and then just
        // parse them before they are sent to the back-end
        const parsedFilters = this.state.filters.map((filterOrGroup) => {
            if ((0,_filterTypes__WEBPACK_IMPORTED_MODULE_1__.isFilterGroup)(filterOrGroup)) {
                return {
                    filters: filterOrGroup.filters.map((filter) => {
                        return parseFilter(filter);
                    }),
                    operator: filterOrGroup.operator
                };
            }
            else {
                return parseFilter(filterOrGroup);
            }
        });
        const filtersToApply = parsedFilters.map((filterOrGroup) => {
            // Filter out these incomplete filters from the group
            if ((0,_filterTypes__WEBPACK_IMPORTED_MODULE_1__.isFilterGroup)(filterOrGroup)) {
                return {
                    filters: filterOrGroup.filters.filter((filter) => {
                        return isValidFilter(filter);
                    }),
                    operator: filterOrGroup.operator
                };
            }
            else {
                return filterOrGroup;
            }
        }).filter((filterOrGroup) => {
            // Filter out the groups if they have no valid filters in them
            if ((0,_filterTypes__WEBPACK_IMPORTED_MODULE_1__.isFilterGroup)(filterOrGroup)) {
                return filterOrGroup.filters.length > 0;
            }
            // And then we filter the non group filters to be non-empty
            return isValidFilter(filterOrGroup);
        });
        const stepID = await this.props.mitoAPI.sendFilterMessage(this.props.selectedSheetIndex, this.props.columnHeader, filtersToApply, this.state.operator, this.state.stepID);
        this.setState({ stepID: stepID });
    }
    /*
        Adds a new, blank filter to the end of the filters list
    */
    addFilter() {
        this.setState(prevState => {
            const newFilters = [...prevState.filters];
            newFilters.push((0,_utils__WEBPACK_IMPORTED_MODULE_2__.getEmptyFilterData)(this.props.columnType));
            return {
                filters: newFilters
            };
        }, () => {
            void this.sendFilterUpdateMessage();
        });
    }
    /*
        Creates a new filter group (at the bottom) with a single empty
        filter
    */
    addFilterGroup() {
        this.setState(prevState => {
            const newFilters = [...prevState.filters];
            newFilters.push({
                filters: [
                    (0,_utils__WEBPACK_IMPORTED_MODULE_2__.getEmptyFilterData)(this.props.columnType)
                ],
                operator: 'And'
            });
            return {
                filters: newFilters
            };
        }, () => {
            void this.sendFilterUpdateMessage();
        });
    }
    /*
        Adds a blank new filter to the end of a specific group
    */
    addFilterToGroup(groupIndex) {
        this.setState(prevState => {
            const newFilters = [...prevState.filters];
            const filterGroup = newFilters[groupIndex];
            if ((0,_filterTypes__WEBPACK_IMPORTED_MODULE_1__.isFilterGroup)(filterGroup)) {
                // If we do have a filter group at that groupIndex, then we add a new filter to it
                filterGroup.filters.push((0,_utils__WEBPACK_IMPORTED_MODULE_2__.getEmptyFilterData)(this.props.columnType));
                return {
                    filters: newFilters
                };
            }
            else {
                // We make no changes if this was not a filter group, which should never occur
                return null;
            }
        }, () => {
            void this.sendFilterUpdateMessage();
        });
    }
    /*
        Deletes a filter that is at the given index in the main
        filter list.
    */
    deleteFilter(filterIndex) {
        this.setState(prevState => {
            const newFilters = [...prevState.filters];
            newFilters.splice(filterIndex, 1);
            return {
                filters: newFilters
            };
        }, () => {
            void this.sendFilterUpdateMessage();
        });
    }
    /*
        Deletes a filter that is at a given index in filter list
        of a specific filter group
    */
    deleteFilterFromGroup(groupIndex, filterIndex) {
        this.setState(prevState => {
            const newFilters = [...prevState.filters];
            const filterGroup = newFilters[groupIndex];
            if ((0,_filterTypes__WEBPACK_IMPORTED_MODULE_1__.isFilterGroup)(filterGroup)) {
                // If we do have a filter group at that groupIndex, then we delete the filter
                // at the passed filterIndex
                filterGroup.filters.splice(filterIndex, 1);
                // If there are no filters left in this group, then we remove the entire group
                if (filterGroup.filters.length === 0) {
                    newFilters.splice(groupIndex, 1);
                }
                return {
                    filters: newFilters
                };
            }
            else {
                // We make no changes if this was not a filter group, which should never occur
                return null;
            }
        }, () => {
            void this.sendFilterUpdateMessage();
        });
    }
    /*
        Sets a filter at the given index to the new filter value
    */
    setFilter(filterIndex, filter) {
        this.setState(prevState => {
            const newFilters = [...prevState.filters];
            newFilters[filterIndex] = filter;
            return {
                filters: newFilters
            };
        }, () => {
            void this.sendFilterUpdateMessage();
        });
    }
    /*
        Sets a filter at the given filterIndex in the specific group at the given
        groupIndex to the new filter value
    */
    setFilterInGroup(groupIndex, filterIndex, filter) {
        this.setState(prevState => {
            const newFilters = [...prevState.filters];
            const filterGroup = newFilters[groupIndex];
            if ((0,_filterTypes__WEBPACK_IMPORTED_MODULE_1__.isFilterGroup)(filterGroup)) {
                filterGroup.filters[filterIndex] = filter;
                return {
                    filters: newFilters
                };
            }
            else {
                // We make no changes if this was not a filter group, which should never occur
                return null;
            }
        }, () => {
            void this.sendFilterUpdateMessage();
        });
    }
    /*
        Sets the operator that combines the highest level filters and
        filter groups
    */
    setOperator(operator) {
        this.setState({ operator: operator }, () => {
            void this.sendFilterUpdateMessage();
        });
    }
    /*
        Sets the operator that combines a specific filter group
    */
    setOperatorInGroup(groupIndex, operator) {
        this.setState(prevState => {
            const newFilters = [...prevState.filters];
            const filterGroup = newFilters[groupIndex];
            if ((0,_filterTypes__WEBPACK_IMPORTED_MODULE_1__.isFilterGroup)(filterGroup)) {
                filterGroup.operator = operator;
                return {
                    filters: newFilters
                };
            }
            else {
                // We make no changes if this was not a filter group, which should never occur
                return null;
            }
        }, () => {
            void this.sendFilterUpdateMessage();
        });
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'filter-modal-section-title mt-25px' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, " Filter ")),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "filter-modal-centering-container" }, this.state.filters.map((filterOrGroup, index) => {
                if ((0,_filterTypes__WEBPACK_IMPORTED_MODULE_1__.isFilterGroup)(filterOrGroup)) {
                    return (
                    /*
                        If the FilterGroup is the first Filter or FilterGroup
                        in the FilterCard, add a 'Where'
                    */
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'filter-group-and-operator-div' },
                        index === 0 &&
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'filter-where-label filter-object-item mr-10px' }, "Where"),
                        index !== 0 &&
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'filter-select filter-operator mr-10px' },
                                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("select", { className: 'filter-select filter-operator mr-10px', value: this.state.operator, onChange: (e) => { this.setOperator(e.target.value); } },
                                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { value: 'And' }, "And"),
                                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { value: 'Or' }, "Or"))),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_FilterGroup__WEBPACK_IMPORTED_MODULE_4__.default, { key: index, mainOperator: this.state.operator, filters: filterOrGroup.filters, groupOperator: filterOrGroup.operator, setFilter: (filterIndex, newFilter) => {
                                this.setFilterInGroup(index, filterIndex, newFilter);
                            }, setOperator: (newOperator) => {
                                this.setOperatorInGroup(index, newOperator);
                            }, deleteFilter: (filterIndex) => {
                                this.deleteFilterFromGroup(index, filterIndex);
                            }, addFilter: () => this.addFilterToGroup(index) })));
                }
                else {
                    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Filter__WEBPACK_IMPORTED_MODULE_3__.Filter, { first: index === 0, key: index, filter: filterOrGroup, operator: this.state.operator, displayOperator: true, setFilter: (newFilter) => {
                            this.setFilter(index, newFilter);
                        }, setOperator: this.setOperator, deleteFilter: () => { this.deleteFilter(index); } }));
                }
            })),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'filter-card-buttons-container' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("select", { className: 'filter-add-filter-button', value: ADD_FILTER_SELECT_TITLE, onChange: (e) => {
                        if (e.target.value === 'filter') {
                            this.addFilter();
                        }
                        else {
                            this.addFilterGroup();
                        }
                        // Set this so it's always what is selected
                        this.setState({ filterSelect: ADD_FILTER_SELECT_TITLE });
                    } },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { selected: true, hidden: true }, ADD_FILTER_SELECT_TITLE),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { value: 'filter' }, "+ Add a Filter"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { value: 'filter-group' }, "+ Add a group of filters")))));
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FilterCard);


/***/ }),

/***/ "./lib/components/taskpanes/ControlPanel/filter/FilterGroup.js":
/*!*********************************************************************!*\
  !*** ./lib/components/taskpanes/ControlPanel/filter/FilterGroup.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ FilterGroup)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Filter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Filter */ "./lib/components/taskpanes/ControlPanel/filter/Filter.js");
/* harmony import */ var _css_filter_card_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../css/filter-card.css */ "./css/filter-card.css");
/* harmony import */ var _css_filter_card_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_filter_card_css__WEBPACK_IMPORTED_MODULE_2__);



/*
    Component that contains a group of filters
*/
function FilterGroup(props) {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: "filter-group filter-object-item" },
        props.filters.map((filter, index) => {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Filter__WEBPACK_IMPORTED_MODULE_1__.Filter, { first: index === 0, key: index, filter: filter, operator: props.groupOperator, displayOperator: true, setFilter: (newFilter) => {
                    props.setFilter(index, newFilter);
                }, setOperator: props.setOperator, deleteFilter: () => { props.deleteFilter(index); } }));
        }),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'filter-add-filter-button', onClick: props.addFilter }, "+ Add a Filter")));
}


/***/ }),

/***/ "./lib/components/taskpanes/ControlPanel/filter/filterConditions.js":
/*!**************************************************************************!*\
  !*** ./lib/components/taskpanes/ControlPanel/filter/filterConditions.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NUMBER_DROPDOWN_OPTIONS": () => (/* binding */ NUMBER_DROPDOWN_OPTIONS),
/* harmony export */   "STRING_DROPDOWN_OPTIONS": () => (/* binding */ STRING_DROPDOWN_OPTIONS),
/* harmony export */   "DATETIME_DROPDOWN_OPTIONS": () => (/* binding */ DATETIME_DROPDOWN_OPTIONS),
/* harmony export */   "CONDITIONS_WITH_NO_INPUT": () => (/* binding */ CONDITIONS_WITH_NO_INPUT)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _filterTypes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./filterTypes */ "./lib/components/taskpanes/ControlPanel/filter/filterTypes.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


const NUMBER_DROPDOWN_OPTIONS = [
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.NUMBER_EXACTLY, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.NUMBER_EXACTLY }, "="),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.GREATER, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.GREATER }, ">"),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.GREATER_THAN_OR_EQUAL, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.GREATER_THAN_OR_EQUAL }, "\u2265"),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.LESS, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.LESS }, "<"),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.LESS_THAN_OR_EQUAL, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.LESS_THAN_OR_EQUAL }, "\u2264"),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.EMPTY, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.EMPTY }, "is empty"),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.NOT_EMPTY, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.NOT_EMPTY }, "is not empty"),
];
const STRING_DROPDOWN_OPTIONS = [
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.StringFilterCondition.CONTAINS, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.StringFilterCondition.CONTAINS }, "contains"),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.StringFilterCondition.DOES_NOT_CONTAIN, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.StringFilterCondition.DOES_NOT_CONTAIN }, "does not contain"),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.StringFilterCondition.STRING_EXACTLY, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.StringFilterCondition.STRING_EXACTLY }, "is exactly"),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.StringFilterCondition.EMPTY, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.StringFilterCondition.EMPTY }, "is empty"),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.StringFilterCondition.NOT_EMPTY, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.StringFilterCondition.NOT_EMPTY }, "is not empty"),
];
const DATETIME_DROPDOWN_OPTIONS = [
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.DatetimeFilterCondition.DATETIME_EXTACTLY, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.DatetimeFilterCondition.DATETIME_EXTACTLY }, "="),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.DatetimeFilterCondition.DATETIME_GREATER_THAN, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.DatetimeFilterCondition.DATETIME_GREATER_THAN }, ">"),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.DatetimeFilterCondition.DATETIME_GREATER_THAN_OR_EQUAL, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.DatetimeFilterCondition.DATETIME_GREATER_THAN_OR_EQUAL }, "\u2265"),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.DatetimeFilterCondition.DATETIME_LESS, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.DatetimeFilterCondition.DATETIME_LESS }, "<"),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.DatetimeFilterCondition.DATETIME_LESS_THAN_OR_EQUAL, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.DatetimeFilterCondition.DATETIME_LESS_THAN_OR_EQUAL }, "\u2264"),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.DatetimeFilterCondition.EMPTY, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.StringFilterCondition.EMPTY }, "is empty"),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("option", { key: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.DatetimeFilterCondition.NOT_EMPTY, value: _filterTypes__WEBPACK_IMPORTED_MODULE_1__.StringFilterCondition.NOT_EMPTY }, "is not empty"),
];
const CONDITIONS_WITH_NO_INPUT = [
    _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.EMPTY,
    _filterTypes__WEBPACK_IMPORTED_MODULE_1__.NumberFilterCondition.NOT_EMPTY,
    _filterTypes__WEBPACK_IMPORTED_MODULE_1__.StringFilterCondition.EMPTY,
    _filterTypes__WEBPACK_IMPORTED_MODULE_1__.StringFilterCondition.NOT_EMPTY,
    _filterTypes__WEBPACK_IMPORTED_MODULE_1__.DatetimeFilterCondition.EMPTY,
    _filterTypes__WEBPACK_IMPORTED_MODULE_1__.DatetimeFilterCondition.NOT_EMPTY,
];


/***/ }),

/***/ "./lib/components/taskpanes/ControlPanel/filter/filterTypes.js":
/*!*********************************************************************!*\
  !*** ./lib/components/taskpanes/ControlPanel/filter/filterTypes.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StringFilterCondition": () => (/* binding */ StringFilterCondition),
/* harmony export */   "NumberFilterCondition": () => (/* binding */ NumberFilterCondition),
/* harmony export */   "DatetimeFilterCondition": () => (/* binding */ DatetimeFilterCondition),
/* harmony export */   "isFilterGroup": () => (/* binding */ isFilterGroup)
/* harmony export */ });
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.
var StringFilterCondition;
(function (StringFilterCondition) {
    StringFilterCondition["CONTAINS"] = "contains";
    StringFilterCondition["DOES_NOT_CONTAIN"] = "string_does_not_contain";
    StringFilterCondition["STRING_EXACTLY"] = "string_exactly";
    StringFilterCondition["EMPTY"] = "empty";
    StringFilterCondition["NOT_EMPTY"] = "not_empty";
})(StringFilterCondition || (StringFilterCondition = {}));
var NumberFilterCondition;
(function (NumberFilterCondition) {
    NumberFilterCondition["NUMBER_EXACTLY"] = "number_exactly";
    NumberFilterCondition["GREATER"] = "greater";
    NumberFilterCondition["GREATER_THAN_OR_EQUAL"] = "greater_than_or_equal";
    NumberFilterCondition["LESS"] = "less";
    NumberFilterCondition["LESS_THAN_OR_EQUAL"] = "less_than_or_equal";
    NumberFilterCondition["EMPTY"] = "empty";
    NumberFilterCondition["NOT_EMPTY"] = "not_empty";
})(NumberFilterCondition || (NumberFilterCondition = {}));
var DatetimeFilterCondition;
(function (DatetimeFilterCondition) {
    DatetimeFilterCondition["DATETIME_EXTACTLY"] = "datetime_exactly";
    DatetimeFilterCondition["DATETIME_GREATER_THAN"] = "datetime_greater";
    DatetimeFilterCondition["DATETIME_GREATER_THAN_OR_EQUAL"] = "datetime_greater_than_or_equal";
    DatetimeFilterCondition["DATETIME_LESS"] = "datetime_less";
    DatetimeFilterCondition["DATETIME_LESS_THAN_OR_EQUAL"] = "datetime_less_than_or_equal";
    DatetimeFilterCondition["EMPTY"] = "empty";
    DatetimeFilterCondition["NOT_EMPTY"] = "not_empty";
})(DatetimeFilterCondition || (DatetimeFilterCondition = {}));
// See: https://www.typescriptlang.org/docs/handbook/advanced-types.html#user-defined-type-guards
function isFilterGroup(filter) {
    return filter.filters !== undefined;
}


/***/ }),

/***/ "./lib/components/taskpanes/ControlPanel/filter/utils.js":
/*!***************************************************************!*\
  !*** ./lib/components/taskpanes/ControlPanel/filter/utils.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getEmptyFilterData": () => (/* binding */ getEmptyFilterData)
/* harmony export */ });
/* harmony import */ var _filterTypes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./filterTypes */ "./lib/components/taskpanes/ControlPanel/filter/filterTypes.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

function getEmptyFilterData(columnType) {
    switch (columnType) {
        case 'string': return {
            type: 'string',
            condition: _filterTypes__WEBPACK_IMPORTED_MODULE_0__.StringFilterCondition.CONTAINS,
            value: ''
        };
        case 'number': return {
            type: 'number',
            condition: _filterTypes__WEBPACK_IMPORTED_MODULE_0__.NumberFilterCondition.GREATER,
            value: ''
        };
        case 'datetime': return {
            type: 'datetime',
            condition: _filterTypes__WEBPACK_IMPORTED_MODULE_0__.DatetimeFilterCondition.DATETIME_EXTACTLY,
            value: ''
        };
    }
}


/***/ }),

/***/ "./lib/components/taskpanes/ControlPanel/renameUtils.js":
/*!**************************************************************!*\
  !*** ./lib/components/taskpanes/ControlPanel/renameUtils.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "isFullyNumeric": () => (/* binding */ isFullyNumeric),
/* harmony export */   "isValidHeader": () => (/* binding */ isValidHeader),
/* harmony export */   "getHeaderErrorMessage": () => (/* binding */ getHeaderErrorMessage)
/* harmony export */ });
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.
const isFullyNumeric = (s) => {
    // Returns true if the given string is a number
    for (let i = 0; i < s.length; i++) {
        const c = s.charAt(i);
        if (c < '0' || c > '9') {
            return false;
        }
    }
    return true;
};
const isValidHeader = (columnHeader) => {
    // To be a valid header:
    // 1. Matches the regex [A-z0-9_]+ (just once, the entire string)
    // 2. Is not all digits (aka cannot be mistake for a number)
    // Check (1)
    const re = /[A-z0-9_]+/;
    const matches = re.exec(columnHeader);
    if (matches === null || matches.length != 1 || matches[0] !== columnHeader) {
        return false;
    }
    // Check (2) (all digits)
    return !isFullyNumeric(columnHeader);
};
const getHeaderErrorMessage = (columnHeader) => {
    /*
        Given a column header, returns a message about _how_ that columnHeader is invalid,
        where it can detect three cases currently:
        1. The column header includes whitespace.
        2. The column header includes _only_ numbers.
        3. The column header includes a "-".
        4. A catch-all: the column header is invalid in other ways.

        Note: We can expand these as we see users make more invalid column headers
        and see what types of errors are common!

        If the columnHeader is valid returns the empty string.
    
    */
    if (isValidHeader(columnHeader) || columnHeader.length === 0) {
        return '';
    }
    // Check for whitespace
    if (columnHeader.indexOf(' ') >= 0) {
        return `Invalid column name. Please remove all spaces.`;
    }
    // Check if it's got a -
    if (columnHeader.indexOf('-') >= 0) {
        return `Invalid column name. Try switching "-" for "_".`;
    }
    // Check if it's only numbers
    if (isFullyNumeric(columnHeader)) {
        return `Invalid column name. Add at least one non-digit.`;
    }
    // Catch the rest... :( )
    return 'Invalid column name. All characters must be letters, digits, and "_".';
};


/***/ }),

/***/ "./lib/components/taskpanes/DefaultTaskpane.js":
/*!*****************************************************!*\
  !*** ./lib/components/taskpanes/DefaultTaskpane.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_default_taskpane_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../css/default-taskpane.css */ "./css/default-taskpane.css");
/* harmony import */ var _css_default_taskpane_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_default_taskpane_css__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _taskpanes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./taskpanes */ "./lib/components/taskpanes/taskpanes.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// import css


/*
    DefaultTaskpane is a higher-order component that
    takes a header and a taskpaneBbody, and displays it as a component.

    The modal has props
    - a header string to be shown at the top of the taskpane
    - a taskpaneBody, a react fragment which is the center segment of the taskpane
    - a setTaskpaneOpenOrClosed function to close the taskpane
*/
const DefaultTaskpane = (props) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-div' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-header-div' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'default-taskpane-header-text' }, props.header),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-header-exit-button-div', onClick: () => props.setCurrOpenTaskpane({ type: _taskpanes__WEBPACK_IMPORTED_MODULE_2__.TaskpaneType.NONE }) },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "18", height: "18", viewBox: "0 0 13 13", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "0.707107", y1: "1.29289", x2: "11.3136", y2: "11.8994", stroke: "#343434", strokeWidth: "2" }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "0.7072", y1: "11.8995", x2: "11.3137", y2: "1.29297", stroke: "#343434", strokeWidth: "2" })))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-body-div' }, props.taskpaneBody)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DefaultTaskpane);


/***/ }),

/***/ "./lib/components/taskpanes/Documentation/BasicExampleContainer.js":
/*!*************************************************************************!*\
  !*** ./lib/components/taskpanes/Documentation/BasicExampleContainer.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "basicExamples": () => (/* binding */ basicExamples),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _CallMitoSheetExampleContent__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CallMitoSheetExampleContent */ "./lib/components/taskpanes/Documentation/CallMitoSheetExampleContent.js");
/* harmony import */ var _FirstFormulaExampleContent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FirstFormulaExampleContent */ "./lib/components/taskpanes/Documentation/FirstFormulaExampleContent.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.



const basicExamples = [
    {
        basicExampleName: 'Basic Mitosheet Python Example',
        content: _CallMitoSheetExampleContent__WEBPACK_IMPORTED_MODULE_1__.default
    },
    {
        basicExampleName: 'Writing your first formula',
        content: _FirstFormulaExampleContent__WEBPACK_IMPORTED_MODULE_2__.default
    }
];
/*
    This container displays a single basic example, depending on
    what it is told to display!
*/
const BasicExampleContainer = (props) => {
    const basicExample = basicExamples.find((basicExample) => {
        return basicExample.basicExampleName == props.basicExampleName;
    });
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null, basicExample === null || basicExample === void 0 ? void 0 : basicExample.content()));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (BasicExampleContainer);


/***/ }),

/***/ "./lib/components/taskpanes/Documentation/CallMitoSheetExampleContent.js":
/*!*******************************************************************************!*\
  !*** ./lib/components/taskpanes/Documentation/CallMitoSheetExampleContent.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _Tooltip__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Tooltip */ "./lib/components/Tooltip.js");
/* harmony import */ var _css_documentation_basic_example_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../css/documentation-basic-example.css */ "./css/documentation-basic-example.css");
/* harmony import */ var _css_documentation_basic_example_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_documentation_basic_example_css__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

// Import Components 


/*
    Returns a documentation entry for displaying your first
    mito sheet - with copyable Python code!
*/
const CallMitoSheetExampleContent = () => {
    const [copyStatus, setCopyStatus] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('Click to copy!');
    const copyToClipBoard = () => {
        // We create a temporary element to make copying to the clipboard easy!
        const elem = document.createElement("textarea");
        document.body.appendChild(elem);
        elem.value = 'import pandas as pd\nimport mitosheet\ndf = pd.DataFrame(data={\'Data\': [\'ABC\', \'DEF\']})\nmitosheet.sheet(df)';
        elem.select();
        document.execCommand("copy");
        document.body.removeChild(elem);
        setCopyStatus('Copied!');
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-basic-example-title' }, "Basic Example Documentation"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "To edit a Mito sheet, you first have to display your data inside one!"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-basic-example-section-title' }, "Instructions"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Copy the following code into a cell in your notebook, and run it:"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-basic-example-python' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-basic-example-python-code mb-1', onClick: copyToClipBoard, onMouseLeave: () => { setCopyStatus('Click to copy!'); } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "import pandas as pd"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "import mitosheet"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                    "df = pd.DataFrame(data=",
                    '{',
                    "'Data': ['ABC', 'DEF']",
                    '}'),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "mitosheet.sheet(df)")),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_Tooltip__WEBPACK_IMPORTED_MODULE_1__.default, { tooltip: copyStatus }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CallMitoSheetExampleContent);


/***/ }),

/***/ "./lib/components/taskpanes/Documentation/DocumentationListContent.js":
/*!****************************************************************************!*\
  !*** ./lib/components/taskpanes/Documentation/DocumentationListContent.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_documentation_taskpane_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../css/documentation-taskpane.css */ "./css/documentation-taskpane.css");
/* harmony import */ var _css_documentation_taskpane_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_documentation_taskpane_css__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _data_function_documentation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../data/function_documentation */ "./lib/data/function_documentation.js");
/* harmony import */ var _BasicExampleContainer__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./BasicExampleContainer */ "./lib/components/taskpanes/Documentation/BasicExampleContainer.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


const listIcon = (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "16", height: "18", viewBox: "0 0 16 18", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("mask", { id: "path-1-inside-1", fill: "white" },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { width: "16", height: "18", rx: "1" })),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { width: "16", height: "18", rx: "1", stroke: "#0081DE", strokeWidth: "2.4", mask: "url(#path-1-inside-1)" }),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "2", y1: "3.2", x2: "14", y2: "3.2", stroke: "#0081DE", strokeWidth: "1.2" }),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "2", y1: "7", x2: "14", y2: "7", stroke: "#0081DE", strokeWidth: "1.2" }),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "2", y1: "10.8", x2: "14", y2: "10.8", stroke: "#0081DE", strokeWidth: "1.2" }),
    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "2", y1: "14.6", x2: "14", y2: "14.6", stroke: "#0081DE", strokeWidth: "1.2" })));


/*
    This documentation taskpane content displays a list of all
    documentation entries users can select.

    These are either:
    1. Basic examples (e.g. how to write a formula)
    2. Function documentations
*/
const DocumentationListContent = (props) => {
    const basicExamplesList = _BasicExampleContainer__WEBPACK_IMPORTED_MODULE_3__.basicExamples.map((basicExample) => {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { className: 'documentation-taskpane-content-function-list-element', key: basicExample.basicExampleName, onClick: () => {
                // Log the selection of the basic documentation
                // NOTE: we don't need to wait on this promise, as we don't care when
                // it finishes
                void props.mitoAPI.sendLogMessage('documentation_log_event', {
                    kind: 'basic',
                    function: basicExample.basicExampleName
                });
                // Set the documentation element
                props.setSelectedDocumentation({
                    kind: 'basic',
                    basicExampleName: basicExample.basicExampleName
                });
            } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-taskpane-content-function-list-icon' }, listIcon),
            basicExample.basicExampleName));
    });
    const functionNameList = _data_function_documentation__WEBPACK_IMPORTED_MODULE_2__.functionDocumentationObjects.map((funcDocObject) => {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { className: 'documentation-taskpane-content-function-list-element', key: funcDocObject.function, onClick: () => {
                // Log they selected this function
                // NOTE: we don't need to wait on this promise, as we don't care
                // when it finishes
                void props.mitoAPI.sendLogMessage('documentation_log_event', {
                    kind: 'function',
                    function: funcDocObject.function
                });
                // Set the documentation
                props.setSelectedDocumentation({
                    kind: 'function',
                    function: funcDocObject.function
                });
            } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-taskpane-content-function-list-icon' }, listIcon),
            funcDocObject.function));
    });
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-taskpane-content-function-list-title' }, "Basic Examples"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", { className: 'documentation-taskpane-content-function-list' }, basicExamplesList),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-taskpane-content-function-list-section-title' }, "Functions"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", { className: 'documentation-taskpane-content-function-list' }, functionNameList)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DocumentationListContent);


/***/ }),

/***/ "./lib/components/taskpanes/Documentation/DocumentationTaskpane.js":
/*!*************************************************************************!*\
  !*** ./lib/components/taskpanes/Documentation/DocumentationTaskpane.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _taskpanes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../taskpanes */ "./lib/components/taskpanes/taskpanes.js");
/* harmony import */ var _FunctionDocumentationContent__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FunctionDocumentationContent */ "./lib/components/taskpanes/Documentation/FunctionDocumentationContent.js");
/* harmony import */ var _DocumentationListContent__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./DocumentationListContent */ "./lib/components/taskpanes/Documentation/DocumentationListContent.js");
/* harmony import */ var _BasicExampleContainer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./BasicExampleContainer */ "./lib/components/taskpanes/Documentation/BasicExampleContainer.js");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_5__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


// Import the content this displays



// Import css

/*
    This object holds the documentation taskpane, as well as the
    state currently displayed by the documentation.

    This can either be:
    1. A list of all content (when selectedDocumentation is undefined)
    2. Documentation for a specific function (when typeof selectedDocumentation is FunctionDocumentation)
    3. Documentation for some basic example (when typeof selectedDocumentation is BasicDocumentation)
*/
const DocumentationTaskpane = (props) => {
    const [selectedDocumentation, setSelectedDocumentation] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(undefined);
    const getSelectedDocumentationContent = () => {
        // Returns the selected documentation, which is either nothing (the list of all documentation), 
        // a basic example, or a specific function.
        if (selectedDocumentation === undefined) {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DocumentationListContent__WEBPACK_IMPORTED_MODULE_3__.default, { setSelectedDocumentation: setSelectedDocumentation, mitoAPI: props.mitoAPI }));
        }
        else if (selectedDocumentation.kind === 'basic') {
            return react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_BasicExampleContainer__WEBPACK_IMPORTED_MODULE_4__.default, { basicExampleName: selectedDocumentation.basicExampleName });
        }
        else if (selectedDocumentation.kind === 'function') {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_FunctionDocumentationContent__WEBPACK_IMPORTED_MODULE_2__.default, { function: selectedDocumentation.function }));
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-div' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-header-div' },
            selectedDocumentation === undefined &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-header-text' }, "Documentation"),
            selectedDocumentation !== undefined &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-taskpane-header-back-and-title' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-taskpane-header-back', onClick: () => { setSelectedDocumentation(undefined); } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "12", height: "16", viewBox: "0 0 12 16", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M0.292893 7.29289C-0.0976311 7.68342 -0.0976311 8.31658 0.292893 8.70711L6.65685 15.0711C7.04738 15.4616 7.68054 15.4616 8.07107 15.0711C8.46159 14.6805 8.46159 14.0474 8.07107 13.6569L2.41421 8L8.07107 2.34315C8.46159 1.95262 8.46159 1.31946 8.07107 0.928932C7.68054 0.538408 7.04738 0.538408 6.65685 0.928932L0.292893 7.29289ZM12 7L1 7V9L12 9V7Z", fill: "#343434" }))),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-header-text' }, "Documentation")),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-header-exit-button-div', onClick: () => props.setCurrOpenTaskpane({ type: _taskpanes__WEBPACK_IMPORTED_MODULE_1__.TaskpaneType.NONE }) },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "18", height: "18", viewBox: "0 0 13 13", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "0.707107", y1: "1.29289", x2: "11.3136", y2: "11.8994", stroke: "#343434", strokeWidth: "2" }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "0.7072", y1: "11.8995", x2: "11.3137", y2: "1.29297", stroke: "#343434", strokeWidth: "2" })))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-body-div' }, getSelectedDocumentationContent())));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DocumentationTaskpane);


/***/ }),

/***/ "./lib/components/taskpanes/Documentation/FirstFormulaExampleContent.js":
/*!******************************************************************************!*\
  !*** ./lib/components/taskpanes/Documentation/FirstFormulaExampleContent.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_documentation_basic_example_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../css/documentation-basic-example.css */ "./css/documentation-basic-example.css");
/* harmony import */ var _css_documentation_basic_example_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_documentation_basic_example_css__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


/*
    Returns a documentation entry telling a user how to
    write their first formula!
*/
const FirstFormulaExampleContent = () => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-basic-example-title' }, "Writing your first formula"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Mito allows you to write Excel-like formulas to transform your data."),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-basic-example-section-title' }, "Instructions"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ol", { className: 'documentation-basic-example-instructions-list' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { className: 'documentation-basic-example-instructions-list-element' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "1."),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-basic-example-instructions-list-element-content' },
                    "Click the Add Column button in the Mito toolbar to create an empty column on the right of the sheet.",
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { className: 'documentation-basic-example-instructions-list-element-content-centered', width: "22", height: "30", viewBox: "0 0 8 12", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M6.45459 1V2.81818", stroke: "#343434", strokeWidth: "0.7", strokeLinecap: "round" }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M7.36365 1.90909L5.54547 1.90909", stroke: "#343434", strokeWidth: "0.7", strokeLinecap: "round" }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M6.45455 4.18182V6.90909V10.5455C6.45455 10.7965 6.25104 11 6 11H1.45455C1.20351 11 1 10.7965 1 10.5455V1.45455C1 1.20351 1.20351 1 1.45455 1H4.8961", stroke: "#343434", strokeWidth: "0.7" }),
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { x: "1", y: "4.63635", width: "5.45455", height: "3.63636", fill: "#343434", fillOpacity: "0.19" })))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { className: 'documentation-basic-example-instructions-list-element' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "2."),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-basic-example-instructions-list-element-content' },
                    "Double click on a cell in the new column and write a basic formula:",
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-basic-example-instructions-list-element-content-centered' }, "=4 + 5"))),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { className: 'documentation-basic-example-instructions-list-element' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "3."),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-basic-example-instructions-list-element-content' },
                    "Double click the cell again. Enter the formula:",
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-basic-example-instructions-list-element-content-centered mb-1' }, "=LEFT(FirstColumn)"),
                    "Replace FirstColumn with the name of the first column in your data. The column will update with the first characters from the first column!")),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { className: 'documentation-basic-example-instructions-list-element' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null, "4."),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'documentation-basic-example-instructions-list-element-content' }, "To see a full list of the functions available, click the back arrow at the top of this taskpane and scroll down!")))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FirstFormulaExampleContent);


/***/ }),

/***/ "./lib/components/taskpanes/Documentation/FunctionDocumentationContent.js":
/*!********************************************************************************!*\
  !*** ./lib/components/taskpanes/Documentation/FunctionDocumentationContent.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_function_documentation_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../css/function-documentation.css */ "./css/function-documentation.css");
/* harmony import */ var _css_function_documentation_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_function_documentation_css__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _data_function_documentation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../data/function_documentation */ "./lib/data/function_documentation.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.




/*
    Returns content for the documentation taskpane that includes documentation
    for a specific function!
*/
const FunctionDocumentationContent = (props) => {
    var _a, _b;
    const funcDocObject = _data_function_documentation__WEBPACK_IMPORTED_MODULE_3__.functionDocumentationObjects.find((funcDocObject) => {
        return funcDocObject.function === props.function;
    });
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h1", { className: 'function-documentation-function-name' }, funcDocObject === null || funcDocObject === void 0 ? void 0 : funcDocObject.function),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, funcDocObject === null || funcDocObject === void 0 ? void 0 : funcDocObject.description),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", { className: 'mb-0' }, "Examples"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", { className: 'function-documentation-example-list blue-text' }, (_a = funcDocObject === null || funcDocObject === void 0 ? void 0 : funcDocObject.examples) === null || _a === void 0 ? void 0 : _a.map((example) => {
            return react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { className: 'function-documentation-example', key: example }, example);
        })),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("h2", { className: 'mb-0' }, "Syntax"),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'blue-text' }, funcDocObject === null || funcDocObject === void 0 ? void 0 : funcDocObject.syntax),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("ul", null, (_b = funcDocObject === null || funcDocObject === void 0 ? void 0 : funcDocObject.syntax_elements) === null || _b === void 0 ? void 0 : _b.map((syntax_element) => {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("li", { key: syntax_element.element },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'blue-text' }, syntax_element.element),
                syntax_element.description));
        }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (FunctionDocumentationContent);


/***/ }),

/***/ "./lib/components/taskpanes/Merge/MergeSheetAndKeySelection.js":
/*!*********************************************************************!*\
  !*** ./lib/components/taskpanes/Merge/MergeSheetAndKeySelection.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _elements_LargeSelect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../elements/LargeSelect */ "./lib/components/elements/LargeSelect.js");
/* harmony import */ var _css_merge_sheet_and_key_selection_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../css/merge-sheet-and-key-selection.css */ "./css/merge-sheet-and-key-selection.css");
/* harmony import */ var _css_merge_sheet_and_key_selection_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_merge_sheet_and_key_selection_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _MergeTaskpane__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./MergeTaskpane */ "./lib/components/taskpanes/Merge/MergeTaskpane.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


// import css


/*
  A custom component that allows you to select a sheet from the list of
  possible sheets, as well as a column header from that sheet.
*/
const MergeSheetAndKeySelection = (props) => {
    const sheetNumStr = props.sheetNum == _MergeTaskpane__WEBPACK_IMPORTED_MODULE_3__.MergeSheet.First ? 'First' : 'Second';
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'merge-sheet-and-key' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'default-taskpane-body-section-title-text' },
                sheetNumStr,
                " Sheet"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_elements_LargeSelect__WEBPACK_IMPORTED_MODULE_1__.default, { startingValue: props.dfNames[props.sheetIndex], key: props.sheetIndex, optionsArray: props.dfNames, setValue: (value) => {
                    const newSheetIndex = props.dfNames.indexOf(value);
                    props.setNewSheetIndex(newSheetIndex);
                } })),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'default-taskpane-body-section-title-text' }, "Merge Key"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_elements_LargeSelect__WEBPACK_IMPORTED_MODULE_1__.default, { startingValue: props.mergeKey, key: props.mergeKey, optionsArray: props.columnHeaders, setValue: (newMergeKey) => { props.setNewMergeKey(newMergeKey); } }))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MergeSheetAndKeySelection);


/***/ }),

/***/ "./lib/components/taskpanes/Merge/MergeTaskpane.js":
/*!*********************************************************!*\
  !*** ./lib/components/taskpanes/Merge/MergeTaskpane.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MergeSheet": () => (/* binding */ MergeSheet),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DefaultTaskpane__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../DefaultTaskpane */ "./lib/components/taskpanes/DefaultTaskpane.js");
/* harmony import */ var _elements_MultiToggleBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../elements/MultiToggleBox */ "./lib/components/elements/MultiToggleBox.js");
/* harmony import */ var _mergeUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./mergeUtils */ "./lib/components/taskpanes/Merge/mergeUtils.js");
/* harmony import */ var _css_pivot_taskpane_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../css/pivot-taskpane.css */ "./css/pivot-taskpane.css");
/* harmony import */ var _css_pivot_taskpane_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_css_pivot_taskpane_css__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _MergeSheetAndKeySelection__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./MergeSheetAndKeySelection */ "./lib/components/taskpanes/Merge/MergeSheetAndKeySelection.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.




// Import 


// Enum to allow you to refer to the first or second sheet by name, for clarity
var MergeSheet;
(function (MergeSheet) {
    MergeSheet[MergeSheet["First"] = 0] = "First";
    MergeSheet[MergeSheet["Second"] = 1] = "Second";
})(MergeSheet || (MergeSheet = {}));
class MergeTaskpane extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        const sheetOneIndex = 0;
        const sheetTwoIndex = Math.min(1, props.sheetJSONArray.length - 1);
        if (props.sheetJSONArray.length === 0) {
            // If there is no data, we just set default values
            this.state = {
                sheetOneIndex: sheetOneIndex,
                sheetTwoIndex: sheetTwoIndex,
                sheetOneMergeKey: '',
                sheetTwoMergeKey: '',
                sheetOneSelectedColumns: [],
                sheetTwoSelectedColumns: [],
                sheetOneToggleAll: true,
                sheetTwoToggleAll: true,
                originalDfNames: props.dfNames,
                stepID: ''
            };
        }
        else {
            const suggestedKeys = (0,_mergeUtils__WEBPACK_IMPORTED_MODULE_3__.getSuggestedColumnHeaderKeys)(props.sheetJSONArray, sheetOneIndex, sheetTwoIndex);
            // We default to selecting _all_ columns
            const sheetOneSelectedColumns = [...this.props.sheetJSONArray[sheetOneIndex].columns];
            const sheetTwoSelectedColumns = [...this.props.sheetJSONArray[sheetTwoIndex].columns];
            this.state = {
                sheetOneIndex: sheetOneIndex,
                sheetTwoIndex: sheetTwoIndex,
                sheetOneMergeKey: suggestedKeys.sheetOneMergeKey,
                sheetTwoMergeKey: suggestedKeys.sheetTwoMergeKey,
                sheetOneSelectedColumns: sheetOneSelectedColumns,
                sheetTwoSelectedColumns: sheetTwoSelectedColumns,
                sheetOneToggleAll: true,
                sheetTwoToggleAll: true,
                originalDfNames: props.dfNames,
                stepID: ''
            };
        }
        this.setNewSheetIndex = this.setNewSheetIndex.bind(this);
        this.setNewMergeKey = this.setNewMergeKey.bind(this);
        this.toggleKeepColumnHeader = this.toggleKeepColumnHeader.bind(this);
        this.toggleAll = this.toggleAll.bind(this);
        this.sendMergeMessage = this.sendMergeMessage.bind(this);
    }
    /*
        It is best practice to make async calls not in the constructor,
        but rather in the componentDidMount lifecycle method!
    */
    componentDidMount() {
        // Send the first merge message, if there is something to send
        if (this.props.sheetJSONArray.length > 0) {
            void this.sendMergeMessage();
        }
    }
    /*
        When one of the two merge indexes is changed, we change state by:
        1. Updating the sheet index.
        2. Updating the columns that are selected (this defaults to all), as well as the toggle
           for this sheet.
        3. Trying to find a new merge key between the sheets
    */
    setNewSheetIndex(sheetNumber, newSheetIndex) {
        const indexName = sheetNumber == MergeSheet.First ? 'sheetOneIndex' : 'sheetTwoIndex';
        const selectedColumnsName = sheetNumber == MergeSheet.First ? 'sheetOneSelectedColumns' : 'sheetTwoSelectedColumns';
        const toggleAllName = sheetNumber == MergeSheet.First ? 'sheetOneToggleAll' : 'sheetTwoToggleAll';
        const newSelectedColumns = [...this.props.sheetJSONArray[newSheetIndex].columns];
        this.setState(prevState => {
            // Return if we're not changing anything!
            if (prevState[indexName] == newSheetIndex) {
                return;
            }
            const newSuggestedKeys = (0,_mergeUtils__WEBPACK_IMPORTED_MODULE_3__.getSuggestedColumnHeaderKeys)(this.props.sheetJSONArray, sheetNumber === MergeSheet.First ? newSheetIndex : prevState.sheetOneIndex, sheetNumber === MergeSheet.Second ? newSheetIndex : prevState.sheetTwoIndex);
            return Object.assign(Object.assign({}, prevState), { [indexName]: newSheetIndex, [selectedColumnsName]: newSelectedColumns, [toggleAllName]: true, sheetOneMergeKey: newSuggestedKeys.sheetOneMergeKey, sheetTwoMergeKey: newSuggestedKeys.sheetTwoMergeKey });
        }, () => {
            void this.sendMergeMessage();
        });
    }
    /*
        Sets a new merge key for one of the merge sheets
    */
    setNewMergeKey(sheetNumber, newMergeKey) {
        const mergeKeyName = sheetNumber === MergeSheet.First ? 'sheetOneMergeKey' : 'sheetTwoMergeKey';
        this.setState(prevState => {
            return Object.assign(Object.assign({}, prevState), { [mergeKeyName]: newMergeKey });
        }, () => {
            void this.sendMergeMessage();
        });
    }
    /*
        Toggles if we should keep a specific column at from one of the sheets in the new
        merged sheet.
    */
    toggleKeepColumnHeader(sheetNumber, columnHeader) {
        const selectedColumnsName = sheetNumber == MergeSheet.First ? 'sheetOneSelectedColumns' : 'sheetTwoSelectedColumns';
        const mergeKeyName = sheetNumber == MergeSheet.First ? 'sheetOneMergeKey' : 'sheetTwoMergeKey';
        this.setState(prevState => {
            // We the don't let you toggle the merge key!
            if (prevState[mergeKeyName] === columnHeader) {
                return;
            }
            const newSelectedColumns = [...prevState[selectedColumnsName]];
            if (newSelectedColumns.includes(columnHeader)) {
                newSelectedColumns.splice(newSelectedColumns.indexOf(columnHeader), 1);
            }
            else {
                newSelectedColumns.push(columnHeader);
            }
            return Object.assign(Object.assign({}, prevState), { [selectedColumnsName]: newSelectedColumns });
        }, () => {
            void this.sendMergeMessage();
        });
    }
    /*
        Toggles all the check boxes selected for a given sheet, based on the current
        toggleAll state for that sheet.
    */
    toggleAll(sheetNumber) {
        const sheetIndexName = sheetNumber === MergeSheet.First ? 'sheetOneIndex' : 'sheetTwoIndex';
        const toggleAllName = sheetNumber === MergeSheet.First ? 'sheetOneToggleAll' : 'sheetTwoToggleAll';
        const selectedColumnsName = sheetNumber === MergeSheet.First ? 'sheetOneSelectedColumns' : 'sheetTwoSelectedColumns';
        this.setState(prevState => {
            let newSelectedColumns = [];
            if (!prevState[toggleAllName]) {
                newSelectedColumns = [...this.props.sheetJSONArray[this.state[sheetIndexName]].columns];
            }
            return Object.assign(Object.assign({}, prevState), { [selectedColumnsName]: newSelectedColumns, [toggleAllName]: !prevState[toggleAllName] });
        }, () => {
            void this.sendMergeMessage();
        });
    }
    /*
        Completes the merge operation by sending information for the merge
        to the backend, potentially overwriting what's already there!
    */
    async sendMergeMessage() {
        // NOTE: We make sure to send the merge keys in the selected columns, no matter what
        const sheetOneSelectedColumns = [...this.state.sheetOneSelectedColumns];
        if (!sheetOneSelectedColumns.includes(this.state.sheetOneMergeKey)) {
            sheetOneSelectedColumns.push(this.state.sheetOneMergeKey);
        }
        const sheetTwoSelectedColumns = [...this.state.sheetTwoSelectedColumns];
        if (!sheetTwoSelectedColumns.includes(this.state.sheetTwoMergeKey)) {
            sheetTwoSelectedColumns.push(this.state.sheetTwoMergeKey);
        }
        const stepID = await this.props.mitoAPI.sendMergeMessage(this.state.sheetOneIndex, this.state.sheetOneMergeKey, sheetOneSelectedColumns, this.state.sheetTwoIndex, this.state.sheetTwoMergeKey, sheetTwoSelectedColumns, this.state.stepID);
        // Save the merge ID
        this.setState({ stepID: stepID });
    }
    render() {
        /*
            If there is no possible merge taskpane that can be displayed (e.g. the sheetJSON is empty),
            then display this error message.
        */
        if (this.props.sheetJSONArray.length === 0) {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DefaultTaskpane__WEBPACK_IMPORTED_MODULE_1__.default, { header: 'Merge Sheets Together', setCurrOpenTaskpane: this.props.setCurrOpenTaskpane, taskpaneBody: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, "Please Import data before merging.") }));
        }
        /*
            We don't let you select or unselect the sheet merge key, and note that we must account
            for the shift in the indexes that this causes when updating if the state of an item is
            toggled.

            Thus, we filter out the merge keys from both the list of columns, as well as the
            toggles for these columns.
        */
        const sheetOneOriginalColumns = this.props.sheetJSONArray[this.state.sheetOneIndex].columns;
        const sheetTwoOriginalColumns = this.props.sheetJSONArray[this.state.sheetTwoIndex].columns;
        const sheetOneColumns = sheetOneOriginalColumns.filter(columnHeader => columnHeader !== this.state.sheetOneMergeKey);
        const sheetTwoColumns = sheetTwoOriginalColumns.filter(columnHeader => columnHeader !== this.state.sheetTwoMergeKey);
        const sheetOneToggles = sheetOneColumns.map(columnHeader => this.state.sheetOneSelectedColumns.includes(columnHeader));
        const sheetTwoToggles = sheetTwoColumns.map(columnHeader => this.state.sheetTwoSelectedColumns.includes(columnHeader));
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DefaultTaskpane__WEBPACK_IMPORTED_MODULE_1__.default, { header: 'Merge Sheets Together', setCurrOpenTaskpane: this.props.setCurrOpenTaskpane, taskpaneBody: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MergeSheetAndKeySelection__WEBPACK_IMPORTED_MODULE_5__.default, { sheetNum: MergeSheet.First, dfNames: this.state.originalDfNames, sheetIndex: this.state.sheetOneIndex, otherSheetIndex: this.state.sheetTwoIndex, setNewSheetIndex: (newSheetIndex) => { this.setNewSheetIndex(MergeSheet.First, newSheetIndex); }, columnHeaders: this.props.sheetJSONArray[this.state.sheetOneIndex].columns, mergeKey: this.state.sheetOneMergeKey, setNewMergeKey: (newMergeKey) => this.setNewMergeKey(MergeSheet.First, newMergeKey) }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'mb-25px' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'default-taskpane-body-section-title-text' }, "Columns to Keep"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_elements_MultiToggleBox__WEBPACK_IMPORTED_MODULE_2__.default, { itemsArray: sheetOneColumns, itemToggleState: sheetOneToggles, toggleItemAtIndex: (index) => this.toggleKeepColumnHeader(MergeSheet.First, sheetOneColumns[index]), toggleAllOptions: {
                            currentToggleAllState: this.state.sheetOneToggleAll,
                            toggleAll: () => { this.toggleAll(MergeSheet.First); }
                        } })),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_MergeSheetAndKeySelection__WEBPACK_IMPORTED_MODULE_5__.default, { sheetNum: MergeSheet.Second, dfNames: this.state.originalDfNames, sheetIndex: this.state.sheetTwoIndex, otherSheetIndex: this.state.sheetOneIndex, setNewSheetIndex: (newSheetIndex) => { this.setNewSheetIndex(MergeSheet.Second, newSheetIndex); }, columnHeaders: this.props.sheetJSONArray[this.state.sheetTwoIndex].columns, mergeKey: this.state.sheetTwoMergeKey, setNewMergeKey: (newMergeKey) => this.setNewMergeKey(MergeSheet.Second, newMergeKey) }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'default-taskpane-body-section-title-text' }, "Columns to Keep"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_elements_MultiToggleBox__WEBPACK_IMPORTED_MODULE_2__.default, { itemsArray: sheetTwoColumns, itemToggleState: sheetTwoToggles, toggleItemAtIndex: (index) => this.toggleKeepColumnHeader(MergeSheet.Second, sheetTwoColumns[index]), toggleAllOptions: {
                            currentToggleAllState: this.state.sheetTwoToggleAll,
                            toggleAll: () => { this.toggleAll(MergeSheet.Second); }
                        } }))) }));
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MergeTaskpane);


/***/ }),

/***/ "./lib/components/taskpanes/Merge/mergeUtils.js":
/*!******************************************************!*\
  !*** ./lib/components/taskpanes/Merge/mergeUtils.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getSuggestedColumnHeaderKeys": () => (/* binding */ getSuggestedColumnHeaderKeys)
/* harmony export */ });
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.
/*
    Returns all column headers shared between the sheets at the given indexes.
*/
const getSharedColumnHeaders = (sheetJSONArray, sheetOneIndex, sheetTwoIndex) => {
    // If invalid indexes are passed, return early to avoid errors
    if ((sheetOneIndex < 0 || sheetJSONArray.length <= sheetOneIndex) || (sheetTwoIndex < 0 || sheetJSONArray.length <= sheetTwoIndex)) {
        return [];
    }
    const sheetOneColumnNames = sheetJSONArray[sheetOneIndex].columns;
    const sheetTwoColumnNames = sheetJSONArray[sheetTwoIndex].columns;
    const sharedKeys = sheetOneColumnNames.filter(columnName => sheetTwoColumnNames.includes(columnName)).map(columnHeader => columnHeader.toString());
    return sharedKeys;
};
/*
    Given two sheet indexes, reccomends a key to merge on. If there are x shared keys, then:
    - If x.length >= 1, it returns the first shared key as reccomended.
    - Else, it reccomends the first key
*/
const getSuggestedColumnHeaderKeys = (sheetJSONArray, sheetOneIndex, sheetTwoIndex) => {
    const sharedKeys = getSharedColumnHeaders(sheetJSONArray, sheetOneIndex, sheetTwoIndex);
    const sheetOneMergeKey = sharedKeys.length >= 1 ? sharedKeys[0] : sheetJSONArray[sheetOneIndex].columns[0];
    const sheetTwoMergeKey = sharedKeys.length >= 1 ? sharedKeys[0] : sheetJSONArray[sheetTwoIndex].columns[0];
    return {
        sheetOneMergeKey: sheetOneMergeKey,
        sheetTwoMergeKey: sheetTwoMergeKey
    };
};


/***/ }),

/***/ "./lib/components/taskpanes/PivotTable/PivotTableColumnHeaderCard.js":
/*!***************************************************************************!*\
  !*** ./lib/components/taskpanes/PivotTable/PivotTableColumnHeaderCard.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _PivotTaskpane__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PivotTaskpane */ "./lib/components/taskpanes/PivotTable/PivotTaskpane.js");
/* harmony import */ var _css_pivot_table_column_header_card_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../css/pivot-table-column-header-card.css */ "./css/pivot-table-column-header-card.css");
/* harmony import */ var _css_pivot_table_column_header_card_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_pivot_table_column_header_card_css__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


// Import css

/*
  A custom component that displays the column headers chosen as the key for the pivot table.
*/
const PivotTableColumnHeaderCard = (props) => {
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'pivot-table-column-header-card-div' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'pivot-table-column-header-card-div-text' }, props.columnHeader),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'pivot-table-column-header-card-exit-div', onClick: () => props.editColumnKeySelection(props.keyType, props.columnHeader, _PivotTaskpane__WEBPACK_IMPORTED_MODULE_1__.SelectionOperation.REMOVE) },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "15", height: "15", viewBox: "0 0 7 7", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "0.353553", y1: "0.646447", x2: "5.66601", y2: "5.9589", stroke: "#343434" }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "0.354943", y1: "5.95895", x2: "5.66739", y2: "0.646497", stroke: "#343434" })))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PivotTableColumnHeaderCard);


/***/ }),

/***/ "./lib/components/taskpanes/PivotTable/PivotTableKeySelection.js":
/*!***********************************************************************!*\
  !*** ./lib/components/taskpanes/PivotTable/PivotTableKeySelection.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _PivotTableColumnHeaderCard__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PivotTableColumnHeaderCard */ "./lib/components/taskpanes/PivotTable/PivotTableColumnHeaderCard.js");
/* harmony import */ var _PivotTaskpane__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./PivotTaskpane */ "./lib/components/taskpanes/PivotTable/PivotTaskpane.js");
/* harmony import */ var _css_pivot_table_key_selection_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../css/pivot-table-key-selection.css */ "./css/pivot-table-key-selection.css");
/* harmony import */ var _css_pivot_table_key_selection_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_css_pivot_table_key_selection_css__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _elements_SmallSelect__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../elements/SmallSelect */ "./lib/components/elements/SmallSelect.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.



// import css


/*
  A custom component used in the pivot table which lets the
  user select column headers to add to the row or column keys
*/
const PivotTableKeySelection = (props) => {
    const pivotTableColumnHeaderCards = [];
    for (const columnHeader of props.selectedColumnHeaders) {
        pivotTableColumnHeaderCards.push((react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_PivotTableColumnHeaderCard__WEBPACK_IMPORTED_MODULE_1__.default, { key: columnHeader, columnHeader: columnHeader, editColumnKeySelection: props.editKeySelection, keyType: props.keyType })));
    }
    /*
      Function passed to the SmallSelect so that when the user selects a
      key to add, it can communicate the addition to the pivot table state

      Note: we use this wrapper around the editColumnKeySelection function so that
      we can conform with the interface of the SmallSelect whose setValue function
      only takes a string as a param
    */
    function selectColumnHeader(columnHeader) {
        props.editKeySelection(props.keyType, columnHeader, _PivotTaskpane__WEBPACK_IMPORTED_MODULE_2__.SelectionOperation.ADD);
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'pivot-taskpane-section-header-div' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'default-taskpane-body-section-title-text' }, props.sectionTitle),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_elements_SmallSelect__WEBPACK_IMPORTED_MODULE_4__.default, { startingValue: 'add', optionsArray: props.selectableColumnHeaders, setValue: selectColumnHeader, titleColor: _elements_SmallSelect__WEBPACK_IMPORTED_MODULE_4__.TitleColor.BLUE })),
        pivotTableColumnHeaderCards));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PivotTableKeySelection);


/***/ }),

/***/ "./lib/components/taskpanes/PivotTable/PivotTableValueAggregationCard.js":
/*!*******************************************************************************!*\
  !*** ./lib/components/taskpanes/PivotTable/PivotTableValueAggregationCard.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _PivotTaskpane__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PivotTaskpane */ "./lib/components/taskpanes/PivotTable/PivotTaskpane.js");
/* harmony import */ var _css_pivot_table_column_header_card_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../css/pivot-table-column-header-card.css */ "./css/pivot-table-column-header-card.css");
/* harmony import */ var _css_pivot_table_column_header_card_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_pivot_table_column_header_card_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _css_pivot_table_value_aggregation_card_css__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../css/pivot-table-value-aggregation-card.css */ "./css/pivot-table-value-aggregation-card.css");
/* harmony import */ var _css_pivot_table_value_aggregation_card_css__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_css_pivot_table_value_aggregation_card_css__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _elements_SmallSelect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../elements/SmallSelect */ "./lib/components/elements/SmallSelect.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


// import css




/*
  A custom component that displays the column headers chosen as the key for the pivot table.
*/
const PivotTableValueAggregationCard = (props) => {
    // Create a list of the possible aggregation methods
    const aggregationTypeList = Object.values(_PivotTaskpane__WEBPACK_IMPORTED_MODULE_1__.AggregationType);
    const setAggregationType = (aggregationType) => {
        // Declare the aggregationType param of type AggregationType and then make sure that it is
        const aggregationTypeCast = aggregationType;
        if (aggregationTypeList.includes(aggregationTypeCast)) {
            props.editValueAggregationSelection(props.columnHeader, _PivotTaskpane__WEBPACK_IMPORTED_MODULE_1__.SelectionOperation.ADD, aggregationTypeCast);
        }
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'pivot-table-column-header-card-div' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'pivot-table-value-aggregation-card-aggregation-info-div' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_elements_SmallSelect__WEBPACK_IMPORTED_MODULE_5__.default, { startingValue: props.aggregationType, optionsArray: aggregationTypeList, setValue: setAggregationType, titleColor: _elements_SmallSelect__WEBPACK_IMPORTED_MODULE_5__.TitleColor.DARK }),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'pivot-table-value-aggregation-card-div-text ml-5' },
                "of ",
                props.columnHeader)),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'pivot-table-column-header-card-exit-div', onClick: () => props.editValueAggregationSelection(props.columnHeader, _PivotTaskpane__WEBPACK_IMPORTED_MODULE_1__.SelectionOperation.REMOVE) },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "15", height: "15", viewBox: "0 0 7 7", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "0.353553", y1: "0.646447", x2: "5.66601", y2: "5.9589", stroke: "#343434" }),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("line", { x1: "0.354943", y1: "5.95895", x2: "5.66739", y2: "0.646497", stroke: "#343434" })))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PivotTableValueAggregationCard);


/***/ }),

/***/ "./lib/components/taskpanes/PivotTable/PivotTableValueSelection.js":
/*!*************************************************************************!*\
  !*** ./lib/components/taskpanes/PivotTable/PivotTableValueSelection.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _PivotTaskpane__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PivotTaskpane */ "./lib/components/taskpanes/PivotTable/PivotTaskpane.js");
/* harmony import */ var _elements_SmallSelect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../elements/SmallSelect */ "./lib/components/elements/SmallSelect.js");
/* harmony import */ var _PivotTableValueAggregationCard__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./PivotTableValueAggregationCard */ "./lib/components/taskpanes/PivotTable/PivotTableValueAggregationCard.js");
/* harmony import */ var _css_pivot_table_key_selection_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../css/pivot-table-key-selection.css */ "./css/pivot-table-key-selection.css");
/* harmony import */ var _css_pivot_table_key_selection_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_css_pivot_table_key_selection_css__WEBPACK_IMPORTED_MODULE_4__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.




// import css

/*
  A custom component used in the pivot table which lets the
  user select column headers to add to the row or column keys
*/
const PivotTableValueSelection = (props) => {
    // TODO: Put these in order of selection so that the new one is at the top so that the user can easily change its aggregation method
    const PivotTableValueAggregationCards = [];
    for (const columnHeader of Object.keys(props.aggregatedValuesInSection)) {
        PivotTableValueAggregationCards.push((react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_PivotTableValueAggregationCard__WEBPACK_IMPORTED_MODULE_3__.default, { key: columnHeader, columnHeader: columnHeader, aggregationType: props.aggregatedValuesInSection[columnHeader], editValueAggregationSelection: props.editValueAggregationSelection })));
    }
    // get column headers that are not yet aggregated
    const selectableColumnHeaders = props.columnHeaders.filter(x => !Object.keys(props.aggregatedValuesInSection).includes(x));
    /*
      Function passed to the SmallSelect so that when the user selects a
      key to add, it can communicate the addition to the pivot table state

      Note: we use this wrapper around the editColumnKeySelection function so that
      we can conform with the interface of the SmallSelect whose setValue function
      only takes a string as a param
    */
    function addAggregatedValue(columnHeader) {
        props.editValueAggregationSelection(columnHeader, _PivotTaskpane__WEBPACK_IMPORTED_MODULE_1__.SelectionOperation.ADD, _PivotTaskpane__WEBPACK_IMPORTED_MODULE_1__.AggregationType.COUNT);
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'pivot-taskpane-section-header-div' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'default-taskpane-body-section-title-text' }, "Values"),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_elements_SmallSelect__WEBPACK_IMPORTED_MODULE_2__.default, { startingValue: 'add', optionsArray: selectableColumnHeaders, setValue: addAggregatedValue, titleColor: _elements_SmallSelect__WEBPACK_IMPORTED_MODULE_2__.TitleColor.BLUE })),
        PivotTableValueAggregationCards));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PivotTableValueSelection);


/***/ }),

/***/ "./lib/components/taskpanes/PivotTable/PivotTaskpane.js":
/*!**************************************************************!*\
  !*** ./lib/components/taskpanes/PivotTable/PivotTaskpane.js ***!
  \**************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AggregationType": () => (/* binding */ AggregationType),
/* harmony export */   "KeyType": () => (/* binding */ KeyType),
/* harmony export */   "SelectionOperation": () => (/* binding */ SelectionOperation),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DefaultTaskpane__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../DefaultTaskpane */ "./lib/components/taskpanes/DefaultTaskpane.js");
/* harmony import */ var _elements_LargeSelect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../elements/LargeSelect */ "./lib/components/elements/LargeSelect.js");
/* harmony import */ var _PivotTableKeySelection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./PivotTableKeySelection */ "./lib/components/taskpanes/PivotTable/PivotTableKeySelection.js");
/* harmony import */ var _css_pivot_taskpane_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../css/pivot-taskpane.css */ "./css/pivot-taskpane.css");
/* harmony import */ var _css_pivot_taskpane_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_css_pivot_taskpane_css__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _PivotTableValueSelection__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./PivotTableValueSelection */ "./lib/components/taskpanes/PivotTable/PivotTableValueSelection.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.




// Import 


// The aggregation functions we're supporting, out of the box
var AggregationType;
(function (AggregationType) {
    AggregationType["SUM"] = "sum";
    AggregationType["MEAN"] = "mean";
    AggregationType["MEDIAN"] = "median";
    AggregationType["MIN"] = "min";
    AggregationType["MAX"] = "max";
    AggregationType["COUNT"] = "count";
    AggregationType["STD"] = "std";
    // NOTE: this needs to match the file mitosheet/steps/pivot.py, in the 
    // values_to_functions function
    AggregationType["COUNT_UNIQUE"] = "count unique";
})(AggregationType || (AggregationType = {}));
var KeyType;
(function (KeyType) {
    KeyType["Row"] = "Row";
    KeyType["Col"] = "Col";
})(KeyType || (KeyType = {}));
var SelectionOperation;
(function (SelectionOperation) {
    SelectionOperation["ADD"] = "Add";
    SelectionOperation["REMOVE"] = "Remove";
})(SelectionOperation || (SelectionOperation = {}));
class PivotTaskpane extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        this.editValueAggregationSelection = (columnHeader, operation, aggregationType) => {
            this.setState(prevState => {
                const newValues = JSON.parse(JSON.stringify(prevState.values));
                if (operation == SelectionOperation.ADD && aggregationType) {
                    // If the column is being added as a new aggregated value, add it
                    newValues[columnHeader] = aggregationType;
                }
                else if (operation == SelectionOperation.REMOVE) {
                    // If the column is being removed as an aggregated value, remove it
                    delete newValues[columnHeader];
                }
                return {
                    values: newValues
                };
            }, () => {
                void this.sendPivotTableUpdateMessage();
            });
        };
        /*
            A callback used by the select data source Select Element so that it can
            set the state of the Pivot Table Taskpane
        */
        this.setSelectedSheet = (newSheetName) => {
            const newSelectedSheetIndex = this.state.dfNames.indexOf(newSheetName);
            // If you didn't select a new sheet, then don't do clear your selections
            if (newSelectedSheetIndex == this.state.selectedSheetIndex) {
                return;
            }
            /*
                Reset the keys so
                    1) the column headers currently selected are dropped
                    2) the values currently aggregated are dropped
                    3) display the column headers from the new sheet
            */
            this.setState({
                selectedSheetIndex: newSelectedSheetIndex,
                pivotRows: [],
                pivotCols: [],
                values: {}
            });
        };
        // Function used to add/remove column headers to the row and column keys 
        this.editKeySelection = (keyType, columnHeader, operation) => {
            // Sanity check: make sure that this column is not already selected. this should not be possible!
            if (operation === SelectionOperation.ADD) {
                if (this.state.pivotRows.includes(columnHeader) || this.state.pivotCols.includes(columnHeader)) {
                    console.log("column selected as key twice in pivot table. should not be possible");
                    return;
                }
            }
            this.setState(prevState => {
                let previousColumnHeaders = [];
                if (keyType === KeyType.Row) {
                    previousColumnHeaders = [...prevState.pivotRows];
                }
                else {
                    previousColumnHeaders = [...prevState.pivotCols];
                }
                if (operation == SelectionOperation.ADD && !previousColumnHeaders.includes(columnHeader)) {
                    // If the operation was add, add the column header to the list of column headers (if not already included)
                    previousColumnHeaders.push(columnHeader);
                }
                else if (operation == SelectionOperation.REMOVE && previousColumnHeaders.includes(columnHeader)) {
                    // If the operation was remove, add the column header to the list of column headers (if not already included)
                    previousColumnHeaders.splice(previousColumnHeaders.indexOf(columnHeader), 1);
                }
                return Object.assign(Object.assign({}, prevState), { [keyType === KeyType.Row ? 'pivotRows' : 'pivotCols']: previousColumnHeaders });
            }, () => {
                void this.sendPivotTableUpdateMessage();
            });
        };
        this.state = {
            dfNames: this.props.dfNames,
            selectedSheetIndex: props.selectedSheetIndex,
            pivotRows: [],
            pivotCols: [],
            values: {},
            keyError: '',
            stepID: ''
        };
        this.getSelectableKeyColumnHeaders = this.getSelectableKeyColumnHeaders.bind(this);
        this.editValueAggregationSelection = this.editValueAggregationSelection.bind(this);
        this.sendPivotTableUpdateMessage = this.sendPivotTableUpdateMessage.bind(this);
    }
    /*
        It is best practice to make async calls not in the constructor,
        but rather in the componentDidMount lifecycle method!

        Here, if there is anything to possibly pivot on, we send a pivot
        message.
    */
    componentDidMount() {
        // Send the first pivot message, if there is something to send
        if (this.props.sheetJSONArray.length > 0) {
            void this.sendPivotTableUpdateMessage();
        }
    }
    /*
        Completes the group operation by sending information for the group
        to the backend.
    */
    async sendPivotTableUpdateMessage() {
        const stepID = await this.props.mitoAPI.sendPivotMessage(this.state.selectedSheetIndex, this.state.pivotRows, this.state.pivotCols, this.state.values, this.state.stepID);
        this.setState({ stepID: stepID });
    }
    /*
        Returns the remaining possible column header keys.
        A column header can only be used in either the row or column key
    */
    getSelectableKeyColumnHeaders() {
        const allColumnHeaders = this.props.sheetJSONArray[this.state.selectedSheetIndex].columns;
        return allColumnHeaders.filter(x => !this.state.pivotRows.includes(x) && !this.state.pivotCols.includes(x));
    }
    render() {
        /*
            If there is no possible Pivot taskpane that can be displayed (e.g. the sheetJSON is empty),
            give an error message indicating so.
        */
        if (this.props.sheetJSONArray.length === 0) {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DefaultTaskpane__WEBPACK_IMPORTED_MODULE_1__.default, { header: 'Create a Pivot Table', setCurrOpenTaskpane: this.props.setCurrOpenTaskpane, taskpaneBody: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, "Please Import data before pivoting.") }));
        }
        const selectableColumnHeaders = this.getSelectableKeyColumnHeaders();
        const pivotRows = this.state.pivotRows;
        const pivotCols = this.state.pivotCols;
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DefaultTaskpane__WEBPACK_IMPORTED_MODULE_1__.default, { header: 'Create a Pivot Table', setCurrOpenTaskpane: this.props.setCurrOpenTaskpane, taskpaneBody: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-body-section-div pivot-taskpane-section-header-div' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'default-taskpane-body-section-title-text' }, "Data Source"),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_elements_LargeSelect__WEBPACK_IMPORTED_MODULE_2__.default, { startingValue: this.state.dfNames[this.state.selectedSheetIndex], key: this.state.selectedSheetIndex, optionsArray: this.state.dfNames, setValue: this.setSelectedSheet })),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-body-section-div' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_PivotTableKeySelection__WEBPACK_IMPORTED_MODULE_3__.default, { sectionTitle: 'Rows', selectableColumnHeaders: selectableColumnHeaders, selectedColumnHeaders: pivotRows, editKeySelection: this.editKeySelection, keyType: KeyType.Row })),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-body-section-div' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_PivotTableKeySelection__WEBPACK_IMPORTED_MODULE_3__.default, { sectionTitle: 'Columns', selectableColumnHeaders: selectableColumnHeaders, selectedColumnHeaders: pivotCols, editKeySelection: this.editKeySelection, keyType: KeyType.Col })),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'default-taskpane-body-section-div' },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_PivotTableValueSelection__WEBPACK_IMPORTED_MODULE_5__.default, { columnHeaders: this.props.sheetJSONArray[this.state.selectedSheetIndex].columns, aggregatedValuesInSection: this.state.values, editValueAggregationSelection: this.editValueAggregationSelection }))) }));
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (PivotTaskpane);


/***/ }),

/***/ "./lib/components/taskpanes/ReplayAnalysis/ReplayAnalysisTaskpane.js":
/*!***************************************************************************!*\
  !*** ./lib/components/taskpanes/ReplayAnalysis/ReplayAnalysisTaskpane.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DefaultTaskpane__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../DefaultTaskpane */ "./lib/components/taskpanes/DefaultTaskpane.js");
/* harmony import */ var _SavedAnalysisCard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SavedAnalysisCard */ "./lib/components/taskpanes/ReplayAnalysis/SavedAnalysisCard.js");
/* harmony import */ var _Steps_StepDataElement__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Steps/StepDataElement */ "./lib/components/taskpanes/Steps/StepDataElement.js");
/* harmony import */ var _css_replay_analysis_taskpane_css__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../css/replay-analysis-taskpane.css */ "./css/replay-analysis-taskpane.css");
/* harmony import */ var _css_replay_analysis_taskpane_css__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_css_replay_analysis_taskpane_css__WEBPACK_IMPORTED_MODULE_4__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.




// Import css

const ReplayAnalysisTaskpane = (props) => {
    const [openedDropdown, setOpenedDropdown] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(undefined);
    const [savedAnalysisDescription, setSavedAnalysisDescription] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(undefined);
    const [selectedSavedAnalysis, setSelectedSavedAnalysis] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(undefined);
    const setSelectedAnalysisAndDescription = (_savedAnalysisName, _savedAnalysisDescription) => {
        setSelectedSavedAnalysis(_savedAnalysisName);
        setSavedAnalysisDescription(_savedAnalysisDescription);
    };
    // Create the saved analysis name cards
    const savedAnalysisCards = props.savedAnalysisNames.map(savedAnalysisName => {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_SavedAnalysisCard__WEBPACK_IMPORTED_MODULE_2__.default, { key: savedAnalysisName, isDescribedAnalysis: false, savedAnalysisName: savedAnalysisName, savedAnalysisNames: props.savedAnalysisNames, openedDropdown: openedDropdown === savedAnalysisName, setOpenedDropdown: setOpenedDropdown, setSelectedAnalysisAndDescription: setSelectedAnalysisAndDescription, setModal: props.setModal, mitoAPI: props.mitoAPI }));
    });
    // Create the saved analysis step descriptions
    let savedAnalysisStepDescriptionDivs = [];
    if (savedAnalysisDescription !== undefined) {
        savedAnalysisStepDescriptionDivs = savedAnalysisDescription.map((step, index) => {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'saved-analysis-taskpane-step', key: index },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'saved-analysis-taskpane-step-icon' }, (0,_Steps_StepDataElement__WEBPACK_IMPORTED_MODULE_3__.getStepIcon)(step['step_type'])),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'saved-analysis-step-text-div' }, step['step_description'])));
        });
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DefaultTaskpane__WEBPACK_IMPORTED_MODULE_1__.default, { header: 'Apply a Saved Analysis', setCurrOpenTaskpane: props.setCurrOpenTaskpane, taskpaneBody: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
            props.savedAnalysisNames.length !== 0 &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'saved-analyses-container' }, savedAnalysisCards),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'saved-analysis-divider-line-container' },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("hr", { className: 'saved-analysis-divider-line' })),
                    selectedSavedAnalysis !== undefined &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_SavedAnalysisCard__WEBPACK_IMPORTED_MODULE_2__.default, { key: selectedSavedAnalysis, isDescribedAnalysis: true, savedAnalysisName: selectedSavedAnalysis, savedAnalysisNames: props.savedAnalysisNames, openedDropdown: openedDropdown === (selectedSavedAnalysis + '-described-analysis'), setOpenedDropdown: setOpenedDropdown, setSelectedAnalysisAndDescription: setSelectedAnalysisAndDescription, setModal: props.setModal, mitoAPI: props.mitoAPI }),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'saved-analysis-taskpane-step-container' }, savedAnalysisStepDescriptionDivs)),
                    savedAnalysisDescription === undefined &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'saved-analysis-taskpane-empty-section-text-container' }, "Click an analysis to see the steps it contains.")),
            props.savedAnalysisNames.length === 0 &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'saved-analysis-taskpane-empty-section-text-container' }, "You don't have any saved analyses. Save one, then come back to apply it to your dataframes!")) }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ReplayAnalysisTaskpane);


/***/ }),

/***/ "./lib/components/taskpanes/ReplayAnalysis/SavedAnalysisCard.js":
/*!**********************************************************************!*\
  !*** ./lib/components/taskpanes/ReplayAnalysis/SavedAnalysisCard.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _elements_CustomDropdown__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../elements/CustomDropdown */ "./lib/components/elements/CustomDropdown.js");
/* harmony import */ var _icons_DropdownIcon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../icons/DropdownIcon */ "./lib/components/icons/DropdownIcon.js");
/* harmony import */ var _Mito__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../Mito */ "./lib/components/Mito.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.





/*
    Helper function for validating saved analysis renames. Valid renames are:
    - not duplicated names
    - not empty
*/
const getAnalysisNameError = (savedAnalysisNames, newAnalysisName) => {
    if (newAnalysisName === '') {
        return 'The analysis cannot be empty.';
    }
    else if (savedAnalysisNames.includes(newAnalysisName)) {
        return 'That name is taken by another analysis.';
    }
    else {
        return '';
    }
};
const SavedAnalysisCard = (props) => {
    const [isRename, setIsRename] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
    const [newSavedAnalysisName, setNewSavedAnalysisName] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(props.savedAnalysisName);
    const [renameError, setRenameError] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)('');
    const [savedAnalysisDescription, setSavedAnalysisDescription] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(undefined);
    // This function applies the saved analysis
    const applySavedAnalysis = async () => {
        // First, we check if there are any simple import steps that we need to handle with special
        // care, specifically by asking the users to switch out the files for new files.
        const importSummary = await props.mitoAPI.getImportSummary(props.savedAnalysisName);
        if (Object.keys(importSummary).length !== 0) {
            props.setModal({ type: _Mito__WEBPACK_IMPORTED_MODULE_3__.ModalEnum.ReplayImport, analysisName: props.savedAnalysisName, importSummary: importSummary });
            return;
        }
        await props.mitoAPI.sendUseExistingAnalysisUpdateMessage(props.savedAnalysisName);
    };
    // This function deletes the saved analysis
    const deleteSavedAnalysis = async () => {
        props.setSelectedAnalysisAndDescription(undefined, undefined);
        await props.mitoAPI.sendDeleteSavedAnalysisMessage(props.savedAnalysisName);
    };
    // This function renames the saved analysis after making sure the name is valid
    const renameSavedAnalysis = async () => {
        // If the new name is the same as the old name, turn off the error and close renaming
        if (props.savedAnalysisName === newSavedAnalysisName) {
            setRenameError('');
            setIsRename(false);
            return;
        }
        // Validate the rename
        const renameAnalysisError = getAnalysisNameError(props.savedAnalysisNames, newSavedAnalysisName);
        setRenameError(renameAnalysisError);
        // If the new name is valid, send rename event
        if (renameAnalysisError === '') {
            await props.mitoAPI.sendRenameSavedAnalysisMessage(props.savedAnalysisName, newSavedAnalysisName);
            props.setSelectedAnalysisAndDescription(newSavedAnalysisName, savedAnalysisDescription);
            setIsRename(false);
        }
    };
    // This function receives the steps of the saved analysis to be displayed by the taskpane
    const getSavedAnalysisDescription = async () => {
        const savedAnalysisDescription = await props.mitoAPI.getSavedAnalysisDescription(props.savedAnalysisName);
        setSavedAnalysisDescription(savedAnalysisDescription);
        props.setSelectedAnalysisAndDescription(newSavedAnalysisName, savedAnalysisDescription);
        props.setOpenedDropdown(undefined);
        /*
            We use a log event here, but not in the other functions, because the other functions
            are update events that are automatically logged. This function goes through api.py and therefore
            needs manual logging.
        */
        void props.mitoAPI.sendLogMessage('clicked_saved_analysis_name_log_event', {
            saved_analysis_name: props.savedAnalysisName,
        });
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'saved-analysis-card' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'saved-analysis-card-analysis-name', onClick: () => { void getSavedAnalysisDescription(); }, onDoubleClick: () => { setIsRename(true); } },
                    isRename &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("form", { onSubmit: async (e) => { e.preventDefault(); await renameSavedAnalysis(); } },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("input", { type: 'text', value: newSavedAnalysisName, onChange: (e) => { setNewSavedAnalysisName(e.target.value); }, onBlur: renameSavedAnalysis, autoFocus: true })),
                    !isRename &&
                        props.savedAnalysisName),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'saved-analysis-card-dropdown-div', onClick: () => {
                            /*
                                If the saved analysis card that is clicked is the analysis card in the summary section
                                of the taskpane, mark it using '-described-analysis', so that we can determine whether the
                                user clicked on the CustomDropdown that is part of the list of saved analyses or if it was
                                the analysis card used in the summary section.

                                We do this so only one dropdown opens instead of the one in the list and the summary section.
                            */
                            if (props.isDescribedAnalysis) {
                                props.setOpenedDropdown(props.savedAnalysisName + '-described-analysis');
                            }
                            else {
                                props.setOpenedDropdown(props.savedAnalysisName);
                            }
                        } },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_DropdownIcon__WEBPACK_IMPORTED_MODULE_2__.default, null)),
                    props.openedDropdown &&
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_elements_CustomDropdown__WEBPACK_IMPORTED_MODULE_1__.default, { closeDropdown: () => { props.setOpenedDropdown(undefined); } },
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { onClick: () => {
                                    void applySavedAnalysis();
                                    props.setOpenedDropdown(undefined);
                                } }, "Apply this Analysis"),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { onClick: () => {
                                    setIsRename(true);
                                    props.setOpenedDropdown(undefined);
                                } }, "Rename this Analysis"),
                            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { onClick: deleteSavedAnalysis }, "Delete this Analysis")))),
            renameError !== '' &&
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'replay-analysis-rename-error' }, renameError))));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (SavedAnalysisCard);


/***/ }),

/***/ "./lib/components/taskpanes/Steps/StepDataElement.js":
/*!***********************************************************!*\
  !*** ./lib/components/taskpanes/Steps/StepDataElement.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getStepIcon": () => (/* binding */ getStepIcon),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../types/StepTypes */ "./lib/types/StepTypes.js");
/* harmony import */ var _icons_ImportIcon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../icons/ImportIcon */ "./lib/components/icons/ImportIcon.js");
/* harmony import */ var _icons_MergeIcon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../icons/MergeIcon */ "./lib/components/icons/MergeIcon.js");
/* harmony import */ var _icons_PivotIcon__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../icons/PivotIcon */ "./lib/components/icons/PivotIcon.js");
/* harmony import */ var _icons_DeleteColumnIcon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../icons/DeleteColumnIcon */ "./lib/components/icons/DeleteColumnIcon.js");
/* harmony import */ var _icons_AddColumnIcon__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../icons/AddColumnIcon */ "./lib/components/icons/AddColumnIcon.js");
/* harmony import */ var _elements_CustomDropdown__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../elements/CustomDropdown */ "./lib/components/elements/CustomDropdown.js");
/* harmony import */ var _icons_DropdownIcon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../icons/DropdownIcon */ "./lib/components/icons/DropdownIcon.js");
/* harmony import */ var _icons_FilterIcons__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../icons/FilterIcons */ "./lib/components/icons/FilterIcons.js");
/* harmony import */ var _icons_EditIcon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../icons/EditIcon */ "./lib/components/icons/EditIcon.js");
/* harmony import */ var _icons_MitoIcon__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../icons/MitoIcon */ "./lib/components/icons/MitoIcon.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


// Icons










/*
    Gets an icon for a specific step type, to display
    with that step
*/
function getStepIcon(stepType) {
    switch (stepType) {
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.Initialize: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_MitoIcon__WEBPACK_IMPORTED_MODULE_11__.default, null));
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.AddColumn: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_AddColumnIcon__WEBPACK_IMPORTED_MODULE_6__.default, null));
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.DeleteColumn: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_DeleteColumnIcon__WEBPACK_IMPORTED_MODULE_5__.default, null));
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.RenameColumn: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_EditIcon__WEBPACK_IMPORTED_MODULE_10__.default, null));
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.ReorderColumn: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_EditIcon__WEBPACK_IMPORTED_MODULE_10__.default, null));
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.FilterColumn: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_FilterIcons__WEBPACK_IMPORTED_MODULE_9__.FilterEmptyIcon, { height: '20', width: '20' }));
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.SetColumnFormula: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'step-taskpane-missing-icon' }, "Fx"));
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.DataframeDelete: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_DeleteColumnIcon__WEBPACK_IMPORTED_MODULE_5__.default, null));
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.DataframeDuplicate: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_EditIcon__WEBPACK_IMPORTED_MODULE_10__.default, null));
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.DataframeRename: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_EditIcon__WEBPACK_IMPORTED_MODULE_10__.default, null));
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.SimpleImport: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_ImportIcon__WEBPACK_IMPORTED_MODULE_2__.default, null));
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.RawPythonImport: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_ImportIcon__WEBPACK_IMPORTED_MODULE_2__.default, null));
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.Sort: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_EditIcon__WEBPACK_IMPORTED_MODULE_10__.default, null));
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.Pivot: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_PivotIcon__WEBPACK_IMPORTED_MODULE_4__.default, { width: '20' }));
        case _types_StepTypes__WEBPACK_IMPORTED_MODULE_1__.StepType.Merge: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_MergeIcon__WEBPACK_IMPORTED_MODULE_3__.default, { width: '27' }));
        default: return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_EditIcon__WEBPACK_IMPORTED_MODULE_10__.default, null));
    }
}
/*
    An element in a list that displays information about a step, and
    eventually will allow the user to interact with that step (e.g.
    to start editing it).
*/
function StepDataElement(props) {
    const rollBackToStep = () => {
        props.setOpenedDropdown(false);
        void props.mitoAPI.checkoutStepByIndex(props.stepData.step_idx);
    };
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'step-taskpane-step-container' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'step-taskpane-step-container-left', style: { opacity: props.beforeCurrIdx ? '1' : '.5' }, onClick: rollBackToStep },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'step-taskpane-step-icon' }, getStepIcon(props.stepData.step_type)),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'step-taskpane-step-text' },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'step-taskpane-step-header' }, props.stepData.step_display_name),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'step-taskpane-step-subtext' }, props.stepData.step_description))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'step-taskpane-step-container-right', onClick: () => {
                props.setOpenedDropdown(!props.openedDropdown);
            } },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_icons_DropdownIcon__WEBPACK_IMPORTED_MODULE_8__.default, null)),
        props.openedDropdown &&
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_elements_CustomDropdown__WEBPACK_IMPORTED_MODULE_7__.default, { closeDropdown: () => { props.setOpenedDropdown(false); } },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { onClick: rollBackToStep }, "View this step"),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'custom-dropdown-inactive' }, "Edit this step (coming soon)"))));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StepDataElement);


/***/ }),

/***/ "./lib/components/taskpanes/Steps/StepsTaskpane.js":
/*!*********************************************************!*\
  !*** ./lib/components/taskpanes/Steps/StepsTaskpane.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _DefaultTaskpane__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../DefaultTaskpane */ "./lib/components/taskpanes/DefaultTaskpane.js");
/* harmony import */ var _css_step_taskpane_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../css/step-taskpane.css */ "./css/step-taskpane.css");
/* harmony import */ var _css_step_taskpane_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_step_taskpane_css__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _StepDataElement__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./StepDataElement */ "./lib/components/taskpanes/Steps/StepDataElement.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.




/*
    Taskpane containing a list of all the steps and allowing
    a user to interact with them
*/
function StepTaskpane(props) {
    const [openedDropdownIndex, setOpenedDropdownIndex] = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(undefined);
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_DefaultTaskpane__WEBPACK_IMPORTED_MODULE_1__.default, { header: 'Step History', setCurrOpenTaskpane: props.setCurrOpenTaskpane, taskpaneBody: react__WEBPACK_IMPORTED_MODULE_0___default().createElement(react__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, props.stepDataList.map((stepData, index) => {
            return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement(_StepDataElement__WEBPACK_IMPORTED_MODULE_3__.default, { key: stepData.step_id, beforeCurrIdx: index <= props.currStepIdx, openedDropdown: index === openedDropdownIndex, setOpenedDropdown: (openedDropdown) => {
                    if (!openedDropdown) {
                        setOpenedDropdownIndex(undefined);
                    }
                    else {
                        setOpenedDropdownIndex(index);
                    }
                }, stepData: stepData, mitoAPI: props.mitoAPI }));
        })) }));
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (StepTaskpane);


/***/ }),

/***/ "./lib/components/taskpanes/TaskpaneError.js":
/*!***************************************************!*\
  !*** ./lib/components/taskpanes/TaskpaneError.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _css_taskpane_error_css__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../css/taskpane-error.css */ "./css/taskpane-error.css");
/* harmony import */ var _css_taskpane_error_css__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_css_taskpane_error_css__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../css/margins.css */ "./css/margins.css");
/* harmony import */ var _css_margins_css__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_css_margins_css__WEBPACK_IMPORTED_MODULE_2__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.



/*
    An error displayed by the taskpane
*/
const TaskpaneError = (props) => {
    // Don't display the error if no message is given
    if (props.message === '') {
        return react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react__WEBPACK_IMPORTED_MODULE_0___default().Fragment), null);
    }
    return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'taskpane-error-container' },
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", { className: 'taskpane-error-error-icon' },
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("svg", { width: "20", height: "20", viewBox: "0 0 30 30", fill: "none", xmlns: "http://www.w3.org/2000/svg" },
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("g", { clipPath: "url(#clip0)" },
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M15 30.0001C6.71568 30.0001 -6.48499e-05 23.2843 -6.48499e-05 15C-6.48499e-05 6.71574 6.71568 0 15 0C23.2843 0 30 6.71574 30 15C30 23.2843 23.2843 30.0001 15 30.0001Z", fill: "#E84849" }),
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("path", { d: "M2.80608 15.5612C2.80608 16.6244 3.66849 17.4866 4.73149 17.4866H25.2692C26.3324 17.4866 27.1948 16.6244 27.1948 15.5612V14.438C27.1948 13.3748 26.3324 12.5126 25.2692 12.5126H4.73149C3.66849 12.5126 2.80608 13.3748 2.80608 14.438V15.5612Z", fill: "#8A2D2E" })),
                react__WEBPACK_IMPORTED_MODULE_0___default().createElement("defs", null,
                    react__WEBPACK_IMPORTED_MODULE_0___default().createElement("clipPath", { id: "clip0" },
                        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("rect", { width: "30", height: "30", fill: "white", transform: "matrix(-1 0 0 1 30 0)" }))))),
        react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", { className: 'taskpane-error-message ml-p5' }, props.message)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TaskpaneError);


/***/ }),

/***/ "./lib/components/taskpanes/taskpanes.js":
/*!***********************************************!*\
  !*** ./lib/components/taskpanes/taskpanes.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TaskpaneType": () => (/* binding */ TaskpaneType),
/* harmony export */   "EDITING_TASKPANES": () => (/* binding */ EDITING_TASKPANES)
/* harmony export */ });
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.
/*
    Each Taskpane has a type (included TaskpaneType.NONE, which is the type of _no taskpane_ (e.g. nothing is displayed)).

    If you want to be able to open a taskpane in Mito, then you need to add the type of this taskpane,
    as well as any parameters it has, to this type.

    For example, if you create a new taskpane 'Dork' that takes a columnHeader as input, then you should
    add a new element here that looks like:
        | {type: 'TaskpaneType.DORK', columnHeader: string}
*/
var TaskpaneType;
(function (TaskpaneType) {
    TaskpaneType["NONE"] = "none";
    TaskpaneType["PIVOT"] = "pivot";
    TaskpaneType["MERGE"] = "merge";
    TaskpaneType["STEPS"] = "steps";
    TaskpaneType["DOCUMENTATION"] = "documentation";
    TaskpaneType["CONTROL_PANEL"] = "control_panel";
    TaskpaneType["REPLAY_ANALYSIS"] = "replay_analysis";
})(TaskpaneType || (TaskpaneType = {}));
/*
    EDITING_TASKPANES are taskpanes that live update edit the sheet using overwrite=True and therefore should be closed
    when the user begins editing the sheet through some other method.

    EDITING_TASKPANES include: pivot and merge
*/
const EDITING_TASKPANES = [TaskpaneType.PIVOT, TaskpaneType.MERGE];


/***/ }),

/***/ "./lib/components/tours/IntroductionTour.js":
/*!**************************************************!*\
  !*** ./lib/components/tours/IntroductionTour.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react_joyride__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! react-joyride */ "webpack/sharing/consume/default/react-joyride/react-joyride");
/* harmony import */ var react_joyride__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react_joyride__WEBPACK_IMPORTED_MODULE_1__);
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


const steps = [
    {
        // Step 0 
        title: 'Welcome to Mito!',
        content: react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Do you want to take a short tour? I'll show you how to load some data into Mito."),
        placement: 'top-start',
        target: '.mito-main-sheet-div',
        disableBeacon: true
    },
    {
        // Step 1
        content: react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Import data to start your analysis."),
        placement: 'right',
        target: '#tour-import-button-id',
        hideFooter: true
    },
    {
        // Step 2
        title: 'Importing Data',
        content: react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null,
            "Click the ",
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("b", null, "Add File"),
            " button, ",
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("b", null, "select a csv"),
            " from the dropdown, and then press ",
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("b", null, "import.")),
        placement: 'left',
        target: '.modal',
        hideFooter: true
    },
    {
        // Step 3
        title: react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "\uD83C\uDF89 Congrats! \uD83C\uDF89"),
        content: (react__WEBPACK_IMPORTED_MODULE_0___default().createElement("div", null,
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "You've uploaded data to Mito. You're now ready to start automating your analyses. "),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("br", null),
            react__WEBPACK_IMPORTED_MODULE_0___default().createElement("p", null, "Edit your data by writing formulas, sorting, filtering, and creating pivot tables."))),
        placement: 'top',
        target: '.mito-main-sheet-div'
    },
];
class IntroductionTour extends (react__WEBPACK_IMPORTED_MODULE_0___default().Component) {
    constructor(props) {
        super(props);
        /*
            Callback called when Joyride state changes. Because we have a controlled tour,
            we need to manually update the step index.
        */
        this.handleJoyrideCallback = (data) => {
            const { index, type, status, action } = data;
            // if the tour is finished, skipped, or closed, turn off runTour and reset indexes
            if ([react_joyride__WEBPACK_IMPORTED_MODULE_1__.STATUS.FINISHED, react_joyride__WEBPACK_IMPORTED_MODULE_1__.STATUS.SKIPPED].includes(status) || react_joyride__WEBPACK_IMPORTED_MODULE_1__.ACTIONS.CLOSE === action) {
                this.props.setTourInfo(false, 0);
                return;
            }
            let newIndex = index;
            // If the user presses the next button while on step 0, advance to step 1 
            if (index === 0 && react_joyride__WEBPACK_IMPORTED_MODULE_1__.EVENTS.STEP_AFTER === type) {
                newIndex = 1;
                this.setState({ stepIndex: newIndex });
            }
            // If the user is on step 1 and the import modal opens, advance to step 2 
            if (index == 1 && react_joyride__WEBPACK_IMPORTED_MODULE_1__.EVENTS.STEP_BEFORE === type && this.state.isImportModalOpen) {
                newIndex = 2;
                this.setState({ stepIndex: newIndex });
            }
            // If the user is on step 2 and the import modal closes, advance to step 3
            if (index == 2 && !this.state.isImportModalOpen) {
                newIndex = 3;
                this.setState({ stepIndex: newIndex });
            }
            // If the user is on step 3 and ends the tour, end the tour
            if (index === 3 && react_joyride__WEBPACK_IMPORTED_MODULE_1__.EVENTS.STEP_AFTER === type) {
                this.props.setTourInfo(false, 0);
                return;
            }
            // Register tour step index with Mito state
            this.props.setTourInfo(true, newIndex);
        };
        this.state = {
            isImportModalOpen: props.isImportModalOpen,
            stepIndex: props.stepIndex
        };
        this.handleJoyrideCallback = this.handleJoyrideCallback.bind(this);
    }
    render() {
        return (react__WEBPACK_IMPORTED_MODULE_0___default().createElement((react_joyride__WEBPACK_IMPORTED_MODULE_1___default()), { run: this.props.run, steps: steps, stepIndex: this.state.stepIndex, continuous: true, showProgress: true, showSkipButton: true, hideBackButton: true, disableScrolling: this.props.run, disableOverlayClose: true, spotlightClicks: true, callback: this.handleJoyrideCallback, styles: {
                options: {
                    primaryColor: '#0081DE',
                    textColor: '#343434',
                }
            } }));
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (IntroductionTour);


/***/ }),

/***/ "./lib/data/function_documentation.js":
/*!********************************************!*\
  !*** ./lib/data/function_documentation.js ***!
  \********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "functionDocumentationObjects": () => (/* binding */ functionDocumentationObjects)
/* harmony export */ });
const functionDocumentationObjects = [{ "function": "ABS", "description": "Returns the absolute value of the passed number or series.", "examples": ["ABS(-1.3)", "ABS(A)"], "syntax": "ABS(value)", "syntax_elements": [{ "element": "value", "description": "The value or series to take the absolute value of." }] }, { "function": "AND", "description": "Returns True if all of the provided arguments are True, and False if any of the provided arguments are False.", "examples": ["AND(True, False)", "AND(Nums > 100, Nums < 200)", "AND(Pay > 10, Pay < 20, Status == 'active')"], "syntax": "AND(boolean_condition1, [boolean_condition2, ...])", "syntax_elements": [{ "element": "boolean_condition1", "description": "An expression or series that returns True or False values. See IF documentation for a list of conditons." }, { "element": "boolean_condition2 ... [OPTIONAL]", "description": "An expression or series that returns True or False values. See IF documentation for a list of conditons." }] }, { "function": "AVG", "description": "Returns the numerical mean value of the passed numbers and series.", "examples": ["AVG(1, 2)", "AVG(A, B)", "AVG(A, 2)"], "syntax": "AVG(value1, [value2, ...])", "syntax_elements": [{ "element": "value1", "description": "The first number or series to consider when calculating the average." }, { "element": "value2, ... [OPTIONAL]", "description": "Additional numbers or series to consider when calculating the average." }] }, { "function": "BOOL", "description": "Converts the passed arguments to boolean values, either True or False. For numberic values, 0 converts to False while all other values convert to True.", "examples": ["BOOL(Amount_Payed)", "AND(BOOL(Amount_Payed), Is_Paying)"], "syntax": "BOOL(series)", "syntax_elements": [{ "element": "series", "description": "An series to convert to boolean values, either True or False." }] }, { "function": "CLEAN", "description": "Returns the text with the non-printable ASCII characters removed.", "examples": ["CLEAN('ABC\n')"], "syntax": "CLEAN(string)", "syntax_elements": [{ "element": "string", "description": "The string or series whose non-printable characters are to be removed." }] }, { "function": "CONCAT", "description": "Returns the passed strings and series appended together.", "examples": ["CONCAT('Bite', 'the bullet')", "CONCAT(A, B)"], "syntax": "CONCAT(string1, [string2, ...])", "syntax_elements": [{ "element": "string1", "description": "The first string or series." }, { "element": "string2, ... [OPTIONAL]", "description": "Additional strings or series to append in sequence." }] }, { "function": "CORR", "description": "Computes the correlation between two series, excluding missing values.", "examples": ["=CORR(A, B)", "=CORR(B, A)"], "syntax": "CORR(series_one, series_two)", "syntax_elements": [{ "element": "series_one", "description": "The number series to convert to calculate the correlation." }, { "element": "series_two", "description": "The number series to convert to calculate the correlation." }] }, { "function": "DATEVALUE", "description": "Converts a given string to a date series.", "examples": ["DATEVALUE(A)", "DATEVALUE('2012-12-22')"], "syntax": "DATEVALUE(date_string)", "syntax_elements": [{ "element": "date_string", "description": "The date string to turn into a date object." }] }, { "function": "DAY", "description": "Returns the day of the month that a specific date falls on, as a number.", "examples": ["DAY(A)", "DAY('2012-12-22')"], "syntax": "DAY(date)", "syntax_elements": [{ "element": "date", "description": "The date or date series to get the day of." }] }, { "function": "FILLNAN", "description": "Replaces the NaN values in the series with the replacement value.", "examples": ["FILLNAN(A, 10)", "FILLNAN(A, 'replacement')"], "syntax": "FILLNAN(series, replacement)", "syntax_elements": [{ "element": "series", "description": "The series to replace the NaN values in." }, { "element": "replacement", "description": "A string, number, or date to replace the NaNs with." }] }, { "function": "FIND", "description": "Returns the position at which a string is first found within text, case-sensitive. Returns 0 if not found.", "examples": ["FIND(A, 'Jack')", "FIND('Ben has a friend Jack', 'Jack')"], "syntax": "FIND(text_to_search, search_for)", "syntax_elements": [{ "element": "text_to_search", "description": "The text or series to search for the first occurrence of search_for." }, { "element": "search_for", "description": "The string to look for within text_to_search." }] }, { "function": "IF", "description": "Returns one value if the condition is True. Returns the other value if the conditon is False.", "examples": ["IF(Status == 'success', 1, 0)", "IF(Nums > 100, 100, Nums)", "IF(AND(Grade >= .6, Status == 'active'), 'pass', 'fail')"], "syntax": "IF(boolean_condition, value_if_true, value_if_false)", "syntax_elements": [{ "element": "boolean_condition", "description": "An expression or series that returns True or False values. Valid conditions for comparison include ==, !=, >, <, >=, <=." }, { "element": "value_if_true", "description": "The value the function returns if condition is True." }, { "element": "value_if_false", "description": "The value the function returns if condition is False." }] }, { "function": "LEFT", "description": "Returns a substring from the beginning of a specified string.", "examples": ["LEFT(A, 2)", "LEFT('The first character!')"], "syntax": "LEFT(string, [number_of_characters])", "syntax_elements": [{ "element": "string", "description": "The string or series from which the left portion will be returned." }, { "element": "number_of_characters [OPTIONAL, 1 by default]", "description": "The number of characters to return from the start of string." }] }, { "function": "LEN", "description": "Returns the length of a string.", "examples": ["LEN(A)", "LEN('This is 21 characters')"], "syntax": "LEN(string)", "syntax_elements": [{ "element": "string", "description": "The string or series whose length will be returned." }] }, { "function": "LOWER", "description": "Converts a given string to lowercase.", "examples": ["=LOWER('ABC')", "=LOWER(A)", "=LOWER('Nate Rush')"], "syntax": "LOWER(string)", "syntax_elements": [{ "element": "string", "description": "The string or series to convert to lowercase." }] }, { "function": "MAX", "description": "Returns the maximum value among the passed arguments.", "examples": ["MAX(10, 11)", "MAX(Old_Data, New_Data)"], "syntax": "MAX(value1, [value2, ...])", "syntax_elements": [{ "element": "value1", "description": "The first number or column to consider for the maximum value." }, { "element": "value2, ... [OPTIONAL]", "description": "Additional numbers or columns to compute the maximum value from." }] }, { "function": "MID", "description": "Returns a segment of a string.", "examples": ["MID(A, 2, 2)", "MID('Some middle characters!', 3, 4)"], "syntax": "MID(string, starting_at, extract_length)", "syntax_elements": [{ "element": "string", "description": "The string or series to extract the segment from." }, { "element": "starting_at", "description": "The index from the left of string from which to begin extracting." }, { "element": "extract_length", "description": "The length of the segment to extract." }] }, { "function": "MIN", "description": "Returns the minimum value among the passed arguments.", "examples": ["MIN(10, 11)", "MIN(Old_Data, New_Data)"], "syntax": "MIN(value1, [value2, ...])", "syntax_elements": [{ "element": "value1", "description": "The first number or column to consider for the minumum value." }, { "element": "value2, ... [OPTIONAL]", "description": "Additional numbers or columns to compute the minumum value from." }] }, { "function": "MONTH", "description": "Returns the month that a specific date falls in, as a number.", "examples": ["MONTH(A)", "MONTH('2012-12-22')"], "syntax": "MONTH(date)", "syntax_elements": [{ "element": "date", "description": "The date or date series to get the month of." }] }, { "function": "MULTIPLY", "description": "Returns the product of two numbers.", "examples": ["MULTIPLY(2,3)", "MULTIPLY(A,3)"], "syntax": "MULTIPLY(factor1, [factor2, ...])", "syntax_elements": [{ "element": "factor1", "description": "The first number to multiply." }, { "element": "factor2, ... [OPTIONAL]", "description": "Additional numbers or series to multiply." }] }, { "function": "OFFSET", "description": "Shifts the given series by the given offset. Use a negative offset to reference a previous row, and a offset number to reference a later row.", "examples": ["OFFSET(Nums, 10)", "OFFSET(call_time, -1)"], "syntax": "OFFSET(series, offset)", "syntax_elements": [{ "element": "series", "description": "The series to shift up or down." }, { "element": "offset", "description": "An integer amount to shift. Use a negative number to reference a previous row, and a positive number to reference a later row." }] }, { "function": "OR", "description": "Returns True if any of the provided arguments are True, and False if all of the provided arguments are False.", "examples": ["OR(True, False)", "OR(Status == 'success', Status == 'pass', Status == 'passed')"], "syntax": "OR(boolean_condition1, [boolean_condition2, ...])", "syntax_elements": [{ "element": "boolean_condition1", "description": "An expression or series that returns True or False values. See IF documentation for a list of conditons." }, { "element": "boolean_condition2 ... [OPTIONAL]", "description": "An expression or series that returns True or False values. See IF documentation for a list of conditons." }] }, { "function": "PROPER", "description": "Capitalizes the first letter of each word in a specified string.", "examples": ["=PROPER('nate nush')", "=PROPER(A)"], "syntax": "PROPER(string)", "syntax_elements": [{ "element": "string", "description": "The value or series to convert to convert to proper case." }] }, { "function": "RIGHT", "description": "Returns a substring from the beginning of a specified string.", "examples": ["RIGHT(A, 2)", "RIGHT('The last character!')"], "syntax": "RIGHT(string, [number_of_characters])", "syntax_elements": [{ "element": "string", "description": "The string or series from which the right portion will be returned." }, { "element": "number_of_characters [OPTIONAL, 1 by default]", "description": "The number of characters to return from the end of string." }] }, { "function": "ROUND", "description": "Rounds a number to a given number of decimals.", "examples": ["ROUND(1.3)", "ROUND(A, 2)"], "syntax": "ROUND(value, [decimals])", "syntax_elements": [{ "element": "value", "description": "The value or series to round." }, { "element": "decimals", "description": " The number of decimals to round to. Default is 0." }] }, { "function": "SUBSTITUTE", "description": "Replaces existing text with new text in a string.", "examples": ["SUBSTITUTE('Better great than never', 'great', 'late')", "SUBSTITUTE(A, 'dog', 'cat')"], "syntax": "SUBSTITUTE(text_to_search, search_for, replace_with, [count])", "syntax_elements": [{ "element": "text_to_search", "description": "The text within which to search and replace." }, { "element": "search_for", "description": " The string to search for within text_to_search." }, { "element": "replace_with", "description": "The string that will replace search_for." }, { "element": "count", "description": "The number of times to perform the substitute. Default is all." }] }, { "function": "SUM", "description": "Returns the sum of the given numbers and series.", "examples": ["SUM(10, 11)", "SUM(A, B, D, F)", "SUM(A, B, D, F)"], "syntax": "SUM(value1, [value2, ...])", "syntax_elements": [{ "element": "value1", "description": "The first number or column to add together." }, { "element": "value2, ... [OPTIONAL]", "description": "Additional numbers or columns to sum." }] }, { "function": "TEXT", "description": "Turns the passed series into a string.", "examples": ["=TEXT(Product_Number)", "=TEXT(Start_Date)"], "syntax": "TEXT(series)", "syntax_elements": [{ "element": "series", "description": "The series to convert to a string." }] }, { "function": "TRIM", "description": "Returns a string with the leading and trailing whitespace removed.", "examples": ["=TRIM('  ABC')", "=TRIM('  ABC  ')", "=TRIM(A)"], "syntax": "TRIM(string)", "syntax_elements": [{ "element": "string", "description": "The value or series to remove the leading and trailing whitespace from." }] }, { "function": "TYPE", "description": "Returns the type of each element of the passed series. Return values are 'number', 'str', 'bool', 'datetime', 'object', or 'NaN'.", "examples": ["TYPE(Nums_and_Strings)", "IF(TYPE(Account_Numbers) != 'NaN', Account_Numbers, 0)"], "syntax": "TYPE(series)", "syntax_elements": [{ "element": "series", "description": "The series to get the type of each element of." }] }, { "function": "UPPER", "description": "Converts a given string to uppercase.", "examples": ["=UPPER('abc')", "=UPPER(A)", "=UPPER('Nate Rush')"], "syntax": "UPPER(string)", "syntax_elements": [{ "element": "string", "description": "The string or series to convert to uppercase." }] }, { "function": "VALUE", "description": "Converts a string series to a number series. Any values that fail to convert will return an NaN.", "examples": ["=VALUE(A)", "=VALUE('123')"], "syntax": "VALUE(string)", "syntax_elements": [{ "element": "string", "description": "The string or series to convert to a number." }] }, { "function": "WEEKDAY", "description": "Returns the day of the week that a specific date falls on. 1-7 corresponds to Monday-Sunday.", "examples": ["WEEKDAY(A)", "WEEKDAY('2012-12-22')"], "syntax": "WEEKDAY(date)", "syntax_elements": [{ "element": "date", "description": "The date or date series to get the weekday of." }] }, { "function": "YEAR", "description": "Returns the day of the year that a specific date falls in, as a number.", "examples": ["YEAR(A)", "YEAR('2012-12-22')"], "syntax": "YEAR(date)", "syntax_elements": [{ "element": "date", "description": "The date or date series to get the month of." }] }];


/***/ }),

/***/ "./lib/plugin.js":
/*!***********************!*\
  !*** ./lib/plugin.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _jupyter_widgets_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyter-widgets/base */ "webpack/sharing/consume/default/@jupyter-widgets/base/@jupyter-widgets/base");
/* harmony import */ var _jupyter_widgets_base__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyter_widgets_base__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @jupyterlab/notebook */ "webpack/sharing/consume/default/@jupyterlab/notebook");
/* harmony import */ var _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _widget__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./widget */ "./lib/widget.js");
/* harmony import */ var _version__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./version */ "./lib/version.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.




const EXTENSION_ID = 'mitosheet:plugin';
const examplePlugin = {
    id: EXTENSION_ID,
    requires: [_jupyter_widgets_base__WEBPACK_IMPORTED_MODULE_0__.IJupyterWidgetRegistry, _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__.INotebookTracker],
    activate: activateWidgetExtension,
    autoStart: true,
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (examplePlugin);
function getCellAtIndex(cells, index) {
    if (cells == undefined) {
        return undefined;
    }
    const cellsIterator = cells.iter();
    let cell = cellsIterator.next();
    let i = 0;
    while (cell) {
        if (i == index) {
            return cell;
        }
        i++;
        cell = cellsIterator.next();
    }
    return undefined;
}
function codeContainer(analysisName, code) {
    if (code.length == 0) {
        return '';
    }
    return `# MITO CODE START (DO NOT EDIT)
# SAVED-ANALYSIS-START${analysisName}SAVED-ANALYSIS-END

from mitosheet3 import *

${code.join('\n\n')}
  
# MITO CODE END (DO NOT EDIT)`;
}
function getAnalysisName(codeblock) {
    /*
    Given the code container format, returns the name of the analysis.
  */
    if (!codeblock.includes('SAVED-ANALYSIS-START')) {
        return undefined;
    }
    // We get just the string part of the container that is the column spreadsheet code
    return codeblock.substring(codeblock.indexOf('SAVED-ANALYSIS-START') + 'SAVED-ANALYSIS-START'.length, codeblock.indexOf('SAVED-ANALYSIS-END'));
}
function getCellText(cell) {
    if (cell == undefined)
        return '';
    const value = cell.modelDB.get('value');
    return value.text;
}
function isMitosheetSheetCell(cell) {
    // Returns true iff a the given cell ends with a mitosheet.sheet call
    // and so displays a mito sheet when run!
    const currentCode = getCellText(cell);
    // Take all the non-empty lines from the cell
    const lines = currentCode.split('\n').filter(line => { return line.length > 0; });
    if (lines.length == 0) {
        return false;
    }
    const lastLine = lines[lines.length - 1];
    return lastLine.startsWith('mitosheet.sheet(');
}
function isMitoAnalysisCell(cell) {
    // Returns true iff a the given cell is a cell containing the generated
    // mito analysis code
    const currentCode = getCellText(cell);
    return currentCode.startsWith('# MITO CODE START');
}
/* Returns True if the passed cell is empty */
function isEmptyCell(cell) {
    const currentCode = getCellText(cell);
    return currentCode.trim() === '';
}
function writeToCell(cell, code) {
    if (cell == undefined) {
        return;
    }
    const value = cell.modelDB.get('value');
    value.text = code;
}
/**
 * Activate the widget extension.
 */
function activateWidgetExtension(app, registry, tracker) {
    /*
    We define a command here, so that we can call it elsewhere in the
    app - and here is the only place we have access to the app (which we
    need to be able to add commands) and tracker (which we need to get
    the current notebook).
  */
    app.commands.addCommand('write-code-to-cell', {
        label: 'Write Mito Code to a Cell',
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        execute: (args) => {
            /*
        Given an analysisName and code, this writes the code to the cell.
        
        We assume this function is called either:
        1. When the current cell is the cell that calls mitosheet.sheet
        2. When the current cell is _right below_ the cell that calls mitosheet.sheet

        If we're in case (1):
        - If the cell below already has a mito analysis written to it, we overwrite it
        - If the cell below has no existing mito analysis, we insert a new cell and write to that.

        If we're in case (2):
        - If this has the analysis written to it, we overwrite it.
        - Otherwise, we insert a new cell above and write to that.
      */
            var _a, _b;
            const analysisName = args.analysisName;
            const codeJSON = args.codeJSON;
            // This is the code that was passed to write to the cell.
            const code = codeContainer(analysisName, codeJSON.code);
            // We get the current notebook (currentWidget)
            const notebook = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;
            const cells = (_b = notebook === null || notebook === void 0 ? void 0 : notebook.model) === null || _b === void 0 ? void 0 : _b.cells;
            if (notebook == undefined || cells == undefined) {
                return;
            }
            const activeCell = notebook.activeCell;
            const activeCellIndex = notebook.activeCellIndex;
            if (isMitosheetSheetCell(activeCell === null || activeCell === void 0 ? void 0 : activeCell.model)) {
                const nextCell = getCellAtIndex(cells, activeCellIndex + 1);
                if (isMitoAnalysisCell(nextCell)) {
                    // If the next cell contains a mito analysis, we overwrite it
                    writeToCell(nextCell, code);
                }
                else {
                    // Otherwise, we insert a cell above and write to that. 
                    _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__.NotebookActions.insertBelow(notebook);
                    const newNextCell = getCellAtIndex(cells, activeCellIndex + 1);
                    writeToCell(newNextCell, code);
                }
            }
            else {
                // We assume we're in case 2, and thus the current cell is where the analysis should be
                if (isMitoAnalysisCell(activeCell === null || activeCell === void 0 ? void 0 : activeCell.model)) {
                    // If this is already analysis, we overwrite it
                    writeToCell(activeCell === null || activeCell === void 0 ? void 0 : activeCell.model, code);
                }
                else {
                    // Otherwise, we insert a cell above, and write to that, if the current cell is not empty
                    if (!isEmptyCell(activeCell === null || activeCell === void 0 ? void 0 : activeCell.model)) {
                        _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__.NotebookActions.insertAbove(notebook);
                    }
                    // New cell is the previous cell, now
                    const prevCell = notebook.activeCell;
                    writeToCell(prevCell === null || prevCell === void 0 ? void 0 : prevCell.model, code);
                }
            }
        }
    });
    app.commands.addCommand('repeat-analysis', {
        label: 'Replicates the current analysis on a given new file, in a new cell.',
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        execute: (args) => {
            var _a, _b;
            const fileName = args.fileName;
            // We get the current notebook (currentWidget)
            const notebook = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;
            const context = (_b = tracker.currentWidget) === null || _b === void 0 ? void 0 : _b.context;
            if (!notebook || !context)
                return;
            // We run the current cell and insert a cell below
            // TODO: see if handling this promise is good enough!
            void _jupyterlab_notebook__WEBPACK_IMPORTED_MODULE_1__.NotebookActions.runAndInsert(notebook, context.sessionContext);
            // And then we write to this inserted cell (which is now the active cell)
            const activeCell = notebook.activeCell;
            if (activeCell) {
                const value = activeCell.model.modelDB.get('value');
                const df_name = fileName.replace(' ', '_').split('.')[0]; // We replace common file names with a dataframe name
                const code = `# Repeated analysis on ${fileName}\n\n${df_name} = pd.read_csv('${fileName}')\n\nmito_analysis(${df_name})\n\nmitosheet.sheet(${df_name})`;
                value.text = code;
            }
        }
    });
    app.commands.addCommand('get-df-names', {
        label: 'Read df name from mitosheet3.sheet call',
        execute: () => {
            /*
        This function has to deal with the fact that there are 2 cases
        in which we want to get the dataframe names:
        1. The first time we are rendering a mitosheet (e.g. after you run a sheet
          with a mitosheet.sheet call).
          
          In this case, the active cell is the cell _after_ the mitosheet.sheet call.

        2. When you have a Mito sheet already displayed and saved in your notebook,
          and your refresh the page.

          In this case, the active cell is the first cell in the notebook, which
          may or may not be the cell the mitosheet.sheet call is actually made.

        We handle these cases by detecting which case we're in based on the index
        of the currently selected cell.

        However, in a sheet with _multiple_ mitosheet.sheet calls, if we're in
        case (2), we can't know which cell to pull from. I haven't been able to
        think of away around this.
        
        However, since this is rare for now, we don't worry about it and just do whatever
        here for now, and hope the user will refresh the sheet if it's not working!
      */
            var _a, _b;
            // We get the current notebook (currentWidget)
            const notebook = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;
            if (!notebook)
                return [];
            const activeCellIndex = notebook.activeCellIndex;
            const cells = (_b = notebook.model) === null || _b === void 0 ? void 0 : _b.cells;
            const getDfNamesFromCellContent = (content) => {
                let nameString = content.split('mitosheet.sheet(')[1].split(')')[0];
                // If there is a tutorial mode parameter passed, we ignore it
                if (nameString.includes('tutorial_mode')) {
                    nameString = nameString.split('tutorial_mode')[0].trim();
                }
                // If there is a analysis name parameter passed, we ignore it
                if (nameString.includes('saved_analysis_name')) {
                    nameString = nameString.split('saved_analysis_name')[0].trim();
                }
                const dfNames = nameString.split(',').map(dfName => dfName.trim()).filter(dfName => dfName.length > 0);
                return dfNames;
            };
            // See comment above. We are in case (2). 
            if (activeCellIndex === 0 && cells !== undefined) {
                // We just get the first mitosheet.sheet call we can find
                const cellsIterator = cells.iter();
                let cell = cellsIterator.next();
                while (cell) {
                    const cellContent = cell.modelDB.get('value').text;
                    if (cellContent.includes('mitosheet.sheet')) {
                        return getDfNamesFromCellContent(cellContent);
                    }
                    cell = cellsIterator.next();
                }
                return [];
            }
            else {
                // Otherwise, were in case (1)
                const previousCell = getCellAtIndex(cells, activeCellIndex - 1); // TODO: change this to next cell model or something
                if (previousCell) {
                    // remove the df argument to mitosheet.sheet() from the cell's text
                    const previousCellContent = previousCell.modelDB.get('value').text;
                    return getDfNamesFromCellContent(previousCellContent);
                }
                return [];
            }
        }
    });
    app.commands.addCommand('read-existing-analysis', {
        label: 'Reads any existing mito analysis from the previous cell, and returns the saved ColumnSpreadsheetCodeJSON, if it exists.',
        execute: () => {
            /*
        This should _only_ run right after the mitosheet.sheet call is run,
        and so the currently selected cell is the cell that actually contains the mito
        analysis.
      */
            var _a;
            // We get the current notebook (currentWidget)
            const notebook = (_a = tracker.currentWidget) === null || _a === void 0 ? void 0 : _a.content;
            if (!notebook)
                return undefined;
            // We get the previous cell to the current active cell
            const activeCell = notebook.activeCell;
            if (activeCell) {
                // remove the df argument to mitosheet.sheet() from the cell's text
                const previousValue = activeCell.model.modelDB.get('value');
                return getAnalysisName(previousValue.text);
            }
            return undefined;
        }
    });
    window.commands = app.commands; // so we can write to it elsewhere
    registry.registerWidget({
        name: _version__WEBPACK_IMPORTED_MODULE_3__.MODULE_NAME,
        version: _version__WEBPACK_IMPORTED_MODULE_3__.MODULE_VERSION,
        exports: _widget__WEBPACK_IMPORTED_MODULE_2__,
    });
}


/***/ }),

/***/ "./lib/types/StepTypes.js":
/*!********************************!*\
  !*** ./lib/types/StepTypes.js ***!
  \********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "StepType": () => (/* binding */ StepType)
/* harmony export */ });
var StepType;
(function (StepType) {
    StepType["Initialize"] = "initialize";
    StepType["AddColumn"] = "add_column";
    StepType["DeleteColumn"] = "delete_column";
    StepType["RenameColumn"] = "rename_column";
    StepType["ReorderColumn"] = "reorder_column";
    StepType["FilterColumn"] = "filter_column";
    StepType["SetColumnFormula"] = "set_column_formula";
    StepType["DataframeDelete"] = "dataframe_delete";
    StepType["DataframeDuplicate"] = "dataframe_duplicate";
    StepType["DataframeRename"] = "dataframe_rename";
    StepType["SimpleImport"] = "simple_import";
    StepType["RawPythonImport"] = "raw_python_import";
    StepType["Sort"] = "sort";
    StepType["Pivot"] = "pivot";
    StepType["Merge"] = "merge";
})(StepType || (StepType = {}));


/***/ }),

/***/ "./lib/utils/gridData.js":
/*!*******************************!*\
  !*** ./lib/utils/gridData.js ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MITO_INDEX": () => (/* binding */ MITO_INDEX),
/* harmony export */   "buildGridData": () => (/* binding */ buildGridData),
/* harmony export */   "buildGridColumns": () => (/* binding */ buildGridColumns),
/* harmony export */   "getNewSelectedColumn": () => (/* binding */ getNewSelectedColumn)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ag_grid_react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ag-grid-react */ "webpack/sharing/consume/default/ag-grid-react/ag-grid-react");
/* harmony import */ var ag_grid_react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(ag_grid_react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _components_ColumnHeader__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../components/ColumnHeader */ "./lib/components/ColumnHeader.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.



const MITO_INDEX = 'mito_index';
// convert json formatted data frame into Ag-Grid data structure 
function buildGridData(sheetJSON) {
    const gridData = [];
    if (sheetJSON === undefined) {
        return gridData;
    }
    const columns = sheetJSON.columns;
    // iterate through the data frame to get each row
    for (let i = 0; i < sheetJSON.data.length; i++) {
        const rowDict = {};
        // set the index column of the Ag-Grid
        rowDict[MITO_INDEX] = `${i + 1}`;
        // iterate through the column to get each element
        for (let j = 0; j < sheetJSON.data[i].length; j++) {
            // create dict entry for row
            const rowDictKey = columns[j];
            rowDict[rowDictKey] = sheetJSON.data[i][j];
        }
        gridData.push(rowDict);
    }
    return gridData;
}
// create columns from data frame columns
function buildGridColumns(df_columns, columnSpreadsheetCodeJSON, columnFiltersJSON, formulaBarValue, editingColumn, selectedColumn, editingColumnCursorIndex, setEditingMode, setEditingFormula, setCursorIndex, setCurrOpenTaskpane, columnWidths, setSelectedColumn) {
    const gridColumns = [];
    if (df_columns === undefined) {
        return gridColumns;
    }
    // create index column
    gridColumns.push(react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ag_grid_react__WEBPACK_IMPORTED_MODULE_1__.AgGridColumn, { key: MITO_INDEX, headerName: '', resizable: true, field: MITO_INDEX, width: 10, lockPosition: true }));
    // iterate through columns of df_columns to create Ag-Grid columns
    df_columns.forEach((columnHeader) => {
        const headerName = columnHeader.toString();
        // only allow formula columns to be editable 
        const isEditable = columnSpreadsheetCodeJSON[headerName] !== '';
        /*
            if the column is the selected column:
                1. set the formula to the formula bar value to make sure that if the user has been editing the formula before ending
                cell editing mode, the most recent formula is used.
                2. set the cursor index to the last index the user was editing at
        */
        let columnFormula = columnSpreadsheetCodeJSON[headerName];
        let cursorIndex = columnFormula.length;
        if (headerName === editingColumn) {
            columnFormula = formulaBarValue;
            cursorIndex = editingColumnCursorIndex;
        }
        gridColumns.push(react__WEBPACK_IMPORTED_MODULE_0___default().createElement(ag_grid_react__WEBPACK_IMPORTED_MODULE_1__.AgGridColumn, Object.assign({ key: headerName }, (headerName === selectedColumn ? { cellStyle: { 'background-color': 'rgba(152, 205, 248, 0.3)' } } : { cellStyle: { 'background-color': 'rgba(152, 205, 248, 0.0)' } }), { field: headerName, headerName: headerName, headerComponentFramework: _components_ColumnHeader__WEBPACK_IMPORTED_MODULE_2__.default, resizable: true, headerComponentParams: {
                setSelectedColumn: setSelectedColumn,
                setCurrOpenTaskpane: setCurrOpenTaskpane,
                displayName: headerName,
                filters: columnFiltersJSON[headerName].filters
            }, cellEditor: 'simpleEditor', cellEditorParams: {
                formula: columnFormula,
                setEditingMode: setEditingMode,
                setEditingFormula: setEditingFormula,
                setCursorIndex: setCursorIndex,
                cursorIndex: cursorIndex,
                columns: df_columns
            }, editable: isEditable, width: columnWidths[headerName] })));
    });
    return gridColumns;
}
/*
    A helper function that will return the new column to select (assuming
    that the previous selected column was deleted).

    Note that newColumnHeaders and oldColumnHeaders are the values of the columns
    in the sheet json before and after deleting.

    NOTE: If the oldSelectedColumnHeader is not in the oldColumnHeaders, then this
    should return the first column in the newColumnHeaders.
*/
function getNewSelectedColumn(newColumnHeaders, oldValues) {
    if (oldValues === undefined) {
        return newColumnHeaders[0] === undefined ? '' : newColumnHeaders[0];
    }
    // We take the column to the right, if it exists. Otherwise we take the column to the left,
    // and otherwise just select the first column
    const index = oldValues.oldColumnHeaders.indexOf(oldValues.oldSelectedColumnHeader);
    if (newColumnHeaders[index] !== undefined) {
        return newColumnHeaders[index];
    }
    else if (newColumnHeaders[index - 1] !== undefined) {
        return newColumnHeaders[index - 1];
    }
    else {
        return newColumnHeaders[0] === undefined ? '' : newColumnHeaders[0];
    }
}


/***/ }),

/***/ "./lib/utils/gridStyling.js":
/*!**********************************!*\
  !*** ./lib/utils/gridStyling.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SHEET_HEIGHT_PIXELS": () => (/* binding */ SHEET_HEIGHT_PIXELS),
/* harmony export */   "DEFAULT_COLUMN_WIDTH": () => (/* binding */ DEFAULT_COLUMN_WIDTH),
/* harmony export */   "LAST_COLUMN_DEFAULT_WIDTH": () => (/* binding */ LAST_COLUMN_DEFAULT_WIDTH),
/* harmony export */   "headerHeightParams": () => (/* binding */ headerHeightParams),
/* harmony export */   "getColumnWidthsArray": () => (/* binding */ getColumnWidthsArray),
/* harmony export */   "getColumnWidths": () => (/* binding */ getColumnWidths),
/* harmony export */   "calculateAndSetHeaderHeight": () => (/* binding */ calculateAndSetHeaderHeight),
/* harmony export */   "getHeaderWords": () => (/* binding */ getHeaderWords)
/* harmony export */ });
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.
const SHEET_HEIGHT_PIXELS = 400;
const DEFAULT_COLUMN_WIDTH = 125;
const LAST_COLUMN_DEFAULT_WIDTH = 300; /* Make sure that this is the width as suggestion-box-container in suggestion-box.css */
const headerHeightParams = {
    defaultHeaderHeight: 40,
    charactersPerRow: 9,
    pixelsPerRow: 35 // number of pixels per row
};
/*
    A helper function for getting the width of columns, for all columns in all sheets. If given the prevColumnWidths, then
    will take columnWidths from there - and if not, will default to the DEFAULT_COLUMN_WIDTH.
*/
function getColumnWidthsArray(sheetJSONArray, prevColumnWidthsArray) {
    let changed = prevColumnWidthsArray === undefined || sheetJSONArray.length !== prevColumnWidthsArray.length;
    const newColumnWidthsArray = [];
    for (let i = 0; i < sheetJSONArray.length; i++) {
        const columnHeaders = sheetJSONArray[i].columns;
        const prevColumnWidths = prevColumnWidthsArray ? prevColumnWidthsArray[i] : undefined;
        const newColumnsWidthsResult = getColumnWidths(columnHeaders, prevColumnWidths);
        newColumnWidthsArray.push(newColumnsWidthsResult.columnWidths);
        changed = changed || newColumnsWidthsResult.changed;
    }
    return {
        columnWidthsArray: newColumnWidthsArray,
        changed: changed
    };
}
/*
    A helper function for getting the width of a list of columns. If given the prevColumnWidths, then
    will take columnWidths from there - and if not, will default to the DEFAULT_COLUMN_WIDTH.

    Includes a helper variable, changed, which tells if you if anything is different between these objects.
*/
function getColumnWidths(columnHeaders, prevColumnWidths) {
    var _a;
    const newColumnWidths = {};
    // We mark these widths as changed if there were no previous widths, or if there are a different number of columns
    let changed = prevColumnWidths === undefined || columnHeaders.length !== ((_a = Object.keys(prevColumnWidths)) === null || _a === void 0 ? void 0 : _a.length);
    for (let i = 0; i < columnHeaders.length; i++) {
        const columnHeader = columnHeaders[i];
        if (prevColumnWidths && i === columnHeaders.length - 1 && prevColumnWidths[columnHeader] < LAST_COLUMN_DEFAULT_WIDTH) {
            // If its the last column, make sure the column is at least LAST_COLUMN_DEFAULT_WIDTH so the cell editor is not cutoff
            newColumnWidths[columnHeader] = LAST_COLUMN_DEFAULT_WIDTH;
            changed = true;
        }
        else if (prevColumnWidths && i !== columnHeaders.length - 1 && prevColumnWidths[columnHeader] === LAST_COLUMN_DEFAULT_WIDTH) {
            // If it was previously the last column and the user didn't change it from the default with, 
            // set the column width to DEFAULT_COLUMN_WIDTH.
            newColumnWidths[columnHeader] = DEFAULT_COLUMN_WIDTH;
            changed = true;
        }
        else if (prevColumnWidths && prevColumnWidths[columnHeader]) {
            // if the column has a width, then maintain it
            newColumnWidths[columnHeader] = prevColumnWidths[columnHeader];
        }
        else {
            newColumnWidths[columnHeader] = DEFAULT_COLUMN_WIDTH;
            // If there is a new column, then things have changed!
            changed = true;
        }
    }
    return {
        columnWidths: newColumnWidths,
        changed: changed
    };
}
function calculateAndSetHeaderHeight(model_id) {
    var _a, _b;
    // we now do some work to find the best height to give the header row
    // first find the largest header
    let maxHeaderLength = 0;
    const gridApi = (_a = window.gridApiMap) === null || _a === void 0 ? void 0 : _a.get(model_id);
    // if the gridApi does not exist, stop
    if (gridApi === undefined) {
        return;
    }
    const rowNodeData = (_b = gridApi.getRowNode('0')) === null || _b === void 0 ? void 0 : _b.data;
    if (rowNodeData === undefined) {
        // This is undefined when the sheet is empty, and thus there aren't
        // any column headers to resize. Thus, we don't need to do anything.
        return;
    }
    Object.keys(rowNodeData).forEach(key => {
        /*
            because each row can only hold 9 characters on average,
            if any words are greater than 9 characters, it will be split into two rows.

            To make sure that we accommodate these special situations, we assume the worst case
            scenario, and add an extra entire line.
        */
        let paddingCharacters = 0;
        getHeaderWords(key).forEach(word => {
            if (word.length > headerHeightParams.charactersPerRow) {
                paddingCharacters += headerHeightParams.charactersPerRow;
            }
        });
        maxHeaderLength = key.length + paddingCharacters > maxHeaderLength ? key.length + paddingCharacters : maxHeaderLength;
    });
    /*
        then set the correct header height...
        we fit on average 10 letters per row with a starting width of 40 pixels
        and we give each row 30 px of space
    */
    gridApi.setHeaderHeight(Math.min(Math.max((maxHeaderLength / headerHeightParams.charactersPerRow - 1) * headerHeightParams.pixelsPerRow, headerHeightParams.defaultHeaderHeight), SHEET_HEIGHT_PIXELS / 3));
    gridApi.refreshHeader();
}
function getHeaderWords(header) {
    /*
        We split the headers at _, and add _ to the latter half (e.g. first_name -> [first, _name]).

        If consecutive words can be combined and be less than the characters per row, then
        we combine them greedly.

    */
    const headerWords = [];
    const headerWordSplit = header.split(/(?=_)/g);
    let i;
    for (i = 0; i < headerWordSplit.length - 1; i++) {
        const firstWord = headerWordSplit[i];
        const secondWord = headerWordSplit[i + 1];
        if ((firstWord.length + secondWord.length) <= headerHeightParams.charactersPerRow) {
            headerWords.push(firstWord + secondWord);
            i++;
        }
        else {
            headerWords.push(firstWord);
        }
    }
    if (i === headerWordSplit.length - 1) {
        headerWords.push(headerWordSplit[headerWordSplit.length - 1]);
    }
    return headerWords;
}


/***/ }),

/***/ "./lib/utils/suggestions.js":
/*!**********************************!*\
  !*** ./lib/utils/suggestions.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getEndingColumnHeader": () => (/* binding */ getEndingColumnHeader),
/* harmony export */   "endsInColumnHeader": () => (/* binding */ endsInColumnHeader),
/* harmony export */   "getColumnHeaderSuggestions": () => (/* binding */ getColumnHeaderSuggestions),
/* harmony export */   "getEndingFunction": () => (/* binding */ getEndingFunction),
/* harmony export */   "getFunctionSuggestions": () => (/* binding */ getFunctionSuggestions)
/* harmony export */ });
/* harmony import */ var _data_function_documentation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../data/function_documentation */ "./lib/data/function_documentation.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.

/*
    Gets the prefix of any possible column headers at the end of the formula. E.g.

    - header -> header
    - header_123 -> header_123
    - function(header_123 -> header_123
    - func(data, 100 -> undefined
*/
function getEndingColumnHeader(formula) {
    /*
        Returns the maximal column header at the end of the formula,
        that meets the column_header validity condition.
    */
    let i = formula.length;
    for (i; i--; i >= 0) {
        const char = formula[i];
        if (!char.match(/[0-9A-Za-z_]+/g)) {
            // Stop as soon as we find a character that can't be in a column header
            break;
        }
    }
    const possibleColumnHeader = formula.substr(i + 1);
    return possibleColumnHeader.length === 0 ? undefined : possibleColumnHeader;
}
/*
    Returns true iff the formula has a column header as a suffix.
*/
function endsInColumnHeader(formula, columns) {
    const endingColumnHeader = getEndingColumnHeader(formula);
    if (endingColumnHeader === undefined) {
        return false;
    }
    return columns.findIndex((columnHeader) => columnHeader === endingColumnHeader) >= 0;
}
/*
    Returns a list of suggestions for column headers to append onto the given
    formula. These column headers must be prefixed by the ending column header.
    Case sensitive.

    Returns undefined if there are no suggestions.
*/
function getColumnHeaderSuggestions(formula, columns) {
    const endingColumnHeader = getEndingColumnHeader(formula);
    if (endingColumnHeader === undefined) {
        return undefined;
    }
    const matchingColumnHeaders = columns.filter((columnHeader) => {
        return (typeof columnHeader == 'string') && (columnHeader.startsWith(endingColumnHeader));
    });
    const suggestions = matchingColumnHeaders.map(columnHeader => {
        return {
            match: endingColumnHeader,
            suggestion: columnHeader,
            subtitle: 'A column in this sheet.',
            type: 'columnHeader'
        };
    });
    if (suggestions.length == 0) {
        return undefined;
    }
    return suggestions;
}
/*
    Gets the prefix of any function at the end of the formula. E.g.

    - func -> func
    - func123 -> undefined
    - function(newfunc -> newfunc
*/
function getEndingFunction(formula) {
    /*
        Returns the maximal formula at the end of the formula.
    */
    let i = formula.length;
    for (i; i--; i >= 0) {
        const char = formula[i];
        if (!char.match(/[A-Za-z]+/g)) {
            // Stop as soon as we find a character that can't be in a column header
            break;
        }
    }
    const possibleFunction = formula.substr(i + 1);
    return possibleFunction.length === 0 ? undefined : possibleFunction;
}
/*
    Returns all the function suggestions for the given formula, which
    it matches at the end of the formula. Case insensitive.
*/
function getFunctionSuggestions(formula) {
    const endingFunction = getEndingFunction(formula);
    if (endingFunction === undefined) {
        return undefined;
    }
    const matchingFunctionDocObjects = _data_function_documentation__WEBPACK_IMPORTED_MODULE_0__.functionDocumentationObjects.filter((funcDocObject) => {
        return funcDocObject.function.startsWith(endingFunction.toUpperCase());
    });
    const suggestions = matchingFunctionDocObjects.map(funcDocObject => {
        return {
            match: endingFunction,
            suggestion: funcDocObject.function,
            subtitle: funcDocObject.description,
            type: 'function'
        };
    });
    if (suggestions.length == 0) {
        return undefined;
    }
    return suggestions;
}


/***/ }),

/***/ "./lib/version.js":
/*!************************!*\
  !*** ./lib/version.js ***!
  \************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MODULE_VERSION": () => (/* binding */ MODULE_VERSION),
/* harmony export */   "MODULE_NAME": () => (/* binding */ MODULE_NAME)
/* harmony export */ });
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.
// eslint-disable-next-line @typescript-eslint/no-var-requires
const data = __webpack_require__(/*! ../package.json */ "./package.json");
/**
 * The _model_module_version/_view_module_version this package implements.
 *
 * The html widget manager assumes that this is the same as the npm package
 * version number.
 */
const MODULE_VERSION = data.version;
/*
 * The current package name.
 */
const MODULE_NAME = data.name;


/***/ }),

/***/ "./lib/widget.js":
/*!***********************!*\
  !*** ./lib/widget.js ***!
  \***********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ExampleModel": () => (/* binding */ ExampleModel),
/* harmony export */   "ExampleView": () => (/* binding */ ExampleView)
/* harmony export */ });
/* harmony import */ var _jupyter_widgets_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @jupyter-widgets/base */ "webpack/sharing/consume/default/@jupyter-widgets/base/@jupyter-widgets/base");
/* harmony import */ var _jupyter_widgets_base__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_jupyter_widgets_base__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _version__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./version */ "./lib/version.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "webpack/sharing/consume/default/react");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react-dom */ "webpack/sharing/consume/default/react-dom");
/* harmony import */ var react_dom__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react_dom__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _components_Mito__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./components/Mito */ "./lib/components/Mito.js");
/* harmony import */ var _utils_gridStyling__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils/gridStyling */ "./lib/utils/gridStyling.js");
/* harmony import */ var _api__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./api */ "./lib/api.js");
// Copyright (c) Mito
// Distributed under the terms of the Modified BSD License.


// React


// Components

class ExampleModel extends _jupyter_widgets_base__WEBPACK_IMPORTED_MODULE_0__.DOMWidgetModel {
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    defaults() {
        return Object.assign(Object.assign({}, super.defaults()), { _model_name: ExampleModel.model_name, _model_module: ExampleModel.model_module, _model_module_version: ExampleModel.model_module_version, _view_name: ExampleModel.view_name, _view_module: ExampleModel.view_module, _view_module_version: ExampleModel.view_module_version, df_json: '' });
    }
}
ExampleModel.serializers = Object.assign({}, _jupyter_widgets_base__WEBPACK_IMPORTED_MODULE_0__.DOMWidgetModel.serializers);
ExampleModel.model_name = 'ExampleModel';
ExampleModel.model_module = _version__WEBPACK_IMPORTED_MODULE_1__.MODULE_NAME;
ExampleModel.model_module_version = _version__WEBPACK_IMPORTED_MODULE_1__.MODULE_VERSION;
ExampleModel.view_name = 'ExampleView'; // Set to null if no view
ExampleModel.view_module = _version__WEBPACK_IMPORTED_MODULE_1__.MODULE_NAME; // Set to null if no view
ExampleModel.view_module_version = _version__WEBPACK_IMPORTED_MODULE_1__.MODULE_VERSION;



class ExampleView extends _jupyter_widgets_base__WEBPACK_IMPORTED_MODULE_0__.DOMWidgetView {
    /*
    We override the DOMWidgetView constructor, so that we can
    create a logging instance for this view.
  */
    initialize(parameters) {
        super.initialize(parameters);
    }
    /*
    We override the sending message utilities
  */
    send(msg) {
        var _a, _b;
        // If this is a message that makes a change (anything but a log_event or api_call or has_rendered_update),
        // then we make the system as loading, as we wait for a response
        if (msg['event'] !== 'log_event' && msg['event'] !== 'api_call' && msg['type'] !== 'has_rendered_update') {
            (_b = (_a = window.mitoMap) === null || _a === void 0 ? void 0 : _a.get(this.model.model_id)) === null || _b === void 0 ? void 0 : _b.setState({
                loading: true
            });
        }
        super.send(msg);
    }
    render() {
        var _a, _b;
        // Capture the send, to pass to the component
        const send = (msg) => {
            this.send(msg);
        };
        // TODO: there is a memory leak, in the case where
        // we rerender the component (e.g. we run the mito.sheet)
        // cell again. We need to clean up the component somehow!
        const model_id = this.model.model_id;
        const mitoAPI = new _api__WEBPACK_IMPORTED_MODULE_6__.MitoAPI(send);
        react_dom__WEBPACK_IMPORTED_MODULE_3___default().render(react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_components_Mito__WEBPACK_IMPORTED_MODULE_4__.default, { mitoAPI: mitoAPI, dfNames: this.getDfNames(), sheetShapeArray: this.getSheetShapeArray(), currStepIdx: this.getCurrStepIdx(), sheetJSONArray: this.getSheetJSONArray(), columnSpreadsheetCodeJSONArray: this.getColumnSpreadsheetCodeJSONArray(), savedAnalysisNames: this.getSavedAnalysisNames(), columnFiltersArray: this.getColumnFilters(), columnTypeJSONArray: this.getColumnTypeJSONArray(), tutorialMode: this.getTutorialMode(), model_id: model_id, isLocalDeployment: this.getIsLocalDeployment(), userEmail: this.getUserEmail(), shouldUpgradeMitosheet: this.getShouldUpgradeMitosheet(), ref: (Mito) => {
                // The first time we render the item, register the Mito instance
                if (window.mitoMap === undefined) {
                    window.mitoMap = new Map();
                }
                window.mitoMap.set(model_id, Mito);
                // We also register the API for this Mito instance
                if (window.mitoAPIMap === undefined) {
                    window.mitoAPIMap = new Map();
                }
                window.mitoAPIMap.set(model_id, mitoAPI);
            }, stepDataList: this.getStepDataList() }), this.el);
        this.model.on('msg:custom', this.handleMessage, this);
        /*
        The first render of a widget happens when the mitosheet.sheet call is
        run. It does not occur when the page that this widget on is refreshed.
        
        We only need to send update events for df_names and reading an existing analysis
        in the case that this is the first render, and not when the page is refreshed.

        NOTE: Rerunning a mitosheet.sheet call that has an analysis in the cell
        below is _creating a new mitosheet_. Thus, this.getHasRendered() will
        return false in this case.
    */
        if (!this.getHasRendered()) {
            // Get df name from code block, and pass it to both the frontend and the backend
            (_a = window.commands) === null || _a === void 0 ? void 0 : _a.execute('get-df-names').then((dfNames) => {
                // If there are dataframe names, send them to the backend
                if (dfNames.length > 0) {
                    this.send({
                        'event': 'update_event',
                        'type': 'df_names_update',
                        'df_names': dfNames
                    });
                }
            });
            // Get any previous analysis and send it back to the model!
            (_b = window.commands) === null || _b === void 0 ? void 0 : _b.execute('read-existing-analysis').then(async (analysisName) => {
                // If there is no previous analysis, we just ignore this step
                if (!analysisName)
                    return;
                // We log that we read from below
                await mitoAPI.sendLogMessage('read_analysis_from_cell_below', {
                    analysis_name: analysisName
                });
                // And send it to the backend (we don't care when it terminates)
                await mitoAPI.sendUseExistingAnalysisUpdateMessage(analysisName, undefined, 
                /*
                    When we read in an analysis name from a cell, we replay this analysis
                    while also overwriting _everything_ that is already in the analysis.

                    This is to avoid issues w/ passing in a saved analysis to the mitosheet.sheet
                    call, where then rerunning the cell with this call w/ doubly-apply things.
                */
                true);
            });
        }
        // Let the backend know we have now rendered the sheet, and all future
        // renders therefor must be page refreshes, and so we let the backend 
        // know that we have rendered
        this.send({
            'event': 'update_event',
            'type': 'has_rendered_update'
        });
    }
    getHasRendered() {
        return this.model.get('has_rendered');
    }
    getSheetJSONArray() {
        const sheetJSONArray = [];
        try {
            const modelSheetJSONArray = JSON.parse(this.model.get('sheet_json'));
            sheetJSONArray.push(...modelSheetJSONArray);
        }
        catch (e) {
            // Suppress error
            console.error(e);
        }
        return sheetJSONArray;
    }
    getIsLocalDeployment() {
        return this.model.get('is_local_deployment');
    }
    getSheetShapeArray() {
        const sheetShapeArray = [];
        try {
            const sheetShapeJSONArrayUnparsed = JSON.parse(this.model.get('df_shape_json'));
            sheetShapeArray.push(...sheetShapeJSONArrayUnparsed);
        }
        catch (e) {
            // Suppress error
            console.error(e);
        }
        return sheetShapeArray;
    }
    getColumnTypeJSONArray() {
        const columnTypeJSONArray = [];
        try {
            const modelColumnTypeJSONArray = JSON.parse(this.model.get('column_type_json'));
            columnTypeJSONArray.push(...modelColumnTypeJSONArray);
        }
        catch (e) {
            // Suppress error
            console.error(e);
        }
        return columnTypeJSONArray;
    }
    getSavedAnalysisNames() {
        const savedAnalysisNames = [];
        try {
            const savedAnalysisNamesJSON = JSON.parse(this.model.get('saved_analysis_names_json'));
            savedAnalysisNames.push(...savedAnalysisNamesJSON);
        }
        catch (e) {
            // Suppress error
            console.error(e);
        }
        return savedAnalysisNames;
    }
    getCurrStepIdx() {
        return this.model.get('curr_step_idx');
    }
    getStepDataList() {
        const stepDataList = [];
        try {
            const savedStepDataList = JSON.parse(this.model.get('step_data_list_json'));
            stepDataList.push(...savedStepDataList);
        }
        catch (e) {
            // Suppress error
            console.error(e);
        }
        return stepDataList;
    }
    getColumnSpreadsheetCodeJSONArray() {
        return JSON.parse(this.model.get('column_spreadsheet_code_json'));
    }
    getDfNames() {
        const dfNames = [];
        const unparsedDfNames = this.model.get('df_names_json');
        try {
            dfNames.push(...JSON.parse(unparsedDfNames)['df_names']);
            // And then we extend it to the length of the number of sheets,
            // as the dfNames sometimes aren't pulled correctly!
            const modelSheetJSONArray = this.getSheetJSONArray();
            for (let i = dfNames.length; i < modelSheetJSONArray.length; i++) {
                dfNames.push(`df${i + 1}`);
            }
        }
        catch (e) {
            // Suppress error
            console.error(e);
        }
        return dfNames;
    }
    getCodeJSON() {
        const codeJSON = {
            imports: '# No imports',
            code: ['# No code has been written yet!', 'pass']
        };
        const unparsedCodeJSON = this.model.get('code_json');
        try {
            codeJSON['imports'] = JSON.parse(unparsedCodeJSON)['imports'];
            codeJSON['code'] = JSON.parse(unparsedCodeJSON)['code'];
        }
        catch (e) {
            // Suppress error
            console.error(e);
        }
        return codeJSON;
    }
    getAnalysisName() {
        return this.model.get('analysis_name');
    }
    getColumnFilters() {
        return JSON.parse(this.model.get('column_filters_json'));
    }
    getTutorialMode() {
        return this.model.get('tutorial_mode');
    }
    getUserEmail() {
        return this.model.get('user_email');
    }
    getShouldUpgradeMitosheet() {
        return this.model.get('should_upgrade_mitosheet');
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any, @typescript-eslint/explicit-module-boundary-types
    handleMessage(message) {
        /*
          This route handles the messages sent from the Python widget
        */
        var _a, _b, _c;
        const model_id = this.model.model_id;
        const mito = (_a = window.mitoMap) === null || _a === void 0 ? void 0 : _a.get(model_id);
        if (mito === undefined) {
            console.error("Error: a message was received for a mito instance that does not exist!");
            return;
        }
        console.log("Got a message, ", message);
        if (message.event === 'update_sheet') {
            console.log("Updating sheet.");
            mito.setState(() => {
                return {
                    sheetJSONArray: this.getSheetJSONArray(),
                    columnSpreadsheetCodeJSONArray: this.getColumnSpreadsheetCodeJSONArray(),
                    dfNames: this.getDfNames(),
                    sheetShapeArray: this.getSheetShapeArray(),
                    savedAnalysisNames: this.getSavedAnalysisNames(),
                    columnFiltersArray: this.getColumnFilters(),
                    columnTypeJSONArray: this.getColumnTypeJSONArray(),
                    loading: false,
                    tutorialMode: this.getTutorialMode(),
                    stepDataList: this.getStepDataList(),
                    currStepIdx: this.getCurrStepIdx()
                };
            }, () => {
                // then recalculate the header height to make sure all headers are visible
                (0,_utils_gridStyling__WEBPACK_IMPORTED_MODULE_5__.calculateAndSetHeaderHeight)(model_id);
            });
        }
        else if (message.event === 'update_code') {
            console.log('Updating code.');
            (_b = window.commands) === null || _b === void 0 ? void 0 : _b.execute('write-code-to-cell', {
                analysisName: this.getAnalysisName(),
                codeJSON: this.getCodeJSON()
            });
            mito.setState({
                loading: false
            });
        }
        else if (message.event === 'edit_error') {
            console.log("Updating edit error.");
            mito.setState({
                modalInfo: { type: _components_Mito__WEBPACK_IMPORTED_MODULE_4__.ModalEnum.Error },
                errorJSON: message,
                loading: false
            });
        }
        else if (message.event === 'api_response') {
            // We get the MitoAPI associated with this Mito instance, and add to it's unconsumed queue
            const mitoAPI = (_c = window.mitoAPIMap) === null || _c === void 0 ? void 0 : _c.get(model_id);
            mitoAPI === null || mitoAPI === void 0 ? void 0 : mitoAPI.receiveResponse(message);
        }
    }
}


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/all-modals.css":
/*!******************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/all-modals.css ***!
  \******************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "\n/* For labeling selection boxes, etc */\n.modal-element-label {\n    text-align: left;\n    margin-bottom: 2px;\n}\n\n/* For any error in the modal (e.g. the user input an invalid value) */\n.modal-error {\n    text-align: left;\n    color: red\n}\n\n/* When adding a value to a list, make the add text this */\n.modal-add {\n    text-align: left;\n    color: #0081DE;\n}\n\n/* Style any input box in a modal with this */\n.modal-input {\n    width: 100%;\n    height: 30px;\n    background-color: #ebebeb;\n    font-size: 12px;\n    color: #343434;\n\n    border-color: #343434;\n    border-style: solid;\n    border-width: 1px;\n    border-radius: 2px;\n\n    box-sizing: border-box;\n    padding-left: 5px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/column-graph-and-describe.css":
/*!*********************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/column-graph-and-describe.css ***!
  \*********************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".column-describe-table-container {\n    display: flex;\n    flex-direction: column;\n    border: 1px black solid;\n    border-radius: 3px;\n\n    margin: 10px;\n    padding: 5px 20px;\n}\n\n.column-describe-table-row {\n    display: flex;\n    flex-direction: row;\n    justify-content: space-between;\n    padding: 5px;\n}\n\n.column-describe-chart-row:not(:last-of-type) {\n    border-bottom: 1px gray solid;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/column-header-modal.css":
/*!***************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/column-header-modal.css ***!
  \***************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".column-header-error {\n    color: #ED4747;\n    text-align: left;\n    margin-top: 5px;\n}\n\n.column-header-input {\n    padding-left: 5px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/column-header.css":
/*!*********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/column-header.css ***!
  \*********************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "\n/* \n    we add the overflow: hidden property to the AgGrid header cell to ensure that\n    the column header does not overflow into the next cell. We have to add it here\n    because it was not working properly when just adding it to the .column-header-cell\n*/\n.ag-header-cell {\n    overflow: hidden;\n}\n\n/* \n    Make the ag-grid column header react attribute larger because it is the parent of \n    the column-header-cell, which we want to be large so that the user can easily\n    click on the column header cell to select it. \n*/\n.ag-react-container {\n    width: 100% !important;\n    height: 100% !important;\n}\n\n.column-header-cell {\n    display: flex;\n    flex-flow: row; /* make space for the header and the filter icon */\n    justify-content: space-between;\n    align-items: center; /* make the header text and filter be aligned vertically */ \n    width: 100%; /* make the column header large so its easily clickable */\n    height: 100%; /* make the column header large so its easily clickable */\n}\n\n.column-header-header-container {\n    white-space: normal; /* suggest to use by ag-grid if we are wrapping text */ \n    word-break: break-all;\n    margin-top: 5px;\n    margin-bottom: 5px;\n}\n\n.column-header-column-header {\n    display: inline-flex;\n    flex-flow: row wrap; /* wrap the column header to make the word spans wrap to a new line*/\n}\n\n.column-header-column-header:hover {\n    text-decoration: underline;\n}\n \n", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/column-name-card.css":
/*!************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/column-name-card.css ***!
  \************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".column-name-card-container {\n    display: inline-block;\n    margin-bottom: 10px;\n    margin-top: 2px;\n    width: 100%;\n}\n\n.column-name-card-column-name-div {\n    display: inline-flex;\n    flex-direction: column;\n    justify-content: space-between;\n    align-items: baseline;\n    width: 85%;\n}\n\n.column-name-card-input-text {\n    font-size: 14px;\n    line-height: 14px;\n    width: 85%\n}\n\n.column-name-card-column-header {\n    font-size: 20px;\n    width: 100%;\n    white-space: nowrap;\n    overflow: hidden;\n    text-overflow: ellipsis; /* add ... for cut off text */\n}\n\n.column-name-card-column-header:hover {\n    text-decoration: underline;\n}\n", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/control-panel-taskpane.css":
/*!******************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/control-panel-taskpane.css ***!
  \******************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".control-panel-taskpane-container {\n    overflow-y: hidden;\n    height: 100%;\n\n    border: 1px solid #9e9e9e;\n    box-sizing: border-box;\n\n    color: #343434;\n    background: white;\n}\n\n.control-panel-taskpane-tab-container {\n    /* \n        We put the tabs at the bottom of the taskpane container,\n        which they are the child of. This way, they are always visible\n    */\n    position: absolute;\n    bottom: 30px;\n\n    display: flex;\n    justify-content: space-around;\n\n    width: inherit;\n}\n\n.control-panel-taskpane-tab {\n    width: 100%;\n    border: 1px #343434 solid;\n    background: white;\n    text-align: center;\n    padding: 4px;\n}\n\n/* When selected, white. when not selected, this color. */\n.control-panel-taskpane-tab.selected {\n    background: #FFFFFF;\n    border-bottom: 3px solid #0081DE;\n}\n\n/* When selected, white. when not selected, this color. */\n.control-panel-taskpane-tab.unselected {\n    background: #FFFFFF;\n}\n\n.sort-buttons-div {\n    display: flex;\n    flex-direction: row wrap;\n    justify-content: space-evenly;\n}\n\n.sort-button {\n    padding-top: 1vh;\n    padding-bottom: 1vh;\n    padding-left: 2vw;\n    padding-right: 2vw;\n\n    font-size: 12px;\n    background-color: #F8F8F8;\n    border-radius: 3px;\n\n    border-style: solid; /* get rid of shadow around button*/\n}\n\n.sort-button-selected{\n    color: #0081DE;\n    border-color: #0081DE;\n}\n\n.sort-button-unselected {\n    color: #929292;\n    border-color: #DDDDDD;\n}\n\n.filter-modal-section-spacer {\n    margin-top: 15px;\n}\n\n.filter-modal-section-title {\n    display: flex;\n    flex-direction: row;\n    justify-content: space-between;\n\n    font-size: 14px;\n    font-weight: bold;\n    color: #343434;\n    text-align: left;\n    margin-bottom: 5px;\n}\n\n.filter-modal-centering-container {\n    text-align: center;\n    align-items: center;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/custom-dropdown.css":
/*!***********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/custom-dropdown.css ***!
  \***********************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "\n\n.custom-dropdown {\n    z-index: 3;\n    position: absolute;\n\n    /* \n        We manually position this popup currently, which we will need\n        to change when we use this popup in places other than just\n        the step list view. We will make these parameters to style\n        on the component!\n    */\n    right: 0px;\n    top: 27px;\n\n    padding: 10px;\n\n    background: white;\n    border-radius: 1px;\n\n    text-align: left;\n\n    box-shadow: 0 0px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);\n}\n\n.custom-dropdown > div:not(:first-child) {\n    margin-top: 10px;\n}\n\n.custom-dropdown > div:hover {\n    text-decoration: underline;\n}\n\n.custom-dropdown-inactive {\n    color: grey;\n}\n", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/default-modal.css":
/*!*********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/default-modal.css ***!
  \*********************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".modal-container {\n    /* Render above other divs */\n    z-index: 2;\n    position: absolute;\n\n    width: 100%;\n    align-items: center;\n    text-align: center;\n\n    margin-top: 60px;\n\n    color: #343434;\n}\n\n.modal {\n    background-color: white;\n\n    /* Place the modal*/\n    width: 40%;\n    margin: auto; /* Center it */\n\n    /* center the elements in the modal */\n    display: flex;\n    flex-direction: column;\n    justify-content: center;\n    align-items: center;\n\n\n    /* Style it! */\n    box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);\n    border-color: #343434;\n    border-style: solid;\n    border-width: 2px;\n    border-radius: 7px;\n}\n\n.modal-header-text-div {\n    text-align: center;\n\n    font-weight: bold;\n    font-size: 18px;\n\n    width: 100%;\n    margin-top: 25px;\n\n}\n\n.modal-message {\n    color: rgba(52, 52, 52, 0.56);\n    font-size: 14px;\n    width: 80%;\n    margin-top: 15px;\n\n    text-align: center;\n}\n\n.modal-buttons {\n    display: flex;\n    flex-direction: row;\n    justify-content: space-around;\n\n    /* center the button text on the same horizontal axis */\n    align-items: baseline;\n    font-size: 15px;\n\n    margin-top: 15px;\n    margin-bottom: 15px;\n}\n\n/* \n    the below css modifier is not called from the \n    default modal, but are instead applied on the buttons\n    fragment passed into the modal\n*/\n.modal-close-button {\n    color: #0081DE;\n    border: none;\n}\n\n/* \n    the below css modifier is not called from the \n    default modal, but are instead applied on the buttons\n    fragment passed into the modal\n*/\n/* underline the close button when hovered over */\n.modal-close-button:hover {\n    text-decoration: underline;\n}\n\n/* \n    the below css modifier is not called from the \n    default modal, but are instead applied on the buttons\n    fragment passed into the modal\n*/\n.modal-action-button {\n    background-color: #0081DE;\n    border: none;\n    color: #FFFFFF;\n\n    padding-top: 1vh;\n    padding-bottom: 1vh;\n    padding-left: 2vw;\n    padding-right: 2vw;\n\n    border-radius: 3px;\n}\n\n/* \n    the below css modifier is not called from the \n    default modal, but are instead applied on the buttons\n    fragment passed into the modal\n\n    this class should be applied when there are two buttons\n    in the modal. It should be applied to the left button\n    to space it from the right button. \n*/\n.modal-dual-button-left {\n    margin-right: 2vw;\n}\n\n/* \n    the below css modifier is not called from the \n    default modal, but are instead applied on the buttons\n    fragment passed into the modal\n\n    this class should be applied when there are two buttons\n    in the modal. It should be applied to the right button to\n    space it from the left button. \n*/\n.modal-dual-button-right {\n    margin-left: 2vw;\n}\n\n/* \n    the below css modifier is used when the button in the \n    default modal is not clickable by the user\n*/\n.modal-button-disabled {\n    background-color: #979797 !important;\n    color: #343434 !important;\n    border-color: #343434 !important;\n}\n\n.modal-input {\n    width: 100%;\n    height: 30px;\n    background-color: #ebebeb;\n    font-size: 12px;\n    color: #343434;\n\n    border-color: #d5c8c8;\n    border-style: solid;\n    border-width: 1px;\n    border-radius: 2px;\n\n    box-sizing: border-box;\n    padding-left: 5px;\n}\n\n.modal-input-label {\n    text-align: left;\n\n    font-weight: bold;\n    font-size: 14px;\n\n    width: 100%;\n\n    color: #343434;\n\n    margin-bottom: 3px;\n}\n\n.modal-loading-text {\n    color: #0081DE;\n}\n\n.modal-loading-dots {\n    color: #0081DE;\n    font-size: 24px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/default-taskpane.css":
/*!************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/default-taskpane.css ***!
  \************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".default-taskpane-div {\n    height: 100%;\n    width: 100%;\n    display: flex;\n    flex-direction: column;\n\n    /* add standard spacing around the entire taskpane */\n    padding-left: 10px;\n    padding-right: 10px;\n    padding-top: 5px;\n    padding-bottom: 5px;\n\n    /* set standard taskpane color */ \n    color: #343434;\n    /* We have to set the background, as the taskpane turns black on fullscreen for some reason */\n    background-color: white;\n\n    /* stylize border of box */ \n    border: 1px solid #9e9e9e;\n    box-sizing: border-box;\n}\n\n.default-taskpane-header-div {\n    width: 100%;\n    height: 25px;\n    display: flex;\n    flex-direction: row;\n    justify-content: space-between;\n}\n\n.default-taskpane-header-text {\n    font-size: 20px;\n    width: 100%;\n}\n\n.default-taskpane-body-div {\n    display: flex;\n    flex-direction: column;\n\n    height: 100%;\n    overflow-y: scroll;\n\n    margin-top: 15px;\n}\n\n.default-taskpane-body-section-div {\n    margin-top: 10px;\n}\n\n.default-taskpane-body-section-title-text {\n    font-size: 16px;\n}\n\n", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/delete-column-modal.css":
/*!***************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/delete-column-modal.css ***!
  \***************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "\n/* Place holder file in case we want to stile the delete\ncolumn modal, so we can avoid nasty webpack issues :) */", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/documentation-basic-example.css":
/*!***********************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/documentation-basic-example.css ***!
  \***********************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "\n\n.documentation-basic-example-title {\n    /* The title at the top of the page */\n    font-size: 20px;\n    text-decoration: underline;\n}\n\n.documentation-basic-example-section-title {\n    /* A title that defines a new section, and so wants some space! */\n    font-size: 20px;\n    margin-top: 10px;\n    text-decoration: underline;\n}\n\n.documentation-basic-example-python-code {\n    /* This makes a box for any Python code to include in the documentation */\n\n    border: 1.5px solid #0081DE;\n    border-radius: 5px;\n\n    margin-top: 5px;\n    padding: 5px;\n}\n\n.documentation-basic-example-python .tooltip {\n    /* the tooltip should default to hidden*/\n    visibility: hidden;\n    background-color: #343434;;\n    color: #fff;\n    text-align: center;\n    border-radius: 6px;\n    padding: 5px 0;\n  \n    font-size: 12px;\n  \n    width: 120px;\n    top: 10%;\n    margin-left: 75px; /* Center the item in the taskpane */\n  \n    /* Position the tooltip */\n    z-index: 1;\n  \n    transition: 0s visibility;\n}\n  \n.documentation-basic-example-python:hover .tooltip {\n    /* when the toolbar item is hovered over, display the tooltip*/\n    visibility: visible;\n    transition-delay:.3s;\n}\n\n.documentation-basic-example-instructions-list {\n    margin-top: 0;\n    padding-left: 0px;\n}\n\n.documentation-basic-example-instructions-list-element {\n    /* A list of instructions */\n    padding-top: 5px;\n    padding-bottom: 10px;\n    display: flex;\n    justify-content: space-between;\n}\n\n.documentation-basic-example-instructions-list-element-content {\n    /* Content in a list of instructions in documentation; usually a numbered step, \n    and some content */\n    padding-left: 5px;\n    display: flex;\n    flex-direction: column;\n}\n\n.documentation-basic-example-instructions-list-element-content-centered {\n    /* \n        In a list of instructions in documentation, this centers content\n        in the center of the documentation taskpane. \n\n        This maybe is too long for a name, lol\n     */\n    align-self: center;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/documentation-box.css":
/*!*************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/documentation-box.css ***!
  \*************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".documentation-box-container {\n    background-color: white;\n\n    display: flex;\n    flex-direction: column;\n    \n    padding-bottom: 10px;\n    width: 300px;\n    color: #343434;\n}\n\n.documentation-box-syntax {\n    background-color: #F1F1F1;\n\n    padding-top: 10px;\n    padding-right: 5px;\n    padding-left: 15px;\n}\n\n.documentation-box-description {\n    background-color: #F1F1F1;\n    font-size: 10px;\n    color: grey;\n\n    padding-top: 3px;\n    padding-right: 5px;\n    padding-left: 15px;\n    padding-bottom: 10px;\n}\n\n.documentation-box-example-header {\n    padding-right: 5px;\n    padding-left: 15px;\n    margin-top: 5px;\n    margin-bottom: 5px;\n}\n\n.documentation-box-example {\n    color: #0081DE;\n\n    padding-right: 5px;\n    padding-left: 15px;\n    margin-bottom: 5px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/documentation-taskpane.css":
/*!******************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/documentation-taskpane.css ***!
  \******************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".documentation-taskpane-header-back {\n    display: flex;\n    flex-direction: column;\n    justify-content: space-around;\n    margin-left: 10px;\n    margin-right: 10px;\n}\n\n.documentation-taskpane-header-back-and-title {\n    /* This container holds the back and title buttons, when there is a back button! */\n    display: flex;\n}\n\n.documentation-taskpane-header-close {\n    font-size: 20px;\n    margin-top: 5px;\n    margin-right: 5px;\n}\n\n.documentation-taskpane-content-function-list-title {\n    font-size: 20px;\n    text-decoration: underline;\n}\n\n.documentation-taskpane-content-function-list-section-title {\n    font-size: 20px;\n    margin-top: 10px;\n    text-decoration: underline;\n}\n\n.documentation-taskpane-content-function-list {\n    margin-top: 0;\n    list-style: none;\n    padding-left: 0px;\n}\n\n.documentation-taskpane-content-function-list-element {\n    font-size: 14px;\n    display: flex;\n    margin-top: 10px;\n}\n\n.documentation-taskpane-content-function-list-icon {\n    margin-right: 10px\n}\n\n/* So the user knows functions are  clickable! */\n.documentation-taskpane-content-function-list-element:hover {\n    text-decoration: underline;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/filter-card.css":
/*!*******************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/filter-card.css ***!
  \*******************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".filter-object {\n    width: 100%;\n    display: flex;\n    flex-direction: row;\n    justify-content: space-between;\n    flex-wrap: nowrap;\n    text-align: center;\n\n    margin-bottom: 10px;\n}\n\n/* Set the the left margin for every item except the first */\n.filter-object .filter-object-item + .filter-object-item {\n    margin-left: 15px;\n}\n\n.filter-where-label {\n    width: 50px;\n    min-width: 50px; /* Set the min-width because the text is less than 50px wide*/\n    /* Should be the same width as filter-select */\n    text-align: center; \n    color: #343434;\n    flex-grow: 0;\n}\n\n.filter-select {\n    color: #343434;\n\n    background: #F8F8F8;\n    border: 0.5px solid #343434;\n    box-sizing: border-box;\n    border-radius: 3px;\n    \n    width: 50px;\n    height: 25px; \n}\n\n/* Set the style of the select dropdown */ \n.filter-select option {\n    background-color:#F8F8F8;\n    color: #343434;\n}\n\n.filter-operator {\n    flex-grow: 0;\n}\n\n.filter-condition {\n    flex-grow: 2;\n}\n\n.filter-value {\n    flex-grow: 3;\n}\n\n/* Make the filter close button div a flex box to vertically center*/\n.filter-close-button {\n    display: flex;\n    flex-direction: column;\n    justify-content: center\n}\n\n.filter-card-buttons-container {\n    width: 100%;\n    text-align: left;\n}\n\n.filter-group {\n    width: 100%;\n\n    background: #F8F8F8;\n    border: 0.5px solid #343434;\n    box-sizing: border-box;\n    border-radius: 3px;\n\n    padding: 10px 5px;\n\n    /* Add a margin to the between the filter group and the next item*/\n    margin-bottom: 10px; \n}\n\n.filter-modal-centering-container > .filter-object > .filter-close-button {\n    /* \n        Only add margin-right to non-FilterGroups to get the X's to line up.\n        The margin-right should be the same as the filter-group padding-right\n    */\n    margin-right: 5px;\n}\n\n.filter-group-and-operator-div {\n    width: 100%;\n    display: flex;\n    flex-direction: row;\n    flex-wrap: nowrap;\n}\n\n.filter-add-filter-button {\n    /* Center the text inside the button */\n    display: flex;\n    flex-direction: column;\n    justify-content: space-around;\n\n    /* Stylize the button */\n    background: #F8F8F8;\n    border: 0.5px solid #343434;\n    box-sizing: border-box;\n    border-radius: 3px;\n\n    /* Stylize the text */\n    color: #0081DE;\n    font-size: 14px;\n    text-align: left;\n    padding-left: 5px;\n\n    /* Set dimensions */\n    width: 110px;\n    height: 20px;\n}\n\n.filter-add-filter-button > option {\n    color: #343434;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/formula-bar.css":
/*!*******************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/formula-bar.css ***!
  \*******************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".formula-bar-container {\n    height: 30px;\n    width: 100%;\n    background-color: #ebebeb;\n\n    font-family: Georgia;\n}\n\n.formula-bar {\n    display: flex;\n    flex-direction: row;\n    justify-content: left;\n    text-align: center;\n    align-content: center;\n}\n\n.fx-text {\n    font-size: 16px;\n    margin-left: 10px;\n}\n\n.formula-bar-input {\n    font-size: 16px;\n    text-align: left;\n\n    /* make input blend in with formula bar */\n    background-color: #ebebeb;\n    border-radius: 0;\n    border-style: none;\n    outline: none;\n}\n", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/function-documentation.css":
/*!******************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/function-documentation.css ***!
  \******************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "\n.function-documentation-function-name {\n    margin-top: 1px;\n    margin-bottom: 1px;\n}\n\n.function-documentation-example-list {\n    margin-top: 0;\n    list-style: none;\n    padding-left: 0;\n}\n\n.function-documentation-example {\n    margin-top: 2px;\n    margin-bottom: 2px;\n}\n\n.blue-text {\n    color: #0081DE;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/import-modal.css":
/*!********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/import-modal.css ***!
  \********************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "\n\n.raw-python-textarea {\n    width: 100%;\n    /* Don't let users expand to big and get stuck */\n    resize: vertical;\n    max-height: 150px;\n}\n\n.import-files-select {\n    display: flex;\n    flex-direction: column;\n}\n\n/* Make the select children center themselves */\n.import-files-select > select {\n    margin: auto;\n    margin-bottom: 10px;\n}\n\n.import-files-old-and-new-container {\n    display: flex;\n    flex-direction: row;\n}\n\n.previous-file-name-labels-container {\n    display: flex;\n    flex-direction: column;\n    margin-right: 10px;\n    width: 50%;\n}\n\n.previous-file-name-label {\n    font-size: 14px;\n    line-height: 20px;\n    color: #343434;\n\n    white-space: nowrap;\n    overflow: hidden;\n    text-overflow: ellipsis; /* add ... for cut off text */\n\n    margin-bottom: 15px;\n    margin-top: 5px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/large-select.css":
/*!********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/large-select.css ***!
  \********************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".select {\n    background-color: #F8F8F8;\n    border: 0.5px solid #343434;\n    box-sizing: border-box;\n    border-radius: 3px;\n    height: 30px;\n}\n\n.large-select {\n    width: 130px;\n}\n\n.extra-large-select {\n    width: 100%;\n}\n\n/* set the style of the select dropdown itself */ \n.large-select option {\n    background-color:#F8F8F8;\n}\n\n/* change font size of options text*/\noptgroup { \n    font-size:14px; \n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/loading-indicator.css":
/*!*************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/loading-indicator.css ***!
  \*************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "\n\n.loading-indicator-container {\n    /* Render above other divs */\n    z-index: 2;\n    position: absolute;\n\n    /* Make it a sidebar on the right side */\n    width: 100px;\n    background-color: white;\n    border-radius: 2px;\n    border: 1px solid black;\n\n    /* Add a drop shadow */\n    box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);\n\n    /* Place it right inside the upper left corner of the sheet */\n    margin-top: 85px;\n    margin-left: 5px;\n}\n\n.loading-indicator-text {\n    /* We have a margin, rather than a center, as the ...'s change the size of the text */\n    margin-left: 20px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/margins.css":
/*!***************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/margins.css ***!
  \***************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "/* Margin css tags to be used across project */\n\n.mt-0 {\n    margin-top: 0vh;\n}\n\n.mt-p5 {\n    margin-top: .5vh;\n}\n\n.mt-1 {\n    margin-top: 1vh;\n}\n\n.mt-2 {\n    margin-top: 2vh;\n}\n\n.mt-4 {\n    margin-top: 4vh;\n}\n\n.mt-6 {\n    margin-top: 6vh;\n}\n\n.mt-10 {\n    margin-top: 10vh;\n}\n\n.mb-0 {\n    margin-bottom: 0vh;\n}\n\n.mb-p5 {\n    margin-bottom: .5vh;\n}\n\n.mb-1 {\n    margin-bottom: 1vh;\n}\n\n.mb-2 {\n    margin-bottom: 2vh;\n}\n\n.mb-4 {\n    margin-bottom: 4vh;\n}\n\n.mb-5 {\n    margin-bottom: 5vh;\n}\n\n.mb-6 {\n    margin-bottom: 6vh;\n}\n\n.mb-10 {\n    margin-bottom: 10vh;\n}\n\n.mb-25px {\n    margin-bottom: 25px;\n}\n\n.ml-0 {\n    margin-left: 0vw;\n}\n\n.ml-p5 {\n    margin-left: .5vw;\n}\n\n.ml-1 {\n    margin-left: 1vw;\n}\n\n.ml-2 {\n    margin-left: 2vw;\n}\n\n.ml-4 {\n    margin-left: 4vw;\n}\n\n.ml-6 {\n    margin-left: 6vw;\n}\n\n.ml-10 {\n    margin-left: 10vw;\n}\n\n.mr-0 {\n    margin-right: 0vw;\n}\n\n.mr-p5 {\n    margin-right: .5vw;\n}\n\n.mr-1 {\n    margin-right: 1vw;\n}\n\n.mr-2 {\n    margin-right: 2vw;\n}\n\n.mr-3 {\n    margin-right: 3vw;\n}\n\n.mr-4 {\n    margin-right: 4vw;\n}\n\n.mr-6 {\n    margin-right: 6vw;\n}\n\n.mr-10 {\n    margin-right: 10vw;\n}\n\n.ma-0 {\n    margin-left: 0vw;\n    margin-right: 0vw;\n    margin-top: 0vw;\n    margin-bottom: 0vw;\n}\n\n.ma-p5 {\n    margin-left: .5vw;\n    margin-right: .5vw;\n    margin-top: .5vw;\n    margin-bottom: .5vw;\n}\n\n.ma-1 {\n    margin-left: 1vw;\n    margin-right: 1vw;\n    margin-top: 1vw;\n    margin-bottom: 1vw;\n}\n\n.ma-2 {\n    margin-left: 2vw;\n    margin-right: 2vw;\n    margin-top: 2vw;\n    margin-bottom: 2vw;\n}\n\n.ma-4 {\n    margin-left: 4vw;\n    margin-right: 4vw;\n    margin-top: 4vw;\n    margin-bottom: 4vw;\n}\n\n.ma-6 {\n    margin-left: 6vw;\n    margin-right: 6vw;\n    margin-top: 6vw;\n    margin-bottom: 6vw;\n}\n\n.ma-10 {\n    margin-left: 10vw;\n    margin-right: 10vw;\n    margin-top: 10vw;\n    margin-bottom: 10vw;\n}\n\n.mr-10px {\n    margin-right: 10px;\n}\n\n.mr-20px {\n    margin-right: 20px;\n}\n\n.mr-30px {\n    margin-right: 30px;\n}\n\n.mb-25px {\n    margin-bottom: 25px;\n}\n\n.mt-25px {\n    margin-top: 25px;\n}\n\n.mb-30px {\n    margin-bottom: 30px;\n}\n\n\n\n", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/merge-sheet-and-key-selection.css":
/*!*************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/merge-sheet-and-key-selection.css ***!
  \*************************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "/* Contains CSS stylings for the MergeSheetAndKey component */\n\n.merge-sheet-and-key {\n    display: flex;\n    justify-content: space-between;\n\n    margin-bottom: 5px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/mito-toolbar.css":
/*!********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/mito-toolbar.css ***!
  \********************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".mito-toolbar-container {\n  width: 100%;\n  height: 50px;\n\n  background-color: #ebebeb;\n  padding-left: 10px;\n\n  /* We make the toolbar a flexbox, for the toolbar icons/actions */\n  display: flex;\n  flex-direction: row;\n  justify-content: space-between;\n\n  /* border-box to set the border inside the div, so it doesn't get chopped */\n  box-sizing: border-box; \n  -moz-box-sizing: border-box; /* Firefox */\n  -webkit-box-sizing: border-box; /* Older Webkit browsers */\n\n  /* Border the bottom */\n  border-bottom: 1px solid #999696;\n}\n\n.mito-toolbar-container-left {\n  /* The left starts from the start */\n  display: flex;\n  flex-direction: row;\n  justify-content: flex-start;\n}\n\n.mito-toolbar-container-right {\n  /* The right starts from the end */\n  display: flex;\n  flex-direction: row;\n  justify-content: flex-end;\n}\n  \n  .mito-toolbar-item {\n    /*keep items evenly spaced */\n    padding-right: 5px;\n\n    margin-top: 5px;\n    margin-bottom: 5px;\n\n    /* make input blend in with formula bar */\n    background-color: #ebebeb;\n    border-radius: 0;\n    border-style: none;\n    outline: none;\n  }\n\n  .mito-toolbar-item .tooltip {\n    /* the tooltip should default to hidden*/\n    visibility: hidden;\n    background-color: #343434;;\n    color: #fff;\n    text-align: center;\n    border-radius: 6px;\n    padding: 5px 0;\n\n    font-size: 12px;\n  \n    width: 120px;\n    top: 50px;\n    margin-left: -45px; /* Use half of the width (120/2 = 60) - half the width of the icon, to center the tooltip */\n\n    /* Position the tooltip */\n    position: absolute;\n    z-index: 1;\n\n    transition: 0s visibility;\n  }\n\n  .mito-toolbar-item:hover .tooltip {\n    /* when the toolbar item is hovered over, display the tooltip*/\n    visibility: visible;\n    transition-delay:.3s;\n  }\n\n  .mito-toolbar-talk-to-support-button {\n    border: 1px solid #343434;\n    box-sizing: border-box;\n    border-radius: 3px;\n\n    height: 25px;\n    text-align: center;\n\n    margin: auto;\n\n    margin-left: 10px;\n    margin-right: 10px;\n  }", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/mito.css":
/*!************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/mito.css ***!
  \************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "\n\n/* \n    We override the the overflow behavior on the jupyter-widgets class, which \n    seems to only be applied to the container of the widgets themselves (e.g.\n    which Mito is). \n    \n    Specifically, we want overflow to be hidden. This keeps the Mitosheet, and\n    all other things inside the box. \n\n    NOTE: do not change the name of this class. We didn't decide it, we inherited\n    it. \n\n    To see where this class is used by Jupyter, search for it in the HTML. It is in\n    the parent of the parent of the .mito-container div!\n*/\n.jupyter-widgets {\n    overflow: hidden !important;\n}\n\n.mito-container {\n    height: 515px;\n    display: flex;\n    flex-direction: column;\n}\n\n\n/*\n    When the container is fullscreen, we expand it so it fills the \n    entire view point. We do webkit as well, so it works on safari\n*/\n.mito-container:fullscreen .mito-container:-webkit-full-screen {\n    height: 100vh;\n    display: flex;\n    flex-direction: column;\n}\n\n/* Contains the Toolbar, Mito Sheet, and Taskpane*/ \n.mito-main-sheet-div {\n    height: 100%;\n    width: 100%;\n    display: flex;\n    flex-direction: row;\n    overflow: hidden;\n}\n\n/* \n    Contains the toolbar and Mito Sheet. This div should take up the entire width of \n    mito-main-sheet-div when the taskpane is closed and only 70% when the taskpane is opened. \n*/ \n.mito-formula-bar-and-mitosheet-div {\n    /* Note that this is the whole height, less the height of the sheet tabs */\n    height: calc(100% - 30px);\n    width: 100%;\n    transition: width 1s;\n}\n\n.mito-formula-bar-and-mitosheet-div-taskpane-open {\n    height: calc(100% - 30px);\n    width: 70%;\n}\n\n.mito-default-taskpane {\n    height: 100%;\n    width: 0%;\n    visibility: hidden;\n    transition-delay: visibility 10s;\n} \n\n.mito-default-taskpane-open {\n    visibility: visible;\n    width: 30%;\n}\n\n/* shade toolbar grey and set to the length of the mito sheet */\n.toolbar {\n    background-color: #C2C2C2;\n    width: 100%;\n}\n\n/* Note this only works with one div, p, etc. at a time. */\n.vertical-align-content {\n    display: flex;\n    flex-direction: column;\n    justify-content: center;\n}    \n\n.vertical-line {\n    border-left: 2px solid #999696;\n    height: 25px;\n    margin-left: 10px;\n    margin-right: 10px;\n}\n\n.sheet-bottom {\n    display: flex;\n    justify-content: space-between;\n    background-color: #ebebeb;\n    overflow-x: auto;\n    overflow-y: clip;\n    /* Stops the sheet tabs from wrapping text, and forces it to display in one line */\n    white-space: nowrap;\n\n    border-bottom: 1px solid #C2C2C2;\n    border-right: 1px solid #C2C2C2;\n    box-sizing: border-box;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/mitosheet.css":
/*!*****************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/mitosheet.css ***!
  \*****************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "/* css for MitoSheet */\n.mitosheet-ag-grid {\n    height: 100%;\n    width: 100%;\n}\n\n/* \n    Overwrite the default line height so that the text is centered\n    inside of the shorter cells\n*/ \n.ag-theme-alpine .ag-cell {\n    line-height: 23px; /* to center the text inside the cell with the 1 px margin around it */\n}\n\n/* \n    Overwrite the height of the cell editor set by .ag-theme-alpine .ag-cell-inline-editing\n*/\n.mito-cell-editor {\n    height: 25px !important;\n}\n\n/* \n    Overwrite the default background color that is set when by allowing the user to select multiple rows\n*/\n.ag-row-selected {\n    background-color:rgba(152, 205, 248, 0.3) !important\n}\n", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/mutli-toggle-box.css":
/*!************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/mutli-toggle-box.css ***!
  \************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "\n/* Contains CSS for the MultiToggleBox element */\n\n.multi-toggle-box {\n    /* These in pair make it so less than the max height will just take up the space it needs, and anything larger scrolls */\n    max-height: 80px;\n    overflow: auto;\n\n    border: 0.5px solid #343434;\n    box-sizing: border-box;\n    border-radius: 3px;\n    background-color: #F8F8F8;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/pivot-table-column-header-card.css":
/*!**************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/pivot-table-column-header-card.css ***!
  \**************************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "/* \n    Contains the css for the column header cards which display an \n    individual Column Header that is used as a key in the row or column \n    section of the pivot table\n*/\n\n.pivot-table-column-header-card-div {\n    height: 30px;\n    align-items: center;\n\n    display: flex;\n    flex-direction: row;\n    justify-content: space-between;\n    \n    border: 0.5px solid #343434;\n    box-sizing: border-box;\n    border-radius: 3px;\n\n    background-color: #F8F8F8;\n\n    margin-top: 5px;\n}\n\n.pivot-table-column-header-card-div-text {\n    font-size: 14px;\n    margin-left: 5px;\n    overflow: hidden;\n    text-overflow: ellipsis; /* add ... for cut off text */\n}\n\n.pivot-table-column-header-card-exit-div {\n    margin-right: 15px;\n}\n\n", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/pivot-table-key-selection.css":
/*!*********************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/pivot-table-key-selection.css ***!
  \*********************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "/* placeholder for pivot-table-key-selection css */ ", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/pivot-table-value-aggregation-card.css":
/*!******************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/pivot-table-value-aggregation-card.css ***!
  \******************************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "/* \n    Contains the css for the value aggregations cards which display the\n    aggregation method and column header of each value of the pivot table\n*/\n\n.pivot-table-value-aggregation-card-aggregation-info-div {\n    height: 30px;\n    align-items: center;\n\n    display: flex;\n    flex-direction: row;\n    justify-content: left;\n    width: 80%;\n}\n\n.pivot-table-value-aggregation-card-div-text {\n    font-size: 14px;\n    margin-left: 5px;\n    width: 80%;\n    white-space: nowrap; /* don't let the text wrap */\n    overflow: hidden;\n    text-overflow: ellipsis; /* add ... for cut off text */\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/pivot-taskpane.css":
/*!**********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/pivot-taskpane.css ***!
  \**********************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".pivot-taskpane-section-header-div {\n    display: flex;\n    flex-direction: row;\n    justify-content: space-between;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/replay-analysis-taskpane.css":
/*!********************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/replay-analysis-taskpane.css ***!
  \********************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ":root {\n    --replay-analysis-saved-analyses-container-height: 40%;\n}\n\n.saved-analyses-container {\n    display: flex;\n    flex-direction: column;\n\n    height: var(--replay-analysis-saved-analyses-container-height);\n    overflow-y: scroll;\n}\n\n.saved-analysis-divider-line-container {\n    width: 100%;\n    align-items: center;\n}\n\n.saved-analysis-divider-line {\n    width: 90%;\n    background-color: #343434;\n    color: #343434;\n    border-radius: .1px;\n}\n\n.saved-analysis-selected-analysis-title {\n    color: #343434;\n    font-size: 16px;\n\n    overflow-x: scroll;\n}\n\n.saved-analysis-card {\n    /* \n        Position as relative, so that the popup popups up \n        in the correct place.\n    */\n    position: relative;\n\n    display: flex;\n    flex-direction: row;\n    justify-content: space-between;\n    text-align: center;\n\n    margin-bottom: 5px;\n\n    padding-right: 15px;\n    padding-left: 5px;\n    padding-top: 2px;\n    padding-bottom: 2px;\n}\n\n.saved-analysis-card:hover {\n    background-color: #e4e2e2\n}\n\n.saved-analysis-card-analysis-name {\n    /* Give the min-width of 70% to make it easy to click */ \n    min-width: 70%;\n    color: #343434;\n    font-size: 16px;\n    text-align: left;\n}\n\n.saved-analysis-card-dropdown-div {\n    display: flex;\n    flex-direction: column;\n    justify-content: space-around;\n}\n\n\n.replay-analysis-rename-error {\n    color: red;\n}\n\n/* \n    As a bit of technical debt, we also recreate and restyle the step\n    components, as they are different in the standard step list\n*/\n.saved-analysis-taskpane-step-container {\n    display: flex;\n    flex-direction: column;\n\n    height: calc(95% - var(--replay-analysis-saved-analyses-container-height)); \n\n    position: relative;\n    width: 95%;\n\n    overflow-y: scroll;\n}\n\n/* \n    Stylizes the text displayed when no analysis description is displayed\n    or there are no saved analyses\n*/\n.saved-analysis-taskpane-empty-section-text-container {\n    display: flex;\n    flex-direction: column;\n    justify-content: space-around;\n\n    height: calc(95% - var(--replay-analysis-saved-analyses-container-height)); \n\n    text-align: center;\n    font-size: 12px;\n}\n\n.saved-analysis-taskpane-step {\n    display: flex;\n    flex-direction: row;\n    width: 100%;\n\n    margin-right: 5px;\n}\n\n.saved-analysis-taskpane-step-icon {\n    min-width: 30px;\n    margin-top: 6px;\n}\n\n.saved-analysis-step-text-div {\n    display: flex;\n    flex-direction: column;\n    justify-content: space-around;\n    height: 100%;\n\n    /* The subtext can get long, so we allow users to scroll the subtext in this case */\n    overflow-x: scroll;\n    white-space: nowrap;\n    padding-bottom: 10px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/save-analysis-modal.css":
/*!***************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/save-analysis-modal.css ***!
  \***************************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "\n.save-analysis-label {\n    margin-bottom: 2px;\n    text-align: left;\n}\n\n.save-analysis-analysis-selection-container {\n    margin-top: 5px;\n    margin-bottom: 15px;\n}\n\n.save-analysis-analysis-selection {\n    border: 1px solid #DDDDDD;\n    border-radius: 5px;\n    background-color: #F8F8F8;\n    height: 60px;\n    overflow: auto;\n    text-align: left;\n    width:  100%;\n}\n\n.save-analysis-analysis-name {\n    box-sizing: border-box;\n    padding-left: 5px;\n}\n\n.save-analysis-name-error {\n    color: #ED4747;\n    text-align: left;\n    margin-top: 5px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/sheet-tab.css":
/*!*****************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/sheet-tab.css ***!
  \*****************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "\n\n.sheet-tab-bar {\n    /* Deal with the overflow */\n    overflow-x: auto;\n    overflow-y: clip;\n    white-space: nowrap;\n}\n\n.sheet-shape {\n    padding: 5px;\n    color: grey;\n    border-left: 1px #C2C2C2 solid;\n\n    /* A bit of a hack to make the text centered */\n    line-height: 20px;\n}\n\n.tab {\n    /* set background color and border of sheet tab*/\n    background: #FDFDFD;\n    border: 1px solid #C2C2C2;\n    box-sizing: border-box;\n\n    height: 100%;\n    padding: 5px 10px 5px 10px;\n\n    display: inline-block;\n    text-align: center;\n    text-decoration: none;\n}\n\n.selected-tab {\n    border-bottom: 3px solid #0081DE;\n    box-sizing: border-box;\n}\n\n.tab-text {\n    display: flex;\n    justify-content: center;\n}\n\n.tab-sheet-name {\n    margin-right: 5px;\n}\n\n/* add a mito blue bar to the bottom of the selected sheet tab */\n.selected-tab-indicator {\n    border: 2px solid #0081DE;\n    background-color: #0081DE;\n}\n\n.sheet-tab-actions-dropdown {\n    z-index: 2;\n    position: absolute;\n    top: calc(100% - 125px);\n\n    background-color: white;\n    box-shadow: 0px 0px 4px #888;\n    border-radius: 3px;\n\n    text-align: left;\n\n    display: flex;\n    flex-direction: column;\n}\n\n.sheet-tab-action {\n    padding: 5px 10px 5px 10px;\n}\n\n.sheet-tab-action:first-child {\n    margin-top: 5px;\n}\n\n.sheet-tab-action:last-child {\n    margin-bottom: 5px;\n}\n\n.sheet-tab-action:hover {\n    background-color: #C2C2C2;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/small-select.css":
/*!********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/small-select.css ***!
  \********************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".small-select {\n    background-color: #F8F8F8;\n    border: 0.5px solid #343434;\n    box-sizing: border-box;\n    border-radius: 3px;\n\n    width: 60px;\n    height: 30px;\n}\n\n/* set the style of the select dropdown*/ \n.small-select option {\n    background-color:#F8F8F8;\n    color: #343434;\n}\n\n/* change font size of options text*/\noptgroup { \n    font-size:14px; \n}\n\n\n", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/step-taskpane.css":
/*!*********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/step-taskpane.css ***!
  \*********************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "\n\n.step-taskpane-step-container {\n    display: flex;\n    justify-content: space-between;\n\n    margin-right: 10px;\n\n    /* \n        We position the container so that the absolute positioning of the dropdown\n        correctly locks to this!\n    */\n    position: relative;\n    width: 100%;\n}\n\n.step-taskpane-step-container-left {\n    width: 80%;\n    display: flex;\n}\n\n.step-taskpane-step-container-right {\n    margin-top: 10px;\n}\n\n.step-taskpane-step-icon {\n    min-width: 30px;\n    margin-top: 6px;\n}\n\n.step-taskpane-missing-icon {\n    font-weight: bold;\n}\n\n.step-taskpane-step-text {\n    width: 100%;\n}\n\n.step-taskpane-step-header {\n    font-weight: bold;\n    font-size: 15px;\n}\n\n.step-taskpane-step-subtext {\n    /* The subtext can get long, so we allow users to scroll the subtext in this case */\n    overflow-x: scroll;\n    white-space: nowrap;\n    padding-bottom: 10px;\n    \n    color: grey;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/suggestion-box.css":
/*!**********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/suggestion-box.css ***!
  \**********************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".suggestion-box-container {\n    background-color: white;\n\n    display: flex;\n    flex-direction: column;\n    \n    width: 300px; /* Make sure that this is the same width as LAST_COLUMN_DEFAULT_WIDTH in gridStyling.tsx */ \n}\n\n.suggestion-box-selected-function {\n    background-color: #F1F1F1;\n\n    padding-top: 10px;\n    padding-right: 5px;\n    padding-left: 15px;\n}\n\n.suggestion-box-selected-description {\n    background-color: #F1F1F1;\n    font-size: 10px;\n    color: grey;\n\n    padding-top: 3px;\n    padding-right: 5px;\n    padding-left: 15px;\n    padding-bottom: 10px;\n}\n\n.suggestion-box-function {\n    padding-top: 10px;\n    padding-right: 5px;\n    padding-left: 15px;\n    padding-bottom: 5px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/taskpane-error.css":
/*!**********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/taskpane-error.css ***!
  \**********************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, ".taskpane-error-container {\n    display: flex;\n    flex-direction: row;\n    margin-top: 5px;\n    margin-bottom: 5px;\n}\n\n.taskpane-error-error-icon{\n    width: 25px;\n    height: 25px;\n}\n\n.taskpane-error-message {\n    color: #E84849;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/top-left-popup.css":
/*!**********************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/top-left-popup.css ***!
  \**********************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "\n.top-left-popup-container {\n    /* Render above other divs */\n    z-index: 2;\n    position: absolute;\n\n    /* Make it a sidebar on the right side */\n    width: 290px;\n    background-color: white;\n    border-radius: 2px;\n    border: 1px solid black;\n\n    /* Add a drop shadow */\n    box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2), 0 6px 20px 0 rgba(0, 0, 0, 0.19);\n\n    /* Place it right inside the upper left corner of the sheet */\n    margin-top: 85px;\n    margin-left: 5px;\n\n    padding: 5px;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./css/widths.css":
/*!**************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./css/widths.css ***!
  \**************************************************************/
/***/ ((module, exports, __webpack_require__) => {

// Imports
var ___CSS_LOADER_API_IMPORT___ = __webpack_require__(/*! ../node_modules/css-loader/dist/runtime/api.js */ "./node_modules/css-loader/dist/runtime/api.js");
exports = ___CSS_LOADER_API_IMPORT___(false);
// Module
exports.push([module.id, "/* Width css tags to be used across project \n   in the format: .w-{number} where number can be any multiple of 5 */\n\n\n.w-5 {\n    width: 5vw;\n}\n\n.w-8 {\n    width: 8vw;\n}\n\n.w-10 {\n    width: 10vw;\n}\n\n.w-15 {\n    width: 15vw;\n}\n\n.w-20 {\n    width: 20vw;\n}\n\n.w-25 {\n    width: 25vw;\n}\n\n.w-30 {\n    width: 30vw;\n}\n\n.w-35 {\n    width: 35vw;\n}\n\n.w-40 {\n    width: 40vw;\n}\n\n.w-45 {\n    width: 45vw;\n}\n\n.w-50 {\n    width: 50vw;\n}\n\n.w-55 {\n    width: 55vw;\n}\n\n.w-60 {\n    width: 60vw;\n}\n\n.w-65 {\n    width: 65vw;\n}\n\n.w-70 {\n    width: 70vw;\n}\n\n.w-75 {\n    width: 75vw;\n}\n\n.w-80 {\n    width: 80vw;\n}\n\n.w-85 {\n    width: 85vw;\n}\n\n.w-90 {\n    width: 90vw;\n}\n\n.w-95 {\n    width: 95vw;\n}\n\n.w-100 {\n    width: 100vw;\n}\n\n.w-90p {\n    width: 90%;\n}\n\n.w-100p {\n    width: 100%;\n}", ""]);
// Exports
module.exports = exports;


/***/ }),

/***/ "./css/all-modals.css":
/*!****************************!*\
  !*** ./css/all-modals.css ***!
  \****************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./all-modals.css */ "./node_modules/css-loader/dist/cjs.js!./css/all-modals.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/column-graph-and-describe.css":
/*!*******************************************!*\
  !*** ./css/column-graph-and-describe.css ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./column-graph-and-describe.css */ "./node_modules/css-loader/dist/cjs.js!./css/column-graph-and-describe.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/column-header-modal.css":
/*!*************************************!*\
  !*** ./css/column-header-modal.css ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./column-header-modal.css */ "./node_modules/css-loader/dist/cjs.js!./css/column-header-modal.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/column-header.css":
/*!*******************************!*\
  !*** ./css/column-header.css ***!
  \*******************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./column-header.css */ "./node_modules/css-loader/dist/cjs.js!./css/column-header.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/column-name-card.css":
/*!**********************************!*\
  !*** ./css/column-name-card.css ***!
  \**********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./column-name-card.css */ "./node_modules/css-loader/dist/cjs.js!./css/column-name-card.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/control-panel-taskpane.css":
/*!****************************************!*\
  !*** ./css/control-panel-taskpane.css ***!
  \****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./control-panel-taskpane.css */ "./node_modules/css-loader/dist/cjs.js!./css/control-panel-taskpane.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/custom-dropdown.css":
/*!*********************************!*\
  !*** ./css/custom-dropdown.css ***!
  \*********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./custom-dropdown.css */ "./node_modules/css-loader/dist/cjs.js!./css/custom-dropdown.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/default-modal.css":
/*!*******************************!*\
  !*** ./css/default-modal.css ***!
  \*******************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./default-modal.css */ "./node_modules/css-loader/dist/cjs.js!./css/default-modal.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/default-taskpane.css":
/*!**********************************!*\
  !*** ./css/default-taskpane.css ***!
  \**********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./default-taskpane.css */ "./node_modules/css-loader/dist/cjs.js!./css/default-taskpane.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/delete-column-modal.css":
/*!*************************************!*\
  !*** ./css/delete-column-modal.css ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./delete-column-modal.css */ "./node_modules/css-loader/dist/cjs.js!./css/delete-column-modal.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/documentation-basic-example.css":
/*!*********************************************!*\
  !*** ./css/documentation-basic-example.css ***!
  \*********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./documentation-basic-example.css */ "./node_modules/css-loader/dist/cjs.js!./css/documentation-basic-example.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/documentation-box.css":
/*!***********************************!*\
  !*** ./css/documentation-box.css ***!
  \***********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./documentation-box.css */ "./node_modules/css-loader/dist/cjs.js!./css/documentation-box.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/documentation-taskpane.css":
/*!****************************************!*\
  !*** ./css/documentation-taskpane.css ***!
  \****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./documentation-taskpane.css */ "./node_modules/css-loader/dist/cjs.js!./css/documentation-taskpane.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/filter-card.css":
/*!*****************************!*\
  !*** ./css/filter-card.css ***!
  \*****************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./filter-card.css */ "./node_modules/css-loader/dist/cjs.js!./css/filter-card.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/formula-bar.css":
/*!*****************************!*\
  !*** ./css/formula-bar.css ***!
  \*****************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./formula-bar.css */ "./node_modules/css-loader/dist/cjs.js!./css/formula-bar.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/function-documentation.css":
/*!****************************************!*\
  !*** ./css/function-documentation.css ***!
  \****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./function-documentation.css */ "./node_modules/css-loader/dist/cjs.js!./css/function-documentation.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/import-modal.css":
/*!******************************!*\
  !*** ./css/import-modal.css ***!
  \******************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./import-modal.css */ "./node_modules/css-loader/dist/cjs.js!./css/import-modal.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/large-select.css":
/*!******************************!*\
  !*** ./css/large-select.css ***!
  \******************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./large-select.css */ "./node_modules/css-loader/dist/cjs.js!./css/large-select.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/loading-indicator.css":
/*!***********************************!*\
  !*** ./css/loading-indicator.css ***!
  \***********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./loading-indicator.css */ "./node_modules/css-loader/dist/cjs.js!./css/loading-indicator.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/margins.css":
/*!*************************!*\
  !*** ./css/margins.css ***!
  \*************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./margins.css */ "./node_modules/css-loader/dist/cjs.js!./css/margins.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/merge-sheet-and-key-selection.css":
/*!***********************************************!*\
  !*** ./css/merge-sheet-and-key-selection.css ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./merge-sheet-and-key-selection.css */ "./node_modules/css-loader/dist/cjs.js!./css/merge-sheet-and-key-selection.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/mito-toolbar.css":
/*!******************************!*\
  !*** ./css/mito-toolbar.css ***!
  \******************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./mito-toolbar.css */ "./node_modules/css-loader/dist/cjs.js!./css/mito-toolbar.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/mito.css":
/*!**********************!*\
  !*** ./css/mito.css ***!
  \**********************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./mito.css */ "./node_modules/css-loader/dist/cjs.js!./css/mito.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/mitosheet.css":
/*!***************************!*\
  !*** ./css/mitosheet.css ***!
  \***************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./mitosheet.css */ "./node_modules/css-loader/dist/cjs.js!./css/mitosheet.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/mutli-toggle-box.css":
/*!**********************************!*\
  !*** ./css/mutli-toggle-box.css ***!
  \**********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./mutli-toggle-box.css */ "./node_modules/css-loader/dist/cjs.js!./css/mutli-toggle-box.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/pivot-table-column-header-card.css":
/*!************************************************!*\
  !*** ./css/pivot-table-column-header-card.css ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./pivot-table-column-header-card.css */ "./node_modules/css-loader/dist/cjs.js!./css/pivot-table-column-header-card.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/pivot-table-key-selection.css":
/*!*******************************************!*\
  !*** ./css/pivot-table-key-selection.css ***!
  \*******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./pivot-table-key-selection.css */ "./node_modules/css-loader/dist/cjs.js!./css/pivot-table-key-selection.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/pivot-table-value-aggregation-card.css":
/*!****************************************************!*\
  !*** ./css/pivot-table-value-aggregation-card.css ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./pivot-table-value-aggregation-card.css */ "./node_modules/css-loader/dist/cjs.js!./css/pivot-table-value-aggregation-card.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/pivot-taskpane.css":
/*!********************************!*\
  !*** ./css/pivot-taskpane.css ***!
  \********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./pivot-taskpane.css */ "./node_modules/css-loader/dist/cjs.js!./css/pivot-taskpane.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/replay-analysis-taskpane.css":
/*!******************************************!*\
  !*** ./css/replay-analysis-taskpane.css ***!
  \******************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./replay-analysis-taskpane.css */ "./node_modules/css-loader/dist/cjs.js!./css/replay-analysis-taskpane.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/save-analysis-modal.css":
/*!*************************************!*\
  !*** ./css/save-analysis-modal.css ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./save-analysis-modal.css */ "./node_modules/css-loader/dist/cjs.js!./css/save-analysis-modal.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/sheet-tab.css":
/*!***************************!*\
  !*** ./css/sheet-tab.css ***!
  \***************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./sheet-tab.css */ "./node_modules/css-loader/dist/cjs.js!./css/sheet-tab.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/small-select.css":
/*!******************************!*\
  !*** ./css/small-select.css ***!
  \******************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./small-select.css */ "./node_modules/css-loader/dist/cjs.js!./css/small-select.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/step-taskpane.css":
/*!*******************************!*\
  !*** ./css/step-taskpane.css ***!
  \*******************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./step-taskpane.css */ "./node_modules/css-loader/dist/cjs.js!./css/step-taskpane.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/suggestion-box.css":
/*!********************************!*\
  !*** ./css/suggestion-box.css ***!
  \********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./suggestion-box.css */ "./node_modules/css-loader/dist/cjs.js!./css/suggestion-box.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/taskpane-error.css":
/*!********************************!*\
  !*** ./css/taskpane-error.css ***!
  \********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./taskpane-error.css */ "./node_modules/css-loader/dist/cjs.js!./css/taskpane-error.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/top-left-popup.css":
/*!********************************!*\
  !*** ./css/top-left-popup.css ***!
  \********************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./top-left-popup.css */ "./node_modules/css-loader/dist/cjs.js!./css/top-left-popup.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./css/widths.css":
/*!************************!*\
  !*** ./css/widths.css ***!
  \************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var api = __webpack_require__(/*! !../node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
            var content = __webpack_require__(/*! !!../node_modules/css-loader/dist/cjs.js!./widths.css */ "./node_modules/css-loader/dist/cjs.js!./css/widths.css");

            content = content.__esModule ? content.default : content;

            if (typeof content === 'string') {
              content = [[module.id, content, '']];
            }

var options = {};

options.insert = "head";
options.singleton = false;

var update = api(content, options);



module.exports = content.locals || {};

/***/ }),

/***/ "./package.json":
/*!**********************!*\
  !*** ./package.json ***!
  \**********************/
/***/ ((module) => {

"use strict";
module.exports = JSON.parse('{"name":"mitosheet3","version":"0.3.3","description":"The Mito Spreadsheet","keywords":["jupyter","jupyterlab","jupyterlab-extension","widgets"],"files":["lib/**/*.js","dist/*.js","css/*.css","style/index.js"],"homepage":"https://github.com/mito/mito","bugs":{"url":"https://github.com/mito/mito/issues"},"license":"BSD-3-Clause","author":{"name":"Mito Sheet","email":"naterush1997@gmail.com"},"main":"lib/index.js","types":"./lib/index.d.ts","repository":{"type":"git","url":"https://github.com/mito/mito"},"scripts":{"build":"jlpm run build:lib && jlpm run build:labextension:dev","build:all":"npm run build:labextension && npm run build:nbextension","build:labextension":"jupyter labextension build .","build:labextension:dev":"jupyter labextension build --development True .","build:lib":"tsc","build:nbextension":"webpack -p","build:prod":"jlpm run build:lib && jlpm run build:labextension","clean":"jlpm run clean:lib","clean:all":"jlpm run clean:lib && jlpm run clean:labextension","clean:labextension":"rimraf mitosheet3/labextension","clean:lib":"rimraf lib tsconfig.tsbuildinfo","clean:nbextension":"rimraf mitosheet3/nbextension/static/index.js","deploy:all":"python3 deployment/deploy.py all","deploy:app":"python3 deployment/deploy.py app","deploy:pypi":"python3 setup.py sdist bdist_wheel upload","deploy:staging":"python3 deployment/deploy.py staging","eslint":"eslint . --ext .ts,.tsx --fix","eslint:check":"eslint . --ext .ts,.tsx","install:extension":"jupyter labextension develop --overwrite .","lint":"eslint src/ --ext .ts,.tsx --fix","lint:check":"eslint src/ --ext .ts,.tsx","prepack":"npm run build:lib","prepare":"jlpm run clean && jlpm run build:prod","test:chrome":"karma start --browsers=Chrome tests/karma.conf.js","test:debug":"karma start --browsers=Chrome --singleRun=false --debug=true tests/karma.conf.js","test:firefox":"karma start --browsers=Firefox tests/karma.conf.js","test:ga:1":"testcafe chrome tests/1/","test:ga:2":"testcafe chrome tests/2/","test:ga:3":"testcafe chrome tests/3/","test:ga:4":"testcafe chrome tests/4/","test:ga:5":"testcafe chrome tests/5/","test:ga:6":"testcafe chrome tests/6/","test:ie":"karma start --browsers=IE tests/karma.conf.js","test:local":"export JUPYTER_LAB_LOCAL_TOKEN=`jupyter notebook list | sed -n 2p | cut -d\' \' -f1 | cut -d\'=\' -f2` && export LOCAL_TEST=\\"True\\" && testcafe chrome tests/","test:local:noauth":"testcafe chrome tests/","test:remote":"export LOCAL_TEST=\\"False\\"; testcafe chrome tests/","watch":"run-p watch:src watch:labextension","watch:labextension":"jupyter labextension watch .","watch:lib":"tsc -w","watch:nbextension":"webpack --watch","watch:src":"tsc -w"},"dependencies":{"@jupyter-widgets/base":"^4","@jupyterlab/notebook":"^3.0.6","@types/fscreen":"^1.0.1","@types/react-dom":"^17.0.2","ag-grid-community":"^24.0.0","ag-grid-react":"^24.0.0","fscreen":"^1.1.0","react":"^17.0.1","react-dom":"^17.0.1","react-intercom":"^1.0.15","react-joyride":"^2.3.0"},"devDependencies":{"@jupyterlab/builder":"^3.0.0","@lumino/application":"^1.13.1","@lumino/widgets":"^1.16.1","@types/expect.js":"^0.3.29","@types/mocha":"^5.2.5","@types/node":"^14.14.35","@types/webpack-env":"^1.13.6","@typescript-eslint/eslint-plugin":"^4.8.1","@typescript-eslint/parser":"^4.8.1","acorn":"^7.2.0","css-loader":"^3.2.0","eslint":"^7.14.0","eslint-config-prettier":"^6.15.0","eslint-plugin-office-addins":"^0.1.7","eslint-plugin-prettier":"^3.1.4","eslint-plugin-react":"^7.21.3","expect.js":"^0.3.1","fs-extra":"^7.0.0","karma":"^3.1.0","karma-chrome-launcher":"^2.2.0","karma-firefox-launcher":"^1.1.0","karma-ie-launcher":"^1.0.0","karma-mocha":"^1.3.0","karma-mocha-reporter":"^2.2.5","karma-typescript":"^5.0.3","karma-typescript-es6-transform":"^5.0.3","mkdirp":"^0.5.1","mocha":"^5.2.0","npm-run-all":"^4.1.5","prettier":"^2.1.1","rimraf":"^3.0.2","source-map-loader":"^0.2.4","style-loader":"^1.0.0","testcafe":"^1.9.4","testcafe-react-selectors":"^4.1.1","ts-loader":"^5.2.1","typescript":"~4.1.3","webpack":"^4.20.2","webpack-cli":"^3.1.2"},"resolutions":{"@types/react":"^17.0.2"},"jupyterlab":{"extension":"lib/plugin","outputDir":"mitosheet3/labextension"},"styleModule":"style/index.js"}');

/***/ })

}]);
//# sourceMappingURL=lib_plugin_js.829415c93c18ee6cd752.js.map