"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ec2_1 = require("monocdk/aws-ec2");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Route tables do not have unrestricted routes ('0.0.0.0/0' or '::/0') to IGWs - (Control IDs: 1.2, 1.2.1, 1.3, 1.3.1, 1.3.2, 2.2.2)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnRoute) {
        if (node.gatewayId != undefined) {
            const destinationCidrBlock = nag_pack_1.resolveIfPrimitive(node, node.destinationCidrBlock);
            const destinationIpv6CidrBlock = nag_pack_1.resolveIfPrimitive(node, node.destinationIpv6CidrBlock);
            if (destinationCidrBlock != undefined &&
                destinationCidrBlock.includes('/0')) {
                return false;
            }
            if (destinationIpv6CidrBlock != undefined &&
                destinationIpv6CidrBlock.includes('/0')) {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGNpRHNzMzIxVlBDTm9VbnJlc3RyaWN0ZWRSb3V0ZVRvSUdXLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL1BDSS1EU1MtMy4yLjEvcnVsZXMvdnBjL3BjaURzczMyMVZQQ05vVW5yZXN0cmljdGVkUm91dGVUb0lHVy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7OztFQUdFOztBQUVGLDZDQUEyQztBQUUzQyxnREFBdUQ7QUFFdkQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLGtCQUFRLEVBQUU7UUFDNUIsSUFBSSxJQUFJLENBQUMsU0FBUyxJQUFJLFNBQVMsRUFBRTtZQUMvQixNQUFNLG9CQUFvQixHQUFHLDZCQUFrQixDQUM3QyxJQUFJLEVBQ0osSUFBSSxDQUFDLG9CQUFvQixDQUMxQixDQUFDO1lBQ0YsTUFBTSx3QkFBd0IsR0FBRyw2QkFBa0IsQ0FDakQsSUFBSSxFQUNKLElBQUksQ0FBQyx3QkFBd0IsQ0FDOUIsQ0FBQztZQUNGLElBQ0Usb0JBQW9CLElBQUksU0FBUztnQkFDakMsb0JBQW9CLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxFQUNuQztnQkFDQSxPQUFPLEtBQUssQ0FBQzthQUNkO1lBQ0QsSUFDRSx3QkFBd0IsSUFBSSxTQUFTO2dCQUNyQyx3QkFBd0IsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEVBQ3ZDO2dCQUNBLE9BQU8sS0FBSyxDQUFDO2FBQ2Q7U0FDRjtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBMUJELDRCQTBCQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuXG5pbXBvcnQgeyBDZm5Sb3V0ZSB9IGZyb20gJ21vbm9jZGsvYXdzLWVjMic7XG5pbXBvcnQgeyBDZm5SZXNvdXJjZSB9IGZyb20gJ21vbm9jZGsnO1xuaW1wb3J0IHsgcmVzb2x2ZUlmUHJpbWl0aXZlIH0gZnJvbSAnLi4vLi4vLi4vbmFnLXBhY2snO1xuXG4vKipcbiAqIFJvdXRlIHRhYmxlcyBkbyBub3QgaGF2ZSB1bnJlc3RyaWN0ZWQgcm91dGVzICgnMC4wLjAuMC8wJyBvciAnOjovMCcpIHRvIElHV3MgLSAoQ29udHJvbCBJRHM6IDEuMiwgMS4yLjEsIDEuMywgMS4zLjEsIDEuMy4yLCAyLjIuMilcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5leHBvcnQgZGVmYXVsdCBmdW5jdGlvbiAobm9kZTogQ2ZuUmVzb3VyY2UpOiBib29sZWFuIHtcbiAgaWYgKG5vZGUgaW5zdGFuY2VvZiBDZm5Sb3V0ZSkge1xuICAgIGlmIChub2RlLmdhdGV3YXlJZCAhPSB1bmRlZmluZWQpIHtcbiAgICAgIGNvbnN0IGRlc3RpbmF0aW9uQ2lkckJsb2NrID0gcmVzb2x2ZUlmUHJpbWl0aXZlKFxuICAgICAgICBub2RlLFxuICAgICAgICBub2RlLmRlc3RpbmF0aW9uQ2lkckJsb2NrXG4gICAgICApO1xuICAgICAgY29uc3QgZGVzdGluYXRpb25JcHY2Q2lkckJsb2NrID0gcmVzb2x2ZUlmUHJpbWl0aXZlKFxuICAgICAgICBub2RlLFxuICAgICAgICBub2RlLmRlc3RpbmF0aW9uSXB2NkNpZHJCbG9ja1xuICAgICAgKTtcbiAgICAgIGlmIChcbiAgICAgICAgZGVzdGluYXRpb25DaWRyQmxvY2sgIT0gdW5kZWZpbmVkICYmXG4gICAgICAgIGRlc3RpbmF0aW9uQ2lkckJsb2NrLmluY2x1ZGVzKCcvMCcpXG4gICAgICApIHtcbiAgICAgICAgcmV0dXJuIGZhbHNlO1xuICAgICAgfVxuICAgICAgaWYgKFxuICAgICAgICBkZXN0aW5hdGlvbklwdjZDaWRyQmxvY2sgIT0gdW5kZWZpbmVkICYmXG4gICAgICAgIGRlc3RpbmF0aW9uSXB2NkNpZHJCbG9jay5pbmNsdWRlcygnLzAnKVxuICAgICAgKSB7XG4gICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgIH1cbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=