"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_s3_1 = require("monocdk/aws-s3");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * S3 Buckets prohibit public access through bucket level settings - (Control IDs: 1.2, 1.2.1, 1.3, 1.3.1, 1.3.2, 1.3.4, 1.3.6, 2.2.2)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        if (node.publicAccessBlockConfiguration == undefined) {
            return false;
        }
        const publicAccess = monocdk_1.Stack.of(node).resolve(node.publicAccessBlockConfiguration);
        const blockPublicAcls = nag_pack_1.resolveIfPrimitive(node, publicAccess.blockPublicAcls);
        const blockPublicPolicy = nag_pack_1.resolveIfPrimitive(node, publicAccess.blockPublicPolicy);
        const ignorePublicAcls = nag_pack_1.resolveIfPrimitive(node, publicAccess.ignorePublicAcls);
        const restrictPublicBuckets = nag_pack_1.resolveIfPrimitive(node, publicAccess.restrictPublicBuckets);
        if (blockPublicAcls !== true ||
            blockPublicPolicy !== true ||
            ignorePublicAcls !== true ||
            restrictPublicBuckets !== true) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGNpRHNzMzIxUzNCdWNrZXRMZXZlbFB1YmxpY0FjY2Vzc1Byb2hpYml0ZWQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi9zcmMvUENJLURTUy0zLjIuMS9ydWxlcy9zMy9wY2lEc3MzMjFTM0J1Y2tldExldmVsUHVibGljQWNjZXNzUHJvaGliaXRlZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLDJDQUEyQztBQUMzQyxxQ0FBNkM7QUFDN0MsZ0RBQXVEO0FBRXZEOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSxrQkFBUyxFQUFFO1FBQzdCLElBQUksSUFBSSxDQUFDLDhCQUE4QixJQUFJLFNBQVMsRUFBRTtZQUNwRCxPQUFPLEtBQUssQ0FBQztTQUNkO1FBQ0QsTUFBTSxZQUFZLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQ3pDLElBQUksQ0FBQyw4QkFBOEIsQ0FDcEMsQ0FBQztRQUNGLE1BQU0sZUFBZSxHQUFHLDZCQUFrQixDQUN4QyxJQUFJLEVBQ0osWUFBWSxDQUFDLGVBQWUsQ0FDN0IsQ0FBQztRQUNGLE1BQU0saUJBQWlCLEdBQUcsNkJBQWtCLENBQzFDLElBQUksRUFDSixZQUFZLENBQUMsaUJBQWlCLENBQy9CLENBQUM7UUFDRixNQUFNLGdCQUFnQixHQUFHLDZCQUFrQixDQUN6QyxJQUFJLEVBQ0osWUFBWSxDQUFDLGdCQUFnQixDQUM5QixDQUFDO1FBQ0YsTUFBTSxxQkFBcUIsR0FBRyw2QkFBa0IsQ0FDOUMsSUFBSSxFQUNKLFlBQVksQ0FBQyxxQkFBcUIsQ0FDbkMsQ0FBQztRQUNGLElBQ0UsZUFBZSxLQUFLLElBQUk7WUFDeEIsaUJBQWlCLEtBQUssSUFBSTtZQUMxQixnQkFBZ0IsS0FBSyxJQUFJO1lBQ3pCLHFCQUFxQixLQUFLLElBQUksRUFDOUI7WUFDQSxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFsQ0QsNEJBa0NDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5pbXBvcnQgeyBDZm5CdWNrZXQgfSBmcm9tICdtb25vY2RrL2F3cy1zMyc7XG5pbXBvcnQgeyBDZm5SZXNvdXJjZSwgU3RhY2sgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL25hZy1wYWNrJztcblxuLyoqXG4gKiBTMyBCdWNrZXRzIHByb2hpYml0IHB1YmxpYyBhY2Nlc3MgdGhyb3VnaCBidWNrZXQgbGV2ZWwgc2V0dGluZ3MgLSAoQ29udHJvbCBJRHM6IDEuMiwgMS4yLjEsIDEuMywgMS4zLjEsIDEuMy4yLCAxLjMuNCwgMS4zLjYsIDIuMi4yKVxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkJ1Y2tldCkge1xuICAgIGlmIChub2RlLnB1YmxpY0FjY2Vzc0Jsb2NrQ29uZmlndXJhdGlvbiA9PSB1bmRlZmluZWQpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gICAgY29uc3QgcHVibGljQWNjZXNzID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShcbiAgICAgIG5vZGUucHVibGljQWNjZXNzQmxvY2tDb25maWd1cmF0aW9uXG4gICAgKTtcbiAgICBjb25zdCBibG9ja1B1YmxpY0FjbHMgPSByZXNvbHZlSWZQcmltaXRpdmUoXG4gICAgICBub2RlLFxuICAgICAgcHVibGljQWNjZXNzLmJsb2NrUHVibGljQWNsc1xuICAgICk7XG4gICAgY29uc3QgYmxvY2tQdWJsaWNQb2xpY3kgPSByZXNvbHZlSWZQcmltaXRpdmUoXG4gICAgICBub2RlLFxuICAgICAgcHVibGljQWNjZXNzLmJsb2NrUHVibGljUG9saWN5XG4gICAgKTtcbiAgICBjb25zdCBpZ25vcmVQdWJsaWNBY2xzID0gcmVzb2x2ZUlmUHJpbWl0aXZlKFxuICAgICAgbm9kZSxcbiAgICAgIHB1YmxpY0FjY2Vzcy5pZ25vcmVQdWJsaWNBY2xzXG4gICAgKTtcbiAgICBjb25zdCByZXN0cmljdFB1YmxpY0J1Y2tldHMgPSByZXNvbHZlSWZQcmltaXRpdmUoXG4gICAgICBub2RlLFxuICAgICAgcHVibGljQWNjZXNzLnJlc3RyaWN0UHVibGljQnVja2V0c1xuICAgICk7XG4gICAgaWYgKFxuICAgICAgYmxvY2tQdWJsaWNBY2xzICE9PSB0cnVlIHx8XG4gICAgICBibG9ja1B1YmxpY1BvbGljeSAhPT0gdHJ1ZSB8fFxuICAgICAgaWdub3JlUHVibGljQWNscyAhPT0gdHJ1ZSB8fFxuICAgICAgcmVzdHJpY3RQdWJsaWNCdWNrZXRzICE9PSB0cnVlXG4gICAgKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19