"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_ec2_1 = require("monocdk/aws-ec2");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Route tables do not have unrestricted routes ('0.0.0.0/0' or '::/0') to IGWs - (Control IDs: AC-4(21), CM-7b)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnRoute) {
        if (node.gatewayId != undefined) {
            const destinationCidrBlock = nag_pack_1.resolveIfPrimitive(node, node.destinationCidrBlock);
            const destinationIpv6CidrBlock = nag_pack_1.resolveIfPrimitive(node, node.destinationIpv6CidrBlock);
            if (destinationCidrBlock != undefined &&
                destinationCidrBlock.includes('/0')) {
                return false;
            }
            if (destinationIpv6CidrBlock != undefined &&
                destinationIpv6CidrBlock.includes('/0')) {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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