"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_s3_1 = require("monocdk/aws-s3");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * S3 Buckets prohibit public access through bucket level settings - (Control IDs: AC-2(6), AC-3, AC-3(7), AC-4(21), AC-6, AC-17b, AC-17(1), AC-17(1), AC-17(4)(a), AC-17(9), AC-17(10), MP-2, SC-7a, SC-7b, SC-7c, SC-7(2), SC-7(3), SC-7(7), SC-7(9)(a), SC-7(11), SC-7(20), SC-7(21), SC-7(24)(b), SC-7(25), SC-7(26), SC-7(27), SC-7(28), SC-25)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_s3_1.CfnBucket) {
        if (node.publicAccessBlockConfiguration == undefined) {
            return false;
        }
        const publicAccess = monocdk_1.Stack.of(node).resolve(node.publicAccessBlockConfiguration);
        const blockPublicAcls = nag_pack_1.resolveIfPrimitive(node, publicAccess.blockPublicAcls);
        const blockPublicPolicy = nag_pack_1.resolveIfPrimitive(node, publicAccess.blockPublicPolicy);
        const ignorePublicAcls = nag_pack_1.resolveIfPrimitive(node, publicAccess.ignorePublicAcls);
        const restrictPublicBuckets = nag_pack_1.resolveIfPrimitive(node, publicAccess.restrictPublicBuckets);
        if (blockPublicAcls !== true ||
            blockPublicPolicy !== true ||
            ignorePublicAcls !== true ||
            restrictPublicBuckets !== true) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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