"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_kms_1 = require("monocdk/aws-kms");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * KMS Symmetric keys have automatic key rotation enabled - (Control IDs: CM-6a, CM-9b, SA-9(6), SC-12, SC-12(2), SC-12(6))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_kms_1.CfnKey) {
        const keySpec = monocdk_1.Stack.of(node).resolve(node.keySpec);
        if (keySpec == undefined || keySpec == aws_kms_1.KeySpec.SYMMETRIC_DEFAULT) {
            const enableKeyRotation = nag_pack_1.resolveIfPrimitive(node, node.enableKeyRotation);
            if (enableKeyRotation !== true) {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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