"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_rds_1 = require("monocdk/aws-rds");
const nag_pack_1 = require("../../../nag-pack");
/**
 *  RDS DB instances and Aurora DB clusters have Deletion Protection enabled - (Control ID: SC-5)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBCluster) {
        if (node.deletionProtection == undefined) {
            return false;
        }
        const deletionProtection = nag_pack_1.resolveIfPrimitive(node, node.deletionProtection);
        if (deletionProtection == false) {
            return false;
        }
        return true;
    }
    else if (node instanceof aws_rds_1.CfnDBInstance) {
        const deletionProtection = nag_pack_1.resolveIfPrimitive(node, node.deletionProtection);
        const engine = nag_pack_1.resolveIfPrimitive(node, node.engine);
        if ((deletionProtection == false || deletionProtection == undefined) &&
            (engine == undefined || !engine.toLowerCase().includes('aurora'))) {
            return false;
        }
        return true;
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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