"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_lambda_1 = require("monocdk/aws-lambda");
const monocdk_1 = require("monocdk");
/**
 * Lambda functions are VPC enabled - (Control IDs: AC-4, SC-7, SC-7(3))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_lambda_1.CfnFunction) {
        //Check for a VPC configuration
        const vpcConfig = monocdk_1.Stack.of(node).resolve(node.vpcConfig);
        if (vpcConfig == undefined) {
            return false;
        }
        else {
            const secgroups = monocdk_1.Stack.of(node).resolve(vpcConfig.securityGroupIds);
            const subnets = monocdk_1.Stack.of(node).resolve(vpcConfig.subnetIds);
            //Does this function exist within at least one VPC security group or subnet?
            if (secgroups == undefined || secgroups.length == 0) {
                if (subnets == undefined || subnets.length == 0) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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