"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_iam_1 = require("monocdk/aws-iam");
const monocdk_1 = require("monocdk");
/**
 * IAM policies do not grant admin access - (Control IDs: AC-2(1), AC-2(j), AC-3, and AC-6)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_iam_1.CfnPolicy || node instanceof aws_iam_1.CfnManagedPolicy) {
        if (checkDocument(node, node.policyDocument)) {
            return false;
        }
    }
    else if (node instanceof aws_iam_1.CfnGroup || node instanceof aws_iam_1.CfnRole) {
        if (node.policies != undefined && checkDocument(node, node.policies)) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
/**
 * Helper function for parsing through the policy document
 * @param node the CfnResource to Check
 * @param policyDoc the JSON policy document
 * @returns boolean
 */
function checkDocument(node, policyDoc) {
    const resolvedDoc = monocdk_1.Stack.of(node).resolve(policyDoc);
    const reg = /"Action":\[?(.*,)?"\*"(,.*)?\]?,"Effect":"Allow","Resource":\[?(.*,)?"(?:arn(?::.*(?::)?)?)?\*"(,.*)?\]?/gm;
    if (JSON.stringify(resolvedDoc).search(reg) != -1) {
        return true;
    }
    return false;
}
//# sourceMappingURL=data:application/json;base64,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