"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_codebuild_1 = require("monocdk/aws-codebuild");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Codebuild projects with a GitHub or BitBucket source repository utilize OAUTH - (Control IDs: SA-3(a))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_codebuild_1.CfnProject) {
        //Check for the presence of OAUTH
        const projectSource = monocdk_1.Stack.of(node).resolve(node.source);
        const projectAuth = monocdk_1.Stack.of(node).resolve(projectSource.auth);
        if (projectAuth == undefined) {
            return false;
        }
        else {
            const projectAuthType = nag_pack_1.resolveIfPrimitive(node, projectAuth.type);
            if (projectAuthType != 'OAUTH') {
                return false;
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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