"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_sagemaker_1 = require("monocdk/aws-sagemaker");
const nag_pack_1 = require("../../../nag-pack");
/**
 * SageMaker notebook instances have direct internet access disabled - (Control IDs: 164.308(a)(3)(i), 164.308(a)(4)(ii)(A), 164.308(a)(4)(ii)(C), 164.312(a)(1), 164.312(e)(1))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_sagemaker_1.CfnNotebookInstance) {
        const directInternetAccess = nag_pack_1.resolveIfPrimitive(node, node.directInternetAccess);
        if (directInternetAccess == undefined ||
            directInternetAccess != 'Disabled') {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGlwYWFTZWN1cml0eVNhZ2VNYWtlck5vdGVib29rTm9EaXJlY3RJbnRlcm5ldEFjY2Vzcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9ISVBBQS1TZWN1cml0eS9ydWxlcy9zYWdlbWFrZXIvaGlwYWFTZWN1cml0eVNhZ2VNYWtlck5vdGVib29rTm9EaXJlY3RJbnRlcm5ldEFjY2Vzcy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUE7OztFQUdFOztBQUVGLHlEQUE0RDtBQUU1RCxnREFBdUQ7QUFFdkQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLG1DQUFtQixFQUFFO1FBQ3ZDLE1BQU0sb0JBQW9CLEdBQUcsNkJBQWtCLENBQzdDLElBQUksRUFDSixJQUFJLENBQUMsb0JBQW9CLENBQzFCLENBQUM7UUFDRixJQUNFLG9CQUFvQixJQUFJLFNBQVM7WUFDakMsb0JBQW9CLElBQUksVUFBVSxFQUNsQztZQUNBLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQWRELDRCQWNDIiwic291cmNlc0NvbnRlbnQiOlsiLypcbkNvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiovXG5cbmltcG9ydCB7IENmbk5vdGVib29rSW5zdGFuY2UgfSBmcm9tICdtb25vY2RrL2F3cy1zYWdlbWFrZXInO1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL25hZy1wYWNrJztcblxuLyoqXG4gKiBTYWdlTWFrZXIgbm90ZWJvb2sgaW5zdGFuY2VzIGhhdmUgZGlyZWN0IGludGVybmV0IGFjY2VzcyBkaXNhYmxlZCAtIChDb250cm9sIElEczogMTY0LjMwOChhKSgzKShpKSwgMTY0LjMwOChhKSg0KShpaSkoQSksIDE2NC4zMDgoYSkoNCkoaWkpKEMpLCAxNjQuMzEyKGEpKDEpLCAxNjQuMzEyKGUpKDEpKVxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbk5vdGVib29rSW5zdGFuY2UpIHtcbiAgICBjb25zdCBkaXJlY3RJbnRlcm5ldEFjY2VzcyA9IHJlc29sdmVJZlByaW1pdGl2ZShcbiAgICAgIG5vZGUsXG4gICAgICBub2RlLmRpcmVjdEludGVybmV0QWNjZXNzXG4gICAgKTtcbiAgICBpZiAoXG4gICAgICBkaXJlY3RJbnRlcm5ldEFjY2VzcyA9PSB1bmRlZmluZWQgfHxcbiAgICAgIGRpcmVjdEludGVybmV0QWNjZXNzICE9ICdEaXNhYmxlZCdcbiAgICApIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=