"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const aws_codebuild_1 = require("monocdk/aws-codebuild");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * CodeBuild projects do not store AWS credentials as plaintext environment variables - (Control IDs: 164.308(a)(3)(i), 164.308(a)(4)(ii)(A), 164.308(a)(4)(ii)(C), 164.312(a)(1))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_codebuild_1.CfnProject) {
        //Check for the presence of OAUTH
        const environment = monocdk_1.Stack.of(node).resolve(node.environment);
        const environmentVars = monocdk_1.Stack.of(node).resolve(environment.environmentVariables);
        if (environmentVars != undefined) {
            //For each envvar, check if its a sensitive credential being stored
            for (const envVar of environmentVars) {
                const resolvedEnvVar = monocdk_1.Stack.of(node).resolve(envVar);
                const name = nag_pack_1.resolveIfPrimitive(node, resolvedEnvVar.name);
                const type = nag_pack_1.resolveIfPrimitive(node, resolvedEnvVar.type);
                if (name == 'AWS_ACCESS_KEY_ID' || name == 'AWS_SECRET_ACCESS_KEY') {
                    //is this credential being stored as plaintext?
                    if (type == undefined || type == 'PLAINTEXT') {
                        return false;
                    }
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaGlwYWFTZWN1cml0eUNvZGVCdWlsZFByb2plY3RFbnZWYXJBd3NDcmVkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0hJUEFBLVNlY3VyaXR5L3J1bGVzL2NvZGVidWlsZC9oaXBhYVNlY3VyaXR5Q29kZUJ1aWxkUHJvamVjdEVudlZhckF3c0NyZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7RUFHRTs7QUFFRix5REFBbUQ7QUFDbkQscUNBQTZDO0FBQzdDLGdEQUF1RDtBQUV2RDs7O0dBR0c7QUFDSCxtQkFBeUIsSUFBaUI7SUFDeEMsSUFBSSxJQUFJLFlBQVksMEJBQVUsRUFBRTtRQUM5QixpQ0FBaUM7UUFDakMsTUFBTSxXQUFXLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQzdELE1BQU0sZUFBZSxHQUFHLGVBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLENBQUMsT0FBTyxDQUM1QyxXQUFXLENBQUMsb0JBQW9CLENBQ2pDLENBQUM7UUFDRixJQUFJLGVBQWUsSUFBSSxTQUFTLEVBQUU7WUFDaEMsbUVBQW1FO1lBQ25FLEtBQUssTUFBTSxNQUFNLElBQUksZUFBZSxFQUFFO2dCQUNwQyxNQUFNLGNBQWMsR0FBRyxlQUFLLENBQUMsRUFBRSxDQUFDLElBQUksQ0FBQyxDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQztnQkFDdEQsTUFBTSxJQUFJLEdBQUcsNkJBQWtCLENBQUMsSUFBSSxFQUFFLGNBQWMsQ0FBQyxJQUFJLENBQUMsQ0FBQztnQkFDM0QsTUFBTSxJQUFJLEdBQUcsNkJBQWtCLENBQUMsSUFBSSxFQUFFLGNBQWMsQ0FBQyxJQUFJLENBQUMsQ0FBQztnQkFDM0QsSUFBSSxJQUFJLElBQUksbUJBQW1CLElBQUksSUFBSSxJQUFJLHVCQUF1QixFQUFFO29CQUNsRSwrQ0FBK0M7b0JBQy9DLElBQUksSUFBSSxJQUFJLFNBQVMsSUFBSSxJQUFJLElBQUksV0FBVyxFQUFFO3dCQUM1QyxPQUFPLEtBQUssQ0FBQztxQkFDZDtpQkFDRjthQUNGO1NBQ0Y7S0FDRjtJQUNELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQXZCRCw0QkF1QkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cblxuaW1wb3J0IHsgQ2ZuUHJvamVjdCB9IGZyb20gJ21vbm9jZGsvYXdzLWNvZGVidWlsZCc7XG5pbXBvcnQgeyBDZm5SZXNvdXJjZSwgU3RhY2sgfSBmcm9tICdtb25vY2RrJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL25hZy1wYWNrJztcblxuLyoqXG4gKiBDb2RlQnVpbGQgcHJvamVjdHMgZG8gbm90IHN0b3JlIEFXUyBjcmVkZW50aWFscyBhcyBwbGFpbnRleHQgZW52aXJvbm1lbnQgdmFyaWFibGVzIC0gKENvbnRyb2wgSURzOiAxNjQuMzA4KGEpKDMpKGkpLCAxNjQuMzA4KGEpKDQpKGlpKShBKSwgMTY0LjMwOChhKSg0KShpaSkoQyksIDE2NC4zMTIoYSkoMSkpXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuUHJvamVjdCkge1xuICAgIC8vQ2hlY2sgZm9yIHRoZSBwcmVzZW5jZSBvZiBPQVVUSFxuICAgIGNvbnN0IGVudmlyb25tZW50ID0gU3RhY2sub2Yobm9kZSkucmVzb2x2ZShub2RlLmVudmlyb25tZW50KTtcbiAgICBjb25zdCBlbnZpcm9ubWVudFZhcnMgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKFxuICAgICAgZW52aXJvbm1lbnQuZW52aXJvbm1lbnRWYXJpYWJsZXNcbiAgICApO1xuICAgIGlmIChlbnZpcm9ubWVudFZhcnMgIT0gdW5kZWZpbmVkKSB7XG4gICAgICAvL0ZvciBlYWNoIGVudnZhciwgY2hlY2sgaWYgaXRzIGEgc2Vuc2l0aXZlIGNyZWRlbnRpYWwgYmVpbmcgc3RvcmVkXG4gICAgICBmb3IgKGNvbnN0IGVudlZhciBvZiBlbnZpcm9ubWVudFZhcnMpIHtcbiAgICAgICAgY29uc3QgcmVzb2x2ZWRFbnZWYXIgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKGVudlZhcik7XG4gICAgICAgIGNvbnN0IG5hbWUgPSByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgcmVzb2x2ZWRFbnZWYXIubmFtZSk7XG4gICAgICAgIGNvbnN0IHR5cGUgPSByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgcmVzb2x2ZWRFbnZWYXIudHlwZSk7XG4gICAgICAgIGlmIChuYW1lID09ICdBV1NfQUNDRVNTX0tFWV9JRCcgfHwgbmFtZSA9PSAnQVdTX1NFQ1JFVF9BQ0NFU1NfS0VZJykge1xuICAgICAgICAgIC8vaXMgdGhpcyBjcmVkZW50aWFsIGJlaW5nIHN0b3JlZCBhcyBwbGFpbnRleHQ/XG4gICAgICAgICAgaWYgKHR5cGUgPT0gdW5kZWZpbmVkIHx8IHR5cGUgPT0gJ1BMQUlOVEVYVCcpIHtcbiAgICAgICAgICAgIHJldHVybiBmYWxzZTtcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIH1cbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=