"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_cognito_1 = require("monocdk/aws-cognito");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Cognito user pools require MFA
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_cognito_1.CfnUserPool) {
        const mfaConfiguration = nag_pack_1.resolveIfPrimitive(node, node.mfaConfiguration);
        if (mfaConfiguration == undefined || mfaConfiguration != aws_cognito_1.Mfa.REQUIRED) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQ09HMi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9Bd3NTb2x1dGlvbnMvcnVsZXMvc2VjdXJpdHlfYW5kX2NvbXBsaWFuY2UvQ09HMi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLHFEQUF1RDtBQUV2RCxnREFBdUQ7QUFFdkQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLHlCQUFXLEVBQUU7UUFDL0IsTUFBTSxnQkFBZ0IsR0FBRyw2QkFBa0IsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLENBQUM7UUFDekUsSUFBSSxnQkFBZ0IsSUFBSSxTQUFTLElBQUksZ0JBQWdCLElBQUksaUJBQUcsQ0FBQyxRQUFRLEVBQUU7WUFDckUsT0FBTyxLQUFLLENBQUM7U0FDZDtLQUNGO0lBQ0QsT0FBTyxJQUFJLENBQUM7QUFDZCxDQUFDO0FBUkQsNEJBUUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cbmltcG9ydCB7IENmblVzZXJQb29sLCBNZmEgfSBmcm9tICdtb25vY2RrL2F3cy1jb2duaXRvJztcbmltcG9ydCB7IENmblJlc291cmNlIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyByZXNvbHZlSWZQcmltaXRpdmUgfSBmcm9tICcuLi8uLi8uLi9uYWctcGFjayc7XG5cbi8qKlxuICogQ29nbml0byB1c2VyIHBvb2xzIHJlcXVpcmUgTUZBXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuVXNlclBvb2wpIHtcbiAgICBjb25zdCBtZmFDb25maWd1cmF0aW9uID0gcmVzb2x2ZUlmUHJpbWl0aXZlKG5vZGUsIG5vZGUubWZhQ29uZmlndXJhdGlvbik7XG4gICAgaWYgKG1mYUNvbmZpZ3VyYXRpb24gPT0gdW5kZWZpbmVkIHx8IG1mYUNvbmZpZ3VyYXRpb24gIT0gTWZhLlJFUVVJUkVEKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19