"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_rds_1 = require("monocdk/aws-rds");
const nag_pack_1 = require("../../../nag-pack");
/**
 * RDS Aurora MySQL serverless clusters have audit, error, general, and slowquery Log Exports enabled
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBCluster) {
        const engine = nag_pack_1.resolveIfPrimitive(node, node.engine).toLowerCase();
        const engineMode = nag_pack_1.resolveIfPrimitive(node, node.engineMode).toLowerCase();
        if (engineMode != undefined &&
            engineMode.toLowerCase() == 'serverless' &&
            (engine.toLowerCase() == 'aurora' ||
                engine.toLowerCase() == 'aurora-mysql')) {
            if (node.enableCloudwatchLogsExports == undefined) {
                return false;
            }
            const needed = ['audit', 'error', 'general', 'slowquery'];
            const exports = node.enableCloudwatchLogsExports.map((i) => {
                return i.toLowerCase();
            });
            return needed.every((i) => exports.includes(i));
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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