"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_elasticache_1 = require("monocdk/aws-elasticache");
const nag_pack_1 = require("../../../nag-pack");
/**
 * ElastiCache Redis clusters are deployed in a Multi-AZ configuration
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticache_1.CfnReplicationGroup) {
        if (node.multiAzEnabled == undefined) {
            return false;
        }
        const multiAz = nag_pack_1.resolveIfPrimitive(node, node.multiAzEnabled);
        if (!multiAz) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQUVDNC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9Bd3NTb2x1dGlvbnMvcnVsZXMvZGF0YWJhc2VzL0FFQzQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7O0VBR0U7QUFDRiw2REFBOEQ7QUFFOUQsZ0RBQXVEO0FBRXZEOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSxxQ0FBbUIsRUFBRTtRQUN2QyxJQUFJLElBQUksQ0FBQyxjQUFjLElBQUksU0FBUyxFQUFFO1lBQ3BDLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7UUFDRCxNQUFNLE9BQU8sR0FBRyw2QkFBa0IsQ0FBQyxJQUFJLEVBQUUsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQzlELElBQUksQ0FBQyxPQUFPLEVBQUU7WUFDWixPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFYRCw0QkFXQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuUmVwbGljYXRpb25Hcm91cCB9IGZyb20gJ21vbm9jZGsvYXdzLWVsYXN0aWNhY2hlJztcbmltcG9ydCB7IENmblJlc291cmNlIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyByZXNvbHZlSWZQcmltaXRpdmUgfSBmcm9tICcuLi8uLi8uLi9uYWctcGFjayc7XG5cbi8qKlxuICogRWxhc3RpQ2FjaGUgUmVkaXMgY2x1c3RlcnMgYXJlIGRlcGxveWVkIGluIGEgTXVsdGktQVogY29uZmlndXJhdGlvblxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmblJlcGxpY2F0aW9uR3JvdXApIHtcbiAgICBpZiAobm9kZS5tdWx0aUF6RW5hYmxlZCA9PSB1bmRlZmluZWQpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gICAgY29uc3QgbXVsdGlBeiA9IHJlc29sdmVJZlByaW1pdGl2ZShub2RlLCBub2RlLm11bHRpQXpFbmFibGVkKTtcbiAgICBpZiAoIW11bHRpQXopIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=