"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const aws_msk_1 = require("monocdk/aws-msk");
const monocdk_1 = require("monocdk");
const nag_pack_1 = require("../../../nag-pack");
/**
 * MSK clusters send broker logs to a supported destination
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_msk_1.CfnCluster) {
        const loggingInfo = monocdk_1.Stack.of(node).resolve(node.loggingInfo);
        if (loggingInfo == undefined) {
            return false;
        }
        const resolvedBrokerLogs = monocdk_1.Stack.of(node).resolve(loggingInfo.brokerLogs);
        let enabled = false;
        const s3 = monocdk_1.Stack.of(node).resolve(resolvedBrokerLogs.s3);
        if (s3 != undefined) {
            const s3Enabled = nag_pack_1.resolveIfPrimitive(node, s3.enabled);
            if (s3Enabled) {
                enabled = true;
            }
        }
        const cloudWatchLogs = monocdk_1.Stack.of(node).resolve(resolvedBrokerLogs.cloudWatchLogs);
        if (cloudWatchLogs != undefined) {
            const cloudWatchLogsEnabled = nag_pack_1.resolveIfPrimitive(node, cloudWatchLogs.enabled);
            if (cloudWatchLogsEnabled) {
                enabled = true;
            }
        }
        const firehose = monocdk_1.Stack.of(node).resolve(resolvedBrokerLogs.firehose);
        if (firehose != undefined) {
            const firehoseEnabled = nag_pack_1.resolveIfPrimitive(node, firehose.enabled);
            if (firehoseEnabled) {
                enabled = true;
            }
        }
        if (!enabled) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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