/**
 * @stability stable
 */
export interface MachineOptions {
    /**
     * @stability stable
     */
    readonly instanceType?: string;
    /**
     * @stability stable
     */
    readonly ami?: string;
    /**
     * @stability stable
     */
    readonly region?: string;
    /**
     * @stability stable
     */
    readonly vpcId?: string;
    /**
     * Extract the availabilityZone last character for the needs of gitlab configuration.
     *
     * @see https://docs.gitlab.com/runners/configuration/runners_autoscale_aws/#the-runnerssmachine-section
     * @stability stable
     */
    readonly zone?: string;
    /**
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * The SecurityGroup's GroupName, not the GroupId.
     *
     * @stability stable
     */
    readonly securityGroup?: string;
    /**
     * @stability stable
     */
    readonly usePrivateAddress?: boolean;
    /**
     * @stability stable
     */
    readonly iamInstanceProfile?: string;
    /**
     * The amazonec2-request-spot-instance parameter.
     *
     * Whether or not to request spot instances.
     *
     * @default true
     * @see https://aws.amazon.com/ec2/spot/
     * @stability stable
     */
    readonly requestSpotInstance?: boolean;
    /**
     * The amazonec2-spot-price parameter.
     *
     * The bidding price for spot instances.
     *
     * @default 0.03
     * @see https://aws.amazon.com/ec2/spot/pricing/
     * @stability stable
     */
    readonly spotPrice?: number;
    /**
     * The amazonec2-block-duration-minutes parameter.
     *
     * AWS spot instance duration in minutes (60, 120, 180, 240, 300, or 360).
     *
     * @see https://docs.gitlab.com/runner/configuration/runner_autoscale_aws/#cutting-down-costs-with-amazon-ec2-spot-instances
     * @stability stable
     */
    readonly blockDurationMinutes?: number;
}
