## Introduction

*easyrec* is an open-sourced and easy-to-use recommender system toolbox based on tensorflow 2.

## License

This project is released under the [MIT License](https://github.com/xu-zhiwei/easyrec/blob/main/LICENSE).

## Features

| model | source |
| ---- | ---- |
| Logisitic Regression (LR) | |
| Multi-layer Perceptron (MLP) | |
| Factorization Machine (FM) | Steffen Rendle. Factorization Machines. ICDM. 2010. |
| Deep Structured Semantic Model (DSSM) | Po-Sen Huang et al. Learning Deep Structured Semantic Models for Web Search using Clickthrough Data. CIKM. 2013. |
| Field-aware Factorization Machine (FFM) | Yuchin Juan et al. Field-aware Factorization Machines for CTR Prediction. RecSys. 2016. |
| Deep Crossing | Ying Shan et al. Deep Crossing: Web-Scale Modeling without Manually Crafted Combinatorial Features. KDD. 2016. |
| Factorization-machine supported Neural Network (FNN) | Weinan Zhang. Deep Learning over Multi-field Categorical Data – A Case Study on User Response Prediction. ECIR. 2016. |
| Product-based Neural Network (PNN) | Yanru Qu et al. Product-based Neural Networks for User Response Prediction. ICDM. 2016. |
| Wide & Deep | Heng-Tze Cheng et al. Wide & Deep Learning for Recommender Systems. RecSys. 2016. |
| Attentional Factorization Machine (AFM) | Jun Xiao et al. Attentional Factorization Machines:Learning the Weight of Feature Interactions via Attention Networks. arXiv. 2017. |
| Neural Factorization Machine (NFM) | Xiangnan He et al. Neural Factorization Machines for Sparse Predictive Analytics. SIGIR. 2017. |
| Neural Matrix Factorization (NMF) | Xiangnan He et al. Neural Collaborative Filtering. WWW. 2017. |
| Deep & Cross Network (DCN) | Ruoxi Wang et al. Deep & Cross Network for ad Click Predictions. ADKDD. 2017. |
| Deep Factorization Machine (DeepFM) | Huifeng Guo et al. DeepFM: A Factorization-Machine based Neural Network for CTR Prediction. arXiv. 2017. |
| Extreme Deep Factorization Machine (xDeepFM) | Jianxun Lian et al. xDeepFM: Combining Explicit and Implicit Feature Interactions for Recommender Systems. KDD. 2018. |
| Multi-gate Mixture-of-Experts (MMOE) | Jiaqi Ma et al. Modeling Task Relationships in Multi-task Learning with Multi-gate Mixture-of-Experts. KDD. 2018. |
| Automatic Feature Interaction (AutoInt) | AutoInt: Automatic Feature Interaction Learning via Self-Attentive Neural Networks. CIKM. 2019. |

## Installation

```
pip install easyrec-python
```

## Getting Started

Please refer to the [documentation](https://easyrec-python.readthedocs.io/en/latest/) for the basic usage of *easyrec*.
