import { Template } from 'cloudform-types';
interface Diff {
    kind: 'N' | 'E' | 'D' | 'A';
    path: string[];
    lhs?: any;
    rhs?: any;
    index?: number;
    item?: any;
}
export declare function check(currentCloudBackendDir: string, buildDirectory: string, rootStackName?: string): Promise<void>;
export declare function cantEditKeySchema(diff: Diff): void;
export declare function cantAddLSILater(diff: Diff): void;
export declare function cantEditGSIKeySchema(diff: Diff, currentBuild: DiffableProject, nextBuild: DiffableProject): void;
export declare function cantAddAndRemoveGSIAtSameTime(diff: Diff, currentBuild: DiffableProject, nextBuild: DiffableProject): void;
export declare function cantMutateMultipleGSIAtUpdateTime(diffs: Diff[], currentBuild: DiffableProject, nextBuild: DiffableProject): void;
export declare function cantEditLSIKeySchema(diff: Diff, currentBuild: DiffableProject, nextBuild: DiffableProject): void;
export declare function cantHaveMoreThan200Resources(diffs: Diff[], currentBuild: DiffableProject, nextBuild: DiffableProject): void;
interface DiffableProject {
    stacks: {
        [stackName: string]: Template;
    };
    root: Template;
}
export {};
//# sourceMappingURL=sanity-check.d.ts.map