# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AclArgs', 'Acl']

@pulumi.input_type
class AclArgs:
    def __init__(__self__, *,
                 acl: pulumi.Input[str]):
        """
        The set of arguments for constructing a Acl resource.
        :param pulumi.Input[str] acl: The JSON-based policy that defines which devices and users are allowed to connect in your network
        """
        pulumi.set(__self__, "acl", acl)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Input[str]:
        """
        The JSON-based policy that defines which devices and users are allowed to connect in your network
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: pulumi.Input[str]):
        pulumi.set(self, "acl", value)


@pulumi.input_type
class _AclState:
    def __init__(__self__, *,
                 acl: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Acl resources.
        :param pulumi.Input[str] acl: The JSON-based policy that defines which devices and users are allowed to connect in your network
        """
        if acl is not None:
            pulumi.set(__self__, "acl", acl)

    @property
    @pulumi.getter
    def acl(self) -> Optional[pulumi.Input[str]]:
        """
        The JSON-based policy that defines which devices and users are allowed to connect in your network
        """
        return pulumi.get(self, "acl")

    @acl.setter
    def acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "acl", value)


class Acl(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The acl resource allows you to configure a Tailscale ACL. See https://tailscale.com/kb/1018/acls for more information.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_tailscale as tailscale

        sample_acl = tailscale.Acl("sampleAcl", acl=json.dumps({
            "acls": [{
                "action": "accept",
                "users": ["*"],
                "ports": ["*:*"],
            }],
        }))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl: The JSON-based policy that defines which devices and users are allowed to connect in your network
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AclArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The acl resource allows you to configure a Tailscale ACL. See https://tailscale.com/kb/1018/acls for more information.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_tailscale as tailscale

        sample_acl = tailscale.Acl("sampleAcl", acl=json.dumps({
            "acls": [{
                "action": "accept",
                "users": ["*"],
                "ports": ["*:*"],
            }],
        }))
        ```

        :param str resource_name: The name of the resource.
        :param AclArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AclArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 acl: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AclArgs.__new__(AclArgs)

            if acl is None and not opts.urn:
                raise TypeError("Missing required property 'acl'")
            __props__.__dict__["acl"] = acl
        super(Acl, __self__).__init__(
            'tailscale:index/acl:Acl',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            acl: Optional[pulumi.Input[str]] = None) -> 'Acl':
        """
        Get an existing Acl resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] acl: The JSON-based policy that defines which devices and users are allowed to connect in your network
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AclState.__new__(_AclState)

        __props__.__dict__["acl"] = acl
        return Acl(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def acl(self) -> pulumi.Output[str]:
        """
        The JSON-based policy that defines which devices and users are allowed to connect in your network
        """
        return pulumi.get(self, "acl")

