# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'ApiArgs',
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'AuthProviderArgs',
    'AuthRequirementArgs',
    'AuthenticationRuleArgs',
    'AuthenticationArgs',
    'BackendRuleArgs',
    'BackendArgs',
    'BillingDestinationArgs',
    'BillingArgs',
    'BindingArgs',
    'ContextRuleArgs',
    'ContextArgs',
    'ControlArgs',
    'CustomErrorRuleArgs',
    'CustomErrorArgs',
    'CustomHttpPatternArgs',
    'DeleteServiceStrategyArgs',
    'DocumentationRuleArgs',
    'DocumentationArgs',
    'EndpointArgs',
    'EnumValueArgs',
    'EnumArgs',
    'ExprArgs',
    'FieldArgs',
    'HttpRuleArgs',
    'HttpArgs',
    'JwtLocationArgs',
    'LabelDescriptorArgs',
    'LogDescriptorArgs',
    'LoggingDestinationArgs',
    'LoggingArgs',
    'MethodArgs',
    'MetricDescriptorMetadataArgs',
    'MetricDescriptorArgs',
    'MetricRuleArgs',
    'MixinArgs',
    'MonitoredResourceDescriptorArgs',
    'MonitoringDestinationArgs',
    'MonitoringArgs',
    'OAuthRequirementsArgs',
    'OptionArgs',
    'PageArgs',
    'QuotaLimitArgs',
    'QuotaArgs',
    'SourceContextArgs',
    'SystemParameterRuleArgs',
    'SystemParametersArgs',
    'SystemParameterArgs',
    'TrafficPercentStrategyArgs',
    'TypeArgs',
    'UsageRuleArgs',
    'UsageArgs',
]

@pulumi.input_type
class ApiArgs:
    def __init__(__self__, *,
                 methods: Optional[pulumi.Input[Sequence[pulumi.Input['MethodArgs']]]] = None,
                 mixins: Optional[pulumi.Input[Sequence[pulumi.Input['MixinArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]] = None,
                 source_context: Optional[pulumi.Input['SourceContextArgs']] = None,
                 syntax: Optional[pulumi.Input['ApiSyntax']] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Api is a light-weight descriptor for an API Interface. Interfaces are also described as "protocol buffer services" in some contexts, such as by the "service" keyword in a .proto file, but they are different from API Services, which represent a concrete implementation of an interface as opposed to simply a description of methods and bindings. They are also sometimes simply referred to as "APIs" in other contexts, such as the name of this message itself. See https://cloud.google.com/apis/design/glossary for detailed terminology.
        :param pulumi.Input[Sequence[pulumi.Input['MethodArgs']]] methods: The methods of this interface, in unspecified order.
        :param pulumi.Input[Sequence[pulumi.Input['MixinArgs']]] mixins: Included interfaces. See Mixin.
        :param pulumi.Input[str] name: The fully qualified name of this interface, including package name followed by the interface's simple name.
        :param pulumi.Input[Sequence[pulumi.Input['OptionArgs']]] options: Any metadata attached to the interface.
        :param pulumi.Input['SourceContextArgs'] source_context: Source context for the protocol buffer service represented by this message.
        :param pulumi.Input['ApiSyntax'] syntax: The source syntax of the service.
        :param pulumi.Input[str] version: A version string for this interface. If specified, must have the form `major-version.minor-version`, as in `1.10`. If the minor version is omitted, it defaults to zero. If the entire version field is empty, the major version is derived from the package name, as outlined below. If the field is not empty, the version in the package name will be verified to be consistent with what is provided here. The versioning schema uses [semantic versioning](http://semver.org) where the major version number indicates a breaking change and the minor version an additive, non-breaking change. Both version numbers are signals to users what to expect from different versions, and should be carefully chosen based on the product plan. The major version is also reflected in the package name of the interface, which must end in `v`, as in `google.feature.v1`. For major versions 0 and 1, the suffix can be omitted. Zero major versions must only be used for experimental, non-GA interfaces. 
        """
        if methods is not None:
            pulumi.set(__self__, "methods", methods)
        if mixins is not None:
            pulumi.set(__self__, "mixins", mixins)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if source_context is not None:
            pulumi.set(__self__, "source_context", source_context)
        if syntax is not None:
            pulumi.set(__self__, "syntax", syntax)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def methods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MethodArgs']]]]:
        """
        The methods of this interface, in unspecified order.
        """
        return pulumi.get(self, "methods")

    @methods.setter
    def methods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MethodArgs']]]]):
        pulumi.set(self, "methods", value)

    @property
    @pulumi.getter
    def mixins(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MixinArgs']]]]:
        """
        Included interfaces. See Mixin.
        """
        return pulumi.get(self, "mixins")

    @mixins.setter
    def mixins(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MixinArgs']]]]):
        pulumi.set(self, "mixins", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified name of this interface, including package name followed by the interface's simple name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]]:
        """
        Any metadata attached to the interface.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="sourceContext")
    def source_context(self) -> Optional[pulumi.Input['SourceContextArgs']]:
        """
        Source context for the protocol buffer service represented by this message.
        """
        return pulumi.get(self, "source_context")

    @source_context.setter
    def source_context(self, value: Optional[pulumi.Input['SourceContextArgs']]):
        pulumi.set(self, "source_context", value)

    @property
    @pulumi.getter
    def syntax(self) -> Optional[pulumi.Input['ApiSyntax']]:
        """
        The source syntax of the service.
        """
        return pulumi.get(self, "syntax")

    @syntax.setter
    def syntax(self, value: Optional[pulumi.Input['ApiSyntax']]):
        pulumi.set(self, "syntax", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        A version string for this interface. If specified, must have the form `major-version.minor-version`, as in `1.10`. If the minor version is omitted, it defaults to zero. If the entire version field is empty, the major version is derived from the package name, as outlined below. If the field is not empty, the version in the package name will be verified to be consistent with what is provided here. The versioning schema uses [semantic versioning](http://semver.org) where the major version number indicates a breaking change and the minor version an additive, non-breaking change. Both version numbers are signals to users what to expect from different versions, and should be carefully chosen based on the product plan. The major version is also reflected in the package name of the interface, which must end in `v`, as in `google.feature.v1`. For major versions 0 and 1, the suffix can be omitted. Zero major versions must only be used for experimental, non-GA interfaces. 
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class AuthProviderArgs:
    def __init__(__self__, *,
                 audiences: Optional[pulumi.Input[str]] = None,
                 authorization_url: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 jwks_uri: Optional[pulumi.Input[str]] = None,
                 jwt_locations: Optional[pulumi.Input[Sequence[pulumi.Input['JwtLocationArgs']]]] = None):
        """
        Configuration for an authentication provider, including support for [JSON Web Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
        :param pulumi.Input[str] audiences: The list of JWT [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access. A JWT containing any of these audiences will be accepted. When this setting is absent, JWTs with audiences: - "https://[service.name]/[google.protobuf.Api.name]" - "https://[service.name]/" will be accepted. For example, if no audiences are in the setting, LibraryService API will accept JWTs with the following audiences: - https://library-example.googleapis.com/google.example.library.v1.LibraryService - https://library-example.googleapis.com/ Example: audiences: bookstore_android.apps.googleusercontent.com, bookstore_web.apps.googleusercontent.com
        :param pulumi.Input[str] authorization_url: Redirect URL if JWT token is required but not present or is expired. Implement authorizationUrl of securityDefinitions in OpenAPI spec.
        :param pulumi.Input[str] id: The unique identifier of the auth provider. It will be referred to by `AuthRequirement.provider_id`. Example: "bookstore_auth".
        :param pulumi.Input[str] issuer: Identifies the principal that issued the JWT. See https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1 Usually a URL or an email address. Example: https://securetoken.google.com Example: 1234567-compute@developer.gserviceaccount.com
        :param pulumi.Input[str] jwks_uri: URL of the provider's public key set to validate signature of the JWT. See [OpenID Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata). Optional if the key set document: - can be retrieved from [OpenID Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html) of the issuer. - can be inferred from the email domain of the issuer (e.g. a Google service account). Example: https://www.googleapis.com/oauth2/v1/certs
        :param pulumi.Input[Sequence[pulumi.Input['JwtLocationArgs']]] jwt_locations: Defines the locations to extract the JWT. For now it is only used by the Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations] (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations) JWT locations can be one of HTTP headers, URL query parameters or cookies. The rule is that the first match wins. If not specified, default to use following 3 locations: 1) Authorization: Bearer 2) x-goog-iap-jwt-assertion 3) access_token query parameter Default locations can be specified as followings: jwt_locations: - header: Authorization value_prefix: "Bearer " - header: x-goog-iap-jwt-assertion - query: access_token
        """
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)
        if authorization_url is not None:
            pulumi.set(__self__, "authorization_url", authorization_url)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if jwks_uri is not None:
            pulumi.set(__self__, "jwks_uri", jwks_uri)
        if jwt_locations is not None:
            pulumi.set(__self__, "jwt_locations", jwt_locations)

    @property
    @pulumi.getter
    def audiences(self) -> Optional[pulumi.Input[str]]:
        """
        The list of JWT [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access. A JWT containing any of these audiences will be accepted. When this setting is absent, JWTs with audiences: - "https://[service.name]/[google.protobuf.Api.name]" - "https://[service.name]/" will be accepted. For example, if no audiences are in the setting, LibraryService API will accept JWTs with the following audiences: - https://library-example.googleapis.com/google.example.library.v1.LibraryService - https://library-example.googleapis.com/ Example: audiences: bookstore_android.apps.googleusercontent.com, bookstore_web.apps.googleusercontent.com
        """
        return pulumi.get(self, "audiences")

    @audiences.setter
    def audiences(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audiences", value)

    @property
    @pulumi.getter(name="authorizationUrl")
    def authorization_url(self) -> Optional[pulumi.Input[str]]:
        """
        Redirect URL if JWT token is required but not present or is expired. Implement authorizationUrl of securityDefinitions in OpenAPI spec.
        """
        return pulumi.get(self, "authorization_url")

    @authorization_url.setter
    def authorization_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization_url", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique identifier of the auth provider. It will be referred to by `AuthRequirement.provider_id`. Example: "bookstore_auth".
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the principal that issued the JWT. See https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1 Usually a URL or an email address. Example: https://securetoken.google.com Example: 1234567-compute@developer.gserviceaccount.com
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter(name="jwksUri")
    def jwks_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the provider's public key set to validate signature of the JWT. See [OpenID Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata). Optional if the key set document: - can be retrieved from [OpenID Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html) of the issuer. - can be inferred from the email domain of the issuer (e.g. a Google service account). Example: https://www.googleapis.com/oauth2/v1/certs
        """
        return pulumi.get(self, "jwks_uri")

    @jwks_uri.setter
    def jwks_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jwks_uri", value)

    @property
    @pulumi.getter(name="jwtLocations")
    def jwt_locations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JwtLocationArgs']]]]:
        """
        Defines the locations to extract the JWT. For now it is only used by the Cloud Endpoints to store the OpenAPI extension [x-google-jwt-locations] (https://cloud.google.com/endpoints/docs/openapi/openapi-extensions#x-google-jwt-locations) JWT locations can be one of HTTP headers, URL query parameters or cookies. The rule is that the first match wins. If not specified, default to use following 3 locations: 1) Authorization: Bearer 2) x-goog-iap-jwt-assertion 3) access_token query parameter Default locations can be specified as followings: jwt_locations: - header: Authorization value_prefix: "Bearer " - header: x-goog-iap-jwt-assertion - query: access_token
        """
        return pulumi.get(self, "jwt_locations")

    @jwt_locations.setter
    def jwt_locations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JwtLocationArgs']]]]):
        pulumi.set(self, "jwt_locations", value)


@pulumi.input_type
class AuthRequirementArgs:
    def __init__(__self__, *,
                 audiences: Optional[pulumi.Input[str]] = None,
                 provider_id: Optional[pulumi.Input[str]] = None):
        """
        User-defined authentication requirements, including support for [JSON Web Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
        :param pulumi.Input[str] audiences: NOTE: This will be deprecated soon, once AuthProvider.audiences is implemented and accepted in all the runtime components. The list of JWT [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access. A JWT containing any of these audiences will be accepted. When this setting is absent, only JWTs with audience "https://Service_name/API_name" will be accepted. For example, if no audiences are in the setting, LibraryService API will only accept JWTs with the following audience "https://library-example.googleapis.com/google.example.library.v1.LibraryService". Example: audiences: bookstore_android.apps.googleusercontent.com, bookstore_web.apps.googleusercontent.com
        :param pulumi.Input[str] provider_id: id from authentication provider. Example: provider_id: bookstore_auth
        """
        if audiences is not None:
            pulumi.set(__self__, "audiences", audiences)
        if provider_id is not None:
            pulumi.set(__self__, "provider_id", provider_id)

    @property
    @pulumi.getter
    def audiences(self) -> Optional[pulumi.Input[str]]:
        """
        NOTE: This will be deprecated soon, once AuthProvider.audiences is implemented and accepted in all the runtime components. The list of JWT [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3). that are allowed to access. A JWT containing any of these audiences will be accepted. When this setting is absent, only JWTs with audience "https://Service_name/API_name" will be accepted. For example, if no audiences are in the setting, LibraryService API will only accept JWTs with the following audience "https://library-example.googleapis.com/google.example.library.v1.LibraryService". Example: audiences: bookstore_android.apps.googleusercontent.com, bookstore_web.apps.googleusercontent.com
        """
        return pulumi.get(self, "audiences")

    @audiences.setter
    def audiences(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audiences", value)

    @property
    @pulumi.getter(name="providerId")
    def provider_id(self) -> Optional[pulumi.Input[str]]:
        """
        id from authentication provider. Example: provider_id: bookstore_auth
        """
        return pulumi.get(self, "provider_id")

    @provider_id.setter
    def provider_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provider_id", value)


@pulumi.input_type
class AuthenticationRuleArgs:
    def __init__(__self__, *,
                 allow_without_credential: Optional[pulumi.Input[bool]] = None,
                 oauth: Optional[pulumi.Input['OAuthRequirementsArgs']] = None,
                 requirements: Optional[pulumi.Input[Sequence[pulumi.Input['AuthRequirementArgs']]]] = None,
                 selector: Optional[pulumi.Input[str]] = None):
        """
        Authentication rules for the service. By default, if a method has any authentication requirements, every request must include a valid credential matching one of the requirements. It's an error to include more than one kind of credential in a single request. If a method doesn't have any auth requirements, request credentials will be ignored.
        :param pulumi.Input[bool] allow_without_credential: If true, the service accepts API keys without any other credential. This flag only applies to HTTP and gRPC requests.
        :param pulumi.Input['OAuthRequirementsArgs'] oauth: The requirements for OAuth credentials.
        :param pulumi.Input[Sequence[pulumi.Input['AuthRequirementArgs']]] requirements: Requirements for additional authentication providers.
        :param pulumi.Input[str] selector: Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        if allow_without_credential is not None:
            pulumi.set(__self__, "allow_without_credential", allow_without_credential)
        if oauth is not None:
            pulumi.set(__self__, "oauth", oauth)
        if requirements is not None:
            pulumi.set(__self__, "requirements", requirements)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="allowWithoutCredential")
    def allow_without_credential(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the service accepts API keys without any other credential. This flag only applies to HTTP and gRPC requests.
        """
        return pulumi.get(self, "allow_without_credential")

    @allow_without_credential.setter
    def allow_without_credential(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_without_credential", value)

    @property
    @pulumi.getter
    def oauth(self) -> Optional[pulumi.Input['OAuthRequirementsArgs']]:
        """
        The requirements for OAuth credentials.
        """
        return pulumi.get(self, "oauth")

    @oauth.setter
    def oauth(self, value: Optional[pulumi.Input['OAuthRequirementsArgs']]):
        pulumi.set(self, "oauth", value)

    @property
    @pulumi.getter
    def requirements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthRequirementArgs']]]]:
        """
        Requirements for additional authentication providers.
        """
        return pulumi.get(self, "requirements")

    @requirements.setter
    def requirements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthRequirementArgs']]]]):
        pulumi.set(self, "requirements", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class AuthenticationArgs:
    def __init__(__self__, *,
                 providers: Optional[pulumi.Input[Sequence[pulumi.Input['AuthProviderArgs']]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationRuleArgs']]]] = None):
        """
        `Authentication` defines the authentication configuration for API methods provided by an API service. Example: name: calendar.googleapis.com authentication: providers: - id: google_calendar_auth jwks_uri: https://www.googleapis.com/oauth2/v1/certs issuer: https://securetoken.google.com rules: - selector: "*" requirements: provider_id: google_calendar_auth - selector: google.calendar.Delegate oauth: canonical_scopes: https://www.googleapis.com/auth/calendar.read
        :param pulumi.Input[Sequence[pulumi.Input['AuthProviderArgs']]] providers: Defines a set of authentication providers that a service supports.
        :param pulumi.Input[Sequence[pulumi.Input['AuthenticationRuleArgs']]] rules: A list of authentication rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        if providers is not None:
            pulumi.set(__self__, "providers", providers)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def providers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthProviderArgs']]]]:
        """
        Defines a set of authentication providers that a service supports.
        """
        return pulumi.get(self, "providers")

    @providers.setter
    def providers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthProviderArgs']]]]):
        pulumi.set(self, "providers", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationRuleArgs']]]]:
        """
        A list of authentication rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuthenticationRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class BackendRuleArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 deadline: Optional[pulumi.Input[float]] = None,
                 disable_auth: Optional[pulumi.Input[bool]] = None,
                 jwt_audience: Optional[pulumi.Input[str]] = None,
                 operation_deadline: Optional[pulumi.Input[float]] = None,
                 path_translation: Optional[pulumi.Input['BackendRulePathTranslation']] = None,
                 protocol: Optional[pulumi.Input[str]] = None,
                 selector: Optional[pulumi.Input[str]] = None):
        """
        A backend rule provides configuration for an individual API element.
        :param pulumi.Input[str] address: The address of the API backend. The scheme is used to determine the backend protocol and security. The following schemes are accepted: SCHEME PROTOCOL SECURITY http:// HTTP None https:// HTTP TLS grpc:// gRPC None grpcs:// gRPC TLS It is recommended to explicitly include a scheme. Leaving out the scheme may cause constrasting behaviors across platforms. If the port is unspecified, the default is: - 80 for schemes without TLS - 443 for schemes with TLS For HTTP backends, use protocol to specify the protocol version.
        :param pulumi.Input[float] deadline: The number of seconds to wait for a response from a request. The default varies based on the request protocol and deployment environment.
        :param pulumi.Input[bool] disable_auth: When disable_auth is true, a JWT ID token won't be generated and the original "Authorization" HTTP header will be preserved. If the header is used to carry the original token and is expected by the backend, this field must be set to true to preserve the header.
        :param pulumi.Input[str] jwt_audience: The JWT audience is used when generating a JWT ID token for the backend. This ID token will be added in the HTTP "authorization" header, and sent to the backend.
        :param pulumi.Input[float] operation_deadline: The number of seconds to wait for the completion of a long running operation. The default is no deadline.
        :param pulumi.Input[str] protocol: The protocol used for sending a request to the backend. The supported values are "http/1.1" and "h2". The default value is inferred from the scheme in the address field: SCHEME PROTOCOL http:// http/1.1 https:// http/1.1 grpc:// h2 grpcs:// h2 For secure HTTP backends (https://) that support HTTP/2, set this field to "h2" for improved performance. Configuring this field to non-default values is only supported for secure HTTP backends. This field will be ignored for all other backends. See https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids for more details on the supported values.
        :param pulumi.Input[str] selector: Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if deadline is not None:
            pulumi.set(__self__, "deadline", deadline)
        if disable_auth is not None:
            pulumi.set(__self__, "disable_auth", disable_auth)
        if jwt_audience is not None:
            pulumi.set(__self__, "jwt_audience", jwt_audience)
        if operation_deadline is not None:
            pulumi.set(__self__, "operation_deadline", operation_deadline)
        if path_translation is not None:
            pulumi.set(__self__, "path_translation", path_translation)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The address of the API backend. The scheme is used to determine the backend protocol and security. The following schemes are accepted: SCHEME PROTOCOL SECURITY http:// HTTP None https:// HTTP TLS grpc:// gRPC None grpcs:// gRPC TLS It is recommended to explicitly include a scheme. Leaving out the scheme may cause constrasting behaviors across platforms. If the port is unspecified, the default is: - 80 for schemes without TLS - 443 for schemes with TLS For HTTP backends, use protocol to specify the protocol version.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def deadline(self) -> Optional[pulumi.Input[float]]:
        """
        The number of seconds to wait for a response from a request. The default varies based on the request protocol and deployment environment.
        """
        return pulumi.get(self, "deadline")

    @deadline.setter
    def deadline(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "deadline", value)

    @property
    @pulumi.getter(name="disableAuth")
    def disable_auth(self) -> Optional[pulumi.Input[bool]]:
        """
        When disable_auth is true, a JWT ID token won't be generated and the original "Authorization" HTTP header will be preserved. If the header is used to carry the original token and is expected by the backend, this field must be set to true to preserve the header.
        """
        return pulumi.get(self, "disable_auth")

    @disable_auth.setter
    def disable_auth(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_auth", value)

    @property
    @pulumi.getter(name="jwtAudience")
    def jwt_audience(self) -> Optional[pulumi.Input[str]]:
        """
        The JWT audience is used when generating a JWT ID token for the backend. This ID token will be added in the HTTP "authorization" header, and sent to the backend.
        """
        return pulumi.get(self, "jwt_audience")

    @jwt_audience.setter
    def jwt_audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jwt_audience", value)

    @property
    @pulumi.getter(name="operationDeadline")
    def operation_deadline(self) -> Optional[pulumi.Input[float]]:
        """
        The number of seconds to wait for the completion of a long running operation. The default is no deadline.
        """
        return pulumi.get(self, "operation_deadline")

    @operation_deadline.setter
    def operation_deadline(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "operation_deadline", value)

    @property
    @pulumi.getter(name="pathTranslation")
    def path_translation(self) -> Optional[pulumi.Input['BackendRulePathTranslation']]:
        return pulumi.get(self, "path_translation")

    @path_translation.setter
    def path_translation(self, value: Optional[pulumi.Input['BackendRulePathTranslation']]):
        pulumi.set(self, "path_translation", value)

    @property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[str]]:
        """
        The protocol used for sending a request to the backend. The supported values are "http/1.1" and "h2". The default value is inferred from the scheme in the address field: SCHEME PROTOCOL http:// http/1.1 https:// http/1.1 grpc:// h2 grpcs:// h2 For secure HTTP backends (https://) that support HTTP/2, set this field to "h2" for improved performance. Configuring this field to non-default values is only supported for secure HTTP backends. This field will be ignored for all other backends. See https://www.iana.org/assignments/tls-extensiontype-values/tls-extensiontype-values.xhtml#alpn-protocol-ids for more details on the supported values.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protocol", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class BackendArgs:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['BackendRuleArgs']]]] = None):
        """
        `Backend` defines the backend configuration for a service.
        :param pulumi.Input[Sequence[pulumi.Input['BackendRuleArgs']]] rules: A list of API backend rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendRuleArgs']]]]:
        """
        A list of API backend rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class BillingDestinationArgs:
    def __init__(__self__, *,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 monitored_resource: Optional[pulumi.Input[str]] = None):
        """
        Configuration of a specific billing destination (Currently only support bill against consumer project).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] metrics: Names of the metrics to report to this billing destination. Each name must be defined in Service.metrics section.
        :param pulumi.Input[str] monitored_resource: The monitored resource type. The type must be defined in Service.monitored_resources section.
        """
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if monitored_resource is not None:
            pulumi.set(__self__, "monitored_resource", monitored_resource)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Names of the metrics to report to this billing destination. Each name must be defined in Service.metrics section.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter(name="monitoredResource")
    def monitored_resource(self) -> Optional[pulumi.Input[str]]:
        """
        The monitored resource type. The type must be defined in Service.monitored_resources section.
        """
        return pulumi.get(self, "monitored_resource")

    @monitored_resource.setter
    def monitored_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitored_resource", value)


@pulumi.input_type
class BillingArgs:
    def __init__(__self__, *,
                 consumer_destinations: Optional[pulumi.Input[Sequence[pulumi.Input['BillingDestinationArgs']]]] = None):
        """
        Billing related configuration of the service. The following example shows how to configure monitored resources and metrics for billing, `consumer_destinations` is the only supported destination and the monitored resources need at least one label key `cloud.googleapis.com/location` to indicate the location of the billing usage, using different monitored resources between monitoring and billing is recommended so they can be evolved independently: monitored_resources: - type: library.googleapis.com/billing_branch labels: - key: cloud.googleapis.com/location description: | Predefined label to support billing location restriction. - key: city description: | Custom label to define the city where the library branch is located in. - key: name description: Custom label to define the name of the library branch. metrics: - name: library.googleapis.com/book/borrowed_count metric_kind: DELTA value_type: INT64 unit: "1" billing: consumer_destinations: - monitored_resource: library.googleapis.com/billing_branch metrics: - library.googleapis.com/book/borrowed_count
        :param pulumi.Input[Sequence[pulumi.Input['BillingDestinationArgs']]] consumer_destinations: Billing configurations for sending metrics to the consumer project. There can be multiple consumer destinations per service, each one must have a different monitored resource type. A metric can be used in at most one consumer destination.
        """
        if consumer_destinations is not None:
            pulumi.set(__self__, "consumer_destinations", consumer_destinations)

    @property
    @pulumi.getter(name="consumerDestinations")
    def consumer_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BillingDestinationArgs']]]]:
        """
        Billing configurations for sending metrics to the consumer project. There can be multiple consumer destinations per service, each one must have a different monitored resource type. A metric can be used in at most one consumer destination.
        """
        return pulumi.get(self, "consumer_destinations")

    @consumer_destinations.setter
    def consumer_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BillingDestinationArgs']]]]):
        pulumi.set(self, "consumer_destinations", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class ContextRuleArgs:
    def __init__(__self__, *,
                 allowed_request_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allowed_response_extensions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 provided: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 requested: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 selector: Optional[pulumi.Input[str]] = None):
        """
        A context rule provides information about the context for an individual API element.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_request_extensions: A list of full type names or extension IDs of extensions allowed in grpc side channel from client to backend.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_response_extensions: A list of full type names or extension IDs of extensions allowed in grpc side channel from backend to client.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] provided: A list of full type names of provided contexts.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requested: A list of full type names of requested contexts.
        :param pulumi.Input[str] selector: Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        if allowed_request_extensions is not None:
            pulumi.set(__self__, "allowed_request_extensions", allowed_request_extensions)
        if allowed_response_extensions is not None:
            pulumi.set(__self__, "allowed_response_extensions", allowed_response_extensions)
        if provided is not None:
            pulumi.set(__self__, "provided", provided)
        if requested is not None:
            pulumi.set(__self__, "requested", requested)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="allowedRequestExtensions")
    def allowed_request_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of full type names or extension IDs of extensions allowed in grpc side channel from client to backend.
        """
        return pulumi.get(self, "allowed_request_extensions")

    @allowed_request_extensions.setter
    def allowed_request_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_request_extensions", value)

    @property
    @pulumi.getter(name="allowedResponseExtensions")
    def allowed_response_extensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of full type names or extension IDs of extensions allowed in grpc side channel from backend to client.
        """
        return pulumi.get(self, "allowed_response_extensions")

    @allowed_response_extensions.setter
    def allowed_response_extensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_response_extensions", value)

    @property
    @pulumi.getter
    def provided(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of full type names of provided contexts.
        """
        return pulumi.get(self, "provided")

    @provided.setter
    def provided(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "provided", value)

    @property
    @pulumi.getter
    def requested(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of full type names of requested contexts.
        """
        return pulumi.get(self, "requested")

    @requested.setter
    def requested(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "requested", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class ContextArgs:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['ContextRuleArgs']]]] = None):
        """
        `Context` defines which contexts an API requests. Example: context: rules: - selector: "*" requested: - google.rpc.context.ProjectContext - google.rpc.context.OriginContext The above specifies that all methods in the API request `google.rpc.context.ProjectContext` and `google.rpc.context.OriginContext`. Available context types are defined in package `google.rpc.context`. This also provides mechanism to allowlist any protobuf message extension that can be sent in grpc metadata using “x-goog-ext--bin” and “x-goog-ext--jspb” format. For example, list any service specific protobuf types that can appear in grpc metadata as follows in your yaml file: Example: context: rules: - selector: "google.example.library.v1.LibraryService.CreateBook" allowed_request_extensions: - google.foo.v1.NewExtension allowed_response_extensions: - google.foo.v1.NewExtension You can also specify extension ID instead of fully qualified extension name here.
        :param pulumi.Input[Sequence[pulumi.Input['ContextRuleArgs']]] rules: A list of RPC context rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ContextRuleArgs']]]]:
        """
        A list of RPC context rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ContextRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class ControlArgs:
    def __init__(__self__, *,
                 environment: Optional[pulumi.Input[str]] = None):
        """
        Selects and configures the service controller used by the service. The service controller handles two things: - **What is allowed:** for each API request, Chemist checks the project status, activation status, abuse status, billing status, service status, location restrictions, VPC Service Controls, SuperQuota, and other policies. - **What has happened:** for each API response, Chemist reports the telemetry data to analytics, auditing, billing, eventing, logging, monitoring, sawmill, and tracing. Chemist also accepts telemetry data not associated with API traffic, such as billing metrics. Example: control: environment: servicecontrol.googleapis.com
        :param pulumi.Input[str] environment: The service controller environment to use. If empty, no control plane feature (like quota and billing) will be enabled. The recommended value for most services is servicecontrol.googleapis.com
        """
        if environment is not None:
            pulumi.set(__self__, "environment", environment)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[str]]:
        """
        The service controller environment to use. If empty, no control plane feature (like quota and billing) will be enabled. The recommended value for most services is servicecontrol.googleapis.com
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "environment", value)


@pulumi.input_type
class CustomErrorRuleArgs:
    def __init__(__self__, *,
                 is_error_type: Optional[pulumi.Input[bool]] = None,
                 selector: Optional[pulumi.Input[str]] = None):
        """
        A custom error rule.
        :param pulumi.Input[bool] is_error_type: Mark this message as possible payload in error response. Otherwise, objects of this type will be filtered when they appear in error payload.
        :param pulumi.Input[str] selector: Selects messages to which this rule applies. Refer to selector for syntax details.
        """
        if is_error_type is not None:
            pulumi.set(__self__, "is_error_type", is_error_type)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="isErrorType")
    def is_error_type(self) -> Optional[pulumi.Input[bool]]:
        """
        Mark this message as possible payload in error response. Otherwise, objects of this type will be filtered when they appear in error payload.
        """
        return pulumi.get(self, "is_error_type")

    @is_error_type.setter
    def is_error_type(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_error_type", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Selects messages to which this rule applies. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class CustomErrorArgs:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['CustomErrorRuleArgs']]]] = None,
                 types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Customize service error responses. For example, list any service specific protobuf types that can appear in error detail lists of error responses. Example: custom_error: types: - google.foo.v1.CustomError - google.foo.v1.AnotherError
        :param pulumi.Input[Sequence[pulumi.Input['CustomErrorRuleArgs']]] rules: The list of custom error rules that apply to individual API messages. **NOTE:** All service configuration rules follow "last one wins" order.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] types: The list of custom error detail types, e.g. 'google.foo.v1.CustomError'.
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if types is not None:
            pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomErrorRuleArgs']]]]:
        """
        The list of custom error rules that apply to individual API messages. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomErrorRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter
    def types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of custom error detail types, e.g. 'google.foo.v1.CustomError'.
        """
        return pulumi.get(self, "types")

    @types.setter
    def types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "types", value)


@pulumi.input_type
class CustomHttpPatternArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None):
        """
        A custom pattern is used for defining custom HTTP verb.
        :param pulumi.Input[str] kind: The name of this custom HTTP verb.
        :param pulumi.Input[str] path: The path matched by this custom verb.
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[str]]:
        """
        The name of this custom HTTP verb.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path matched by this custom verb.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class DeleteServiceStrategyArgs:
    def __init__(__self__):
        """
        Strategy used to delete a service. This strategy is a placeholder only used by the system generated rollout to delete a service.
        """
        pass


@pulumi.input_type
class DocumentationRuleArgs:
    def __init__(__self__, *,
                 deprecation_description: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 selector: Optional[pulumi.Input[str]] = None):
        """
        A documentation rule provides information about individual API elements.
        :param pulumi.Input[str] deprecation_description: Deprecation description of the selected element(s). It can be provided if an element is marked as `deprecated`.
        :param pulumi.Input[str] description: Description of the selected proto element (e.g. a message, a method, a 'service' definition, or a field). Defaults to leading & trailing comments taken from the proto source definition of the proto element.
        :param pulumi.Input[str] selector: The selector is a comma-separated list of patterns for any element such as a method, a field, an enum value. Each pattern is a qualified name of the element which may end in "*", indicating a wildcard. Wildcards are only allowed at the end and for a whole component of the qualified name, i.e. "foo.*" is ok, but not "foo.b*" or "foo.*.bar". A wildcard will match one or more components. To specify a default for all applicable elements, the whole pattern "*" is used.
        """
        if deprecation_description is not None:
            pulumi.set(__self__, "deprecation_description", deprecation_description)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="deprecationDescription")
    def deprecation_description(self) -> Optional[pulumi.Input[str]]:
        """
        Deprecation description of the selected element(s). It can be provided if an element is marked as `deprecated`.
        """
        return pulumi.get(self, "deprecation_description")

    @deprecation_description.setter
    def deprecation_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deprecation_description", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the selected proto element (e.g. a message, a method, a 'service' definition, or a field). Defaults to leading & trailing comments taken from the proto source definition of the proto element.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        The selector is a comma-separated list of patterns for any element such as a method, a field, an enum value. Each pattern is a qualified name of the element which may end in "*", indicating a wildcard. Wildcards are only allowed at the end and for a whole component of the qualified name, i.e. "foo.*" is ok, but not "foo.b*" or "foo.*.bar". A wildcard will match one or more components. To specify a default for all applicable elements, the whole pattern "*" is used.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class DocumentationArgs:
    def __init__(__self__, *,
                 documentation_root_url: Optional[pulumi.Input[str]] = None,
                 overview: Optional[pulumi.Input[str]] = None,
                 pages: Optional[pulumi.Input[Sequence[pulumi.Input['PageArgs']]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['DocumentationRuleArgs']]]] = None,
                 service_root_url: Optional[pulumi.Input[str]] = None,
                 summary: Optional[pulumi.Input[str]] = None):
        """
        `Documentation` provides the information for describing a service. Example: documentation: summary: > The Google Calendar API gives access to most calendar features. pages: - name: Overview content: (== include google/foo/overview.md ==) - name: Tutorial content: (== include google/foo/tutorial.md ==) subpages; - name: Java content: (== include google/foo/tutorial_java.md ==) rules: - selector: google.calendar.Calendar.Get description: > ... - selector: google.calendar.Calendar.Put description: > ... Documentation is provided in markdown syntax. In addition to standard markdown features, definition lists, tables and fenced code blocks are supported. Section headers can be provided and are interpreted relative to the section nesting of the context where a documentation fragment is embedded. Documentation from the IDL is merged with documentation defined via the config at normalization time, where documentation provided by config rules overrides IDL provided. A number of constructs specific to the API platform are supported in documentation text. In order to reference a proto element, the following notation can be used: [fully.qualified.proto.name][] To override the display text used for the link, this can be used: [display text][fully.qualified.proto.name] Text can be excluded from doc using the following notation: (-- internal comment --) A few directives are available in documentation. Note that directives must appear on a single line to be properly identified. The `include` directive includes a markdown file from an external source: (== include path/to/file ==) The `resource_for` directive marks a message to be the resource of a collection in REST view. If it is not specified, tools attempt to infer the resource from the operations in a collection: (== resource_for v1.shelves.books ==) The directive `suppress_warning` does not directly affect documentation and is documented together with service config validation.
        :param pulumi.Input[str] documentation_root_url: The URL to the root of documentation.
        :param pulumi.Input[str] overview: Declares a single overview page. For example: documentation: summary: ... overview: (== include overview.md ==) This is a shortcut for the following declaration (using pages style): documentation: summary: ... pages: - name: Overview content: (== include overview.md ==) Note: you cannot specify both `overview` field and `pages` field.
        :param pulumi.Input[Sequence[pulumi.Input['PageArgs']]] pages: The top level pages for the documentation set.
        :param pulumi.Input[Sequence[pulumi.Input['DocumentationRuleArgs']]] rules: A list of documentation rules that apply to individual API elements. **NOTE:** All service configuration rules follow "last one wins" order.
        :param pulumi.Input[str] service_root_url: Specifies the service root url if the default one (the service name from the yaml file) is not suitable. This can be seen in any fully specified service urls as well as sections that show a base that other urls are relative to.
        :param pulumi.Input[str] summary: A short description of what the service does. The summary must be plain text. It becomes the overview of the service displayed in Google Cloud Console. NOTE: This field is equivalent to the standard field `description`.
        """
        if documentation_root_url is not None:
            pulumi.set(__self__, "documentation_root_url", documentation_root_url)
        if overview is not None:
            pulumi.set(__self__, "overview", overview)
        if pages is not None:
            pulumi.set(__self__, "pages", pages)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)
        if service_root_url is not None:
            pulumi.set(__self__, "service_root_url", service_root_url)
        if summary is not None:
            pulumi.set(__self__, "summary", summary)

    @property
    @pulumi.getter(name="documentationRootUrl")
    def documentation_root_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL to the root of documentation.
        """
        return pulumi.get(self, "documentation_root_url")

    @documentation_root_url.setter
    def documentation_root_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "documentation_root_url", value)

    @property
    @pulumi.getter
    def overview(self) -> Optional[pulumi.Input[str]]:
        """
        Declares a single overview page. For example: documentation: summary: ... overview: (== include overview.md ==) This is a shortcut for the following declaration (using pages style): documentation: summary: ... pages: - name: Overview content: (== include overview.md ==) Note: you cannot specify both `overview` field and `pages` field.
        """
        return pulumi.get(self, "overview")

    @overview.setter
    def overview(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overview", value)

    @property
    @pulumi.getter
    def pages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PageArgs']]]]:
        """
        The top level pages for the documentation set.
        """
        return pulumi.get(self, "pages")

    @pages.setter
    def pages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PageArgs']]]]):
        pulumi.set(self, "pages", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DocumentationRuleArgs']]]]:
        """
        A list of documentation rules that apply to individual API elements. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DocumentationRuleArgs']]]]):
        pulumi.set(self, "rules", value)

    @property
    @pulumi.getter(name="serviceRootUrl")
    def service_root_url(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the service root url if the default one (the service name from the yaml file) is not suitable. This can be seen in any fully specified service urls as well as sections that show a base that other urls are relative to.
        """
        return pulumi.get(self, "service_root_url")

    @service_root_url.setter
    def service_root_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_root_url", value)

    @property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[str]]:
        """
        A short description of what the service does. The summary must be plain text. It becomes the overview of the service displayed in Google Cloud Console. NOTE: This field is equivalent to the standard field `description`.
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "summary", value)


@pulumi.input_type
class EndpointArgs:
    def __init__(__self__, *,
                 allow_cors: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 target: Optional[pulumi.Input[str]] = None):
        """
        `Endpoint` describes a network address of a service that serves a set of APIs. It is commonly known as a service endpoint. A service may expose any number of service endpoints, and all service endpoints share the same service definition, such as quota limits and monitoring metrics. Example: type: google.api.Service name: library-example.googleapis.com endpoints: # Declares network address `https://library-example.googleapis.com` # for service `library-example.googleapis.com`. The `https` scheme # is implicit for all service endpoints. Other schemes may be # supported in the future. - name: library-example.googleapis.com allow_cors: false - name: content-staging-library-example.googleapis.com # Allows HTTP OPTIONS calls to be passed to the API frontend, for it # to decide whether the subsequent cross-origin request is allowed # to proceed. allow_cors: true
        :param pulumi.Input[bool] allow_cors: Allowing [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka cross-domain traffic, would allow the backends served from this endpoint to receive and respond to HTTP OPTIONS requests. The response will be used by the browser to determine whether the subsequent cross-origin request is allowed to proceed.
        :param pulumi.Input[str] name: The canonical name of this endpoint.
        :param pulumi.Input[str] target: The specification of an Internet routable address of API frontend that will handle requests to this [API Endpoint](https://cloud.google.com/apis/design/glossary). It should be either a valid IPv4 address or a fully-qualified domain name. For example, "8.8.8.8" or "myservice.appspot.com".
        """
        if allow_cors is not None:
            pulumi.set(__self__, "allow_cors", allow_cors)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @property
    @pulumi.getter(name="allowCors")
    def allow_cors(self) -> Optional[pulumi.Input[bool]]:
        """
        Allowing [CORS](https://en.wikipedia.org/wiki/Cross-origin_resource_sharing), aka cross-domain traffic, would allow the backends served from this endpoint to receive and respond to HTTP OPTIONS requests. The response will be used by the browser to determine whether the subsequent cross-origin request is allowed to proceed.
        """
        return pulumi.get(self, "allow_cors")

    @allow_cors.setter
    def allow_cors(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_cors", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The canonical name of this endpoint.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of an Internet routable address of API frontend that will handle requests to this [API Endpoint](https://cloud.google.com/apis/design/glossary). It should be either a valid IPv4 address or a fully-qualified domain name. For example, "8.8.8.8" or "myservice.appspot.com".
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target", value)


@pulumi.input_type
class EnumValueArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 number: Optional[pulumi.Input[int]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]] = None):
        """
        Enum value definition.
        :param pulumi.Input[str] name: Enum value name.
        :param pulumi.Input[int] number: Enum value number.
        :param pulumi.Input[Sequence[pulumi.Input['OptionArgs']]] options: Protocol buffer options.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number is not None:
            pulumi.set(__self__, "number", number)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Enum value name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[int]]:
        """
        Enum value number.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]]:
        """
        Protocol buffer options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]]):
        pulumi.set(self, "options", value)


@pulumi.input_type
class EnumArgs:
    def __init__(__self__, *,
                 enumvalue: Optional[pulumi.Input[Sequence[pulumi.Input['EnumValueArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]] = None,
                 source_context: Optional[pulumi.Input['SourceContextArgs']] = None,
                 syntax: Optional[pulumi.Input['EnumSyntax']] = None):
        """
        Enum type definition.
        :param pulumi.Input[Sequence[pulumi.Input['EnumValueArgs']]] enumvalue: Enum value definitions.
        :param pulumi.Input[str] name: Enum type name.
        :param pulumi.Input[Sequence[pulumi.Input['OptionArgs']]] options: Protocol buffer options.
        :param pulumi.Input['SourceContextArgs'] source_context: The source context.
        :param pulumi.Input['EnumSyntax'] syntax: The source syntax.
        """
        if enumvalue is not None:
            pulumi.set(__self__, "enumvalue", enumvalue)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if source_context is not None:
            pulumi.set(__self__, "source_context", source_context)
        if syntax is not None:
            pulumi.set(__self__, "syntax", syntax)

    @property
    @pulumi.getter
    def enumvalue(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnumValueArgs']]]]:
        """
        Enum value definitions.
        """
        return pulumi.get(self, "enumvalue")

    @enumvalue.setter
    def enumvalue(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnumValueArgs']]]]):
        pulumi.set(self, "enumvalue", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Enum type name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]]:
        """
        Protocol buffer options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="sourceContext")
    def source_context(self) -> Optional[pulumi.Input['SourceContextArgs']]:
        """
        The source context.
        """
        return pulumi.get(self, "source_context")

    @source_context.setter
    def source_context(self, value: Optional[pulumi.Input['SourceContextArgs']]):
        pulumi.set(self, "source_context", value)

    @property
    @pulumi.getter
    def syntax(self) -> Optional[pulumi.Input['EnumSyntax']]:
        """
        The source syntax.
        """
        return pulumi.get(self, "syntax")

    @syntax.setter
    def syntax(self, value: Optional[pulumi.Input['EnumSyntax']]):
        pulumi.set(self, "syntax", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class FieldArgs:
    def __init__(__self__, *,
                 cardinality: Optional[pulumi.Input['FieldCardinality']] = None,
                 default_value: Optional[pulumi.Input[str]] = None,
                 json_name: Optional[pulumi.Input[str]] = None,
                 kind: Optional[pulumi.Input['FieldKind']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 number: Optional[pulumi.Input[int]] = None,
                 oneof_index: Optional[pulumi.Input[int]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]] = None,
                 packed: Optional[pulumi.Input[bool]] = None,
                 type_url: Optional[pulumi.Input[str]] = None):
        """
        A single field of a message type.
        :param pulumi.Input['FieldCardinality'] cardinality: The field cardinality.
        :param pulumi.Input[str] default_value: The string value of the default value of this field. Proto2 syntax only.
        :param pulumi.Input[str] json_name: The field JSON name.
        :param pulumi.Input['FieldKind'] kind: The field type.
        :param pulumi.Input[str] name: The field name.
        :param pulumi.Input[int] number: The field number.
        :param pulumi.Input[int] oneof_index: The index of the field type in `Type.oneofs`, for message or enumeration types. The first type has index 1; zero means the type is not in the list.
        :param pulumi.Input[Sequence[pulumi.Input['OptionArgs']]] options: The protocol buffer options.
        :param pulumi.Input[bool] packed: Whether to use alternative packed wire representation.
        :param pulumi.Input[str] type_url: The field type URL, without the scheme, for message or enumeration types. Example: `"type.googleapis.com/google.protobuf.Timestamp"`.
        """
        if cardinality is not None:
            pulumi.set(__self__, "cardinality", cardinality)
        if default_value is not None:
            pulumi.set(__self__, "default_value", default_value)
        if json_name is not None:
            pulumi.set(__self__, "json_name", json_name)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number is not None:
            pulumi.set(__self__, "number", number)
        if oneof_index is not None:
            pulumi.set(__self__, "oneof_index", oneof_index)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if packed is not None:
            pulumi.set(__self__, "packed", packed)
        if type_url is not None:
            pulumi.set(__self__, "type_url", type_url)

    @property
    @pulumi.getter
    def cardinality(self) -> Optional[pulumi.Input['FieldCardinality']]:
        """
        The field cardinality.
        """
        return pulumi.get(self, "cardinality")

    @cardinality.setter
    def cardinality(self, value: Optional[pulumi.Input['FieldCardinality']]):
        pulumi.set(self, "cardinality", value)

    @property
    @pulumi.getter(name="defaultValue")
    def default_value(self) -> Optional[pulumi.Input[str]]:
        """
        The string value of the default value of this field. Proto2 syntax only.
        """
        return pulumi.get(self, "default_value")

    @default_value.setter
    def default_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_value", value)

    @property
    @pulumi.getter(name="jsonName")
    def json_name(self) -> Optional[pulumi.Input[str]]:
        """
        The field JSON name.
        """
        return pulumi.get(self, "json_name")

    @json_name.setter
    def json_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "json_name", value)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input['FieldKind']]:
        """
        The field type.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input['FieldKind']]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The field name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def number(self) -> Optional[pulumi.Input[int]]:
        """
        The field number.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter(name="oneofIndex")
    def oneof_index(self) -> Optional[pulumi.Input[int]]:
        """
        The index of the field type in `Type.oneofs`, for message or enumeration types. The first type has index 1; zero means the type is not in the list.
        """
        return pulumi.get(self, "oneof_index")

    @oneof_index.setter
    def oneof_index(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "oneof_index", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]]:
        """
        The protocol buffer options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def packed(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to use alternative packed wire representation.
        """
        return pulumi.get(self, "packed")

    @packed.setter
    def packed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "packed", value)

    @property
    @pulumi.getter(name="typeUrl")
    def type_url(self) -> Optional[pulumi.Input[str]]:
        """
        The field type URL, without the scheme, for message or enumeration types. Example: `"type.googleapis.com/google.protobuf.Timestamp"`.
        """
        return pulumi.get(self, "type_url")

    @type_url.setter
    def type_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type_url", value)


@pulumi.input_type
class HttpRuleArgs:
    def __init__(__self__, *,
                 additional_bindings: Optional[pulumi.Input[Sequence[pulumi.Input['HttpRuleArgs']]]] = None,
                 body: Optional[pulumi.Input[str]] = None,
                 custom: Optional[pulumi.Input['CustomHttpPatternArgs']] = None,
                 delete: Optional[pulumi.Input[str]] = None,
                 get: Optional[pulumi.Input[str]] = None,
                 patch: Optional[pulumi.Input[str]] = None,
                 post: Optional[pulumi.Input[str]] = None,
                 put: Optional[pulumi.Input[str]] = None,
                 response_body: Optional[pulumi.Input[str]] = None,
                 selector: Optional[pulumi.Input[str]] = None):
        """
        # gRPC Transcoding gRPC Transcoding is a feature for mapping between a gRPC method and one or more HTTP REST endpoints. It allows developers to build a single API service that supports both gRPC APIs and REST APIs. Many systems, including [Google APIs](https://github.com/googleapis/googleapis), [Cloud Endpoints](https://cloud.google.com/endpoints), [gRPC Gateway](https://github.com/grpc-ecosystem/grpc-gateway), and [Envoy](https://github.com/envoyproxy/envoy) proxy support this feature and use it for large scale production services. `HttpRule` defines the schema of the gRPC/REST mapping. The mapping specifies how different portions of the gRPC request message are mapped to the URL path, URL query parameters, and HTTP request body. It also controls how the gRPC response message is mapped to the HTTP response body. `HttpRule` is typically specified as an `google.api.http` annotation on the gRPC method. Each mapping specifies a URL path template and an HTTP method. The path template may refer to one or more fields in the gRPC request message, as long as each field is a non-repeated field with a primitive (non-message) type. The path template controls how fields of the request message are mapped to the URL path. Example: service Messaging { rpc GetMessage(GetMessageRequest) returns (Message) { option (google.api.http) = { get: "/v1/{name=messages/*}" }; } } message GetMessageRequest { string name = 1; // Mapped to URL path. } message Message { string text = 1; // The resource content. } This enables an HTTP REST to gRPC mapping as below: HTTP | gRPC -----|----- `GET /v1/messages/123456` | `GetMessage(name: "messages/123456")` Any fields in the request message which are not bound by the path template automatically become HTTP query parameters if there is no HTTP request body. For example: service Messaging { rpc GetMessage(GetMessageRequest) returns (Message) { option (google.api.http) = { get:"/v1/messages/{message_id}" }; } } message GetMessageRequest { message SubMessage { string subfield = 1; } string message_id = 1; // Mapped to URL path. int64 revision = 2; // Mapped to URL query parameter `revision`. SubMessage sub = 3; // Mapped to URL query parameter `sub.subfield`. } This enables a HTTP JSON to RPC mapping as below: HTTP | gRPC -----|----- `GET /v1/messages/123456?revision=2&sub.subfield=foo` | `GetMessage(message_id: "123456" revision: 2 sub: SubMessage(subfield: "foo"))` Note that fields which are mapped to URL query parameters must have a primitive type or a repeated primitive type or a non-repeated message type. In the case of a repeated type, the parameter can be repeated in the URL as `...?param=A&param=B`. In the case of a message type, each field of the message is mapped to a separate parameter, such as `...?foo.a=A&foo.b=B&foo.c=C`. For HTTP methods that allow a request body, the `body` field specifies the mapping. Consider a REST update method on the message resource collection: service Messaging { rpc UpdateMessage(UpdateMessageRequest) returns (Message) { option (google.api.http) = { patch: "/v1/messages/{message_id}" body: "message" }; } } message UpdateMessageRequest { string message_id = 1; // mapped to the URL Message message = 2; // mapped to the body } The following HTTP JSON to RPC mapping is enabled, where the representation of the JSON in the request body is determined by protos JSON encoding: HTTP | gRPC -----|----- `PATCH /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id: "123456" message { text: "Hi!" })` The special name `*` can be used in the body mapping to define that every field not bound by the path template should be mapped to the request body. This enables the following alternative definition of the update method: service Messaging { rpc UpdateMessage(Message) returns (Message) { option (google.api.http) = { patch: "/v1/messages/{message_id}" body: "*" }; } } message Message { string message_id = 1; string text = 2; } The following HTTP JSON to RPC mapping is enabled: HTTP | gRPC -----|----- `PATCH /v1/messages/123456 { "text": "Hi!" }` | `UpdateMessage(message_id: "123456" text: "Hi!")` Note that when using `*` in the body mapping, it is not possible to have HTTP parameters, as all fields not bound by the path end in the body. This makes this option more rarely used in practice when defining REST APIs. The common usage of `*` is in custom methods which don't use the URL at all for transferring data. It is possible to define multiple HTTP methods for one RPC by using the `additional_bindings` option. Example: service Messaging { rpc GetMessage(GetMessageRequest) returns (Message) { option (google.api.http) = { get: "/v1/messages/{message_id}" additional_bindings { get: "/v1/users/{user_id}/messages/{message_id}" } }; } } message GetMessageRequest { string message_id = 1; string user_id = 2; } This enables the following two alternative HTTP JSON to RPC mappings: HTTP | gRPC -----|----- `GET /v1/messages/123456` | `GetMessage(message_id: "123456")` `GET /v1/users/me/messages/123456` | `GetMessage(user_id: "me" message_id: "123456")` ## Rules for HTTP mapping 1. Leaf request fields (recursive expansion nested messages in the request message) are classified into three categories: - Fields referred by the path template. They are passed via the URL path. - Fields referred by the HttpRule.body. They are passed via the HTTP request body. - All other fields are passed via the URL query parameters, and the parameter name is the field path in the request message. A repeated field can be represented as multiple query parameters under the same name. 2. If HttpRule.body is "*", there is no URL query parameter, all fields are passed via URL path and HTTP request body. 3. If HttpRule.body is omitted, there is no HTTP request body, all fields are passed via URL path and URL query parameters. ### Path template syntax Template = "/" Segments [ Verb ] ; Segments = Segment { "/" Segment } ; Segment = "*" | "**" | LITERAL | Variable ; Variable = "{" FieldPath [ "=" Segments ] "}" ; FieldPath = IDENT { "." IDENT } ; Verb = ":" LITERAL ; The syntax `*` matches a single URL path segment. The syntax `**` matches zero or more URL path segments, which must be the last part of the URL path except the `Verb`. The syntax `Variable` matches part of the URL path as specified by its template. A variable template must not contain other variables. If a variable matches a single path segment, its template may be omitted, e.g. `{var}` is equivalent to `{var=*}`. The syntax `LITERAL` matches literal text in the URL path. If the `LITERAL` contains any reserved character, such characters should be percent-encoded before the matching. If a variable contains exactly one path segment, such as `"{var}"` or `"{var=*}"`, when such a variable is expanded into a URL path on the client side, all characters except `[-_.~0-9a-zA-Z]` are percent-encoded. The server side does the reverse decoding. Such variables show up in the [Discovery Document](https://developers.google.com/discovery/v1/reference/apis) as `{var}`. If a variable contains multiple path segments, such as `"{var=foo/*}"` or `"{var=**}"`, when such a variable is expanded into a URL path on the client side, all characters except `[-_.~/0-9a-zA-Z]` are percent-encoded. The server side does the reverse decoding, except "%2F" and "%2f" are left unchanged. Such variables show up in the [Discovery Document](https://developers.google.com/discovery/v1/reference/apis) as `{+var}`. ## Using gRPC API Service Configuration gRPC API Service Configuration (service config) is a configuration language for configuring a gRPC service to become a user-facing product. The service config is simply the YAML representation of the `google.api.Service` proto message. As an alternative to annotating your proto file, you can configure gRPC transcoding in your service config YAML files. You do this by specifying a `HttpRule` that maps the gRPC method to a REST endpoint, achieving the same effect as the proto annotation. This can be particularly useful if you have a proto that is reused in multiple services. Note that any transcoding specified in the service config will override any matching transcoding configuration in the proto. Example: http: rules: # Selects a gRPC method and applies HttpRule to it. - selector: example.v1.Messaging.GetMessage get: /v1/messages/{message_id}/{sub.subfield} ## Special notes When gRPC Transcoding is used to map a gRPC to JSON REST endpoints, the proto to JSON conversion must follow the [proto3 specification](https://developers.google.com/protocol-buffers/docs/proto3#json). While the single segment variable follows the semantics of [RFC 6570](https://tools.ietf.org/html/rfc6570) Section 3.2.2 Simple String Expansion, the multi segment variable **does not** follow RFC 6570 Section 3.2.3 Reserved Expansion. The reason is that the Reserved Expansion does not expand special characters like `?` and `#`, which would lead to invalid URLs. As the result, gRPC Transcoding uses a custom encoding for multi segment variables. The path variables **must not** refer to any repeated or mapped field, because client libraries are not capable of handling such variable expansion. The path variables **must not** capture the leading "/" character. The reason is that the most common use case "{var}" does not capture the leading "/" character. For consistency, all path variables must share the same behavior. Repeated message fields must not be mapped to URL query parameters, because no client library can support such complicated mapping. If an API needs to use a JSON array for request or response body, it can map the request or response body to a repeated field. However, some gRPC Transcoding implementations may not support this feature.
        :param pulumi.Input[Sequence[pulumi.Input['HttpRuleArgs']]] additional_bindings: Additional HTTP bindings for the selector. Nested bindings must not contain an `additional_bindings` field themselves (that is, the nesting may only be one level deep).
        :param pulumi.Input[str] body: The name of the request field whose value is mapped to the HTTP request body, or `*` for mapping all request fields not captured by the path pattern to the HTTP body, or omitted for not having any HTTP request body. NOTE: the referred field must be present at the top-level of the request message type.
        :param pulumi.Input['CustomHttpPatternArgs'] custom: The custom pattern is used for specifying an HTTP method that is not included in the `pattern` field, such as HEAD, or "*" to leave the HTTP method unspecified for this rule. The wild-card rule is useful for services that provide content to Web (HTML) clients.
        :param pulumi.Input[str] delete: Maps to HTTP DELETE. Used for deleting a resource.
        :param pulumi.Input[str] get: Maps to HTTP GET. Used for listing and getting information about resources.
        :param pulumi.Input[str] patch: Maps to HTTP PATCH. Used for updating a resource.
        :param pulumi.Input[str] post: Maps to HTTP POST. Used for creating a resource or performing an action.
        :param pulumi.Input[str] put: Maps to HTTP PUT. Used for replacing a resource.
        :param pulumi.Input[str] response_body: Optional. The name of the response field whose value is mapped to the HTTP response body. When omitted, the entire response message will be used as the HTTP response body. NOTE: The referred field must be present at the top-level of the response message type.
        :param pulumi.Input[str] selector: Selects a method to which this rule applies. Refer to selector for syntax details.
        """
        if additional_bindings is not None:
            pulumi.set(__self__, "additional_bindings", additional_bindings)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if custom is not None:
            pulumi.set(__self__, "custom", custom)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if get is not None:
            pulumi.set(__self__, "get", get)
        if patch is not None:
            pulumi.set(__self__, "patch", patch)
        if post is not None:
            pulumi.set(__self__, "post", post)
        if put is not None:
            pulumi.set(__self__, "put", put)
        if response_body is not None:
            pulumi.set(__self__, "response_body", response_body)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="additionalBindings")
    def additional_bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpRuleArgs']]]]:
        """
        Additional HTTP bindings for the selector. Nested bindings must not contain an `additional_bindings` field themselves (that is, the nesting may only be one level deep).
        """
        return pulumi.get(self, "additional_bindings")

    @additional_bindings.setter
    def additional_bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpRuleArgs']]]]):
        pulumi.set(self, "additional_bindings", value)

    @property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the request field whose value is mapped to the HTTP request body, or `*` for mapping all request fields not captured by the path pattern to the HTTP body, or omitted for not having any HTTP request body. NOTE: the referred field must be present at the top-level of the request message type.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "body", value)

    @property
    @pulumi.getter
    def custom(self) -> Optional[pulumi.Input['CustomHttpPatternArgs']]:
        """
        The custom pattern is used for specifying an HTTP method that is not included in the `pattern` field, such as HEAD, or "*" to leave the HTTP method unspecified for this rule. The wild-card rule is useful for services that provide content to Web (HTML) clients.
        """
        return pulumi.get(self, "custom")

    @custom.setter
    def custom(self, value: Optional[pulumi.Input['CustomHttpPatternArgs']]):
        pulumi.set(self, "custom", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[str]]:
        """
        Maps to HTTP DELETE. Used for deleting a resource.
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter
    def get(self) -> Optional[pulumi.Input[str]]:
        """
        Maps to HTTP GET. Used for listing and getting information about resources.
        """
        return pulumi.get(self, "get")

    @get.setter
    def get(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "get", value)

    @property
    @pulumi.getter
    def patch(self) -> Optional[pulumi.Input[str]]:
        """
        Maps to HTTP PATCH. Used for updating a resource.
        """
        return pulumi.get(self, "patch")

    @patch.setter
    def patch(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "patch", value)

    @property
    @pulumi.getter
    def post(self) -> Optional[pulumi.Input[str]]:
        """
        Maps to HTTP POST. Used for creating a resource or performing an action.
        """
        return pulumi.get(self, "post")

    @post.setter
    def post(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "post", value)

    @property
    @pulumi.getter
    def put(self) -> Optional[pulumi.Input[str]]:
        """
        Maps to HTTP PUT. Used for replacing a resource.
        """
        return pulumi.get(self, "put")

    @put.setter
    def put(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "put", value)

    @property
    @pulumi.getter(name="responseBody")
    def response_body(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of the response field whose value is mapped to the HTTP response body. When omitted, the entire response message will be used as the HTTP response body. NOTE: The referred field must be present at the top-level of the response message type.
        """
        return pulumi.get(self, "response_body")

    @response_body.setter
    def response_body(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_body", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Selects a method to which this rule applies. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class HttpArgs:
    def __init__(__self__, *,
                 fully_decode_reserved_expansion: Optional[pulumi.Input[bool]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['HttpRuleArgs']]]] = None):
        """
        Defines the HTTP configuration for an API service. It contains a list of HttpRule, each specifying the mapping of an RPC method to one or more HTTP REST API methods.
        :param pulumi.Input[bool] fully_decode_reserved_expansion: When set to true, URL path parameters will be fully URI-decoded except in cases of single segment matches in reserved expansion, where "%2F" will be left encoded. The default behavior is to not decode RFC 6570 reserved characters in multi segment matches.
        :param pulumi.Input[Sequence[pulumi.Input['HttpRuleArgs']]] rules: A list of HTTP configuration rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        if fully_decode_reserved_expansion is not None:
            pulumi.set(__self__, "fully_decode_reserved_expansion", fully_decode_reserved_expansion)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="fullyDecodeReservedExpansion")
    def fully_decode_reserved_expansion(self) -> Optional[pulumi.Input[bool]]:
        """
        When set to true, URL path parameters will be fully URI-decoded except in cases of single segment matches in reserved expansion, where "%2F" will be left encoded. The default behavior is to not decode RFC 6570 reserved characters in multi segment matches.
        """
        return pulumi.get(self, "fully_decode_reserved_expansion")

    @fully_decode_reserved_expansion.setter
    def fully_decode_reserved_expansion(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "fully_decode_reserved_expansion", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['HttpRuleArgs']]]]:
        """
        A list of HTTP configuration rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['HttpRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class JwtLocationArgs:
    def __init__(__self__, *,
                 cookie: Optional[pulumi.Input[str]] = None,
                 header: Optional[pulumi.Input[str]] = None,
                 query: Optional[pulumi.Input[str]] = None,
                 value_prefix: Optional[pulumi.Input[str]] = None):
        """
        Specifies a location to extract JWT from an API request.
        :param pulumi.Input[str] cookie: Specifies cookie name to extract JWT token.
        :param pulumi.Input[str] header: Specifies HTTP header name to extract JWT token.
        :param pulumi.Input[str] query: Specifies URL query parameter name to extract JWT token.
        :param pulumi.Input[str] value_prefix: The value prefix. The value format is "value_prefix{token}" Only applies to "in" header type. Must be empty for "in" query type. If not empty, the header value has to match (case sensitive) this prefix. If not matched, JWT will not be extracted. If matched, JWT will be extracted after the prefix is removed. For example, for "Authorization: Bearer {JWT}", value_prefix="Bearer " with a space at the end.
        """
        if cookie is not None:
            pulumi.set(__self__, "cookie", cookie)
        if header is not None:
            pulumi.set(__self__, "header", header)
        if query is not None:
            pulumi.set(__self__, "query", query)
        if value_prefix is not None:
            pulumi.set(__self__, "value_prefix", value_prefix)

    @property
    @pulumi.getter
    def cookie(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies cookie name to extract JWT token.
        """
        return pulumi.get(self, "cookie")

    @cookie.setter
    def cookie(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cookie", value)

    @property
    @pulumi.getter
    def header(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies HTTP header name to extract JWT token.
        """
        return pulumi.get(self, "header")

    @header.setter
    def header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "header", value)

    @property
    @pulumi.getter
    def query(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies URL query parameter name to extract JWT token.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="valuePrefix")
    def value_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        The value prefix. The value format is "value_prefix{token}" Only applies to "in" header type. Must be empty for "in" query type. If not empty, the header value has to match (case sensitive) this prefix. If not matched, JWT will not be extracted. If matched, JWT will be extracted after the prefix is removed. For example, for "Authorization: Bearer {JWT}", value_prefix="Bearer " with a space at the end.
        """
        return pulumi.get(self, "value_prefix")

    @value_prefix.setter
    def value_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value_prefix", value)


@pulumi.input_type
class LabelDescriptorArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 value_type: Optional[pulumi.Input['LabelDescriptorValueType']] = None):
        """
        A description of a label.
        :param pulumi.Input[str] description: A human-readable description for the label.
        :param pulumi.Input[str] key: The label key.
        :param pulumi.Input['LabelDescriptorValueType'] value_type: The type of data that can be assigned to the label.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description for the label.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The label key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[pulumi.Input['LabelDescriptorValueType']]:
        """
        The type of data that can be assigned to the label.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[pulumi.Input['LabelDescriptorValueType']]):
        pulumi.set(self, "value_type", value)


@pulumi.input_type
class LogDescriptorArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['LabelDescriptorArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        A description of a log type. Example in YAML format: - name: library.googleapis.com/activity_history description: The history of borrowing and returning library items. display_name: Activity labels: - key: /customer_id description: Identifier of a library customer
        :param pulumi.Input[str] description: A human-readable description of this log. This information appears in the documentation and can contain details.
        :param pulumi.Input[str] display_name: The human-readable name for this log. This information appears on the user interface and should be concise.
        :param pulumi.Input[Sequence[pulumi.Input['LabelDescriptorArgs']]] labels: The set of labels that are available to describe a specific log entry. Runtime requests that contain labels not specified here are considered invalid.
        :param pulumi.Input[str] name: The name of the log. It must be less than 512 characters long and can include the following characters: upper- and lower-case alphanumeric characters [A-Za-z0-9], and punctuation characters including slash, underscore, hyphen, period [/_-.].
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of this log. This information appears in the documentation and can contain details.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The human-readable name for this log. This information appears on the user interface and should be concise.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LabelDescriptorArgs']]]]:
        """
        The set of labels that are available to describe a specific log entry. Runtime requests that contain labels not specified here are considered invalid.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LabelDescriptorArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the log. It must be less than 512 characters long and can include the following characters: upper- and lower-case alphanumeric characters [A-Za-z0-9], and punctuation characters including slash, underscore, hyphen, period [/_-.].
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class LoggingDestinationArgs:
    def __init__(__self__, *,
                 logs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 monitored_resource: Optional[pulumi.Input[str]] = None):
        """
        Configuration of a specific logging destination (the producer project or the consumer project).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] logs: Names of the logs to be sent to this destination. Each name must be defined in the Service.logs section. If the log name is not a domain scoped name, it will be automatically prefixed with the service name followed by "/".
        :param pulumi.Input[str] monitored_resource: The monitored resource type. The type must be defined in the Service.monitored_resources section.
        """
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if monitored_resource is not None:
            pulumi.set(__self__, "monitored_resource", monitored_resource)

    @property
    @pulumi.getter
    def logs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Names of the logs to be sent to this destination. Each name must be defined in the Service.logs section. If the log name is not a domain scoped name, it will be automatically prefixed with the service name followed by "/".
        """
        return pulumi.get(self, "logs")

    @logs.setter
    def logs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "logs", value)

    @property
    @pulumi.getter(name="monitoredResource")
    def monitored_resource(self) -> Optional[pulumi.Input[str]]:
        """
        The monitored resource type. The type must be defined in the Service.monitored_resources section.
        """
        return pulumi.get(self, "monitored_resource")

    @monitored_resource.setter
    def monitored_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitored_resource", value)


@pulumi.input_type
class LoggingArgs:
    def __init__(__self__, *,
                 consumer_destinations: Optional[pulumi.Input[Sequence[pulumi.Input['LoggingDestinationArgs']]]] = None,
                 producer_destinations: Optional[pulumi.Input[Sequence[pulumi.Input['LoggingDestinationArgs']]]] = None):
        """
        Logging configuration of the service. The following example shows how to configure logs to be sent to the producer and consumer projects. In the example, the `activity_history` log is sent to both the producer and consumer projects, whereas the `purchase_history` log is only sent to the producer project. monitored_resources: - type: library.googleapis.com/branch labels: - key: /city description: The city where the library branch is located in. - key: /name description: The name of the branch. logs: - name: activity_history labels: - key: /customer_id - name: purchase_history logging: producer_destinations: - monitored_resource: library.googleapis.com/branch logs: - activity_history - purchase_history consumer_destinations: - monitored_resource: library.googleapis.com/branch logs: - activity_history
        :param pulumi.Input[Sequence[pulumi.Input['LoggingDestinationArgs']]] consumer_destinations: Logging configurations for sending logs to the consumer project. There can be multiple consumer destinations, each one must have a different monitored resource type. A log can be used in at most one consumer destination.
        :param pulumi.Input[Sequence[pulumi.Input['LoggingDestinationArgs']]] producer_destinations: Logging configurations for sending logs to the producer project. There can be multiple producer destinations, each one must have a different monitored resource type. A log can be used in at most one producer destination.
        """
        if consumer_destinations is not None:
            pulumi.set(__self__, "consumer_destinations", consumer_destinations)
        if producer_destinations is not None:
            pulumi.set(__self__, "producer_destinations", producer_destinations)

    @property
    @pulumi.getter(name="consumerDestinations")
    def consumer_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoggingDestinationArgs']]]]:
        """
        Logging configurations for sending logs to the consumer project. There can be multiple consumer destinations, each one must have a different monitored resource type. A log can be used in at most one consumer destination.
        """
        return pulumi.get(self, "consumer_destinations")

    @consumer_destinations.setter
    def consumer_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoggingDestinationArgs']]]]):
        pulumi.set(self, "consumer_destinations", value)

    @property
    @pulumi.getter(name="producerDestinations")
    def producer_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LoggingDestinationArgs']]]]:
        """
        Logging configurations for sending logs to the producer project. There can be multiple producer destinations, each one must have a different monitored resource type. A log can be used in at most one producer destination.
        """
        return pulumi.get(self, "producer_destinations")

    @producer_destinations.setter
    def producer_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LoggingDestinationArgs']]]]):
        pulumi.set(self, "producer_destinations", value)


@pulumi.input_type
class MethodArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]] = None,
                 request_streaming: Optional[pulumi.Input[bool]] = None,
                 request_type_url: Optional[pulumi.Input[str]] = None,
                 response_streaming: Optional[pulumi.Input[bool]] = None,
                 response_type_url: Optional[pulumi.Input[str]] = None,
                 syntax: Optional[pulumi.Input['MethodSyntax']] = None):
        """
        Method represents a method of an API interface.
        :param pulumi.Input[str] name: The simple name of this method.
        :param pulumi.Input[Sequence[pulumi.Input['OptionArgs']]] options: Any metadata attached to the method.
        :param pulumi.Input[bool] request_streaming: If true, the request is streamed.
        :param pulumi.Input[str] request_type_url: A URL of the input message type.
        :param pulumi.Input[bool] response_streaming: If true, the response is streamed.
        :param pulumi.Input[str] response_type_url: The URL of the output message type.
        :param pulumi.Input['MethodSyntax'] syntax: The source syntax of this method.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if request_streaming is not None:
            pulumi.set(__self__, "request_streaming", request_streaming)
        if request_type_url is not None:
            pulumi.set(__self__, "request_type_url", request_type_url)
        if response_streaming is not None:
            pulumi.set(__self__, "response_streaming", response_streaming)
        if response_type_url is not None:
            pulumi.set(__self__, "response_type_url", response_type_url)
        if syntax is not None:
            pulumi.set(__self__, "syntax", syntax)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The simple name of this method.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]]:
        """
        Any metadata attached to the method.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="requestStreaming")
    def request_streaming(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the request is streamed.
        """
        return pulumi.get(self, "request_streaming")

    @request_streaming.setter
    def request_streaming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "request_streaming", value)

    @property
    @pulumi.getter(name="requestTypeUrl")
    def request_type_url(self) -> Optional[pulumi.Input[str]]:
        """
        A URL of the input message type.
        """
        return pulumi.get(self, "request_type_url")

    @request_type_url.setter
    def request_type_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_type_url", value)

    @property
    @pulumi.getter(name="responseStreaming")
    def response_streaming(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the response is streamed.
        """
        return pulumi.get(self, "response_streaming")

    @response_streaming.setter
    def response_streaming(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "response_streaming", value)

    @property
    @pulumi.getter(name="responseTypeUrl")
    def response_type_url(self) -> Optional[pulumi.Input[str]]:
        """
        The URL of the output message type.
        """
        return pulumi.get(self, "response_type_url")

    @response_type_url.setter
    def response_type_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "response_type_url", value)

    @property
    @pulumi.getter
    def syntax(self) -> Optional[pulumi.Input['MethodSyntax']]:
        """
        The source syntax of this method.
        """
        return pulumi.get(self, "syntax")

    @syntax.setter
    def syntax(self, value: Optional[pulumi.Input['MethodSyntax']]):
        pulumi.set(self, "syntax", value)


@pulumi.input_type
class MetricDescriptorMetadataArgs:
    def __init__(__self__, *,
                 ingest_delay: Optional[pulumi.Input[str]] = None,
                 launch_stage: Optional[pulumi.Input['MetricDescriptorMetadataLaunchStage']] = None,
                 sample_period: Optional[pulumi.Input[str]] = None):
        """
        Additional annotations that can be used to guide the usage of a metric.
        :param pulumi.Input[str] ingest_delay: The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors.
        :param pulumi.Input['MetricDescriptorMetadataLaunchStage'] launch_stage: Deprecated. Must use the MetricDescriptor.launch_stage instead.
        :param pulumi.Input[str] sample_period: The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period.
        """
        if ingest_delay is not None:
            pulumi.set(__self__, "ingest_delay", ingest_delay)
        if launch_stage is not None:
            warnings.warn("""Deprecated. Must use the MetricDescriptor.launch_stage instead.""", DeprecationWarning)
            pulumi.log.warn("""launch_stage is deprecated: Deprecated. Must use the MetricDescriptor.launch_stage instead.""")
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if sample_period is not None:
            pulumi.set(__self__, "sample_period", sample_period)

    @property
    @pulumi.getter(name="ingestDelay")
    def ingest_delay(self) -> Optional[pulumi.Input[str]]:
        """
        The delay of data points caused by ingestion. Data points older than this age are guaranteed to be ingested and available to be read, excluding data loss due to errors.
        """
        return pulumi.get(self, "ingest_delay")

    @ingest_delay.setter
    def ingest_delay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ingest_delay", value)

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input['MetricDescriptorMetadataLaunchStage']]:
        """
        Deprecated. Must use the MetricDescriptor.launch_stage instead.
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input['MetricDescriptorMetadataLaunchStage']]):
        pulumi.set(self, "launch_stage", value)

    @property
    @pulumi.getter(name="samplePeriod")
    def sample_period(self) -> Optional[pulumi.Input[str]]:
        """
        The sampling period of metric data points. For metrics which are written periodically, consecutive data points are stored at this time interval, excluding data loss due to errors. Metrics with a higher granularity have a smaller sampling period.
        """
        return pulumi.get(self, "sample_period")

    @sample_period.setter
    def sample_period(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sample_period", value)


@pulumi.input_type
class MetricDescriptorArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 labels: Optional[pulumi.Input[Sequence[pulumi.Input['LabelDescriptorArgs']]]] = None,
                 launch_stage: Optional[pulumi.Input['MetricDescriptorLaunchStage']] = None,
                 metadata: Optional[pulumi.Input['MetricDescriptorMetadataArgs']] = None,
                 metric_kind: Optional[pulumi.Input['MetricDescriptorMetricKind']] = None,
                 monitored_resource_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 value_type: Optional[pulumi.Input['MetricDescriptorValueType']] = None):
        """
        Defines a metric type and its schema. Once a metric descriptor is created, deleting or altering it stops data collection and makes the metric type's existing data unusable. 
        :param pulumi.Input[str] description: A detailed description of the metric, which can be used in documentation.
        :param pulumi.Input[str] display_name: A concise name for the metric, which can be displayed in user interfaces. Use sentence case without an ending period, for example "Request count". This field is optional but it is recommended to be set for any metrics associated with user-visible concepts, such as Quota.
        :param pulumi.Input[Sequence[pulumi.Input['LabelDescriptorArgs']]] labels: The set of labels that can be used to describe a specific instance of this metric type. For example, the `appengine.googleapis.com/http/server/response_latencies` metric type has a label for the HTTP response code, `response_code`, so you can look at latencies for successful responses or just for responses that failed.
        :param pulumi.Input['MetricDescriptorLaunchStage'] launch_stage: Optional. The launch stage of the metric definition.
        :param pulumi.Input['MetricDescriptorMetadataArgs'] metadata: Optional. Metadata which can be used to guide usage of the metric.
        :param pulumi.Input['MetricDescriptorMetricKind'] metric_kind: Whether the metric records instantaneous values, changes to a value, etc. Some combinations of `metric_kind` and `value_type` might not be supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] monitored_resource_types: Read-only. If present, then a time series, which is identified partially by a metric type and a MonitoredResourceDescriptor, that is associated with this metric type can only be associated with one of the monitored resource types listed here.
        :param pulumi.Input[str] name: The resource name of the metric descriptor.
        :param pulumi.Input[str] type: The metric type, including its DNS name prefix. The type is not URL-encoded. All user-defined metric types have the DNS name `custom.googleapis.com` or `external.googleapis.com`. Metric types should use a natural hierarchical grouping. For example: "custom.googleapis.com/invoice/paid/amount" "external.googleapis.com/prometheus/up" "appengine.googleapis.com/http/server/response_latencies"
        :param pulumi.Input[str] unit: The units in which the metric value is reported. It is only applicable if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit` defines the representation of the stored metric values. Different systems might scale the values to be more easily displayed (so a value of `0.02kBy` _might_ be displayed as `20By`, and a value of `3523kBy` _might_ be displayed as `3.5MBy`). However, if the `unit` is `kBy`, then the value of the metric is always in thousands of bytes, no matter how it might be displayed. If you want a custom metric to record the exact number of CPU-seconds used by a job, you can create an `INT64 CUMULATIVE` metric whose `unit` is `s{CPU}` (or equivalently `1s{CPU}` or just `s`). If the job uses 12,005 CPU-seconds, then the value is written as `12005`. Alternatively, if you want a custom metric to record data in a more granular way, you can create a `DOUBLE CUMULATIVE` metric whose `unit` is `ks{CPU}`, and then write the value `12.005` (which is `12005/1000`), or use `Kis{CPU}` and write `11.723` (which is `12005/1024`). The supported units are a subset of [The Unified Code for Units of Measure](https://unitsofmeasure.org/ucum.html) standard: **Basic units (UNIT)** * `bit` bit * `By` byte * `s` second * `min` minute * `h` hour * `d` day * `1` dimensionless **Prefixes (PREFIX)** * `k` kilo (10^3) * `M` mega (10^6) * `G` giga (10^9) * `T` tera (10^12) * `P` peta (10^15) * `E` exa (10^18) * `Z` zetta (10^21) * `Y` yotta (10^24) * `m` milli (10^-3) * `u` micro (10^-6) * `n` nano (10^-9) * `p` pico (10^-12) * `f` femto (10^-15) * `a` atto (10^-18) * `z` zepto (10^-21) * `y` yocto (10^-24) * `Ki` kibi (2^10) * `Mi` mebi (2^20) * `Gi` gibi (2^30) * `Ti` tebi (2^40) * `Pi` pebi (2^50) **Grammar** The grammar also includes these connectors: * `/` division or ratio (as an infix operator). For examples, `kBy/{email}` or `MiBy/10ms` (although you should almost never have `/s` in a metric `unit`; rates should always be computed at query time from the underlying cumulative or delta value). * `.` multiplication or composition (as an infix operator). For examples, `GBy.d` or `k{watt}.h`. The grammar for a unit is as follows: Expression = Component { "." Component } { "/" Component } ; Component = ( [ PREFIX ] UNIT | "%" ) [ Annotation ] | Annotation | "1" ; Annotation = "{" NAME "}" ; Notes: * `Annotation` is just a comment if it follows a `UNIT`. If the annotation is used alone, then the unit is equivalent to `1`. For examples, `{request}/s == 1/s`, `By{transmitted}/s == By/s`. * `NAME` is a sequence of non-blank printable ASCII characters not containing `{` or `}`. * `1` represents a unitary [dimensionless unit](https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such as in `1/s`. It is typically used when none of the basic units are appropriate. For example, "new users per day" can be represented as `1/d` or `{new-users}/d` (and a metric value `5` would mean "5 new users). Alternatively, "thousands of page views per day" would be represented as `1000/d` or `k1/d` or `k{page_views}/d` (and a metric value of `5.3` would mean "5300 page views per day"). * `%` represents dimensionless value of 1/100, and annotates values giving a percentage (so the metric values are typically in the range of 0..100, and a metric value `3` means "3 percent"). * `10^2.%` indicates a metric contains a ratio, typically in the range 0..1, that will be multiplied by 100 and displayed as a percentage (so a metric value `0.03` means "3 percent").
        :param pulumi.Input['MetricDescriptorValueType'] value_type: Whether the measurement is an integer, a floating-point number, etc. Some combinations of `metric_kind` and `value_type` might not be supported.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if metric_kind is not None:
            pulumi.set(__self__, "metric_kind", metric_kind)
        if monitored_resource_types is not None:
            pulumi.set(__self__, "monitored_resource_types", monitored_resource_types)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if value_type is not None:
            pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A detailed description of the metric, which can be used in documentation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A concise name for the metric, which can be displayed in user interfaces. Use sentence case without an ending period, for example "Request count". This field is optional but it is recommended to be set for any metrics associated with user-visible concepts, such as Quota.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LabelDescriptorArgs']]]]:
        """
        The set of labels that can be used to describe a specific instance of this metric type. For example, the `appengine.googleapis.com/http/server/response_latencies` metric type has a label for the HTTP response code, `response_code`, so you can look at latencies for successful responses or just for responses that failed.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LabelDescriptorArgs']]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input['MetricDescriptorLaunchStage']]:
        """
        Optional. The launch stage of the metric definition.
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input['MetricDescriptorLaunchStage']]):
        pulumi.set(self, "launch_stage", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['MetricDescriptorMetadataArgs']]:
        """
        Optional. Metadata which can be used to guide usage of the metric.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['MetricDescriptorMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter(name="metricKind")
    def metric_kind(self) -> Optional[pulumi.Input['MetricDescriptorMetricKind']]:
        """
        Whether the metric records instantaneous values, changes to a value, etc. Some combinations of `metric_kind` and `value_type` might not be supported.
        """
        return pulumi.get(self, "metric_kind")

    @metric_kind.setter
    def metric_kind(self, value: Optional[pulumi.Input['MetricDescriptorMetricKind']]):
        pulumi.set(self, "metric_kind", value)

    @property
    @pulumi.getter(name="monitoredResourceTypes")
    def monitored_resource_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Read-only. If present, then a time series, which is identified partially by a metric type and a MonitoredResourceDescriptor, that is associated with this metric type can only be associated with one of the monitored resource types listed here.
        """
        return pulumi.get(self, "monitored_resource_types")

    @monitored_resource_types.setter
    def monitored_resource_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "monitored_resource_types", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the metric descriptor.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The metric type, including its DNS name prefix. The type is not URL-encoded. All user-defined metric types have the DNS name `custom.googleapis.com` or `external.googleapis.com`. Metric types should use a natural hierarchical grouping. For example: "custom.googleapis.com/invoice/paid/amount" "external.googleapis.com/prometheus/up" "appengine.googleapis.com/http/server/response_latencies"
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        The units in which the metric value is reported. It is only applicable if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The `unit` defines the representation of the stored metric values. Different systems might scale the values to be more easily displayed (so a value of `0.02kBy` _might_ be displayed as `20By`, and a value of `3523kBy` _might_ be displayed as `3.5MBy`). However, if the `unit` is `kBy`, then the value of the metric is always in thousands of bytes, no matter how it might be displayed. If you want a custom metric to record the exact number of CPU-seconds used by a job, you can create an `INT64 CUMULATIVE` metric whose `unit` is `s{CPU}` (or equivalently `1s{CPU}` or just `s`). If the job uses 12,005 CPU-seconds, then the value is written as `12005`. Alternatively, if you want a custom metric to record data in a more granular way, you can create a `DOUBLE CUMULATIVE` metric whose `unit` is `ks{CPU}`, and then write the value `12.005` (which is `12005/1000`), or use `Kis{CPU}` and write `11.723` (which is `12005/1024`). The supported units are a subset of [The Unified Code for Units of Measure](https://unitsofmeasure.org/ucum.html) standard: **Basic units (UNIT)** * `bit` bit * `By` byte * `s` second * `min` minute * `h` hour * `d` day * `1` dimensionless **Prefixes (PREFIX)** * `k` kilo (10^3) * `M` mega (10^6) * `G` giga (10^9) * `T` tera (10^12) * `P` peta (10^15) * `E` exa (10^18) * `Z` zetta (10^21) * `Y` yotta (10^24) * `m` milli (10^-3) * `u` micro (10^-6) * `n` nano (10^-9) * `p` pico (10^-12) * `f` femto (10^-15) * `a` atto (10^-18) * `z` zepto (10^-21) * `y` yocto (10^-24) * `Ki` kibi (2^10) * `Mi` mebi (2^20) * `Gi` gibi (2^30) * `Ti` tebi (2^40) * `Pi` pebi (2^50) **Grammar** The grammar also includes these connectors: * `/` division or ratio (as an infix operator). For examples, `kBy/{email}` or `MiBy/10ms` (although you should almost never have `/s` in a metric `unit`; rates should always be computed at query time from the underlying cumulative or delta value). * `.` multiplication or composition (as an infix operator). For examples, `GBy.d` or `k{watt}.h`. The grammar for a unit is as follows: Expression = Component { "." Component } { "/" Component } ; Component = ( [ PREFIX ] UNIT | "%" ) [ Annotation ] | Annotation | "1" ; Annotation = "{" NAME "}" ; Notes: * `Annotation` is just a comment if it follows a `UNIT`. If the annotation is used alone, then the unit is equivalent to `1`. For examples, `{request}/s == 1/s`, `By{transmitted}/s == By/s`. * `NAME` is a sequence of non-blank printable ASCII characters not containing `{` or `}`. * `1` represents a unitary [dimensionless unit](https://en.wikipedia.org/wiki/Dimensionless_quantity) of 1, such as in `1/s`. It is typically used when none of the basic units are appropriate. For example, "new users per day" can be represented as `1/d` or `{new-users}/d` (and a metric value `5` would mean "5 new users). Alternatively, "thousands of page views per day" would be represented as `1000/d` or `k1/d` or `k{page_views}/d` (and a metric value of `5.3` would mean "5300 page views per day"). * `%` represents dimensionless value of 1/100, and annotates values giving a percentage (so the metric values are typically in the range of 0..100, and a metric value `3` means "3 percent"). * `10^2.%` indicates a metric contains a ratio, typically in the range 0..1, that will be multiplied by 100 and displayed as a percentage (so a metric value `0.03` means "3 percent").
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> Optional[pulumi.Input['MetricDescriptorValueType']]:
        """
        Whether the measurement is an integer, a floating-point number, etc. Some combinations of `metric_kind` and `value_type` might not be supported.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: Optional[pulumi.Input['MetricDescriptorValueType']]):
        pulumi.set(self, "value_type", value)


@pulumi.input_type
class MetricRuleArgs:
    def __init__(__self__, *,
                 metric_costs: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 selector: Optional[pulumi.Input[str]] = None):
        """
        Bind API methods to metrics. Binding a method to a metric causes that metric's configured quota behaviors to apply to the method call.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metric_costs: Metrics to update when the selected methods are called, and the associated cost applied to each metric. The key of the map is the metric name, and the values are the amount increased for the metric against which the quota limits are defined. The value must not be negative.
        :param pulumi.Input[str] selector: Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        if metric_costs is not None:
            pulumi.set(__self__, "metric_costs", metric_costs)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter(name="metricCosts")
    def metric_costs(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Metrics to update when the selected methods are called, and the associated cost applied to each metric. The key of the map is the metric name, and the values are the amount increased for the metric against which the quota limits are defined. The value must not be negative.
        """
        return pulumi.get(self, "metric_costs")

    @metric_costs.setter
    def metric_costs(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metric_costs", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Selects the methods to which this rule applies. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class MixinArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 root: Optional[pulumi.Input[str]] = None):
        """
        Declares an API Interface to be included in this interface. The including interface must redeclare all the methods from the included interface, but documentation and options are inherited as follows: - If after comment and whitespace stripping, the documentation string of the redeclared method is empty, it will be inherited from the original method. - Each annotation belonging to the service config (http, visibility) which is not set in the redeclared method will be inherited. - If an http annotation is inherited, the path pattern will be modified as follows. Any version prefix will be replaced by the version of the including interface plus the root path if specified. Example of a simple mixin: package google.acl.v1; service AccessControl { // Get the underlying ACL object. rpc GetAcl(GetAclRequest) returns (Acl) { option (google.api.http).get = "/v1/{resource=**}:getAcl"; } } package google.storage.v2; service Storage { // rpc GetAcl(GetAclRequest) returns (Acl); // Get a data record. rpc GetData(GetDataRequest) returns (Data) { option (google.api.http).get = "/v2/{resource=**}"; } } Example of a mixin configuration: apis: - name: google.storage.v2.Storage mixins: - name: google.acl.v1.AccessControl The mixin construct implies that all methods in `AccessControl` are also declared with same name and request/response types in `Storage`. A documentation generator or annotation processor will see the effective `Storage.GetAcl` method after inheriting documentation and annotations as follows: service Storage { // Get the underlying ACL object. rpc GetAcl(GetAclRequest) returns (Acl) { option (google.api.http).get = "/v2/{resource=**}:getAcl"; } ... } Note how the version in the path pattern changed from `v1` to `v2`. If the `root` field in the mixin is specified, it should be a relative path under which inherited HTTP paths are placed. Example: apis: - name: google.storage.v2.Storage mixins: - name: google.acl.v1.AccessControl root: acls This implies the following inherited HTTP annotation: service Storage { // Get the underlying ACL object. rpc GetAcl(GetAclRequest) returns (Acl) { option (google.api.http).get = "/v2/acls/{resource=**}:getAcl"; } ... }
        :param pulumi.Input[str] name: The fully qualified name of the interface which is included.
        :param pulumi.Input[str] root: If non-empty specifies a path under which inherited HTTP paths are rooted.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if root is not None:
            pulumi.set(__self__, "root", root)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified name of the interface which is included.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def root(self) -> Optional[pulumi.Input[str]]:
        """
        If non-empty specifies a path under which inherited HTTP paths are rooted.
        """
        return pulumi.get(self, "root")

    @root.setter
    def root(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root", value)


@pulumi.input_type
class MonitoredResourceDescriptorArgs:
    def __init__(__self__, *,
                 labels: pulumi.Input[Sequence[pulumi.Input['LabelDescriptorArgs']]],
                 type: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 launch_stage: Optional[pulumi.Input['MonitoredResourceDescriptorLaunchStage']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        An object that describes the schema of a MonitoredResource object using a type name and a set of labels. For example, the monitored resource descriptor for Google Compute Engine VM instances has a type of `"gce_instance"` and specifies the use of the labels `"instance_id"` and `"zone"` to identify particular VM instances. Different APIs can support different monitored resource types. APIs generally provide a `list` method that returns the monitored resource descriptors used by the API. 
        :param pulumi.Input[Sequence[pulumi.Input['LabelDescriptorArgs']]] labels: A set of labels used to describe instances of this monitored resource type. For example, an individual Google Cloud SQL database is identified by values for the labels `"database_id"` and `"zone"`.
        :param pulumi.Input[str] type: The monitored resource type. For example, the type `"cloudsql_database"` represents databases in Google Cloud SQL. For a list of types, see [Monitoring resource types](https://cloud.google.com/monitoring/api/resources) and [Logging resource types](https://cloud.google.com/logging/docs/api/v2/resource-list).
        :param pulumi.Input[str] description: Optional. A detailed description of the monitored resource type that might be used in documentation.
        :param pulumi.Input[str] display_name: Optional. A concise name for the monitored resource type that might be displayed in user interfaces. It should be a Title Cased Noun Phrase, without any article or other determiners. For example, `"Google Cloud SQL Database"`.
        :param pulumi.Input['MonitoredResourceDescriptorLaunchStage'] launch_stage: Optional. The launch stage of the monitored resource definition.
        :param pulumi.Input[str] name: Optional. The resource name of the monitored resource descriptor: `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where {type} is the value of the `type` field in this object and {project_id} is a project ID that provides API-specific context for accessing the type. APIs that do not use project information can use the resource name format `"monitoredResourceDescriptors/{type}"`.
        """
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if launch_stage is not None:
            pulumi.set(__self__, "launch_stage", launch_stage)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Input[Sequence[pulumi.Input['LabelDescriptorArgs']]]:
        """
        A set of labels used to describe instances of this monitored resource type. For example, an individual Google Cloud SQL database is identified by values for the labels `"database_id"` and `"zone"`.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: pulumi.Input[Sequence[pulumi.Input['LabelDescriptorArgs']]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The monitored resource type. For example, the type `"cloudsql_database"` represents databases in Google Cloud SQL. For a list of types, see [Monitoring resource types](https://cloud.google.com/monitoring/api/resources) and [Logging resource types](https://cloud.google.com/logging/docs/api/v2/resource-list).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A detailed description of the monitored resource type that might be used in documentation.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. A concise name for the monitored resource type that might be displayed in user interfaces. It should be a Title Cased Noun Phrase, without any article or other determiners. For example, `"Google Cloud SQL Database"`.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="launchStage")
    def launch_stage(self) -> Optional[pulumi.Input['MonitoredResourceDescriptorLaunchStage']]:
        """
        Optional. The launch stage of the monitored resource definition.
        """
        return pulumi.get(self, "launch_stage")

    @launch_stage.setter
    def launch_stage(self, value: Optional[pulumi.Input['MonitoredResourceDescriptorLaunchStage']]):
        pulumi.set(self, "launch_stage", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The resource name of the monitored resource descriptor: `"projects/{project_id}/monitoredResourceDescriptors/{type}"` where {type} is the value of the `type` field in this object and {project_id} is a project ID that provides API-specific context for accessing the type. APIs that do not use project information can use the resource name format `"monitoredResourceDescriptors/{type}"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class MonitoringDestinationArgs:
    def __init__(__self__, *,
                 metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 monitored_resource: Optional[pulumi.Input[str]] = None):
        """
        Configuration of a specific monitoring destination (the producer project or the consumer project).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] metrics: Types of the metrics to report to this monitoring destination. Each type must be defined in Service.metrics section.
        :param pulumi.Input[str] monitored_resource: The monitored resource type. The type must be defined in Service.monitored_resources section.
        """
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if monitored_resource is not None:
            pulumi.set(__self__, "monitored_resource", monitored_resource)

    @property
    @pulumi.getter
    def metrics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Types of the metrics to report to this monitoring destination. Each type must be defined in Service.metrics section.
        """
        return pulumi.get(self, "metrics")

    @metrics.setter
    def metrics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "metrics", value)

    @property
    @pulumi.getter(name="monitoredResource")
    def monitored_resource(self) -> Optional[pulumi.Input[str]]:
        """
        The monitored resource type. The type must be defined in Service.monitored_resources section.
        """
        return pulumi.get(self, "monitored_resource")

    @monitored_resource.setter
    def monitored_resource(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "monitored_resource", value)


@pulumi.input_type
class MonitoringArgs:
    def __init__(__self__, *,
                 consumer_destinations: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringDestinationArgs']]]] = None,
                 producer_destinations: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringDestinationArgs']]]] = None):
        """
        Monitoring configuration of the service. The example below shows how to configure monitored resources and metrics for monitoring. In the example, a monitored resource and two metrics are defined. The `library.googleapis.com/book/returned_count` metric is sent to both producer and consumer projects, whereas the `library.googleapis.com/book/num_overdue` metric is only sent to the consumer project. monitored_resources: - type: library.googleapis.com/Branch display_name: "Library Branch" description: "A branch of a library." launch_stage: GA labels: - key: resource_container description: "The Cloud container (ie. project id) for the Branch." - key: location description: "The location of the library branch." - key: branch_id description: "The id of the branch." metrics: - name: library.googleapis.com/book/returned_count display_name: "Books Returned" description: "The count of books that have been returned." launch_stage: GA metric_kind: DELTA value_type: INT64 unit: "1" labels: - key: customer_id description: "The id of the customer." - name: library.googleapis.com/book/num_overdue display_name: "Books Overdue" description: "The current number of overdue books." launch_stage: GA metric_kind: GAUGE value_type: INT64 unit: "1" labels: - key: customer_id description: "The id of the customer." monitoring: producer_destinations: - monitored_resource: library.googleapis.com/Branch metrics: - library.googleapis.com/book/returned_count consumer_destinations: - monitored_resource: library.googleapis.com/Branch metrics: - library.googleapis.com/book/returned_count - library.googleapis.com/book/num_overdue
        :param pulumi.Input[Sequence[pulumi.Input['MonitoringDestinationArgs']]] consumer_destinations: Monitoring configurations for sending metrics to the consumer project. There can be multiple consumer destinations. A monitored resource type may appear in multiple monitoring destinations if different aggregations are needed for different sets of metrics associated with that monitored resource type. A monitored resource and metric pair may only be used once in the Monitoring configuration.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoringDestinationArgs']]] producer_destinations: Monitoring configurations for sending metrics to the producer project. There can be multiple producer destinations. A monitored resource type may appear in multiple monitoring destinations if different aggregations are needed for different sets of metrics associated with that monitored resource type. A monitored resource and metric pair may only be used once in the Monitoring configuration.
        """
        if consumer_destinations is not None:
            pulumi.set(__self__, "consumer_destinations", consumer_destinations)
        if producer_destinations is not None:
            pulumi.set(__self__, "producer_destinations", producer_destinations)

    @property
    @pulumi.getter(name="consumerDestinations")
    def consumer_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringDestinationArgs']]]]:
        """
        Monitoring configurations for sending metrics to the consumer project. There can be multiple consumer destinations. A monitored resource type may appear in multiple monitoring destinations if different aggregations are needed for different sets of metrics associated with that monitored resource type. A monitored resource and metric pair may only be used once in the Monitoring configuration.
        """
        return pulumi.get(self, "consumer_destinations")

    @consumer_destinations.setter
    def consumer_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringDestinationArgs']]]]):
        pulumi.set(self, "consumer_destinations", value)

    @property
    @pulumi.getter(name="producerDestinations")
    def producer_destinations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringDestinationArgs']]]]:
        """
        Monitoring configurations for sending metrics to the producer project. There can be multiple producer destinations. A monitored resource type may appear in multiple monitoring destinations if different aggregations are needed for different sets of metrics associated with that monitored resource type. A monitored resource and metric pair may only be used once in the Monitoring configuration.
        """
        return pulumi.get(self, "producer_destinations")

    @producer_destinations.setter
    def producer_destinations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoringDestinationArgs']]]]):
        pulumi.set(self, "producer_destinations", value)


@pulumi.input_type
class OAuthRequirementsArgs:
    def __init__(__self__, *,
                 allow_any_scope: Optional[pulumi.Input[bool]] = None,
                 canonical_scopes: Optional[pulumi.Input[str]] = None):
        """
        OAuth scopes are a way to define data and permissions on data. For example, there are scopes defined for "Read-only access to Google Calendar" and "Access to Cloud Platform". Users can consent to a scope for an application, giving it permission to access that data on their behalf. OAuth scope specifications should be fairly coarse grained; a user will need to see and understand the text description of what your scope means. In most cases: use one or at most two OAuth scopes for an entire family of products. If your product has multiple APIs, you should probably be sharing the OAuth scope across all of those APIs. When you need finer grained OAuth consent screens: talk with your product management about how developers will use them in practice. Please note that even though each of the canonical scopes is enough for a request to be accepted and passed to the backend, a request can still fail due to the backend requiring additional scopes or permissions.
        :param pulumi.Input[bool] allow_any_scope: UNIMPLEMENTED: If enabled, ESF will allow OAuth credentials with any scope, more details in http://go/esf-oauth-any-scope. WARNING: Enabling this option will bring security risks. Customers enabling this feature accidentally may have the risk of losing authentication enforcement. Please reach out to api-auth@ and esf-team@ for approval and allowlisting before you enable this option. 
        :param pulumi.Input[str] canonical_scopes: The list of publicly documented OAuth scopes that are allowed access. An OAuth token containing any of these scopes will be accepted. Example: canonical_scopes: https://www.googleapis.com/auth/calendar, https://www.googleapis.com/auth/calendar.read
        """
        if allow_any_scope is not None:
            pulumi.set(__self__, "allow_any_scope", allow_any_scope)
        if canonical_scopes is not None:
            pulumi.set(__self__, "canonical_scopes", canonical_scopes)

    @property
    @pulumi.getter(name="allowAnyScope")
    def allow_any_scope(self) -> Optional[pulumi.Input[bool]]:
        """
        UNIMPLEMENTED: If enabled, ESF will allow OAuth credentials with any scope, more details in http://go/esf-oauth-any-scope. WARNING: Enabling this option will bring security risks. Customers enabling this feature accidentally may have the risk of losing authentication enforcement. Please reach out to api-auth@ and esf-team@ for approval and allowlisting before you enable this option. 
        """
        return pulumi.get(self, "allow_any_scope")

    @allow_any_scope.setter
    def allow_any_scope(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_any_scope", value)

    @property
    @pulumi.getter(name="canonicalScopes")
    def canonical_scopes(self) -> Optional[pulumi.Input[str]]:
        """
        The list of publicly documented OAuth scopes that are allowed access. An OAuth token containing any of these scopes will be accepted. Example: canonical_scopes: https://www.googleapis.com/auth/calendar, https://www.googleapis.com/auth/calendar.read
        """
        return pulumi.get(self, "canonical_scopes")

    @canonical_scopes.setter
    def canonical_scopes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "canonical_scopes", value)


@pulumi.input_type
class OptionArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A protocol buffer option, which can be attached to a message, field, enumeration, etc.
        :param pulumi.Input[str] name: The option's name. For protobuf built-in options (options defined in descriptor.proto), this is the short name. For example, `"map_entry"`. For custom options, it should be the fully-qualified name. For example, `"google.api.http"`.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] value: The option's value packed in an Any message. If the value is a primitive, the corresponding wrapper type defined in google/protobuf/wrappers.proto should be used. If the value is an enum, it should be stored as an int32 value using the google.protobuf.Int32Value type.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The option's name. For protobuf built-in options (options defined in descriptor.proto), this is the short name. For example, `"map_entry"`. For custom options, it should be the fully-qualified name. For example, `"google.api.http"`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The option's value packed in an Any message. If the value is a primitive, the corresponding wrapper type defined in google/protobuf/wrappers.proto should be used. If the value is an enum, it should be stored as an int32 value using the google.protobuf.Int32Value type.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class PageArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 subpages: Optional[pulumi.Input[Sequence[pulumi.Input['PageArgs']]]] = None):
        """
        Represents a documentation page. A page can contain subpages to represent nested documentation set structure.
        :param pulumi.Input[str] content: The Markdown content of the page. You can use (== include {path} ==) to include content from a Markdown file. The content can be used to produce the documentation page such as HTML format page.
        :param pulumi.Input[str] name: The name of the page. It will be used as an identity of the page to generate URI of the page, text of the link to this page in navigation, etc. The full page name (start from the root page name to this page concatenated with `.`) can be used as reference to the page in your documentation. For example: pages: - name: Tutorial content: (== include tutorial.md ==) subpages: - name: Java content: (== include tutorial_java.md ==) You can reference `Java` page using Markdown reference link syntax: `Java`.
        :param pulumi.Input[Sequence[pulumi.Input['PageArgs']]] subpages: Subpages of this page. The order of subpages specified here will be honored in the generated docset.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if subpages is not None:
            pulumi.set(__self__, "subpages", subpages)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The Markdown content of the page. You can use (== include {path} ==) to include content from a Markdown file. The content can be used to produce the documentation page such as HTML format page.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the page. It will be used as an identity of the page to generate URI of the page, text of the link to this page in navigation, etc. The full page name (start from the root page name to this page concatenated with `.`) can be used as reference to the page in your documentation. For example: pages: - name: Tutorial content: (== include tutorial.md ==) subpages: - name: Java content: (== include tutorial_java.md ==) You can reference `Java` page using Markdown reference link syntax: `Java`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def subpages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PageArgs']]]]:
        """
        Subpages of this page. The order of subpages specified here will be honored in the generated docset.
        """
        return pulumi.get(self, "subpages")

    @subpages.setter
    def subpages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PageArgs']]]]):
        pulumi.set(self, "subpages", value)


@pulumi.input_type
class QuotaLimitArgs:
    def __init__(__self__, *,
                 default_limit: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 duration: Optional[pulumi.Input[str]] = None,
                 free_tier: Optional[pulumi.Input[str]] = None,
                 max_limit: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 values: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        `QuotaLimit` defines a specific limit that applies over a specified duration for a limit type. There can be at most one limit for a duration and limit type combination defined within a `QuotaGroup`.
        :param pulumi.Input[str] default_limit: Default number of tokens that can be consumed during the specified duration. This is the number of tokens assigned when a client application developer activates the service for his/her project. Specifying a value of 0 will block all requests. This can be used if you are provisioning quota to selected consumers and blocking others. Similarly, a value of -1 will indicate an unlimited quota. No other negative values are allowed. Used by group-based quotas only.
        :param pulumi.Input[str] description: Optional. User-visible, extended description for this quota limit. Should be used only when more context is needed to understand this limit than provided by the limit's display name (see: `display_name`).
        :param pulumi.Input[str] display_name: User-visible display name for this limit. Optional. If not set, the UI will provide a default display name based on the quota configuration. This field can be used to override the default display name generated from the configuration.
        :param pulumi.Input[str] duration: Duration of this limit in textual notation. Must be "100s" or "1d". Used by group-based quotas only.
        :param pulumi.Input[str] free_tier: Free tier value displayed in the Developers Console for this limit. The free tier is the number of tokens that will be subtracted from the billed amount when billing is enabled. This field can only be set on a limit with duration "1d", in a billable group; it is invalid on any other limit. If this field is not set, it defaults to 0, indicating that there is no free tier for this service. Used by group-based quotas only.
        :param pulumi.Input[str] max_limit: Maximum number of tokens that can be consumed during the specified duration. Client application developers can override the default limit up to this maximum. If specified, this value cannot be set to a value less than the default limit. If not specified, it is set to the default limit. To allow clients to apply overrides with no upper bound, set this to -1, indicating unlimited maximum quota. Used by group-based quotas only.
        :param pulumi.Input[str] metric: The name of the metric this quota limit applies to. The quota limits with the same metric will be checked together during runtime. The metric must be defined within the service config.
        :param pulumi.Input[str] name: Name of the quota limit. The name must be provided, and it must be unique within the service. The name can only include alphanumeric characters as well as '-'. The maximum length of the limit name is 64 characters.
        :param pulumi.Input[str] unit: Specify the unit of the quota limit. It uses the same syntax as Metric.unit. The supported unit kinds are determined by the quota backend system. Here are some examples: * "1/min/{project}" for quota per minute per project. Note: the order of unit components is insignificant. The "1" at the beginning is required to follow the metric unit syntax.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] values: Tiered limit values. You must specify this as a key:value pair, with an integer value that is the maximum number of requests allowed for the specified unit. Currently only STANDARD is supported.
        """
        if default_limit is not None:
            pulumi.set(__self__, "default_limit", default_limit)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if duration is not None:
            pulumi.set(__self__, "duration", duration)
        if free_tier is not None:
            pulumi.set(__self__, "free_tier", free_tier)
        if max_limit is not None:
            pulumi.set(__self__, "max_limit", max_limit)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)
        if values is not None:
            pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="defaultLimit")
    def default_limit(self) -> Optional[pulumi.Input[str]]:
        """
        Default number of tokens that can be consumed during the specified duration. This is the number of tokens assigned when a client application developer activates the service for his/her project. Specifying a value of 0 will block all requests. This can be used if you are provisioning quota to selected consumers and blocking others. Similarly, a value of -1 will indicate an unlimited quota. No other negative values are allowed. Used by group-based quotas only.
        """
        return pulumi.get(self, "default_limit")

    @default_limit.setter
    def default_limit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_limit", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. User-visible, extended description for this quota limit. Should be used only when more context is needed to understand this limit than provided by the limit's display name (see: `display_name`).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        User-visible display name for this limit. Optional. If not set, the UI will provide a default display name based on the quota configuration. This field can be used to override the default display name generated from the configuration.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def duration(self) -> Optional[pulumi.Input[str]]:
        """
        Duration of this limit in textual notation. Must be "100s" or "1d". Used by group-based quotas only.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "duration", value)

    @property
    @pulumi.getter(name="freeTier")
    def free_tier(self) -> Optional[pulumi.Input[str]]:
        """
        Free tier value displayed in the Developers Console for this limit. The free tier is the number of tokens that will be subtracted from the billed amount when billing is enabled. This field can only be set on a limit with duration "1d", in a billable group; it is invalid on any other limit. If this field is not set, it defaults to 0, indicating that there is no free tier for this service. Used by group-based quotas only.
        """
        return pulumi.get(self, "free_tier")

    @free_tier.setter
    def free_tier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "free_tier", value)

    @property
    @pulumi.getter(name="maxLimit")
    def max_limit(self) -> Optional[pulumi.Input[str]]:
        """
        Maximum number of tokens that can be consumed during the specified duration. Client application developers can override the default limit up to this maximum. If specified, this value cannot be set to a value less than the default limit. If not specified, it is set to the default limit. To allow clients to apply overrides with no upper bound, set this to -1, indicating unlimited maximum quota. Used by group-based quotas only.
        """
        return pulumi.get(self, "max_limit")

    @max_limit.setter
    def max_limit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_limit", value)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the metric this quota limit applies to. The quota limits with the same metric will be checked together during runtime. The metric must be defined within the service config.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the quota limit. The name must be provided, and it must be unique within the service. The name can only include alphanumeric characters as well as '-'. The maximum length of the limit name is 64 characters.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the unit of the quota limit. It uses the same syntax as Metric.unit. The supported unit kinds are determined by the quota backend system. Here are some examples: * "1/min/{project}" for quota per minute per project. Note: the order of unit components is insignificant. The "1" at the beginning is required to follow the metric unit syntax.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter
    def values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Tiered limit values. You must specify this as a key:value pair, with an integer value that is the maximum number of requests allowed for the specified unit. Currently only STANDARD is supported.
        """
        return pulumi.get(self, "values")

    @values.setter
    def values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "values", value)


@pulumi.input_type
class QuotaArgs:
    def __init__(__self__, *,
                 limits: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaLimitArgs']]]] = None,
                 metric_rules: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRuleArgs']]]] = None):
        """
        Quota configuration helps to achieve fairness and budgeting in service usage. The metric based quota configuration works this way: - The service configuration defines a set of metrics. - For API calls, the quota.metric_rules maps methods to metrics with corresponding costs. - The quota.limits defines limits on the metrics, which will be used for quota checks at runtime. An example quota configuration in yaml format: quota: limits: - name: apiWriteQpsPerProject metric: library.googleapis.com/write_calls unit: "1/min/{project}" # rate limit for consumer projects values: STANDARD: 10000 # The metric rules bind all methods to the read_calls metric, # except for the UpdateBook and DeleteBook methods. These two methods # are mapped to the write_calls metric, with the UpdateBook method # consuming at twice rate as the DeleteBook method. metric_rules: - selector: "*" metric_costs: library.googleapis.com/read_calls: 1 - selector: google.example.library.v1.LibraryService.UpdateBook metric_costs: library.googleapis.com/write_calls: 2 - selector: google.example.library.v1.LibraryService.DeleteBook metric_costs: library.googleapis.com/write_calls: 1 Corresponding Metric definition: metrics: - name: library.googleapis.com/read_calls display_name: Read requests metric_kind: DELTA value_type: INT64 - name: library.googleapis.com/write_calls display_name: Write requests metric_kind: DELTA value_type: INT64 
        :param pulumi.Input[Sequence[pulumi.Input['QuotaLimitArgs']]] limits: List of `QuotaLimit` definitions for the service.
        :param pulumi.Input[Sequence[pulumi.Input['MetricRuleArgs']]] metric_rules: List of `MetricRule` definitions, each one mapping a selected method to one or more metrics.
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if metric_rules is not None:
            pulumi.set(__self__, "metric_rules", metric_rules)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QuotaLimitArgs']]]]:
        """
        List of `QuotaLimit` definitions for the service.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QuotaLimitArgs']]]]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter(name="metricRules")
    def metric_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MetricRuleArgs']]]]:
        """
        List of `MetricRule` definitions, each one mapping a selected method to one or more metrics.
        """
        return pulumi.get(self, "metric_rules")

    @metric_rules.setter
    def metric_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MetricRuleArgs']]]]):
        pulumi.set(self, "metric_rules", value)


@pulumi.input_type
class SourceContextArgs:
    def __init__(__self__, *,
                 file_name: Optional[pulumi.Input[str]] = None):
        """
        `SourceContext` represents information about the source of a protobuf element, like the file in which it is defined.
        :param pulumi.Input[str] file_name: The path-qualified name of the .proto file that contained the associated protobuf element. For example: `"google/protobuf/source_context.proto"`.
        """
        if file_name is not None:
            pulumi.set(__self__, "file_name", file_name)

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[pulumi.Input[str]]:
        """
        The path-qualified name of the .proto file that contained the associated protobuf element. For example: `"google/protobuf/source_context.proto"`.
        """
        return pulumi.get(self, "file_name")

    @file_name.setter
    def file_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "file_name", value)


@pulumi.input_type
class SystemParameterRuleArgs:
    def __init__(__self__, *,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['SystemParameterArgs']]]] = None,
                 selector: Optional[pulumi.Input[str]] = None):
        """
        Define a system parameter rule mapping system parameter definitions to methods.
        :param pulumi.Input[Sequence[pulumi.Input['SystemParameterArgs']]] parameters: Define parameters. Multiple names may be defined for a parameter. For a given method call, only one of them should be used. If multiple names are used the behavior is implementation-dependent. If none of the specified names are present the behavior is parameter-dependent.
        :param pulumi.Input[str] selector: Selects the methods to which this rule applies. Use '*' to indicate all methods in all APIs. Refer to selector for syntax details.
        """
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemParameterArgs']]]]:
        """
        Define parameters. Multiple names may be defined for a parameter. For a given method call, only one of them should be used. If multiple names are used the behavior is implementation-dependent. If none of the specified names are present the behavior is parameter-dependent.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Selects the methods to which this rule applies. Use '*' to indicate all methods in all APIs. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)


@pulumi.input_type
class SystemParametersArgs:
    def __init__(__self__, *,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['SystemParameterRuleArgs']]]] = None):
        """
        ### System parameter configuration A system parameter is a special kind of parameter defined by the API system, not by an individual API. It is typically mapped to an HTTP header and/or a URL query parameter. This configuration specifies which methods change the names of the system parameters.
        :param pulumi.Input[Sequence[pulumi.Input['SystemParameterRuleArgs']]] rules: Define system parameters. The parameters defined here will override the default parameters implemented by the system. If this field is missing from the service config, default system parameters will be used. Default system parameters and names is implementation-dependent. Example: define api key for all methods system_parameters rules: - selector: "*" parameters: - name: api_key url_query_parameter: api_key Example: define 2 api key names for a specific method. system_parameters rules: - selector: "/ListShelves" parameters: - name: api_key http_header: Api-Key1 - name: api_key http_header: Api-Key2 **NOTE:** All service configuration rules follow "last one wins" order.
        """
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SystemParameterRuleArgs']]]]:
        """
        Define system parameters. The parameters defined here will override the default parameters implemented by the system. If this field is missing from the service config, default system parameters will be used. Default system parameters and names is implementation-dependent. Example: define api key for all methods system_parameters rules: - selector: "*" parameters: - name: api_key url_query_parameter: api_key Example: define 2 api key names for a specific method. system_parameters rules: - selector: "/ListShelves" parameters: - name: api_key http_header: Api-Key1 - name: api_key http_header: Api-Key2 **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SystemParameterRuleArgs']]]]):
        pulumi.set(self, "rules", value)


@pulumi.input_type
class SystemParameterArgs:
    def __init__(__self__, *,
                 http_header: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 url_query_parameter: Optional[pulumi.Input[str]] = None):
        """
        Define a parameter's name and location. The parameter may be passed as either an HTTP header or a URL query parameter, and if both are passed the behavior is implementation-dependent.
        :param pulumi.Input[str] http_header: Define the HTTP header name to use for the parameter. It is case insensitive.
        :param pulumi.Input[str] name: Define the name of the parameter, such as "api_key" . It is case sensitive.
        :param pulumi.Input[str] url_query_parameter: Define the URL query parameter name to use for the parameter. It is case sensitive.
        """
        if http_header is not None:
            pulumi.set(__self__, "http_header", http_header)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if url_query_parameter is not None:
            pulumi.set(__self__, "url_query_parameter", url_query_parameter)

    @property
    @pulumi.getter(name="httpHeader")
    def http_header(self) -> Optional[pulumi.Input[str]]:
        """
        Define the HTTP header name to use for the parameter. It is case insensitive.
        """
        return pulumi.get(self, "http_header")

    @http_header.setter
    def http_header(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_header", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Define the name of the parameter, such as "api_key" . It is case sensitive.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="urlQueryParameter")
    def url_query_parameter(self) -> Optional[pulumi.Input[str]]:
        """
        Define the URL query parameter name to use for the parameter. It is case sensitive.
        """
        return pulumi.get(self, "url_query_parameter")

    @url_query_parameter.setter
    def url_query_parameter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url_query_parameter", value)


@pulumi.input_type
class TrafficPercentStrategyArgs:
    def __init__(__self__, *,
                 percentages: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Strategy that specifies how clients of Google Service Controller want to send traffic to use different config versions. This is generally used by API proxy to split traffic based on your configured percentage for each config version. One example of how to gradually rollout a new service configuration using this strategy: Day 1 Rollout { id: "example.googleapis.com/rollout_20160206" traffic_percent_strategy { percentages: { "example.googleapis.com/20160201": 70.00 "example.googleapis.com/20160206": 30.00 } } } Day 2 Rollout { id: "example.googleapis.com/rollout_20160207" traffic_percent_strategy: { percentages: { "example.googleapis.com/20160206": 100.00 } } }
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] percentages: Maps service configuration IDs to their corresponding traffic percentage. Key is the service configuration ID, Value is the traffic percentage which must be greater than 0.0 and the sum must equal to 100.0.
        """
        if percentages is not None:
            pulumi.set(__self__, "percentages", percentages)

    @property
    @pulumi.getter
    def percentages(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Maps service configuration IDs to their corresponding traffic percentage. Key is the service configuration ID, Value is the traffic percentage which must be greater than 0.0 and the sum must equal to 100.0.
        """
        return pulumi.get(self, "percentages")

    @percentages.setter
    def percentages(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "percentages", value)


@pulumi.input_type
class TypeArgs:
    def __init__(__self__, *,
                 fields: Optional[pulumi.Input[Sequence[pulumi.Input['FieldArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 oneofs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]] = None,
                 source_context: Optional[pulumi.Input['SourceContextArgs']] = None,
                 syntax: Optional[pulumi.Input['TypeSyntax']] = None):
        """
        A protocol buffer message type.
        :param pulumi.Input[Sequence[pulumi.Input['FieldArgs']]] fields: The list of fields.
        :param pulumi.Input[str] name: The fully qualified message name.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oneofs: The list of types appearing in `oneof` definitions in this type.
        :param pulumi.Input[Sequence[pulumi.Input['OptionArgs']]] options: The protocol buffer options.
        :param pulumi.Input['SourceContextArgs'] source_context: The source context.
        :param pulumi.Input['TypeSyntax'] syntax: The source syntax.
        """
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oneofs is not None:
            pulumi.set(__self__, "oneofs", oneofs)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if source_context is not None:
            pulumi.set(__self__, "source_context", source_context)
        if syntax is not None:
            pulumi.set(__self__, "syntax", syntax)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['FieldArgs']]]]:
        """
        The list of fields.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['FieldArgs']]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The fully qualified message name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def oneofs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of types appearing in `oneof` definitions in this type.
        """
        return pulumi.get(self, "oneofs")

    @oneofs.setter
    def oneofs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oneofs", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]]:
        """
        The protocol buffer options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OptionArgs']]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="sourceContext")
    def source_context(self) -> Optional[pulumi.Input['SourceContextArgs']]:
        """
        The source context.
        """
        return pulumi.get(self, "source_context")

    @source_context.setter
    def source_context(self, value: Optional[pulumi.Input['SourceContextArgs']]):
        pulumi.set(self, "source_context", value)

    @property
    @pulumi.getter
    def syntax(self) -> Optional[pulumi.Input['TypeSyntax']]:
        """
        The source syntax.
        """
        return pulumi.get(self, "syntax")

    @syntax.setter
    def syntax(self, value: Optional[pulumi.Input['TypeSyntax']]):
        pulumi.set(self, "syntax", value)


@pulumi.input_type
class UsageRuleArgs:
    def __init__(__self__, *,
                 allow_unregistered_calls: Optional[pulumi.Input[bool]] = None,
                 selector: Optional[pulumi.Input[str]] = None,
                 skip_service_control: Optional[pulumi.Input[bool]] = None):
        """
        Usage configuration rules for the service. NOTE: Under development. Use this rule to configure unregistered calls for the service. Unregistered calls are calls that do not contain consumer project identity. (Example: calls that do not contain an API key). By default, API methods do not allow unregistered calls, and each method call must be identified by a consumer project identity. Use this rule to allow/disallow unregistered calls. Example of an API that wants to allow unregistered calls for entire service. usage: rules: - selector: "*" allow_unregistered_calls: true Example of a method that wants to allow unregistered calls. usage: rules: - selector: "google.example.library.v1.LibraryService.CreateBook" allow_unregistered_calls: true
        :param pulumi.Input[bool] allow_unregistered_calls: If true, the selected method allows unregistered calls, e.g. calls that don't identify any user or application.
        :param pulumi.Input[str] selector: Selects the methods to which this rule applies. Use '*' to indicate all methods in all APIs. Refer to selector for syntax details.
        :param pulumi.Input[bool] skip_service_control: If true, the selected method should skip service control and the control plane features, such as quota and billing, will not be available. This flag is used by Google Cloud Endpoints to bypass checks for internal methods, such as service health check methods.
        """
        if allow_unregistered_calls is not None:
            pulumi.set(__self__, "allow_unregistered_calls", allow_unregistered_calls)
        if selector is not None:
            pulumi.set(__self__, "selector", selector)
        if skip_service_control is not None:
            pulumi.set(__self__, "skip_service_control", skip_service_control)

    @property
    @pulumi.getter(name="allowUnregisteredCalls")
    def allow_unregistered_calls(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the selected method allows unregistered calls, e.g. calls that don't identify any user or application.
        """
        return pulumi.get(self, "allow_unregistered_calls")

    @allow_unregistered_calls.setter
    def allow_unregistered_calls(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_unregistered_calls", value)

    @property
    @pulumi.getter
    def selector(self) -> Optional[pulumi.Input[str]]:
        """
        Selects the methods to which this rule applies. Use '*' to indicate all methods in all APIs. Refer to selector for syntax details.
        """
        return pulumi.get(self, "selector")

    @selector.setter
    def selector(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "selector", value)

    @property
    @pulumi.getter(name="skipServiceControl")
    def skip_service_control(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the selected method should skip service control and the control plane features, such as quota and billing, will not be available. This flag is used by Google Cloud Endpoints to bypass checks for internal methods, such as service health check methods.
        """
        return pulumi.get(self, "skip_service_control")

    @skip_service_control.setter
    def skip_service_control(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "skip_service_control", value)


@pulumi.input_type
class UsageArgs:
    def __init__(__self__, *,
                 producer_notification_channel: Optional[pulumi.Input[str]] = None,
                 requirements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rules: Optional[pulumi.Input[Sequence[pulumi.Input['UsageRuleArgs']]]] = None):
        """
        Configuration controlling usage of a service.
        :param pulumi.Input[str] producer_notification_channel: The full resource name of a channel used for sending notifications to the service producer. Google Service Management currently only supports [Google Cloud Pub/Sub](https://cloud.google.com/pubsub) as a notification channel. To use Google Cloud Pub/Sub as the channel, this must be the name of a Cloud Pub/Sub topic that uses the Cloud Pub/Sub topic name format documented in https://cloud.google.com/pubsub/docs/overview.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] requirements: Requirements that must be satisfied before a consumer project can use the service. Each requirement is of the form /; for example 'serviceusage.googleapis.com/billing-enabled'. For Google APIs, a Terms of Service requirement must be included here. Google Cloud APIs must include "serviceusage.googleapis.com/tos/cloud". Other Google APIs should include "serviceusage.googleapis.com/tos/universal". Additional ToS can be included based on the business needs.
        :param pulumi.Input[Sequence[pulumi.Input['UsageRuleArgs']]] rules: A list of usage rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        if producer_notification_channel is not None:
            pulumi.set(__self__, "producer_notification_channel", producer_notification_channel)
        if requirements is not None:
            pulumi.set(__self__, "requirements", requirements)
        if rules is not None:
            pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter(name="producerNotificationChannel")
    def producer_notification_channel(self) -> Optional[pulumi.Input[str]]:
        """
        The full resource name of a channel used for sending notifications to the service producer. Google Service Management currently only supports [Google Cloud Pub/Sub](https://cloud.google.com/pubsub) as a notification channel. To use Google Cloud Pub/Sub as the channel, this must be the name of a Cloud Pub/Sub topic that uses the Cloud Pub/Sub topic name format documented in https://cloud.google.com/pubsub/docs/overview.
        """
        return pulumi.get(self, "producer_notification_channel")

    @producer_notification_channel.setter
    def producer_notification_channel(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "producer_notification_channel", value)

    @property
    @pulumi.getter
    def requirements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Requirements that must be satisfied before a consumer project can use the service. Each requirement is of the form /; for example 'serviceusage.googleapis.com/billing-enabled'. For Google APIs, a Terms of Service requirement must be included here. Google Cloud APIs must include "serviceusage.googleapis.com/tos/cloud". Other Google APIs should include "serviceusage.googleapis.com/tos/universal". Additional ToS can be included based on the business needs.
        """
        return pulumi.get(self, "requirements")

    @requirements.setter
    def requirements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "requirements", value)

    @property
    @pulumi.getter
    def rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UsageRuleArgs']]]]:
        """
        A list of usage rules that apply to individual API methods. **NOTE:** All service configuration rules follow "last one wins" order.
        """
        return pulumi.get(self, "rules")

    @rules.setter
    def rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UsageRuleArgs']]]]):
        pulumi.set(self, "rules", value)


