# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'GoogleCloudIdentitytoolkitAdminV2AppleSignInConfigResponse',
    'GoogleCloudIdentitytoolkitAdminV2ClientPermissionConfigResponse',
    'GoogleCloudIdentitytoolkitAdminV2ClientPermissionsResponse',
    'GoogleCloudIdentitytoolkitAdminV2CodeFlowConfigResponse',
    'GoogleCloudIdentitytoolkitAdminV2HashConfigResponse',
    'GoogleCloudIdentitytoolkitAdminV2IdpCertificateResponse',
    'GoogleCloudIdentitytoolkitAdminV2IdpConfigResponse',
    'GoogleCloudIdentitytoolkitAdminV2InheritanceResponse',
    'GoogleCloudIdentitytoolkitAdminV2MultiFactorAuthConfigResponse',
    'GoogleCloudIdentitytoolkitAdminV2OAuthResponseTypeResponse',
    'GoogleCloudIdentitytoolkitAdminV2SpCertificateResponse',
    'GoogleCloudIdentitytoolkitAdminV2SpConfigResponse',
    'GoogleIamV1AuditConfigResponse',
    'GoogleIamV1AuditLogConfigResponse',
    'GoogleIamV1BindingResponse',
    'GoogleTypeExprResponse',
]

@pulumi.output_type
class GoogleCloudIdentitytoolkitAdminV2AppleSignInConfigResponse(dict):
    """
    Additional config for SignInWithApple.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bundleIds":
            suggest = "bundle_ids"
        elif key == "codeFlowConfig":
            suggest = "code_flow_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudIdentitytoolkitAdminV2AppleSignInConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudIdentitytoolkitAdminV2AppleSignInConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudIdentitytoolkitAdminV2AppleSignInConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bundle_ids: Sequence[str],
                 code_flow_config: 'outputs.GoogleCloudIdentitytoolkitAdminV2CodeFlowConfigResponse'):
        """
        Additional config for SignInWithApple.
        :param Sequence[str] bundle_ids: A list of Bundle ID's usable by this project
        """
        pulumi.set(__self__, "bundle_ids", bundle_ids)
        pulumi.set(__self__, "code_flow_config", code_flow_config)

    @property
    @pulumi.getter(name="bundleIds")
    def bundle_ids(self) -> Sequence[str]:
        """
        A list of Bundle ID's usable by this project
        """
        return pulumi.get(self, "bundle_ids")

    @property
    @pulumi.getter(name="codeFlowConfig")
    def code_flow_config(self) -> 'outputs.GoogleCloudIdentitytoolkitAdminV2CodeFlowConfigResponse':
        return pulumi.get(self, "code_flow_config")


@pulumi.output_type
class GoogleCloudIdentitytoolkitAdminV2ClientPermissionConfigResponse(dict):
    """
    Options related to how clients making requests on behalf of a tenant should be configured.
    """
    def __init__(__self__, *,
                 permissions: 'outputs.GoogleCloudIdentitytoolkitAdminV2ClientPermissionsResponse'):
        """
        Options related to how clients making requests on behalf of a tenant should be configured.
        :param 'GoogleCloudIdentitytoolkitAdminV2ClientPermissionsResponse' permissions: Configuration related to restricting a user's ability to affect their account.
        """
        pulumi.set(__self__, "permissions", permissions)

    @property
    @pulumi.getter
    def permissions(self) -> 'outputs.GoogleCloudIdentitytoolkitAdminV2ClientPermissionsResponse':
        """
        Configuration related to restricting a user's ability to affect their account.
        """
        return pulumi.get(self, "permissions")


@pulumi.output_type
class GoogleCloudIdentitytoolkitAdminV2ClientPermissionsResponse(dict):
    """
    Configuration related to restricting a user's ability to affect their account.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disabledUserDeletion":
            suggest = "disabled_user_deletion"
        elif key == "disabledUserSignup":
            suggest = "disabled_user_signup"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudIdentitytoolkitAdminV2ClientPermissionsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudIdentitytoolkitAdminV2ClientPermissionsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudIdentitytoolkitAdminV2ClientPermissionsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled_user_deletion: bool,
                 disabled_user_signup: bool):
        """
        Configuration related to restricting a user's ability to affect their account.
        :param bool disabled_user_deletion: When true, end users cannot delete their account on the associated project through any of our API methods
        :param bool disabled_user_signup: When true, end users cannot sign up for a new account on the associated project through any of our API methods
        """
        pulumi.set(__self__, "disabled_user_deletion", disabled_user_deletion)
        pulumi.set(__self__, "disabled_user_signup", disabled_user_signup)

    @property
    @pulumi.getter(name="disabledUserDeletion")
    def disabled_user_deletion(self) -> bool:
        """
        When true, end users cannot delete their account on the associated project through any of our API methods
        """
        return pulumi.get(self, "disabled_user_deletion")

    @property
    @pulumi.getter(name="disabledUserSignup")
    def disabled_user_signup(self) -> bool:
        """
        When true, end users cannot sign up for a new account on the associated project through any of our API methods
        """
        return pulumi.get(self, "disabled_user_signup")


@pulumi.output_type
class GoogleCloudIdentitytoolkitAdminV2CodeFlowConfigResponse(dict):
    """
    Additional config for Apple for code flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyId":
            suggest = "key_id"
        elif key == "privateKey":
            suggest = "private_key"
        elif key == "teamId":
            suggest = "team_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudIdentitytoolkitAdminV2CodeFlowConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudIdentitytoolkitAdminV2CodeFlowConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudIdentitytoolkitAdminV2CodeFlowConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_id: str,
                 private_key: str,
                 team_id: str):
        """
        Additional config for Apple for code flow.
        :param str key_id: Key ID for the private key.
        :param str private_key: Private key used for signing the client secret JWT.
        :param str team_id: Apple Developer Team ID.
        """
        pulumi.set(__self__, "key_id", key_id)
        pulumi.set(__self__, "private_key", private_key)
        pulumi.set(__self__, "team_id", team_id)

    @property
    @pulumi.getter(name="keyId")
    def key_id(self) -> str:
        """
        Key ID for the private key.
        """
        return pulumi.get(self, "key_id")

    @property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> str:
        """
        Private key used for signing the client secret JWT.
        """
        return pulumi.get(self, "private_key")

    @property
    @pulumi.getter(name="teamId")
    def team_id(self) -> str:
        """
        Apple Developer Team ID.
        """
        return pulumi.get(self, "team_id")


@pulumi.output_type
class GoogleCloudIdentitytoolkitAdminV2HashConfigResponse(dict):
    """
    History information of the hash algorithm and key. Different accounts' passwords may be generated by different version.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryCost":
            suggest = "memory_cost"
        elif key == "saltSeparator":
            suggest = "salt_separator"
        elif key == "signerKey":
            suggest = "signer_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudIdentitytoolkitAdminV2HashConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudIdentitytoolkitAdminV2HashConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudIdentitytoolkitAdminV2HashConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: str,
                 memory_cost: int,
                 rounds: int,
                 salt_separator: str,
                 signer_key: str):
        """
        History information of the hash algorithm and key. Different accounts' passwords may be generated by different version.
        :param str algorithm: Different password hash algorithms used in Identity Toolkit.
        :param int memory_cost: Memory cost for hash calculation. Used by scrypt and other similar password derivation algorithms. See https://tools.ietf.org/html/rfc7914 for explanation of field.
        :param int rounds: How many rounds for hash calculation. Used by scrypt and other similar password derivation algorithms.
        :param str salt_separator: Non-printable character to be inserted between the salt and plain text password in base64.
        :param str signer_key: Signer key in base64.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "memory_cost", memory_cost)
        pulumi.set(__self__, "rounds", rounds)
        pulumi.set(__self__, "salt_separator", salt_separator)
        pulumi.set(__self__, "signer_key", signer_key)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        Different password hash algorithms used in Identity Toolkit.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter(name="memoryCost")
    def memory_cost(self) -> int:
        """
        Memory cost for hash calculation. Used by scrypt and other similar password derivation algorithms. See https://tools.ietf.org/html/rfc7914 for explanation of field.
        """
        return pulumi.get(self, "memory_cost")

    @property
    @pulumi.getter
    def rounds(self) -> int:
        """
        How many rounds for hash calculation. Used by scrypt and other similar password derivation algorithms.
        """
        return pulumi.get(self, "rounds")

    @property
    @pulumi.getter(name="saltSeparator")
    def salt_separator(self) -> str:
        """
        Non-printable character to be inserted between the salt and plain text password in base64.
        """
        return pulumi.get(self, "salt_separator")

    @property
    @pulumi.getter(name="signerKey")
    def signer_key(self) -> str:
        """
        Signer key in base64.
        """
        return pulumi.get(self, "signer_key")


@pulumi.output_type
class GoogleCloudIdentitytoolkitAdminV2IdpCertificateResponse(dict):
    """
    The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "x509Certificate":
            suggest = "x509_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudIdentitytoolkitAdminV2IdpCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudIdentitytoolkitAdminV2IdpCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudIdentitytoolkitAdminV2IdpCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 x509_certificate: str):
        """
        The IDP's certificate data to verify the signature in the SAMLResponse issued by the IDP.
        :param str x509_certificate: The x509 certificate
        """
        pulumi.set(__self__, "x509_certificate", x509_certificate)

    @property
    @pulumi.getter(name="x509Certificate")
    def x509_certificate(self) -> str:
        """
        The x509 certificate
        """
        return pulumi.get(self, "x509_certificate")


@pulumi.output_type
class GoogleCloudIdentitytoolkitAdminV2IdpConfigResponse(dict):
    """
    The SAML IdP (Identity Provider) configuration when the project acts as the relying party.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idpCertificates":
            suggest = "idp_certificates"
        elif key == "idpEntityId":
            suggest = "idp_entity_id"
        elif key == "signRequest":
            suggest = "sign_request"
        elif key == "ssoUrl":
            suggest = "sso_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudIdentitytoolkitAdminV2IdpConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudIdentitytoolkitAdminV2IdpConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudIdentitytoolkitAdminV2IdpConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idp_certificates: Sequence['outputs.GoogleCloudIdentitytoolkitAdminV2IdpCertificateResponse'],
                 idp_entity_id: str,
                 sign_request: bool,
                 sso_url: str):
        """
        The SAML IdP (Identity Provider) configuration when the project acts as the relying party.
        :param Sequence['GoogleCloudIdentitytoolkitAdminV2IdpCertificateResponse'] idp_certificates: IDP's public keys for verifying signature in the assertions.
        :param str idp_entity_id: Unique identifier for all SAML entities.
        :param bool sign_request: Indicates if outbounding SAMLRequest should be signed.
        :param str sso_url: URL to send Authentication request to.
        """
        pulumi.set(__self__, "idp_certificates", idp_certificates)
        pulumi.set(__self__, "idp_entity_id", idp_entity_id)
        pulumi.set(__self__, "sign_request", sign_request)
        pulumi.set(__self__, "sso_url", sso_url)

    @property
    @pulumi.getter(name="idpCertificates")
    def idp_certificates(self) -> Sequence['outputs.GoogleCloudIdentitytoolkitAdminV2IdpCertificateResponse']:
        """
        IDP's public keys for verifying signature in the assertions.
        """
        return pulumi.get(self, "idp_certificates")

    @property
    @pulumi.getter(name="idpEntityId")
    def idp_entity_id(self) -> str:
        """
        Unique identifier for all SAML entities.
        """
        return pulumi.get(self, "idp_entity_id")

    @property
    @pulumi.getter(name="signRequest")
    def sign_request(self) -> bool:
        """
        Indicates if outbounding SAMLRequest should be signed.
        """
        return pulumi.get(self, "sign_request")

    @property
    @pulumi.getter(name="ssoUrl")
    def sso_url(self) -> str:
        """
        URL to send Authentication request to.
        """
        return pulumi.get(self, "sso_url")


@pulumi.output_type
class GoogleCloudIdentitytoolkitAdminV2InheritanceResponse(dict):
    """
    Settings that the tenants will inherit from project level.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "emailSendingConfig":
            suggest = "email_sending_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudIdentitytoolkitAdminV2InheritanceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudIdentitytoolkitAdminV2InheritanceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudIdentitytoolkitAdminV2InheritanceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email_sending_config: bool):
        """
        Settings that the tenants will inherit from project level.
        :param bool email_sending_config: Whether to allow the tenant to inherit custom domains, email templates, and custom SMTP settings. If true, email sent from tenant will follow the project level email sending configurations. If false (by default), emails will go with the default settings with no customizations.
        """
        pulumi.set(__self__, "email_sending_config", email_sending_config)

    @property
    @pulumi.getter(name="emailSendingConfig")
    def email_sending_config(self) -> bool:
        """
        Whether to allow the tenant to inherit custom domains, email templates, and custom SMTP settings. If true, email sent from tenant will follow the project level email sending configurations. If false (by default), emails will go with the default settings with no customizations.
        """
        return pulumi.get(self, "email_sending_config")


@pulumi.output_type
class GoogleCloudIdentitytoolkitAdminV2MultiFactorAuthConfigResponse(dict):
    """
    Options related to MultiFactor Authentication for the project.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enabledProviders":
            suggest = "enabled_providers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudIdentitytoolkitAdminV2MultiFactorAuthConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudIdentitytoolkitAdminV2MultiFactorAuthConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudIdentitytoolkitAdminV2MultiFactorAuthConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled_providers: Sequence[str],
                 state: str):
        """
        Options related to MultiFactor Authentication for the project.
        :param Sequence[str] enabled_providers: A list of usable second factors for this project.
        :param str state: Whether MultiFactor Authentication has been enabled for this project.
        """
        pulumi.set(__self__, "enabled_providers", enabled_providers)
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="enabledProviders")
    def enabled_providers(self) -> Sequence[str]:
        """
        A list of usable second factors for this project.
        """
        return pulumi.get(self, "enabled_providers")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Whether MultiFactor Authentication has been enabled for this project.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GoogleCloudIdentitytoolkitAdminV2OAuthResponseTypeResponse(dict):
    """
    The response type to request for in the OAuth authorization flow. You can set either `id_token` or `code` to true, but not both. Setting both types to be simultaneously true (`{code: true, id_token: true}`) is not yet supported. See https://openid.net/specs/openid-connect-core-1_0.html#Authentication for a mapping of response type to OAuth 2.0 flow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idToken":
            suggest = "id_token"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudIdentitytoolkitAdminV2OAuthResponseTypeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudIdentitytoolkitAdminV2OAuthResponseTypeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudIdentitytoolkitAdminV2OAuthResponseTypeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 code: bool,
                 id_token: bool,
                 token: bool):
        """
        The response type to request for in the OAuth authorization flow. You can set either `id_token` or `code` to true, but not both. Setting both types to be simultaneously true (`{code: true, id_token: true}`) is not yet supported. See https://openid.net/specs/openid-connect-core-1_0.html#Authentication for a mapping of response type to OAuth 2.0 flow.
        :param bool code: If true, authorization code is returned from IdP's authorization endpoint.
        :param bool id_token: If true, ID token is returned from IdP's authorization endpoint.
        :param bool token: Do not use. The `token` response type is not supported at the moment.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "id_token", id_token)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def code(self) -> bool:
        """
        If true, authorization code is returned from IdP's authorization endpoint.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter(name="idToken")
    def id_token(self) -> bool:
        """
        If true, ID token is returned from IdP's authorization endpoint.
        """
        return pulumi.get(self, "id_token")

    @property
    @pulumi.getter
    def token(self) -> bool:
        """
        Do not use. The `token` response type is not supported at the moment.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class GoogleCloudIdentitytoolkitAdminV2SpCertificateResponse(dict):
    """
    The SP's certificate data for IDP to verify the SAMLRequest generated by the SP.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiresAt":
            suggest = "expires_at"
        elif key == "x509Certificate":
            suggest = "x509_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudIdentitytoolkitAdminV2SpCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudIdentitytoolkitAdminV2SpCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudIdentitytoolkitAdminV2SpCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expires_at: str,
                 x509_certificate: str):
        """
        The SP's certificate data for IDP to verify the SAMLRequest generated by the SP.
        :param str expires_at: Timestamp of the cert expiration instance.
        :param str x509_certificate: Self-signed public certificate.
        """
        pulumi.set(__self__, "expires_at", expires_at)
        pulumi.set(__self__, "x509_certificate", x509_certificate)

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> str:
        """
        Timestamp of the cert expiration instance.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter(name="x509Certificate")
    def x509_certificate(self) -> str:
        """
        Self-signed public certificate.
        """
        return pulumi.get(self, "x509_certificate")


@pulumi.output_type
class GoogleCloudIdentitytoolkitAdminV2SpConfigResponse(dict):
    """
    The SAML SP (Service Provider) configuration when the project acts as the relying party to receive and accept an authentication assertion issued by a SAML identity provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "callbackUri":
            suggest = "callback_uri"
        elif key == "spCertificates":
            suggest = "sp_certificates"
        elif key == "spEntityId":
            suggest = "sp_entity_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudIdentitytoolkitAdminV2SpConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudIdentitytoolkitAdminV2SpConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudIdentitytoolkitAdminV2SpConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 callback_uri: str,
                 sp_certificates: Sequence['outputs.GoogleCloudIdentitytoolkitAdminV2SpCertificateResponse'],
                 sp_entity_id: str):
        """
        The SAML SP (Service Provider) configuration when the project acts as the relying party to receive and accept an authentication assertion issued by a SAML identity provider.
        :param str callback_uri: Callback URI where responses from IDP are handled.
        :param Sequence['GoogleCloudIdentitytoolkitAdminV2SpCertificateResponse'] sp_certificates: Public certificates generated by the server to verify the signature in SAMLRequest in the SP-initiated flow.
        :param str sp_entity_id: Unique identifier for all SAML entities.
        """
        pulumi.set(__self__, "callback_uri", callback_uri)
        pulumi.set(__self__, "sp_certificates", sp_certificates)
        pulumi.set(__self__, "sp_entity_id", sp_entity_id)

    @property
    @pulumi.getter(name="callbackUri")
    def callback_uri(self) -> str:
        """
        Callback URI where responses from IDP are handled.
        """
        return pulumi.get(self, "callback_uri")

    @property
    @pulumi.getter(name="spCertificates")
    def sp_certificates(self) -> Sequence['outputs.GoogleCloudIdentitytoolkitAdminV2SpCertificateResponse']:
        """
        Public certificates generated by the server to verify the signature in SAMLRequest in the SP-initiated flow.
        """
        return pulumi.get(self, "sp_certificates")

    @property
    @pulumi.getter(name="spEntityId")
    def sp_entity_id(self) -> str:
        """
        Unique identifier for all SAML entities.
        """
        return pulumi.get(self, "sp_entity_id")


@pulumi.output_type
class GoogleIamV1AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.GoogleIamV1AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['GoogleIamV1AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.GoogleIamV1AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class GoogleIamV1AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleIamV1AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleIamV1AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleIamV1AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class GoogleIamV1BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.GoogleTypeExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'GoogleTypeExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.GoogleTypeExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class GoogleTypeExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


