# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities

__all__ = [
    'GetIdentityAwareProxyClientResult',
    'AwaitableGetIdentityAwareProxyClientResult',
    'get_identity_aware_proxy_client',
    'get_identity_aware_proxy_client_output',
]

@pulumi.output_type
class GetIdentityAwareProxyClientResult:
    def __init__(__self__, display_name=None, name=None, secret=None):
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if secret and not isinstance(secret, str):
            raise TypeError("Expected argument 'secret' to be a str")
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Human-friendly name given to the OAuth client.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique identifier of the OAuth client.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> str:
        """
        Client secret of the OAuth client.
        """
        return pulumi.get(self, "secret")


class AwaitableGetIdentityAwareProxyClientResult(GetIdentityAwareProxyClientResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIdentityAwareProxyClientResult(
            display_name=self.display_name,
            name=self.name,
            secret=self.secret)


def get_identity_aware_proxy_client(brand_id: Optional[str] = None,
                                    identity_aware_proxy_client_id: Optional[str] = None,
                                    project: Optional[str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIdentityAwareProxyClientResult:
    """
    Retrieves an Identity Aware Proxy (IAP) OAuth client. Requires that the client is owned by IAP.
    """
    __args__ = dict()
    __args__['brandId'] = brand_id
    __args__['identityAwareProxyClientId'] = identity_aware_proxy_client_id
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:iap/v1:getIdentityAwareProxyClient', __args__, opts=opts, typ=GetIdentityAwareProxyClientResult).value

    return AwaitableGetIdentityAwareProxyClientResult(
        display_name=__ret__.display_name,
        name=__ret__.name,
        secret=__ret__.secret)


@_utilities.lift_output_func(get_identity_aware_proxy_client)
def get_identity_aware_proxy_client_output(brand_id: Optional[pulumi.Input[str]] = None,
                                           identity_aware_proxy_client_id: Optional[pulumi.Input[str]] = None,
                                           project: Optional[pulumi.Input[Optional[str]]] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIdentityAwareProxyClientResult]:
    """
    Retrieves an Identity Aware Proxy (IAP) OAuth client. Requires that the client is owned by IAP.
    """
    ...
