# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AnnotationConfigResponse',
    'AnnotationSourceResponse',
    'AttributeResponse',
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'BindingResponse',
    'BoundingPolyResponse',
    'CharacterMaskConfigResponse',
    'CloudHealthcareSourceResponse',
    'CryptoHashConfigResponse',
    'DateShiftConfigResponse',
    'DeidentifiedStoreDestinationResponse',
    'DeidentifyConfigResponse',
    'DeidentifyOperationMetadataResponse',
    'DicomConfigResponse',
    'ExprResponse',
    'FhirConfigResponse',
    'FhirNotificationConfigResponse',
    'FhirOutputResponse',
    'FieldMetadataResponse',
    'FieldResponse',
    'GoogleCloudHealthcareV1beta1ConsentPolicyResponse',
    'GoogleCloudHealthcareV1beta1DicomBigQueryDestinationResponse',
    'GoogleCloudHealthcareV1beta1DicomStreamConfigResponse',
    'GoogleCloudHealthcareV1beta1FhirBigQueryDestinationResponse',
    'Hl7SchemaConfigResponse',
    'Hl7TypesConfigResponse',
    'Hl7V2NotificationConfigResponse',
    'ImageAnnotationResponse',
    'ImageConfigResponse',
    'ImageResponse',
    'InfoTypeTransformationResponse',
    'KmsWrappedCryptoKeyResponse',
    'NotificationConfigResponse',
    'ParsedDataResponse',
    'ParserConfigResponse',
    'PatientIdResponse',
    'RedactConfigResponse',
    'ReplaceWithInfoTypeConfigResponse',
    'ResourceAnnotationResponse',
    'SchemaConfigResponse',
    'SchemaPackageResponse',
    'SchematizedDataResponse',
    'SearchConfigResponse',
    'SearchParameterResponse',
    'SegmentResponse',
    'SensitiveTextAnnotationResponse',
    'SignatureResponse',
    'StreamConfigResponse',
    'TagFilterListResponse',
    'TextConfigResponse',
    'TypeResponse',
    'ValidationConfigResponse',
    'VersionSourceResponse',
    'VertexResponse',
]

@pulumi.output_type
class AnnotationConfigResponse(dict):
    """
    Specifies how to store annotations during de-identification operation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "annotationStoreName":
            suggest = "annotation_store_name"
        elif key == "storeQuote":
            suggest = "store_quote"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnnotationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnnotationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnnotationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotation_store_name: str,
                 store_quote: bool):
        """
        Specifies how to store annotations during de-identification operation.
        :param str annotation_store_name: The name of the annotation store, in the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotationStores/{annotation_store_id}`). * The destination annotation store must be in the same project as the source data. De-identifying data across multiple projects is not supported. * The destination annotation store must exist when using DeidentifyDicomStore or DeidentifyFhirStore. DeidentifyDataset automatically creates the destination annotation store.
        :param bool store_quote: If set to true, the sensitive texts are included in SensitiveTextAnnotation of Annotation.
        """
        pulumi.set(__self__, "annotation_store_name", annotation_store_name)
        pulumi.set(__self__, "store_quote", store_quote)

    @property
    @pulumi.getter(name="annotationStoreName")
    def annotation_store_name(self) -> str:
        """
        The name of the annotation store, in the form `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/annotationStores/{annotation_store_id}`). * The destination annotation store must be in the same project as the source data. De-identifying data across multiple projects is not supported. * The destination annotation store must exist when using DeidentifyDicomStore or DeidentifyFhirStore. DeidentifyDataset automatically creates the destination annotation store.
        """
        return pulumi.get(self, "annotation_store_name")

    @property
    @pulumi.getter(name="storeQuote")
    def store_quote(self) -> bool:
        """
        If set to true, the sensitive texts are included in SensitiveTextAnnotation of Annotation.
        """
        return pulumi.get(self, "store_quote")


@pulumi.output_type
class AnnotationSourceResponse(dict):
    """
    AnnotationSource holds the source information of the annotation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudHealthcareSource":
            suggest = "cloud_healthcare_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AnnotationSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AnnotationSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AnnotationSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_healthcare_source: 'outputs.CloudHealthcareSourceResponse'):
        """
        AnnotationSource holds the source information of the annotation.
        :param 'CloudHealthcareSourceResponse' cloud_healthcare_source: Cloud Healthcare API resource.
        """
        pulumi.set(__self__, "cloud_healthcare_source", cloud_healthcare_source)

    @property
    @pulumi.getter(name="cloudHealthcareSource")
    def cloud_healthcare_source(self) -> 'outputs.CloudHealthcareSourceResponse':
        """
        Cloud Healthcare API resource.
        """
        return pulumi.get(self, "cloud_healthcare_source")


@pulumi.output_type
class AttributeResponse(dict):
    """
    An attribute value for a Consent or User data mapping. Each Attribute must have a corresponding AttributeDefinition in the consent store that defines the default and allowed values.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "attributeDefinitionId":
            suggest = "attribute_definition_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AttributeResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AttributeResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AttributeResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 attribute_definition_id: str,
                 values: Sequence[str]):
        """
        An attribute value for a Consent or User data mapping. Each Attribute must have a corresponding AttributeDefinition in the consent store that defines the default and allowed values.
        :param str attribute_definition_id: Indicates the name of an attribute defined in the consent store.
        :param Sequence[str] values: The value of the attribute. Must be an acceptable value as defined in the consent store. For example, if the consent store defines "data type" with acceptable values "questionnaire" and "step-count", when the attribute name is data type, this field must contain one of those values.
        """
        pulumi.set(__self__, "attribute_definition_id", attribute_definition_id)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="attributeDefinitionId")
    def attribute_definition_id(self) -> str:
        """
        Indicates the name of an attribute defined in the consent store.
        """
        return pulumi.get(self, "attribute_definition_id")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        The value of the attribute. Must be an acceptable value as defined in the consent store. For example, if the consent store defines "data type" with acceptable values "questionnaire" and "step-count", when the attribute name is data type, this field must contain one of those values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class BoundingPolyResponse(dict):
    """
    A bounding polygon for the detected image annotation.
    """
    def __init__(__self__, *,
                 label: str,
                 vertices: Sequence['outputs.VertexResponse']):
        """
        A bounding polygon for the detected image annotation.
        :param str label: A description of this polygon.
        :param Sequence['VertexResponse'] vertices: List of the vertices of this polygon.
        """
        pulumi.set(__self__, "label", label)
        pulumi.set(__self__, "vertices", vertices)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        A description of this polygon.
        """
        return pulumi.get(self, "label")

    @property
    @pulumi.getter
    def vertices(self) -> Sequence['outputs.VertexResponse']:
        """
        List of the vertices of this polygon.
        """
        return pulumi.get(self, "vertices")


@pulumi.output_type
class CharacterMaskConfigResponse(dict):
    """
    Mask a string by replacing its characters with a fixed character.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maskingCharacter":
            suggest = "masking_character"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CharacterMaskConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CharacterMaskConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CharacterMaskConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 masking_character: str):
        """
        Mask a string by replacing its characters with a fixed character.
        :param str masking_character: Character to mask the sensitive values. If not supplied, defaults to "*".
        """
        pulumi.set(__self__, "masking_character", masking_character)

    @property
    @pulumi.getter(name="maskingCharacter")
    def masking_character(self) -> str:
        """
        Character to mask the sensitive values. If not supplied, defaults to "*".
        """
        return pulumi.get(self, "masking_character")


@pulumi.output_type
class CloudHealthcareSourceResponse(dict):
    """
    Cloud Healthcare API resource.
    """
    def __init__(__self__, *,
                 name: str):
        """
        Cloud Healthcare API resource.
        :param str name: Full path of a Cloud Healthcare API resource.
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Full path of a Cloud Healthcare API resource.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CryptoHashConfigResponse(dict):
    """
    Pseudonymization method that generates surrogates via cryptographic hashing. Uses SHA-256. Outputs a base64-encoded representation of the hashed output. For example, `L7k0BHmF1ha5U3NfGykjro4xWi1MPVQPjhMAZbSV9mM=`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cryptoKey":
            suggest = "crypto_key"
        elif key == "kmsWrapped":
            suggest = "kms_wrapped"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CryptoHashConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CryptoHashConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CryptoHashConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crypto_key: str,
                 kms_wrapped: 'outputs.KmsWrappedCryptoKeyResponse'):
        """
        Pseudonymization method that generates surrogates via cryptographic hashing. Uses SHA-256. Outputs a base64-encoded representation of the hashed output. For example, `L7k0BHmF1ha5U3NfGykjro4xWi1MPVQPjhMAZbSV9mM=`.
        :param str crypto_key: An AES 128/192/256 bit key. Causes the hash to be computed based on this key. A default key is generated for each Deidentify operation and is used when neither `crypto_key` nor `kms_wrapped` is specified. Must not be set if `kms_wrapped` is set.
        :param 'KmsWrappedCryptoKeyResponse' kms_wrapped: KMS wrapped key. Must not be set if `crypto_key` is set.
        """
        pulumi.set(__self__, "crypto_key", crypto_key)
        pulumi.set(__self__, "kms_wrapped", kms_wrapped)

    @property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> str:
        """
        An AES 128/192/256 bit key. Causes the hash to be computed based on this key. A default key is generated for each Deidentify operation and is used when neither `crypto_key` nor `kms_wrapped` is specified. Must not be set if `kms_wrapped` is set.
        """
        return pulumi.get(self, "crypto_key")

    @property
    @pulumi.getter(name="kmsWrapped")
    def kms_wrapped(self) -> 'outputs.KmsWrappedCryptoKeyResponse':
        """
        KMS wrapped key. Must not be set if `crypto_key` is set.
        """
        return pulumi.get(self, "kms_wrapped")


@pulumi.output_type
class DateShiftConfigResponse(dict):
    """
    Shift a date forward or backward in time by a random amount which is consistent for a given patient and crypto key combination.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cryptoKey":
            suggest = "crypto_key"
        elif key == "kmsWrapped":
            suggest = "kms_wrapped"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DateShiftConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DateShiftConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DateShiftConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crypto_key: str,
                 kms_wrapped: 'outputs.KmsWrappedCryptoKeyResponse'):
        """
        Shift a date forward or backward in time by a random amount which is consistent for a given patient and crypto key combination.
        :param str crypto_key: An AES 128/192/256 bit key. Causes the shift to be computed based on this key and the patient ID. A default key is generated for each de-identification operation and is used when neither `crypto_key` nor `kms_wrapped` is specified. Must not be set if `kms_wrapped` is set.
        :param 'KmsWrappedCryptoKeyResponse' kms_wrapped: KMS wrapped key. Must not be set if `crypto_key` is set.
        """
        pulumi.set(__self__, "crypto_key", crypto_key)
        pulumi.set(__self__, "kms_wrapped", kms_wrapped)

    @property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> str:
        """
        An AES 128/192/256 bit key. Causes the shift to be computed based on this key and the patient ID. A default key is generated for each de-identification operation and is used when neither `crypto_key` nor `kms_wrapped` is specified. Must not be set if `kms_wrapped` is set.
        """
        return pulumi.get(self, "crypto_key")

    @property
    @pulumi.getter(name="kmsWrapped")
    def kms_wrapped(self) -> 'outputs.KmsWrappedCryptoKeyResponse':
        """
        KMS wrapped key. Must not be set if `crypto_key` is set.
        """
        return pulumi.get(self, "kms_wrapped")


@pulumi.output_type
class DeidentifiedStoreDestinationResponse(dict):
    """
    Contains configuration for streaming de-identified FHIR export.
    """
    def __init__(__self__, *,
                 config: 'outputs.DeidentifyConfigResponse',
                 store: str):
        """
        Contains configuration for streaming de-identified FHIR export.
        :param 'DeidentifyConfigResponse' config: The configuration to use when de-identifying resources that are added to this store.
        :param str store: The full resource name of a Cloud Healthcare FHIR store, for example, `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
        """
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "store", store)

    @property
    @pulumi.getter
    def config(self) -> 'outputs.DeidentifyConfigResponse':
        """
        The configuration to use when de-identifying resources that are added to this store.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def store(self) -> str:
        """
        The full resource name of a Cloud Healthcare FHIR store, for example, `projects/{project_id}/locations/{location_id}/datasets/{dataset_id}/fhirStores/{fhir_store_id}`.
        """
        return pulumi.get(self, "store")


@pulumi.output_type
class DeidentifyConfigResponse(dict):
    """
    Configures de-id options specific to different types of content. Each submessage customizes the handling of an https://tools.ietf.org/html/rfc6838 media type or subtype. Configs are applied in a nested manner at runtime.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operationMetadata":
            suggest = "operation_metadata"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeidentifyConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeidentifyConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeidentifyConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotation: 'outputs.AnnotationConfigResponse',
                 dicom: 'outputs.DicomConfigResponse',
                 fhir: 'outputs.FhirConfigResponse',
                 image: 'outputs.ImageConfigResponse',
                 operation_metadata: 'outputs.DeidentifyOperationMetadataResponse',
                 text: 'outputs.TextConfigResponse'):
        """
        Configures de-id options specific to different types of content. Each submessage customizes the handling of an https://tools.ietf.org/html/rfc6838 media type or subtype. Configs are applied in a nested manner at runtime.
        :param 'AnnotationConfigResponse' annotation: Configures how annotations, meaning that the location and infoType of sensitive information findings, are created during de-identification. If unspecified, no annotations are created.
        :param 'DicomConfigResponse' dicom: Configures de-id of application/DICOM content.
        :param 'FhirConfigResponse' fhir: Configures de-id of application/FHIR content.
        :param 'ImageConfigResponse' image: Configures de-identification of image pixels wherever they are found in the source_dataset.
        :param 'DeidentifyOperationMetadataResponse' operation_metadata: Details about the work the de-identify operation performed.
        :param 'TextConfigResponse' text: Configures de-identification of text wherever it is found in the source_dataset.
        """
        pulumi.set(__self__, "annotation", annotation)
        pulumi.set(__self__, "dicom", dicom)
        pulumi.set(__self__, "fhir", fhir)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "operation_metadata", operation_metadata)
        pulumi.set(__self__, "text", text)

    @property
    @pulumi.getter
    def annotation(self) -> 'outputs.AnnotationConfigResponse':
        """
        Configures how annotations, meaning that the location and infoType of sensitive information findings, are created during de-identification. If unspecified, no annotations are created.
        """
        return pulumi.get(self, "annotation")

    @property
    @pulumi.getter
    def dicom(self) -> 'outputs.DicomConfigResponse':
        """
        Configures de-id of application/DICOM content.
        """
        return pulumi.get(self, "dicom")

    @property
    @pulumi.getter
    def fhir(self) -> 'outputs.FhirConfigResponse':
        """
        Configures de-id of application/FHIR content.
        """
        return pulumi.get(self, "fhir")

    @property
    @pulumi.getter
    def image(self) -> 'outputs.ImageConfigResponse':
        """
        Configures de-identification of image pixels wherever they are found in the source_dataset.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="operationMetadata")
    def operation_metadata(self) -> 'outputs.DeidentifyOperationMetadataResponse':
        """
        Details about the work the de-identify operation performed.
        """
        return pulumi.get(self, "operation_metadata")

    @property
    @pulumi.getter
    def text(self) -> 'outputs.TextConfigResponse':
        """
        Configures de-identification of text wherever it is found in the source_dataset.
        """
        return pulumi.get(self, "text")


@pulumi.output_type
class DeidentifyOperationMetadataResponse(dict):
    """
    Details about the work the de-identify operation performed.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fhirOutput":
            suggest = "fhir_output"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeidentifyOperationMetadataResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeidentifyOperationMetadataResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeidentifyOperationMetadataResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fhir_output: 'outputs.FhirOutputResponse'):
        """
        Details about the work the de-identify operation performed.
        :param 'FhirOutputResponse' fhir_output: Details about the FHIR store to write the output to.
        """
        pulumi.set(__self__, "fhir_output", fhir_output)

    @property
    @pulumi.getter(name="fhirOutput")
    def fhir_output(self) -> 'outputs.FhirOutputResponse':
        """
        Details about the FHIR store to write the output to.
        """
        return pulumi.get(self, "fhir_output")


@pulumi.output_type
class DicomConfigResponse(dict):
    """
    Specifies the parameters needed for de-identification of DICOM stores.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filterProfile":
            suggest = "filter_profile"
        elif key == "keepList":
            suggest = "keep_list"
        elif key == "removeList":
            suggest = "remove_list"
        elif key == "skipIdRedaction":
            suggest = "skip_id_redaction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DicomConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DicomConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DicomConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter_profile: str,
                 keep_list: 'outputs.TagFilterListResponse',
                 remove_list: 'outputs.TagFilterListResponse',
                 skip_id_redaction: bool):
        """
        Specifies the parameters needed for de-identification of DICOM stores.
        :param str filter_profile: Tag filtering profile that determines which tags to keep/remove.
        :param 'TagFilterListResponse' keep_list: List of tags to keep. Remove all other tags.
        :param 'TagFilterListResponse' remove_list: List of tags to remove. Keep all other tags.
        :param bool skip_id_redaction: If true, skip replacing StudyInstanceUID, SeriesInstanceUID, SOPInstanceUID, and MediaStorageSOPInstanceUID and leave them untouched. The Cloud Healthcare API regenerates these UIDs by default based on the DICOM Standard's reasoning: "Whilst these UIDs cannot be mapped directly to an individual out of context, given access to the original images, or to a database of the original images containing the UIDs, it would be possible to recover the individual's identity." http://dicom.nema.org/medical/dicom/current/output/chtml/part15/sect_E.3.9.html
        """
        pulumi.set(__self__, "filter_profile", filter_profile)
        pulumi.set(__self__, "keep_list", keep_list)
        pulumi.set(__self__, "remove_list", remove_list)
        pulumi.set(__self__, "skip_id_redaction", skip_id_redaction)

    @property
    @pulumi.getter(name="filterProfile")
    def filter_profile(self) -> str:
        """
        Tag filtering profile that determines which tags to keep/remove.
        """
        return pulumi.get(self, "filter_profile")

    @property
    @pulumi.getter(name="keepList")
    def keep_list(self) -> 'outputs.TagFilterListResponse':
        """
        List of tags to keep. Remove all other tags.
        """
        return pulumi.get(self, "keep_list")

    @property
    @pulumi.getter(name="removeList")
    def remove_list(self) -> 'outputs.TagFilterListResponse':
        """
        List of tags to remove. Keep all other tags.
        """
        return pulumi.get(self, "remove_list")

    @property
    @pulumi.getter(name="skipIdRedaction")
    def skip_id_redaction(self) -> bool:
        """
        If true, skip replacing StudyInstanceUID, SeriesInstanceUID, SOPInstanceUID, and MediaStorageSOPInstanceUID and leave them untouched. The Cloud Healthcare API regenerates these UIDs by default based on the DICOM Standard's reasoning: "Whilst these UIDs cannot be mapped directly to an individual out of context, given access to the original images, or to a database of the original images containing the UIDs, it would be possible to recover the individual's identity." http://dicom.nema.org/medical/dicom/current/output/chtml/part15/sect_E.3.9.html
        """
        return pulumi.get(self, "skip_id_redaction")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class FhirConfigResponse(dict):
    """
    Specifies how to handle de-identification of a FHIR store.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultKeepExtensions":
            suggest = "default_keep_extensions"
        elif key == "fieldMetadataList":
            suggest = "field_metadata_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 default_keep_extensions: bool,
                 field_metadata_list: Sequence['outputs.FieldMetadataResponse']):
        """
        Specifies how to handle de-identification of a FHIR store.
        :param bool default_keep_extensions: The behaviour for handling FHIR extensions that aren't otherwise specified for de-identification. If true, all extensions are preserved during de-identification by default. If false or unspecified, all extensions are removed during de-identification by default.
        :param Sequence['FieldMetadataResponse'] field_metadata_list: Specifies FHIR paths to match and how to transform them. Any field that is not matched by a FieldMetadata is passed through to the output dataset unmodified. All extensions will be processed according to `default_keep_extensions`. If a field can be matched by more than one FieldMetadata, the first FieldMetadata.Action is applied.
        """
        pulumi.set(__self__, "default_keep_extensions", default_keep_extensions)
        pulumi.set(__self__, "field_metadata_list", field_metadata_list)

    @property
    @pulumi.getter(name="defaultKeepExtensions")
    def default_keep_extensions(self) -> bool:
        """
        The behaviour for handling FHIR extensions that aren't otherwise specified for de-identification. If true, all extensions are preserved during de-identification by default. If false or unspecified, all extensions are removed during de-identification by default.
        """
        return pulumi.get(self, "default_keep_extensions")

    @property
    @pulumi.getter(name="fieldMetadataList")
    def field_metadata_list(self) -> Sequence['outputs.FieldMetadataResponse']:
        """
        Specifies FHIR paths to match and how to transform them. Any field that is not matched by a FieldMetadata is passed through to the output dataset unmodified. All extensions will be processed according to `default_keep_extensions`. If a field can be matched by more than one FieldMetadata, the first FieldMetadata.Action is applied.
        """
        return pulumi.get(self, "field_metadata_list")


@pulumi.output_type
class FhirNotificationConfigResponse(dict):
    """
    Contains the configuration for FHIR notifications.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pubsubTopic":
            suggest = "pubsub_topic"
        elif key == "sendFullResource":
            suggest = "send_full_resource"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirNotificationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirNotificationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirNotificationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pubsub_topic: str,
                 send_full_resource: bool):
        """
        Contains the configuration for FHIR notifications.
        :param str pubsub_topic: The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. The notification is a `PubsubMessage` with the following fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the ID of this notification. It is guaranteed to be unique within the topic. * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. The Cloud Healthcare API service account, service-@gcp-sa-healthcare.iam.gserviceaccount.com, must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare-api/docs/how-tos/logging).
        :param bool send_full_resource: Whether to send full FHIR resource to this Pub/Sub topic for Create and Update operation. Note that setting this to true does not guarantee that all resources will be sent in the format of full FHIR resource. When a resource change is too large or during heavy traffic, only the resource name will be sent. Clients should always check the "payloadType" label from a Pub/Sub message to determine whether it needs to fetch the full resource as a separate operation.
        """
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        pulumi.set(__self__, "send_full_resource", send_full_resource)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> str:
        """
        The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. The notification is a `PubsubMessage` with the following fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the ID of this notification. It is guaranteed to be unique within the topic. * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. The Cloud Healthcare API service account, service-@gcp-sa-healthcare.iam.gserviceaccount.com, must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare-api/docs/how-tos/logging).
        """
        return pulumi.get(self, "pubsub_topic")

    @property
    @pulumi.getter(name="sendFullResource")
    def send_full_resource(self) -> bool:
        """
        Whether to send full FHIR resource to this Pub/Sub topic for Create and Update operation. Note that setting this to true does not guarantee that all resources will be sent in the format of full FHIR resource. When a resource change is too large or during heavy traffic, only the resource name will be sent. Clients should always check the "payloadType" label from a Pub/Sub message to determine whether it needs to fetch the full resource as a separate operation.
        """
        return pulumi.get(self, "send_full_resource")


@pulumi.output_type
class FhirOutputResponse(dict):
    """
    Details about the FHIR store to write the output to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fhirStore":
            suggest = "fhir_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FhirOutputResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FhirOutputResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FhirOutputResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fhir_store: str):
        """
        Details about the FHIR store to write the output to.
        :param str fhir_store: Name of the output FHIR store, which must already exist. You must grant the healthcare.fhirResources.update permission on the destination store to your project's **Cloud Healthcare Service Agent** [service account](https://cloud.google.com/healthcare/docs/how-tos/permissions-healthcare-api-gcp-products#the_cloud_healthcare_service_agent). The destination store must set `enable_update_create` to true. The destination store must use FHIR version R4. Writing these resources will consume FHIR operations quota from the project containing the source data. De-identify operation metadata is only generated for DICOM de-identification operations.
        """
        pulumi.set(__self__, "fhir_store", fhir_store)

    @property
    @pulumi.getter(name="fhirStore")
    def fhir_store(self) -> str:
        """
        Name of the output FHIR store, which must already exist. You must grant the healthcare.fhirResources.update permission on the destination store to your project's **Cloud Healthcare Service Agent** [service account](https://cloud.google.com/healthcare/docs/how-tos/permissions-healthcare-api-gcp-products#the_cloud_healthcare_service_agent). The destination store must set `enable_update_create` to true. The destination store must use FHIR version R4. Writing these resources will consume FHIR operations quota from the project containing the source data. De-identify operation metadata is only generated for DICOM de-identification operations.
        """
        return pulumi.get(self, "fhir_store")


@pulumi.output_type
class FieldMetadataResponse(dict):
    """
    Specifies FHIR paths to match, and how to handle de-identification of matching fields.
    """
    def __init__(__self__, *,
                 action: str,
                 paths: Sequence[str]):
        """
        Specifies FHIR paths to match, and how to handle de-identification of matching fields.
        :param str action: Deidentify action for one field.
        :param Sequence[str] paths: List of paths to FHIR fields to redact. Each path is a period-separated list where each component is either a field name or FHIR type name. All types begin with an upper case letter. For example, the resource field "Patient.Address.city", which uses a string type, can be matched by "Patient.Address.String". Path also supports partial matching. For example, "Patient.Address.city" can be matched by "Address.city" (Patient omitted). Partial matching and type matching can be combined. For example, "Patient.Address.city" can be matched by "Address.String". For "choice" types (those defined in the FHIR spec with the form: field[x]), use two separate components. For example, "deceasedAge.unit" is matched by "Deceased.Age.unit". Supported types are: AdministrativeGenderCode, Base64Binary, Boolean, Code, Date, DateTime, Decimal, HumanName, Id, Instant, Integer, LanguageCode, Markdown, Oid, PositiveInt, String, UnsignedInt, Uri, Uuid, Xhtml. The sub-type for HumanName(for example HumanName.given, HumanName.family) can be omitted.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "paths", paths)

    @property
    @pulumi.getter
    def action(self) -> str:
        """
        Deidentify action for one field.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        List of paths to FHIR fields to redact. Each path is a period-separated list where each component is either a field name or FHIR type name. All types begin with an upper case letter. For example, the resource field "Patient.Address.city", which uses a string type, can be matched by "Patient.Address.String". Path also supports partial matching. For example, "Patient.Address.city" can be matched by "Address.city" (Patient omitted). Partial matching and type matching can be combined. For example, "Patient.Address.city" can be matched by "Address.String". For "choice" types (those defined in the FHIR spec with the form: field[x]), use two separate components. For example, "deceasedAge.unit" is matched by "Deceased.Age.unit". Supported types are: AdministrativeGenderCode, Base64Binary, Boolean, Code, Date, DateTime, Decimal, HumanName, Id, Instant, Integer, LanguageCode, Markdown, Oid, PositiveInt, String, UnsignedInt, Uri, Uuid, Xhtml. The sub-type for HumanName(for example HumanName.given, HumanName.family) can be omitted.
        """
        return pulumi.get(self, "paths")


@pulumi.output_type
class FieldResponse(dict):
    """
    A (sub) field of a type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxOccurs":
            suggest = "max_occurs"
        elif key == "minOccurs":
            suggest = "min_occurs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FieldResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FieldResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FieldResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_occurs: int,
                 min_occurs: int,
                 name: str,
                 table: str,
                 type: str):
        """
        A (sub) field of a type.
        :param int max_occurs: The maximum number of times this field can be repeated. 0 or -1 means unbounded.
        :param int min_occurs: The minimum number of times this field must be present/repeated.
        :param str name: The name of the field. For example, "PID-1" or just "1".
        :param str table: The HL7v2 table this field refers to. For example, PID-15 (Patient's Primary Language) usually refers to table "0296".
        :param str type: The type of this field. A Type with this name must be defined in an Hl7TypesConfig.
        """
        pulumi.set(__self__, "max_occurs", max_occurs)
        pulumi.set(__self__, "min_occurs", min_occurs)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "table", table)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="maxOccurs")
    def max_occurs(self) -> int:
        """
        The maximum number of times this field can be repeated. 0 or -1 means unbounded.
        """
        return pulumi.get(self, "max_occurs")

    @property
    @pulumi.getter(name="minOccurs")
    def min_occurs(self) -> int:
        """
        The minimum number of times this field must be present/repeated.
        """
        return pulumi.get(self, "min_occurs")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the field. For example, "PID-1" or just "1".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def table(self) -> str:
        """
        The HL7v2 table this field refers to. For example, PID-15 (Patient's Primary Language) usually refers to table "0296".
        """
        return pulumi.get(self, "table")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of this field. A Type with this name must be defined in an Hl7TypesConfig.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GoogleCloudHealthcareV1beta1ConsentPolicyResponse(dict):
    """
    Represents a user's consent in terms of the resources that can be accessed and under what conditions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authorizationRule":
            suggest = "authorization_rule"
        elif key == "resourceAttributes":
            suggest = "resource_attributes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudHealthcareV1beta1ConsentPolicyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudHealthcareV1beta1ConsentPolicyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudHealthcareV1beta1ConsentPolicyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 authorization_rule: 'outputs.ExprResponse',
                 resource_attributes: Sequence['outputs.AttributeResponse']):
        """
        Represents a user's consent in terms of the resources that can be accessed and under what conditions.
        :param 'ExprResponse' authorization_rule: The request conditions to meet to grant access. In addition to any supported comparison operators, authorization rules may have `IN` operator as well as at most 10 logical operators that are limited to `AND` (`&&`), `OR` (`||`).
        :param Sequence['AttributeResponse'] resource_attributes: The resources that this policy applies to. A resource is a match if it matches all the attributes listed here. If empty, this policy applies to all User data mappings for the given user.
        """
        pulumi.set(__self__, "authorization_rule", authorization_rule)
        pulumi.set(__self__, "resource_attributes", resource_attributes)

    @property
    @pulumi.getter(name="authorizationRule")
    def authorization_rule(self) -> 'outputs.ExprResponse':
        """
        The request conditions to meet to grant access. In addition to any supported comparison operators, authorization rules may have `IN` operator as well as at most 10 logical operators that are limited to `AND` (`&&`), `OR` (`||`).
        """
        return pulumi.get(self, "authorization_rule")

    @property
    @pulumi.getter(name="resourceAttributes")
    def resource_attributes(self) -> Sequence['outputs.AttributeResponse']:
        """
        The resources that this policy applies to. A resource is a match if it matches all the attributes listed here. If empty, this policy applies to all User data mappings for the given user.
        """
        return pulumi.get(self, "resource_attributes")


@pulumi.output_type
class GoogleCloudHealthcareV1beta1DicomBigQueryDestinationResponse(dict):
    """
    The BigQuery table where the server writes output.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "tableUri":
            suggest = "table_uri"
        elif key == "writeDisposition":
            suggest = "write_disposition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudHealthcareV1beta1DicomBigQueryDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudHealthcareV1beta1DicomBigQueryDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudHealthcareV1beta1DicomBigQueryDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 force: bool,
                 table_uri: str,
                 write_disposition: str):
        """
        The BigQuery table where the server writes output.
        :param bool force: Use `write_disposition` instead. If `write_disposition` is specified, this parameter is ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is equivalent to write_disposition=WRITE_TRUNCATE.
        :param str table_uri: BigQuery URI to a table, up to 2000 characters long, in the format `bq://projectId.bqDatasetId.tableId`
        :param str write_disposition: Determines whether the existing table in the destination is to be overwritten or appended to. If a write_disposition is specified, the `force` parameter is ignored.
        """
        pulumi.set(__self__, "force", force)
        pulumi.set(__self__, "table_uri", table_uri)
        pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter
    def force(self) -> bool:
        """
        Use `write_disposition` instead. If `write_disposition` is specified, this parameter is ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is equivalent to write_disposition=WRITE_TRUNCATE.
        """
        return pulumi.get(self, "force")

    @property
    @pulumi.getter(name="tableUri")
    def table_uri(self) -> str:
        """
        BigQuery URI to a table, up to 2000 characters long, in the format `bq://projectId.bqDatasetId.tableId`
        """
        return pulumi.get(self, "table_uri")

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> str:
        """
        Determines whether the existing table in the destination is to be overwritten or appended to. If a write_disposition is specified, the `force` parameter is ignored.
        """
        return pulumi.get(self, "write_disposition")


@pulumi.output_type
class GoogleCloudHealthcareV1beta1DicomStreamConfigResponse(dict):
    """
    StreamConfig specifies configuration for a streaming DICOM export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigqueryDestination":
            suggest = "bigquery_destination"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudHealthcareV1beta1DicomStreamConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudHealthcareV1beta1DicomStreamConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudHealthcareV1beta1DicomStreamConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bigquery_destination: 'outputs.GoogleCloudHealthcareV1beta1DicomBigQueryDestinationResponse'):
        """
        StreamConfig specifies configuration for a streaming DICOM export.
        :param 'GoogleCloudHealthcareV1beta1DicomBigQueryDestinationResponse' bigquery_destination: Results are appended to this table. The server creates a new table in the given BigQuery dataset if the specified table does not exist. To enable the Cloud Healthcare API to write to your BigQuery table, you must give the Cloud Healthcare API service account the bigquery.dataEditor role. The service account is: `service-{PROJECT_NUMBER}@gcp-sa-healthcare.iam.gserviceaccount.com`. The PROJECT_NUMBER identifies the project that the DICOM store resides in. To get the project number, go to the Cloud Console Dashboard. It is recommended to not have a custom schema in the destination table which could conflict with the schema created by the Cloud Healthcare API. Instance deletions are not applied to the destination table. The destination's table schema will be automatically updated in case a new instance's data is incompatible with the current schema. The schema should not be updated manually as this can cause incompatibilies that cannot be resolved automatically. One resolution in this case is to delete the incompatible table and let the server recreate one, though the newly created table only contains data after the table recreation. BigQuery imposes a 1 MB limit on streaming insert row size, therefore any instance that generates more than 1 MB of BigQuery data will not be streamed. If an instance cannot be streamed to BigQuery, errors will be logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        """
        pulumi.set(__self__, "bigquery_destination", bigquery_destination)

    @property
    @pulumi.getter(name="bigqueryDestination")
    def bigquery_destination(self) -> 'outputs.GoogleCloudHealthcareV1beta1DicomBigQueryDestinationResponse':
        """
        Results are appended to this table. The server creates a new table in the given BigQuery dataset if the specified table does not exist. To enable the Cloud Healthcare API to write to your BigQuery table, you must give the Cloud Healthcare API service account the bigquery.dataEditor role. The service account is: `service-{PROJECT_NUMBER}@gcp-sa-healthcare.iam.gserviceaccount.com`. The PROJECT_NUMBER identifies the project that the DICOM store resides in. To get the project number, go to the Cloud Console Dashboard. It is recommended to not have a custom schema in the destination table which could conflict with the schema created by the Cloud Healthcare API. Instance deletions are not applied to the destination table. The destination's table schema will be automatically updated in case a new instance's data is incompatible with the current schema. The schema should not be updated manually as this can cause incompatibilies that cannot be resolved automatically. One resolution in this case is to delete the incompatible table and let the server recreate one, though the newly created table only contains data after the table recreation. BigQuery imposes a 1 MB limit on streaming insert row size, therefore any instance that generates more than 1 MB of BigQuery data will not be streamed. If an instance cannot be streamed to BigQuery, errors will be logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        """
        return pulumi.get(self, "bigquery_destination")


@pulumi.output_type
class GoogleCloudHealthcareV1beta1FhirBigQueryDestinationResponse(dict):
    """
    The configuration for exporting to BigQuery.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "datasetUri":
            suggest = "dataset_uri"
        elif key == "schemaConfig":
            suggest = "schema_config"
        elif key == "writeDisposition":
            suggest = "write_disposition"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleCloudHealthcareV1beta1FhirBigQueryDestinationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleCloudHealthcareV1beta1FhirBigQueryDestinationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleCloudHealthcareV1beta1FhirBigQueryDestinationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataset_uri: str,
                 force: bool,
                 schema_config: 'outputs.SchemaConfigResponse',
                 write_disposition: str):
        """
        The configuration for exporting to BigQuery.
        :param str dataset_uri: BigQuery URI to an existing dataset, up to 2000 characters long, in the format `bq://projectId.bqDatasetId`.
        :param bool force: Use `write_disposition` instead. If `write_disposition` is specified, this parameter is ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is equivalent to write_disposition=WRITE_TRUNCATE.
        :param 'SchemaConfigResponse' schema_config: The configuration for the exported BigQuery schema.
        :param str write_disposition: Determines if existing data in the destination dataset is overwritten, appended to, or not written if the tables contain data. If a write_disposition is specified, the `force` parameter is ignored.
        """
        pulumi.set(__self__, "dataset_uri", dataset_uri)
        pulumi.set(__self__, "force", force)
        pulumi.set(__self__, "schema_config", schema_config)
        pulumi.set(__self__, "write_disposition", write_disposition)

    @property
    @pulumi.getter(name="datasetUri")
    def dataset_uri(self) -> str:
        """
        BigQuery URI to an existing dataset, up to 2000 characters long, in the format `bq://projectId.bqDatasetId`.
        """
        return pulumi.get(self, "dataset_uri")

    @property
    @pulumi.getter
    def force(self) -> bool:
        """
        Use `write_disposition` instead. If `write_disposition` is specified, this parameter is ignored. force=false is equivalent to write_disposition=WRITE_EMPTY and force=true is equivalent to write_disposition=WRITE_TRUNCATE.
        """
        return pulumi.get(self, "force")

    @property
    @pulumi.getter(name="schemaConfig")
    def schema_config(self) -> 'outputs.SchemaConfigResponse':
        """
        The configuration for the exported BigQuery schema.
        """
        return pulumi.get(self, "schema_config")

    @property
    @pulumi.getter(name="writeDisposition")
    def write_disposition(self) -> str:
        """
        Determines if existing data in the destination dataset is overwritten, appended to, or not written if the tables contain data. If a write_disposition is specified, the `force` parameter is ignored.
        """
        return pulumi.get(self, "write_disposition")


@pulumi.output_type
class Hl7SchemaConfigResponse(dict):
    """
    Root config message for HL7v2 schema. This contains a schema structure of groups and segments, and filters that determine which messages to apply the schema structure to.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "messageSchemaConfigs":
            suggest = "message_schema_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Hl7SchemaConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Hl7SchemaConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Hl7SchemaConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 message_schema_configs: Mapping[str, str],
                 version: Sequence['outputs.VersionSourceResponse']):
        """
        Root config message for HL7v2 schema. This contains a schema structure of groups and segments, and filters that determine which messages to apply the schema structure to.
        :param Mapping[str, str] message_schema_configs: Map from each HL7v2 message type and trigger event pair, such as ADT_A04, to its schema configuration root group.
        :param Sequence['VersionSourceResponse'] version: Each VersionSource is tested and only if they all match is the schema used for the message.
        """
        pulumi.set(__self__, "message_schema_configs", message_schema_configs)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="messageSchemaConfigs")
    def message_schema_configs(self) -> Mapping[str, str]:
        """
        Map from each HL7v2 message type and trigger event pair, such as ADT_A04, to its schema configuration root group.
        """
        return pulumi.get(self, "message_schema_configs")

    @property
    @pulumi.getter
    def version(self) -> Sequence['outputs.VersionSourceResponse']:
        """
        Each VersionSource is tested and only if they all match is the schema used for the message.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class Hl7TypesConfigResponse(dict):
    """
    Root config for HL7v2 datatype definitions for a specific HL7v2 version.
    """
    def __init__(__self__, *,
                 type: Sequence['outputs.TypeResponse'],
                 version: Sequence['outputs.VersionSourceResponse']):
        """
        Root config for HL7v2 datatype definitions for a specific HL7v2 version.
        :param Sequence['TypeResponse'] type: The HL7v2 type definitions.
        :param Sequence['VersionSourceResponse'] version: The version selectors that this config applies to. A message must match ALL version sources to apply.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def type(self) -> Sequence['outputs.TypeResponse']:
        """
        The HL7v2 type definitions.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def version(self) -> Sequence['outputs.VersionSourceResponse']:
        """
        The version selectors that this config applies to. A message must match ALL version sources to apply.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class Hl7V2NotificationConfigResponse(dict):
    """
    Specifies where and whether to send notifications upon changes to a data store.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pubsubTopic":
            suggest = "pubsub_topic"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in Hl7V2NotificationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        Hl7V2NotificationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        Hl7V2NotificationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 filter: str,
                 pubsub_topic: str):
        """
        Specifies where and whether to send notifications upon changes to a data store.
        :param str filter: Restricts notifications sent for messages matching a filter. If this is empty, all messages are matched. The following syntax is available: * A string field value can be written as text inside quotation marks, for example `"query text"`. The only valid relational operation for text fields is equality (`=`), where text is searched within the field, rather than having the field be equal to the text. For example, `"Comment = great"` returns messages with `great` in the comment field. * A number field value can be written as an integer, a decimal, or an exponential. The valid relational operators for number fields are the equality operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * A date field value must be written in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format. Leading zeros are required for one-digit months and days. The valid relational operators for date fields are the equality operator (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field query expressions can be combined in one query by adding `AND` or `OR` operators between the expressions. If a boolean operator appears within a quoted string, it is not treated as special, it's just another part of the character string to be matched. You can prepend the `NOT` operator to an expression to negate it. Fields/functions available for filtering are: * `message_type`, from the MSH-9.1 field. For example, `NOT message_type = "ADT"`. * `send_date` or `sendDate`, the YYYY-MM-DD date the message was sent in the dataset's time_zone, from the MSH-7 segment. For example, `send_date < "2017-01-02"`. * `send_time`, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, `send_time < "2017-01-02T00:00:00-05:00"`. * `create_time`, the timestamp when the message was created in the HL7v2 store. Use the RFC3339 time format for comparisons. For example, `create_time < "2017-01-02T00:00:00-05:00"`. * `send_facility`, the care center that the message came from, from the MSH-4 segment. For example, `send_facility = "ABC"`. * `PatientId(value, type)`, which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, `PatientId("123456", "MRN")`. * `labels.x`, a string value of the label with key `x` as set using the Message.labels map. For example, `labels."priority"="high"`. The operator `:*` can be used to assert the existence of a label. For example, `labels."priority":*`.
        :param str pubsub_topic: The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. The notification is a `PubsubMessage` with the following fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the ID of this notification. It is guaranteed to be unique within the topic. * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. Cloud Healthcare API service account must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging).
        """
        pulumi.set(__self__, "filter", filter)
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)

    @property
    @pulumi.getter
    def filter(self) -> str:
        """
        Restricts notifications sent for messages matching a filter. If this is empty, all messages are matched. The following syntax is available: * A string field value can be written as text inside quotation marks, for example `"query text"`. The only valid relational operation for text fields is equality (`=`), where text is searched within the field, rather than having the field be equal to the text. For example, `"Comment = great"` returns messages with `great` in the comment field. * A number field value can be written as an integer, a decimal, or an exponential. The valid relational operators for number fields are the equality operator (`=`), along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * A date field value must be written in `yyyy-mm-dd` form. Fields with date and time use the RFC3339 time format. Leading zeros are required for one-digit months and days. The valid relational operators for date fields are the equality operator (`=`) , along with the less than/greater than operators (`<`, `<=`, `>`, `>=`). Note that there is no inequality (`!=`) operator. You can prepend the `NOT` operator to an expression to negate it. * Multiple field query expressions can be combined in one query by adding `AND` or `OR` operators between the expressions. If a boolean operator appears within a quoted string, it is not treated as special, it's just another part of the character string to be matched. You can prepend the `NOT` operator to an expression to negate it. Fields/functions available for filtering are: * `message_type`, from the MSH-9.1 field. For example, `NOT message_type = "ADT"`. * `send_date` or `sendDate`, the YYYY-MM-DD date the message was sent in the dataset's time_zone, from the MSH-7 segment. For example, `send_date < "2017-01-02"`. * `send_time`, the timestamp when the message was sent, using the RFC3339 time format for comparisons, from the MSH-7 segment. For example, `send_time < "2017-01-02T00:00:00-05:00"`. * `create_time`, the timestamp when the message was created in the HL7v2 store. Use the RFC3339 time format for comparisons. For example, `create_time < "2017-01-02T00:00:00-05:00"`. * `send_facility`, the care center that the message came from, from the MSH-4 segment. For example, `send_facility = "ABC"`. * `PatientId(value, type)`, which matches if the message lists a patient having an ID of the given value and type in the PID-2, PID-3, or PID-4 segments. For example, `PatientId("123456", "MRN")`. * `labels.x`, a string value of the label with key `x` as set using the Message.labels map. For example, `labels."priority"="high"`. The operator `:*` can be used to assert the existence of a label. For example, `labels."priority":*`.
        """
        return pulumi.get(self, "filter")

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> str:
        """
        The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. The notification is a `PubsubMessage` with the following fields: * `PubsubMessage.Data` contains the resource name. * `PubsubMessage.MessageId` is the ID of this notification. It is guaranteed to be unique within the topic. * `PubsubMessage.PublishTime` is the time when the message was published. Note that notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. Cloud Healthcare API service account must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging. For more information, see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging).
        """
        return pulumi.get(self, "pubsub_topic")


@pulumi.output_type
class ImageAnnotationResponse(dict):
    """
    Image annotation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boundingPolys":
            suggest = "bounding_polys"
        elif key == "frameIndex":
            suggest = "frame_index"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageAnnotationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageAnnotationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageAnnotationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bounding_polys: Sequence['outputs.BoundingPolyResponse'],
                 frame_index: int):
        """
        Image annotation.
        :param Sequence['BoundingPolyResponse'] bounding_polys: The list of polygons outlining the sensitive regions in the image.
        :param int frame_index: 0-based index of the image frame. For example, an image frame in a DICOM instance.
        """
        pulumi.set(__self__, "bounding_polys", bounding_polys)
        pulumi.set(__self__, "frame_index", frame_index)

    @property
    @pulumi.getter(name="boundingPolys")
    def bounding_polys(self) -> Sequence['outputs.BoundingPolyResponse']:
        """
        The list of polygons outlining the sensitive regions in the image.
        """
        return pulumi.get(self, "bounding_polys")

    @property
    @pulumi.getter(name="frameIndex")
    def frame_index(self) -> int:
        """
        0-based index of the image frame. For example, an image frame in a DICOM instance.
        """
        return pulumi.get(self, "frame_index")


@pulumi.output_type
class ImageConfigResponse(dict):
    """
    Specifies how to handle de-identification of image pixels.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "textRedactionMode":
            suggest = "text_redaction_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 text_redaction_mode: str):
        """
        Specifies how to handle de-identification of image pixels.
        :param str text_redaction_mode: Determines how to redact text from image.
        """
        pulumi.set(__self__, "text_redaction_mode", text_redaction_mode)

    @property
    @pulumi.getter(name="textRedactionMode")
    def text_redaction_mode(self) -> str:
        """
        Determines how to redact text from image.
        """
        return pulumi.get(self, "text_redaction_mode")


@pulumi.output_type
class ImageResponse(dict):
    """
    Raw bytes representing consent artifact content.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcsUri":
            suggest = "gcs_uri"
        elif key == "rawBytes":
            suggest = "raw_bytes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gcs_uri: str,
                 raw_bytes: str):
        """
        Raw bytes representing consent artifact content.
        :param str gcs_uri: Input only. Points to a Cloud Storage URI containing the consent artifact content. The URI must be in the following format: `gs://{bucket_id}/{object_id}`. The Cloud Healthcare API service account must have the `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage location. The consent artifact content at this URI is copied to a Cloud Storage location managed by the Cloud Healthcare API. Responses to fetching requests return the consent artifact content in raw_bytes.
        :param str raw_bytes: Consent artifact content represented as a stream of bytes. This field is populated when returned in GetConsentArtifact response, but not included in CreateConsentArtifact and ListConsentArtifact response.
        """
        pulumi.set(__self__, "gcs_uri", gcs_uri)
        pulumi.set(__self__, "raw_bytes", raw_bytes)

    @property
    @pulumi.getter(name="gcsUri")
    def gcs_uri(self) -> str:
        """
        Input only. Points to a Cloud Storage URI containing the consent artifact content. The URI must be in the following format: `gs://{bucket_id}/{object_id}`. The Cloud Healthcare API service account must have the `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage location. The consent artifact content at this URI is copied to a Cloud Storage location managed by the Cloud Healthcare API. Responses to fetching requests return the consent artifact content in raw_bytes.
        """
        return pulumi.get(self, "gcs_uri")

    @property
    @pulumi.getter(name="rawBytes")
    def raw_bytes(self) -> str:
        """
        Consent artifact content represented as a stream of bytes. This field is populated when returned in GetConsentArtifact response, but not included in CreateConsentArtifact and ListConsentArtifact response.
        """
        return pulumi.get(self, "raw_bytes")


@pulumi.output_type
class InfoTypeTransformationResponse(dict):
    """
    A transformation to apply to text that is identified as a specific info_type.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "characterMaskConfig":
            suggest = "character_mask_config"
        elif key == "cryptoHashConfig":
            suggest = "crypto_hash_config"
        elif key == "dateShiftConfig":
            suggest = "date_shift_config"
        elif key == "infoTypes":
            suggest = "info_types"
        elif key == "redactConfig":
            suggest = "redact_config"
        elif key == "replaceWithInfoTypeConfig":
            suggest = "replace_with_info_type_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InfoTypeTransformationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InfoTypeTransformationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InfoTypeTransformationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 character_mask_config: 'outputs.CharacterMaskConfigResponse',
                 crypto_hash_config: 'outputs.CryptoHashConfigResponse',
                 date_shift_config: 'outputs.DateShiftConfigResponse',
                 info_types: Sequence[str],
                 redact_config: 'outputs.RedactConfigResponse',
                 replace_with_info_type_config: 'outputs.ReplaceWithInfoTypeConfigResponse'):
        """
        A transformation to apply to text that is identified as a specific info_type.
        :param 'CharacterMaskConfigResponse' character_mask_config: Config for character mask.
        :param 'CryptoHashConfigResponse' crypto_hash_config: Config for crypto hash.
        :param 'DateShiftConfigResponse' date_shift_config: Config for date shift.
        :param Sequence[str] info_types: InfoTypes to apply this transformation to. If this is not specified, this transformation becomes the default transformation, and is used for any info_type that is not specified in another transformation.
        :param 'RedactConfigResponse' redact_config: Config for text redaction.
        :param 'ReplaceWithInfoTypeConfigResponse' replace_with_info_type_config: Config for replace with InfoType.
        """
        pulumi.set(__self__, "character_mask_config", character_mask_config)
        pulumi.set(__self__, "crypto_hash_config", crypto_hash_config)
        pulumi.set(__self__, "date_shift_config", date_shift_config)
        pulumi.set(__self__, "info_types", info_types)
        pulumi.set(__self__, "redact_config", redact_config)
        pulumi.set(__self__, "replace_with_info_type_config", replace_with_info_type_config)

    @property
    @pulumi.getter(name="characterMaskConfig")
    def character_mask_config(self) -> 'outputs.CharacterMaskConfigResponse':
        """
        Config for character mask.
        """
        return pulumi.get(self, "character_mask_config")

    @property
    @pulumi.getter(name="cryptoHashConfig")
    def crypto_hash_config(self) -> 'outputs.CryptoHashConfigResponse':
        """
        Config for crypto hash.
        """
        return pulumi.get(self, "crypto_hash_config")

    @property
    @pulumi.getter(name="dateShiftConfig")
    def date_shift_config(self) -> 'outputs.DateShiftConfigResponse':
        """
        Config for date shift.
        """
        return pulumi.get(self, "date_shift_config")

    @property
    @pulumi.getter(name="infoTypes")
    def info_types(self) -> Sequence[str]:
        """
        InfoTypes to apply this transformation to. If this is not specified, this transformation becomes the default transformation, and is used for any info_type that is not specified in another transformation.
        """
        return pulumi.get(self, "info_types")

    @property
    @pulumi.getter(name="redactConfig")
    def redact_config(self) -> 'outputs.RedactConfigResponse':
        """
        Config for text redaction.
        """
        return pulumi.get(self, "redact_config")

    @property
    @pulumi.getter(name="replaceWithInfoTypeConfig")
    def replace_with_info_type_config(self) -> 'outputs.ReplaceWithInfoTypeConfigResponse':
        """
        Config for replace with InfoType.
        """
        return pulumi.get(self, "replace_with_info_type_config")


@pulumi.output_type
class KmsWrappedCryptoKeyResponse(dict):
    """
    Include to use an existing data crypto key wrapped by KMS. The wrapped key must be a 128-, 192-, or 256-bit key. The key must grant the Cloud IAM permission `cloudkms.cryptoKeyVersions.useToDecrypt` to the project's Cloud Healthcare Service Agent service account. For more information, see [Creating a wrapped key] (https://cloud.google.com/dlp/docs/create-wrapped-key).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cryptoKey":
            suggest = "crypto_key"
        elif key == "wrappedKey":
            suggest = "wrapped_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KmsWrappedCryptoKeyResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KmsWrappedCryptoKeyResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KmsWrappedCryptoKeyResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 crypto_key: str,
                 wrapped_key: str):
        """
        Include to use an existing data crypto key wrapped by KMS. The wrapped key must be a 128-, 192-, or 256-bit key. The key must grant the Cloud IAM permission `cloudkms.cryptoKeyVersions.useToDecrypt` to the project's Cloud Healthcare Service Agent service account. For more information, see [Creating a wrapped key] (https://cloud.google.com/dlp/docs/create-wrapped-key).
        :param str crypto_key: The resource name of the KMS CryptoKey to use for unwrapping. For example, `projects/{project_id}/locations/{location_id}/keyRings/{keyring}/cryptoKeys/{key}`.
        :param str wrapped_key: The wrapped data crypto key.
        """
        pulumi.set(__self__, "crypto_key", crypto_key)
        pulumi.set(__self__, "wrapped_key", wrapped_key)

    @property
    @pulumi.getter(name="cryptoKey")
    def crypto_key(self) -> str:
        """
        The resource name of the KMS CryptoKey to use for unwrapping. For example, `projects/{project_id}/locations/{location_id}/keyRings/{keyring}/cryptoKeys/{key}`.
        """
        return pulumi.get(self, "crypto_key")

    @property
    @pulumi.getter(name="wrappedKey")
    def wrapped_key(self) -> str:
        """
        The wrapped data crypto key.
        """
        return pulumi.get(self, "wrapped_key")


@pulumi.output_type
class NotificationConfigResponse(dict):
    """
    Specifies where to send notifications upon changes to a data store.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pubsubTopic":
            suggest = "pubsub_topic"
        elif key == "sendForBulkImport":
            suggest = "send_for_bulk_import"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NotificationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NotificationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NotificationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pubsub_topic: str,
                 send_for_bulk_import: bool):
        """
        Specifies where to send notifications upon changes to a data store.
        :param str pubsub_topic: The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. PubsubMessage.Data contains the resource name. PubsubMessage.MessageId is the ID of this message. It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message was published. Notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. Cloud Healthcare API service account must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)). If the number of errors exceeds a certain rate, some aren't submitted. Note that not all operations trigger notifications, see [Configuring Pub/Sub notifications](https://cloud.google.com/healthcare/docs/how-tos/pubsub) for specific details.
        :param bool send_for_bulk_import: Indicates whether or not to send Pub/Sub notifications on bulk import. Only supported for DICOM imports.
        """
        pulumi.set(__self__, "pubsub_topic", pubsub_topic)
        pulumi.set(__self__, "send_for_bulk_import", send_for_bulk_import)

    @property
    @pulumi.getter(name="pubsubTopic")
    def pubsub_topic(self) -> str:
        """
        The [Pub/Sub](https://cloud.google.com/pubsub/docs/) topic that notifications of changes are published on. Supplied by the client. PubsubMessage.Data contains the resource name. PubsubMessage.MessageId is the ID of this message. It is guaranteed to be unique within the topic. PubsubMessage.PublishTime is the time at which the message was published. Notifications are only sent if the topic is non-empty. [Topic names](https://cloud.google.com/pubsub/docs/overview#names) must be scoped to a project. Cloud Healthcare API service account must have publisher permissions on the given Pub/Sub topic. Not having adequate permissions causes the calls that send notifications to fail. If a notification can't be published to Pub/Sub, errors are logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)). If the number of errors exceeds a certain rate, some aren't submitted. Note that not all operations trigger notifications, see [Configuring Pub/Sub notifications](https://cloud.google.com/healthcare/docs/how-tos/pubsub) for specific details.
        """
        return pulumi.get(self, "pubsub_topic")

    @property
    @pulumi.getter(name="sendForBulkImport")
    def send_for_bulk_import(self) -> bool:
        """
        Indicates whether or not to send Pub/Sub notifications on bulk import. Only supported for DICOM imports.
        """
        return pulumi.get(self, "send_for_bulk_import")


@pulumi.output_type
class ParsedDataResponse(dict):
    """
    The content of an HL7v2 message in a structured format.
    """
    def __init__(__self__, *,
                 segments: Sequence['outputs.SegmentResponse']):
        """
        The content of an HL7v2 message in a structured format.
        """
        pulumi.set(__self__, "segments", segments)

    @property
    @pulumi.getter
    def segments(self) -> Sequence['outputs.SegmentResponse']:
        return pulumi.get(self, "segments")


@pulumi.output_type
class ParserConfigResponse(dict):
    """
    The configuration for the parser. It determines how the server parses the messages.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowNullHeader":
            suggest = "allow_null_header"
        elif key == "segmentTerminator":
            suggest = "segment_terminator"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ParserConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ParserConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ParserConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allow_null_header: bool,
                 schema: 'outputs.SchemaPackageResponse',
                 segment_terminator: str,
                 version: str):
        """
        The configuration for the parser. It determines how the server parses the messages.
        :param bool allow_null_header: Determines whether messages with no header are allowed.
        :param 'SchemaPackageResponse' schema: Schemas used to parse messages in this store, if schematized parsing is desired.
        :param str segment_terminator: Byte(s) to use as the segment terminator. If this is unset, '\\r' is used as segment terminator, matching the HL7 version 2 specification.
        :param str version: Immutable. Determines the version of both the default parser to be used when `schema` is not given, as well as the schematized parser used when `schema` is specified. This field is immutable after HL7v2 store creation.
        """
        pulumi.set(__self__, "allow_null_header", allow_null_header)
        pulumi.set(__self__, "schema", schema)
        pulumi.set(__self__, "segment_terminator", segment_terminator)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="allowNullHeader")
    def allow_null_header(self) -> bool:
        """
        Determines whether messages with no header are allowed.
        """
        return pulumi.get(self, "allow_null_header")

    @property
    @pulumi.getter
    def schema(self) -> 'outputs.SchemaPackageResponse':
        """
        Schemas used to parse messages in this store, if schematized parsing is desired.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter(name="segmentTerminator")
    def segment_terminator(self) -> str:
        """
        Byte(s) to use as the segment terminator. If this is unset, '\\r' is used as segment terminator, matching the HL7 version 2 specification.
        """
        return pulumi.get(self, "segment_terminator")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Immutable. Determines the version of both the default parser to be used when `schema` is not given, as well as the schematized parser used when `schema` is specified. This field is immutable after HL7v2 store creation.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class PatientIdResponse(dict):
    """
    A patient identifier and associated type.
    """
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        A patient identifier and associated type.
        :param str type: ID type. For example, MRN or NHS.
        :param str value: The patient's unique identifier.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        ID type. For example, MRN or NHS.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The patient's unique identifier.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RedactConfigResponse(dict):
    """
    Define how to redact sensitive values. Default behaviour is erase. For example, "My name is Jane." becomes "My name is ."
    """
    def __init__(__self__):
        """
        Define how to redact sensitive values. Default behaviour is erase. For example, "My name is Jane." becomes "My name is ."
        """
        pass


@pulumi.output_type
class ReplaceWithInfoTypeConfigResponse(dict):
    """
    When using the INSPECT_AND_TRANSFORM action, each match is replaced with the name of the info_type. For example, "My name is Jane" becomes "My name is [PERSON_NAME]." The TRANSFORM action is equivalent to redacting.
    """
    def __init__(__self__):
        """
        When using the INSPECT_AND_TRANSFORM action, each match is replaced with the name of the info_type. For example, "My name is Jane" becomes "My name is [PERSON_NAME]." The TRANSFORM action is equivalent to redacting.
        """
        pass


@pulumi.output_type
class ResourceAnnotationResponse(dict):
    """
    Resource level annotation.
    """
    def __init__(__self__, *,
                 label: str):
        """
        Resource level annotation.
        :param str label: A description of the annotation record.
        """
        pulumi.set(__self__, "label", label)

    @property
    @pulumi.getter
    def label(self) -> str:
        """
        A description of the annotation record.
        """
        return pulumi.get(self, "label")


@pulumi.output_type
class SchemaConfigResponse(dict):
    """
    Configuration for the FHIR BigQuery schema. Determines how the server generates the schema.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "recursiveStructureDepth":
            suggest = "recursive_structure_depth"
        elif key == "schemaType":
            suggest = "schema_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchemaConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchemaConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchemaConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 recursive_structure_depth: str,
                 schema_type: str):
        """
        Configuration for the FHIR BigQuery schema. Determines how the server generates the schema.
        :param str recursive_structure_depth: The depth for all recursive structures in the output analytics schema. For example, `concept` in the CodeSystem resource is a recursive structure; when the depth is 2, the CodeSystem table will have a column called `concept.concept` but not `concept.concept.concept`. If not specified or set to 0, the server will use the default value 2. The maximum depth allowed is 5.
        :param str schema_type: Specifies the output schema type. Schema type is required.
        """
        pulumi.set(__self__, "recursive_structure_depth", recursive_structure_depth)
        pulumi.set(__self__, "schema_type", schema_type)

    @property
    @pulumi.getter(name="recursiveStructureDepth")
    def recursive_structure_depth(self) -> str:
        """
        The depth for all recursive structures in the output analytics schema. For example, `concept` in the CodeSystem resource is a recursive structure; when the depth is 2, the CodeSystem table will have a column called `concept.concept` but not `concept.concept.concept`. If not specified or set to 0, the server will use the default value 2. The maximum depth allowed is 5.
        """
        return pulumi.get(self, "recursive_structure_depth")

    @property
    @pulumi.getter(name="schemaType")
    def schema_type(self) -> str:
        """
        Specifies the output schema type. Schema type is required.
        """
        return pulumi.get(self, "schema_type")


@pulumi.output_type
class SchemaPackageResponse(dict):
    """
    A schema package contains a set of schemas and type definitions.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ignoreMinOccurs":
            suggest = "ignore_min_occurs"
        elif key == "schematizedParsingType":
            suggest = "schematized_parsing_type"
        elif key == "unexpectedSegmentHandling":
            suggest = "unexpected_segment_handling"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SchemaPackageResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SchemaPackageResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SchemaPackageResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ignore_min_occurs: bool,
                 schemas: Sequence['outputs.Hl7SchemaConfigResponse'],
                 schematized_parsing_type: str,
                 types: Sequence['outputs.Hl7TypesConfigResponse'],
                 unexpected_segment_handling: str):
        """
        A schema package contains a set of schemas and type definitions.
        :param bool ignore_min_occurs: Flag to ignore all min_occurs restrictions in the schema. This means that incoming messages can omit any group, segment, field, component, or subcomponent.
        :param Sequence['Hl7SchemaConfigResponse'] schemas: Schema configs that are layered based on their VersionSources that match the incoming message. Schema configs present in higher indices override those in lower indices with the same message type and trigger event if their VersionSources all match an incoming message.
        :param str schematized_parsing_type: Determines how messages that fail to parse are handled.
        :param Sequence['Hl7TypesConfigResponse'] types: Schema type definitions that are layered based on their VersionSources that match the incoming message. Type definitions present in higher indices override those in lower indices with the same type name if their VersionSources all match an incoming message.
        :param str unexpected_segment_handling: Determines how unexpected segments (segments not matched to the schema) are handled.
        """
        pulumi.set(__self__, "ignore_min_occurs", ignore_min_occurs)
        pulumi.set(__self__, "schemas", schemas)
        pulumi.set(__self__, "schematized_parsing_type", schematized_parsing_type)
        pulumi.set(__self__, "types", types)
        pulumi.set(__self__, "unexpected_segment_handling", unexpected_segment_handling)

    @property
    @pulumi.getter(name="ignoreMinOccurs")
    def ignore_min_occurs(self) -> bool:
        """
        Flag to ignore all min_occurs restrictions in the schema. This means that incoming messages can omit any group, segment, field, component, or subcomponent.
        """
        return pulumi.get(self, "ignore_min_occurs")

    @property
    @pulumi.getter
    def schemas(self) -> Sequence['outputs.Hl7SchemaConfigResponse']:
        """
        Schema configs that are layered based on their VersionSources that match the incoming message. Schema configs present in higher indices override those in lower indices with the same message type and trigger event if their VersionSources all match an incoming message.
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter(name="schematizedParsingType")
    def schematized_parsing_type(self) -> str:
        """
        Determines how messages that fail to parse are handled.
        """
        return pulumi.get(self, "schematized_parsing_type")

    @property
    @pulumi.getter
    def types(self) -> Sequence['outputs.Hl7TypesConfigResponse']:
        """
        Schema type definitions that are layered based on their VersionSources that match the incoming message. Type definitions present in higher indices override those in lower indices with the same type name if their VersionSources all match an incoming message.
        """
        return pulumi.get(self, "types")

    @property
    @pulumi.getter(name="unexpectedSegmentHandling")
    def unexpected_segment_handling(self) -> str:
        """
        Determines how unexpected segments (segments not matched to the schema) are handled.
        """
        return pulumi.get(self, "unexpected_segment_handling")


@pulumi.output_type
class SchematizedDataResponse(dict):
    """
    The content of an HL7v2 message in a structured format as specified by a schema.
    """
    def __init__(__self__, *,
                 data: str,
                 error: str):
        """
        The content of an HL7v2 message in a structured format as specified by a schema.
        :param str data: JSON output of the parser.
        :param str error: The error output of the parser.
        """
        pulumi.set(__self__, "data", data)
        pulumi.set(__self__, "error", error)

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        JSON output of the parser.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def error(self) -> str:
        """
        The error output of the parser.
        """
        return pulumi.get(self, "error")


@pulumi.output_type
class SearchConfigResponse(dict):
    """
    Contains the configuration for FHIR search.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "searchParameters":
            suggest = "search_parameters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SearchConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SearchConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SearchConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 search_parameters: Sequence['outputs.SearchParameterResponse']):
        """
        Contains the configuration for FHIR search.
        :param Sequence['SearchParameterResponse'] search_parameters: A list of search parameters in this FHIR store that are used to configure this FHIR store.
        """
        pulumi.set(__self__, "search_parameters", search_parameters)

    @property
    @pulumi.getter(name="searchParameters")
    def search_parameters(self) -> Sequence['outputs.SearchParameterResponse']:
        """
        A list of search parameters in this FHIR store that are used to configure this FHIR store.
        """
        return pulumi.get(self, "search_parameters")


@pulumi.output_type
class SearchParameterResponse(dict):
    """
    Contains the versioned name and the URL for one SearchParameter.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "canonicalUrl":
            suggest = "canonical_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SearchParameterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SearchParameterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SearchParameterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 canonical_url: str,
                 parameter: str):
        """
        Contains the versioned name and the URL for one SearchParameter.
        :param str canonical_url: The canonical url of the search parameter resource.
        :param str parameter: The versioned name of the search parameter resource. The format is projects/{project-id}/locations/{location}/datasets/{dataset-id}/fhirStores/{fhirStore-id}/fhir/SearchParameter/{resource-id}/_history/{version-id} For fhir stores with disable_resource_versioning=true, the format is projects/{project-id}/locations/{location}/datasets/{dataset-id}/fhirStores/{fhirStore-id}/fhir/SearchParameter/{resource-id}/
        """
        pulumi.set(__self__, "canonical_url", canonical_url)
        pulumi.set(__self__, "parameter", parameter)

    @property
    @pulumi.getter(name="canonicalUrl")
    def canonical_url(self) -> str:
        """
        The canonical url of the search parameter resource.
        """
        return pulumi.get(self, "canonical_url")

    @property
    @pulumi.getter
    def parameter(self) -> str:
        """
        The versioned name of the search parameter resource. The format is projects/{project-id}/locations/{location}/datasets/{dataset-id}/fhirStores/{fhirStore-id}/fhir/SearchParameter/{resource-id}/_history/{version-id} For fhir stores with disable_resource_versioning=true, the format is projects/{project-id}/locations/{location}/datasets/{dataset-id}/fhirStores/{fhirStore-id}/fhir/SearchParameter/{resource-id}/
        """
        return pulumi.get(self, "parameter")


@pulumi.output_type
class SegmentResponse(dict):
    """
    A segment in a structured format.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "segmentId":
            suggest = "segment_id"
        elif key == "setId":
            suggest = "set_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SegmentResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SegmentResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SegmentResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 fields: Mapping[str, str],
                 segment_id: str,
                 set_id: str):
        """
        A segment in a structured format.
        :param Mapping[str, str] fields: A mapping from the positional location to the value. The key string uses zero-based indexes separated by dots to identify Fields, components and sub-components. A bracket notation is also used to identify different instances of a repeated field. Regex for key: (\\d+)(\\[\\d+\\])?(.\\d+)?(.\\d+)? Examples of (key, value) pairs: * (0.1, "hemoglobin") denotes that the first component of Field 0 has the value "hemoglobin". * (1.1.2, "CBC") denotes that the second sub-component of the first component of Field 1 has the value "CBC". * (1[0].1, "HbA1c") denotes that the first component of the first Instance of Field 1, which is repeated, has the value "HbA1c".
        :param str segment_id: A string that indicates the type of segment. For example, EVN or PID.
        :param str set_id: Set ID for segments that can be in a set. This can be empty if it's missing or isn't applicable.
        """
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "segment_id", segment_id)
        pulumi.set(__self__, "set_id", set_id)

    @property
    @pulumi.getter
    def fields(self) -> Mapping[str, str]:
        """
        A mapping from the positional location to the value. The key string uses zero-based indexes separated by dots to identify Fields, components and sub-components. A bracket notation is also used to identify different instances of a repeated field. Regex for key: (\\d+)(\\[\\d+\\])?(.\\d+)?(.\\d+)? Examples of (key, value) pairs: * (0.1, "hemoglobin") denotes that the first component of Field 0 has the value "hemoglobin". * (1.1.2, "CBC") denotes that the second sub-component of the first component of Field 1 has the value "CBC". * (1[0].1, "HbA1c") denotes that the first component of the first Instance of Field 1, which is repeated, has the value "HbA1c".
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="segmentId")
    def segment_id(self) -> str:
        """
        A string that indicates the type of segment. For example, EVN or PID.
        """
        return pulumi.get(self, "segment_id")

    @property
    @pulumi.getter(name="setId")
    def set_id(self) -> str:
        """
        Set ID for segments that can be in a set. This can be empty if it's missing or isn't applicable.
        """
        return pulumi.get(self, "set_id")


@pulumi.output_type
class SensitiveTextAnnotationResponse(dict):
    """
    A TextAnnotation specifies a text range that includes sensitive information.
    """
    def __init__(__self__, *,
                 details: Mapping[str, str]):
        """
        A TextAnnotation specifies a text range that includes sensitive information.
        :param Mapping[str, str] details: Maps from a resource slice. For example, FHIR resource field path to a set of sensitive text findings. For example, Appointment.Narrative text1 --> {findings_1, findings_2, findings_3}
        """
        pulumi.set(__self__, "details", details)

    @property
    @pulumi.getter
    def details(self) -> Mapping[str, str]:
        """
        Maps from a resource slice. For example, FHIR resource field path to a set of sensitive text findings. For example, Appointment.Narrative text1 --> {findings_1, findings_2, findings_3}
        """
        return pulumi.get(self, "details")


@pulumi.output_type
class SignatureResponse(dict):
    """
    User signature.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "signatureTime":
            suggest = "signature_time"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SignatureResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SignatureResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SignatureResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image: 'outputs.ImageResponse',
                 metadata: Mapping[str, str],
                 signature_time: str,
                 user_id: str):
        """
        User signature.
        :param 'ImageResponse' image: Optional. An image of the user's signature.
        :param Mapping[str, str] metadata: Optional. Metadata associated with the user's signature. For example, the user's name or the user's title.
        :param str signature_time: Optional. Timestamp of the signature.
        :param str user_id: User's UUID provided by the client.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "signature_time", signature_time)
        pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter
    def image(self) -> 'outputs.ImageResponse':
        """
        Optional. An image of the user's signature.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        Optional. Metadata associated with the user's signature. For example, the user's name or the user's title.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="signatureTime")
    def signature_time(self) -> str:
        """
        Optional. Timestamp of the signature.
        """
        return pulumi.get(self, "signature_time")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> str:
        """
        User's UUID provided by the client.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class StreamConfigResponse(dict):
    """
    Contains configuration for streaming FHIR export.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bigqueryDestination":
            suggest = "bigquery_destination"
        elif key == "deidentifiedStoreDestination":
            suggest = "deidentified_store_destination"
        elif key == "resourceTypes":
            suggest = "resource_types"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StreamConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StreamConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StreamConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bigquery_destination: 'outputs.GoogleCloudHealthcareV1beta1FhirBigQueryDestinationResponse',
                 deidentified_store_destination: 'outputs.DeidentifiedStoreDestinationResponse',
                 resource_types: Sequence[str]):
        """
        Contains configuration for streaming FHIR export.
        :param 'GoogleCloudHealthcareV1beta1FhirBigQueryDestinationResponse' bigquery_destination: The destination BigQuery structure that contains both the dataset location and corresponding schema config. The output is organized in one table per resource type. The server reuses the existing tables (if any) that are named after the resource types, e.g. "Patient", "Observation". When there is no existing table for a given resource type, the server attempts to create one. When a table schema doesn't align with the schema config, either because of existing incompatible schema or out of band incompatible modification, the server does not stream in new data. One resolution in this case is to delete the incompatible table and let the server recreate one, though the newly created table only contains data after the table recreation. BigQuery imposes a 1 MB limit on streaming insert row size, therefore any resource mutation that generates more than 1 MB of BigQuery data will not be streamed. Results are written to BigQuery tables according to the parameters in BigQueryDestination.WriteDisposition. Different versions of the same resource are distinguishable by the meta.versionId and meta.lastUpdated columns. The operation (CREATE/UPDATE/DELETE) that results in the new version is recorded in the meta.tag. The tables contain all historical resource versions since streaming was enabled. For query convenience, the server also creates one view per table of the same name containing only the current resource version. The streamed data in the BigQuery dataset is not guaranteed to be completely unique. The combination of the id and meta.versionId columns should ideally identify a single unique row. But in rare cases, duplicates may exist. At query time, users may use the SQL select statement to keep only one of the duplicate rows given an id and meta.versionId pair. Alternatively, the server created view mentioned above also filters out duplicates. If a resource mutation cannot be streamed to BigQuery, errors will be logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        :param 'DeidentifiedStoreDestinationResponse' deidentified_store_destination: The destination FHIR store for de-identified resources. After this field is added, all subsequent creates/updates/patches to the source store will be de-identified using the provided configuration and applied to the destination store. Importing resources to the source store will not trigger the streaming. If the source store already contains resources when this option is enabled, those resources will not be copied to the destination store unless they are subsequently updated. This may result in invalid references in the destination store. Before adding this config, you must grant the healthcare.fhirResources.update permission on the destination store to your project's **Cloud Healthcare Service Agent** [service account](https://cloud.google.com/healthcare/docs/how-tos/permissions-healthcare-api-gcp-products#the_cloud_healthcare_service_agent). The destination store must set enable_update_create to true. The destination store must have disable_referential_integrity set to true. If a resource cannot be de-identified, errors will be logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        :param Sequence[str] resource_types: Supply a FHIR resource type (such as "Patient" or "Observation"). See https://www.hl7.org/fhir/valueset-resource-types.html for a list of all FHIR resource types. The server treats an empty list as an intent to stream all the supported resource types in this FHIR store.
        """
        pulumi.set(__self__, "bigquery_destination", bigquery_destination)
        pulumi.set(__self__, "deidentified_store_destination", deidentified_store_destination)
        pulumi.set(__self__, "resource_types", resource_types)

    @property
    @pulumi.getter(name="bigqueryDestination")
    def bigquery_destination(self) -> 'outputs.GoogleCloudHealthcareV1beta1FhirBigQueryDestinationResponse':
        """
        The destination BigQuery structure that contains both the dataset location and corresponding schema config. The output is organized in one table per resource type. The server reuses the existing tables (if any) that are named after the resource types, e.g. "Patient", "Observation". When there is no existing table for a given resource type, the server attempts to create one. When a table schema doesn't align with the schema config, either because of existing incompatible schema or out of band incompatible modification, the server does not stream in new data. One resolution in this case is to delete the incompatible table and let the server recreate one, though the newly created table only contains data after the table recreation. BigQuery imposes a 1 MB limit on streaming insert row size, therefore any resource mutation that generates more than 1 MB of BigQuery data will not be streamed. Results are written to BigQuery tables according to the parameters in BigQueryDestination.WriteDisposition. Different versions of the same resource are distinguishable by the meta.versionId and meta.lastUpdated columns. The operation (CREATE/UPDATE/DELETE) that results in the new version is recorded in the meta.tag. The tables contain all historical resource versions since streaming was enabled. For query convenience, the server also creates one view per table of the same name containing only the current resource version. The streamed data in the BigQuery dataset is not guaranteed to be completely unique. The combination of the id and meta.versionId columns should ideally identify a single unique row. But in rare cases, duplicates may exist. At query time, users may use the SQL select statement to keep only one of the duplicate rows given an id and meta.versionId pair. Alternatively, the server created view mentioned above also filters out duplicates. If a resource mutation cannot be streamed to BigQuery, errors will be logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        """
        return pulumi.get(self, "bigquery_destination")

    @property
    @pulumi.getter(name="deidentifiedStoreDestination")
    def deidentified_store_destination(self) -> 'outputs.DeidentifiedStoreDestinationResponse':
        """
        The destination FHIR store for de-identified resources. After this field is added, all subsequent creates/updates/patches to the source store will be de-identified using the provided configuration and applied to the destination store. Importing resources to the source store will not trigger the streaming. If the source store already contains resources when this option is enabled, those resources will not be copied to the destination store unless they are subsequently updated. This may result in invalid references in the destination store. Before adding this config, you must grant the healthcare.fhirResources.update permission on the destination store to your project's **Cloud Healthcare Service Agent** [service account](https://cloud.google.com/healthcare/docs/how-tos/permissions-healthcare-api-gcp-products#the_cloud_healthcare_service_agent). The destination store must set enable_update_create to true. The destination store must have disable_referential_integrity set to true. If a resource cannot be de-identified, errors will be logged to Cloud Logging (see [Viewing error logs in Cloud Logging](https://cloud.google.com/healthcare/docs/how-tos/logging)).
        """
        return pulumi.get(self, "deidentified_store_destination")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Sequence[str]:
        """
        Supply a FHIR resource type (such as "Patient" or "Observation"). See https://www.hl7.org/fhir/valueset-resource-types.html for a list of all FHIR resource types. The server treats an empty list as an intent to stream all the supported resource types in this FHIR store.
        """
        return pulumi.get(self, "resource_types")


@pulumi.output_type
class TagFilterListResponse(dict):
    """
    List of tags to be filtered.
    """
    def __init__(__self__, *,
                 tags: Sequence[str]):
        """
        List of tags to be filtered.
        :param Sequence[str] tags: Tags to be filtered. Tags must be DICOM Data Elements, File Meta Elements, or Directory Structuring Elements, as defined at: http://dicom.nema.org/medical/dicom/current/output/html/part06.html#table_6-1,. They may be provided by "Keyword" or "Tag". For example, "PatientID", "00100010".
        """
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        Tags to be filtered. Tags must be DICOM Data Elements, File Meta Elements, or Directory Structuring Elements, as defined at: http://dicom.nema.org/medical/dicom/current/output/html/part06.html#table_6-1,. They may be provided by "Keyword" or "Tag". For example, "PatientID", "00100010".
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class TextConfigResponse(dict):
    def __init__(__self__, *,
                 transformations: Sequence['outputs.InfoTypeTransformationResponse']):
        """
        :param Sequence['InfoTypeTransformationResponse'] transformations: The transformations to apply to the detected data.
        """
        pulumi.set(__self__, "transformations", transformations)

    @property
    @pulumi.getter
    def transformations(self) -> Sequence['outputs.InfoTypeTransformationResponse']:
        """
        The transformations to apply to the detected data.
        """
        return pulumi.get(self, "transformations")


@pulumi.output_type
class TypeResponse(dict):
    """
    A type definition for some HL7v2 type (incl. Segments and Datatypes).
    """
    def __init__(__self__, *,
                 fields: Sequence['outputs.FieldResponse'],
                 name: str,
                 primitive: str):
        """
        A type definition for some HL7v2 type (incl. Segments and Datatypes).
        :param Sequence['FieldResponse'] fields: The (sub) fields this type has (if not primitive).
        :param str name: The name of this type. This would be the segment or datatype name. For example, "PID" or "XPN".
        :param str primitive: If this is a primitive type then this field is the type of the primitive For example, STRING. Leave unspecified for composite types.
        """
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primitive", primitive)

    @property
    @pulumi.getter
    def fields(self) -> Sequence['outputs.FieldResponse']:
        """
        The (sub) fields this type has (if not primitive).
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of this type. This would be the segment or datatype name. For example, "PID" or "XPN".
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def primitive(self) -> str:
        """
        If this is a primitive type then this field is the type of the primitive For example, STRING. Leave unspecified for composite types.
        """
        return pulumi.get(self, "primitive")


@pulumi.output_type
class ValidationConfigResponse(dict):
    """
    Contains the configuration for FHIR profiles and validation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableFhirpathValidation":
            suggest = "disable_fhirpath_validation"
        elif key == "disableProfileValidation":
            suggest = "disable_profile_validation"
        elif key == "disableReferenceTypeValidation":
            suggest = "disable_reference_type_validation"
        elif key == "disableRequiredFieldValidation":
            suggest = "disable_required_field_validation"
        elif key == "enabledImplementationGuides":
            suggest = "enabled_implementation_guides"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ValidationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ValidationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ValidationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_fhirpath_validation: bool,
                 disable_profile_validation: bool,
                 disable_reference_type_validation: bool,
                 disable_required_field_validation: bool,
                 enabled_implementation_guides: Sequence[str]):
        """
        Contains the configuration for FHIR profiles and validation.
        :param bool disable_fhirpath_validation: Whether to disable FHIRPath validation for incoming resources. Set this to true to disable checking incoming resources for conformance against FHIRPath requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        :param bool disable_profile_validation: Whether to disable profile validation for this FHIR store. Set this to true to disable checking incoming resources for conformance against StructureDefinitions in this FHIR store.
        :param bool disable_reference_type_validation: Whether to disable reference type validation for incoming resources. Set this to true to disable checking incoming resources for conformance against reference type requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        :param bool disable_required_field_validation: Whether to disable required fields validation for incoming resources. Set this to true to disable checking incoming resources for conformance against required fields requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        :param Sequence[str] enabled_implementation_guides: A list of ImplementationGuide URLs in this FHIR store that are used to configure the profiles to use for validation. For example, to use the US Core profiles for validation, set `enabled_implementation_guides` to `["http://hl7.org/fhir/us/core/ImplementationGuide/ig"]`. If `enabled_implementation_guides` is empty or omitted, then incoming resources are only required to conform to the base FHIR profiles. Otherwise, a resource must conform to at least one profile listed in the `global` property of one of the enabled ImplementationGuides. The Cloud Healthcare API does not currently enforce all of the rules in a StructureDefinition. The following rules are supported: - min/max - minValue/maxValue - maxLength - type - fixed[x] - pattern[x] on simple types - slicing, when using "value" as the discriminator type When a URL cannot be resolved (for example, in a type assertion), the server does not return an error.
        """
        pulumi.set(__self__, "disable_fhirpath_validation", disable_fhirpath_validation)
        pulumi.set(__self__, "disable_profile_validation", disable_profile_validation)
        pulumi.set(__self__, "disable_reference_type_validation", disable_reference_type_validation)
        pulumi.set(__self__, "disable_required_field_validation", disable_required_field_validation)
        pulumi.set(__self__, "enabled_implementation_guides", enabled_implementation_guides)

    @property
    @pulumi.getter(name="disableFhirpathValidation")
    def disable_fhirpath_validation(self) -> bool:
        """
        Whether to disable FHIRPath validation for incoming resources. Set this to true to disable checking incoming resources for conformance against FHIRPath requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        """
        return pulumi.get(self, "disable_fhirpath_validation")

    @property
    @pulumi.getter(name="disableProfileValidation")
    def disable_profile_validation(self) -> bool:
        """
        Whether to disable profile validation for this FHIR store. Set this to true to disable checking incoming resources for conformance against StructureDefinitions in this FHIR store.
        """
        return pulumi.get(self, "disable_profile_validation")

    @property
    @pulumi.getter(name="disableReferenceTypeValidation")
    def disable_reference_type_validation(self) -> bool:
        """
        Whether to disable reference type validation for incoming resources. Set this to true to disable checking incoming resources for conformance against reference type requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        """
        return pulumi.get(self, "disable_reference_type_validation")

    @property
    @pulumi.getter(name="disableRequiredFieldValidation")
    def disable_required_field_validation(self) -> bool:
        """
        Whether to disable required fields validation for incoming resources. Set this to true to disable checking incoming resources for conformance against required fields requirement defined in the FHIR specification. This property only affects resource types that do not have profiles configured for them, any rules in enabled implementation guides will still be enforced.
        """
        return pulumi.get(self, "disable_required_field_validation")

    @property
    @pulumi.getter(name="enabledImplementationGuides")
    def enabled_implementation_guides(self) -> Sequence[str]:
        """
        A list of ImplementationGuide URLs in this FHIR store that are used to configure the profiles to use for validation. For example, to use the US Core profiles for validation, set `enabled_implementation_guides` to `["http://hl7.org/fhir/us/core/ImplementationGuide/ig"]`. If `enabled_implementation_guides` is empty or omitted, then incoming resources are only required to conform to the base FHIR profiles. Otherwise, a resource must conform to at least one profile listed in the `global` property of one of the enabled ImplementationGuides. The Cloud Healthcare API does not currently enforce all of the rules in a StructureDefinition. The following rules are supported: - min/max - minValue/maxValue - maxLength - type - fixed[x] - pattern[x] on simple types - slicing, when using "value" as the discriminator type When a URL cannot be resolved (for example, in a type assertion), the server does not return an error.
        """
        return pulumi.get(self, "enabled_implementation_guides")


@pulumi.output_type
class VersionSourceResponse(dict):
    """
    Describes a selector for extracting and matching an MSH field to a value.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mshField":
            suggest = "msh_field"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VersionSourceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VersionSourceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VersionSourceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 msh_field: str,
                 value: str):
        """
        Describes a selector for extracting and matching an MSH field to a value.
        :param str msh_field: The field to extract from the MSH segment. For example, "3.1" or "18[1].1".
        :param str value: The value to match with the field. For example, "My Application Name" or "2.3".
        """
        pulumi.set(__self__, "msh_field", msh_field)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="mshField")
    def msh_field(self) -> str:
        """
        The field to extract from the MSH segment. For example, "3.1" or "18[1].1".
        """
        return pulumi.get(self, "msh_field")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value to match with the field. For example, "My Application Name" or "2.3".
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class VertexResponse(dict):
    """
    A 2D coordinate in an image. The origin is the top-left.
    """
    def __init__(__self__, *,
                 x: float,
                 y: float):
        """
        A 2D coordinate in an image. The origin is the top-left.
        :param float x: X coordinate.
        :param float y: Y coordinate.
        """
        pulumi.set(__self__, "x", x)
        pulumi.set(__self__, "y", y)

    @property
    @pulumi.getter
    def x(self) -> float:
        """
        X coordinate.
        """
        return pulumi.get(self, "x")

    @property
    @pulumi.getter
    def y(self) -> float:
        """
        Y coordinate.
        """
        return pulumi.get(self, "y")


