# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetBackupPlanResult',
    'AwaitableGetBackupPlanResult',
    'get_backup_plan',
    'get_backup_plan_output',
]

@pulumi.output_type
class GetBackupPlanResult:
    def __init__(__self__, backup_config=None, backup_schedule=None, cluster=None, create_time=None, deactivated=None, description=None, etag=None, labels=None, name=None, protected_pod_count=None, retention_policy=None, uid=None, update_time=None):
        if backup_config and not isinstance(backup_config, dict):
            raise TypeError("Expected argument 'backup_config' to be a dict")
        pulumi.set(__self__, "backup_config", backup_config)
        if backup_schedule and not isinstance(backup_schedule, dict):
            raise TypeError("Expected argument 'backup_schedule' to be a dict")
        pulumi.set(__self__, "backup_schedule", backup_schedule)
        if cluster and not isinstance(cluster, str):
            raise TypeError("Expected argument 'cluster' to be a str")
        pulumi.set(__self__, "cluster", cluster)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if deactivated and not isinstance(deactivated, bool):
            raise TypeError("Expected argument 'deactivated' to be a bool")
        pulumi.set(__self__, "deactivated", deactivated)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if protected_pod_count and not isinstance(protected_pod_count, int):
            raise TypeError("Expected argument 'protected_pod_count' to be a int")
        pulumi.set(__self__, "protected_pod_count", protected_pod_count)
        if retention_policy and not isinstance(retention_policy, dict):
            raise TypeError("Expected argument 'retention_policy' to be a dict")
        pulumi.set(__self__, "retention_policy", retention_policy)
        if uid and not isinstance(uid, str):
            raise TypeError("Expected argument 'uid' to be a str")
        pulumi.set(__self__, "uid", uid)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="backupConfig")
    def backup_config(self) -> 'outputs.BackupConfigResponse':
        """
        Defines the configuration of Backups created via this BackupPlan.
        """
        return pulumi.get(self, "backup_config")

    @property
    @pulumi.getter(name="backupSchedule")
    def backup_schedule(self) -> 'outputs.ScheduleResponse':
        """
        Defines a schedule for automatic Backup creation via this BackupPlan.
        """
        return pulumi.get(self, "backup_schedule")

    @property
    @pulumi.getter
    def cluster(self) -> str:
        """
        Immutable. The source cluster from which Backups will be created via this BackupPlan. Valid formats: - `projects/*/locations/*/clusters/*` - `projects/*/zones/*/clusters/*`
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The timestamp when this BackupPlan resource was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def deactivated(self) -> bool:
        """
        This flag indicates whether this BackupPlan has been deactivated. Setting this field to True locks the BackupPlan such that no further updates will be allowed (except deletes), including the deactivated field itself. It also prevents any new Backups from being created via this BackupPlan (including scheduled Backups). Default: False
        """
        return pulumi.get(self, "deactivated")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        User specified descriptive string for this BackupPlan.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def etag(self) -> str:
        """
        `etag` is used for optimistic concurrency control as a way to help prevent simultaneous updates of a backup plan from overwriting each other. It is strongly suggested that systems make use of the 'etag' in the read-modify-write cycle to perform BackupPlan updates in order to avoid race conditions: An `etag` is returned in the response to `GetBackupPlan`, and systems are expected to put that etag in the request to `UpdateBackupPlan` or `DeleteBackupPlan` to ensure that their change will be applied to the same version of the resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A set of custom labels supplied by user.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The full name of the BackupPlan resource. Format: `projects/*/locations/*/backupPlans/*`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="protectedPodCount")
    def protected_pod_count(self) -> int:
        """
        The number of Kubernetes Pods backed up in the last successful Backup created via this BackupPlan.
        """
        return pulumi.get(self, "protected_pod_count")

    @property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> 'outputs.RetentionPolicyResponse':
        """
        RetentionPolicy governs lifecycle of Backups created under this plan.
        """
        return pulumi.get(self, "retention_policy")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        Server generated global unique identifier of [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier) format.
        """
        return pulumi.get(self, "uid")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The timestamp when this BackupPlan resource was last updated.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetBackupPlanResult(GetBackupPlanResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupPlanResult(
            backup_config=self.backup_config,
            backup_schedule=self.backup_schedule,
            cluster=self.cluster,
            create_time=self.create_time,
            deactivated=self.deactivated,
            description=self.description,
            etag=self.etag,
            labels=self.labels,
            name=self.name,
            protected_pod_count=self.protected_pod_count,
            retention_policy=self.retention_policy,
            uid=self.uid,
            update_time=self.update_time)


def get_backup_plan(backup_plan_id: Optional[str] = None,
                    location: Optional[str] = None,
                    project: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupPlanResult:
    """
    Retrieve the details of a single BackupPlan.
    """
    __args__ = dict()
    __args__['backupPlanId'] = backup_plan_id
    __args__['location'] = location
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:gkebackup/v1:getBackupPlan', __args__, opts=opts, typ=GetBackupPlanResult).value

    return AwaitableGetBackupPlanResult(
        backup_config=__ret__.backup_config,
        backup_schedule=__ret__.backup_schedule,
        cluster=__ret__.cluster,
        create_time=__ret__.create_time,
        deactivated=__ret__.deactivated,
        description=__ret__.description,
        etag=__ret__.etag,
        labels=__ret__.labels,
        name=__ret__.name,
        protected_pod_count=__ret__.protected_pod_count,
        retention_policy=__ret__.retention_policy,
        uid=__ret__.uid,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_backup_plan)
def get_backup_plan_output(backup_plan_id: Optional[pulumi.Input[str]] = None,
                           location: Optional[pulumi.Input[str]] = None,
                           project: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBackupPlanResult]:
    """
    Retrieve the details of a single BackupPlan.
    """
    ...
