# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['EvaluationArgs', 'Evaluation']

@pulumi.input_type
class EvaluationArgs:
    def __init__(__self__, *,
                 conversation_model_id: pulumi.Input[str],
                 display_name: Optional[pulumi.Input[str]] = None,
                 evaluation_config: Optional[pulumi.Input['GoogleCloudDialogflowV2EvaluationConfigArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Evaluation resource.
        :param pulumi.Input[str] display_name: Optional. The display name of the model evaluation. At most 64 bytes long.
        :param pulumi.Input['GoogleCloudDialogflowV2EvaluationConfigArgs'] evaluation_config: Optional. The configuration of the evaluation task.
        :param pulumi.Input[str] name: The resource name of the evaluation. Format: `projects//conversationModels//evaluations/`
        """
        pulumi.set(__self__, "conversation_model_id", conversation_model_id)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if evaluation_config is not None:
            pulumi.set(__self__, "evaluation_config", evaluation_config)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="conversationModelId")
    def conversation_model_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "conversation_model_id")

    @conversation_model_id.setter
    def conversation_model_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "conversation_model_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The display name of the model evaluation. At most 64 bytes long.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="evaluationConfig")
    def evaluation_config(self) -> Optional[pulumi.Input['GoogleCloudDialogflowV2EvaluationConfigArgs']]:
        """
        Optional. The configuration of the evaluation task.
        """
        return pulumi.get(self, "evaluation_config")

    @evaluation_config.setter
    def evaluation_config(self, value: Optional[pulumi.Input['GoogleCloudDialogflowV2EvaluationConfigArgs']]):
        pulumi.set(self, "evaluation_config", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The resource name of the evaluation. Format: `projects//conversationModels//evaluations/`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)


class Evaluation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conversation_model_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 evaluation_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2EvaluationConfigArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Creates evaluation of a conversation model.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: Optional. The display name of the model evaluation. At most 64 bytes long.
        :param pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2EvaluationConfigArgs']] evaluation_config: Optional. The configuration of the evaluation task.
        :param pulumi.Input[str] name: The resource name of the evaluation. Format: `projects//conversationModels//evaluations/`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EvaluationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates evaluation of a conversation model.
        Note - this resource's API doesn't support deletion. When deleted, the resource will persist
        on Google Cloud even though it will be deleted from Pulumi state.

        :param str resource_name: The name of the resource.
        :param EvaluationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EvaluationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 conversation_model_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 evaluation_config: Optional[pulumi.Input[pulumi.InputType['GoogleCloudDialogflowV2EvaluationConfigArgs']]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EvaluationArgs.__new__(EvaluationArgs)

            if conversation_model_id is None and not opts.urn:
                raise TypeError("Missing required property 'conversation_model_id'")
            __props__.__dict__["conversation_model_id"] = conversation_model_id
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["evaluation_config"] = evaluation_config
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["create_time"] = None
            __props__.__dict__["smart_reply_metrics"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["conversation_model_id", "location", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Evaluation, __self__).__init__(
            'google-native:dialogflow/v2:Evaluation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Evaluation':
        """
        Get an existing Evaluation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = EvaluationArgs.__new__(EvaluationArgs)

        __props__.__dict__["conversation_model_id"] = None
        __props__.__dict__["create_time"] = None
        __props__.__dict__["display_name"] = None
        __props__.__dict__["evaluation_config"] = None
        __props__.__dict__["location"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["smart_reply_metrics"] = None
        return Evaluation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="conversationModelId")
    def conversation_model_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "conversation_model_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Creation time of this model.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Optional. The display name of the model evaluation. At most 64 bytes long.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="evaluationConfig")
    def evaluation_config(self) -> pulumi.Output['outputs.GoogleCloudDialogflowV2EvaluationConfigResponse']:
        """
        Optional. The configuration of the evaluation task.
        """
        return pulumi.get(self, "evaluation_config")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the evaluation. Format: `projects//conversationModels//evaluations/`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="smartReplyMetrics")
    def smart_reply_metrics(self) -> pulumi.Output['outputs.GoogleCloudDialogflowV2SmartReplyMetricsResponse']:
        """
        Only available when model is for smart reply.
        """
        return pulumi.get(self, "smart_reply_metrics")

