# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AsyncOptionsArgs',
    'AuditConfigArgs',
    'AuditLogConfigArgs',
    'BasicAuthArgs',
    'BindingArgs',
    'CollectionOverrideArgs',
    'CompositeTypeLabelEntryArgs',
    'ConfigFileArgs',
    'CredentialArgs',
    'DeploymentLabelEntryArgs',
    'DiagnosticArgs',
    'ExprArgs',
    'ImportFileArgs',
    'InputMappingArgs',
    'MethodMapArgs',
    'OptionsArgs',
    'PollingOptionsArgs',
    'ServiceAccountArgs',
    'TargetConfigurationArgs',
    'TemplateContentsArgs',
    'TypeProviderLabelEntryArgs',
    'ValidationOptionsArgs',
]

@pulumi.input_type
class AsyncOptionsArgs:
    def __init__(__self__, *,
                 method_match: Optional[pulumi.Input[str]] = None,
                 polling_options: Optional[pulumi.Input['PollingOptionsArgs']] = None):
        """
        Async options that determine when a resource should finish.
        :param pulumi.Input[str] method_match: Method regex where this policy will apply.
        :param pulumi.Input['PollingOptionsArgs'] polling_options: Deployment manager will poll instances for this API resource setting a RUNNING state, and blocking until polling conditions tell whether the resource is completed or failed.
        """
        if method_match is not None:
            pulumi.set(__self__, "method_match", method_match)
        if polling_options is not None:
            pulumi.set(__self__, "polling_options", polling_options)

    @property
    @pulumi.getter(name="methodMatch")
    def method_match(self) -> Optional[pulumi.Input[str]]:
        """
        Method regex where this policy will apply.
        """
        return pulumi.get(self, "method_match")

    @method_match.setter
    def method_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method_match", value)

    @property
    @pulumi.getter(name="pollingOptions")
    def polling_options(self) -> Optional[pulumi.Input['PollingOptionsArgs']]:
        """
        Deployment manager will poll instances for this API resource setting a RUNNING state, and blocking until polling conditions tell whether the resource is completed or failed.
        """
        return pulumi.get(self, "polling_options")

    @polling_options.setter
    def polling_options(self, value: Optional[pulumi.Input['PollingOptionsArgs']]):
        pulumi.set(self, "polling_options", value)


@pulumi.input_type
class AuditConfigArgs:
    def __init__(__self__, *,
                 audit_log_configs: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]] = None,
                 service: Optional[pulumi.Input[str]] = None):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts `jose@example.com` from DATA_READ logging, and `aliya@example.com` from DATA_WRITE logging.
        :param pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]] audit_log_configs: The configuration for logging of each type of permission.
        :param pulumi.Input[str] service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        if audit_log_configs is not None:
            pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @audit_log_configs.setter
    def audit_log_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AuditLogConfigArgs']]]]):
        pulumi.set(self, "audit_log_configs", value)

    @property
    @pulumi.getter
    def service(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    @service.setter
    def service(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service", value)


@pulumi.input_type
class AuditLogConfigArgs:
    def __init__(__self__, *,
                 exempted_members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_type: Optional[pulumi.Input['AuditLogConfigLogType']] = None):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param pulumi.Input['AuditLogConfigLogType'] log_type: The log type that this config enables.
        """
        if exempted_members is not None:
            pulumi.set(__self__, "exempted_members", exempted_members)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @exempted_members.setter
    def exempted_members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "exempted_members", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input['AuditLogConfigLogType']]:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input['AuditLogConfigLogType']]):
        pulumi.set(self, "log_type", value)


@pulumi.input_type
class BasicAuthArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 user: Optional[pulumi.Input[str]] = None):
        """
        Basic Auth used as a credential.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if user is not None:
            pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def user(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a Google service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An identifier for a [Kubernetes service account](https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts). For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class CollectionOverrideArgs:
    def __init__(__self__, *,
                 collection: Optional[pulumi.Input[str]] = None,
                 method_map: Optional[pulumi.Input['MethodMapArgs']] = None,
                 options: Optional[pulumi.Input['OptionsArgs']] = None):
        """
        CollectionOverride allows resource handling overrides for specific resources within a BaseType
        :param pulumi.Input[str] collection: The collection that identifies this resource within its service.
        :param pulumi.Input['MethodMapArgs'] method_map: Custom verb method mappings to support unordered list API mappings.
        :param pulumi.Input['OptionsArgs'] options: The options to apply to this resource-level override
        """
        if collection is not None:
            pulumi.set(__self__, "collection", collection)
        if method_map is not None:
            pulumi.set(__self__, "method_map", method_map)
        if options is not None:
            pulumi.set(__self__, "options", options)

    @property
    @pulumi.getter
    def collection(self) -> Optional[pulumi.Input[str]]:
        """
        The collection that identifies this resource within its service.
        """
        return pulumi.get(self, "collection")

    @collection.setter
    def collection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "collection", value)

    @property
    @pulumi.getter(name="methodMap")
    def method_map(self) -> Optional[pulumi.Input['MethodMapArgs']]:
        """
        Custom verb method mappings to support unordered list API mappings.
        """
        return pulumi.get(self, "method_map")

    @method_map.setter
    def method_map(self, value: Optional[pulumi.Input['MethodMapArgs']]):
        pulumi.set(self, "method_map", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['OptionsArgs']]:
        """
        The options to apply to this resource-level override
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['OptionsArgs']]):
        pulumi.set(self, "options", value)


@pulumi.input_type
class CompositeTypeLabelEntryArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Label object for CompositeTypes
        :param pulumi.Input[str] key: Key of the label
        :param pulumi.Input[str] value: Value of the label
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key of the label
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the label
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ConfigFileArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] content: The contents of the file.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The contents of the file.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)


@pulumi.input_type
class CredentialArgs:
    def __init__(__self__, *,
                 basic_auth: Optional[pulumi.Input['BasicAuthArgs']] = None,
                 service_account: Optional[pulumi.Input['ServiceAccountArgs']] = None,
                 use_project_default: Optional[pulumi.Input[bool]] = None):
        """
        The credential used by Deployment Manager and TypeProvider. Only one of the options is permitted.
        :param pulumi.Input['BasicAuthArgs'] basic_auth: Basic Auth Credential, only used by TypeProvider.
        :param pulumi.Input['ServiceAccountArgs'] service_account: Service Account Credential, only used by Deployment.
        :param pulumi.Input[bool] use_project_default: Specify to use the project default credential, only supported by Deployment.
        """
        if basic_auth is not None:
            pulumi.set(__self__, "basic_auth", basic_auth)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if use_project_default is not None:
            pulumi.set(__self__, "use_project_default", use_project_default)

    @property
    @pulumi.getter(name="basicAuth")
    def basic_auth(self) -> Optional[pulumi.Input['BasicAuthArgs']]:
        """
        Basic Auth Credential, only used by TypeProvider.
        """
        return pulumi.get(self, "basic_auth")

    @basic_auth.setter
    def basic_auth(self, value: Optional[pulumi.Input['BasicAuthArgs']]):
        pulumi.set(self, "basic_auth", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input['ServiceAccountArgs']]:
        """
        Service Account Credential, only used by Deployment.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input['ServiceAccountArgs']]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter(name="useProjectDefault")
    def use_project_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Specify to use the project default credential, only supported by Deployment.
        """
        return pulumi.get(self, "use_project_default")

    @use_project_default.setter
    def use_project_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_project_default", value)


@pulumi.input_type
class DeploymentLabelEntryArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Label object for Deployments
        :param pulumi.Input[str] key: Key of the label
        :param pulumi.Input[str] value: Value of the label
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key of the label
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the label
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DiagnosticArgs:
    def __init__(__self__, *,
                 field: Optional[pulumi.Input[str]] = None,
                 level: Optional[pulumi.Input['DiagnosticLevel']] = None):
        """
        :param pulumi.Input[str] field: JsonPath expression on the resource that if non empty, indicates that this field needs to be extracted as a diagnostic.
        :param pulumi.Input['DiagnosticLevel'] level: Level to record this diagnostic.
        """
        if field is not None:
            pulumi.set(__self__, "field", field)
        if level is not None:
            pulumi.set(__self__, "level", level)

    @property
    @pulumi.getter
    def field(self) -> Optional[pulumi.Input[str]]:
        """
        JsonPath expression on the resource that if non empty, indicates that this field needs to be extracted as a diagnostic.
        """
        return pulumi.get(self, "field")

    @field.setter
    def field(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field", value)

    @property
    @pulumi.getter
    def level(self) -> Optional[pulumi.Input['DiagnosticLevel']]:
        """
        Level to record this diagnostic.
        """
        return pulumi.get(self, "level")

    @level.setter
    def level(self, value: Optional[pulumi.Input['DiagnosticLevel']]):
        pulumi.set(self, "level", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class ImportFileArgs:
    def __init__(__self__, *,
                 content: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] content: The contents of the file.
        :param pulumi.Input[str] name: The name of the file.
        """
        if content is not None:
            pulumi.set(__self__, "content", content)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def content(self) -> Optional[pulumi.Input[str]]:
        """
        The contents of the file.
        """
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the file.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class InputMappingArgs:
    def __init__(__self__, *,
                 field_name: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input['InputMappingLocation']] = None,
                 method_match: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        InputMapping creates a 'virtual' property that will be injected into the properties before sending the request to the underlying API.
        :param pulumi.Input[str] field_name: The name of the field that is going to be injected.
        :param pulumi.Input['InputMappingLocation'] location: The location where this mapping applies.
        :param pulumi.Input[str] method_match: Regex to evaluate on method to decide if input applies.
        :param pulumi.Input[str] value: A jsonPath expression to select an element.
        """
        if field_name is not None:
            pulumi.set(__self__, "field_name", field_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if method_match is not None:
            pulumi.set(__self__, "method_match", method_match)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="fieldName")
    def field_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the field that is going to be injected.
        """
        return pulumi.get(self, "field_name")

    @field_name.setter
    def field_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "field_name", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input['InputMappingLocation']]:
        """
        The location where this mapping applies.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input['InputMappingLocation']]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="methodMatch")
    def method_match(self) -> Optional[pulumi.Input[str]]:
        """
        Regex to evaluate on method to decide if input applies.
        """
        return pulumi.get(self, "method_match")

    @method_match.setter
    def method_match(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "method_match", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        A jsonPath expression to select an element.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class MethodMapArgs:
    def __init__(__self__, *,
                 create: Optional[pulumi.Input[str]] = None,
                 delete: Optional[pulumi.Input[str]] = None,
                 get: Optional[pulumi.Input[str]] = None,
                 set_iam_policy: Optional[pulumi.Input[str]] = None,
                 update: Optional[pulumi.Input[str]] = None):
        """
        Deployment Manager will call these methods during the events of creation/deletion/update/get/setIamPolicy
        :param pulumi.Input[str] create: The action identifier for the create method to be used for this collection
        :param pulumi.Input[str] delete: The action identifier for the delete method to be used for this collection
        :param pulumi.Input[str] get: The action identifier for the get method to be used for this collection
        :param pulumi.Input[str] set_iam_policy: The action identifier for the setIamPolicy method to be used for this collection
        :param pulumi.Input[str] update: The action identifier for the update method to be used for this collection
        """
        if create is not None:
            pulumi.set(__self__, "create", create)
        if delete is not None:
            pulumi.set(__self__, "delete", delete)
        if get is not None:
            pulumi.set(__self__, "get", get)
        if set_iam_policy is not None:
            pulumi.set(__self__, "set_iam_policy", set_iam_policy)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @property
    @pulumi.getter
    def create(self) -> Optional[pulumi.Input[str]]:
        """
        The action identifier for the create method to be used for this collection
        """
        return pulumi.get(self, "create")

    @create.setter
    def create(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create", value)

    @property
    @pulumi.getter
    def delete(self) -> Optional[pulumi.Input[str]]:
        """
        The action identifier for the delete method to be used for this collection
        """
        return pulumi.get(self, "delete")

    @delete.setter
    def delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete", value)

    @property
    @pulumi.getter
    def get(self) -> Optional[pulumi.Input[str]]:
        """
        The action identifier for the get method to be used for this collection
        """
        return pulumi.get(self, "get")

    @get.setter
    def get(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "get", value)

    @property
    @pulumi.getter(name="setIamPolicy")
    def set_iam_policy(self) -> Optional[pulumi.Input[str]]:
        """
        The action identifier for the setIamPolicy method to be used for this collection
        """
        return pulumi.get(self, "set_iam_policy")

    @set_iam_policy.setter
    def set_iam_policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "set_iam_policy", value)

    @property
    @pulumi.getter
    def update(self) -> Optional[pulumi.Input[str]]:
        """
        The action identifier for the update method to be used for this collection
        """
        return pulumi.get(self, "update")

    @update.setter
    def update(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update", value)


@pulumi.input_type
class OptionsArgs:
    def __init__(__self__, *,
                 async_options: Optional[pulumi.Input[Sequence[pulumi.Input['AsyncOptionsArgs']]]] = None,
                 input_mappings: Optional[pulumi.Input[Sequence[pulumi.Input['InputMappingArgs']]]] = None,
                 name_property: Optional[pulumi.Input[str]] = None,
                 validation_options: Optional[pulumi.Input['ValidationOptionsArgs']] = None):
        """
        Options allows customized resource handling by Deployment Manager.
        :param pulumi.Input[Sequence[pulumi.Input['AsyncOptionsArgs']]] async_options: Options regarding how to thread async requests.
        :param pulumi.Input[Sequence[pulumi.Input['InputMappingArgs']]] input_mappings: The mappings that apply for requests.
        :param pulumi.Input[str] name_property: The json path to the field in the resource JSON body into which the resource name should be mapped. Leaving this empty indicates that there should be no mapping performed.
        :param pulumi.Input['ValidationOptionsArgs'] validation_options: Options for how to validate and process properties on a resource.
        """
        if async_options is not None:
            pulumi.set(__self__, "async_options", async_options)
        if input_mappings is not None:
            pulumi.set(__self__, "input_mappings", input_mappings)
        if name_property is not None:
            pulumi.set(__self__, "name_property", name_property)
        if validation_options is not None:
            pulumi.set(__self__, "validation_options", validation_options)

    @property
    @pulumi.getter(name="asyncOptions")
    def async_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AsyncOptionsArgs']]]]:
        """
        Options regarding how to thread async requests.
        """
        return pulumi.get(self, "async_options")

    @async_options.setter
    def async_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AsyncOptionsArgs']]]]):
        pulumi.set(self, "async_options", value)

    @property
    @pulumi.getter(name="inputMappings")
    def input_mappings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InputMappingArgs']]]]:
        """
        The mappings that apply for requests.
        """
        return pulumi.get(self, "input_mappings")

    @input_mappings.setter
    def input_mappings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InputMappingArgs']]]]):
        pulumi.set(self, "input_mappings", value)

    @property
    @pulumi.getter(name="nameProperty")
    def name_property(self) -> Optional[pulumi.Input[str]]:
        """
        The json path to the field in the resource JSON body into which the resource name should be mapped. Leaving this empty indicates that there should be no mapping performed.
        """
        return pulumi.get(self, "name_property")

    @name_property.setter
    def name_property(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name_property", value)

    @property
    @pulumi.getter(name="validationOptions")
    def validation_options(self) -> Optional[pulumi.Input['ValidationOptionsArgs']]:
        """
        Options for how to validate and process properties on a resource.
        """
        return pulumi.get(self, "validation_options")

    @validation_options.setter
    def validation_options(self, value: Optional[pulumi.Input['ValidationOptionsArgs']]):
        pulumi.set(self, "validation_options", value)


@pulumi.input_type
class PollingOptionsArgs:
    def __init__(__self__, *,
                 diagnostics: Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticArgs']]]] = None,
                 fail_condition: Optional[pulumi.Input[str]] = None,
                 finish_condition: Optional[pulumi.Input[str]] = None,
                 polling_link: Optional[pulumi.Input[str]] = None,
                 target_link: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input['DiagnosticArgs']]] diagnostics: An array of diagnostics to be collected by Deployment Manager, these diagnostics will be displayed to the user.
        :param pulumi.Input[str] fail_condition: JsonPath expression that determines if the request failed.
        :param pulumi.Input[str] finish_condition: JsonPath expression that determines if the request is completed.
        :param pulumi.Input[str] polling_link: JsonPath expression that evaluates to string, it indicates where to poll.
        :param pulumi.Input[str] target_link: JsonPath expression, after polling is completed, indicates where to fetch the resource.
        """
        if diagnostics is not None:
            pulumi.set(__self__, "diagnostics", diagnostics)
        if fail_condition is not None:
            pulumi.set(__self__, "fail_condition", fail_condition)
        if finish_condition is not None:
            pulumi.set(__self__, "finish_condition", finish_condition)
        if polling_link is not None:
            pulumi.set(__self__, "polling_link", polling_link)
        if target_link is not None:
            pulumi.set(__self__, "target_link", target_link)

    @property
    @pulumi.getter
    def diagnostics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticArgs']]]]:
        """
        An array of diagnostics to be collected by Deployment Manager, these diagnostics will be displayed to the user.
        """
        return pulumi.get(self, "diagnostics")

    @diagnostics.setter
    def diagnostics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DiagnosticArgs']]]]):
        pulumi.set(self, "diagnostics", value)

    @property
    @pulumi.getter(name="failCondition")
    def fail_condition(self) -> Optional[pulumi.Input[str]]:
        """
        JsonPath expression that determines if the request failed.
        """
        return pulumi.get(self, "fail_condition")

    @fail_condition.setter
    def fail_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fail_condition", value)

    @property
    @pulumi.getter(name="finishCondition")
    def finish_condition(self) -> Optional[pulumi.Input[str]]:
        """
        JsonPath expression that determines if the request is completed.
        """
        return pulumi.get(self, "finish_condition")

    @finish_condition.setter
    def finish_condition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "finish_condition", value)

    @property
    @pulumi.getter(name="pollingLink")
    def polling_link(self) -> Optional[pulumi.Input[str]]:
        """
        JsonPath expression that evaluates to string, it indicates where to poll.
        """
        return pulumi.get(self, "polling_link")

    @polling_link.setter
    def polling_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "polling_link", value)

    @property
    @pulumi.getter(name="targetLink")
    def target_link(self) -> Optional[pulumi.Input[str]]:
        """
        JsonPath expression, after polling is completed, indicates where to fetch the resource.
        """
        return pulumi.get(self, "target_link")

    @target_link.setter
    def target_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_link", value)


@pulumi.input_type
class ServiceAccountArgs:
    def __init__(__self__, *,
                 email: Optional[pulumi.Input[str]] = None):
        """
        Service Account used as a credential.
        :param pulumi.Input[str] email: The IAM service account email address like test@myproject.iam.gserviceaccount.com
        """
        if email is not None:
            pulumi.set(__self__, "email", email)

    @property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM service account email address like test@myproject.iam.gserviceaccount.com
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email", value)


@pulumi.input_type
class TargetConfigurationArgs:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input['ConfigFileArgs']] = None,
                 imports: Optional[pulumi.Input[Sequence[pulumi.Input['ImportFileArgs']]]] = None):
        """
        :param pulumi.Input['ConfigFileArgs'] config: The configuration to use for this deployment.
        :param pulumi.Input[Sequence[pulumi.Input['ImportFileArgs']]] imports: Specifies any files to import for this configuration. This can be used to import templates or other files. For example, you might import a text file in order to use the file in a template.
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if imports is not None:
            pulumi.set(__self__, "imports", imports)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['ConfigFileArgs']]:
        """
        The configuration to use for this deployment.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['ConfigFileArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def imports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImportFileArgs']]]]:
        """
        Specifies any files to import for this configuration. This can be used to import templates or other files. For example, you might import a text file in order to use the file in a template.
        """
        return pulumi.get(self, "imports")

    @imports.setter
    def imports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImportFileArgs']]]]):
        pulumi.set(self, "imports", value)


@pulumi.input_type
class TemplateContentsArgs:
    def __init__(__self__, *,
                 imports: Optional[pulumi.Input[Sequence[pulumi.Input['ImportFileArgs']]]] = None,
                 interpreter: Optional[pulumi.Input['TemplateContentsInterpreter']] = None,
                 main_template: Optional[pulumi.Input[str]] = None,
                 schema: Optional[pulumi.Input[str]] = None,
                 template: Optional[pulumi.Input[str]] = None):
        """
        Files that make up the template contents of a template type.
        :param pulumi.Input[Sequence[pulumi.Input['ImportFileArgs']]] imports: Import files referenced by the main template.
        :param pulumi.Input['TemplateContentsInterpreter'] interpreter: Which interpreter (python or jinja) should be used during expansion.
        :param pulumi.Input[str] main_template: The filename of the mainTemplate
        :param pulumi.Input[str] schema: The contents of the template schema.
        :param pulumi.Input[str] template: The contents of the main template file.
        """
        if imports is not None:
            pulumi.set(__self__, "imports", imports)
        if interpreter is not None:
            pulumi.set(__self__, "interpreter", interpreter)
        if main_template is not None:
            pulumi.set(__self__, "main_template", main_template)
        if schema is not None:
            pulumi.set(__self__, "schema", schema)
        if template is not None:
            pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def imports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ImportFileArgs']]]]:
        """
        Import files referenced by the main template.
        """
        return pulumi.get(self, "imports")

    @imports.setter
    def imports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ImportFileArgs']]]]):
        pulumi.set(self, "imports", value)

    @property
    @pulumi.getter
    def interpreter(self) -> Optional[pulumi.Input['TemplateContentsInterpreter']]:
        """
        Which interpreter (python or jinja) should be used during expansion.
        """
        return pulumi.get(self, "interpreter")

    @interpreter.setter
    def interpreter(self, value: Optional[pulumi.Input['TemplateContentsInterpreter']]):
        pulumi.set(self, "interpreter", value)

    @property
    @pulumi.getter(name="mainTemplate")
    def main_template(self) -> Optional[pulumi.Input[str]]:
        """
        The filename of the mainTemplate
        """
        return pulumi.get(self, "main_template")

    @main_template.setter
    def main_template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_template", value)

    @property
    @pulumi.getter
    def schema(self) -> Optional[pulumi.Input[str]]:
        """
        The contents of the template schema.
        """
        return pulumi.get(self, "schema")

    @schema.setter
    def schema(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema", value)

    @property
    @pulumi.getter
    def template(self) -> Optional[pulumi.Input[str]]:
        """
        The contents of the main template file.
        """
        return pulumi.get(self, "template")

    @template.setter
    def template(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template", value)


@pulumi.input_type
class TypeProviderLabelEntryArgs:
    def __init__(__self__, *,
                 key: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Label object for TypeProviders
        :param pulumi.Input[str] key: Key of the label
        :param pulumi.Input[str] value: Value of the label
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        Key of the label
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        Value of the label
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ValidationOptionsArgs:
    def __init__(__self__, *,
                 schema_validation: Optional[pulumi.Input['ValidationOptionsSchemaValidation']] = None,
                 undeclared_properties: Optional[pulumi.Input['ValidationOptionsUndeclaredProperties']] = None):
        """
        Options for how to validate and process properties on a resource.
        :param pulumi.Input['ValidationOptionsSchemaValidation'] schema_validation: Customize how deployment manager will validate the resource against schema errors.
        :param pulumi.Input['ValidationOptionsUndeclaredProperties'] undeclared_properties: Specify what to do with extra properties when executing a request.
        """
        if schema_validation is not None:
            pulumi.set(__self__, "schema_validation", schema_validation)
        if undeclared_properties is not None:
            pulumi.set(__self__, "undeclared_properties", undeclared_properties)

    @property
    @pulumi.getter(name="schemaValidation")
    def schema_validation(self) -> Optional[pulumi.Input['ValidationOptionsSchemaValidation']]:
        """
        Customize how deployment manager will validate the resource against schema errors.
        """
        return pulumi.get(self, "schema_validation")

    @schema_validation.setter
    def schema_validation(self, value: Optional[pulumi.Input['ValidationOptionsSchemaValidation']]):
        pulumi.set(self, "schema_validation", value)

    @property
    @pulumi.getter(name="undeclaredProperties")
    def undeclared_properties(self) -> Optional[pulumi.Input['ValidationOptionsUndeclaredProperties']]:
        """
        Specify what to do with extra properties when executing a request.
        """
        return pulumi.get(self, "undeclared_properties")

    @undeclared_properties.setter
    def undeclared_properties(self, value: Optional[pulumi.Input['ValidationOptionsUndeclaredProperties']]):
        pulumi.set(self, "undeclared_properties", value)


