# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'GoogleCloudContactcenterinsightsV1ConversationCallMetadataArgs',
    'GoogleCloudContactcenterinsightsV1ConversationDataSourceArgs',
    'GoogleCloudContactcenterinsightsV1DialogflowSourceArgs',
    'GoogleCloudContactcenterinsightsV1ExactMatchConfigArgs',
    'GoogleCloudContactcenterinsightsV1GcsSourceArgs',
    'GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigArgs',
    'GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfigArgs',
    'GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupArgs',
    'GoogleCloudContactcenterinsightsV1PhraseMatchRuleArgs',
]

@pulumi.input_type
class GoogleCloudContactcenterinsightsV1ConversationCallMetadataArgs:
    def __init__(__self__, *,
                 agent_channel: Optional[pulumi.Input[int]] = None,
                 customer_channel: Optional[pulumi.Input[int]] = None):
        """
        Call-specific metadata.
        :param pulumi.Input[int] agent_channel: The audio channel that contains the agent.
        :param pulumi.Input[int] customer_channel: The audio channel that contains the customer.
        """
        if agent_channel is not None:
            pulumi.set(__self__, "agent_channel", agent_channel)
        if customer_channel is not None:
            pulumi.set(__self__, "customer_channel", customer_channel)

    @property
    @pulumi.getter(name="agentChannel")
    def agent_channel(self) -> Optional[pulumi.Input[int]]:
        """
        The audio channel that contains the agent.
        """
        return pulumi.get(self, "agent_channel")

    @agent_channel.setter
    def agent_channel(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "agent_channel", value)

    @property
    @pulumi.getter(name="customerChannel")
    def customer_channel(self) -> Optional[pulumi.Input[int]]:
        """
        The audio channel that contains the customer.
        """
        return pulumi.get(self, "customer_channel")

    @customer_channel.setter
    def customer_channel(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "customer_channel", value)


@pulumi.input_type
class GoogleCloudContactcenterinsightsV1ConversationDataSourceArgs:
    def __init__(__self__, *,
                 dialogflow_source: Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1DialogflowSourceArgs']] = None,
                 gcs_source: Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1GcsSourceArgs']] = None):
        """
        The conversation source, which is a combination of transcript and audio.
        :param pulumi.Input['GoogleCloudContactcenterinsightsV1DialogflowSourceArgs'] dialogflow_source: The source when the conversation comes from Dialogflow.
        :param pulumi.Input['GoogleCloudContactcenterinsightsV1GcsSourceArgs'] gcs_source: A Cloud Storage location specification for the audio and transcript.
        """
        if dialogflow_source is not None:
            pulumi.set(__self__, "dialogflow_source", dialogflow_source)
        if gcs_source is not None:
            pulumi.set(__self__, "gcs_source", gcs_source)

    @property
    @pulumi.getter(name="dialogflowSource")
    def dialogflow_source(self) -> Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1DialogflowSourceArgs']]:
        """
        The source when the conversation comes from Dialogflow.
        """
        return pulumi.get(self, "dialogflow_source")

    @dialogflow_source.setter
    def dialogflow_source(self, value: Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1DialogflowSourceArgs']]):
        pulumi.set(self, "dialogflow_source", value)

    @property
    @pulumi.getter(name="gcsSource")
    def gcs_source(self) -> Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1GcsSourceArgs']]:
        """
        A Cloud Storage location specification for the audio and transcript.
        """
        return pulumi.get(self, "gcs_source")

    @gcs_source.setter
    def gcs_source(self, value: Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1GcsSourceArgs']]):
        pulumi.set(self, "gcs_source", value)


@pulumi.input_type
class GoogleCloudContactcenterinsightsV1DialogflowSourceArgs:
    def __init__(__self__, *,
                 audio_uri: Optional[pulumi.Input[str]] = None):
        """
        A Dialogflow source of conversation data.
        :param pulumi.Input[str] audio_uri: Cloud Storage URI that points to a file that contains the conversation audio.
        """
        if audio_uri is not None:
            pulumi.set(__self__, "audio_uri", audio_uri)

    @property
    @pulumi.getter(name="audioUri")
    def audio_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud Storage URI that points to a file that contains the conversation audio.
        """
        return pulumi.get(self, "audio_uri")

    @audio_uri.setter
    def audio_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audio_uri", value)


@pulumi.input_type
class GoogleCloudContactcenterinsightsV1ExactMatchConfigArgs:
    def __init__(__self__, *,
                 case_sensitive: Optional[pulumi.Input[bool]] = None):
        """
        Exact match configuration.
        :param pulumi.Input[bool] case_sensitive: Whether to consider case sensitivity when performing an exact match.
        """
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to consider case sensitivity when performing an exact match.
        """
        return pulumi.get(self, "case_sensitive")

    @case_sensitive.setter
    def case_sensitive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "case_sensitive", value)


@pulumi.input_type
class GoogleCloudContactcenterinsightsV1GcsSourceArgs:
    def __init__(__self__, *,
                 audio_uri: Optional[pulumi.Input[str]] = None,
                 transcript_uri: Optional[pulumi.Input[str]] = None):
        """
        A Cloud Storage source of conversation data.
        :param pulumi.Input[str] audio_uri: Cloud Storage URI that points to a file that contains the conversation audio.
        :param pulumi.Input[str] transcript_uri: Immutable. Cloud Storage URI that points to a file that contains the conversation transcript.
        """
        if audio_uri is not None:
            pulumi.set(__self__, "audio_uri", audio_uri)
        if transcript_uri is not None:
            pulumi.set(__self__, "transcript_uri", transcript_uri)

    @property
    @pulumi.getter(name="audioUri")
    def audio_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Cloud Storage URI that points to a file that contains the conversation audio.
        """
        return pulumi.get(self, "audio_uri")

    @audio_uri.setter
    def audio_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audio_uri", value)

    @property
    @pulumi.getter(name="transcriptUri")
    def transcript_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Immutable. Cloud Storage URI that points to a file that contains the conversation transcript.
        """
        return pulumi.get(self, "transcript_uri")

    @transcript_uri.setter
    def transcript_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transcript_uri", value)


@pulumi.input_type
class GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigArgs:
    def __init__(__self__, *,
                 filter: Optional[pulumi.Input[str]] = None,
                 medium: Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigMedium']] = None):
        """
        Configs for the input data used to create the issue model.
        :param pulumi.Input[str] filter: A filter to reduce the conversations used for training the model to a specific subset.
        :param pulumi.Input['GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigMedium'] medium: Medium of conversations used in training data. This field is being deprecated. To specify the medium to be used in training a new issue model, set the `medium` field on `filter`.
        """
        if filter is not None:
            pulumi.set(__self__, "filter", filter)
        if medium is not None:
            pulumi.set(__self__, "medium", medium)

    @property
    @pulumi.getter
    def filter(self) -> Optional[pulumi.Input[str]]:
        """
        A filter to reduce the conversations used for training the model to a specific subset.
        """
        return pulumi.get(self, "filter")

    @filter.setter
    def filter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "filter", value)

    @property
    @pulumi.getter
    def medium(self) -> Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigMedium']]:
        """
        Medium of conversations used in training data. This field is being deprecated. To specify the medium to be used in training a new issue model, set the `medium` field on `filter`.
        """
        return pulumi.get(self, "medium")

    @medium.setter
    def medium(self, value: Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1IssueModelInputDataConfigMedium']]):
        pulumi.set(self, "medium", value)


@pulumi.input_type
class GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfigArgs:
    def __init__(__self__, *,
                 exact_match_config: Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1ExactMatchConfigArgs']] = None):
        """
        Configuration information of a phrase match rule.
        :param pulumi.Input['GoogleCloudContactcenterinsightsV1ExactMatchConfigArgs'] exact_match_config: The configuration for the exact match rule.
        """
        if exact_match_config is not None:
            pulumi.set(__self__, "exact_match_config", exact_match_config)

    @property
    @pulumi.getter(name="exactMatchConfig")
    def exact_match_config(self) -> Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1ExactMatchConfigArgs']]:
        """
        The configuration for the exact match rule.
        """
        return pulumi.get(self, "exact_match_config")

    @exact_match_config.setter
    def exact_match_config(self, value: Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1ExactMatchConfigArgs']]):
        pulumi.set(self, "exact_match_config", value)


@pulumi.input_type
class GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupArgs:
    def __init__(__self__, *,
                 type: pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupType'],
                 phrase_match_rules: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleArgs']]]] = None):
        """
        A message representing a rule in the phrase matcher.
        :param pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupType'] type: The type of this phrase match rule group.
        :param pulumi.Input[Sequence[pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleArgs']]] phrase_match_rules: A list of phase match rules that are included in this group.
        """
        pulumi.set(__self__, "type", type)
        if phrase_match_rules is not None:
            pulumi.set(__self__, "phrase_match_rules", phrase_match_rules)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupType']:
        """
        The type of this phrase match rule group.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleGroupType']):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="phraseMatchRules")
    def phrase_match_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleArgs']]]]:
        """
        A list of phase match rules that are included in this group.
        """
        return pulumi.get(self, "phrase_match_rules")

    @phrase_match_rules.setter
    def phrase_match_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleArgs']]]]):
        pulumi.set(self, "phrase_match_rules", value)


@pulumi.input_type
class GoogleCloudContactcenterinsightsV1PhraseMatchRuleArgs:
    def __init__(__self__, *,
                 query: pulumi.Input[str],
                 config: Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfigArgs']] = None,
                 negated: Optional[pulumi.Input[bool]] = None):
        """
        The data for a phrase match rule.
        :param pulumi.Input[str] query: The phrase to be matched.
        :param pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfigArgs'] config: Provides additional information about the rule that specifies how to apply the rule.
        :param pulumi.Input[bool] negated: Specifies whether the phrase must be missing from the transcript segment or present in the transcript segment.
        """
        pulumi.set(__self__, "query", query)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if negated is not None:
            pulumi.set(__self__, "negated", negated)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        The phrase to be matched.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfigArgs']]:
        """
        Provides additional information about the rule that specifies how to apply the rule.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input['GoogleCloudContactcenterinsightsV1PhraseMatchRuleConfigArgs']]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def negated(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether the phrase must be missing from the transcript segment or present in the transcript segment.
        """
        return pulumi.get(self, "negated")

    @negated.setter
    def negated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "negated", value)


