# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetConnectionResult',
    'AwaitableGetConnectionResult',
    'get_connection',
    'get_connection_output',
]

@pulumi.output_type
class GetConnectionResult:
    def __init__(__self__, auth_config=None, config_variables=None, connector_version=None, create_time=None, description=None, destination_configs=None, envoy_image_location=None, image_location=None, labels=None, lock_config=None, name=None, node_config=None, service_account=None, service_directory=None, status=None, suspended=None, update_time=None):
        if auth_config and not isinstance(auth_config, dict):
            raise TypeError("Expected argument 'auth_config' to be a dict")
        pulumi.set(__self__, "auth_config", auth_config)
        if config_variables and not isinstance(config_variables, list):
            raise TypeError("Expected argument 'config_variables' to be a list")
        pulumi.set(__self__, "config_variables", config_variables)
        if connector_version and not isinstance(connector_version, str):
            raise TypeError("Expected argument 'connector_version' to be a str")
        pulumi.set(__self__, "connector_version", connector_version)
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if destination_configs and not isinstance(destination_configs, list):
            raise TypeError("Expected argument 'destination_configs' to be a list")
        pulumi.set(__self__, "destination_configs", destination_configs)
        if envoy_image_location and not isinstance(envoy_image_location, str):
            raise TypeError("Expected argument 'envoy_image_location' to be a str")
        pulumi.set(__self__, "envoy_image_location", envoy_image_location)
        if image_location and not isinstance(image_location, str):
            raise TypeError("Expected argument 'image_location' to be a str")
        pulumi.set(__self__, "image_location", image_location)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if lock_config and not isinstance(lock_config, dict):
            raise TypeError("Expected argument 'lock_config' to be a dict")
        pulumi.set(__self__, "lock_config", lock_config)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_config and not isinstance(node_config, dict):
            raise TypeError("Expected argument 'node_config' to be a dict")
        pulumi.set(__self__, "node_config", node_config)
        if service_account and not isinstance(service_account, str):
            raise TypeError("Expected argument 'service_account' to be a str")
        pulumi.set(__self__, "service_account", service_account)
        if service_directory and not isinstance(service_directory, str):
            raise TypeError("Expected argument 'service_directory' to be a str")
        pulumi.set(__self__, "service_directory", service_directory)
        if status and not isinstance(status, dict):
            raise TypeError("Expected argument 'status' to be a dict")
        pulumi.set(__self__, "status", status)
        if suspended and not isinstance(suspended, bool):
            raise TypeError("Expected argument 'suspended' to be a bool")
        pulumi.set(__self__, "suspended", suspended)
        if update_time and not isinstance(update_time, str):
            raise TypeError("Expected argument 'update_time' to be a str")
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="authConfig")
    def auth_config(self) -> 'outputs.AuthConfigResponse':
        """
        Optional. Configuration for establishing the connection's authentication with an external system.
        """
        return pulumi.get(self, "auth_config")

    @property
    @pulumi.getter(name="configVariables")
    def config_variables(self) -> Sequence['outputs.ConfigVariableResponse']:
        """
        Optional. Configuration for configuring the connection with an external system.
        """
        return pulumi.get(self, "config_variables")

    @property
    @pulumi.getter(name="connectorVersion")
    def connector_version(self) -> str:
        """
        Connector version on which the connection is created. The format is: projects/*/locations/*/providers/*/connectors/*/versions/* Only global location is supported for ConnectorVersion resource.
        """
        return pulumi.get(self, "connector_version")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Created time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationConfigs")
    def destination_configs(self) -> Sequence['outputs.DestinationConfigResponse']:
        """
        Optional. Configuration of the Connector's destination. Only accepted for Connectors that accepts user defined destination(s).
        """
        return pulumi.get(self, "destination_configs")

    @property
    @pulumi.getter(name="envoyImageLocation")
    def envoy_image_location(self) -> str:
        """
        GCR location where the envoy image is stored. formatted like: gcr.io/{bucketName}/{imageName}
        """
        return pulumi.get(self, "envoy_image_location")

    @property
    @pulumi.getter(name="imageLocation")
    def image_location(self) -> str:
        """
        GCR location where the runtime image is stored. formatted like: gcr.io/{bucketName}/{imageName}
        """
        return pulumi.get(self, "image_location")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. Resource labels to represent user-provided metadata. Refer to cloud documentation on labels for more details. https://cloud.google.com/compute/docs/labeling-resources
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="lockConfig")
    def lock_config(self) -> 'outputs.LockConfigResponse':
        """
        Optional. Configuration that indicates whether or not the Connection can be edited.
        """
        return pulumi.get(self, "lock_config")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Resource name of the Connection. Format: projects/{project}/locations/{location}/connections/{connection}
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> 'outputs.NodeConfigResponse':
        """
        Optional. Configuration for the connection.
        """
        return pulumi.get(self, "node_config")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Optional. Service account needed for runtime plane to access GCP resources.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="serviceDirectory")
    def service_directory(self) -> str:
        """
        The name of the Service Directory service name. Used for Private Harpoon to resolve the ILB address. e.g. "projects/cloud-connectors-e2e-testing/locations/us-central1/namespaces/istio-system/services/istio-ingressgateway-connectors"
        """
        return pulumi.get(self, "service_directory")

    @property
    @pulumi.getter
    def status(self) -> 'outputs.ConnectionStatusResponse':
        """
        Current status of the connection.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def suspended(self) -> bool:
        """
        Optional. Suspended indicates if a user has suspended a connection or not.
        """
        return pulumi.get(self, "suspended")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Updated time.
        """
        return pulumi.get(self, "update_time")


class AwaitableGetConnectionResult(GetConnectionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionResult(
            auth_config=self.auth_config,
            config_variables=self.config_variables,
            connector_version=self.connector_version,
            create_time=self.create_time,
            description=self.description,
            destination_configs=self.destination_configs,
            envoy_image_location=self.envoy_image_location,
            image_location=self.image_location,
            labels=self.labels,
            lock_config=self.lock_config,
            name=self.name,
            node_config=self.node_config,
            service_account=self.service_account,
            service_directory=self.service_directory,
            status=self.status,
            suspended=self.suspended,
            update_time=self.update_time)


def get_connection(connection_id: Optional[str] = None,
                   location: Optional[str] = None,
                   project: Optional[str] = None,
                   view: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionResult:
    """
    Gets details of a single Connection.
    """
    __args__ = dict()
    __args__['connectionId'] = connection_id
    __args__['location'] = location
    __args__['project'] = project
    __args__['view'] = view
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('google-native:connectors/v1:getConnection', __args__, opts=opts, typ=GetConnectionResult).value

    return AwaitableGetConnectionResult(
        auth_config=__ret__.auth_config,
        config_variables=__ret__.config_variables,
        connector_version=__ret__.connector_version,
        create_time=__ret__.create_time,
        description=__ret__.description,
        destination_configs=__ret__.destination_configs,
        envoy_image_location=__ret__.envoy_image_location,
        image_location=__ret__.image_location,
        labels=__ret__.labels,
        lock_config=__ret__.lock_config,
        name=__ret__.name,
        node_config=__ret__.node_config,
        service_account=__ret__.service_account,
        service_directory=__ret__.service_directory,
        status=__ret__.status,
        suspended=__ret__.suspended,
        update_time=__ret__.update_time)


@_utilities.lift_output_func(get_connection)
def get_connection_output(connection_id: Optional[pulumi.Input[str]] = None,
                          location: Optional[pulumi.Input[str]] = None,
                          project: Optional[pulumi.Input[Optional[str]]] = None,
                          view: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectionResult]:
    """
    Gets details of a single Connection.
    """
    ...
