# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'BindingResponse',
    'DeviceConfigResponse',
    'DeviceCredentialResponse',
    'DeviceStateResponse',
    'EventNotificationConfigResponse',
    'ExprResponse',
    'GatewayConfigResponse',
    'HttpConfigResponse',
    'MqttConfigResponse',
    'PublicKeyCertificateResponse',
    'PublicKeyCredentialResponse',
    'RegistryCredentialResponse',
    'StateNotificationConfigResponse',
    'StatusResponse',
    'X509CertificateDetailsResponse',
]

@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Google Cloud resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class DeviceConfigResponse(dict):
    """
    The device configuration. Eventually delivered to devices.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "binaryData":
            suggest = "binary_data"
        elif key == "cloudUpdateTime":
            suggest = "cloud_update_time"
        elif key == "deviceAckTime":
            suggest = "device_ack_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 binary_data: str,
                 cloud_update_time: str,
                 device_ack_time: str,
                 version: str):
        """
        The device configuration. Eventually delivered to devices.
        :param str binary_data: The device configuration data.
        :param str cloud_update_time: [Output only] The time at which this configuration version was updated in Cloud IoT Core. This timestamp is set by the server.
        :param str device_ack_time: [Output only] The time at which Cloud IoT Core received the acknowledgment from the device, indicating that the device has received this configuration version. If this field is not present, the device has not yet acknowledged that it received this version. Note that when the config was sent to the device, many config versions may have been available in Cloud IoT Core while the device was disconnected, and on connection, only the latest version is sent to the device. Some versions may never be sent to the device, and therefore are never acknowledged. This timestamp is set by Cloud IoT Core.
        :param str version: [Output only] The version of this update. The version number is assigned by the server, and is always greater than 0 after device creation. The version must be 0 on the `CreateDevice` request if a `config` is specified; the response of `CreateDevice` will always have a value of 1.
        """
        pulumi.set(__self__, "binary_data", binary_data)
        pulumi.set(__self__, "cloud_update_time", cloud_update_time)
        pulumi.set(__self__, "device_ack_time", device_ack_time)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="binaryData")
    def binary_data(self) -> str:
        """
        The device configuration data.
        """
        return pulumi.get(self, "binary_data")

    @property
    @pulumi.getter(name="cloudUpdateTime")
    def cloud_update_time(self) -> str:
        """
        [Output only] The time at which this configuration version was updated in Cloud IoT Core. This timestamp is set by the server.
        """
        return pulumi.get(self, "cloud_update_time")

    @property
    @pulumi.getter(name="deviceAckTime")
    def device_ack_time(self) -> str:
        """
        [Output only] The time at which Cloud IoT Core received the acknowledgment from the device, indicating that the device has received this configuration version. If this field is not present, the device has not yet acknowledged that it received this version. Note that when the config was sent to the device, many config versions may have been available in Cloud IoT Core while the device was disconnected, and on connection, only the latest version is sent to the device. Some versions may never be sent to the device, and therefore are never acknowledged. This timestamp is set by Cloud IoT Core.
        """
        return pulumi.get(self, "device_ack_time")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        [Output only] The version of this update. The version number is assigned by the server, and is always greater than 0 after device creation. The version must be 0 on the `CreateDevice` request if a `config` is specified; the response of `CreateDevice` will always have a value of 1.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DeviceCredentialResponse(dict):
    """
    A server-stored device credential used for authentication.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationTime":
            suggest = "expiration_time"
        elif key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceCredentialResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceCredentialResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceCredentialResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiration_time: str,
                 public_key: 'outputs.PublicKeyCredentialResponse'):
        """
        A server-stored device credential used for authentication.
        :param str expiration_time: [Optional] The time at which this credential becomes invalid. This credential will be ignored for new client authentication requests after this timestamp; however, it will not be automatically deleted.
        :param 'PublicKeyCredentialResponse' public_key: A public key used to verify the signature of JSON Web Tokens (JWTs). When adding a new device credential, either via device creation or via modifications, this public key credential may be required to be signed by one of the registry level certificates. More specifically, if the registry contains at least one certificate, any new device credential must be signed by one of the registry certificates. As a result, when the registry contains certificates, only X.509 certificates are accepted as device credentials. However, if the registry does not contain a certificate, self-signed certificates and public keys will be accepted. New device credentials must be different from every registry-level certificate.
        """
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        """
        [Optional] The time at which this credential becomes invalid. This credential will be ignored for new client authentication requests after this timestamp; however, it will not be automatically deleted.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> 'outputs.PublicKeyCredentialResponse':
        """
        A public key used to verify the signature of JSON Web Tokens (JWTs). When adding a new device credential, either via device creation or via modifications, this public key credential may be required to be signed by one of the registry level certificates. More specifically, if the registry contains at least one certificate, any new device credential must be signed by one of the registry certificates. As a result, when the registry contains certificates, only X.509 certificates are accepted as device credentials. However, if the registry does not contain a certificate, self-signed certificates and public keys will be accepted. New device credentials must be different from every registry-level certificate.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class DeviceStateResponse(dict):
    """
    The device state, as reported by the device.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "binaryData":
            suggest = "binary_data"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceStateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceStateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceStateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 binary_data: str,
                 update_time: str):
        """
        The device state, as reported by the device.
        :param str binary_data: The device state data.
        :param str update_time: [Output only] The time at which this state version was updated in Cloud IoT Core.
        """
        pulumi.set(__self__, "binary_data", binary_data)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="binaryData")
    def binary_data(self) -> str:
        """
        The device state data.
        """
        return pulumi.get(self, "binary_data")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        [Output only] The time at which this state version was updated in Cloud IoT Core.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class EventNotificationConfigResponse(dict):
    """
    The configuration for forwarding telemetry events.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pubsubTopicName":
            suggest = "pubsub_topic_name"
        elif key == "subfolderMatches":
            suggest = "subfolder_matches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EventNotificationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EventNotificationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EventNotificationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pubsub_topic_name: str,
                 subfolder_matches: str):
        """
        The configuration for forwarding telemetry events.
        :param str pubsub_topic_name: A Cloud Pub/Sub topic name. For example, `projects/myProject/topics/deviceEvents`.
        :param str subfolder_matches: If the subfolder name matches this string exactly, this configuration will be used. The string must not include the leading '/' character. If empty, all strings are matched. This field is used only for telemetry events; subfolders are not supported for state changes.
        """
        pulumi.set(__self__, "pubsub_topic_name", pubsub_topic_name)
        pulumi.set(__self__, "subfolder_matches", subfolder_matches)

    @property
    @pulumi.getter(name="pubsubTopicName")
    def pubsub_topic_name(self) -> str:
        """
        A Cloud Pub/Sub topic name. For example, `projects/myProject/topics/deviceEvents`.
        """
        return pulumi.get(self, "pubsub_topic_name")

    @property
    @pulumi.getter(name="subfolderMatches")
    def subfolder_matches(self) -> str:
        """
        If the subfolder name matches this string exactly, this configuration will be used. The string must not include the leading '/' character. If empty, all strings are matched. This field is used only for telemetry events; subfolders are not supported for state changes.
        """
        return pulumi.get(self, "subfolder_matches")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GatewayConfigResponse(dict):
    """
    Gateway-related configuration and state.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gatewayAuthMethod":
            suggest = "gateway_auth_method"
        elif key == "gatewayType":
            suggest = "gateway_type"
        elif key == "lastAccessedGatewayId":
            suggest = "last_accessed_gateway_id"
        elif key == "lastAccessedGatewayTime":
            suggest = "last_accessed_gateway_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GatewayConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GatewayConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GatewayConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gateway_auth_method: str,
                 gateway_type: str,
                 last_accessed_gateway_id: str,
                 last_accessed_gateway_time: str):
        """
        Gateway-related configuration and state.
        :param str gateway_auth_method: Indicates how to authorize and/or authenticate devices to access the gateway.
        :param str gateway_type: Indicates whether the device is a gateway.
        :param str last_accessed_gateway_id: [Output only] The ID of the gateway the device accessed most recently.
        :param str last_accessed_gateway_time: [Output only] The most recent time at which the device accessed the gateway specified in `last_accessed_gateway`.
        """
        pulumi.set(__self__, "gateway_auth_method", gateway_auth_method)
        pulumi.set(__self__, "gateway_type", gateway_type)
        pulumi.set(__self__, "last_accessed_gateway_id", last_accessed_gateway_id)
        pulumi.set(__self__, "last_accessed_gateway_time", last_accessed_gateway_time)

    @property
    @pulumi.getter(name="gatewayAuthMethod")
    def gateway_auth_method(self) -> str:
        """
        Indicates how to authorize and/or authenticate devices to access the gateway.
        """
        return pulumi.get(self, "gateway_auth_method")

    @property
    @pulumi.getter(name="gatewayType")
    def gateway_type(self) -> str:
        """
        Indicates whether the device is a gateway.
        """
        return pulumi.get(self, "gateway_type")

    @property
    @pulumi.getter(name="lastAccessedGatewayId")
    def last_accessed_gateway_id(self) -> str:
        """
        [Output only] The ID of the gateway the device accessed most recently.
        """
        return pulumi.get(self, "last_accessed_gateway_id")

    @property
    @pulumi.getter(name="lastAccessedGatewayTime")
    def last_accessed_gateway_time(self) -> str:
        """
        [Output only] The most recent time at which the device accessed the gateway specified in `last_accessed_gateway`.
        """
        return pulumi.get(self, "last_accessed_gateway_time")


@pulumi.output_type
class HttpConfigResponse(dict):
    """
    The configuration of the HTTP bridge for a device registry.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "httpEnabledState":
            suggest = "http_enabled_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HttpConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HttpConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HttpConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 http_enabled_state: str):
        """
        The configuration of the HTTP bridge for a device registry.
        :param str http_enabled_state: If enabled, allows devices to use DeviceService via the HTTP protocol. Otherwise, any requests to DeviceService will fail for this registry.
        """
        pulumi.set(__self__, "http_enabled_state", http_enabled_state)

    @property
    @pulumi.getter(name="httpEnabledState")
    def http_enabled_state(self) -> str:
        """
        If enabled, allows devices to use DeviceService via the HTTP protocol. Otherwise, any requests to DeviceService will fail for this registry.
        """
        return pulumi.get(self, "http_enabled_state")


@pulumi.output_type
class MqttConfigResponse(dict):
    """
    The configuration of MQTT for a device registry.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mqttEnabledState":
            suggest = "mqtt_enabled_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MqttConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MqttConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MqttConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mqtt_enabled_state: str):
        """
        The configuration of MQTT for a device registry.
        :param str mqtt_enabled_state: If enabled, allows connections using the MQTT protocol. Otherwise, MQTT connections to this registry will fail.
        """
        pulumi.set(__self__, "mqtt_enabled_state", mqtt_enabled_state)

    @property
    @pulumi.getter(name="mqttEnabledState")
    def mqtt_enabled_state(self) -> str:
        """
        If enabled, allows connections using the MQTT protocol. Otherwise, MQTT connections to this registry will fail.
        """
        return pulumi.get(self, "mqtt_enabled_state")


@pulumi.output_type
class PublicKeyCertificateResponse(dict):
    """
    A public key certificate format and data.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "x509Details":
            suggest = "x509_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PublicKeyCertificateResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PublicKeyCertificateResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PublicKeyCertificateResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate: str,
                 format: str,
                 x509_details: 'outputs.X509CertificateDetailsResponse'):
        """
        A public key certificate format and data.
        :param str certificate: The certificate data.
        :param str format: The certificate format.
        :param 'X509CertificateDetailsResponse' x509_details: [Output only] The certificate details. Used only for X.509 certificates.
        """
        pulumi.set(__self__, "certificate", certificate)
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "x509_details", x509_details)

    @property
    @pulumi.getter
    def certificate(self) -> str:
        """
        The certificate data.
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        The certificate format.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="x509Details")
    def x509_details(self) -> 'outputs.X509CertificateDetailsResponse':
        """
        [Output only] The certificate details. Used only for X.509 certificates.
        """
        return pulumi.get(self, "x509_details")


@pulumi.output_type
class PublicKeyCredentialResponse(dict):
    """
    A public key format and data.
    """
    def __init__(__self__, *,
                 format: str,
                 key: str):
        """
        A public key format and data.
        :param str format: The format of the key.
        :param str key: The key data.
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        The format of the key.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key data.
        """
        return pulumi.get(self, "key")


@pulumi.output_type
class RegistryCredentialResponse(dict):
    """
    A server-stored registry credential used to validate device credentials.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKeyCertificate":
            suggest = "public_key_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RegistryCredentialResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RegistryCredentialResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RegistryCredentialResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_key_certificate: 'outputs.PublicKeyCertificateResponse'):
        """
        A server-stored registry credential used to validate device credentials.
        :param 'PublicKeyCertificateResponse' public_key_certificate: A public key certificate used to verify the device credentials.
        """
        pulumi.set(__self__, "public_key_certificate", public_key_certificate)

    @property
    @pulumi.getter(name="publicKeyCertificate")
    def public_key_certificate(self) -> 'outputs.PublicKeyCertificateResponse':
        """
        A public key certificate used to verify the device credentials.
        """
        return pulumi.get(self, "public_key_certificate")


@pulumi.output_type
class StateNotificationConfigResponse(dict):
    """
    The configuration for notification of new states received from the device.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pubsubTopicName":
            suggest = "pubsub_topic_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateNotificationConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateNotificationConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateNotificationConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pubsub_topic_name: str):
        """
        The configuration for notification of new states received from the device.
        :param str pubsub_topic_name: A Cloud Pub/Sub topic name. For example, `projects/myProject/topics/deviceEvents`.
        """
        pulumi.set(__self__, "pubsub_topic_name", pubsub_topic_name)

    @property
    @pulumi.getter(name="pubsubTopicName")
    def pubsub_topic_name(self) -> str:
        """
        A Cloud Pub/Sub topic name. For example, `projects/myProject/topics/deviceEvents`.
        """
        return pulumi.get(self, "pubsub_topic_name")


@pulumi.output_type
class StatusResponse(dict):
    """
    The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
    """
    def __init__(__self__, *,
                 code: int,
                 details: Sequence[Mapping[str, str]],
                 message: str):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param int code: The status code, which should be an enum value of google.rpc.Code.
        :param Sequence[Mapping[str, str]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param str message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        pulumi.set(__self__, "code", code)
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> int:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def details(self) -> Sequence[Mapping[str, str]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")


@pulumi.output_type
class X509CertificateDetailsResponse(dict):
    """
    Details of an X.509 certificate. For informational purposes only.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiryTime":
            suggest = "expiry_time"
        elif key == "publicKeyType":
            suggest = "public_key_type"
        elif key == "signatureAlgorithm":
            suggest = "signature_algorithm"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in X509CertificateDetailsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        X509CertificateDetailsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        X509CertificateDetailsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 expiry_time: str,
                 issuer: str,
                 public_key_type: str,
                 signature_algorithm: str,
                 start_time: str,
                 subject: str):
        """
        Details of an X.509 certificate. For informational purposes only.
        :param str expiry_time: The time the certificate becomes invalid.
        :param str issuer: The entity that signed the certificate.
        :param str public_key_type: The type of public key in the certificate.
        :param str signature_algorithm: The algorithm used to sign the certificate.
        :param str start_time: The time the certificate becomes valid.
        :param str subject: The entity the certificate and public key belong to.
        """
        pulumi.set(__self__, "expiry_time", expiry_time)
        pulumi.set(__self__, "issuer", issuer)
        pulumi.set(__self__, "public_key_type", public_key_type)
        pulumi.set(__self__, "signature_algorithm", signature_algorithm)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "subject", subject)

    @property
    @pulumi.getter(name="expiryTime")
    def expiry_time(self) -> str:
        """
        The time the certificate becomes invalid.
        """
        return pulumi.get(self, "expiry_time")

    @property
    @pulumi.getter
    def issuer(self) -> str:
        """
        The entity that signed the certificate.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter(name="publicKeyType")
    def public_key_type(self) -> str:
        """
        The type of public key in the certificate.
        """
        return pulumi.get(self, "public_key_type")

    @property
    @pulumi.getter(name="signatureAlgorithm")
    def signature_algorithm(self) -> str:
        """
        The algorithm used to sign the certificate.
        """
        return pulumi.get(self, "signature_algorithm")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The time the certificate becomes valid.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def subject(self) -> str:
        """
        The entity the certificate and public key belong to.
        """
        return pulumi.get(self, "subject")


