# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['RoutineArgs', 'Routine']

@pulumi.input_type
class RoutineArgs:
    def __init__(__self__, *,
                 dataset_id: pulumi.Input[str],
                 definition_body: pulumi.Input[str],
                 routine_reference: pulumi.Input['RoutineReferenceArgs'],
                 routine_type: pulumi.Input['RoutineRoutineType'],
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 determinism_level: Optional[pulumi.Input['RoutineDeterminismLevel']] = None,
                 imported_libraries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 language: Optional[pulumi.Input['RoutineLanguage']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 remote_function_options: Optional[pulumi.Input['RemoteFunctionOptionsArgs']] = None,
                 return_table_type: Optional[pulumi.Input['StandardSqlTableTypeArgs']] = None,
                 return_type: Optional[pulumi.Input['StandardSqlDataTypeArgs']] = None,
                 spark_options: Optional[pulumi.Input['SparkOptionsArgs']] = None,
                 strict_mode: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a Routine resource.
        :param pulumi.Input[str] definition_body: The body of the routine. For functions, this is the expression in the AS clause. If language=SQL, it is the substring inside (but excluding) the parentheses. For example, for the function created with the following statement: `CREATE FUNCTION JoinLines(x string, y string) as (concat(x, "\\n", y))` The definition_body is `concat(x, "\\n", y)` (\\n is not replaced with linebreak). If language=JAVASCRIPT, it is the evaluated string in the AS clause. For example, for the function created with the following statement: `CREATE FUNCTION f() RETURNS STRING LANGUAGE js AS 'return "\\n";\\n'` The definition_body is `return "\\n";\\n` Note that both \\n are replaced with linebreaks.
        :param pulumi.Input['RoutineReferenceArgs'] routine_reference: Reference describing the ID of this routine.
        :param pulumi.Input['RoutineRoutineType'] routine_type: The type of routine.
        :param pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]] arguments: Optional.
        :param pulumi.Input[str] description: Optional. The description of the routine, if defined.
        :param pulumi.Input['RoutineDeterminismLevel'] determinism_level: Optional. The determinism level of the JavaScript UDF, if defined.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] imported_libraries: Optional. If language = "JAVASCRIPT", this field stores the path of the imported JAVASCRIPT libraries.
        :param pulumi.Input['RoutineLanguage'] language: Optional. Defaults to "SQL".
        :param pulumi.Input['RemoteFunctionOptionsArgs'] remote_function_options: Optional. Remote function specific options.
        :param pulumi.Input['StandardSqlTableTypeArgs'] return_table_type: Optional. Can be set only if routine_type = "TABLE_VALUED_FUNCTION". If absent, the return table type is inferred from definition_body at query time in each query that references this routine. If present, then the columns in the evaluated table result will be cast to match the column types specificed in return table type, at query time.
        :param pulumi.Input['StandardSqlDataTypeArgs'] return_type: Optional if language = "SQL"; required otherwise. Cannot be set if routine_type = "TABLE_VALUED_FUNCTION". If absent, the return type is inferred from definition_body at query time in each query that references this routine. If present, then the evaluated result will be cast to the specified returned type at query time. For example, for the functions created with the following statements: * `CREATE FUNCTION Add(x FLOAT64, y FLOAT64) RETURNS FLOAT64 AS (x + y);` * `CREATE FUNCTION Increment(x FLOAT64) AS (Add(x, 1));` * `CREATE FUNCTION Decrement(x FLOAT64) RETURNS FLOAT64 AS (Add(x, -1));` The return_type is `{type_kind: "FLOAT64"}` for `Add` and `Decrement`, and is absent for `Increment` (inferred as FLOAT64 at query time). Suppose the function `Add` is replaced by `CREATE OR REPLACE FUNCTION Add(x INT64, y INT64) AS (x + y);` Then the inferred return type of `Increment` is automatically changed to INT64 at query time, while the return type of `Decrement` remains FLOAT64.
        :param pulumi.Input['SparkOptionsArgs'] spark_options: Optional. Spark specific options.
        :param pulumi.Input[bool] strict_mode: Optional. Can be set for procedures only. If true (default), the definition body will be validated in the creation and the updates of the procedure. For procedures with an argument of ANY TYPE, the definition body validtion is not supported at creation/update time, and thus this field must be set to false explicitly.
        """
        pulumi.set(__self__, "dataset_id", dataset_id)
        pulumi.set(__self__, "definition_body", definition_body)
        pulumi.set(__self__, "routine_reference", routine_reference)
        pulumi.set(__self__, "routine_type", routine_type)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if determinism_level is not None:
            pulumi.set(__self__, "determinism_level", determinism_level)
        if imported_libraries is not None:
            pulumi.set(__self__, "imported_libraries", imported_libraries)
        if language is not None:
            pulumi.set(__self__, "language", language)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if remote_function_options is not None:
            pulumi.set(__self__, "remote_function_options", remote_function_options)
        if return_table_type is not None:
            pulumi.set(__self__, "return_table_type", return_table_type)
        if return_type is not None:
            pulumi.set(__self__, "return_type", return_type)
        if spark_options is not None:
            pulumi.set(__self__, "spark_options", spark_options)
        if strict_mode is not None:
            pulumi.set(__self__, "strict_mode", strict_mode)

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Input[str]:
        return pulumi.get(self, "dataset_id")

    @dataset_id.setter
    def dataset_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "dataset_id", value)

    @property
    @pulumi.getter(name="definitionBody")
    def definition_body(self) -> pulumi.Input[str]:
        """
        The body of the routine. For functions, this is the expression in the AS clause. If language=SQL, it is the substring inside (but excluding) the parentheses. For example, for the function created with the following statement: `CREATE FUNCTION JoinLines(x string, y string) as (concat(x, "\\n", y))` The definition_body is `concat(x, "\\n", y)` (\\n is not replaced with linebreak). If language=JAVASCRIPT, it is the evaluated string in the AS clause. For example, for the function created with the following statement: `CREATE FUNCTION f() RETURNS STRING LANGUAGE js AS 'return "\\n";\\n'` The definition_body is `return "\\n";\\n` Note that both \\n are replaced with linebreaks.
        """
        return pulumi.get(self, "definition_body")

    @definition_body.setter
    def definition_body(self, value: pulumi.Input[str]):
        pulumi.set(self, "definition_body", value)

    @property
    @pulumi.getter(name="routineReference")
    def routine_reference(self) -> pulumi.Input['RoutineReferenceArgs']:
        """
        Reference describing the ID of this routine.
        """
        return pulumi.get(self, "routine_reference")

    @routine_reference.setter
    def routine_reference(self, value: pulumi.Input['RoutineReferenceArgs']):
        pulumi.set(self, "routine_reference", value)

    @property
    @pulumi.getter(name="routineType")
    def routine_type(self) -> pulumi.Input['RoutineRoutineType']:
        """
        The type of routine.
        """
        return pulumi.get(self, "routine_type")

    @routine_type.setter
    def routine_type(self, value: pulumi.Input['RoutineRoutineType']):
        pulumi.set(self, "routine_type", value)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]]]:
        """
        Optional.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ArgumentArgs']]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The description of the routine, if defined.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="determinismLevel")
    def determinism_level(self) -> Optional[pulumi.Input['RoutineDeterminismLevel']]:
        """
        Optional. The determinism level of the JavaScript UDF, if defined.
        """
        return pulumi.get(self, "determinism_level")

    @determinism_level.setter
    def determinism_level(self, value: Optional[pulumi.Input['RoutineDeterminismLevel']]):
        pulumi.set(self, "determinism_level", value)

    @property
    @pulumi.getter(name="importedLibraries")
    def imported_libraries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. If language = "JAVASCRIPT", this field stores the path of the imported JAVASCRIPT libraries.
        """
        return pulumi.get(self, "imported_libraries")

    @imported_libraries.setter
    def imported_libraries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "imported_libraries", value)

    @property
    @pulumi.getter
    def language(self) -> Optional[pulumi.Input['RoutineLanguage']]:
        """
        Optional. Defaults to "SQL".
        """
        return pulumi.get(self, "language")

    @language.setter
    def language(self, value: Optional[pulumi.Input['RoutineLanguage']]):
        pulumi.set(self, "language", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="remoteFunctionOptions")
    def remote_function_options(self) -> Optional[pulumi.Input['RemoteFunctionOptionsArgs']]:
        """
        Optional. Remote function specific options.
        """
        return pulumi.get(self, "remote_function_options")

    @remote_function_options.setter
    def remote_function_options(self, value: Optional[pulumi.Input['RemoteFunctionOptionsArgs']]):
        pulumi.set(self, "remote_function_options", value)

    @property
    @pulumi.getter(name="returnTableType")
    def return_table_type(self) -> Optional[pulumi.Input['StandardSqlTableTypeArgs']]:
        """
        Optional. Can be set only if routine_type = "TABLE_VALUED_FUNCTION". If absent, the return table type is inferred from definition_body at query time in each query that references this routine. If present, then the columns in the evaluated table result will be cast to match the column types specificed in return table type, at query time.
        """
        return pulumi.get(self, "return_table_type")

    @return_table_type.setter
    def return_table_type(self, value: Optional[pulumi.Input['StandardSqlTableTypeArgs']]):
        pulumi.set(self, "return_table_type", value)

    @property
    @pulumi.getter(name="returnType")
    def return_type(self) -> Optional[pulumi.Input['StandardSqlDataTypeArgs']]:
        """
        Optional if language = "SQL"; required otherwise. Cannot be set if routine_type = "TABLE_VALUED_FUNCTION". If absent, the return type is inferred from definition_body at query time in each query that references this routine. If present, then the evaluated result will be cast to the specified returned type at query time. For example, for the functions created with the following statements: * `CREATE FUNCTION Add(x FLOAT64, y FLOAT64) RETURNS FLOAT64 AS (x + y);` * `CREATE FUNCTION Increment(x FLOAT64) AS (Add(x, 1));` * `CREATE FUNCTION Decrement(x FLOAT64) RETURNS FLOAT64 AS (Add(x, -1));` The return_type is `{type_kind: "FLOAT64"}` for `Add` and `Decrement`, and is absent for `Increment` (inferred as FLOAT64 at query time). Suppose the function `Add` is replaced by `CREATE OR REPLACE FUNCTION Add(x INT64, y INT64) AS (x + y);` Then the inferred return type of `Increment` is automatically changed to INT64 at query time, while the return type of `Decrement` remains FLOAT64.
        """
        return pulumi.get(self, "return_type")

    @return_type.setter
    def return_type(self, value: Optional[pulumi.Input['StandardSqlDataTypeArgs']]):
        pulumi.set(self, "return_type", value)

    @property
    @pulumi.getter(name="sparkOptions")
    def spark_options(self) -> Optional[pulumi.Input['SparkOptionsArgs']]:
        """
        Optional. Spark specific options.
        """
        return pulumi.get(self, "spark_options")

    @spark_options.setter
    def spark_options(self, value: Optional[pulumi.Input['SparkOptionsArgs']]):
        pulumi.set(self, "spark_options", value)

    @property
    @pulumi.getter(name="strictMode")
    def strict_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Can be set for procedures only. If true (default), the definition body will be validated in the creation and the updates of the procedure. For procedures with an argument of ANY TYPE, the definition body validtion is not supported at creation/update time, and thus this field must be set to false explicitly.
        """
        return pulumi.get(self, "strict_mode")

    @strict_mode.setter
    def strict_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "strict_mode", value)


class Routine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ArgumentArgs']]]]] = None,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 definition_body: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 determinism_level: Optional[pulumi.Input['RoutineDeterminismLevel']] = None,
                 imported_libraries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 language: Optional[pulumi.Input['RoutineLanguage']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 remote_function_options: Optional[pulumi.Input[pulumi.InputType['RemoteFunctionOptionsArgs']]] = None,
                 return_table_type: Optional[pulumi.Input[pulumi.InputType['StandardSqlTableTypeArgs']]] = None,
                 return_type: Optional[pulumi.Input[pulumi.InputType['StandardSqlDataTypeArgs']]] = None,
                 routine_reference: Optional[pulumi.Input[pulumi.InputType['RoutineReferenceArgs']]] = None,
                 routine_type: Optional[pulumi.Input['RoutineRoutineType']] = None,
                 spark_options: Optional[pulumi.Input[pulumi.InputType['SparkOptionsArgs']]] = None,
                 strict_mode: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        """
        Creates a new routine in the dataset.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ArgumentArgs']]]] arguments: Optional.
        :param pulumi.Input[str] definition_body: The body of the routine. For functions, this is the expression in the AS clause. If language=SQL, it is the substring inside (but excluding) the parentheses. For example, for the function created with the following statement: `CREATE FUNCTION JoinLines(x string, y string) as (concat(x, "\\n", y))` The definition_body is `concat(x, "\\n", y)` (\\n is not replaced with linebreak). If language=JAVASCRIPT, it is the evaluated string in the AS clause. For example, for the function created with the following statement: `CREATE FUNCTION f() RETURNS STRING LANGUAGE js AS 'return "\\n";\\n'` The definition_body is `return "\\n";\\n` Note that both \\n are replaced with linebreaks.
        :param pulumi.Input[str] description: Optional. The description of the routine, if defined.
        :param pulumi.Input['RoutineDeterminismLevel'] determinism_level: Optional. The determinism level of the JavaScript UDF, if defined.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] imported_libraries: Optional. If language = "JAVASCRIPT", this field stores the path of the imported JAVASCRIPT libraries.
        :param pulumi.Input['RoutineLanguage'] language: Optional. Defaults to "SQL".
        :param pulumi.Input[pulumi.InputType['RemoteFunctionOptionsArgs']] remote_function_options: Optional. Remote function specific options.
        :param pulumi.Input[pulumi.InputType['StandardSqlTableTypeArgs']] return_table_type: Optional. Can be set only if routine_type = "TABLE_VALUED_FUNCTION". If absent, the return table type is inferred from definition_body at query time in each query that references this routine. If present, then the columns in the evaluated table result will be cast to match the column types specificed in return table type, at query time.
        :param pulumi.Input[pulumi.InputType['StandardSqlDataTypeArgs']] return_type: Optional if language = "SQL"; required otherwise. Cannot be set if routine_type = "TABLE_VALUED_FUNCTION". If absent, the return type is inferred from definition_body at query time in each query that references this routine. If present, then the evaluated result will be cast to the specified returned type at query time. For example, for the functions created with the following statements: * `CREATE FUNCTION Add(x FLOAT64, y FLOAT64) RETURNS FLOAT64 AS (x + y);` * `CREATE FUNCTION Increment(x FLOAT64) AS (Add(x, 1));` * `CREATE FUNCTION Decrement(x FLOAT64) RETURNS FLOAT64 AS (Add(x, -1));` The return_type is `{type_kind: "FLOAT64"}` for `Add` and `Decrement`, and is absent for `Increment` (inferred as FLOAT64 at query time). Suppose the function `Add` is replaced by `CREATE OR REPLACE FUNCTION Add(x INT64, y INT64) AS (x + y);` Then the inferred return type of `Increment` is automatically changed to INT64 at query time, while the return type of `Decrement` remains FLOAT64.
        :param pulumi.Input[pulumi.InputType['RoutineReferenceArgs']] routine_reference: Reference describing the ID of this routine.
        :param pulumi.Input['RoutineRoutineType'] routine_type: The type of routine.
        :param pulumi.Input[pulumi.InputType['SparkOptionsArgs']] spark_options: Optional. Spark specific options.
        :param pulumi.Input[bool] strict_mode: Optional. Can be set for procedures only. If true (default), the definition body will be validated in the creation and the updates of the procedure. For procedures with an argument of ANY TYPE, the definition body validtion is not supported at creation/update time, and thus this field must be set to false explicitly.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RoutineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a new routine in the dataset.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param RoutineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RoutineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ArgumentArgs']]]]] = None,
                 dataset_id: Optional[pulumi.Input[str]] = None,
                 definition_body: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 determinism_level: Optional[pulumi.Input['RoutineDeterminismLevel']] = None,
                 imported_libraries: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 language: Optional[pulumi.Input['RoutineLanguage']] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 remote_function_options: Optional[pulumi.Input[pulumi.InputType['RemoteFunctionOptionsArgs']]] = None,
                 return_table_type: Optional[pulumi.Input[pulumi.InputType['StandardSqlTableTypeArgs']]] = None,
                 return_type: Optional[pulumi.Input[pulumi.InputType['StandardSqlDataTypeArgs']]] = None,
                 routine_reference: Optional[pulumi.Input[pulumi.InputType['RoutineReferenceArgs']]] = None,
                 routine_type: Optional[pulumi.Input['RoutineRoutineType']] = None,
                 spark_options: Optional[pulumi.Input[pulumi.InputType['SparkOptionsArgs']]] = None,
                 strict_mode: Optional[pulumi.Input[bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RoutineArgs.__new__(RoutineArgs)

            __props__.__dict__["arguments"] = arguments
            if dataset_id is None and not opts.urn:
                raise TypeError("Missing required property 'dataset_id'")
            __props__.__dict__["dataset_id"] = dataset_id
            if definition_body is None and not opts.urn:
                raise TypeError("Missing required property 'definition_body'")
            __props__.__dict__["definition_body"] = definition_body
            __props__.__dict__["description"] = description
            __props__.__dict__["determinism_level"] = determinism_level
            __props__.__dict__["imported_libraries"] = imported_libraries
            __props__.__dict__["language"] = language
            __props__.__dict__["project"] = project
            __props__.__dict__["remote_function_options"] = remote_function_options
            __props__.__dict__["return_table_type"] = return_table_type
            __props__.__dict__["return_type"] = return_type
            if routine_reference is None and not opts.urn:
                raise TypeError("Missing required property 'routine_reference'")
            __props__.__dict__["routine_reference"] = routine_reference
            if routine_type is None and not opts.urn:
                raise TypeError("Missing required property 'routine_type'")
            __props__.__dict__["routine_type"] = routine_type
            __props__.__dict__["spark_options"] = spark_options
            __props__.__dict__["strict_mode"] = strict_mode
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["last_modified_time"] = None
        replace_on_changes = pulumi.ResourceOptions(replace_on_changes=["dataset_id", "project"])
        opts = pulumi.ResourceOptions.merge(opts, replace_on_changes)
        super(Routine, __self__).__init__(
            'google-native:bigquery/v2:Routine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Routine':
        """
        Get an existing Routine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = RoutineArgs.__new__(RoutineArgs)

        __props__.__dict__["arguments"] = None
        __props__.__dict__["creation_time"] = None
        __props__.__dict__["dataset_id"] = None
        __props__.__dict__["definition_body"] = None
        __props__.__dict__["description"] = None
        __props__.__dict__["determinism_level"] = None
        __props__.__dict__["etag"] = None
        __props__.__dict__["imported_libraries"] = None
        __props__.__dict__["language"] = None
        __props__.__dict__["last_modified_time"] = None
        __props__.__dict__["project"] = None
        __props__.__dict__["remote_function_options"] = None
        __props__.__dict__["return_table_type"] = None
        __props__.__dict__["return_type"] = None
        __props__.__dict__["routine_reference"] = None
        __props__.__dict__["routine_type"] = None
        __props__.__dict__["spark_options"] = None
        __props__.__dict__["strict_mode"] = None
        return Routine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arguments(self) -> pulumi.Output[Sequence['outputs.ArgumentResponse']]:
        """
        Optional.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The time when this routine was created, in milliseconds since the epoch.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="datasetId")
    def dataset_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "dataset_id")

    @property
    @pulumi.getter(name="definitionBody")
    def definition_body(self) -> pulumi.Output[str]:
        """
        The body of the routine. For functions, this is the expression in the AS clause. If language=SQL, it is the substring inside (but excluding) the parentheses. For example, for the function created with the following statement: `CREATE FUNCTION JoinLines(x string, y string) as (concat(x, "\\n", y))` The definition_body is `concat(x, "\\n", y)` (\\n is not replaced with linebreak). If language=JAVASCRIPT, it is the evaluated string in the AS clause. For example, for the function created with the following statement: `CREATE FUNCTION f() RETURNS STRING LANGUAGE js AS 'return "\\n";\\n'` The definition_body is `return "\\n";\\n` Note that both \\n are replaced with linebreaks.
        """
        return pulumi.get(self, "definition_body")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Optional. The description of the routine, if defined.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="determinismLevel")
    def determinism_level(self) -> pulumi.Output[str]:
        """
        Optional. The determinism level of the JavaScript UDF, if defined.
        """
        return pulumi.get(self, "determinism_level")

    @property
    @pulumi.getter
    def etag(self) -> pulumi.Output[str]:
        """
        A hash of this resource.
        """
        return pulumi.get(self, "etag")

    @property
    @pulumi.getter(name="importedLibraries")
    def imported_libraries(self) -> pulumi.Output[Sequence[str]]:
        """
        Optional. If language = "JAVASCRIPT", this field stores the path of the imported JAVASCRIPT libraries.
        """
        return pulumi.get(self, "imported_libraries")

    @property
    @pulumi.getter
    def language(self) -> pulumi.Output[str]:
        """
        Optional. Defaults to "SQL".
        """
        return pulumi.get(self, "language")

    @property
    @pulumi.getter(name="lastModifiedTime")
    def last_modified_time(self) -> pulumi.Output[str]:
        """
        The time when this routine was last modified, in milliseconds since the epoch.
        """
        return pulumi.get(self, "last_modified_time")

    @property
    @pulumi.getter
    def project(self) -> pulumi.Output[str]:
        return pulumi.get(self, "project")

    @property
    @pulumi.getter(name="remoteFunctionOptions")
    def remote_function_options(self) -> pulumi.Output['outputs.RemoteFunctionOptionsResponse']:
        """
        Optional. Remote function specific options.
        """
        return pulumi.get(self, "remote_function_options")

    @property
    @pulumi.getter(name="returnTableType")
    def return_table_type(self) -> pulumi.Output['outputs.StandardSqlTableTypeResponse']:
        """
        Optional. Can be set only if routine_type = "TABLE_VALUED_FUNCTION". If absent, the return table type is inferred from definition_body at query time in each query that references this routine. If present, then the columns in the evaluated table result will be cast to match the column types specificed in return table type, at query time.
        """
        return pulumi.get(self, "return_table_type")

    @property
    @pulumi.getter(name="returnType")
    def return_type(self) -> pulumi.Output['outputs.StandardSqlDataTypeResponse']:
        """
        Optional if language = "SQL"; required otherwise. Cannot be set if routine_type = "TABLE_VALUED_FUNCTION". If absent, the return type is inferred from definition_body at query time in each query that references this routine. If present, then the evaluated result will be cast to the specified returned type at query time. For example, for the functions created with the following statements: * `CREATE FUNCTION Add(x FLOAT64, y FLOAT64) RETURNS FLOAT64 AS (x + y);` * `CREATE FUNCTION Increment(x FLOAT64) AS (Add(x, 1));` * `CREATE FUNCTION Decrement(x FLOAT64) RETURNS FLOAT64 AS (Add(x, -1));` The return_type is `{type_kind: "FLOAT64"}` for `Add` and `Decrement`, and is absent for `Increment` (inferred as FLOAT64 at query time). Suppose the function `Add` is replaced by `CREATE OR REPLACE FUNCTION Add(x INT64, y INT64) AS (x + y);` Then the inferred return type of `Increment` is automatically changed to INT64 at query time, while the return type of `Decrement` remains FLOAT64.
        """
        return pulumi.get(self, "return_type")

    @property
    @pulumi.getter(name="routineReference")
    def routine_reference(self) -> pulumi.Output['outputs.RoutineReferenceResponse']:
        """
        Reference describing the ID of this routine.
        """
        return pulumi.get(self, "routine_reference")

    @property
    @pulumi.getter(name="routineType")
    def routine_type(self) -> pulumi.Output[str]:
        """
        The type of routine.
        """
        return pulumi.get(self, "routine_type")

    @property
    @pulumi.getter(name="sparkOptions")
    def spark_options(self) -> pulumi.Output['outputs.SparkOptionsResponse']:
        """
        Optional. Spark specific options.
        """
        return pulumi.get(self, "spark_options")

    @property
    @pulumi.getter(name="strictMode")
    def strict_mode(self) -> pulumi.Output[bool]:
        """
        Optional. Can be set for procedures only. If true (default), the definition body will be validated in the creation and the updates of the procedure. For procedures with an argument of ANY TYPE, the definition body validtion is not supported at creation/update time, and thus this field must be set to false explicitly.
        """
        return pulumi.get(self, "strict_mode")

